## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(sparta)

## -----------------------------------------------------------------------------
dn <- function(x) setNames(lapply(x, paste0, 1:2), toupper(x))
d  <- c(2, 2, 2)
f  <- array(c(5, 4, 0, 7, 0, 9, 0, 0), d, dn(c("x", "y", "z")))
g  <- array(c(7, 6, 0, 6, 0, 0, 9, 0), d, dn(c("y", "z", "w")))

## -----------------------------------------------------------------------------
ftable(f, row.vars = "X")
ftable(g, row.vars = "W")

## -----------------------------------------------------------------------------
sf <- as_sparta(f); sg <- as_sparta(g)

## -----------------------------------------------------------------------------
print.default(sf)

## -----------------------------------------------------------------------------
print(sf)

## -----------------------------------------------------------------------------
mfg <- mult(sf, sg); mfg

## -----------------------------------------------------------------------------
sf_cpt <- as_cpt(sf, y = "Z"); sf_cpt

## -----------------------------------------------------------------------------
slice(sf, s = c(X = "x1"), drop = TRUE)

## -----------------------------------------------------------------------------
marg(sg, y = c("Y"))

