/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import org.rosuda.ibase.MapSegment;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.BaseCanvas;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.ibase.toolkit.MapSegmentTools;
import org.rosuda.ibase.toolkit.PPrimPolygon;
import org.rosuda.ibase.toolkit.PlotPrimitive;
import org.rosuda.util.Global;

public class MapCanvas
extends BaseCanvas {
    SVar v;
    boolean fixedAspectRatio = true;
    double minX;
    double minY;
    double maxX;
    double maxY;

    public MapCanvas(int n, Frame frame, SVar sVar, SMarker sMarker) {
        super(n, frame, sMarker);
        this.setTitle("Polygon Map (" + sVar.getName() + ")");
        this.v = sVar;
        this.allow180 = true;
        this.ax = new Axis(null, 0, 0);
        this.ax.addDepend(this);
        this.ay = new Axis(null, 1, 0);
        this.ay.addDepend(this);
        String[] stringArray = new String[]{"+", "File", "~File.Graph", "~Edit", "+", "View", "@RRotate", "rotate", "@BToggle border lines", "bounds", "~Window", "0"};
        EzMenu.getEzMenu(frame, this, stringArray);
        this.setDefaultMargins(new int[]{10, 10, 10, 10});
        this.pp = null;
        this.dontPaint = false;
    }

    public void updateObjects() {
        int n;
        int n2;
        int n3;
        Dimension dimension = this.getSize();
        int n4 = dimension.width;
        int n5 = dimension.height;
        if (Global.DEBUG > 0) {
            System.out.println("MapCanvas.updateObjects(): (" + n4 + "," + n5 + ")/(" + this.W + "," + this.H + ") pp=" + this.pp);
        }
        n4 = this.W - this.mLeft * 2;
        n5 = this.H - this.mLeft * 2;
        boolean bl = true;
        if (this.pp == null) {
            n3 = 0;
            for (n2 = 0; n2 < this.v.size(); ++n2) {
                MapSegment mapSegment = (MapSegment)this.v.at(n2);
                if (mapSegment == null) continue;
                n3 += mapSegment.count();
                if (bl) {
                    this.minX = mapSegment.minX;
                    this.minY = mapSegment.minY;
                    this.maxX = mapSegment.maxX;
                    this.maxY = mapSegment.maxY;
                    bl = false;
                    continue;
                }
                if (mapSegment.minX < this.minX) {
                    this.minX = mapSegment.minX;
                }
                if (mapSegment.minY < this.minY) {
                    this.minY = mapSegment.minY;
                }
                if (mapSegment.maxX > this.maxX) {
                    this.maxX = mapSegment.maxX;
                }
                if (!(mapSegment.maxY > this.maxY)) continue;
                this.maxY = mapSegment.maxY;
            }
            this.pp = new PlotPrimitive[n3];
            n = this.ignoreNotifications;
            this.ignoreNotifications = true;
            this.ax.setValueRange(this.minX, this.maxX - this.minX);
            this.ay.setValueRange(this.minY, this.maxY - this.minY);
            this.ignoreNotifications = n;
        }
        int n6 = n3 = !this.fixedAspectRatio ? 1 : 0;
        while (n3 == 0) {
            double d = (double)this.ax.gLen / this.ax.vLen;
            double d2 = (double)this.ay.gLen / this.ay.vLen;
            if (d < 0.0) {
                d = -d;
            }
            if (d2 < 0.0) {
                d2 = -d2;
            }
            double d3 = d < d2 ? d2 / d : d / d2;
            Axis axis = d < d2 ? this.ay : this.ax;
            double d4 = axis.vBegin + axis.vLen / 2.0;
            double d5 = axis.vLen * d3;
            axis.setValueRange(d4 - d5 / 2.0, d5);
            if (this.ax.vLen > (this.maxX - this.minX) * 1.01 && this.ay.vLen > (this.maxY - this.minY) * 1.01) {
                this.ax.setValueRange(this.minX, this.maxX - this.minX);
                this.ay.setValueRange(this.minY, this.maxY - this.minY);
                continue;
            }
            n3 = 1;
        }
        if (Global.DEBUG > 0) {
            System.out.println(" X:[" + this.ax + "][" + this.minX + ".." + this.maxX + "] Y:[" + this.ay + "][" + this.minY + ".." + this.maxY + "]");
        }
        n = 0;
        for (n2 = 0; n2 < this.v.size() && n < this.pp.length; ++n2) {
            MapSegment mapSegment = (MapSegment)this.v.at(n2);
            if (mapSegment == null) continue;
            int n7 = 0;
            while (n7 < mapSegment.count()) {
                PPrimPolygon pPrimPolygon = new PPrimPolygon();
                pPrimPolygon.ref = new int[1];
                pPrimPolygon.ref[0] = n2;
                pPrimPolygon.drawBorder = this.paintOutline;
                pPrimPolygon.pg = this.orientation == 0 || this.orientation == 2 ? new Polygon(MapSegmentTools.transViaAxisX(mapSegment, n7, this.ax), MapSegmentTools.transViaAxisY(mapSegment, n7, this.ay), mapSegment.getSizeAt(n7)) : new Polygon(MapSegmentTools.transViaAxisY(mapSegment, n7, this.ay), MapSegmentTools.transViaAxisX(mapSegment, n7, this.ax), mapSegment.getSizeAt(n7));
                this.pp[n] = pPrimPolygon;
                ++n7;
                ++n;
            }
        }
        this.setUpdateRoot(0);
    }

    public String queryObject(int n) {
        return "Map segment";
    }

    public void keyTyped(KeyEvent keyEvent) {
        super.keyTyped(keyEvent);
        if (keyEvent.getKeyChar() == 'b') {
            this.run(this, "bounds");
        }
    }

    public Object run(Object object, String string) {
        super.run(object, string);
        if (string == "bounds") {
            this.setUpdateRoot(0);
            this.paintOutline = !this.paintOutline;
            this.updateObjects();
            this.repaint();
        }
        return null;
    }

    public SVar getData(int n) {
        return n == 0 ? this.v : null;
    }
}

