/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.Timer;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.SparseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class SparseDoubleAlgebraBenchmark {
    private static final Timer t = new Timer();
    private static int niters = 10;
    private static int[] nthreads;

    public static void main(String[] stringArray) {
        SparseDoubleAlgebraBenchmark.benchmarkLU();
    }

    public static void benchmarkLU(String string) {
        SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D = null;
        File file = new File(string);
        try {
            sparseCCDoubleMatrix2D = new SparseDoubleMatrix2D(new MatrixVectorReader(new FileReader(file))).getColumnCompressed(false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Benchmark of sparse LU. Matrix: (" + file.getName() + ")");
        SparseDoubleAlgebra sparseDoubleAlgebra = SparseDoubleAlgebra.DEFAULT;
        for (int i = 0; i < nthreads.length; ++i) {
            ConcurrencyUtils.setNumberOfThreads(nthreads[i]);
            System.out.println("\tNumber of threads = " + nthreads[i]);
            SparseDoubleLUDecomposition sparseDoubleLUDecomposition = sparseDoubleAlgebra.lu(sparseCCDoubleMatrix2D, 0);
            t.reset().start();
            for (int j = 0; j < niters; ++j) {
                sparseDoubleLUDecomposition = sparseDoubleAlgebra.lu(sparseCCDoubleMatrix2D, 0);
            }
            t.stop();
            System.out.println("\t\tAverage execution time of LU = " + t.seconds() / (double)niters + " seconds");
        }
    }

    public static void benchmarkLU() {
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.sparse.random(1000, 1000);
        doubleMatrix2D = ((SparseDoubleMatrix2D)doubleMatrix2D).getColumnCompressed(false);
        System.out.println("Benchmark of sparse LU.");
        SparseDoubleAlgebra sparseDoubleAlgebra = SparseDoubleAlgebra.DEFAULT;
        ConcurrencyUtils.setNumberOfThreads(1);
        SparseDoubleLUDecomposition sparseDoubleLUDecomposition = sparseDoubleAlgebra.lu(doubleMatrix2D, 0);
        t.reset().start();
        for (int i = 0; i < niters; ++i) {
            sparseDoubleLUDecomposition = sparseDoubleAlgebra.lu(doubleMatrix2D, 0);
        }
        t.stop();
        System.out.println("\t\tAverage execution time of LU = " + t.seconds() / (double)niters + " seconds");
    }
}

