# PhenotypeSimulator 0.3.4
## Minor changes
1. Fixed missing --genotypefile flag [issue 27](https://github.com/HannahVMeyer/PhenotypeSimulator/issues/27)
2. Update vignettes with new location for impute files and commands to get the
CEU samples [issue 24](https://github.com/HannahVMeyer/PhenotypeSimulator/issues/24),
thanks to @zfuller5280 for the suggestion!)
3. Standardise genotypes on row with major alleles [issue 21](https://github.com/HannahVMeyer/PhenotypeSimulator/issues/21).
Thank you for the detailed bug report by @alanw1!
4. Add option to imput missing genotypes to standardise genotype function;
otherwise, if genotypes are missing, function will fail
[issue 17](https://github.com/HannahVMeyer/PhenotypeSimulator/issues/17)
5. Fix function description and passing of SNP IDs in readStandardGenotypes with
delim option [issue 25](https://github.com/HannahVMeyer/PhenotypeSimulator/issues/25),
thanks @BSchmidt1.

# PhenotypeSimulator 0.3.3
## Minor changes
1. Fixed bug that failed to return causal SNP name when only one SNP was chosen
   to be causal [issue
   13](https://github.com/HannahVMeyer/PhenotypeSimulator/issues/13).

# PhenotypeSimulator 0.3.2
## Minor changes
1. Option for external, delimited genotype file to contain a header;
   additional checks to make sure the right data is received when
   sampling from the genotypes file [issue 10](https://github.com/HannahVMeyer/PhenotypeSimulator/issues/10)
1. Fixed bug for reading external genotypes file [issue
   9](https://github.com/HannahVMeyer/PhenotypeSimulator/issues/9)

# PhenotypeSimulator 0.3.1
## Minor changes
1. Adapted output file names for genotypes consistent with other
   filenames from genotypes.txt to Genotypes.txt

# PhenotypeSimulator 0.3.0
## Major changes
1. Add option for non-linear transformation of simulated phenotypes: function (transformNonlinear)[https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/createphenotypeFunctions.R], accessible from [runSimulation](https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/createphenotypeFunctions.R). Both transformed and original phenotypes are automatically returned with [savePheno](https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/outputFunctions.R)
1. Replace parameter 'oxgen' in [readStandardGenotypes](https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/genotypeFunctions.R) and [getCausalSNPs](https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/genotypeFunctions.R) with 'format' - ensures proper 
    specification of genotype format for all cases.
## Minor changes
1. In addition to full kinship, [savePheno](https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/outputFunctions.R) and  [writeStandardOutput](https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/outputFunctions.R) write eigenvalues and eigenvalues of  kinship matrix.
1. Output file names have been made more consistent in [savePheno](https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/outputFunctions.R) and  [writeStandardOutput](https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/outputFunctions.R).
1. Causal SNPs are now also saved in specified standard output format.
1. LiMMBo has been added as output format in [savePheno](https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/outputFunctions.R) and  [writeStandardOutput](https://github.com/HannahVMeyer/PhenotypeSimulator/blob/master/R/outputFunctions.R)([LiMMBo format](https://limmbo.readthedocs.io/en/latest/))

# PhenotypeSimulator 0.2.2
## Minor changes
1. Update readStandardGenotypes to be compatible with latest
   release of data.table (v1.11.2), see
   [here](https://github.com/HannahVMeyer/PhenotypeSimulator/issues/7)

# PhenotypeSimulator 0.2.1
## Minor changes
1. Additional tests for compatibility of input parameters with variance
   components functions, genotype functions and output functions.
1. Bug fix in output function: savePheno now properly saves kinship matrix as
   .rds.

# PhenotypeSimulator 0.2.0
## Major changes
**Input**
1. *PhenotypeSimulator* now includes readStandardGenotypes which can read externally simulated or user-provided genotypes in plink, genome, oxgen (hapgen/impute2), bimbam or simple delimited format.
1. A user-specified correlation matrix can be provided for the simulation of the correlatedBdEffects.
1. Short option flags for command-line use of *PhenotypeSimulator* were removed.

**Output**
1. *PhenotypeSimulator* provides the option to save the simulated phenotypes and genotypes in formats compatible with a number of commonly used genetic association software (gemma, bimbam, plink, snptest) via writeStandardOutput.
1. Intermediate phenotype components are now saved per default.
1. Saving additional subsets of the simulated data has been removed.

**Variance components**
1. Genotype simulation and kinship estimation: functions for genotype simulation and kinship estimation have been rewritten for
    significant speed-ups of the computation time [benchmarking](https://github.com/HannahVMeyer/PhenotypeSimulator-profiling).
    
1. geneticFixedEffects and noiseFixedEffects:
    1. The effect size distributions of the shared effects are now modelled as the product of two exponential distributions
        (to yield an approximately uniform distributions) or the product of a normal distribution with user-specified
        parameters and a standard normal distribution.
        
    1. The independent effects can now be specified to affect the same subset or different subsets of traits (via 
        keepSameIndependent).
        
    1. The overall number of traits affected by the effects can now be specified via pTraitsAffected.
    

1. correlatedBgEffects: the additional correlation between the traits can be specified by the user by providing an external
    correlation matrix. 
