/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.functions.MathFunctionWithDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithIntegral;

public class AverageMathFunction
implements MathFunction,
MathFunctionWithFirstDerivative,
MathFunctionWithDerivative,
MathFunctionWithIntegral {
    private MathFunction[] func;

    public AverageMathFunction(MathFunction ... mathFunctionArray) {
        if (mathFunctionArray == null) {
            throw new NullPointerException();
        }
        this.func = (MathFunction[])mathFunctionArray.clone();
    }

    public MathFunction[] getFunctions() {
        return (MathFunction[])this.func.clone();
    }

    public double evaluate(double d) {
        double d2 = 0.0;
        for (MathFunction mathFunction : this.func) {
            d2 += mathFunction.evaluate(d);
        }
        return d2 / (double)this.func.length;
    }

    public double derivative(double d, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be greater than or equal to 0");
        }
        if (n == 0) {
            return this.evaluate(d);
        }
        double d2 = 0.0;
        for (MathFunction mathFunction : this.func) {
            d2 += MathFunctionUtil.derivative(mathFunction, d, n);
        }
        return d2 / (double)this.func.length;
    }

    public double derivative(double d) {
        double d2 = 0.0;
        for (MathFunction mathFunction : this.func) {
            d2 += MathFunctionUtil.derivative(mathFunction, d);
        }
        return d2 / (double)this.func.length;
    }

    public double integral(double d, double d2) {
        double d3 = 0.0;
        for (MathFunction mathFunction : this.func) {
            d3 += MathFunctionUtil.integral(mathFunction, d, d2);
        }
        return d3 / (double)this.func.length;
    }
}

