/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.ANR;

import java.util.Arrays;
import java.util.Vector;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.FUN;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.LinearSearchBrent;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.OPV;
import org.core.Randomize;

public class ConjGradNN {
    static Randomize r;
    int nLayers;
    int nInputs;
    int nOutputs;
    int[] nElements;
    double[][][] weights;
    double[][] input;
    double[] output;
    double[][] delta;
    double[][][] gradf;
    double[] factor;
    double[] max_x;
    double[] min_x;
    double[] max_y;
    double[] min_y;
    double[][] Input;
    double[][] Output;
    private double[][] inputU;
    private double[][] outputV;
    private double[][] classProbability;
    private int[] originalClass;
    private int[] finalClass;
    private double best_SSE_adj = Double.MAX_VALUE;
    private double[] initialClassDistribution;
    private double[] currentClassDistribution;

    public ConjGradNN(int[] vNelement, double[][] vInput, double[][] vOutput, Randomize pr) {
        int j;
        int i;
        r = pr;
        this.Input = this.duplicate(vInput);
        this.Output = this.duplicate(vOutput);
        this.nInputs = vInput[0].length;
        this.nOutputs = vOutput[0].length;
        this.nElements = vNelement;
        for (int ne = 0; ne < this.nElements.length; ++ne) {
            System.out.println("conche = " + this.nElements[ne]);
        }
        this.nLayers = this.nElements.length;
        this.weights = new double[this.nLayers + 1][][];
        this.gradf = new double[this.nLayers + 1][][];
        this.input = new double[this.nLayers + 1][];
        this.output = new double[this.nOutputs];
        this.delta = new double[this.nLayers + 1][];
        for (i = 0; i < this.nLayers; ++i) {
            this.weights[i] = new double[this.nElements[i]][];
            this.gradf[i] = new double[this.nElements[i]][];
            int nInputsAux = i == 0 ? this.nInputs : this.weights[i - 1].length;
            this.input[i] = new double[nInputsAux + 1];
            this.delta[i] = new double[this.nElements[i]];
            for (j = 0; j < this.weights[i].length; ++j) {
                this.weights[i][j] = new double[nInputsAux + 1];
                this.gradf[i][j] = new double[nInputsAux + 1];
            }
        }
        this.weights[i] = new double[this.nOutputs][];
        this.gradf[i] = new double[this.nOutputs][];
        if (this.nLayers == 0) {
            for (j = 0; j < this.weights[i].length; ++j) {
                this.weights[i][j] = new double[this.nInputs + 1];
                this.gradf[i][j] = new double[this.nInputs + 1];
            }
            this.input[i] = new double[this.nInputs + 1];
        } else {
            for (j = 0; j < this.weights[i].length; ++j) {
                this.weights[i][j] = new double[this.weights[i - 1].length + 1];
                this.gradf[i][j] = new double[this.weights[i - 1].length + 1];
            }
            this.input[i] = new double[this.weights[i - 1].length + 1];
        }
        this.delta[i] = new double[this.nOutputs];
        this.factor = new double[this.nOutputs];
        this.max_x = new double[this.nInputs];
        this.min_x = new double[this.nInputs];
        this.max_y = new double[this.nOutputs];
        this.min_y = new double[this.nOutputs];
        for (i = 0; i < this.factor.length; ++i) {
            this.factor[i] = 1.0;
        }
        for (i = 0; i < this.nInputs; ++i) {
            this.max_x[i] = 1.0;
            this.min_x[i] = 0.0;
        }
        for (i = 0; i < this.nOutputs; ++i) {
            this.max_y[i] = 1.0;
            this.min_y[i] = 0.0;
        }
        this.scale();
        this.inputU = new double[this.Input.length][this.nOutputs];
        this.outputV = new double[this.Input.length][this.nOutputs];
        this.classProbability = new double[this.Input.length][this.nOutputs];
        this.originalClass = new int[this.Input.length];
        this.finalClass = new int[this.Input.length];
        this.initialClassDistribution = new double[this.nOutputs];
        Arrays.fill(this.initialClassDistribution, 0.0);
        this.currentClassDistribution = new double[this.nOutputs];
        Arrays.fill(this.currentClassDistribution, 0.0);
        for (int nc = 0; nc < this.nOutputs; ++nc) {
            System.out.println(this.Output[0][nc]);
        }
        double probRest = 0.05 / (double)(this.nOutputs - 1);
        double u0 = 0.02;
        for (int ni = 0; ni < this.Input.length; ++ni) {
            for (int nc = 0; nc < this.nOutputs; ++nc) {
                if (this.Output[ni][nc] == 1.0) {
                    this.classProbability[ni][nc] = 0.95;
                    this.outputV[ni][nc] = 0.95;
                    this.originalClass[ni] = nc;
                    this.finalClass[ni] = nc;
                    int n = nc;
                    this.initialClassDistribution[n] = this.initialClassDistribution[n] + 1.0;
                    int n2 = nc;
                    this.currentClassDistribution[n2] = this.currentClassDistribution[n2] + 1.0;
                    this.inputU[ni][nc] = this.atanh(2.0 * this.outputV[ni][nc] - 1.0) * 0.02;
                    continue;
                }
                this.classProbability[ni][nc] = probRest;
                this.outputV[ni][nc] = probRest;
                this.inputU[ni][nc] = this.atanh(2.0 * this.outputV[ni][nc] - 1.0) * 0.02;
            }
        }
        int nc = 0;
        while (nc < this.nOutputs) {
            int n = nc++;
            this.initialClassDistribution[n] = this.initialClassDistribution[n] / (double)this.Input.length;
        }
    }

    private double[][][] numericalGradient(FUN f, double[][][] x) {
        int k;
        int j;
        int i;
        double h = 0.001f;
        double[][][] result = new double[x.length][x[0].length][x[0][0].length];
        double[][][] fplus = new double[x.length][x[0].length][x[0][0].length];
        double[][][] fminus = new double[x.length][x[0].length][x[0][0].length];
        double[][][] copyx = new double[x.length][x[0].length][x[0][0].length];
        for (i = 0; i < x.length; ++i) {
            for (j = 0; j < x[i].length; ++j) {
                for (k = 0; k < x[i][j].length; ++k) {
                    copyx[i][j][k] = x[i][j][k];
                }
            }
        }
        for (i = 0; i < x.length; ++i) {
            for (j = 0; j < x[i].length; ++j) {
                for (k = 0; k < x[i][j].length; ++k) {
                    double[] dArray = copyx[i][j];
                    int n = k;
                    dArray[n] = dArray[n] + h;
                    fplus[i][j][k] = f.evaluate(copyx);
                    double[] dArray2 = copyx[i][j];
                    int n2 = k;
                    dArray2[n2] = dArray2[n2] - 2.0 * h;
                    fminus[i][j][k] = f.evaluate(copyx);
                    copyx[i][j][k] = x[i][j][k];
                    result[i][j][k] = (fplus[i][j][k] - fminus[i][j][k]) / (2.0 * h);
                }
            }
        }
        return result;
    }

    private void copy(double[] org, int size, double[] dst) {
        for (int i = 0; i < size; ++i) {
            dst[i] = org[i];
        }
    }

    double[] duplicate(double[] x) {
        double[] r = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            r[i] = x[i];
        }
        return r;
    }

    double[][] duplicate(double[][] x) {
        double[][] r = new double[x.length][];
        for (int i = 0; i < x.length; ++i) {
            r[i] = new double[x[i].length];
            for (int j = 0; j < x[i].length; ++j) {
                r[i][j] = x[i][j];
            }
        }
        return r;
    }

    double[][][] duplicate(double[][][] x) {
        double[][][] r = new double[x.length][][];
        for (int i = 0; i < x.length; ++i) {
            r[i] = new double[x[i].length][];
            for (int j = 0; j < r[i].length; ++j) {
                r[i][j] = new double[x[i][j].length];
                for (int k = 0; k < r[i][j].length; ++k) {
                    r[i][j][k] = x[i][j][k];
                }
            }
        }
        return r;
    }

    private double hTan(double x) {
        if (x < -100.0) {
            return -1.0;
        }
        if (x > 100.0) {
            return 1.0;
        }
        return (Math.exp(x) - Math.exp(-x)) / (Math.exp(x) + Math.exp(-x));
    }

    private double hTanp(double x) {
        if (x < -100.0) {
            return 0.0;
        }
        if (x > 100.0) {
            return 0.0;
        }
        return 4.0 / Math.pow(Math.exp(x) + Math.exp(-x), 2.0);
    }

    private double[][][] gradient(FUN f, double[][][] x) {
        double[][][] GRADE = this.duplicate(this.gradf);
        boolean seguir = true;
        int contador = 0;
        while (seguir) {
            for (int k = 0; k < this.Input.length; ++k) {
                int nc;
                int j;
                int i;
                this.copy(this.Input[k], this.Input[k].length, this.input[0]);
                this.input[0][this.input[0].length - 1] = 1.0;
                for (i = 0; i < x.length - 1; ++i) {
                    for (j = 0; j < x[i].length; ++j) {
                        this.input[i + 1][j] = OPV.multiply(x[i][j], this.input[i]);
                        this.delta[i][j] = this.hTanp(this.input[i + 1][j]);
                    }
                    for (j = 0; j < this.input[i + 1].length - 1; ++j) {
                        this.input[i + 1][j] = this.hTan(this.input[i + 1][j]);
                    }
                    this.input[i + 1][this.input[i + 1].length - 1] = 1.0;
                }
                for (j = 0; j < this.output.length; ++j) {
                    this.output[j] = OPV.multiply(x[i][j], this.input[i]);
                }
                for (j = 0; j < this.delta[i].length; ++j) {
                    this.delta[i][j] = this.output[j] - this.Output[k][j];
                }
                for (i = x.length - 2; i >= 0; --i) {
                    j = 0;
                    while (j < this.delta[i].length) {
                        double suma = 0.0;
                        for (int l = 0; l < this.delta[i + 1].length; ++l) {
                            suma += this.delta[i + 1][l] * x[i + 1][l][j];
                        }
                        double[] dArray = this.delta[i];
                        int n = j++;
                        dArray[n] = dArray[n] * suma;
                    }
                }
                for (i = 0; i < this.gradf.length; ++i) {
                    for (j = 0; j < this.gradf[i].length; ++j) {
                        for (int m = 0; m < this.gradf[i][j].length; ++m) {
                            this.gradf[i][j][m] = 2.0 * this.delta[i][j] * this.input[i][m] / (double)this.Input.length;
                        }
                    }
                }
                GRADE = k == 0 ? this.duplicate(this.gradf) : OPV.sum(GRADE, this.gradf);
                double Lp = 5.0E-4;
                for (int nc2 = 0; nc2 < this.nOutputs; ++nc2) {
                    this.inputU[k][nc2] = this.inputU[k][nc2] + 5.0E-4 * (this.output[nc2] - this.classProbability[k][nc2]);
                }
                double u0 = 0.02;
                for (int nc3 = 0; nc3 < this.nOutputs; ++nc3) {
                    this.outputV[k][nc3] = 0.5 * (1.0 + Math.tanh(this.inputU[k][nc3] / 0.02));
                }
                int posMAX = 0;
                double valueMAX = this.outputV[k][0];
                for (nc = 1; nc < this.nOutputs; ++nc) {
                    this.classProbability[k][nc] = this.outputV[k][nc];
                    if (!(this.classProbability[k][nc] > valueMAX)) continue;
                    valueMAX = this.classProbability[k][nc];
                    posMAX = nc;
                }
                int n = this.finalClass[k];
                this.currentClassDistribution[n] = this.currentClassDistribution[n] - 1.0;
                int n2 = posMAX;
                this.currentClassDistribution[n2] = this.currentClassDistribution[n2] + 1.0;
                this.finalClass[k] = posMAX;
                for (nc = 0; nc < this.nOutputs; ++nc) {
                    this.Output[k][nc] = posMAX == nc ? 1.0 : 0.0;
                }
                if (k % 20 == 0) {
                    double sseadj = this.computeSSEadj();
                    if (sseadj < this.best_SSE_adj) {
                        this.best_SSE_adj = sseadj;
                        contador = 0;
                    } else {
                        ++contador;
                    }
                }
                if (contador != 10) continue;
                seguir = false;
            }
        }
        return GRADE;
    }

    public double getSSEadj() {
        return this.best_SSE_adj;
    }

    public double atanh(double x) {
        if (x > 1.0 || x < -1.0) {
            System.out.println("ERROR");
            System.exit(1);
        }
        return Math.log(Math.sqrt((1.0 + x) / (1.0 - x)));
    }

    public Vector getNoisyInstances() {
        Vector<Integer> res = new Vector<Integer>();
        for (int i = 0; i < this.Input.length; ++i) {
            if (this.originalClass[i] == this.finalClass[i]) continue;
            res.add(i);
        }
        return res;
    }

    public double computeSSEadj() {
        double SSE_std = 0.0;
        for (int i = 0; i < this.Input.length; ++i) {
            double[] error = OPV.subtract(this.nn(this.Input[i], this.weights), this.Output[i]);
            SSE_std += OPV.multiply(error, error);
        }
        double SSE_hn = 0.0;
        double A1 = 0.05;
        double A2 = 0.2;
        double I = this.nInputs;
        double H = this.nElements[0];
        double N = this.Input.length;
        double C = this.nOutputs;
        if (H <= I) {
            SSE_hn = 0.05 * (H - 1.0) * N * (C - 1.0) / C;
        } else if (H > I) {
            SSE_hn = (0.05 * (I - 1.0) + 0.2 * (H - I)) * N * (C - 1.0) / C;
        }
        double SSE_dist = 0.0;
        double primero = N * (C - 1.0) / C;
        double[] aux = new double[this.currentClassDistribution.length];
        System.arraycopy(this.currentClassDistribution, 0, aux, 0, this.currentClassDistribution.length);
        int nc = 0;
        while ((double)nc < C) {
            int n = nc++;
            aux[n] = aux[n] / N;
        }
        int i = 0;
        while ((double)i < C) {
            double Di = Math.abs(aux[i] - this.initialClassDistribution[i]);
            double Bi = 0.0;
            Bi = Di < 0.05 ? 0.1 : 1.0;
            SSE_dist += Di * Bi * this.max(aux[i], this.initialClassDistribution[i]);
            ++i;
        }
        return SSE_std + SSE_hn + (SSE_dist *= primero);
    }

    private double max(double a, double b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public void sample(double[][][] x) {
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                for (int k = 0; k < x[i][j].length; ++k) {
                    System.out.print(x[i][j][k] + " ");
                }
            }
        }
    }

    public double[] nn(double[] x, double[][][] W) {
        int j;
        int i;
        this.copy(x, x.length, this.input[0]);
        this.input[0][this.input[0].length - 1] = 1.0;
        for (i = 0; i < W.length - 1; ++i) {
            for (j = 0; j < W[i].length; ++j) {
                this.input[i + 1][j] = OPV.multiply(W[i][j], this.input[i]);
            }
            for (j = 0; j < this.input[i + 1].length - 1; ++j) {
                this.input[i + 1][j] = this.hTan(this.input[i + 1][j]);
            }
            this.input[i + 1][this.input[i + 1].length - 1] = 1.0;
        }
        for (j = 0; j < this.output.length; ++j) {
            this.output[j] = OPV.multiply(W[i][j], this.input[i]);
        }
        return this.output;
    }

    public double f(double[][][] x) {
        double RMS = 0.0;
        for (int i = 0; i < this.Input.length; ++i) {
            double[] error = OPV.subtract(this.nn(this.Input[i], x), this.Output[i]);
            RMS += OPV.multiply(error, error);
        }
        return RMS / (double)this.Input.length;
    }

    public double f_denormalized(double[][][] x, double[] FACTOR) {
        double RMS = 0.0;
        for (int i = 0; i < this.Input.length; ++i) {
            double[] error = OPV.subtract(this.nn(this.Input[i], x), this.Output[i]);
            for (int j = 0; j < error.length; ++j) {
                int n = j;
                error[n] = error[n] * FACTOR[j];
            }
            RMS += OPV.multiply(error, error);
        }
        return RMS / (double)this.Input.length;
    }

    private double rnd(double low, double high) {
        return r.Rand() * (high - low) + low;
    }

    public void scale() {
        int i;
        for (i = 0; i < this.Input.length; ++i) {
            if (i == 0) {
                this.max_x = this.duplicate(this.Input[i]);
                this.max_y = this.duplicate(this.Output[i]);
                this.min_x = this.duplicate(this.Input[i]);
                this.min_y = this.duplicate(this.Output[i]);
                continue;
            }
            this.max_x = OPV.maximum(this.max_x, this.Input[i]);
            this.max_y = OPV.maximum(this.max_y, this.Output[i]);
            this.min_x = OPV.minimum(this.min_x, this.Input[i]);
            this.min_y = OPV.minimum(this.min_y, this.Output[i]);
        }
        for (i = 0; i < this.Input.length; ++i) {
            this.Input[i] = OPV.scale(this.Input[i], this.max_x, this.min_x);
        }
        for (i = 0; i < this.Input.length; ++i) {
            this.Output[i] = OPV.scale(this.Output[i], this.max_y, this.min_y);
        }
        for (i = 0; i < this.factor.length; ++i) {
            this.factor[i] = this.max_y[i] - this.min_y[i];
        }
    }

    public double conjugatedGradient(FUN f, double TOL_ERR, double MIN_DELTAGC, int MAX_ITER) {
        double[][][] gr;
        int NVAR = 0;
        double last_err = 0.0;
        double err = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            NVAR += this.weights[i].length * this.weights[i][0].length;
        }
        int iter = 0;
        int subiter = 0;
        double alfa = 0.0;
        double[][][] x = this.weights;
        boolean restart = true;
        boolean debug = false;
        double[][][] g_old = this.gradient(f, x);
        double[][][] d = this.duplicate(g_old);
        do {
            if (debug) {
                System.out.println("Debug: X=" + this.AString(x));
                System.out.println("Debug: g_old=" + this.AString(g_old));
            }
            gr = this.gradient(f, x);
            if (restart) {
                d = OPV.signChange(gr);
                restart = false;
                subiter = 0;
            } else {
                double beta = OPV.multiply(OPV.subtract(gr, g_old), gr) / OPV.multiply(g_old, g_old);
                d = OPV.subtract(OPV.multiply(beta, d), gr);
            }
            double ngr = Math.sqrt(OPV.multiply(gr, gr));
            double dgr = Math.sqrt(OPV.multiply(d, d));
            if (debug) {
                System.out.println("...1");
            }
            double[][][] xbus = this.duplicate(x);
            double[][][] dbus = OPV.multiply(1.0 / dgr, this.duplicate(d));
            if (debug) {
                System.out.println("...2");
            }
            LinearSearchBrent BL = new LinearSearchBrent(f, dbus, xbus);
            if (debug) {
                System.out.println("...3");
            }
            alfa = BL.minimumSearch(r);
            if (debug) {
                System.out.println("...4");
            }
            this.weights = x = OPV.sum(x, OPV.multiply(alfa, dbus));
            g_old = this.duplicate(gr);
            ++iter;
            if (++subiter >= NVAR) {
                restart = true;
            }
            if (debug) {
                System.out.println("...5");
            }
            err = this.f_denormalized(x, this.factor);
            if (alfa < 1.0E-4 * dgr) {
                System.out.println("return: alpha<" + 1.0E-4 * dgr + "=" + alfa);
                break;
            }
            last_err = err;
        } while (Math.sqrt(OPV.multiply(gr, gr)) > TOL_ERR * (double)gr.length && iter < MAX_ITER);
        return err;
    }

    public double descentGradient(FUN f, double TOL_ERR, double MIN_DELTAGC, int MAX_ITER) {
        double[][][] gr;
        int NVAR = 0;
        double last_err = 0.0;
        double err = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            NVAR += this.weights[i].length * this.weights[i][0].length;
        }
        int iter = 0;
        boolean subiter = false;
        double alpha = 0.0;
        double[][][] x = this.weights;
        boolean restart = true;
        boolean debug = false;
        double[][][] g_old = this.gradient(f, x);
        double[][][] d = this.duplicate(g_old);
        do {
            gr = this.gradient(f, x);
            d = OPV.signChange(gr);
            double[][][] xbus = this.duplicate(x);
            double[][][] dbus = this.duplicate(d);
            LinearSearchBrent BL = new LinearSearchBrent(f, dbus, xbus);
            alpha = BL.minimumSearch(r);
            this.weights = x = OPV.sum(x, OPV.multiply(alpha, dbus));
            g_old = this.duplicate(gr);
            ++iter;
            err = this.f_denormalized(x, this.factor);
            if (!(alpha < 1.0E-4)) continue;
            System.out.println("return: alpha < 0.0001");
            break;
        } while (Math.sqrt(OPV.multiply(gr, gr)) > TOL_ERR * (double)gr.length && iter < MAX_ITER);
        return err;
    }

    public void randomWeights(double x) {
        for (int i = 0; i < this.weights.length; ++i) {
            for (int j = 0; j < this.weights[i].length; ++j) {
                for (int k = 0; k < this.weights[i][j].length; ++k) {
                    this.weights[i][j][k] = this.rnd(-x, x);
                }
            }
        }
    }

    public void changeWeights(double x) {
        for (int i = 0; i < this.weights.length; ++i) {
            for (int j = 0; j < this.weights[i].length; ++j) {
                int k = 0;
                while (k < this.weights[i][j].length) {
                    double[] dArray = this.weights[i][j];
                    int n = k++;
                    dArray[n] = dArray[n] + this.rnd(-x, x);
                }
            }
        }
    }

    private String AString(double[] x) {
        String result = "[";
        for (int i = 0; i < x.length - 1; ++i) {
            result = result + x[i] + " ";
        }
        result = result + x[x.length - 1];
        result = result + "]";
        return result;
    }

    private String AString(double[][] x) {
        String result = "";
        for (int i = 0; i < x.length; ++i) {
            result = result + this.AString(x[i]);
        }
        return result;
    }

    private String AString(double[][][] x) {
        String result = "";
        for (int i = 0; i < x.length; ++i) {
            result = result + this.AString(x[i]);
        }
        return result;
    }

    private void debugOutput() {
        System.out.println("Weight=" + this.AString(this.weights));
        for (int i = 0; i < this.Input.length; ++i) {
            double[] x = OPV.invScale(this.Input[i], this.max_x, this.min_x);
            double[] y = OPV.invScale(this.nn(this.Input[i], this.weights), this.max_y, this.min_y);
            double[] d = OPV.invScale(this.Output[i], this.max_y, this.min_y);
            System.out.println(this.AString(x) + " " + this.AString(y) + " " + this.AString(d));
        }
    }

    public void getWeights(double[] p) {
        int total = 0;
        for (int i = 0; i < this.weights.length; ++i) {
            for (int j = 0; j < this.weights[i].length; ++j) {
                for (int k = 0; k < this.weights[i][j].length; ++k) {
                    p[total++] = this.weights[i][j][k];
                }
            }
        }
    }

    public void setWeights(double[] p) {
        int total = 0;
        for (int i = 0; i < this.weights.length; ++i) {
            for (int j = 0; j < this.weights[i].length; ++j) {
                for (int k = 0; k < this.weights[i][j].length; ++k) {
                    this.weights[i][j][k] = p[total++];
                }
            }
        }
    }
}

