/*
 * Decompiled with CFR 0.152.
 */
package dsa;

import dsa.Interval;
import dsa.Split;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;

class Partition {
    String name;
    String predictedValue;
    String numobs;
    String numsections;
    String section;
    String maxpartitions;
    Icon image;
    Map<String, Interval> intervals;

    Partition(String name, String predictedValue, String numobs, String numsections, String section, String maxpartitions, Icon image, Interval ... intervals) {
        this.name = name;
        this.predictedValue = predictedValue;
        this.numobs = numobs;
        this.numsections = numsections;
        this.section = section;
        this.maxpartitions = maxpartitions;
        this.image = image;
        this.intervals = new HashMap<String, Interval>();
        for (Interval i : intervals) {
            this.add(i);
        }
    }

    void add(Interval interval) {
        assert (!this.intervals.containsKey(interval.getVarName()));
        this.intervals.put(interval.getVarName(), interval);
    }

    int satisfied(Split split) {
        if (this.intervals.containsKey(split.varname)) {
            return this.intervals.get(split.varname).satisfied(split);
        }
        return 2;
    }

    Set<Split> getsplits() {
        HashSet<Split> s = new HashSet<Split>();
        for (Interval i : this.intervals.values()) {
            s.addAll(i.getsplits());
        }
        return s;
    }

    String getPredictedValue() {
        return this.predictedValue;
    }

    public String toString() {
        return this.name;
    }

    public String description() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(": ");
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(this.intervals.keySet());
        for (String k : keys) {
            sb.append(this.intervals.get(k).toString());
            if (k.equals(keys.last())) continue;
            sb.append(" and ");
        }
        return sb.toString();
    }
}

