/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.LabelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.xgboost.ObjFunction;

public abstract class Classification
extends ObjFunction {
    private int num_class;

    public Classification(int num_class) {
        this.num_class = num_class;
    }

    @Override
    public Label encodeLabel(FieldName targetField, List<?> targetCategories, PMMLEncoder encoder) {
        DataField dataField;
        if (targetCategories == null) {
            targetCategories = LabelUtil.createTargetCategories((int)this.num_class);
            dataField = encoder.createDataField(targetField, OpType.CATEGORICAL, DataType.INTEGER, targetCategories);
        } else {
            if (targetCategories.size() != this.num_class) {
                throw new IllegalArgumentException("Expected " + this.num_class + " target categories, got " + targetCategories.size() + " target categories");
            }
            dataField = encoder.createDataField(targetField, OpType.CATEGORICAL, DataType.STRING, targetCategories);
        }
        return new CategoricalLabel(dataField);
    }

    public int num_class() {
        return this.num_class;
    }
}

