/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.formats.brat.AnnotationConfiguration;
import opennlp.tools.formats.brat.BratAnnotation;
import opennlp.tools.formats.brat.BratAnnotationStream;

public class BratDocument {
    private final AnnotationConfiguration config;
    private final String id;
    private final String text;
    private final Map<String, BratAnnotation> annotationMap;

    public BratDocument(AnnotationConfiguration config, String id, String text, Collection<BratAnnotation> annotations) {
        this.config = config;
        this.id = id;
        this.text = text;
        HashMap<String, BratAnnotation> annMap = new HashMap<String, BratAnnotation>();
        for (BratAnnotation annotation : annotations) {
            annMap.put(annotation.getId(), annotation);
        }
        this.annotationMap = Collections.unmodifiableMap(annMap);
    }

    public AnnotationConfiguration getConfig() {
        return this.config;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public BratAnnotation getAnnotation(String id) {
        return this.annotationMap.get(id);
    }

    public Collection<BratAnnotation> getAnnotations() {
        return this.annotationMap.values();
    }

    public static BratDocument parseDocument(AnnotationConfiguration config, String id, InputStream txtIn, InputStream annIn) throws IOException {
        BratAnnotation ann;
        int len;
        InputStreamReader txtReader = new InputStreamReader(txtIn, StandardCharsets.UTF_8);
        StringBuilder text = new StringBuilder();
        char[] cbuf = new char[1024];
        while ((len = txtReader.read(cbuf)) > 0) {
            text.append(cbuf, 0, len);
        }
        ArrayList<BratAnnotation> annotations = new ArrayList<BratAnnotation>();
        BratAnnotationStream annStream = new BratAnnotationStream(config, id, annIn);
        while ((ann = (BratAnnotation)annStream.read()) != null) {
            annotations.add(ann);
        }
        annStream.close();
        return new BratDocument(config, id, text.toString(), annotations);
    }
}

