/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.tools.diff.ChemObjectDiff;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IntegerDifference;

public class ElectronContainerDiff {
    private ElectronContainerDiff() {
    }

    public static String diff(IChemObject first, IChemObject second) {
        IDifference diff = ElectronContainerDiff.difference(first, second);
        if (diff == null) {
            return "";
        }
        return diff.toString();
    }

    public static IDifference difference(IChemObject first, IChemObject second) {
        if (!(first instanceof IElectronContainer) || !(second instanceof IElectronContainer)) {
            return null;
        }
        IElectronContainer firstEC = (IElectronContainer)first;
        IElectronContainer secondEC = (IElectronContainer)second;
        ChemObjectDifference totalDiff = new ChemObjectDifference("ElectronContainerDiff");
        totalDiff.addChild(IntegerDifference.construct("eCount", firstEC.getElectronCount(), secondEC.getElectronCount()));
        totalDiff.addChild(ChemObjectDiff.difference(first, second));
        if (totalDiff.childCount() > 0) {
            return totalDiff;
        }
        return null;
    }
}

