/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import org.openscience.cdk.charges.IChargeCalculator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.forcefield.mmff.Mmff;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.modeling.builder3d.MMFF94BasedParameterSetReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MMFF94PartialCharges
implements IChargeCalculator {
    public static final String MMFF_94_CHARGE = "MMFF94charge";
    private final ILoggingTool LOG = LoggingToolFactory.createLoggingTool(MMFF94BasedParameterSetReader.class);
    private final Mmff mmff = new Mmff();

    public IAtomContainer assignMMFF94PartialCharges(IAtomContainer ac) throws CDKException {
        if (!this.mmff.assignAtomTypes(ac)) {
            throw new CDKException("Molecule had an atom of unknown MMFF type");
        }
        this.mmff.partialCharges(ac);
        this.mmff.clearProps(ac);
        for (IAtom atom : ac.atoms()) {
            atom.setProperty(MMFF_94_CHARGE, atom.getCharge());
        }
        return ac;
    }

    @Override
    public void calculateCharges(IAtomContainer container) throws CDKException {
        try {
            this.assignMMFF94PartialCharges(container);
        }
        catch (Exception exception) {
            throw new CDKException("Could not calculate MMFF94 partial charges: " + exception.getMessage(), exception);
        }
    }
}

