/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class ZagrebIndexDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"Zagreb"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#zagrebIndex", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        double zagreb = 0.0;
        for (IAtom atom : atomContainer.atoms()) {
            if (atom.getSymbol().equals("H")) continue;
            int atomDegree = 0;
            List<IAtom> neighbours = atomContainer.getConnectedAtomsList(atom);
            for (IAtom neighbour : neighbours) {
                if (neighbour.getSymbol().equals("H")) continue;
                ++atomDegree;
            }
            zagreb += (double)(atomDegree * atomDegree);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(zagreb), this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }
}

