/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.ui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.rosuda.JGR.DataLoader;
import org.rosuda.JGR.JGR;

public class DatasetPane
extends JPanel {
    private JButton browseButton;
    private JComboBox datasetComboBox;
    private JLabel datasetLabel;

    public DatasetPane() {
        this.initComponents();
        this.refreshDatasetComboBox();
    }

    public String getSelectedDataset() {
        return GUIUtils.getSelectedItem(this.getDatasetComboBox());
    }

    public void refreshDatasetComboBox() {
        GUIUtils.refreshDataset(this.datasetComboBox);
    }

    public void refreshDatasetComboBoxValidity() {
        GUIUtils.refreshDatasetValidity(this.datasetComboBox);
    }

    private void initComponents() {
        this.datasetLabel = new JLabel();
        this.datasetComboBox = new JComboBox();
        this.browseButton = new JButton();
        this.datasetLabel.setLabelFor(this.datasetComboBox);
        this.datasetLabel.setText("Dataset:");
        this.browseButton.setText("Browse...");
        this.browseButton.setMargin(new Insets(0, 5, 0, 5));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatasetPane.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.datasetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datasetComboBox, -2, 240, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.browseButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.datasetLabel).addComponent(this.datasetComboBox, -2, -1, -2).addComponent(this.browseButton)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        DataLoader loader = new DataLoader();
        String dataName = loader.getDataName();
        JGR.MAINRCONSOLE.toBack();
        if (dataName == null || dataName.length() > 0) {
            // empty if block
        }
    }

    public JComboBox getDatasetComboBox() {
        return this.datasetComboBox;
    }

    public void setDatasetComboBox(JComboBox datasetComboBox) {
        this.datasetComboBox = datasetComboBox;
    }

    public void setDatasetLabel(JLabel datasetLabel) {
        this.datasetLabel = datasetLabel;
    }

    public JLabel getDatasetLabel() {
        return this.datasetLabel;
    }
}

