/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util;

import java.lang.reflect.Array;

public abstract class GrowableBase {
    public static final int DEFAULT_SIZE = 8;
    protected int m_countLimit;
    protected int m_maximumGrowth;

    public GrowableBase(int n, int n2, Class clazz) {
        Object object = Array.newInstance(clazz, n);
        this.m_countLimit = n;
        this.m_maximumGrowth = n2;
        this.setArray(object);
    }

    public GrowableBase(int n, Class clazz) {
        this(n, Integer.MAX_VALUE, clazz);
    }

    public GrowableBase(GrowableBase growableBase) {
        this(growableBase.m_countLimit, growableBase.m_maximumGrowth, growableBase.getArray().getClass().getComponentType());
    }

    protected abstract Object getArray();

    protected abstract void setArray(Object var1);

    protected void resizeCopy(Object object, Object object2) {
        System.arraycopy(object, 0, object2, 0, Array.getLength(object));
    }

    protected void discardValues(int n, int n2) {
        Object object = this.getArray();
        if (!object.getClass().getComponentType().isPrimitive()) {
            Object[] objectArray = (Object[])object;
            int n3 = n;
            while (n3 < n2) {
                objectArray[n3] = null;
                ++n3;
            }
        }
    }

    protected void growArray(int n) {
        Object object = this.getArray();
        int n2 = Math.max(n, this.m_countLimit + Math.min(this.m_countLimit, this.m_maximumGrowth));
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n2);
        this.resizeCopy(object, object2);
        this.m_countLimit = n2;
        this.setArray(object2);
    }

    public final void ensureCapacity(int n) {
        if (n > this.m_countLimit) {
            this.growArray(n);
        }
    }

    protected Object buildArray(Class clazz, int n, int n2) {
        Object object = Array.newInstance(clazz, n2);
        System.arraycopy(this.getArray(), n, object, 0, n2);
        return object;
    }
}

