/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class Provider {
    private String name;
    private String description;
    private URI endpoint;
    private String sdmxVersion;
    private boolean needsCredentials;
    private boolean needsURLEncoding;
    private boolean supportsCompression;
    private boolean full = false;
    private boolean isCustom = false;
    private Map<String, Dataflow> flows;
    private Map<String, DataFlowStructure> dsdNameToStructureCache = null;
    private SSLSocketFactory sslSocketFactory;

    public Provider(String string, URI uRI, KeyStore keyStore, boolean bl, boolean bl2, boolean bl3, String string2, boolean bl4, String string3) throws SdmxException {
        this.name = string;
        this.endpoint = uRI;
        this.description = string2;
        this.flows = new HashMap<String, Dataflow>();
        this.dsdNameToStructureCache = new HashMap<String, DataFlowStructure>();
        this.needsCredentials = bl;
        this.needsURLEncoding = bl2;
        this.supportsCompression = bl3;
        this.isCustom = bl4;
        this.sdmxVersion = string3;
        try {
            if (keyStore != null) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
                this.sslSocketFactory = sSLContext.getSocketFactory();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI uRI) {
        this.endpoint = uRI;
    }

    public void setFlows(Map<String, Dataflow> map) {
        this.flows = map;
    }

    public void setFlow(Dataflow dataflow) {
        this.flows.put(dataflow.getFullIdentifier(), dataflow);
    }

    public Dataflow getFlow(String string) {
        if (this.flows.containsKey(string)) {
            return this.flows.get(string);
        }
        return this.flows.values().stream().filter(dataflow -> dataflow.getId().equals(string)).max(Comparator.comparing(SDMXReference::getVersion)).orElse(null);
    }

    public Map<String, Dataflow> getFlows() {
        return this.flows;
    }

    public SDMXReference getDSDIdentifier(String string) {
        SDMXReference sDMXReference = null;
        Dataflow dataflow = this.getFlow(string);
        if (dataflow != null) {
            sDMXReference = dataflow.getDsdIdentifier();
        }
        return sDMXReference;
    }

    public DataFlowStructure getDSD(String string) {
        return this.dsdNameToStructureCache.get(string);
    }

    public void setDSD(String string, DataFlowStructure dataFlowStructure) {
        this.dsdNameToStructureCache.put(string, dataFlowStructure);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isNeedsCredentials() {
        return this.needsCredentials;
    }

    public void setNeedsCredentials(boolean bl) {
        this.needsCredentials = bl;
    }

    public void setFull(boolean bl) {
        this.full = bl;
    }

    public boolean isFull() {
        return this.full;
    }

    public boolean isNeedsURLEncoding() {
        return this.needsURLEncoding;
    }

    public void setNeedsURLEncoding(boolean bl) {
        this.needsURLEncoding = bl;
    }

    public boolean isSupportsCompression() {
        return this.supportsCompression;
    }

    public void setSupportsCompression(boolean bl) {
        this.supportsCompression = bl;
    }

    public void setCustom(boolean bl) {
        this.isCustom = bl;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public String getSdmxVersion() {
        return this.sdmxVersion;
    }

    public void setSdmxVersion(String string) {
        this.sdmxVersion = string;
    }
}

