/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCBA;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Associative_Classification.ClassifierCBA.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Item;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Itemset;
import keel.Algorithms.Associative_Classification.ClassifierCBA.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierCBA.myDataset;

public class Apriori {
    ArrayList<Itemset> L2;
    double minpsup;
    double minpconf;
    int nClasses;
    int nVariables;
    int prune;
    long time;
    RuleBase ruleBase;
    myDataset train;
    DataBase dataBase;
    int limitRules;
    int numberRules;

    public Apriori() {
    }

    public Apriori(DataBase dataBase, myDataset train, double minpsup, double minpconf, int prune, int limitRules) {
        this.train = train;
        this.dataBase = dataBase;
        this.minpsup = minpsup;
        this.minpconf = minpconf;
        this.prune = prune;
        this.nClasses = this.train.getnClasses();
        this.nVariables = this.train.getnInputs();
        this.limitRules = limitRules;
        this.L2 = new ArrayList();
    }

    public void setSupportConfidence(double minpsup, double minpconf) {
        this.minpsup = minpsup;
        this.minpconf = minpconf;
    }

    public RuleBase generateCAR() {
        this.ruleBase = new RuleBase(this.dataBase, this.train);
        this.numberRules = 0;
        this.time = 0L;
        this.generateL2();
        this.generateLarge(this.L2);
        System.gc();
        return this.ruleBase;
    }

    private void generateL2() {
        this.L2.clear();
        Itemset itemset = new Itemset(0);
        for (int i = 0; i < this.nVariables && this.numberRules < this.limitRules; ++i) {
            if (this.dataBase.numLabels(i) <= 1) continue;
            for (int j = 0; j < this.dataBase.numLabels(i) && this.numberRules < this.limitRules; ++j) {
                Item item = new Item(i, j);
                itemset.add(item);
                for (int k = 0; k < this.nClasses && this.numberRules < this.limitRules; ++k) {
                    itemset.setClas(k);
                    itemset.calculateSupports(this.train);
                    if (!(itemset.getSupportClass() > this.minpsup)) continue;
                    this.L2.add(itemset.clone());
                    ++this.numberRules;
                }
                itemset.remove(0);
            }
        }
        this.generateRules(this.L2, this.L2);
    }

    private void generateLarge(ArrayList<Itemset> Lk) {
        int size = Lk.size();
        if (size > 1 && this.numberRules < this.limitRules && Lk.get(0).size() < this.dataBase.numVariablesUsed()) {
            ArrayList<Itemset> Lnew = new ArrayList<Itemset>();
            for (int i = 0; i < size - 1 && this.numberRules < this.limitRules; ++i) {
                Itemset itemseti = Lk.get(i);
                for (int j = i + 1; j < size && this.numberRules < this.limitRules; ++j) {
                    Itemset itemsetj = Lk.get(j);
                    if (!this.isCombinable(itemseti, itemsetj)) continue;
                    Itemset newItemset = itemseti.clone();
                    newItemset.add(itemsetj.get(itemsetj.size() - 1).clone());
                    newItemset.calculateSupports(this.train);
                    if (!(newItemset.getSupportClass() >= this.minpsup)) continue;
                    Lnew.add(newItemset);
                    ++this.numberRules;
                }
            }
            this.generateRules(Lnew, Lk);
            if (this.numberRules < this.limitRules) {
                this.numberRules -= Lk.size();
                Lk.clear();
                System.gc();
                this.generateLarge(Lnew);
            }
        }
    }

    private boolean isCombinable(Itemset itemseti, Itemset itemsetj) {
        Item itemj;
        Item itemi;
        if (itemseti.getClas() != itemsetj.getClas()) {
            return false;
        }
        if (itemseti.size() != itemsetj.size()) {
            return false;
        }
        for (int i = 0; i < itemseti.size() - 1; ++i) {
            itemi = itemseti.get(i);
            itemj = itemsetj.get(i);
            if (itemi.getVariable() == itemj.getVariable() && itemi.getValue() == itemj.getValue()) continue;
            return false;
        }
        itemi = itemseti.get(itemseti.size() - 1);
        itemj = itemsetj.get(itemsetj.size() - 1);
        return itemi.getVariable() < itemj.getVariable();
    }

    private boolean isPrune(Itemset itemset, ArrayList<Itemset> Lf) {
        for (int i = 0; i < Lf.size() && Lf.size() > 1; ++i) {
            Itemset itemseti = Lf.get(i);
            if (!itemseti.isSubItemset(itemset) || !(itemseti.getPer() < itemset.getPer())) continue;
            return true;
        }
        return false;
    }

    private void generateRules(ArrayList<Itemset> Lk, ArrayList<Itemset> Lf) {
        Collections.sort(Lk);
        int i = 0;
        while (i < Lk.size() && this.numberRules < this.limitRules) {
            Itemset itemseti = Lk.get(i);
            double bestConfidence = itemseti.getSupport() > 0.0 ? itemseti.getSupportClass() / itemseti.getSupport() : 0.0;
            boolean stop = false;
            int j = i + 1;
            while (j < Lk.size() && !stop) {
                Itemset itemsetj = Lk.get(j);
                if (itemseti.isEqualAnt(itemsetj)) {
                    double confidence = itemsetj.getSupport() > 0.0 ? itemsetj.getSupportClass() / itemsetj.getSupport() : 0.0;
                    if (confidence > bestConfidence) {
                        bestConfidence = confidence;
                        itemseti = itemsetj;
                    }
                    ++j;
                    continue;
                }
                stop = true;
            }
            if (bestConfidence >= this.minpconf) {
                if (this.prune > 0 && itemseti.size() > 1) {
                    if (!this.isPrune(itemseti, Lf)) {
                        this.ruleBase.add(itemseti, this.time);
                        ++this.time;
                        ++this.numberRules;
                    }
                } else {
                    this.ruleBase.add(itemseti, this.time);
                    ++this.time;
                    ++this.numberRules;
                }
            }
            i = j;
        }
    }
}

