/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR.GARProcess;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR.myDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GAR.parseParameters;
import keel.Dataset.Attributes;
import org.core.Files;
import org.core.Randomize;

public class GAR {
    myDataset trans;
    String assoc_rules_fname;
    String sup_rules_fname;
    String valuesOrderFilename;
    GARProcess ap;
    ArrayList<AssociationRule> assoc_rules;
    private String fileTime;
    private String fileHora;
    private String namedataset;
    private int nItemset;
    private int nTrials;
    private int popsize;
    private double ps;
    private double pc;
    private double pm;
    private double w;
    private double y;
    private double u;
    private double AF;
    private double minConfidence;
    private double minSupport;
    long startTime;
    long totalTime;
    private boolean somethingWrong = false;

    public GAR() {
    }

    public GAR(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.trans = new myDataset();
        try {
            this.namedataset = parameters.getTransactionsInputFile();
            System.out.println("\nReading the transaction set: " + parameters.getTransactionsInputFile());
            this.trans.readDataSet(parameters.getTransactionsInputFile());
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input transaction set: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.trans.hasMissingAttributes();
        this.assoc_rules_fname = parameters.getAssociationRulesFile();
        this.sup_rules_fname = parameters.getOutputFile(0);
        this.valuesOrderFilename = parameters.getOutputFile(1);
        this.fileTime = parameters.getOutputFile(0).substring(0, parameters.getOutputFile(0).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(0).substring(0, parameters.getOutputFile(0).lastIndexOf(47)) + "/hora.txt";
        long seed = Long.parseLong(parameters.getParameter(0));
        this.nItemset = Integer.parseInt(parameters.getParameter(1));
        this.nTrials = Integer.parseInt(parameters.getParameter(2));
        this.popsize = Integer.parseInt(parameters.getParameter(3));
        this.ps = Double.parseDouble(parameters.getParameter(4));
        this.pc = Double.parseDouble(parameters.getParameter(5));
        this.pm = Double.parseDouble(parameters.getParameter(6));
        this.w = Double.parseDouble(parameters.getParameter(7));
        this.y = Double.parseDouble(parameters.getParameter(8));
        this.u = Double.parseDouble(parameters.getParameter(9));
        this.AF = Double.parseDouble(parameters.getParameter(10));
        this.minSupport = Double.parseDouble(parameters.getParameter(11));
        this.minConfidence = Double.parseDouble(parameters.getParameter(12));
        Randomize.setSeed(seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found");
            System.err.println("Aborting the program");
        } else {
            this.ap = new GARProcess(this.trans, this.nItemset, this.nTrials, this.popsize, this.ps, this.pc, this.pm, this.w, this.y, this.u, this.AF);
            this.ap.run();
            this.assoc_rules = this.ap.getSetRules(this.minConfidence, this.minSupport);
            try {
                PrintWriter rule_writer = new PrintWriter(this.assoc_rules_fname);
                PrintWriter sup_writer = new PrintWriter(this.sup_rules_fname);
                PrintWriter valuesOrder_writer = new PrintWriter(this.valuesOrderFilename);
                rule_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                rule_writer.println("<association_rules>");
                sup_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                sup_writer.println("<values>");
                for (int i = 0; i < this.assoc_rules.size(); ++i) {
                    AssociationRule a_r = this.assoc_rules.get(i);
                    ArrayList<Gene> ant = a_r.getAntecedent();
                    ArrayList<Gene> cons = a_r.getConsequent();
                    rule_writer.println("<rule id=\"" + i + "\">");
                    sup_writer.println("<rule id=\"" + i + "\" rule_support=\"" + GARProcess.roundDouble(a_r.getAll_support(), 2) + "\" antecedent_support=\"" + GARProcess.roundDouble(a_r.getSupport_Ant(), 2) + "\" consequent_support=\"" + GARProcess.roundDouble(a_r.getSupport_cons(), 2) + "\" confidence=\"" + GARProcess.roundDouble(a_r.getConfidence(), 2) + "\" lift=\"" + GARProcess.roundDouble(a_r.getLift(), 2) + "\" conviction=\"" + GARProcess.roundDouble(a_r.getConv(), 2) + "\" certainFactor=\"" + GARProcess.roundDouble(a_r.getCF(), 2) + "\" netConf=\"" + GARProcess.roundDouble(a_r.getNetConf(), 2) + "\" yulesQ=\"" + GARProcess.roundDouble(a_r.getYulesQ(), 2) + "\" nAttributes=\"" + (a_r.getAntecedent().size() + a_r.getConsequent().size()) + "\"/>");
                    rule_writer.println("<antecedents>");
                    for (int j = 0; j < ant.size(); ++j) {
                        Gene g_ant = ant.get(j);
                        this.createRule(g_ant, rule_writer);
                    }
                    rule_writer.println("</antecedents>");
                    rule_writer.println("<consequents>");
                    Gene g_cons = cons.get(0);
                    this.createRule(g_cons, rule_writer);
                    rule_writer.println("</consequents>");
                    rule_writer.println("</rule>");
                }
                rule_writer.println("</association_rules>");
                sup_writer.println("</values>");
                rule_writer.close();
                sup_writer.close();
                valuesOrder_writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                valuesOrder_writer.println("<values>");
                valuesOrder_writer.print(this.ap.printRules(this.assoc_rules));
                valuesOrder_writer.print("</values>");
                valuesOrder_writer.close();
                this.totalTime = System.currentTimeMillis() - this.startTime;
                this.writeTime();
                System.out.println("Algorithm Finished");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.namedataset + this.assoc_rules_fname + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.assoc_rules_fname + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void createRule(Gene g, PrintWriter w) {
        int attr = g.getAttr();
        w.println("<attribute name=\"" + Attributes.getInputAttribute(attr).getName() + "\" value=\"");
        if (g.getType() == 0) {
            w.print(Attributes.getInputAttribute(attr).getNominalValue((int)g.getL()));
        } else {
            w.print("[" + g.getL() + ", " + g.getU() + "]");
        }
        w.println("\" />");
    }
}

