/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Missing_Values.knnImpute;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import keel.Algorithms.Preprocess.Missing_Values.knnImpute.FreqList;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class knnImpute {
    double[] mean = null;
    double[] std_dev = null;
    double tempData = 0.0;
    String[][] X = null;
    FreqList[] timesSeen = null;
    String[] mostCommon;
    int ndatos = 0;
    int nentradas = 0;
    int tipo = 0;
    int direccion = 0;
    int nvariables = 0;
    int nsalidas = 0;
    int nneigh = 1;
    InstanceSet IS;
    InstanceSet IStest;
    String input_train_name = new String();
    String input_test_name = new String();
    String output_train_name = new String();
    String output_test_name = new String();
    String temp = new String();
    String data_out = new String("");

    public knnImpute(String fileParam) {
        this.config_read(fileParam);
        this.IS = new InstanceSet();
        this.IStest = new InstanceSet();
    }

    private void write_results(String output) {
        try {
            FileWriter file_write = new FileWriter(output);
            file_write.write(this.IS.getHeader());
            file_write.write("@data\n");
            for (int i = 0; i < this.ndatos; ++i) {
                file_write.write(this.X[i][0]);
                for (int j = 1; j < this.nvariables; ++j) {
                    file_write.write("," + this.X[i][j]);
                }
                file_write.write("\n");
            }
            file_write.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("k = ");
            this.nneigh = new Integer(out[1]);
            file_reader.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private double distance(Instance i, Instance j) {
        double dist = 0.0;
        int in = 0;
        int out = 0;
        for (int l = 0; l < this.nvariables; ++l) {
            Attribute a = Attributes.getAttribute(l);
            this.direccion = a.getDirectionAttribute();
            this.tipo = a.getType();
            if (this.direccion == 1) {
                if (this.tipo != 0 && !i.getInputMissingValues(in)) {
                    dist += (i.getInputRealValues(in) - j.getInputRealValues(in)) * (i.getInputRealValues(in) - j.getInputRealValues(in));
                } else if (!i.getInputMissingValues(in) && i.getInputNominalValues(in) != j.getInputNominalValues(in)) {
                    dist += 1.0;
                }
                ++in;
                continue;
            }
            if (this.direccion != 2) continue;
            if (this.tipo != 0 && !i.getOutputMissingValues(out)) {
                dist += (i.getOutputRealValues(out) - j.getOutputRealValues(out)) * (i.getOutputRealValues(out) - j.getOutputRealValues(out));
            } else if (!i.getOutputMissingValues(out) && i.getOutputNominalValues(out) != j.getOutputNominalValues(out)) {
                dist += 1.0;
            }
            ++out;
        }
        return Math.sqrt(dist);
    }

    protected boolean sameMissingInputAttributes(Instance inst1, Instance inst2) {
        boolean sameMVs = true;
        for (int i = 0; i < Attributes.getInputNumAttributes() && sameMVs; ++i) {
            if (inst1.getInputMissingValues(i) == inst2.getInputMissingValues(i)) continue;
            sameMVs = false;
        }
        return sameMVs;
    }

    protected Instance nearestValidNeighbor(Instance inst, int a) {
        double distance = Double.POSITIVE_INFINITY;
        int nn = 0;
        for (int i = 0; i < this.IS.getNumInstances(); ++i) {
            Instance inst2 = this.IS.getInstance(i);
            if (inst == inst2 || inst2.getInputMissingValues(a) || !(this.distance(inst, inst2) < distance)) continue;
            distance = this.distance(inst, inst2);
            nn = i;
        }
        return this.IS.getInstance(nn);
    }

    public double boundValueToAttributeLimits(double value, Attribute a) {
        if (value < a.getMinAttribute()) {
            value = a.getMinAttribute();
        } else if (value > a.getMaxAttribute()) {
            value = a.getMaxAttribute();
        }
        return value;
    }

    public void process() {
        Instance inst2;
        int m;
        int totalN;
        double mean;
        boolean allNull;
        int j;
        int actual;
        double dist;
        Instance neighbor;
        int k;
        int n;
        Instance inst;
        int i;
        int out;
        int in;
        int[] N = new int[this.nneigh];
        double[] Ndist = new double[this.nneigh];
        try {
            this.IS.readSet(this.input_train_name, true);
            in = 0;
            out = 0;
            this.ndatos = this.IS.getNumInstances();
            this.nvariables = Attributes.getNumAttributes();
            this.nentradas = Attributes.getInputNumAttributes();
            this.nsalidas = Attributes.getOutputNumAttributes();
            this.X = new String[this.ndatos][this.nvariables];
            this.timesSeen = new FreqList[this.nvariables];
            this.mostCommon = new String[this.nvariables];
            for (i = 0; i < this.ndatos; ++i) {
                inst = this.IS.getInstance(i);
                in = 0;
                out = 0;
                if (inst.existsAnyMissingValue()) {
                    for (n = 0; n < this.nneigh; ++n) {
                        Ndist[n] = Double.MAX_VALUE;
                        N[n] = -1;
                    }
                    for (k = 0; k < this.ndatos; ++k) {
                        neighbor = this.IS.getInstance(k);
                        if (this.sameMissingInputAttributes(inst, neighbor)) continue;
                        dist = this.distance(inst, neighbor);
                        actual = -1;
                        for (int n2 = 0; n2 < this.nneigh; ++n2) {
                            if (!(dist < Ndist[n2])) continue;
                            if (actual != -1) {
                                if (!(Ndist[n2] > Ndist[actual])) continue;
                                actual = n2;
                                continue;
                            }
                            actual = n2;
                        }
                        if (actual == -1) continue;
                        N[actual] = k;
                        Ndist[actual] = dist;
                    }
                }
                for (j = 0; j < this.nvariables; ++j) {
                    Attribute a = Attributes.getAttribute(j);
                    this.direccion = a.getDirectionAttribute();
                    this.tipo = a.getType();
                    if (this.direccion == 1) {
                        if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                            this.X[i][j] = new String(String.valueOf(inst.getInputRealValues(in)));
                        } else if (!inst.getInputMissingValues(in)) {
                            this.X[i][j] = inst.getInputNominalValues(in);
                        } else {
                            allNull = true;
                            this.timesSeen[j] = new FreqList();
                            if (this.tipo != 0) {
                                mean = 0.0;
                                totalN = 0;
                                for (m = 0; m < this.nneigh; ++m) {
                                    if (N[m] == -1 || (inst2 = this.IS.getInstance(N[m])).getInputMissingValues(in)) continue;
                                    mean += inst2.getInputRealValues(in);
                                    ++totalN;
                                    allNull = false;
                                }
                                if (!allNull) {
                                    mean /= (double)totalN;
                                    if (this.tipo == 1) {
                                        mean = new Double(mean + 0.5).intValue();
                                    }
                                    this.X[i][j] = new String(String.valueOf(mean));
                                } else {
                                    this.X[i][j] = String.valueOf(this.nearestValidNeighbor(inst, in).getInputRealValues(in));
                                }
                            } else {
                                for (m = 0; m < this.nneigh; ++m) {
                                    inst2 = this.IS.getInstance(N[m]);
                                    if (N[m] == -1 || inst2.getInputMissingValues(in)) continue;
                                    this.timesSeen[j].AddElement(inst2.getInputNominalValues(in));
                                }
                                this.X[i][j] = this.timesSeen[j].totalElements != 0 ? new String(this.timesSeen[j].mostCommon().getValue()) : this.nearestValidNeighbor(inst, in).getInputNominalValues(in);
                            }
                        }
                        ++in;
                        continue;
                    }
                    if (this.direccion != 2) continue;
                    if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                        this.X[i][j] = new String(String.valueOf(inst.getOutputRealValues(out)));
                    } else if (!inst.getOutputMissingValues(out)) {
                        this.X[i][j] = inst.getOutputNominalValues(out);
                    } else {
                        allNull = true;
                        this.timesSeen[j] = new FreqList();
                        if (this.tipo != 0) {
                            mean = 0.0;
                            totalN = 0;
                            for (m = 0; m < this.nneigh; ++m) {
                                if (N[m] == -1) continue;
                                ++totalN;
                                allNull = false;
                                inst2 = this.IS.getInstance(N[m]);
                                mean += inst2.getOutputRealValues(out);
                            }
                            if (!allNull) {
                                mean /= (double)totalN;
                                if (this.tipo == 1) {
                                    mean = new Double(mean + 0.5).intValue();
                                }
                                mean = this.boundValueToAttributeLimits(mean, a);
                                this.X[i][j] = new String(String.valueOf(mean));
                            } else {
                                this.X[i][j] = new String("<null>");
                            }
                        } else {
                            for (m = 0; m < this.nneigh; ++m) {
                                inst2 = this.IS.getInstance(N[m]);
                                if (N[m] == -1) continue;
                                this.timesSeen[j].AddElement(inst2.getOutputNominalValues(out));
                            }
                            this.X[i][j] = this.timesSeen[j].totalElements != 0 ? new String(this.timesSeen[j].mostCommon().getValue()) : new String("<null>");
                        }
                    }
                    ++out;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Dataset exception = " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        this.write_results(this.output_train_name);
        if (this.input_train_name.compareTo(this.input_test_name) != 0) {
            try {
                this.IStest.readSet(this.input_test_name, false);
                in = 0;
                out = 0;
                this.ndatos = this.IStest.getNumInstances();
                this.nvariables = Attributes.getNumAttributes();
                this.nentradas = Attributes.getInputNumAttributes();
                this.nsalidas = Attributes.getOutputNumAttributes();
                this.X = new String[this.ndatos][this.nvariables];
                this.timesSeen = new FreqList[this.nvariables];
                this.mostCommon = new String[this.nvariables];
                for (i = 0; i < this.ndatos; ++i) {
                    inst = this.IStest.getInstance(i);
                    in = 0;
                    out = 0;
                    if (inst.existsAnyMissingValue()) {
                        for (n = 0; n < this.nneigh; ++n) {
                            Ndist[n] = Double.MAX_VALUE;
                            N[n] = -1;
                        }
                        for (k = 0; k < this.ndatos; ++k) {
                            neighbor = this.IS.getInstance(k);
                            if (this.sameMissingInputAttributes(inst, neighbor)) continue;
                            dist = this.distance(inst, neighbor);
                            actual = -1;
                            for (int n3 = 0; n3 < this.nneigh; ++n3) {
                                if (!(dist < Ndist[n3])) continue;
                                if (actual != -1) {
                                    if (!(Ndist[n3] > Ndist[actual])) continue;
                                    actual = n3;
                                    continue;
                                }
                                actual = n3;
                            }
                            if (actual == -1) continue;
                            N[actual] = k;
                            Ndist[actual] = dist;
                        }
                    }
                    for (j = 0; j < this.nvariables; ++j) {
                        Attribute a = Attributes.getAttribute(j);
                        this.direccion = a.getDirectionAttribute();
                        this.tipo = a.getType();
                        if (this.direccion == 1) {
                            if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                                this.X[i][j] = new String(String.valueOf(inst.getInputRealValues(in)));
                            } else if (!inst.getInputMissingValues(in)) {
                                this.X[i][j] = inst.getInputNominalValues(in);
                            } else {
                                allNull = true;
                                this.timesSeen[j] = new FreqList();
                                if (this.tipo != 0) {
                                    mean = 0.0;
                                    totalN = 0;
                                    for (m = 0; m < this.nneigh; ++m) {
                                        if (N[m] == -1 || (inst2 = this.IS.getInstance(N[m])).getInputMissingValues(in)) continue;
                                        mean += inst2.getInputRealValues(in);
                                        ++totalN;
                                        allNull = false;
                                    }
                                    if (!allNull) {
                                        mean /= (double)totalN;
                                        if (this.tipo == 1) {
                                            mean = new Double(mean + 0.5).intValue();
                                        }
                                        mean = this.boundValueToAttributeLimits(mean, a);
                                        this.X[i][j] = new String(String.valueOf(mean));
                                    } else {
                                        this.X[i][j] = String.valueOf(this.nearestValidNeighbor(inst, in).getInputRealValues(in));
                                    }
                                } else {
                                    for (m = 0; m < this.nneigh; ++m) {
                                        inst2 = this.IS.getInstance(N[m]);
                                        if (N[m] == -1 || inst2.getInputMissingValues(in)) continue;
                                        this.timesSeen[j].AddElement(inst2.getInputNominalValues(in));
                                    }
                                    this.X[i][j] = this.timesSeen[j].totalElements != 0 ? new String(this.timesSeen[j].mostCommon().getValue()) : this.nearestValidNeighbor(inst, in).getInputNominalValues(in);
                                }
                            }
                            ++in;
                            continue;
                        }
                        if (this.direccion != 2) continue;
                        if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                            this.X[i][j] = new String(String.valueOf(inst.getOutputRealValues(out)));
                        } else if (!inst.getOutputMissingValues(out)) {
                            this.X[i][j] = inst.getOutputNominalValues(out);
                        } else {
                            allNull = true;
                            this.timesSeen[j] = new FreqList();
                            if (this.tipo != 0) {
                                mean = 0.0;
                                totalN = 0;
                                for (m = 0; m < this.nneigh; ++m) {
                                    if (N[m] == -1) continue;
                                    ++totalN;
                                    allNull = false;
                                    inst2 = this.IS.getInstance(N[m]);
                                    mean += inst2.getOutputRealValues(out);
                                }
                                if (!allNull) {
                                    mean /= (double)totalN;
                                    if (this.tipo == 1) {
                                        mean = new Double(mean + 0.5).intValue();
                                    }
                                    this.X[i][j] = new String(String.valueOf(mean));
                                } else {
                                    this.X[i][j] = new String("<null>");
                                }
                            } else {
                                for (m = 0; m < this.nneigh; ++m) {
                                    inst2 = this.IS.getInstance(N[m]);
                                    if (N[m] == -1) continue;
                                    this.timesSeen[j].AddElement(inst2.getOutputNominalValues(out));
                                }
                                this.X[i][j] = this.timesSeen[j].totalElements != 0 ? new String(this.timesSeen[j].mostCommon().getValue()) : new String("<null>");
                            }
                        }
                        ++out;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Dataset exception = " + e);
                e.printStackTrace();
                System.exit(-1);
            }
            this.write_results(this.output_test_name);
        }
    }
}

