/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryBond;

final class QueryStereoFilter
implements Predicate<int[]> {
    private final IAtomContainer query;
    private final IAtomContainer target;
    private final Map<IAtom, Integer> queryMap;
    private final Map<IAtom, Integer> targetMap;
    private final IStereoElement[] queryElements;
    private final IStereoElement[] targetElements;
    private final Type[] queryTypes;
    private final Type[] targetTypes;
    private final int[] queryStereoIndices;
    private final int[] targetStereoIndices;
    private int[] groupConfigAdjust;

    public QueryStereoFilter(IAtomContainer query, IAtomContainer target) {
        if (!(query instanceof IQueryAtomContainer)) {
            throw new IllegalArgumentException("match predicate is for SMARTS only");
        }
        this.query = query;
        this.target = target;
        this.queryMap = QueryStereoFilter.indexAtoms(query);
        this.targetMap = QueryStereoFilter.indexAtoms(target);
        this.queryElements = new IStereoElement[query.getAtomCount()];
        this.targetElements = new IStereoElement[target.getAtomCount()];
        this.queryTypes = new Type[query.getAtomCount()];
        this.targetTypes = new Type[target.getAtomCount()];
        this.queryStereoIndices = QueryStereoFilter.indexElements(this.queryMap, this.queryElements, this.queryTypes, query);
        this.targetStereoIndices = QueryStereoFilter.indexElements(this.targetMap, this.targetElements, this.targetTypes, target);
    }

    @Override
    public boolean test(int[] mapping) {
        if (this.groupConfigAdjust != null) {
            Arrays.fill(this.groupConfigAdjust, 0);
        }
        block4: for (int u : this.queryStereoIndices) {
            switch (this.queryTypes[u]) {
                case Tetrahedral: {
                    if (this.checkTetrahedral(u, mapping)) continue block4;
                    return false;
                }
                case Geometric: {
                    if (this.checkGeometric(u, this.otherIndex(u), mapping)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    private static int indexOf(int[] xs, int x) {
        for (int i = 0; i < xs.length; ++i) {
            if (xs[i] != x) continue;
            return i;
        }
        return -1;
    }

    private boolean checkTetrahedral(int u, int[] mapping) {
        int v = mapping[u];
        if (this.targetTypes[v] != null && this.targetTypes[v] != Type.Tetrahedral) {
            return false;
        }
        ITetrahedralChirality queryElement = (ITetrahedralChirality)this.queryElements[u];
        ITetrahedralChirality targetElement = (ITetrahedralChirality)this.targetElements[v];
        IAtom queryAtom = this.query.getAtom(u);
        IAtom targetAtom = this.target.getAtom(v);
        if (this.targetTypes[v] == null) {
            return ((QueryAtom)queryAtom).getExpression().matches(targetAtom, 0);
        }
        if (this.targetTypes[v] != Type.Tetrahedral) {
            return false;
        }
        int[] us = this.map(u, v, this.neighbors(queryElement, this.queryMap), mapping);
        int[] vs = this.neighbors(targetElement, this.targetMap);
        int focusIdx = this.targetMap.get(targetAtom);
        for (int i = 0; i < 4; ++i) {
            int j = QueryStereoFilter.indexOf(us, vs[i]);
            if (j >= 0) continue;
            us[QueryStereoFilter.indexOf((int[])us, (int)focusIdx)] = vs[i];
        }
        int parity = this.permutationParity(us) * this.permutationParity(vs) * this.parity(targetElement.getStereo());
        int groupInfo = targetElement.getGroupInfo();
        if (groupInfo != 0) {
            if (this.groupConfigAdjust == null) {
                this.groupConfigAdjust = new int[this.target.getAtomCount()];
            }
            if (this.groupConfigAdjust[v] == 0) {
                boolean leftOk = ((QueryAtom)queryAtom).getExpression().matches(targetAtom, 1);
                boolean rghtOk = ((QueryAtom)queryAtom).getExpression().matches(targetAtom, 2);
                if (leftOk && rghtOk) {
                    return true;
                }
                int adjust = 1;
                if (parity == -1 && !leftOk || parity == 1 && !rghtOk) {
                    adjust = -1;
                }
                for (int idx : this.targetStereoIndices) {
                    if (this.targetElements[idx].getGroupInfo() != groupInfo) continue;
                    this.groupConfigAdjust[idx] = adjust;
                }
            }
            parity *= this.groupConfigAdjust[v];
        }
        if (parity < 0) {
            return ((QueryAtom)queryAtom).getExpression().matches(targetAtom, 1);
        }
        if (parity > 0) {
            return ((QueryAtom)queryAtom).getExpression().matches(targetAtom, 2);
        }
        return ((QueryAtom)queryAtom).getExpression().matches(targetAtom, 0);
    }

    private int[] map(int u, int v, int[] us, int[] mapping) {
        for (int i = 0; i < us.length; ++i) {
            us[i] = mapping[us[i]];
        }
        return us;
    }

    private boolean checkGeometric(int u1, int u2, int[] mapping) {
        IBond tbond;
        int v1 = mapping[u1];
        int v2 = mapping[u2];
        if (this.targetTypes[v1] != null && this.targetTypes[v1] != Type.Geometric) {
            return false;
        }
        if (this.targetTypes[v2] != null && this.targetTypes[v2] != Type.Geometric) {
            return false;
        }
        IDoubleBondStereochemistry queryElement = (IDoubleBondStereochemistry)this.queryElements[u1];
        IBond qbond = queryElement.getStereoBond();
        int config = 0;
        if (this.targetTypes[v1] == Type.Geometric && this.targetTypes[v2] == Type.Geometric) {
            IDoubleBondStereochemistry targetElement = (IDoubleBondStereochemistry)this.targetElements[v1];
            tbond = targetElement.getStereoBond();
            if (!targetElement.getStereoBond().contains(this.target.getAtom(v1)) || !targetElement.getStereoBond().contains(this.target.getAtom(v2))) {
                return false;
            }
            IBond[] qbonds = queryElement.getBonds();
            IBond[] tbonds = targetElement.getBonds();
            if (!queryElement.getStereoBond().getBegin().equals((Object)this.query.getAtom(u1))) {
                this.swap(qbonds, 0, 1);
            }
            if (!targetElement.getStereoBond().getBegin().equals((Object)this.target.getAtom(v1))) {
                this.swap(tbonds, 0, 1);
            }
            config = this.getMappedBond(qbonds[0], mapping).equals((Object)tbonds[0]) != this.getMappedBond(qbonds[1], mapping).equals((Object)tbonds[1]) ? targetElement.getConfigOrder() ^ 3 : targetElement.getConfigOrder();
        } else {
            tbond = this.target.getBond(this.target.getAtom(v1), this.target.getAtom(v2));
        }
        Expr expr = ((QueryBond)qbond).getExpression();
        return expr.matches(tbond, config);
    }

    private IBond getMappedBond(IBond qbond, int[] mapping) {
        return this.target.getBond(this.target.getAtom(mapping[this.query.indexOf(qbond.getBegin())]), this.target.getAtom(mapping[this.query.indexOf(qbond.getEnd())]));
    }

    private void swap(IBond[] tbonds, int i, int j) {
        IBond tmp = tbonds[i];
        tbonds[i] = tbonds[j];
        tbonds[j] = tmp;
    }

    private int[] neighbors(ITetrahedralChirality element, Map<IAtom, Integer> map) {
        IAtom[] atoms = element.getLigands();
        int[] vs = new int[atoms.length];
        for (int i = 0; i < atoms.length; ++i) {
            vs[i] = map.get(atoms[i]);
        }
        return vs;
    }

    private int permutationParity(int[] vs) {
        int n = 0;
        for (int i = 0; i < vs.length; ++i) {
            for (int j = i + 1; j < vs.length; ++j) {
                if (vs[i] <= vs[j]) continue;
                ++n;
            }
        }
        return n & true ? -1 : 1;
    }

    private int otherIndex(int i) {
        IDoubleBondStereochemistry element = (IDoubleBondStereochemistry)this.queryElements[i];
        return this.queryMap.get(element.getStereoBond().getOther(this.query.getAtom(i)));
    }

    private static Map<IAtom, Integer> indexAtoms(IAtomContainer container) {
        HashMap<IAtom, Integer> map = new HashMap<IAtom, Integer>(2 * container.getAtomCount());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            map.put(container.getAtom(i), i);
        }
        return map;
    }

    private static int[] indexElements(Map<IAtom, Integer> map, IStereoElement[] elements, Type[] types, IAtomContainer container) {
        int[] indices = new int[container.getAtomCount()];
        int nElements = 0;
        for (IStereoElement element : container.stereoElements()) {
            if (element instanceof ITetrahedralChirality) {
                ITetrahedralChirality tc = (ITetrahedralChirality)element;
                int idx = map.get(tc.getChiralAtom());
                elements[idx] = element;
                types[idx] = Type.Tetrahedral;
                indices[nElements++] = idx;
                continue;
            }
            if (!(element instanceof IDoubleBondStereochemistry)) continue;
            IDoubleBondStereochemistry dbs = (IDoubleBondStereochemistry)element;
            int idx1 = map.get(dbs.getStereoBond().getBegin());
            int idx2 = map.get(dbs.getStereoBond().getEnd());
            elements[idx2] = elements[idx1] = element;
            types[idx1] = types[idx2] = Type.Geometric;
            indices[nElements++] = idx1;
        }
        return Arrays.copyOf(indices, nElements);
    }

    private int parity(ITetrahedralChirality.Stereo stereo) {
        return stereo == ITetrahedralChirality.Stereo.CLOCKWISE ? 1 : -1;
    }

    private int parity(IDoubleBondStereochemistry.Conformation conformation) {
        return conformation == IDoubleBondStereochemistry.Conformation.TOGETHER ? 1 : -1;
    }

    public boolean apply(int[] ints) {
        return this.test(ints);
    }

    private static enum Type {
        Tetrahedral,
        Geometric;

    }
}

