/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropMinBC
extends Propagator<IntVar> {
    private final IntVar BST;
    private final IntVar v1;
    private final IntVar v2;

    public PropMinBC(IntVar X, IntVar Y, IntVar Z) {
        super((Variable[])new IntVar[]{X, Y, Z}, (Priority)PropagatorPriority.TERNARY, false);
        this.BST = ((IntVar[])this.vars)[0];
        this.v1 = ((IntVar[])this.vars)[1];
        this.v2 = ((IntVar[])this.vars)[2];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int bst;
        boolean change;
        do {
            change = ((IntVar[])this.vars)[0].updateLowerBound(Math.min(((IntVar[])this.vars)[1].getLB(), ((IntVar[])this.vars)[2].getLB()), (ICause)this);
            change |= ((IntVar[])this.vars)[0].updateUpperBound(Math.min(((IntVar[])this.vars)[1].getUB(), ((IntVar[])this.vars)[2].getUB()), (ICause)this);
            change |= ((IntVar[])this.vars)[1].updateLowerBound(((IntVar[])this.vars)[0].getLB(), (ICause)this);
            change |= ((IntVar[])this.vars)[2].updateLowerBound(((IntVar[])this.vars)[0].getLB(), (ICause)this);
            if (((IntVar[])this.vars)[2].getLB() > ((IntVar[])this.vars)[0].getUB()) {
                change |= ((IntVar[])this.vars)[1].updateUpperBound(((IntVar[])this.vars)[0].getUB(), (ICause)this);
            }
            if (((IntVar[])this.vars)[1].getLB() <= ((IntVar[])this.vars)[0].getUB()) continue;
            change |= ((IntVar[])this.vars)[2].updateUpperBound(((IntVar[])this.vars)[0].getUB(), (ICause)this);
        } while (change);
        if (((IntVar[])this.vars)[0].isInstantiated() && (((IntVar[])this.vars)[1].isInstantiatedTo(bst = ((IntVar[])this.vars)[0].getValue()) || ((IntVar[])this.vars)[2].isInstantiatedTo(bst))) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        int lb = ((IntVar[])this.vars)[0].getLB();
        if (((IntVar[])this.vars)[1].getUB() < lb || ((IntVar[])this.vars)[2].getUB() < lb) {
            return ESat.FALSE;
        }
        if (Math.min(((IntVar[])this.vars)[1].getLB(), ((IntVar[])this.vars)[2].getLB()) > ((IntVar[])this.vars)[0].getUB()) {
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[1].getLB() < lb || ((IntVar[])this.vars)[2].getLB() < lb) {
            return ESat.UNDEFINED;
        }
        if (((IntVar[])this.vars)[0].isInstantiated() && (((IntVar[])this.vars)[1].isInstantiatedTo(lb) || ((IntVar[])this.vars)[2].isInstantiatedTo(lb))) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.BST.toString() + ".MIN(" + this.v1.toString() + "," + this.v2.toString() + ")";
    }
}

