/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.connectivity;

import java.util.BitSet;
import java.util.Iterator;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.UGVarConnectivityHelper;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropConnected
extends Propagator<UndirectedGraphVar> {
    private final int n;
    private final UndirectedGraphVar g;
    private final BitSet visited;
    private final UGVarConnectivityHelper helper;

    public PropConnected(UndirectedGraphVar graph) {
        super((Variable[])new UndirectedGraphVar[]{graph}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.n = graph.getNbMaxNodes();
        this.visited = new BitSet(this.n);
        this.helper = new UGVarConnectivityHelper(this.g);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return GraphEventType.REMOVE_EDGE.getMask() + GraphEventType.ADD_NODE.getMask() + GraphEventType.REMOVE_NODE.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.g.getPotentialNodes().size() <= 1) {
            this.setPassive();
            return;
        }
        if (this.g.getMandatoryNodes().size() > 0) {
            this.visited.clear();
            int root = this.g.getMandatoryNodes().iterator().next();
            this.helper.exploreFrom(root, this.visited);
            Iterator<Integer> iterator = this.g.getPotentialNodes().iterator();
            while (iterator.hasNext()) {
                int o = (Integer)iterator.next();
                if (this.visited.get(o)) continue;
                this.g.removeNode(o, this);
            }
            this.helper.computeMandatoryArticulationPointsAndBridges();
            iterator = this.helper.getArticulationPoints().iterator();
            while (iterator.hasNext()) {
                int ap = (Integer)iterator.next();
                this.g.enforceNode(ap, this);
            }
            for (int[] bridge : this.helper.getBridges()) {
                this.g.enforceEdge(bridge[0], bridge[1], this);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.g.getPotentialNodes().size() <= 1) {
            return ESat.TRUE;
        }
        if (this.g.getMandatoryNodes().size() < 2) {
            return ESat.UNDEFINED;
        }
        this.visited.clear();
        int root = this.g.getMandatoryNodes().iterator().next();
        this.helper.exploreFrom(root, this.visited);
        ISetIterator iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.visited.get(i)) continue;
            return ESat.FALSE;
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

