/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evolution.tree.Tree;
import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.ARGTree;
import dr.evomodel.arg.OldTreeLogger;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.coalescent.structure.ColourSamplerModel;
import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.MCLogger;
import dr.inference.loggers.MLLogger;
import dr.inference.loggers.TabDelimitedFormatter;
import dr.inference.model.Likelihood;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class ARGTreeLogger
extends OldTreeLogger {
    public static final String LOG_ARG = "logArgTree";
    public static final String PARTITION = "partition";
    private int partition;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("logEvery"), AttributeRule.newIntegerRule("partition"), new StringAttributeRule("fileName", "The name of the file to send log output to. If no file name is specified then log is sent to standard output", true), new StringAttributeRule("title", "The title of the log", true), AttributeRule.newBooleanRule("nexusFormat", true, "Whether to use the NEXUS format for the tree log"), new StringAttributeRule("branchLengths", "What units should the branch lengths be in", new String[]{"time", "substitutions"}, true), new ElementRule(ARGModel.class, "The ARG which is to be logged"), new ElementRule(BranchRateModel.class, true), new ElementRule(ColourSamplerModel.class, true), new ElementRule(Likelihood.class, true)};

        @Override
        public String getParserName() {
            return ARGTreeLogger.LOG_ARG;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Object object;
            Object object2;
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            String string = null;
            String string2 = null;
            boolean bl = false;
            String string3 = "demes";
            String string4 = "rate";
            String string5 = "lnP";
            if (xMLObject.hasAttribute("title")) {
                string2 = xMLObject.getStringAttribute("title");
            }
            if (xMLObject.hasAttribute("fileName")) {
                string = xMLObject.getStringAttribute("fileName");
            }
            if (xMLObject.hasAttribute("nexusFormat")) {
                bl = xMLObject.getBooleanAttribute("nexusFormat");
            }
            boolean bl2 = false;
            if (xMLObject.hasAttribute("branchLengths")) {
                bl2 = xMLObject.getStringAttribute("branchLengths").equals("substitutions");
            }
            BranchRateModel branchRateModel = (BranchRateModel)xMLObject.getChild(BranchRateModel.class);
            ColourSamplerModel colourSamplerModel = (ColourSamplerModel)xMLObject.getChild(ColourSamplerModel.class);
            Likelihood likelihood = (Likelihood)xMLObject.getChild(Likelihood.class);
            int n = 1;
            if (xMLObject.hasAttribute("logEvery")) {
                n = xMLObject.getIntegerAttribute("logEvery");
            }
            int n2 = 0;
            if (xMLObject.hasAttribute(ARGTreeLogger.PARTITION)) {
                n2 = xMLObject.getIntegerAttribute(ARGTreeLogger.PARTITION);
            }
            if (n2 > aRGModel.getMaxPartitionNumber()) {
                throw new XMLParseException("ARGModel does not contain a partition #" + n2);
            }
            PrintWriter printWriter = null;
            if (string != null) {
                try {
                    object2 = new File(string);
                    object = ((File)object2).getName();
                    String string6 = ((File)object2).getParent();
                    if (!((File)object2).isAbsolute()) {
                        string6 = System.getProperty("user.dir");
                    }
                    printWriter = new PrintWriter(new FileOutputStream(new File(string6, (String)object)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
                }
            } else {
                printWriter = new PrintWriter(System.out);
            }
            object2 = new TabDelimitedFormatter(printWriter);
            object = new ARGTreeLogger(aRGModel, n2, branchRateModel, string4, colourSamplerModel, string3, likelihood, string5, (LogFormatter)object2, n, bl, bl2);
            if (string2 != null) {
                ((MCLogger)object).setTitle(string2);
            }
            return object;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Logs a tree to a file";
        }

        @Override
        public String getExample() {
            return "<!-- The " + this.getParserName() + " element takes an argTreeModel to be logged -->\n<" + this.getParserName() + " " + "logEvery" + "=\"100\" " + "fileName" + "=\"log.trees\" " + "nexusFormat" + "=\"true\">\n\t<treeModel idref=\"treeModel1\"/>\n</" + this.getParserName() + ">\n";
        }

        @Override
        public Class getReturnType() {
            return MLLogger.class;
        }
    };

    public ARGTreeLogger(Tree tree, int n, BranchRateModel branchRateModel, String string, ColourSamplerModel colourSamplerModel, String string2, Likelihood likelihood, String string3, LogFormatter logFormatter, int n2, boolean bl, boolean bl2) {
        super(tree, branchRateModel, string, colourSamplerModel, string2, likelihood, string3, logFormatter, n2, bl, bl2);
        this.partition = n;
    }

    @Override
    protected String additionalInfo() {
        return " [&PARTITION=" + this.partition + "] [&YULE=" + this.getLogYuleProbabilityString() + "] [&NUM_REC=" + this.getNumberOfReassortments() + "]";
    }

    private int getNumberOfReassortments() {
        ARGModel aRGModel = (ARGModel)this.getTree();
        return aRGModel.getReassortmentNodeCount();
    }

    private String getLogYuleProbabilityString() {
        ARGTree aRGTree = new ARGTree((ARGModel)this.getTree(), this.partition);
        double d = 0.0;
        int n = aRGTree.getNodeCount();
        for (int i = 0; i < n; ++i) {
            ARGModel.Node node = (ARGModel.Node)aRGTree.getNode(i);
            int n2 = node.getDescendentTipCount();
            if (n2 <= 2) continue;
            d -= 2.0 * Math.log(n2 - 1);
        }
        return String.format("%5.4f", d);
    }

    @Override
    protected Tree getPrintTree() {
        return new ARGTree((ARGModel)this.getTree(), this.partition);
    }

    @Override
    protected boolean useTaxonLabels() {
        return true;
    }
}

