/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIaqjms {
    int aqjmshdrpcnt;
    byte[] aqjmshdrprop;
    int aqjmsusrprpcnt;
    byte[] aqjmsuserprop;
    int aqjmsflags = 1;
    T4CMAREngine mar;

    T4CTTIaqjms(T4CConnection t4CConnection) {
        this.mar = t4CConnection.mare;
    }

    void marshal() throws IOException {
        this.mar.marshalUB4(this.aqjmshdrpcnt);
        if (this.aqjmshdrprop != null && this.aqjmshdrprop.length != 0) {
            this.mar.marshalSWORD(this.aqjmshdrprop.length);
            this.mar.marshalCLR(this.aqjmshdrprop, 0, this.aqjmshdrprop.length);
        } else {
            this.mar.marshalSWORD(0);
        }
        this.mar.marshalUB4(this.aqjmsusrprpcnt);
        if (this.aqjmsuserprop != null && this.aqjmsuserprop.length != 0) {
            this.mar.marshalSWORD(this.aqjmsuserprop.length);
            this.mar.marshalCLR(this.aqjmsuserprop, 0, this.aqjmsuserprop.length);
        } else {
            this.mar.marshalSWORD(0);
        }
        this.mar.marshalUB4(this.aqjmsflags);
    }

    void receive() throws SQLException, IOException {
        this.aqjmshdrpcnt = (int)this.mar.unmarshalUB4();
        int n2 = this.mar.unmarshalSWORD();
        if (n2 > 0) {
            this.aqjmshdrprop = new byte[n2];
            int[] nArray = new int[1];
            this.mar.unmarshalCLR(this.aqjmshdrprop, 0, nArray, n2);
        } else {
            this.aqjmshdrprop = null;
        }
        this.aqjmsusrprpcnt = (int)this.mar.unmarshalUB4();
        int n3 = this.mar.unmarshalSWORD();
        if (n3 > 0) {
            this.aqjmsuserprop = new byte[n3];
            int[] nArray = new int[1];
            this.mar.unmarshalCLR(this.aqjmsuserprop, 0, nArray, n3);
        } else {
            this.aqjmsuserprop = null;
        }
        this.aqjmsflags = (int)this.mar.unmarshalUB4();
    }
}

