/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.plots.ParamStatSummary;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class ParamStatSummaryWidget
extends ParamWidget
implements ActionListener {
    private JLabel modelLabel;
    private JComboBox methodCombo;
    private JTextField multField;
    private JTextPane dataText;
    private JScrollPane jScrollPane3;
    private JPanel jPanel3;
    private JTextPane ymaxText;
    private JScrollPane jScrollPane2;
    private JPanel jPanel2;
    private JTextPane yminText;
    private JScrollPane jScrollPane1;
    private JPanel jPanel1;
    private JTextPane yText;
    private JScrollPane scroller1;
    private JPanel jPanel0;
    private JTextField simSizeField;
    private JLabel simulationLabel;
    private JLabel sdMultLabel;
    private JTextField confidenceField;
    private JLabel confidenceLabel;

    public ParamStatSummaryWidget() {
        this.initGUI();
        this.updateView();
    }

    public ParamStatSummaryWidget(ParamStatSummary paramStatSummary) {
        this();
        this.setModel(paramStatSummary);
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(199, 536));
            this.setMinimumSize(new Dimension(140, 536));
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.jPanel0 = new JPanel();
            Serializable serializable = new BorderLayout();
            this.jPanel0.setLayout((LayoutManager)((Object)serializable));
            this.add((Component)this.jPanel0, new AnchorConstraint(61, 1002, 343, 2, 2, 1, 0, 1));
            this.jPanel0.setPreferredSize(new Dimension(199, 107));
            this.jPanel0.setBorder(BorderFactory.createTitledBorder("y function"));
            this.scroller1 = new JScrollPane();
            this.jPanel0.add((Component)this.scroller1, "Center");
            this.yText = new JTextPane();
            this.scroller1.setViewportView(this.yText);
            this.modelLabel = new JLabel();
            this.add((Component)this.modelLabel, new AnchorConstraint(12, 263, 68, 0, 2, 0, 0, 2));
            this.modelLabel.setText("Method");
            this.modelLabel.setHorizontalAlignment(11);
            this.modelLabel.setPreferredSize(new Dimension(52, 15));
            serializable = new DefaultComboBoxModel<String>(new String[]{"Mean with standard deviation limits (mean_sdl)", "Mean with confidence interval (mean_cl_normal)", "Median  with quantile limits (median_hilow)", "Bootstrap mean with confidence interval (mean_cl_boot)", "Custom"});
            this.methodCombo = new JComboBox();
            this.add((Component)this.methodCombo, new AnchorConstraint(21, 0, 75, 58, 1, 2, 0, 2));
            this.methodCombo.setModel(serializable);
            this.methodCombo.setPreferredSize(new Dimension(141, 22));
            this.methodCombo.addActionListener(this);
            this.jPanel1 = new JPanel();
            this.add((Component)this.jPanel1, new AnchorConstraint(180, 1002, 343, 2, 2, 1, 0, 1));
            serializable = new BorderLayout();
            this.jPanel1.setPreferredSize(new Dimension(199, 107));
            this.jPanel1.setBorder(BorderFactory.createTitledBorder("y-min function"));
            this.jPanel1.setLayout((LayoutManager)((Object)serializable));
            this.jScrollPane1 = new JScrollPane();
            this.jPanel1.add((Component)this.jScrollPane1, "Center");
            this.yminText = new JTextPane();
            this.jScrollPane1.setViewportView(this.yminText);
            this.jPanel2 = new JPanel();
            this.add((Component)this.jPanel2, new AnchorConstraint(293, 1002, 343, 2, 2, 1, 0, 1));
            serializable = new BorderLayout();
            this.jPanel2.setPreferredSize(new Dimension(199, 107));
            this.jPanel2.setBorder(BorderFactory.createTitledBorder("y-max function"));
            this.jPanel2.setLayout((LayoutManager)((Object)serializable));
            this.jScrollPane2 = new JScrollPane();
            this.jPanel2.add((Component)this.jScrollPane2, "Center");
            this.ymaxText = new JTextPane();
            this.jScrollPane2.setViewportView(this.ymaxText);
            this.jPanel3 = new JPanel();
            this.add((Component)this.jPanel3, new AnchorConstraint(406, 1002, 343, 2, 2, 1, 0, 1));
            serializable = new BorderLayout();
            this.jPanel3.setPreferredSize(new Dimension(199, 107));
            this.jPanel3.setBorder(BorderFactory.createTitledBorder("data function"));
            this.jPanel3.setLayout((LayoutManager)((Object)serializable));
            this.jScrollPane3 = new JScrollPane();
            this.jPanel3.add((Component)this.jScrollPane3, "Center");
            this.dataText = new JTextPane();
            this.jScrollPane3.setViewportView(this.dataText);
            this.confidenceLabel = new JLabel();
            this.add((Component)this.confidenceLabel, new AnchorConstraint(42, 711, 142, 2, 2, 1, 0, 1));
            this.confidenceLabel.setText("Confidence Level");
            this.confidenceLabel.setHorizontalAlignment(11);
            this.confidenceLabel.setPreferredSize(new Dimension(141, 15));
            this.confidenceField = new JTextField();
            this.add((Component)this.confidenceField, new AnchorConstraint(38, 992, 150, 771, 2, 1, 0, 1));
            this.confidenceField.setToolTipText("Confidence level for confidence interval");
            this.confidenceField.setPreferredSize(new Dimension(44, 22));
            this.confidenceField.setHorizontalAlignment(0);
            this.sdMultLabel = new JLabel();
            this.add((Component)this.sdMultLabel, new AnchorConstraint(70, 711, 212, 2, 2, 1, 0, 1));
            this.sdMultLabel.setText("Std. Multiplier");
            this.sdMultLabel.setHorizontalAlignment(11);
            this.sdMultLabel.setPreferredSize(new Dimension(141, 15));
            this.multField = new JTextField();
            this.add((Component)this.multField, new AnchorConstraint(66, 992, 219, 771, 2, 1, 0, 1));
            this.multField.setToolTipText("Limits defined by ___ times the computed standard deviation");
            this.multField.setPreferredSize(new Dimension(44, 22));
            this.multField.setHorizontalAlignment(0);
            this.simulationLabel = new JLabel();
            this.add((Component)this.simulationLabel, new AnchorConstraint(97, 711, 279, 2, 2, 1, 0, 1));
            this.simulationLabel.setText("Simulation size");
            this.simulationLabel.setHorizontalAlignment(11);
            this.simulationLabel.setPreferredSize(new Dimension(141, 15));
            this.simSizeField = new JTextField();
            this.add((Component)this.simSizeField, new AnchorConstraint(93, 992, 286, 771, 2, 1, 0, 1));
            this.simSizeField.setToolTipText("Sample size for bootstrap simulation");
            this.simSizeField.setPreferredSize(new Dimension(44, 22));
            this.simSizeField.setHorizontalAlignment(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateView() {
        int n = this.methodCombo.getSelectedIndex();
        if (n == 4) {
            this.confidenceLabel.setVisible(false);
            this.confidenceField.setVisible(false);
            this.sdMultLabel.setVisible(false);
            this.multField.setVisible(false);
            this.simulationLabel.setVisible(false);
            this.simSizeField.setVisible(false);
            this.jPanel3.setVisible(true);
            this.jPanel2.setVisible(true);
            this.jPanel1.setVisible(true);
            this.jPanel0.setVisible(true);
        } else {
            this.jPanel3.setVisible(false);
            this.jPanel2.setVisible(false);
            this.jPanel1.setVisible(false);
            this.jPanel0.setVisible(false);
        }
        if (n == 0) {
            this.confidenceLabel.setVisible(false);
            this.confidenceField.setVisible(false);
            this.sdMultLabel.setVisible(true);
            this.multField.setVisible(true);
            this.simulationLabel.setVisible(false);
            this.simSizeField.setVisible(false);
        }
        if (n == 1) {
            this.confidenceLabel.setVisible(true);
            this.confidenceField.setVisible(true);
            this.confidenceField.setToolTipText("Confidence level for confidence interval");
            this.sdMultLabel.setVisible(false);
            this.multField.setVisible(false);
            this.simulationLabel.setVisible(false);
            this.simSizeField.setVisible(false);
        }
        if (n == 2) {
            this.confidenceLabel.setVisible(true);
            this.confidenceField.setVisible(true);
            this.confidenceField.setToolTipText("Quantile limits. For example, .95 gives limits with 2.5% ofobservations below the lower limit, and 2.5% above the upper limit");
            this.sdMultLabel.setVisible(false);
            this.multField.setVisible(false);
            this.simulationLabel.setVisible(false);
            this.simSizeField.setVisible(false);
        }
        if (n == 3) {
            this.confidenceLabel.setVisible(true);
            this.confidenceField.setVisible(true);
            this.confidenceField.setToolTipText("Confidence level for confidence interval");
            this.sdMultLabel.setVisible(false);
            this.multField.setVisible(false);
            this.simulationLabel.setVisible(true);
            this.simSizeField.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateView();
    }

    public void setModel(Param param) {
        this.model = param;
        if (param.getValue() != null) {
            Vector vector = (Vector)param.getValue();
            this.methodCombo.setSelectedIndex((Integer)vector.get(0));
            this.confidenceField.setText(vector.get(1).toString());
            this.multField.setText(vector.get(2).toString());
            this.simSizeField.setText(vector.get(3).toString());
            this.yText.setText(vector.get(4).toString());
            this.yminText.setText(vector.get(5).toString());
            this.ymaxText.setText(vector.get(6).toString());
            this.dataText.setText(vector.get(7).toString());
        }
    }

    public void updateModel() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Integer(this.methodCombo.getSelectedIndex()));
        vector.add(this.confidenceField.getText());
        vector.add(this.multField.getText());
        vector.add(this.simSizeField.getText());
        vector.add(this.yText.getText());
        vector.add(this.yminText.getText());
        vector.add(this.ymaxText.getText());
        vector.add(this.dataText.getText());
        this.model.setValue(vector);
    }
}

