/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import giny.model.Edge;
import giny.model.Node;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.WeakHashMap;
import uk.ac.rhul.cs.cl1.ui.cytoscape.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.Graph;
import uk.ac.rhul.cs.cl1.ui.cytoscape.NonNumericAttributeException;
import uk.ac.rhul.cs.utils.ObjectUtils;
import uk.ac.rhul.cs.utils.Pair;
import uk.ac.rhul.cs.utils.UniqueIDGenerator;

public class CyNetworkCache
implements PropertyChangeListener {
    WeakHashMap<CyNetwork, Pair<String, Graph>> storage = new WeakHashMap();

    public CyNetworkCache() {
        Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener("NETWORK_MODIFIED", this);
        Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener(Cytoscape.NETWORK_DESTROYED, this);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public Graph convertCyNetworkToGraph(CyNetwork network, String weightAttr) throws NonNumericAttributeException {
        Pair<String, Graph> attrNameAndGraph = this.storage.get(network);
        if (attrNameAndGraph != null && ObjectUtils.equals(weightAttr, attrNameAndGraph.getLeft())) {
            return attrNameAndGraph.getRight();
        }
        Graph graph = new Graph();
        UniqueIDGenerator<Node> nodeIdGen = new UniqueIDGenerator<Node>(graph);
        CyAttributes edgeAttrs = Cytoscape.getEdgeAttributes();
        try {
            Iterator it = network.edgesIterator();
            while (it.hasNext()) {
                Double weight;
                int dest;
                Edge edge = (Edge)it.next();
                int src = nodeIdGen.get(edge.getSource());
                if (src == (dest = nodeIdGen.get(edge.getTarget()))) continue;
                Double d = weight = weightAttr == null ? null : (Double)edgeAttrs.getAttribute(edge.getIdentifier(), weightAttr);
                if (weight == null) {
                    weight = 1.0;
                }
                graph.createEdge(src, dest, weight);
            }
        }
        catch (ClassCastException ex) {
            throw new NonNumericAttributeException(weightAttr);
        }
        graph.setNodeMapping(nodeIdGen.getReversedList());
        this.storage.put(network, Pair.create(weightAttr, graph));
        return graph;
    }

    public Graph convertCyNetworkToGraph(CyNetwork network) throws NonNumericAttributeException {
        ControlPanel panel = ControlPanel.getShownInstance();
        if (panel == null) {
            return this.convertCyNetworkToGraph(network, null);
        }
        return this.convertCyNetworkToGraph(network, panel.getWeightAttributeName());
    }

    public void invalidate(CyNetwork network) {
        this.storage.remove(network);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("NETWORK_MODIFIED")) {
            this.invalidate((CyNetwork)e.getNewValue());
        } else if (e.getPropertyName().equals(Cytoscape.NETWORK_DESTROYED)) {
            String value = (String)e.getNewValue();
            for (CyNetwork network : this.storage.keySet()) {
                if (!network.getTitle().equals(value)) continue;
                this.invalidate(network);
            }
        }
    }
}

