/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.ui.NodeSetTableModel;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeApp;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CyNetworkUtil;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CytoscapeResultViewerPanel;

public class FindAction
extends AbstractAction {
    protected CytoscapeResultViewerPanel resultViewer;

    public FindAction(CytoscapeResultViewerPanel panel) {
        super("Find clusters of this node");
        this.resultViewer = panel;
        this.putValue("MnemonicKey", 70);
        this.putValue("ShortDescription", "Select all the clusters corresponding to the selected nodes in the result panel");
        ClusterONECytoscapeApp app = this.resultViewer.getCytoscapeApp();
        URL url = app.getResource(app.getResourcePathName() + "/find.png");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
    }

    public void actionPerformed(ActionEvent event) {
        CyNetwork network = this.resultViewer.getNetwork();
        if (network == null) {
            return;
        }
        List<CyNode> selectedNodes = CyNetworkUtil.getSelectedNodes(network);
        List<CyNode> nodeMapping = this.resultViewer.getNodeMapping();
        HashSet<Integer> selectedIndices = new HashSet<Integer>();
        for (CyNode node : selectedNodes) {
            int pos = nodeMapping.indexOf(node);
            if (pos < 0) continue;
            selectedIndices.add(pos);
        }
        ArrayList<Integer> selectedRowIndices = new ArrayList<Integer>();
        NodeSetTableModel model = this.resultViewer.getTableModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            NodeSet nodeSet = model.getNodeSetByIndex(row);
            if (!nodeSet.containsAny(selectedIndices)) continue;
            selectedRowIndices.add(row);
        }
        this.resultViewer.setSelectedNodeSetIndices(selectedRowIndices);
    }
}

