/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule.extend;

import eu.kliegr.ac1.data.Attribute;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.Transaction;
import eu.kliegr.ac1.performance.StopWatches;
import eu.kliegr.ac1.rule.Antecedent;
import eu.kliegr.ac1.rule.Consequent;
import eu.kliegr.ac1.rule.Data;
import eu.kliegr.ac1.rule.Rule;
import eu.kliegr.ac1.rule.RuleMultiItem;
import eu.kliegr.ac1.rule.extend.DefaultRuleOverlapPruningType;
import eu.kliegr.ac1.rule.extend.ExtendRule;
import eu.kliegr.ac1.rule.extend.ExtendRuleConfig;
import eu.kliegr.ac1.rule.extend.ExtendType;
import eu.kliegr.ac1.rule.extend.History;
import eu.kliegr.ac1.rule.extend.PostPruningType;
import eu.kliegr.ac1.rule.extend.ValueOrigin;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ExtendRules {
    private static final Logger LOGGER = Logger.getLogger(ExtendRules.class.getName());
    private final List<ExtendRule> seedRules;
    private List<ExtendRule> extendedRules;
    private final Comparator ruleComparator;
    private final ExtendType type;
    private final Data data;

    public ExtendRules(ArrayList<Rule> rules, Comparator ruleComparator, ExtendType type, ExtendRuleConfig extConf, Data data) {
        this.type = type;
        this.ruleComparator = ruleComparator;
        this.data = data;
        this.seedRules = rules.stream().map(rule -> new ExtendRule((Rule)rule, null, type, extConf)).collect(Collectors.toCollection(() -> Collections.synchronizedList(new ArrayList())));
        LOGGER.log(Level.INFO, "Rules loaded: {0}", this.seedRules.size());
    }

    public List<ExtendRule> getSeedRules() {
        return Collections.unmodifiableList(this.seedRules);
    }

    public List<ExtendRule> getExtendedRules() {
        return Collections.unmodifiableList(this.extendedRules);
    }

    public void sortRules() {
        this.seedRules.sort(this.ruleComparator);
    }

    public void annotateRules() {
        ArrayList<Consequent> consequents = this.generateConsequents();
        AtomicInteger i = new AtomicInteger(0);
        this.extendedRules.parallelStream().forEach(rule -> {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Starting annotation of rule:{0}", rule.getRID());
            }
            if (rule == null) {
                LOGGER.severe("Rule object is null, this should not happen, skipping");
            } else {
                rule.generateAnnotation(consequents);
            }
            i.getAndAdd(1);
            LOGGER.log(Level.INFO, "Rules already annotated:{0} ; out of {1}", new Object[]{i, this.extendedRules.size()});
        });
    }

    private ArrayList<Consequent> generateConsequents() {
        ArrayList<AttributeValue> cons = new ArrayList<AttributeValue>(this.data.getValuesOfTargetAttribute());
        ArrayList consOrigin = new ArrayList();
        cons.stream().forEach(value -> consOrigin.add(ValueOrigin.consequent));
        ArrayList<Consequent> consequents = new ArrayList<Consequent>();
        cons.stream().forEach(value -> {
            ArrayList<AttributeValue> valuesInConsequent = new ArrayList<AttributeValue>();
            valuesInConsequent.add((AttributeValue)value);
            RuleMultiItem consNewCons = this.data.makeRuleItem(valuesInConsequent, consOrigin, value.getAttribute(), ValueOrigin.fakeConsequent);
            consequents.add(new Consequent(consNewCons));
        });
        return consequents;
    }

    public void processRules(boolean isAttRemovalEnabled, boolean isTrimmingEnabled, boolean isContinuousPruningEnabled, boolean isFuzzificationEnabled, PostPruningType postpruningType, DefaultRuleOverlapPruningType defaultRuleOverlapPruningType) {
        LOGGER.info("STARTED Extension phase\n");
        AtomicInteger processedRules = new AtomicInteger(0);
        int lastRuleRID = this.seedRules.get(this.seedRules.size() - 1).getRID();
        this.extendedRules = new ArrayList<ExtendRule>();
        for (ExtendRule rule : this.seedRules) {
            LOGGER.log(Level.INFO, "Rules already processed:{0}  out of {1}", new Object[]{processedRules.addAndGet(1), this.seedRules.size()});
            int antLength = rule.getAntecedent().getItems().size();
            if (antLength == 0) {
                if (rule.getRID() == lastRuleRID) {
                    LOGGER.info("Removing default rule ");
                    continue;
                }
                LOGGER.severe("Unexpected rule with empty antecedent on other than last position, leaving out this rule");
                continue;
            }
            if (rule.getRID() == lastRuleRID) {
                LOGGER.severe("Last rule is expected to be a default rule with empty antecedent");
            }
            if (isAttRemovalEnabled) {
                LOGGER.info("STARTED removeRedundantAttributes ");
                rule = rule.removeRedundantAttributes();
                LOGGER.info("FINISHED removeRedundantAttributes ");
            }
            if (rule.getAntecedent().getItems().size() == 0) {
                LOGGER.info("REMOVING DEFAULT RULE CREATED BY removeRedundantAttributes ");
                continue;
            }
            if (isTrimmingEnabled) {
                rule = rule.trim();
            }
            if (this.type != ExtendType.noExtend) {
                rule = rule.extend();
            }
            if (isFuzzificationEnabled) {
                rule = rule.addFuzzyBorders();
            }
            if (isContinuousPruningEnabled) {
                int transRemoved = rule.removeTransactionsCoveredByAntecedent(true);
                LOGGER.log(Level.INFO, "Removed {0} supporting transactions", transRemoved);
                if (transRemoved == 0) continue;
            }
            this.extendedRules.add(rule);
        }
        LOGGER.info("FINISHED PHASE 1 phase\n");
        if (isContinuousPruningEnabled) {
            this.data.getDataTable().unhideAllTransactions();
        }
        LOGGER.info("STARTED updating rule quality\n");
        this.extendedRules.stream().forEach(r -> r.updateQuality());
        LOGGER.info("FINISHED updating rule quality\n");
        this.extendedRules.sort(this.ruleComparator);
        if (postpruningType != PostPruningType.none) {
            LOGGER.info("STARTED POST PRUNING phase\n");
            LOGGER.info("STARTED Resorting rules\n");
            LOGGER.info("FINISHED Resorting rules\n");
            LOGGER.log(Level.INFO, "Rules before pruning (default rule, if any, was removed):{0}", this.extendedRules.size());
            if (postpruningType == PostPruningType.cba) {
                this.pruneRules_cbaLike();
            } else if (postpruningType == PostPruningType.greedy) {
                this.pruneRules_greedy();
            }
            this.data.getDataTable().unhideAllTransactions();
            LOGGER.log(Level.INFO, "Rules after pruning (with default rule):{0}", this.extendedRules.size());
            LOGGER.info("FINISHED PRUNING phase\n");
        } else {
            ExtendRule finalDefRule = this.createNewDefaultRule(this.getDefaultRuleClass());
            this.extendedRules.add(finalDefRule);
        }
        if (defaultRuleOverlapPruningType == DefaultRuleOverlapPruningType.transactionBased | defaultRuleOverlapPruningType == DefaultRuleOverlapPruningType.rangeBased) {
            if (defaultRuleOverlapPruningType == DefaultRuleOverlapPruningType.transactionBased) {
                this.extendedRules = ExtendRules.removeRedundantExtendedRules_transactionBased(this.extendedRules);
                this.data.getDataTable().unhideAllTransactions();
            } else {
                this.extendedRules = ExtendRules.removeRedundantExtendedRules_rangeBased(this.extendedRules);
            }
        }
    }

    public void saveSummary(String path, StopWatches watches) throws FileNotFoundException, IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
        ((OutputStream)output).write(("Number of rules to extend:" + this.seedRules.size() + "\n").getBytes());
        ((OutputStream)output).write(("Number of extended rules :" + this.extendedRules.size() + "\n").getBytes());
        ((OutputStream)output).write(watches.toString().getBytes());
        ((OutputStream)output).flush();
        ((OutputStream)output).close();
    }

    public void pruneRules_greedy() {
        LOGGER.info("STARTED Postpruning");
        AttributeValue defClass = this.getDefaultRuleClass();
        int defError = this.getDefaultRuleError(defClass);
        boolean removeTail = false;
        Iterator<ExtendRule> it = this.extendedRules.iterator();
        while (it.hasNext()) {
            ExtendRule rule = it.next();
            rule.updateQuality();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "#Rule {0}", rule.toString());
            }
            if (removeTail) {
                it.remove();
                continue;
            }
            if (rule.getAntecedentLength() == 0) {
                it.remove();
                continue;
            }
            if (rule.getRuleQuality().getA() == 0) {
                it.remove();
                continue;
            }
            int supportingTransactions = rule.removeTransactionsCoveredByAntecedent(true);
            AttributeValue newDefClass = this.getDefaultRuleClass();
            int newDefError = this.getDefaultRuleError(newDefClass);
            if (defError <= newDefError) {
                it.remove();
                removeTail = true;
                continue;
            }
            LOGGER.log(Level.FINE, "{0} transactions, RULE {1} KEPT", new Object[]{supportingTransactions, rule.getRID()});
            defClass = newDefClass;
            defError = newDefError;
        }
        LOGGER.fine("Creating new Extend rule within narrow rule procedure");
        this.extendedRules.add(this.createNewDefaultRule(defClass));
        LOGGER.info("FINISHED Postpruning");
    }

    public void pruneRules_cbaLike() {
        LOGGER.info("STARTED Postpruning");
        ArrayList<ExtendRule> rulesToRemove = new ArrayList<ExtendRule>();
        int totalErrorsWithoutDefault = 0;
        AttributeValue defClassForLowestTotalErrorsRule = this.getDefaultRuleClass();
        int lowestTotalErrors = this.getDefaultRuleError(defClassForLowestTotalErrorsRule);
        ExtendRule lowestTotalErrorsRule = null;
        for (ExtendRule rule : this.extendedRules) {
            rule.updateQuality();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Processing rule {0}", rule.toString());
            }
            if (rule.getAntecedentLength() == 0) {
                LOGGER.fine("Rule of length 0, MARKED FOR REMOVAL");
                rulesToRemove.add(rule);
                continue;
            }
            if (rule.getRuleQuality().getA() == 0) {
                LOGGER.fine("Rule classifying 0 instances correctly, MARKED FOR REMOVAL");
                rulesToRemove.add(rule);
                continue;
            }
            rule.removeTransactionsCoveredByAntecedent(true);
            AttributeValue newDefClass = this.getDefaultRuleClass();
            int newDefError = this.getDefaultRuleError(newDefClass);
            int totalErrorWithDefault = newDefError + (totalErrorsWithoutDefault += rule.getRuleQuality().getB().intValue());
            if (totalErrorWithDefault >= lowestTotalErrors) continue;
            lowestTotalErrors = totalErrorWithDefault;
            lowestTotalErrorsRule = rule;
            defClassForLowestTotalErrorsRule = newDefClass;
        }
        boolean removeTail = lowestTotalErrorsRule == null;
        this.data.getDataTable().unhideAllTransactions();
        Iterator<ExtendRule> it = this.extendedRules.iterator();
        while (it.hasNext()) {
            ExtendRule rule = it.next();
            if (rulesToRemove.contains(rule) || removeTail) {
                it.remove();
                continue;
            }
            if (rule.equals(lowestTotalErrorsRule)) {
                removeTail = true;
            }
            rule.updateQuality();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating new default rule within narrow rule procedure");
        }
        this.extendedRules.add(this.createNewDefaultRule(defClassForLowestTotalErrorsRule));
        LOGGER.info("FINISHED Postpruning");
    }

    public static List<ExtendRule> removeRedundantExtendedRules_transactionBased(List<ExtendRule> rules) {
        LOGGER.info("STARTED removeRedundantExtendedRules - transaction based");
        LOGGER.info("Rules on start:" + rules.size());
        ExtendRule defRule = rules.get(rules.size() - 1);
        if (defRule.getAntecedent().getItems().size() > 0) {
            LOGGER.warning("Default rule is not last rule. Returning null. Last rule:" + defRule.toString());
            return null;
        }
        Consequent defClass = defRule.getConsequent();
        Iterator<ExtendRule> it = rules.iterator();
        while (it.hasNext()) {
            ExtendRule PRCandidate = it.next();
            if (!PRCandidate.getConsequent().toString().equals(defClass.toString()) || PRCandidate.equals(defRule)) continue;
            Set<Transaction> suppTran = PRCandidate.getAntecedent().getSupportingTransactions();
            Set<Transaction> consTran = PRCandidate.getConsequent().getSupportingTransactions();
            suppTran.retainAll(consTran);
            boolean nonEmptyIntersection = false;
            boolean positionBelowPRCand = false;
            for (ExtendRule candidateClash : rules) {
                Transaction t;
                if (candidateClash.equals(PRCandidate)) {
                    positionBelowPRCand = true;
                    continue;
                }
                if (!positionBelowPRCand || candidateClash.getConsequent().toString().equals(defClass.toString())) continue;
                Iterator<Transaction> iterator = candidateClash.getAntecedent().getSupportingTransactions().iterator();
                if (iterator.hasNext() && suppTran.contains(t = iterator.next())) {
                    nonEmptyIntersection = true;
                }
                if (!nonEmptyIntersection) continue;
                break;
            }
            if (nonEmptyIntersection) continue;
            LOGGER.fine("Removing rule:" + PRCandidate.toString());
            it.remove();
        }
        LOGGER.info("Rules on finish:" + rules.size());
        LOGGER.info("FINISHED removeRedundantExtendedRules - transaction based");
        return rules;
    }

    public static List<ExtendRule> removeRedundantExtendedRules_rangeBased(List<ExtendRule> rules) {
        LOGGER.info("STARTED removeRedundantExtendedRules - range based");
        LOGGER.info("Rules on start:" + rules.size());
        ExtendRule defRule = rules.get(rules.size() - 1);
        Consequent defClass = defRule.getConsequent();
        Iterator<ExtendRule> it = rules.iterator();
        while (it.hasNext()) {
            ExtendRule PRCandidate = it.next();
            if (!PRCandidate.getConsequent().toString().equals(defClass.toString()) || PRCandidate.equals(defRule)) continue;
            ArrayList<RuleMultiItem> PR_items = PRCandidate.getAntecedent().getItems();
            HashMap<Attribute, RuleMultiItem> PR_itemsMap = new HashMap<Attribute, RuleMultiItem>();
            for (RuleMultiItem rmi : PR_items) {
                PR_itemsMap.put(rmi.getAttribute(), rmi);
            }
            boolean clashingRuleFound = false;
            boolean positionBelowPRCand = false;
            for (ExtendRule candidateClash : rules) {
                if (candidateClash.equals(PRCandidate)) {
                    positionBelowPRCand = true;
                    continue;
                }
                if (candidateClash.getConsequent().toString().equals(defClass.toString()) || !positionBelowPRCand) continue;
                ArrayList<RuleMultiItem> literalsInClashOnSharedAtt = new ArrayList<RuleMultiItem>();
                for (RuleMultiItem clash_rmi : candidateClash.getAntecedent().getItems()) {
                    if (!PR_itemsMap.containsKey(clash_rmi.getAttribute())) continue;
                    literalsInClashOnSharedAtt.add(clash_rmi);
                }
                if (literalsInClashOnSharedAtt.isEmpty()) {
                    clashingRuleFound = true;
                    break;
                }
                boolean attLeastOneAttDisjunct = true;
                for (RuleMultiItem clash_rmi : literalsInClashOnSharedAtt) {
                    RuleMultiItem machingPR_RMI = (RuleMultiItem)PR_itemsMap.get(clash_rmi.getAttribute());
                    for (AttributeValue v : machingPR_RMI.getAttributeValues()) {
                        if (!clash_rmi.getAttributeValues().contains(v)) continue;
                        attLeastOneAttDisjunct = false;
                    }
                    if (!attLeastOneAttDisjunct) continue;
                    break;
                }
                if (attLeastOneAttDisjunct) continue;
                clashingRuleFound = true;
            }
            if (clashingRuleFound) continue;
            LOGGER.fine("Removing rule:" + PRCandidate.toString());
            it.remove();
        }
        LOGGER.info("Rules on finish:" + rules.size());
        LOGGER.info("FINISHED removeRedundantExtendedRules - range based");
        return rules;
    }

    private ExtendRule createNewDefaultRule(AttributeValue conval) {
        ArrayList<AttributeValue> conValues = new ArrayList<AttributeValue>();
        ArrayList<ValueOrigin> origin = new ArrayList<ValueOrigin>();
        conValues.add(conval);
        origin.add(ValueOrigin.consequent);
        Consequent consequent = new Consequent(this.data.makeRuleItem(conValues, origin, conval.getAttribute(), ValueOrigin.fakeConsequent));
        ArrayList<RuleMultiItem> emptyAntecedent = new ArrayList<RuleMultiItem>();
        Rule r = new Rule(new Antecedent(emptyAntecedent), consequent, null, null, -2, -2, this.data);
        ExtendRule finalDefRule = new ExtendRule(r, new History(r.getRID()), ExtendType.defaultRule, null);
        return finalDefRule;
    }

    private AttributeValue getDefaultRuleClass() {
        AttributeValue max = Collections.max(this.data.getDataTable().getTargetAttribute().getAllValues(), Comparator.comparing(c -> c.getTransactions().size()));
        return max;
    }

    private int getDefaultRuleError(AttributeValue def) {
        int correct = def.getTransactions().size();
        return this.data.getDataTable().getAllCurrentTransactions().size() - correct;
    }
}

