% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install}
\alias{install}
\title{Install packages}
\usage{
install(
  packages = NULL,
  ...,
  exclude = NULL,
  library = NULL,
  type = NULL,
  rebuild = FALSE,
  repos = NULL,
  prompt = interactive(),
  dependencies = NULL,
  verbose = NULL,
  lock = FALSE,
  project = NULL
)
}
\arguments{
\item{packages}{Either \code{NULL} (the default) to install all packages required
by the project, or a character vector of packages to install. renv
supports a subset of the remotes syntax used for package installation,
e.g:
\itemize{
\item \code{pkg}: install latest version of \code{pkg} from CRAN.
\item \code{pkg@version}: install specified version of \code{pkg} from CRAN.
\item \code{username/repo}: install package from GitHub
\item \code{bioc::pkg}: install \code{pkg} from Bioconductor.
}

See \url{https://remotes.r-lib.org/articles/dependencies.html} and the examples
below for more details.

renv deviates from the remotes spec in one important way: subdirectories
are separated from the main repository specification with a \code{:}, not \code{/}.
So to install from the \code{subdir} subdirectory of GitHub package
\code{username/repo} you'd use \verb{"username/repo:subdir}.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{exclude}{Packages which should not be installed. \code{exclude} is useful
when using \code{renv::install()} to install all dependencies in a project,
except for a specific set of packages.}

\item{library}{The \R library to be used. When \code{NULL}, the active project
library will be used instead.}

\item{type}{The type of package to install ("source" or "binary"). Defaults
to the value of \code{getOption("pkgType")}.}

\item{rebuild}{Force packages to be rebuilt, thereby bypassing any installed
versions of the package available in the cache? This can either be a
boolean (indicating that all installed packages should be rebuilt), or a
vector of package names indicating which packages should be rebuilt.}

\item{repos}{The repositories to use when restoring packages installed
from CRAN or a CRAN-like repository. By default, the repositories recorded
in the lockfile will be, ensuring that (e.g.) CRAN packages are
re-installed from the same CRAN mirror.

Use \code{repos = getOption("repos")} to override with the repositories set
in the current session, or see the \code{repos.override} option in \link{config} for
an alternate way override.}

\item{prompt}{Boolean; prompt the user before taking any action? For backwards
compatibility, \code{confirm} is accepted as an alias for \code{prompt}.}

\item{dependencies}{A vector of DESCRIPTION field names that should be used
for package dependency resolution. When \code{NULL} (the default), the value
of \code{renv::settings$package.dependency.fields} is used. The aliases
"strong", "most", and "all" are also supported.
See \code{\link[tools:package_dependencies]{tools::package_dependencies()}} for more details.}

\item{verbose}{Boolean; report output from \verb{R CMD build} and \verb{R CMD INSTALL}
during installation? When \code{NULL} (the default), the value of \code{config$install.verbose()}
will be used. When \code{FALSE}, installation output will be emitted only if
a package fails to install.}

\item{lock}{Boolean; update the \code{renv.lock} lockfile after the successful
installation of the requested packages?}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A named list of package records which were installed by renv.
}
\description{
Install one or more \R packages, from a variety of remote sources.
\code{install()} uses the same machinery as \code{\link[=restore]{restore()}} (i.e. it uses cached
packages where possible) but it does not respect the lockfile, instead
installing the latest versions available from CRAN.

See \code{vignette("package-install")} for more details.
}
\section{\code{Remotes}}{
\code{install()} (called without arguments) will respect the \code{Remotes} field
of the \code{DESCRIPTION} file (if present). This allows you to specify places
to install a package other than the latest version from CRAN.
See \url{https://remotes.r-lib.org/articles/dependencies.html} for details.
}

\section{Bioconductor}{
Packages from Bioconductor can be installed by using the \verb{bioc::} prefix.
For example,

\if{html}{\out{<div class="sourceCode">}}\preformatted{renv::install("bioc::Biobase")
}\if{html}{\out{</div>}}

will install the latest-available version of Biobase from Bioconductor.

renv depends on BiocManager (or, for older versions of \R, BiocInstaller)
for the installation of packages from Bioconductor. If these packages are
not available, renv will attempt to automatically install them before
fulfilling the installation request.
}

\examples{
\dontrun{

# install the latest version of 'digest'
renv::install("digest")

# install an old version of 'digest' (using archives)
renv::install("digest@0.6.18")

# install 'digest' from GitHub (latest dev. version)
renv::install("eddelbuettel/digest")

# install a package from GitHub, using specific commit
renv::install("eddelbuettel/digest@df55b00bff33e945246eff2586717452e635032f")

# install a package from Bioconductor
# (note: requires the BiocManager package)
renv::install("bioc::Biobase")

# install a package, specifying path explicitly
renv::install("~/path/to/package")

# install packages as declared in the project DESCRIPTION file
renv::install()

}
}
