/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.dynamic;

import org.chocosolver.solver.Model;
import org.chocosolver.util.objects.setDataStructures.AbstractSet;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class SetDifference
extends AbstractSet {
    public ISet setA;
    public ISet setB;
    protected ISet values;

    public SetDifference(ISet setA, ISet setB) {
        this(setA, setB, setA.getSetType() != SetType.DYNAMIC ? setA.getSetType() : SetType.RANGESET, setA instanceof ISet.WithOffset ? ((ISet.WithOffset)((Object)setA)).getOffset() : 0);
    }

    public SetDifference(ISet setA, ISet setB, SetType setType, int offset) {
        this.setA = setA;
        this.setB = setB;
        this.values = setType == SetType.FIXED_ARRAY || setType == SetType.FIXED_INTERVAL ? SetFactory.makeRangeSet() : SetFactory.makeSet(setType, offset);
        this.init();
    }

    public SetDifference(Model model, ISet setA, ISet setB) {
        this(model, setA, setB, setA.getSetType() != SetType.DYNAMIC ? setA.getSetType() : SetType.RANGESET, setA instanceof ISet.WithOffset ? ((ISet.WithOffset)((Object)setA)).getOffset() : 0);
    }

    public SetDifference(Model model, ISet setA, ISet setB, SetType setType, int offset) {
        this.setA = setA;
        this.setB = setB;
        this.values = SetFactory.makeStoredSet(setType, offset, model);
        this.init();
    }

    private void init() {
        this.setA.registerObserver(this, 0);
        this.setB.registerObserver(this, 1);
        ISetIterator iSetIterator = this.setA.iterator();
        while (iSetIterator.hasNext()) {
            int v = (Integer)iSetIterator.next();
            if (this.setB.contains(v)) continue;
            this.values.add(v);
        }
    }

    @Override
    public ISetIterator iterator() {
        return this.values.iterator();
    }

    @Override
    public ISetIterator newIterator() {
        return this.values.newIterator();
    }

    @Override
    public boolean add(int element) {
        throw new UnsupportedOperationException("this set is read-only");
    }

    @Override
    public boolean remove(int element) {
        throw new UnsupportedOperationException("this set is read-only");
    }

    @Override
    public boolean contains(int element) {
        return this.values.contains(element);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("this set is read-only");
    }

    @Override
    public int min() {
        return this.values.min();
    }

    @Override
    public int max() {
        return this.values.max();
    }

    @Override
    public SetType getSetType() {
        return SetType.DYNAMIC;
    }

    @Override
    public void notifyElementRemoved(int element, int idx) {
        if (idx == 0 && this.values.remove(element)) {
            this.notifyObservingElementRemoved(element);
        }
        if (idx == 1 && this.setA.contains(element) && this.values.add(element)) {
            this.notifyObservingElementAdded(element);
        }
    }

    @Override
    public void notifyElementAdded(int element, int idx) {
        if (idx == 0 && !this.setB.contains(element) && this.values.add(element)) {
            this.notifyObservingElementAdded(element);
        }
        if (idx == 1 && this.setA.contains(element) && this.values.remove(element)) {
            this.notifyObservingElementRemoved(element);
        }
    }

    @Override
    public void notifyCleared(int idx) {
        if (idx == 0) {
            this.values.clear();
            this.notifyObservingCleared();
        }
        if (idx == 0) {
            ISetIterator iSetIterator = this.setA.iterator();
            while (iSetIterator.hasNext()) {
                int v = (Integer)iSetIterator.next();
                if (!this.values.add(v)) continue;
                this.notifyObservingElementAdded(v);
            }
        }
    }
}

