/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core;

import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.rules.AbstractAMRules;
import moa.classifiers.rules.core.Rule;
import moa.classifiers.rules.driftdetection.PageHinkleyFading;
import moa.classifiers.rules.driftdetection.PageHinkleyTest;
import moa.classifiers.trees.HoeffdingTree;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;

public abstract class RuleActiveLearningNode
extends HoeffdingTree.ActiveLearningNode {
    protected PageHinkleyTest pageHinckleyTest;
    protected int predictionFunction;
    protected boolean changeDetection;
    protected Rule owner;
    protected boolean[] attributesMask;
    protected int numAttributesSelected;
    private static final long serialVersionUID = 9129659494380381126L;
    protected DoubleVector nodeStatistics;
    protected AbstractAMRules amRules;
    protected AttributeSplitSuggestion bestSuggestion = null;
    protected int splitIndex = 0;
    protected double[] statisticsNewRuleActiveLearningNode = null;
    protected double[] statisticsBranchSplit = null;
    protected double[] statisticsOtherBranchSplit;

    public RuleActiveLearningNode(double[] initialClassObservations) {
        super(initialClassObservations);
        this.nodeStatistics = new DoubleVector(initialClassObservations);
    }

    public RuleActiveLearningNode() {
        this(new double[0]);
    }

    public RuleActiveLearningNode(Rule.Builder builder) {
        this(builder.statistics);
        this.changeDetection = builder.changeDetection;
        if (!builder.changeDetection) {
            this.pageHinckleyTest = new PageHinkleyFading(builder.threshold, builder.alpha);
        }
        this.amRules = builder.amRules;
        this.predictionFunction = builder.predictionFunction;
        this.owner = builder.getOwner();
    }

    public abstract void learnFromInstance(Instance var1);

    @Override
    public void learnFromInstance(Instance inst, HoeffdingTree ht) {
        this.learnFromInstance(inst);
    }

    protected AttributeClassObserver newNumericClassObserver() {
        return (AttributeClassObserver)((AttributeClassObserver)this.amRules.numericObserverOption.getPreMaterializedObject()).copy();
    }

    public void updateStatistics(Instance instance) {
        this.learnFromInstance(instance);
    }

    public AutoExpandVector<AttributeClassObserver> getAttributeObservers() {
        return this.attributeObservers;
    }

    protected void debug(String string, int level) {
        if (this.amRules.VerbosityOption.getValue() >= level) {
            System.out.println(string);
        }
    }

    public double[] getPrediction(Instance instance) {
        int predictionMode = this.getLearnerToUse(instance, this.predictionFunction);
        return this.getPrediction(instance, predictionMode);
    }

    public abstract double[] getPrediction(Instance var1, int var2);

    public abstract int getLearnerToUse(Instance var1, int var2);

    public abstract double computeError(Instance var1);

    public boolean updatePageHinckleyTest(double error) {
        boolean changeDetected = false;
        if (!this.changeDetection) {
            changeDetected = this.pageHinckleyTest.update(error);
        }
        return changeDetected;
    }

    public long getInstancesSeen() {
        return (long)this.getWeightSeen();
    }

    public abstract boolean isAnomaly(Instance var1, double var2, double var4, int var6);

    public double computeProbability(double mean, double sd, double value) {
        double probability = 0.0;
        if (sd > 0.0) {
            double k = Math.abs(value - mean) / sd;
            probability = 1.0 / (1.0 + k * k);
            double var = Math.pow(sd, 2.0);
            probability = 2.0 * var / (var + Math.pow(Math.abs(value - mean), 2.0));
        }
        return probability;
    }

    public int getSplitIndex() {
        return this.splitIndex;
    }

    public void setSplitIndex(int splitIndex) {
        this.splitIndex = splitIndex;
    }

    public AttributeSplitSuggestion getBestSuggestion() {
        return this.bestSuggestion;
    }

    public void setBestSuggestion(AttributeSplitSuggestion bestSuggestion) {
        this.bestSuggestion = bestSuggestion;
    }

    public double[] getStatisticsBranchSplit() {
        return this.statisticsBranchSplit;
    }

    public void setStatisticsBranchSplit(double[] statisticsBranchSplit) {
        this.statisticsBranchSplit = statisticsBranchSplit;
    }

    public double[] getStatisticsNewRuleActiveLearningNode() {
        return this.statisticsNewRuleActiveLearningNode;
    }

    public void setStatisticsNewRuleActiveLearningNode(double[] statisticsNewRuleActiveLearningNode) {
        this.statisticsNewRuleActiveLearningNode = statisticsNewRuleActiveLearningNode;
    }

    public double[] getStatisticsOtherBranchSplit() {
        return this.statisticsOtherBranchSplit;
    }

    public void setStatisticsOtherBranchSplit(double[] statisticsOtherBranchSplit) {
        this.statisticsOtherBranchSplit = statisticsOtherBranchSplit;
    }

    public abstract boolean tryToExpand(double var1, double var3);

    public static double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    public abstract void initialize(RuleActiveLearningNode var1);

    public abstract double[] getSimplePrediction();

    public DoubleVector getNodeStatistics() {
        return this.nodeStatistics;
    }

    public boolean updateChangeDetection(double error) {
        if (!this.changeDetection) {
            return this.pageHinckleyTest.update(error);
        }
        return false;
    }

    public abstract double getCurrentError();
}

