/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeStatistic;
import java.util.Set;

public class TMRCAStatistic
extends TreeStatistic {
    private Tree tree = null;
    private Set<String> leafSet = null;
    private final double mostRecentTipTime;
    private final boolean isBackwards;
    private final boolean forParent;

    public TMRCAStatistic(String string, Tree tree, TaxonList taxonList, boolean bl, boolean bl2) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        if (bl && Taxon.getMostRecentDate() != null) {
            this.isBackwards = Taxon.getMostRecentDate().isBackwards();
            this.mostRecentTipTime = Taxon.getMostRecentDate().getAbsoluteTimeValue();
        } else {
            this.mostRecentTipTime = Double.NaN;
            this.isBackwards = false;
        }
        this.leafSet = taxonList != null ? TreeUtils.getLeavesForTaxa(tree, taxonList) : null;
        this.forParent = bl2;
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        NodeRef nodeRef;
        if (this.leafSet != null) {
            nodeRef = TreeUtils.getCommonAncestorNode(this.tree, this.leafSet);
            if (this.forParent && !this.tree.isRoot(nodeRef)) {
                nodeRef = this.tree.getParent(nodeRef);
            }
        } else {
            nodeRef = this.tree.getRoot();
        }
        if (nodeRef == null) {
            throw new RuntimeException("No node found that is MRCA of " + this.leafSet);
        }
        if (!Double.isNaN(this.mostRecentTipTime)) {
            if (this.isBackwards) {
                return this.mostRecentTipTime + this.tree.getNodeHeight(nodeRef);
            }
            return this.mostRecentTipTime - this.tree.getNodeHeight(nodeRef);
        }
        return this.tree.getNodeHeight(nodeRef);
    }
}

