## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
#  install.packages("corella")

## -----------------------------------------------------------------------------
#  # install.packages("devtools")
#  devtools::install_github("AtlasOfLivingAustralia/corella")

## -----------------------------------------------------------------------------
library(corella)

## -----------------------------------------------------------------------------
library(tibble)
library(lubridate)

df <- tibble(
  latitude = c(-35.310, "-35.273"), # deliberate error for demonstration purposes
  longitude = c(149.125, 149.133),
  date = c("14-01-2023", "15-01-2023"),
  time = c("10:23:00", "11:25:00"),
  month = c("January", "February"),
  day = c(100, 101),
  species = c("Callocephalon fimbriatum", "Eolophus roseicapilla"),
  n = c(2, 3),
  crs = c("WGS84", "WGS8d"),
  country = c("Australia", "Denmark"),
  continent = c("Oceania", "Europe")
  )

df

## -----------------------------------------------------------------------------
df |>
  set_scientific_name(scientificName = species)

## -----------------------------------------------------------------------------
df |>
  set_scientific_name(scientificName = species) |>
  set_coordinates(decimalLongitude = longitude,
                  decimalLatitude = latitude)

## -----------------------------------------------------------------------------
df_darwincore <- df |>
  set_scientific_name(scientificName = species) |>
  set_coordinates(decimalLongitude = longitude,
                  decimalLatitude = as.numeric(latitude))

df_darwincore

## -----------------------------------------------------------------------------
df |>
  set_scientific_name(scientificName = species) |>
  set_coordinates(decimalLongitude = longitude,
                  decimalLatitude = as.numeric(latitude)) |>
  set_locality()

df_darwincore

## -----------------------------------------------------------------------------
df |>
  suggest_workflow()

## -----------------------------------------------------------------------------
df_edited <- df |>
  set_occurrences(
    occurrenceID = seq_len(nrow(df)),
    basisOfRecord = "humanObservation"
    )

## -----------------------------------------------------------------------------
df_edited |>
  suggest_workflow()

## -----------------------------------------------------------------------------
df <- tibble(
  latitude = c(-35.310, "-35.273"), # deliberate error for demonstration purposes
  longitude = c(149.125, 149.133),
  date = c("14-01-2023", "15-01-2023"),
  individualCount = c(0, 2),
  species = c("Callocephalon fimbriatum", "Eolophus roseicapilla"),
  country = c("AU", "AU"),
  occurrenceStatus = c("present", "present")
  )

df |>
  check_dataset()

