/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.chunker;

import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.chunker.ChunkEvaluationErrorListener;
import opennlp.tools.cmdline.chunker.ChunkerDetailedFMeasureListener;
import opennlp.tools.cmdline.chunker.ChunkerModelLoader;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChunkerEvaluatorTool
extends AbstractEvaluatorTool<ChunkSample, EvalToolParams> {
    public ChunkerEvaluatorTool() {
        super(ChunkSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the Chunker model with the reference data";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        ChunkerModel model = (ChunkerModel)new ChunkerModelLoader().load(((EvalToolParams)this.params).getModel());
        LinkedList<ChunkerEvaluationMonitor> listeners = new LinkedList<ChunkerEvaluationMonitor>();
        ChunkerDetailedFMeasureListener detailedFMeasureListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new ChunkEvaluationErrorListener());
        }
        if (((EvalToolParams)this.params).getDetailedF().booleanValue()) {
            detailedFMeasureListener = new ChunkerDetailedFMeasureListener();
            listeners.add(detailedFMeasureListener);
        }
        ChunkerEvaluator evaluator = new ChunkerEvaluator(new ChunkerME(model, 10), listeners.toArray(new ChunkerEvaluationMonitor[listeners.size()]));
        final PerformanceMonitor monitor = new PerformanceMonitor("sent");
        ObjectStream<ChunkSample> measuredSampleStream = new ObjectStream<ChunkSample>(){

            @Override
            public ChunkSample read() throws IOException {
                monitor.incrementCounter();
                return (ChunkSample)ChunkerEvaluatorTool.this.sampleStream.read();
            }

            @Override
            public void reset() throws IOException {
                ChunkerEvaluatorTool.this.sampleStream.reset();
            }

            @Override
            public void close() throws IOException {
                ChunkerEvaluatorTool.this.sampleStream.close();
            }
        };
        monitor.startAndPrintThroughput();
        try {
            evaluator.evaluate(measuredSampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), e);
        }
        finally {
            try {
                measuredSampleStream.close();
            }
            catch (IOException e) {}
        }
        monitor.stopAndPrintFinalResult();
        System.out.println();
        if (detailedFMeasureListener == null) {
            System.out.println(evaluator.getFMeasure());
        } else {
            System.out.println(detailedFMeasureListener.toString());
        }
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    DetailedFMeasureEvaluatorParams {
    }
}

