/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.complex.complexLinks;

import dmLab.array.FArray;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.complex.Complex;
import dmLab.classifier.adx.complex.complexLinks.ComplexLink;
import dmLab.classifier.adx.selector.SelectorList;
import java.util.Arrays;

public final class ComplexLinks {
    private ComplexLink[] links;
    private boolean[] mask;
    private int iterator = 0;
    private boolean iterateSelected = true;
    private double sumPos;
    private double sumNeg;
    private int activeComplexes;
    public double alternativeScore;

    public ComplexLinks() {
    }

    public ComplexLinks(ComplexLink[] links) {
        this();
        ComplexLinks complexLinks;
        this.links = links;
        this.mask = new boolean[((void)complexLinks).length];
        complexLinks = this;
        Arrays.fill(complexLinks.mask, true);
    }

    public final int size() {
        return this.links.length;
    }

    public final void sort() {
        Arrays.sort(this.links);
    }

    public final void disableAll() {
        Arrays.fill(this.mask, false);
    }

    public final void enable(int index) {
        this.mask[var1_1] = true;
    }

    public final void disable(int index) {
        this.mask[var1_1] = false;
    }

    /*
     * WARNING - void declaration
     */
    public final void calcGlobalParams$4379dc3a() {
        this.activeComplexes = 0;
        this.sumPos = 0.0;
        this.sumNeg = 0.0;
        for (int j = 0; j < this.links.length; ++j) {
            void var2_2;
            if (!this.mask[j]) continue;
            Complex complex = this.links[j].complex;
            ++this.activeComplexes;
            this.sumPos += (double)complex.posCoverage;
            this.sumNeg += (double)var2_2.negCoverage;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final double calcScore(SelectorList selectorsList, FArray array, int eventIndex, ADXParams adxParams) {
        double currPos = 0.0;
        double currNeg = 0.0;
        int covered = 0;
        double probability = 1.0;
        double avgProbability = 0.0;
        for (int i = 0; i < this.links.length; ++i) {
            Complex complex;
            if (!this.mask[i] || !(complex = this.links[i].complex).covers(selectorsList, array, eventIndex)) continue;
            currPos += (double)complex.posCoverage;
            currNeg += (double)complex.negCoverage;
            probability *= 1.0 - complex.calcPosProbability();
            avgProbability += complex.calcPosProbability();
            ++covered;
        }
        double score = Double.NaN;
        if (covered == 0) {
            return 0.0;
        }
        if (adxParams.scoreMethod == 0) {
            double sumAvg = (this.sumPos - this.sumNeg) / (double)this.activeComplexes;
            score = (currPos - currNeg) / (double)covered / sumAvg;
        } else if (adxParams.scoreMethod == 1) {
            score = (currPos - currNeg) / (this.sumPos - this.sumNeg);
        } else if (adxParams.scoreMethod == 2) {
            score = currNeg != 0.0 ? currPos / this.sumPos * (this.sumNeg / currNeg) : currPos / this.sumPos;
        } else if (adxParams.scoreMethod == 3) {
            score = this.sumNeg != 0.0 ? currPos / this.sumPos * (1.0 - currNeg / this.sumNeg) : currPos / this.sumPos;
        } else if (adxParams.scoreMethod == 4) {
            score = 1.0 - probability;
        } else if (adxParams.scoreMethod == 5) {
            score = avgProbability / (double)covered;
        } else if (adxParams.scoreMethod == 6) {
            score = avgProbability / (double)covered;
            this.alternativeScore = currPos / this.sumPos;
        } else if (adxParams.scoreMethod == 7) {
            score = 1.0 - probability;
            this.alternativeScore = currPos / this.sumPos;
        }
        if (Double.isNaN(score)) {
            System.err.println("Error! Score is NaN for eventIndex=" + eventIndex);
            System.err.println("# sumPos=" + this.sumPos + " sumNeg=" + this.sumNeg);
            System.err.println("# currPos=" + currPos + " currNeg=" + currNeg);
            System.err.println("# activeComplexes=" + this.activeComplexes + " covered=" + covered);
            System.err.println("# probability=" + probability + " avgProbability=" + avgProbability);
        } else if (Double.isInfinite(score)) {
            void var3_3;
            System.err.println("Error! Score is Infinite for eventIndex=" + (int)var3_3);
            System.err.println("# sumPos=" + this.sumPos + " sumNeg=" + this.sumNeg);
            System.err.println("# currPos=" + currPos + " currNeg=" + currNeg);
            System.err.println("# activeComplexes=" + this.activeComplexes + " covered=" + covered);
            System.err.println("# probability=" + probability + " avgProbability=" + avgProbability);
        }
        return score;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < this.links.length; ++i) {
            if (!this.mask[i]) continue;
            tmp.append(this.links[i].toString() + "\n");
        }
        return var1_1.toString();
    }

    public final boolean initIterator(boolean iterateSelected) {
        this.iterator = 0;
        this.iterateSelected = false;
        return true;
    }

    public final ComplexLink getNext() {
        while (this.iterator < this.links.length) {
            if (this.mask[this.iterator] == this.iterateSelected) {
                return this.links[this.iterator++];
            }
            ++this.iterator;
        }
        return null;
    }
}

