# simtrial 0.4.2

## Statistical improvements

- Summary function of `sim_gs_n()` is available (#268, thanks to @LittleBeannie).
- The denominator of the milestone test Z-score is corrected (#270, thanks to @LittleBeannie).
- Statistical information is added as output of `sim_gs_n()` (#273, thanks to @LittleBeannie).
- The randomization ratio is built as an attribute of `sim_pw_surv()` and passed into the `wlr()` test (#281, #285 thanks to @LittleBeannie and @jdblischak).
- The sign of the Z-score is unified to positive numbers (#272, #286, thanks to @LittleBeannie and @jdblischak).

## Computational improvements

- The source code of `summary()` is rewritten from `tibble` or `data.frame` to `data.table`, which is optimized to use as little memory as possible by avoiding making unnecessary temporary copies of data frames. This results in code that is more efficient in both time and memory use. (#289, thanks to @jdblischak).
- The `sim_fixed_n()` function has been updated to allow parallel simulations (#249, #252, #253, #262, thanks to @cmansch and @jdblischak).

## Bug fixes

- Fixed the bug of cut functions in parallel (#261, thanks to @cmansch).

## Coding improvements

- The `wlr()` function is enhanced to S3 generic to accept both counting process and time-to-event data as its input (#276, #277, thanks to @jdblischak).

## Documentation

- Use KaTeX for pkgdown math rendering  (#263, thanks to @nanxstats).

## Tests

- Regression tests of `summary()` is added (#282, thanks to @jdblischak).

# simtrial 0.4.1

## Improvements

- Pass `noSuggests` checks by running code examples, tests, and vignettes
  conditionally if the `Suggests` dependencies are not installed (#243).

# simtrial 0.4.0

## New features

- `rmst()` introduces the RMST test (#188, thanks, @LittleBeannie).
- `milestone()` introduces the milestone test
  (#199, #204, #211, #237, thanks, @LittleBeannie).
- `sim_gs_n()` provides an experimental implementation for fixed sample size
  group sequential design simulation, with unit tests upcoming
  (#195, #201, #208, #212, thanks, @LittleBeannie and @jdblischak).
- `create_cut()` allows users to create custom interim and final
  analyses cuttings based on their specific requirements
  (#201, #221, thanks, @jdblischak).
- `create_test()` enables users to create various testing approaches for
  interim and final analyses (#215, #221, thanks, @jdblischak).
- `multitest()` gives users the option to perform multiple tests on a
  simulated dataset (#215, thanks, @jdblischak).
  Note: This function is still experimental and may be improved in
  future releases, as it was created prior to the standardization of
  test functions in #227.
- Test outputs (logrank, weighted logrank, RMST, milestone, MaxCombo) are now
  unified as a list including method, parameter, estimate, se, z-value, and
  p-value (#227, thanks, @LittleBeannie).

## Bug fixes

- Fixed incorrect weights generated by `early_zero()` under stratified designs
  (#233, thanks, @LittleBeannie).

## Documentation

- Enhanced documentation for `get_analysis_date()` (#186, thanks, @LittleBeannie).

## Dependency

- Removed dependency on the bshazard package as it was archived by CRAN
  (#234, thanks, @nanxstats).

# simtrial 0.3.2

This release makes minor improvements on auxiliary code with side-effects.

## Improvements

- Remove the code that sets `options()` within `vignette("modest-wlrt")`.
- Updated the code used for generating image assets. These scripts now write to
  `tempdir()` instead of the package directory.

# simtrial 0.3.1

This release introduces significant changes to the API, improves simulation
performance substantially, and adds new features and documentation.

## Significant user-visible changes

- Complete overhaul of the API. Function and argument names now use
  snake case for consistency and readability. See the
  [function reference](https://merck.github.io/simtrial/reference/)
  for the updated naming scheme. Detailed change history is available in the merged pull requests
  (thanks, @LittleBeannie, @lili-ling-msd, and @XintongLi2023).
- Dataset names updated to snake case (thanks, @nanxstats, #164).
- The base pipe operator is now used throughout the package.
  The magrittr pipe is no longer re-exported (thanks, @nanxstats, #146).

## Improvements

- Rewritten table backend for simtrial functions using data.table,
  achieving a 3x to 5x speedup compared to the previous implementation
  (thanks, @jdblischak, #111).
- `sim_fixed_n()` now utilizes the `%dofuture%` operator for parallelization,
  enhancing flexibility and reproducibility (thanks, @cmansch, #110).
- `rpwexp()` adopts the inverse CDF method for random number generation,
  with the naive methods now as internal functions
  (thanks, @jianxiaoyang, #15 and #174).
- `sim_fixed_n()` is optimized to skip Breslow's method in the absence of ties
  (thanks, @jdblischak, #130).
- The internal function for computing Z statistics in Fleming-Harrington
  weighted logrank tests is now named `wlr_z_stat()` (thanks, @elong0527, #105).

## New features

- `early_zero_weight()` is added as a weighting function for early data removal
  (thanks, @LittleBeannie, #123).
- `get_analysis_date()` is added to calculate interim/final analysis dates
  under various conditions (thanks, @LittleBeannie, #122).

## Documentation

- New `vignette("workflow")` providing an overview of data manipulations
  involved in TTE simulations (thanks, @keaven, #99).
- New `vignette("parallel")` demonstrating the parallelization workflow and
  coding best practices (thanks, @cmansch, #113 and #134).

## Miscellaneous

- Added a hex sticker logo with a generative art design for the package
  (thanks, @keaven, #158).

# simtrial 0.2.2

GitHub release in February 2023.

This is the version that enables parallel computation in `simfix()`.

# simtrial 0.2.1

GitHub release in May 2022.

This version supports the _Biometrical Journal_ paper
"A unified framework for weighted parametric group sequential design (WPGSD)"
by Keaven M. Anderson, Zifang Guo, Jing Zhao, and Linda Z. Sun.

# simtrial 0.2.0

Internal development release in August 2020.

- Updated vignettes and website.
- Prepared for Regulatory/Industry training session in September.

# simtrial 0.1.7.9004

Internal development release in February 2020.

- Added `wMB()` to compute Magirr-Burman weights.
- Added vignette to demonstrate working with different weighting schemes.
- Replaced `Depends` with `Imports` in `DESCRIPTION`.

# simtrial 0.1.7.9003

Internal development release in November 2019.

- Incorporated new functions to simplify use (`simfix()`, `simfix2simPWSurv()`, `pMaxCombo()`).
- Removed `hgraph()` with intent to put it into a release of gsDesign.
- Limited to 2 essential vignettes.
- Added continuous integration/continuous deployment (YAML) and pkgdown for website generation.
- Limited dependencies to those that are essential; this removed some convenience functions not related to core package functionality.
