#ifndef SOBOL_DIRECTIONS_H
#define SOBOL_DIRECTIONS_H

#include <cstdint>

// Sobol direction numbers up to dimension = 21201 , each with 32 bits.

static const uint32_t SPACEFILLR_SOBOL_DIRECTIONS[21201][32] = {
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x04000000, 0x02000000, 0x01000000, 0x00800000, 0x00400000, 0x00200000, 0x00100000, 0x00080000, 0x00040000, 0x00020000, 0x00010000, 0x00008000, 0x00004000, 0x00002000, 0x00001000, 0x00000800, 0x00000400, 0x00000200, 0x00000100, 0x00000080, 0x00000040, 0x00000020, 0x00000010, 0x00000008, 0x00000004, 0x00000002, 0x00000001 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x88000000, 0xCC000000, 0xAA000000, 0xFF000000, 0x80800000, 0xC0C00000, 0xA0A00000, 0xF0F00000, 0x88880000, 0xCCCC0000, 0xAAAA0000, 0xFFFF0000, 0x80008000, 0xC000C000, 0xA000A000, 0xF000F000, 0x88008800, 0xCC00CC00, 0xAA00AA00, 0xFF00FF00, 0x80808080, 0xC0C0C0C0, 0xA0A0A0A0, 0xF0F0F0F0, 0x88888888, 0xCCCCCCCC, 0xAAAAAAAA, 0xFFFFFFFF } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xE8000000, 0x5C000000, 0x8E000000, 0xC5000000, 0x68800000, 0x9CC00000, 0xEE600000, 0x55900000, 0x80680000, 0xC09C0000, 0x60EE0000, 0x90550000, 0xE8808000, 0x5CC0C000, 0x8E606000, 0xC5909000, 0x6868E800, 0x9C9C5C00, 0xEEEE8E00, 0x5555C500, 0x8000E880, 0xC0005CC0, 0x60008E60, 0x9000C590, 0xE8006868, 0x5C009C9C, 0x8E00EEEE, 0xC5005555 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xF8000000, 0x74000000, 0xA2000000, 0x93000000, 0xD8800000, 0x25400000, 0x59E00000, 0xE6D00000, 0x78080000, 0xB40C0000, 0x82020000, 0xC3050000, 0x208F8000, 0x51474000, 0xFBEA2000, 0x75D93000, 0xA0858800, 0x914E5400, 0xDBE79E00, 0x25DB6D00, 0x58800080, 0xE54000C0, 0x79E00020, 0xB6D00050, 0x800800F8, 0xC00C0074, 0x200200A2, 0x50050093 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xF8000000, 0xDC000000, 0x7A000000, 0x9D000000, 0x5A800000, 0x2FC00000, 0xA1600000, 0xF0B00000, 0xDA880000, 0x6FC40000, 0x81620000, 0x40BB0000, 0x22878000, 0xB3C9C000, 0xFB65A000, 0xDDB2D000, 0x78022800, 0x9C0B3C00, 0x5A0FB600, 0x2D0DDB00, 0xA2878080, 0xF3C9C040, 0xDB65A020, 0x6DB2D0B0, 0x800228F8, 0x400B3CDC, 0x200FB67A, 0xB00DDB9D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xC8000000, 0x24000000, 0x56000000, 0xFB000000, 0xE0800000, 0x70400000, 0xA8600000, 0x14300000, 0x9EC80000, 0xDF240000, 0xB6D60000, 0x8BBB0000, 0x48008000, 0x64004000, 0x36006000, 0xCB003000, 0x2880C800, 0x54402400, 0xFE605600, 0xEF30FB00, 0x7E48E080, 0xAF647040, 0x1EB6A860, 0x9F8B1430, 0xD6C81EC8, 0xBB249F24, 0x80D6D6D6, 0x40BBBBBB } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x58000000, 0x94000000, 0x3E000000, 0xE3000000, 0xBE800000, 0x23C00000, 0x1E200000, 0xF3100000, 0x46780000, 0x67840000, 0x78460000, 0x84670000, 0xC6788000, 0xA784C000, 0xD846A000, 0x5467D000, 0x9E78D800, 0x33845400, 0xE6469E00, 0xB7673300, 0x20F86680, 0x104477C0, 0xF8668020, 0x4477C010, 0x668020F8, 0x77C01044, 0x8020F866, 0xC0104477 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x88000000, 0x24000000, 0x12000000, 0x2D000000, 0x76800000, 0x9E400000, 0x08200000, 0x64100000, 0xB2280000, 0x7D140000, 0xFEA20000, 0xBA490000, 0x1A248000, 0x491B4000, 0xC4B5A000, 0xE3739000, 0xF6800800, 0xDE400400, 0xA8200A00, 0x34100500, 0x3A280880, 0x59140240, 0xECA20120, 0x974902D0, 0x6CA48768, 0xD75B49E4, 0xCC95A082, 0x87639641 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x28000000, 0xD4000000, 0x6A000000, 0x71000000, 0x38800000, 0x58400000, 0xEA200000, 0x31100000, 0x98A80000, 0x08540000, 0xC22A0000, 0xE5250000, 0xF2B28000, 0x79484000, 0xFAA42000, 0xBD731000, 0x18A80800, 0x48540400, 0x622A0A00, 0xB5250500, 0xDAB28280, 0xAD484D40, 0x90A426A0, 0xCC731710, 0x20280B88, 0x10140184, 0x880A04A2, 0x84350611 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x98000000, 0x94000000, 0x8A000000, 0x5B000000, 0x33800000, 0xD9C00000, 0x72200000, 0x3F100000, 0xC1B80000, 0xA6EC0000, 0x53860000, 0x29F50000, 0x0A3A8000, 0x1B2AC000, 0xD392E000, 0x69FF7000, 0xEA380800, 0xAB2C0400, 0x4BA60E00, 0xFDE50B00, 0x60028980, 0xF006C940, 0x7834E8A0, 0x241A75B0, 0x123A8B38, 0xCF2AC99C, 0xB992E922, 0x82FF78F1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x08000000, 0x6C000000, 0x9E000000, 0x23000000, 0x57800000, 0xADC00000, 0x7FA00000, 0x91D00000, 0x49880000, 0xCED40000, 0x880A0000, 0x2C0F0000, 0x3E0D8000, 0x3317C000, 0x5FB06000, 0xC1F8B000, 0xE18D8800, 0xB2D7C400, 0x1E106A00, 0x6328B100, 0xF7858880, 0xBDC3C2C0, 0x77BA63E0, 0xFDF7B330, 0xD7800DF8, 0xEDC0081C, 0xDFA0041A, 0x81D00A2D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x58000000, 0xAC000000, 0x96000000, 0x2B000000, 0xD4800000, 0x09400000, 0xE2A00000, 0x52500000, 0x4E280000, 0xC71C0000, 0x629E0000, 0x12670000, 0x6E138000, 0xF731C000, 0x3A98A000, 0xBE449000, 0xF83B8800, 0xDC2DC400, 0xEE06A200, 0xB7239300, 0x1AA80D80, 0x8E5C0EC0, 0xA03E0B60, 0x703701B0, 0x783B88C8, 0x9C2DCA54, 0xCE06A74A, 0x87239795 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xF8000000, 0x8C000000, 0xE2000000, 0x33000000, 0x0F800000, 0x21400000, 0x95A00000, 0x5E700000, 0xD8080000, 0x1C240000, 0xBA160000, 0xEF370000, 0x15868000, 0x9E6FC000, 0x781B6000, 0x4C349000, 0x420E8800, 0x630BCC00, 0xF7AD6A00, 0xAD739500, 0x77800780, 0x6D4004C0, 0xD7A00420, 0x3D700630, 0x2F880F78, 0xB1640AD4, 0xCDB6077A, 0x824706D7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x38000000, 0xC4000000, 0x42000000, 0xA3000000, 0xF1800000, 0xAA400000, 0xFCE00000, 0x85100000, 0xE0080000, 0x500C0000, 0x58060000, 0x54090000, 0x7A038000, 0x670C4000, 0xB3842000, 0x094A3000, 0x0D6F1800, 0x2F5AA400, 0x1CE7CE00, 0xD5145100, 0xB8000080, 0x040000C0, 0x22000060, 0x33000090, 0xC9800038, 0x6E4000C4, 0xBEE00042, 0x261000A3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xA8000000, 0x54000000, 0x9A000000, 0x9D000000, 0x1E800000, 0x5CC00000, 0x7D200000, 0x8D100000, 0x24880000, 0x71C40000, 0xEBA20000, 0x75DF0000, 0x6BA28000, 0x35D14000, 0x4BA3A000, 0xC5D2D000, 0xE3A16800, 0x91DB8C00, 0x79AEF200, 0x0CDF4100, 0x672A8080, 0x50154040, 0x1A01A020, 0xDD0DD0F0, 0x3E83E8A8, 0xACCACC54, 0xD52D529A, 0xD91D919D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xD8000000, 0xC4000000, 0x46000000, 0x85000000, 0xA5800000, 0x76C00000, 0xADA00000, 0x6AB00000, 0x2DA80000, 0xAABC0000, 0x0DAA0000, 0x7AB10000, 0xD5A78000, 0xBEBD4000, 0x93A3E000, 0x3BB51000, 0x3629B800, 0x4D727C00, 0x9B836200, 0x27C4D700, 0xB629B880, 0x8D727CC0, 0xBB836220, 0xF7C4D7D0, 0x6E29B858, 0x49727C04, 0xFD836266, 0x72C4D755 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x38000000, 0x14000000, 0xF6000000, 0x67000000, 0x8F800000, 0x50400000, 0x8AA00000, 0x0FF00000, 0x12A80000, 0xABF40000, 0xFCAA0000, 0x28FB0000, 0xBD298000, 0x0BBA4000, 0x4E06E000, 0x330C3000, 0x59861800, 0xC74D3400, 0x3D2CB200, 0x4BB2CB00, 0x6E061880, 0xC30D3440, 0x618CB220, 0xD342CBF0, 0xCB2E18B8, 0x2CB93454, 0xE186B2D6, 0x9349CB97 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x68000000, 0x64000000, 0x36000000, 0x6D000000, 0x41800000, 0xE0400000, 0xD2E00000, 0x9BF00000, 0x0CE80000, 0x52FC0000, 0x5B6A0000, 0x2FB30000, 0xA00C8000, 0x30054000, 0x4807E000, 0x940F9000, 0x5E01F800, 0x090E9400, 0x778A5600, 0x8D416B00, 0x9369F880, 0x7BB294C0, 0xDE005620, 0xC9026BF0, 0x578D78E8, 0x7D4BD4A4, 0xFB6DB616, 0x1FBEFB9D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x98000000, 0xF4000000, 0xAE000000, 0xBB000000, 0xE7800000, 0x95C00000, 0x1C200000, 0xD0300000, 0xDBA80000, 0x55F40000, 0xFF820000, 0x21C10000, 0x12238000, 0x3B3A4000, 0xA42B6000, 0x3430F000, 0x4DA69800, 0x4AF3EC00, 0x2E043A00, 0xFB0A1F00, 0x47851880, 0xC5C9AC40, 0x842F5AA0, 0x243AEF50, 0x75A38018, 0xEEFA40B4, 0x180B600E, 0xB400F0EB } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xB8000000, 0x3C000000, 0xCE000000, 0x41000000, 0x21800000, 0x51C00000, 0x09600000, 0x85700000, 0xF2780000, 0x8E9C0000, 0x60020000, 0x70030000, 0x58038000, 0x8C02C000, 0x7602E000, 0x7D00F000, 0xEF833800, 0x10C10400, 0x28E08600, 0xD4B14700, 0xFB182580, 0x0BEE15C0, 0x9279C9E0, 0xFE9D3A70, 0x38000008, 0xFC00000C, 0x2E00000E, 0xF100000B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x68000000, 0x3C000000, 0x8A000000, 0x51000000, 0xA9800000, 0xDDC00000, 0x5BA00000, 0x39D00000, 0x95F80000, 0x56D40000, 0x0A020000, 0x91030000, 0x49838000, 0x0DC34000, 0x33A1A000, 0x05D0F000, 0x1FFA2800, 0x07D54400, 0xA380A600, 0x4CC07700, 0x1222EE80, 0x3413A740, 0xA65BF7E0, 0x5305AB50, 0x15F80008, 0x96D4000C, 0xEA02000E, 0x4103000D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x38000000, 0x8C000000, 0x7E000000, 0x71000000, 0xC8800000, 0x04C00000, 0x1BA00000, 0xBB700000, 0x4A980000, 0xC3BC0000, 0xA6020000, 0x6D010000, 0xEE818000, 0x29C34000, 0x9520E000, 0x42B23000, 0xE7B9F800, 0x0D0DC400, 0x3FB92200, 0x110D1300, 0x19BBEE80, 0x3C0CADC0, 0x973A4A60, 0xC5CF7EF0, 0x3A180008, 0x0B7C0004, 0xA3A20006, 0x7771000D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x08000000, 0x64000000, 0x6A000000, 0x89000000, 0xA5800000, 0xCB400000, 0x18200000, 0xAD900000, 0xAF880000, 0x72F40000, 0x25820000, 0x0B430000, 0xB8228000, 0x3D924000, 0xA7882000, 0x16F59000, 0x4F83A800, 0x82412400, 0x1DA01600, 0xF6D16D00, 0xBFA84080, 0xBB672640, 0xE0091620, 0xF0B4EFD0, 0x38228008, 0xFD92400C, 0x0788200A, 0x86F59009 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x48000000, 0x8C000000, 0xD6000000, 0x39000000, 0xD5800000, 0x32400000, 0xB2A00000, 0x72100000, 0x53D80000, 0x82CC0000, 0xCB820000, 0x47430000, 0x91208000, 0xA9534000, 0x7CF92000, 0x4E9E3000, 0xFCF95800, 0x8E9FE400, 0xDCF9D600, 0x5E9C8900, 0x94F96A80, 0xD29FB840, 0x42F9B760, 0xEB9C9F30, 0x97788008, 0xD9DF400C, 0x25DB2002, 0xABCD300D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xD8000000, 0xF4000000, 0x3E000000, 0x95000000, 0x8F800000, 0x3D400000, 0xF3200000, 0x2EF00000, 0xADC80000, 0x0A0C0000, 0x8B220000, 0x4AF30000, 0x6BC88000, 0x3B0D4000, 0xE2A16000, 0x16B0D000, 0x29687800, 0xBDBF1400, 0x33CB5E00, 0x0F0C2500, 0xFCA1B480, 0xD3B0AFC0, 0x7EEB6920, 0x74FE4D30, 0xFEE87808, 0xB4FF140C, 0xDEEB5E02, 0xE4FC2505 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x98000000, 0xA4000000, 0x7A000000, 0xD5000000, 0x02800000, 0x60400000, 0x51E00000, 0x88700000, 0x8C280000, 0x47C40000, 0x0BE20000, 0xAD710000, 0xB6AA8000, 0x3386C000, 0xB8006000, 0x54039000, 0x42036800, 0xC1019400, 0xE0826A00, 0x11431100, 0x2960AF80, 0x3D3175C0, 0xDF4A3AA0, 0xAFF49E10, 0xD62B6808, 0x62C59404, 0x31606A0A, 0xD932110B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x18000000, 0x34000000, 0x8A000000, 0x9D000000, 0x67800000, 0x82400000, 0x40E00000, 0x60F00000, 0x91480000, 0x29440000, 0x2D620000, 0xBFB30000, 0x162A8000, 0xFBF4C000, 0xE4CA6000, 0xC207D000, 0x2002A800, 0xF001B400, 0xB8037E00, 0x04021900, 0x92034B80, 0xA90327C0, 0xED81F320, 0x1F40D810, 0x27602808, 0xE2B1740C, 0xD1AB1E0A, 0x49B6C903 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x08000000, 0x4C000000, 0x02000000, 0xB5000000, 0x36800000, 0xC2C00000, 0x14200000, 0x07500000, 0x1BF80000, 0x50340000, 0x48A20000, 0xAC910000, 0xD35B8000, 0xBCA74000, 0x7BFA2000, 0xC0343000, 0xA0A18800, 0x30909400, 0xD95B7A00, 0x45A57B00, 0x4F7A7880, 0xB7F6F940, 0x82013DE0, 0xF502DFD0, 0xD6820808, 0x12C3D404, 0x1C235A0E, 0x4B504B0D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x68000000, 0x4C000000, 0x76000000, 0xF7000000, 0x36800000, 0xD7400000, 0x87E00000, 0xEF300000, 0xA3A80000, 0xD5440000, 0x23AA0000, 0x15470000, 0xC3A98000, 0x45464000, 0xABA82000, 0x09477000, 0xDDA9F800, 0xFE44AC00, 0xEB292200, 0x2907F100, 0x6CCB3D80, 0xC6344DC0, 0xCF61B320, 0x137318D0, 0xECCB3D88, 0x06344DCC, 0x2F61B32E, 0x437318D5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xC8000000, 0x74000000, 0x52000000, 0x03000000, 0xEB800000, 0x6F400000, 0x64600000, 0xDAF00000, 0x17980000, 0x297C0000, 0xA59A0000, 0xFA7D0000, 0xE61B8000, 0x713F4000, 0x1878A000, 0xDCCE9000, 0xB661E800, 0x99F29C00, 0x9C184600, 0xD63E2100, 0x09FA5780, 0x548E0AC0, 0xA380A9E0, 0x5B413F30, 0x56625788, 0x49F20AC4, 0x341AA9E6, 0x323C3F39 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0xB8000000, 0x04000000, 0x6E000000, 0x97000000, 0xF2800000, 0xEDC00000, 0x13600000, 0x5C900000, 0xDB580000, 0x31E40000, 0x09DA0000, 0xCC270000, 0x02B88000, 0x44B44000, 0x0FE26000, 0xE6505000, 0x9AB9D800, 0x50B50C00, 0x79E29200, 0xA552FB00, 0xBE38BF80, 0x2E77D940, 0xF6000AE0, 0x830112D0, 0x84803F88, 0xAEC3994C, 0x37E26AEA, 0x225142DD } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x68000000, 0xEC000000, 0x22000000, 0x2B000000, 0x36800000, 0x9D400000, 0x6A200000, 0x16700000, 0x4DE80000, 0x330C0000, 0x936A0000, 0x824F0000, 0x3B498000, 0x8F3FC000, 0x28202000, 0xCD707000, 0xF36AA800, 0x724FDC00, 0xB34BF200, 0x533E6900, 0x62207A80, 0x0A7140C0, 0xE7EA6520, 0xC40D90F0, 0xEFE9FA88, 0xD80E80CC, 0x45EA452E, 0x2F0DE0F3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x28000000, 0xD4000000, 0x8A000000, 0xFF000000, 0x84800000, 0x73C00000, 0x13200000, 0xC2B00000, 0xFB380000, 0x361C0000, 0x401A0000, 0xE0AF0000, 0x11228000, 0x19B3C000, 0xFDB82000, 0x5EDF9000, 0x75B88800, 0x7ADFAC00, 0xF7BABA00, 0x61DDF300, 0xD1387E80, 0x391E55C0, 0xCC9BA860, 0x776CBEB0, 0xA000F688, 0xF001F9CC, 0x08011262, 0xE4014DB3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xB8000000, 0x84000000, 0x1A000000, 0xAF000000, 0xBD800000, 0xDFC00000, 0x14E00000, 0x43500000, 0xDA380000, 0x4E1C0000, 0x4CDA0000, 0x364D0000, 0x29608000, 0xDC904000, 0x6ED86000, 0x5D4F5000, 0x2EE08800, 0xFC51AC00, 0x7FB81E00, 0x45DC8300, 0xFA3A4580, 0x5E1D6240, 0x54DBD360, 0xE24EC930, 0x8B62CD88, 0xF790CE44, 0xC959CD6A, 0x2D8F4A35 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x08000000, 0xF4000000, 0xF6000000, 0x8B000000, 0xC9800000, 0x55400000, 0x67200000, 0xF3F00000, 0x34780000, 0x57440000, 0x1ADA0000, 0xB1F50000, 0xA9818000, 0x6540C000, 0x8F23A000, 0x77F21000, 0xCA7BF800, 0x2845FC00, 0x255AFE00, 0x6FB67900, 0x07233A80, 0xC3F25AC0, 0xDC7AED60, 0xD34482D0, 0xE4D94288, 0xCEF766C4, 0x9603B36E, 0xBB00EBD7 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x68000000, 0xF4000000, 0x62000000, 0xDF000000, 0x79800000, 0xDD400000, 0x76E00000, 0x2CF00000, 0xCFB80000, 0x51EC0000, 0xC8DA0000, 0x845D0000, 0x9B818000, 0x42434000, 0xEF622000, 0x61B19000, 0xD1582800, 0x891CAC00, 0x65626E00, 0x0AB10900, 0x2ADBBD80, 0x1B5D86C0, 0x02014560, 0x0F032470, 0xF1821588, 0xB9426AC4, 0x7CE10B6E, 0x07F3BD79 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x18000000, 0xDC000000, 0x42000000, 0x37000000, 0x20800000, 0xF1400000, 0x28600000, 0x94900000, 0x87880000, 0xA83C0000, 0x556A0000, 0xE6EF0000, 0xF8038000, 0x4C024000, 0x3A01E000, 0xBB023000, 0x7A816800, 0x1A43AC00, 0x4AE18A00, 0x52D31900, 0x8F682380, 0xCDED9740, 0xFA80BFA0, 0xDA43F2B0, 0x2AE2CB88, 0x02D07B4C, 0x976AD5A6, 0x11EDDBB5 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0xF8000000, 0x34000000, 0x62000000, 0xF5000000, 0xA8800000, 0xFCC00000, 0x8E200000, 0x53F00000, 0xC7780000, 0x95740000, 0xB8020000, 0xD4E50000, 0xB2808000, 0xFDC0C000, 0x64A02000, 0xAA30F000, 0x19D8F800, 0x0E443400, 0x935A6200, 0xE761F500, 0x657A2880, 0x40913CC0, 0xE0022E20, 0xD0E563F0, 0x08809F78, 0xCCC09174, 0x56200202, 0x97F0E5E5 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xF8000000, 0xEC000000, 0x7E000000, 0x61000000, 0x5C800000, 0xE6C00000, 0xDDA00000, 0x2A700000, 0x93380000, 0x13CC0000, 0xD3CE0000, 0x73790000, 0x83A08000, 0x7B70C000, 0x97B8A000, 0xE90CF000, 0x886EF800, 0xD409EC00, 0x3218FE00, 0xEF7CA100, 0xC556FC80, 0x56C516C0, 0x4556A5A0, 0x96C50670, 0xE556CD38, 0x66C542CC, 0x1D56574E, 0x8AC549B9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x58000000, 0x2C000000, 0x9A000000, 0xF9000000, 0x3C800000, 0xB2C00000, 0xAD200000, 0x3A300000, 0x89980000, 0x448C0000, 0x2EEA0000, 0x6F810000, 0xEF208000, 0x2F30C000, 0x0F182000, 0xBF4CB000, 0xE74A5800, 0xCB712C00, 0x51981A00, 0xA88C3900, 0x94EA1C80, 0x268102C0, 0x8BA07520, 0xB1F0D630, 0x38383398, 0x7C7C0D8C, 0x52524A6A, 0x3D3DF141 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xD8000000, 0xAC000000, 0x8E000000, 0x09000000, 0x9E800000, 0xA1C00000, 0xCAA00000, 0x33700000, 0x95780000, 0x085C0000, 0x24B60000, 0x6A350000, 0x43788000, 0x6D5CC000, 0x14362000, 0x72F5B000, 0xCF585800, 0x53EC6C00, 0xC5EEAE00, 0x40D9B900, 0xE016C680, 0x9045CDC0, 0x6880E4A0, 0x74C04A70, 0x2220F3F8, 0x87B0B59C, 0x9758B816, 0x3FECFC45 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xA8000000, 0x2C000000, 0xA2000000, 0x2D000000, 0xDA800000, 0xF9400000, 0xEC600000, 0x02B00000, 0x3D480000, 0x825C0000, 0x7D4A0000, 0x62610000, 0x8DC88000, 0xCA1C4000, 0xA1AAE000, 0x6891F000, 0x8C602800, 0xB2B06C00, 0x75484200, 0x5E5CDD00, 0x774A7280, 0x6361D540, 0xF548CE60, 0x1E5C6FB0, 0x974A07C8, 0x93618B1C, 0x5D48B92A, 0x325C0CD1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xC8000000, 0x7C000000, 0x82000000, 0x4F000000, 0xBE800000, 0xEDC00000, 0x21600000, 0xAB700000, 0x78680000, 0x746C0000, 0x1E9A0000, 0xFDCB0000, 0x39088000, 0x2F1CC000, 0x4EF2E000, 0xC5A73000, 0x6D924800, 0xE1D7BC00, 0x4B7AE200, 0x487BBF00, 0xBC801680, 0x62C061C0, 0x7FE08B60, 0x76B0A870, 0x91088CE8, 0xA31CAAAC, 0xE4F2037A, 0xC6A7F47B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x98000000, 0x2C000000, 0x06000000, 0xCD000000, 0x8A800000, 0x1BC00000, 0xFFA00000, 0xAD500000, 0x7AF80000, 0xB3DC0000, 0x5B2E0000, 0x1F290000, 0x9D588000, 0xF28CC000, 0x07D62000, 0x71F51000, 0xD4F61800, 0xDA65EC00, 0x632EA600, 0xE3291D00, 0x2358B280, 0x038CE7C0, 0x135641A0, 0x8B355C50, 0xA7D6EE78, 0xA1F5891C, 0x6CF6880E, 0xE665B4B9 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x98000000, 0x54000000, 0x3A000000, 0x9D000000, 0x7E800000, 0x7F400000, 0x17200000, 0xAB500000, 0x6DF80000, 0x96A40000, 0x83D20000, 0x71E10000, 0xC0D88000, 0xE0F44000, 0x30AAA000, 0x08059000, 0xCC2A1800, 0x6E451400, 0xA78A1A00, 0xE3554D00, 0x01D2C680, 0x68E1FB40, 0xBC589520, 0xC6B4B250, 0xFB0A1178, 0x1515B0E4, 0xF272C872, 0xB1F12CF1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x08000000, 0x84000000, 0xB2000000, 0xB9000000, 0xBE800000, 0x4FC00000, 0x55600000, 0xF8F00000, 0xAC280000, 0x66D40000, 0xB30A0000, 0x8BB50000, 0xC7C88000, 0x11E4C000, 0xAA42E000, 0xA591B000, 0xD0EA8800, 0x78854400, 0x6C80D200, 0x86C0C900, 0x03E05680, 0x83307BC0, 0x4348EF60, 0xA324C5F0, 0x13A2A0A8, 0x1BA19014, 0x9F22D8EA, 0x2D61FC85 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x78000000, 0x24000000, 0x9E000000, 0x47000000, 0x67800000, 0xF7400000, 0xDF200000, 0xB3100000, 0x71680000, 0x8C4C0000, 0x32520000, 0xE5D50000, 0xAA528000, 0x31D5C000, 0x2C52E000, 0x62D5F000, 0xADD29800, 0xF695D400, 0x8B720600, 0xF5C59300, 0x42BA6180, 0x3DD96440, 0xDEA0BEA0, 0xE750D750, 0x37C84FC8, 0xBF1C9B1C, 0x839A1D9A, 0x09C94EC9 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x78000000, 0x9C000000, 0xEE000000, 0x1B000000, 0xCB800000, 0xC3400000, 0xC7A00000, 0x05100000, 0x88680000, 0xC4740000, 0x225A0000, 0x3DA10000, 0x345A8000, 0x7AA1C000, 0xF1DA6000, 0x12E17000, 0x85FA1800, 0x48B1EC00, 0x2432F600, 0x92D5F700, 0x45803D80, 0xA8403440, 0x94207A20, 0xEA50F150, 0xD9C81248, 0x46648524, 0x8FB24812, 0x21952485 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x58000000, 0x7C000000, 0xC2000000, 0xE1000000, 0x0D800000, 0xD7C00000, 0x2AA00000, 0xF5300000, 0x9BA80000, 0xC0F40000, 0x20C60000, 0x702F0000, 0x48668000, 0x241F4000, 0xBE4EE000, 0x232B5000, 0xEC28B800, 0xDA342C00, 0xFDE6FA00, 0xDFDF8D00, 0x6EEE1780, 0x5B1B0AC0, 0xE0000520, 0x500093F0, 0x38008488, 0x6C008E04, 0x9A000BCE, 0x9D00D8EB } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xB8000000, 0xAC000000, 0x72000000, 0xB1000000, 0x03800000, 0xD2C00000, 0xC1600000, 0x9B900000, 0x4E480000, 0x0B740000, 0x864E0000, 0x3F0B0000, 0x68068000, 0x447F4000, 0x7648A000, 0xE7747000, 0xD44E9800, 0xBE0B9C00, 0xD3864A00, 0x3ABF5D00, 0xC528D180, 0xCDE413C0, 0x99865AE0, 0x67BFD550, 0x94A8C528, 0x9E24CDE4, 0xE3669986, 0x82EF67BF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x88000000, 0x44000000, 0x4A000000, 0x47000000, 0xDD800000, 0x42400000, 0xC3200000, 0x77100000, 0x75B80000, 0x966C0000, 0x715E0000, 0xFC950000, 0xA6E68000, 0xD9F9C000, 0x28386000, 0x142CB000, 0x527E6800, 0xFB853400, 0x5B5E4200, 0x0B95C300, 0x1366F780, 0xAFB9B540, 0x2918F6A0, 0x603CC150, 0xB0469498, 0x68A9927C, 0x34A09B66, 0xC250EBB9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xD8000000, 0xFC000000, 0xF6000000, 0xD5000000, 0xBF800000, 0x2C400000, 0xEEE00000, 0x09700000, 0x19080000, 0x21640000, 0xAD6A0000, 0xD3130000, 0x22828000, 0x9707C000, 0x98E0A000, 0x1C709000, 0x8688F800, 0x5D24AC00, 0x9B8A2E00, 0x26632900, 0xCD8AC980, 0x63633940, 0x8A0AF160, 0xE323B530, 0x4AEA8FE8, 0xC3534414, 0x1A623A62, 0x1B774B77 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0xAC000000, 0x6A000000, 0x85000000, 0xFB800000, 0xA8C00000, 0x84200000, 0xAE300000, 0x4B080000, 0xE0740000, 0x10860000, 0x388F0000, 0xFC2E8000, 0x320B4000, 0x2980E000, 0x91C01000, 0x2DA03800, 0x7FF0FC00, 0x06A83200, 0xCF842900, 0x4E2E9180, 0x5B0B2DC0, 0xD800FFA0, 0xEC0046F0, 0x0A00AF28, 0xD5001E44, 0xA380038E, 0x04C074FB } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xE8000000, 0x44000000, 0x5E000000, 0xAD000000, 0xEF800000, 0x68400000, 0x84600000, 0xFE500000, 0xFD280000, 0x07F40000, 0x2C620000, 0xDA4F0000, 0x53068000, 0x12DFC000, 0x6F802000, 0xA8403000, 0x24602800, 0xAE501400, 0x15283A00, 0x43F41100, 0x72621780, 0x774F2B40, 0xBC86BBE0, 0x7A9FDA10, 0xEBE00118, 0x56100F94, 0xD948174A, 0xA9A415FD } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x18000000, 0x04000000, 0xDA000000, 0x09000000, 0x22800000, 0xE8400000, 0xBC600000, 0x0E300000, 0x7B580000, 0x378C0000, 0x14C20000, 0x874D0000, 0x99D48000, 0xBFB94000, 0x18802000, 0x91403000, 0xE6E01800, 0x52702C00, 0x05380600, 0x34BC0100, 0x971A3680, 0x51810240, 0x13F688A0, 0xDE847A10, 0x466C8F18, 0x1745738C, 0x91FA26D6, 0x73F111E3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x88000000, 0x9C000000, 0x2E000000, 0x05000000, 0xAB800000, 0x1C400000, 0x6E200000, 0x25100000, 0xFBA80000, 0x94040000, 0xF26E0000, 0x0B070000, 0xFEAA8000, 0x3FD1C000, 0xEE202000, 0x65101000, 0xDBA80800, 0xC4041400, 0x7A6E2200, 0x97072700, 0xD0AA8B80, 0x3AD1C140, 0x45A00AE0, 0x79501710, 0xB5881388, 0xE1141D44, 0x81C61CEA, 0x03030201 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xC8000000, 0x3C000000, 0x3E000000, 0x67000000, 0xF9800000, 0xCC400000, 0x66600000, 0xB3100000, 0xABA80000, 0x5D240000, 0xC4FE0000, 0xB8CF0000, 0x66BB8000, 0x71A8C000, 0x10602000, 0x28103000, 0x4C280800, 0xA6641400, 0x931E3200, 0xFB9F0F00, 0x95738F80, 0xF89CD9C0, 0x86B61E60, 0x01BB0310, 0x880D9198, 0xDC13F8C4, 0x4E6DB8EA, 0xFF03E849 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x58000000, 0x44000000, 0x7E000000, 0x69000000, 0x5B800000, 0xDC400000, 0x5A200000, 0x87100000, 0xDAD80000, 0x9BEC0000, 0xBC420000, 0xCA0F0000, 0x6F7C8000, 0xC6D9C000, 0xA1A02000, 0xAB501000, 0xF8F80800, 0xE8FC2C00, 0x409A1600, 0x7CE31100, 0xF6BE9F80, 0xB996DA40, 0xCF7CB6E0, 0x36D9E710, 0xD9A03E88, 0x5F501DC4, 0xDEF828B6, 0xC5FC1BFB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x48000000, 0x74000000, 0xC2000000, 0xE7000000, 0xB5800000, 0xBA400000, 0x9B200000, 0xA3D00000, 0x2F180000, 0x81840000, 0xD82A0000, 0xCC190000, 0x5E078000, 0xE138C000, 0xD8982000, 0x9CC41000, 0x568A2800, 0x65892C00, 0xA23F9200, 0xB76CDD00, 0xEDAA1080, 0x365929C0, 0x65278560, 0xF2E8C290, 0xBF8014C8, 0x694025F4, 0x4CA01346, 0x4E9035A1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x98000000, 0xB4000000, 0x52000000, 0x07000000, 0xBF800000, 0x5A400000, 0x3B200000, 0x91D00000, 0xD3380000, 0xFDEC0000, 0x954A0000, 0x58F10000, 0xB5DF8000, 0x091DC000, 0x86B82000, 0xA4AC1000, 0x7BEA2800, 0xD0613C00, 0x2847A600, 0x8C61ED00, 0x166A3480, 0xCD2111C0, 0x0CE787E0, 0xB7F1EA90, 0x667208C8, 0x151D1974, 0x1895884E, 0x15ECC2BB } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xF8000000, 0x4C000000, 0xA6000000, 0x89000000, 0x6E800000, 0x1A400000, 0x17600000, 0x4BF00000, 0xA2F80000, 0x7C5C0000, 0x7E360000, 0x551B0000, 0x40808000, 0x272D4000, 0x93982000, 0x7EAC3000, 0x524E3800, 0x43071C00, 0xD1D6BE00, 0x75C65300, 0xD7E08980, 0xACDD5240, 0xD16003A0, 0x72F02A90, 0xD47803D8, 0x5A1C1DFC, 0x37563F3E, 0xDBEB2E57 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xB8000000, 0x3C000000, 0xDE000000, 0xDF000000, 0x29800000, 0x32400000, 0xE9200000, 0x62900000, 0x71D80000, 0x5E3C0000, 0x9F2E0000, 0x09E70000, 0x026B8000, 0x5176C000, 0x5EF82000, 0xAFAC1000, 0x81760800, 0xB69B0C00, 0x3BE5AE00, 0xEB41CF00, 0x33EB9780, 0x2F36E7C0, 0xF1D82260, 0x1E3C1090, 0xBF2E1C48, 0x39E71BA4, 0xBA6B85F6, 0x6D76EF4F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xF8000000, 0x3C000000, 0x6E000000, 0x19000000, 0x50800000, 0xCA400000, 0x7B200000, 0xAFD00000, 0x97A80000, 0x4B9C0000, 0x55AE0000, 0x64EF0000, 0xF0288000, 0x68524000, 0x64082000, 0x820C1000, 0x8F262800, 0x75A33400, 0xF4AEBE00, 0xA8614F00, 0x842EBB80, 0xF2215640, 0xA70E9C20, 0xB1F15690, 0xA6A6A8C8, 0xDF6D40F4, 0xCD88886A, 0x68C27FA7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xC8000000, 0xBC000000, 0x4E000000, 0x57000000, 0x80800000, 0x0A400000, 0xFD200000, 0x8DB00000, 0xFFA80000, 0xA6840000, 0x110E0000, 0x4BDF0000, 0x74D78000, 0xB8724000, 0x84082000, 0x8A741000, 0xBD061800, 0xEDAB3400, 0x2FD1B200, 0x6ED96F00, 0xAD59B380, 0x05ED45C0, 0x23FF9820, 0x38B66690, 0x8E263548, 0x771B286C, 0x30F9866A, 0x121D6761 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xA8000000, 0xD4000000, 0xFA000000, 0xF9000000, 0x92800000, 0x19400000, 0x42A00000, 0x21500000, 0x8EF80000, 0xA7040000, 0x59920000, 0x36F90000, 0x2B2E8000, 0xFFD04000, 0x51922000, 0x12F91000, 0x592E8800, 0x62D06C00, 0x91120A00, 0x26B92500, 0x730EB680, 0xA3C05240, 0xCFCA2EA0, 0xB9AD2350, 0xE6C4A628, 0x136D5A14, 0x338E8D1E, 0xD7804A91 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x58000000, 0x1C000000, 0x72000000, 0x4F000000, 0xA1800000, 0x77400000, 0x4DA00000, 0xBD300000, 0xAEF80000, 0x369C0000, 0x8AB60000, 0xA8850000, 0x0FE18000, 0xEA0DC000, 0xF3362000, 0x83C51000, 0xD041B800, 0xA83DEC00, 0xA44E3600, 0xDE191700, 0x6557A480, 0xF288FFC0, 0xA4D79E60, 0x75C8CAD0, 0x517797E8, 0x64F8C08C, 0xD58F8DDE, 0x0164EB77 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x88000000, 0x34000000, 0xA2000000, 0x03000000, 0x41800000, 0xF7400000, 0x03A00000, 0x04100000, 0x9A080000, 0x4F140000, 0x0FB20000, 0xEA550000, 0xD73B8000, 0x13A1C000, 0x2C122000, 0xFE451000, 0x6533A800, 0x38B5D400, 0x09A00200, 0x23101D00, 0x51880080, 0xDF5414C0, 0x67923260, 0x2E0530D0, 0xAD13A868, 0xACE5C1C4, 0xFB8816E2, 0xA8543E15 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0xB8000000, 0x1C000000, 0x82000000, 0xFB000000, 0xED800000, 0x87400000, 0xFFA00000, 0x24300000, 0xDE480000, 0x992C0000, 0xC6E60000, 0xD2DD0000, 0x64938000, 0x59A7C000, 0x01462000, 0xAAED1000, 0xD8DBB800, 0xEB8BF400, 0x92200E00, 0xE3701700, 0xC1E81880, 0x6D1C0AC0, 0xA0AE1560, 0x57F126D0, 0x20759F68, 0x707AF7CC, 0x8855ACF2, 0x740AD79B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x48000000, 0xAC000000, 0x06000000, 0x95000000, 0x05800000, 0xC9400000, 0x3BE00000, 0x08100000, 0xCC680000, 0xB6740000, 0xCD5E0000, 0xE1A70000, 0x635C8000, 0xA8E1C000, 0x98BE2000, 0x00B73000, 0x44B4A800, 0xFED5C400, 0x25803200, 0x19401B00, 0xD3E02980, 0xB4102140, 0x82681360, 0x8F741950, 0xCEDE0F78, 0xBDE72744, 0x5D3CB27A, 0x69B1DFCD } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xF8000000, 0x34000000, 0x1A000000, 0xFF000000, 0xF3800000, 0x93400000, 0x2DA00000, 0x3E700000, 0x3D480000, 0x88CC0000, 0x52B20000, 0x8D910000, 0xCE358000, 0x750CC000, 0x94922000, 0x84A11000, 0x5CDD9800, 0xD8B0F400, 0xEAE81E00, 0xD9BC1D00, 0x047A1E80, 0x721D0BC0, 0x532782E0, 0x0DEDE9D0, 0x8E6FADE8, 0x1521E05C, 0x44DD8BB2, 0x7CB0E2E3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x28000000, 0xFC000000, 0xB2000000, 0x5B000000, 0x3F800000, 0x7F400000, 0x89E00000, 0x22700000, 0xB3680000, 0xA3A40000, 0xDD360000, 0xFAAD0000, 0xE1A38000, 0x7E6EC000, 0x71562000, 0xC09D3000, 0x36AB9800, 0xCBFAC400, 0x81682A00, 0x38A40F00, 0x82B63480, 0x95ED12C0, 0x404385E0, 0xA01EE0D0, 0x703E2EF8, 0x38392E5C, 0xD41DBB3A, 0x4E17F339 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x08000000, 0x4C000000, 0xF6000000, 0x7F000000, 0x76800000, 0x19400000, 0x11A00000, 0x7BF00000, 0x8AF80000, 0xA7540000, 0x42AE0000, 0xCB170000, 0xE4A58000, 0x8C124000, 0xD6562000, 0x2F431000, 0x4E8B9800, 0x5D454C00, 0xABD3A200, 0xF2E14300, 0x83058580, 0xC8E243C0, 0x4A2E27A0, 0xA1570950, 0x1585A3E8, 0xA1A25E3C, 0x338E209E, 0xA6A73345 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0xB8000000, 0x7C000000, 0x4A000000, 0xF3000000, 0x90800000, 0x81400000, 0x5FA00000, 0xFB900000, 0x5DD80000, 0x8CEC0000, 0x5B360000, 0xC4B10000, 0xDF338000, 0x52974000, 0x166E2000, 0x891D1000, 0x7BA5A800, 0x1DB65C00, 0x2C858E00, 0x2B664F00, 0x7CFD9A80, 0xA31A70C0, 0x18938220, 0xE5077350, 0x19B62368, 0xFAF11124, 0x4213A7D6, 0xD7477CAB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x88000000, 0xD4000000, 0xEA000000, 0xB7000000, 0xF5800000, 0xA5400000, 0xFEA00000, 0x7E900000, 0x3EB80000, 0x9EF40000, 0x2E820000, 0xA6D90000, 0x729D8000, 0x98C9C000, 0x2FBA2000, 0xDA6D1000, 0x7F3FA800, 0x81C0EC00, 0xFF3F8200, 0xC1C0E500, 0x5F3FB280, 0x71C0D1C0, 0xD73F9760, 0xA5C0E050, 0x3D3FAF28, 0x12C0FB64, 0xC8BFA24E, 0xB780EA2D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x08000000, 0x34000000, 0x1A000000, 0xD1000000, 0xAC800000, 0x57400000, 0x43A00000, 0x18D00000, 0x0D480000, 0xB2B40000, 0xE4620000, 0x52010000, 0xC5668000, 0xE6E94000, 0x8E0A2000, 0xDB251000, 0x55EC8800, 0x9F8C5400, 0x06C6A200, 0xBE395D00, 0xA3422E80, 0x39913040, 0xB98EA120, 0xF98D4CD0, 0xD9A03468, 0x89D02F74, 0x81C826F2, 0xB5F4193D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x08000000, 0xE4000000, 0xE6000000, 0x07000000, 0x10800000, 0x7D400000, 0x5DA00000, 0x08F00000, 0x21180000, 0x37940000, 0xFDFA0000, 0xD8EF0000, 0xB9258000, 0x2BE14000, 0xF7C22000, 0xDDCB1000, 0x48E79800, 0x412A7C00, 0xC7A5A200, 0xF5A16900, 0x3CE20180, 0x5F7B2DC0, 0x2CDF9E20, 0xE70E5A50, 0xA0E78CE8, 0x152A6AFC, 0x49A58DE6, 0xE6A17F75 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x38000000, 0xAC000000, 0xA2000000, 0xCF000000, 0x57800000, 0x2FC00000, 0x63A00000, 0x51B00000, 0x16E80000, 0xD5740000, 0xF4E20000, 0xFA130000, 0x33448000, 0x5DC74000, 0xC4C4A000, 0x02077000, 0xBF64A800, 0x4FB75C00, 0x338CA600, 0xF9C37700, 0x32EE8E80, 0xE31044C0, 0x358A1B60, 0xC0A70F30, 0x8406A388, 0x46646B5C, 0xD9680E32, 0x26B40201 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x78000000, 0x6C000000, 0x7E000000, 0xFF000000, 0x18800000, 0xC0C00000, 0x7CA00000, 0x5AB00000, 0xD9B80000, 0xC7040000, 0x94F20000, 0x8EED0000, 0xEBE28000, 0x5676C000, 0x0B62A000, 0x3AB6F000, 0x29C2A800, 0x8F06F400, 0x90FAB600, 0xE4C2EF00, 0x06A8A980, 0xCF9FD0C0, 0x2C722FA0, 0x9E2D20F0, 0xCF429088, 0x70C6C65C, 0xD4DA8EE6, 0x6EB2C39D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xD8000000, 0xF4000000, 0xD2000000, 0xAB000000, 0x98800000, 0x90C00000, 0xECA00000, 0x82F00000, 0xE7E80000, 0x2A040000, 0xAF3E0000, 0x32B70000, 0xFFF28000, 0x7E46C000, 0x4D72A000, 0x4186F000, 0x93528800, 0x3CB6FC00, 0x0A9ABE00, 0x5B82C100, 0xE46C8A80, 0xFA01EBC0, 0x27682CA0, 0x8EC40FF0, 0x319E3788, 0x2B471F4C, 0x589AA672, 0x3082D9CD } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x08000000, 0x0C000000, 0x72000000, 0xF9000000, 0x4A800000, 0x86C00000, 0x14E00000, 0x7DB00000, 0x0F280000, 0x8DEC0000, 0xE70A0000, 0x11830000, 0xAD578000, 0xECDEC000, 0x99B7A000, 0xE16ED000, 0x3E9F8800, 0x5082DC00, 0xA3958A00, 0xB401DF00, 0x36421680, 0x271F2140, 0xF195A420, 0x3D01D0F0, 0xD4C22918, 0x9DDF139C, 0x9F75A0D2, 0xB5B1EFE7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x28000000, 0xE4000000, 0x1E000000, 0x0D000000, 0x4F800000, 0x03C00000, 0xB9E00000, 0xCAD00000, 0xD8780000, 0xBC2C0000, 0xE27E0000, 0x8F410000, 0x90EF8000, 0xBB1C4000, 0xE68FA000, 0x320C5000, 0xE717B800, 0x14F04400, 0xF511B200, 0xC39D7D00, 0x99803580, 0xFAC03E40, 0xA0600660, 0x70102EB0, 0x18183018, 0x9C3C0804, 0xD2660C06, 0xF77D1E0F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x38000000, 0x2C000000, 0xD2000000, 0x8D000000, 0x70800000, 0x14C00000, 0xB2E00000, 0x51F00000, 0xF6280000, 0x0B740000, 0x23C20000, 0x8B7B0000, 0x63858000, 0xAB51C000, 0xD3E5A000, 0x9361D000, 0xFFADA800, 0x4125FC00, 0x72A7A600, 0x31DAF700, 0x66481280, 0x83441440, 0x378A2EA0, 0x753F0170, 0x3C8F8A18, 0x56AEF90C, 0xB78A1992, 0x353F20D1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xD8000000, 0xEC000000, 0xF2000000, 0x65000000, 0x87800000, 0x05C00000, 0x48A00000, 0xCB100000, 0x58F80000, 0xB3340000, 0x84D20000, 0xC9130000, 0xD5F58000, 0x50944000, 0x470DA000, 0xFAA07000, 0x0E5FB800, 0xEF736400, 0x3E8A0E00, 0xF8371F00, 0x1C5F9280, 0x1A737640, 0x010A0B60, 0x41F71330, 0x7EFF9748, 0x58637EF4, 0x2C7233F6, 0x92031479 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x58000000, 0xC4000000, 0x66000000, 0x3B000000, 0x39800000, 0xD7C00000, 0x10A00000, 0xBB700000, 0xF9F80000, 0x77F40000, 0x80A60000, 0xE30D0000, 0x3DB48000, 0x11C64000, 0xBBCCA000, 0xDAF27000, 0xEA4A8800, 0x014F5400, 0x00A61E00, 0x230D2500, 0x9DB4A780, 0x81C65BC0, 0xE3CCA1E0, 0x1EF27A30, 0x8C4A9BC8, 0x3A4F41EC, 0x39262A36, 0xF4CD23D1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xB8000000, 0xB4000000, 0xFA000000, 0x47000000, 0xD1800000, 0x1FC00000, 0xE2E00000, 0x94100000, 0x4A580000, 0x0F240000, 0xCD8E0000, 0xE9BB0000, 0xEBE48000, 0xF8A64000, 0xC35CA000, 0x23925000, 0xA48A9800, 0xD50D5400, 0x3AE03600, 0x70103900, 0xE8582880, 0xEC2438C0, 0x5E0E24E0, 0x057B3B30, 0x2284B258, 0x34767334, 0xBA64BE4E, 0xA766713D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xB8000000, 0x14000000, 0xD2000000, 0x6D000000, 0x25800000, 0x73C00000, 0x54E00000, 0x38500000, 0x54380000, 0xB2440000, 0x3D7E0000, 0x9DBF0000, 0x67958000, 0x86AD4000, 0x554DA000, 0x71B95000, 0xC18BB800, 0x69824400, 0xA5801600, 0x33C00100, 0x34E00280, 0x68500A40, 0xEC3813E0, 0xA64402B0, 0xEF7E28D8, 0xF0BF09A4, 0x42158956, 0xF56D7E75 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x38000000, 0x2C000000, 0x86000000, 0x79000000, 0xE2800000, 0xD8C00000, 0xAFE00000, 0xC0100000, 0xA0280000, 0x10140000, 0xC8720000, 0x14490000, 0xAA698000, 0xFF0EC000, 0x9BA1A000, 0x3A0AD000, 0x777B9800, 0x6F97EC00, 0x60001600, 0xB0002700, 0xD8001780, 0xDC002940, 0xBE001720, 0x55002370, 0x648032D8, 0xA1C01874, 0x4D603B52, 0x18D00231 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x48000000, 0x34000000, 0x3E000000, 0x1B000000, 0xE0800000, 0xE2C00000, 0xD3A00000, 0xC6500000, 0xA7080000, 0x0ACC0000, 0xF7E60000, 0x60010000, 0xF0188000, 0xA80AC000, 0x0430A000, 0x7656F000, 0x2F7E9800, 0xDECBFC00, 0xF9880A00, 0x330C3100, 0x24C62580, 0x749107C0, 0xCCB0A5A0, 0x5096F370, 0x6ADEA348, 0x079BFFE4, 0xC8003D0A, 0xF4003797 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x98000000, 0x9C000000, 0x4E000000, 0x59000000, 0x07800000, 0xDDC00000, 0xDEA00000, 0x1A300000, 0x23080000, 0x34A40000, 0xA13A0000, 0x8BC50000, 0xDB958000, 0x73D04000, 0x57BDA000, 0x75847000, 0xFAAFA800, 0x38154C00, 0xAC280E00, 0xF6542B00, 0x35123D80, 0xD1910D40, 0x1887B460, 0x97414630, 0x9EBA05C8, 0xFA0517BC, 0xF335B68A, 0x5CE040D5 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x84000000, 0x92000000, 0x91000000, 0xBD800000, 0x8CC00000, 0x61600000, 0xC5B00000, 0x30D80000, 0x6F6C0000, 0x4AF60000, 0x0A530000, 0x5D2D8000, 0x8BC04000, 0x9FDBA000, 0x45935000, 0x70F62800, 0x4F531400, 0x5AAD8A00, 0x02006500, 0xD93B8680, 0x19E35540, 0x0ECE23E0, 0xF84F1370, 0xFC63BD38, 0x2E4F775C, 0x9F5812EE, 0x32AC3FF7 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x78000000, 0xAC000000, 0x3A000000, 0x0D000000, 0xF1800000, 0x6CC00000, 0xF5200000, 0x9DF00000, 0x76A80000, 0x08640000, 0x141A0000, 0xB6230000, 0xC75F8000, 0x84944000, 0x3145A000, 0xA3B77000, 0x659A2800, 0x1AE30C00, 0x127F9600, 0xE9645700, 0x3FEDB080, 0x07D35840, 0x4B801AE0, 0xA1C01470, 0x24A01728, 0x01302B4C, 0xFB883062, 0x39940D25 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x98000000, 0x6C000000, 0xAA000000, 0x83000000, 0xD7800000, 0xC0C00000, 0xA1600000, 0x30D00000, 0x99280000, 0x8CF40000, 0x9B4A0000, 0xFBDB0000, 0x8AE88000, 0x12644000, 0x7F42A000, 0x35AF5000, 0x87E21800, 0x28EF1C00, 0xB5429E00, 0xC6AF5700, 0x28622C80, 0xB42F2BC0, 0x2622A760, 0x197F5CF0, 0xCCCA1BB8, 0x7B1B3704, 0xCB889C92, 0x12B443C9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x28000000, 0x8C000000, 0x2E000000, 0xC3000000, 0xAE800000, 0x79C00000, 0x9D200000, 0xE5D00000, 0x0B680000, 0xD2EC0000, 0x1FA20000, 0xE2690000, 0x4D328000, 0x3DD8C000, 0xCF30A000, 0x40A1F000, 0xDACA3800, 0x03853C00, 0xB4109200, 0x1A71EF00, 0x19222180, 0xD7A923C0, 0x9E12B820, 0x2B08E2B0, 0x42D8A6E8, 0x678DF404, 0x76481612, 0xC73C010F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x48000000, 0x6C000000, 0x4E000000, 0x3B000000, 0x94800000, 0xC1C00000, 0xBE200000, 0xB3500000, 0x98880000, 0xFFDC0000, 0xCD320000, 0x4BC10000, 0x17728000, 0x7AABC000, 0xEAC8A000, 0x12B6F000, 0x56883800, 0x04DC2C00, 0x39B20A00, 0xFA010700, 0xE1528180, 0xA5FBD5C0, 0x3C4096A0, 0xD66ACEB0, 0x0F3A32A8, 0x8EDD30A4, 0x90E083AA, 0x33FAD423 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x58000000, 0x44000000, 0x1A000000, 0xF1000000, 0x4E800000, 0xF5C00000, 0x32600000, 0x3D100000, 0x28F80000, 0xCAA40000, 0xCFEE0000, 0x337F0000, 0xBBAD8000, 0xC14BC000, 0xA6BBA000, 0x1990D000, 0xA4783800, 0xCA643400, 0xC90E0E00, 0x9AAF3500, 0xB7B59080, 0x873FED40, 0x69CDB520, 0x2C5BD130, 0xB643A738, 0x0734C634, 0x299628A6, 0x4C1B18ED } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xC8000000, 0xE4000000, 0x42000000, 0xBD000000, 0x6A800000, 0x05C00000, 0x2A200000, 0x89100000, 0xF0880000, 0x64DC0000, 0x2EB60000, 0x97830000, 0x4F578000, 0x3FE7C000, 0x9B69A000, 0x55B8F000, 0x32081800, 0xB51C0C00, 0x6E960A00, 0xB7930500, 0x5F5FA280, 0x07FBD640, 0xB77FAA20, 0xF3EBDE30, 0xCD778828, 0x62F7EF34, 0x01E19CAA, 0x9864CE73 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x48000000, 0xDC000000, 0x92000000, 0x53000000, 0x6C800000, 0x85C00000, 0x36600000, 0xE5500000, 0xC9F80000, 0xAC6C0000, 0x8A6A0000, 0x27570000, 0x32E88000, 0x0CFBC000, 0xD5FAA000, 0x9E00D000, 0x29181800, 0x13FC1400, 0x23722A00, 0x74AB3300, 0xF19AB680, 0x6850E3C0, 0x6C601FA0, 0x2A5025B0, 0xD7782EB8, 0x6AAC1C24, 0x988A2DE6, 0x9BC7254F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x98000000, 0x6C000000, 0x2E000000, 0x71000000, 0x7C800000, 0xEBC00000, 0xD2200000, 0x67500000, 0xD1D80000, 0xF1640000, 0xBC9A0000, 0x8BD10000, 0x02678000, 0xFF1AC000, 0xBDA5A000, 0xDF6FF000, 0xCDF83800, 0xF7340400, 0xE9C23E00, 0x2D752F00, 0xDADDAD80, 0x0E9BC740, 0x3C9A34A0, 0x4BD116B0, 0x6267B3A8, 0x2F1AD724, 0x25A586FE, 0xB36FCE8D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xB8000000, 0xAC000000, 0x06000000, 0xFD000000, 0xEF800000, 0xF8C00000, 0x8C200000, 0xF6300000, 0xE5480000, 0x73C40000, 0x46CA0000, 0xDD750000, 0x1FCD8000, 0xE0814000, 0x106FA000, 0x48007000, 0xB4200800, 0x9A303C00, 0x43480600, 0xBEC42700, 0x114A2F80, 0x89B51440, 0x95EDBA60, 0xEBB14170, 0x1AA7B8E8, 0xC30473BC, 0x7ECA125A, 0xB1751D7D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x58000000, 0x14000000, 0x5A000000, 0x75000000, 0x6C800000, 0x87C00000, 0xDC600000, 0xF6700000, 0xCB780000, 0x4B840000, 0xD2660000, 0x79070000, 0x82C78000, 0xF8E4C000, 0x9DB9A000, 0x0917D000, 0xCAE00800, 0x14B00400, 0x83983E00, 0x7E341100, 0xC77E0080, 0xA5F31840, 0xAD598DA0, 0x38A7FCB0, 0x7DF80C38, 0xF9440C6C, 0xC2862DC6, 0x58B73B7D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xE8000000, 0x94000000, 0x42000000, 0x7B000000, 0x49800000, 0x3CC00000, 0x90200000, 0x58500000, 0x1C080000, 0xA64C0000, 0xD13E0000, 0xA6EB0000, 0x375C8000, 0xD7F94000, 0x81CAA000, 0x78CE7000, 0x2A003800, 0x2F002C00, 0x6B802200, 0x37C03900, 0x31A02A80, 0xF0903BC0, 0xCE2802E0, 0x851C11F0, 0x84B63668, 0x3C671924, 0x7642A30A, 0x29427F87 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x28000000, 0x14000000, 0x4A000000, 0xE3000000, 0x6F800000, 0x72C00000, 0x70200000, 0xE8300000, 0x34080000, 0xBA3C0000, 0xCB0A0000, 0x7B850000, 0x38D28000, 0x9318C000, 0x87ABE000, 0x46D4B000, 0xCA000800, 0x23000C00, 0x4F800200, 0x82C00F00, 0x58200280, 0xFC300140, 0x7E0804A0, 0x593C0E30, 0xA48A06F8, 0x0945072C, 0x48F28702, 0x7B28CE83 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x28000000, 0x9C000000, 0x7E000000, 0xFF000000, 0x43800000, 0x79C00000, 0xB8200000, 0x14100000, 0x52380000, 0xF9140000, 0x088A0000, 0xD8670000, 0x40FF8000, 0x108FC000, 0x7C78E000, 0x6AD27000, 0x5D800800, 0x96C00400, 0x33A00E00, 0xA1D00500, 0xBC180280, 0x8E0409C0, 0x673207E0, 0xA7B30FF0, 0xB3D58438, 0xA538C79C, 0xD69F6B82, 0x9759B141 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x48000000, 0x1C000000, 0xAE000000, 0xF9000000, 0x6C800000, 0x95C00000, 0x7C200000, 0x3E300000, 0xE1080000, 0x489C0000, 0x6FD20000, 0x37270000, 0x059B8000, 0xE1764000, 0xCDE72000, 0xB8277000, 0x94200800, 0x92300C00, 0x27080200, 0xDD9C0700, 0xE5520480, 0x47E701C0, 0xBB3B8AE0, 0xB3864F90, 0x3C4F26C8, 0x5B4B795C, 0x66DA0FC2, 0xD3BB0FE3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x48000000, 0xBC000000, 0x0E000000, 0xE1000000, 0xB5800000, 0x3DC00000, 0x8C200000, 0xD6100000, 0x75180000, 0xD7B40000, 0x9AD20000, 0x648F0000, 0x50538000, 0x25C04000, 0x38296000, 0x04157000, 0x4A200800, 0xCB100400, 0xAE980600, 0xDB740D00, 0xEB720480, 0x335F0BC0, 0xA76B80E0, 0xC5644E10, 0x62636B58, 0x8AEE73DC, 0x0C8180C2, 0x5C4F4961 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x98000000, 0x34000000, 0x12000000, 0x43000000, 0x04800000, 0xB8400000, 0x46200000, 0x41300000, 0x3FB80000, 0x58F40000, 0x74460000, 0x701D0000, 0x680C8000, 0x9C1CC000, 0x6E132000, 0xFD051000, 0x61980800, 0xEDC40C00, 0xB9FE0E00, 0xBBE90D00, 0x80CA8980, 0x6041C340, 0x523FA120, 0x6329D430, 0x34B32848, 0xF0751784, 0xEA000262, 0x67000513 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x98000000, 0xEC000000, 0x0E000000, 0x29000000, 0x9F800000, 0xA9400000, 0x52200000, 0x8F300000, 0x32A80000, 0x1CD40000, 0xA8460000, 0x89AB0000, 0xAC5B8000, 0x63964000, 0x5F65E000, 0x673F5000, 0xD6880800, 0xC6E40C00, 0x336E0A00, 0xA93F0500, 0x5FBD8980, 0x094D4EC0, 0x023660E0, 0x170D1290, 0xDEA3E1F8, 0x12D45694, 0x81738722, 0x160241F3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xF8000000, 0xFC000000, 0x1E000000, 0x2B000000, 0x67800000, 0xC5400000, 0xAB200000, 0x27900000, 0x65680000, 0x9B2C0000, 0xDFAE0000, 0x99570000, 0x852B8000, 0xF4A4C000, 0xFECEE000, 0x405AD000, 0x5FAE0800, 0xD9570400, 0x252B8A00, 0xC4A4C300, 0x06CEEF80, 0xBC5ADFC0, 0x41AE09E0, 0xF25706B0, 0x42AB8C78, 0x01E4CF54, 0xADEEE532, 0x9BCADDB9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x68000000, 0x9C000000, 0x06000000, 0x2F000000, 0xF8800000, 0x2A400000, 0x7F200000, 0x30900000, 0xC6780000, 0x81040000, 0xEB8A0000, 0xA4DF0000, 0x82458000, 0x4321C000, 0x46B12000, 0x11571000, 0x8D8A0800, 0x5BDF0400, 0xF2C58E00, 0x6561C900, 0x57912680, 0x92C719C0, 0xB5720860, 0xDF9B06F0, 0x9EEF8188, 0xDB6ECBA4, 0x6C8CA172, 0x6072DAC9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0xA8000000, 0x44000000, 0xC2000000, 0x13000000, 0xCF800000, 0xE2400000, 0x71200000, 0x6CB00000, 0xA5C80000, 0xA77C0000, 0x77BA0000, 0x9E690000, 0x0F048000, 0x2182C000, 0x5740E000, 0x1FA51000, 0xFA720800, 0xBD150C00, 0x9ABE8200, 0xDCEBC700, 0x3FC46A80, 0x9867D440, 0x1E12E420, 0xDD001D30, 0x0A8486F8, 0x24C2C524, 0xA3E0EF92, 0xB655158B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x18000000, 0x7C000000, 0x8E000000, 0x6F000000, 0x52800000, 0x1FC00000, 0x59200000, 0x71B00000, 0x2B780000, 0x5DE40000, 0x90160000, 0xD8170000, 0x9C1F8000, 0x9E19C000, 0x770DA000, 0x2EBB7000, 0x91EE0800, 0x36330C00, 0x23298E00, 0x34BEC100, 0x04EA2180, 0xE186B7C0, 0xF355A0E0, 0xC1EF7AF0, 0x0E000328, 0xAF000CFC, 0xB2800A12, 0x0FC001DB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x08000000, 0xF4000000, 0xA6000000, 0x77000000, 0x65800000, 0xD3C00000, 0x45200000, 0xE4900000, 0xD9680000, 0xBF4C0000, 0x28720000, 0x5DE50000, 0x361D8000, 0x8F0BC000, 0x39A26000, 0x31CE7000, 0x9C3A0800, 0x02390400, 0xC9078A00, 0x5EA2CB00, 0xEC4DE080, 0xB3E0BF40, 0x1525E260, 0xFCACB370, 0x9557E458, 0xE549B23C, 0x0D4A66D2, 0xE9427E09 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x48000000, 0xF4000000, 0x26000000, 0x61000000, 0x17800000, 0x08C00000, 0xBB200000, 0x04B00000, 0xE8580000, 0x5D540000, 0x1CC20000, 0x8D350000, 0x4D958000, 0xDBE64000, 0x3BBEE000, 0x32D4B000, 0xB83A0800, 0xCC110C00, 0x2A2F8600, 0x2B374D00, 0xECB16480, 0xAC53FF40, 0xE3536A60, 0xC1D6FA10, 0x489EEF78, 0x0264B18C, 0x16620132, 0x20450E0B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x78000000, 0x74000000, 0x7E000000, 0x5F000000, 0xD0800000, 0x75400000, 0x7D200000, 0x2D900000, 0x18F80000, 0x85FC0000, 0xD86E0000, 0xB8950000, 0x496B8000, 0xEF0DC000, 0x08BB2000, 0x9179D000, 0x0B360800, 0x7EB90400, 0xC25D8E00, 0xD1B4C700, 0x2AE6A780, 0x30CD1740, 0x59D0AFE0, 0x3A7411F0, 0xE58D2B08, 0xB4C0D454, 0x1FEB8652, 0xF14DC699 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0xC8000000, 0x24000000, 0x8E000000, 0x39000000, 0x6A800000, 0x60400000, 0x5AA00000, 0xF8700000, 0x96A80000, 0xC2540000, 0xE99A0000, 0xB5DD0000, 0x6D798000, 0xB6334000, 0xA5332000, 0xB8B35000, 0xAB798800, 0x6B334C00, 0x61B32200, 0x71F35900, 0x53598480, 0xD7034E40, 0x23BB2AE0, 0x72D75A90, 0x46EB8228, 0xC0CA4844, 0xFDF8AF4A, 0x89491517 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0xF8000000, 0xBC000000, 0xCA000000, 0x39000000, 0x13800000, 0x55400000, 0xBBA00000, 0xD1700000, 0x6D880000, 0xF2440000, 0xBF360000, 0x08AB0000, 0x9BE48000, 0x5B754000, 0x34986000, 0x91EC1000, 0xC2648800, 0xF7354C00, 0x3CB86A00, 0xC5DC1D00, 0xEC4C8780, 0x680147C0, 0x240666A0, 0x06331E90, 0xDB1E06B8, 0x6E9F0294, 0x30DA8D1A, 0x1DDA4387 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xF8000000, 0xE4000000, 0xFA000000, 0xAD000000, 0xB6800000, 0x89C00000, 0x92A00000, 0x53D00000, 0x6FB80000, 0x2D5C0000, 0xFA460000, 0xA1C50000, 0xFEA88000, 0xD5D64000, 0xEC992000, 0x34D23000, 0x8C088800, 0xF6064400, 0x1B212600, 0xCD8E3300, 0x744E8780, 0x1EC34A40, 0xA909A9A0, 0x3C9879D0, 0xBCF7ACE8, 0xF00172DC, 0xD819288A, 0xB41238ED } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x68000000, 0xE4000000, 0x86000000, 0x9D000000, 0xE1800000, 0xB0C00000, 0xEDA00000, 0x12F00000, 0x16980000, 0x7E740000, 0x2FC20000, 0xC72D0000, 0x56B38000, 0x5E624000, 0xDFE7E000, 0xBF387000, 0xDA938800, 0x3C524C00, 0xC4DFEE00, 0xC3BC7100, 0x8BC98E80, 0x610B4240, 0x3BAE6660, 0xC7F338D0, 0xE31DE098, 0x3091794C, 0xD37A00BA, 0x566905FF } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xA8000000, 0x34000000, 0xD2000000, 0x59000000, 0xD6800000, 0xF1400000, 0x9AA00000, 0x8F500000, 0xADA80000, 0x96CC0000, 0xA9420000, 0x46A10000, 0x49468000, 0x56AF4000, 0xB1672000, 0xBAA51000, 0xFF668800, 0x05BF4400, 0xA2EF2200, 0x7B791700, 0x1FAC8280, 0x9FC24740, 0xA7E3AF20, 0x2BEB5290, 0x35E72FE8, 0x52E51854, 0x93468E8A, 0x0BAF4E65 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x88000000, 0xCC000000, 0x5A000000, 0x77000000, 0x4E800000, 0x23400000, 0xD4A00000, 0xB4500000, 0xAA080000, 0x8F340000, 0x3A8A0000, 0xAD570000, 0xBD948000, 0x1BFEC000, 0xEACD2000, 0x41411000, 0x379C8800, 0x44CAC400, 0xF8472A00, 0xB0161900, 0x58080080, 0xE43408C0, 0x060A0FA0, 0xA5170E70, 0xF5B48C68, 0x37EECEF4, 0x80E528EA, 0x2E651C35 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x68000000, 0xB4000000, 0xB6000000, 0x09000000, 0x40800000, 0xB9400000, 0x3EA00000, 0x54700000, 0x30180000, 0x482C0000, 0x24220000, 0xAE310000, 0xD5378000, 0x42AF4000, 0x067DA000, 0x770C1000, 0xADAF8800, 0xB7C34C00, 0x22FFAE00, 0x404D1700, 0xD6000E80, 0xB9000740, 0xC8800560, 0x7D400790, 0xE0A00288, 0xE97000D4, 0xC698088A, 0xF86C05D7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xB8000000, 0xE4000000, 0x86000000, 0x8D000000, 0x4B800000, 0x8EC00000, 0x79A00000, 0x1DF00000, 0xAB180000, 0xF6B40000, 0x8D560000, 0xBB5D0000, 0xBE5F8000, 0x59F24000, 0x1D1F6000, 0x33A2F000, 0x8AE78800, 0xEFB64C00, 0x28D16E00, 0x048BF100, 0xFE4E0380, 0x79E90240, 0xED098660, 0x9BAF49D0, 0xD6C0EF38, 0x8D90B6AC, 0x23D8E7FA, 0xC224B50F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x88000000, 0xBC000000, 0xBA000000, 0x6B000000, 0xBB800000, 0x27400000, 0x30A00000, 0x6CD00000, 0xFFF80000, 0x505C0000, 0xA10A0000, 0x788B0000, 0xF0F88000, 0x95DBC000, 0x037D6000, 0x2EBA9000, 0x59F28800, 0x1150C400, 0x2985E600, 0x60615B00, 0x690FE080, 0xA4AA5FC0, 0xFAD765A0, 0x76E199B0, 0x04F20D38, 0xB3D706B4, 0x0272862A, 0xC610C0BD } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x58000000, 0x54000000, 0x56000000, 0x33000000, 0x54800000, 0xE4C00000, 0x17A00000, 0x18700000, 0xCF780000, 0x05C40000, 0xBE1E0000, 0xAF290000, 0x6E8F8000, 0x85DBC000, 0x7E23A000, 0xCF057000, 0x3E918800, 0xDDF2CC00, 0x2A2C2600, 0x991EB500, 0x0D922D80, 0x8947B940, 0xCEE5AB60, 0x8E987A30, 0x15F80EC8, 0x4604020C, 0xCB3E079A, 0x309902F7 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x78000000, 0xDC000000, 0xCA000000, 0x43000000, 0xE3800000, 0x9C400000, 0xB8A00000, 0x73D00000, 0x06C80000, 0x1C7C0000, 0xF8860000, 0xD3C30000, 0x36E88000, 0x6445C000, 0x24BB6000, 0x19C65000, 0x75EE8800, 0x87C6C400, 0xB8F3EA00, 0xA1539300, 0x061DEF80, 0x813C99C0, 0xA4BB6EA0, 0x59C65330, 0xD5EE8BB8, 0xB7C6C304, 0xC0F3EAAA, 0x7D539DCD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x08000000, 0x5C000000, 0x3A000000, 0x2F000000, 0xAC800000, 0x94C00000, 0x5FA00000, 0xC2700000, 0x44480000, 0xA1740000, 0x1AFA0000, 0xE68B0000, 0x43F08000, 0x9732C000, 0xA8A4A000, 0x5ADD7000, 0x86AA8800, 0x73C9CC00, 0x0F1C2A00, 0xFC9BB900, 0x3CF42880, 0x939FB9C0, 0xF04621A0, 0x3760B7F0, 0x37CCA848, 0xA119798C, 0x15B884DA, 0x1546CE17 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x28000000, 0xC4000000, 0x3A000000, 0x9B000000, 0xA1800000, 0x93400000, 0xA0A00000, 0xF9F00000, 0x2A580000, 0x560C0000, 0xA5020000, 0xE0950000, 0xD9D88000, 0xBA7DC000, 0x0E07E000, 0x49049000, 0x1E828800, 0x78E4CC00, 0x80DD6E00, 0x3CEC5700, 0x7ADDEA80, 0x47DD9040, 0xAB7805A0, 0xFCBC02B0, 0xCFFA0698, 0x3F690274, 0x7E828B2A, 0xC8E4CA6F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x28000000, 0xA4000000, 0xFE000000, 0x3D000000, 0x82800000, 0xB3400000, 0x05A00000, 0x42F00000, 0x41780000, 0xA28C0000, 0x63620000, 0x3D8D0000, 0xBED98000, 0x33544000, 0xC5BA2000, 0x22FE1000, 0x31638800, 0x8AA54C00, 0xC779A600, 0xC3AB5700, 0x83E22A80, 0xB1C21640, 0x76D981E0, 0x275448D0, 0x73BA2CA8, 0xCBFE1674, 0x65E3853A, 0xA0E541BF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x88000000, 0x5C000000, 0xEA000000, 0x43000000, 0x40800000, 0xFC400000, 0x9DA00000, 0x19F00000, 0x90580000, 0xDF8C0000, 0x96EA0000, 0xC2D30000, 0xB4D48000, 0xFDCDC000, 0x8E49A000, 0xBA835000, 0x87468800, 0xE922CC00, 0x238F2E00, 0x2CE19700, 0x99E9A080, 0x507359C0, 0x3F9E88A0, 0xE6EECF30, 0x4AC52288, 0xE8C29D04, 0x17E527FA, 0xCD729C6F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x58000000, 0x9C000000, 0x2A000000, 0xCF000000, 0x3D800000, 0x4C400000, 0x0CA00000, 0x70D00000, 0xB4780000, 0x60840000, 0xB2DE0000, 0x6F6B0000, 0xB3188000, 0x878AC000, 0xBB4EE000, 0x7D285000, 0x4E9E8800, 0xEBF5C400, 0x07D06600, 0x85DD9D00, 0x3ECEED80, 0x3D685DC0, 0x503E8CA0, 0x1825C5F0, 0xFC286058, 0xFA199004, 0x9730EFEA, 0xA193563D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xE8000000, 0x0C000000, 0xBE000000, 0x2F000000, 0x73800000, 0x12400000, 0x3A600000, 0x16700000, 0x58680000, 0x0F4C0000, 0x98F60000, 0x38B50000, 0x93FA8000, 0xD9014000, 0xE0B5A000, 0xC7DD3000, 0x7335A800, 0x059D3400, 0xC155AE00, 0x8FED3D00, 0xCF3DA080, 0xA3A13DC0, 0x9A4BAB60, 0xA6543F30, 0x40512C58, 0x7B657E14, 0xC2EC8FFE, 0xA5844F73 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x08000000, 0x74000000, 0xEA000000, 0x15000000, 0xDC800000, 0x40C00000, 0xE8E00000, 0xCCD00000, 0x0ED80000, 0xFFFC0000, 0xC17E0000, 0xE0A30000, 0x3EF98000, 0xA7ECC000, 0x9D63E000, 0xEE9FD000, 0xC9E3E800, 0x1A5FDC00, 0xEB03EA00, 0x538FD500, 0x315BEA80, 0x98B3D240, 0xF2C5E420, 0xA1C0D310, 0x1E6469E8, 0xB910171C, 0xAA998766, 0x7BFCCBD1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xA8000000, 0x9C000000, 0xFA000000, 0xD3000000, 0xDB800000, 0xB4C00000, 0x88E00000, 0x62D00000, 0x39D80000, 0xAE6C0000, 0x48860000, 0x8F410000, 0xCC2F8000, 0x92034000, 0x6F39A000, 0xF1829000, 0xCFD9A800, 0xCF529C00, 0x2C01AA00, 0x623E9100, 0x1707A080, 0xC5BF98C0, 0xA9C82F20, 0xE66CD5F0, 0x24A98298, 0x0D424EBC, 0x2B162216, 0x2F81D491 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x88000000, 0xFC000000, 0xE6000000, 0x59000000, 0x18800000, 0xC1400000, 0x95600000, 0x1F700000, 0xF8480000, 0xFDC40000, 0xB6260000, 0xA1390000, 0x8C908000, 0xEB7EC000, 0xA254E000, 0xA2D6B000, 0xC7B4E800, 0xF0E6B400, 0x249CE600, 0x8752B700, 0x1C72EE80, 0xBFEFB8C0, 0x4D2460E0, 0x72987D50, 0x16480168, 0x18C40144, 0xA8A6003E, 0x097904B3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x58000000, 0x84000000, 0xCA000000, 0x6B000000, 0x1F800000, 0x12400000, 0x98600000, 0xD3500000, 0xFCE80000, 0x669C0000, 0x22EA0000, 0xBF9B0000, 0xE2418000, 0xF0474000, 0xDF6AA000, 0xEAD53000, 0x4382A800, 0x9C493C00, 0xD968A600, 0x77D23100, 0xA9292380, 0x68957940, 0xA3C38F20, 0xFB004FF0, 0x67A126D8, 0xA65972D4, 0xDA41895E, 0x64474EE1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x68000000, 0xE4000000, 0x7E000000, 0x87000000, 0xDA800000, 0x2C400000, 0x62600000, 0x3D700000, 0x9BD80000, 0x158C0000, 0x02F60000, 0xF83F0000, 0x6C388000, 0x6A354000, 0xC125E000, 0xD199F000, 0x6CFDE800, 0xB715F400, 0x028BE200, 0x506AF100, 0xC0536480, 0x486FBF40, 0x5C4E8360, 0x1A4A4730, 0x117D66C8, 0x51DCB1F4, 0x848002EE, 0xBB400323 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xD8000000, 0xFC000000, 0xBA000000, 0x2F000000, 0xD0800000, 0x78C00000, 0xAAE00000, 0x81F00000, 0x07680000, 0x42B40000, 0x33E20000, 0x5C6D0000, 0x1C0B8000, 0x8A244000, 0x972A6000, 0x5CA55000, 0x1AC26800, 0x79D15400, 0xEB406E00, 0x508C5300, 0x38C3E380, 0xCAEC1CC0, 0xF1E38820, 0xDF504E30, 0xBEA86D28, 0x89F85DBC, 0x7341E986, 0xCCB116A3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xB8000000, 0x74000000, 0x02000000, 0xBF000000, 0x18800000, 0x05C00000, 0x5BE00000, 0x6AF00000, 0xDB680000, 0x6B2C0000, 0x2AA20000, 0x72EF0000, 0x9F578000, 0xA12C4000, 0x49BC6000, 0xA4741000, 0x53B46800, 0x5F681400, 0x811E6E00, 0x399B1500, 0x0C63E580, 0x9F845240, 0x294205A0, 0x3C1F09B0, 0x9E3F8C28, 0x11004DEC, 0xC19E6F96, 0x185B1A43 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xC8000000, 0xDC000000, 0x12000000, 0x65000000, 0x6D800000, 0x97C00000, 0xC1E00000, 0x72F00000, 0xEC680000, 0x85140000, 0xDD860000, 0x3FE10000, 0xEDDD8000, 0xA8E8C000, 0x5559A000, 0xFAB75000, 0x2F51A800, 0x93935400, 0x08DFAE00, 0x85565B00, 0xA28C2280, 0xCB7B96C0, 0x958603A0, 0xA3E10090, 0x9FDD8D78, 0x3DE8CDEC, 0xF0D9A766, 0xB17755C3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x38000000, 0x4C000000, 0x66000000, 0xFB000000, 0xC4800000, 0x4CC00000, 0x47E00000, 0x7B500000, 0x5B980000, 0x0A640000, 0xB23A0000, 0x61310000, 0x418C8000, 0x4F684000, 0x91B86000, 0xC77FD000, 0xC5826800, 0x9D4EDC00, 0x608EEA00, 0xEEE69B00, 0x8ED68980, 0x1EC94FC0, 0x76CCE7E0, 0x72E39C70, 0x60F801A8, 0xB1F403BC, 0xE8420C56, 0x9B050BC9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xC8000000, 0xDC000000, 0x22000000, 0x4B000000, 0xA8800000, 0x00C00000, 0xBFE00000, 0x19500000, 0xD8880000, 0x68E40000, 0x33C60000, 0xC3590000, 0x87858000, 0x3E494000, 0x5A366000, 0x9F01D000, 0x36906800, 0x59C8DC00, 0x947DEE00, 0x6D359F00, 0x45858280, 0x854942C0, 0x5AB668A0, 0x73C1DA70, 0x63706C28, 0xD798D57C, 0xC675ED56, 0x4E119A29 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xC8000000, 0x44000000, 0x82000000, 0x2D000000, 0xEF800000, 0x67400000, 0x48600000, 0xCAF00000, 0x62380000, 0x9D2C0000, 0xD78E0000, 0x3B570000, 0x46638000, 0x21CAC000, 0x22A82000, 0x38C57000, 0x171E2800, 0xDEBE7400, 0xA6F3AA00, 0x1423B900, 0x0A380680, 0x492C0D40, 0xBD8E06A0, 0x82570B90, 0xE3E38A58, 0x2F8AC0E4, 0x0748225E, 0xB875780B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xD8000000, 0xC4000000, 0xC6000000, 0xA1000000, 0x6A800000, 0xB5C00000, 0xCAE00000, 0x65700000, 0xEC080000, 0x9A340000, 0x43120000, 0x7D9B0000, 0xA6768000, 0xD188C000, 0xDC536000, 0xE2879000, 0x79C96800, 0x80E89400, 0x6E4DE600, 0xFD8B5300, 0xE6600B80, 0x31B00F40, 0xAC680FE0, 0x3A840150, 0xBDFA0748, 0x46DF0D0C, 0xCF6C8666, 0x9727C71B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xB8000000, 0x14000000, 0x56000000, 0x29000000, 0x7D800000, 0xD6400000, 0xE1600000, 0x69D00000, 0x88380000, 0x7C1C0000, 0x5A020000, 0x7B2F0000, 0xBABE8000, 0x96DAC000, 0x1CA0A000, 0x77D0B000, 0x7D1AA800, 0x4BA3BC00, 0x4F462200, 0x34C67D00, 0x13800980, 0x2B400C40, 0x6AE004E0, 0x869002D0, 0xACD80938, 0xD78C0EB4, 0x655A0CAE, 0x47E30969 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x58000000, 0xF4000000, 0x4E000000, 0x57000000, 0xBF800000, 0xD0C00000, 0xF5E00000, 0x4F500000, 0xF5080000, 0xF2B40000, 0x66520000, 0xE5970000, 0x79C88000, 0x25434000, 0xA425A000, 0xC6301000, 0xEB1FA800, 0x2D831C00, 0x65ED2E00, 0xA7735B00, 0x393A0B80, 0x38B30440, 0x27728760, 0xF9304D30, 0x58B72A98, 0x5750573C, 0xA1208846, 0xACA74089 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x68000000, 0x1C000000, 0x3A000000, 0x07000000, 0xFC800000, 0xE6C00000, 0xD2600000, 0xF8B00000, 0xE8C80000, 0x93440000, 0xC9160000, 0x9D950000, 0x476D8000, 0x3F094000, 0x58B3E000, 0x38D71000, 0x6B5E6800, 0x4D1E5400, 0xD38D8E00, 0x66794B00, 0xFE9BE080, 0x45E31EC0, 0xF0E06D20, 0xA77F55B0, 0x8F3E0268, 0x50A1051C, 0xD4D3826E, 0x39684F27 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x28000000, 0x7C000000, 0x5E000000, 0x9D000000, 0xDE800000, 0x7D400000, 0xFBE00000, 0x02900000, 0x13480000, 0xBEDC0000, 0x981E0000, 0x641D0000, 0xFA348000, 0x873EC000, 0x4985E000, 0x1CE07000, 0x9B316800, 0xC79EBC00, 0x49D48600, 0x29AECD00, 0xCCCDEC80, 0x533C76C0, 0xABAF6F60, 0x3FC3B210, 0xC8800E08, 0x4C400304, 0xB3600ED6, 0x8ED0013D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0xAC000000, 0x12000000, 0x93000000, 0x39800000, 0x97400000, 0x82E00000, 0x47B00000, 0x36480000, 0x38640000, 0x916E0000, 0x87C10000, 0x431B8000, 0x61B64000, 0x2347A000, 0x44FA3000, 0x62BC2800, 0x22FC7400, 0x17B38E00, 0x2E624300, 0xEC61A680, 0x275F3DC0, 0xAAC9A9A0, 0xFB8B37F0, 0x5C6FACB8, 0x0F6E3344, 0x16FA2536, 0x91A974CF } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x28000000, 0x04000000, 0xEE000000, 0xD3000000, 0xE3800000, 0xFA400000, 0x65E00000, 0x9D900000, 0xA1680000, 0x324C0000, 0x71EE0000, 0x3B830000, 0xA6668000, 0x17C94000, 0x5CA32000, 0x53DEF000, 0x12A5A800, 0x30C7BC00, 0x090E8E00, 0xE6854100, 0x86CD2480, 0x461DFD40, 0x17232460, 0x6D9EF170, 0xF945AED8, 0xAE57B394, 0x63E684E6, 0x2A89473D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0x4C000000, 0x06000000, 0xF3000000, 0x25800000, 0xD2C00000, 0x51600000, 0x00B00000, 0x2C480000, 0x8A2C0000, 0xD51E0000, 0xE6910000, 0xCF468000, 0xA7874000, 0x1BF6A000, 0xD9C45000, 0x70F82800, 0xA86F1400, 0xB0108E00, 0x783A4100, 0x442E2080, 0x1A1211C0, 0x9D280EE0, 0x9A9C0FF0, 0xF1560438, 0x70BD071C, 0x745881CE, 0xFE1649E7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x08000000, 0x4C000000, 0xB6000000, 0xF9000000, 0xB2800000, 0x93400000, 0x87E00000, 0x55900000, 0xC4C80000, 0x88040000, 0x8C2E0000, 0x56290000, 0x89228000, 0xBA91C000, 0xDF41E000, 0x31C5F000, 0xACAB6800, 0x76503C00, 0x1B448600, 0x0BFCCB00, 0x03AD6E80, 0x4DED33C0, 0x328003E0, 0x53400750, 0x67E00E48, 0x259001A4, 0xCCC803D6, 0xC40408AD } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x08000000, 0x64000000, 0xDA000000, 0xC5000000, 0x8B800000, 0x66C00000, 0x9F600000, 0x88B00000, 0x6E580000, 0xB10C0000, 0x19B60000, 0xE7D30000, 0x5EEB8000, 0x2375C000, 0x1EB2A000, 0x8571D000, 0x2D812800, 0x55C81400, 0x4FE58A00, 0xEADACD00, 0xD1572280, 0x2FAB1F40, 0xDCD60520, 0xEA630E10, 0x9B338718, 0x64B9C33C, 0x9064A1CE, 0x8E12D8A7 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0xB8000000, 0xE4000000, 0x76000000, 0x87000000, 0x5F800000, 0x12C00000, 0xF3600000, 0xFA900000, 0xE4780000, 0x0D140000, 0x7AA20000, 0x245F0000, 0x2D388000, 0x8AA24000, 0x9C472000, 0xC912D000, 0xFC87A800, 0x1B649C00, 0x96828A00, 0xEE794300, 0xE825A980, 0x6C3B9140, 0x0A3A04E0, 0xE51B0A30, 0x16828098, 0x2E79465C, 0xC825A14E, 0x9C3B90C5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xE8000000, 0x54000000, 0x4E000000, 0xFD000000, 0xBF800000, 0x57400000, 0x32E00000, 0x36B00000, 0x16F80000, 0xD0B40000, 0x1FD60000, 0xD1270000, 0x5DAA8000, 0x087EC000, 0x7259A000, 0xD163B000, 0x2BEB2800, 0x8F197400, 0x189C8200, 0xFBE9CB00, 0xD70B2480, 0x04A97A40, 0x11E48260, 0x8C1DCE90, 0x123D2518, 0xB73E75A4, 0x14B60E56, 0xA9D7075F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x98000000, 0xB4000000, 0x7A000000, 0x97000000, 0x63800000, 0xF5400000, 0x70E00000, 0xD4900000, 0x66E80000, 0x2DAC0000, 0xD8420000, 0xE4730000, 0x12778000, 0x7B554000, 0x3DCC2000, 0x10013000, 0x3833A800, 0x84287C00, 0xB2358E00, 0xBB264900, 0xADBBAF80, 0x18547E40, 0x847F8620, 0x42694E30, 0xE3662798, 0x89DE3324, 0x6A0620B6, 0xAF0E355D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x48000000, 0xF4000000, 0xD6000000, 0x8D000000, 0x46800000, 0x00400000, 0x3BE00000, 0x25100000, 0x02980000, 0xEE5C0000, 0xDAC60000, 0x09BF0000, 0xADD08000, 0xC82AC000, 0x3424E000, 0x7616B000, 0x5D326800, 0x0E837C00, 0xF4460200, 0xEDFF0100, 0xA8308E80, 0x443AC240, 0xEE3CE9E0, 0xE10AB790, 0x2C946108, 0xAF6C74D4, 0x266E85D6, 0xEED9C355 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xD8000000, 0x64000000, 0xAA000000, 0x69000000, 0x9A800000, 0xF4C00000, 0x9F600000, 0x75100000, 0x24B80000, 0xCFE40000, 0xB8FA0000, 0x697F0000, 0x422B8000, 0x1524C000, 0x74AEE000, 0x87D89000, 0xB4FF6800, 0x7F435C00, 0xE51A0A00, 0x4CAF0700, 0x73F38F80, 0x76D0CD40, 0xAA6CE720, 0xB18390D0, 0x7B4EEB08, 0x1F0895DC, 0x6DA76A5E, 0xE5775F1D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x98000000, 0x1C000000, 0xE6000000, 0xDF000000, 0xAE800000, 0x0AC00000, 0x7F600000, 0xE1100000, 0xCDA80000, 0x92740000, 0x82AA0000, 0xB4D10000, 0xDC468000, 0x19B24000, 0x80526000, 0x5FBA1000, 0x8F5EE800, 0xD9095C00, 0x01820E00, 0x5C650700, 0xD98C8F80, 0xE0734AC0, 0xEFBCE7E0, 0x177C5C30, 0xC5268C88, 0xE7A2415C, 0x837A6B1E, 0x770E15BD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xA8000000, 0x9C000000, 0xF6000000, 0x15000000, 0x89800000, 0xE7C00000, 0x75600000, 0x9A300000, 0x9B280000, 0x489C0000, 0x944E0000, 0xD9AD0000, 0xEFCA8000, 0x9960C000, 0x54332000, 0xBA199000, 0xAB1FA800, 0x90885400, 0x30480600, 0x1BAC0D00, 0x90E60480, 0xF3F100C0, 0x2F6485E0, 0xA13DC890, 0xA3B1A7F8, 0xE4D55F2C, 0x79CA87CE, 0x5C60C3DF } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x78000000, 0xA4000000, 0x5E000000, 0xF3000000, 0x97800000, 0x6D400000, 0x4BE00000, 0x18300000, 0x34280000, 0xC60C0000, 0x872A0000, 0xB1B70000, 0x3A7E8000, 0x824B4000, 0x86692000, 0xE876B000, 0xB375A800, 0xF8F6F400, 0x6F800600, 0x89400900, 0xF5E00980, 0x3B300740, 0xDBA80260, 0x0F4C0570, 0x92CA0C98, 0x5A8709E4, 0x99D68DC6, 0x29074757 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x38000000, 0x0C000000, 0x1E000000, 0x63000000, 0xCC800000, 0xB3C00000, 0xC6600000, 0xB0300000, 0x58180000, 0x5C140000, 0x56120000, 0x570D0000, 0xDE848000, 0xCEDF4000, 0x69CBE000, 0xCF6FD000, 0x2DA56800, 0x2A599400, 0xBE000A00, 0x53000300, 0xD4800180, 0xCFC007C0, 0xE0600260, 0xDF3006F0, 0x8A980D28, 0x8CD40D0C, 0x5CF200AE, 0x54FD003F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xD8000000, 0xC4000000, 0xE2000000, 0x7B000000, 0x38800000, 0x10C00000, 0x3AA00000, 0xE0100000, 0x30180000, 0xB80C0000, 0x341E0000, 0x3A1B0000, 0xBF188000, 0xDA9C4000, 0x6BCF6000, 0x02271000, 0xF0D21800, 0x0ABF5400, 0x58000200, 0x04000300, 0x82000180, 0x8B0003C0, 0xE0800360, 0xD4C00310, 0xD8A00388, 0x9B1001EC, 0x089800E2, 0xA8CC0043 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x18000000, 0x5C000000, 0xAE000000, 0xA9000000, 0x3B800000, 0x78C00000, 0x18E00000, 0xB8100000, 0xCC180000, 0xE61C0000, 0x5D160000, 0xD1830000, 0x23CB8000, 0x2475C000, 0x52452000, 0x97BF7000, 0x3E231800, 0x31FD1C00, 0x43800200, 0x54C00300, 0x4EE00380, 0xFD1002C0, 0x41980060, 0x6BDC0170, 0xD07602B8, 0xB85302A4, 0xCCB380EE, 0x02B9C1E3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x38000000, 0x44000000, 0xDA000000, 0xE5000000, 0x59800000, 0x35400000, 0x5CA00000, 0x74100000, 0x02080000, 0xF1140000, 0x4B9E0000, 0xAC470000, 0x9B288000, 0x7E4B4000, 0xE234A000, 0xE9CF3000, 0x2070A800, 0x75E89400, 0xA6A00200, 0x21100100, 0xC3880280, 0x705403C0, 0xF53E00E0, 0x79570110, 0x1AA08368, 0x5F1F4394, 0xAC8AA166, 0x04D830D5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x58000000, 0x44000000, 0x32000000, 0x87000000, 0xC9800000, 0x8B400000, 0xB3200000, 0xB4100000, 0xFA080000, 0x3B140000, 0x6F9A0000, 0x664B0000, 0xB9A88000, 0xC4D64000, 0x4578E000, 0xF5BD3000, 0xAAD36800, 0x14616400, 0x59200200, 0x37100100, 0xA1880280, 0xE7540340, 0x4D3A0160, 0x1D1B0110, 0xC28080C8, 0xCCD2421C, 0x196AE326, 0x23A2322D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x08000000, 0xF4000000, 0x86000000, 0xD7000000, 0x5E800000, 0xEC400000, 0x9B600000, 0xE6100000, 0x27180000, 0x66840000, 0x00420000, 0xE1610000, 0x430E8000, 0x2888C000, 0x035EE000, 0x29E9D000, 0x704C8800, 0x1975EC00, 0x8F180200, 0x42840300, 0xAE420080, 0xD2610040, 0x938E8020, 0xE7C8C3D0, 0x40BEE218, 0xF4B9D35C, 0x92B4897A, 0x75A1EFB1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x88000000, 0x84000000, 0x12000000, 0xDD000000, 0xD6800000, 0x36400000, 0xD1E00000, 0x56100000, 0x6F080000, 0x3B9C0000, 0xB8DA0000, 0xEBB10000, 0x11E08000, 0xF61A4000, 0x5F0FA000, 0x639CD000, 0xB4CDC800, 0x7DBBBC00, 0xDEE80200, 0xFD8C0100, 0xBFD20380, 0x842D0340, 0x333A8220, 0x44AB4210, 0x8A6F2048, 0x7EC69374, 0xECA26B5A, 0x7E776CD9 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xD8000000, 0x0C000000, 0x1E000000, 0x5D000000, 0x2E800000, 0xD8400000, 0x83200000, 0xF2100000, 0xB3080000, 0xCB8C0000, 0x4AD60000, 0x9D7B0000, 0x20318000, 0x719BC000, 0xFDCFA000, 0x2CFFD000, 0xFDE60800, 0x8D72E400, 0x68280200, 0x759C0100, 0x87DE0180, 0xBBF702C0, 0x9C678360, 0x38A0C030, 0x40DE2078, 0xF2741174, 0x9DA1A8BA, 0xB2413761 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xC8000000, 0xA4000000, 0xF2000000, 0x23000000, 0xBA800000, 0x5EC00000, 0xC1600000, 0x1E100000, 0xB5180000, 0x8B9C0000, 0xB74E0000, 0xED390000, 0x25A48000, 0x98764000, 0x03906000, 0x335D5000, 0x8F20D800, 0xBEABAC00, 0x4EF80200, 0x0B4C0300, 0x23360380, 0x08B501C0, 0xEFF28320, 0x5AD34290, 0x637AE3C8, 0x6512108C, 0x13943AEA, 0x4B40BD7B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x58000000, 0x8C000000, 0x5A000000, 0xCD000000, 0x78800000, 0x02400000, 0x07600000, 0x5E100000, 0xE3180000, 0x938C0000, 0x25D20000, 0x64AB0000, 0xF5A18000, 0x2F234000, 0x9C7DA000, 0x71991000, 0x34CD4800, 0x7E246C00, 0x26F80200, 0x52DC0300, 0x812A0180, 0xB7770240, 0x360B8160, 0xC7144230, 0x8D962168, 0x66DD5334, 0x072369E2, 0x18653C09 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x18000000, 0xCC000000, 0x0E000000, 0xB1000000, 0x1A800000, 0xF3C00000, 0x0B200000, 0x61100000, 0xB2980000, 0x07C40000, 0xB92E0000, 0xC6130000, 0xD5018000, 0xE085C000, 0xF0D82000, 0xB6A05000, 0xF557F800, 0x5EF8A400, 0x2F2E0200, 0x7B130300, 0xE1818080, 0xD245C1C0, 0xF9782060, 0xE8705330, 0x42EFF838, 0x892CA6C4, 0x3E18026A, 0x490400CF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xD8000000, 0x04000000, 0xE2000000, 0xE7000000, 0x95800000, 0xBDC00000, 0x6BA00000, 0xDF100000, 0x81880000, 0xE7CC0000, 0xD8AA0000, 0x708B0000, 0xDF488000, 0xFBF04000, 0x5D66E000, 0x0F31B000, 0x5A433800, 0xC97F3400, 0x152A0200, 0x894B0100, 0x36E88180, 0x93E04140, 0x916EE360, 0x513DB010, 0x0B493B88, 0x81E4379C, 0xDE6A8056, 0x28B743F7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xC8000000, 0x74000000, 0x0A000000, 0xFF000000, 0x45800000, 0xDEC00000, 0xFDE00000, 0xE7100000, 0xA9980000, 0xF8CC0000, 0x44FE0000, 0xEB890000, 0xB3D68000, 0x6B6D4000, 0x3A51E000, 0xC3A9B000, 0x26A95800, 0x6428FC00, 0x237E0200, 0x8E490300, 0xA9B68180, 0x29BD43C0, 0xE9A9E320, 0x89B5B1D0, 0x79AF5828, 0xB1BDFFFC, 0xC5AE8316, 0xCFB1407B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x68000000, 0x24000000, 0xDA000000, 0xC1000000, 0xD1800000, 0x17C00000, 0x02200000, 0x75100000, 0xA3980000, 0xD2C40000, 0x19A20000, 0xCBDD0000, 0x543C8000, 0x6A0F4000, 0x79022000, 0xBD933000, 0xF9C47800, 0x71360400, 0x41820200, 0xBFCD0300, 0x06248080, 0xBF0B4040, 0x0A8021A0, 0x275E3090, 0xD460FB68, 0x08FD4704, 0xF0A22146, 0xDE43335F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x18000000, 0x1C000000, 0x3A000000, 0x29000000, 0x43800000, 0xD1C00000, 0x6C600000, 0xAD100000, 0x25880000, 0x22DC0000, 0x96F20000, 0x27530000, 0x842B8000, 0xD9AB4000, 0x376F2000, 0x638F7000, 0xE1DFB800, 0x0467CC00, 0x39120200, 0x1B830100, 0x2DC38380, 0xC6674240, 0x9C152060, 0x7A007070, 0xC90638E8, 0xD39F8CA4, 0xC9D6A30E, 0x70673247 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xC8000000, 0xC4000000, 0xF6000000, 0xD9000000, 0x38800000, 0xE3400000, 0x1AE00000, 0x9F100000, 0x19880000, 0xA7DC0000, 0x93B20000, 0xA6E90000, 0x55008000, 0x4A8AC000, 0x2C552000, 0x6B6C1000, 0x8CCDE800, 0x242D1C00, 0xD43A0200, 0xCC350100, 0x20328380, 0x8223C240, 0x6535A320, 0x40B6D310, 0x6D70CBD8, 0x4DCD0F64, 0xF0ADEAE2, 0x957D1E8D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0xB8000000, 0x3C000000, 0x56000000, 0x85000000, 0x6C800000, 0x51C00000, 0x70A00000, 0xEB100000, 0x95880000, 0x8B5C0000, 0x94660000, 0x4F270000, 0x135F8000, 0x387EC000, 0x713AA000, 0x22449000, 0x86EEB800, 0xCFE95400, 0xED6E0200, 0xD5BB0100, 0x17998380, 0xAC49C0C0, 0x4FED22E0, 0xAD6650F0, 0x35B21958, 0x278AC614, 0x145F3BB2, 0x73EC9447 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0xD4000000, 0x7E000000, 0x7B000000, 0xEE800000, 0xB1C00000, 0xAD600000, 0x51100000, 0xAB880000, 0x444C0000, 0xC2260000, 0x25BD0000, 0x83E28000, 0xC0DBC000, 0x56ED6000, 0x4D4AD000, 0xD5AFB800, 0xCBF1EC00, 0x44CE0200, 0x70E10100, 0x8A4C8180, 0x912AC0C0, 0x7F29E1A0, 0x7C2C1350, 0x7EA059F8, 0x3D60FDEC, 0x290CD9BA, 0x479A3FC7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x38000000, 0x74000000, 0x96000000, 0x77000000, 0x5A800000, 0xEF400000, 0x1EE00000, 0x35100000, 0x6B880000, 0x6ACC0000, 0x173E0000, 0x1EB70000, 0xD5768000, 0x8FC6C000, 0xD4B4E000, 0xC86E5000, 0x18526800, 0x047C9C00, 0xBA560200, 0x856B0100, 0x67C08180, 0x08BDC3C0, 0xE27C60E0, 0xB55F91D0, 0xCBF00A58, 0xEE840DDC, 0x59588B6A, 0xF9E5CEBD } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xD8000000, 0x64000000, 0xDA000000, 0x97000000, 0x85800000, 0x18C00000, 0xB6A00000, 0x59100000, 0x70880000, 0xFE440000, 0x99F60000, 0xDC6B0000, 0xA4B48000, 0x82074000, 0xB308E000, 0x7F99B000, 0x3FC29800, 0xEB3A1400, 0x25DE0200, 0x1C3F0100, 0x304A8080, 0x6CE842C0, 0x3AEA6360, 0x8BE5F190, 0x0776FB68, 0x6720E65C, 0x03C27816, 0x1527A563 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x28000000, 0x14000000, 0x6A000000, 0x91000000, 0x05800000, 0xB5400000, 0xBBA00000, 0xA7100000, 0xDA980000, 0x83DC0000, 0x7E7E0000, 0xEE750000, 0xF66A8000, 0x2A794000, 0xA4782000, 0x776FB000, 0xF7FB2800, 0x2D37B400, 0xB2C60200, 0xABF90300, 0x632C8380, 0x81C043C0, 0xDB74A0A0, 0x91FFF050, 0x0A3789A8, 0xA8444644, 0xC8378A16, 0xED4445D5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x48000000, 0xAC000000, 0x8E000000, 0xE5000000, 0x4E800000, 0x97C00000, 0xE5600000, 0x3E900000, 0x0FD80000, 0xE17C0000, 0x0C920000, 0x2CD10000, 0xE6E98000, 0x5BC3C000, 0xBB6DA000, 0x73905000, 0xFD593800, 0xB0B50C00, 0xA0E98200, 0xD2C3C300, 0x9BEDA380, 0x11505040, 0x1EB93920, 0xB5E50EB0, 0xC4518038, 0xE82FC094, 0xD627A2BA, 0x4B3D521F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xC8000000, 0x04000000, 0x0A000000, 0x1B000000, 0xEB800000, 0x57400000, 0x0FE00000, 0x63900000, 0xF3580000, 0xB5EC0000, 0x608A0000, 0xD4C10000, 0xECAC8000, 0x7E6B4000, 0x47D26000, 0xA329F000, 0x932DA800, 0x4B299C00, 0xE72C8200, 0x392B4300, 0xE0326180, 0x14B9F340, 0xA275AB20, 0xE1C59C10, 0x66268228, 0xA1AA436C, 0xE8FEE22E, 0x5E02B21D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xB8000000, 0x94000000, 0x12000000, 0xDD000000, 0x86800000, 0xE0400000, 0xD2A00000, 0xB2900000, 0xA2480000, 0x97A40000, 0xB0120000, 0xE81F0000, 0x0C168000, 0x96004000, 0x770CA000, 0xCF825000, 0x74DE4800, 0xEFE1F400, 0xE6B68200, 0xF0904100, 0xE744A080, 0x95265040, 0xFA4C4AE0, 0x73BEF650, 0x2A000248, 0x09000274, 0xB480029A, 0x2D4003C1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xF8000000, 0x74000000, 0x66000000, 0x13000000, 0x9B800000, 0x8A400000, 0xF6200000, 0x5F900000, 0x54480000, 0xF12C0000, 0x92160000, 0x35170000, 0xE8828000, 0x21CAC000, 0x847D6000, 0xDDADF000, 0x6DC58800, 0xB678A400, 0xF8A28200, 0x2D5AC100, 0x2BB56180, 0x96C1F0C0, 0xF1F38BE0, 0xA8FFA5D0, 0x22680398, 0xEEBC014C, 0xA65E03EE, 0xF43B02E9 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x28000000, 0xDC000000, 0x22000000, 0x27000000, 0xED800000, 0xA7C00000, 0xBF200000, 0x09900000, 0x51D80000, 0xD63C0000, 0x991A0000, 0xC89D0000, 0xDD478000, 0x8D6E4000, 0xE571E000, 0x196E3000, 0x8B64B800, 0xD46D0400, 0xCDE78200, 0x943E4300, 0x2E09E380, 0xED023140, 0xF686B8A0, 0x385C0770, 0x17E20288, 0x8731039C, 0xDD858036, 0x1FCF43DF } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x08000000, 0x8C000000, 0x5E000000, 0x1B000000, 0xDA800000, 0x62C00000, 0xCC600000, 0x2E900000, 0xE8C80000, 0xED7C0000, 0x2D120000, 0x1D890000, 0x0E4D8000, 0x29A9C000, 0x6E726000, 0x3392D000, 0x4D539800, 0x9724EC00, 0xCEAD8200, 0xB2F9C100, 0x2E5A6380, 0x99BED040, 0x96699820, 0xA781EE30, 0x975A0378, 0x5E35016C, 0x513F80EA, 0x11B0C1CB } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x68000000, 0x5C000000, 0x56000000, 0x87000000, 0xA3800000, 0x22C00000, 0x30A00000, 0x95900000, 0xD5C80000, 0x1B3C0000, 0xDB560000, 0xDB650000, 0x55A78000, 0xFB14C000, 0x6589E000, 0x1DC5F000, 0x97259800, 0xD5407400, 0x686F8200, 0xFC28C100, 0x08DFE380, 0x71A0F0C0, 0x090219A0, 0x5094B570, 0x6B466358, 0xF37D331C, 0xE9B2790E, 0x9D1C844B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x48000000, 0x64000000, 0xB6000000, 0x19000000, 0xD6800000, 0x36C00000, 0x40200000, 0xD0900000, 0xA7D80000, 0x12BC0000, 0x60560000, 0xB6F10000, 0x70A08000, 0x4758C000, 0xFD6E2000, 0x16FC5000, 0x60B71800, 0xDF5AA400, 0xE1788200, 0x8CE4C300, 0xABB82380, 0xA6CD50C0, 0x18379920, 0x2C926590, 0x0DCEA0D8, 0x91A49364, 0x7DD938DA, 0xF9A6F41B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0x74000000, 0xEE000000, 0xC9000000, 0x8A800000, 0x27400000, 0xFF600000, 0x8C900000, 0xDA480000, 0xFBEC0000, 0x32DA0000, 0xC7A50000, 0x24328000, 0xF9EFC000, 0x79C02000, 0x4631D000, 0xE2E22800, 0x90574C00, 0xF4FA8200, 0x6543C100, 0xD47A2180, 0x5D04D140, 0x7498A9A0, 0xE6548DD0, 0x51E0A1B8, 0x2DD71224, 0x982A8BAA, 0x13FC5DDD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xE8000000, 0xE4000000, 0x1A000000, 0x11000000, 0x53800000, 0xB8C00000, 0x80E00000, 0xD1900000, 0xC5D80000, 0xBD740000, 0xBA560000, 0x0BA50000, 0x79B88000, 0x4CAD4000, 0xA5232000, 0x3CECF000, 0x07935800, 0x8AD9BC00, 0xD5E08200, 0xA8194300, 0x84152280, 0x8A19F0C0, 0xC913DBA0, 0x5F90FF90, 0x46CDA268, 0x8BE4B344, 0x9308FBCE, 0x2E980E23 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xE8000000, 0x54000000, 0xBE000000, 0x1B000000, 0x7F800000, 0xA9C00000, 0xBF600000, 0x3D900000, 0xF8D80000, 0x55EC0000, 0x48DA0000, 0x2DE50000, 0x94D68000, 0x97E5C000, 0xD9C26000, 0xA7777000, 0xB183F800, 0xAACC0C00, 0x4CEE8200, 0xC659C300, 0x5EA06180, 0xE6EE7140, 0xC3577BA0, 0x0A20CD50, 0x88A060F8, 0x69EE736C, 0x62D7787E, 0xE8E0CFE7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x48000000, 0x14000000, 0x2A000000, 0x47000000, 0x1E800000, 0xF0400000, 0x96200000, 0x08900000, 0xB9580000, 0x4DBC0000, 0x454E0000, 0xA3B10000, 0x704E8000, 0x56234000, 0xE88DE000, 0x49475000, 0x05AE4800, 0x5156A400, 0x89B68200, 0x374F4300, 0x48BBE380, 0x18DA53C0, 0xDF76C920, 0x0D38E450, 0xE81BE2A8, 0xC40A521C, 0x720ECBFA, 0xEB14E401 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x78000000, 0xE4000000, 0x42000000, 0x5D000000, 0xE5800000, 0xD8C00000, 0x1BE00000, 0x0B900000, 0xEBD80000, 0x0D740000, 0x65CA0000, 0x4E770000, 0xDB588000, 0xBC2A4000, 0xD8E0A000, 0x75123000, 0xB9905800, 0xDEDA5C00, 0xD4E08200, 0xCB0E4300, 0x3292A280, 0x8C413340, 0x28BAD9E0, 0x4BA31F90, 0xE52AA308, 0xCF653274, 0xF8C8D916, 0x0BF01C23 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x88000000, 0xAC000000, 0xFE000000, 0xBF000000, 0x21800000, 0x2C400000, 0x86200000, 0x5E900000, 0x6DC80000, 0x7A640000, 0xA0AE0000, 0x17490000, 0x45B98000, 0x9BD5C000, 0x2970E000, 0x5F34B000, 0x7409C800, 0x6A05E400, 0x45178200, 0x3C9CC100, 0xC4C96080, 0x98E173C0, 0x2B792A20, 0x263156B0, 0xEE9E49F8, 0xC5D927FC, 0x267EE206, 0xD6ADB271 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xB8000000, 0x1C000000, 0x2A000000, 0xC7000000, 0x25800000, 0x49400000, 0xC9600000, 0xF2900000, 0x44C80000, 0xF4240000, 0x45EE0000, 0xFF4F0000, 0x646F8000, 0x300F4000, 0xD819E000, 0xCC143000, 0x6211E800, 0x63138C00, 0x13818200, 0xA4404100, 0x2BF66080, 0x9E5B73C0, 0xC4E80AE0, 0xCFD7BC70, 0xF3B86AA8, 0x4FA7CE1C, 0xD5B1E216, 0x8AA033E5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x78000000, 0x9C000000, 0x2A000000, 0x95000000, 0x20800000, 0xB9400000, 0x27E00000, 0xB9900000, 0xEBD80000, 0xA7BC0000, 0x3CEA0000, 0x9A070000, 0xFD178000, 0x24834000, 0xDF47A000, 0xE0F89000, 0x9011E800, 0x580B1C00, 0xAC1D8200, 0x82144300, 0x71082380, 0x9687D340, 0x065C49E0, 0x92648E70, 0x2043EAA8, 0x75601D54, 0x39D80102, 0x6EBC02A5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xB8000000, 0x34000000, 0xCA000000, 0x59000000, 0x8A800000, 0x81C00000, 0x58E00000, 0x37900000, 0x09580000, 0xEC3C0000, 0xABE60000, 0x941F0000, 0x5A028000, 0xB1134000, 0xB68A2000, 0xC7C0D000, 0xFFEFF800, 0x2E097C00, 0x5B048200, 0xBF9C4300, 0x4550A380, 0xF22F92C0, 0x88E3DAE0, 0xFF86ACD0, 0x6551F928, 0xA22A7E64, 0x80E003AA, 0x739003C7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x98000000, 0x6C000000, 0xAA000000, 0xCB000000, 0xDC800000, 0x18400000, 0xECE00000, 0x93900000, 0x5AD80000, 0x19BC0000, 0x32EE0000, 0x5E9B0000, 0x07498000, 0xE6774000, 0x82C46000, 0x55BD1000, 0x88F7C800, 0xFD87BC00, 0x2FC78200, 0x383C4300, 0x0F35E380, 0xD1A653C0, 0x16E5AA60, 0x108DADB0, 0x624FC8A8, 0xAFEBBC2C, 0x4B1182F2, 0x1C8B40A1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xE8000000, 0x64000000, 0x2A000000, 0x9B000000, 0x05800000, 0x2FC00000, 0x18A00000, 0xD4900000, 0x61580000, 0xCAE40000, 0x5FF60000, 0x0B750000, 0xAA208000, 0x40CF4000, 0x2F346000, 0xCC433000, 0x026F3800, 0x68B0B400, 0xDC8E8200, 0x155E4300, 0x38E2E080, 0x48F970C0, 0x40FBDBA0, 0x34FCC590, 0xC6F5DAA8, 0xD1FDC56C, 0x9A7B5A96, 0x04A3877F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0xD8000000, 0x2C000000, 0xA2000000, 0x65000000, 0xE4800000, 0xA8C00000, 0xD2E00000, 0x2B900000, 0x9D480000, 0xF0BC0000, 0xC6BA0000, 0x3DA30000, 0x26218000, 0x737A4000, 0x97D9A000, 0x8F7C1000, 0xADD9D800, 0x267E3C00, 0xBB538200, 0x33A54100, 0xA1222380, 0x12F55140, 0x8B89FB60, 0x2D546CB0, 0x78A1F888, 0x32B86C94, 0xB3B3FA12, 0xE1376EE3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xC8000000, 0x14000000, 0x82000000, 0xC1000000, 0x14800000, 0x8DC00000, 0x61A00000, 0xE3900000, 0x4A580000, 0xD1E40000, 0x5F7A0000, 0x0FB10000, 0xCC8E8000, 0xB1C64000, 0x87AF2000, 0x38831000, 0x43C27800, 0xDEA2D400, 0xF00C8200, 0x58034300, 0xFC03A080, 0xC6105140, 0x8B19DB20, 0xC1968450, 0x1B4F5808, 0x2D74C404, 0x96BA7AD2, 0x2416D477 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x58000000, 0x3C000000, 0xE2000000, 0x4D000000, 0xCD800000, 0xADC00000, 0x8AE00000, 0x66900000, 0x43580000, 0x6DA40000, 0xF53A0000, 0x49630000, 0xFC4B8000, 0x552A4000, 0xD97CA000, 0x84573000, 0x39397800, 0x637D3C00, 0xF5498200, 0x16BD4300, 0x83B52080, 0xB22A7140, 0xDDEC5960, 0x4A074CF0, 0xB91DD988, 0x6B8E0E34, 0x6ECAF9B6, 0xB0637CF7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x58000000, 0xD4000000, 0xEE000000, 0xAB000000, 0x1B800000, 0x4A400000, 0x3FA00000, 0xCA500000, 0x7FA80000, 0xAA5C0000, 0xEFBA0000, 0xF2570000, 0x3BA08000, 0x1C4AC000, 0x90B5E000, 0x07C9B000, 0xDAFCA800, 0x386E4400, 0x10B5E200, 0x47C9B100, 0xBAFCA980, 0xA86E4640, 0x48B5E360, 0x93C9B250, 0x54FCAA38, 0x036E44EC, 0x5335E30E, 0xD989B379 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0x9C000000, 0xE2000000, 0x8B000000, 0x52800000, 0x56C00000, 0x4A600000, 0xB6D00000, 0x3A680000, 0xDED40000, 0xEE6A0000, 0xF8DF0000, 0x1B798000, 0xC3434000, 0x9428E000, 0x8D691000, 0x3E523800, 0x4BB85C00, 0x6C28E200, 0x41691100, 0xA4523880, 0x4CB85C40, 0x84A8E360, 0x00A91370, 0x5EB23B08, 0x27A85E6C, 0xA620E22A, 0x3E6D122B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x48000000, 0x44000000, 0xCA000000, 0x0D000000, 0x28800000, 0x51400000, 0xD8A00000, 0x59500000, 0xBCB80000, 0xC34C0000, 0x49AE0000, 0xE7C50000, 0x96E68000, 0xF87C4000, 0xEA372000, 0x3D015000, 0xA0910800, 0xF5444400, 0xA2B72200, 0x1C415300, 0xD0310B80, 0x581446C0, 0x9C0F2320, 0x960D5210, 0x7B1F08A8, 0xE39146F4, 0xFAC9A382, 0x66611355 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xA8000000, 0xAC000000, 0xE6000000, 0x09000000, 0x38800000, 0xE2C00000, 0x50A00000, 0xEAD00000, 0x2CB80000, 0x84D40000, 0x99BA0000, 0xF2410000, 0xDE6F8000, 0x7C7DC000, 0xDF7EA000, 0x38E2D000, 0x53A6F800, 0xDD4AC400, 0xCFFEA200, 0xB622D300, 0xC506F880, 0x2E9AC440, 0x73C6A0A0, 0x7C36D1B0, 0xEA1CFB18, 0x3F0BC464, 0xB9912042, 0x665F123B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x48000000, 0x64000000, 0xEA000000, 0xC5000000, 0x4F800000, 0x75C00000, 0x3B600000, 0xA1D00000, 0xD9680000, 0xE0CC0000, 0x4CEE0000, 0x18050000, 0x5C028000, 0x26084000, 0x7B122000, 0x289DB000, 0x9B5A9800, 0xEB33DC00, 0x2A722200, 0x0C4DB100, 0xEDB29B80, 0x4E3FDCC0, 0x15FC2320, 0xD198B090, 0x82D81828, 0x4DFB9FD4, 0x6D80021E, 0x94C00147 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x58000000, 0x54000000, 0x72000000, 0xCF000000, 0xF2800000, 0x99400000, 0xCFA00000, 0xFB500000, 0x98B80000, 0x7DD40000, 0xE3EA0000, 0x257F0000, 0xBE308000, 0x56894000, 0xC35D6000, 0xBCAD1000, 0xE7C94800, 0xB0F06400, 0xA9E56200, 0xCE791300, 0xD6A34880, 0x9CCF6640, 0x8075E360, 0x37A05250, 0xFF462948, 0x92B6757C, 0x76D6A8AA, 0x3B6F3435 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xD8000000, 0xDC000000, 0x62000000, 0xDF000000, 0x2C800000, 0x15400000, 0xBE600000, 0x2B500000, 0x43680000, 0x38CC0000, 0x0AA60000, 0x4BF70000, 0x438D8000, 0x41C34000, 0xE7326000, 0x5F2CD000, 0xB321C800, 0xE9219C00, 0x9A3A6200, 0x0CB0D100, 0x1AEFCB80, 0xEA1A9DC0, 0x0B11E160, 0xDA849270, 0xDC502A08, 0x2BF50EBC, 0x738249D2, 0x79C9DE25 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x98000000, 0xA4000000, 0x5A000000, 0x33000000, 0xDF800000, 0x4AC00000, 0xA9600000, 0xA4D00000, 0x28680000, 0xD4440000, 0x732E0000, 0xC6F70000, 0x360A8000, 0x85044000, 0x1A80E000, 0xF045B000, 0x6928B800, 0x55E11C00, 0xD988E200, 0x57D1B100, 0x17EEBA80, 0x0E921CC0, 0x724C6060, 0x5E32F390, 0xE06CDBE8, 0x3847EC0C, 0x85223B1E, 0xA3E55EBB } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x08000000, 0x84000000, 0xEA000000, 0x8F000000, 0x9C800000, 0x2EC00000, 0x86200000, 0x18D00000, 0xAF380000, 0x45540000, 0xA8620000, 0xF6350000, 0x00C28000, 0x03204000, 0xFB4F6000, 0xC56DD000, 0x61B1B800, 0x589C9400, 0x24D76200, 0xF929D300, 0x5C4BB880, 0x0DED9740, 0xAD6FE220, 0xD5B89110, 0x4A9C5B28, 0xF7C1057C, 0x03B1B852, 0x939C95AB } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x28000000, 0x2C000000, 0x82000000, 0x61000000, 0xBC800000, 0x5E400000, 0xBBA00000, 0x88500000, 0x8CA80000, 0x43CC0000, 0xF9660000, 0xFDA90000, 0xE7538000, 0x43214000, 0x980BA000, 0xA404D000, 0x3E1B6800, 0xBB1B2400, 0xD983A200, 0x4CD8D100, 0x06F56B80, 0xEE6E25C0, 0xE63E22A0, 0x2A8C91B0, 0x89434988, 0x003EB444, 0xD5936852, 0x1EC724C9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xA8000000, 0x8C000000, 0xBE000000, 0x41000000, 0x31800000, 0x05C00000, 0x9AE00000, 0xE4D00000, 0x7B780000, 0x69140000, 0x7D9A0000, 0x9BD10000, 0xCBF38000, 0x7D52C000, 0xF2A1A000, 0x4DE5F000, 0xD8429800, 0xD13C6C00, 0xA73BA200, 0x9A34F300, 0x8DB11880, 0xFD6EAC40, 0xCC1A00A0, 0x5E110130, 0x71138278, 0x8982C144, 0x21D9A266, 0xA8F1F227 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x18000000, 0x94000000, 0xBE000000, 0xA7000000, 0x39800000, 0x6A400000, 0x6C600000, 0x55500000, 0x81E80000, 0x21040000, 0xDA9A0000, 0x55D70000, 0xA5208000, 0xA6A4C000, 0x8DFE6000, 0x4B1CF000, 0x6397A800, 0x5B4FBC00, 0xEEE46200, 0x348BF100, 0x0AD72A80, 0x38BB7E40, 0xFAF20260, 0xCA930350, 0x0DDA8078, 0x9123C0DC, 0x88B6E086, 0x32FC33F9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x08000000, 0x94000000, 0x36000000, 0xBD000000, 0x28800000, 0xA9C00000, 0x60A00000, 0x2CD00000, 0xC4380000, 0x4F1C0000, 0x6B820000, 0xC84D0000, 0x07E88000, 0x50B7C000, 0x34CD2000, 0x3837D000, 0x3D049800, 0xE88A0400, 0xC9CF2200, 0xB0BAD300, 0x24CC1980, 0x502DC740, 0x791A0220, 0xD6810150, 0xE0D28158, 0xAE26C1B4, 0x3007A082, 0x181D10F7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x08000000, 0xF4000000, 0xC6000000, 0xE9000000, 0xD6800000, 0xF2400000, 0x06200000, 0x4F500000, 0x86A80000, 0x8C1C0000, 0x1A1E0000, 0x0B0D0000, 0x41888000, 0x31D9C000, 0x10E3A000, 0x94321000, 0xF05B6800, 0x613E1400, 0xE4DDA200, 0xD46F1100, 0x997BE980, 0x71FBD6C0, 0xF6A00220, 0xA41002D0, 0x3E080298, 0x750C0164, 0x5496037A, 0xD5410019 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xC8000000, 0xFC000000, 0xC6000000, 0xA5000000, 0x7A800000, 0xC6400000, 0x8EE00000, 0x2F500000, 0x9A680000, 0xE0140000, 0x10060000, 0x981D0000, 0x44118000, 0xF201C000, 0x9F0B2000, 0x19979000, 0x19CC6800, 0x323E8C00, 0x67ED2200, 0x3BDA9100, 0x5535E880, 0x6A6B4DC0, 0x68000120, 0xCC0002F0, 0x2E000398, 0x29000354, 0x748002CA, 0x9F4000E9 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x58000000, 0xAC000000, 0x6E000000, 0x41000000, 0x23800000, 0x46C00000, 0x22200000, 0x33D00000, 0x23A80000, 0x4A040000, 0x8B1E0000, 0xE89F0000, 0x0E438000, 0x9C66C000, 0xF7ADA000, 0x7811B000, 0x5C1CF800, 0x96023400, 0x5D13A200, 0x159EB100, 0xABD77A80, 0x6FB0F6C0, 0x34080360, 0x221403B0, 0x3F160338, 0x8A8B03C4, 0x915581EE, 0xA6EDC3AB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x48000000, 0x0C000000, 0xCA000000, 0xFB000000, 0xB1800000, 0x5EC00000, 0xC9600000, 0xC1D00000, 0xAEE80000, 0x46040000, 0x71020000, 0xEA9D0000, 0xBF4B8000, 0xDFB04000, 0x04AEE000, 0xA5377000, 0x13F8B800, 0x86891C00, 0xC54CE200, 0x9CBA7100, 0xA13B3A80, 0x75ED5D40, 0xE7880320, 0xC7D40130, 0x7FEA01A8, 0xFC9902AC, 0x864983E6, 0x392D414B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xA8000000, 0xFC000000, 0xAA000000, 0x63000000, 0x18800000, 0xBB400000, 0xA6E00000, 0x7A500000, 0x91680000, 0xFB940000, 0xE3D60000, 0x3DB10000, 0x2CB18000, 0x43384000, 0x96EFE000, 0xB2545000, 0xBD7C0800, 0x09974C00, 0xD4D1E200, 0x73315100, 0x5EFB8880, 0x9E4E0FC0, 0x4F6780A0, 0x3E8942F0, 0x9A5E6228, 0x016C124C, 0x8393EAC2, 0x47C31D1D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xD8000000, 0x24000000, 0xF2000000, 0x2B000000, 0x7F800000, 0xB2C00000, 0x24200000, 0x03D00000, 0xBCA80000, 0xB0840000, 0xDF520000, 0xCDEF0000, 0x506E8000, 0xF1BD4000, 0xFE0DE000, 0xB517B000, 0xFA863800, 0xE04EF400, 0xE877E200, 0xE5BCB100, 0xA41ABA80, 0xB20CB740, 0x8B1C8160, 0xAF824190, 0x6ACB6148, 0x002EF3EC, 0xF1D9DA9E, 0x97B6465B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xD8000000, 0x4C000000, 0x22000000, 0xDF000000, 0x26800000, 0x8EC00000, 0xB0E00000, 0xEFD00000, 0x73780000, 0xF4940000, 0x19D20000, 0x227F0000, 0x5F138000, 0xE6874000, 0xAED66000, 0xE0EA9000, 0x37C13800, 0x3F634C00, 0xD69C6200, 0xC6D19300, 0x04F8B880, 0xD1CF0D40, 0x566B8160, 0x41134230, 0x93846008, 0xC355923C, 0x26B2BBFA, 0xF4F40F0B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x68000000, 0xEC000000, 0xFA000000, 0xFB000000, 0x61800000, 0x89C00000, 0xD9200000, 0x34D00000, 0x01A80000, 0x33840000, 0x7ECE0000, 0xD2B90000, 0x1E0B8000, 0x3D1A4000, 0x9896E000, 0xA7557000, 0x4F635800, 0x893A9400, 0x8CD0E200, 0x15B87100, 0x7D8EDA80, 0xFBDDD4C0, 0x5E2383A0, 0xF75E42B0, 0xF778E168, 0x9D3C732C, 0xC2C0D826, 0x90A4D597 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x68000000, 0x6C000000, 0x62000000, 0x69000000, 0xC2800000, 0xF2C00000, 0x5E600000, 0x7DD00000, 0x3BF80000, 0x269C0000, 0xCCC60000, 0x5D610000, 0x4A438000, 0x01B94000, 0x8F3CA000, 0x4FE21000, 0x809A7800, 0xCBD41C00, 0x64E2A200, 0x7B0F1300, 0x0387F980, 0x3C405FC0, 0x3EA383A0, 0x22A942B0, 0xE8A4A008, 0x8DAE1264, 0xDD247AAA, 0x2EE91E7B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xB8000000, 0xAC000000, 0x46000000, 0x6B000000, 0xDF800000, 0xBEC00000, 0x1FA00000, 0x37D00000, 0x99380000, 0x87840000, 0x82C60000, 0xB1A30000, 0xB8DB8000, 0x14A7C000, 0xB85CE000, 0x6FF53000, 0x8C29B800, 0x5F1B8400, 0x0582E200, 0x8BC23300, 0xF72C3A80, 0xA88B47C0, 0xFF5B80E0, 0x3667C1B0, 0xF9FCE398, 0x6F25326C, 0x3491B99E, 0xA15F844B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xA8000000, 0x0C000000, 0x22000000, 0x27000000, 0xF8800000, 0x65C00000, 0x4C600000, 0xDD500000, 0x49B80000, 0x81240000, 0x8CFE0000, 0x6C890000, 0x23DB8000, 0xE5734000, 0x90D66000, 0x5BF7D000, 0x5C099800, 0x5A183C00, 0x930DE200, 0xCE849300, 0xC4DFFA80, 0xBDEFEEC0, 0x450478A0, 0xBF9CAF30, 0x8D521808, 0x31AB7D5C, 0x353B81C2, 0xBAE34067 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x78000000, 0x7C000000, 0xE2000000, 0x11000000, 0x0B800000, 0x7EC00000, 0xF9600000, 0x25500000, 0xBFA80000, 0x402C0000, 0xA8E20000, 0x968B0000, 0x9F418000, 0xA2B54000, 0xE1A8A000, 0x1325B000, 0x827A3800, 0x4BDE3C00, 0x1CE92200, 0xE090F100, 0x88529B80, 0xF63B8F40, 0x1FF31BE0, 0xF21ECCF0, 0xC913BA08, 0x47877E04, 0x34C3804E, 0xEC6E424B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x18000000, 0x3C000000, 0x3E000000, 0x99000000, 0xD3800000, 0x13C00000, 0x3EE00000, 0x58500000, 0x51280000, 0xB8AC0000, 0x60660000, 0x22070000, 0xF70D8000, 0x4286C000, 0x1449A000, 0x37393000, 0xFDA11800, 0x7DF14C00, 0xB0C42200, 0x267FF100, 0x3708BB80, 0xE2987FC0, 0x044D3A60, 0xDF22BDF0, 0xD9AA9978, 0x7FE08CA4, 0x17C802AE, 0x6CFC027F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x98000000, 0x64000000, 0x2E000000, 0xAB000000, 0xFC800000, 0xE6C00000, 0xF8A00000, 0x26500000, 0xF4680000, 0x2BEC0000, 0x8DAA0000, 0x39D70000, 0xF22A8000, 0xEF88C000, 0x4E50E000, 0xD879D000, 0x19E2F800, 0xFCBB2400, 0xD85A6200, 0x27611100, 0x237A1B80, 0xDD7EF640, 0x0E7A9860, 0x06E13490, 0x5620F938, 0x618025EC, 0x955AE012, 0x2CFED14B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xA8000000, 0x6C000000, 0xF2000000, 0xDF000000, 0x42800000, 0x15C00000, 0x57200000, 0x63500000, 0x04E80000, 0xED640000, 0x5C2A0000, 0x57D90000, 0xF0238000, 0x45DD4000, 0x1F396000, 0x3F4A9000, 0xCEF09800, 0xF6761400, 0x80BAE200, 0x6F07D100, 0x3A81FA80, 0x71C88640, 0x592878A0, 0xE65CC4B0, 0xF57A9B48, 0x483F143C, 0xC1D1632A, 0x212E92A7 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x48000000, 0x4C000000, 0xD6000000, 0x63000000, 0x9F800000, 0xBF400000, 0xB6A00000, 0x76D00000, 0x2AE80000, 0xFFE40000, 0xB3720000, 0x2BA50000, 0x764F8000, 0x6425C000, 0xC102E000, 0x3E8BB000, 0x31D5C800, 0x3F700400, 0x1DA56200, 0xE54A7100, 0xE3A52A80, 0x7A5EB540, 0x123F2B20, 0xF21FB430, 0xE902ABD8, 0xC29F75CC, 0x5FCFCBDE, 0x0871078D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x98000000, 0x64000000, 0x06000000, 0x65000000, 0x55800000, 0xB6400000, 0x17600000, 0x15D00000, 0x7C280000, 0x633C0000, 0x71BE0000, 0x91670000, 0x30DE8000, 0x49B1C000, 0xE5692000, 0xFECBF000, 0xE0A12800, 0x4AF2BC00, 0x4F9FA200, 0xC1463100, 0xD9F60980, 0xC71E4CC0, 0x16800860, 0xD6D54C90, 0x5CA88B98, 0x48EF8C54, 0x1C8928B6, 0x69CEBE89 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x5C000000, 0xAA000000, 0x5D000000, 0x91800000, 0x34400000, 0x04A00000, 0xF7D00000, 0x19E80000, 0xF4FC0000, 0x3D7A0000, 0x4D390000, 0xC79D8000, 0xF35E4000, 0xD0232000, 0x7613F000, 0xB716E800, 0xAC8BC400, 0xB5D6A200, 0x58F1B100, 0xAF6FC980, 0x44313440, 0xB015CBA0, 0x58083470, 0x44084928, 0x8E167434, 0xC30B6866, 0x3A9584E1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xC8000000, 0x64000000, 0x9A000000, 0xFD000000, 0xA6800000, 0xECC00000, 0x86200000, 0x08500000, 0xABE80000, 0xCEF40000, 0x74660000, 0x8EA50000, 0xFB8E8000, 0xFA584000, 0x82F02000, 0x1A7C1000, 0xF1BCF800, 0xFC187400, 0x8616A200, 0xEB105100, 0x558AD880, 0xE55167C0, 0x556CD920, 0x5E346490, 0x344258E8, 0x4DFC2534, 0xF5FA7B3A, 0x19E434E3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0x74000000, 0x6E000000, 0x2F000000, 0x7F800000, 0x4C400000, 0xFEA00000, 0xC9D00000, 0x23E80000, 0x8FFC0000, 0x3DEA0000, 0xF8E50000, 0xDE688000, 0x3EBAC000, 0xE9DC6000, 0xD3EBB000, 0x97F02800, 0xC1ED8400, 0xE2FCE200, 0x9F7D7100, 0x6E2E4980, 0xDA1F3640, 0x610E4820, 0xA08F34D0, 0x2BC64A38, 0x4EE337FC, 0x2D64485E, 0xAB2A37A1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xE8000000, 0xFC000000, 0x12000000, 0x67000000, 0xF4800000, 0xEAC00000, 0xBE600000, 0x40500000, 0xF9B80000, 0x89BC0000, 0x31BA0000, 0x45B90000, 0x3BA98000, 0xA6A94000, 0xC9386000, 0xC5685000, 0xF6C77800, 0xFC637C00, 0xAF49E200, 0x612D1300, 0x997D1980, 0x14CE2E40, 0xE37D19A0, 0x4FCE2CF0, 0x65FD1BC8, 0x520E2CDC, 0xC71D1BF2, 0x049E2D1B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x38000000, 0x7C000000, 0xB2000000, 0xAF000000, 0xB8800000, 0x54C00000, 0x4A600000, 0x8A500000, 0x77B80000, 0xC1AC0000, 0x80B60000, 0x35330000, 0xBE658000, 0x5C5B4000, 0x06A76000, 0xAC3BD000, 0x87F7B800, 0x5D017C00, 0x379AE200, 0xFC5C9300, 0xD6BEDB80, 0x8435AFC0, 0x33E6DAE0, 0xAB09AEF0, 0x5688DB48, 0x59C6AE7C, 0x95E35B82, 0x2202EC63 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0xC8000000, 0x14000000, 0x8E000000, 0xCF000000, 0x7D800000, 0x5BC00000, 0x53200000, 0x49500000, 0x85780000, 0xB9AC0000, 0x93120000, 0x279D0000, 0xFAC48000, 0x31B2C000, 0xA7126000, 0x9984F000, 0x2DDF5800, 0x90263400, 0x66C4E200, 0x8BAB3300, 0xD609BB80, 0x33100740, 0xD789D920, 0x02C9F750, 0x3DB203B8, 0xF50D037C, 0xCC9C8156, 0x114EC27F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xA8000000, 0x64000000, 0x96000000, 0x23000000, 0x0F800000, 0x50400000, 0xC8600000, 0x0CD00000, 0x9FB80000, 0xA0FC0000, 0x550E0000, 0xDC810000, 0x97C68000, 0xCC21C000, 0xFAADE000, 0xD477B000, 0xA6D8A800, 0x86AE9C00, 0x4E656200, 0x17D77300, 0x0C33C980, 0x9AB8ECC0, 0xE47028A0, 0x0EDE5E90, 0xE2B601D8, 0xD87D034C, 0x34C8831E, 0x03A0C011 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x58000000, 0x04000000, 0x82000000, 0x05000000, 0x05800000, 0x52400000, 0x42E00000, 0xCAD00000, 0x71280000, 0xE8740000, 0x340A0000, 0x0A070000, 0x79168000, 0x13894000, 0x8D4B2000, 0x46707000, 0x1F0AA800, 0x64804C00, 0x65D7A200, 0xDDBE3100, 0xD1B70880, 0x6FA97E40, 0x5CBE2B60, 0x163A0D10, 0x18E00088, 0x8BD00354, 0xD6A801F6, 0x2F340319 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x98000000, 0x34000000, 0x22000000, 0x2B000000, 0xBD800000, 0x79400000, 0x2FE00000, 0x57D00000, 0xAF280000, 0x1B640000, 0xF81E0000, 0xE40F0000, 0x2A148000, 0xB7114000, 0x3390E000, 0x44557000, 0x9B6E0800, 0xB8072C00, 0x441A6200, 0x1A0B3100, 0x2F0A6A80, 0x07931CC0, 0x664C8860, 0xB07D6DD0, 0x05800008, 0x3D40016C, 0x35E00216, 0x78D001F5 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x68000000, 0x24000000, 0xAA000000, 0x93000000, 0xF4800000, 0xC4C00000, 0x8DA00000, 0xB7500000, 0xCFF80000, 0x51240000, 0x37920000, 0x98410000, 0xCD6A8000, 0x40F24000, 0x83B3E000, 0x4E535000, 0x0869B800, 0xB16E4400, 0x16EB6200, 0x86B01300, 0x1FC8DA80, 0x4D2B5740, 0x11833BA0, 0x255C0790, 0xD0F88228, 0x8BB3420C, 0x1A5960F2, 0x1A6110C3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x28000000, 0xCC000000, 0x4A000000, 0x81000000, 0x61800000, 0x4A400000, 0xDEE00000, 0x2ED00000, 0x83380000, 0x69740000, 0x678A0000, 0x41590000, 0x1E7F8000, 0x151E4000, 0x3F94A000, 0x5558F000, 0x80722800, 0x2A12CC00, 0x71012200, 0x798FB300, 0xBE410880, 0x70F07C40, 0x29D5AAA0, 0x29A88C30, 0xC3A783A8, 0x92BA4144, 0xFB26A1A6, 0x6D75F259 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x98000000, 0xE4000000, 0x76000000, 0xB5000000, 0xE3800000, 0xAE400000, 0xFE200000, 0x94D00000, 0x09E80000, 0x1BBC0000, 0x57860000, 0x90570000, 0xA72E8000, 0x8D53C000, 0x18B12000, 0x21123000, 0x4D9BA800, 0x9F4A1400, 0x9BB9A200, 0x1786F100, 0xF04C0980, 0x5727E7C0, 0x155D2860, 0xFCA5D690, 0x570E8258, 0xF883C014, 0x7CD9206E, 0x35EE32E9 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xD8000000, 0x24000000, 0x82000000, 0x91000000, 0xA2800000, 0x2F400000, 0x19200000, 0x0ED00000, 0x1DF80000, 0x5E2C0000, 0xB74A0000, 0x1D3F0000, 0x7CCA8000, 0x44F14000, 0x00A1A000, 0x3E0A9000, 0x17188800, 0x419FD400, 0xD4D92200, 0x68E8D300, 0x9EB9AB80, 0x191B0440, 0x7E8A8960, 0x795CD790, 0xC221A388, 0xC14A9104, 0x36388A6A, 0x7B4FD46D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0xF8000000, 0x5C000000, 0x26000000, 0x05000000, 0xF2800000, 0x91400000, 0x43600000, 0x08D00000, 0x61B80000, 0x82740000, 0x90560000, 0xFBE30000, 0x62818000, 0x795DC000, 0x37702000, 0x7ADF1000, 0xE6B14800, 0x0FE91C00, 0xD09FA200, 0xDE55D300, 0x4AF6E880, 0xC218CFC0, 0x9F0749E0, 0x019A1E70, 0x6EC62218, 0x84AC10D4, 0xA0E8C8AA, 0x0910DCF5 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x58000000, 0x3C000000, 0x82000000, 0x53000000, 0x5C800000, 0xD3C00000, 0x67E00000, 0xB6500000, 0x4FA80000, 0x58EC0000, 0x70C20000, 0x137F0000, 0x31918000, 0x1E494000, 0x5BBAE000, 0x8EF65000, 0x15D35800, 0xFAFE8C00, 0x53C16200, 0x27EC1100, 0x565A3B80, 0x9FAE9F40, 0x00F15B60, 0x4CD18DF0, 0x9178E388, 0x6289530C, 0x42C2DB92, 0x8877CCFF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x38000000, 0xDC000000, 0x92000000, 0x0F000000, 0x97800000, 0x7FC00000, 0xEE200000, 0x49500000, 0x8B780000, 0xA8240000, 0x50460000, 0x8DEB0000, 0x95718000, 0xBD334000, 0x8CC16000, 0x5BB93000, 0xA1915800, 0x5EC45400, 0x34AEE200, 0xE6157300, 0x691FBA80, 0x3E8125C0, 0xE1495AE0, 0x7F705470, 0x0E30E2C8, 0x594A72FC, 0x6370383E, 0x3C2D674F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x38000000, 0x54000000, 0x5A000000, 0x0F000000, 0xC6800000, 0x60400000, 0x4AA00000, 0x17D00000, 0xD1780000, 0x38A40000, 0xB4DA0000, 0xB9EB0000, 0x9DFC8000, 0x0FF64000, 0x5CF06000, 0x3C771000, 0x652FA800, 0xE813E400, 0x0C0EE200, 0x3E1E5300, 0xFD014A80, 0xA59DB640, 0xA8D7AAE0, 0x7FF7E650, 0x94F4E1E8, 0x6065517C, 0xC325C97A, 0xD11FF691 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xB8000000, 0x34000000, 0x92000000, 0xDD000000, 0xFF800000, 0xDCC00000, 0x9E200000, 0xEE300000, 0x76280000, 0x92340000, 0x88320000, 0xD9250000, 0x80A38000, 0x1371C000, 0xAFCA6000, 0x62A59000, 0x56760800, 0xB441CC00, 0xA4760A00, 0x9941CF00, 0x03F60980, 0x4181CFC0, 0xB7D60B60, 0x46B1CF10, 0xAC7E0928, 0xD545CC64, 0x45EC0AD6, 0x3E90CF17 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x08000000, 0xCC000000, 0x92000000, 0xB9000000, 0x10800000, 0xF3C00000, 0xB4200000, 0xE4300000, 0x1C380000, 0xB8340000, 0x56220000, 0x75230000, 0x10BA8000, 0x61E8C000, 0x9F1FE000, 0xDF8DF000, 0xD45B8800, 0xC4610C00, 0xCE5B8A00, 0xF1610D00, 0x2CDB8B80, 0x0BA10FC0, 0x807B8BA0, 0xD0510CF0, 0xBA6389E8, 0x35550E14, 0xE0F989AA, 0x0B820DDB } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x98000000, 0xEC000000, 0x2A000000, 0x27000000, 0xA9800000, 0x09400000, 0x11E00000, 0x99F00000, 0x2DE80000, 0x8BE40000, 0x16F60000, 0x00650000, 0x4CB88000, 0x7E1DC000, 0xD1092000, 0xCC841000, 0x63C93800, 0xEF390400, 0x60493A00, 0x01790700, 0xB8293B80, 0x01C90540, 0x1C2139E0, 0xFFDD06F0, 0x0D3F3948, 0x535C066C, 0xFEF1BBEE, 0x2464C649 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xF8000000, 0x84000000, 0x26000000, 0xA7000000, 0x3A800000, 0x9EC00000, 0x4FE00000, 0x87F00000, 0x4BF80000, 0xE1E40000, 0x0CE60000, 0xCB790000, 0x6A298000, 0x008D4000, 0xCBC9A000, 0xEC66F000, 0x10B92800, 0x7E5AD400, 0x94392A00, 0x939AD500, 0xDF592980, 0xB9AAD540, 0x3FC12A60, 0x627ED750, 0x2BBF2AF8, 0xF6D3D5CC, 0x73E8AA12, 0xC5F397B7 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x28000000, 0x34000000, 0x76000000, 0x53000000, 0xB1800000, 0x57400000, 0xF5E00000, 0x4BF00000, 0x7CF80000, 0x837C0000, 0xAB3A0000, 0x855F0000, 0x88E98000, 0x957F4000, 0xE8392000, 0x2CCD1000, 0xC3B4F800, 0x2291C400, 0x86CCFA00, 0xB2ADC500, 0xA616FA80, 0x2B02C5C0, 0xBD877A20, 0x0D418510, 0xCCE45BF8, 0xEB63945C, 0xBF21213E, 0xC3411101 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x98000000, 0x0C000000, 0x6A000000, 0x85000000, 0x30800000, 0xD7C00000, 0x7AE00000, 0x9CF00000, 0x33F80000, 0xA67C0000, 0x11360000, 0x24050000, 0xCE148000, 0x0B11C000, 0x1B856000, 0x9C497000, 0x7EA08800, 0xEE5E5400, 0xB7B88A00, 0x94D25500, 0xB5768A80, 0x46AB5440, 0xF25408E0, 0x65BF9470, 0x4DC5E948, 0x77E72664, 0x1860018A, 0xD230013B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x48000000, 0xA4000000, 0xB6000000, 0x69000000, 0x56800000, 0x18400000, 0x4E200000, 0xCC300000, 0xBB280000, 0xD0AC0000, 0xB0760000, 0x631F0000, 0xA59B8000, 0x15D54000, 0x0FFC6000, 0xEDDCB000, 0xD3FEB800, 0x47CFFC00, 0x30F6BA00, 0x2253FF00, 0x0528BA80, 0xFDA0FC40, 0xA0E53BA0, 0x8A5ABED0, 0x512AD978, 0xD3BF4F74, 0x25FE0022, 0xCEC30315 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x38000000, 0xC4000000, 0xE6000000, 0x85000000, 0x23800000, 0x39C00000, 0x84E00000, 0x5EF00000, 0x19F80000, 0xC96C0000, 0x5E2A0000, 0x3C8D0000, 0xFD458000, 0x5DB14000, 0x7545E000, 0xE1BF9000, 0xF753A800, 0xB2B1B400, 0x69CBAA00, 0x6CEDB500, 0x32F9A880, 0x33FCB5C0, 0x566E2860, 0xDAACF6D0, 0x45C44BF8, 0xE6EF24C4, 0x9DF78376, 0x8F604023 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x88000000, 0xAC000000, 0x5E000000, 0x2D000000, 0xF8800000, 0x88C00000, 0x5EA00000, 0x13B00000, 0xFB380000, 0x1BE40000, 0xB94E0000, 0x7CEF0000, 0x06C28000, 0xBBAD4000, 0xA726E000, 0x7DF6F000, 0xE0556800, 0xFE6BFC00, 0x511B6A00, 0x6E84FD00, 0xE9D9E980, 0xA829BC40, 0x3E7F0BA0, 0xF11F4EF0, 0xDE8A62D8, 0x31C4B244, 0x8C290B3A, 0xCC644D67 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xA8000000, 0xF4000000, 0xF6000000, 0xBF000000, 0x7C800000, 0x07C00000, 0x4EE00000, 0x81F00000, 0x95680000, 0xC6BC0000, 0x8E420000, 0x18A70000, 0x05518000, 0x32334000, 0x4D86A000, 0xA85E3000, 0x3FA74800, 0x85C1D400, 0xC7E54A00, 0xE266D700, 0x1E34C880, 0x279594C0, 0xB5526A20, 0xFA3BA710, 0xE99D21F8, 0x064671EC, 0xDCBA6A0A, 0xFB47A6F3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x88000000, 0x1C000000, 0x16000000, 0xB9000000, 0x3F800000, 0x2A400000, 0xF3E00000, 0x62F00000, 0xF1680000, 0x35340000, 0x7BC60000, 0xA4A70000, 0xCC8C8000, 0x9ADA4000, 0x2F3B6000, 0x9CD39000, 0xDE3E5800, 0x5F446400, 0x72785A00, 0x9DA36700, 0x3314D980, 0x50892540, 0x4CC7BBA0, 0x762EB530, 0x335FE3F8, 0x7C7DD3D4, 0xB0A33906, 0x0680F47D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x58000000, 0x2C000000, 0x12000000, 0x31000000, 0x0E800000, 0x1F400000, 0x62E00000, 0x1BF00000, 0x81780000, 0xD02C0000, 0x19D60000, 0x49AD0000, 0xE7108000, 0x699EC000, 0x36DEE000, 0xF43A3000, 0x3FDD5800, 0xE6A5C400, 0x1A8B5A00, 0x1148C500, 0x69FBD880, 0x80660640, 0xF6BD39E0, 0xA28036F0, 0x4D4E61A8, 0xF3E4F234, 0xC563BB92, 0xC62FF749 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xF8000000, 0xA4000000, 0x1A000000, 0xA7000000, 0x88800000, 0x6B400000, 0x07200000, 0x08300000, 0x6CB80000, 0x61FC0000, 0x8FC20000, 0x4A6D0000, 0xC6018000, 0x591EC000, 0x15982000, 0xB4CC3000, 0x1CF4D800, 0xC04CFC00, 0x79B6DA00, 0xA261FD00, 0x0A175A80, 0xCF0F3EC0, 0x04977960, 0xDD4F0C50, 0xE639A108, 0x99A2F2CC, 0x3274F92A, 0x220CCE61 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xD8000000, 0x1C000000, 0x46000000, 0xD1000000, 0x20800000, 0x42400000, 0xAE200000, 0xFB300000, 0xE1A80000, 0xA4FC0000, 0x135A0000, 0x4EB10000, 0x197A8000, 0x7F9E4000, 0x87C66000, 0xEEE77000, 0xAC53B800, 0xDB233C00, 0x11A9BA00, 0xDCE23F00, 0x3F5B3880, 0xD0B07FC0, 0xD46F5BE0, 0x191A0FB0, 0x149C62F8, 0x605670F4, 0x1529387A, 0x94BD7EFD } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xF8000000, 0x4C000000, 0x6A000000, 0x8F000000, 0x43800000, 0x02400000, 0x7FA00000, 0xF4B00000, 0x59280000, 0xFA6C0000, 0x47560000, 0xA3390000, 0x6D788000, 0xB8C9C000, 0xE3762000, 0x29D35000, 0x29E99800, 0x5D14AC00, 0x609F9A00, 0xDBDDAF00, 0xDAEF1A80, 0x7C886C40, 0x89C73960, 0x39FE3D70, 0x850820C8, 0xFC86534C, 0x49C71BC6, 0x19E46C45 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0xF8000000, 0x14000000, 0xE6000000, 0x99000000, 0x47800000, 0xEF400000, 0x4DE00000, 0x12F00000, 0xBC780000, 0xDCA40000, 0x421E0000, 0x17110000, 0xD29B8000, 0x8ADB4000, 0x25B26000, 0x95959000, 0xE052F800, 0x5B738400, 0x8634FA00, 0x14C68500, 0xE8B17980, 0xD40CC640, 0x46189A60, 0xA9021610, 0x6F9801F8, 0x03540074, 0xBFE602E6, 0x6DF502C9 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xC8000000, 0x4C000000, 0x3A000000, 0x1F000000, 0x94800000, 0xEBC00000, 0x37600000, 0x82700000, 0x31F80000, 0x6AAC0000, 0x701A0000, 0x28130000, 0x5C128000, 0x4201C000, 0x9B142000, 0xE29FB000, 0xCECB4800, 0xBCEAE400, 0xFD294A00, 0xED55E500, 0xDFA1C880, 0xC38727C0, 0x73476BA0, 0x46A956F0, 0x1A000348, 0xEF00028C, 0xFC80031A, 0x17C00023 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xA8000000, 0x2C000000, 0xFE000000, 0x51000000, 0xEF800000, 0x06400000, 0x57600000, 0x10700000, 0x22E80000, 0x05240000, 0xFD0E0000, 0xD18B0000, 0x37568000, 0xE8E54000, 0xBE356000, 0x59859000, 0xEB5CD800, 0x8EFBF400, 0x3B3ADA00, 0xCC14F700, 0x6E025B80, 0x990AB640, 0x9389B920, 0x504E66F0, 0x2A6E02D8, 0x01FB03B4, 0x75BE8366, 0xBDC140AD } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xC8000000, 0x7C000000, 0xC2000000, 0x13000000, 0x61800000, 0xC3400000, 0x58200000, 0xA1300000, 0x5FB80000, 0x97740000, 0xD3020000, 0x418B0000, 0x134C8000, 0x2038C000, 0x153CA000, 0xE1A19000, 0x467A7800, 0xA19F3C00, 0xE3407A00, 0x88203D00, 0xD92EFB80, 0xEBA3FFC0, 0x2966D8A0, 0x020EAE30, 0x330203A8, 0xB18B027C, 0xBB4C802E, 0xEC38C071 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xF8000000, 0x2C000000, 0x96000000, 0xCF000000, 0x62800000, 0xDD400000, 0xFEA00000, 0x4BB00000, 0x90380000, 0x10EC0000, 0xF9860000, 0x45C90000, 0xDAE48000, 0x48924000, 0x9C59A000, 0x8F36F000, 0xCA66D800, 0xA8D6CC00, 0x7D78DA00, 0xA643CD00, 0x96225880, 0xC7F48C40, 0x47197B60, 0xA6993CF0, 0x3F428138, 0xDBAB43CC, 0x882522B2, 0xCCF8B1B9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x48000000, 0x5C000000, 0x3A000000, 0xE7000000, 0x99800000, 0x04400000, 0xBB200000, 0x0A300000, 0x46B80000, 0x407C0000, 0xEC8A0000, 0xF6D30000, 0xC4F08000, 0xF643C000, 0x40312000, 0x89B71000, 0x15E61800, 0x2ACD3C00, 0xBEF41A00, 0x31523D00, 0x69B69A80, 0xC5FEFFC0, 0xF2DD3BA0, 0x1AE92EB0, 0x1F428348, 0xE8ACC12C, 0x816BA32E, 0x8817D03D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x58000000, 0xAC000000, 0xDE000000, 0xE9000000, 0x99800000, 0x82C00000, 0x9D600000, 0x3E700000, 0x6CF80000, 0x08AC0000, 0x239A0000, 0xB1C10000, 0x67FC8000, 0x0E234000, 0x85C06000, 0xF5FC5000, 0x29378800, 0x1D48E400, 0x1AB58A00, 0x4495E500, 0x894B0880, 0x38ABA7C0, 0x3B95E9E0, 0xBDD9B570, 0x09E48298, 0xBF3F42D4, 0xB04262FE, 0xA92151DF } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x08000000, 0x54000000, 0xD6000000, 0xE5000000, 0xAB800000, 0xE9400000, 0x1B200000, 0x70B00000, 0x39F80000, 0x92C40000, 0xBA7E0000, 0xDF870000, 0xCF498000, 0x462D4000, 0xD736E000, 0x5AAA1000, 0xEEFA7800, 0x525FFC00, 0x41B3FA00, 0x0472BD00, 0x7E851980, 0x5AD8AC40, 0x4E7F61A0, 0xB9875110, 0x724C98F8, 0xB1B5EF84, 0xBC6983D6, 0x729D4061 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x18000000, 0x54000000, 0xFA000000, 0x83000000, 0xCA800000, 0x95C00000, 0xB7A00000, 0x2D300000, 0x70F80000, 0x1B5C0000, 0x307A0000, 0x75810000, 0x89578000, 0x9F72C000, 0x8103A000, 0xCD9D7000, 0x2D550800, 0x5D745C00, 0xE6028A00, 0xE5069D00, 0x6F812A80, 0xDA5BEFC0, 0xDDF422E0, 0xE8DFB290, 0xCC2EAB08, 0x2D752D9C, 0x9E0D82A2, 0x2103C00B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x48000000, 0x9C000000, 0x42000000, 0x51000000, 0xC2800000, 0x25C00000, 0x65600000, 0x9FF00000, 0xFE280000, 0xAD5C0000, 0xEDA60000, 0x8A070000, 0x0D088000, 0x2086C000, 0x24DBE000, 0xEFF33000, 0x26354800, 0xD9500400, 0x63BDCA00, 0xD116C700, 0x02862880, 0x85D5F640, 0x357B61A0, 0xD7E9F030, 0x6228AAA8, 0xEF543674, 0xBCA80122, 0x489C00A3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x38000000, 0x04000000, 0x76000000, 0xDF000000, 0x84800000, 0x84400000, 0xFCA00000, 0x5C300000, 0x7E780000, 0xF5C40000, 0x617A0000, 0xD1450000, 0x75218000, 0x65E54000, 0x1503A000, 0x6996B000, 0x49C97800, 0x53784C00, 0x9848FA00, 0x5EAD0D00, 0x5D335980, 0x69FFBCC0, 0xBF002160, 0xB482F0D0, 0x5C495AB8, 0x88BABEAC, 0x1221A12A, 0xA567B07D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x48000000, 0x5C000000, 0xAA000000, 0xB5000000, 0x17800000, 0x42400000, 0x06200000, 0xDDB00000, 0x8DE80000, 0x0ACC0000, 0x06FA0000, 0x9E5B0000, 0x6C3C8000, 0x48A3C000, 0xAA666000, 0x00841000, 0x5CCD9800, 0xE9F43C00, 0x54D11A00, 0x55E7FF00, 0xEEDF7A80, 0x98EFEFC0, 0xED48E3A0, 0x2CB0D2B0, 0xF46D7B08, 0x5388EF64, 0x2C4661D6, 0x1D3411AD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x98000000, 0x5C000000, 0x12000000, 0x07000000, 0x4E800000, 0x4AC00000, 0xF7E00000, 0x2B700000, 0xA6A80000, 0xBFDC0000, 0x6E7A0000, 0xA7210000, 0x6F868000, 0xB556C000, 0xAAAB2000, 0xE5DE7000, 0xBD60E800, 0x8FB3B400, 0xF44E6A00, 0x45397700, 0x909F4880, 0xB7C605C0, 0xDA7922E0, 0xD12370B0, 0x969C68A8, 0x76C477AC, 0xF5E3C912, 0x0471C747 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x78000000, 0x14000000, 0x2A000000, 0x69000000, 0x0E800000, 0x54C00000, 0x82200000, 0xC6B00000, 0x4B680000, 0xCFCC0000, 0x61B60000, 0xEEF10000, 0xB08F8000, 0xD7D4C000, 0xC5A4E000, 0xCCFCB000, 0xE583E800, 0x9F40CC00, 0xC6646A00, 0x03580F00, 0x10768A80, 0x0C55BE40, 0x19FAE360, 0x6D01B210, 0xBC9A69C8, 0x59D50CB4, 0x8EA70B72, 0x977C7FA7 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x28000000, 0x84000000, 0x82000000, 0x55000000, 0x37800000, 0xB0400000, 0x3BE00000, 0x06700000, 0x37380000, 0xB15C0000, 0xC66E0000, 0x57330000, 0x814F8000, 0xFE69C000, 0xFB3C6000, 0x87431000, 0x2963D800, 0x99A14400, 0x00945A00, 0xA2D48500, 0xA4263A80, 0x31D49540, 0x24B26220, 0xD3001350, 0xA0945A28, 0xF2D48704, 0xAC263876, 0xA5D49485 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x48000000, 0x8C000000, 0x9A000000, 0x57000000, 0x4B800000, 0x50400000, 0x0CA00000, 0x65300000, 0xE6780000, 0x975C0000, 0x1F220000, 0xA1730000, 0xC4CE8000, 0xFB67C000, 0xF3D22000, 0xE0FFD000, 0x9B851800, 0x28462C00, 0xE8B39A00, 0x033DED00, 0x6363BA80, 0x07C13CC0, 0x9EF023A0, 0xAA8CD2F0, 0xE6CB9BC8, 0x2861EEAC, 0x8E41B866, 0x0DB23F2D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x88000000, 0x04000000, 0x66000000, 0xC5000000, 0x57800000, 0xCAC00000, 0x99A00000, 0x6C300000, 0xE5F80000, 0x3ECC0000, 0x37B20000, 0x0D3B0000, 0xA4678000, 0xB9114000, 0xFD86E000, 0xCDD59000, 0x1D348800, 0xBC6DDC00, 0xE50B0A00, 0x67809D00, 0xE2C7E880, 0xEDA20CC0, 0x8226E2A0, 0x24E590D0, 0x0F4C8938, 0x3861DEC4, 0xC31908E6, 0x028B9D2F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xB8000000, 0x94000000, 0xAA000000, 0xB9000000, 0x77800000, 0x87C00000, 0x5B600000, 0xC2F00000, 0xBE280000, 0x97C40000, 0xD36A0000, 0x8EF50000, 0x70338000, 0x3CD4C000, 0x89FAE000, 0xD4B99000, 0x159AA800, 0xD2D1A400, 0x72E12A00, 0xA6316700, 0x93D9CB80, 0x3179F4C0, 0x1BFAE160, 0x39B99290, 0xA81AA9C8, 0x1C11A774, 0xE6012B96, 0x770165AB } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x38000000, 0xDC000000, 0xDE000000, 0x6D000000, 0x90800000, 0x6DC00000, 0x1E600000, 0x34F00000, 0xF6280000, 0xEBCC0000, 0x3F720000, 0x127D0000, 0x62FA8000, 0x5F2B4000, 0x094FE000, 0xD9B17000, 0x2D948800, 0x754D2400, 0xB7A60A00, 0x589A6700, 0x49D3EA80, 0x3C6A16C0, 0xF7E7E260, 0x33BD71B0, 0xCA868B18, 0x92C02704, 0x55F48BDA, 0x30BD2473 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x88000000, 0xD4000000, 0x46000000, 0xD9000000, 0x81800000, 0xD5400000, 0xD0600000, 0xC0F00000, 0xE0380000, 0xF3040000, 0x02820000, 0xFFDB0000, 0xABBD8000, 0x15534000, 0x70616000, 0x90EFD000, 0xD83FB800, 0xAF059400, 0x90803A00, 0x60CDD500, 0xF33CD980, 0x418147C0, 0x755A03A0, 0x806F0090, 0xF8E780B8, 0xBC3C42F4, 0x6106E13E, 0x9D939361 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x08000000, 0xFC000000, 0xAE000000, 0x11000000, 0x24800000, 0x8D400000, 0x88600000, 0x45F00000, 0x68280000, 0x870C0000, 0x918E0000, 0xD3D70000, 0xD62C8000, 0x5E1B4000, 0x69106000, 0x60977000, 0x47451800, 0xC3653400, 0x22679A00, 0x7EE97700, 0xB7BB7A80, 0xF5D54540, 0xFB2602A0, 0xF49B02B0, 0x65428218, 0xC47C41F4, 0x73F4E20A, 0x8D303181 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x58000000, 0xA4000000, 0x02000000, 0x39000000, 0x93800000, 0x41C00000, 0x80A00000, 0x3E300000, 0xF6780000, 0xCA140000, 0xD5020000, 0x3D810000, 0xB6D98000, 0xD43FC000, 0x7363E000, 0x9F8D1000, 0x9FD96800, 0x4FA05C00, 0xFEA2EA00, 0xE12E9D00, 0x3EE08B80, 0x11484DC0, 0xDFF802E0, 0x66D40350, 0xFC2200E8, 0xEF7102B4, 0x09818326, 0xFCDBC373 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0xD8000000, 0xB4000000, 0xDA000000, 0xA1000000, 0xCD800000, 0x69400000, 0xAE600000, 0x7EF00000, 0x8C380000, 0x340C0000, 0x9A1E0000, 0x010D0000, 0xDD8F8000, 0xB156C000, 0x1A79E000, 0xA4E6D000, 0x2D38B800, 0xF98D5400, 0xF3493A00, 0xAF669500, 0xA3675880, 0x3D6A8540, 0x2E6003E0, 0x3EF00390, 0x2C380288, 0x240C0014, 0x421E033E, 0xB50D01F1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xC8000000, 0x8C000000, 0x5E000000, 0xBF000000, 0xA9800000, 0x68400000, 0xD7E00000, 0x15700000, 0xBEA80000, 0x041C0000, 0xB21A0000, 0xF11B0000, 0x6E9E8000, 0x85C34000, 0x6DADA000, 0x23991000, 0xBD57D800, 0x7B76C400, 0x09B35A00, 0x819E8700, 0x34487880, 0x51E8D5C0, 0x5E6003A0, 0x0D3003F0, 0x014800D8, 0x2D6C020C, 0x9AB200FE, 0xC607016D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xA8000000, 0x04000000, 0xBA000000, 0xFB000000, 0xAF800000, 0x36400000, 0xDCE00000, 0x42700000, 0xC8B80000, 0x298C0000, 0xCB420000, 0xCE7F0000, 0xC6BB8000, 0x609AC000, 0x6BD4A000, 0x45B7D000, 0xD3175800, 0xEB952400, 0x2C56DA00, 0xD7FCE500, 0x45FBF880, 0xFAEEF6C0, 0x4F638220, 0x7226C2D0, 0xA94EA2C8, 0xD974D03C, 0x7736DAF6, 0xE7CCE725 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x18000000, 0x1C000000, 0x96000000, 0x9B000000, 0x9C800000, 0x34C00000, 0x3D600000, 0x94F00000, 0xABA80000, 0x60840000, 0xD2C20000, 0xDE790000, 0xA4668000, 0x117A4000, 0xDAE62000, 0x4CA03000, 0xDA176800, 0x65102400, 0x639BEA00, 0x92576700, 0x1CB94B80, 0xB20415C0, 0x010683E0, 0x598A41B0, 0x874E23B8, 0x072430DC, 0x8C55684A, 0x93A926CF } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x58000000, 0x24000000, 0xCA000000, 0xA1000000, 0xE2800000, 0xE4400000, 0x85600000, 0x44F00000, 0x3F280000, 0x62840000, 0x245E0000, 0xE56D0000, 0x14F58000, 0x673EC000, 0x468DE000, 0xEE4F3000, 0x4479F800, 0xF665F400, 0x837A7A00, 0xC3F23700, 0xAABC1B80, 0x7B5EC640, 0x94F582E0, 0xA73EC2D0, 0x268DE3C8, 0xBE4F3354, 0x1C79F9C2, 0xD265F585 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x78000000, 0xB4000000, 0xFE000000, 0x8D000000, 0x51800000, 0xB5C00000, 0xC7A00000, 0xD1300000, 0x06780000, 0xC8940000, 0x2A460000, 0xF7610000, 0x9B0B8000, 0x508E4000, 0xCE54E000, 0x11665000, 0xB2122800, 0x871AFC00, 0x4287AA00, 0x7951BD00, 0x5BE6CB80, 0x174CAD40, 0xEEED8260, 0x92DF4390, 0xB5276398, 0xA07C10A4, 0x8180CB5E, 0xEDDDAE33 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x08000000, 0x84000000, 0x7E000000, 0x49000000, 0x24800000, 0x55400000, 0xD3600000, 0x64F00000, 0xF2280000, 0x01840000, 0x3BDA0000, 0xD9230000, 0x2E0F8000, 0x91064000, 0xB89A6000, 0xD74C7000, 0x68661800, 0xF374D400, 0xB4FB9A00, 0xEA259700, 0xFD9C7B80, 0xC9C8A6C0, 0x6A3583A0, 0x3D9540D0, 0xA9DDE058, 0x1A3E32F4, 0x358E794A, 0x2DDFA661 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x78000000, 0x9C000000, 0x6A000000, 0xEB000000, 0x26800000, 0x18C00000, 0x76A00000, 0x15300000, 0x26680000, 0x379C0000, 0xCD560000, 0xA4E10000, 0xB9568000, 0x4AE9C000, 0xD447A000, 0x4576F000, 0xE511A800, 0xFB989C00, 0x1F592A00, 0x73FC5F00, 0x25D60880, 0xC12E6C40, 0x18688160, 0x2294C230, 0x5EC722C8, 0xFFBE329C, 0xECA088D2, 0x9637ADBF } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xF8000000, 0x44000000, 0xC2000000, 0x0D000000, 0x6B800000, 0x4B400000, 0xF0E00000, 0x9BB00000, 0xFB580000, 0x38FC0000, 0x57BE0000, 0x555D0000, 0x4BEB8000, 0xB72EC000, 0xBA84E000, 0x96C75000, 0xFCBAD800, 0x61DB9400, 0x3E3E3A00, 0xF31CC500, 0xA084E080, 0x4FC75240, 0x0D3AD960, 0xB39B9650, 0x9F5E3AE8, 0x6AECC424, 0x02BCE226, 0xAACB5359 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x08000000, 0x94000000, 0xB6000000, 0x5D000000, 0xDC800000, 0x3EC00000, 0x8D600000, 0xCBB00000, 0x8AD80000, 0x8B740000, 0x6EAE0000, 0xDA5B0000, 0x9FA78000, 0x9CCA4000, 0x26766000, 0xAA2FB000, 0x78820800, 0x30DE1400, 0xBC746A00, 0x2D31A500, 0xC3166180, 0xA59FB140, 0xAC5A0BA0, 0x62AA1610, 0xB05A68F8, 0x00AAA624, 0xBB51E02A, 0x9125F0CF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0xC8000000, 0x14000000, 0xD2000000, 0x45000000, 0x28800000, 0xEBC00000, 0xB6600000, 0xC9B00000, 0x6DC80000, 0x01640000, 0xD43E0000, 0xF6830000, 0x80DF8000, 0x6DF6C000, 0xC5E9E000, 0x81FE3000, 0x7BF4A800, 0xBAFF5400, 0x887D4A00, 0x32B16700, 0x7E41E180, 0x192A3140, 0xEA02A8A0, 0xC9185610, 0xC69CCA68, 0xF8C4A644, 0xC1F7826A, 0x5BE2C3FB } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xF8000000, 0xAC000000, 0x1A000000, 0xD1000000, 0x0D800000, 0xFE400000, 0x3EA00000, 0xCCF00000, 0x78480000, 0xCDA40000, 0x5C7A0000, 0x21810000, 0x244E8000, 0x0FBCC000, 0x71606000, 0x7E191000, 0x5F0CB800, 0x8A8B7C00, 0x88CCDA00, 0xE4626F00, 0xAD886180, 0x6E4D11C0, 0x96BEB860, 0x28EE7C70, 0x36585988, 0xAAAFAEF4, 0x9AEE81DE, 0x034CC17D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x08000000, 0x84000000, 0x3E000000, 0xE9000000, 0x50800000, 0x7EC00000, 0x30600000, 0xFAB00000, 0x5CD80000, 0xDB740000, 0x11320000, 0xD1870000, 0x1A458000, 0x98B54000, 0x57D5E000, 0xC0EEB000, 0x947E8800, 0x94B53400, 0xADCB6A00, 0xF7EB8500, 0xDDEDE180, 0xB2EAB2C0, 0x67748BA0, 0x033635D0, 0x9284EAD8, 0x65DDC4B4, 0xD3F7803A, 0xF3F2409F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x28000000, 0xD4000000, 0x42000000, 0xB1000000, 0xFB800000, 0x9CC00000, 0xF0E00000, 0xD0300000, 0x16C80000, 0x05F40000, 0x21B60000, 0xBF070000, 0x648B8000, 0x0854C000, 0xE0B16000, 0x9C86D000, 0x34462800, 0x16BFE400, 0x3F974A00, 0x56C93700, 0xA5F96380, 0x11B2D240, 0xC7102920, 0x9888E610, 0x9E54CBA8, 0x13A9F694, 0xD61E0166, 0x530302F7 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x38000000, 0xF4000000, 0xEE000000, 0x1F000000, 0xE4800000, 0x39400000, 0xEA600000, 0x2F300000, 0xA7580000, 0x6D740000, 0x6FBA0000, 0xF8090000, 0x540D8000, 0xBE094000, 0x970F2000, 0x2886F000, 0x2358F800, 0x1B644400, 0xD4B7DA00, 0x7A92B500, 0xBE572180, 0xAAF2F3C0, 0x7062FB60, 0x9E2D4510, 0xBCDA5958, 0x00ABF6AC, 0x848001AA, 0xC9400359 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x98000000, 0x14000000, 0x6A000000, 0xC9000000, 0x4E800000, 0xDD400000, 0x84200000, 0x53700000, 0x0E580000, 0xDBBC0000, 0x74BA0000, 0xCD350000, 0x5DFD8000, 0x731DC000, 0xAF856000, 0xBFCB7000, 0xD770B800, 0xEC5ECC00, 0xCEADDA00, 0x2C29BD00, 0x3F676080, 0x204272C0, 0x10B738E0, 0x7F360F90, 0x20F539C8, 0xA78F0E74, 0x23CAB812, 0x616BCE91 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x08000000, 0x8C000000, 0x66000000, 0x71000000, 0x7C800000, 0x6A400000, 0x7E200000, 0xA2700000, 0x85480000, 0xA7A40000, 0xB6BE0000, 0x9A3B0000, 0x18648000, 0x7A5B4000, 0xB635E000, 0xCE6F3000, 0x73449800, 0xDEB4EC00, 0x46397A00, 0x967FDF00, 0x1743E180, 0xA4B03140, 0x593E1BA0, 0x17E4AC70, 0x67801BB8, 0xC1DFACF4, 0xF9E499EA, 0x5A84ED2D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xA8000000, 0xD4000000, 0x4A000000, 0x9B000000, 0x3B800000, 0x56400000, 0x4EE00000, 0xDAB00000, 0x6B480000, 0xC86C0000, 0xCA6A0000, 0x95730000, 0x9CF38000, 0x5DA1C000, 0x1EDD2000, 0x97399000, 0x58017800, 0xBC00B400, 0x3E145A00, 0xA1152700, 0x089F2080, 0xB9D692C0, 0x52B0F820, 0x0F4E7690, 0x8A78F988, 0xF562763C, 0x4CF2F946, 0x85A175F5 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x78000000, 0x7C000000, 0xDA000000, 0x45000000, 0xFB800000, 0x94C00000, 0xEAE00000, 0x4C300000, 0xF7C80000, 0x4E6C0000, 0xC66A0000, 0x02690000, 0x047C8000, 0xEB66C000, 0x2DEEE000, 0x3EA55000, 0x9A842800, 0x795EA400, 0x3922CA00, 0x1457F700, 0x76ACE080, 0xFE9052C0, 0x0F5AAB60, 0xAE3D6430, 0xAEDAA888, 0xBFFD67E4, 0x1FBAA806, 0x170D6587 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xC8000000, 0x8C000000, 0x82000000, 0x83000000, 0xC9800000, 0xB0400000, 0x3EE00000, 0xC8B00000, 0xBB480000, 0xDB740000, 0x8AFE0000, 0xDEB30000, 0x9E4C8000, 0x8FF7C000, 0x3A272000, 0x968BD000, 0x93C3F800, 0xF1AE7400, 0x65CCDA00, 0x04A1A700, 0x99592380, 0x2878D340, 0x9B6F7AA0, 0x2AE9B670, 0xAEA3FB28, 0x465E773C, 0xCBE4DAAE, 0x3425A78D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x98000000, 0x84000000, 0x16000000, 0x99000000, 0x16800000, 0x9E400000, 0x3E600000, 0x9A300000, 0x17480000, 0x00E40000, 0xF8620000, 0xCB350000, 0x8DD78000, 0xE4B84000, 0x5500E000, 0x4C847000, 0x9D4C5800, 0xCBFB6400, 0x81E4BA00, 0xAAEB1700, 0xA362E180, 0x5AB172C0, 0xF01BD9E0, 0x580327D0, 0x64045838, 0x661F6774, 0x0106B982, 0x929E16DD } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x58000000, 0x0C000000, 0x3A000000, 0x5D000000, 0xF3800000, 0x08400000, 0x57E00000, 0x81B00000, 0x75480000, 0x54740000, 0xE1F60000, 0x26A90000, 0xBBCE8000, 0xFFB8C000, 0xE651E000, 0xFCED5000, 0x752EB800, 0x83849400, 0xA0575A00, 0x33EDC700, 0xBFA7E380, 0x46445240, 0xCCE038E0, 0x7D3C5570, 0xD786BB88, 0x96409644, 0x54E958A6, 0x1130C715 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xA8000000, 0xD4000000, 0xD6000000, 0xB3000000, 0xC1800000, 0xE7C00000, 0xDBA00000, 0x0F700000, 0x55580000, 0xDDE40000, 0xA3020000, 0xD9830000, 0xFBC38000, 0x29BE4000, 0xC269A000, 0xF3CCD000, 0x2DBA0800, 0x2C73EC00, 0xCCD1AA00, 0x463C3D00, 0x7AA82380, 0xB3F192C0, 0xDC102B20, 0xD2017C90, 0x5D0203F8, 0xFE83009C, 0x8C4381DE, 0x8D7E4293 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xA8000000, 0xB4000000, 0x66000000, 0x93000000, 0x57800000, 0x4F400000, 0x2D200000, 0x99700000, 0x77D80000, 0xD7E40000, 0xC6120000, 0xC3130000, 0xEF8F8000, 0x23544000, 0x572BA000, 0xD87E1000, 0xD557D800, 0x5C3A2C00, 0xF3EE7A00, 0x38173D00, 0x2C162380, 0x1A0950C0, 0x310BFB20, 0x0A847F10, 0x3FD80138, 0x53E4019C, 0x68120146, 0x941302B1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x38000000, 0x34000000, 0x1E000000, 0xF3000000, 0x86800000, 0xC6C00000, 0xF5A00000, 0x68700000, 0x07580000, 0xEBEC0000, 0x881A0000, 0x6C010000, 0x7A058000, 0xA50B4000, 0x799AA000, 0x6A483000, 0xDE6BC800, 0xE8480C00, 0x2F6B6A00, 0xDFC13D00, 0xFE252280, 0x8B3270C0, 0xFAACE860, 0xBCE77D10, 0x38800298, 0x05C0021C, 0x6B2002E2, 0xEAB00117 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x98000000, 0x84000000, 0x72000000, 0x73000000, 0xDD800000, 0x86400000, 0x4E600000, 0xFF300000, 0x3ED80000, 0x04A40000, 0x61960000, 0x00510000, 0xE76F8000, 0x1DA4C000, 0x0B0B2000, 0x49815000, 0x0C433800, 0xE96E6400, 0xC8BE1A00, 0x4F8E3500, 0xE54AA380, 0x6BE09040, 0xAD699BE0, 0x9ABEF750, 0x0C8F81A8, 0xF0D4C2DC, 0xF1B3233E, 0x15155295 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x18000000, 0x9C000000, 0x32000000, 0x3D000000, 0x5C800000, 0xB3400000, 0x83200000, 0x59700000, 0x90C80000, 0x19F40000, 0xD18E0000, 0xC7C90000, 0x447C8000, 0xFC57C000, 0x42BAE000, 0x46A3B000, 0x28A1B800, 0x47A6AC00, 0xB6355A00, 0x41FC1F00, 0xED806380, 0x05C97140, 0xF169D9E0, 0x24DBDC30, 0x5FF282A8, 0xCA9EC184, 0x1046603A, 0x38B47079 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x38000000, 0x94000000, 0xD6000000, 0x99000000, 0x03800000, 0x43400000, 0xC5A00000, 0x59F00000, 0x2EC80000, 0x4BE40000, 0xA9CA0000, 0x9D790000, 0x9B198000, 0x6C964000, 0x09D2E000, 0x8D67D000, 0x7305D800, 0xF0897C00, 0x73D53A00, 0x5673AF00, 0x3F836180, 0x295593C0, 0xF6BD3B60, 0x8967AE90, 0x8D0161B8, 0x15889334, 0x3A4EB8D6, 0xF638EFA9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x38000000, 0xA4000000, 0xB6000000, 0x29000000, 0x48800000, 0x7A400000, 0x9BA00000, 0x16F00000, 0x00D80000, 0xEEF40000, 0x04CA0000, 0x88E90000, 0x25DF8000, 0x5C6C4000, 0x4D98E000, 0x58D6B000, 0x3AEB9800, 0x6ADB9C00, 0x35E17A00, 0xE3502D00, 0xAB3F6180, 0x28BEF1C0, 0x1D617B60, 0xE9102E50, 0xE89F6038, 0xAA4EF334, 0x93B9787A, 0x8AE42D8D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x38000000, 0x1C000000, 0xD2000000, 0x51000000, 0xC9800000, 0x65C00000, 0x23600000, 0x21B00000, 0xB4580000, 0x8ABC0000, 0x48D60000, 0x48FD0000, 0x1D608000, 0xEAB3C000, 0x38DB6000, 0x40FE9000, 0xA97EC800, 0x1CAC7400, 0xA7CBAA00, 0x0A63E500, 0x543BE080, 0x938D5340, 0xC0C5AA60, 0xBCE2E630, 0x4B6D61A8, 0xE5B39034, 0x4A464AEE, 0xA1A3B693 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xD8000000, 0xDC000000, 0x3A000000, 0x4D000000, 0x60800000, 0xF0C00000, 0x76A00000, 0xE5700000, 0xC0580000, 0xFE740000, 0x3FDE0000, 0x57210000, 0x772C8000, 0x4736C000, 0xEF31E000, 0x7B283000, 0x45384800, 0xEE2FEC00, 0xF9AFAA00, 0x24E2DD00, 0xC21D6180, 0xA11EF340, 0xF289A8E0, 0x29C7DD30, 0x2837E188, 0xBEBD3344, 0xA16ACAEA, 0xC6482CB7 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xC8000000, 0xCC000000, 0xD6000000, 0x3F000000, 0xC9800000, 0xE5400000, 0x65E00000, 0xB9300000, 0x11980000, 0x915C0000, 0x17F20000, 0xAC2F0000, 0xF9188000, 0x4E9F4000, 0x88CF2000, 0xAAA1D000, 0xFDD51800, 0x923B5400, 0x7A02BA00, 0x3905C500, 0xAE988080, 0x18DF41C0, 0x52AF21A0, 0xF9D1D3F0, 0x882D1878, 0x931757CC, 0xCF88BA7E, 0x8246C669 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x38000000, 0xF4000000, 0x26000000, 0x33000000, 0xE4800000, 0x95C00000, 0x42E00000, 0xBBB00000, 0xE0980000, 0x2BD40000, 0x55FA0000, 0x71310000, 0x8A418000, 0x5FAE4000, 0x6E88A000, 0x04D3F000, 0x6B6BA800, 0x3DF6A400, 0xCD228A00, 0x804B1500, 0x8EA18180, 0xA71E41C0, 0xB290A360, 0x7EC7F310, 0x6271A878, 0x3077A71C, 0x657B090A, 0x52F1579B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xB8000000, 0xCC000000, 0xD2000000, 0x99000000, 0x77800000, 0x35C00000, 0xE6E00000, 0x50B00000, 0x5D880000, 0x40C40000, 0xB37E0000, 0x54650000, 0xB8E68000, 0x3BB7C000, 0x431F6000, 0xAA8CD000, 0x1458C800, 0xFC2CA400, 0xFEC12A00, 0xC867B700, 0xF2EE8180, 0x9EB3C340, 0x4E816160, 0x7259D370, 0x9B3649A8, 0xD25F6554, 0xAB204896, 0x9A4E65B3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xD8000000, 0x5C000000, 0x9E000000, 0x31000000, 0xF7800000, 0x0B400000, 0xF1E00000, 0x29300000, 0x61980000, 0xFE440000, 0xA4660000, 0xDD610000, 0x8EE88000, 0x77AC4000, 0xA14BE000, 0xCAEDD000, 0x95B91800, 0x3E4E1400, 0x847A7A00, 0xED7F8500, 0x06F08380, 0xF3A84040, 0x634DE2E0, 0x65FCD030, 0x53299918, 0xC29655B4, 0x7ECF9BA6, 0x35B755E9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x58000000, 0xBC000000, 0x6E000000, 0x85000000, 0xF7800000, 0xF9C00000, 0xB6A00000, 0x9EF00000, 0x40980000, 0x354C0000, 0xF5F20000, 0x720D0000, 0x1B148000, 0x0A9E4000, 0x024B6000, 0x79655000, 0x11464800, 0x47EC2C00, 0x0901AA00, 0x819B3D00, 0xE0DE8280, 0x9F2F43C0, 0xBA35E1E0, 0xBDBA1030, 0x3C6BA8D8, 0x86DA3CE4, 0x2E380066, 0x57BC00F3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xD8000000, 0xCC000000, 0xBA000000, 0x11000000, 0xB1800000, 0xBEC00000, 0xD1600000, 0x98300000, 0xA4980000, 0x11440000, 0xB0B20000, 0x6FD50000, 0x40EA8000, 0xB6F2C000, 0x5DF36000, 0x9D7B1000, 0x62326800, 0xD58BB400, 0x50D38A00, 0xD6766500, 0x72B88380, 0x62D7C2C0, 0x0361E2E0, 0xFD3DD0F0, 0x930B0988, 0xDC91A774, 0x0D41622E, 0x42AE13BF } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x08000000, 0x0C000000, 0x9E000000, 0x77000000, 0xF9800000, 0x04400000, 0x7C600000, 0x83B00000, 0xEA880000, 0xBFDC0000, 0x89220000, 0x45570000, 0x0EF88000, 0xC8664000, 0xD9B32000, 0x2F9CD000, 0x9F443800, 0x0BFFC400, 0xC8E79A00, 0x6B695700, 0xAA3A8280, 0xF6C143C0, 0xF7A3A0A0, 0x909690F0, 0x4ADD1A58, 0xA1A815EC, 0xCB99239E, 0x1D57D2CD } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x78000000, 0xAC000000, 0x5A000000, 0x11000000, 0x53800000, 0xF3400000, 0x63E00000, 0xED300000, 0xCA980000, 0x04CC0000, 0x2EA60000, 0x01DD0000, 0xEB328000, 0x898AC000, 0xA2436000, 0x10635000, 0x0E739800, 0xD16E5400, 0x45FA7A00, 0xBE3BC500, 0x14148280, 0x9617C140, 0x7B11E160, 0x2A9992F0, 0x74C8F888, 0x66B106F4, 0xC5D7E226, 0x65349289 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xD8000000, 0xC4000000, 0xB2000000, 0x1D000000, 0xF1800000, 0xE4400000, 0xFCE00000, 0x34300000, 0xBD180000, 0x818C0000, 0x1C420000, 0x08FD0000, 0x5E338000, 0x6416C000, 0xC219E000, 0xE51F9000, 0x059FB800, 0x8E409400, 0x25F7DA00, 0x77B4C500, 0x44420280, 0x8CFD01C0, 0xCC3383E0, 0x4916C3D0, 0xEB99E1A8, 0xC55F9364, 0x4B7FB90E, 0xA77097E5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x28000000, 0x2C000000, 0x96000000, 0x07000000, 0x14800000, 0xD4C00000, 0x4C600000, 0x23300000, 0xC3180000, 0x8E840000, 0x15CA0000, 0x47E30000, 0xE7708000, 0xE1AF4000, 0x70C62000, 0xE6607000, 0xCA270800, 0xE48D9400, 0xDCDBAA00, 0x3061A500, 0xAD2A0380, 0xC01301C0, 0x20088120, 0x501B4070, 0x181422F8, 0x040770AC, 0xBA1D8A0A, 0x9101D74F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x38000000, 0xE4000000, 0x4E000000, 0x7B000000, 0x80800000, 0x46C00000, 0x3F600000, 0xDA300000, 0x17080000, 0xD29C0000, 0xB7C20000, 0xBAE10000, 0x5F6B8000, 0x0A3D4000, 0x3F0AA000, 0x3E857000, 0x25DDC800, 0x6BF2B400, 0xEAFEEA00, 0xB76B8700, 0xC6220280, 0x9D1103C0, 0xD7838060, 0x74514350, 0x98A0A1D8, 0x68C8727C, 0x947C4B3A, 0x72B2F4F7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xD8000000, 0x5C000000, 0xE2000000, 0xE5000000, 0x5D800000, 0x4AC00000, 0x10A00000, 0xCAF00000, 0xE9080000, 0x17940000, 0x4BDA0000, 0x432D0000, 0x5F208000, 0x1D3FC000, 0x2824E000, 0x1DA51000, 0xD36BE800, 0x7DC9CC00, 0xB0358A00, 0xE1BE1F00, 0xE17A0380, 0xF0DD01C0, 0x69A882E0, 0x156BC3B0, 0xF6DEE0E8, 0x82B812E4, 0x97E36AFE, 0x58920EBF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x48000000, 0xFC000000, 0xCA000000, 0x4D000000, 0xE1800000, 0x2A400000, 0x2A200000, 0xF0F00000, 0x2B180000, 0x6E840000, 0x1AD60000, 0xFBF30000, 0xF5868000, 0xEC4EC000, 0x553CE000, 0x387F9000, 0x9EC87800, 0x15FB8C00, 0xA6841A00, 0xA6C9DD00, 0x51EE0380, 0x68870240, 0x45C880A0, 0x8379C0B0, 0xD84C6208, 0x233252C4, 0xDF6A18AE, 0xE24EDD9D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x18000000, 0xEC000000, 0x5A000000, 0xC3000000, 0x72800000, 0x67C00000, 0x33200000, 0x59700000, 0xCD080000, 0x17840000, 0x445A0000, 0x21650000, 0xD10E8000, 0xB58EC000, 0x5B4F2000, 0x11F03000, 0x99D1A800, 0xAE2F1C00, 0xA6EA0A00, 0x9D44EF00, 0xB0F20180, 0x145103C0, 0xC97C83E0, 0xC51FC370, 0x3393A108, 0xDA5FF0BC, 0x4C6A08A2, 0xD684EE93 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x58000000, 0x4C000000, 0x8E000000, 0x5D000000, 0x15800000, 0xD6400000, 0x2E200000, 0x84F00000, 0x5B080000, 0x0C8C0000, 0xC9D20000, 0x0F6D0000, 0x78528000, 0x83204000, 0x697E6000, 0xF1471000, 0xF4BF7800, 0x5C348C00, 0xCFE19A00, 0xFF8EDF00, 0x715A0080, 0x34A103C0, 0xFC2083E0, 0xFFFD41F0, 0xA784E358, 0x3D5B5044, 0xBABB1A6E, 0xA1229E2D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x98000000, 0x84000000, 0xE6000000, 0x13000000, 0x78800000, 0xAFC00000, 0x1EE00000, 0xCCB00000, 0xDE080000, 0x27040000, 0x768E0000, 0x30C10000, 0x9C638000, 0x127C4000, 0x4D76A000, 0x2FF97000, 0x613CE800, 0x6A432400, 0xE6AFCA00, 0x17031700, 0x5E880180, 0x5CC40140, 0xF66E01E0, 0xFB710050, 0x44EB81F8, 0x0DB8425C, 0xBB98A27A, 0x6F4872F3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x28000000, 0x8C000000, 0x2A000000, 0x9B000000, 0xE7800000, 0xFB400000, 0x86200000, 0x43F00000, 0xAE080000, 0x4D0C0000, 0xDE820000, 0xBBD30000, 0x98F48000, 0x2984C000, 0xA64E2000, 0xC0BB9000, 0x5C259800, 0x90E2AC00, 0xD5953A00, 0x0442FF00, 0x67A80080, 0xB9BC01C0, 0x7CAA0220, 0x9E2F00F0, 0x27FE8008, 0xA81BC05C, 0x4C18A336, 0x8A1C5181 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xC8000000, 0x3C000000, 0xDA000000, 0x53000000, 0x2E800000, 0x11400000, 0x94A00000, 0x7E700000, 0xAC080000, 0x02040000, 0x771A0000, 0x309F0000, 0x6C5E8000, 0x0F3CC000, 0xC8A12000, 0x5467B000, 0xD713F800, 0x2092BC00, 0x745E5A00, 0xCB22CF00, 0xE6A00180, 0xE17003C0, 0x708800A0, 0x4C440030, 0xDF3A0048, 0x30AF01BC, 0xA07683D2, 0x3108C109 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x28000000, 0x54000000, 0xBA000000, 0x85000000, 0x43800000, 0x29C00000, 0x70E00000, 0x81B00000, 0x4C080000, 0xA60C0000, 0xBB1A0000, 0x248B0000, 0x934F8000, 0xF4BDC000, 0xE797E000, 0x7BC0D000, 0x01F94800, 0x08352400, 0xC8D32A00, 0xC17F3700, 0xA9600080, 0x9D7002C0, 0xF7680220, 0x2A7C0090, 0x15F20248, 0xD2370344, 0x9DDD83E6, 0xDAFAC2B3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x18000000, 0xEC000000, 0xF2000000, 0xA1000000, 0x8E800000, 0xCBC00000, 0xDD200000, 0xE7900000, 0x2A080000, 0xED040000, 0xEC8E0000, 0x02C70000, 0xA7A18000, 0x325EC000, 0xA4272000, 0x251E1000, 0x83CEE800, 0xF92FBC00, 0x71925200, 0xFD0FB900, 0xC4880080, 0x16C40040, 0xC9AE00E0, 0x79570070, 0x67A98018, 0x925AC0EC, 0x342920F2, 0x4D1910A1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x18000000, 0xBC000000, 0xCE000000, 0xAB000000, 0xBE800000, 0x98400000, 0x17200000, 0x17500000, 0xE2080000, 0xBD0C0000, 0x89820000, 0xF8C10000, 0x3C618000, 0x02FBC000, 0xA314E000, 0xE32EB000, 0x9D55E800, 0x0B028400, 0x6E8DF200, 0xA0493500, 0xBB280080, 0xC15C00C0, 0xF50A0020, 0xCD8D0010, 0xBAC38018, 0x516AC0BC, 0xB37D60CE, 0xF7D970AB } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xB8000000, 0x84000000, 0xD6000000, 0x83000000, 0xDC800000, 0x6F400000, 0x56200000, 0x80B00000, 0x5A080000, 0xC90C0000, 0x9D860000, 0xAECF0000, 0x5AEB8000, 0x37584000, 0xB6D56000, 0x1A1C3000, 0x3DFFC800, 0x992BF400, 0x763BE200, 0x844ACB00, 0xE6A80080, 0x95FC00C0, 0x952E0060, 0xFC3300F0, 0xA54580B8, 0xD72B4084, 0x2130E0D6, 0xA6C77083 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x38000000, 0xD4000000, 0xCA000000, 0xA7000000, 0xD9800000, 0xC8C00000, 0x9CE00000, 0xEC500000, 0x76080000, 0xF10C0000, 0x38860000, 0x184B0000, 0xD8A38000, 0x12FD4000, 0xDDF4A000, 0x987E7000, 0x16BF9800, 0x83558C00, 0xE3834E00, 0xF7C10500, 0x41680080, 0x669C00C0, 0xA1EE0060, 0xDAD700B0, 0xEB4D8038, 0x0B2A40D4, 0x1D3920CA, 0x289430A7 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x78000000, 0xEC000000, 0x52000000, 0x13000000, 0x43800000, 0xD0C00000, 0x9DE00000, 0x1F900000, 0x5B080000, 0x97840000, 0xCECA0000, 0x6CEB0000, 0x37178000, 0x2446C000, 0x88A12000, 0x5FBB3000, 0x6BF73800, 0x2B568C00, 0xE0E11E00, 0x3511D900, 0x5F4A0080, 0xEF2B0040, 0x497780A0, 0x5B16C0B0, 0x36492078, 0x3BAF30EC, 0xAC353852, 0xC3398C13 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xA8000000, 0xC4000000, 0x2E000000, 0xDB000000, 0x3F800000, 0xF0400000, 0x85200000, 0x18100000, 0xDD080000, 0x60840000, 0x01CE0000, 0x1E6B0000, 0x0ABA8000, 0xF1544000, 0x16AEE000, 0xA257B000, 0xFD2EF800, 0x841A8400, 0x7F089200, 0xE1802100, 0x63460080, 0xCEAF0040, 0x6E5480E0, 0x472F40B0, 0x691C60A8, 0xF787F0C4, 0xC44E182E, 0xE32634DB } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x38000000, 0xBC000000, 0xEA000000, 0xD9000000, 0x16800000, 0xB6C00000, 0xCCE00000, 0x2DD00000, 0x3F080000, 0x7D8C0000, 0x954A0000, 0x4EAF0000, 0x0AF38000, 0x9EB3C000, 0xEA9AA000, 0xD4A39000, 0x2BF86800, 0x9435EC00, 0x465F8E00, 0xF94A3D00, 0xACA20080, 0xF7F300C0, 0x2E3180A0, 0x5750C0F0, 0x6BC32038, 0x4C6F50BC, 0x081948EA, 0xCC69BCD9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xD8000000, 0xE4000000, 0xB6000000, 0x57000000, 0x28800000, 0x08C00000, 0x9EA00000, 0x3EF00000, 0x08880000, 0x18C40000, 0x16AE0000, 0xB2FB0000, 0x82858000, 0x1DCA4000, 0xDF256000, 0xC5BE7000, 0x3C670800, 0xB55ACC00, 0x77F48A00, 0xEB019F00, 0x3A858080, 0x09CA4040, 0x512560E0, 0xC6BE70B0, 0x7AE708D8, 0x0E9ACCE4, 0x77D48AB6, 0x8A319F57 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x78000000, 0x94000000, 0x6A000000, 0xDB000000, 0x60800000, 0xEA400000, 0xED600000, 0xE9500000, 0x08880000, 0x96440000, 0xBB660000, 0x045B0000, 0x350F8000, 0x398D4000, 0x6DC0A000, 0x51A6B000, 0xB3718800, 0x493FE400, 0x4C547600, 0x99092500, 0xA78F8080, 0x6CCD4040, 0x9220A060, 0xADB6B0B0, 0x24198878, 0x936BE494, 0x185A766A, 0xD30625DB } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x68000000, 0x2C000000, 0x36000000, 0x13000000, 0x63800000, 0x62400000, 0x78A00000, 0x89300000, 0x0F880000, 0x344C0000, 0xFBAA0000, 0xB2B30000, 0x29CE8000, 0x56EEC000, 0x57996000, 0xCDBA3000, 0x1C44B800, 0xB7A2E400, 0x14BDEA00, 0x62C42300, 0x716E8080, 0x2FDEC0C0, 0x901160A0, 0xE5F63030, 0xB9EEB868, 0x3A11E42C, 0x68F36A36, 0x456AE313 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x28000000, 0x04000000, 0x4A000000, 0xAD000000, 0xCE800000, 0xFFC00000, 0x45200000, 0x19900000, 0x92880000, 0x79CC0000, 0xB6220000, 0x28130000, 0x22CA8000, 0x43AC4000, 0xF256A000, 0x85A1D000, 0xE1526800, 0xA425BC00, 0x491FF200, 0xB243C900, 0x436A8080, 0xF8FC40C0, 0xE37EA020, 0x2E3DD030, 0xE2D86828, 0x456ABC04, 0xCBFF724A, 0xF2F089AD } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x78000000, 0x74000000, 0xF6000000, 0x5F000000, 0x7F800000, 0x5D400000, 0xE0E00000, 0xF0100000, 0x99880000, 0xEA4C0000, 0xC3620000, 0x27570000, 0xDC6F8000, 0xB8DB4000, 0xD1256000, 0x503EF000, 0x2D3A7800, 0x4BB19400, 0x6E70EE00, 0xA85CB100, 0x6BE78080, 0xC99740C0, 0xC3C76020, 0x7129F070, 0xE035F878, 0x753AD474, 0x4FBD8EF6, 0xE07E415F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0xA8000000, 0xE4000000, 0x66000000, 0x11000000, 0xFF800000, 0x30C00000, 0x90A00000, 0x72700000, 0xD1880000, 0x75CC0000, 0xD12A0000, 0xCFBD0000, 0x94A28000, 0xA4724000, 0x18846000, 0x16401000, 0xCBEF7800, 0xCC104C00, 0x6E5DEA00, 0xABBC7700, 0x32AA8080, 0x157E40C0, 0x370E60A0, 0x8E8D10D0, 0xBF45F8A8, 0xD86E0CE4, 0xAED38A66, 0x21F16711 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xE8000000, 0x4C000000, 0x0E000000, 0x49000000, 0x93800000, 0x81C00000, 0x49600000, 0xDC300000, 0x51880000, 0x86C40000, 0xB3E20000, 0x3E7F0000, 0x71268000, 0x5F90C000, 0x305AE000, 0xA0379000, 0xD789B800, 0x53C5DC00, 0x3667F600, 0x52BC1300, 0xE9CE8080, 0x4564C040, 0xF230E020, 0xE88C90F0, 0xFD4D38E8, 0x7E2A1C4C, 0x791B960E, 0xE41B4349 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x68000000, 0x8C000000, 0xE6000000, 0xBF000000, 0x3D800000, 0x85C00000, 0x59A00000, 0x67D00000, 0x47880000, 0x54C40000, 0x272A0000, 0x819D0000, 0xC0EE8000, 0x3D3CC000, 0xDBBC6000, 0x49FAF000, 0x6C935800, 0x006B9C00, 0xF07E7A00, 0xB35CCD00, 0x18C68080, 0x2128C040, 0x4E9E60A0, 0x4563F0D0, 0x5CF7D868, 0xE81A5C8C, 0x77249AE6, 0xA99EFDBF } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xB8000000, 0x54000000, 0x5E000000, 0xFB000000, 0xBD800000, 0xE6400000, 0x8BE00000, 0x12900000, 0xA6880000, 0xCBCC0000, 0xB5A60000, 0x9D750000, 0x52138000, 0xC2414000, 0x9DEFE000, 0x359CB000, 0xF90D5800, 0x648CA400, 0x72CE1E00, 0x712E7900, 0xDFB58080, 0xCB3440C0, 0xF1FC6060, 0x5CDDF050, 0x6162B8B8, 0xE3501454, 0x5E23465E, 0xFC32DDFB } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xE8000000, 0xD4000000, 0xF2000000, 0xC9000000, 0x43800000, 0x30400000, 0x41600000, 0xB7F00000, 0xF6880000, 0xF5CC0000, 0xBA260000, 0x04190000, 0x0EB68000, 0x54694000, 0x82752000, 0x75CB9000, 0x7A2FB800, 0x6416C400, 0x9EB77600, 0xBC624F00, 0x56708080, 0x87C040C0, 0xB32BA060, 0x279ED090, 0xAEF498E8, 0xFD0854D4, 0xE1884EF2, 0x7144CBC9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xE8000000, 0xB4000000, 0xFA000000, 0x09000000, 0x31800000, 0xD8C00000, 0x35200000, 0x25900000, 0xDA880000, 0xFC440000, 0xB2620000, 0x4B770000, 0x1AB68000, 0x5E174000, 0x8341A000, 0x1CE19000, 0x2D389800, 0xF1D74C00, 0xBCE53200, 0x1D302900, 0x39DC8080, 0x78E44040, 0x0F352020, 0x84D1D070, 0xB367B8E8, 0xDEF59CB4, 0x80760AFA, 0x4E35F509 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x68000000, 0x3C000000, 0x86000000, 0xB5000000, 0x36800000, 0x49400000, 0xA3200000, 0xC0700000, 0x9D880000, 0xEECC0000, 0xBEE20000, 0xDD190000, 0xAF5E8000, 0xC3F7C000, 0x224E6000, 0x24AC5000, 0x4DBEE800, 0xE8E0D400, 0xE01B1200, 0x15D6F700, 0xF4B48080, 0x6062C0C0, 0x6852E020, 0xAA729090, 0x26860868, 0xE147443C, 0xBF219A86, 0xD67F73B5 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x28000000, 0x8C000000, 0x1E000000, 0xD1000000, 0x98800000, 0x15C00000, 0x5FE00000, 0xAEB00000, 0x65C80000, 0x27EC0000, 0x6AB60000, 0x67C10000, 0xC0EE8000, 0xAF3EC000, 0xF480E000, 0x5BC39000, 0xC6E74800, 0x2A39BC00, 0x46026E00, 0x2507A300, 0x4280E080, 0xC6C390C0, 0x20674860, 0x7EF9BC90, 0xA9626E28, 0x1277A38C, 0x66A8E09E, 0x9E9F9011 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xD8000000, 0xE4000000, 0xE2000000, 0x7B000000, 0x59800000, 0xA0C00000, 0x12A00000, 0x20B00000, 0xBCC80000, 0x04AC0000, 0xB1B60000, 0x12430000, 0x23E18000, 0x7ED84000, 0xE0DD2000, 0x3DDE3000, 0x2D59D800, 0xC71D2C00, 0x10F21A00, 0x842D5300, 0x93FD2080, 0x29AE30C0, 0xD931D860, 0xCC012CB0, 0x7E0C1AD8, 0xAD0253E4, 0xA88AA062, 0xBE4570BB } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x58000000, 0x44000000, 0x86000000, 0xDF000000, 0x1F800000, 0xA4400000, 0x29E00000, 0xCED00000, 0xA8480000, 0x03E40000, 0xEBD60000, 0x5AC70000, 0xB9218000, 0xE2F24000, 0x803F6000, 0x8D147000, 0xB1EFB800, 0xAADF2400, 0xBE4BEE00, 0x74E7D500, 0xE85F6080, 0x3C847040, 0xC9C7B860, 0xECAB24F0, 0x93B5EE58, 0x0354D544, 0xBD00E006, 0x9685309F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xC8000000, 0x74000000, 0xDA000000, 0x9F000000, 0x13800000, 0x80400000, 0x47600000, 0x6E100000, 0xCE480000, 0xF2640000, 0x9A920000, 0x71810000, 0x53488000, 0x82E54000, 0x8754A000, 0x63AD7000, 0x3EB27800, 0xC57FA400, 0xA6588600, 0xBD255900, 0x667CA080, 0x5BD97040, 0x58687820, 0x3D9AA490, 0x6E0206C8, 0x25011974, 0x3C80805A, 0xCBC140DF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x28000000, 0xFC000000, 0x96000000, 0x13000000, 0xE3800000, 0x96400000, 0x0F600000, 0x2B300000, 0x14480000, 0x56640000, 0x3DB60000, 0x4A890000, 0xF8C68000, 0xE5A9C000, 0xFF986000, 0x615BB000, 0xEFFDF800, 0x47EA0400, 0xCAF2C600, 0x87610B00, 0xE7306080, 0xDA4FB040, 0x8163F860, 0x9C370410, 0xA5CA4628, 0x9125CBFC, 0xA8588016, 0x9174C053 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xA8000000, 0x14000000, 0x5A000000, 0xA9000000, 0xBC800000, 0x80400000, 0xF3E00000, 0xA0500000, 0xB6480000, 0xECE40000, 0x43D20000, 0xF58B0000, 0x6CCE8000, 0xCBA34000, 0xDFB6A000, 0xF0181000, 0xBDA68800, 0xE0BBA400, 0x239CAE00, 0x56644D00, 0x749EA080, 0xF1EC1040, 0xD55C8820, 0x54C4A430, 0x07A82EA8, 0x19B80D14, 0x271C80DA, 0x5A2840E9 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x18000000, 0x84000000, 0xEE000000, 0x45000000, 0x7E800000, 0xE2C00000, 0x64A00000, 0x5A900000, 0x0BC80000, 0x28240000, 0xF7560000, 0x0AE30000, 0xB3F58000, 0x80764000, 0x1039E000, 0x345FD000, 0x8D6EA800, 0x95B84C00, 0x051EDA00, 0x89826100, 0x934FE080, 0x83ECD040, 0x4F732860, 0x35BA0CB0, 0x95193A18, 0x418AB184, 0xBF4AC86E, 0xF1E5DC05 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xF8000000, 0x3C000000, 0x22000000, 0x07000000, 0xF9800000, 0x0F400000, 0x55E00000, 0x74B00000, 0xAA480000, 0xEB640000, 0x227A0000, 0x20E50000, 0x323B8000, 0xC081C000, 0x43CB2000, 0xFC25F000, 0x3B915800, 0x5E555400, 0x5B7AEE00, 0xCC6CF300, 0x4BF92080, 0x77A4F040, 0x8BD0D8A0, 0x6E3194D0, 0xD28A4EF8, 0xCCC8C33C, 0x11A358A2, 0xD2D45447 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x88000000, 0x84000000, 0x92000000, 0x4D000000, 0x95800000, 0x3CC00000, 0x50200000, 0x92900000, 0x13C80000, 0x20AC0000, 0xEFDE0000, 0xD5230000, 0xA3148000, 0xED0E4000, 0x058E2000, 0xE4C25000, 0xEC2A1800, 0x0C926C00, 0x48C19200, 0x6A255100, 0x0B982080, 0x2C4D50C0, 0x5D6098E0, 0x3C7F2CB0, 0xA47B3288, 0x38794184, 0xF6741812, 0x95716C8D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x48000000, 0x8C000000, 0x3E000000, 0xEB000000, 0xB3800000, 0xA1C00000, 0x2F600000, 0x48900000, 0x82480000, 0xD6A40000, 0xF3FE0000, 0x80D30000, 0x45E88000, 0xCFD2C000, 0xB46EE000, 0x13153000, 0xFF817800, 0x3FCE3C00, 0x94652600, 0x0312C100, 0xE7866080, 0x4BC7F040, 0x6E6F98E0, 0x5A1B0CB0, 0x81045E48, 0xB28CFD8C, 0x534B46BE, 0x9C2131AB } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xF8000000, 0x64000000, 0x0A000000, 0x43000000, 0x10800000, 0x0B400000, 0x36A00000, 0xFE300000, 0xF3C80000, 0x91EC0000, 0x3E960000, 0xD0F70000, 0xC3AB8000, 0x93BC4000, 0xC901A000, 0x9388B000, 0x7BCEC800, 0xCDE95400, 0x30987A00, 0x69F49B00, 0x682A2080, 0xEC74F0C0, 0xFEEF6860, 0x1811E4F0, 0x66BEB2F8, 0xA481CF64, 0xA94C5A8A, 0x79AB6B83 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x38000000, 0x44000000, 0x4A000000, 0x57000000, 0xA6800000, 0x3F400000, 0xBDA00000, 0xB6900000, 0x5DC80000, 0x88E40000, 0x3C360000, 0xFDD30000, 0xD26F8000, 0x4D764000, 0x3D71A000, 0x2571F000, 0xB177A800, 0x73721400, 0x58788A00, 0xF0F2B100, 0xD2BE2080, 0x9E97B040, 0xB1CE0860, 0x6EE7E4B0, 0xED392238, 0x3A53A544, 0x12A92ACA, 0x74134117 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x38000000, 0x3C000000, 0xD6000000, 0xBD000000, 0x4C800000, 0xC0400000, 0xBE200000, 0xD6300000, 0xF8C80000, 0xEC640000, 0xDF1E0000, 0xF9770000, 0x1D6F8000, 0x3D99C000, 0x58346000, 0xC9CB5000, 0xAEEE8800, 0x6E53A400, 0xE5D9D200, 0x8A1E3B00, 0xE1FBE080, 0x1F229040, 0x1CB2E8E0, 0xAD8CF4F0, 0xEAC15A38, 0x1B6E9F3C, 0xE89BB256, 0x00B66BFD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x28000000, 0xF4000000, 0xE2000000, 0x25000000, 0x92800000, 0x62400000, 0x0E200000, 0x02B00000, 0x1CC80000, 0xE26C0000, 0x679A0000, 0x47F50000, 0x15668000, 0x48194000, 0x1B312000, 0x9709D000, 0x5F82E800, 0xA4C04400, 0x5E631200, 0x01969300, 0x78F7A080, 0x7EE090C0, 0xAEDBC8A0, 0xB05594D0, 0x2C13FA28, 0xB13FD7F4, 0x36003262, 0xD70643E5 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xE8000000, 0xAC000000, 0xD6000000, 0x1F000000, 0x53800000, 0x24C00000, 0x25A00000, 0x3FD00000, 0xF1480000, 0x46640000, 0x2DF20000, 0x60570000, 0xB3828000, 0xB4CCC000, 0x1DA06000, 0x8BD07000, 0x63497800, 0x2361EC00, 0xB77CCA00, 0x08103500, 0xE16AE080, 0x8A78B040, 0xF69B1820, 0x03269CF0, 0xF99732E8, 0x28AD19AC, 0x495E4A56, 0x6F0CF55F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x18000000, 0x04000000, 0x46000000, 0x5D000000, 0x61800000, 0x2D400000, 0xFD600000, 0x5D300000, 0x96C80000, 0x8F240000, 0xFAD20000, 0x0A350000, 0xB04D8000, 0xFCE64000, 0x807B6000, 0xA3A15000, 0xCE13D800, 0x2E1CF400, 0x9E1F6600, 0x76199B00, 0xBA1EE080, 0xE0131040, 0xFF12B820, 0x859CA4D0, 0x945B3E18, 0x25F22F04, 0xA8E566C6, 0x9E789B1D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x68000000, 0x84000000, 0x9A000000, 0xC7000000, 0x4C800000, 0x37400000, 0xD4600000, 0xE5700000, 0x64C80000, 0x83AC0000, 0x78560000, 0x38DB0000, 0xE1928000, 0x60FA4000, 0xBA08A000, 0x5703F000, 0x748F0800, 0xEB471400, 0xA2665600, 0x3C770F00, 0x754C2080, 0x3F62B0C0, 0xD7F52860, 0x3E8EA430, 0xB449FE68, 0x62EFEB84, 0x253B7E1A, 0x9425AB07 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x38000000, 0xC4000000, 0xF6000000, 0x9B000000, 0xF7800000, 0xAA400000, 0x66600000, 0x32900000, 0x42C80000, 0xADAC0000, 0x15BA0000, 0x09B50000, 0x8BB78000, 0xAEB24000, 0xEE3C6000, 0xB9F93000, 0xDCD3B800, 0x12A90400, 0xA4347600, 0x70FA4100, 0x3651E080, 0x3C6E70C0, 0x639058A0, 0xBC4E74D0, 0x4D61AE38, 0x8D1F75C4, 0xC481AE76, 0xC1CF755B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xD8000000, 0xF4000000, 0xEA000000, 0xBD000000, 0x5B800000, 0xDDC00000, 0x4D200000, 0xFD500000, 0xBF480000, 0x396C0000, 0x84BA0000, 0x4EB70000, 0xC3B98000, 0xE0314000, 0x39FFA000, 0x46D75000, 0xF2867800, 0xFC48BC00, 0xA5E66200, 0x37F2DD00, 0x59DC2080, 0x680110C0, 0x4C0858A0, 0x4E02ACF0, 0x7F05BAD8, 0xCA8A31F4, 0x984DBA6A, 0xC7E6317D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xF8000000, 0xEC000000, 0xFA000000, 0xEB000000, 0xC2800000, 0x5C400000, 0x37E00000, 0x40F00000, 0xD7E80000, 0x50F40000, 0x7FEA0000, 0x34F30000, 0x91E58000, 0xC9FDC000, 0x426A2000, 0xBC337000, 0xEB460800, 0x9766B400, 0x4BBD7600, 0x508EBB00, 0xB3460880, 0x4B66B440, 0x69BD7620, 0x278EBB70, 0x73C60878, 0x1026B4AC, 0x66DD76DA, 0xD03EBB9B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x28000000, 0x9C000000, 0xE6000000, 0x59000000, 0x7C800000, 0x5E400000, 0x35E00000, 0xEA300000, 0x01E80000, 0x503C0000, 0x1EE20000, 0x65BD0000, 0x14208000, 0x9214C000, 0x2DFEE000, 0x20C95000, 0x00AD2800, 0x3052B400, 0x4E117600, 0xABF19700, 0xC9CD2880, 0x4422B4C0, 0xDA1976A0, 0x01FD9710, 0xFEC728A8, 0xEDA3B45C, 0x36DBF646, 0xAF545749 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x38000000, 0xBC000000, 0x76000000, 0x9D000000, 0x26800000, 0x6F400000, 0x57600000, 0xD6F00000, 0x33680000, 0x2CF40000, 0x906A0000, 0x43710000, 0x2BA98000, 0x2C5AC000, 0x67BEE000, 0x1D0B1000, 0x66808800, 0x4F43E400, 0x0766FE00, 0xEEFA0B00, 0x8F608880, 0x5AF3E440, 0x0D6EFE20, 0x65FE0B50, 0x44E288B8, 0x7B36E4FC, 0xB14D7E56, 0x2E65CBCD } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0x54000000, 0x26000000, 0x4B000000, 0x05800000, 0x95C00000, 0xC4E00000, 0x2DF00000, 0x12E80000, 0x4EF40000, 0x2B6E0000, 0xA1310000, 0x8E8B8000, 0xB0444000, 0x6121E000, 0xE114F000, 0x331FB800, 0x2E14AC00, 0x08947600, 0xC4D03300, 0xBFF7B880, 0x6FE0AC40, 0x387A7660, 0xBF213350, 0x8E1C38D8, 0x7894EC14, 0xACD39646, 0xE3F1C31B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x98000000, 0x34000000, 0x52000000, 0x45000000, 0x63800000, 0x23C00000, 0xDC200000, 0xC8F00000, 0x06280000, 0xD1FC0000, 0x3BA20000, 0xE13F0000, 0x0B0B8000, 0x188C4000, 0xC346A000, 0xBB641000, 0x899A9800, 0x66BD2C00, 0xB2CADA00, 0xBDACE300, 0xA6329880, 0x25812CC0, 0xC4C8DAA0, 0xC2A3E330, 0x8CB11818, 0x33C16CF4, 0xB4247AF2, 0xC4F4F375 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x98000000, 0xAC000000, 0x32000000, 0x29000000, 0x14800000, 0x02C00000, 0xCDE00000, 0xADF00000, 0xB3E80000, 0xA6FC0000, 0xC6620000, 0xF4BB0000, 0x0F4B8000, 0x23A1C000, 0x1ED0A000, 0x09F75000, 0xA5EFE800, 0x59FE7C00, 0x8DEBB600, 0xCDFAE300, 0x63E7E880, 0x4EF27CC0, 0xF261B6A0, 0x6ABDE370, 0x144E6818, 0x1E28BC6C, 0x089A9692, 0xC6DB7359 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x98000000, 0xB4000000, 0xDE000000, 0x61000000, 0xCA800000, 0x63C00000, 0x39200000, 0xC9300000, 0x6B280000, 0x923C0000, 0xA6AA0000, 0x7E750000, 0x70C38000, 0x38AE4000, 0xFF766000, 0x0A4C5000, 0x5364C800, 0xEA596C00, 0xA973DA00, 0x87413F00, 0xD3ECC880, 0xA6956CC0, 0xA3D1DA20, 0x53383F90, 0x3C2D4818, 0xA5B22C74, 0x6DEE3AFE, 0xB79F2FF1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xB8000000, 0x3C000000, 0x82000000, 0x79000000, 0x1D800000, 0xF6400000, 0x67A00000, 0x8D300000, 0x82A80000, 0x22B40000, 0xC5EE0000, 0xCC950000, 0xB8958000, 0xEE9EC000, 0xF199A000, 0x3B1F5000, 0x93D97800, 0x5ABBB400, 0xD9ECC200, 0x3E934700, 0x69977880, 0x771EB440, 0xB9D14260, 0xA7B98710, 0x7A60D838, 0x33D4E47C, 0x6ABDBAE2, 0x11ECF369 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x88000000, 0x34000000, 0xD6000000, 0xE5000000, 0x25800000, 0x89C00000, 0xA2600000, 0x93B00000, 0xE3680000, 0xD8340000, 0x53AE0000, 0xCDD30000, 0xF2D68000, 0x78584000, 0xC31FE000, 0x06301000, 0xC2AAB800, 0x5E580C00, 0xEE17DE00, 0x77B25700, 0xED64B880, 0x913B0C40, 0x6C295E60, 0xCB1E1770, 0x72355808, 0x74A81C74, 0xCB5D66B6, 0x439A5B95 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xA8000000, 0xE4000000, 0x2E000000, 0xC7000000, 0xFE800000, 0x22C00000, 0xFAE00000, 0xF2300000, 0x7BE80000, 0xCFB40000, 0x79A20000, 0x28910000, 0xC3F88000, 0x49874000, 0x64466000, 0x342D3000, 0x92D28800, 0xC8D29C00, 0x69D0E600, 0x44559F00, 0x4E188880, 0x1D379C40, 0x216A66A0, 0x6373DF50, 0x144E6828, 0x8C29ECA4, 0x7EDC8E8E, 0x52DD7397 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x98000000, 0xD4000000, 0x1E000000, 0xE5000000, 0x6B800000, 0xB9400000, 0x56E00000, 0x33700000, 0xED680000, 0x423C0000, 0x678A0000, 0x93470000, 0x3DEB8000, 0x95F64000, 0x73A06000, 0x679F1000, 0xF91D5800, 0xC3DAC400, 0x407C5600, 0x5FE8E300, 0xE2F6D880, 0x172C84C0, 0xFE5C3620, 0x0037F3B0, 0xA08B8018, 0x6FC64014, 0x7028603E, 0x72D31055 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xE8000000, 0x0C000000, 0x22000000, 0xA3000000, 0xD0800000, 0x8BC00000, 0x44A00000, 0x13F00000, 0x0C280000, 0xAC3C0000, 0x6E860000, 0x22CD0000, 0xDB208000, 0x7AB1C000, 0x8844A000, 0x27E6F000, 0xD8912800, 0x657B8C00, 0xDAE3C200, 0xB11B4300, 0x9931A880, 0xFB0A4CC0, 0x048762E0, 0xBDCDB310, 0x31A88068, 0xA67DC0CC, 0xDA6AA0C2, 0x32D7F0B3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x88000000, 0x24000000, 0x5E000000, 0x85000000, 0xB6800000, 0x01C00000, 0xF2200000, 0x42F00000, 0x6AA80000, 0x5E3C0000, 0xA20A0000, 0xB7010000, 0x698A8000, 0xBC4F4000, 0x486D6000, 0x239A1000, 0x85B68800, 0x014C4C00, 0x62EA4A00, 0x205B3300, 0xD0940880, 0x823F0CC0, 0x400D2A20, 0xE00023D0, 0xF0080008, 0x580C00E4, 0xAC02007E, 0x7A0D0055 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x98000000, 0x94000000, 0x6E000000, 0xA3000000, 0x96800000, 0x3E400000, 0x56200000, 0x91700000, 0xBBA80000, 0xCDBC0000, 0x6DC20000, 0x41EB0000, 0xDD938000, 0xF3B64000, 0xE6CB6000, 0x7B657000, 0x69D28800, 0xF09F5400, 0xD638CA00, 0x060B5300, 0x6F030880, 0xCC8214C0, 0x83402AA0, 0xFBA86370, 0xADB2E018, 0xBDC43054, 0xA9E868CE, 0xD19764D3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x58000000, 0x5C000000, 0x7A000000, 0xCD000000, 0x80800000, 0x5E400000, 0x4CE00000, 0x5B100000, 0x5B680000, 0x58DC0000, 0x31420000, 0x9D610000, 0x5FDF8000, 0x54C0C000, 0x97AE2000, 0x33731000, 0xA83AA800, 0xA058B400, 0x23070600, 0x538CF500, 0x45CF2880, 0xAD2574C0, 0x0034A6A0, 0xB45E25D0, 0xFD0420D8, 0x688E109C, 0x2A4728DA, 0xE2E9741D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xB8000000, 0x94000000, 0x1A000000, 0x4B000000, 0xA5800000, 0x7BC00000, 0x48600000, 0xD2700000, 0xE4E80000, 0xA33C0000, 0x60C20000, 0x35ED0000, 0x8DB18000, 0x1E804000, 0x16462000, 0xAFA7F000, 0xBC1AF800, 0x4B908C00, 0x27539E00, 0x4CB53B00, 0x88017880, 0xFC01CCC0, 0x96063EA0, 0xD50F8B10, 0x4C842038, 0x014AF054, 0x8C2B78BA, 0xAAD0CC5B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x08000000, 0x5C000000, 0x62000000, 0x81000000, 0xED800000, 0x87C00000, 0x6E600000, 0x9E300000, 0x58E80000, 0xF1740000, 0x4ACA0000, 0xA9ED0000, 0xE4F28000, 0x2904C000, 0x6182A000, 0xCDCFD000, 0x2361F800, 0x19B0EC00, 0x0225FE00, 0x1093BF00, 0xD2317880, 0x72ED2C40, 0x0C7FDE20, 0x5545AF90, 0xA728A088, 0x3B12D01C, 0x52FB7842, 0xD6002C11 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xB8000000, 0xEC000000, 0x66000000, 0x23000000, 0xAB800000, 0xADC00000, 0x1B600000, 0x17100000, 0x09E80000, 0x0C5C0000, 0xABCA0000, 0x88690000, 0x74998000, 0xA023C000, 0x2531E000, 0x15D6F000, 0x6F0DD800, 0x5D8D6C00, 0x16C2CE00, 0x0CE34D00, 0x64D65880, 0xDD8BACC0, 0xD6C8AE20, 0x2CE37D50, 0x34D9E038, 0x658AF02C, 0x3AC7D846, 0x4AE46C73 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xD8000000, 0x44000000, 0x7E000000, 0x61000000, 0x23800000, 0x7EC00000, 0xF1200000, 0x26500000, 0x1FE80000, 0xCF7C0000, 0x1DBE0000, 0xBE950000, 0x6BCF8000, 0xC4AF4000, 0xD59D6000, 0x3F46D000, 0x14E01800, 0x8BF45C00, 0x15F5DA00, 0xA4F82100, 0x3F7D7880, 0x15B28CC0, 0x4295C260, 0x41CC7D10, 0x03A8A258, 0xD31AAD84, 0x1C00BA9E, 0xFA02F1B1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0xA8000000, 0x7C000000, 0x16000000, 0x6D000000, 0x7B800000, 0x66400000, 0xE3200000, 0x87D00000, 0xF3680000, 0xF9F40000, 0x17320000, 0xA8DD0000, 0xCFEC8000, 0x3F38C000, 0x94D8E000, 0x79E69000, 0x42359800, 0x47551400, 0x63A9BA00, 0xB71C3100, 0xAD857880, 0xEB478440, 0x28AE22A0, 0x59942510, 0xC4404228, 0x1423753C, 0x9F53BA36, 0x47A5313D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xB8000000, 0x24000000, 0x0E000000, 0xD1000000, 0x96800000, 0x05C00000, 0x12600000, 0x69B00000, 0x41A80000, 0x3ED40000, 0x689E0000, 0x7FB30000, 0x64A18000, 0x8E5F4000, 0xD05A6000, 0x6957D000, 0xF3DA4800, 0x941AEC00, 0xC57B3E00, 0xC14E7F00, 0xCCA82880, 0xA2593C40, 0x225F7660, 0x625793F0, 0x025A9638, 0xF25C0364, 0x4A533EEE, 0x6E5A7F61 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x28000000, 0x4C000000, 0x4A000000, 0xE5000000, 0x7C800000, 0x45400000, 0x8B600000, 0x90500000, 0x7C280000, 0xDA340000, 0x76F60000, 0x1C590000, 0x96208000, 0x8F3BC000, 0x72752000, 0x3D111000, 0x1B472800, 0xB0656400, 0x97DC0E00, 0xDEEF8900, 0xA39A0880, 0xB7007440, 0xED8D26E0, 0xF7C3ED50, 0x7D2E86A8, 0xE0B03D0C, 0x7CBC0E2A, 0x5EBF89F5 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x28000000, 0xFC000000, 0x0A000000, 0xF9000000, 0x8E800000, 0x6BC00000, 0x2AE00000, 0x9A300000, 0xE4280000, 0x24540000, 0xE4DA0000, 0xC8190000, 0x137C8000, 0xE704C000, 0xE1812000, 0x6645D000, 0x4EA00800, 0x8194CC00, 0xC932B600, 0x83A4C700, 0xC91B2880, 0x09F81C40, 0x5AC63E20, 0x6860CB50, 0xA3F2BEA8, 0xB3C00BBC, 0xEEE19EAA, 0x6438DBE9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x38000000, 0xB4000000, 0x46000000, 0x4B000000, 0xFC800000, 0x86400000, 0x03A00000, 0xB6700000, 0x52E80000, 0x73540000, 0xC3DA0000, 0xD7970000, 0x493D8000, 0xC0CE4000, 0x64EAE000, 0x60557000, 0x1B506800, 0x9FDC7400, 0x8D9A6200, 0x78391B00, 0xBD408880, 0xA72E0440, 0x143F8A20, 0x9F4F2FB0, 0x02220AB8, 0x9FB16FF4, 0x2F80EAE6, 0x3EC01FBB } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x58000000, 0x9C000000, 0x1E000000, 0x3F000000, 0x83800000, 0x02400000, 0x18E00000, 0x1BD00000, 0xE1280000, 0xAD7C0000, 0x04120000, 0x048B0000, 0x8DC38000, 0x0CACC000, 0x083B6000, 0xA377B000, 0xF3141800, 0x130C3400, 0xA5834600, 0xF1492100, 0x2D6CF880, 0xE29744C0, 0xF84C3EA0, 0x95E2A5F0, 0x4153A6D8, 0x33EE515C, 0x7251803E, 0xA667C00F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xD8000000, 0xFC000000, 0x6A000000, 0xAB000000, 0x71800000, 0x0FC00000, 0x83200000, 0x33B00000, 0x95680000, 0x5B5C0000, 0xD3FE0000, 0x0C870000, 0x1F478000, 0x066AC000, 0x26D82000, 0x0E30F000, 0xE8AA7800, 0xEF76EC00, 0xCBC89A00, 0xE5265F00, 0x4AB5D880, 0x83ECDCC0, 0x971AC260, 0x08104330, 0xA79F3A58, 0x1D506F3C, 0x3AF1808A, 0x9201C05B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x38000000, 0x2C000000, 0xE6000000, 0xB7000000, 0x59800000, 0xEA400000, 0xDF200000, 0x17D00000, 0x4AE80000, 0xB5B40000, 0x6B9E0000, 0xEAC10000, 0x5FE18000, 0xE939C000, 0xC558E000, 0x07263000, 0xABDB3800, 0xF4E8B400, 0xFEB99A00, 0xEC150100, 0x9B8A5880, 0x3F434440, 0xA3A44260, 0x091A85D0, 0x4F097AB8, 0x5587316C, 0xBC4F6006, 0x802AF027 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x68000000, 0x3C000000, 0xD6000000, 0x51000000, 0x1A800000, 0x49C00000, 0xDF200000, 0xEAD00000, 0xFA680000, 0x5D3C0000, 0x9D1A0000, 0x884F0000, 0x5B688000, 0xCFBAC000, 0x78D8E000, 0x59645000, 0xB4B10800, 0xC55DEC00, 0xEB20CA00, 0x50D0D900, 0x85696880, 0xF2BF7CC0, 0x4C532220, 0xA5A665B0, 0xF3102AE8, 0xDD4889FC, 0x53E26076, 0xE57D9021 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x58000000, 0x14000000, 0xDA000000, 0xF3000000, 0x01800000, 0x7E400000, 0x28600000, 0x55D00000, 0x21A80000, 0x2EFC0000, 0x4C9E0000, 0x12490000, 0x966F8000, 0x94DA4000, 0x4F2D2000, 0xC737F000, 0x27B2F800, 0x477C7400, 0x6EDA2E00, 0xCC2CE100, 0x2EB85880, 0xC5FDC4C0, 0xF913F660, 0x060265D0, 0xC5090ED8, 0x8C8211D4, 0xDECD203A, 0xE8A7F0E3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xA8000000, 0xCC000000, 0x22000000, 0xB1000000, 0xBE800000, 0xEA400000, 0x9DE00000, 0xF3100000, 0x48280000, 0x523C0000, 0x609E0000, 0xE6EF0000, 0x90908000, 0xEEE9C000, 0x8C9FA000, 0xD4E35000, 0x59920800, 0x84631400, 0x20D2E600, 0x160CDD00, 0x87032880, 0x298684C0, 0xBBCFCE60, 0xF22559B0, 0x473C6628, 0x501A1D0C, 0x2FA408C2, 0xAAF014C1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xD8000000, 0x64000000, 0xAA000000, 0xC1000000, 0x47800000, 0x8F400000, 0x94A00000, 0xBB300000, 0x49680000, 0xC55C0000, 0x34B20000, 0xBA2D0000, 0x3FFB8000, 0x748D4000, 0xADC22000, 0x566DD000, 0xF1D19800, 0xF97BC400, 0xDC436200, 0x862B9F00, 0x31FA3880, 0xBF8654C0, 0xBB435AA0, 0x46ACCB90, 0x8E38E258, 0x7CE6DFA4, 0xEF18188A, 0x4D9B8491 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x68000000, 0x24000000, 0xA2000000, 0x15000000, 0x4F800000, 0xEE400000, 0x0B600000, 0x6D700000, 0xB3A80000, 0x21DC0000, 0x9CF20000, 0x76EF0000, 0x8E308000, 0x1B4B4000, 0x94EBA000, 0xFB3F9000, 0x44CF9800, 0xA2AF1400, 0xBC5D5E00, 0xAFB5EB00, 0xA606B880, 0xC704C4C0, 0x9281E6A0, 0x35C22FB0, 0x2F25DEE8, 0x5712ABE4, 0x33571882, 0x69385465 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xD8000000, 0xF4000000, 0x16000000, 0xFD000000, 0xC3800000, 0x53400000, 0x8A200000, 0x27B00000, 0x5BE80000, 0x17540000, 0x323E0000, 0xD5AF0000, 0x0EFF8000, 0xAEC24000, 0x286BE000, 0xDC1B1000, 0x2C191800, 0xD41A0400, 0x701E0A00, 0x8E131700, 0x5F137880, 0x7E9C5440, 0xC6DB7260, 0x72744330, 0xC5098A58, 0x478557B4, 0xFD4698F6, 0xB328448D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x48000000, 0xE4000000, 0xBE000000, 0x51000000, 0xD1800000, 0xB7C00000, 0x1F600000, 0x47500000, 0x16280000, 0xAF7C0000, 0x485E0000, 0xA6AB0000, 0xE13E8000, 0xF4FF4000, 0x08946000, 0x054DD000, 0x222DB800, 0x09780C00, 0x25543E00, 0x95273100, 0x15F15880, 0x311D9CC0, 0xC68D6660, 0x3B46ADF0, 0xB3223EC8, 0xB8F03124, 0x6291D85E, 0xC249DC61 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xF8000000, 0x9C000000, 0x76000000, 0x0D000000, 0x9F800000, 0xC9C00000, 0x9B200000, 0x98100000, 0x76180000, 0x971C0000, 0xB6960000, 0x865F0000, 0x90F08000, 0x26294000, 0x2F962000, 0x7BDAF000, 0x763D0800, 0xAD829400, 0xFEC5A600, 0x27AE6700, 0xCF5DA680, 0x35726740, 0xCCEBA620, 0x2A3D67D0, 0x3B8326D8, 0xC3C8274C, 0xD02306AE, 0x629DD741 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xD8000000, 0x34000000, 0xD6000000, 0x8D000000, 0xD3800000, 0xEA400000, 0xFD600000, 0xCA100000, 0x74180000, 0x85140000, 0x0C920000, 0xD9D70000, 0x743A8000, 0x3EE9C000, 0x585CA000, 0x8D707000, 0x11074800, 0x1982EC00, 0x6D49BA00, 0xC9EDDB00, 0x44D1BA80, 0xDFB9DBC0, 0xD0A3BAE0, 0xFB3EDB90, 0x26613A38, 0x54931BA4, 0x2DD79AEE, 0xC2306B29 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x48000000, 0x64000000, 0xFA000000, 0x17000000, 0xDD800000, 0xD0C00000, 0x9BA00000, 0x34F00000, 0xEBF80000, 0x92740000, 0xD8B20000, 0xC41B0000, 0x656F8000, 0x3A51C000, 0xC98A6000, 0x32C91000, 0xC0A7C800, 0xE7714400, 0x9E3B3E00, 0xA7591100, 0x1B093E80, 0x738211C0, 0x85C6BEE0, 0xED23D150, 0xEFB4DEA8, 0x299EC134, 0x0DA11652, 0x1DF48523 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x88000000, 0x44000000, 0xA6000000, 0x6B000000, 0xCD800000, 0x47400000, 0x69E00000, 0x62300000, 0xA1380000, 0x78BC0000, 0x01F20000, 0x3F1D0000, 0xFAA58000, 0x95D9C000, 0x840FA000, 0x060B1000, 0x7B02C800, 0xB58F3C00, 0x8B4A6200, 0x8BEAE100, 0xAF386280, 0x07B7E140, 0xF27DE260, 0x2F5E21B0, 0x34CA42E8, 0x39A931F4, 0x4C5A8A4E, 0xFD4B0D9F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xE8000000, 0xF4000000, 0x4A000000, 0x51000000, 0xAE800000, 0xB5C00000, 0xB5A00000, 0x7A500000, 0x67580000, 0xDFDC0000, 0xE51A0000, 0x35370000, 0xED298000, 0xD09EC000, 0x3F766000, 0x23C17000, 0x7AA89800, 0x7FD44400, 0x1510DE00, 0x6D359B00, 0x212ADE80, 0x86929B40, 0xD07B5EE0, 0x96405B90, 0x30EF3E08, 0xD13A2B64, 0x6F2C2642, 0xC59BAF35 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xF8000000, 0x34000000, 0x76000000, 0x4D000000, 0x88800000, 0x93C00000, 0x9E200000, 0x5FD00000, 0x40D80000, 0x9B540000, 0x511A0000, 0xDE710000, 0x7B4E8000, 0x7DE5C000, 0xD9FEA000, 0x9B0C7000, 0x558BF800, 0xB34F4400, 0x71E0E600, 0x7BF6FB00, 0x1002E680, 0x6803FBC0, 0x9C0E6660, 0x0A033B70, 0xF7044698, 0x878B8B44, 0x20479EEE, 0xC8697F09 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x68000000, 0x44000000, 0x32000000, 0x19000000, 0x5D800000, 0x52400000, 0x2B600000, 0x5C100000, 0xD9980000, 0x07DC0000, 0xCAB20000, 0xA5A50000, 0x14BB8000, 0x6AA3C000, 0xF232E000, 0x64667000, 0xFA902800, 0x3752CC00, 0x7F7C9A00, 0xF1802B00, 0x64471A80, 0xE063EB40, 0x6895FA60, 0xBE559B30, 0x3AFDD208, 0x8FCB5774, 0x392B483A, 0x97727C6D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x28000000, 0xCC000000, 0x4A000000, 0x63000000, 0x6E800000, 0x26400000, 0x3EE00000, 0xA1700000, 0x4BF80000, 0x5BB40000, 0x845A0000, 0x94AD0000, 0xF5978000, 0x198F4000, 0x26C1E000, 0x1DA2D000, 0xA81FB800, 0xE94C9C00, 0xAA619200, 0x2C37D500, 0xA7961280, 0xBE8895C0, 0x5E4FF260, 0x4AEE45B0, 0x7F724A48, 0x86FBD97C, 0xD03E5802, 0xE59E4C1F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x98000000, 0x6C000000, 0x16000000, 0x45000000, 0x5A800000, 0x77C00000, 0x93E00000, 0xC9D00000, 0x05580000, 0xF7940000, 0x1EF60000, 0x70EB0000, 0x7E5A8000, 0x2C184000, 0x21B72000, 0xE3CC7000, 0xD9E55800, 0xF2D16400, 0x3ED5FA00, 0x38DD5700, 0xC5D77A80, 0x235117C0, 0xDA965AA0, 0x60766710, 0xE5298238, 0xD2BF437C, 0xEC4B582E, 0x4CAE6439 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xB8000000, 0x54000000, 0xCE000000, 0x93000000, 0xA1800000, 0xE3400000, 0x76600000, 0x13B00000, 0xC8380000, 0x66740000, 0xFA920000, 0x2FEF0000, 0x04FC8000, 0xC05DC000, 0x8ECB2000, 0x7F211000, 0x30D18800, 0xD50F7C00, 0xCE88BA00, 0x00CDD100, 0x4C2C3A80, 0x215411C0, 0x5E4D1AE0, 0x54EE0110, 0x89721258, 0xD913BD44, 0x75AD0896, 0xE612BCD7 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xB8000000, 0x04000000, 0x3E000000, 0x3B000000, 0x2E800000, 0x80400000, 0x05A00000, 0x8DF00000, 0x51780000, 0x88340000, 0xB2160000, 0x1C250000, 0x61368000, 0xF592C000, 0x1BEF2000, 0x43559000, 0x6A0BF800, 0x6D0E3C00, 0xB980C600, 0x1CC2C900, 0x3CEE4680, 0xA7D409C0, 0x774F66A0, 0x492099F0, 0x1CBC1E18, 0xF75D65F4, 0x2C0B7826, 0x7209FCCF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x38000000, 0xAC000000, 0xDA000000, 0x3B000000, 0x73800000, 0x0A400000, 0xBD600000, 0x95100000, 0x8D980000, 0xAC540000, 0x077E0000, 0xDD0F0000, 0x6A848000, 0x4EC24000, 0x0EA5E000, 0x21375000, 0x7A6BE800, 0x64958C00, 0xA0DDFA00, 0x90B01B00, 0x37277A80, 0xE87D5BC0, 0xB8861A20, 0x31C84BD0, 0x93281218, 0x767A977C, 0x6D8600C2, 0x1F4B0047 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xF8000000, 0xE4000000, 0x62000000, 0xDF000000, 0x8D800000, 0xFD400000, 0x01600000, 0x2BD00000, 0xE5580000, 0xD3940000, 0xB2B60000, 0x9A830000, 0xDCC48000, 0xF226C000, 0xDBB2E000, 0xE2021000, 0x1F014800, 0xAD8EDC00, 0xAD4FEA00, 0xF96A2700, 0xCFDD6A80, 0x875FE7C0, 0x0C930AA0, 0x3F3F3790, 0x67CEA258, 0xDDA4FB74, 0xD9F2803A, 0x3EE5C0AB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x98000000, 0xD4000000, 0x6E000000, 0x1F000000, 0x0F800000, 0x4AC00000, 0x3DE00000, 0x2B500000, 0x47D80000, 0x709C0000, 0x9AB60000, 0x36870000, 0xF6468000, 0x72AFC000, 0xA5732000, 0x0DEBD000, 0xE35EA800, 0xABD14400, 0xDA9B7A00, 0x73BABF00, 0xF20BFA80, 0xDD027F40, 0x1A865A20, 0xBC4A6F50, 0x2BA5D2B8, 0xE9FBFB84, 0x6AA880D6, 0x3174C09B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x28000000, 0x84000000, 0x9A000000, 0xFD000000, 0xD5800000, 0xC5C00000, 0x5B600000, 0x3FB00000, 0x9D380000, 0x98740000, 0x37520000, 0x9C4B0000, 0xB0A18000, 0xDBD5C000, 0xB6026000, 0x2300B000, 0xD2856800, 0x7D4E7400, 0x6329E200, 0x251F0900, 0x63E26280, 0xC7F5C9C0, 0xE79382E0, 0xF6ABB950, 0x40D50AC8, 0xC880BDD4, 0x4043E052, 0xD6A57029 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x08000000, 0x24000000, 0xEE000000, 0xCB000000, 0x1A800000, 0xDB400000, 0xD5600000, 0xDAB00000, 0xF5380000, 0x67F40000, 0x0F5A0000, 0xA9C10000, 0x5A298000, 0x09D7C000, 0x708F2000, 0x6E4C9000, 0x5CEFB800, 0x87754C00, 0x39157A00, 0x692AA100, 0x1F5EFA80, 0x31C861C0, 0x26225A60, 0x7BD23170, 0x798B4268, 0x75CC2D54, 0xB826A086, 0x58DB509F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x68000000, 0x9C000000, 0x6E000000, 0x9F000000, 0xD3800000, 0x1C400000, 0xCEA00000, 0xD7F00000, 0xC9780000, 0xA7BC0000, 0x41DA0000, 0x134D0000, 0x45238000, 0x5FBE4000, 0x85D6A000, 0xE94C5000, 0x5829E800, 0x1532EC00, 0x49106600, 0x862E2900, 0xC231E680, 0x16916940, 0xEC66C6E0, 0x67927930, 0xE0E00E88, 0xC85F85AC, 0x420CA0E6, 0xB9015033 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xA8000000, 0xBC000000, 0x66000000, 0x3B000000, 0x1B800000, 0x66C00000, 0x74600000, 0x0FB00000, 0x51780000, 0x111C0000, 0xF4AA0000, 0x00D70000, 0x25418000, 0x76A04000, 0x39D12000, 0x47C31000, 0x12EAE800, 0x79F9A400, 0xA05BF200, 0x1804E100, 0x040AD280, 0x1207F140, 0xB1003AE0, 0xEE8E5510, 0xFA43C848, 0x6F26B4AC, 0x261B1AAE, 0x312A45D7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xF8000000, 0x64000000, 0xA2000000, 0x73000000, 0xCA800000, 0x3BC00000, 0x5CA00000, 0x1C700000, 0x33B80000, 0x15140000, 0xCE6A0000, 0x5D510000, 0x9C8A8000, 0x02C6C000, 0xA92DE000, 0xE3385000, 0x19D63800, 0x2A4A6400, 0xC1E2FE00, 0xA51D8100, 0xF66F1E80, 0xD955D1C0, 0x0E812660, 0x89CBB5F0, 0x07A9D898, 0x7AF73494, 0x367446BA, 0xFCB02527 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0xF8000000, 0x0C000000, 0xCA000000, 0x53000000, 0xEF800000, 0x7AC00000, 0xDE600000, 0x8B100000, 0xC5D80000, 0x3DBC0000, 0x9FA60000, 0x0EFF0000, 0x520C8000, 0xAF0A4000, 0x6D89E000, 0xCDC85000, 0x0FE8E800, 0x64DCA400, 0x6D301200, 0x70EBCB00, 0x1159F280, 0x1CF39B40, 0x5D091A20, 0xD2833F50, 0x584708D8, 0xCE2BF45C, 0xA1347A92, 0x5AED2F4F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x48000000, 0x94000000, 0xD6000000, 0xA1000000, 0x65800000, 0x7DC00000, 0x5FE00000, 0xD6B00000, 0x59780000, 0xF9940000, 0x1FA20000, 0xB8990000, 0x8A298000, 0xED52C000, 0x71CEA000, 0xA5E13000, 0x1DB3A800, 0xEFF9D400, 0xDED99A00, 0x6D0E1900, 0xFF8F3A80, 0x86CB29C0, 0xA16692E0, 0x65FFFDF0, 0xFDD488A8, 0x1F8A2464, 0x76C492FE, 0x8966FD05 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x08000000, 0x6C000000, 0x7A000000, 0x77000000, 0x74800000, 0x09C00000, 0xABE00000, 0xFF900000, 0x51580000, 0xA6340000, 0x4C6A0000, 0x54DB0000, 0x1E7F8000, 0x61CB4000, 0x97E3E000, 0x6D911000, 0xDA561800, 0xA0B2E400, 0x5EA60A00, 0xF1BE0B00, 0x9F2FEA80, 0xEFF41BC0, 0xC7867260, 0xDB4DBF50, 0xD7239868, 0xA3F2A43C, 0xCD826A92, 0x34405B8B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x08000000, 0x7C000000, 0x5A000000, 0x33000000, 0xB8800000, 0x92C00000, 0x2FE00000, 0xAFD00000, 0xDC180000, 0x447C0000, 0x3BE60000, 0xF9D70000, 0x8D1B8000, 0x2BF24000, 0x3FA4E000, 0x51F65000, 0xDCA69800, 0x417BD400, 0xA260BA00, 0x3C9D7F00, 0x42BA5A80, 0x02002F40, 0xA7014220, 0xAE8EBBD0, 0x63C69828, 0xD06BD4AC, 0xA398BAF2, 0x08317FDF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xF8000000, 0x1C000000, 0x62000000, 0x77000000, 0xF3800000, 0x93C00000, 0xCB600000, 0x03500000, 0x19980000, 0xF4740000, 0x006A0000, 0xE2D70000, 0xB55C8000, 0x789F4000, 0x16F26000, 0x392F9000, 0xA4F6E800, 0x762C3400, 0xAB7BD200, 0xD7ECAF00, 0xEF1BB280, 0x3B303FC0, 0x0743DA60, 0x73204B90, 0xF7FCE898, 0x1BAB348C, 0x7DBF527A, 0x6007EF3B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x48000000, 0xBC000000, 0x02000000, 0xDF000000, 0xB8800000, 0xB1C00000, 0xC8600000, 0x77D00000, 0x8F180000, 0xCEFC0000, 0xC5620000, 0xF85B0000, 0xCA538000, 0xED524000, 0x51DD6000, 0x06151000, 0xE771D800, 0x49212400, 0x12787200, 0xC2A57700, 0xB13F1280, 0xC8076740, 0xFC074A60, 0xE2030350, 0xCF0BD828, 0xF08624EC, 0x0DC9F2AA, 0xCA6C3773 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xA8000000, 0x94000000, 0xDE000000, 0x11000000, 0xF1800000, 0xB8C00000, 0x95200000, 0xAD700000, 0x94380000, 0x71D40000, 0x4D8E0000, 0x32C50000, 0xFA238000, 0x7DF0C000, 0x75762000, 0xC831B000, 0xABDDE800, 0x1A888400, 0xEE424600, 0xF962C900, 0x9F17E680, 0xADA3B9C0, 0xB83C2E20, 0x63DA8DF0, 0x1E838088, 0xA840C064, 0xD46E20D6, 0x2495B0B5 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x88000000, 0x2C000000, 0x66000000, 0x75000000, 0xE3800000, 0x2FC00000, 0xBAA00000, 0xEED00000, 0xEA980000, 0xF3F40000, 0xD1820000, 0x58CD0000, 0x06298000, 0x419D4000, 0x61742000, 0x47C7F000, 0x26A50800, 0x60DA9400, 0xC390EE00, 0xFE79FB00, 0xA74D4E80, 0x67E34BC0, 0xB23C66E0, 0xF22E2FB0, 0x53918068, 0xC679409C, 0x634E208E, 0x5DEEF029 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xB8000000, 0x9C000000, 0xC6000000, 0xB5000000, 0xAB800000, 0x79400000, 0x0C600000, 0x78B00000, 0xE2780000, 0xC35C0000, 0x65860000, 0x38470000, 0xE5E88000, 0x7EFB4000, 0x8E962000, 0x4022F000, 0x9F538800, 0x438D7C00, 0xBD4B6A00, 0x66689900, 0x23B5CA80, 0xD8F12940, 0x4B906220, 0x63AEA5D0, 0x52108098, 0xADE7404C, 0x2AF020DE, 0x5C95F0B9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0xE8000000, 0xC4000000, 0x3E000000, 0x47000000, 0xF4800000, 0x83C00000, 0xDC600000, 0xB5D00000, 0x74980000, 0x38340000, 0x23060000, 0x7A890000, 0x0CCB8000, 0x9CE5C000, 0xE0112000, 0x2BF3D000, 0x476CD800, 0x935D0400, 0x6A57B200, 0x19D32700, 0x4E951280, 0x613137C0, 0xE08EEAA0, 0xE5C6E3B0, 0x97660048, 0xCB590074, 0x665380F6, 0x93D1C0F3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x28000000, 0x14000000, 0x92000000, 0xBD000000, 0xA0800000, 0x0E400000, 0x94E00000, 0xE6500000, 0x5D980000, 0x33BC0000, 0x7D460000, 0x5F650000, 0x5F938000, 0x56B0C000, 0x41C6E000, 0x672DB000, 0xCC79F800, 0xB960BC00, 0x20946200, 0x733DAF00, 0x63070280, 0x5385DF40, 0x85CB9A20, 0x8D2813F0, 0x5D78E008, 0x07E4B0E4, 0x3DD4781A, 0x7C597C19 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x68000000, 0xB4000000, 0xFA000000, 0xCF000000, 0xB9800000, 0x67C00000, 0x27600000, 0x3D700000, 0xF8380000, 0xEB1C0000, 0x61C60000, 0x16610000, 0x79F38000, 0xAD7AC000, 0x803E6000, 0x671E1000, 0xB7C1C800, 0xFF669400, 0x41775200, 0x4632BD00, 0xB61CB280, 0xA3476D40, 0x32289A20, 0xF65929B0, 0x0EE66048, 0x22B21004, 0x535FC832, 0x006B948B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xC8000000, 0xEC000000, 0x42000000, 0x1F000000, 0x77800000, 0xE5C00000, 0xE8600000, 0xA9500000, 0x70180000, 0x9C340000, 0x71C20000, 0x1E6F0000, 0xB05F8000, 0xE69F4000, 0x9B726000, 0xF8E91000, 0x8F1DA800, 0x7BBF5400, 0x3C04E200, 0x4A062F00, 0x930B0280, 0x658F7FC0, 0x32C34AE0, 0x73E27B90, 0x0E926028, 0x8779107C, 0x42E5A8EA, 0xE41B54A3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0xD8000000, 0xF4000000, 0x2E000000, 0x73000000, 0x1E800000, 0x67400000, 0x9F600000, 0xDE700000, 0x7AB80000, 0x2F140000, 0xB7CE0000, 0x3B2B0000, 0xF79A8000, 0x3F87C000, 0xC8CC2000, 0xEFA09000, 0xB5D93800, 0xE9652C00, 0x997D2A00, 0xEA328500, 0xEB5D8A80, 0xEE2AD5C0, 0x761C1220, 0x3C43A910, 0xBDEEA0F8, 0x1B3350E4, 0x9CDB1856, 0x6AEEBC57 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x28000000, 0xEC000000, 0xCA000000, 0x51000000, 0x17800000, 0xF1C00000, 0x65200000, 0xC7500000, 0xD2180000, 0xCC740000, 0x524A0000, 0x5AED0000, 0x35738000, 0x69CB4000, 0x812CE000, 0xF1597000, 0x911FC800, 0x4EFDF400, 0x920CF600, 0x55049B00, 0xD1819680, 0x9ACFABC0, 0x0BAB3E60, 0xCD1D6F30, 0x8CFF6048, 0x3F0230DC, 0x508B2802, 0xB540844D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xF8000000, 0x3C000000, 0x4E000000, 0x19000000, 0x56800000, 0x7E400000, 0x65200000, 0xA7500000, 0xE2780000, 0xB52C0000, 0x0F5E0000, 0x36790000, 0x8F288000, 0x9C524000, 0x0BFE2000, 0xF0EDF000, 0xC8B6B800, 0xE14CAC00, 0xAEA44600, 0x5D9E9F00, 0x1E12FE80, 0xC0D23340, 0x5EB6B820, 0x344CACF0, 0xEE244658, 0xB6DE9F8C, 0x9BB2FE36, 0x3CC23365 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x98000000, 0x34000000, 0xBE000000, 0x59000000, 0xFF800000, 0x1FC00000, 0xAE600000, 0xB7700000, 0x01180000, 0xC26C0000, 0xDD7E0000, 0xD61B0000, 0x6CEC8000, 0x9134C000, 0xEDB3A000, 0x92F2F000, 0x81D6A800, 0xCE89A400, 0x3C4BEA00, 0x93A23900, 0xC21D4280, 0x02EB9D40, 0xF036A820, 0xB639A4D0, 0xAB33EA38, 0x42BE39A4, 0x387B42A6, 0x7B9C9D2D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xF8000000, 0xB4000000, 0x12000000, 0x39000000, 0x2D800000, 0x4BC00000, 0xA1E00000, 0xC8F00000, 0xF1180000, 0x3DEC0000, 0xD6FE0000, 0xCE170000, 0x6B668000, 0x71BAC000, 0xBDBD6000, 0x5BB43000, 0xD0B38800, 0x943F0400, 0x0A709200, 0x54501900, 0x2F431A80, 0x2FAF1D40, 0xCED38820, 0x6E0F0410, 0xD7089258, 0xBA8C19E4, 0x51451A6A, 0xA0A41DCD } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x98000000, 0x3C000000, 0xE2000000, 0xBB000000, 0x6C800000, 0x7A400000, 0xA0A00000, 0x70B00000, 0xCC180000, 0xCEA40000, 0x71BA0000, 0x479D0000, 0x0A6E8000, 0x88504000, 0xC700E000, 0x2E831000, 0x91413800, 0x642F8C00, 0xAEF1BE00, 0xB2BBB900, 0xE7108680, 0x6A2435C0, 0x9FF938E0, 0xA13B8CF0, 0x1FD3BEF8, 0x71C2B90C, 0xA46406FA, 0xE9597547 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x74000000, 0x72000000, 0x8B000000, 0x7F800000, 0x31400000, 0x43200000, 0x88700000, 0x49580000, 0x722C0000, 0x38F20000, 0x6D9F0000, 0x874B8000, 0xE223C000, 0x10F76000, 0x79901000, 0xE5428800, 0x01268C00, 0x1B7FB600, 0x3ADC7D00, 0x2D653E80, 0xF6D6F140, 0x636888E0, 0x0BD58C50, 0x9DE63608, 0xD210BD64, 0x9601DE9A, 0xD10921BF } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x58000000, 0x1C000000, 0x6A000000, 0xFF000000, 0xE9800000, 0x02400000, 0x5EA00000, 0xC5F00000, 0x04580000, 0x38240000, 0xB63E0000, 0x64B50000, 0x397E8000, 0xD0924000, 0xAD4E6000, 0xDF2DD000, 0xA3B82800, 0xDCFB5C00, 0x30DCDE00, 0xB8E9BD00, 0xDD5AF680, 0x2CA7E1C0, 0xC6F8A8A0, 0x57DC1C30, 0x6D6C3E78, 0x45162DEC, 0xD50CBEB2, 0xF6816D23 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xA8000000, 0x34000000, 0x12000000, 0xBD000000, 0xB3800000, 0x50C00000, 0x06200000, 0x14D00000, 0xD7F80000, 0xBCA40000, 0x259A0000, 0x5C110000, 0xEDD18000, 0x1E7BC000, 0x056F6000, 0x72357000, 0x0D082800, 0xBB85D400, 0xF4C05E00, 0x4C2CA700, 0x35D27680, 0x427873C0, 0x4363A8E0, 0x2D3F1430, 0xAB86BEC8, 0x6CC617C4, 0xB02F3E3A, 0xE3D9D749 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x38000000, 0x94000000, 0x2A000000, 0x77000000, 0xC8800000, 0x27400000, 0xCF600000, 0x42D00000, 0x0EB80000, 0xDEE40000, 0x58120000, 0xA51D0000, 0x8A9C8000, 0x0D50C000, 0xF97AE000, 0xF2C75000, 0x77A83800, 0x32739C00, 0x2C429200, 0xF1E74300, 0x7498AA80, 0x7059DFC0, 0x16FEB860, 0x950A5C70, 0x338EF2D8, 0x01C9D324, 0x3D24F292, 0x9E30D323 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x88000000, 0x84000000, 0xE6000000, 0xE5000000, 0x4A800000, 0x25C00000, 0xFD600000, 0x11700000, 0xB5180000, 0xE4EC0000, 0x233E0000, 0x8B350000, 0x3F338000, 0xF136C000, 0xE0372000, 0xC4B9B000, 0x807B3800, 0xD1995400, 0x002C7A00, 0x02D39900, 0xD2894280, 0xB9CFCD40, 0xC76EB820, 0x6E769430, 0xF096DA28, 0x0CA9E9F4, 0xB216DAEE, 0xED69E921 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x28000000, 0xC4000000, 0x9A000000, 0x9B000000, 0xBF800000, 0x60400000, 0xF8200000, 0x3B100000, 0xE2380000, 0x4DAC0000, 0xF85E0000, 0x199D0000, 0x90F18000, 0x0F48C000, 0x15A4E000, 0x54579000, 0xE79B8800, 0x61F69C00, 0x03C3D600, 0x0E66DB00, 0x563E5E80, 0xBFA14740, 0x07520820, 0xCC125CB0, 0x43B93688, 0x8CEC4B34, 0xD4F45632, 0xD54F1B1F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x38000000, 0xDC000000, 0xAA000000, 0x29000000, 0xB2800000, 0x83C00000, 0xD6600000, 0x65300000, 0x80580000, 0x86E40000, 0x0BF20000, 0x42B50000, 0xEB148000, 0x22444000, 0xE6266000, 0xB616B000, 0xCECCF800, 0xD2EBF400, 0x85FEAA00, 0xFDB32D00, 0xEA985280, 0x0209D9C0, 0xDD007860, 0x2C8BB4F0, 0xD4CACAD8, 0x03E09DEC, 0x0B782A12, 0xE4726D35 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xA8000000, 0xB4000000, 0xE6000000, 0x15000000, 0x63800000, 0xF1C00000, 0xC5A00000, 0xEDF00000, 0x6B580000, 0x682C0000, 0xFD320000, 0x4B7F0000, 0x71178000, 0x984BC000, 0x8B662000, 0xC4D2B000, 0x43EFA800, 0x0F928400, 0x8E093600, 0x810E8D00, 0xF58C9E80, 0x5CCF0940, 0xBA2028E0, 0x4E354450, 0x5DFD16C8, 0xF3533DA4, 0x042CB6CE, 0x173A4DE1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xA8000000, 0x9C000000, 0xEA000000, 0xBF000000, 0x54800000, 0x12400000, 0x33A00000, 0xD5900000, 0x47380000, 0x2F2C0000, 0x6BD20000, 0x56990000, 0xA9B18000, 0x3A694000, 0x48F26000, 0x4F46D000, 0x142EF800, 0xC15F8C00, 0x9DD18E00, 0x4398FB00, 0x22357680, 0x0CA27740, 0xC11F78E0, 0x3576CC30, 0x6C83EEC8, 0x164E2BEC, 0x8DA38EC2, 0x6C91FB63 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x08000000, 0x7C000000, 0x72000000, 0xC3000000, 0x73800000, 0x50400000, 0x2DE00000, 0x40300000, 0xFE580000, 0x5E2C0000, 0x75960000, 0xCF870000, 0x42498000, 0x1EE54000, 0xEBBDE000, 0xDA139000, 0x7DC0C800, 0x84A31C00, 0x8154EA00, 0x3FA46500, 0x16DDA280, 0x49E23940, 0x2634A8A0, 0xC355CC90, 0x44A9C228, 0xE154E9AC, 0xCFA980FA, 0xCED540FF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x58000000, 0x74000000, 0x5E000000, 0xA1000000, 0x23800000, 0x68C00000, 0xD7200000, 0x1B500000, 0xDBF80000, 0xD6640000, 0xABB20000, 0x2D050000, 0x198A8000, 0x1FCCC000, 0x49A1A000, 0x221A7000, 0xEF176800, 0xC6955400, 0x815BEE00, 0xBCF7FF00, 0xC0E60680, 0x8EFE6BC0, 0x6BE44860, 0x8277E4F0, 0xE9A726B8, 0x3219DB44, 0x67120086, 0xDA950015 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x58000000, 0x24000000, 0x56000000, 0x41000000, 0x4E800000, 0x00400000, 0xE7600000, 0x33700000, 0x0C980000, 0xDEAC0000, 0xABDA0000, 0x2E450000, 0x12628000, 0xA3F9C000, 0x01DC2000, 0x5D48F000, 0xABE8B800, 0x9C3C8C00, 0xF074E200, 0xAD126900, 0x2566DA80, 0x3C7B2540, 0xC7141860, 0xF664BC70, 0x55F8FAB8, 0x90DAD514, 0x7BC4208E, 0xD7A4F025 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xA8000000, 0x3C000000, 0x3E000000, 0x65000000, 0x92800000, 0x4AC00000, 0x0FE00000, 0x52900000, 0xD9F80000, 0xD8AC0000, 0x82360000, 0x77CF0000, 0x196B8000, 0x925B4000, 0xE11D2000, 0xEBB33000, 0xDA82B800, 0x46CD6400, 0xE9EF8200, 0xF390BF00, 0xE17EBA80, 0xF56A9B40, 0x445A18A0, 0x98161410, 0x17359A88, 0x5D46AB6C, 0xE7AB2016, 0xCFBC3019 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xD8000000, 0x04000000, 0x16000000, 0xE5000000, 0x78800000, 0xB0400000, 0x05600000, 0x5C300000, 0x3FD80000, 0x4AAC0000, 0xEA9A0000, 0x77470000, 0xE6E88000, 0x5DF3C000, 0x28782000, 0x8CBEB000, 0x039B9800, 0x65CEEC00, 0x51A38200, 0x1B10DD00, 0x85889A80, 0x6CC1F140, 0x53293860, 0x74589C50, 0xC76ABA38, 0xD7384114, 0x565A204E, 0x5C65B0A1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x28000000, 0x3C000000, 0x92000000, 0xB7000000, 0x60800000, 0x0DC00000, 0xA8200000, 0x03100000, 0x2DB80000, 0xEA640000, 0xE2720000, 0xFD470000, 0x4DEF8000, 0x773F4000, 0xACA3E000, 0x58DCD000, 0x5498B800, 0x80FAF400, 0xAF89AE00, 0x594C7B00, 0xFBE69680, 0xB63DCFC0, 0xED26D860, 0x049E64D0, 0x88FD76C8, 0x63851F2C, 0xF34C603A, 0x58E3904B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x98000000, 0x0C000000, 0x6E000000, 0x15000000, 0x54800000, 0xA5C00000, 0xD1600000, 0x08900000, 0x78780000, 0x71A40000, 0x857A0000, 0x112D0000, 0x12B68000, 0x13474000, 0xCFA92000, 0xF8783000, 0xB1AFD800, 0xE57C7400, 0x2128DA00, 0x8AB13700, 0x1F4B8280, 0xA1A703C0, 0xED7CF8E0, 0xE52944F0, 0x40B182F8, 0xF04A033C, 0x822A7876, 0x673E04D9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x38000000, 0x54000000, 0x8A000000, 0x43000000, 0xBA800000, 0xF1400000, 0x9F200000, 0x8E700000, 0xB8D80000, 0x056C0000, 0xA7D60000, 0xE9E70000, 0x039A8000, 0xB94CC000, 0x6324E000, 0x487D1000, 0xF5DFD800, 0x4EE39C00, 0xFB119600, 0xB7051D00, 0xA082CE80, 0xAA4D4140, 0xA1AD38A0, 0xCD398C90, 0x30F4CE18, 0xBB9A4184, 0xAD4FB832, 0xC9294C57 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xA8000000, 0x5C000000, 0x22000000, 0x2B000000, 0xAA800000, 0xD3400000, 0x3A200000, 0xD1B00000, 0xF0D80000, 0x774C0000, 0x3C2A0000, 0xBCB90000, 0xD7558000, 0xF3834000, 0x2ACDE000, 0x27E99000, 0x9ED59800, 0xE640DC00, 0xA9AD7600, 0xCB702900, 0x9F350E80, 0xC5996540, 0x506DE060, 0x62199030, 0x94AD9848, 0x94FCDC2C, 0x7FFF768A, 0x75752977 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xC8000000, 0x14000000, 0xA2000000, 0x65000000, 0x74800000, 0x22C00000, 0x2CE00000, 0x80900000, 0x96B80000, 0x26C40000, 0x26E60000, 0x019F0000, 0xD8318000, 0xBD09C000, 0xC88D6000, 0x64C37000, 0x73E89800, 0x4D18A400, 0x76F38200, 0xEFE2B700, 0x9B167A80, 0x41F963C0, 0x666D6020, 0x11537090, 0xF9D09868, 0x0D1CA444, 0x16F5826A, 0x1FEDB771 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x78000000, 0x9C000000, 0x6E000000, 0x03000000, 0xEB800000, 0xBF400000, 0x8EE00000, 0xF6500000, 0x4BF80000, 0xB54C0000, 0x3FE20000, 0x10DD0000, 0xAC348000, 0x17624000, 0x641D2000, 0x4D93D000, 0xA7DE0800, 0x3DB10C00, 0x412D3A00, 0x407FDB00, 0xFA0E1280, 0xA90D0740, 0xCA8520E0, 0xF1CFD0F0, 0x3D240818, 0xDE700C2C, 0xE103BA16, 0x6E8C9B9F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x48000000, 0xE4000000, 0xA2000000, 0x4F000000, 0x6B800000, 0x6C400000, 0x29A00000, 0xF0F00000, 0x77180000, 0x514C0000, 0x152A0000, 0x4B310000, 0xCCF38000, 0xC916C000, 0xF0466000, 0x87ABD000, 0xE9F7C800, 0x499DBC00, 0xB588BE00, 0x7D470500, 0x13211680, 0x463D6940, 0x18746060, 0x86D6D0B0, 0x51AE48A8, 0xFCFA7C14, 0x211D5EEA, 0x044A15AB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x98000000, 0xB4000000, 0xA6000000, 0x1F000000, 0x68800000, 0x5AC00000, 0x57A00000, 0x51700000, 0xE2180000, 0x0FCC0000, 0xD22E0000, 0x2A3F0000, 0x50F48000, 0x175EC000, 0x7E272000, 0x78309000, 0x49F9F800, 0x30D8E400, 0xD46E7600, 0xC15BBD00, 0xE928AE80, 0x9CBFC940, 0x51312020, 0x46739010, 0x469B7838, 0xB70524E4, 0xF48BD63E, 0x20C6EDAB } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x08000000, 0x34000000, 0x6E000000, 0xA3000000, 0xD9800000, 0xC9C00000, 0x23E00000, 0x7EF00000, 0x6ED80000, 0x8EC40000, 0x5C620000, 0xC03B0000, 0xAABD8000, 0x92F7C000, 0xFCDFA000, 0x97C3D000, 0x18E02800, 0x7B79C400, 0xAD168200, 0x682EC100, 0x6C110A80, 0xD0A0D5C0, 0x6D5DA060, 0x4A08D090, 0xE505A8E8, 0xFE8A0464, 0x264B2266, 0x75261197 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x18000000, 0x0C000000, 0x22000000, 0xC5000000, 0x13800000, 0x2A400000, 0x3D200000, 0x6E900000, 0x0FF80000, 0x17440000, 0x92AA0000, 0x1ED10000, 0x8BDE8000, 0x50554000, 0x7E10E000, 0x053B7000, 0x98A9E800, 0x6FDFDC00, 0xA65B1600, 0xF5190B00, 0x81BA1E80, 0x7C69A7C0, 0x673AE0E0, 0xFDAA70B0, 0x6C576878, 0xE41A9C7C, 0xDC33F63A, 0xC1267BC9 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xE8000000, 0xAC000000, 0xAE000000, 0xA1000000, 0x90800000, 0x54C00000, 0x9A200000, 0x93100000, 0x0CF80000, 0x0D4C0000, 0xB2620000, 0x93F30000, 0xF4C38000, 0xEA204000, 0x4B162000, 0x18FDF000, 0xE7419800, 0x11648400, 0x0C750E00, 0x91890300, 0xB440B680, 0x16E37740, 0x1D37A0E0, 0x75EEB010, 0xA2B43888, 0x20A934FC, 0x44DAB646, 0x395C770D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xA8000000, 0x24000000, 0x9A000000, 0x01000000, 0xE2800000, 0x29C00000, 0xCD600000, 0x8B300000, 0x90980000, 0x0F440000, 0x2EAA0000, 0x8F5F0000, 0x4D2B8000, 0x8414C000, 0xC985E000, 0x524CB000, 0x7A22B800, 0xE997F400, 0xC1C56A00, 0x496A3500, 0xE1303280, 0xA99A71C0, 0x61CE60E0, 0xB9687050, 0xD93F58C8, 0x259F44B4, 0xDFCDD232, 0x2262C125 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x78000000, 0x1C000000, 0x86000000, 0x21000000, 0x60800000, 0x3C400000, 0x80E00000, 0x92300000, 0xB6180000, 0xC48C0000, 0x064A0000, 0xD7EF0000, 0xBBB68000, 0x8EDE4000, 0xE225A000, 0xB3907000, 0xB2431800, 0x95E74C00, 0xF0B38A00, 0x21518D00, 0xFBE3B280, 0xF5B8F140, 0x3BD68060, 0x70AE4050, 0x4CDDA098, 0xE92C700C, 0xFC1118FE, 0xBB844C3D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x08000000, 0xFC000000, 0x5A000000, 0x41000000, 0x84800000, 0xA5400000, 0x6A200000, 0x7BB00000, 0xC8580000, 0x68840000, 0x874E0000, 0xFF290000, 0xE93B8000, 0x7E174000, 0x3B2E6000, 0x873FB000, 0xB91D5800, 0x14AD9C00, 0xEFFDB600, 0x0EFA7900, 0xFA750E80, 0x773F15C0, 0x511B80A0, 0x78A74070, 0x0DF66028, 0xBBFBB04C, 0xD8F35852, 0xC9749CBD } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x98000000, 0xC4000000, 0x06000000, 0x0B000000, 0x4F800000, 0x35400000, 0x52600000, 0xB1700000, 0x3DD80000, 0xDD840000, 0x604E0000, 0xF2EF0000, 0x1DB48000, 0xC9FDC000, 0xB5182000, 0xDFA6D000, 0x4BD74800, 0x5E892C00, 0x53C2B200, 0xD5A99100, 0xDAD95A80, 0xF80BADC0, 0xF40C80A0, 0x6E09C010, 0x870E20B8, 0x158DD014, 0xFC4DC89E, 0x10EBECCF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x48000000, 0x74000000, 0x36000000, 0xE3000000, 0x7E800000, 0x70400000, 0xAF600000, 0xD6300000, 0xFD980000, 0x95840000, 0x1AC60000, 0xF9210000, 0x625F8000, 0x692BC000, 0x5A582000, 0xF52F5000, 0xA85ED800, 0x68266C00, 0x41DDB200, 0x50E27500, 0x7DFCCA80, 0x573489C0, 0x26198020, 0x904AC070, 0x7F67A0E8, 0x8E3490C4, 0x719EF87E, 0x9F8D3C97 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0x0C000000, 0x9A000000, 0x8F000000, 0x8A800000, 0xC2C00000, 0xBB600000, 0x1DB00000, 0xC9980000, 0x530C0000, 0x08820000, 0x31C70000, 0x83E28000, 0x64734000, 0x6E716000, 0x997D5000, 0x7FFA5800, 0x373F8400, 0x3B5F1A00, 0xA0622D00, 0x3134A280, 0x5654B940, 0xC9E200E0, 0xF3770050, 0x98FA8058, 0xE9BF401C, 0x7F9360A2, 0x360A5083 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x58000000, 0x5C000000, 0xAE000000, 0x83000000, 0xC4800000, 0xD4400000, 0x18200000, 0xC7500000, 0xD8B80000, 0xDD0C0000, 0x0F860000, 0x34C70000, 0x6E608000, 0xAA704000, 0x04672000, 0xBB76D000, 0x9DEE7800, 0x20B00C00, 0x91034600, 0xD9893700, 0xBBCC9E80, 0x5CE8AB40, 0xA13E00A0, 0x76CB0010, 0x2B668078, 0x99F7400C, 0xEEA7A0F6, 0x5E1690DF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x18000000, 0x0C000000, 0xB2000000, 0x09000000, 0xE0800000, 0x3CC00000, 0xBBA00000, 0x6CB00000, 0x86580000, 0x5B040000, 0x39860000, 0xD4410000, 0x236A8000, 0x71114000, 0x5DE3E000, 0x86D7B000, 0xB7CC9800, 0x8A2AC400, 0x1CF3F600, 0x033EB100, 0x9D100E80, 0x3FE385C0, 0x87DE0020, 0xF3450070, 0x10EC80B8, 0x105040BC, 0x340960AA, 0xCE06F005 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0xE8000000, 0x74000000, 0xE2000000, 0x0F000000, 0x20800000, 0x98C00000, 0x10E00000, 0xE6700000, 0xB3D80000, 0xDA040000, 0x730E0000, 0x068B0000, 0x0DC78000, 0xA369C000, 0xC8396000, 0xD6F6D000, 0x0316F800, 0x9EED8400, 0xE77F8200, 0x5252E900, 0x83419A80, 0xAAAF7DC0, 0xD15800A0, 0x1DC40050, 0x8B6E00C8, 0x9C3B00E4, 0xA4FF800A, 0xE41DC07B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xA8000000, 0x4C000000, 0x4E000000, 0x97000000, 0xC5800000, 0x7D400000, 0xA7600000, 0x3BF00000, 0x55280000, 0xF8040000, 0x84020000, 0xB2010000, 0xE1048000, 0xB6854000, 0xBAC26000, 0x03227000, 0xCE14B800, 0xD61E2C00, 0x770FEA00, 0xE0933B00, 0x58DADF80, 0xFE2B2940, 0x2B800020, 0x3A400010, 0xEAE00008, 0x9AB00024, 0x1448002A, 0x18F40013 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x38000000, 0x8C000000, 0x5A000000, 0x21000000, 0x3B800000, 0x38400000, 0xCBE00000, 0x69F00000, 0x2D980000, 0x2C040000, 0x6A060000, 0xE9070000, 0x9F808000, 0xD641C000, 0x3CE46000, 0x2972D000, 0x0F590800, 0xE425DC00, 0xF057C200, 0x66895F00, 0xF7EFCF80, 0xBDDAACC0, 0x93E00020, 0x35F00030, 0xAF980038, 0x91040004, 0x3386000E, 0x7C470023 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xC8000000, 0xDC000000, 0x4A000000, 0x4F000000, 0x53800000, 0xE2C00000, 0x86600000, 0x10F00000, 0x7ED80000, 0xB4040000, 0xE6020000, 0xED010000, 0xF0818000, 0x33464000, 0xF7A6E000, 0x8F125000, 0xC3EA7800, 0x1F3E9C00, 0xA0311600, 0xF3BF3300, 0xB9740780, 0x5B1E36C0, 0x9DE00020, 0x6E300010, 0x92B80008, 0xDBF4000C, 0x035A0032, 0x67C50037 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x28000000, 0x34000000, 0x6A000000, 0xA5000000, 0xDA800000, 0x10C00000, 0xD5200000, 0xC6900000, 0xFCF80000, 0x02040000, 0xF1060000, 0xC0850000, 0x4DC68000, 0x13A14000, 0x8851A000, 0xE6DB5000, 0xBB112800, 0xC7B8D400, 0x07618600, 0xAF762900, 0xE94A7480, 0x3B6CC7C0, 0x06780020, 0x02C40030, 0xAC260028, 0xE2150034, 0xF33E800A, 0x80A5400D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xD8000000, 0xE4000000, 0xBE000000, 0x37000000, 0xDD800000, 0x3D400000, 0xF3200000, 0x6BD00000, 0x3C480000, 0xBA040000, 0x99060000, 0x52830000, 0xD4C68000, 0xA866C000, 0x4BF72000, 0x341DF000, 0x8C0DB800, 0x0DA4EC00, 0x9D14EA00, 0x492A1900, 0xAD771E80, 0x46DE0240, 0x97680020, 0xF5D40030, 0x7B4E0018, 0x0F870034, 0x48408036, 0x23A5C039 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x28000000, 0x84000000, 0xDA000000, 0x23000000, 0x31800000, 0xCEC00000, 0x2AA00000, 0x96100000, 0x4B580000, 0xAE040000, 0xA1060000, 0x0E810000, 0x19448000, 0xB1614000, 0xF0342000, 0xDB0ED000, 0x13BD1800, 0x4CF38C00, 0x96A97600, 0x4E28D500, 0x7A6B7080, 0x0B8C3AC0, 0x33F80020, 0xCF140030, 0x09DE0008, 0x59450024, 0x5162800A, 0x40304021 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x38000000, 0x84000000, 0x56000000, 0x27000000, 0x2B800000, 0xC7C00000, 0x4F600000, 0xD9900000, 0xDFB80000, 0x77040000, 0xF3820000, 0x73C50000, 0xB1648000, 0x4291C000, 0x263C2000, 0xC1C6B000, 0xB0633800, 0x46145C00, 0xE67ABE00, 0xA367BB00, 0xD390EC80, 0x1AB94DC0, 0x85820020, 0x84C50010, 0x02E48028, 0x9151C024, 0x075C200E, 0xBB56B021 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xF8000000, 0x3C000000, 0x5A000000, 0x1B000000, 0xA8800000, 0x1C400000, 0x7B600000, 0x81100000, 0x4F080000, 0xAB040000, 0x80860000, 0xF8410000, 0x0D608000, 0x3817C000, 0xC089E000, 0x45C6D000, 0xFCA6D800, 0xAAB44400, 0xDF386200, 0xA7781B00, 0x6A1FE880, 0x720BA840, 0xA2860020, 0x1F410030, 0xDFE08008, 0x2F57C004, 0xEB69E03E, 0xE496D00F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x28000000, 0x3C000000, 0xD2000000, 0x7B000000, 0xEF800000, 0x48400000, 0xC9200000, 0x88100000, 0x90A80000, 0xA3040000, 0x8B820000, 0xBE450000, 0xE4248000, 0xDA914000, 0xA269E000, 0x64E29000, 0x1671D800, 0xC81A7C00, 0xDEFAC200, 0x23890900, 0x2C16A080, 0x86A99540, 0xBE020020, 0x61050010, 0x98848028, 0xCDC14024, 0xEE61E00A, 0x40B6900F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xF8000000, 0xBC000000, 0xC2000000, 0x57000000, 0xC0800000, 0x30C00000, 0x82200000, 0x28B00000, 0x66380000, 0xCB040000, 0x72860000, 0x3FC50000, 0x4EA58000, 0x2277C000, 0x0F1DE000, 0xE1321000, 0x737CB800, 0xB6670400, 0x24520600, 0xF9AED100, 0xA20D2580, 0xD7F8E1C0, 0x88A60020, 0x6B750030, 0x4A9D8028, 0x0E73C02C, 0x451BE03E, 0x5237102F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x88000000, 0x0C000000, 0xCA000000, 0x37000000, 0x2B800000, 0x9D400000, 0xD2E00000, 0x56B00000, 0x55C80000, 0xEB040000, 0x39820000, 0x3E430000, 0xC7638000, 0xB2F44000, 0x5DA86000, 0xF6725000, 0x3F6BB800, 0xE7D65C00, 0xB23D6A00, 0xB62DD700, 0x4B375580, 0xFD89BE40, 0x49620020, 0x63F30010, 0x9B2B8018, 0x8FB0401C, 0xDF4A6022, 0x38C15003 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x38000000, 0x54000000, 0x12000000, 0xED000000, 0x9C800000, 0x89400000, 0x8A600000, 0x07500000, 0xC1380000, 0x91040000, 0x82860000, 0xD2450000, 0x81E28000, 0x9391C000, 0x189AA000, 0x6A749000, 0xBF096800, 0x90EDE400, 0x507CCA00, 0xDF629300, 0x0FD31A80, 0xFA78D9C0, 0xA6660020, 0x21550030, 0xCE3A8028, 0x8885C014, 0xFB44A00E, 0x97659015 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x48000000, 0x14000000, 0x6E000000, 0xC9000000, 0xF3800000, 0xD4C00000, 0x89E00000, 0xBB100000, 0x7EB80000, 0xE5040000, 0x11820000, 0x4FC30000, 0x59648000, 0x73524000, 0x0D18A000, 0x9EB77000, 0x400C4800, 0x15089C00, 0xBC8C2600, 0x3F4B0F00, 0x542CF880, 0x947B45C0, 0xCDE20020, 0xBD130010, 0x53BC8018, 0xA0864024, 0x5042A012, 0x4FA07005 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xF8000000, 0x4C000000, 0x76000000, 0x07000000, 0xB5800000, 0x5F400000, 0x91E00000, 0x80900000, 0xB2980000, 0xB1040000, 0x52820000, 0xDAC50000, 0xA6A48000, 0xA577C000, 0x080A6000, 0x729FB000, 0x51063800, 0x6282AC00, 0xB2C37A00, 0x12A7CF00, 0x9F71A480, 0x790C44C0, 0xC01A0020, 0xBBC10010, 0xAC268028, 0xA3B2C024, 0x20AEE03E, 0x9CE87013 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xB8000000, 0xFC000000, 0x26000000, 0xE3000000, 0xC1800000, 0xCEC00000, 0x3CE00000, 0x41900000, 0xE9780000, 0xB5040000, 0x5A860000, 0x93430000, 0x24278000, 0x2675C000, 0x956FE000, 0xB4BD3000, 0x30651800, 0x49D30C00, 0x90DAF600, 0x8BB7A700, 0xA80E2C80, 0x5BEE9BC0, 0x15FE0020, 0x05470030, 0xDF218018, 0x8BF6C03C, 0x35A8602E, 0x2F58F03F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xB8000000, 0x64000000, 0x7A000000, 0xF5000000, 0xB5800000, 0xD7C00000, 0x78600000, 0xDFF00000, 0xCA580000, 0x6B040000, 0xFA860000, 0xB7410000, 0x4A228000, 0xC855C000, 0x09CB2000, 0x04AFD000, 0xAEDDA800, 0x9346AC00, 0xD0233E00, 0x4D558300, 0x544A9F80, 0x0F6F62C0, 0xC8BE0020, 0xC3B50030, 0x5AFC8008, 0x4410C014, 0x016FA02E, 0x1FBB1019 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x28000000, 0x6C000000, 0xA2000000, 0x55000000, 0x89800000, 0x0C400000, 0x1D600000, 0xCDB00000, 0x25580000, 0x73040000, 0xF2820000, 0xC2C50000, 0xF5A08000, 0x11114000, 0x37CB6000, 0x71891000, 0xB5ECA800, 0xE3DF4C00, 0xA7C3E200, 0x04262B00, 0xF951CD80, 0xF4AE9AC0, 0x633A0020, 0x20310010, 0xB71A8028, 0x11604004, 0x9FB1E00A, 0xE859501B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0xB8000000, 0xD4000000, 0xAA000000, 0x6B000000, 0xFF800000, 0xC2C00000, 0x9E200000, 0x44500000, 0xF5980000, 0xAF840000, 0x4AC20000, 0x52250000, 0x4A538000, 0x8C9DC000, 0xEF02A000, 0xDD875000, 0x65C65800, 0x6FA47C00, 0xFF93D600, 0x2B3A5100, 0x7C937280, 0x88BEF4C0, 0xD8538020, 0x739DC010, 0x1A82A028, 0x0447501C, 0xBC66582E, 0x3D347C35 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x48000000, 0x54000000, 0x96000000, 0xDB000000, 0x1D800000, 0x79400000, 0xD9600000, 0xF0500000, 0x22A80000, 0xB5840000, 0xFD460000, 0x67630000, 0x6F508000, 0xE12A4000, 0x43C6A000, 0xAFA2B000, 0x3575D800, 0x89186C00, 0xDDBD8A00, 0x454E6B00, 0x8D123280, 0x85CA4D40, 0xBAD08020, 0x0C6A4030, 0x6CA6A018, 0x94F2B004, 0x425DD812, 0x11DC6C15 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x68000000, 0xA4000000, 0x26000000, 0x8F000000, 0x92800000, 0x61C00000, 0xFCE00000, 0x6FF00000, 0x89780000, 0xA6840000, 0xEFC60000, 0x77E50000, 0xCB708000, 0x0FBB4000, 0x6CE12000, 0xC7F73000, 0x8D797800, 0x90801400, 0x08C64E00, 0x4167C700, 0x8CB2CF80, 0x7C5B73C0, 0x91908020, 0x2F4B4030, 0xD7192028, 0x10B33004, 0xF65F781A, 0x2C951429 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xA8000000, 0x34000000, 0x2A000000, 0xC3000000, 0x6B800000, 0x67400000, 0x41600000, 0x83300000, 0x49280000, 0x0F840000, 0x35460000, 0x0E670000, 0xAEB78000, 0x5B6D4000, 0xF865A000, 0x53B75000, 0xC9E91800, 0x6FA0DC00, 0x82107A00, 0x72FCAB00, 0x0DDEC980, 0xEF0B1140, 0x0DD78020, 0x1F5D4030, 0xB8CDA038, 0x3C73503C, 0x544F182A, 0x72B7DC0D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xE8000000, 0xCC000000, 0x5E000000, 0x39000000, 0x43800000, 0x8FC00000, 0x75E00000, 0x68900000, 0x10E80000, 0x97840000, 0x95C20000, 0xCEE10000, 0x94118000, 0xC1AF4000, 0xBC226000, 0x6070F000, 0xB9F8C800, 0xB7AF9C00, 0x29253E00, 0x6DF6CF00, 0xD7393480, 0xA5CB8F40, 0x5C718020, 0x6FFF4010, 0x52AA6008, 0xECA4F00C, 0xFF32C83A, 0x735A9C33 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x48000000, 0x34000000, 0xE2000000, 0xAF000000, 0xDF800000, 0x1CC00000, 0x52200000, 0xFED00000, 0xBAA80000, 0x7D840000, 0xD3C60000, 0x3DA50000, 0xBA108000, 0x948A4000, 0x5555A000, 0x24691000, 0x30A47800, 0xAA907C00, 0xE7CFA600, 0x43B7B100, 0xF49CA680, 0xA2D80D40, 0x20B88020, 0x390E4030, 0x6E93A028, 0x3DCC1004, 0x20B4F812, 0xA51A3C0D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x88000000, 0xA4000000, 0x4A000000, 0x5F000000, 0x94800000, 0x90C00000, 0x71E00000, 0x89F00000, 0x4A980000, 0x9A840000, 0x55C20000, 0xA2610000, 0x11B58000, 0xCDBC4000, 0xD3912000, 0x17285000, 0x293FF800, 0xAB572400, 0x52CBC600, 0xD2CE2F00, 0x92C9DF80, 0xB2CECCC0, 0x02CD8020, 0x8AC84010, 0x2ECB2008, 0x64CD502C, 0x3BC87822, 0xAF4A6429 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xB8000000, 0x2C000000, 0x2E000000, 0xE7000000, 0x2E800000, 0xA6C00000, 0x58E00000, 0x61B00000, 0xF8C80000, 0x5C840000, 0xB7C60000, 0x2D650000, 0x4FF18000, 0x75EDC000, 0x49556000, 0x417F7000, 0x184E3800, 0x4D42F400, 0xE9A3F600, 0x4E172700, 0x55DE3D80, 0xADD85E40, 0xE1D98020, 0x5FD9C030, 0x30DB6028, 0x8A5E700C, 0x2E99B82E, 0xBF7A340B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x88000000, 0xEC000000, 0x1A000000, 0xB5000000, 0x46800000, 0xF7C00000, 0xE3200000, 0x1C900000, 0x35780000, 0x88840000, 0x7CC20000, 0x06A70000, 0x32D18000, 0x5A1C4000, 0x2A736000, 0x5BCAD000, 0xF1EEA800, 0xA9FDB400, 0x6A42FE00, 0x0964F900, 0x55F2F480, 0x808EA3C0, 0x38098020, 0xCCC84010, 0x26696038, 0x0EB9D00C, 0xE1A52822, 0x8D52F43B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xF8000000, 0xEC000000, 0xA2000000, 0xCD000000, 0x7A800000, 0x86400000, 0x83200000, 0x3E500000, 0x38B80000, 0x67840000, 0xC4C60000, 0x89630000, 0x4F728000, 0x33EFC000, 0xC9BB6000, 0x87071000, 0x03836800, 0x82C25400, 0xC2617200, 0x1EF4B900, 0xB42B8280, 0x355EBDC0, 0xA9B48020, 0xB78CC030, 0x9C49E018, 0x62A8D014, 0xB118083E, 0xD795443B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x88000000, 0x34000000, 0x12000000, 0x4F000000, 0x08800000, 0x2E400000, 0x00A00000, 0x8A300000, 0xC3B80000, 0x6F840000, 0x62C60000, 0x04E70000, 0x29928000, 0xEF0C4000, 0xEB7DA000, 0x58629000, 0x85D37800, 0xC8ADC400, 0x0DCBB200, 0x2F9FE500, 0x91F06180, 0x3ADF75C0, 0xABD48020, 0x61AB4030, 0xB84F2038, 0x165ED014, 0x3F96D822, 0xAA0B540D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x38000000, 0xD4000000, 0x7A000000, 0x91000000, 0x06800000, 0x47400000, 0x96600000, 0x3B300000, 0x5BA80000, 0x1F840000, 0xBDC60000, 0xA7270000, 0x42568000, 0xB519C000, 0x40EAA000, 0x0FE1D000, 0x61F58800, 0x1509B400, 0xCF117A00, 0x9A7DD300, 0x715FA980, 0x6D090540, 0x3B108020, 0xD07EC030, 0x085C2038, 0x87881034, 0xD257280E, 0xAD1C6435 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0xF8000000, 0x4C000000, 0x8A000000, 0xD9000000, 0x17800000, 0x6E400000, 0xECA00000, 0x2A100000, 0x8B180000, 0x6A840000, 0xD7C20000, 0xB5E70000, 0x06318000, 0x3FCFC000, 0x6BFE6000, 0x51325000, 0x8F4BC800, 0xED3A3C00, 0xA7533200, 0x113FC500, 0x9555E080, 0x643A80C0, 0x38D38020, 0x2B78C010, 0x8FF7E038, 0xE529900C, 0x314FA83E, 0xB23B6C13 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xC8000000, 0x24000000, 0x2E000000, 0xE1000000, 0xC0800000, 0x9D400000, 0x4B600000, 0xEA300000, 0x84880000, 0x8F840000, 0xFCC20000, 0x36A10000, 0x2C108000, 0xEDDE4000, 0xC53D2000, 0xD9CF7000, 0xA4E00800, 0x26F58400, 0x6A2B2A00, 0x4F91BB00, 0x1B1B4180, 0x3C9E7C40, 0xD45A8020, 0x14FB4010, 0x35EFA008, 0x12B03004, 0x85CDA832, 0x36E4B409 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x28000000, 0x94000000, 0x3E000000, 0xED000000, 0xD7800000, 0x13C00000, 0xBE200000, 0x1CB00000, 0x4ED80000, 0x64840000, 0x59460000, 0xE2610000, 0x9D548000, 0x6E494000, 0x71E8A000, 0x779BF000, 0xF6E46800, 0x5C153C00, 0xA02C5E00, 0x6EB89100, 0x5ED6F580, 0x838F4EC0, 0x02CA8020, 0x2CAC4030, 0x83FA2008, 0x12B3B024, 0xDBD8480A, 0x2F078C25 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x48000000, 0xAC000000, 0xD2000000, 0xB3000000, 0x02800000, 0x38400000, 0x63E00000, 0x6F100000, 0x98E80000, 0x33840000, 0x31C60000, 0x5D270000, 0x7AB18000, 0xBD1A4000, 0xD9F96000, 0x726C9000, 0xB7C09800, 0x18209400, 0x55350200, 0xD6DDBF00, 0x7BDEC880, 0xE858AF40, 0xC99F8020, 0x0CB94030, 0xA20EE038, 0x2911D00C, 0x3DE87812, 0x2C06442B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xE8000000, 0xB4000000, 0x3A000000, 0x9F000000, 0x85800000, 0x3DC00000, 0x38E00000, 0x34F00000, 0x7A280000, 0x78840000, 0x4B420000, 0x96A30000, 0xD8D08000, 0x0ABF4000, 0x9F19A000, 0x6C4FD000, 0x8E31F800, 0xCB4DAC00, 0x77B12E00, 0x0889A700, 0x12559780, 0x7AF9D940, 0x5E3A8020, 0xA2584010, 0x03EB2018, 0xC2639004, 0xDCB0D83A, 0xF7093C2D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xC8000000, 0x54000000, 0xF2000000, 0x39000000, 0xE9800000, 0x44C00000, 0x59E00000, 0x5F100000, 0xE4B80000, 0xB6840000, 0x46420000, 0xDDA30000, 0x13B38000, 0x3A8E4000, 0xF2CEA000, 0x80699000, 0x195CC800, 0x9391CC00, 0xAFFEE600, 0x00A2AF00, 0xE0300880, 0x034E9DC0, 0x08A98020, 0x3EB94010, 0xEB872018, 0xF5C0D01C, 0x8463E832, 0x99D51C15 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x58000000, 0x8C000000, 0xEE000000, 0x7B000000, 0x28800000, 0xF4C00000, 0x94600000, 0xE2700000, 0x86280000, 0xE9840000, 0x05460000, 0xFD210000, 0xE1518000, 0x747AC000, 0x61786000, 0xF2FD7000, 0x0EB8D800, 0x5E1BC400, 0x700FE600, 0x98508300, 0x19F84380, 0x8E3AB940, 0x5EDF8020, 0xB66FC030, 0xB727E008, 0x4052B00C, 0x55FF3816, 0x40397423 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x78000000, 0x64000000, 0xF2000000, 0xEB000000, 0x0C800000, 0x79C00000, 0x6D200000, 0x6FB00000, 0x3DC80000, 0xB9840000, 0x10420000, 0x35610000, 0x66D38000, 0xBD1BC000, 0x659F2000, 0xF6599000, 0x44785800, 0xDD4CE400, 0x6E448E00, 0x20630900, 0x3F568D80, 0xBD5A4640, 0x78F98020, 0xFC8EC010, 0x1766A008, 0xC5D7501C, 0x8D9EF81E, 0xFA5BB419 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x18000000, 0x1C000000, 0x22000000, 0x87000000, 0xAC800000, 0x58400000, 0x2FE00000, 0xFAB00000, 0x50680000, 0x70440000, 0x6BE20000, 0xE4B10000, 0x456D8000, 0x43C4C000, 0x8322E000, 0xB1101000, 0x1739B800, 0x4599A400, 0xFB4C2200, 0x85576F00, 0x62DD6D80, 0xB42FA740, 0x8DA2E020, 0x2E501010, 0xB459B808, 0x5769A42C, 0x9CC42206, 0x13A36F07 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xD8000000, 0x34000000, 0xC2000000, 0x7B000000, 0x20800000, 0xA8C00000, 0x76E00000, 0x50500000, 0xCCF80000, 0xFCC40000, 0x84E60000, 0x13570000, 0x287F8000, 0x4E02C000, 0xBD07A000, 0xA1811000, 0x37445800, 0xE4A7C400, 0xC174E600, 0x08CDA700, 0xB3AD5A80, 0xE2BD63C0, 0x93E7A020, 0x05D11030, 0xD9BC5838, 0x9363C43C, 0xBD12E636, 0x875AA70D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x38000000, 0x04000000, 0x8E000000, 0x13000000, 0xA2800000, 0xBF400000, 0x2A200000, 0x4AD00000, 0x54480000, 0x23440000, 0xB0260000, 0x3FD70000, 0xE9C98000, 0x8C85C000, 0xBC462000, 0x60A37000, 0xF9911800, 0xCC6CD400, 0xF091DA00, 0xDBEB2100, 0x1251CE80, 0x6E083640, 0x6CE62020, 0x61337030, 0xD1F91838, 0x82F8D40C, 0x007FDA0E, 0x6F382101 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xF8000000, 0x94000000, 0x16000000, 0x47000000, 0x54800000, 0x46C00000, 0x0A600000, 0xED900000, 0xDD580000, 0x1AC40000, 0xA0660000, 0x70950000, 0x5CD88000, 0xA183C000, 0x6B42A000, 0x9325B000, 0x67B2B800, 0xD56D6400, 0xA7EA9600, 0x8E2AE300, 0x1CCA5480, 0x259BCEC0, 0x5BA2A020, 0x2B75B030, 0x520AB828, 0x33F96404, 0x7C34963E, 0xDB2BE325 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x88000000, 0x74000000, 0xA6000000, 0x41000000, 0x89800000, 0xA9C00000, 0xDAA00000, 0xFA700000, 0xF2280000, 0xCFC40000, 0xBBA20000, 0xE3F30000, 0x23EF8000, 0xE9604000, 0x93D1A000, 0xF6DE3000, 0x24A98800, 0x72860C00, 0x0347EE00, 0xF5E76500, 0xC5961B80, 0xDCBC3D40, 0x81F9A020, 0x891A3010, 0x770B8818, 0x15750C3C, 0x0EA86E22, 0x2987251D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xA8000000, 0x2C000000, 0x52000000, 0x5F000000, 0x76800000, 0x5A400000, 0xE3600000, 0xADF00000, 0x4A780000, 0x70440000, 0x18620000, 0xD5730000, 0xA5388000, 0x3EA14000, 0xE7536000, 0x2B299000, 0xB26E7800, 0xED88F400, 0xB13EB200, 0xA8A00B00, 0xA6535780, 0x40AE47C0, 0x69AB6020, 0x0E2D9010, 0xF7EC7818, 0xF34BF404, 0x471E322A, 0x38B54B0B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xE8000000, 0xE4000000, 0xDE000000, 0xBB000000, 0xE8800000, 0x24400000, 0x4BA00000, 0x7C300000, 0xFD680000, 0xC2440000, 0x8CA60000, 0xA6B70000, 0xE82D8000, 0xEC634000, 0x63512000, 0x02B9F000, 0x82BC5800, 0x42BA0400, 0xA2BB0200, 0x12BC2D00, 0xFAB9F980, 0x1EB84F40, 0xC0B92020, 0x7BBDF030, 0x933A5838, 0xB77D042C, 0xFCDE823A, 0x80EB6D39 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x98000000, 0x3C000000, 0x6E000000, 0x53000000, 0xB2800000, 0xFA400000, 0x50600000, 0x5ED00000, 0xCC080000, 0x80440000, 0x89620000, 0x8D530000, 0x89C98000, 0x53E0C000, 0xF313E000, 0xDBA87000, 0x98371800, 0x7A9B5400, 0x41293200, 0x86767300, 0x18FDAE80, 0x12FC9440, 0x33FBE020, 0xEC7C7010, 0x5FBD1818, 0xE31C540C, 0x45EAB226, 0xBA51B30F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xE8000000, 0x8C000000, 0x92000000, 0x17000000, 0x26800000, 0x9AC00000, 0xBE600000, 0x6BD00000, 0xFE880000, 0x5CC40000, 0xEF660000, 0xDC510000, 0xF3CA8000, 0xBFE34000, 0x8F926000, 0xCE2D9000, 0x2F763800, 0x9B387400, 0x519DB600, 0x7929E300, 0x99F7A680, 0xC9FF2040, 0x33FA6020, 0x68F99030, 0xFC783808, 0x21BD7414, 0x5159363A, 0x2C4FA323 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x98000000, 0x5C000000, 0x0E000000, 0xC5000000, 0xE0800000, 0x54400000, 0x59A00000, 0xB6900000, 0x09D80000, 0x41440000, 0x61220000, 0x1ED50000, 0x0E7A8000, 0xAAD0C000, 0xD478E000, 0x05D17000, 0xF3FEA800, 0xE212C400, 0x8798C200, 0xB7E77D00, 0xF031FC80, 0xF0CEFAC0, 0x3B5AE020, 0x9E047010, 0xBD042828, 0x4C820414, 0x92402226, 0x58A60D17 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x38000000, 0xFC000000, 0xEA000000, 0x61000000, 0x30800000, 0xCB400000, 0xF0A00000, 0xB0100000, 0x31580000, 0x72440000, 0xCC260000, 0x99550000, 0xF4FC8000, 0xDCD5C000, 0x4139E000, 0xA0365000, 0x12098800, 0x7FB94400, 0x4C773A00, 0xC12A1500, 0x396CE880, 0xA4481EC0, 0xA59FE020, 0x5E235030, 0x64550828, 0x1E7C8424, 0xDE96DA0E, 0x4518453F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xF8000000, 0x1C000000, 0x32000000, 0xEB000000, 0x73800000, 0x21400000, 0x7DE00000, 0x55B00000, 0x30880000, 0x42440000, 0x8A620000, 0xCAF10000, 0xDC6D8000, 0x6B73C000, 0xC62AE000, 0x0D149000, 0xE6D8D800, 0x96795C00, 0x342A6A00, 0x8612BF00, 0x055B9580, 0xFF3CC840, 0xADC8E020, 0xFDA59010, 0xECD55808, 0x25FA9C2C, 0x75688A3E, 0x6BF22F07 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x98000000, 0x1C000000, 0x5E000000, 0xAB000000, 0x85800000, 0x3CC00000, 0xA6600000, 0x23700000, 0xBC880000, 0xD3C40000, 0xC1E20000, 0x5AB70000, 0xFC6A8000, 0xCDF0C000, 0xA5CAE000, 0xF961F000, 0x8CF5D800, 0x414FEC00, 0xD1278600, 0x2AD10300, 0x101BA380, 0xE6FDB840, 0x27C8E020, 0xAC66F010, 0x12775838, 0x300B2C14, 0xCF876626, 0xEDC3F307 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x38000000, 0xC4000000, 0x6E000000, 0x59000000, 0x36800000, 0xB7C00000, 0xB5E00000, 0xC7900000, 0xC2F80000, 0x62C40000, 0xE1620000, 0x0B550000, 0x9A988000, 0xEF15C000, 0xE43C2000, 0xADA27000, 0x13304800, 0xB74D7400, 0xFA4F1E00, 0x7AC91F00, 0xE009D480, 0x256F53C0, 0xF03E2020, 0x1BA77010, 0x3E30C828, 0xC7CCB404, 0xE8893E0E, 0x53AA6F31 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x08000000, 0xF4000000, 0x12000000, 0x67000000, 0x01800000, 0xE8400000, 0xB9200000, 0xB6F00000, 0x5C680000, 0x4D440000, 0xE7A20000, 0x83310000, 0x9B0B8000, 0x3F944000, 0x9FBDA000, 0x69DD9000, 0x078EB800, 0x55574C00, 0x85586200, 0x654B9900, 0xBBB4EF80, 0x9BCE9F40, 0xBE77A020, 0x74A89010, 0x48A73808, 0x16B20C1C, 0x314E4202, 0x99B2493D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x88000000, 0x54000000, 0x96000000, 0x31000000, 0x7F800000, 0xFEC00000, 0x91200000, 0x85500000, 0x24C80000, 0xBDC40000, 0xF1A20000, 0x99150000, 0xAEAE8000, 0x2C704000, 0x4D98A000, 0xA30DB000, 0xE7610800, 0x6C30BC00, 0x45FED600, 0x35BEF900, 0xC5DD4280, 0x5F6FCA40, 0x37D2A020, 0xF78CB010, 0x5D258828, 0x2F51FC34, 0xA7CAF622, 0x3D460915 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x68000000, 0x3C000000, 0x52000000, 0xF7000000, 0x69800000, 0x66400000, 0x91600000, 0x20B00000, 0x52580000, 0xF7440000, 0xB1E60000, 0xF2710000, 0x5FF98000, 0x4F574000, 0xAD2FE000, 0x2A3F9000, 0x93743800, 0x377F0C00, 0x91965200, 0x9A8ADB00, 0x59291D80, 0xB4392EC0, 0x7E71E020, 0xA5FA9030, 0xA453B808, 0xA6AD4C0C, 0xD37E321A, 0x57970B0F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xA8000000, 0xEC000000, 0xB6000000, 0x95000000, 0xEF800000, 0x61C00000, 0x55200000, 0x90700000, 0xC3480000, 0x36C40000, 0xFDA60000, 0x41370000, 0xE32B8000, 0xACD14000, 0x2FF96000, 0x332EB000, 0x54D52800, 0xFBFB3C00, 0xB12CEE00, 0x33D3D900, 0xDB7B0B80, 0x1C6B3640, 0x7DB76020, 0x906DB030, 0x7BB0A838, 0x4D697C1C, 0x08300E2A, 0x32AF293B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xD8000000, 0xD4000000, 0x2A000000, 0xD3000000, 0x62800000, 0xCBC00000, 0x59E00000, 0x64500000, 0x07F80000, 0x89440000, 0x62220000, 0x45B50000, 0x07AD8000, 0x7CBAC000, 0xEC60A000, 0x6F165000, 0x5ADE1800, 0x40745400, 0x3F4C3E00, 0xDD6C3F00, 0xD8DF6A80, 0x7F7073C0, 0xB3CD2020, 0x87AC9010, 0x3CBEB828, 0x4C62042C, 0xDF122636, 0x82D86B35 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x48000000, 0x84000000, 0x76000000, 0x03000000, 0xA1800000, 0x00400000, 0x0CA00000, 0x46F00000, 0xFD480000, 0x85C40000, 0x6AE20000, 0x51530000, 0xE6398000, 0xC2CE4000, 0x12822000, 0xA9C2B000, 0xE8E29800, 0x0C56CC00, 0xF0BE6200, 0x5D0BF500, 0x99679F80, 0x3413FE40, 0x501BA020, 0xD9FCF010, 0x5928B818, 0x97507C0C, 0xED3EFA12, 0x874E3921 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xE8000000, 0x14000000, 0x22000000, 0x8D000000, 0x19800000, 0xF7C00000, 0x69200000, 0x14700000, 0x78980000, 0xAA440000, 0xF4E60000, 0x94530000, 0xAF688000, 0x541B4000, 0x1802A000, 0x2C041000, 0xBE07E800, 0xAB070C00, 0x5E805E00, 0x7742F900, 0xA565DB80, 0x079760C0, 0x1C4A2020, 0x316F5030, 0x4F1D4818, 0xDE871C04, 0xB741B63A, 0xC566F505 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x58000000, 0x4C000000, 0x2E000000, 0x59000000, 0x57800000, 0x2B400000, 0x14A00000, 0xB4100000, 0x3AC80000, 0x32C40000, 0xD6E60000, 0xDF310000, 0xE19A8000, 0x26AEC000, 0x6B306000, 0x139E7000, 0x29AD4800, 0x79B0FC00, 0x195EFA00, 0x034C3500, 0xA0845880, 0xE5C60240, 0x4862E020, 0xDBF4B030, 0xC27B2808, 0xF01F8C14, 0xF0E93216, 0x62120913 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x68000000, 0xCC000000, 0xAE000000, 0x27000000, 0xF7800000, 0x98C00000, 0xA7A00000, 0x5FB00000, 0xDBA80000, 0x09440000, 0x64620000, 0xE9910000, 0x07DF8000, 0x44CF4000, 0x41506000, 0xA87E7000, 0x077BB800, 0xACFD7C00, 0x223EE600, 0xF69EAD00, 0x54AD7580, 0x52C5F940, 0x82A7E020, 0xF1353010, 0x0BE9D808, 0x65A20C3C, 0x66B2DE1A, 0x43289133 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x68000000, 0xDC000000, 0x96000000, 0xB9000000, 0x1C800000, 0x0F400000, 0xEFA00000, 0x80300000, 0xBA680000, 0xDDC40000, 0xADE20000, 0x59130000, 0xAA1D8000, 0x458F4000, 0x3FD0E000, 0x387DB000, 0xF85F4800, 0x64A82400, 0x4BA0DA00, 0x3231AD00, 0xF168B980, 0xEA44DF40, 0x25256020, 0x5676F010, 0xF94DA818, 0x3AB6942C, 0x242A121A, 0x92E2C937 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x38000000, 0xD4000000, 0x16000000, 0xD9000000, 0x6A800000, 0xE9400000, 0x73200000, 0xE1700000, 0xA1B80000, 0x71C40000, 0xDD620000, 0x3DD50000, 0x690A8000, 0x691DC000, 0x4F70A000, 0xECBFB000, 0xAD454800, 0xBD221400, 0x1C752A00, 0xB53F0900, 0xAD84B380, 0x06C431C0, 0xFAE22020, 0x08167010, 0x7A6FE828, 0xA9CCA414, 0x32F8E20E, 0x59E5DD35 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x88000000, 0xD4000000, 0xCE000000, 0xFB000000, 0xB8800000, 0xC3400000, 0xA4E00000, 0xE8500000, 0x8AB80000, 0x69C40000, 0x46A60000, 0xA1330000, 0xB22A8000, 0xB4584000, 0x7494A000, 0xEF9B7000, 0xE3325800, 0x1B2D0400, 0x8DDBFA00, 0x6A557700, 0x43BFAA80, 0x004569C0, 0xD0662020, 0xD9173030, 0x9F58F818, 0x84117414, 0x98DD2222, 0xD9D73335 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x08000000, 0x9C000000, 0x32000000, 0xEB000000, 0xA0800000, 0xC1400000, 0x1F600000, 0xC2700000, 0xC7E80000, 0x37C40000, 0x83260000, 0x90950000, 0xF15E8000, 0x5F8C4000, 0x7F36E000, 0x5A8A9000, 0x66B0D800, 0xA04DC400, 0xC013AA00, 0x281D0B00, 0x74E99B80, 0xC3440340, 0x4C606020, 0x86F2D030, 0x70A83828, 0x65A65434, 0xA4D3F202, 0xEFBD8F27 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0xF8000000, 0x14000000, 0x32000000, 0x1D000000, 0xA2800000, 0x60400000, 0xA4200000, 0x07F00000, 0x93080000, 0xFFC40000, 0xF6E20000, 0xEB970000, 0xECD98000, 0xB53BC000, 0xA12EA000, 0x6F309000, 0x2E6C6800, 0xD4905400, 0x3B5FE200, 0x4BF8D100, 0x8B4E6780, 0x0FE63440, 0x23152020, 0x559C5010, 0x499B4838, 0x379B040C, 0xDC9D2A3E, 0x99181505 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x78000000, 0x6C000000, 0x1E000000, 0x55000000, 0x77800000, 0x3CC00000, 0xCC200000, 0xD9100000, 0x51E80000, 0xCE440000, 0x4F620000, 0x9DF50000, 0xC6DF8000, 0x75BFC000, 0x9E4D6000, 0x4993F000, 0xB1AA2800, 0x4C26FC00, 0x9914C600, 0xF1EB3100, 0x3E447080, 0x3762AB40, 0xF1F0E020, 0xD8D93010, 0x20B8C828, 0xE9CACC3C, 0x75538E1E, 0x7D8E3D1B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x48000000, 0x4C000000, 0xE2000000, 0x0D000000, 0x44800000, 0x29400000, 0x03200000, 0xB8D00000, 0xEBE80000, 0xC8C40000, 0xD2E60000, 0x58B30000, 0x21198000, 0x757E4000, 0x99886000, 0xE7361000, 0x37DCE800, 0xA09EE400, 0x94BAEA00, 0x31EE2900, 0x61C05E80, 0x6864C340, 0xE6F7E020, 0x6FBB5030, 0x0E6D0818, 0xB706B40C, 0xDD866212, 0xDBC2DD13 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x58000000, 0x54000000, 0x06000000, 0x61000000, 0xD0800000, 0x2DC00000, 0x96A00000, 0x59D00000, 0x07B80000, 0x88440000, 0x8DE60000, 0x93B10000, 0x70498000, 0xF7EEC000, 0xC6B8A000, 0xA8C33000, 0xD8258800, 0x6114C400, 0x77988E00, 0xC550E500, 0x987D5680, 0x69E081C0, 0x0DB72020, 0x654CF030, 0x116CA808, 0xD27D340C, 0xBAE3A616, 0xAA361115 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x88000000, 0x54000000, 0xFA000000, 0x37000000, 0x21800000, 0x60C00000, 0x30200000, 0x91300000, 0x1BB80000, 0x92440000, 0x43620000, 0x42D70000, 0x51298000, 0xC7084000, 0x8F3CA000, 0x9806D000, 0x4C053800, 0xF603CC00, 0x21046600, 0x3080B100, 0xD8404180, 0xBC67B9C0, 0xD7572020, 0xFBE99010, 0x48281838, 0x6B895C0C, 0x197FFE22, 0xD962AD15 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xE8000000, 0x2C000000, 0xCE000000, 0xDF000000, 0x74800000, 0xA0400000, 0x10A00000, 0x19F00000, 0x28880000, 0x4FC40000, 0xE6660000, 0x18150000, 0xDA5A8000, 0x427B4000, 0x1DCB6000, 0x76E17000, 0xCA577800, 0x93FB6400, 0x8C0DA200, 0xC782D500, 0x7AC22780, 0x9FE5E840, 0xC5D7E020, 0x553F3030, 0x95EE9828, 0xA1555414, 0x7D7FBA3A, 0x5949C10B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x08000000, 0x24000000, 0x0A000000, 0xBD000000, 0x75800000, 0xFBC00000, 0xAA600000, 0xF9100000, 0x1BC80000, 0x3F440000, 0x1A260000, 0xC7B30000, 0x1C3D8000, 0x75DC4000, 0xFC0B2000, 0x73215000, 0x10356800, 0xAEFD6C00, 0x183F3E00, 0x6FDE6300, 0x990A5080, 0x9AA24A40, 0xCDF0A020, 0x979E1030, 0x23ABC818, 0x47547C2C, 0x826F7602, 0x28355F09 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0xB8000000, 0x4C000000, 0x26000000, 0xB7000000, 0x86800000, 0x64C00000, 0xCD600000, 0xDE700000, 0xA2280000, 0x71440000, 0xDD260000, 0xDAD70000, 0x8EBC8000, 0xAC59C000, 0x4B686000, 0x90643000, 0x09F03800, 0x176A7400, 0xCE640600, 0x12F6FB00, 0x27EF1B80, 0xA5A52D40, 0x1512E020, 0xBB5AF030, 0x7DECD838, 0x3CA38424, 0xA0925E2E, 0x1B1BBF13 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xE8000000, 0xB4000000, 0x22000000, 0x45000000, 0xED800000, 0x25400000, 0xA1600000, 0xA8100000, 0xEE480000, 0x9BC40000, 0xCEA60000, 0x64B70000, 0x1FF98000, 0xB1BB4000, 0x065FA000, 0x558C1000, 0x8566A800, 0x7210AC00, 0x274D4A00, 0x38437B00, 0xD0E29880, 0xFB518640, 0x18282020, 0x73545030, 0x5C2E8838, 0x5954FC0C, 0x9D2BC23A, 0x7ED3872D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xD8000000, 0x94000000, 0x52000000, 0x49000000, 0x7E800000, 0xFA400000, 0x35E00000, 0x45700000, 0xF6780000, 0x5BC40000, 0x82260000, 0x11570000, 0xF4298000, 0xE46AC000, 0xFC8EA000, 0xAD7F9000, 0x4C46C800, 0xD6E5B400, 0x36F33200, 0xC8B8DF00, 0x91649380, 0x4A363FC0, 0x43192020, 0x5BF65030, 0xFC3FE838, 0x5623E40C, 0x6354DA36, 0x6D2F3B25 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x18000000, 0x1C000000, 0xAE000000, 0x8F000000, 0x90800000, 0x7BC00000, 0x4EE00000, 0xBC300000, 0xC0380000, 0x1E440000, 0xC0A20000, 0xC4970000, 0xA8AA8000, 0x50ECC000, 0x1B4EE000, 0xFD5C7000, 0x0F37F800, 0x0EBBC400, 0x42827E00, 0x4AC7A700, 0xA963C980, 0x1B71EDC0, 0x431E6020, 0x7F93B010, 0x82299838, 0xEE287414, 0xA82BE606, 0x932FD307 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x28000000, 0xB4000000, 0x22000000, 0xA7000000, 0x0B800000, 0xF3C00000, 0x64200000, 0x7B700000, 0xD5880000, 0x74240000, 0x33720000, 0x91890000, 0xAE228000, 0x08734000, 0x0C0CA000, 0xD8E39000, 0xC0D67800, 0x8F3CFC00, 0x9A8C0E00, 0xABA15900, 0x12B52780, 0xAAAFA240, 0x42D67820, 0xB83CFC10, 0x990C0E08, 0x3C615934, 0x7C95278A, 0xC2DFA26D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x38000000, 0x54000000, 0x4E000000, 0x17000000, 0x6A800000, 0x6B400000, 0xA2A00000, 0x80B00000, 0x06280000, 0xDAA40000, 0x34B60000, 0xD8290000, 0x45A18000, 0x3237C000, 0xA96BA000, 0xBE03F000, 0xCF077800, 0xAE80F400, 0xAD44AA00, 0xD9A46D00, 0xF035F180, 0x34691B40, 0x05877820, 0xB5C0F430, 0x17E4AA08, 0xBD146D2C, 0x801DF18E, 0xADCD1B55 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x18000000, 0xE4000000, 0xF2000000, 0x85000000, 0x0E800000, 0xB1C00000, 0xF5200000, 0x9C100000, 0x05E80000, 0x3D240000, 0x30160000, 0x9BEB0000, 0x46238000, 0xB596C000, 0xB7AC2000, 0x7B441000, 0xE6E2E800, 0x64345400, 0x9B7D9E00, 0x870F4100, 0x6B11B480, 0x4E6F3140, 0xE262E820, 0x84F45430, 0xEADD9E18, 0x3BDF413C, 0x7F59B486, 0x3F9B3179 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0xDC000000, 0xE6000000, 0x89000000, 0x74800000, 0xA8400000, 0x7B200000, 0xB2100000, 0xB8B80000, 0x47240000, 0x44120000, 0x09BB0000, 0xBFA68000, 0x5250C000, 0x279DE000, 0x9F31B000, 0xCBAC8800, 0x6F1A4400, 0xC176F200, 0x018C5100, 0x258D5480, 0x6F89F7C0, 0x688C8820, 0x410A4410, 0xFFCEF218, 0x9FA85114, 0x4D1F5496, 0x1272F7F7 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xE8000000, 0xB4000000, 0x02000000, 0xF1000000, 0xA4800000, 0x50C00000, 0x73A00000, 0xB0500000, 0x68180000, 0xB7A40000, 0x1A520000, 0xCD1F0000, 0xE1238000, 0x53954000, 0xAE3AA000, 0x03B39000, 0xB92AC800, 0x0D4B8400, 0x213B1600, 0xB0325500, 0x466F8680, 0xD7AA16C0, 0x488AC820, 0x0C1B8410, 0x0DA31638, 0xA756553C, 0xC79D86BA, 0x1EE516ED } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x68000000, 0x7C000000, 0xA2000000, 0x69000000, 0x63800000, 0x24400000, 0x18600000, 0x55500000, 0x9FF80000, 0x5C640000, 0xD3520000, 0xE0FD0000, 0xF8E78000, 0x37914000, 0xAA5EE000, 0x50129000, 0xA81A0800, 0x4771FC00, 0x31CDB200, 0x4049CB00, 0x850FD680, 0x52E88DC0, 0x99FA0820, 0x6361FC10, 0xD7D5B228, 0x743DCB1C, 0xDA45D69A, 0xE3618DDF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x18000000, 0xDC000000, 0x16000000, 0x1F000000, 0x3A800000, 0x55C00000, 0x9E200000, 0x72D00000, 0x4C980000, 0x10240000, 0x71D60000, 0x801F0000, 0xEAE18000, 0xCD76C000, 0x7B09E000, 0x2E593000, 0xB0823800, 0x7CC63400, 0xEBA09E00, 0xB5914900, 0x437C6280, 0x36D29AC0, 0x469A3820, 0xF9223430, 0xE4569E38, 0xF75E492C, 0xFD05E286, 0x37805AF7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xE8000000, 0xE4000000, 0x7A000000, 0xB3000000, 0xD6800000, 0x93C00000, 0x16200000, 0x79900000, 0x43780000, 0x24240000, 0x7E920000, 0x17FB0000, 0x78E78000, 0xC8354000, 0xD0AC2000, 0x323C5000, 0x63C4D800, 0xBE209400, 0xFD97CE00, 0x4979E900, 0x7F211880, 0x4C1075C0, 0xFE3CD820, 0xDDC49410, 0x6725CE18, 0x0012E91C, 0x003E98BA, 0x64C135F9 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xB8000000, 0xC4000000, 0xCA000000, 0x89000000, 0xA9800000, 0x50C00000, 0x81600000, 0x6D500000, 0xF1C80000, 0x0F640000, 0xEE560000, 0x714D0000, 0x46218000, 0x87F3C000, 0x597B2000, 0x10BFD000, 0xF05B8800, 0x11CC6C00, 0xDF665600, 0x46530300, 0xBD4D4680, 0xF0213840, 0x00F38820, 0xB3F86C30, 0x60F85628, 0x887A032C, 0xAD3AC6AE, 0xC29FF871 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xA8000000, 0x8C000000, 0x6E000000, 0x4F000000, 0x09800000, 0x43400000, 0x83E00000, 0xA5B00000, 0xDD580000, 0x11E40000, 0x3CB60000, 0x9FD90000, 0x69228000, 0x75134000, 0x730D6000, 0x3509F000, 0x360D3800, 0x718F2C00, 0xADCCEA00, 0x8FAEA700, 0xE559C180, 0xD5E320C0, 0x2EB53820, 0xC6DB2C30, 0x0BA2EA08, 0xDDD3A734, 0x92AD41AA, 0x55D960E3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x48000000, 0x24000000, 0xBE000000, 0xA7000000, 0xDA800000, 0x5A400000, 0x94200000, 0xFF300000, 0x12D80000, 0xD6240000, 0x9A360000, 0x6D5B0000, 0x93E18000, 0xFBD44000, 0xBB8A2000, 0x73EC7000, 0x73FD7800, 0x0E96F400, 0x712FA200, 0xB8995900, 0xAA05CD80, 0x9101D4C0, 0x39857820, 0x8EC2F430, 0x2161A218, 0x9596592C, 0x09AA4D92, 0xF7DA94C9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xF8000000, 0xF4000000, 0x9A000000, 0x41000000, 0xF4800000, 0xA4400000, 0x56600000, 0x97700000, 0x81980000, 0xD7640000, 0x03F20000, 0x75D90000, 0x09078000, 0x9885C000, 0x9A46A000, 0x05675000, 0x2EF5C800, 0xBF580400, 0xFE45F200, 0x7762BB00, 0x33F21F80, 0xADDAAEC0, 0x8D07C820, 0xFA810410, 0x2F427208, 0x6BE77B1C, 0xCBB4BFBE, 0x1DBDFEFD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xA8000000, 0x94000000, 0xAE000000, 0xBF000000, 0x9B800000, 0x71400000, 0xFBA00000, 0x33D00000, 0x51D80000, 0xDCA40000, 0xF4560000, 0xCA9D0000, 0xEE078000, 0xDF034000, 0x4B81A000, 0xA946F000, 0xC7A0B800, 0x09D07C00, 0x40DEFA00, 0xF8262500, 0x1E934280, 0x407C04C0, 0x2676B820, 0xBD0D7C30, 0xC6F97A28, 0x81B5651C, 0xF96AE2AA, 0x2D4EF4E5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x88000000, 0xBC000000, 0x46000000, 0x65000000, 0x02800000, 0xCB400000, 0x90A00000, 0x4FF00000, 0xE6280000, 0xCDA40000, 0xA9720000, 0xFF6D0000, 0x52008000, 0x4F064000, 0x0980E000, 0x80C6B000, 0x97676800, 0xCD15F400, 0x7DFC6A00, 0xCA3BAD00, 0x10DC6B80, 0x1F0A6B40, 0x72956820, 0x6038F410, 0x5BDCEA28, 0xF48DED24, 0xE5548BA2, 0x6AD8DB6F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x58000000, 0x8C000000, 0xE2000000, 0xC7000000, 0xB8800000, 0xB4400000, 0x70A00000, 0x5BF00000, 0xF3C80000, 0x43A40000, 0xFD720000, 0x9A8D0000, 0xF0858000, 0x1040C000, 0xE6A16000, 0xC2F69000, 0x364CF800, 0x0465A400, 0x6310B200, 0xC298BD00, 0x909A9B80, 0x4F9EFC40, 0xDB1EF820, 0xBD58A410, 0x52FD3228, 0x3D8C7D0C, 0x9801FB96, 0x6C016C63 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x48000000, 0xF4000000, 0xA6000000, 0x9D000000, 0xC3800000, 0xB8C00000, 0xF4A00000, 0x84B00000, 0x87A80000, 0xE5A40000, 0xED360000, 0xC8690000, 0x05868000, 0x95C44000, 0x0F26A000, 0xD077B000, 0x690EA800, 0xAE15BC00, 0x921EF600, 0xCB8E4D00, 0x6752B980, 0x957CBB40, 0xFD18A820, 0xA30CBC30, 0xE9107608, 0xBE9E0D14, 0xDBCA1992, 0x3DB60B7D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x98000000, 0x4C000000, 0xDE000000, 0xE1000000, 0xBF800000, 0x36C00000, 0x7CA00000, 0x2CD00000, 0xEA880000, 0xC3A40000, 0xB2560000, 0xC3CD0000, 0x39C18000, 0x7A22C000, 0x49976000, 0xCEEB7000, 0xEAD7C800, 0x87899C00, 0x02264600, 0xD5976D00, 0x98ED5A80, 0x6FD50240, 0x3209C820, 0x47E09C30, 0x29B1C628, 0xDC78AD2C, 0x70BBBAA6, 0x971CB253 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x68000000, 0xFC000000, 0x46000000, 0x7F000000, 0x68800000, 0xCFC00000, 0x3EA00000, 0xBC900000, 0x6D980000, 0x67A40000, 0xFB160000, 0x32D90000, 0xB2C18000, 0xAB254000, 0x26D6E000, 0xE97FB000, 0xEFD4B800, 0x76FAA400, 0x24914E00, 0x19998D00, 0x4DA0E080, 0x1A1172C0, 0xB15AB820, 0xAF87A430, 0x6346CE08, 0xB365CD2C, 0x9F37809A, 0x148B82FF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0xE8000000, 0x1C000000, 0x16000000, 0xA3000000, 0x28800000, 0x8CC00000, 0xB4A00000, 0xC8F00000, 0xC7480000, 0xD1A40000, 0x8B760000, 0x0F0F0000, 0x87C08000, 0xA0214000, 0x2237E000, 0xA8EC3000, 0xC5D65800, 0xCAFFA400, 0xDF0FD600, 0x4FC63D00, 0xCC214380, 0x4C313C40, 0xFFE85820, 0xE754A430, 0xF3395638, 0xE0287D24, 0x237623BA, 0x330C4C47 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xC8000000, 0x0C000000, 0x4E000000, 0xC3000000, 0xF5800000, 0x0B400000, 0x68E00000, 0xFB500000, 0x99180000, 0xA9E40000, 0xA3D60000, 0xF4DF0000, 0x47C18000, 0xFF204000, 0xBC776000, 0x016FF000, 0x5A8C5800, 0xBC5DCC00, 0x72072A00, 0x8501DF00, 0xDA84B680, 0x00C732C0, 0x68A25820, 0x6A36CC30, 0x2708AA38, 0x9B1A9F2C, 0x04E456B2, 0xC55782C3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x68000000, 0x14000000, 0x86000000, 0x8F000000, 0x3A800000, 0x7E400000, 0xA0200000, 0xE5F00000, 0xB1F80000, 0xEAA40000, 0x33B60000, 0xE5DF0000, 0x79538000, 0x654D4000, 0x21FBA000, 0xB2A1B000, 0xAFB63800, 0x87D9F400, 0x18570200, 0xC4CC9900, 0xE3396B80, 0xE3C3B5C0, 0xD0E5B820, 0xAD94B430, 0xE32CA238, 0xF82D293C, 0x84AF539A, 0x95EA41C5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x48000000, 0x4C000000, 0x2A000000, 0xDD000000, 0x49800000, 0xBEC00000, 0x55600000, 0x8A300000, 0x12680000, 0xF4E40000, 0xC8F60000, 0x550F0000, 0x37D08000, 0xBD1C4000, 0xA4296000, 0x14C7D000, 0x4865A800, 0x23B3AC00, 0x3CAA6600, 0xE9806300, 0x0EC32D80, 0x6D65DD40, 0x1E352820, 0x3C6FEC30, 0x4FE30638, 0x7677B324, 0x7F4E8592, 0x95F27153 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xA8000000, 0xBC000000, 0x6A000000, 0x6D000000, 0x95800000, 0xC9C00000, 0x90200000, 0x4B900000, 0xF8C80000, 0x1DA40000, 0x86520000, 0x76EB0000, 0xBD368000, 0x441F4000, 0xE60AE000, 0x9D07D000, 0x4D872800, 0xEDC0CC00, 0xBE22DE00, 0x58974900, 0xD6484080, 0x46E5B040, 0x2731A820, 0xF11F8C10, 0x57883E18, 0x7AC09914, 0xCEA768AA, 0x88D17C6F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x48000000, 0x7C000000, 0x5A000000, 0x2B000000, 0xFC800000, 0xA1C00000, 0x8CE00000, 0xA7900000, 0x99A80000, 0x8C640000, 0x9C560000, 0xDE4F0000, 0x67718000, 0xEC3C4000, 0xA2C8E000, 0x06B55000, 0x80DA1800, 0xB55A8400, 0xD71A1E00, 0x70B99F00, 0x730B6880, 0x22508B40, 0xEB4B9820, 0x3EF6C430, 0x0C7AFE38, 0x4A68CF2C, 0x27877092, 0x35450F5F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xF8000000, 0xA4000000, 0x7E000000, 0x71000000, 0xC7800000, 0xB5C00000, 0x54200000, 0xA1B00000, 0xA4580000, 0xE7A40000, 0x22720000, 0x7D7D0000, 0xAB938000, 0xC4EDC000, 0xDC7C2000, 0x24127000, 0x8D2B4800, 0xA25D9C00, 0x72A01E00, 0x3BF4C900, 0x49BF6180, 0xC034B4C0, 0x7498C820, 0x52005C10, 0x13043E28, 0xCC82B93C, 0x8D4629BE, 0xAF6428E9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x88000000, 0xD4000000, 0x46000000, 0x63000000, 0x1C800000, 0x3CC00000, 0xB4E00000, 0x77F00000, 0x58780000, 0xA4640000, 0x11320000, 0x3D990000, 0x3A128000, 0x820E4000, 0xD95BA000, 0x92F2B000, 0x47FC5800, 0x7425C400, 0xC1131600, 0xA28D5F00, 0x879D4B80, 0x5B104DC0, 0x138ED820, 0x9E1B8410, 0xC850B608, 0x0F2BEF34, 0xB5CB13A2, 0x153889F5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xB8000000, 0xCC000000, 0x1A000000, 0x09000000, 0x18800000, 0x70400000, 0x7CA00000, 0xC0100000, 0x89B80000, 0x86240000, 0x55560000, 0xA79F0000, 0x37718000, 0xCCCBC000, 0x47ED6000, 0x843F5000, 0x3CE08800, 0xC4B22400, 0x65AC1200, 0xA5998D00, 0x6277B480, 0x264837C0, 0xFAA90820, 0x8E1DE430, 0x53B77238, 0x3A29DD2C, 0x425EBCAE, 0x6D15D3F3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xB8000000, 0x84000000, 0xB2000000, 0x29000000, 0xCF800000, 0x0D400000, 0x57200000, 0x45900000, 0x2E880000, 0xB2A40000, 0x55D60000, 0x1C2D0000, 0x27778000, 0xE9FBC000, 0x4B5D2000, 0x768C1000, 0x26A38800, 0x8FD2DC00, 0x792EBA00, 0x66F59100, 0xFBBE2080, 0x48F8E640, 0xD8DC0820, 0x9DCD1C30, 0x22859A28, 0x10C4811C, 0xA36228AE, 0x1535FA61 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0x34000000, 0x3A000000, 0x0D000000, 0x7F800000, 0xBB400000, 0x09A00000, 0xD8700000, 0x37080000, 0xB8240000, 0x74320000, 0x5C2B0000, 0xDC978000, 0xCDDA4000, 0x3BDEA000, 0x70DC5000, 0x6C5D2800, 0xEF9CDC00, 0x27FACA00, 0x06EF4500, 0x61738F80, 0x328EBA40, 0x6E62A820, 0x72129C10, 0x371E6A18, 0xD63C151C, 0x978B2782, 0x75E3264D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x68000000, 0x3C000000, 0xBA000000, 0xBF000000, 0x9A800000, 0xD9400000, 0x5C600000, 0x41100000, 0x5F680000, 0xA8E40000, 0x61560000, 0xFC8B0000, 0x65378000, 0x499D4000, 0xAC5EE000, 0xFC7C5000, 0xBC8FB800, 0xC537B400, 0x599EDA00, 0xB4593B00, 0xA8782C80, 0x3A8FB940, 0xC0303820, 0x7C1EF430, 0xF79E3A18, 0x2D5A6B1C, 0x27FE149A, 0xDE4A4D4F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x28000000, 0x4C000000, 0xDA000000, 0xD3000000, 0xAD800000, 0xD1C00000, 0x6FA00000, 0xB8300000, 0xF1B80000, 0x9C240000, 0x9CF60000, 0x629D0000, 0x3F528000, 0xC0AF4000, 0xBDEB6000, 0x210A5000, 0xD8D8D800, 0x60368C00, 0x85BC9E00, 0x82214500, 0x09F5DD80, 0xEE1F6BC0, 0xDC125820, 0x094DCC30, 0x68B9FE28, 0xAAA21534, 0xDCB1858A, 0xFEFFA7D3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xD8000000, 0x0C000000, 0xEE000000, 0x9D000000, 0xF2800000, 0x18C00000, 0xD4E00000, 0xF3700000, 0x11E80000, 0xDB640000, 0x29360000, 0xF5C90000, 0xF8F28000, 0xF1A8C000, 0x40456000, 0x8B27F000, 0x5A132800, 0x73D97400, 0xBD2D7600, 0xDD802F00, 0x81407F80, 0x8FA32140, 0xF3D7A820, 0x6BB8B430, 0x139A9608, 0xE60F1F34, 0x5F9637B6, 0xFE9DA543 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x08000000, 0x5C000000, 0xF6000000, 0x69000000, 0x0F800000, 0x59C00000, 0x22600000, 0x6EF00000, 0x73280000, 0xB4E40000, 0x10B60000, 0x048F0000, 0xB6718000, 0x306E4000, 0x66C1E000, 0xD4E43000, 0x60B40800, 0xEC8F1C00, 0x5A713E00, 0xCE6EBB00, 0x53C7BB80, 0x2D619F40, 0x50738820, 0xC16E5C30, 0x6D415E38, 0x9F24CB2C, 0x89D25382, 0x4EFAB357 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xD8000000, 0x2C000000, 0xFA000000, 0x03000000, 0xCE800000, 0x31C00000, 0xFF600000, 0xB4F00000, 0x5C080000, 0x0AE40000, 0xF7B60000, 0xD0AB0000, 0x3E768000, 0xF3C8C000, 0x98866000, 0x08C35000, 0x52E5D800, 0x1BB59400, 0x4AA89E00, 0x6D728300, 0xE54A0380, 0x85447640, 0x0DA55820, 0xE5165430, 0x89387E18, 0x71891314, 0x65A1BBB6, 0x8116B24B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x78000000, 0xC4000000, 0xF2000000, 0x9F000000, 0x74800000, 0x87C00000, 0x18200000, 0xFA700000, 0x0A080000, 0x3BA40000, 0x75360000, 0xC3EB0000, 0x84F58000, 0x16CDC000, 0xC5012000, 0xA7801000, 0xDD443800, 0x06E40400, 0x83D06E00, 0x583A1900, 0x28CFE780, 0xB4029640, 0x2A07B820, 0x0B02C430, 0xCE84CE18, 0xA4C7C90C, 0x5AA2FF9E, 0x10B28271 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x48000000, 0xBC000000, 0xAE000000, 0x01000000, 0x19800000, 0xFCC00000, 0xC7600000, 0x8BF00000, 0xCA180000, 0x67E40000, 0xEAB20000, 0x9BBB0000, 0x20768000, 0xE9D84000, 0xC002E000, 0x2005F000, 0x30014800, 0x1807AC00, 0xF400D600, 0x1203D300, 0xAF01E380, 0x1881BEC0, 0xE545C820, 0x3BA4EC10, 0x4C94B618, 0x41EE6314, 0xADFA4B92, 0x8D57E2EF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x08000000, 0x84000000, 0xAE000000, 0x89000000, 0xEA800000, 0xBB400000, 0xB0A00000, 0x32500000, 0xD5080000, 0x67240000, 0x75960000, 0xABEF0000, 0xBD508000, 0x828E4000, 0xE0E72000, 0xEB77F000, 0xE19B0800, 0x424BF400, 0x4D82EA00, 0x18C4ED00, 0x01603680, 0xA9B3FA40, 0x5FFD8820, 0x047AB430, 0x69BD4A38, 0x30595D24, 0x89AA1E82, 0x2F70FE61 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x98000000, 0xB4000000, 0xBE000000, 0xE3000000, 0x0E800000, 0xA9400000, 0x9F600000, 0xD4300000, 0x8B180000, 0x2EE40000, 0xF1F60000, 0xEC390000, 0x52328000, 0xCC1AC000, 0x2660A000, 0xDFB57000, 0x5BDAD800, 0x78475400, 0x68E27A00, 0x96F74300, 0x34BDA580, 0xE476CAC0, 0xCFFE5820, 0xB2149430, 0x98485A08, 0xE5CCF334, 0x3A09DDA6, 0x4829EEED } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x38000000, 0xFC000000, 0x42000000, 0x47000000, 0xDD800000, 0x8C400000, 0xA3E00000, 0xBFD00000, 0xD8F80000, 0x1B640000, 0xB9120000, 0xF2DF0000, 0x27168000, 0x07DBC000, 0x3594E000, 0xC21A9000, 0x9C30F800, 0x27298C00, 0x239CB200, 0xF2744700, 0x73CDC280, 0x29CEFDC0, 0x62CC7820, 0x75494C10, 0x2A0CD238, 0xD26A1714, 0x18FF5A8E, 0xBB6621FF } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x48000000, 0x94000000, 0x2E000000, 0x45000000, 0x06800000, 0x67C00000, 0xB8E00000, 0x4AD00000, 0x1AE80000, 0xE5640000, 0x96920000, 0xEF490000, 0x52928000, 0xC9484000, 0xA391A000, 0x31CDF000, 0xC9556800, 0x1BA81400, 0xCA450E00, 0xFCA7CF00, 0x63705280, 0x171BE140, 0xD1BDE820, 0x99CD5410, 0xED542E08, 0x8DAB7F34, 0x83461A92, 0x08264565 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xD8000000, 0x54000000, 0x1A000000, 0xE9000000, 0x34800000, 0xC2400000, 0x2B200000, 0x98B00000, 0x22880000, 0x14A40000, 0xA3760000, 0x8D6B0000, 0xD0728000, 0x90E8C000, 0x46B5A000, 0xA9885000, 0x2D268800, 0x47B38400, 0x010B0200, 0x19663100, 0x1B957180, 0x8639EE40, 0x702A0820, 0xC8D44430, 0xBD9A2218, 0x58DDA134, 0x747CD9B6, 0x930EFA55 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xB8000000, 0x34000000, 0x2A000000, 0x93000000, 0x6E800000, 0x89400000, 0x09200000, 0xAA900000, 0xC4380000, 0x9AA40000, 0xEC520000, 0xDDDF0000, 0xFCD18000, 0x1D9FC000, 0x5072A000, 0xD4CED000, 0x862A5800, 0x4AD95400, 0x4051DA00, 0xD3DDF100, 0xADD43080, 0xDC1D13C0, 0x11B1D820, 0xD9AD9410, 0xF218FA38, 0x50B7E12C, 0xF02F48AE, 0x8FDA57CD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xC8000000, 0x6C000000, 0x1E000000, 0x2D000000, 0x71800000, 0x09C00000, 0x09600000, 0x4A700000, 0x6F580000, 0xC0A40000, 0xE3120000, 0xB52F0000, 0x17FF8000, 0x87B04000, 0x243E6000, 0x91D07000, 0xCCCEA800, 0xDBCDAC00, 0xB54E5E00, 0x1E0E9300, 0x32295780, 0xC17C88C0, 0x88F0C820, 0x7A1DDC10, 0x5180F638, 0xD9C33F1C, 0x516709B2, 0x9E721BDB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x68000000, 0xC4000000, 0xC6000000, 0xA7000000, 0x71800000, 0x03400000, 0x2C200000, 0x41700000, 0xFC580000, 0x0F640000, 0x5D520000, 0x752D0000, 0x473F8000, 0xFC354000, 0x4B792000, 0x8594B000, 0x1F4FF800, 0xEAEFEC00, 0x8CDD8A00, 0x4AA22900, 0xBBB61F80, 0xC73F84C0, 0xBC36D820, 0xEB7B5C10, 0xF5927228, 0x774DC51C, 0x2EEB959A, 0x4ADDADF1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xF8000000, 0x24000000, 0x36000000, 0x07000000, 0xE6800000, 0xB8400000, 0xC2E00000, 0xCAB00000, 0x01A80000, 0x02A40000, 0x6C520000, 0x9D1B0000, 0xD40A8000, 0x7071C000, 0x6D082000, 0xBDF03000, 0x69CB7800, 0xFA56D400, 0x6A19D200, 0x7A8F5F00, 0xC430F980, 0x45ED8B40, 0x62435820, 0xBFE6E410, 0xA132AA18, 0x9A698B34, 0x57812BBE, 0x19C6D449 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xA8000000, 0xA4000000, 0xC2000000, 0xA5000000, 0x55800000, 0xCD400000, 0x49600000, 0x85900000, 0x47A80000, 0x90240000, 0x76F60000, 0x4B390000, 0xF40C8000, 0xE4974000, 0x202A2000, 0x60639000, 0x7616E800, 0xCDEBCC00, 0x39C1DA00, 0xC3A23300, 0x2CB78880, 0x6AD86B40, 0xF55CC820, 0xE9185C30, 0xBFFF3208, 0xE62DFF04, 0xD76052AA, 0x0E935869 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x88000000, 0xA4000000, 0x3A000000, 0xBB000000, 0x2B800000, 0x95C00000, 0xB7600000, 0x57300000, 0xB9580000, 0xDEA40000, 0xA6560000, 0xD3690000, 0x51798000, 0x6BB64000, 0x591A2000, 0x5D015000, 0x66821800, 0x0B413C00, 0xB025DE00, 0xC915F300, 0x794B1D80, 0x936DE8C0, 0xB1783820, 0xFBB06C30, 0x611FC608, 0x7100CF2C, 0xF880C3A2, 0x8A451BE9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x48000000, 0xC4000000, 0xB2000000, 0xCD000000, 0xCC800000, 0x71400000, 0x07A00000, 0x78300000, 0x27480000, 0x94E40000, 0x9A920000, 0xE7F90000, 0xA8E88000, 0x48D44000, 0xBFDD2000, 0x661C1000, 0x72FEA800, 0xA86D0400, 0x6F93BA00, 0x577E0500, 0x57AE2D80, 0x2C77A440, 0xF86B8820, 0x47951410, 0x237F1208, 0x3DAA0124, 0x6D751792, 0x42EDE171 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x48000000, 0xAC000000, 0xB2000000, 0x8F000000, 0xD7800000, 0x14C00000, 0x9B600000, 0x70300000, 0x70780000, 0x35A40000, 0xE8560000, 0xB5CF0000, 0xA61D8000, 0x75104000, 0x276C6000, 0xC5CF1000, 0xCE1DB800, 0x09149C00, 0xED68D600, 0xAECDF300, 0x079DE580, 0x20D229C0, 0x2E89D820, 0x1DBF8C30, 0xF8436E38, 0xFE266F0C, 0xC690B392, 0xEDAB9AEB } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x18000000, 0x64000000, 0x76000000, 0xDB000000, 0x15800000, 0x37C00000, 0x63A00000, 0xA5B00000, 0xBBF80000, 0x6A640000, 0xA1160000, 0xB9CD0000, 0x9B5A8000, 0x7E52C000, 0xFB282000, 0xBB0C3000, 0x927A9800, 0x2FA44C00, 0x1FB4AE00, 0x1AFD3500, 0x7EE23980, 0x52529DC0, 0x312AB820, 0xD20C7C30, 0xFAF83628, 0xCEE47934, 0x3A541786, 0x9D2968D9 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x38000000, 0xDC000000, 0x82000000, 0xCF000000, 0x6A800000, 0x4DC00000, 0xA0E00000, 0x4F500000, 0xCA180000, 0xC3240000, 0xDAB20000, 0x5CCD0000, 0x5C7B8000, 0x03B7C000, 0xDF49E000, 0x4A3A9000, 0x39163800, 0xE0BB7400, 0x94D61E00, 0x105B2F00, 0x13817680, 0x3E401AC0, 0x8EA7D820, 0xA9F5E410, 0x77EA2628, 0xD2C95B3C, 0x997EE88E, 0xE231F5F7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xA8000000, 0xE4000000, 0x3E000000, 0xB7000000, 0xAF800000, 0xD6400000, 0x71E00000, 0x69300000, 0xDF980000, 0x75A40000, 0xE5D60000, 0x682F0000, 0x98F98000, 0xEA574000, 0x2E6E2000, 0x111F7000, 0x7F677800, 0x83F61C00, 0x09BAE200, 0xBC330700, 0x251FED80, 0x9960E2C0, 0x98F15820, 0xCC3D6C30, 0x4B739A38, 0xA87E1B2C, 0xB7928FAA, 0x57CFA5F9 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xD8000000, 0x04000000, 0x2A000000, 0x2F000000, 0xC1800000, 0x5FC00000, 0xC7200000, 0x07300000, 0x76E80000, 0x9EE40000, 0x79160000, 0xA15D0000, 0x1B498000, 0x4D94C000, 0xA81B2000, 0x562DD000, 0x90403800, 0xEDE3EC00, 0x56930E00, 0x5B9D5100, 0x82EDAD80, 0x0CE43540, 0x42131820, 0x22DA3C30, 0xB78D3628, 0x6537BD2C, 0xF5E923B6, 0x0964A441 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x68000000, 0x5C000000, 0xAE000000, 0xAD000000, 0x5A800000, 0x9AC00000, 0xCEA00000, 0xF5B00000, 0xBDC80000, 0x99640000, 0x91960000, 0x8AB90000, 0xCE0C8000, 0x67414000, 0xF9E5E000, 0x8454F000, 0x559EA800, 0x1AFF7400, 0x12694600, 0x30556D00, 0x679F9180, 0x39FD2C40, 0xF5ED4820, 0x98128430, 0x6FFB6E08, 0xACEB5904, 0x1093379A, 0xE63CB157 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x88000000, 0xAC000000, 0x4A000000, 0x3D000000, 0x99800000, 0x9B400000, 0xDF200000, 0x03700000, 0x03980000, 0x31640000, 0x49D20000, 0x61AF0000, 0x08DE8000, 0xC6424000, 0x56A06000, 0xF037D000, 0x20BF2800, 0xF011EC00, 0xDB49EA00, 0x834E4100, 0xE749BF80, 0xE14D4AC0, 0xC64D4820, 0xEAC93C10, 0x44084238, 0x4A6DED14, 0xAB3835A2, 0x3250DBEB } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xC8000000, 0xF4000000, 0xF6000000, 0x0F000000, 0x76800000, 0xA7C00000, 0xB8200000, 0x1D300000, 0x3B980000, 0xA8E40000, 0x2F960000, 0x636F0000, 0x225B8000, 0x2BC44000, 0x5226A000, 0x00373000, 0x8C19B800, 0x4AA65400, 0x44F32E00, 0x98BD0900, 0xC550A580, 0x74CF16C0, 0xF1291820, 0x413E6430, 0xC4111638, 0xB32F1D3C, 0x983D2BB2, 0xAD912FFD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0xE8000000, 0xE4000000, 0x96000000, 0xED000000, 0x2A800000, 0xAEC00000, 0x13E00000, 0xDF900000, 0x95180000, 0xDC240000, 0xD4F20000, 0x7F4F0000, 0xCD5E8000, 0xBB014000, 0x67822000, 0x34413000, 0x0522A800, 0xC0713400, 0x388EE600, 0x323F4700, 0xCF56C080, 0x2FFD8AC0, 0x0F328820, 0xBA2F0410, 0x960ACE38, 0x1AFB3314, 0x39B006BA, 0x6EE8FDF9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xC8000000, 0x4C000000, 0x66000000, 0x01000000, 0x49800000, 0x07C00000, 0x6FE00000, 0xA3900000, 0x13880000, 0x0D240000, 0x7FF20000, 0x88D90000, 0x0DC98000, 0x7D004000, 0xA7816000, 0x6AC7B000, 0xF063C800, 0x6D566C00, 0x79E96E00, 0xCF744700, 0x029D5880, 0x6FEFEE40, 0x6670A820, 0x9718DC10, 0x762B2608, 0x8C966B2C, 0x570F56B2, 0x05611953 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xE8000000, 0x3C000000, 0xE6000000, 0xAF000000, 0xC5800000, 0x61C00000, 0x8EA00000, 0x72300000, 0x24E80000, 0xA4640000, 0x9B160000, 0x4A1F0000, 0xEEAE8000, 0x48054000, 0x4C00E000, 0xBE02B000, 0x2B00B800, 0xF7808C00, 0x14C5DE00, 0x02263D00, 0x7970C580, 0x0E0C0540, 0x39365820, 0x436D3C30, 0xB8A3E638, 0xF537F114, 0x3D6BFBBA, 0x73A3884F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x88000000, 0x1C000000, 0x16000000, 0xC1000000, 0x2C800000, 0x3CC00000, 0x46200000, 0xECB00000, 0x8E380000, 0xEDE40000, 0x27160000, 0xA2CD0000, 0xE13F8000, 0xF4664000, 0xED53E000, 0xF72E3000, 0x322DC800, 0x8CAFC400, 0x236EB600, 0x7AC80900, 0xC538C980, 0xD664D3C0, 0x56502820, 0x84A8F430, 0xFF6AFE28, 0xCCCC8D1C, 0x743A1FA2, 0x72E4AAC7 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x38000000, 0xE4000000, 0x0E000000, 0x7D000000, 0xC9800000, 0xECC00000, 0x9DA00000, 0x19900000, 0xFC980000, 0x16640000, 0xE6B60000, 0xC9490000, 0xD4198000, 0x3923C000, 0x74D02000, 0x71FCF000, 0xC853A800, 0x48BEAC00, 0x73353600, 0x0F8CF500, 0x1AB9A880, 0x24366EC0, 0x950D8820, 0xF2FF5C30, 0xA4D11E08, 0x19FC992C, 0x84533E8E, 0x2ABCABF9 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xA8000000, 0xFC000000, 0xE6000000, 0xE9000000, 0x73800000, 0xE6400000, 0xDA600000, 0xE3300000, 0x4EB80000, 0x47240000, 0x29D20000, 0x3F4D0000, 0x833A8000, 0x8C634000, 0x9230E000, 0x193CB000, 0xC3608800, 0xA8B33C00, 0x5CFAE200, 0x57442B00, 0x6DE48D80, 0x17743BC0, 0xB7DA6820, 0x70968C10, 0xE7AAEA28, 0xD1CD5734, 0x9CFE0FAA, 0xB746E0FF } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x18000000, 0x6C000000, 0x1E000000, 0x5B000000, 0xFC800000, 0x93C00000, 0xB5600000, 0xF2900000, 0x5DA80000, 0x02240000, 0x58320000, 0x145D0000, 0x5E198000, 0x8F3EC000, 0xAF886000, 0xE2167000, 0x90689800, 0x4C40C400, 0xE6204E00, 0xC2312300, 0x855CB880, 0x3B9F7F40, 0xBD797820, 0x42A87410, 0xD4A0B628, 0x42F7972C, 0xA8BC6E86, 0x80CA985B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xA8000000, 0x24000000, 0xDA000000, 0x99000000, 0x9E800000, 0x85400000, 0x4A200000, 0xF7F00000, 0x57680000, 0x45E40000, 0x0A920000, 0x37BB0000, 0x11F98000, 0xAC5B4000, 0x886C2000, 0x84665000, 0x0E550800, 0x195E1400, 0x78EF1A00, 0x3A222900, 0x7FF17380, 0xA36EFD40, 0x87E0A820, 0x1F930410, 0x573E3218, 0xD7BE6D2C, 0xE1F961AA, 0x6459C049 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x48000000, 0xE4000000, 0xF2000000, 0xF5000000, 0x6D800000, 0xD8C00000, 0x78E00000, 0x31700000, 0xDDB80000, 0xF1A40000, 0x6F560000, 0xC72B0000, 0xEFEA8000, 0xAF084000, 0x827E2000, 0xD1C01000, 0x8B666800, 0x6AB38C00, 0x1FDAB600, 0xC8929F00, 0x9B4BFF80, 0x55DC7FC0, 0xE192C820, 0x18CBDC30, 0xF61AFE18, 0x5FF50334, 0x7FF92192, 0xE1026CF9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xE8000000, 0x54000000, 0xC6000000, 0x23000000, 0xBB800000, 0xEFC00000, 0x29200000, 0xFF700000, 0xE0180000, 0xCB640000, 0x02920000, 0x81C90000, 0xD1C88000, 0x59C94000, 0xBDCDA000, 0x03CDB000, 0x9CCDD800, 0xB54BBC00, 0xBF8F2E00, 0x0E280100, 0xA51B6F80, 0x83E4EAC0, 0x9ED0F820, 0x832B4C10, 0x299D5608, 0x31A70D24, 0xEB3119BA, 0x06FE17D5 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x58000000, 0x44000000, 0x22000000, 0x61000000, 0x2C800000, 0x21C00000, 0x4EE00000, 0xEE100000, 0x65A80000, 0xD9A40000, 0x54320000, 0x23D90000, 0x9ED88000, 0xB45CC000, 0x669D2000, 0xADFA9000, 0x52AA4800, 0x3E220400, 0x04777E00, 0x967D0F00, 0x04EC6C80, 0x7887BF40, 0x1BC7E820, 0x4BE05410, 0x70921608, 0x7D6C9B24, 0xFFC1DA96, 0xB9E07451 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xA8000000, 0xCC000000, 0xB6000000, 0xF9000000, 0xE5800000, 0xC8400000, 0x5EA00000, 0x93100000, 0x3F880000, 0x3D640000, 0x28F20000, 0xE5B90000, 0x2ABB8000, 0x763B4000, 0x7BF96000, 0x1D1D3000, 0x78AA0800, 0x18348C00, 0xACDC5200, 0x40492D00, 0x68836C80, 0x6FC2CA40, 0x6DE0E820, 0xF336FC10, 0xAA5D3A08, 0xF289913C, 0xBAE6B6AA, 0xEBB02B73 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xB8000000, 0x74000000, 0x9A000000, 0x35000000, 0xC7800000, 0xBFC00000, 0xE3200000, 0x87B00000, 0x32E80000, 0xA5640000, 0xAC560000, 0xE0FD0000, 0xDA788000, 0x9E3FC000, 0xA4DCA000, 0x334F5000, 0x2297E800, 0x165FDC00, 0x2B0ACE00, 0x4E728100, 0x5ACA1980, 0x52510D40, 0x37FBC820, 0xFCFB4C30, 0xEC7F8628, 0x753B0D24, 0xE459BFAE, 0xB20E905D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xE8000000, 0x14000000, 0x56000000, 0x79000000, 0x08800000, 0xD6C00000, 0xB8E00000, 0xEC900000, 0xCF880000, 0x0CA40000, 0x99B20000, 0x8C7B0000, 0x30FE8000, 0xC0394000, 0xD9DDA000, 0x91CD3000, 0x22830800, 0xADC42400, 0xFF626600, 0x1BD1DF00, 0x4129B880, 0x9A155640, 0x54482820, 0xDAC45410, 0x62E6CE18, 0x0F97CB14, 0x440C56BA, 0x01E6ED45 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x38000000, 0xF4000000, 0x5A000000, 0x6D000000, 0xB9800000, 0xD0400000, 0x0B600000, 0x09900000, 0x8E480000, 0x04A40000, 0x69B20000, 0x963B0000, 0xADBF8000, 0xD4FFC000, 0x641AA000, 0x54CC5000, 0x0A642800, 0x4E112C00, 0x410AB200, 0x67400300, 0x9FE05880, 0x00522440, 0x25690820, 0x3E56BC10, 0x1A6E3A18, 0x46D27F1C, 0xADAB428E, 0x92F3CB7D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x38000000, 0xDC000000, 0xA2000000, 0x7B000000, 0xC2800000, 0x22C00000, 0xF1A00000, 0x37B00000, 0x37E80000, 0xAAE40000, 0x06520000, 0x033B0000, 0xD3198000, 0x48EFC000, 0xE663E000, 0xA5919000, 0x271C9800, 0x9EE8B400, 0x0B652600, 0xEA16A500, 0xFA5FE180, 0x8A0D2540, 0xF434F820, 0x80ADE410, 0x4103DE18, 0xF580412C, 0xAA45BF8E, 0xFC62A477 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xC8000000, 0x44000000, 0xBA000000, 0xA5000000, 0xFB800000, 0xB3400000, 0xC2200000, 0x5C300000, 0x32D80000, 0x67E40000, 0x52D60000, 0x458F0000, 0x9E2B8000, 0x685C4000, 0xB5272000, 0x96B35000, 0x181BE800, 0xCF803C00, 0x01422A00, 0xC323C900, 0xEDB24580, 0xEC98B8C0, 0x1A414820, 0x07A02C30, 0x10756238, 0x5E7CE53C, 0xBB14A7B2, 0x556C1DD1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x68000000, 0xFC000000, 0x1A000000, 0xE1000000, 0xB2800000, 0x8EC00000, 0x04200000, 0xFE900000, 0x76980000, 0xA5640000, 0x9CF20000, 0xC3E90000, 0x4BCA8000, 0x575D4000, 0x74C0E000, 0x55255000, 0xD413C800, 0xBC5FB400, 0x2F440600, 0x65621900, 0xFCF4B880, 0x33EBDEC0, 0xF3CBA820, 0xC35EA410, 0x92C5AE08, 0xAE21BD34, 0x8791969A, 0x801A23FF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x08000000, 0x7C000000, 0xD6000000, 0x91000000, 0xCB800000, 0xF0400000, 0x3EA00000, 0xBAB00000, 0x03380000, 0xD0640000, 0x5DD20000, 0x2C6B0000, 0x6BC98000, 0x96FE4000, 0xDB86E000, 0x68423000, 0x9AA24800, 0xA8B07C00, 0x303A9200, 0x20E42D00, 0x2113B180, 0xB80E4FC0, 0xD41F2820, 0xE1970C10, 0x8CCFBA18, 0x5C7C212C, 0x38478B82, 0x62A72EDF } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xB8000000, 0xFC000000, 0x62000000, 0xC1000000, 0x56800000, 0x46400000, 0x03200000, 0x9A100000, 0xB9380000, 0x90E40000, 0xF8F20000, 0x78CF0000, 0xA2AC8000, 0x6E1BC000, 0x6CF6E000, 0xFECE9000, 0x0DA84800, 0x339E1400, 0xF9320200, 0x732F6100, 0x71DD3C80, 0x8417E7C0, 0x5A382820, 0xE7604410, 0xF8322A38, 0x85AB2504, 0xC79D16AE, 0x2F33C2FF } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x08000000, 0x04000000, 0xAA000000, 0x4D000000, 0x88800000, 0xAD400000, 0x2BA00000, 0x4D700000, 0x8CB80000, 0x39640000, 0xA6120000, 0x3BAF0000, 0xCC4C8000, 0x341E4000, 0x43912000, 0xAE68D000, 0xB2A9A800, 0x4ECAA400, 0x24595A00, 0xF8B7C500, 0x425CD780, 0xBBB4C3C0, 0xDDDE0820, 0xCB773410, 0xDFBF5238, 0xAEE4F104, 0xD2D18582, 0x93CF32C1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x38000000, 0xF4000000, 0x12000000, 0x79000000, 0x0C800000, 0x59400000, 0xB4600000, 0x19500000, 0xF4980000, 0x62A40000, 0x1DF20000, 0xC26D0000, 0x75498000, 0x8D7FC000, 0x9A34A000, 0xB64A1000, 0xC4FE8800, 0xB1F58400, 0x746B3A00, 0x364DDB00, 0x84F9B680, 0x11F3A2C0, 0xC469A820, 0x0E495410, 0x70FA9228, 0x03F08F2C, 0xBD69248E, 0x02CA2DFD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x58000000, 0xD4000000, 0x16000000, 0xCF000000, 0x48800000, 0x34C00000, 0xD4E00000, 0x43900000, 0x42280000, 0x55A40000, 0x1A320000, 0xDA1F0000, 0xB6BA8000, 0xFB0CC000, 0x0557A000, 0x87CB3000, 0xFDB13800, 0x365AA400, 0xEE9E7600, 0x687E4F00, 0x4AED5080, 0x8B46AB40, 0xECA61820, 0x0DB65410, 0x1E586E38, 0x52981B34, 0x227D3E96, 0x1FEAB075 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xD8000000, 0x5C000000, 0x26000000, 0x09000000, 0x94800000, 0x45C00000, 0xB9200000, 0x8E100000, 0xC7980000, 0x43640000, 0xD5720000, 0x6EEB0000, 0xDB898000, 0x6FF8C000, 0x1197E000, 0xF5DDB000, 0x0C040800, 0x0E070400, 0xED043E00, 0x5E83D100, 0xB2C76C80, 0x78A21EC0, 0x79506820, 0x327D7410, 0xE0D45618, 0xD93EA52C, 0x53333AB6, 0xC38CBBD7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x78000000, 0xB4000000, 0x06000000, 0x29000000, 0x98800000, 0x15C00000, 0xE2E00000, 0xD8500000, 0xA7280000, 0xF8540000, 0x572E0000, 0xB0570000, 0xCB2C8000, 0x7A54C000, 0x50292000, 0xCDD4F000, 0xF4686800, 0xA2703400, 0xDB18C600, 0x3FEF2300, 0x5C320480, 0x37B81A40, 0x4318C620, 0x1BEF2330, 0x42320498, 0xFAB81A54, 0xA598C63E, 0x932F231D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x48000000, 0x94000000, 0x9E000000, 0x7D000000, 0x81800000, 0x8C400000, 0x87E00000, 0xFFB00000, 0x18C80000, 0xE7B40000, 0x04CE0000, 0x8DB70000, 0x37C88000, 0x39354000, 0xAE0C2000, 0xAC91B000, 0xAB5FC800, 0xCA6DBC00, 0xD867AA00, 0xAEF38300, 0xAEA95780, 0x0C44C540, 0x47E7AA20, 0x9FB38330, 0xC8C95798, 0xAFB4C574, 0x90CFAA32, 0x13B78315 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xF8000000, 0xDC000000, 0x0E000000, 0x91000000, 0xAD800000, 0xE8400000, 0x49A00000, 0xADF00000, 0xB8880000, 0xC5F40000, 0x8C8E0000, 0x3FF10000, 0x478D8000, 0x2976C000, 0x414B6000, 0xBA16B000, 0x71DFE800, 0xA30BDC00, 0x00B4AA00, 0xB6AB9100, 0x6342C580, 0x3F20D540, 0x7B34AA20, 0xA3EB9130, 0xD162C5A8, 0x4790D55C, 0xD19CAA1E, 0x6EAF9107 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x18000000, 0x64000000, 0x02000000, 0xB5000000, 0x06800000, 0x3CC00000, 0x51A00000, 0x8BB00000, 0xE8A80000, 0x2FB40000, 0x4AAA0000, 0x8AB30000, 0xA42D8000, 0xCA73C000, 0x938EA000, 0xF6C3D000, 0xC8A30800, 0xE337E400, 0xEF68EE00, 0xB3966900, 0x28593380, 0xBEFEEC40, 0xDEC8EE20, 0x88266910, 0x38F133B8, 0x054AEC7C, 0x8E62EE26, 0xD3956909 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x88000000, 0xD4000000, 0x82000000, 0x07000000, 0x10800000, 0x91C00000, 0xAA600000, 0x52100000, 0x48780000, 0x8E140000, 0xDE7E0000, 0xAB110000, 0x99FC8000, 0xA2554000, 0x765A2000, 0xD8215000, 0x6B321800, 0x0ECDD400, 0xAA9C9600, 0xD1C78700, 0xCA638680, 0xA21404C0, 0x907C9620, 0xD2178730, 0x887B86A8, 0x2E1004D4, 0x8E7A9602, 0x23128705 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xD8000000, 0xBC000000, 0xC2000000, 0xC9000000, 0x5D800000, 0x50400000, 0x07E00000, 0x5EB00000, 0xF7680000, 0x0AB40000, 0xF16E0000, 0xADB70000, 0x0FED8000, 0x0D71C000, 0x7BC86000, 0x0F67D000, 0x41762800, 0xA1C93C00, 0x1A66AA00, 0xAEF40300, 0xE088DF80, 0xFC04F840, 0x6206AA20, 0xD9040330, 0xF580DF98, 0x3440F85C, 0x79E0AA16, 0x55B7031F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xB8000000, 0x24000000, 0x06000000, 0xA5000000, 0x1E800000, 0x04C00000, 0xDFA00000, 0xEC700000, 0x5EE80000, 0xC0740000, 0xD4EA0000, 0x9F770000, 0x1D688000, 0x9E32C000, 0x5989A000, 0xB1A2F000, 0x95748800, 0x026E0400, 0x37B2AE00, 0x08C9F900, 0x4D444D80, 0x9EE44E40, 0xC892AE20, 0x2179F910, 0xB48C4D98, 0x43204E54, 0x3BB0AE0E, 0xB2CAF919 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x78000000, 0xAC000000, 0xFA000000, 0xBF000000, 0x21800000, 0x44400000, 0xC1E00000, 0x8B300000, 0xA4280000, 0xD1340000, 0x0B2E0000, 0xA8B50000, 0x33688000, 0xEB56C000, 0xAB5DE000, 0x94F91000, 0x812C1800, 0x7FB61C00, 0xE6EB3A00, 0x29109300, 0x57BDA380, 0x2D4E5240, 0xBAC33A20, 0x94249330, 0x8693A388, 0xEAFB5274, 0xD02BBA3E, 0x9732531B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xC8000000, 0xD4000000, 0xD6000000, 0x21000000, 0x95800000, 0x3E400000, 0xB8600000, 0x8B900000, 0x1C580000, 0x69940000, 0x5B5A0000, 0xE5150000, 0x3C9C8000, 0xA9334000, 0x2C6A2000, 0x5C7DF000, 0xD3672800, 0x7D175C00, 0x6099DA00, 0x8B331F00, 0x0B6E4680, 0x20FC9DC0, 0xACA1DA20, 0x2D371F10, 0x726C4688, 0x897D9DF4, 0x40E75A12, 0xAA515F25 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xB8000000, 0x94000000, 0xAA000000, 0x11000000, 0x67800000, 0xA0C00000, 0x53200000, 0xB7500000, 0xA2780000, 0x11540000, 0x5D7E0000, 0xD5D10000, 0x0F3E8000, 0x53B4C000, 0xCE8A2000, 0xD8399000, 0x7B36A800, 0x02C8AC00, 0xF558AE00, 0x7403B500, 0xDA025480, 0x1900C6C0, 0x5B80AE20, 0x26C7B530, 0x7C2454A8, 0x6BD5C6C4, 0x74382E0E, 0x85367515 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xC8000000, 0xE4000000, 0x76000000, 0x29000000, 0x07800000, 0xBBC00000, 0x5DE00000, 0x6D500000, 0xDC680000, 0x24540000, 0xEBEA0000, 0xB7930000, 0x22098000, 0x64C54000, 0x3366A000, 0x3112F000, 0x4A4DE800, 0xDCE1CC00, 0xBED1B600, 0x39AE6300, 0xC4B07C80, 0x3F387040, 0x1D3BB620, 0x2A3D6310, 0x70B9FCB8, 0x02FD305C, 0xE1DD1612, 0x44EF9329 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x68000000, 0x64000000, 0xFE000000, 0x5D000000, 0x8C800000, 0x99400000, 0x6D600000, 0x8AF00000, 0xC6480000, 0xE3F40000, 0x7CCE0000, 0x33B70000, 0x1B2E8000, 0x71044000, 0xA685A000, 0x2247B000, 0xA0E14800, 0x6D30D400, 0xF56D0200, 0x2BE4FF00, 0x78B47580, 0x6EAA3D40, 0xFAC30220, 0x1FA3FF30, 0x2152F598, 0x111A7D44, 0xDBE8A23A, 0xBDA34F29 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xE8000000, 0xDC000000, 0x9E000000, 0xF9000000, 0x15800000, 0x4F400000, 0x42A00000, 0x3E300000, 0x3E380000, 0x0B340000, 0x2DBA0000, 0x29710000, 0x089B8000, 0xD7064000, 0x44856000, 0x26C6B000, 0xA3E0A800, 0x6D931C00, 0xC98B5200, 0xE44A4900, 0x9D2A4380, 0x2F7848C0, 0x50915220, 0x960B4910, 0x8009C3A8, 0x750A08CC, 0x868E321A, 0x34CCF927 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x88000000, 0xC4000000, 0x9E000000, 0x1F000000, 0x60800000, 0x3A400000, 0xB3A00000, 0xA3700000, 0x19980000, 0x20740000, 0xFB1E0000, 0x47370000, 0x15398000, 0x73834000, 0xA0C7A000, 0x98E3B000, 0x17515800, 0xAC2BB400, 0xEA0B0A00, 0x4AB86900, 0x79453180, 0x3124D5C0, 0x34350A20, 0x7FBF6930, 0xD0C4B198, 0xD0E395FC, 0xB354AA02, 0xC22FD901 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xC8000000, 0x0C000000, 0xF6000000, 0x91000000, 0xBC800000, 0x02400000, 0x38E00000, 0x4A700000, 0x7B880000, 0xFD740000, 0x2E0A0000, 0x27B10000, 0x1EAD8000, 0xFA274000, 0x0ED5E000, 0x341CF000, 0x760F6800, 0xF3B21400, 0x7CABFA00, 0xA9251300, 0x11550980, 0xE1DCDF40, 0x9729FA20, 0xAEE01310, 0xCB7289A8, 0x5F0A9F7C, 0xCB319A12, 0x24EBA313 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x78000000, 0x4C000000, 0x52000000, 0xE7000000, 0x28800000, 0x62400000, 0x00600000, 0x01300000, 0x4B480000, 0xEC340000, 0x38CE0000, 0x2CF10000, 0xC1EF8000, 0x2F22C000, 0x42D5E000, 0xF2BC5000, 0x1258D800, 0x852A1400, 0x70014A00, 0x18015700, 0xDC036380, 0x1A033D40, 0xD3074A20, 0x36845730, 0xD742E3A8, 0xCFE0FD4C, 0x4BF52A3E, 0x296EC723 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xD8000000, 0xAC000000, 0xE2000000, 0xB3000000, 0x03800000, 0xD5400000, 0x76600000, 0xAAB00000, 0x09480000, 0x93B40000, 0xFDCA0000, 0xA3770000, 0x6BEA8000, 0x5921C000, 0xE3D7E000, 0x327AD000, 0x34BC7800, 0x6F9FCC00, 0x6F4B5200, 0xE6B13F00, 0xBB492780, 0x98B7C540, 0x42495220, 0x4C323F10, 0x0289A798, 0x12110544, 0x8CDC3216, 0xD42D2F3B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xE8000000, 0x9C000000, 0x6A000000, 0xBF000000, 0xDD800000, 0xAC400000, 0x42200000, 0xD0100000, 0xE8380000, 0x59140000, 0x80BA0000, 0x07D50000, 0xEB5F8000, 0x4DA24000, 0x67536000, 0xF99D1000, 0x34409800, 0x5620FC00, 0xB6157A00, 0x653A2D00, 0x4F955A80, 0x077D5CC0, 0x3CB77A20, 0x1BEB2D10, 0x0448DA88, 0x381E1CEC, 0xB2019A1A, 0x8B017D37 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x18000000, 0x74000000, 0x26000000, 0x43000000, 0xDC800000, 0x1C400000, 0x76A00000, 0xAD100000, 0x82480000, 0x6C140000, 0xE3CE0000, 0x7BD30000, 0x23AC8000, 0xE723C000, 0xD2D72000, 0x9E2EF000, 0xEAE73800, 0x1BB11400, 0xCF5E5A00, 0xBE5AE100, 0x97DD5280, 0xEC1FE340, 0x7E785A20, 0x878DE130, 0xE977D2B8, 0x50BB2354, 0x026DFA26, 0x5C43D12D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x58000000, 0xDC000000, 0xAA000000, 0xA9000000, 0x6B800000, 0xCBC00000, 0x64600000, 0x92900000, 0x7BF80000, 0xE5940000, 0xF77E0000, 0x8AD10000, 0xD85B8000, 0xF163C000, 0x83156000, 0x513A9000, 0xDE722800, 0x802ACC00, 0x4A4CF600, 0xC7DAAF00, 0x74A24280, 0x2873C0C0, 0x432AF620, 0x28CFAF30, 0xD79FC2A8, 0x830500EC, 0x02821636, 0x0043FF07 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x28000000, 0xB4000000, 0xDE000000, 0x05000000, 0xD1800000, 0x5DC00000, 0x25E00000, 0x6BD00000, 0x8C480000, 0xAA540000, 0xB98A0000, 0xDBB30000, 0x9C5E8000, 0x7AFA4000, 0x538F2000, 0x40B6B000, 0xA8DC0800, 0x66BEBC00, 0x03ACA600, 0xBA84B300, 0x91434880, 0x45A7D940, 0xC1F22620, 0x857EF310, 0xF34C68B8, 0xC8D16964, 0x64CE2E2A, 0x3C104F3D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xE8000000, 0xAC000000, 0x9E000000, 0x13000000, 0x0B800000, 0x68400000, 0x2FA00000, 0x21D00000, 0x99D80000, 0x3A540000, 0x899E0000, 0x01F10000, 0x82498000, 0x512E4000, 0x9298E000, 0x3674B000, 0xCC097800, 0xD98D6C00, 0x62CC7A00, 0xE6E8F100, 0x5F7BC480, 0x010647C0, 0xB685FA20, 0x38C6B130, 0x106324A8, 0x1032F7FC, 0x28AC821A, 0x17DBDD1B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x18000000, 0x7C000000, 0xEA000000, 0x27000000, 0x3A800000, 0x4C400000, 0x99600000, 0x4C700000, 0x04780000, 0xEEF40000, 0x743A0000, 0xFD970000, 0xEF4D8000, 0xDB6FC000, 0x31FA6000, 0xDC329000, 0xA71C5800, 0x0D86C400, 0xDEC5FA00, 0xD1226F00, 0xB3120980, 0x9D0B94C0, 0x8B087A20, 0x060DAF10, 0x7B886998, 0xFD4904FC, 0x306C2226, 0x997F6B0F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x28000000, 0xBC000000, 0xAE000000, 0xEF000000, 0x5A800000, 0x58400000, 0xC3200000, 0xCF100000, 0x3C080000, 0xED940000, 0x104A0000, 0x0CB10000, 0x265E8000, 0x11384000, 0xDB0F6000, 0xDB173000, 0x6E091800, 0x0C936400, 0x35CF9A00, 0x26741D00, 0x013DD280, 0xB30F6540, 0xC7111A20, 0x500C5D10, 0xCB92B2A8, 0xD3485564, 0xD030022A, 0x2D1B393F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x18000000, 0x3C000000, 0x6A000000, 0xDD000000, 0xDC800000, 0xF6C00000, 0xF9A00000, 0x9E100000, 0xFBD80000, 0x2E940000, 0xDF1E0000, 0x46370000, 0xFF8E8000, 0xB22FC000, 0xA23B6000, 0xB2E29000, 0xE7F28800, 0xD7AEF400, 0x7E7CFE00, 0x7A815900, 0x89C21E80, 0xBC20CFC0, 0xF2527E20, 0x5BBE9930, 0x74A17E98, 0xFA965FC4, 0x411EF626, 0xB5376D3F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x78000000, 0xE4000000, 0xDE000000, 0x8B000000, 0x44800000, 0xDCC00000, 0xEB200000, 0xB0700000, 0xB0E80000, 0x08F40000, 0xA62A0000, 0x2ED30000, 0x8DDF8000, 0xA078C000, 0xDDCCA000, 0xC7843000, 0xA443F800, 0x5DE59400, 0xC653DE00, 0x531F6D00, 0x1A5AED80, 0xCC3C5240, 0x1C2C5E20, 0x3BD7AD10, 0xA25E4DB8, 0x883C626C, 0x922DA63E, 0x78D53929 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xA8000000, 0x2C000000, 0x0A000000, 0x0D000000, 0x0D800000, 0xF3400000, 0x49600000, 0x53300000, 0x2AE80000, 0x6AB40000, 0x67AE0000, 0x50D10000, 0xEA1C8000, 0x07FC4000, 0x1C09E000, 0x83C21000, 0x8FA08800, 0xCD12FC00, 0x46B95200, 0xBC6A5700, 0x0B765B80, 0xA9084840, 0x6A45D220, 0xAAE61730, 0x7B77BBA8, 0x910E5854, 0x4E435A0A, 0xDCE1EB3B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xE8000000, 0xCC000000, 0xBA000000, 0x1D000000, 0x6C800000, 0x37400000, 0x06E00000, 0x9AD00000, 0x3DD80000, 0xCC540000, 0x579A0000, 0x46330000, 0x4A0F8000, 0x950C4000, 0xD08DE000, 0x454B9000, 0x47EA0800, 0x345D7400, 0xA394F200, 0xA83F2300, 0xE907F480, 0x028125C0, 0x54437220, 0xB1676310, 0x8E1014B8, 0xB1F9B5EC, 0xB1A6FA1A, 0xDC365723 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x18000000, 0x2C000000, 0x62000000, 0x4B000000, 0xBD800000, 0x5CC00000, 0xB4200000, 0x31900000, 0xEE880000, 0x7E140000, 0x414E0000, 0xEBB70000, 0x86188000, 0xCE1FC000, 0x3A1DE000, 0x141AD000, 0xED1CB800, 0x0399BC00, 0xCEDE9E00, 0x443D7D00, 0x8A8C0280, 0xE8105140, 0x244E1E20, 0xAF36BD30, 0x345FE298, 0xB77D8174, 0x816A2626, 0x3420C13B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x98000000, 0xB4000000, 0xB2000000, 0xF9000000, 0x2D800000, 0xA2400000, 0xD3E00000, 0x39300000, 0xAF980000, 0x9EB40000, 0xD0DA0000, 0x6AD50000, 0xD6AC8000, 0x1129C000, 0x9E6D2000, 0x220E5000, 0x087BE800, 0x7581BC00, 0x76463A00, 0x91E48300, 0x88316380, 0xAE19B7C0, 0x3AF2BA20, 0x48394310, 0x87664388, 0xF6F2E7F4, 0xFE3DD206, 0xA4653F3D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x38000000, 0x74000000, 0x02000000, 0x4D000000, 0x9C800000, 0xDFC00000, 0x40E00000, 0x30300000, 0x09380000, 0x82B40000, 0x7DFE0000, 0x79D50000, 0x7F8D8000, 0x3D4CC000, 0x692A2000, 0xEADAD000, 0xA5014800, 0x6081B400, 0xB1C47600, 0x0BE71300, 0xDBB76780, 0x737F72C0, 0x8311F620, 0x9FEFD330, 0x9CBB4788, 0x1BF4A2DC, 0x8BDB3E2E, 0xDF83A72D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x28000000, 0x0C000000, 0x02000000, 0x39000000, 0xA5800000, 0x1B400000, 0x3CA00000, 0xB2500000, 0xD5780000, 0x61D40000, 0xE13E0000, 0xC7F50000, 0x2AA98000, 0x83EC4000, 0x4E4DE000, 0x859A5000, 0x91A52800, 0xD1D4FC00, 0x293EB200, 0x1BF67900, 0xF0ABB080, 0x9EEEDAC0, 0xE5CF3220, 0xA5DE3930, 0x31805088, 0xDD458AFC, 0xDBA59A2A, 0xF4D78533 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x88000000, 0x0C000000, 0x46000000, 0x63000000, 0x7A800000, 0xF2C00000, 0x68E00000, 0x9CD00000, 0x57980000, 0x05540000, 0x9FDA0000, 0xBF750000, 0x9BED8000, 0xFC394000, 0xC521E000, 0x20B57000, 0x868DF800, 0x7EAE2400, 0x139EAE00, 0x2F55C300, 0x6ADED880, 0xDEF7F7C0, 0x97A92E20, 0x2C198310, 0x1412B888, 0xF27BC7FC, 0x5C053602, 0x7E02D713 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x48000000, 0x94000000, 0x72000000, 0xFB000000, 0xA2800000, 0x4F400000, 0x42200000, 0x52100000, 0xC7580000, 0x03940000, 0x1E9E0000, 0x2CF70000, 0x8DAF8000, 0xC73D4000, 0xE0272000, 0x1114D000, 0xD9D9F800, 0x9AD14400, 0x9DBD4200, 0xB3673500, 0xD5332280, 0x32CFA7C0, 0x4C0CC220, 0xE7ED7530, 0xD29B8298, 0x12F637CC, 0x88AA1A32, 0x00BCE115 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xC8000000, 0xEC000000, 0x02000000, 0x77000000, 0x2F800000, 0x03C00000, 0x63600000, 0x94700000, 0xC9F80000, 0x14F40000, 0x51BA0000, 0x82550000, 0x07AD8000, 0xA15B4000, 0x6FE6E000, 0xDE355000, 0x105A5800, 0x4964AC00, 0x9F708600, 0xFC7C1700, 0xB4349580, 0x3B5BD0C0, 0x8CE70620, 0xF7B25710, 0x7A9FF588, 0xB885C0FC, 0xBC43BE12, 0x78A7AB2B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x08000000, 0xC4000000, 0xEA000000, 0x15000000, 0x17800000, 0x2CC00000, 0x6BE00000, 0x05500000, 0x34280000, 0xF3D40000, 0x5D6E0000, 0x1DF50000, 0x525C8000, 0x334D4000, 0xD2C6A000, 0x5CE01000, 0xE3D50800, 0xB56D2C00, 0xA9F3AE00, 0xE05C9300, 0xEA4BB480, 0xEB426A40, 0x8F212E20, 0x8AB4D330, 0x8B799488, 0xDAFB3A54, 0x7D3C8622, 0x865CEF01 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x48000000, 0x94000000, 0x26000000, 0xDD000000, 0xE3800000, 0xF3400000, 0x47600000, 0x59300000, 0x19880000, 0x1BB40000, 0xAB4E0000, 0xCC930000, 0x679F8000, 0x66E94000, 0xBE872000, 0xD0C27000, 0x5424C800, 0x2E55EC00, 0x08BF9200, 0x963CB700, 0x96F88B80, 0xBADE0340, 0x488E1220, 0xF236F730, 0x9F082BB8, 0x3771334C, 0x9D6BFA32, 0x61C66B15 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x88000000, 0x24000000, 0x86000000, 0xD5000000, 0x3F800000, 0xDDC00000, 0xA2600000, 0xB6100000, 0xE8D80000, 0xA0940000, 0x909A0000, 0x00350000, 0x3C6D8000, 0x67B94000, 0xC500A000, 0x27837000, 0xA1C10800, 0x78660C00, 0x49152600, 0xA059FF00, 0x11D5C680, 0x05BF01C0, 0xF602A620, 0x1D05BF10, 0x3B80E688, 0xABC131FC, 0xFF610E02, 0xAD91C319 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xD8000000, 0x6C000000, 0x52000000, 0x2B000000, 0x55800000, 0x9BC00000, 0x56600000, 0x18700000, 0x98A80000, 0x74F40000, 0x9DEE0000, 0x1CD50000, 0x40388000, 0x7E6BC000, 0x8A17E000, 0x76DB5000, 0x0159B800, 0x799A7C00, 0xEE7B2600, 0x83CC6F00, 0xEC049580, 0x9201A240, 0x0B05A620, 0x8586AF30, 0x43C5F588, 0x3A643274, 0x4A737E16, 0xB3AC432B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x88000000, 0x44000000, 0xF6000000, 0xEF000000, 0x47800000, 0x38C00000, 0x8FE00000, 0x20700000, 0xCC780000, 0x96F40000, 0x283E0000, 0xE8550000, 0x4C688000, 0xF6394000, 0x5356A000, 0x55ECF000, 0xB5FED800, 0xE5354C00, 0xE65FDE00, 0x47E05300, 0x8474CD80, 0xCA7838C0, 0x21F15E20, 0xA3B81330, 0x6294ED88, 0xDA8888F4, 0x7EC9A602, 0xE06CEF21 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x38000000, 0xFC000000, 0xC2000000, 0x27000000, 0x32800000, 0x8AC00000, 0x84200000, 0x17D00000, 0xF6980000, 0x44540000, 0x77DE0000, 0x2D330000, 0x136C8000, 0x341AC000, 0x86976000, 0x87FED000, 0x6CE75800, 0xC4F2C400, 0x5BCC4E00, 0xAC0AC500, 0xB1A80080, 0x5439D9C0, 0x1F46CE20, 0xFC670530, 0xF935E0B8, 0x356AC9D4, 0x9D1C762E, 0x3916D10F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x18000000, 0x6C000000, 0xAA000000, 0x81000000, 0x50800000, 0xDAC00000, 0xF3200000, 0xDD500000, 0x15B80000, 0xF2D40000, 0x08FE0000, 0x18B10000, 0x51CE8000, 0x1B39C000, 0xAF11E000, 0x205E9000, 0xDEA6E800, 0x25119400, 0x715C7E00, 0x3627AD00, 0x83D7A480, 0x307FD8C0, 0x0674FE20, 0x6CEB6D30, 0x996EC4A8, 0xAD2D88C4, 0x73CB7626, 0x2E38A92B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xA8000000, 0xEC000000, 0x32000000, 0xB7000000, 0x11800000, 0x06400000, 0x7B600000, 0x5B300000, 0x05A80000, 0x1D740000, 0xDECE0000, 0x76470000, 0x23648000, 0x2F364000, 0x23ADE000, 0xDC70D000, 0xA64CD800, 0xE4861C00, 0xF8C10A00, 0x18A51700, 0x00170B80, 0xE4FF2640, 0x3B6CEA20, 0x54D5C730, 0x6E5BD398, 0xBC793A54, 0x59ADE00A, 0x1770D00B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x08000000, 0x3C000000, 0xFE000000, 0xED000000, 0xAE800000, 0x54400000, 0xBA600000, 0x94F00000, 0xF4180000, 0xF0B40000, 0xF67E0000, 0x20410000, 0x18608000, 0xF7F54000, 0x6F9F6000, 0x3E73B000, 0xDA588800, 0x1DD38400, 0x3B0D4A00, 0x0999E700, 0x87736580, 0xC6DEC3C0, 0x82922A20, 0xF6EA5730, 0xA5ABEDA8, 0x8E4D47F4, 0x5B7F6022, 0xEEC3B03F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xF8000000, 0x14000000, 0xDA000000, 0x33000000, 0xCC800000, 0xB7400000, 0xAE600000, 0xC8700000, 0xBD080000, 0xF7340000, 0x6F6E0000, 0xA9410000, 0x7F648000, 0x83F2C000, 0x4CCA2000, 0x25151000, 0xD1FF3800, 0xB179B400, 0xA83CA200, 0x1F5BD700, 0x80AED980, 0xAA640B40, 0x8A768220, 0x6A0EC730, 0x49B1E1A8, 0x072DBF54, 0x05A2201E, 0xE9511035 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x68000000, 0x8C000000, 0xE2000000, 0x19000000, 0x83800000, 0x61400000, 0x25600000, 0x9D900000, 0x37B80000, 0xF0D40000, 0xB0DA0000, 0xD4410000, 0x74E18000, 0x2DD64000, 0x6D5FE000, 0x86005000, 0x3706A800, 0xD8860C00, 0x8BC04200, 0xAFA67700, 0x55B38680, 0x6D4F86C0, 0x43FFA220, 0xF4362710, 0xF50D2EA8, 0x351D8ADC, 0x10E5E03A, 0x03D15033 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x78000000, 0xBC000000, 0xC2000000, 0x49000000, 0x1B800000, 0x12C00000, 0x0E200000, 0xA8700000, 0x1FF80000, 0x3EB40000, 0x4FDE0000, 0x4DC30000, 0xCAA38000, 0xBE34C000, 0xE7986000, 0xDEA1D000, 0xC831A800, 0x4899CC00, 0x42235E00, 0x32756D00, 0xBAFF3580, 0x2F371EC0, 0xD01B3E20, 0x2664BD30, 0xFB169DB8, 0xFD6AD2EC, 0x781E603E, 0x9266D01F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x18000000, 0x34000000, 0x8A000000, 0xD3000000, 0x90800000, 0x78C00000, 0xA6E00000, 0x31300000, 0x15280000, 0xC5F40000, 0xDDCE0000, 0x95C50000, 0xAF668000, 0x2A71C000, 0x4B892000, 0x32E09000, 0x6B313800, 0xFE29D400, 0x7171DE00, 0x370F7300, 0xD426EF80, 0x84D74E40, 0x9498FE20, 0xB81FE330, 0xA6DFD788, 0x4D3A9A44, 0xA58F2026, 0x93E1903D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x88000000, 0x1C000000, 0x4A000000, 0x4D000000, 0xFC800000, 0x22400000, 0x8B200000, 0x15900000, 0x5CF80000, 0xADD40000, 0x62DA0000, 0xB0C70000, 0x7A638000, 0x19374000, 0xA0A96000, 0x61CA1000, 0x937C8800, 0x7810B400, 0xE83BFA00, 0x19B17D00, 0xB8EE9E80, 0x4FEF4EC0, 0x566A9A20, 0xC4AF6D10, 0x9FC81698, 0xD878FACC, 0x3B92E002, 0xEFF95017 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x18000000, 0x2C000000, 0xBE000000, 0xC7000000, 0xE2800000, 0x1B400000, 0x3BE00000, 0xE8D00000, 0x07780000, 0x31940000, 0x1D9A0000, 0xF0C50000, 0x8D248000, 0x3EF1C000, 0x8D0FE000, 0x84D93000, 0xCA215800, 0x9C71E400, 0xB6496200, 0x6F3C8B00, 0x3AF03C80, 0xB70E74C0, 0x39DE8220, 0xB5A1BB10, 0x28B36488, 0x216E90F4, 0x3CC96026, 0xD079F01B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x98000000, 0xD4000000, 0x06000000, 0x91000000, 0xB3800000, 0xD7C00000, 0x2B600000, 0xEF900000, 0x5F180000, 0x3A540000, 0x2B7A0000, 0xAB430000, 0xAA258000, 0xB6B3C000, 0xB5292000, 0x5E38F000, 0xA4642800, 0x5910AC00, 0xDD5AB600, 0xA7F38700, 0xC409A280, 0x180E33C0, 0xE20B9620, 0xD90F7710, 0xD98F8AB8, 0xB2C99FFC, 0xB8EEA006, 0x1E5C3025 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xC8000000, 0xFC000000, 0xFE000000, 0x81000000, 0x3E800000, 0x30C00000, 0x13600000, 0x8A300000, 0xFEC80000, 0xF0F40000, 0x2EAA0000, 0xDB430000, 0xAF258000, 0xFE914000, 0xD4186000, 0xBC4DB000, 0x7E35E800, 0x5CCB0400, 0x9FF10E00, 0xA92AAF00, 0xE1077780, 0x8E82FD40, 0x18C16E20, 0x1F631F10, 0xBC309FB8, 0x83CEF97C, 0x3077E012, 0x9F6FF02F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x48000000, 0xC4000000, 0xF2000000, 0x73000000, 0x24800000, 0x1DC00000, 0xE7600000, 0x2D700000, 0x01780000, 0x5EB40000, 0x4B1A0000, 0x22430000, 0x6A248000, 0x5DD54000, 0xE468A000, 0x2839D000, 0x4C13B800, 0x750BB400, 0x644EF600, 0xCAECDF00, 0x5AFCE580, 0x11F100C0, 0xD0BE5620, 0x6FD10F10, 0x376D5DB8, 0x3CBDB4F4, 0xC9D62032, 0x1E6F9021 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x68000000, 0x2C000000, 0x8E000000, 0x07000000, 0x16800000, 0x93C00000, 0x10A00000, 0x96700000, 0xADD80000, 0xFFB40000, 0x607E0000, 0xD2470000, 0x3DE08000, 0x59104000, 0x750FE000, 0xAB1B3000, 0x08935800, 0x5049C400, 0x987D2600, 0x3647F100, 0x2FE70D80, 0x68157BC0, 0x208AC620, 0x8C58C130, 0x02F25598, 0xC71FBFF4, 0x2691603A, 0xE74C703B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xB8000000, 0x74000000, 0xAE000000, 0x59000000, 0xFA800000, 0x11C00000, 0xDBE00000, 0x45F00000, 0x15780000, 0xD9340000, 0x0A1A0000, 0x4C050000, 0x9A048000, 0xD704C000, 0x73852000, 0x5340B000, 0xBE216800, 0x3012A400, 0x098A4600, 0x36CD0B00, 0xC2ECA180, 0x9DF974C0, 0x93F56620, 0x5878BB10, 0x7DB14988, 0x2ADB10F4, 0xA160000E, 0x1430000D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x68000000, 0x1C000000, 0x1A000000, 0xB7000000, 0x1A800000, 0xEDC00000, 0xEAA00000, 0xF9700000, 0xD3980000, 0x4FB40000, 0x11BA0000, 0x10030000, 0x58018000, 0x94044000, 0x76036000, 0xC5039000, 0xB1855800, 0xED400400, 0xB062D600, 0x09578100, 0xC728A580, 0x768DC9C0, 0xA77BB620, 0xD2271110, 0x07B47DB8, 0xDDBD8DDC, 0xF200003A, 0xEB000017 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x38000000, 0x04000000, 0x36000000, 0x2F000000, 0x1E800000, 0x05400000, 0x72E00000, 0x3C100000, 0x22180000, 0xAA540000, 0xBC7E0000, 0x6A030000, 0x6D038000, 0xDF86C000, 0x80C5A000, 0x67207000, 0x60B15800, 0x44694400, 0x9E1D5200, 0x58516300, 0x4578CA80, 0xEB8407C0, 0x4EC6F220, 0xAC221330, 0xF83212B8, 0x562F83EC, 0xF678002E, 0x57040031 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x08000000, 0x6C000000, 0x02000000, 0x05000000, 0x1F800000, 0x27400000, 0xA2200000, 0x41900000, 0xB8280000, 0x41D40000, 0x908E0000, 0x90810000, 0x91C48000, 0x38E54000, 0x91F1E000, 0x4C185000, 0xF32F4800, 0xC952EC00, 0x054A1200, 0x36666D00, 0x5F37F680, 0x0A7EF040, 0x341DF220, 0x072B3D30, 0x0F523EA8, 0x3E485C54, 0x26E28022, 0x0EF0402B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x98000000, 0x84000000, 0x22000000, 0x85000000, 0xD4800000, 0xC7400000, 0xD7200000, 0x09900000, 0x03B80000, 0x51D40000, 0xB11E0000, 0x81830000, 0xABC28000, 0xE463C000, 0xF4B0A000, 0x932DD000, 0x20EC0800, 0x808DB400, 0xB63F1200, 0x30119D00, 0x5C7F3680, 0x9FB1C4C0, 0xDCA9B220, 0x602B4D30, 0xEB6FBEB8, 0xE24CB0E4, 0x58DC8006, 0xB0E0C011 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x68000000, 0x94000000, 0x02000000, 0xD7000000, 0xFE800000, 0xFAC00000, 0x07A00000, 0x93100000, 0xEAB80000, 0xE4D40000, 0x989E0000, 0xF5870000, 0x42458000, 0x50604000, 0x31372000, 0x83EB5000, 0xB20E1800, 0xC37DE400, 0xC7F06E00, 0xBA494900, 0x001C8E80, 0x724108C0, 0x98614E20, 0xB5311930, 0x99E91698, 0x990BACDC, 0xABFB803A, 0xE8374015 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xE8000000, 0x4C000000, 0x3E000000, 0x4F000000, 0x63800000, 0x8AC00000, 0x97200000, 0x64300000, 0xBE480000, 0x03F40000, 0x73EA0000, 0x7D830000, 0x75C28000, 0xECA04000, 0x5AF2E000, 0xB36EB000, 0x5AC41800, 0xDF20EC00, 0xD8312E00, 0x784F2500, 0xE8F43780, 0x62692B40, 0x8641CE20, 0xCE669510, 0x61D0AFB8, 0xF95E8744, 0x438A801A, 0xF3544003 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x28000000, 0x7C000000, 0xDE000000, 0x7F000000, 0xA6800000, 0x6B400000, 0xE8E00000, 0xF5500000, 0xA9180000, 0x2B140000, 0xDA7E0000, 0x82850000, 0x11468000, 0x2DE04000, 0xB6D36000, 0x91DFB000, 0xD3341800, 0xAB0DC400, 0x84EDA200, 0x4338F300, 0x0366B080, 0x71966FC0, 0xAF38C220, 0x35664330, 0x52922888, 0xC7BAEBC4, 0x0926802A, 0x60F0402F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x28000000, 0x14000000, 0xF6000000, 0xBF000000, 0x17800000, 0xF8400000, 0x21A00000, 0xFD300000, 0x41F80000, 0x92F40000, 0xD81A0000, 0xAE630000, 0x34D08000, 0x556E4000, 0x6A3E2000, 0xD510F000, 0x4F885800, 0xA32E8C00, 0x889FFA00, 0x3DA15100, 0xEF30BB80, 0x90FD8AC0, 0x56715A20, 0xFDDFE110, 0x2A86C3B8, 0xB6C3F6D4, 0xB966F82A, 0x77503C15 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x08000000, 0x24000000, 0xAE000000, 0x05000000, 0x17800000, 0x73C00000, 0x6C200000, 0x71500000, 0xE5E80000, 0x3D140000, 0x6E0A0000, 0x26610000, 0x2BB58000, 0x4F1D4000, 0x2A6AA000, 0xD2D33000, 0x202E0800, 0x28334C00, 0x7ADE7600, 0x374BBD00, 0xE205C480, 0x9F065640, 0xE4815620, 0xBD45CD10, 0x8A616CA8, 0xE1B62A7C, 0x44192822, 0xC8E93C19 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xB8000000, 0xFC000000, 0xF6000000, 0x53000000, 0xFF800000, 0xC2400000, 0x07E00000, 0x50500000, 0x8DC80000, 0xD1940000, 0x5E6E0000, 0xC5250000, 0xF4778000, 0x1F3CC000, 0x766A6000, 0x71207000, 0x66727800, 0x7638CC00, 0x94ECCA00, 0xE3E7E300, 0xAA53C080, 0xB0C9F940, 0xB1112A20, 0x2DAB5330, 0xAF83D888, 0xAA45454C, 0x53E1980E, 0xD2517C0F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xD8000000, 0x64000000, 0x3E000000, 0x41000000, 0xDC800000, 0x84400000, 0xE2E00000, 0x76500000, 0x0A180000, 0xAA940000, 0xE2BE0000, 0xC7270000, 0x56758000, 0x05EDC000, 0xD9BCA000, 0xB4A53000, 0x87B42800, 0x73CF9400, 0x4B4F6A00, 0x310E1300, 0xF2EC4080, 0x283E3FC0, 0x7E664A20, 0x5216E330, 0xF8FCC898, 0x74C09BDC, 0x54A30816, 0x37B06429 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x58000000, 0x4C000000, 0x0E000000, 0x05000000, 0xC6800000, 0xCAC00000, 0x5E600000, 0xB4300000, 0x83C80000, 0x04740000, 0x316E0000, 0x4F230000, 0x8A148000, 0x1D5DC000, 0x60ECE000, 0xD060B000, 0x71334800, 0xA54BC400, 0x9EB23E00, 0x370A6700, 0xB712E780, 0x07DA3540, 0x1C2A5E20, 0x97071730, 0x55854FB8, 0xA5454154, 0x0C252836, 0x7D95B423 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x48000000, 0x54000000, 0x1A000000, 0x07000000, 0x87800000, 0x86C00000, 0xDD200000, 0xCAB00000, 0xA6680000, 0xB7F40000, 0x838E0000, 0x05650000, 0xA3D08000, 0x13BB4000, 0x85482000, 0x18409000, 0x49659800, 0x65D36C00, 0x7AB8CE00, 0xCFCE3500, 0x56021380, 0xC1043240, 0xEE806E20, 0xCC45E530, 0x9367AB88, 0x42D3CE74, 0x2D3B3832, 0x0109BC25 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xF8000000, 0x34000000, 0x5E000000, 0x83000000, 0x5A800000, 0x72400000, 0xC2E00000, 0xA6700000, 0xCFE80000, 0x10B40000, 0x5C4A0000, 0xDEA30000, 0xAF928000, 0x0F18C000, 0x2F1D2000, 0x9F1B3000, 0x971CB800, 0x4B19A400, 0xD919CA00, 0x301B2300, 0xB79BB180, 0x1C596040, 0xF67E6A20, 0xE0ACD310, 0x4BD029B8, 0x32F8F444, 0xB1E9981E, 0x23B6941D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xE8000000, 0xDC000000, 0x32000000, 0xCB000000, 0xD1800000, 0x16C00000, 0x36A00000, 0x48700000, 0xB1D80000, 0x4D340000, 0x72BE0000, 0x5E670000, 0xDFD58000, 0xB72C4000, 0xA5A96000, 0x0EECD000, 0x9489B800, 0x8D5D9C00, 0x7F732E00, 0x82581900, 0x68F64580, 0xD19FD3C0, 0x06D7CE20, 0x7DAC8930, 0x9AE89D98, 0x6A899FDC, 0xEC58D81A, 0x51F54C07 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xE8000000, 0x4C000000, 0x8E000000, 0xD9000000, 0xA8800000, 0x52400000, 0x3EA00000, 0x3AB00000, 0x44E80000, 0x32740000, 0x070A0000, 0x83E70000, 0x91948000, 0x269C4000, 0x9D78E000, 0xA8ED3000, 0x4C71A800, 0x860EB400, 0x5F629A00, 0xE9D51100, 0x03391780, 0x58498A40, 0xCFC6FA20, 0xBA606110, 0xD7525F98, 0x9C790E74, 0x346B481A, 0x54308403 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x08000000, 0x6C000000, 0x22000000, 0xC9000000, 0x30800000, 0x47400000, 0x9EA00000, 0xFCB00000, 0x44F80000, 0x7D740000, 0x221A0000, 0xD0E70000, 0x72928000, 0x8F0B4000, 0xBF2FE000, 0xC7DF5000, 0xF8002800, 0x34011400, 0x2607B200, 0x9706D100, 0xD387EF80, 0xD2C2EAC0, 0xCB62D220, 0xEC56C110, 0x166A2798, 0x827FAEC4, 0x8535C822, 0x7339440B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x18000000, 0xA4000000, 0x1A000000, 0xC7000000, 0x46800000, 0x20400000, 0xBD600000, 0xC3900000, 0xBA880000, 0xC2540000, 0x312A0000, 0xA4E50000, 0x41528000, 0x1DA9C000, 0x6BA1A000, 0x16B21000, 0x587A1800, 0x154E6400, 0x8CF1FA00, 0x7219FF00, 0xA85A4E80, 0xA2384740, 0x0F28DA20, 0x39E72F10, 0xE0D37688, 0x6B6DF344, 0xEE829826, 0xCC42A439 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x18000000, 0x44000000, 0xEE000000, 0x29000000, 0x87800000, 0xE9400000, 0x6DA00000, 0x2BD00000, 0x44A80000, 0x54140000, 0x33CE0000, 0xFD270000, 0xD4128000, 0xF3CBC000, 0x9D22A000, 0x4411B000, 0xEBC86800, 0xD923CC00, 0xAA10C200, 0xC2CE7100, 0x5EA1E480, 0x4356C040, 0xAF6EE220, 0x75730130, 0x07F9AC98, 0xFB7F7C64, 0x46BCE826, 0xFADB0C21 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x78000000, 0xBC000000, 0x06000000, 0xC3000000, 0x39800000, 0xCD400000, 0x5AA00000, 0x34B00000, 0xBDB80000, 0xCB740000, 0xB7DA0000, 0x82250000, 0xA9718000, 0xFEDAC000, 0x26A26000, 0x52B1F000, 0x2EBAF800, 0xFAF67C00, 0xBE99B200, 0x6283F900, 0x58C67F80, 0xB9E3E0C0, 0x19105220, 0x728DC910, 0xC28F6788, 0xDA8EACDC, 0x3689783E, 0x388DBC3F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x88000000, 0x84000000, 0xAA000000, 0x41000000, 0x94800000, 0x8EC00000, 0x8C600000, 0xAB700000, 0xB2F80000, 0xA4340000, 0x36DE0000, 0xE0E10000, 0xE9B18000, 0xB0994000, 0x1447A000, 0xD9A71000, 0xDA932800, 0x77CE7400, 0x366E3E00, 0x70FEE700, 0xF1337D80, 0xD05F7CC0, 0xD3261E20, 0x5751B730, 0xFA2E75A8, 0x555B58FC, 0x8DA2A802, 0xC8973411 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xD8000000, 0x3C000000, 0x4A000000, 0xEB000000, 0xCF800000, 0x49400000, 0xB3E00000, 0xAB300000, 0x82580000, 0xE2F40000, 0x217A0000, 0x02610000, 0xF7778000, 0xAB3BC000, 0x3A006000, 0xD3069000, 0xE383B800, 0x6B41AC00, 0xBCE3D200, 0x12B20300, 0x6A1D4380, 0x7592D5C0, 0x0C8E3220, 0x7A9E5310, 0x0D511BA8, 0xA32A29EC, 0x58CC3816, 0xE7FE6C1F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x08000000, 0xDC000000, 0x8E000000, 0x23000000, 0x99800000, 0x02C00000, 0x32200000, 0x75900000, 0x1D280000, 0xBBD40000, 0x834E0000, 0xD5230000, 0x06158000, 0x86EF4000, 0x11716000, 0xC89A3000, 0x9E6CF800, 0xEF313C00, 0x7EF84E00, 0xBC9B3D00, 0x9C6E0A80, 0xDA33C040, 0x607AAE20, 0x7DD94D30, 0xDD8812B8, 0xA9048C5C, 0xB082F822, 0x72423C07 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xA8000000, 0x94000000, 0x06000000, 0xB1000000, 0x3B800000, 0x54C00000, 0x45E00000, 0xF9700000, 0x6B680000, 0x15340000, 0x86CE0000, 0xFFE50000, 0x1A738000, 0xC7EC4000, 0x7B752000, 0x046B7000, 0x83B42800, 0xCB8A6C00, 0xF1C76E00, 0xB864D300, 0x3CB11D80, 0xA50DDC40, 0x1087CE20, 0x3C42E330, 0x15A59588, 0x46D1806C, 0x16BC280A, 0xB30E6C15 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x88000000, 0x44000000, 0xC2000000, 0x77000000, 0x96800000, 0x2A400000, 0x13A00000, 0xCC300000, 0x46A80000, 0x79F40000, 0xC0CE0000, 0x03A70000, 0x84328000, 0x62AF4000, 0x2BF2A000, 0x3FCC5000, 0xD1269800, 0x6C702400, 0x060DAA00, 0x71468900, 0x53236380, 0xBB703040, 0x608B8A20, 0x43069930, 0x8C83DB98, 0xF1400464, 0x93269802, 0xDB702421 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xE8000000, 0x0C000000, 0xDE000000, 0x65000000, 0xB1800000, 0xD9400000, 0x2EE00000, 0xA3100000, 0xE6880000, 0x3DF40000, 0x9D9E0000, 0xCF7F0000, 0x0A6E8000, 0x0DE64000, 0xC391E000, 0xD44E3000, 0xED548800, 0xF2EA5C00, 0x8B247200, 0x4933A300, 0x9C393680, 0x4B8DE540, 0xB070FA20, 0x82D9FF30, 0xF09D4498, 0x22FE4664, 0x8529CC9A, 0xDA041A73 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x38000000, 0x54000000, 0xF6000000, 0x63000000, 0xAB800000, 0xAD400000, 0xF0E00000, 0x64500000, 0x99D80000, 0x40B40000, 0xCB8E0000, 0x1A690000, 0xB0BE8000, 0x44A6C000, 0x0E352000, 0x664FF000, 0xB048F800, 0x834B8C00, 0xB0CC6200, 0xD98DF300, 0xE76A4C80, 0xB43B9FC0, 0x70649A20, 0xFE967F30, 0x6E7E2EA8, 0xBD026CE4, 0x6480D6AE, 0x04C4E0E5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0x7C000000, 0xC6000000, 0x11000000, 0x25800000, 0x60400000, 0xC0600000, 0x61100000, 0xDD280000, 0x4D740000, 0x323A0000, 0xCD5F0000, 0xA4CC8000, 0x9A264000, 0x36706000, 0xE8BCF000, 0x859EA800, 0xB769BC00, 0x22135A00, 0x13AA1700, 0xBFB76E80, 0xF69AE440, 0x41EDF220, 0xC4D3AB10, 0x6D0C3498, 0xE404F354, 0xA2009CBA, 0xF3064F4F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xF8000000, 0x8C000000, 0xD6000000, 0x0B000000, 0xCB800000, 0xFEC00000, 0xA4A00000, 0xE0900000, 0xE1180000, 0x78340000, 0xBF8E0000, 0x862F0000, 0x06388000, 0xE266C000, 0x6833E000, 0xE788F000, 0x3A2D7800, 0x78394C00, 0x9D647E00, 0xF9B21100, 0xC448B680, 0x5E0EA7C0, 0xADE90620, 0x261B5D30, 0xC5B4C898, 0x7A48B6D4, 0x410FB09E, 0x6C6AFAD3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x88000000, 0x84000000, 0xC6000000, 0xF5000000, 0xC8800000, 0xEF400000, 0x13A00000, 0x79D00000, 0x31180000, 0x96740000, 0xF2CE0000, 0x286F0000, 0x433C8000, 0xC2654000, 0xE837A000, 0xFFEFF000, 0xA3FD4800, 0xFD021400, 0x8C87C200, 0x4942C100, 0x36A79880, 0x39504BC0, 0x5A5A8A20, 0x43D0D530, 0x7E185A98, 0xD1F68AF4, 0x3A0B1282, 0x230B9ED1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xD8000000, 0x3C000000, 0x16000000, 0x6D000000, 0xD6800000, 0x4CC00000, 0xEEE00000, 0xA8D00000, 0x1AE80000, 0xD0340000, 0x1F3E0000, 0x3C5D0000, 0x33CF8000, 0x1585C000, 0x9B436000, 0x2AA2F000, 0x33F1C800, 0x78592400, 0x69CC5E00, 0x96801B00, 0xACC5FC80, 0x7EE7F240, 0xC0D59620, 0xFEED3F30, 0xFA37A288, 0x643AE96C, 0x87DFEA96, 0xA98F0D7F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x68000000, 0x8C000000, 0x6E000000, 0xFF000000, 0x9B800000, 0xEF400000, 0xE1600000, 0xA7100000, 0xA2580000, 0xD8740000, 0x024A0000, 0xA5A90000, 0x07788000, 0xBF804000, 0xED45E000, 0x0063B000, 0x7B965800, 0x32988C00, 0x34539200, 0xD53D5F00, 0xC4606680, 0x09953FC0, 0x6B9DCA20, 0x0CD1D310, 0xA7F9F4A8, 0xB94160F4, 0xBA652CBA, 0x7E94ACF3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x98000000, 0x0C000000, 0xB2000000, 0x25000000, 0x69800000, 0xC3C00000, 0xA9600000, 0xDEF00000, 0xDEF80000, 0xD1940000, 0xDB0A0000, 0xD1ED0000, 0x35DB8000, 0x91C3C000, 0x5C66E000, 0xBF75D000, 0x39380800, 0x5EF67C00, 0x9EF8C600, 0xF197BF00, 0x6B0D0D80, 0x49EF2EC0, 0x39D8CE20, 0x23C5C310, 0x7967CB88, 0xD6F191EC, 0xFAFC4386, 0xF7902DD3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xA8000000, 0xC4000000, 0x9E000000, 0x11000000, 0xFE800000, 0x52C00000, 0x16E00000, 0xEF700000, 0x1AB80000, 0x78940000, 0x434A0000, 0x04E90000, 0x4B3C8000, 0xD5D64000, 0xF1EBA000, 0x3BBA3000, 0x9E176800, 0x8D8F6400, 0xB00B4E00, 0x474AFB00, 0x7AEAF180, 0xAA3E50C0, 0xD3562620, 0xCF2C9F10, 0x775D3FA8, 0xFE62EBD4, 0x78B7778A, 0x64D8FFE1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xE8000000, 0x4C000000, 0xAA000000, 0x6D000000, 0x34800000, 0x82C00000, 0x69A00000, 0xD3900000, 0xE9A80000, 0xE7340000, 0x76BE0000, 0xC85B0000, 0x4E288000, 0x42724000, 0x7A59E000, 0xF72B9000, 0xC8F6C800, 0xCB98D400, 0xC909CE00, 0x26231100, 0x3AD46680, 0x4F4B0240, 0xB5410620, 0xC4E0C530, 0xC37528B8, 0x94DA5354, 0x40EC809A, 0x61D05763 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xC8000000, 0x44000000, 0xFA000000, 0x83000000, 0x1A800000, 0xBD400000, 0x1FA00000, 0xBAD00000, 0x5BD80000, 0x4E740000, 0x8F8A0000, 0xBAED0000, 0x695D8000, 0xA7314000, 0xF22AA000, 0x7F3F1000, 0x5E05F800, 0x69006400, 0x01868200, 0x5BC62100, 0xD4E09080, 0x9872EDC0, 0x82897A20, 0x316B4510, 0x799B9288, 0x2D558CDC, 0x2D1B4A92, 0x6112B8C1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x98000000, 0x5C000000, 0xD2000000, 0x27000000, 0xAF800000, 0xA9400000, 0x1A600000, 0x19100000, 0xFD380000, 0x38740000, 0x39AE0000, 0xBB0F0000, 0xBC3E8000, 0xF6F5C000, 0x6E6B6000, 0x9EA9D000, 0xD4899800, 0x757CCC00, 0x7C958200, 0xEF7F4700, 0x3F946680, 0x3EFD3CC0, 0x6BD21A20, 0x681C8B30, 0xFA076498, 0xD303BBE4, 0x49831C86, 0x084767E7 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x28000000, 0x2C000000, 0x22000000, 0x03000000, 0xCA800000, 0x75400000, 0xC4200000, 0xB3100000, 0x61E80000, 0xA8340000, 0x627E0000, 0x0B990000, 0xF2EA8000, 0x8AB64000, 0x9B3AE000, 0xFDB9D000, 0x6AFAB800, 0x0DD86400, 0x644C4200, 0x58E7BD00, 0x18F3DE80, 0xEB9C6040, 0x82E8FA20, 0x12B6D930, 0x8F3D1CA8, 0xDBB99D44, 0x67FFC4AA, 0xE65A697B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x78000000, 0x14000000, 0xEA000000, 0xB3000000, 0x45800000, 0x24400000, 0x3BA00000, 0x47100000, 0x4F480000, 0x93B40000, 0x5BDA0000, 0xADBF0000, 0x2B488000, 0xF1B6C000, 0x34DF2000, 0xBE3D1000, 0x3A0E7800, 0xC2931C00, 0x4B0CCA00, 0x18137900, 0xB4CB4E80, 0x8EF39940, 0x46F8B220, 0xF36F6510, 0x6FE70498, 0xF4B22074, 0xD45EDCBE, 0x8AFAEC55 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x28000000, 0x54000000, 0x12000000, 0x5D000000, 0x69800000, 0xF0C00000, 0x96E00000, 0xD0F00000, 0x99780000, 0x69140000, 0xAD0A0000, 0xA12B0000, 0x663A8000, 0x70304000, 0x879B2000, 0x9DE65000, 0x9E778800, 0xE93F3C00, 0xE4B7DE00, 0x6EDEC300, 0x43C10580, 0xA462A6C0, 0xE6B25620, 0x5BDEFF10, 0x9E465BB8, 0xD6A725E4, 0x0552F3AA, 0xB6AA49C5 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x68000000, 0xAC000000, 0x22000000, 0x35000000, 0x28800000, 0xC6400000, 0xC4600000, 0x9DB00000, 0x73180000, 0xA6D40000, 0x1F2A0000, 0x390D0000, 0x1EDA8000, 0x3F744000, 0xA33AE000, 0x1203D000, 0x8D010800, 0xCC877400, 0xD8476A00, 0xBB649F00, 0x2C375380, 0xBFDBDDC0, 0x91F46220, 0x6E7AEB10, 0x11E0B988, 0x0F7602E4, 0x1B3B51BA, 0xF602A6FB } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xC8000000, 0x54000000, 0x0A000000, 0x3B000000, 0xF4800000, 0xF6C00000, 0xF2A00000, 0x0AB00000, 0xBBC80000, 0x21140000, 0x5AFE0000, 0xEA9F0000, 0x088C8000, 0x2AF74000, 0xC0A92000, 0x8F879000, 0xA245B800, 0xB4601400, 0xE0121E00, 0x2D7FF900, 0xC4DF3F80, 0x4AE80940, 0x7FE1A620, 0xE054ED30, 0x261FA198, 0x124FB074, 0xFE533992, 0xB7183465 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x08000000, 0x9C000000, 0xB2000000, 0xAB000000, 0xC9800000, 0x74C00000, 0xDCE00000, 0xD5F00000, 0x57380000, 0x0C140000, 0x924E0000, 0x2D6F0000, 0x8FF98000, 0xCAF14000, 0x60BA6000, 0x79D15000, 0xC82C7800, 0x63D87C00, 0xF5E60E00, 0x1F752300, 0x667A7D80, 0x6E33E4C0, 0xA45C7620, 0x48265F30, 0xB913F398, 0xEACC87DC, 0xB72BEBA2, 0x245AABD7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x98000000, 0xC4000000, 0xB6000000, 0x7D000000, 0x51800000, 0xFD400000, 0x0B200000, 0xB2100000, 0xD4080000, 0x16340000, 0x4C9A0000, 0x7BFF0000, 0x314A8000, 0x9911C000, 0x288BA000, 0x42F2F000, 0xEEFF8800, 0xECCADC00, 0xEE551200, 0xBCA94D00, 0xF266BE80, 0x2F346F40, 0xEB189A20, 0x9BB89110, 0xFBEB2C98, 0x4E47E264, 0x33A50486, 0x50D0CE61 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x48000000, 0x2C000000, 0x1E000000, 0xF1000000, 0x15800000, 0x4A400000, 0xD6E00000, 0x60500000, 0x38E80000, 0x25B40000, 0x0A3A0000, 0xAF990000, 0x60AA8000, 0xCC514000, 0x66EAE000, 0x74B73000, 0x8FBA2800, 0xADDA7C00, 0x9A4ECA00, 0xB2002300, 0xAF049480, 0x4486BE40, 0xCFC6E220, 0xD4A75F10, 0x9AB2DEA8, 0x46BADD64, 0xEC5816B2, 0x3A0E915B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xE8000000, 0x5C000000, 0xCE000000, 0xEF000000, 0x5F800000, 0x08400000, 0x82600000, 0xE4100000, 0xCD980000, 0xA9F40000, 0xF9CE0000, 0xB20B0000, 0xD62D8000, 0x4F5A4000, 0x21506000, 0xF97FB000, 0xB9265800, 0x37F0AC00, 0x2ECBEA00, 0x498E8700, 0x5469D680, 0x583859C0, 0xE7C03220, 0x42246B30, 0x2A725CB8, 0xFF896EFC, 0x3F6FBC9A, 0x9DBC9EE7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xA8000000, 0xCC000000, 0xF6000000, 0x37000000, 0x6F800000, 0xA1400000, 0xB6E00000, 0xFB500000, 0xB8180000, 0x9A340000, 0x460E0000, 0xCECF0000, 0x766E8000, 0xC05C4000, 0x2053E000, 0x119B7000, 0x54711800, 0x6B6D6C00, 0x06DF2200, 0x75902300, 0x0FBFE480, 0x278259C0, 0x3D40BA20, 0x88E10F30, 0x90532698, 0x89990AE4, 0xC076468A, 0x696A3AC3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x18000000, 0xA4000000, 0x36000000, 0xEB000000, 0xC3800000, 0x4BC00000, 0xFCA00000, 0xC7300000, 0xEDB80000, 0xAC140000, 0x0F4A0000, 0x52090000, 0xE1ED8000, 0x083BC000, 0x84D5A000, 0x5C6DF000, 0x24F83800, 0x91F7CC00, 0xD99E5600, 0x3360B100, 0x3D95D380, 0x798B72C0, 0x562BEE20, 0xC69CBD10, 0xEEE625A8, 0x815233DC, 0xA4AC05A6, 0x1FD903F9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x28000000, 0xC4000000, 0x62000000, 0x1D000000, 0xBC800000, 0x3EC00000, 0xEBE00000, 0x3F900000, 0x28A80000, 0xDCF40000, 0x93FA0000, 0x5EBD0000, 0xD21A8000, 0x482E4000, 0xBC35A000, 0xCB1DD000, 0xF6AE0800, 0x2FF31400, 0x247E6E00, 0x1BFEE300, 0x4ABDD680, 0xB81A8040, 0x012AE620, 0x4AB3B710, 0x2CDE1888, 0xC3CDB364, 0x33A338AA, 0x5BB72361 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0xA4000000, 0x36000000, 0x2F000000, 0x6F800000, 0x05C00000, 0x40A00000, 0xC9B00000, 0xD2580000, 0x8A940000, 0x9C2A0000, 0x396F0000, 0x638F8000, 0xE75E4000, 0x2811A000, 0xE76A7000, 0xA8899800, 0xDEDB2C00, 0x32D38600, 0xA04C1100, 0xC0F81780, 0x7A275DC0, 0x5EF59E20, 0x81B97D10, 0x76C23198, 0xC5253CCC, 0x497611BA, 0x187E0CF9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xF8000000, 0x64000000, 0x5E000000, 0x09000000, 0xFF800000, 0x9BC00000, 0xFFE00000, 0x4EF00000, 0x2F380000, 0x02940000, 0x980A0000, 0x114B0000, 0x94EE8000, 0x573EC000, 0x2692A000, 0x2608B000, 0x084F2800, 0x936F6C00, 0xA8FB8600, 0x87701B00, 0x61F9AD80, 0xD8F28CC0, 0x0A3A2E20, 0xCF11B710, 0xD8C88BB8, 0xDA2E27C4, 0x8D5EAB9E, 0xB4A357C9 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x78000000, 0x5C000000, 0x6A000000, 0x01000000, 0x82800000, 0x94C00000, 0x0AA00000, 0x0F100000, 0xDC380000, 0x0D340000, 0xF6EA0000, 0x412F0000, 0xCC098000, 0x735EC000, 0xD2006000, 0x7D061000, 0x7885A800, 0x1DC1E400, 0xAC26DE00, 0xADD5F900, 0xBD9B9280, 0x81A20EC0, 0x3C92F620, 0xD27EDD10, 0x3F572C98, 0xE15EE7FC, 0xCF054CBE, 0xF583F7C7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x88000000, 0x14000000, 0xA2000000, 0x49000000, 0x4A800000, 0xC3400000, 0xFE600000, 0xC5B00000, 0x84B80000, 0xAB540000, 0xF74E0000, 0xFD0F0000, 0x89EF8000, 0xEF1D4000, 0x25C42000, 0xC321D000, 0xA4D02800, 0x508E2400, 0x6729A200, 0x3FB85F00, 0x50D43B80, 0x828D50C0, 0xC62E0A20, 0xD13F3B30, 0xB997B998, 0x21EBDFEC, 0xEB1D9982, 0xDFC50FF5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xE8000000, 0xEC000000, 0x62000000, 0x4F000000, 0xC6800000, 0xE1400000, 0x8A200000, 0x88F00000, 0xC4280000, 0xEA540000, 0xD09E0000, 0x55DB0000, 0xE1F98000, 0x4C0A4000, 0x9DA1E000, 0xDA36D000, 0xC2CED800, 0x31428400, 0x32204200, 0x1CF36D00, 0xD22F9180, 0xC3527640, 0xD71F1A20, 0x5F1FA930, 0x031833B8, 0x6918CB5C, 0xBA19D39A, 0xF69E1B4B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x68000000, 0x6C000000, 0x32000000, 0xAD000000, 0x35800000, 0x12400000, 0x9E200000, 0x24900000, 0xA4180000, 0x59340000, 0x11CE0000, 0xC18F0000, 0x3AAF8000, 0x97BA4000, 0xCBE7E000, 0xA5F25000, 0xFB2BC800, 0x13F99C00, 0x76C64A00, 0xF3E7C500, 0xD1F26280, 0xAD2B47C0, 0x50FA0220, 0xB4401930, 0x1525C898, 0x5A15D2EC, 0xA8DA28BA, 0x7BD382EB } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xE8000000, 0x5C000000, 0x92000000, 0xE5000000, 0x75800000, 0xDDC00000, 0xB7A00000, 0xFE900000, 0x50F80000, 0xA9B40000, 0xAE2A0000, 0x2F2B0000, 0x2CA98000, 0x226E4000, 0xD34C6000, 0x469D5000, 0x22840800, 0x1D401C00, 0xE7E07600, 0xD0F78900, 0x3FCCAE80, 0x2CDF20C0, 0x55E7FE20, 0x65F2D510, 0xB24938B8, 0xB51BB9FC, 0xC443389A, 0xB060B9C7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0x3C000000, 0xA6000000, 0xAD000000, 0x67800000, 0xDBC00000, 0xD4A00000, 0x5E500000, 0x00580000, 0x70740000, 0xDA4A0000, 0x3B4F0000, 0xA2CA8000, 0x00094000, 0xB9286000, 0xBFB8F000, 0x9DC14800, 0xA9A62C00, 0xD1D4A600, 0x779CE100, 0x8AD6E880, 0x1518FDC0, 0xFA956E20, 0xA47C8D10, 0x6960AE98, 0x07F5ACE4, 0xC98AAE82, 0xB3EAACDF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x28000000, 0x94000000, 0x82000000, 0xA1000000, 0x13800000, 0x69400000, 0x90200000, 0x7D700000, 0xA7580000, 0x6BD40000, 0x52EA0000, 0x8CEF0000, 0x2BEC8000, 0x536C4000, 0x4CAB2000, 0x0C4AD000, 0xBD5F6800, 0x66D6EC00, 0x1F6C3200, 0x02AD6500, 0xA3484580, 0x61DB95C0, 0x8315DA20, 0x4288C910, 0xB63BD798, 0x328460D4, 0x3AC3D7AA, 0x996060F5 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xB8000000, 0x94000000, 0x0A000000, 0x0B000000, 0x04800000, 0x7CC00000, 0x02200000, 0x09D00000, 0xB3980000, 0xE0740000, 0xD00A0000, 0xE20B0000, 0x3D0B8000, 0xD38CC000, 0x14482000, 0xAAE91000, 0x4BFDB800, 0xF0459400, 0x12E20E00, 0x75F3DD00, 0x0B4F6480, 0xE46B27C0, 0xDC3E3620, 0x46E18910, 0xDFF6CAB8, 0x50492AEC, 0xE8EECA8E, 0x8CFD2AF5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0xC8000000, 0x24000000, 0x62000000, 0x07000000, 0x13800000, 0xEC400000, 0xA8A00000, 0x6DF00000, 0x2D080000, 0x5DD40000, 0xE93E0000, 0x793B0000, 0x913C8000, 0x853B4000, 0xFF3AA000, 0x143ED000, 0x41BCD800, 0xC8FF6C00, 0x74D8AA00, 0xE6EA1100, 0x8F035980, 0x17801B40, 0xBE46F220, 0xB7A53D30, 0x9275D3B8, 0x874B9A74, 0x9075D392, 0x904B9A79 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xA8000000, 0x3C000000, 0xE2000000, 0x51000000, 0x84800000, 0xD1400000, 0x29A00000, 0xE2900000, 0xBFA80000, 0x00B40000, 0x5BFA0000, 0x02790000, 0x5DBF8000, 0x685E4000, 0xF5EB6000, 0x8090D000, 0xAEA8A800, 0x24371400, 0xBABC3200, 0x83DD5100, 0x832E4280, 0x35F5C640, 0xA4591A20, 0x5FE90510, 0x7D9490A8, 0x502B074C, 0x3071108A, 0xC99C475F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x68000000, 0x6C000000, 0x92000000, 0x6D000000, 0x94800000, 0x51C00000, 0x25600000, 0xCB500000, 0xD9680000, 0x01B40000, 0x847E0000, 0xE7FD0000, 0x73BF8000, 0xF9984000, 0x9F6DE000, 0xAAB15000, 0x7BF9C800, 0x69B89400, 0x689AD600, 0x41E95700, 0x92726880, 0x341FF240, 0x0C2A9E20, 0x6D108330, 0x4E4CDE88, 0xBBC6B56C, 0x3C655EBA, 0xE9D7F56B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x98000000, 0x9C000000, 0xF6000000, 0x49000000, 0x20800000, 0x01400000, 0x84A00000, 0x88B00000, 0x9DF80000, 0xA7940000, 0x1F8A0000, 0x440F0000, 0x66C88000, 0xCCA9C000, 0xE07F6000, 0x5450F000, 0x096DE800, 0x9F9F1400, 0x1F455200, 0x39A1F900, 0xEA31D380, 0xF7BE7CC0, 0xB8B23A20, 0x95FC2D10, 0xC3916198, 0xA58DB5F4, 0x630BE186, 0x934F75F7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x58000000, 0x7C000000, 0x2A000000, 0x73000000, 0xE2800000, 0xD6400000, 0x58E00000, 0x1EF00000, 0x11280000, 0x30540000, 0x673A0000, 0x178F0000, 0x72468000, 0x4EE3C000, 0x27F06000, 0x90AB1000, 0x5C96B800, 0x959FA400, 0x7B9B7A00, 0x0E98CB00, 0x8D1E9180, 0xA6DA9C40, 0xB8FDA220, 0x27AC7F10, 0xB8135398, 0x22DDF344, 0xDEF849B6, 0x56AE284F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x78000000, 0x74000000, 0x9E000000, 0x67000000, 0x17800000, 0xB2400000, 0xD8E00000, 0xC3100000, 0xC5880000, 0x91B40000, 0x8A7E0000, 0x992B0000, 0xB1418000, 0x9962C000, 0xFA572000, 0x90ECB000, 0x61E75800, 0x9391EC00, 0xF04D5A00, 0xF312C300, 0x9D8EF680, 0x75B5D940, 0x1C7D2220, 0xF22F9F30, 0x4CC4F4B8, 0xD226F65C, 0x52368EBE, 0xF63C856D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xE8000000, 0x24000000, 0xC2000000, 0x21000000, 0xEB800000, 0xB0400000, 0x29200000, 0x5DD00000, 0x2A280000, 0x0CB40000, 0x6ADA0000, 0xF1490000, 0x19448000, 0x56A04000, 0x3796A000, 0xBE0BD000, 0xB4E36800, 0x37B26C00, 0xDC5F9A00, 0x54899D00, 0xFF217080, 0xE6D3BA40, 0xDCAA5220, 0x09702110, 0xDCBD82A8, 0xA9384B54, 0xD67CB89A, 0x23DE0659 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xA8000000, 0x24000000, 0xDE000000, 0xD1000000, 0x23800000, 0x0BC00000, 0x3D600000, 0x85F00000, 0x38280000, 0x07540000, 0x36BE0000, 0x2F8F0000, 0xE4428000, 0x6CA04000, 0xC792A000, 0xF75B3000, 0x9B3EE800, 0xFD4CCC00, 0xAEA12600, 0x8493FF00, 0x9FDBAD80, 0xAC789440, 0x916D6E20, 0x1A740330, 0xD1EC6398, 0xC933A744, 0x03C9E58A, 0xBCE06879 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x58000000, 0x9C000000, 0x2A000000, 0x87000000, 0xDE800000, 0x40C00000, 0x4BE00000, 0xEE300000, 0xAA480000, 0x7F140000, 0x109E0000, 0x19EF0000, 0x9F038000, 0xE287C000, 0x3AC66000, 0xA4E21000, 0xF4B21800, 0x5C8B4400, 0x99F36E00, 0xA72E9300, 0x2DE48380, 0xEB328B40, 0x57CF1620, 0x6753C730, 0xEEBBF598, 0x79B85C4C, 0x6F3B7BB6, 0xBBF81F57 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x58000000, 0x64000000, 0xE2000000, 0xFB000000, 0xC5800000, 0x4F400000, 0x27A00000, 0x05B00000, 0x3DD80000, 0x3F540000, 0x8CCA0000, 0x8EBB0000, 0x8F028000, 0x3F87C000, 0x3040A000, 0x90215000, 0xE9F63800, 0xBBFA1C00, 0x97A6B200, 0x6DB2C900, 0x71DB7B80, 0x715229C0, 0xA9C82A20, 0x363D8510, 0x1CC1F1B8, 0x69E1FCE4, 0x989763B6, 0xC0AAA5C9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x18000000, 0x54000000, 0xCE000000, 0x85000000, 0xC2800000, 0xEBC00000, 0x9A600000, 0x6D500000, 0xDCB80000, 0x1AF40000, 0x028E0000, 0x439D0000, 0xEC068000, 0xCA07C000, 0x73072000, 0x83823000, 0xFF464800, 0xA0A2C400, 0xFBB50600, 0xDF2EEF00, 0x9EAE2080, 0x9EEF68C0, 0x07CC6E20, 0xD83A1B30, 0xF8336E88, 0xE06E43E4, 0x1E09C8A6, 0xF5585CE5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0x2C000000, 0x0A000000, 0x0F000000, 0xF8800000, 0x77400000, 0x3BE00000, 0xC0700000, 0xD9C80000, 0x1ED40000, 0x395A0000, 0xB1EF0000, 0xD0058000, 0x58014000, 0x3401E000, 0x5E039000, 0x21015800, 0xD186F400, 0x8AC39200, 0xBB266300, 0x74527D80, 0x551CAB40, 0x3C8B2A20, 0x3E370710, 0x4FAAB798, 0x46633C5C, 0x00B745A2, 0x0DE88F5B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x78000000, 0x9C000000, 0xD2000000, 0x83000000, 0xED800000, 0x74400000, 0x16A00000, 0x36100000, 0x77280000, 0x9AF40000, 0x469A0000, 0xD54F0000, 0x02878000, 0x13C2C000, 0x2DE66000, 0x5734D000, 0x527B3800, 0x58F91C00, 0xCF3F2A00, 0x9CDEC100, 0xE2E9FE80, 0x4217EE40, 0x512A7220, 0x7FF70D10, 0x2E1FEC98, 0xF98B334C, 0x40E126BE, 0xFBB3E277 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x98000000, 0xFC000000, 0xF6000000, 0x83000000, 0xCF800000, 0x83400000, 0x39200000, 0x9A700000, 0x61F80000, 0x7A140000, 0x8FAA0000, 0x411B0000, 0x26828000, 0xE9C1C000, 0x8EE46000, 0x8397F000, 0x2FEF3800, 0xC7BA2C00, 0x37B1B200, 0xD51EAD00, 0x64813580, 0x18C49CC0, 0x5862EA20, 0x22577110, 0x250DBFB8, 0xDE2F1DE4, 0xF55AED86, 0xA22780EF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xC8000000, 0x8C000000, 0xF6000000, 0x2D000000, 0xAA800000, 0xC9400000, 0x3CA00000, 0xFD100000, 0xDCC80000, 0x75F40000, 0xAFFE0000, 0xC96B0000, 0x78658000, 0x71774000, 0x3FBCE000, 0x0D4A7000, 0xEB314800, 0x289F8400, 0x759C1200, 0xD71E1900, 0x725BD680, 0x48F81940, 0x50EFBA20, 0xAAA0ED30, 0xE0130CB8, 0x5E4EC47C, 0xC0B49E92, 0xAD5C9D53 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xE8000000, 0x24000000, 0x5E000000, 0xE3000000, 0x19800000, 0xD8C00000, 0xEA200000, 0x63900000, 0x46F80000, 0xDA740000, 0xB2CA0000, 0x59DD0000, 0x77648000, 0xA3744000, 0x264AA000, 0xE39B3000, 0xC0077800, 0x60001C00, 0x7000AE00, 0xB8054500, 0xCC037680, 0x7A0070C0, 0xBD077620, 0xFA836910, 0xC1402088, 0x32E169D4, 0x89B60E9A, 0x25696CD9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xF8000000, 0x24000000, 0x8E000000, 0x75000000, 0x8E800000, 0xB1C00000, 0x68A00000, 0x59B00000, 0xC4180000, 0x2DD40000, 0x0F8A0000, 0x67BB0000, 0xD7E18000, 0xC0D2C000, 0x1509A000, 0x40783000, 0x1E434800, 0x61E42400, 0x31D2D600, 0x058CD900, 0x8CB9D780, 0x2463BBC0, 0x23923E20, 0x666BCD10, 0x8A69C9B8, 0x786986FC, 0xB7689F9E, 0xCAE89FD9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x28000000, 0x4C000000, 0x9E000000, 0x19000000, 0x96800000, 0x67C00000, 0xE9E00000, 0x28500000, 0x65980000, 0x27740000, 0x86AE0000, 0xD77D0000, 0xF6A28000, 0x67764000, 0x66ABE000, 0xE7793000, 0xCEA1E800, 0x03752400, 0xB4AE8600, 0x607EF300, 0x4127E880, 0xF236CDC0, 0x3A8A8E20, 0xA1CFE730, 0x0CEA0688, 0xB0DB5AC4, 0x9B5000AA, 0xF01AE9E3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x88000000, 0xCC000000, 0xC6000000, 0xB9000000, 0xDF800000, 0x0AC00000, 0x41600000, 0x0DB00000, 0x0D680000, 0x43140000, 0x303E0000, 0x2C0D0000, 0x9EA38000, 0xA5534000, 0x1B1EE000, 0x2C9FF000, 0x3A5DE800, 0x253DAC00, 0xE5892E00, 0xB567FF00, 0x4FB26780, 0x9E6EA640, 0xD3942620, 0xD478A330, 0x742D2188, 0x1EB3B54C, 0x5DEF8F82, 0x87530A43 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xE8000000, 0x34000000, 0x66000000, 0x5D000000, 0x03800000, 0xF8C00000, 0x5EA00000, 0xBC900000, 0xD6880000, 0xDBF40000, 0x853E0000, 0x822D0000, 0xB0648000, 0x47304000, 0x959E2000, 0x77BEF000, 0xD36E0800, 0xD1018C00, 0x79879E00, 0xD7C0C100, 0xB6225E80, 0xF2D65740, 0x4769B620, 0xA702BD30, 0xEC874888, 0x30435A74, 0xC0E4569A, 0xC573DB7D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x38000000, 0x64000000, 0x96000000, 0x11000000, 0x4D800000, 0xF5400000, 0x99E00000, 0x4CD00000, 0x3E580000, 0x1D740000, 0x2CEA0000, 0x19BF0000, 0xACA18000, 0xF530C000, 0xE28FA000, 0xEB2EF000, 0x6D9C6800, 0xC750FC00, 0x321D1200, 0x05176B00, 0xAF78C080, 0x6503C7C0, 0x5384DA20, 0xD8466710, 0xD6603A98, 0x069090FC, 0x9F3CA8AE, 0x7F673BC9 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xD8000000, 0xB4000000, 0x8E000000, 0x49000000, 0x70800000, 0xBEC00000, 0x2F200000, 0x47300000, 0x59780000, 0x19D40000, 0x34EE0000, 0xBBD90000, 0x7EA38000, 0x2575C000, 0x52992000, 0x86C73000, 0xCB272800, 0x81375400, 0x4C7A4E00, 0x8B527500, 0xF92FEB80, 0x237B34C0, 0xBED24620, 0x9D6F1130, 0x9D9F0DA8, 0x8342D5CC, 0x77654396, 0x8BD0A0DD } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x08000000, 0x9C000000, 0x8A000000, 0x71000000, 0x0E800000, 0x5CC00000, 0x83600000, 0x31900000, 0x75280000, 0x51340000, 0x865A0000, 0x50CF0000, 0x90668000, 0x82114000, 0xC56F6000, 0x73909000, 0xB82D2800, 0xA5B7C400, 0xB39FBE00, 0x4928A700, 0xEB317E80, 0x8F584440, 0xDA4FF620, 0xD2A4F310, 0x66776898, 0x017D6744, 0x25FAD6A2, 0x383EC077 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xB8000000, 0xF4000000, 0x36000000, 0xB7000000, 0x99800000, 0x6BC00000, 0xA8200000, 0xAC500000, 0x7DF80000, 0x92B40000, 0xBD0A0000, 0x1C5F0000, 0xAD208000, 0xFCD4C000, 0xC4BA2000, 0x62D6F000, 0x1FBDD800, 0x8955DC00, 0x9D7BD600, 0x43F6F500, 0x0169D080, 0x7CEE80C0, 0xB92E2E20, 0xE20ED910, 0x89DD5E98, 0x64E269F4, 0x05F4888E, 0xFE6F9CED } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x28000000, 0xEC000000, 0xEA000000, 0xC5000000, 0x97800000, 0xB4400000, 0x6DA00000, 0x2D300000, 0x32080000, 0x03540000, 0x56DE0000, 0xB9CB0000, 0xF6B08000, 0x1C484000, 0x33F6E000, 0x786A9000, 0x11830800, 0x5B400C00, 0xDF229A00, 0x5EF41900, 0xC3EE6780, 0xAFC21740, 0xA3E7F220, 0x4D96C530, 0x34B915B8, 0x471C9254, 0x112807AA, 0xBFA0C74B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xD8000000, 0x84000000, 0xC6000000, 0xED000000, 0xF2800000, 0xB1C00000, 0x53200000, 0xC0500000, 0x9F880000, 0x40340000, 0xA53E0000, 0x68C90000, 0x6CD28000, 0x274DC000, 0x9795A000, 0xF1AE7000, 0x0AE48800, 0x1F730400, 0x65DF1600, 0x60BAC500, 0xE48EE880, 0xE7B7A340, 0xD27CBE20, 0x842A7130, 0x4EA0D6A8, 0xC8101244, 0xD2E9C896, 0x58041351 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x24000000, 0xCE000000, 0xC9000000, 0x0B800000, 0xEDC00000, 0xFDA00000, 0x0A500000, 0x41680000, 0xF9B40000, 0x3F5A0000, 0xE12F0000, 0x54D68000, 0x052A4000, 0xBAD6A000, 0xBC2FB000, 0xC9532800, 0x1DED8C00, 0xDEF31600, 0x10BA5900, 0x5D1D5080, 0x0F4B6040, 0x72201E20, 0x19922510, 0x6DCBCE98, 0xA4630544, 0x11F570BA, 0xC63A9059 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x28000000, 0x74000000, 0x6E000000, 0x55000000, 0x6E800000, 0xA9400000, 0x4C600000, 0xE1D00000, 0x8EB80000, 0xA2740000, 0x4E4E0000, 0xB7790000, 0x5A548000, 0x897A4000, 0xE7542000, 0x33FAB000, 0xF0114800, 0x029B2400, 0x0B44D200, 0x4B609F00, 0xB0560080, 0x8A7CD4C0, 0x20D53A20, 0x3E3B4B30, 0x0637BAA8, 0xE0ADDFF4, 0xCDEEA0AA, 0xD78824ED } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x38000000, 0xF4000000, 0x12000000, 0xE9000000, 0x82800000, 0x8C400000, 0x77200000, 0xFB700000, 0x4C580000, 0xBE940000, 0xE24A0000, 0x799D0000, 0x4E768000, 0x50DAC000, 0x1DD22000, 0xFCEBD000, 0x5D2C2800, 0x8FCDA400, 0xFC5D7A00, 0xD690C500, 0x0E4D7D80, 0x8F9911C0, 0x8D75F220, 0xCF5C7110, 0x01160F88, 0xEE8BA0C4, 0x53FBDDAE, 0xB4A101ED } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x08000000, 0x44000000, 0xCE000000, 0x47000000, 0x6F800000, 0x35400000, 0x68200000, 0x6D300000, 0xDAB80000, 0x11D40000, 0x6DEE0000, 0xC1FF0000, 0x2EF48000, 0x075D4000, 0xBA03A000, 0x9106B000, 0x04835800, 0x00C1AC00, 0xDC65A200, 0x69902500, 0x234FCF80, 0xD10A06C0, 0x16A9DA20, 0x2EDE7930, 0x4C449598, 0x38A23FF4, 0xCBF46FA2, 0xD5D8B6E1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xC8000000, 0xD4000000, 0x72000000, 0xBB000000, 0x0C800000, 0xADC00000, 0x96E00000, 0xFF900000, 0x59E80000, 0x0A340000, 0x8E5E0000, 0xB2290000, 0xC5D58000, 0x5E4D4000, 0xA6802000, 0x9AC45000, 0xA4603800, 0x7752D400, 0x168D6600, 0x49E3AB00, 0x29176680, 0xCB2BCE40, 0xDA50FE20, 0x7B0C6F30, 0xD7A418A8, 0x54B7E17C, 0xA89F4692, 0x404B9E45 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x38000000, 0x7C000000, 0xAE000000, 0x81000000, 0xF6800000, 0x81C00000, 0xC2600000, 0x48300000, 0x90E80000, 0x23140000, 0x727A0000, 0x6B2B0000, 0xCA768000, 0x7FCCC000, 0xB3806000, 0xE5463000, 0x8CA12800, 0xEDD1A400, 0x979CB600, 0x8C5A4F00, 0x753A8B80, 0x408B9240, 0xE4237E20, 0x65151B10, 0x177D75B8, 0xBFAD4944, 0x4CB2EBAE, 0x8E29A24F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xA8000000, 0x44000000, 0x2E000000, 0x1D000000, 0x09800000, 0x3FC00000, 0x73E00000, 0x6FF00000, 0x60A80000, 0xDC540000, 0xF27A0000, 0xE36D0000, 0xDDB18000, 0x628E4000, 0x0D40A000, 0xACA1B000, 0x8C568800, 0xEA7C9C00, 0x2F692600, 0x47B71B00, 0xF988BD80, 0x5DC30C40, 0xB4E68E20, 0xDD707710, 0xFFEDB388, 0x1FF43B7C, 0x88A81D8A, 0xB852BC41 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0x84000000, 0xBE000000, 0x81000000, 0x57800000, 0x73400000, 0x23E00000, 0xA4900000, 0x48A80000, 0xA5B40000, 0x819A0000, 0x7FEF0000, 0x18528000, 0x540D4000, 0x78C7A000, 0xC2A73000, 0xCC776800, 0x9CBFEC00, 0x44DA2200, 0x190D8B00, 0x3544F280, 0x7EE14840, 0x21106A20, 0x10EC1710, 0x66D41898, 0x04CB1F64, 0x8E635282, 0xC8D67871 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xB8000000, 0x4C000000, 0x7E000000, 0xD1000000, 0x7C800000, 0x91C00000, 0xABA00000, 0x7F700000, 0x45880000, 0x2B940000, 0x1F9E0000, 0x0F490000, 0xDFB18000, 0x82AEC000, 0xAD20E000, 0x75B3B000, 0xD1AC2800, 0x66A5F400, 0x75F23600, 0x514F5100, 0xBEB0E180, 0xE62EB740, 0x00E77E20, 0x1813D530, 0x33D81FA8, 0x21AAA25C, 0x1EA6018E, 0x99F00763 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x28000000, 0x4C000000, 0x9E000000, 0xF1000000, 0xE5800000, 0x58C00000, 0xB5E00000, 0xCF100000, 0x71B80000, 0xC5B40000, 0xD48E0000, 0xF67F0000, 0xDCD08000, 0xA2DC4000, 0xE8E7E000, 0x24913000, 0x907FA800, 0x89D73C00, 0xF55EFE00, 0x8F206B00, 0xADF3E280, 0xAE292CC0, 0x8B4E3620, 0xBB1E2730, 0x00835498, 0xB7444BD4, 0xD62202AA, 0xC4731CE3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xA8000000, 0xA4000000, 0xC2000000, 0x77000000, 0x40800000, 0xC0400000, 0xC0A00000, 0xDA700000, 0xF1E80000, 0x25140000, 0x1FFA0000, 0x846B0000, 0x92D28000, 0xBF984000, 0xCEFAA000, 0xD1E9D000, 0x1512D800, 0xC7F8B400, 0x18696A00, 0x5CD55900, 0xAE99A580, 0x3B788040, 0x26299220, 0x55777D10, 0x1D6A37B8, 0xF354FD64, 0x5259258A, 0x659FC079 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x48000000, 0x74000000, 0x46000000, 0xFF000000, 0x46800000, 0xEA400000, 0xDC600000, 0x02900000, 0x2B880000, 0x99340000, 0xEFBA0000, 0xD10B0000, 0x01738000, 0x6ADF4000, 0xDA1D2000, 0xCE3BF000, 0xB1CF1800, 0xAD572400, 0xC9285A00, 0x44844F00, 0x5B412280, 0xF1E3C540, 0x5853E220, 0xAAACDB10, 0x7540C0B8, 0x6AE01E6C, 0x40D2A2B2, 0x33EC854D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x68000000, 0xCC000000, 0x7A000000, 0x9D000000, 0x58800000, 0xD3C00000, 0xE4A00000, 0xDD300000, 0x08E80000, 0x53D40000, 0x983E0000, 0x786B0000, 0x6C128000, 0xF69A4000, 0x405DE000, 0x987A1000, 0xC08CC800, 0xDBC2F400, 0xF8A36600, 0x2F33A900, 0x49ECC380, 0x1957E440, 0x1AFECE20, 0xBE4A0D30, 0xFFE40DB8, 0x4252E944, 0x1D7E43BA, 0xEC0DA443 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xA8000000, 0x34000000, 0x12000000, 0x37000000, 0xC6800000, 0x04C00000, 0xBAE00000, 0x4E700000, 0xE2180000, 0x1DD40000, 0xB2CA0000, 0x0A9D0000, 0xB8118000, 0x63AE4000, 0x75AB2000, 0x98AC5000, 0x8D2A5800, 0x056F8400, 0x104CCE00, 0x045E3B00, 0x89F09180, 0x3D5BA9C0, 0x1E763620, 0xFA1EAF10, 0xA1D4A788, 0x64CC06FC, 0x8799118A, 0x7D91E9DD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xC8000000, 0x94000000, 0x6A000000, 0xED000000, 0x9F800000, 0x31400000, 0x21A00000, 0x4B500000, 0x2E680000, 0x13340000, 0x1F5A0000, 0x356B0000, 0x3FB58000, 0xA69B4000, 0xEF0C2000, 0xA7809000, 0x2D408800, 0x3FA78C00, 0xBC507200, 0x94E87900, 0x29F4DC80, 0x65BFCC40, 0xB29B5A20, 0xC50B2510, 0xAA8786B8, 0xC2C0E95C, 0xC6E6DC92, 0x09F0CC75 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xB8000000, 0x44000000, 0x46000000, 0xF7000000, 0xA1800000, 0xC9C00000, 0x1D200000, 0xE6100000, 0x89B80000, 0x4A740000, 0xA1CA0000, 0x4AB90000, 0x55F18000, 0x7B0AC000, 0x401CA000, 0x35267000, 0x0A175800, 0x63BF9C00, 0xF7758600, 0x4D4FBD00, 0xD7FD6280, 0x9196E2C0, 0x1F7DFE20, 0x5AD19110, 0xC4189CA8, 0x932373FC, 0xAD17628E, 0x8A3FE2C1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x48000000, 0xEC000000, 0xAA000000, 0x69000000, 0xF6800000, 0xBEC00000, 0xCCE00000, 0x18700000, 0x2D580000, 0x13D40000, 0x228A0000, 0x935F0000, 0x54D58000, 0xEB0B4000, 0x201BE000, 0x1D729000, 0x31DF6800, 0xA4110400, 0x68E82E00, 0x7DE8BB00, 0x596D3180, 0x4AABA3C0, 0x46CB2620, 0x6B7B6F10, 0xF9461798, 0x10A0CCDC, 0x045531B2, 0xA6CFA3EB } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x78000000, 0x84000000, 0x0A000000, 0xFD000000, 0x40800000, 0x9C400000, 0xBEE00000, 0xAE900000, 0xBD480000, 0xCFB40000, 0xAEFE0000, 0xDF4F0000, 0x0EB68000, 0x007EC000, 0x240FA000, 0x75D51000, 0xF62D0800, 0xB1E5F400, 0x57121A00, 0x0B8CFB00, 0x80176280, 0x860E8740, 0xD4D03220, 0xC8A9DF30, 0x32A75098, 0xA8775864, 0xF7DF62BE, 0xE8FA8751 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x38000000, 0xBC000000, 0x2A000000, 0xA1000000, 0x75800000, 0x14C00000, 0x31A00000, 0xDEB00000, 0xBA080000, 0x21540000, 0xD35E0000, 0x860D0000, 0xCB528000, 0x525EC000, 0xE3886000, 0xE7921000, 0xDFFE2800, 0x173A9C00, 0xFC9FBE00, 0x8B280900, 0xD0A2CF80, 0x4B36E340, 0x9ECD7620, 0x38F74530, 0x89EFB988, 0xAA01A644, 0x6102CFAE, 0x5586E35F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x18000000, 0xA4000000, 0x32000000, 0x75000000, 0xBB800000, 0xC2C00000, 0xA2200000, 0xE8300000, 0xFDA80000, 0xD8540000, 0xA5FE0000, 0xBDAB0000, 0xF8578000, 0xF5F9C000, 0x15ABA000, 0x4456D000, 0x63FF4800, 0x52AFEC00, 0x8AD36E00, 0x1ABF8500, 0x324EBB80, 0xC0C19240, 0x0F260620, 0x17B07930, 0xBD68BDB8, 0x1771EB6C, 0x524EBBA6, 0xB0C19259 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xF8000000, 0x4C000000, 0xCE000000, 0xAD000000, 0xED800000, 0x2F400000, 0xFE600000, 0xB6900000, 0x22980000, 0x829C0000, 0xD29E0000, 0x3A9D0000, 0xFE9E8000, 0x84994000, 0xAB9B2000, 0x251D5000, 0x4AD83800, 0x767F5400, 0x11CE2E00, 0x7BA1DD00, 0x6D306980, 0x1FAB7D40, 0x753069A0, 0x63AB7D50, 0x233069B8, 0xF2AB7D4C, 0xF8B06986, 0x3CEB7D5F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0xC8000000, 0x1C000000, 0xBA000000, 0xFF000000, 0x99800000, 0x1C400000, 0xECA00000, 0x8B900000, 0xD8380000, 0x703C0000, 0x1C3E0000, 0x8E390000, 0x5D388000, 0xB6BEC000, 0x49FE2000, 0x86DBF000, 0xEE0C0800, 0x4310C400, 0xA4FC2600, 0x8C5D4300, 0xF9CC1F80, 0x60F45E40, 0x284C1FA0, 0x20B45E50, 0x9EEC1F98, 0x64245E5C, 0x17541FAA, 0x14585E5B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x48000000, 0xE4000000, 0x9E000000, 0x8F000000, 0x52800000, 0x01400000, 0xADA00000, 0x0C100000, 0x15A80000, 0x2DAC0000, 0x41AA0000, 0x9BAF0000, 0x7AA88000, 0xEF2AC000, 0x58EDE000, 0x6A091000, 0x44BD6800, 0x0F87FC00, 0x36C3F600, 0xF7609B00, 0x2175FB80, 0xD5DAD6C0, 0x6DF5FBA0, 0x9B9AD6F0, 0x32D5FB88, 0x66CAD6CC, 0xC2DDFB9A, 0xA376D6F5 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xE8000000, 0xB4000000, 0xB6000000, 0x31000000, 0x5E800000, 0x73400000, 0x36E00000, 0x50300000, 0xF4D80000, 0xB0DC0000, 0x9EDA0000, 0x43DF0000, 0xE75F8000, 0x4F18C000, 0x147D6000, 0xEE88D000, 0x30715800, 0xCBBFAC00, 0xB42E3600, 0xD5248100, 0xB8978080, 0x6E89E640, 0xF07780A0, 0x6BB9E670, 0xA42F8088, 0x3D25E674, 0x0C9580B2, 0xD88AE659 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x58000000, 0xF4000000, 0x52000000, 0xE7000000, 0xBA800000, 0xADC00000, 0x31600000, 0x39300000, 0xA8880000, 0xAA8C0000, 0x558E0000, 0x7B0D0000, 0x54CB8000, 0xDAA94000, 0xAD1EE000, 0xFA547000, 0x86BF4800, 0x50849C00, 0x2EC4F200, 0xE1E2F900, 0x57F47080, 0x296AD4C0, 0x2D7C70A0, 0x24E6D4D0, 0xA27270B8, 0x222BD4E4, 0x9FD9F0AE, 0x35B294D9 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x28000000, 0xCC000000, 0x86000000, 0x35000000, 0xF1800000, 0x17C00000, 0xF2E00000, 0x0F700000, 0xB0A80000, 0x26AC0000, 0xABAA0000, 0xEE2D0000, 0x2BE88000, 0x8E09C000, 0x0FFFA000, 0xEA139000, 0xED1E3800, 0x5D63B400, 0xE9B60A00, 0xA9CD1D00, 0x151AA680, 0xC96383C0, 0x6BB2A6A0, 0x66CF83F0, 0x7F98A698, 0xD62283DC, 0xF9102692, 0xB99B43EF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x28000000, 0xE4000000, 0x5A000000, 0xEB000000, 0x44800000, 0xC6400000, 0x85A00000, 0x67D00000, 0x30A80000, 0x2EAC0000, 0xEFAA0000, 0xD82D0000, 0xC6EF8000, 0x130EC000, 0xA479E000, 0x06833000, 0x71406800, 0xB7244C00, 0xA4957E00, 0x688BD300, 0xC4BDAD80, 0x826508C0, 0x39B5ADA0, 0xBF1908F0, 0x74B7AD98, 0x169808E4, 0x6B722D92, 0x14FBC8DD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xC8000000, 0xDC000000, 0xCE000000, 0xB1000000, 0x28800000, 0xD7400000, 0x8FE00000, 0x08F00000, 0xEF380000, 0x853C0000, 0x2E3A0000, 0x05BF0000, 0xB57E8000, 0xBC58C000, 0x188E2000, 0x69E05000, 0x35F1D800, 0x51BE9C00, 0xC7792600, 0x535AD900, 0x7909DE80, 0x8221C740, 0x7F51DEA0, 0xA9ADC770, 0xB933DE88, 0xC69EC77C, 0x8AAF5EBA, 0x2EB5074B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xA8000000, 0xA4000000, 0x86000000, 0x83000000, 0x7E800000, 0x6BC00000, 0x9EA00000, 0xC6D00000, 0x6B280000, 0x512C0000, 0x682E0000, 0x6FAD0000, 0x63ED8000, 0xE108C000, 0x0D3DE000, 0x2E21D000, 0xDA11C800, 0xC5083C00, 0xCB3C6200, 0xCD221700, 0xB4966180, 0x06CA98C0, 0xF19E61A0, 0x8DF698D0, 0x5CB861B8, 0x296798D4, 0xF273E192, 0x7CFE58FD } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xA8000000, 0x1C000000, 0x9A000000, 0xDD000000, 0x80800000, 0xA5C00000, 0x08E00000, 0xB8500000, 0x4D880000, 0xB88C0000, 0xE40A0000, 0xFBCB0000, 0x3E2B8000, 0xAEFEC000, 0x5AB62000, 0x70DEF000, 0xF1821800, 0xC7451C00, 0xE427B200, 0xA6333500, 0xBF1BD780, 0xBC64CBC0, 0x5B91D7A0, 0x226FCBF0, 0x4D5A57A8, 0x24C10BF4, 0xF2647782, 0xF093FBF3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x18000000, 0x5C000000, 0x5A000000, 0x6B000000, 0x95800000, 0xB8C00000, 0x7EA00000, 0x00300000, 0x62E80000, 0xD5EC0000, 0xDA6A0000, 0xA9AF0000, 0x728E8000, 0xD27E4000, 0x9234A000, 0x1DEA7000, 0xCE6B2800, 0x27AC8400, 0x378DC200, 0x32FF7700, 0xD2755680, 0x7F0A71C0, 0xF6BF56A0, 0x169571F0, 0x46D9D688, 0x210731FC, 0x1687768E, 0xC94241EB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x18000000, 0x94000000, 0xDA000000, 0x25000000, 0x79800000, 0xF5C00000, 0x98A00000, 0x69B00000, 0x78E80000, 0xF1EC0000, 0x966E0000, 0x24AB0000, 0x648B8000, 0x437B4000, 0xE7F7E000, 0x448D3000, 0x137A1800, 0x5FF6D400, 0xC088FA00, 0xD17A7F00, 0xEEF25280, 0x630A65C0, 0x01BC52A0, 0x0FD165D0, 0xFF7FD288, 0xE1F625D4, 0x978E328E, 0x11FC15F1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xF8000000, 0x1C000000, 0x0A000000, 0xC1000000, 0xC6800000, 0xD8C00000, 0xBAE00000, 0xD6B00000, 0xE8880000, 0xFD8C0000, 0x650E0000, 0x62CB0000, 0x61A98000, 0x865E4000, 0x1D76A000, 0x59EAF000, 0x677AF800, 0x62A3CC00, 0xC7968A00, 0x3F5C1D00, 0x87F48880, 0x2B2FFCC0, 0x4C9A88A0, 0x8A94FCD0, 0xEBDB0888, 0x7236BCC4, 0xF54BA8B6, 0x67EB4CC3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x88000000, 0xEC000000, 0xC2000000, 0xE9000000, 0xC2800000, 0x95400000, 0x7EA00000, 0x65F00000, 0x0F180000, 0xA41C0000, 0xCF9E0000, 0xB85F0000, 0x43BF8000, 0xD0EBC000, 0x5604A000, 0x3F06B000, 0xBD83F800, 0x08C4EC00, 0x6660C600, 0x8B977300, 0x688B3C80, 0x0E915440, 0x280D3CA0, 0x52D25450, 0x842CBCA8, 0x2A669454, 0x19979C8A, 0x298BE46F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x38000000, 0xA4000000, 0xD6000000, 0x35000000, 0x37800000, 0x1F400000, 0xBD200000, 0x78100000, 0xEEF80000, 0xF5FC0000, 0x337E0000, 0x5DBF0000, 0x42DA8000, 0x2C6B4000, 0xD7C66000, 0x92E4D000, 0x2EF77800, 0x860FC400, 0xCEF6BE00, 0x560C9700, 0x66F57780, 0x7A0E3040, 0x2CF377A0, 0x3D0D3050, 0xF877F7A8, 0x20C9707C, 0x6D9317A6, 0xFABAE055 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xF8000000, 0x74000000, 0xEA000000, 0x03000000, 0xB6800000, 0xF2C00000, 0x8E600000, 0x84B00000, 0xB8C80000, 0x19CC0000, 0xE04A0000, 0x5A090000, 0xFFA88000, 0xB8FF4000, 0xB4C4E000, 0x8367B000, 0x7331A800, 0x438F1C00, 0xB5ED0A00, 0x8558B900, 0xB7943C80, 0x9D5B2AC0, 0x33963CA0, 0xEF5E2AF0, 0x7494BCB8, 0x4BD86AFC, 0xF150DC86, 0x993C9AE1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xB8000000, 0x0C000000, 0x02000000, 0xA7000000, 0xED800000, 0x9FC00000, 0xE2600000, 0xF0100000, 0x60480000, 0x694C0000, 0xB1CE0000, 0xFC8F0000, 0xB0A98000, 0x871C4000, 0x5E242000, 0x48B03000, 0xC8BF0800, 0xE3556400, 0x71691A00, 0x387CC900, 0xC8B6A980, 0x88BBFBC0, 0xC350A9A0, 0xA168FBD0, 0x807F29A8, 0xC4B7BBE4, 0x8ABC8986, 0x6454CBE7 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x28000000, 0xBC000000, 0x82000000, 0x7B000000, 0x89800000, 0xC3C00000, 0x0BE00000, 0x07700000, 0xED380000, 0xF83C0000, 0x70BE0000, 0x45FB0000, 0x225A8000, 0x800BC000, 0xAD262000, 0x0C163000, 0x530FE800, 0xD8A2A400, 0xEDD33A00, 0x13ED2500, 0x7E507E80, 0x7F2DC740, 0x62367EA0, 0x729AC750, 0x5E6AFE88, 0x7B96075C, 0x89C85E82, 0xB1C0F773 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x68000000, 0x84000000, 0xBA000000, 0xED000000, 0xE9800000, 0x6BC00000, 0x58200000, 0xFAD00000, 0x7E180000, 0x379C0000, 0x6C5A0000, 0x7C7B0000, 0xF2AC8000, 0x5EB7C000, 0x002FE000, 0x3FF03000, 0xC54C5800, 0x86479400, 0x49E30A00, 0x6FF62B00, 0x9D4DCD80, 0x4A406540, 0x87E14DA0, 0x50F7A570, 0x1DCEADA8, 0x7207954C, 0x5902F5B2, 0x1B80016D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x98000000, 0x1C000000, 0xCA000000, 0xE7000000, 0x4D800000, 0xB8400000, 0xACA00000, 0xD0F00000, 0x40180000, 0xFD9C0000, 0xADDA0000, 0x357F0000, 0xBB8F8000, 0x52934000, 0xD38FA000, 0xA693F000, 0x2D8BC800, 0x1F962400, 0xC908A600, 0xDB566300, 0xBD6D1480, 0xB5C5DC40, 0x74E294A0, 0xCC569C70, 0x18ED3488, 0x39856C74, 0x8646FCAE, 0xB5A34873 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x78000000, 0xC4000000, 0x5A000000, 0xA3000000, 0xD8800000, 0xBF400000, 0xFDE00000, 0x0C900000, 0x50E80000, 0x146C0000, 0xE52E0000, 0x39CB0000, 0x1ADF8000, 0x0FF44000, 0x3E3E6000, 0xA8E2B000, 0xD114A800, 0xAA29EC00, 0xE74A5600, 0xA89ED900, 0x3B948D80, 0x4A6F62C0, 0xFC2B0DA0, 0x724B22D0, 0x951D6D88, 0xF15592F4, 0x514FC596, 0x0D9B7EC5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x98000000, 0xA4000000, 0x3E000000, 0x59000000, 0x2E800000, 0x9BC00000, 0x0D200000, 0x2E900000, 0x89C80000, 0x394C0000, 0x4B8A0000, 0x802D0000, 0x99798000, 0x1F954000, 0xCB4C6000, 0x408F9000, 0x15AC5800, 0x7F3EAC00, 0x58F23200, 0xA0BFBB00, 0x61B01F80, 0x445A69C0, 0x89019FA0, 0x968329F0, 0x4FC7FF98, 0x3B21B9D4, 0x4B9227BE, 0x3D4A55FD } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x58000000, 0xB4000000, 0xFE000000, 0x55000000, 0xC2800000, 0x6DC00000, 0x67A00000, 0x1DD00000, 0xF8E80000, 0xF46C0000, 0xC4AE0000, 0x2D8B0000, 0x079B8000, 0x6BD14000, 0xA1E8E000, 0xCCE91000, 0x4A6CB800, 0x31AF2C00, 0xFF0E0200, 0x325A5F00, 0xB870E180, 0x423E7EC0, 0x610361A0, 0x7C833ED0, 0x98C58188, 0xB5212ED4, 0x2812B99E, 0x2B4F42F9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x68000000, 0xA4000000, 0x02000000, 0xCF000000, 0xD9800000, 0x92400000, 0x26E00000, 0x6BD00000, 0x55880000, 0x360C0000, 0xF74A0000, 0x56290000, 0x5EBE8000, 0xF555C000, 0x8A4CE000, 0x88AEF000, 0x217D8800, 0xDBF7C400, 0xC47B9600, 0xC976C100, 0x1DB9AF80, 0x2AD3EBC0, 0x450F2FA0, 0x20CA2BF0, 0xCD69CFB8, 0x9CDDDBCC, 0x7242C7A2, 0x16E3DFE5 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x68000000, 0xC4000000, 0x2A000000, 0x1F000000, 0x62800000, 0xC7C00000, 0xB0600000, 0xB8F00000, 0xDEE80000, 0x126C0000, 0x40AA0000, 0xDD490000, 0x98F88000, 0x9DB3C000, 0x6949E000, 0x7AFAB000, 0x16B74800, 0x79CADC00, 0x0E3C2200, 0x2A51C100, 0x33FDF680, 0x1D3269C0, 0x258D76A0, 0xDA1DA9F0, 0xDA8696B8, 0x9BC219FC, 0x56635EA2, 0x79F205CD } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x38000000, 0xAC000000, 0x12000000, 0x8D000000, 0x42800000, 0x90C00000, 0x84600000, 0x05D00000, 0x1DE80000, 0x596C0000, 0x3AAA0000, 0x434B0000, 0x29DA8000, 0x5A134000, 0xBE0A2000, 0x0AF8B000, 0x85E3D800, 0x90954C00, 0x7ACF8A00, 0x109A0900, 0x2F305780, 0x7AF880C0, 0x5DE2D7A0, 0x2C97C0F0, 0x60CAF7A8, 0x099870FC, 0xD3B1AFA6, 0x75397CD7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x78000000, 0xCC000000, 0x2E000000, 0xD5000000, 0xBE800000, 0xD4C00000, 0x57600000, 0x8D500000, 0x6AD80000, 0x1E5C0000, 0xA59A0000, 0x8B7D0000, 0xFF6D8000, 0xC9964000, 0x85BC2000, 0xBF0F5000, 0xF140F800, 0x38268C00, 0x28756A00, 0xB82D7100, 0xF8B28B80, 0x454FC540, 0xCAE70BA0, 0xCE158570, 0xF1F92B98, 0x61ABD574, 0x31F65386, 0x916A1947 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xC8000000, 0x8C000000, 0x86000000, 0x8D000000, 0x11800000, 0x66400000, 0xB1E00000, 0x16D00000, 0x33680000, 0x63EC0000, 0xF22A0000, 0x988F0000, 0x763B8000, 0x71C5C000, 0x9AA5A000, 0x16B79000, 0xD3FEF800, 0x2966F400, 0x0B118600, 0xDFCB6900, 0x005A6F80, 0xE4535CC0, 0x15ABEFA0, 0x4BC99CF0, 0xA25DCF88, 0x5357CCD4, 0x572C97BA, 0xF509A8F7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x78000000, 0x84000000, 0x36000000, 0xB5000000, 0x2E800000, 0x15C00000, 0xDC200000, 0xDB700000, 0x2A480000, 0x05CC0000, 0xB08A0000, 0x28690000, 0x87BC8000, 0xAE474000, 0xF7676000, 0xBA90D000, 0x611E7800, 0x3EF68C00, 0x980FE200, 0x30AC2300, 0x911BC880, 0xE6F272C0, 0xCC0D48A0, 0xCEAC32F0, 0xD81EA8B8, 0x7A77A2DC, 0x5ACDB0A6, 0x8908FEFD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xC8000000, 0xFC000000, 0xDE000000, 0x89000000, 0xA0800000, 0xCCC00000, 0x58200000, 0x60B00000, 0xE3380000, 0x1EBC0000, 0x00FA0000, 0x9B1F0000, 0x8E0E8000, 0x8BC0C000, 0x49A32000, 0x98F3D000, 0x65DA9800, 0xB92A1C00, 0x56F43A00, 0xD4D81B00, 0x8DAE6E80, 0x88307F40, 0x13FAEEA0, 0x389FBF70, 0xD94F4E88, 0x10A0AF7C, 0xA074F6BA, 0x0D1A6343 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x28000000, 0xE4000000, 0xC6000000, 0x3B000000, 0xCD800000, 0xBD400000, 0xAB600000, 0xF7100000, 0x73780000, 0xE3FC0000, 0x783A0000, 0xAB9B0000, 0xBEAB8000, 0x7FA2C000, 0xC731E000, 0x2409D000, 0x92150800, 0x99F9E400, 0xB93E4E00, 0x671BB500, 0xEF6AFD80, 0x95065E40, 0xF2837DA0, 0x86C39E70, 0x15231DA8, 0x5DF38E74, 0x1B2C75A2, 0xC6E17A4D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x58000000, 0x54000000, 0x32000000, 0x93000000, 0x77800000, 0x71C00000, 0x58A00000, 0x3B900000, 0xE0380000, 0x06BC0000, 0x0BFA0000, 0xA11F0000, 0x31EA8000, 0x79E04000, 0x8776E000, 0x29C97000, 0x4E34E800, 0x9928D400, 0xE1C69A00, 0x70A47F00, 0x97907380, 0x363B0A40, 0xFFB8F3A0, 0xBB784A70, 0x955E9388, 0x8B8E7A5C, 0x6D561B9E, 0x2D1F9E49 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x28000000, 0xD4000000, 0xB6000000, 0xCD000000, 0xAA800000, 0x0FC00000, 0x5A600000, 0x61D00000, 0xDEF80000, 0x977C0000, 0xA33A0000, 0xAE190000, 0x396E8000, 0x47A7C000, 0xA8B56000, 0x6CAED000, 0xAAC7B800, 0x84E76C00, 0x48135200, 0x919BA100, 0xA02FDF80, 0x1006A040, 0x18035FA0, 0x9C046070, 0x9202BFB8, 0x5304704C, 0xB386E7B2, 0x13460C79 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x58000000, 0x54000000, 0xC6000000, 0x4F000000, 0x1F800000, 0x94400000, 0xFAE00000, 0xE2D00000, 0xA4B80000, 0xE63C0000, 0xA4FE0000, 0x7AD90000, 0x192E8000, 0x69E44000, 0x6752E000, 0xA5FED000, 0x765FA800, 0x48EAD400, 0x7243B600, 0xE5E54100, 0xB554A780, 0xCCFE5A40, 0xD6DC27A0, 0x9B2F1A50, 0x48E64798, 0x3BD08A6C, 0xBC3B8F8E, 0x91F9CE79 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x48000000, 0x54000000, 0x5A000000, 0xAF000000, 0xE2800000, 0x6CC00000, 0xE7E00000, 0xA5900000, 0xD9780000, 0xCAFC0000, 0x59BA0000, 0xBB190000, 0x75298000, 0x31E3C000, 0x8C956000, 0xFAF9B000, 0xA1BBC800, 0xD71A5C00, 0x23287A00, 0xD8E56500, 0xCF14D980, 0x81BBCA40, 0x671F59A0, 0x1B2D0A70, 0xD4E1B9B8, 0x89127A74, 0x20BC91AA, 0x709B5661 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x78000000, 0x84000000, 0xF2000000, 0x79000000, 0x7D800000, 0x6BC00000, 0x8CE00000, 0xCE900000, 0x83380000, 0xE1BC0000, 0xB4FE0000, 0xCB5D0000, 0x196A8000, 0x40E14000, 0xE0916000, 0x1C3CF000, 0x9F383800, 0x27BE5400, 0x27FDCA00, 0xBBDA0D00, 0x85282980, 0x5AC3D840, 0x2D64A9A0, 0x43539850, 0x0CD949B8, 0xD7AF286C, 0x578491A6, 0x46C1CC4D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xF8000000, 0x3C000000, 0x8E000000, 0x1D000000, 0xAC800000, 0x61C00000, 0x90E00000, 0xAF900000, 0x0AC80000, 0x314C0000, 0x330E0000, 0x4DAF0000, 0xCA9B8000, 0xF6644000, 0x2151A000, 0x85AFD000, 0xDE9A3800, 0x9C61DC00, 0x1E501200, 0x422BF500, 0x32D83980, 0x4FC7E7C0, 0x5DE5B9A0, 0xDB10A7D0, 0xC70999A8, 0xD7A837F4, 0xBD9F8196, 0x65E17BFB } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xB8000000, 0x74000000, 0xBE000000, 0x97000000, 0xA3800000, 0xB5C00000, 0x50E00000, 0x65700000, 0x5CD80000, 0xAA5C0000, 0x691A0000, 0x3ABD0000, 0xEC6D8000, 0x76604000, 0xFE37E000, 0x6B7C1000, 0x7A8BA800, 0x10103400, 0xAF6B5A00, 0x5BE0FD00, 0x94F6E680, 0x441A9840, 0xD83966A0, 0x412BD870, 0xEAC10698, 0xEF668874, 0x42B2CEB6, 0x413BEC69 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x48000000, 0x74000000, 0x9E000000, 0x5B000000, 0x3F800000, 0xE3400000, 0xA1A00000, 0x52300000, 0xA6180000, 0xB55C0000, 0x1CFE0000, 0xDAC90000, 0x92D28000, 0x348CC000, 0x63F16000, 0xC47C9000, 0xAC0CC800, 0xF531F400, 0xD39F8E00, 0x031A1300, 0xE1DA4A80, 0x683F8E40, 0x9C2B2AA0, 0xB7431E50, 0xEFA7E298, 0xD132EA4C, 0xD5986C8A, 0xF418F951 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x68000000, 0x94000000, 0xB2000000, 0x49000000, 0x4A800000, 0x77400000, 0xEEA00000, 0xD0F00000, 0x10680000, 0xB72C0000, 0x618E0000, 0x5D7B0000, 0xB3168000, 0x0339C000, 0x47336000, 0xDC8DF000, 0xF5F93800, 0xF552AC00, 0xEB1A7600, 0xAE84F300, 0x4D414C80, 0x23A263C0, 0xF0722CA0, 0xD22F93D0, 0x350B1488, 0x3D3D3FFC, 0xA0316292, 0xE909CCD9 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x28000000, 0xEC000000, 0x6E000000, 0xFF000000, 0x6F800000, 0x72C00000, 0xFD600000, 0x0ED00000, 0x83680000, 0x89AC0000, 0x00CA0000, 0x041F0000, 0x8A748000, 0xD559C000, 0xDBD4A000, 0x51E8D000, 0xA5EBA800, 0x6FE91400, 0xC2EA2200, 0x646B1900, 0x4229C780, 0x200D48C0, 0x307D67A0, 0xD02598F0, 0xC976CF88, 0x4CDC8CEC, 0x3214ED82, 0x310B95D7 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xD8000000, 0x2C000000, 0xBE000000, 0x41000000, 0xA2800000, 0xD0C00000, 0x71600000, 0xED900000, 0x76580000, 0x6A9C0000, 0xB5FE0000, 0x916F0000, 0xC1B48000, 0x31EE4000, 0x26712000, 0x070BD000, 0x83A55800, 0xDBF20C00, 0x044BAA00, 0x7884F100, 0xCBC64580, 0x88E3BB40, 0xE4D765A0, 0x7E786B50, 0x572A3DA8, 0xD216674C, 0x221F979E, 0x863D9647 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xD8000000, 0x84000000, 0xC6000000, 0xAF000000, 0x19800000, 0xE4400000, 0x29600000, 0x73B00000, 0x81280000, 0x096C0000, 0xFA0E0000, 0x44BF0000, 0x05128000, 0x86B84000, 0x2C126000, 0x103B5000, 0x61D4A800, 0x05182400, 0xBF076600, 0x31807D00, 0x9844C880, 0xDB6525C0, 0xC2B6A8A0, 0xB3AE75D0, 0x32AA00A8, 0x982A51FC, 0x07EB669E, 0x13C92CDD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x68000000, 0x94000000, 0x3E000000, 0x63000000, 0x88800000, 0x66400000, 0xE4600000, 0xF0500000, 0xAB980000, 0xE3DC0000, 0x6CBA0000, 0x706F0000, 0xBBB58000, 0x230AC000, 0x9D646000, 0x7DD29000, 0x2A580800, 0x7B7C8C00, 0xBFCCDE00, 0x8E40ED00, 0xB067A780, 0x6E511740, 0x989BC7A0, 0x035F8770, 0x9EF9CF88, 0xAA0C0B64, 0x28E09192, 0x00162641 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xB8000000, 0x4C000000, 0xD6000000, 0x55000000, 0x8D800000, 0x82C00000, 0x3FA00000, 0x1C300000, 0x0D280000, 0x21EC0000, 0x274E0000, 0x70FD0000, 0x62168000, 0x05DF4000, 0x26632000, 0xE7109000, 0x6058B800, 0x40A59400, 0x8AB3A200, 0x0B6A4F00, 0x0F085680, 0x271C0BC0, 0x49C376A0, 0x53209BD0, 0xE975CEB8, 0x43480FCC, 0x62F8EC96, 0x751100DF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x68000000, 0x24000000, 0x66000000, 0x51000000, 0x2B800000, 0x9AC00000, 0x07A00000, 0xAF300000, 0xA4B80000, 0xC07C0000, 0x1ADA0000, 0x7C6F0000, 0x05148000, 0xD04BC000, 0xF0E0E000, 0xD354D000, 0xEFAED800, 0x05364400, 0x77B97200, 0x7CFF1F00, 0x8A9A7E80, 0xA28A7F40, 0x13429EA0, 0xBA62AF70, 0x6A164688, 0x86CBEB6C, 0xD3A3B492, 0x61333465 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x48000000, 0xB4000000, 0x46000000, 0xDB000000, 0xC8800000, 0x43C00000, 0x77200000, 0x28900000, 0xD5F80000, 0xC43C0000, 0x9E1E0000, 0xCD0F0000, 0xD7B08000, 0x296EC000, 0x87C56000, 0x39205000, 0x67920800, 0xAB788C00, 0x14FEF200, 0x95BA9B00, 0xE05B9780, 0xAE681440, 0x0D46F7A0, 0x8FE44450, 0x4732FFA8, 0x06AFC86C, 0x9AE28DBA, 0x80B49341 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x48000000, 0xB4000000, 0x22000000, 0xDB000000, 0x54800000, 0xD1400000, 0xB9600000, 0x64500000, 0x5AA80000, 0xD0EC0000, 0x7D0E0000, 0x28190000, 0x7BD48000, 0x876AC000, 0x14C96000, 0xCE3D7000, 0x13E12800, 0xE8104C00, 0x564B2600, 0xA6795D00, 0xC5023780, 0xB985DEC0, 0x2CC557A0, 0x1FA1AED0, 0xA4F0FF98, 0xC0DB22FC, 0xAE72B98A, 0x1C9F0FD1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xA8000000, 0xAC000000, 0x4A000000, 0x21000000, 0x91800000, 0x59C00000, 0x08E00000, 0xB5300000, 0xDBE80000, 0xCB2C0000, 0x5E4E0000, 0x68B90000, 0x42B28000, 0xA92BC000, 0x9348A000, 0x533FF000, 0x4A727800, 0x984C3400, 0xD3B8DA00, 0xCA32AD00, 0x156CDC80, 0x8C6F47C0, 0x29EA7CA0, 0xDE29B7D0, 0x61CA8498, 0x867E43CC, 0x18D2FEB2, 0x595F1EE7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xF8000000, 0xD4000000, 0x4A000000, 0x0F000000, 0x4A800000, 0xED400000, 0x44E00000, 0xD7500000, 0xAA780000, 0xE03C0000, 0x025A0000, 0xC6490000, 0xBDD78000, 0x373C4000, 0xECD8E000, 0x290FB000, 0x0A324800, 0xCCED5C00, 0x3AE15600, 0x82568100, 0x77F99380, 0x43F8AC40, 0x19FB73A0, 0x8EFE1C70, 0xC07EBBB8, 0x9F3F0044, 0x00DF0D86, 0xD70A3171 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x98000000, 0xB4000000, 0xA2000000, 0xDF000000, 0x60800000, 0x6DC00000, 0xFFE00000, 0xF2700000, 0x18A80000, 0x026C0000, 0x010A0000, 0x60BB0000, 0x86F18000, 0x47694000, 0x9A8EE000, 0x77FCF000, 0x2FD18800, 0x1078CC00, 0x7690C200, 0x505C8D00, 0x6C017680, 0xF6010FC0, 0x0D0596A0, 0x7786FFF0, 0x21459EA8, 0x842773E4, 0x7093BC8E, 0x555B0EC9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x58000000, 0xFC000000, 0x46000000, 0x3D000000, 0x7F800000, 0x8CC00000, 0x39600000, 0xBAF00000, 0x68F80000, 0x953C0000, 0x8DDE0000, 0x9AE90000, 0xC2F08000, 0x04FE4000, 0x5B3FA000, 0x24D89000, 0x076FF800, 0xC9374400, 0x391A0200, 0x2F881900, 0x86031680, 0x9D00C540, 0xAF82B6A0, 0xE4C15550, 0x9D65CE98, 0x00F4515C, 0x13FE6C8E, 0xD7BDD863 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x68000000, 0xC4000000, 0x5E000000, 0xB9000000, 0x77800000, 0x37400000, 0xBFA00000, 0xE3300000, 0x3FE80000, 0x7DAC0000, 0x5F8E0000, 0x34FB0000, 0x46378000, 0x6A68C000, 0xA1E8E000, 0x24AD1000, 0x18095800, 0xFBBD2400, 0x5591FE00, 0x135CD300, 0x7902F280, 0x978679C0, 0x074412A0, 0x47A069D0, 0x4F32CA88, 0xA5E98DF4, 0x9AADD492, 0x910F4EC5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xC8000000, 0x94000000, 0xFE000000, 0xDF000000, 0x19800000, 0x59400000, 0x3C600000, 0xEFD00000, 0xD6C80000, 0x7C8C0000, 0xDB6A0000, 0x08FD0000, 0x22D48000, 0x724EC000, 0x69486000, 0xB6CE9000, 0x8C8EE800, 0xF369E400, 0xACF9CE00, 0x14D37D00, 0x39490B80, 0x8ECB89C0, 0x308B6BA0, 0xA96819F0, 0x45F90398, 0x46533DFC, 0x878AADAA, 0x34EFD0D9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xF8000000, 0x94000000, 0xE2000000, 0x1F000000, 0xC1800000, 0xD0400000, 0x9B600000, 0x60700000, 0xACF80000, 0x41BC0000, 0xA45E0000, 0xA5E90000, 0x2A358000, 0xFC9E4000, 0xE24CE000, 0x57E6F000, 0x46B18800, 0xAA5EC400, 0x8CE82600, 0xF6B1CD00, 0x6259E680, 0x90EC5540, 0xE8B306A0, 0xF35FA550, 0x38690E98, 0x04762174, 0x66F848A6, 0xD2BF5C51 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0xB8000000, 0xEC000000, 0xEE000000, 0xDD000000, 0x24800000, 0x2E400000, 0xFAE00000, 0xB4500000, 0x50180000, 0x955C0000, 0x0A3A0000, 0x52AB0000, 0xCF178000, 0x8A7E4000, 0x954B2000, 0xEFC35000, 0xDC243800, 0xAEF25C00, 0x53A88E00, 0xED97C900, 0x0D3C3380, 0xD92D1F40, 0xFED513A0, 0x63594F70, 0x6B3CABA8, 0x002E5354, 0x40508586, 0x02188A6F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x38000000, 0x84000000, 0x6A000000, 0xB3000000, 0x21800000, 0x2E400000, 0xC0A00000, 0x70F00000, 0x91980000, 0x4EDC0000, 0xC0FE0000, 0xA1CF0000, 0xEFB18000, 0x3FBC4000, 0xFFEE6000, 0xB6863000, 0xF5C02800, 0x45E46400, 0xC5D1F600, 0x9D2E0300, 0x28E68C80, 0xB554B440, 0x6DEEECA0, 0xE1818450, 0x4E4144A8, 0x30A6A064, 0x98F752A6, 0x2D9ED345 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xF8000000, 0x94000000, 0x2E000000, 0xD7000000, 0x86800000, 0x59400000, 0x19E00000, 0x28500000, 0x83D80000, 0xD79C0000, 0xE1FA0000, 0xA96B0000, 0x30968000, 0xCDFD4000, 0xF36BE000, 0x59959000, 0xD47BA800, 0x40AFDC00, 0xA3317600, 0x1CCCE900, 0xBAA22380, 0x28B4D140, 0x6A0BC3A0, 0xC3864170, 0x1AC4EBA8, 0xC323DD5C, 0xCB72FD96, 0xF8ACE479 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x98000000, 0x6C000000, 0xD6000000, 0x37000000, 0x2D800000, 0x11C00000, 0xD3E00000, 0x71700000, 0x02C80000, 0x1E8C0000, 0xACAA0000, 0x26390000, 0x71878000, 0x4FC74000, 0x70E22000, 0x36F79000, 0x6A08A800, 0xBBE90400, 0x379CEA00, 0xD1D7C500, 0xE01F7680, 0x8110CCC0, 0x997AD6A0, 0x84201CF0, 0xAD905EB8, 0x823E88C4, 0x93841C9E, 0xA2C049DF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x18000000, 0x4C000000, 0x46000000, 0xF7000000, 0x18800000, 0x84400000, 0xBE600000, 0xCF500000, 0xC0380000, 0xA4FC0000, 0x62DE0000, 0x2DED0000, 0x69828000, 0x4BC64000, 0xB2A62000, 0x1D771000, 0xE50F2800, 0xA1932C00, 0xB71B6E00, 0x0449AD00, 0xBA76EF80, 0x35886A40, 0xE1D24FA0, 0xEB793A50, 0x2E1B47B8, 0x9FCD066C, 0xBCB701BE, 0x56AB877F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xB8000000, 0x64000000, 0xD6000000, 0x8B000000, 0xF1800000, 0x7DC00000, 0x9FA00000, 0x0F300000, 0xF6380000, 0x4E7C0000, 0x121E0000, 0x45890000, 0x37028000, 0x73834000, 0x78C26000, 0xF123D000, 0xED740800, 0xFB5E4400, 0xF96A8A00, 0x1DD2C700, 0x93EDE680, 0x19905B40, 0x4D8D06A0, 0x4B00CB50, 0x51836E98, 0xEDC15F4C, 0x57A3ECB6, 0xD334DC55 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x18000000, 0x3C000000, 0x16000000, 0xC5000000, 0x43800000, 0xD1C00000, 0x7B200000, 0x11300000, 0xACB80000, 0xB0FC0000, 0x231A0000, 0x7C890000, 0x05C78000, 0x39234000, 0x5634A000, 0xC83F1000, 0xD5BBB800, 0x257F6400, 0x57DB0A00, 0x942EE300, 0xDD308280, 0xD2BA1B40, 0xE1FBA2A0, 0x829A4B70, 0x5A4EBAB8, 0xD2633F44, 0x695188BE, 0xD6EDF84B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xC8000000, 0xBC000000, 0xBE000000, 0x15000000, 0x38800000, 0x4CC00000, 0x7D200000, 0xBF900000, 0x09380000, 0x1B7C0000, 0xBB9A0000, 0x2BAF0000, 0xF6C68000, 0xC224C000, 0x00172000, 0x2E7FD000, 0x731AF800, 0x0F6B7C00, 0x07E1FA00, 0x0BB26300, 0xA02F7780, 0xB3821A40, 0x9146D7A0, 0x61650A70, 0x02710F88, 0xBD8EA67C, 0x04D48DBA, 0x2F5F7953 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x98000000, 0x4C000000, 0xC6000000, 0xD5000000, 0xB5800000, 0x70400000, 0x5BE00000, 0xB2300000, 0x4EC80000, 0x790C0000, 0xDDAE0000, 0x6AFD0000, 0x5AC18000, 0xAD214000, 0x09112000, 0x6ADC1000, 0x7A523800, 0x89BD5400, 0x21A1B600, 0xBAD4D900, 0xFC7EA080, 0x62045AC0, 0x170600A0, 0x12850AD0, 0x0AC318B8, 0x15254EF4, 0xB517169E, 0xA4DC83E7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x28000000, 0xC4000000, 0x7E000000, 0x3D000000, 0x4E800000, 0xD6400000, 0x3E200000, 0xAF100000, 0xDA580000, 0xF79C0000, 0x257E0000, 0xC40D0000, 0xCE618000, 0x9034C000, 0xC9C8E000, 0xEC841000, 0xC9477800, 0x2FA54C00, 0x08D25E00, 0xD3BD9F00, 0x796A6F80, 0xB5D11940, 0xDD3D0FA0, 0xCF2CC950, 0x1BF317B8, 0x5A295574, 0xD176D1B2, 0x92699645 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x08000000, 0xA4000000, 0xDA000000, 0x77000000, 0xF9800000, 0xEAC00000, 0x6C600000, 0xE5B00000, 0xFAB80000, 0xC6FC0000, 0x75DE0000, 0xD8CF0000, 0x9EA38000, 0x65D7C000, 0x4108E000, 0x01433000, 0x35A20800, 0x1A568400, 0x1AC97200, 0x05A40100, 0xC253F480, 0x96CB1D40, 0xEBA694A0, 0x6750ED50, 0xBC4FFCA8, 0x22E29974, 0x96F466AA, 0xCC1F2C5D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x68000000, 0x84000000, 0xDA000000, 0x7B000000, 0x90800000, 0x00C00000, 0x9EE00000, 0xAD500000, 0x85480000, 0xBA0C0000, 0xE6AA0000, 0x1ADB0000, 0x9EA38000, 0x9B74C000, 0x12FEE000, 0x58153000, 0xCAEC6800, 0x52F8AC00, 0xB8130A00, 0xFAEFED00, 0x2AFCBF80, 0x5412A1C0, 0xA4EBDFA0, 0x8BF851F0, 0xBF92D7A8, 0x34AD0DF4, 0x15D955B2, 0x8C247CD5 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x48000000, 0xE4000000, 0xA6000000, 0xDD000000, 0x2F800000, 0x0AC00000, 0x94A00000, 0x1C900000, 0xDEE80000, 0xBAAC0000, 0xC14A0000, 0xFCBB0000, 0x4EE68000, 0x8670C000, 0x7699E000, 0xD531D000, 0x2DF8B800, 0x4E808400, 0x5F417200, 0x69602700, 0x88B7CB80, 0xD43D90C0, 0xECA2ABA0, 0x709780F0, 0xBCED73A8, 0x71AA14DC, 0x7BCF59BA, 0x3DFC67E5 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x58000000, 0xC4000000, 0x42000000, 0xDB000000, 0x72800000, 0x48400000, 0x55A00000, 0xD1F00000, 0x8C780000, 0xAFBC0000, 0x5BDE0000, 0x05490000, 0x75208000, 0x8AB64000, 0xE75A6000, 0xD80B7000, 0x87062800, 0x54847C00, 0x01439E00, 0x9426E300, 0x77311480, 0x179E3340, 0xB2EDF4A0, 0xAFD60350, 0x1C4F3C98, 0x9CA64F5C, 0x50706A8E, 0xCAB9E06D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x98000000, 0xAC000000, 0x86000000, 0xC1000000, 0x14800000, 0xC0C00000, 0x32E00000, 0x05100000, 0x79980000, 0x8ADC0000, 0x7D7A0000, 0x16CB0000, 0x9C628000, 0xEAD24000, 0x8AF92000, 0x41881000, 0x29C19800, 0xD260FC00, 0xCFD41A00, 0x3C7C7D00, 0xC24ABD80, 0x7CA72540, 0xE8331DA0, 0x17EA7570, 0x941325A8, 0x251BD97C, 0x6E1D078E, 0xCD9D0857 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x28000000, 0x74000000, 0x66000000, 0xAF000000, 0x94800000, 0x86C00000, 0x00200000, 0x8C500000, 0xC9380000, 0x5A7C0000, 0x631E0000, 0x53290000, 0xFBA48000, 0x3E11C000, 0x1FD86000, 0x4E085000, 0x7A72A800, 0xD26C4C00, 0x0BC05A00, 0x35A32B00, 0xA5111180, 0x0D5B0C40, 0xD7CBF1A0, 0xC6D79C50, 0xACFBB998, 0xA4DB407C, 0x4C8DAB92, 0x9BB1B761 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xA8000000, 0x84000000, 0xEA000000, 0xB7000000, 0xFF800000, 0x7A400000, 0xA0600000, 0xCD100000, 0xBAD80000, 0xA61C0000, 0xFEBA0000, 0xB10D0000, 0xBB628000, 0x9C93C000, 0x7D99E000, 0xBEFDB000, 0x1E698800, 0x55F43400, 0x9A084600, 0xA2E55500, 0x2FD7A580, 0x277C5F40, 0x6D2EC5A0, 0xEF132F70, 0xB9DE2D98, 0xFB986B4C, 0x47FE83B2, 0xACEA7A6D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x48000000, 0x0C000000, 0xFA000000, 0x93000000, 0xB3800000, 0x89400000, 0x2E200000, 0xBE900000, 0x4B280000, 0x74EC0000, 0x990A0000, 0x087D0000, 0xB5278000, 0x2111C000, 0x886FA000, 0xD1CB7000, 0xD01B6800, 0x3C13B400, 0x86E91E00, 0x260FFF00, 0xF1FFF380, 0xB76266C0, 0xF8B5D3A0, 0x49B9D6F0, 0xDDC49B98, 0x3AE1D2E4, 0xD4F4CD8A, 0x5D1A29E7 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x98000000, 0x14000000, 0x82000000, 0x61000000, 0xF1800000, 0x5E400000, 0xBE600000, 0x5B100000, 0x5D980000, 0x7D5C0000, 0x8BFA0000, 0x6A4F0000, 0xE0648000, 0x84144000, 0x631AE000, 0x559FF000, 0xE1597800, 0x55FF3400, 0x754EE600, 0x7EE3C500, 0xDCD6B580, 0x91B9C540, 0x7E2AD5A0, 0xF6717570, 0xCE0FCD88, 0x3B06F16C, 0xE48433AE, 0xFDC2B069 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x58000000, 0x54000000, 0x52000000, 0x71000000, 0x8A800000, 0x20C00000, 0xB8600000, 0x41300000, 0x49F80000, 0x1CBC0000, 0xC19E0000, 0x558B0000, 0x24638000, 0x5F354000, 0x9EFDE000, 0xA53E7000, 0x42DF7800, 0x13ACEC00, 0xAFF7CA00, 0x9E9E5900, 0x000B7880, 0x1120F340, 0x721318A0, 0xE2ECC350, 0xC8D40088, 0x678C1F54, 0xA564D29E, 0x3DB29A41 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x78000000, 0x44000000, 0xCA000000, 0x45000000, 0xDD800000, 0xD8400000, 0x66200000, 0x58D00000, 0xA3780000, 0x555C0000, 0xB58A0000, 0x32F10000, 0xBDAD8000, 0x35244000, 0x9E576000, 0x31BCB000, 0x27BAD800, 0x3CBB5400, 0x76392600, 0x62FCCF00, 0xB31F5D80, 0x54AA6040, 0xDEA585A0, 0xED113470, 0x151CA3B8, 0x47ADFB74, 0xB823FE26, 0x0FD79B25 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x18000000, 0xDC000000, 0xBE000000, 0x63000000, 0x25800000, 0x30C00000, 0xF1200000, 0xF5B00000, 0xB6F80000, 0xAFDC0000, 0xBE6E0000, 0x3A950000, 0x60488000, 0x5CA64000, 0x1175A000, 0x6DD8D000, 0x736D8800, 0x34110400, 0x810C5200, 0xE7445300, 0x14E1FA80, 0xD6119F40, 0x1C0C72A0, 0xC1C09B50, 0x31A020B8, 0x0FF4C85C, 0xC499DA3E, 0x3C89572B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x98000000, 0x5C000000, 0xBA000000, 0xD5000000, 0x78800000, 0x89C00000, 0xA3600000, 0x24900000, 0xF1880000, 0x6EEC0000, 0x207A0000, 0x8CF30000, 0x6E9E8000, 0xB9204000, 0xA5B1A000, 0xF83AF000, 0x94D41800, 0x0DAA7C00, 0xDBDEC200, 0xB584C100, 0x6D451980, 0xB0A217C0, 0x62F101A0, 0x35986BF0, 0x4AA7C3A8, 0x57F0AAFC, 0x5D18DA0E, 0x6B61BD2B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xB8000000, 0x3C000000, 0x6A000000, 0xF9000000, 0xE9800000, 0x81C00000, 0x0BE00000, 0x2E500000, 0x0CC80000, 0xED2C0000, 0xFA7A0000, 0x3F330000, 0xE3DA8000, 0xAA454000, 0x8727A000, 0x02367000, 0xBC58F800, 0x28821400, 0x94436A00, 0xC0214D00, 0x6CB76B80, 0x731BC7C0, 0x5C2793A0, 0x76B5D3F0, 0x121EF9A8, 0x39A79EDC, 0x25731206, 0xDCF91913 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xE8000000, 0x94000000, 0x56000000, 0xCB000000, 0x74800000, 0xDB400000, 0x09A00000, 0x78D00000, 0x55480000, 0x5AEC0000, 0xB13E0000, 0xCCF70000, 0x7F5C8000, 0xB2C5C000, 0x2D666000, 0xFEB05000, 0x0F7FC800, 0x96D40C00, 0x524D8600, 0x246A8300, 0x937A8980, 0xC4D2C5C0, 0xF74D41A0, 0x17EAC9D0, 0x16BEC7A8, 0x1F374AEC, 0x6FB8CE12, 0x5EB04F09 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xD8000000, 0x9C000000, 0x56000000, 0xA1000000, 0x7F800000, 0x03C00000, 0xB6E00000, 0x34100000, 0x0F780000, 0x279C0000, 0x668A0000, 0x54750000, 0x732C8000, 0x6FC04000, 0x18E1A000, 0x59179000, 0x4EFED800, 0xC15E8400, 0x65E80A00, 0x94A1E500, 0x14358180, 0x000BD040, 0xC43359A0, 0xA8095470, 0x60315398, 0xD20DB15C, 0x4F30522E, 0x908A213B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x18000000, 0xD4000000, 0xA2000000, 0x43000000, 0xBB800000, 0xCDC00000, 0xEDE00000, 0xBF500000, 0x0C580000, 0xA7BC0000, 0xA1EE0000, 0x61310000, 0xA2C88000, 0x78064000, 0x2401E000, 0x5A047000, 0x27042800, 0x01821400, 0x5AC70A00, 0xF461CD00, 0x3196E380, 0x5A3F2B40, 0xD52ACBA0, 0x40513F50, 0x79DBC198, 0x0F7DF27C, 0xBE8BA21E, 0x27259909 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x78000000, 0x94000000, 0xBA000000, 0xE9000000, 0x7B800000, 0x7D400000, 0xA5200000, 0xCCB00000, 0xA9080000, 0xBA2C0000, 0xC19E0000, 0x08170000, 0xA1FB8000, 0x95864000, 0x4E45E000, 0x07A3B000, 0xA276B800, 0x9D6A8400, 0xFDBFDE00, 0xF726CF00, 0x89B4EE80, 0xDC8C58C0, 0x846A56A0, 0x8E3ADCD0, 0x566388A8, 0x6A9713D4, 0xAF3AE636, 0x91E60B31 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x38000000, 0x2C000000, 0x0A000000, 0x69000000, 0x45800000, 0xF5C00000, 0x9AE00000, 0x21300000, 0x79480000, 0xCDAC0000, 0x3B9A0000, 0x58510000, 0x0EBE8000, 0x62854000, 0x17452000, 0x4DA3F000, 0x0C91F800, 0x05D8F400, 0xF073AA00, 0xE7EF0500, 0xB5BE3880, 0xD205B8C0, 0xF507C0A0, 0x17814CF0, 0xC0C66AB8, 0xED6349EC, 0x91F4D236, 0xAC2EB127 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x98000000, 0xC4000000, 0xD6000000, 0xE3000000, 0xB4800000, 0x19400000, 0x2C600000, 0xA5900000, 0xE6B80000, 0x49DC0000, 0x88CE0000, 0x7F330000, 0x768E8000, 0xD1D44000, 0xB9596000, 0x078D5000, 0x10500800, 0x579FCC00, 0xB62CD600, 0x18E1FD00, 0xFCD67D80, 0x6ADACE40, 0xDC4875A0, 0xF6760250, 0xF2EA2388, 0x2843BF5C, 0x4DE53E2E, 0x7B54212D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0xC8000000, 0xA4000000, 0xCA000000, 0x79000000, 0x68800000, 0x49400000, 0xF2200000, 0x8D300000, 0xADA80000, 0x2E8C0000, 0xCF3E0000, 0x51D10000, 0x6C7F8000, 0x2AF7C000, 0xF1CBE000, 0xF21E3000, 0x8B643800, 0xA7159C00, 0xAC9A6600, 0xBD200F00, 0x9AB31A80, 0x2B69A1C0, 0xD66922A0, 0x84ED3DD0, 0xCCACC498, 0x6A0AF2C4, 0x087C3E2A, 0x40F1632D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x38000000, 0x04000000, 0x12000000, 0x0D000000, 0xE7800000, 0xFEC00000, 0x7C600000, 0xC5700000, 0x03580000, 0xBA3C0000, 0xE4CE0000, 0x6F550000, 0xC60A8000, 0x35354000, 0x44786000, 0xA8EE7000, 0xCD055800, 0xC7870400, 0xEEC00200, 0x3461F900, 0xF973B680, 0x155A5E40, 0xA538EEA0, 0x0E485A50, 0x76126CB8, 0x44ACE34C, 0x8C21BA36, 0x8254CD0D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x28000000, 0x8C000000, 0xFE000000, 0x61000000, 0x82800000, 0xC5400000, 0x64E00000, 0x32700000, 0xC3880000, 0x6A6C0000, 0x549A0000, 0xBB570000, 0x0B5E8000, 0x7EF5C000, 0x8FCEA000, 0xA00BD000, 0xEDAF1800, 0x553EAC00, 0x5DC7D600, 0xD2A12900, 0x5B123680, 0x4F3FECC0, 0x2EC72EA0, 0xDF2640F0, 0xE5D67888, 0xC81EA9DC, 0xCF10EE02, 0xD53D953F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x58000000, 0x34000000, 0x5A000000, 0x5B000000, 0xD0800000, 0x19400000, 0xF6A00000, 0xE3D00000, 0x41D80000, 0xB07C0000, 0xA52E0000, 0x70B10000, 0x83EF8000, 0x55D34000, 0x34DBE000, 0x81FAB000, 0x67ED2800, 0x17D54C00, 0xBBDAB600, 0x5B786B00, 0x7DAD5980, 0x05F49140, 0x1B4E71A0, 0xB700DD50, 0xFE834798, 0xF847F644, 0x2D23FE0E, 0x7214D709 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0xFC000000, 0x72000000, 0x31000000, 0x65800000, 0x27400000, 0x0E600000, 0x57100000, 0xFDA80000, 0x40CC0000, 0x2B5E0000, 0x08350000, 0x63DA8000, 0x08F5C000, 0x33FF2000, 0xB8023000, 0xE4047800, 0xC6037400, 0xCF07FE00, 0x0E80B500, 0x8FC59980, 0x3EA59AC0, 0x4F37E1A0, 0xC15FEED0, 0xCD349FB8, 0x985F9BCC, 0x34B4A632, 0xBD1DF133 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x18000000, 0xAC000000, 0x1E000000, 0x9B000000, 0x3F800000, 0x7A400000, 0x91A00000, 0xE7500000, 0x98180000, 0x84BC0000, 0x136A0000, 0x8CB70000, 0x2EE98000, 0x5BF34000, 0x5FC92000, 0x03645000, 0x1D35C800, 0xE7A81400, 0xB1D51600, 0x38D89300, 0x3BD8DD80, 0x685EFB40, 0xAC1F15A0, 0xF6BDEF70, 0x36698388, 0x78313C64, 0x7329FE0E, 0x1C14D70F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xE8000000, 0x74000000, 0x8A000000, 0xD7000000, 0xCF800000, 0x5BC00000, 0x2E600000, 0x76D00000, 0xBDD80000, 0x9ABC0000, 0xAEEE0000, 0x28710000, 0xE4EE8000, 0x5F77C000, 0xBB6D6000, 0x9CB3B000, 0x0908C800, 0x1460D400, 0xE9D03A00, 0x9659C100, 0xD37A8380, 0xCB8C4740, 0x6F244BA0, 0x5FF19350, 0xF32CF198, 0xF712924C, 0x7CBB9222, 0x2FEBA511 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x58000000, 0x84000000, 0xB2000000, 0x95000000, 0xD8800000, 0xB0400000, 0xB3A00000, 0x63D00000, 0x0FC80000, 0xF76C0000, 0xF73E0000, 0x13370000, 0x283A8000, 0xAAB64000, 0x8AFD6000, 0x88567000, 0x680E9800, 0x45083C00, 0x498C4E00, 0x03CE8B00, 0xC96D0980, 0x1C39E9C0, 0x00B591A0, 0xBBFAD5D0, 0xD2D55FA8, 0x15491EDC, 0xAA29B63E, 0x281BC73D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x68000000, 0x94000000, 0x26000000, 0x77000000, 0x02800000, 0x91400000, 0xFEA00000, 0x66100000, 0x41980000, 0x8DBC0000, 0xC2EA0000, 0x21D70000, 0x687B8000, 0xD20AC000, 0x9FE56000, 0x80B5D000, 0x6B8BA800, 0x06255C00, 0xE256C600, 0x24BBFB00, 0x8B6E4780, 0xA0142540, 0x469E6FA0, 0x573BB970, 0xBFADC988, 0x05759274, 0xCB682612, 0xC014EB11 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x28000000, 0xC4000000, 0xCE000000, 0xF5000000, 0x6B800000, 0x80C00000, 0x10A00000, 0x7D700000, 0x3C680000, 0x1F4C0000, 0xFEFA0000, 0xC0350000, 0xA50F8000, 0xDB1CC000, 0x1023E000, 0x8B301000, 0xE38E7800, 0xEC594400, 0x72459200, 0x31E68F00, 0x36173080, 0x1F39B9C0, 0x9D16C8A0, 0x89BC3DF0, 0x8250BA98, 0x2FDAA2C4, 0xF681F212, 0x0F465F35 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x08000000, 0x0C000000, 0x32000000, 0xC5000000, 0x7E800000, 0x60C00000, 0xD2600000, 0x8DB00000, 0x06E80000, 0x060C0000, 0x897A0000, 0xB0F30000, 0xD9CB8000, 0x0C99C000, 0xA106A000, 0x3086B000, 0x2FC25800, 0xFDE08C00, 0xA5F6FA00, 0x4F4F9100, 0xD05A4080, 0xD96515C0, 0x7C3398A0, 0x69AC59F0, 0x6C2BC2A8, 0x456978D4, 0x6C49DA2A, 0xBDDFE117 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xA8000000, 0x24000000, 0x92000000, 0xC9000000, 0xCA800000, 0xF9C00000, 0x36A00000, 0xF2500000, 0xBCE80000, 0x4CCC0000, 0x315A0000, 0x40170000, 0x0D0C8000, 0x1BFBC000, 0xFC41E000, 0x96E3F000, 0x4AB17800, 0x815E4C00, 0x8817B200, 0x790B9F00, 0xD1FA3180, 0xB9465CC0, 0xEA67C9A0, 0xE873D0F0, 0xB4799B88, 0x4907BFCC, 0x0A80D222, 0x59C4AF05 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xF8000000, 0xDC000000, 0x32000000, 0x53000000, 0xD2800000, 0x62C00000, 0xE1E00000, 0x85100000, 0xF3A80000, 0x44CC0000, 0x7D1E0000, 0x86550000, 0xF2098000, 0xDAF84000, 0x2647A000, 0x7E21B000, 0xB7766800, 0x85FADC00, 0x1EC23A00, 0xE3E7FD00, 0x5E103980, 0x152836C0, 0x300FD1A0, 0x21FAAAD0, 0xB0C24BB8, 0xE2E0E7D4, 0xCF921A06, 0x5D6B0D23 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xB8000000, 0x54000000, 0xF2000000, 0xB7000000, 0x3E800000, 0x56C00000, 0x11E00000, 0xE6500000, 0x86E80000, 0xBB8C0000, 0xEC1E0000, 0x9D950000, 0xD2898000, 0xE39A4000, 0xC0D1E000, 0xB429F000, 0x906F0800, 0x41489C00, 0x3BFC9A00, 0x2EC37D00, 0x65E36380, 0x645326C0, 0x99EDEBA0, 0x690DFAD0, 0x1CDE91B8, 0xC97277D4, 0xBD5B7A16, 0x0D338D01 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x88000000, 0xB4000000, 0x22000000, 0xDF000000, 0x85800000, 0xC6C00000, 0xE2E00000, 0x51D00000, 0x04D80000, 0x51BC0000, 0x01AA0000, 0x0E110000, 0xE6BC8000, 0xC02AC000, 0x02D26000, 0x5F5DF000, 0xBE7CC800, 0xABCC0400, 0x4B840200, 0xF7C53D00, 0xC6628780, 0x6B970B40, 0xD07ACFA0, 0xCACDCF70, 0xD706ADB8, 0xF184027C, 0x84C4621A, 0x0DE5CD11 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x88000000, 0xEC000000, 0x0A000000, 0x85000000, 0x07800000, 0xB2C00000, 0xBBE00000, 0x09900000, 0x5A380000, 0x345C0000, 0xDE0E0000, 0x76570000, 0x6A5C8000, 0x550EC000, 0xC2D2A000, 0x28187000, 0xBAA99800, 0x23E18400, 0xFD91A200, 0xE439C500, 0x2F5BBD80, 0x328E7640, 0xA016A5A0, 0xEBFD3250, 0xD73BA7A8, 0x9FDB876C, 0x46CD020A, 0xB8B6B517 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xD8000000, 0x34000000, 0xEE000000, 0x4D000000, 0x79800000, 0xF8C00000, 0xE7600000, 0xE8700000, 0x92B80000, 0x665C0000, 0x5DEE0000, 0xD0B70000, 0x15DB8000, 0xBE2B4000, 0x0751E000, 0x5AEB1000, 0x92313800, 0xCD9A9400, 0x260C0200, 0x65836100, 0x8AC76680, 0x98656940, 0xCEF5DEA0, 0x5CF8BD50, 0x977E3CA8, 0x70BBCC54, 0x815DE21E, 0x6F687119 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xF8000000, 0xC4000000, 0x56000000, 0xA5000000, 0x18800000, 0x98400000, 0x9E200000, 0x47500000, 0x0FC80000, 0xA36C0000, 0xAB7A0000, 0xA1130000, 0xC8ED8000, 0x4EB84000, 0x9FF16000, 0xD9DC5000, 0x60063800, 0xB0041C00, 0x8801CE00, 0x6C06E700, 0x6A025180, 0x370579C0, 0xEB81E9A0, 0x25C525F0, 0x1EE347A8, 0x413092E4, 0xD6B8AE16, 0xEBF6B715 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x58000000, 0xFC000000, 0x2A000000, 0xFD000000, 0x72800000, 0x92400000, 0xC0E00000, 0xE8700000, 0x81680000, 0x4D0C0000, 0x343E0000, 0x44310000, 0xA28B8000, 0x44FF4000, 0xAE95A000, 0xA6197000, 0x5FE4D800, 0x63F36C00, 0x87AACE00, 0x40AD3100, 0x372FAE80, 0x1BEFD3C0, 0xEB48F6A0, 0x9ADFFFD0, 0x57419898, 0xDE66BEE4, 0xE8376E0E, 0x9088411B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xB8000000, 0x6C000000, 0x22000000, 0x83000000, 0x93800000, 0xDFC00000, 0xBAA00000, 0x58300000, 0x65780000, 0xA75C0000, 0x172A0000, 0x01350000, 0x39FC8000, 0x991B4000, 0xF9492000, 0xA422B000, 0x9572E800, 0x409ED400, 0x01895A00, 0x9B020700, 0x6F868280, 0x15C72B40, 0x5DA2EAA0, 0x3DB7BF70, 0x77BE1098, 0x2F7C485C, 0x805B5A36, 0x92AB0707 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xE8000000, 0x1C000000, 0xC2000000, 0x0F000000, 0x38800000, 0x6F400000, 0x6B600000, 0x5CB00000, 0x23080000, 0xE3EC0000, 0x6A9E0000, 0xE2B30000, 0x9E0B8000, 0x0C6AC000, 0x595D2000, 0xD092B000, 0x78DD0800, 0x86556C00, 0xC17BE600, 0x65415500, 0xA862CC80, 0xEE354AC0, 0xCF4A44A0, 0x9A09E6D0, 0x4A6F0288, 0x505CC3F4, 0x4113E632, 0x161D5533 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x68000000, 0xC4000000, 0xC6000000, 0x6B000000, 0xA1800000, 0x32400000, 0x55200000, 0xBFF00000, 0xA5080000, 0x86AC0000, 0x009A0000, 0x8BF30000, 0x7B0B8000, 0xF1AAC000, 0x5B1BE000, 0xB8B05000, 0xE6A8C800, 0x709AA400, 0x53F42600, 0x470A6700, 0x9BAC0C80, 0x321FDAC0, 0xB43544A0, 0x1E6CBEF0, 0xB67902A8, 0x8B6049D4, 0x08D42632, 0x07FA6725 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x48000000, 0x4C000000, 0x7A000000, 0xA1000000, 0x03800000, 0x15C00000, 0x49600000, 0x89700000, 0x57D80000, 0x963C0000, 0x500E0000, 0x7CF70000, 0xF91C8000, 0xADD8C000, 0x7739A000, 0x738CF000, 0x99343800, 0xF8780400, 0x68AF1A00, 0x5AE08900, 0x44B35680, 0xCABE9A40, 0x914DEEA0, 0xD8D55E50, 0x7E49D4A8, 0x6456E76C, 0x2F0B9A3A, 0x5874493F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x78000000, 0x4C000000, 0xBE000000, 0x2D000000, 0x95800000, 0xCF400000, 0x7AA00000, 0xD9700000, 0x0F380000, 0xEB1C0000, 0x39AA0000, 0xB0F10000, 0xA67A8000, 0x60BB4000, 0x435C2000, 0x698D5000, 0x50407800, 0xDC217400, 0x3EB69E00, 0xA75AD300, 0xB38A5C80, 0x67453340, 0x1EA2A4A0, 0xC3720770, 0x58389AB8, 0xD99FC44C, 0xBC6C1E26, 0x0391931F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x18000000, 0x94000000, 0x0E000000, 0x13000000, 0x71800000, 0x03400000, 0x31A00000, 0x20100000, 0x27480000, 0x726C0000, 0xFFBE0000, 0x21970000, 0xCC0F8000, 0x7FC94000, 0xCDAEE000, 0x97DB1000, 0x46E7C800, 0xEFB42400, 0xBC5AEE00, 0x38A68B00, 0x0C961F80, 0x668F73C0, 0xA10857A0, 0xF54917D0, 0x836DD9A8, 0xB73ACCF4, 0xC6556E2E, 0x106FCB11 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x78000000, 0x34000000, 0x22000000, 0x6F000000, 0x43800000, 0xE8400000, 0x8F200000, 0x32B00000, 0x38480000, 0x4DEC0000, 0x799E0000, 0x5A330000, 0x89888000, 0xD18D4000, 0x558BE000, 0xAF887000, 0x048F4800, 0x1D0F3400, 0xAE48C600, 0x40EED700, 0xF51E2680, 0x01F2BAC0, 0x96EFEEA0, 0x581FCED0, 0x7D724888, 0xB52B29EC, 0x737E4616, 0xD6E09721 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xD8000000, 0xE4000000, 0x3E000000, 0x13000000, 0x8B800000, 0x19C00000, 0x56A00000, 0x27700000, 0x6A880000, 0xCEAC0000, 0x4E9A0000, 0x37F30000, 0x14CE8000, 0x93CA4000, 0x1E4A6000, 0xE08B1000, 0xEBACC800, 0xFA197400, 0x97B76A00, 0x4AA8B700, 0xA09F4880, 0xECF78EC0, 0x934F00A0, 0x880BBAF0, 0x81EE8AA8, 0x617D5DFC, 0x0063EA1E, 0xF051F705 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x78000000, 0x34000000, 0x86000000, 0x53000000, 0x0B800000, 0xC7C00000, 0xD8E00000, 0x80F00000, 0x69180000, 0xAB7C0000, 0x3ACE0000, 0x68770000, 0x8D5B8000, 0xD85E4000, 0xC0DCE000, 0x2C995000, 0x23B88800, 0x03AAB400, 0xDE411A00, 0x9A257500, 0x5891B680, 0x01AD9C40, 0x2344BEA0, 0xAEA26850, 0x36D4C4A8, 0xB38B0D54, 0x17D49A36, 0x0D0C3519 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x18000000, 0x04000000, 0x7A000000, 0x1F000000, 0x14800000, 0x85400000, 0xFD200000, 0xFE300000, 0xD9980000, 0x21FC0000, 0xE2EA0000, 0xA5410000, 0x2D268000, 0xF6304000, 0xB59B6000, 0x47FF3000, 0x83E90800, 0xD4C28C00, 0xA3E2F600, 0x9AD32700, 0x33CF5280, 0x9D71E440, 0x85BD3AA0, 0xCE4C5870, 0xC5B6C4B8, 0xF05DF36C, 0x4D9B603E, 0xF3FF302D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x88000000, 0x6C000000, 0xA2000000, 0x4F000000, 0x35800000, 0x33400000, 0x03A00000, 0x06100000, 0x98980000, 0x187C0000, 0x75CE0000, 0x57430000, 0x8DA48000, 0x4B12C000, 0x921CA000, 0x96BE3000, 0x292A0800, 0xF0F5C400, 0x5C2ECE00, 0xFE76EB00, 0xCCEF1780, 0xB797D940, 0xF5D9BFA0, 0xAEDC2D50, 0x9D5D7988, 0x8F1F024C, 0x243CA02A, 0xE3EE3017 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x98000000, 0xC4000000, 0xB6000000, 0xC9000000, 0x8D800000, 0xED400000, 0x51600000, 0xEEB00000, 0x9E880000, 0x0AAC0000, 0xD97E0000, 0x33470000, 0xD4618000, 0xA9374000, 0x98C86000, 0x314B5000, 0x5A0BD800, 0x2A689400, 0x4558CE00, 0xDC90CD00, 0x3C59F480, 0xF911DAC0, 0xFD1A4CA0, 0x12721ED0, 0x30A95AA8, 0xBA7A47C4, 0x25C0600E, 0x9BA75035 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x58000000, 0x34000000, 0x92000000, 0xC5000000, 0x12800000, 0x36C00000, 0xF1600000, 0xD2900000, 0xBC080000, 0x2FAC0000, 0x4E5E0000, 0x5DC10000, 0x78E18000, 0xE5D14000, 0xF62FE000, 0x811BF000, 0x53E51800, 0x8C572C00, 0x516C8A00, 0x933CE900, 0xC955C980, 0x03ECCFC0, 0x45FF31A0, 0xA83013D0, 0x897EA398, 0xCDF7D6F4, 0x1599E00E, 0x0226F039 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x58000000, 0x1C000000, 0x96000000, 0xCD000000, 0x03800000, 0xCCC00000, 0x31E00000, 0x29500000, 0xCAB80000, 0xFB9C0000, 0x7D2E0000, 0x07C10000, 0x17628000, 0x42124000, 0x4D9DA000, 0xE02A9000, 0x4C443800, 0x6FA7C400, 0xA1F09200, 0x23CAB500, 0x72108380, 0xB598C040, 0xEC291BA0, 0x72459450, 0xE6A5B198, 0x2874E56C, 0xB40BA00E, 0x8D77902B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xD8000000, 0x94000000, 0xBE000000, 0x29000000, 0x99800000, 0x29400000, 0x86A00000, 0xD9D00000, 0x11980000, 0x827C0000, 0x8F0A0000, 0x14410000, 0x61248000, 0xB9944000, 0x3EBBE000, 0xAAEB9000, 0x8C321800, 0xF1ED7400, 0xD6B24E00, 0xB628F300, 0xF9D6D180, 0x819CA740, 0x0A7F29A0, 0xF30A4370, 0xE6477FB8, 0x6223C47C, 0xB711E00E, 0xA77A9019 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xA8000000, 0xC4000000, 0x72000000, 0xB3000000, 0x36800000, 0x9CC00000, 0xDFA00000, 0x1AF00000, 0x5BE80000, 0xDA8C0000, 0xC4DA0000, 0xD7470000, 0x88E28000, 0x5211C000, 0xA9FAE000, 0x4374F000, 0x2FAE2800, 0x3CEEBC00, 0xC60B4A00, 0x2719EF00, 0xB8626C80, 0x67D0A5C0, 0x97DEA4A0, 0xB1C6E9F0, 0x2C21C688, 0xD1B6BAFC, 0xAD0A6022, 0x1D9E300D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x58000000, 0x4C000000, 0x56000000, 0x89000000, 0x4A800000, 0xA9C00000, 0xC0E00000, 0x0F500000, 0x2B280000, 0xCC0C0000, 0x86BE0000, 0x5E410000, 0xC9A78000, 0x51774000, 0x631A2000, 0x49361000, 0x9BBE9800, 0x4EC7AC00, 0x5F63D200, 0x0214DD00, 0xD70BD380, 0x473B54C0, 0xCE076BA0, 0x6506E8D0, 0xAC842198, 0x28C499C4, 0x9E63A00E, 0xBC905017 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x78000000, 0x0C000000, 0x8A000000, 0x51000000, 0x43800000, 0x27C00000, 0xAA600000, 0xD4900000, 0xC6980000, 0xA93C0000, 0x92CA0000, 0xB5470000, 0x0E218000, 0xF9344000, 0xE8692000, 0xC333F000, 0xF168B800, 0x04B5C400, 0x78AD2A00, 0x01D4B100, 0x38BE2980, 0x780B5340, 0x0EA7B1A0, 0xF0716770, 0x24482388, 0xEF071264, 0xF482A016, 0x4F40B027 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x48000000, 0xF4000000, 0x62000000, 0x35000000, 0x9F800000, 0x06400000, 0xCDE00000, 0x51100000, 0x13380000, 0x469C0000, 0x196A0000, 0x23C70000, 0x82A38000, 0x3577C000, 0x036D6000, 0x7AC2F000, 0x63231800, 0x80334400, 0x4E0DE600, 0x7314E100, 0x463D7580, 0x691E6E40, 0x472B0DA0, 0x5223DA70, 0x45B7F388, 0x714F7F74, 0xEF76E01A, 0xFA693009 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xF8000000, 0xAC000000, 0x12000000, 0x65000000, 0x23800000, 0xE5C00000, 0x29E00000, 0xC4B00000, 0xB5F80000, 0x1FDC0000, 0x598A0000, 0x24470000, 0x31268000, 0x72D74000, 0xCE8F2000, 0xB2C63000, 0x1F60D800, 0x5AF7A400, 0x65D89A00, 0x188CBD00, 0xE1C72480, 0xBFE15540, 0xF7B0DCA0, 0x057CC170, 0xFA9A9E88, 0x6D2CD85C, 0x7851A036, 0xCACD7037 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x78000000, 0x14000000, 0x3A000000, 0x6D000000, 0xFF800000, 0xEC400000, 0x6C600000, 0xE5D00000, 0xD8180000, 0xCD3C0000, 0x6F0A0000, 0xA4830000, 0xA0C78000, 0x60A24000, 0x8B73E000, 0x146AB000, 0x33D61800, 0x5B1B4400, 0x45BEF600, 0x01C97D00, 0xA323EF80, 0xD135AD40, 0x0B0C17A0, 0x16875970, 0x91C379A8, 0xD9272074, 0x5C358036, 0xC48D4031 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x88000000, 0xC4000000, 0xB6000000, 0x6F000000, 0x6B800000, 0x07400000, 0xEAE00000, 0x06100000, 0x4E480000, 0xF4EC0000, 0x9F9A0000, 0x32810000, 0xC3C28000, 0xE620C000, 0x1BB5E000, 0x2ABFD000, 0x78B4E800, 0x933B9400, 0x36F71E00, 0x055DB100, 0x10241D80, 0xD4B2B5C0, 0xD13F15A0, 0x07F7F1F0, 0x35DE63B8, 0x42E114CC, 0x9210801A, 0xE04DC03D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x98000000, 0xF4000000, 0x16000000, 0x6F000000, 0x51800000, 0xC2400000, 0x42A00000, 0x45900000, 0xA6D80000, 0xA13C0000, 0x8B8A0000, 0xF0830000, 0xE8C18000, 0x37634000, 0xE275E000, 0x9C6BD000, 0x62306800, 0xB7CF4400, 0xA122E600, 0xA6D60B00, 0x0EFBEB80, 0xB1682F40, 0x5AB463A0, 0xF30FBB70, 0x54476DA8, 0xEDA5B444, 0x3413800E, 0xB49C4039 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x88000000, 0xDC000000, 0xEA000000, 0x5B000000, 0xE3800000, 0x48400000, 0x45A00000, 0x39100000, 0x8B380000, 0xF1DC0000, 0xDCEE0000, 0xC9810000, 0xB3418000, 0xD627C000, 0x69562000, 0x9A9DF000, 0xFECF6800, 0xE6D49400, 0x80DA8600, 0xC468F300, 0x12476780, 0xA6A01C40, 0xFE902FA0, 0xED787850, 0x517C4198, 0x6B7FDF74, 0x5879803A, 0xF7FBC003 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0xC8000000, 0x4C000000, 0xF6000000, 0x25000000, 0x00800000, 0x45400000, 0x59A00000, 0xB9500000, 0x8BA80000, 0x744C0000, 0x993A0000, 0xF2030000, 0x5F048000, 0xF384C000, 0x10C7A000, 0xD4639000, 0xE9B4F800, 0x9D5E9C00, 0x63B70600, 0x665EE300, 0x5A302D80, 0x6D9EDAC0, 0xE7D175A0, 0x37ECD6F0, 0x436C0BA8, 0xB42B69EC, 0x5288001A, 0x485C003F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x98000000, 0x5C000000, 0xAE000000, 0xEB000000, 0x68800000, 0x72400000, 0xFF200000, 0xB4D00000, 0x38680000, 0x280C0000, 0x9C7A0000, 0x74050000, 0xAA008000, 0xF9024000, 0x1D87A000, 0x69C35000, 0xB9E0C800, 0x97B16C00, 0x989F8E00, 0xCC332F00, 0xFE5FCD80, 0x3F509CC0, 0xF6AAA5A0, 0x1F6BA0F0, 0x668F6398, 0x113EA3FC, 0xB9A0003E, 0xED90002B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x28000000, 0xAC000000, 0x2E000000, 0x3D000000, 0xAF800000, 0xC5C00000, 0x07600000, 0x7D900000, 0x5AE80000, 0x434C0000, 0x973A0000, 0xBC010000, 0xA6078000, 0xA100C000, 0xF986A000, 0x7CC55000, 0x2AE5F800, 0xAB55E400, 0xCF0ABA00, 0x549F6900, 0x0F77F980, 0x85BC00C0, 0x1646A1A0, 0x04A1B4F0, 0x8BF463B8, 0xF6FAF9E4, 0xC9600032, 0xD090000F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0x04000000, 0x36000000, 0xE7000000, 0xC0800000, 0x40400000, 0x9DA00000, 0xA8D00000, 0x38780000, 0xF09C0000, 0xF46E0000, 0x13050000, 0x9E828000, 0xC341C000, 0x1B22E000, 0x2790D000, 0x615EA800, 0x2E0C8C00, 0xB6B53E00, 0x8BC9EB00, 0x12D72980, 0xBD78A840, 0xD91D61A0, 0xCFADF450, 0x146277B8, 0x3EB0534C, 0xDFCE0032, 0x1CD5000D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xD8000000, 0x4C000000, 0xAE000000, 0xFD000000, 0x41800000, 0xAB400000, 0xD9E00000, 0xF8F00000, 0x52D80000, 0x4F7C0000, 0x54EA0000, 0x4D030000, 0x49878000, 0x1F474000, 0x2BE42000, 0x73F1D000, 0xA258F800, 0x0BBC9400, 0xDB4ABE00, 0x2D929900, 0x48EBD280, 0xDB00DE40, 0xC8850AA0, 0x38C29A70, 0xE9A2CCA8, 0x0994D774, 0xA2EA001E, 0x3C030027 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xA8000000, 0x44000000, 0x16000000, 0x51000000, 0x5F800000, 0xA0400000, 0xE3A00000, 0xBBD00000, 0xE2980000, 0x9EFC0000, 0x16CA0000, 0xE4250000, 0xD7948000, 0x033FC000, 0x7A2EE000, 0x16D5D000, 0xD7191800, 0xC5BE4400, 0xB1EFB600, 0x0B328300, 0x2A69D180, 0x7D742F40, 0x78CAA9A0, 0x29207B70, 0x9212E798, 0x10796C5C, 0x290D9832, 0x47C1840D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x78000000, 0x7C000000, 0x52000000, 0xD5000000, 0x1B800000, 0xE8C00000, 0xF4200000, 0x03100000, 0xBCA80000, 0xCBCC0000, 0x5C3A0000, 0x23A10000, 0x51D78000, 0xF98A4000, 0xAD5EA000, 0xF750B000, 0xAECAD800, 0xAFB96400, 0xAF627200, 0xDBF51B00, 0x05980F80, 0xA37324C0, 0x9DDBF7A0, 0x3B10B0F0, 0x60ADFDB8, 0xA9CC7FE4, 0xA13D5826, 0x3C23243B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x38000000, 0x6C000000, 0x82000000, 0xDF000000, 0x38800000, 0x13C00000, 0xEA600000, 0x38F00000, 0xAA280000, 0x630C0000, 0x565E0000, 0xD0E10000, 0xB4328000, 0x98C94000, 0xB8392000, 0x2E10B000, 0xE71C8800, 0xCA47AC00, 0xF423E200, 0x62D3A900, 0x75FEFA80, 0x0174EDC0, 0x4469D2A0, 0x012AB1D0, 0xE58F9898, 0x309E04EC, 0x79060816, 0x7182EC37 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xB8000000, 0xDC000000, 0x66000000, 0xA7000000, 0xF7800000, 0x06400000, 0xC6200000, 0xD7700000, 0x18F80000, 0x731C0000, 0xC20A0000, 0x8CA50000, 0xB7B28000, 0xA0194000, 0x878CA000, 0xCFE21000, 0xEB11E800, 0xFFAD3400, 0xD390F600, 0x3A6C9F00, 0x81F66880, 0xFE3BC540, 0x1CF9A0A0, 0x791DA170, 0x5B0C1E98, 0x70221A6C, 0x98716836, 0x1B7D741B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xD8000000, 0x3C000000, 0xBE000000, 0xC1000000, 0xA8800000, 0x67C00000, 0x79E00000, 0xC0D00000, 0x1E380000, 0x049C0000, 0x8C6E0000, 0x6E650000, 0xEE928000, 0xB89E4000, 0x7268A000, 0xCF64D000, 0x36131800, 0x075E3C00, 0x37893200, 0xB1B49500, 0xE92BE780, 0xAB424040, 0xDC22DFA0, 0xA636EC50, 0xC76855B8, 0x0DE4954C, 0xAAD7980E, 0xE5397C03 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x98000000, 0x1C000000, 0xBA000000, 0x29000000, 0xD8800000, 0x89C00000, 0x32200000, 0xC6100000, 0x7C180000, 0xEB7C0000, 0xE88E0000, 0x0FA10000, 0xE5528000, 0x7AFC4000, 0x09CFA000, 0xCC47F000, 0xFD617800, 0xE2F2DC00, 0xABA88200, 0xAD333B00, 0xBA8CDF80, 0xE2A3D940, 0x7BD087A0, 0x903AB550, 0x526EDD98, 0x4710A26C, 0x809DF83E, 0xD4BF9C2B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x68000000, 0x3C000000, 0x6A000000, 0x45000000, 0xD8800000, 0x0EC00000, 0x8BA00000, 0xD1F00000, 0xC2B80000, 0x755C0000, 0x24CE0000, 0x84A10000, 0x5C708000, 0x2CF9C000, 0x143B2000, 0x409FF000, 0x84E99800, 0x1C133C00, 0xEE2F5A00, 0xE9B6CF00, 0xCCDCD480, 0x6C8C1F40, 0x42C6ECA0, 0x29A51350, 0xF8F50E98, 0xA83E107C, 0x6A9F9802, 0x21EE3C33 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0xB8000000, 0x14000000, 0xE6000000, 0xC9000000, 0x70800000, 0x1B400000, 0xEDE00000, 0xF3900000, 0xC3C80000, 0x83EC0000, 0xDFDE0000, 0x1AE10000, 0x2E148000, 0x160B4000, 0x9848E000, 0xEF2C5000, 0xECF8D800, 0x15527C00, 0x6BEC5600, 0x03DBD100, 0xB0E5F980, 0x2517F5C0, 0xF18941A0, 0x2E8E99D0, 0x8F0B2F98, 0x20CA64DC, 0xB86ED836, 0xC31F7C19 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x88000000, 0x04000000, 0x4E000000, 0x8F000000, 0xB4800000, 0xA4C00000, 0x8A200000, 0x01700000, 0x99D80000, 0x05BC0000, 0xC12E0000, 0xB9270000, 0x37F68000, 0xD818C000, 0x4A1DE000, 0xD7181000, 0xBE992800, 0x53D92C00, 0x84BA3A00, 0xDAAA3300, 0x1965EC80, 0x91147C40, 0x574FA4A0, 0x9CB18050, 0xC47F56A8, 0xCE8D8F7C, 0x8F17280A, 0x804E2C3D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xD8000000, 0xE4000000, 0xAA000000, 0xE3000000, 0x82800000, 0x1DC00000, 0xEB200000, 0xF7D00000, 0xDAB80000, 0xB8DC0000, 0x54EE0000, 0x79270000, 0x00D78000, 0x9A3B4000, 0xEA196000, 0xAB4AB000, 0x3E326800, 0xFAC9DC00, 0xA974A200, 0x102CC300, 0x6B81B980, 0xAC45DA40, 0x8C6531A0, 0x7531F650, 0xB44C9BA8, 0x92B55974, 0x1E0A681E, 0x6BD5DC0D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x78000000, 0x1C000000, 0xD6000000, 0x11000000, 0x9D800000, 0x0C400000, 0xC6E00000, 0x38900000, 0xF3680000, 0xB64C0000, 0xCF7A0000, 0x70E50000, 0x99928000, 0xF6EF4000, 0xD60CA000, 0xA79F9000, 0x4573D800, 0x21785400, 0x5DE74600, 0x42141900, 0xE3AD0180, 0xE96930C0, 0x5948F9A0, 0xB7FDB4F0, 0x2322C798, 0xF03769EC, 0x4E1BD806, 0x4B34542B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0xE8000000, 0x0C000000, 0x5E000000, 0xED000000, 0x4E800000, 0xC0400000, 0x68E00000, 0xC7F00000, 0x63D80000, 0x58FC0000, 0x712A0000, 0x21A30000, 0x73948000, 0xF76DC000, 0x8040A000, 0x88E3D000, 0x97F4F800, 0xFBDC6C00, 0xBCF85E00, 0x232D5100, 0x92A28A80, 0xD0158E40, 0x79A852A0, 0x28E4F270, 0x27F0D4A8, 0x33DBDF6C, 0xC0FE5812, 0x952CBC2F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xC8000000, 0x9C000000, 0x7E000000, 0x0F000000, 0x37800000, 0xD6400000, 0x6E200000, 0x5E100000, 0xEFB80000, 0x475C0000, 0xBAAE0000, 0x65650000, 0x9EB68000, 0x536AC000, 0x61012000, 0x40835000, 0xD5C46800, 0xAA65B400, 0x89313600, 0x15289F00, 0x3720C380, 0x4A948440, 0xD87D0BA0, 0x9C3DA050, 0x0B1FF5B8, 0x91891B6C, 0x11F3480A, 0x29CFE40B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x18000000, 0x8C000000, 0x52000000, 0xD7000000, 0x31800000, 0xDFC00000, 0x80200000, 0x5CB00000, 0x93180000, 0xA27C0000, 0x44AE0000, 0xEAE10000, 0x92158000, 0x45EF4000, 0xB8802000, 0x2B443000, 0x59674800, 0x22D52400, 0x88490A00, 0x61F31300, 0x7B788A80, 0x482FC440, 0xAFA462A0, 0xA6709050, 0x05BF8098, 0x188DD754, 0x1C51681E, 0x4A0C1437 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x08000000, 0x7C000000, 0x32000000, 0xF7000000, 0x38800000, 0xD2400000, 0x31A00000, 0x72100000, 0xD9C80000, 0xC9AC0000, 0x32DA0000, 0x3DE70000, 0x4EB38000, 0xB85DC000, 0xD8A72000, 0xE7943000, 0x0808C800, 0x38CB6C00, 0x202AAE00, 0xD11A3B00, 0x3B829F80, 0x64C0ABC0, 0x86E4F7A0, 0x9C3537F0, 0x491A3188, 0x8F8190F4, 0x8AC7E80A, 0x53E35C2B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x98000000, 0xA4000000, 0x62000000, 0xF3000000, 0x70800000, 0xF3400000, 0x1E200000, 0x0AF00000, 0x20880000, 0xCC6C0000, 0xB87E0000, 0xF7E50000, 0x08938000, 0xB2DD4000, 0x4C576000, 0xF538F000, 0xCCC6A800, 0x1BE78C00, 0x16944600, 0xE7DB4F00, 0xFDD4EC80, 0x1DF91AC0, 0xF520A4A0, 0x9E7226D0, 0xD1C8AAB8, 0x714E55C4, 0x5A0A481E, 0x802E3C2D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x78000000, 0x3C000000, 0xD2000000, 0x8D000000, 0x29800000, 0x12C00000, 0xD1600000, 0xDC300000, 0xA3180000, 0x863C0000, 0x552E0000, 0xD4270000, 0x08908000, 0x6EC94000, 0x5C55A000, 0x94AEB000, 0x92E61800, 0x1FF23400, 0xD9FF7200, 0xCDC93100, 0x4AD3AC80, 0x72EBFA40, 0x70C694A0, 0x44653E50, 0x99B4DEA8, 0x6BDECB4C, 0x9E5B3836, 0x4E99C403 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x68000000, 0x6C000000, 0x5E000000, 0xC7000000, 0xDE800000, 0xD2400000, 0x77E00000, 0x48500000, 0x45080000, 0x4F2C0000, 0x975E0000, 0x5F210000, 0x2FF78000, 0x3BBEC000, 0x0FF6A000, 0xCBB8D000, 0xD7F4A800, 0x9FBABC00, 0x8DF61E00, 0x6AB83900, 0xCA75DF80, 0xA17E0DC0, 0xB15657A0, 0x4C8FA1D0, 0xCBEBC198, 0x0EFA34C4, 0x56958802, 0x89ACAC1F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xB8000000, 0x7C000000, 0x3E000000, 0x51000000, 0x2A800000, 0x08400000, 0x62200000, 0xA4F00000, 0xF3B80000, 0x845C0000, 0xDD4A0000, 0x1CE70000, 0xC0948000, 0x7C6F4000, 0x7595A000, 0x24E9D000, 0x0AD19800, 0xB14BAC00, 0x0AE75E00, 0x05906700, 0x5CEF4480, 0xD6D34340, 0x7F4DFCA0, 0xE3E57F70, 0x53101A88, 0x6AAF244C, 0xE5F0B826, 0xF13D3C13 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xA8000000, 0x0C000000, 0x5E000000, 0x63000000, 0x75800000, 0xEBC00000, 0xD8600000, 0x9A300000, 0xF6980000, 0xD5BC0000, 0x5EAE0000, 0x2E230000, 0x45918000, 0x9ACEC000, 0xA217A000, 0xAC0DD000, 0x1CF08800, 0xD07EC400, 0x7DCBAA00, 0x1592D100, 0x72CDFC80, 0x0E115E40, 0x220D54A0, 0xD7F38A50, 0xA9FE5688, 0xC80F8F64, 0xAEF6A822, 0x9D7DD427 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x88000000, 0xD4000000, 0xAA000000, 0xDB000000, 0x24800000, 0x20C00000, 0xA7600000, 0x36B00000, 0x25380000, 0xA31C0000, 0x078E0000, 0x4C270000, 0x6F928000, 0xD72CC000, 0x5F776000, 0x61DDB000, 0xCFE82800, 0xE4152C00, 0x0969BA00, 0xABD73900, 0x308F1880, 0xDEA49F40, 0xCA54D0A0, 0x15CBC350, 0x3E86A2A8, 0x33C3A65C, 0x77E3C80A, 0x8C735C29 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x88000000, 0xFC000000, 0xE2000000, 0x07000000, 0x5C800000, 0x8B400000, 0x5DA00000, 0xDEB00000, 0x9B680000, 0x400C0000, 0xEDDE0000, 0x17630000, 0x67D48000, 0x71BAC000, 0x46342000, 0x662EB000, 0xD4A9C800, 0x72E84C00, 0x28C9C600, 0xB3BB3300, 0x71339280, 0x12AFDBC0, 0xD3ECFAA0, 0x454CE7D0, 0x0D7A5488, 0x9654E8CC, 0xBD7F682A, 0xFE533C33 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x78000000, 0x54000000, 0x56000000, 0x6F000000, 0x4D800000, 0xAC400000, 0x2B200000, 0x1A700000, 0x70680000, 0x2A1C0000, 0xFA720000, 0x406D0000, 0x32188000, 0x5E764000, 0x6E6C6000, 0x09189000, 0x45F78800, 0xAD2D7400, 0x6FBF9E00, 0xF3C3B300, 0xF664FE80, 0x5FD0CEC0, 0x79DB60A0, 0x9C137DF0, 0x97BF9E38, 0x67C3B30C, 0xC064FE86, 0xC0D0CEE9 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x78000000, 0x74000000, 0xBA000000, 0x05000000, 0xB4800000, 0xB2400000, 0x56E00000, 0xF6100000, 0x0D480000, 0xDB5C0000, 0x86160000, 0x854F0000, 0x67598000, 0x20154000, 0x364F6000, 0x18DFF000, 0x99D0B800, 0x636AEC00, 0xBEEFC600, 0x862F9D00, 0x158BEB80, 0x18FA1CC0, 0x53642DA0, 0xAAD581D0, 0x5CEFC608, 0xA72F9D14, 0xC30BEBB6, 0xCBBA1CD9 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x68000000, 0xA4000000, 0xE6000000, 0xAF000000, 0x9D800000, 0xEA400000, 0x0F600000, 0xB1900000, 0x8B480000, 0xF2DC0000, 0x8D920000, 0x61490000, 0xFFD88000, 0x2912C000, 0xD18F6000, 0x237A9000, 0x9BA08800, 0x4B36F400, 0x76FD2E00, 0x85E1A100, 0x5A540380, 0xD46F78C0, 0xB9292DA0, 0xAFCED9F0, 0x821D2E18, 0xB131A12C, 0xA3FC03A2, 0x0D6378F5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xC8000000, 0x14000000, 0xCE000000, 0x35000000, 0xD3800000, 0xCAC00000, 0x52200000, 0x18F00000, 0xE2C80000, 0x623C0000, 0xACF60000, 0xBCC90000, 0x4F3A8000, 0x1375C000, 0x640FE000, 0xF21C5000, 0x23021800, 0xAA80D400, 0xDB409A00, 0x0FE0DF00, 0xBE538280, 0x0C79CBC0, 0x309318A0, 0xA85914D0, 0xA1609A38, 0xF310DF3C, 0x3A9B82AA, 0xFF45CBE9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x34000000, 0xCA000000, 0xD3000000, 0xBF800000, 0x51400000, 0x0C200000, 0x6A700000, 0x8A680000, 0x341C0000, 0x04760000, 0xDB6B0000, 0x4C9D8000, 0x30B6C000, 0x5D0AE000, 0xA14A7000, 0x4BEE0800, 0x3C5D8400, 0x44D70600, 0x4FD9E300, 0x93943680, 0x56FD46C0, 0x736330A0, 0x1754A5D0, 0x889F0628, 0x82B5E314, 0x820A368A, 0xF8CA46C9 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0xF8000000, 0xB4000000, 0xA6000000, 0x9D000000, 0xFE800000, 0xAF400000, 0x69200000, 0x45100000, 0x71D80000, 0x38CC0000, 0x7B120000, 0x08D90000, 0x784F8000, 0x6D514000, 0xC17B6000, 0xBB1F1000, 0x2D289800, 0x8EE47C00, 0x26779E00, 0xF76BAB00, 0x95409D80, 0x3E227840, 0x449703A0, 0x7319D370, 0xD12F9E18, 0x14E7AB14, 0xC1729D86, 0x7EEB7849 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x08000000, 0x24000000, 0x8A000000, 0x11000000, 0x40800000, 0x46400000, 0x91200000, 0xB8100000, 0xF0680000, 0x727C0000, 0xFB160000, 0xBDEB0000, 0xF2BE8000, 0xE375C000, 0x475A6000, 0x8903F000, 0x7C851800, 0xB042EC00, 0x5626C600, 0x4F922300, 0x49AAE580, 0x7E9A25C0, 0xC5E423A0, 0x627406D0, 0x1FD8C628, 0xB345230C, 0x3BA2658A, 0xBF54E5D5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x58000000, 0x74000000, 0x66000000, 0x8F000000, 0x26800000, 0x6C400000, 0xD7600000, 0x90D00000, 0xB0480000, 0x8E9C0000, 0x5DD20000, 0x07C90000, 0xCF5B8000, 0xEE704000, 0x8F386000, 0x0C231000, 0xC5330800, 0x92DB2C00, 0x02B64600, 0x5B1E5100, 0x7D17D180, 0xD1EEE2C0, 0x0F6997A0, 0x272CB3F0, 0x3E4C4618, 0x1D9B5134, 0xC15651AE, 0xBE8BA2D9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xA8000000, 0xAC000000, 0x1A000000, 0x43000000, 0x58800000, 0x7E400000, 0xCBA00000, 0x4F300000, 0x98A80000, 0xF19C0000, 0xD8360000, 0xBE2B0000, 0x4ADD8000, 0xAA13C000, 0x90DB2000, 0x89103000, 0xF85D0800, 0x4F55FC00, 0x37FE0600, 0xB6672700, 0xF6531880, 0x5C7B1AC0, 0x08A51EA0, 0x57B03DD0, 0xC6E80628, 0x2A3C2714, 0x3F0698A2, 0x8A84DAEF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xD8000000, 0xFC000000, 0xDE000000, 0x2F000000, 0x74800000, 0xC3400000, 0x38A00000, 0x68F00000, 0x64480000, 0x76BC0000, 0x5FF60000, 0xCCC90000, 0xBBFA8000, 0x20554000, 0xF4B82000, 0x3EF39000, 0x9F4EC800, 0x983CFC00, 0x21B72E00, 0xA9EF9700, 0xB7CD3E80, 0x157E6BC0, 0x3E1210A0, 0x219DFCD0, 0xEAC12E38, 0x5666973C, 0x8C97BEAE, 0x11DB2BD3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xE8000000, 0x6C000000, 0xEE000000, 0x8D000000, 0xF6800000, 0xF2C00000, 0x39A00000, 0x48700000, 0x13C80000, 0x7ABC0000, 0x51F60000, 0xE4890000, 0x42598000, 0x9867C000, 0x72552000, 0xBBF99000, 0xF016D800, 0xD19DFC00, 0xF9433200, 0x25E1C300, 0xB7141280, 0xD81F1FC0, 0xC60120A0, 0xC107DCD0, 0xA884B238, 0x47C30324, 0x4B26B2A2, 0x38B44FEF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xB8000000, 0x14000000, 0x9E000000, 0xD7000000, 0x51800000, 0x25400000, 0xE1A00000, 0x95F00000, 0x01E80000, 0x6F1C0000, 0xF5760000, 0x96290000, 0xF4788000, 0x3B644000, 0x1E146000, 0xA038D000, 0x08440800, 0x01235400, 0x4234F600, 0xFA8BEF00, 0x510E5680, 0xC549A6C0, 0xD66CA0A0, 0x595B49D0, 0xF3527638, 0xAD9AAF2C, 0x77B4B6B6, 0xB9CC36F9 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x98000000, 0x14000000, 0x02000000, 0x27000000, 0xCC800000, 0x8C400000, 0x58A00000, 0x33D00000, 0x2A680000, 0x22BC0000, 0x2A520000, 0xC5AB0000, 0x16DF8000, 0x0B604000, 0x39B76000, 0xD25B3000, 0x6B276800, 0x07153C00, 0x8C8FB600, 0x26CD0F00, 0x736AC780, 0x573D6BC0, 0x639771A0, 0x3CCB64F0, 0x806A3608, 0x39BA4F04, 0x18D0278E, 0x30ED1BF1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x98000000, 0xAC000000, 0x12000000, 0xB1000000, 0xE0800000, 0x6FC00000, 0x09200000, 0x83B00000, 0xB1280000, 0xC19C0000, 0x79320000, 0xFBED0000, 0x26398000, 0x7E404000, 0x2664A000, 0x55507000, 0x73BF5800, 0xC7072C00, 0xB7878A00, 0xE0452F00, 0xF5605880, 0x2CD12EC0, 0x18FDD2A0, 0x87E501F0, 0x32160A38, 0x91596F04, 0xBB96F8BE, 0x121C5EDF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xB8000000, 0x34000000, 0x7E000000, 0x6D000000, 0x65800000, 0x94400000, 0x67A00000, 0xFB100000, 0xD7080000, 0xCF1C0000, 0xD8920000, 0xDA4B0000, 0x13398000, 0xCAC74000, 0xB7676000, 0x8777D000, 0xDCFDD800, 0x34202400, 0xFE53DE00, 0x972A0700, 0x2F482180, 0x92B92EC0, 0x3881FFA0, 0x99C429F0, 0xDFE25E08, 0xC6B14734, 0x871D4186, 0x2495FEC9 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x18000000, 0x24000000, 0x6A000000, 0xAF000000, 0xC3800000, 0x2A400000, 0xA0600000, 0xED100000, 0x8B180000, 0x070C0000, 0xCA960000, 0x2B5F0000, 0xD86A8000, 0x8C054000, 0xB606E000, 0x3104F000, 0x6E856800, 0x7AC28400, 0x07A53E00, 0xA2327900, 0xAAE90F80, 0x88C07E40, 0xCCA231A0, 0xABB10750, 0x5FAFBE08, 0xF327390C, 0x2FF7EFAE, 0xEAC88E55 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0xE8000000, 0xAC000000, 0x12000000, 0x05000000, 0x68800000, 0x13400000, 0x73E00000, 0xB7D00000, 0xFE880000, 0xDA5C0000, 0x17560000, 0x71CF0000, 0xF3BA8000, 0x7982C000, 0x1DC52000, 0x93A37000, 0x67B47800, 0xCD994C00, 0x85F22E00, 0x60F9BD00, 0x4A644D80, 0x0A1014C0, 0x1D2863A0, 0x55EAA9D0, 0x76C8AE08, 0xE63B7D0C, 0x96416D92, 0x5B6364F7 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x88000000, 0xC4000000, 0x0A000000, 0x8F000000, 0x41800000, 0xC0C00000, 0xD2A00000, 0x39D00000, 0x43F80000, 0xC32C0000, 0xC8520000, 0x6B3B0000, 0x858E8000, 0x8381C000, 0xEBC16000, 0xC924F000, 0x0E17E800, 0x9CDC1400, 0xF43E7A00, 0xDC0EBB00, 0x5F462F80, 0x8F635B40, 0x39F255A0, 0x4D6AE070, 0x5BB0FA08, 0xE08F7B0C, 0xDD074F8A, 0xB287AB4D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xD8000000, 0x6C000000, 0x36000000, 0x9F000000, 0x50800000, 0xFDC00000, 0xC6600000, 0xFD100000, 0x3DF80000, 0x106C0000, 0x90560000, 0x26590000, 0xFB1A8000, 0x38BD4000, 0xBFC8A000, 0x21225000, 0x27B70800, 0xAD0D5C00, 0x4FC0FA00, 0x9B633500, 0x08967780, 0x89BBA540, 0x3C4C0DA0, 0x6A65D050, 0xEB12DA38, 0x72FC253C, 0x28E9DFAE, 0xD994A977 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xB8000000, 0xE4000000, 0xEE000000, 0x43000000, 0xF0800000, 0x90400000, 0x30A00000, 0xCF700000, 0xA6680000, 0xF99C0000, 0x1FB20000, 0x7E8F0000, 0xC24C8000, 0xA8AE4000, 0xDA79E000, 0x30E2D000, 0xB7D62800, 0x151FFC00, 0x65F31600, 0xF32C8F00, 0x36BF3280, 0x3206A6C0, 0x8900A4A0, 0x7D8469F0, 0x13C67628, 0xE8601F3C, 0x8B90FAA6, 0xB7BB8AF5 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x98000000, 0x9C000000, 0xAE000000, 0x3D000000, 0xA4800000, 0xA4400000, 0xDDA00000, 0x01F00000, 0x35580000, 0xC02C0000, 0xA9320000, 0x98BB0000, 0x16798000, 0x829E4000, 0xC24F2000, 0xDEA61000, 0xC073D800, 0x09996C00, 0x07C9D600, 0xD0657700, 0x9490BE80, 0xE948BB40, 0x0B20E8A0, 0x56B38C70, 0xC17F7608, 0x491D2734, 0xE18C468E, 0xB6C7C763 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x28000000, 0x64000000, 0x1E000000, 0xF1000000, 0x41800000, 0xCBC00000, 0xDAE00000, 0xBD500000, 0xFB380000, 0xEFEC0000, 0x9B160000, 0xC0190000, 0x2F5F8000, 0x19FFC000, 0x688F6000, 0xDF865000, 0x7AC7B800, 0xFB646400, 0x66964200, 0x09DD9100, 0x36B96980, 0x7E2F1940, 0xDEF0ABA0, 0xF5CD4850, 0x1226A238, 0x9D340114, 0x7B29B192, 0xE9712D5D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xD8000000, 0x34000000, 0x9A000000, 0x57000000, 0xDA800000, 0x0E400000, 0x4DA00000, 0x40700000, 0xF6980000, 0x006C0000, 0x96B20000, 0x767D0000, 0xFD398000, 0x711A4000, 0xFBAE6000, 0x8BD2F000, 0xE7EB2800, 0xBD728C00, 0xB31D9600, 0x58AC1700, 0xAB55F280, 0x6EAEB940, 0xF251E4A0, 0xC928EE70, 0x79927638, 0xBC48A704, 0xD402BAAE, 0x8A03C579 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xB8000000, 0xCC000000, 0xEA000000, 0x25000000, 0xA5800000, 0xBA400000, 0x4BA00000, 0xC6B00000, 0x93480000, 0xAA7C0000, 0x2E720000, 0xEE2F0000, 0xF2AB8000, 0x7F694000, 0x4788A000, 0x551CB000, 0x27A63800, 0x3CB62400, 0x2E4B8E00, 0x13F8D700, 0xC6369C80, 0x4C8D49C0, 0x7B9E92A0, 0x7360DEF0, 0x03D2AE28, 0x079E2704, 0x116184A6, 0xA2D19DC7 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x98000000, 0x44000000, 0xC6000000, 0xA7000000, 0x2B800000, 0xB4400000, 0x5C200000, 0x31500000, 0x43A80000, 0xBB7C0000, 0x9D960000, 0x9E4F0000, 0x214B8000, 0x0EC84000, 0xDC8DE000, 0x77AD9000, 0xF57E4800, 0x46930400, 0x67C9AE00, 0x6C092B00, 0x9A6B5F80, 0xB41981C0, 0x7B6171A0, 0x08F4EAD0, 0x1DB9CE08, 0x5D73FB04, 0x5AFB778E, 0xD4D355C5 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x08000000, 0xCC000000, 0xEE000000, 0xD3000000, 0x52800000, 0x4AC00000, 0xA5E00000, 0xBED00000, 0x68780000, 0x562C0000, 0x51920000, 0x47DB0000, 0x42DF8000, 0xB75CC000, 0xF5192000, 0x33389000, 0x83882800, 0xBC63AC00, 0x02941200, 0xD55B3100, 0xA81F0580, 0xC2BBBF40, 0x43CC97A0, 0x97404E70, 0x3BA0B208, 0x3EF46104, 0x17C98DAA, 0xDD404347 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xE8000000, 0xB4000000, 0x22000000, 0x81000000, 0x21800000, 0x56400000, 0xC2200000, 0xA9100000, 0xE6480000, 0x2FDC0000, 0x5E560000, 0xB5EF0000, 0x988E8000, 0x3E3EC000, 0xF921E000, 0x15943000, 0xA788D800, 0xE8BC6400, 0x7DE64E00, 0x39731B00, 0xE77DCD80, 0xA5810CC0, 0x7C4303A0, 0xA723D7D0, 0xB291AE08, 0x6D082B2C, 0x5A7B9592, 0x0203A8D1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xB8000000, 0x1C000000, 0x1A000000, 0xD1000000, 0x03800000, 0x65C00000, 0x27A00000, 0xC0500000, 0xE3B80000, 0x516C0000, 0x04960000, 0x8F9B0000, 0xE0F98000, 0xEE8F4000, 0x71A22000, 0xD357B000, 0x9D3E1800, 0x052B3400, 0x33F0C200, 0x6DEFAB00, 0x6DD0FB80, 0xA97FE540, 0x824FB9A0, 0xF9840E50, 0x44C4E228, 0x2C231B34, 0x919763A6, 0x7A1B9163 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x48000000, 0xEC000000, 0xB2000000, 0x03000000, 0xF3800000, 0x70C00000, 0x3F200000, 0x9C300000, 0xEC580000, 0x28EC0000, 0x9BF60000, 0x76FB0000, 0xB91F8000, 0x5A0EC000, 0x0A622000, 0x9ED37000, 0x65CC4800, 0x64C42400, 0x1926AA00, 0xF9319700, 0x5ADD8C80, 0xBEA9C140, 0x7A92A6A0, 0xE7AD9650, 0x76128A28, 0xBEE9E704, 0x86F6449A, 0x147F256F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0xA8000000, 0x04000000, 0x2A000000, 0xCB000000, 0x32800000, 0x68400000, 0xADA00000, 0xABF00000, 0x2BA80000, 0xFDDC0000, 0x66B20000, 0xB58F0000, 0x97EE8000, 0x627CC000, 0x8A466000, 0xF2A5F000, 0x4B70C800, 0x54E92C00, 0xE4FAE600, 0x40030700, 0xE001AE80, 0x50020CC0, 0xD807C8A0, 0xAC02CBF0, 0x2E068628, 0xE105F72C, 0xF985E6A2, 0x5AC4E0DD } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x38000000, 0x7C000000, 0x06000000, 0xF7000000, 0xAE800000, 0x79400000, 0x9D600000, 0x22500000, 0xC5880000, 0x625C0000, 0x86120000, 0xFF690000, 0xFCCD8000, 0xDF3D4000, 0x94472000, 0xD2E45000, 0xDA97C800, 0x232E6C00, 0x9A28AE00, 0x77A94900, 0xD26A0580, 0x534DB8C0, 0xF7FD2BA0, 0x4AE0B1F0, 0x56958E18, 0x2D281904, 0xF92A4DB6, 0x9B2B94EB } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xD8000000, 0x84000000, 0xD6000000, 0xC5000000, 0x92800000, 0xB6400000, 0xDB200000, 0xA0B00000, 0x03380000, 0x600C0000, 0x79F60000, 0x0D9D0000, 0xBF788000, 0x6C2B4000, 0xB8C3E000, 0x9F641000, 0xF892D800, 0x5C0BDC00, 0x1BF17600, 0x269DD300, 0x1CFCD080, 0x46EF9240, 0x94A326A0, 0xA0740150, 0x285C9618, 0x7698C30C, 0x14F8888E, 0x8AEE0E7D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xC8000000, 0x8C000000, 0x0A000000, 0xFD000000, 0x44800000, 0x35400000, 0xFF200000, 0xD3B00000, 0x38880000, 0x88BC0000, 0x94F20000, 0x2EAB0000, 0xF18D8000, 0x7238C000, 0x22B52000, 0xB60BB000, 0xE0FC7800, 0xBF516C00, 0x005AFE00, 0xBA200B00, 0x23303880, 0x73CC1FC0, 0x549D46A0, 0xB0C3D4F0, 0x1CE7DE08, 0x00D7BB14, 0x469E409A, 0x69C673C7 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x78000000, 0x8C000000, 0x86000000, 0x53000000, 0x93800000, 0x2BC00000, 0x68E00000, 0xB0F00000, 0x1A380000, 0x5C4C0000, 0x45360000, 0xDDDD0000, 0xB13D8000, 0x03CB4000, 0x08F6A000, 0x363BD000, 0xEA48E800, 0xBE312400, 0xBA5B5200, 0x90FD5100, 0xBE2FB480, 0x7884AC40, 0x944766A0, 0xF523BD50, 0x2315F218, 0xCD4A8124, 0x67B15CA6, 0xA4988857 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x18000000, 0x44000000, 0x6E000000, 0x8D000000, 0x7B800000, 0xF7C00000, 0x0EA00000, 0xED700000, 0x26280000, 0x0BDC0000, 0xC8B20000, 0xFF8D0000, 0x062A8000, 0x1BDF4000, 0x00B3E000, 0x1389D000, 0x342D5800, 0xBCDAD400, 0x9834F200, 0x12CA7300, 0xB6C99A80, 0xA8CB30C0, 0x5DCDE8A0, 0xD24F03F0, 0x538F1238, 0x942FA31C, 0x6CDEC29E, 0x3030E4FD } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x58000000, 0x94000000, 0xAE000000, 0xE9000000, 0xE4800000, 0xA3400000, 0x70600000, 0xB7500000, 0x61080000, 0x91DC0000, 0x58160000, 0x6B6F0000, 0xC1898000, 0x249C4000, 0xE5756000, 0xDEBE5000, 0x26C17800, 0x1BA48C00, 0xEE742E00, 0xA9388100, 0x8605E580, 0xD50564C0, 0x36864BA0, 0x3842A5D0, 0x1FE14E08, 0x2396D114, 0x11AC9DBE, 0xF82DE8E1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x18000000, 0x7C000000, 0x86000000, 0xA7000000, 0xDA800000, 0x02400000, 0x51600000, 0x45500000, 0x23980000, 0x594C0000, 0x2F160000, 0x56F90000, 0x86188000, 0xDD894000, 0x6A362000, 0x0DC95000, 0x5E514800, 0x5F1D4C00, 0x6C0ED600, 0x4CF1F100, 0x75EEBD80, 0x0EE3A840, 0xE096EBA0, 0x1B3E1950, 0xDAB8F638, 0xA478A12C, 0xC05FF59E, 0xE6EEE463 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0xFC000000, 0x86000000, 0x11000000, 0x05800000, 0xDCC00000, 0xE7E00000, 0x79500000, 0x94780000, 0x4BAC0000, 0x05960000, 0x43990000, 0x7AFF8000, 0x45EF4000, 0x4A332000, 0x146A5000, 0x94F2F800, 0xF88C0400, 0x6F23DA00, 0x9CB00100, 0xE62AA180, 0x5D524B40, 0xBE78FBA0, 0x84A80A50, 0xFD10FA38, 0x24DA5114, 0xACD85996, 0x58DE4F7B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x98000000, 0x84000000, 0xE2000000, 0x75000000, 0xF7800000, 0x09C00000, 0xE0600000, 0xA0100000, 0xAC780000, 0xA5AC0000, 0x59B20000, 0xB4090000, 0xCDC78000, 0x22664000, 0xA517E000, 0x53FFB000, 0xB06C7800, 0xDFD23400, 0x8319E200, 0xE33B6500, 0x798FFF80, 0x1505CD40, 0xA781FDA0, 0x71C11870, 0xF4627A18, 0xDA16E114, 0x5D7A659E, 0xB02C9C45 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x08000000, 0x0C000000, 0xCE000000, 0x25000000, 0x64800000, 0x37C00000, 0x89A00000, 0x36D00000, 0xCA980000, 0x178C0000, 0xD2B60000, 0x3AED0000, 0xD8418000, 0xEFE0C000, 0x04372000, 0x1E2C9000, 0xA4631800, 0x10706C00, 0x9FCBEA00, 0x35525B00, 0x32DC9F80, 0x086D3C40, 0x6E8055A0, 0x70C3F750, 0xB627D218, 0x1892A704, 0x147A6DBA, 0x5D3E0B57 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xE8000000, 0xC4000000, 0x66000000, 0x21000000, 0xDB800000, 0xE5400000, 0x6BA00000, 0x52900000, 0x42B80000, 0xC16C0000, 0x16760000, 0xB88F0000, 0xEDC58000, 0x1A61C000, 0xD2F46000, 0x5B499000, 0x52A17800, 0xD513F400, 0xDDFFC600, 0x51CDFF00, 0xF4665580, 0x47F68B40, 0x3ECDF3A0, 0x2AE2E450, 0x2F32DE08, 0xE92B9B34, 0xE456EB92, 0x785B8055 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x08000000, 0x14000000, 0x22000000, 0x5D000000, 0x6C800000, 0x9AC00000, 0x4CA00000, 0x54D00000, 0xBE780000, 0xBC6C0000, 0x00B60000, 0xEB090000, 0x62468000, 0xB463C000, 0x2573E000, 0xB6283000, 0x90D7B800, 0xE47B2C00, 0x9D69A200, 0x6A33DB00, 0x06CAE780, 0x0B65A340, 0x34F0A5A0, 0x106E4850, 0x7EB5FA38, 0xE00CC71C, 0x41C2FD9A, 0x17245449 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x18000000, 0x54000000, 0x0A000000, 0x29000000, 0x07800000, 0x2BC00000, 0x69600000, 0xB7900000, 0xD6080000, 0xD85C0000, 0xDA320000, 0x987F0000, 0x26808000, 0x10434000, 0x24A36000, 0x19F77000, 0x5D19D800, 0x5F17D400, 0x4D4F3200, 0x9E7E5D00, 0xB1814B80, 0xA4C592C0, 0x89E519A0, 0x10D0BFF0, 0xF62F8A28, 0x74EDF91C, 0xDA0D218E, 0x665C5BF9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x48000000, 0xE4000000, 0x6E000000, 0x7F000000, 0x27800000, 0x47C00000, 0x37A00000, 0x89D00000, 0xF9A80000, 0x81BC0000, 0x2CB20000, 0xA15D0000, 0xB6848000, 0xDF47C000, 0x37E66000, 0x89B7D000, 0x0FDAC800, 0x15C1E400, 0x3AA67200, 0x73537B00, 0x1CEF4F80, 0x8F5FFDC0, 0x69875DA0, 0xE8C756F0, 0x4820DA38, 0x12144F2C, 0x0C0D758A, 0xFD6BA2E5 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0xB8000000, 0x44000000, 0xBA000000, 0x81000000, 0x4E800000, 0x21C00000, 0xDA600000, 0x71500000, 0x82B80000, 0xAC2C0000, 0x8FF60000, 0x7D0D0000, 0xCF058000, 0x5D814000, 0xF240E000, 0x9B217000, 0x09F41800, 0xA20C5C00, 0x8A82AA00, 0xDBC1D500, 0xBB602D80, 0xEFD01140, 0x1B7A67A0, 0x324CB450, 0x44A05218, 0x7EB1F924, 0x2DAB1F96, 0xF3B0D865 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xF8000000, 0xEC000000, 0xC6000000, 0x21000000, 0xD4800000, 0x52400000, 0x6EE00000, 0x16F00000, 0x37080000, 0xB9BC0000, 0x37560000, 0xE59B0000, 0x27078000, 0x95874000, 0xF6C1A000, 0x94A3D000, 0x6C10F800, 0x0BF8CC00, 0x69B60600, 0x7B6AED00, 0x54086480, 0xFE3F1DC0, 0xCA97C2A0, 0x42BA20D0, 0xECD15E28, 0x765AF104, 0xB5211AB6, 0xA0D67CEF } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x88000000, 0xD4000000, 0x9A000000, 0x8B000000, 0xD9800000, 0x60C00000, 0x06200000, 0xE4100000, 0x37680000, 0xB5BC0000, 0xE1F60000, 0x08DD0000, 0xF4078000, 0xAA02C000, 0x7305E000, 0x1586F000, 0xA6C4C800, 0xC3243400, 0x2C911A00, 0x052F6F00, 0x0ADDDD80, 0x63039DC0, 0xDD8127A0, 0x92C602D0, 0xC9263218, 0x2F90AB34, 0x08AF8F9A, 0xF01A06D1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xA8000000, 0xE4000000, 0x5A000000, 0xA1000000, 0xA5800000, 0xB3C00000, 0x22200000, 0xD9700000, 0x82680000, 0x1EDC0000, 0x91920000, 0xC0BD0000, 0x70008000, 0x6804C000, 0x84016000, 0xAA027000, 0x09029800, 0x41870400, 0xE9C26200, 0x83218700, 0x7CF2F680, 0x31AF46C0, 0x3CF9F4A0, 0x48E0B1F0, 0x42D39A38, 0x6ED9F30C, 0xF9928CB2, 0x44BD05C5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x18000000, 0x0C000000, 0xD2000000, 0xC9000000, 0xBA800000, 0xDB400000, 0x72E00000, 0x4EF00000, 0xCFC80000, 0x837C0000, 0xDCD60000, 0xA6190000, 0x85E38000, 0x3F764000, 0x1F0BA000, 0x0C5E7000, 0xF1861800, 0x90C2FC00, 0xEF221E00, 0xBD574500, 0x2EDC9480, 0x66C023C0, 0x50232AA0, 0xF8D016D0, 0xD01A2638, 0x7AE48934, 0x1AF0B29E, 0x71CDAAE7 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x68000000, 0xAC000000, 0x1A000000, 0x63000000, 0x24800000, 0x28C00000, 0x2C200000, 0xDF100000, 0xAF080000, 0x8FDC0000, 0x36720000, 0xBB7F0000, 0xA3A28000, 0x4F52C000, 0xF9EF2000, 0x43EE3000, 0x10EA8800, 0x7C6C5C00, 0x08AC3200, 0x568CFF00, 0x469C1D80, 0xD710B6C0, 0x130D0FA0, 0x2DDD79F0, 0x61711A28, 0x41FF530C, 0x5E650792, 0x3EF3E5D7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x28000000, 0x24000000, 0x8A000000, 0xB1000000, 0xE0800000, 0x0BC00000, 0x61A00000, 0x46500000, 0x84A80000, 0xE43C0000, 0x77B20000, 0x39190000, 0x4C228000, 0x0B16C000, 0x21CF6000, 0x0048F000, 0xE30A9800, 0x7D6EAC00, 0xC89F8A00, 0xB7631B00, 0x9976DB80, 0x3A3CF9C0, 0x44B431A0, 0x9C9E12F0, 0x3562F218, 0xDC76873C, 0x48BC29B2, 0xF2767EC5 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x18000000, 0xB4000000, 0x02000000, 0x7B000000, 0xCC800000, 0xE1C00000, 0x19A00000, 0x80900000, 0xEEA80000, 0x06FC0000, 0x4E760000, 0x695B0000, 0xD7E78000, 0x40704000, 0xB45C6000, 0x5A633000, 0xF2310800, 0x9AB91C00, 0xED97FA00, 0x4B2EDB00, 0x68BA0D80, 0x9E90EFC0, 0x0BAF97A0, 0x6F7A04D0, 0xE6351228, 0x88B8B704, 0xAE969F8E, 0x63AF18F9 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x98000000, 0xBC000000, 0xAE000000, 0x87000000, 0xF0800000, 0xC7C00000, 0x0CA00000, 0xD5100000, 0x46080000, 0xA5DC0000, 0x44F20000, 0x9D7B0000, 0xDBE58000, 0xEE764000, 0x37BC2000, 0x82C01000, 0x2D238800, 0xE9535C00, 0xDBE84A00, 0x18AAA300, 0x39CEA980, 0x4578D6C0, 0x07E0C3A0, 0x707565F0, 0xB8BA6208, 0x5643AF14, 0xF8E34B8E, 0xCCF639CB } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x18000000, 0x64000000, 0x1E000000, 0x1B000000, 0x5A800000, 0xF1C00000, 0x53A00000, 0xA1100000, 0xE2880000, 0x0F5C0000, 0x8BF20000, 0xA8FF0000, 0xCCE38000, 0xC5704000, 0x4F3AE000, 0xD8415000, 0x94E6E800, 0x41702C00, 0xA13B2A00, 0x0B410B00, 0xB2606180, 0xCAB462C0, 0xF79BABA0, 0xEBD739F0, 0xFBACA228, 0x678C3704, 0x8EDD438E, 0x00B715ED } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0xF8000000, 0x14000000, 0xCE000000, 0x35000000, 0x00800000, 0xE3C00000, 0x97200000, 0xE7100000, 0xD0E80000, 0xC73C0000, 0xC9760000, 0xF81D0000, 0xB2628000, 0xEAF44000, 0xAA586000, 0x20035000, 0x90021800, 0x28060C00, 0xDC00EA00, 0x2205CF00, 0xEF032580, 0xFB80D1C0, 0xD645AFA0, 0x74674ED0, 0x93F01218, 0xA0D8D31C, 0xF0C7B786, 0xDEA142C9 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x28000000, 0x14000000, 0x62000000, 0x87000000, 0x8C800000, 0xBAC00000, 0x5F200000, 0xB9D00000, 0xF8D80000, 0xEACC0000, 0x74B60000, 0xDEE90000, 0x3FE78000, 0x1DF3C000, 0xDB8AE000, 0x5DD73000, 0xE2DC6800, 0x31CFFC00, 0x9E342200, 0xA92B5700, 0x7F447380, 0xF0670E40, 0x41B4B1A0, 0xDD6E6950, 0x6DA52A38, 0xA2105B14, 0x867ED992, 0xE6589541 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x98000000, 0xF4000000, 0xFA000000, 0xC7000000, 0x95800000, 0x80C00000, 0xAAA00000, 0x17100000, 0xDB980000, 0x554C0000, 0xD4F20000, 0xD0ED0000, 0xCA658000, 0x2DB04000, 0x34886000, 0x2AD6F000, 0xE3BB2800, 0x371A3400, 0x750FFA00, 0xA012AB00, 0x26196180, 0x898CF240, 0xB854FBA0, 0x96F9A970, 0x4D793238, 0x50BE2F24, 0x989DD3BE, 0x52CE9D69 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x28000000, 0xA4000000, 0x7E000000, 0xE5000000, 0x8D800000, 0x8EC00000, 0x12600000, 0x1BF00000, 0x14880000, 0xA6BC0000, 0xDAD20000, 0x0BDF0000, 0x17A68000, 0xD914C000, 0xD03D6000, 0xAC915000, 0x62FB9800, 0x6CF36400, 0x360E6A00, 0x46FF8D00, 0xD2F08080, 0xF309BDC0, 0xBB798AA0, 0x743460F0, 0x456E1228, 0xDE89792C, 0x85B81282, 0x6E5404F5 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x28000000, 0x3C000000, 0x6E000000, 0x07000000, 0x81800000, 0x0F400000, 0x03600000, 0x59500000, 0xAFF80000, 0xD06C0000, 0x8FB20000, 0x4BEF0000, 0x85F08000, 0x180AC000, 0xF165A000, 0x40511000, 0x217B0800, 0xD2AC5400, 0xC5944600, 0x2ADEB900, 0x9CDD2D80, 0x6FD93740, 0x2C5C4BA0, 0xD21C5E70, 0x43FFCE28, 0xC6682D1C, 0x0CB4CB82, 0x006A9E63 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x18000000, 0xD4000000, 0x66000000, 0xFD000000, 0x4D800000, 0x8A400000, 0xA1A00000, 0xE9700000, 0xCD380000, 0xE78C0000, 0x9F560000, 0xA90F0000, 0x31918000, 0x096A4000, 0x1E076000, 0xD9071000, 0x83811800, 0xAB43A400, 0x4625CE00, 0x2C301700, 0xBA1B1A80, 0x343E9840, 0x340834A0, 0x8C13DF50, 0x2B2D5608, 0x63A5F314, 0x9A77B4AE, 0x01BA9F71 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x28000000, 0xA4000000, 0x2A000000, 0x9F000000, 0x32800000, 0xC4400000, 0xF7A00000, 0xED700000, 0xF0680000, 0xFFDC0000, 0x6E520000, 0x385B0000, 0x67958000, 0x093BC000, 0x01056000, 0x6F86F000, 0x6DC1E800, 0xBB64CC00, 0x6997A600, 0x7C384700, 0x0C841280, 0x094432C0, 0x762354A0, 0x05B145F0, 0x5E8BCE08, 0xEC8B4B14, 0xAF8CD4A2, 0x9B0D85CD } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x48000000, 0x0C000000, 0xBE000000, 0x69000000, 0x40800000, 0x35400000, 0x97E00000, 0x40300000, 0xB2180000, 0xA3EC0000, 0xB1520000, 0xBA690000, 0xAC908000, 0x84CFC000, 0xFD412000, 0x5BE01000, 0x1E33F800, 0xAB1AAC00, 0xAB681E00, 0x88143D00, 0x93884A80, 0x85A5F340, 0x7651F4A0, 0x6BEE1E70, 0x7D536618, 0xE46D512C, 0xB59374AA, 0x8C48DE5F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xE8000000, 0x34000000, 0x12000000, 0xFD000000, 0xE0800000, 0x50400000, 0x2AA00000, 0xB3F00000, 0x05580000, 0x4A6C0000, 0xEBD60000, 0x5BE90000, 0xE5168000, 0x720CC000, 0x77C1E000, 0x7362B000, 0x6B933800, 0xE948CC00, 0xEAE65600, 0x61579F00, 0x3AA85E80, 0xB1355F40, 0x92B968A0, 0x8BBCB050, 0xE13BEE38, 0xF07F931C, 0x2C59E8A2, 0xC8E97041 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xA8000000, 0x2C000000, 0x96000000, 0x23000000, 0x15800000, 0xF1400000, 0x54600000, 0x8A900000, 0xE0380000, 0xF06C0000, 0x9A720000, 0x67690000, 0x5DF68000, 0xEF2EC000, 0x19172000, 0x0A7E5000, 0x658BE800, 0x43A75400, 0xE237D600, 0xAB8FD100, 0xC4A62B80, 0x1DB7E740, 0xF7C85DA0, 0x2244A670, 0xC9E0BE18, 0x07D3451C, 0x3A5A5D92, 0xDDFDA667 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xF8000000, 0x14000000, 0x3A000000, 0x89000000, 0x9B800000, 0xBBC00000, 0x05E00000, 0x55700000, 0xB9080000, 0x7E3C0000, 0x5C160000, 0x673F0000, 0x2F968000, 0x60FA4000, 0x0C766000, 0x6A8CF000, 0x89FB5800, 0x87F1B400, 0x79481200, 0x901F9900, 0x0481C880, 0x674695C0, 0xC6A13AA0, 0xF1D3BCD0, 0x25DBCA08, 0x02676D2C, 0x78B73A96, 0xBBECBCF9 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x88000000, 0x04000000, 0x5A000000, 0x45000000, 0x1B800000, 0xA2400000, 0x68600000, 0x23900000, 0xEDF80000, 0xE9AC0000, 0xF1760000, 0x9DA90000, 0x63708000, 0xBCA9C000, 0xD2F36000, 0xD3EF7000, 0xA513B800, 0x083F5400, 0x658C5E00, 0xD985D900, 0xDB451380, 0xC5E5E940, 0x6AD2ADA0, 0x091A8050, 0x32F96638, 0x972A4D2C, 0xD8B2ADBA, 0x2F8A807D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xF8000000, 0x1C000000, 0x2E000000, 0x0F000000, 0xC3800000, 0x24400000, 0xE6A00000, 0x72100000, 0x2BD80000, 0x2C0C0000, 0xF4320000, 0x580F0000, 0xDE338000, 0x950F4000, 0x14B22000, 0x99C91000, 0x27D3C800, 0x083E0400, 0x543C8E00, 0x9A3A0F00, 0x653F0980, 0x8EBEF440, 0x4EFA27A0, 0x9A5EAB70, 0xC94EC628, 0x2E144B04, 0xE5DA27B6, 0xD30EAB73 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x28000000, 0x24000000, 0x9E000000, 0x4D000000, 0x34800000, 0x63C00000, 0xF1A00000, 0x9C700000, 0x95680000, 0xB45C0000, 0x98560000, 0xA4590000, 0x00508000, 0xC85CC000, 0x4A576000, 0x33585000, 0x17D0D800, 0xFA1F6C00, 0xC8B00A00, 0xA34A5B00, 0xA2687A80, 0x73D99EC0, 0x121790A0, 0xDABB55D0, 0x02465238, 0x8AE0F72C, 0x24179092, 0xF3BB55F5 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x88000000, 0xBC000000, 0x26000000, 0x0D000000, 0x35800000, 0x76C00000, 0x5EE00000, 0xB7500000, 0x75880000, 0x139C0000, 0x19320000, 0xDD9F0000, 0x78348000, 0x561BC000, 0x07F4A000, 0x2F7B5000, 0x51601800, 0x1A93A400, 0xBBEE6A00, 0x6B894900, 0xEA999180, 0x96B328C0, 0xB05FDBA0, 0x9656F1F0, 0x1E08F228, 0x7C5E2D3C, 0xD857DBAA, 0xBF0AF1E3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x18000000, 0x1C000000, 0xF2000000, 0xD1000000, 0xC6800000, 0xDB400000, 0x24A00000, 0x34F00000, 0xDBF80000, 0x24CC0000, 0x2FD60000, 0xB6CD0000, 0x0ED68000, 0x884F4000, 0x79932000, 0x46E8F000, 0x8062D800, 0xA997DC00, 0xAEE8BE00, 0x64601700, 0xF793E680, 0x95E8CA40, 0x6FE6F8A0, 0x18536D50, 0xBB0AE618, 0xB9358B3C, 0x2C1EF8BE, 0x609F6D6B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xE8000000, 0xB4000000, 0x0A000000, 0x6D000000, 0xA7800000, 0x73400000, 0x11E00000, 0x3A300000, 0x7E680000, 0xCD9C0000, 0xFED60000, 0x0FDB0000, 0xB6B28000, 0x01AAC000, 0xE3BFE000, 0xCAC47000, 0xB5A77800, 0x29557400, 0xD49E3600, 0x33569D00, 0xC19B9280, 0x18D780C0, 0x14DEC4A0, 0x3234ADD0, 0x5A6F4E28, 0xFF98E92C, 0x3FD724B2, 0xFE5BDDD1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x58000000, 0xE4000000, 0x92000000, 0x59000000, 0x64800000, 0x2B400000, 0x64600000, 0xF7100000, 0xA2A80000, 0xEB7C0000, 0x1E720000, 0x1B3F0000, 0x8F968000, 0x4FEF4000, 0x3C18E000, 0x40E23000, 0x3C539800, 0x96CC4C00, 0x346BAE00, 0x00DF5100, 0x86470F80, 0x5AE12FC0, 0x6950C1A0, 0xFC4C0EF0, 0x402A3628, 0x933C1D2C, 0x8392219E, 0x41ED3EE5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x58000000, 0x84000000, 0x4A000000, 0x1D000000, 0x83800000, 0xFEC00000, 0x52200000, 0x5AD00000, 0xF3F80000, 0x6D6C0000, 0x0BF60000, 0x75AF0000, 0x32D48000, 0x6FFD4000, 0x036FE000, 0xECF5F000, 0xB32F7800, 0xCB945400, 0x891CFA00, 0x169A6F00, 0xC659AB80, 0xD379C740, 0xFF2831A0, 0xAD941850, 0xA21D8208, 0xF61D3B3C, 0xB41FD1BE, 0x651DE84D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xF8000000, 0x64000000, 0x4A000000, 0x2F000000, 0x82800000, 0x97C00000, 0xD4E00000, 0xA2B00000, 0x0D080000, 0xA1FC0000, 0x1F520000, 0x743D0000, 0x08B18000, 0x320F4000, 0xBB7BE000, 0x3C95F000, 0x12D9E800, 0xE107CC00, 0xF785BA00, 0xA2448100, 0x75A05680, 0x53952BC0, 0x305D8CA0, 0xC6C61AF0, 0x0B665238, 0x9CF24D04, 0x56AE6CA6, 0x976FEAED } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xF8000000, 0xF4000000, 0x5A000000, 0x73000000, 0x89800000, 0x3BC00000, 0xF8A00000, 0x76900000, 0x87480000, 0xDC9C0000, 0xCF360000, 0x475B0000, 0x67958000, 0xE9CD4000, 0x04DD6000, 0x9753F000, 0x4CED8800, 0x038DF400, 0x63BE0200, 0x9B62E300, 0x2A36CD80, 0x73D958C0, 0xCCD62FA0, 0x382E0BD0, 0x34AD8A28, 0x0BE81714, 0xB00B4FB6, 0x1B7DFBF9 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xF8000000, 0x0C000000, 0x16000000, 0xAD000000, 0xA7800000, 0x90C00000, 0x95200000, 0x8AB00000, 0xF6180000, 0x62EC0000, 0xB4920000, 0x7E2B0000, 0xF7B08000, 0xF9984000, 0x962EA000, 0xF3B35000, 0xBB991800, 0x1128B400, 0x17354A00, 0x2DD9E700, 0xA54D9080, 0x3566FB40, 0x63D4FAA0, 0x2BCF0C70, 0x80265208, 0x4136533C, 0xE0DA5A96, 0x92CC5C4F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xE8000000, 0xB4000000, 0x1A000000, 0x43000000, 0xC7800000, 0x2C400000, 0xA1A00000, 0xF1900000, 0x45880000, 0x6EDC0000, 0xD6360000, 0xF91D0000, 0xC5D78000, 0x6829C000, 0x3949E000, 0xEEBFF000, 0xE1448800, 0x0F200400, 0xC1534E00, 0xC3E81700, 0x54AA8D80, 0x2E8DAAC0, 0xBD59A3A0, 0x90728DD0, 0x63BFC618, 0xAFC41334, 0xAFE7C382, 0xAF34BDC9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x58000000, 0xCC000000, 0xF2000000, 0xE3000000, 0xEA800000, 0xE2400000, 0x74200000, 0xA4B00000, 0x82280000, 0xD35C0000, 0x2C960000, 0xCC9D0000, 0x9E768000, 0x574D4000, 0xB94FA000, 0x004A7000, 0x7DCB4800, 0xFB0AAC00, 0x24699600, 0x317B8B00, 0xED266080, 0xC9328EC0, 0x0CE8D6A0, 0x283F35D0, 0x5F82DE18, 0xCDC1273C, 0x41E7F6AE, 0x795505DF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x68000000, 0x9C000000, 0x6E000000, 0xA7000000, 0x0B800000, 0x24C00000, 0xC8600000, 0x82300000, 0x91280000, 0x415C0000, 0x42520000, 0xDF190000, 0x36778000, 0xA809C000, 0x90CCA000, 0xF6A91000, 0x33980800, 0x39300400, 0x34ACCA00, 0x229A7D00, 0x11B05E80, 0x11E956C0, 0xF33DB4A0, 0x0566FBF0, 0xE4B4C218, 0x636A7914, 0x637C94A2, 0x86432BC3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xD8000000, 0xD4000000, 0x16000000, 0x9B000000, 0x4E800000, 0x9D400000, 0x20600000, 0xBC100000, 0x8FE80000, 0x313C0000, 0x1C760000, 0x73F90000, 0xDED08000, 0xDD4B4000, 0xB78F6000, 0x792F9000, 0x159FA800, 0xF1C28C00, 0x80266E00, 0xF1F5D100, 0xC439C780, 0xCDF57DC0, 0xFE3E49A0, 0x04F17CD0, 0x15B9C638, 0x40375D2C, 0x241FA9AE, 0xCC00ACC9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x78000000, 0xBC000000, 0x66000000, 0x01000000, 0x81800000, 0x96C00000, 0x6EE00000, 0xB1100000, 0xCDA80000, 0xC25C0000, 0x76E20000, 0x9D170000, 0x83AA8000, 0x775C4000, 0x55642000, 0xD0D1D000, 0x0BC9B800, 0xD0084400, 0xE16C9A00, 0x5BBA1100, 0x6F754780, 0xF3F8A1C0, 0x1BD065A0, 0x054AF4F0, 0x5249B828, 0x4AC8442C, 0xB18C9A16, 0x27AA1133 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x08000000, 0xBC000000, 0xB6000000, 0x2B000000, 0xB4800000, 0x8EC00000, 0x03A00000, 0x5AD00000, 0x85680000, 0x941C0000, 0x97A20000, 0xA0D30000, 0xB06C8000, 0x879DC000, 0x13E7A000, 0xBAB35000, 0xEB986800, 0xFDE13C00, 0xB5B27200, 0x6D193B00, 0x5A23A380, 0x239441C0, 0x9089B9A0, 0xCDAC46F0, 0xD4B86808, 0x55F13C3C, 0x257A722A, 0xB8D53B23 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x58000000, 0xCC000000, 0x6E000000, 0x17000000, 0xCF800000, 0x45400000, 0xB1E00000, 0xD9300000, 0x2FB80000, 0xFF6C0000, 0x15E60000, 0x93310000, 0x32BF8000, 0x4DEA4000, 0x7222A000, 0x1D141000, 0xA9AC4800, 0x97448400, 0x40E2F600, 0xF5B1B500, 0x977C0E80, 0x2ACFB040, 0x69B2B0A0, 0x817A8150, 0x01CC4838, 0x00348434, 0x473AF60E, 0xDDADB517 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xE8000000, 0xC4000000, 0xCA000000, 0x4B000000, 0x95800000, 0xB1400000, 0x64A00000, 0xFC500000, 0x89280000, 0xE9DC0000, 0x20A60000, 0x76510000, 0xA22E8000, 0xCC5EC000, 0x79E76000, 0xD6F17000, 0x947A8800, 0x0E703400, 0x05BA4600, 0x4711DF00, 0x868F4F80, 0x500D1FC0, 0x40CF81A0, 0xD72CF4D0, 0x70DA8838, 0xB220343C, 0xEC924622, 0x1ECDDF1D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0xB8000000, 0x04000000, 0x4A000000, 0x33000000, 0xBD800000, 0xC0C00000, 0xA2A00000, 0xE8500000, 0xD0880000, 0x5E7C0000, 0x8CA60000, 0xE1550000, 0x060E8000, 0x17384000, 0x1CC3E000, 0x9CA77000, 0xC9554800, 0x6A083400, 0xD13A0A00, 0xD9C76300, 0x5C249F80, 0xCD1332C0, 0x86EBDDA0, 0xE68C65D0, 0x837D4818, 0x9824341C, 0x27140A16, 0x65EE630D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xB8000000, 0x2C000000, 0xFA000000, 0xB1000000, 0xBB800000, 0xA6400000, 0x76E00000, 0x62900000, 0x51580000, 0x492C0000, 0xF0E60000, 0x41970000, 0x5FDC8000, 0x0AE84000, 0xFF42A000, 0x8961B000, 0x3AD6D800, 0xC8BC1400, 0x4F384E00, 0xDB7E3500, 0x2899FB80, 0x178B4A40, 0x13976DA0, 0x0AD96B50, 0x7F6ED808, 0x0E00141C, 0xB7064E06, 0xD8853507 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x14000000, 0x8E000000, 0xFF000000, 0x0A800000, 0x72C00000, 0x3A600000, 0x82300000, 0xA9380000, 0xDD6C0000, 0x04660000, 0x25330000, 0x9FB98000, 0x25ACC000, 0x4706E000, 0x4687D000, 0xC0C20800, 0x4F676C00, 0xF1B32200, 0x3A7E9500, 0x114A4A80, 0x31F0F440, 0x3EDB60A0, 0x1B190D50, 0x6FFA0828, 0x390B6C14, 0x5155220A, 0x828D9501 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xB8000000, 0x74000000, 0xDA000000, 0x9D000000, 0xB5800000, 0xF2C00000, 0x44A00000, 0x28700000, 0x24C80000, 0x221C0000, 0x3BA60000, 0x34F70000, 0x198B8000, 0xD97F4000, 0x5AF06000, 0xBE8A7000, 0x81FDB800, 0x75B40400, 0xC4EB5A00, 0x432F4300, 0x3E0C1E80, 0xEABC41C0, 0x1DD2FCA0, 0x873B06D0, 0xAB13B808, 0xD19F0424, 0x0266DA06, 0x56D70329 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x38000000, 0x3C000000, 0xCA000000, 0x03000000, 0xB6800000, 0x35400000, 0x5D200000, 0x48300000, 0xBE980000, 0x298C0000, 0x08260000, 0x87B10000, 0xF65F8000, 0x63694000, 0xE6762000, 0xD93EB000, 0x56FDC800, 0x7C9EEC00, 0x9E893E00, 0x80A57300, 0xEFF2A080, 0xD0FDB940, 0x5D9E56A0, 0x4F0A2650, 0x6563C838, 0x7693EC34, 0x4C68BE16, 0xE2F1332B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x78000000, 0x4C000000, 0x5E000000, 0xB3000000, 0x97800000, 0x82400000, 0x9FE00000, 0x0DB00000, 0x4B780000, 0x1B2C0000, 0xF8E20000, 0x18330000, 0x0C3A8000, 0x64484000, 0x8A93A000, 0xEFEB9000, 0xFFC1E800, 0x7CA36400, 0x48D40E00, 0x100FFD00, 0xA2743A80, 0xBFDF7240, 0x67F9DCA0, 0xFAEFEB70, 0x5743E808, 0x9760640C, 0x16768E36, 0x6DDBBD2F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xD8000000, 0x2C000000, 0xA6000000, 0xA5000000, 0xB8800000, 0xF7400000, 0x20A00000, 0xF5D00000, 0x96480000, 0xA63C0000, 0xDD220000, 0xAA150000, 0xF9AD8000, 0x8F4C4000, 0xC0BDA000, 0x13655000, 0x9C339800, 0xAA3BAC00, 0x0B275E00, 0x67122F00, 0x652CD380, 0x2A0C40C0, 0xCF1A15A0, 0x5D30C3F0, 0xE0BC1838, 0x6362EC04, 0xF4377E2E, 0x8E3B3F3F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xF8000000, 0xEC000000, 0x02000000, 0xB9000000, 0x1A800000, 0xAFC00000, 0xB7E00000, 0xB7700000, 0x22980000, 0x8B0C0000, 0x6C660000, 0xAE310000, 0x58BE8000, 0x829E4000, 0x1B0EA000, 0x44627000, 0x0A315800, 0x4EBC5C00, 0xD59C8A00, 0xBA8E7100, 0x4827BC80, 0x08952340, 0xE1EC6EA0, 0xF7960E50, 0xA469D838, 0x8DD31C3C, 0x41CCAA26, 0x7B024117 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xC8000000, 0x0C000000, 0xA2000000, 0x1B000000, 0x2E800000, 0x82400000, 0x36200000, 0xB2B00000, 0xB7280000, 0x70BC0000, 0x2FA20000, 0x6C750000, 0xC0488000, 0x6EA9C000, 0xCE7C2000, 0x28C47000, 0xBA634800, 0x2D976C00, 0x8818C600, 0xAF529300, 0x457F8C80, 0x7E4390C0, 0x9C2602A0, 0xC5B36FF0, 0x4BA9C838, 0x21FBAC2C, 0x3B04662A, 0xFE83231F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xE8000000, 0x3C000000, 0x62000000, 0xA7000000, 0x9D800000, 0xE7C00000, 0x43E00000, 0xD9100000, 0x86980000, 0xA76C0000, 0x17620000, 0x4E550000, 0x443E8000, 0x95DEC000, 0xA3CCA000, 0x54D3F000, 0x2E7EA800, 0x09FC1400, 0x5D3AF200, 0xBD599100, 0xF68F9F80, 0xE173F840, 0xD949C5A0, 0x8E937D70, 0x5A5A2838, 0xCB0BD41C, 0xD6B2D222, 0xC2ADA123 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xE8000000, 0x84000000, 0x6A000000, 0x0F000000, 0x5B800000, 0xACC00000, 0x57E00000, 0x51F00000, 0x6A080000, 0x971C0000, 0x95620000, 0x5FB70000, 0xE3A88000, 0xB74AC000, 0x83396000, 0xD8F47000, 0x108DA800, 0x25596400, 0x0AC75A00, 0x46E0E900, 0xA777B880, 0x264EEBC0, 0xB5BF4AA0, 0xB4B066F0, 0x022F2828, 0xEC88A43C, 0xD35CBA32, 0x23C5592D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0xB8000000, 0xC4000000, 0x06000000, 0x0B000000, 0x00800000, 0x59400000, 0xAFE00000, 0x19F00000, 0xE1580000, 0x704C0000, 0x32620000, 0x93330000, 0xA37B8000, 0xF11F4000, 0x1229E000, 0xD9511000, 0x544DE800, 0x84621C00, 0x5031AE00, 0x0FF96500, 0xD2597880, 0x74C86940, 0xCD273EA0, 0xE7D01070, 0x020C6808, 0x8D025C04, 0xCB81CE06, 0xF9C43505 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x08000000, 0x64000000, 0xB6000000, 0x71000000, 0xA1800000, 0x5CC00000, 0x17A00000, 0x39D00000, 0x24E80000, 0x6D9C0000, 0x70220000, 0xDC110000, 0x16C88000, 0x4E8BC000, 0x3A696000, 0x4DDB9000, 0xA8C4B800, 0x99A04400, 0xC4D40A00, 0xA76B0B00, 0xFE582B80, 0xD302FDC0, 0xAE8299A0, 0x0844B2F0, 0xACE43818, 0x0BB7840C, 0xCF1F6A3A, 0x9A619B25 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x88000000, 0xEC000000, 0xEE000000, 0xC7000000, 0x39800000, 0x37C00000, 0x6DA00000, 0x89100000, 0x06080000, 0x97BC0000, 0x40220000, 0x94D50000, 0xFEAA8000, 0xB629C000, 0xEB692000, 0x62891000, 0x44F9C800, 0x3EC33400, 0x0327D200, 0x5F540300, 0x086CCD80, 0xF90BDCC0, 0x0A38D7A0, 0x15E5EBF0, 0xE0734838, 0x013AF43C, 0x5266F23A, 0xC8B11337 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x28000000, 0x8C000000, 0x3E000000, 0x3B000000, 0xDA800000, 0x66C00000, 0x04A00000, 0x96500000, 0x76A80000, 0xD55C0000, 0x2E260000, 0xC8930000, 0xF60B8000, 0xA10FC000, 0x758B2000, 0x704A9000, 0x5A6DA800, 0x30FBCC00, 0xCBF54200, 0x577E4300, 0x88B61F80, 0x2D9C5BC0, 0x0180F5A0, 0x8C46D4D0, 0x3A662828, 0x66F40C04, 0x7AFE6202, 0x2AF4D337 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x48000000, 0x94000000, 0x02000000, 0xF1000000, 0x1D800000, 0x27400000, 0xDF200000, 0x4C700000, 0x11980000, 0xDDCC0000, 0xA2A20000, 0x5B370000, 0x76BF8000, 0x9DB8C000, 0x6D3CE000, 0xE1FFB000, 0x3A9A1800, 0x0D48A400, 0xFE62B600, 0xC850B300, 0xD56A6280, 0x6C91FB40, 0xAA08CCA0, 0xE142EC70, 0xA4259828, 0x14F06404, 0xF95E561A, 0x9CAF0311 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x18000000, 0x54000000, 0x32000000, 0x5F000000, 0x07800000, 0xBA400000, 0x0AA00000, 0x2BD00000, 0xA7880000, 0xC17C0000, 0x97620000, 0x8B330000, 0x3EFB8000, 0xC9224000, 0xDB946000, 0xD62E3000, 0x1729E800, 0x99A80400, 0x21684E00, 0x550D9700, 0xB7BAB380, 0xB207BEC0, 0x9F0095A0, 0xA7806DF0, 0x6A460808, 0x12A47404, 0x7FD5C62E, 0x958BA321 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xF8000000, 0x84000000, 0xDE000000, 0xC3000000, 0x11800000, 0xE4400000, 0xFBA00000, 0xB8700000, 0xCE980000, 0xC4CC0000, 0xE2620000, 0xC5910000, 0xF44F8000, 0xAEA34000, 0x26F5E000, 0x695DD000, 0xAA2C6800, 0xD1335400, 0xDFBA8E00, 0xED7D8F00, 0xFD194680, 0x798DDB40, 0xF54020A0, 0x5B204070, 0xCCB60818, 0x49FDC434, 0x97DB0606, 0xDDEF0B25 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x98000000, 0x0C000000, 0x96000000, 0x77000000, 0x37800000, 0x66400000, 0x76E00000, 0x5B100000, 0x9AE80000, 0x489C0000, 0x1B220000, 0x95B30000, 0xF41D8000, 0x34E04000, 0xD612A000, 0xFC69D000, 0xE65B8800, 0xA804C400, 0x4401EE00, 0xA201B500, 0xFD069780, 0x4E8313C0, 0x2AC171A0, 0xB12622F0, 0x3CB4A808, 0x809D5434, 0xEF20C60E, 0xBFB0A107 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x98000000, 0xEC000000, 0x06000000, 0x9B000000, 0x76800000, 0xA4400000, 0xF5E00000, 0xCFB00000, 0xC2D80000, 0xE20C0000, 0x8D220000, 0xE3170000, 0xC50E8000, 0x55A74000, 0x8855A000, 0x5C6E5000, 0x3B576800, 0xBEEDAC00, 0xA514F600, 0xBE0B3D00, 0xF324CA80, 0x44153F40, 0xDD89D4A0, 0x1EE4EE70, 0xE1344828, 0xAA98BC0C, 0xE1EC3E2E, 0x4193C107 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x18000000, 0x4C000000, 0x5A000000, 0x69000000, 0xBC800000, 0xDC400000, 0x14E00000, 0x8CF00000, 0x8C180000, 0xD48C0000, 0x1A260000, 0xCB570000, 0x338D8000, 0x99A44000, 0x3890A000, 0x3EADB000, 0x79751800, 0xBCDC6C00, 0xA4286600, 0xDE321500, 0x89B84880, 0x4E1E0340, 0xB188B6A0, 0x5CA43A50, 0x6E103808, 0x83E99C14, 0x8513DE2E, 0xFA68C917 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x68000000, 0x34000000, 0xC6000000, 0x59000000, 0x64800000, 0x45C00000, 0x14200000, 0x9B300000, 0xBB880000, 0xCC1C0000, 0xFB660000, 0x97D50000, 0x1E1C8000, 0xB464C000, 0x5250E000, 0x13589000, 0x7F837800, 0x7640AC00, 0xC867AA00, 0x70573F00, 0x745DF080, 0x6E0781C0, 0xCD05A2A0, 0x3284D2D0, 0x04C71818, 0x2CA0FC0C, 0x2CF23222, 0x30AA0311 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x68000000, 0x44000000, 0xC2000000, 0x81000000, 0x44800000, 0x5E400000, 0xBDE00000, 0x0B700000, 0x74680000, 0xCA7C0000, 0x1D260000, 0xD5D50000, 0xB87E8000, 0xB426C000, 0x35536000, 0x143B3000, 0xE0C79800, 0x3EA76C00, 0xFC15F600, 0x16588D00, 0x6C76FC80, 0x03E9FCC0, 0xD9BA12A0, 0xCE00DDD0, 0x97027818, 0xBF869C1C, 0x87C70E22, 0x4921D11D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x48000000, 0x14000000, 0x5A000000, 0x87000000, 0x39800000, 0x2D400000, 0xD2A00000, 0xDB100000, 0x89180000, 0x632C0000, 0xDB660000, 0x3A750000, 0xE46B8000, 0x16C2C000, 0x64E0E000, 0x9E357000, 0x324A6800, 0xCE13B400, 0x639A0600, 0xCDEE2F00, 0x3386F580, 0x42441C40, 0x8F251BA0, 0x74574750, 0x80BF0818, 0xCFBD0434, 0xA23D0E2A, 0x357F2B21 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x98000000, 0x8C000000, 0x8A000000, 0x71000000, 0x98800000, 0x68C00000, 0x76A00000, 0xB9900000, 0x07B80000, 0x6A0C0000, 0x05E60000, 0xB2730000, 0x1AC98000, 0xBF404000, 0xA1E2A000, 0x7C713000, 0xD5CF5800, 0x40C78C00, 0x32A1E200, 0x0795A300, 0x60BD7180, 0x9189F540, 0x08A24BA0, 0xBE979A50, 0xCC3A7828, 0xEF49FC14, 0x1D039A2E, 0x62805F27 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xB8000000, 0xF4000000, 0x1A000000, 0x8B000000, 0xFA800000, 0xCAC00000, 0x08600000, 0x5DD00000, 0xCAE80000, 0xABDC0000, 0xF7260000, 0xF7F70000, 0xE29B8000, 0x48074000, 0xDC006000, 0xF6027000, 0xB5020800, 0xD3864C00, 0x4F462200, 0x2226C500, 0x1476F580, 0x65DB6DC0, 0xF6215FA0, 0x9E70A4D0, 0xF6DFE808, 0x28A47C24, 0xF6B7CA06, 0x81B9B909 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x78000000, 0xA4000000, 0x36000000, 0xD9000000, 0x92800000, 0x03400000, 0x12200000, 0xA4700000, 0xDA780000, 0x3CAC0000, 0x96E60000, 0xED910000, 0x946D8000, 0x85014000, 0x4084E000, 0x8C479000, 0x89A1F800, 0x4DB19C00, 0x6F19AE00, 0xBCFD3B00, 0x31ED7A80, 0x99C26440, 0x3D60ACA0, 0xEC538350, 0x9D0E9838, 0x47564C24, 0x70893606, 0x1796771D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x78000000, 0x94000000, 0x8E000000, 0x7B000000, 0x8E800000, 0x0C400000, 0x4E600000, 0x50300000, 0xBB480000, 0x799C0000, 0x97A20000, 0xEC950000, 0x615D8000, 0xE0814000, 0x67416000, 0xD8E3D000, 0x18712800, 0x032C6C00, 0xC6ACB600, 0x2C6C6100, 0xE24A2A80, 0x361CAFC0, 0x506234A0, 0xF331E2F0, 0x11CFC838, 0x53DBFC04, 0x4EC17E06, 0x28229D11 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x48000000, 0x64000000, 0x16000000, 0x01000000, 0x65800000, 0x58400000, 0xA8600000, 0x7CF00000, 0x57780000, 0x676C0000, 0xB1220000, 0x11150000, 0xA3CE8000, 0x6073C000, 0x86BF6000, 0x854C9000, 0xC2B73800, 0x161C6400, 0xCA184E00, 0x501AF100, 0xF31ECC80, 0x799D6040, 0x695D3AA0, 0x8EFD3570, 0x152A5838, 0xF245F41C, 0x8361F60A, 0xF2755535 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x38000000, 0xC4000000, 0xCA000000, 0xE7000000, 0xF9800000, 0x0FC00000, 0xF7200000, 0x89F00000, 0xF4A80000, 0x8CFC0000, 0x13E20000, 0xC1530000, 0x139D8000, 0xB7F54000, 0x31A9E000, 0xCE797000, 0xFBA3E800, 0x2CB23400, 0xB7CC1200, 0xF6ECD700, 0x56192E80, 0xD63356C0, 0x5B8954A0, 0x710BF5F0, 0x05480808, 0x56A84434, 0xF7FA7A26, 0x5467A335 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x88000000, 0x3C000000, 0xE6000000, 0x8B000000, 0xBE800000, 0xEBC00000, 0x4DE00000, 0xFC500000, 0x5CD80000, 0xECEC0000, 0x83260000, 0x18350000, 0xE3CF8000, 0x0510C000, 0xD4FFA000, 0x0A5DD000, 0x6B2DE800, 0x40C4EC00, 0x4366CA00, 0x6F91C100, 0xB53CF580, 0x42BE6040, 0x8EFE57A0, 0x275E8D50, 0xBEAC4818, 0x05803C14, 0x6D42A21A, 0xE220ED0B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0xDC000000, 0x2E000000, 0x57000000, 0x45800000, 0xC6C00000, 0xD0A00000, 0x55F00000, 0x25080000, 0xA6DC0000, 0xD7660000, 0x63D10000, 0x61B98000, 0xBCB5C000, 0x8E6FA000, 0x9B089000, 0xB9DF4800, 0x7EE6D400, 0xB3117A00, 0x521B0300, 0x5EC5B280, 0x14A77BC0, 0xFFF400A0, 0xB80E6CD0, 0x2E5EE838, 0xF1234404, 0x4931B202, 0x30A91723 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x28000000, 0xB4000000, 0xC2000000, 0xFD000000, 0x78800000, 0x53400000, 0x50A00000, 0x22B00000, 0xF5D80000, 0x804C0000, 0x21E20000, 0x1F150000, 0xE7E98000, 0xC2D7C000, 0x1B0AE000, 0x5544B000, 0xB7A57800, 0x0B366C00, 0xD01E7E00, 0x20AB4F00, 0xA073D880, 0xDCBE6F40, 0x141B5EA0, 0x3AAD8C70, 0xF1779838, 0xAA3EDC24, 0xE4590612, 0x99882339 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x08000000, 0x04000000, 0xB2000000, 0x1B000000, 0xCB800000, 0x7F400000, 0xB3200000, 0x26100000, 0x49980000, 0x362C0000, 0x32620000, 0x58330000, 0xBD0D8000, 0xC874C000, 0x0FAE6000, 0x3624B000, 0x9093C800, 0xFC5BC400, 0x3EC90600, 0xA991B300, 0xE4DF5180, 0x2E093040, 0xC7F21FA0, 0x62E88770, 0x8E05A808, 0x75037434, 0xCE80CE2A, 0x09C57705 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xD8000000, 0x74000000, 0x0A000000, 0x9D000000, 0xF7800000, 0xCAC00000, 0xA1A00000, 0x47700000, 0x19D80000, 0x178C0000, 0x65620000, 0x79D10000, 0x782F8000, 0x5D124000, 0x568B6000, 0xE4E0F000, 0x68123800, 0xDD0A9400, 0x6826CA00, 0x3AB3CB00, 0x22FF7E80, 0xA5B99940, 0xBBDE0CA0, 0xF68F8670, 0xD4E15818, 0x40166434, 0x610EF20E, 0xCE245F19 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xC8000000, 0xC4000000, 0xFE000000, 0x6F000000, 0x5F800000, 0x00C00000, 0x69A00000, 0x56700000, 0x4EC80000, 0xDB9C0000, 0x1D660000, 0x49D10000, 0xD3BA8000, 0x04D3C000, 0x613A6000, 0xA696D000, 0x32DF0800, 0x9F00C400, 0xB7875A00, 0x94C1FB00, 0x6FA52680, 0x357389C0, 0x2B49F4A0, 0x4A5C76D0, 0x44456838, 0x40E6141C, 0xF410522A, 0xE09D3F3D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x28000000, 0xCC000000, 0xCA000000, 0x9B000000, 0x76800000, 0x73400000, 0x67E00000, 0xC1300000, 0x78580000, 0x850C0000, 0xA0A60000, 0xB8D70000, 0xAC6E8000, 0x66D6C000, 0x596D2000, 0x2D513000, 0x7DAB0800, 0xFC772C00, 0x12BFCE00, 0x9BBEB500, 0xD23A0E80, 0x71FA6F40, 0x445E48A0, 0x270E3650, 0x57A62808, 0x74561C0C, 0x6C2CC622, 0xBBB5992F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xE8000000, 0x8C000000, 0xD2000000, 0x5B000000, 0x8E800000, 0xB0400000, 0x10600000, 0x18B00000, 0xBBD80000, 0x408C0000, 0xF0220000, 0xC0D10000, 0xDF6F8000, 0xD153C000, 0x8FAD2000, 0xE071F000, 0x26FAC800, 0xCBDAEC00, 0x788F1600, 0x7421D100, 0x8ED77E80, 0xBE6F3F40, 0x88D720A0, 0x636AC270, 0x1B57E818, 0xA0AB1C34, 0xD8F5DE02, 0x93BB3D27 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x68000000, 0x54000000, 0xA6000000, 0xAD000000, 0x6E800000, 0xCEC00000, 0xDDE00000, 0x78B00000, 0xD2380000, 0x99AC0000, 0x1EC20000, 0xE5E30000, 0xD4B48000, 0x783AC000, 0xAEADE000, 0x2F459000, 0x4EA35800, 0x04129C00, 0x7D2FC200, 0x17057900, 0xC184BA80, 0x63400C40, 0xB4A5C0A0, 0xCB127970, 0x40ADE008, 0x2645903C, 0x4E235832, 0x03D29C19 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x18000000, 0x64000000, 0xBE000000, 0x73000000, 0x66800000, 0x8E400000, 0xB4E00000, 0x3A500000, 0xC8C80000, 0x183C0000, 0x06460000, 0xE8E10000, 0xD0518000, 0x4DCA4000, 0x71BFE000, 0x3480D000, 0x1F476800, 0x4B612C00, 0x57950600, 0x9BEA3500, 0xA44EA580, 0x037FFCC0, 0xA3232BA0, 0xD47435D0, 0x493FE038, 0xD9C0D004, 0xB527681E, 0xCB712C0D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xF8000000, 0x0C000000, 0x22000000, 0xAF000000, 0x48800000, 0x6FC00000, 0xA5200000, 0x42D00000, 0xCBF80000, 0xF3CC0000, 0x17C60000, 0xE9250000, 0x80D38000, 0xF4FB4000, 0x434BA000, 0x74077000, 0x6E016800, 0x6D04BC00, 0x77827A00, 0xDF41F700, 0xC6E64F80, 0xC5F02140, 0x262EFDA0, 0x70B21A50, 0x8BCBA018, 0x5BC77034, 0x2B216806, 0xBFD4BC27 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xB8000000, 0x04000000, 0x9E000000, 0x33000000, 0xD2800000, 0x68C00000, 0x6D200000, 0xF6300000, 0x38480000, 0x839C0000, 0xBCC60000, 0x3B210000, 0x19328000, 0x40CC4000, 0xFE59E000, 0x3462D000, 0xE9546800, 0x179D8C00, 0x8AC59200, 0xE427CF00, 0xD9B30880, 0x390A9BC0, 0xE8FB12A0, 0xD51208D0, 0x3579E038, 0xB552D01C, 0xFD9C6836, 0xFFC18C0D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x18000000, 0x9C000000, 0x1E000000, 0x55000000, 0x54800000, 0xA7400000, 0x72E00000, 0x18D00000, 0xAE580000, 0x2F2C0000, 0x0D460000, 0xEDE70000, 0x23558000, 0x9A984000, 0xFD082000, 0x5DB21000, 0xC44D5800, 0x3A518C00, 0x281DDE00, 0x234B8D00, 0x6DD1C180, 0xAAD82C40, 0x306967A0, 0xF3A03D50, 0xF3302008, 0x440E1014, 0xFF33582E, 0x020A8C23 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xA8000000, 0xF4000000, 0xAE000000, 0xD9000000, 0x7D800000, 0x9AC00000, 0x88600000, 0xFA900000, 0x07280000, 0x431C0000, 0xB4C20000, 0x91630000, 0x27158000, 0x8DEDC000, 0x637EE000, 0xBA50D000, 0x3848B800, 0xBD0CA400, 0x44A8FA00, 0x68DD7500, 0x1526C780, 0x4F3295C0, 0xD95865A0, 0xBDE394F0, 0xE456E008, 0x394CD034, 0x2C8AB802, 0x3C6FA439 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xB8000000, 0xDC000000, 0xAA000000, 0x79000000, 0xB5800000, 0xD8C00000, 0x27600000, 0x1BF00000, 0x69680000, 0xA73C0000, 0xCBC60000, 0x8BE30000, 0xE6B48000, 0x9EC84000, 0xFFAF2000, 0xCF5DB000, 0x96B19800, 0x46C8E400, 0xB3AE2A00, 0x6D5F5D00, 0x8BB09480, 0x854D6CC0, 0xB86806A0, 0x86BB65D0, 0xFD012028, 0x1382B03C, 0x23C31826, 0x3FE3A41B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xE8000000, 0x4C000000, 0xB2000000, 0x55000000, 0x44800000, 0x75400000, 0xEA200000, 0xACD00000, 0x7C380000, 0x558C0000, 0xD6420000, 0x15A50000, 0xF2158000, 0x6ED9C000, 0x78B92000, 0x80CDF000, 0x8C663800, 0x81730C00, 0x2A2B4E00, 0xC5535B00, 0x49FC8780, 0x84ECDF40, 0x4FB0D1A0, 0x70CD7870, 0x14632038, 0x9574F004, 0xEC29B822, 0x8653CC27 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x98000000, 0xFC000000, 0x7A000000, 0x4D000000, 0x21800000, 0x5A400000, 0x01600000, 0x6FB00000, 0x92F80000, 0x406C0000, 0x9B420000, 0x32E10000, 0x2CF18000, 0x7C1A4000, 0x269F2000, 0xE25E3000, 0x51FCB800, 0x12E8E400, 0x1B849E00, 0x37467900, 0x10E20680, 0x7DF3F240, 0xF79D00A0, 0xA9DF5F70, 0x3EBD2018, 0x1E0F3004, 0xCC75381E, 0x15DEA40B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x38000000, 0x3C000000, 0xFE000000, 0x69000000, 0x59800000, 0xD6400000, 0xD0E00000, 0xE3F00000, 0x69E80000, 0x7EBC0000, 0xCB460000, 0x53610000, 0x4EB68000, 0xFF8C4000, 0x7F8C2000, 0x3F881000, 0x5F89B800, 0xEF890400, 0xD78D3E00, 0xEB889500, 0x158EC880, 0x7C8848C0, 0x250E6EA0, 0xF34DC9D0, 0x23AA2038, 0xC059103C, 0xA9B73816, 0xD7094423 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x98000000, 0x54000000, 0xC6000000, 0xA1000000, 0xF9800000, 0x81C00000, 0xA0E00000, 0xB9D00000, 0x0EF80000, 0x870C0000, 0x91460000, 0x24A30000, 0xB2F28000, 0x54CF4000, 0x36A26000, 0x95F69000, 0x2C4A3800, 0x3EE54400, 0x2CD50200, 0x617AA900, 0x4FC97980, 0x04227140, 0x8EB223A0, 0x7BE80C50, 0x3296E028, 0xD15AD00C, 0x177AD82E, 0x16CC9409 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xE8000000, 0xCC000000, 0xBE000000, 0xFB000000, 0x1B800000, 0x81C00000, 0xF4600000, 0xB4100000, 0xB9F80000, 0x8F4C0000, 0xF3460000, 0xBB210000, 0xA9358000, 0x7FC9C000, 0xA1052000, 0xB2819000, 0x6F412800, 0xAD218400, 0xFE339200, 0x0A4DCD00, 0x33C3F380, 0x9165B740, 0xE49269A0, 0x1BB96E50, 0xDEEEA038, 0xC1355024, 0xF3CF8822, 0x7F04D407 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xB8000000, 0xFC000000, 0xF2000000, 0xED000000, 0x57800000, 0x4DC00000, 0x57A00000, 0x60300000, 0x4A780000, 0xC92C0000, 0xA5460000, 0x30E10000, 0x45D68000, 0xC4284000, 0x02C62000, 0xA5227000, 0x5E73F800, 0xEE185400, 0x59B91200, 0xC9893300, 0x5BF32C80, 0xDEDABA40, 0x3199E6A0, 0x1078AD50, 0xF02EA038, 0x94C7303C, 0x96255836, 0x1EF36413 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x28000000, 0xB4000000, 0x92000000, 0x61000000, 0x02800000, 0x26400000, 0x59600000, 0x7F500000, 0x68C80000, 0xFBBC0000, 0xC6C60000, 0xC6250000, 0x08B58000, 0x6FDBC000, 0xA510E000, 0x07AB3000, 0xBFEC9800, 0x298F9C00, 0xA3596600, 0x6455D900, 0x1F4B6180, 0xFD7ED4C0, 0xA0E07FA0, 0x7E96A1D0, 0x1F6D6018, 0x56CCF004, 0x84BA7832, 0x4B41AC39 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x68000000, 0x1C000000, 0x86000000, 0xAD000000, 0xD4800000, 0xD2C00000, 0xBB200000, 0xAA900000, 0xA2480000, 0xC23C0000, 0x44460000, 0x76E30000, 0xD2308000, 0x159AC000, 0x1817A000, 0x8D8ED000, 0xD59C5800, 0x78144C00, 0x9D887200, 0x8D9F2F00, 0x0C107D80, 0x078D8EC0, 0xA69DF7A0, 0x75973DD0, 0x01CF2028, 0xCF78101C, 0x6425F812, 0x09159C0B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xB8000000, 0x0C000000, 0xEE000000, 0x0B000000, 0x26800000, 0x23400000, 0xEE200000, 0x8DD00000, 0x85680000, 0xE8DC0000, 0xC7C60000, 0x98650000, 0x06778000, 0xA97D4000, 0xFAD1A000, 0xA5ED1000, 0x949C2800, 0xFD67EC00, 0x6BF0EE00, 0x4CB98B00, 0x27B52F80, 0x7E1FBDC0, 0x902649A0, 0x7ED5CAD0, 0x4FEE2018, 0x359C5014, 0x9AE38816, 0x3F33FC07 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x08000000, 0x5C000000, 0x9E000000, 0xFB000000, 0xDB800000, 0x96C00000, 0x32A00000, 0x99100000, 0xC7780000, 0x430C0000, 0xD1460000, 0x9A650000, 0x40B08000, 0x7DEFC000, 0x46B6A000, 0x62EC1000, 0xB7302800, 0x3D2C8400, 0x33112A00, 0x4E7A4300, 0x158AED80, 0xCB064B40, 0x73834FA0, 0xDAC59C50, 0x54A62018, 0x3613D02C, 0xDEFE883A, 0xB0CC942B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xE8000000, 0x6C000000, 0x5E000000, 0xFF000000, 0x17800000, 0xA5400000, 0xF5E00000, 0x3EF00000, 0x73480000, 0x081C0000, 0x42C20000, 0x98A10000, 0xF7128000, 0x4BBAC000, 0x00502000, 0x6F5F9000, 0xDE260800, 0x72D4C400, 0x309DD600, 0x68006500, 0xAC05E880, 0xBE01F5C0, 0x4F0416A0, 0xFF87C4F0, 0xC942A018, 0xABE5501C, 0xC1F62802, 0x64CB5437 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x98000000, 0x9C000000, 0x46000000, 0x73000000, 0xD0800000, 0x5D400000, 0x24600000, 0x14900000, 0x12D80000, 0x9FEC0000, 0xE8820000, 0xB1410000, 0x4A658000, 0x33964000, 0x80582000, 0x6BAAD000, 0x2963A800, 0x5B141C00, 0xF119EE00, 0xC1C98900, 0x4AF3A780, 0x434FE240, 0x06B441A0, 0xAEAEE770, 0x62E58018, 0x62D64024, 0x9A38201E, 0xC03AD033 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x58000000, 0x84000000, 0x36000000, 0xC1000000, 0x67800000, 0x69C00000, 0xA3E00000, 0x55900000, 0xE4580000, 0x546C0000, 0x33820000, 0xE7C70000, 0x56E58000, 0xCC164000, 0x909EE000, 0x22099000, 0xF8D5B800, 0x06FA3400, 0x5959F200, 0xD1EA1100, 0xD5425380, 0xF6A39E40, 0x633579A0, 0xA76C6B70, 0x63058028, 0x08864014, 0x6B46E01E, 0x0BA59005 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x48000000, 0x74000000, 0xA6000000, 0x11000000, 0xF8800000, 0x7B400000, 0x29200000, 0xC4500000, 0xB9780000, 0x8FCC0000, 0x0C860000, 0x9D410000, 0x58268000, 0x8CD7C000, 0x8A39E000, 0xD2EA9000, 0x6ED3B800, 0x353E4C00, 0x2F6E9E00, 0xFB135300, 0x3E5F8B80, 0x4E9FF940, 0x5B7DCDA0, 0x30CFB650, 0xF1068038, 0x0887C03C, 0x5341E00A, 0xED269031 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xF8000000, 0xCC000000, 0x3A000000, 0xAB000000, 0x19800000, 0x7B400000, 0xCAA00000, 0xDAD00000, 0x7FD80000, 0x616C0000, 0xDF820000, 0xA2470000, 0x3C238000, 0xE6154000, 0x6B39A000, 0x359BB000, 0x894E8800, 0xBF969400, 0xF07E9600, 0x8F3DCF00, 0xFB99A380, 0xF44E5840, 0x67139DA0, 0xC1BBF370, 0xEB5B8028, 0xAAA94024, 0x30E3A036, 0xBAF0B027 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xA8000000, 0xAC000000, 0xD2000000, 0xCF000000, 0x7A800000, 0x5AC00000, 0x94E00000, 0x2BB00000, 0x23980000, 0xD88C0000, 0x10860000, 0xD1C70000, 0x30618000, 0xFC71C000, 0xAAF82000, 0x7F7FF000, 0x2F3EE800, 0x791EAC00, 0x524E8200, 0x8C64B100, 0xC6765A80, 0x69FF7140, 0x47FF90A0, 0x12FB5C50, 0x3B798008, 0xF13DC034, 0xF41E2002, 0x4FC8F00F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x98000000, 0x14000000, 0xA2000000, 0x77000000, 0x7B800000, 0x2A400000, 0xA7200000, 0x02D00000, 0xCD280000, 0xE51C0000, 0x79860000, 0xCD410000, 0x94A68000, 0x14914000, 0x440C6000, 0x26C9B000, 0x1A28A800, 0x0E9D6400, 0x1BC20E00, 0x56642B00, 0xB877CF80, 0x18BA8FC0, 0x0F9789A0, 0x798B30D0, 0x218E8038, 0x158D403C, 0x678A603E, 0x3888B029 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x18000000, 0xCC000000, 0x06000000, 0x65000000, 0x4F800000, 0x02C00000, 0x1FA00000, 0x12B00000, 0x9D980000, 0x9BCC0000, 0x8C820000, 0x58470000, 0x6AE48000, 0x73D54000, 0x8E8EA000, 0xBDE25000, 0xC3551800, 0x28C85400, 0xEE03EA00, 0x51062B00, 0x15870880, 0xC9C1C940, 0xE123DAA0, 0x95F4A670, 0xE3FE8028, 0xBC5E401C, 0x4EE8200E, 0x4370101F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x58000000, 0xD4000000, 0xAA000000, 0x27000000, 0x1C800000, 0xA1400000, 0xFAE00000, 0x40F00000, 0x71580000, 0x7C8C0000, 0xA1820000, 0x72C70000, 0xBB238000, 0x6D504000, 0xCA4C6000, 0x08A7F000, 0x9C926800, 0xCFE8DC00, 0x6FB36E00, 0xCEBE1D00, 0xABFE7080, 0x431C5D40, 0x80E896A0, 0x4F312C70, 0x39F98028, 0x001B4024, 0x1E6DE01E, 0x1570B021 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x88000000, 0xF4000000, 0xC2000000, 0xA5000000, 0xCF800000, 0x59400000, 0x23600000, 0x25900000, 0xAC080000, 0x4E3C0000, 0x50820000, 0x2FC30000, 0x13A48000, 0x80B5C000, 0xBC7BE000, 0x6765B000, 0xAF953800, 0x5D0E5400, 0x73B93600, 0x24C59100, 0x37249780, 0xAD76DCC0, 0xAADFF9A0, 0x185169F0, 0xC2AE8008, 0xED0AC03C, 0x3BBD600A, 0x70C37031 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x48000000, 0xCC000000, 0x62000000, 0x55000000, 0x01800000, 0x38C00000, 0x11200000, 0x13500000, 0x07980000, 0x96AC0000, 0xF2820000, 0xE2410000, 0xCF668000, 0x1633C000, 0xB8AC2000, 0x05817000, 0x56C7B800, 0xC625A400, 0x77D04A00, 0x76DB0F00, 0x734A7380, 0x92F1B640, 0xA38F21A0, 0x5FD1AD70, 0x4ADC8018, 0xB94EC03C, 0x3BF0A02A, 0x880FB03F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x58000000, 0xEC000000, 0x16000000, 0x83000000, 0xCC800000, 0xAFC00000, 0x38E00000, 0x07B00000, 0xD2380000, 0xA02C0000, 0x5D860000, 0x02470000, 0x82A48000, 0xF9134000, 0x552DA000, 0xC203D000, 0xA906A800, 0x91877C00, 0x64429A00, 0xF9A67900, 0xE9969A80, 0xB4EE1C40, 0x95E388A0, 0x74338950, 0x6F7A8008, 0x3008401C, 0x0C57203E, 0x010B9037 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0xC8000000, 0xC4000000, 0x2A000000, 0xAB000000, 0x8F800000, 0x5EC00000, 0x53600000, 0x13900000, 0x16480000, 0xE9FC0000, 0xA0820000, 0xDB410000, 0xD6A38000, 0x9772C000, 0x57186000, 0x42D37000, 0xDBEA0800, 0x490A2400, 0x35580A00, 0xECF32D00, 0x5BD9A780, 0xC6B0BEC0, 0xF1F845A0, 0x8C8407F0, 0x45418018, 0x0FA3C014, 0xBFF3E00A, 0x685DB015 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x38000000, 0x8C000000, 0x5E000000, 0x03000000, 0xB7800000, 0x91400000, 0xCB600000, 0x68100000, 0x7A080000, 0x3CBC0000, 0xE3060000, 0x67810000, 0xC9478000, 0xD7654000, 0x0E15A000, 0xF50E9000, 0xD53EE800, 0x7143A400, 0x1B603600, 0x30155100, 0x66085B80, 0x5AB930C0, 0x6C02A5A0, 0x8E0515D0, 0x5B060038, 0xAB810034, 0xF7478016, 0x44654007 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xE8000000, 0xE4000000, 0x46000000, 0x37000000, 0x7F800000, 0xA3400000, 0x66E00000, 0x89500000, 0xC1180000, 0x556C0000, 0x8F020000, 0x93870000, 0x31418000, 0xEFE7C000, 0xCDD06000, 0xBFDD1000, 0xE1CF8800, 0x28304400, 0x0709E600, 0x6093AD00, 0xDA3EBD80, 0x991F2240, 0x896B33A0, 0xE5011B70, 0x16820028, 0xD7C70034, 0xE0218032, 0x31F7C03D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x88000000, 0x3C000000, 0xEA000000, 0x53000000, 0xB3800000, 0x28C00000, 0x0E600000, 0xBB700000, 0xA7E80000, 0xD2BC0000, 0xA7020000, 0x45810000, 0x81C08000, 0x96E3C000, 0x9435A000, 0x574EB000, 0xDEA9C800, 0x5B1D0400, 0xAB91DA00, 0xD2DFB500, 0xC1756880, 0x4CECC4C0, 0x353A5AA0, 0xA9C205F0, 0x7AE20018, 0xE631000C, 0x4048801A, 0x332FC033 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xA8000000, 0xF4000000, 0x46000000, 0x61000000, 0x23800000, 0xABC00000, 0x19E00000, 0xB6500000, 0x20C80000, 0x623C0000, 0x6B060000, 0x28870000, 0x53448000, 0x72A4C000, 0xA8F2E000, 0x923D9000, 0x23053800, 0x4C801400, 0x8D414200, 0x4FA41100, 0x39703D80, 0x1EFB14C0, 0x786427A0, 0x729141D0, 0x1FAE0008, 0x822B001C, 0xC4EA8002, 0x748FC031 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x68000000, 0x3C000000, 0xFA000000, 0x51000000, 0x83800000, 0xA5400000, 0x34200000, 0xCAB00000, 0x34280000, 0x497C0000, 0xD3060000, 0x16830000, 0x58C68000, 0x9E64C000, 0x8212A000, 0x4F5E3000, 0xC4B15800, 0x132C9400, 0x29FC3600, 0x68C50B00, 0x9667B480, 0x6E1094C0, 0x2D58FAA0, 0xC1B0FBD0, 0x56AE0028, 0x27BF002C, 0x8E608012, 0x7A17C033 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x18000000, 0x4C000000, 0xDE000000, 0xC1000000, 0xDD800000, 0x54C00000, 0x52600000, 0x4BB00000, 0x30A80000, 0x333C0000, 0x2C060000, 0xAE050000, 0x39068000, 0xA1814000, 0x92C2A000, 0xDF649000, 0x4830F800, 0xA568E400, 0xBCD84A00, 0x33763500, 0xCCCDCE80, 0x418958C0, 0xBD2F5CA0, 0x0FFB59D0, 0xCA600018, 0x47B0001C, 0x0EA8003E, 0xC23C001F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xD8000000, 0x0C000000, 0x06000000, 0xAD000000, 0xC3800000, 0x35400000, 0x64600000, 0xCD100000, 0x64380000, 0x248C0000, 0x68020000, 0x14070000, 0x2A008000, 0x9B074000, 0xB686A000, 0xFAC05000, 0x57255800, 0x04737400, 0x6AAFB600, 0x75F68900, 0x28EB4B80, 0xB1104940, 0x5A3D85A0, 0x9589A470, 0x45800028, 0x5840003C, 0x87E0003E, 0xC850000F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x98000000, 0x04000000, 0x0E000000, 0xD3000000, 0x4E800000, 0x96C00000, 0x32600000, 0x56B00000, 0x31780000, 0x1CEC0000, 0x60060000, 0x10070000, 0xC8028000, 0x6C034000, 0x9204E000, 0xD9005000, 0x9386E800, 0x0B44EC00, 0xEA26C200, 0xF2152500, 0x55AB2680, 0x7B273E40, 0x4D936CA0, 0x6CEEE750, 0xB8000008, 0xB400002C, 0x3600000E, 0x2700003D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x88000000, 0xD4000000, 0xFA000000, 0x0D000000, 0xA9800000, 0xB4C00000, 0x41200000, 0x19D00000, 0xB5480000, 0xA34C0000, 0x44020000, 0x12030000, 0xA9028000, 0x0B834000, 0xE5C22000, 0xC6A35000, 0x5A13E800, 0x50E83400, 0xA7DEA600, 0x04A8D300, 0xE9BE0480, 0x4198E740, 0x0F869520, 0xAB8C2D30, 0x9B200008, 0x04D0000C, 0x34C8000A, 0x138C000D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xE8000000, 0x24000000, 0xC6000000, 0x4D000000, 0x46800000, 0x98400000, 0xBFA00000, 0x3D700000, 0x3FB80000, 0x00CC0000, 0x9C020000, 0x4A010000, 0xCF018000, 0x1D834000, 0x7BC3A000, 0x45609000, 0xDC931800, 0xF0693400, 0x44851A00, 0x3B346100, 0x696DFE80, 0x247275C0, 0xA73B3EE0, 0xA98D6330, 0xBF200008, 0xA8300004, 0xA6980006, 0x75FC000D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xA8000000, 0xDC000000, 0x0A000000, 0x33000000, 0xD3800000, 0x4D400000, 0x41A00000, 0xE8300000, 0x5E880000, 0xEB3C0000, 0x62020000, 0xCF010000, 0x09818000, 0x6642C000, 0xE622A000, 0x73737000, 0x26282800, 0xE38CCC00, 0xA2494E00, 0x28DC3500, 0xC2128680, 0x1FF860C0, 0x5A165A20, 0x9C0C1CF0, 0x6D080008, 0x567C0004, 0xEBA20006, 0x4B31000B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x48000000, 0x54000000, 0x9A000000, 0xAB000000, 0x77800000, 0x55400000, 0xCEA00000, 0x44500000, 0x47080000, 0xA78C0000, 0x02020000, 0xE7010000, 0xE1818000, 0x0841C000, 0x94212000, 0x03915000, 0x9A6A6800, 0xA4BEAC00, 0xED3BDE00, 0xD8345500, 0x89F4BA80, 0x4997D140, 0x7026BC20, 0xA8DC8E30, 0x02880008, 0x3DCC0004, 0x09220006, 0x79110007 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xF8000000, 0x3C000000, 0x2E000000, 0x23000000, 0x9E800000, 0xD9400000, 0xEFA00000, 0x58700000, 0x86C80000, 0x399C0000, 0xDA020000, 0xA9010000, 0x7F808000, 0x42C3C000, 0x4F63E000, 0xE210F000, 0xE558B800, 0xB5048C00, 0x7AE47A00, 0xFAB46500, 0x82CC3E80, 0x90F921C0, 0x6477BB20, 0x73AEB670, 0x79E80008, 0x2BAC0004, 0xF5EA0002, 0xDDAD000F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xA8000000, 0x64000000, 0xC6000000, 0xA7000000, 0xDB800000, 0x71400000, 0x3B200000, 0x1AF00000, 0xD0480000, 0x4DF40000, 0x13020000, 0xF5810000, 0x92408000, 0x76A14000, 0x64B2A000, 0x54E99000, 0xE0471800, 0x5F689C00, 0x79066E00, 0x204B4500, 0xF5F4AC80, 0xFF004BC0, 0x07829120, 0x5B400FD0, 0x6E220008, 0x08710004, 0xB9888002, 0x1A154005 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xF8000000, 0xBC000000, 0xA2000000, 0x53000000, 0xAC800000, 0x0AC00000, 0xAA600000, 0x75D00000, 0x62980000, 0x31C40000, 0x5F020000, 0xC6810000, 0x6DC38000, 0x70E24000, 0xCA13E000, 0x297AF000, 0x13568800, 0x62BB4C00, 0x8EB7B200, 0x8529AB00, 0x3A8DE980, 0xDE5FB740, 0x93463A60, 0x1CC12F10, 0xCF620008, 0x8C510004, 0x19DB800E, 0x34E64009 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xF8000000, 0x44000000, 0x7A000000, 0xB9000000, 0xAA800000, 0x20400000, 0x44600000, 0x2CD00000, 0x40B80000, 0x9C1C0000, 0x55020000, 0x4C830000, 0x57438000, 0xC5E04000, 0xA313E000, 0xB0191000, 0x17EDE800, 0x6E88E400, 0x3635AA00, 0xBAC50100, 0x28CC5180, 0x81B9D340, 0xB29CD2E0, 0xEF41B870, 0xA1E20008, 0x2913000C, 0xE11B800E, 0x016C4001 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xB8000000, 0xF4000000, 0x9A000000, 0xD9000000, 0xE3800000, 0x13400000, 0x9DE00000, 0x64100000, 0x6D680000, 0xE9A40000, 0xE5020000, 0x25830000, 0x3C408000, 0x19634000, 0x6FD2E000, 0x2D4BD000, 0x7A966800, 0xBBD96400, 0xBB3C8E00, 0x2ADECD00, 0xC0CC3780, 0x1EA6F040, 0xA580A5A0, 0xFC43EE90, 0x39620008, 0xBFD3000C, 0x95488002, 0x8E97400D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x98000000, 0x4C000000, 0x02000000, 0xE5000000, 0xD7800000, 0xEBC00000, 0x85A00000, 0x79D00000, 0x28480000, 0xF5C40000, 0xB7020000, 0x7A810000, 0x78438000, 0xC861C000, 0xCF726000, 0x2D193000, 0x06CC0800, 0x1E259400, 0x0DB05E00, 0x3D392F00, 0x91DC5680, 0x144C4740, 0xF264F120, 0x6BD26F10, 0x654A0008, 0x16450004, 0x62C1800E, 0x8020C007 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x08000000, 0x8C000000, 0xC2000000, 0xFB000000, 0xF3800000, 0x72C00000, 0x9E200000, 0x6CB00000, 0x05280000, 0xA1F40000, 0x25020000, 0xE2810000, 0xC6418000, 0x85614000, 0xFF502000, 0x4A3A3000, 0x83AF0800, 0x177DEC00, 0x8B84CE00, 0xE80B4B00, 0xF2C7B880, 0xF0EB52C0, 0x765644A0, 0x74701FD0, 0x9C0A0008, 0xC4C50004, 0x7DEB8006, 0x68D44005 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x58000000, 0x64000000, 0x9E000000, 0xAF000000, 0xBF800000, 0x88400000, 0x17600000, 0x0C500000, 0x87480000, 0x348C0000, 0x4D020000, 0x8A830000, 0x96C28000, 0xE7A0C000, 0x10F16000, 0xEE399000, 0x99F67800, 0xE214BC00, 0x4387FE00, 0xFAEDA100, 0xADD31D80, 0x60081140, 0x3C6CAD20, 0xF9109A30, 0x42AA0008, 0xCA1F000C, 0xB3E8800A, 0x01FFC003 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xE8000000, 0x24000000, 0x7E000000, 0x37000000, 0x57800000, 0x45400000, 0x35E00000, 0x9F500000, 0x52280000, 0x64240000, 0x87820000, 0xDD410000, 0x99E18000, 0xF550C000, 0xF32BA000, 0x20A49000, 0xEB43F800, 0x9AE1DC00, 0x64D0DE00, 0x7D69D500, 0xF0C77780, 0x5C50ED40, 0xE3A9B0A0, 0xBA64CC90, 0x8FE18008, 0xA650C004, 0xBAABA006, 0x62E49003 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x88000000, 0x54000000, 0x9E000000, 0x8B000000, 0x31800000, 0x21C00000, 0xDC600000, 0x70D00000, 0x6C780000, 0x54FC0000, 0x79820000, 0x55C10000, 0xD2618000, 0x83D3C000, 0x81FA2000, 0xBF3D5000, 0xB0E07800, 0x9F932C00, 0xAE594600, 0x2A8F4700, 0x54CB5180, 0xF6559340, 0x5A0449E0, 0x313FBFF0, 0x03E18008, 0x1213C004, 0xB59A2006, 0x6BED500F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x48000000, 0x3C000000, 0x46000000, 0x77000000, 0x90800000, 0xD0C00000, 0x60200000, 0xF0300000, 0x80B80000, 0x45140000, 0xB4820000, 0xC2C10000, 0x9D218000, 0x89B24000, 0xC3F92000, 0x1F74F000, 0xC5531800, 0x35E8DC00, 0xE8FFC200, 0x487F0300, 0x60BFA080, 0x849DB0C0, 0xD6AFDAE0, 0x13152850, 0xCB818008, 0x0E424004, 0x9BE12006, 0xD690F009 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x98000000, 0x4C000000, 0x86000000, 0xC7000000, 0x99800000, 0xCBC00000, 0xAAE00000, 0x4CF00000, 0x7AB80000, 0x67040000, 0xDF820000, 0x6CC10000, 0x43608000, 0x4F314000, 0x045A6000, 0xE1F53000, 0xE4381800, 0x55461C00, 0xCEA0E600, 0x42D36F00, 0xA1284B80, 0x988D43C0, 0xFDDF92E0, 0x0C34B010, 0x99D88008, 0x38354004, 0x63D86002, 0x91343005 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xE8000000, 0xCC000000, 0xF2000000, 0xD1000000, 0xD7800000, 0x0BC00000, 0x8B600000, 0x38B00000, 0x4F380000, 0x986C0000, 0x3E820000, 0xD8410000, 0xCEA18000, 0x68D04000, 0x550BA000, 0x35173000, 0x054DC800, 0x53904400, 0xBD2BDE00, 0xF185EF00, 0x28E7CD80, 0xF15772C0, 0xF1EF44E0, 0x56402DB0, 0x35A38008, 0x3A514004, 0x4F4A2006, 0xB2B77001 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x88000000, 0x04000000, 0x0A000000, 0x77000000, 0x3C800000, 0x37C00000, 0xD6E00000, 0x50B00000, 0x7B580000, 0xF84C0000, 0x73820000, 0x97410000, 0x07218000, 0xAF514000, 0xE26A2000, 0xFB541000, 0x5C6E2800, 0x2252DC00, 0x51E87200, 0x4C141F00, 0x6B4E3B80, 0x550072C0, 0x3F815560, 0xB942D530, 0x4A238008, 0x3CD04004, 0x652BA006, 0x14755005 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0xE8000000, 0x64000000, 0x06000000, 0x83000000, 0xBA800000, 0x4CC00000, 0x50A00000, 0xDB900000, 0x28480000, 0x1F0C0000, 0x3D820000, 0xE0430000, 0xA7608000, 0x4DB3C000, 0x351BA000, 0x86E59000, 0xC69E1800, 0x80CB0C00, 0xFECD6A00, 0x10A07300, 0x3B922280, 0xF849DE40, 0x070EE920, 0xB183C830, 0x82428008, 0x2260C00C, 0x74332002, 0xC35A500F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xE8000000, 0xB4000000, 0xD2000000, 0xB3000000, 0xA5800000, 0x74400000, 0x6F600000, 0x52300000, 0x0C980000, 0x2FC40000, 0xF2820000, 0x9BC30000, 0x94218000, 0x4ED2C000, 0xA3EBA000, 0xEEBED000, 0x8CB54800, 0xCDFBCC00, 0xB8F41600, 0x02989100, 0x3AC7DD80, 0x5603B8C0, 0x49006A60, 0xC2831B10, 0xB3C38008, 0x4021C00C, 0x2CD22006, 0xF8E8100B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x88000000, 0xEC000000, 0x9A000000, 0x7F000000, 0xF2800000, 0xD5C00000, 0x8F600000, 0xC1500000, 0x1BD80000, 0x9A340000, 0xC9820000, 0xC1410000, 0x97A28000, 0xFFB34000, 0xEFCA2000, 0x484FB000, 0x75046800, 0x788AFC00, 0xAAEC4A00, 0x2F349700, 0x8C005D80, 0xAA011540, 0x87007760, 0x46809CD0, 0x2BC08008, 0x86624004, 0xD6D0A00A, 0x4398F00D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xB8000000, 0x6C000000, 0x3E000000, 0xCB000000, 0x8E800000, 0x73C00000, 0x67600000, 0x2AD00000, 0x2A280000, 0xEB2C0000, 0x63820000, 0x6A410000, 0x3C208000, 0xE971C000, 0x6F1AE000, 0x3F15B000, 0x7566F800, 0x70FC2C00, 0xF629BA00, 0x0D2D8F00, 0x94803D80, 0x12C33B40, 0x50E380A0, 0x529008B0, 0xC30A8008, 0x37DCC004, 0x49D86002, 0x2DF57007 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xE8000000, 0x14000000, 0xD6000000, 0xC3000000, 0x0F800000, 0x6A400000, 0x02600000, 0xB3100000, 0x78E80000, 0xAE440000, 0x22820000, 0x1AC10000, 0x85A08000, 0x9E314000, 0xED1BA000, 0x147C5000, 0x4A0D5800, 0xE4740C00, 0x799BBE00, 0xBDBD6900, 0x782C6980, 0xEC077C40, 0x54E2CBA0, 0x0FD27D10, 0x864A8008, 0xC3F44004, 0x67D92002, 0x19DC1005 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x38000000, 0xBC000000, 0x02000000, 0x49000000, 0x99800000, 0x56C00000, 0x31200000, 0x89D00000, 0xF0E80000, 0xEC440000, 0xD6820000, 0x78410000, 0x55638000, 0x6EB14000, 0xBF58E000, 0x4E9EF000, 0x70DE0800, 0x72BE2400, 0x7E8EE600, 0x2F949B00, 0x1B69E480, 0x3B87F740, 0x4A211BA0, 0x7150CD10, 0x5BA98008, 0x65A44004, 0x1D71600E, 0x6DFAB005 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x78000000, 0xF4000000, 0x32000000, 0x83000000, 0x38800000, 0x5C400000, 0xF9600000, 0x9DF00000, 0x8BD80000, 0x1B440000, 0x2C420000, 0x11610000, 0x31F08000, 0x9DDB4000, 0xD245E000, 0x63C1D000, 0x47A1C800, 0x17D28C00, 0xC1CBA200, 0x982C9100, 0x0A3E3580, 0xED55BFC0, 0xA12BA360, 0xFA1E4F10, 0x1845E008, 0x54C1D004, 0x6D21C802, 0x18928C0D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xF8000000, 0xFC000000, 0x2A000000, 0xFD000000, 0x99800000, 0x46400000, 0x6B600000, 0xCF700000, 0xD2080000, 0x2D2C0000, 0x74420000, 0x1A610000, 0xB4F08000, 0x7D484000, 0xF1CFE000, 0xD671F000, 0xED89A800, 0x746F7400, 0x6FA02600, 0x24D3F900, 0x60DADD80, 0xBAF7D5C0, 0xBA355C20, 0x879622B0, 0xE247E008, 0x111DF004, 0x00ABA802, 0xB07E7401 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x08000000, 0x44000000, 0x0A000000, 0xB7000000, 0x96800000, 0xF4C00000, 0x51600000, 0x69500000, 0xC6380000, 0x9D4C0000, 0x3AC20000, 0xAC610000, 0x28D18000, 0x147AC000, 0x30EC2000, 0x46F31000, 0x09092800, 0xC4A75C00, 0x25769A00, 0x528CF300, 0x9322D580, 0x5CF3CD40, 0x260AA4E0, 0xCE27DF30, 0x27B42008, 0xF2EF1004, 0x95F32806, 0x458A5C0B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xB8000000, 0xB4000000, 0xC6000000, 0x91000000, 0x83800000, 0x7EC00000, 0xACA00000, 0xD6100000, 0x45380000, 0x1C5C0000, 0x24C20000, 0xE7A10000, 0x5E928000, 0x137BC000, 0x16BEE000, 0x4030D000, 0x726A1800, 0x1104C400, 0xE92FCE00, 0x88C81B00, 0xFE17E280, 0x73970040, 0xD05570E0, 0x2D77CF70, 0x22A6E008, 0x61BCD004, 0xE2B0180A, 0x9729C40F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x58000000, 0xFC000000, 0xAA000000, 0xCB000000, 0xCD800000, 0xDC400000, 0xAB200000, 0x4D500000, 0x91880000, 0x66340000, 0xB7420000, 0xF6A30000, 0xE9108000, 0x96A94000, 0xD9656000, 0x11C9F000, 0xF715A800, 0x4911AC00, 0x06A97600, 0xA1669100, 0xBDCA1C80, 0x0515FD40, 0x7E101A20, 0x612A46D0, 0xB6276008, 0xDB6AF00C, 0x94052802, 0x44B8EC05 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x88000000, 0xD4000000, 0xF2000000, 0xC9000000, 0x86800000, 0xF5C00000, 0x1AE00000, 0xC7300000, 0xDE880000, 0x5F7C0000, 0x84C20000, 0xD0630000, 0xFCF18000, 0xFB6B4000, 0xADCE2000, 0x34095000, 0x14BCC800, 0x9920A400, 0xAED25A00, 0xE2387700, 0xD0B47B80, 0x759CF4C0, 0xDBF20E20, 0x32EA2FF0, 0x558C2008, 0xCCAA500C, 0xE62D4806, 0x49BBE40D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x78000000, 0x14000000, 0x1A000000, 0x8F000000, 0x01800000, 0x4E400000, 0xD1A00000, 0x44500000, 0x66F80000, 0x34EC0000, 0x3B420000, 0xCF230000, 0x23928000, 0x651BC000, 0xD71DE000, 0x98EA5000, 0x09B76800, 0xECFEBC00, 0x0F1AC600, 0xE01D5900, 0x2D685680, 0xADF45940, 0xCA5E97E0, 0x5ECA2DB0, 0xD2A7E008, 0x4725500C, 0xD367E80A, 0x2DC67C0F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x18000000, 0x5C000000, 0x92000000, 0x11000000, 0x80800000, 0xF1400000, 0x1DE00000, 0x4F700000, 0x57980000, 0x727C0000, 0x62420000, 0xB4610000, 0xD2B18000, 0xE13B4000, 0x75EC6000, 0x342B7000, 0xE3C74800, 0x4EEFC400, 0x09AA4200, 0xA8072500, 0x274DC780, 0x0DBB55C0, 0x9EAC8A60, 0x1CC833F0, 0x32366008, 0x73367004, 0xABB4C806, 0x66F5840D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x48000000, 0xE4000000, 0xE6000000, 0x25000000, 0x14800000, 0x74C00000, 0x10E00000, 0x57B00000, 0x77180000, 0x4A140000, 0x47C20000, 0x79630000, 0x3BF28000, 0xC13B4000, 0x86452000, 0xB2E99000, 0xC22C9800, 0x77041400, 0xAC4A1200, 0x90BD7300, 0x65CC1380, 0xDF35A6C0, 0x0A107860, 0xD40BB250, 0x989F2008, 0x809E900C, 0xEC9C180A, 0x4E9C540D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x48000000, 0x84000000, 0x4E000000, 0xCB000000, 0xAF800000, 0x5BC00000, 0xA9600000, 0x57B00000, 0x73280000, 0x4A540000, 0x1AC20000, 0xA3E30000, 0x78F38000, 0x960BC000, 0x23452000, 0x5D381000, 0x482E3800, 0x3FCEAC00, 0x913C7E00, 0x1036CF00, 0xEEF1F580, 0xA10A06C0, 0xEEC590A0, 0xF7F85F50, 0x83CF2008, 0xD33F100C, 0xF137B80E, 0x34726C0F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xF8000000, 0x0C000000, 0xE2000000, 0x7B000000, 0x65800000, 0x69400000, 0xE3A00000, 0xC4F00000, 0x4A380000, 0x450C0000, 0xCC420000, 0x27230000, 0x1F328000, 0xF75AC000, 0x881FE000, 0xC8AA3000, 0x67A48800, 0x44E56C00, 0xF8465600, 0x5F35C500, 0xA14EFE80, 0x0F623BC0, 0x9E1054E0, 0x85689A30, 0x8FC5E008, 0xD575300C, 0x3B6C080A, 0x08D0AC0B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xA8000000, 0xFC000000, 0xC6000000, 0x17000000, 0x42800000, 0x13C00000, 0x7BE00000, 0x6DB00000, 0x9BE80000, 0x49940000, 0xAEC20000, 0x50610000, 0x2FF08000, 0x5349C000, 0xC906A000, 0x4CF9F000, 0x6FEE1800, 0x6EEEDC00, 0xA36FCA00, 0x862D6F00, 0xA40C5F80, 0xCB5E4EC0, 0x948523A0, 0xD1B82450, 0x49CCA008, 0xE3BCF004, 0x79B49802, 0xAC921C07 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xC8000000, 0xFC000000, 0xE2000000, 0xEF000000, 0x18800000, 0x6EC00000, 0x15A00000, 0x4ED00000, 0x64080000, 0xA59C0000, 0xE6420000, 0x73630000, 0x07728000, 0xD8D84000, 0xE6972000, 0xA75DF000, 0x19E28800, 0x8EB23C00, 0x89FAA200, 0x3486DB00, 0xF1F68680, 0x162C4340, 0x803A2420, 0xA5A48870, 0x83E5A008, 0x5085B00C, 0x47F5A80A, 0x572FCC01 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x18000000, 0x64000000, 0xCA000000, 0xA9000000, 0x0B800000, 0x92400000, 0x28E00000, 0x52F00000, 0x03780000, 0x9D2C0000, 0x7DC20000, 0xB0A30000, 0xB3118000, 0x8A0B4000, 0x14146000, 0xAC0F9000, 0x55922800, 0xA9C82400, 0xAFB6EE00, 0x719F6900, 0x20585380, 0x187D73C0, 0x752941E0, 0x8F44DEB0, 0x0FE5E008, 0xB4F4D00C, 0x22FE4806, 0x48EBB40D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x98000000, 0x04000000, 0x42000000, 0x59000000, 0xDA800000, 0x35400000, 0xF1A00000, 0x6CD00000, 0x51580000, 0x57E40000, 0x03C20000, 0xEAE30000, 0x2A718000, 0x30094000, 0x6E7E6000, 0x55461000, 0x80900800, 0xBA7BE400, 0x6E77AA00, 0xF339F500, 0x49D6B680, 0x7CEB2B40, 0xCF0F6960, 0x1ECEB190, 0x552FE008, 0xF1DF500C, 0x2E966806, 0xEC49F405 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x78000000, 0x3C000000, 0x32000000, 0x8B000000, 0x24800000, 0x53C00000, 0x1DA00000, 0x99D00000, 0x60E80000, 0xE99C0000, 0x91420000, 0x43630000, 0x7DF08000, 0x3B78C000, 0x2295E000, 0x3CEEF000, 0x73F9C800, 0xEB55AC00, 0xFE4ED200, 0x88A96F00, 0x257EE680, 0xABF01F40, 0x4E7947A0, 0xE7148870, 0xCCAD6008, 0x531A300C, 0x8BE62802, 0x0C545C03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xF8000000, 0x3C000000, 0x3E000000, 0xBB000000, 0x58800000, 0xA4C00000, 0xA7600000, 0xEB700000, 0x9B780000, 0x6F4C0000, 0xA7420000, 0x2B230000, 0xA0D28000, 0x03684000, 0xE547E000, 0xEA76F000, 0x3EADF800, 0x6BF16C00, 0xD3B8A200, 0xAE2FB300, 0xDB33CD80, 0x2EDB45C0, 0xEC5E09E0, 0x65C88B30, 0x3AD76008, 0x2E3DB00C, 0x1D38980A, 0x15EFDC01 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xC8000000, 0x4C000000, 0x5E000000, 0x59000000, 0x35800000, 0x1AC00000, 0x51200000, 0x2AB00000, 0x61980000, 0xAD340000, 0x1E420000, 0xC2630000, 0xD7508000, 0x3F08C000, 0x459F2000, 0xDD2F3000, 0x4BB47800, 0x6200E400, 0x2F039600, 0x30830B00, 0x89439480, 0x96E3C2C0, 0x5C10AA60, 0x56EA7ED0, 0xF10DA008, 0xB684F00C, 0xF65BD802, 0xC3971403 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x78000000, 0x54000000, 0xCA000000, 0x19000000, 0x05800000, 0x9C400000, 0xC2600000, 0x2A300000, 0x79A80000, 0x5AB40000, 0xE4C20000, 0x59A30000, 0x31138000, 0xE27A4000, 0x6A6DE000, 0x873F5000, 0x87262800, 0xB77AE400, 0xA1EED600, 0x507C5100, 0x9DC4F980, 0xB689B0C0, 0xCB653AA0, 0x2D1810D0, 0xAFDC6008, 0x0BD6100C, 0xF270480E, 0xC9CBF409 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x38000000, 0xC4000000, 0xF6000000, 0x15000000, 0xDB800000, 0x5C400000, 0x19E00000, 0x21700000, 0x90580000, 0xE5240000, 0xB4C20000, 0xF3210000, 0x5B508000, 0x52894000, 0x60ECE000, 0xFF4D1000, 0x98DCD800, 0xF577D400, 0xB4C9AE00, 0x560D5100, 0x6ABC5780, 0xC046EDC0, 0x9171BD60, 0x9858A690, 0x69266008, 0xEEC15004, 0xEC22B802, 0xA7D28405 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x08000000, 0x64000000, 0xCE000000, 0xB9000000, 0x31800000, 0x3BC00000, 0x88A00000, 0x61900000, 0xC1080000, 0x3F1C0000, 0xA9420000, 0x1DE10000, 0xEE728000, 0x9479C000, 0xF9E42000, 0x25E79000, 0x67E43800, 0xA4E76400, 0x9A648600, 0x45248F00, 0x6DC7D280, 0xC8374E40, 0x688F2820, 0xFD481670, 0x197CA008, 0x7BF35004, 0x81B8980A, 0x18443407 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xE8000000, 0x54000000, 0x56000000, 0x67000000, 0xAB800000, 0xF3400000, 0xC3200000, 0xB9F00000, 0xE9580000, 0x7C2C0000, 0x0DC20000, 0xD2E30000, 0x19138000, 0x99494000, 0xC5E7A000, 0x7AE75000, 0xFD645800, 0x04271C00, 0xF2056E00, 0x3977AD00, 0xBBEE3C80, 0x0A228FC0, 0xE9705160, 0x039BAAB0, 0xC54E2008, 0x0791100C, 0xD88A780E, 0x8D060C05 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x98000000, 0x0C000000, 0x1A000000, 0x17000000, 0xE6800000, 0xCB400000, 0x94E00000, 0x3D900000, 0x11780000, 0x33D40000, 0xC4E20000, 0x05910000, 0x6D7B8000, 0x21D64000, 0x47E06000, 0xF5113000, 0xAB3BE800, 0x44B61C00, 0x57B3FA00, 0xBBCA1D00, 0x319DBB80, 0xACBCEA40, 0x708EBFE0, 0x21875250, 0xD13BE808, 0x83B61C04, 0xC933FA0E, 0xEC8A1D09 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xD8000000, 0x7C000000, 0x9E000000, 0x0F000000, 0xB6800000, 0xE1400000, 0xF3A00000, 0x07500000, 0x71180000, 0xCFFC0000, 0x2DA20000, 0x68530000, 0x379A8000, 0xA6BD4000, 0x7A016000, 0x8D02F000, 0xD780F800, 0xD0C17C00, 0x0061BA00, 0xF7B27500, 0x14E9B680, 0x00342140, 0xC4851E60, 0x98EDBAF0, 0x8698F808, 0x8F3D7C0C, 0x55C3BA0A, 0xB3E17505 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x28000000, 0x84000000, 0x86000000, 0xC7000000, 0xD4800000, 0x2F400000, 0xD3600000, 0xC1B00000, 0x19780000, 0x1A340000, 0xB9620000, 0x64B30000, 0x5CFA8000, 0x7EF5C000, 0x3DC2A000, 0x5B211000, 0x16509800, 0xAF8ADC00, 0x7C2FF200, 0x60E4AD00, 0x85A85580, 0x31FD9AC0, 0x60AE77E0, 0xDBA4B5D0, 0x28C89808, 0xEB4EDC0C, 0x8755F20A, 0x2BD3AD07 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x68000000, 0x74000000, 0x92000000, 0x89000000, 0x84800000, 0x96400000, 0x37A00000, 0xF3500000, 0x4E780000, 0x7DBC0000, 0x84A20000, 0x2AD10000, 0x9EBB8000, 0x8D5EC000, 0xD8D3A000, 0xE7B8D000, 0x81DDC800, 0x8A92E400, 0x2A1AB200, 0x8F8C0900, 0xD26A5680, 0x48E54940, 0xB80F7BE0, 0x9DA827F0, 0xAF87C808, 0xBBBFE404, 0x8FA3320E, 0x1F53C90B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x14000000, 0x72000000, 0x65000000, 0xB2800000, 0x61C00000, 0x29E00000, 0x25900000, 0x2A780000, 0x10A40000, 0xB6E20000, 0xB6110000, 0x83398000, 0x39844000, 0x1213A000, 0xA9395000, 0x50844800, 0xBE93D400, 0xA3FA6A00, 0xC8E45700, 0x5F432F80, 0x1621A240, 0x0773B3E0, 0xAE684D90, 0x969E4808, 0x2DE6D404, 0xADC1EA06, 0x17E11701 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xC8000000, 0xE4000000, 0x36000000, 0x73000000, 0x0F800000, 0xDA400000, 0x4C600000, 0x84D00000, 0x0DF80000, 0xD4440000, 0x31620000, 0xA4510000, 0xF2388000, 0x3B644000, 0x9F512000, 0x59BA9000, 0xF7245800, 0xB0338C00, 0x1AEA1E00, 0xC49C7900, 0x1E17A980, 0xDC5BFF40, 0x62B619E0, 0xE22A2010, 0x9A3E5808, 0xDD668C04, 0x44509E02, 0x82393901 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xD8000000, 0x44000000, 0x92000000, 0x0B000000, 0xB3800000, 0x08400000, 0x90200000, 0x10F00000, 0x8DC80000, 0xEC940000, 0x0D220000, 0x9A730000, 0x8D098000, 0xCF774000, 0x19B16000, 0x416A1000, 0x65A7C800, 0x1B896C00, 0xD9B6AE00, 0xC352B100, 0x3D784880, 0xDD7E8FC0, 0x2F44A920, 0x1F9BBB50, 0x956DC808, 0x6D9E6C0C, 0x6C552E06, 0xEEC2F10D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x58000000, 0xFC000000, 0xCE000000, 0x3D000000, 0x1D800000, 0x9D400000, 0xCBA00000, 0xCCF00000, 0x7A780000, 0x31A40000, 0xECA20000, 0xA6730000, 0x25BB8000, 0xE1C4C000, 0xF2336000, 0x6998F000, 0x0774B800, 0x616A3400, 0xBF0E1600, 0x1BCC0500, 0xBF2DD680, 0xAB7C27C0, 0x0D742FE0, 0x9E6AAB90, 0xE98EB808, 0x6A0D340C, 0x624F960E, 0xF06FC503 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x18000000, 0xFC000000, 0xAA000000, 0xC1000000, 0xBE800000, 0x29400000, 0x15E00000, 0xCAF00000, 0x4E280000, 0x41C40000, 0x67620000, 0xB1B10000, 0x36CA8000, 0x77B7C000, 0x250A6000, 0x0D16F000, 0xD91A2800, 0xE24DC400, 0x0F361A00, 0x6F4B9500, 0xD3751F80, 0x3A289FC0, 0x1FC7CAA0, 0xB861B610, 0x7030A808, 0x2E0A0404, 0x62947A0A, 0x06D9650F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x08000000, 0x84000000, 0x76000000, 0xDB000000, 0xF3800000, 0x30400000, 0xC2A00000, 0x2BF00000, 0x5AD80000, 0x7C440000, 0xCD220000, 0xA1B10000, 0x117A8000, 0xF937C000, 0x873A2000, 0x58971000, 0x73495800, 0x300DAC00, 0x68AF6E00, 0x7A5E1100, 0x26077280, 0x3E8393C0, 0x08C31D60, 0x59612C10, 0xA513D808, 0x498A6C04, 0x246D4E0A, 0xB53D010F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x48000000, 0x0C000000, 0xD2000000, 0x5F000000, 0xC2800000, 0xF7C00000, 0x02A00000, 0xF0100000, 0xDA380000, 0x04740000, 0xEA220000, 0x5CD10000, 0x241B8000, 0xBEA4C000, 0xE73B2000, 0x91F53000, 0x3362C800, 0x4BB0BC00, 0xC1A9AA00, 0x5A0F2F00, 0x1CB46280, 0x22018C40, 0xB701AAE0, 0x1E81F2D0, 0x5DC14808, 0x19A07C04, 0xEC908A0E, 0xA0FB1F03 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x7C000000, 0x32000000, 0x89000000, 0x3A800000, 0x10C00000, 0xA0600000, 0x7AB00000, 0xCDF80000, 0xF2D40000, 0x24E20000, 0xA9710000, 0x9A188000, 0xF4244000, 0x96BA2000, 0x7CF4F000, 0x98F24800, 0x615B6400, 0x2A044A00, 0x02ABF300, 0xD8DF6980, 0x12ECBEC0, 0x62D455E0, 0x6CE20C50, 0xF572C808, 0xB81B2404, 0x75246A02, 0xD03A0301 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x38000000, 0x3C000000, 0xFE000000, 0x59000000, 0xE2800000, 0xC2400000, 0xE4600000, 0x90700000, 0xEF680000, 0xB8E40000, 0x57E20000, 0x74B30000, 0xAB4A8000, 0xDBF6C000, 0xAB7AE000, 0x3FFFF000, 0x9C6F7800, 0xD5B6A400, 0xE918EA00, 0xDA8CB900, 0xE786C980, 0xF210F5C0, 0x7A1A5FA0, 0x5B0FC690, 0xFC47F808, 0x21B3640C, 0x4FC88A0A, 0xDCB5890B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x98000000, 0x74000000, 0x9E000000, 0xA5000000, 0x6F800000, 0x71400000, 0xFEE00000, 0xF7900000, 0xCA180000, 0x55A40000, 0x5C620000, 0x75510000, 0x07BB8000, 0x5BD74000, 0xD9686000, 0xBB2CD000, 0xD55FF800, 0xC056D400, 0x762B5E00, 0x00CDD500, 0x9D4D2380, 0xE30EBA40, 0xA96FDE60, 0x353E6F90, 0x87067808, 0xDE909404, 0xDF98BE0E, 0x67E6450D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x88000000, 0xA4000000, 0x56000000, 0x9D000000, 0xA1800000, 0x00C00000, 0x7D200000, 0x83D00000, 0x8D080000, 0xBD7C0000, 0x05A20000, 0xC4930000, 0x85E98000, 0x360DC000, 0xD5B82000, 0xB0C59000, 0x4966D800, 0xE7F6B400, 0xF51C2600, 0x8593D300, 0x9E69CC80, 0x39CC8B40, 0xB21A9A20, 0x87566AF0, 0xBC0D5808, 0xF2B8740C, 0x1E458606, 0x53278307 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xF8000000, 0xE4000000, 0x06000000, 0xD9000000, 0x38800000, 0x43C00000, 0xCFE00000, 0x55700000, 0xD9280000, 0x7F940000, 0x52620000, 0xBC310000, 0x420A8000, 0x88864000, 0xBF79E000, 0xADAE9000, 0x12EC9800, 0x48CE2400, 0x535E8200, 0x93855F00, 0x88FB0780, 0x57EF81C0, 0xD24D2EA0, 0x6F9EBD50, 0x2DE41808, 0x5EC96404, 0xE6E5E20A, 0x31498F09 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xD8000000, 0x8C000000, 0xA2000000, 0xEB000000, 0x1E800000, 0x33400000, 0x41A00000, 0x13700000, 0xC6A80000, 0x277C0000, 0x76220000, 0x65B10000, 0x92CB8000, 0x3AEFC000, 0x98596000, 0xF0173000, 0xB9BF0800, 0xD6436C00, 0x46219A00, 0x1DB2BD00, 0x0ECB2E80, 0xB0EEB1C0, 0x2759D8A0, 0xC09474F0, 0xC3FE8808, 0x6261AC04, 0x78917A0E, 0xA9FB4D0F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x98000000, 0x74000000, 0x8E000000, 0xCF000000, 0xA0800000, 0xFCC00000, 0xC9E00000, 0x53500000, 0x6C180000, 0x68640000, 0xD0620000, 0xC4130000, 0x5FB88000, 0xBD164000, 0xE4486000, 0x5AFED000, 0xA3C4B800, 0x01107C00, 0x563B6200, 0x7254E300, 0x83EB3F80, 0x918EC140, 0xC0EE5A60, 0x4B7C1690, 0xD8863808, 0xC8B13C0C, 0xC2498202, 0x29FF7309 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x18000000, 0xE4000000, 0x52000000, 0x13000000, 0x0C800000, 0x63400000, 0x46A00000, 0x72D00000, 0xEE480000, 0xB8940000, 0x4F220000, 0x0C130000, 0x5C2B8000, 0x6F25C000, 0x585A6000, 0xCBBC9000, 0x7A84C800, 0x06088C00, 0xD6B4D200, 0xECB25D00, 0xC7FAF280, 0x82EDF740, 0x490E9320, 0xF87F0B50, 0xB9654808, 0xFB7A4C0C, 0xD9AF320E, 0x7BAC0D07 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xD8000000, 0xBC000000, 0x3E000000, 0x4F000000, 0xDC800000, 0xF0400000, 0x9CE00000, 0x1A700000, 0x4B280000, 0x0E440000, 0x15620000, 0x5BB30000, 0xFA098000, 0x23144000, 0x90196000, 0xEA0DF000, 0x5D977800, 0xA1587C00, 0x4D6E9200, 0x1F26F100, 0xDCD0AB80, 0x08BA45C0, 0xF69D96A0, 0xA1CF1C10, 0x59B4F808, 0xED8B3C0C, 0x5DD47206, 0x35B84101 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x18000000, 0x74000000, 0x8A000000, 0xE3000000, 0x2A800000, 0x32400000, 0x31600000, 0xC7F00000, 0x78E80000, 0xCCAC0000, 0xEEE20000, 0xAA330000, 0xE4498000, 0xF7FF4000, 0x7D5A6000, 0xED26D000, 0x39BDA800, 0x0A39CC00, 0x87D64A00, 0xCAD5D900, 0x5154CD80, 0xBE95A3C0, 0xCD3571A0, 0xF2E5FFB0, 0x221E2808, 0xE9E98C0C, 0x612FAA06, 0x0423490D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xE8000000, 0xF4000000, 0xC6000000, 0x07000000, 0x0D800000, 0x38C00000, 0x76200000, 0x36900000, 0x0ED80000, 0x442C0000, 0x1EE20000, 0x78B30000, 0x34498000, 0xE0F5C000, 0x87CDA000, 0x5ED2D000, 0xB8B99800, 0x90DC5C00, 0x12C85600, 0xAFB79300, 0xEC2E9080, 0x4AE31E40, 0xAEB13160, 0xAB4A55B0, 0xF1743808, 0x8D0E8C0C, 0xE9F1CE06, 0x84ABCF07 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x98000000, 0x54000000, 0x72000000, 0x95000000, 0x6C800000, 0x6EC00000, 0x46A00000, 0x1C500000, 0xAB780000, 0xAB940000, 0x40620000, 0x86F30000, 0xA92A8000, 0x63EF4000, 0xF8746000, 0x05D05000, 0x19384800, 0x6BF79400, 0x06929200, 0x8FD98B00, 0x1AC70280, 0x039AAD40, 0xA9A42BE0, 0x6EEB7750, 0xE7CC2808, 0x01E7C40C, 0xE78ADA0A, 0xD3BE1F0D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x48000000, 0x6C000000, 0x5E000000, 0xBF000000, 0x11800000, 0x62C00000, 0xB2A00000, 0xFEF00000, 0xD6B80000, 0x7D340000, 0x9C620000, 0xA2530000, 0xAF498000, 0x8E0C4000, 0xF9972000, 0x0190B000, 0x036BF800, 0x3BBF3C00, 0xCB4F2600, 0x4AF41B00, 0x3A428280, 0xC2E2BFC0, 0x491100E0, 0x3B28E9D0, 0xE05CD808, 0x78DF8C0C, 0x689CDE06, 0xCF7F2701 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x28000000, 0xAC000000, 0x12000000, 0x4F000000, 0x8B800000, 0x8CC00000, 0x8CA00000, 0x3D900000, 0xFDA80000, 0x400C0000, 0xA4620000, 0x3F330000, 0x153A8000, 0x2527C000, 0xD92EA000, 0x7833B000, 0x02B9C800, 0x33E47C00, 0x468F4E00, 0xF4212300, 0x90D14A80, 0x66C8C240, 0x1CBF84A0, 0x31990D30, 0x74B76808, 0x9687CC0C, 0x873E860A, 0x05595F0F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x68000000, 0xA4000000, 0x2A000000, 0x75000000, 0x8F800000, 0xA6C00000, 0x57A00000, 0x5CB00000, 0xFF380000, 0xCF8C0000, 0x3B620000, 0x0E130000, 0xF40A8000, 0x4A744000, 0x454FA000, 0x92C39000, 0xD5A12800, 0x2DB31400, 0x4ABBDE00, 0x744DAB00, 0x47416680, 0xDE630EC0, 0x299296E0, 0x56CBDB30, 0x27D68808, 0x04FC840C, 0x4678F60A, 0x96EDBF01 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x78000000, 0x3C000000, 0x76000000, 0x05000000, 0xBF800000, 0x7F400000, 0xCF200000, 0xF8900000, 0xF0880000, 0xAAF40000, 0x0E620000, 0xB6B30000, 0xDD988000, 0x663CC000, 0xA937E000, 0xBC81F000, 0x5DC25800, 0x23E05400, 0x76F3DE00, 0x8638ED00, 0x576E1480, 0x585C2E40, 0x67842820, 0x5D1828D0, 0x4DFDB808, 0x8FD5A40C, 0x75F38602, 0xA4BBB903 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x88000000, 0x74000000, 0x26000000, 0x17000000, 0xBC800000, 0x0B400000, 0x7AA00000, 0x65F00000, 0x6F280000, 0x69740000, 0x63E20000, 0xCE530000, 0x91588000, 0x299C4000, 0x87742000, 0xE0E0D000, 0x64D31800, 0x15189C00, 0x13BC9200, 0xBBC5DD00, 0xC469A280, 0xC3D6D3C0, 0xAE11D2A0, 0xC57A1AD0, 0x562F3808, 0x297C4C0C, 0xD3A58A02, 0x6DFA4101 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x48000000, 0xCC000000, 0x12000000, 0xC1000000, 0xAC800000, 0x5A400000, 0xD1E00000, 0xD0500000, 0x16480000, 0x542C0000, 0x9DA20000, 0xDEB30000, 0xD9998000, 0xE5A64000, 0xA6AF2000, 0xD4E23000, 0x02D2C800, 0x6F08C400, 0x304DD200, 0x3F317900, 0x9D5B3F80, 0x5F058D40, 0xD39DAF20, 0xCCBAABB0, 0x4F55E808, 0xA5D6F40C, 0x08951A06, 0x9AF6BD09 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x88000000, 0xB4000000, 0xC2000000, 0x11000000, 0xC0800000, 0x57400000, 0x0D200000, 0x8C500000, 0xE3F80000, 0xE0E40000, 0xB4620000, 0x0E730000, 0x382A8000, 0x9FDD4000, 0xE3642000, 0xDAA3D000, 0xD0928800, 0xF41B8400, 0xD0546200, 0xDAABAD00, 0xE99EEC80, 0x56C5FD40, 0x6DB089E0, 0xC04A7C90, 0xFFAEA808, 0x944C540C, 0xB2FCEA0A, 0xFF372905 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x98000000, 0xCC000000, 0x46000000, 0x63000000, 0x27800000, 0x4B400000, 0xC3600000, 0x18F00000, 0xB7B80000, 0xE54C0000, 0x47220000, 0x4A130000, 0xFF0B8000, 0x4A14C000, 0x2FDC6000, 0xD6EA3000, 0x29259800, 0x6DC4CC00, 0x2E773E00, 0x12AEFD00, 0x8B136580, 0x698AD7C0, 0x2FD5DCE0, 0x957CAE30, 0x9ABBF808, 0xE5CDFC0C, 0xE9E1260E, 0x8332F103 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x68000000, 0xD4000000, 0x6E000000, 0xCB000000, 0xD0800000, 0x28400000, 0xFE200000, 0x73500000, 0xD3580000, 0x38040000, 0x13620000, 0x26F10000, 0xD0CB8000, 0x193FC000, 0xA017A000, 0x8A985000, 0xA3E73800, 0x01D16C00, 0xA2182200, 0x87A5D100, 0xCDF0D080, 0x504BF940, 0x497FF360, 0x12377B10, 0x2BCA9808, 0x01BC3C04, 0x4C569A0E, 0x82BA7D0F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x38000000, 0x5C000000, 0x16000000, 0x2B000000, 0x78800000, 0x4D400000, 0xB5A00000, 0xC4B00000, 0x51D80000, 0x316C0000, 0x55E20000, 0x0A910000, 0x94A98000, 0xDA54C000, 0x4C9EE000, 0xD39A7000, 0xF64CD800, 0x8113EC00, 0x8D68C200, 0x6CB52500, 0x7A8D3E80, 0x107006C0, 0xACB9F960, 0x3EBD0AB0, 0x70E83808, 0x6E749C04, 0x8CEF9A06, 0x37230903 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x88000000, 0x04000000, 0x22000000, 0x89000000, 0xDD800000, 0x74400000, 0x7C200000, 0xC9100000, 0xF6380000, 0xE43C0000, 0x5B620000, 0x0DB10000, 0x20E88000, 0x8966C000, 0xD2EC2000, 0xE63B1000, 0x9C3D0800, 0xF7626400, 0x9BB29600, 0x03EB6100, 0xD9E7A880, 0x592DA840, 0x67599AE0, 0xF48C3FF0, 0xBC0B2808, 0xF5947404, 0x75A51E02, 0x790EC50B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0xE8000000, 0xC4000000, 0x8E000000, 0xD9000000, 0x91800000, 0xC6400000, 0x10E00000, 0x01500000, 0x4E380000, 0xAD4C0000, 0xEB220000, 0xDDF10000, 0xE88B8000, 0x7AA74000, 0xB795A000, 0x893C1000, 0x41EAB800, 0xD9B6A400, 0x574F2600, 0xC423E900, 0x59704B80, 0x254A8940, 0x1306C2E0, 0x2AA63E30, 0x1F949808, 0xAD3DF404, 0x1FE83E0E, 0xE8B55D0D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xF8000000, 0xCC000000, 0xF2000000, 0xE3000000, 0xBC800000, 0x27400000, 0xB6200000, 0x52500000, 0xAFC80000, 0x61240000, 0x0FE20000, 0x88330000, 0x53388000, 0xCDFEC000, 0x522DE000, 0xD5263000, 0xF1E24800, 0xB932CC00, 0xBCBB5200, 0xAE3E8D00, 0x0F4FC080, 0xC3573D40, 0xEF798920, 0xCB5D2790, 0xF53F2808, 0x9FCE3C0C, 0x8616FA02, 0xF259710B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xB8000000, 0xF4000000, 0x5E000000, 0x5D000000, 0x27800000, 0x9A400000, 0xE1A00000, 0x96300000, 0xAC480000, 0xFF3C0000, 0x9E620000, 0xF2D10000, 0xA3598000, 0x4785C000, 0xDE74E000, 0xAEDCD000, 0xAAF3F800, 0xD2283400, 0x3DEE3E00, 0xE5389900, 0x3156CE80, 0x9B2E04C0, 0x4058E320, 0x0D061FF0, 0xBBB69808, 0x513D2404, 0x3B632606, 0x41517D07 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xB8000000, 0x64000000, 0x52000000, 0x0B000000, 0xF7800000, 0x92C00000, 0x98E00000, 0xC2300000, 0x2DE80000, 0xEDDC0000, 0x72A20000, 0xBD930000, 0x46FA8000, 0x0166C000, 0x6C64E000, 0xAAE49000, 0x08A6C800, 0xCB056C00, 0x86147E00, 0x3BAC7B00, 0x05E91B80, 0x41DE5CC0, 0x5CA33DA0, 0x3091F670, 0x507AA808, 0x0B243C0C, 0xC3C4D60A, 0x69F7470B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x48000000, 0x04000000, 0x02000000, 0x31000000, 0x0B800000, 0xB4C00000, 0xDC200000, 0xE8500000, 0xE6780000, 0xA9EC0000, 0xD0620000, 0x7A330000, 0x8D4B8000, 0xBF25C000, 0xE3872000, 0x09951000, 0x6A8E8800, 0x00D38400, 0x70384E00, 0x168DA300, 0x6ED18880, 0xD7395D40, 0x160CEBE0, 0xAC9356B0, 0xB2582808, 0xA5BC540C, 0x4418660E, 0xAADDF707 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xC8000000, 0x94000000, 0x72000000, 0x3F000000, 0x9A800000, 0x96C00000, 0x16E00000, 0x11D00000, 0x33F80000, 0x57EC0000, 0x23A20000, 0x36730000, 0xAF898000, 0x4B66C000, 0x6C452000, 0xDDF75000, 0x271D4800, 0x3CEABC00, 0x46F50A00, 0xC79E6B00, 0x612B2380, 0x08968340, 0xB78C81E0, 0x4AB0BAB0, 0xAA6BE808, 0x8E342C0C, 0xA07EE206, 0x837A470B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x98000000, 0x64000000, 0x32000000, 0xC9000000, 0xC3800000, 0x40400000, 0x42200000, 0x66D00000, 0x00080000, 0xEC1C0000, 0x6EE20000, 0x04330000, 0xEA3B8000, 0xC926C000, 0xB7446000, 0x05B49000, 0x786E4800, 0x2EFB6400, 0xB7C72E00, 0xBB75B100, 0x438DF080, 0xCF4B0740, 0x9EBF3220, 0xEEF37370, 0xBBDBA808, 0x6596340C, 0xDFBC860E, 0x4173850B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x58000000, 0xAC000000, 0xB6000000, 0x41000000, 0x02800000, 0xEFC00000, 0x25A00000, 0x3F700000, 0xC6380000, 0x35F40000, 0x23E20000, 0x68930000, 0x74A98000, 0xD65E4000, 0x263F6000, 0xFBEFB000, 0xE9265800, 0x93ABC400, 0x0DDDAA00, 0x077DAF00, 0x178EDE80, 0xEAF471C0, 0xC460BEE0, 0xA7D11ED0, 0x75CAB808, 0x610D340C, 0xDF371206, 0x76C09B09 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x88000000, 0x44000000, 0xCE000000, 0x25000000, 0x26800000, 0xF3400000, 0x47E00000, 0x1B700000, 0x01880000, 0x38DC0000, 0xD3720000, 0xE58B0000, 0x26DD8000, 0xCE70C000, 0x0F092000, 0x5F9C9000, 0x6293F800, 0x17F9B400, 0x8BD40A00, 0xEEEC3500, 0x981AAB80, 0x74A767C0, 0xF165B320, 0xBDC488F0, 0x4D540A08, 0x6DAC350C, 0x37FAAB86, 0x9BD767CB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x08000000, 0x3C000000, 0xD6000000, 0xED000000, 0x73800000, 0xF1C00000, 0x73600000, 0x44D00000, 0xD1D80000, 0x1AC40000, 0xBCD20000, 0xA5D90000, 0x50C68000, 0xF7D3C000, 0x33592000, 0xEE867000, 0xA3709800, 0xE9EA9400, 0x080FBE00, 0x99AF5F00, 0x3C9D5980, 0x55D5AD40, 0xBD6B9860, 0x814C7290, 0x2D8FBE08, 0xC56F5F04, 0x9C7D598A, 0x90C5AD47 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x48000000, 0x84000000, 0x3A000000, 0xD3000000, 0x7A800000, 0x96400000, 0xDEE00000, 0x37700000, 0x25C80000, 0xB8240000, 0x4B720000, 0x33CB0000, 0x05248000, 0x60F1C000, 0xC00A2000, 0x89069000, 0xF6212800, 0xA5D16C00, 0xCF5B7A00, 0x681D7100, 0x8CDF1780, 0xA07E27C0, 0xA3EFA620, 0xDA549710, 0xF13B7A08, 0x2A2D710C, 0x65771782, 0xCD6A27CF } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xA8000000, 0xAC000000, 0x36000000, 0x59000000, 0x0D800000, 0x23400000, 0x6C200000, 0x16F00000, 0x2B180000, 0x3F7C0000, 0x60F20000, 0xD21B0000, 0x22FD8000, 0x9BB3C000, 0xBA39A000, 0xAE0F3000, 0xDFAB1800, 0xD1C4C400, 0xE03D0600, 0x42D09500, 0x89E8F480, 0x46669DC0, 0xEC8D9960, 0x78693970, 0x2B250608, 0xCDAC950C, 0x211AF486, 0x487D9DC7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x78000000, 0x44000000, 0x1E000000, 0x0F000000, 0x41800000, 0xA2400000, 0xF4600000, 0xCD900000, 0x7C780000, 0xA7040000, 0x9B920000, 0x6F7B0000, 0x2C878000, 0x20D3C000, 0xE99AE000, 0x58D69000, 0x1B8BB800, 0x39EEDC00, 0x916D9600, 0xF9AE3100, 0x100C8D80, 0xF4BC6040, 0x88B5A0E0, 0x781AC190, 0xD2959608, 0x43EA310C, 0xA67E8D8E, 0xC0176047 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x88000000, 0x1C000000, 0xFA000000, 0x45000000, 0xB3800000, 0xF5400000, 0xA8200000, 0x3A500000, 0xA5080000, 0x6F240000, 0x5C520000, 0xDA0B0000, 0xB9A48000, 0x4A934000, 0x0F692000, 0x37D4F000, 0x2FC8A800, 0x80443400, 0xB7203E00, 0x5CD27D00, 0x4BC91480, 0x7E471740, 0xBC228920, 0x1C517810, 0x3A083E08, 0xC9A67D0C, 0x92931482, 0x9B681745 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x88000000, 0x1C000000, 0x52000000, 0xCF000000, 0xF8800000, 0xFDC00000, 0x3DA00000, 0x37B00000, 0x6F580000, 0x37540000, 0x19B20000, 0x82590000, 0xB8D68000, 0x18F04000, 0x843B2000, 0x33C6F000, 0x25990800, 0x16741C00, 0x25C31200, 0x49A1FF00, 0x49B36A80, 0xEA590CC0, 0x94D52260, 0x52F167D0, 0xDF3B1208, 0x8545FF04, 0x45596A8A, 0x1C540CC9 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xD8000000, 0x0C000000, 0x5E000000, 0x1F000000, 0x97800000, 0xFBC00000, 0xFFE00000, 0x89B00000, 0xC3880000, 0x82C40000, 0x53B20000, 0x868B0000, 0x90468000, 0x1AF0C000, 0x80286000, 0xC756B000, 0x8269B800, 0xC4741C00, 0xCFBAEE00, 0x9B8F5700, 0xB6146380, 0x58CB88C0, 0x05677920, 0x2C23F890, 0xC252EE08, 0x083B570C, 0x684E638A, 0x8DF488CB } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xC8000000, 0x3C000000, 0xB2000000, 0x33000000, 0x6C800000, 0x59400000, 0x8DA00000, 0x77D00000, 0x06A80000, 0x34940000, 0x84D20000, 0x0A290000, 0xBDD48000, 0x3171C000, 0x89FA2000, 0x357C7000, 0x84E70800, 0x52A8EC00, 0x0A94C200, 0xEDD2ED00, 0x99AB1A80, 0xF2173D40, 0xEA9287A0, 0xAD0AC0D0, 0x2E46C208, 0x57FBED04, 0xCC7F9A82, 0x0F66FD4F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xE8000000, 0x5C000000, 0xF6000000, 0xCF000000, 0xD6800000, 0xC9400000, 0x66600000, 0x93500000, 0xC5480000, 0xAC2C0000, 0x36520000, 0xCAC90000, 0x0CEE8000, 0x77F14000, 0x42BAA000, 0x9697F000, 0xB4C69800, 0x040F9C00, 0xD9E3AA00, 0xEB903D00, 0x40E8C580, 0xB65C8740, 0x212B3820, 0xBA7FBD30, 0x6C99AA08, 0x8E253D04, 0xF71C458A, 0x2B48C74D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x98000000, 0x3C000000, 0x52000000, 0x49000000, 0x8B800000, 0x02C00000, 0x88200000, 0xC2300000, 0xF1C80000, 0xF9440000, 0x41B20000, 0x67090000, 0xE7658000, 0xD483C000, 0x9E436000, 0xE2617000, 0xC6508800, 0xF89B4400, 0x355EDE00, 0xDAAF4300, 0xA7C40480, 0xCAF3A6C0, 0x2CEA8C20, 0xF2F7E590, 0x13BB5E08, 0x39EC8304, 0x08276486, 0xD162D6C7 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x38000000, 0x3C000000, 0x52000000, 0x49000000, 0xF6800000, 0x72400000, 0xD8600000, 0x47300000, 0x4E880000, 0xC1540000, 0xDDB20000, 0xE6CB0000, 0xF4368000, 0x7203C000, 0xF903E000, 0x6E827000, 0x3E408800, 0xB261C400, 0x32332A00, 0xEA088100, 0xFA164580, 0xF350C6C0, 0xD3BBF320, 0x62DEE4D0, 0xF465AA08, 0x6A3B410C, 0x491DA58A, 0x17C6B6C7 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x88000000, 0x14000000, 0x6E000000, 0x9B000000, 0x56800000, 0xFB400000, 0x42200000, 0xC6700000, 0xEF980000, 0x4A2C0000, 0x1CF20000, 0x26DB0000, 0x490E8000, 0xE9004000, 0x77812000, 0xF8C2D000, 0xE4E3F800, 0xA1904C00, 0x84890A00, 0x4FE65500, 0xE4356480, 0xC91F43C0, 0xC24BD360, 0xD807E030, 0x37278A08, 0xC0D6150C, 0xC88C448A, 0xD6C193C9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x28000000, 0x54000000, 0xD2000000, 0x1F000000, 0x66800000, 0xD3C00000, 0x81200000, 0xC5F00000, 0x49580000, 0x84CC0000, 0xD5720000, 0x3F990000, 0xC86F8000, 0x07C3C000, 0x1321A000, 0x3AF2D000, 0x5FDA8800, 0x7F0CDC00, 0x0052CA00, 0x28690700, 0x9E35F880, 0xE58D4DC0, 0x1591CA60, 0x844BC7B0, 0x52454A08, 0x3196C704, 0x97BE588E, 0xC7EA9DC7 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x58000000, 0x44000000, 0x76000000, 0xBD000000, 0x59800000, 0xFBC00000, 0x04200000, 0xCD700000, 0x96680000, 0x7FC40000, 0x1EF20000, 0xB2AB0000, 0x21668000, 0xE0C2C000, 0xE8A26000, 0xE3339000, 0x33891800, 0x61979400, 0x936A7600, 0x32453700, 0x5B326480, 0x278993C0, 0xDF9656A0, 0x026A3F90, 0x01C4F608, 0x2FF3F70C, 0xB12A048A, 0x0DA503C3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xD8000000, 0xBC000000, 0x5E000000, 0xAB000000, 0xCE800000, 0xDAC00000, 0x87200000, 0x4EB00000, 0xDF180000, 0x87140000, 0x0B320000, 0xBB5B0000, 0xB2F58000, 0x76A14000, 0x10F06000, 0xA3FB7000, 0xC1063800, 0x1FDBCC00, 0x3936CA00, 0x16019300, 0x6F00F080, 0x9C80E0C0, 0x27C1A760, 0x86A218D0, 0xB8F14A08, 0x77FBD30C, 0x2B051086, 0x8EDAD0CD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xC8000000, 0x54000000, 0x66000000, 0x1D000000, 0xB4800000, 0x49400000, 0x06600000, 0x45F00000, 0x2D680000, 0x528C0000, 0x48720000, 0xBEAB0000, 0xF4AE8000, 0xA963C000, 0x4A702000, 0x6DABD000, 0xD92C5800, 0x8AA15400, 0x84508200, 0xA8BA3D00, 0x83F5AD80, 0x5AA6E5C0, 0x269DC0A0, 0x3C2B4BB0, 0xD8EC0208, 0x2782FD0C, 0x04C30D8A, 0xF5A2F5C7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xE8000000, 0xDC000000, 0xCE000000, 0xC7000000, 0xFF800000, 0x55400000, 0xF4A00000, 0xF9300000, 0x59380000, 0x13FC0000, 0xDFB20000, 0x8CFB0000, 0xE99F8000, 0x0D63C000, 0xE550A000, 0x70E8F000, 0x3BD6F800, 0x3C86BC00, 0x6D6D8E00, 0x5238ED00, 0x7A7D8E80, 0x99F3FAC0, 0xE5DA21E0, 0xA4EFF570, 0x44780E08, 0x6B5C2D0C, 0x9080AE8E, 0x56C3CAC7 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xB8000000, 0xCC000000, 0x7A000000, 0x3F000000, 0xC3800000, 0x09400000, 0x06E00000, 0xEBB00000, 0xCBA80000, 0xF8A40000, 0x21320000, 0x04690000, 0x2B848000, 0x96A04000, 0x93D3E000, 0x39DBB000, 0x152FA800, 0xBA841C00, 0x0C233E00, 0x84104D00, 0x96FA2780, 0xF0BC00C0, 0x663CDBA0, 0x6BFE2110, 0x4BDDBE08, 0x45CD0D04, 0xE4374782, 0x330AF0C9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x18000000, 0x4C000000, 0x1A000000, 0x93000000, 0xE2800000, 0xD5C00000, 0xA5200000, 0x0BD00000, 0x9D980000, 0xAF3C0000, 0x2A120000, 0xBEB90000, 0x15EC8000, 0x1A084000, 0x24C56000, 0x901FB000, 0xF2C12800, 0xE1A3AC00, 0xFF107A00, 0x8D391F00, 0xDDAD8880, 0x0268FD40, 0xD4F60560, 0x0DF76E70, 0x04751A08, 0xCF36AF04, 0x2DD4A082, 0x44275149 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xB8000000, 0x0C000000, 0xAE000000, 0x9B000000, 0xC8800000, 0xF5400000, 0x4BE00000, 0xD5500000, 0x1F180000, 0x65240000, 0x62120000, 0x71FB0000, 0x3BF58000, 0x9CC94000, 0xBC7DE000, 0x5057B000, 0x41F8F800, 0x93F60C00, 0x48CBD200, 0xCE7FCD00, 0xDD561380, 0x1E78BF40, 0x00371D60, 0x6D690510, 0x984E3208, 0xE25C7D0C, 0x2FA4EB86, 0xD251B34D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0xE8000000, 0xBC000000, 0xBE000000, 0x7B000000, 0xD2800000, 0x58400000, 0xE9600000, 0xA3100000, 0x50480000, 0xDC0C0000, 0xC1520000, 0xC82B0000, 0x649C8000, 0xA6D84000, 0x5884A000, 0x677C7000, 0xE989B800, 0x53ADCC00, 0xA5617A00, 0x85117900, 0xCF4B9980, 0x748F8E40, 0x08129420, 0x8ACB83B0, 0x884DDA08, 0xEE31090C, 0x44382182, 0xE4554249 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xC8000000, 0x9C000000, 0x3A000000, 0x6F000000, 0x3E800000, 0x88400000, 0xBAA00000, 0x94300000, 0xC6C80000, 0x628C0000, 0xF3720000, 0x02E90000, 0xDEFE8000, 0x5F194000, 0x3C562000, 0x7746F000, 0x057CA800, 0x7EDB1C00, 0x14364A00, 0x6F962900, 0xEC264680, 0xB92E92C0, 0xA0C0DE20, 0x9FE12EB0, 0x5B126A08, 0x5A39D904, 0x97A46E8A, 0x48ECCECD } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x68000000, 0x7C000000, 0xAE000000, 0x4B000000, 0x0D800000, 0x62400000, 0x73200000, 0xE4700000, 0x68780000, 0xFF740000, 0xED320000, 0x06DB0000, 0xC1458000, 0x5268C000, 0xA7DEA000, 0xDD0E7000, 0x43457800, 0xAF680C00, 0x955D8600, 0xD0CFD100, 0xDF277080, 0x02B9CFC0, 0xD8960CE0, 0x1DA17350, 0x57B12608, 0x071AA10C, 0xFB278886, 0x78B903CB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x98000000, 0x4C000000, 0x0E000000, 0x81000000, 0x6F800000, 0xB2C00000, 0x36200000, 0x65B00000, 0x8B780000, 0x2E1C0000, 0x06720000, 0xAAD90000, 0x856E8000, 0xBD284000, 0xB4776000, 0x25E5B000, 0x042D7800, 0xEFC9E400, 0x8AE54E00, 0x3AAE5300, 0x0A88CC80, 0xD204C0C0, 0xFF3D2AE0, 0x2940C2F0, 0x16E02E08, 0xE492E304, 0xDC4B348A, 0xEE2564C9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xF8000000, 0x34000000, 0x62000000, 0x21000000, 0x2C800000, 0x0AC00000, 0xBF200000, 0x2D500000, 0x77080000, 0x358C0000, 0xF2920000, 0x26A90000, 0xC31F8000, 0xFE3A4000, 0xF8B6E000, 0xAFA55000, 0x834EC800, 0xB3B3E400, 0x64FAA200, 0xFF958300, 0x56F70880, 0x8645BF40, 0x5F3CAB20, 0x8EEB54B0, 0xB1FE4208, 0x0BC9D304, 0x79AE408E, 0xDA401B41 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x08000000, 0x6C000000, 0x5A000000, 0x09000000, 0x9A800000, 0xDAC00000, 0x52600000, 0xA6500000, 0x11480000, 0x6E740000, 0x9F920000, 0x98A90000, 0x04678000, 0x6C7AC000, 0x03ED2000, 0xDA6C3000, 0x0B2EA800, 0xAD0C8400, 0x8DFF9A00, 0x5F866300, 0x2368BD80, 0xD0864B40, 0xA2EAB220, 0x15C78650, 0xDAC8BA08, 0x3A375304, 0xC933958E, 0x63990F43 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x68000000, 0x94000000, 0x7A000000, 0x13000000, 0x3E800000, 0xAAC00000, 0x99600000, 0x8CF00000, 0x2D780000, 0x91EC0000, 0xB7320000, 0xD5990000, 0xEF5F8000, 0xA4E9C000, 0x6E64A000, 0xEAA7D000, 0xBAC52800, 0x0BB56C00, 0x2A8DEA00, 0x74C1A300, 0x38609980, 0x257091C0, 0x5B3B8AE0, 0x4D4E8C30, 0x72234A08, 0xB7D37304, 0xE728318E, 0x9A853DCF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x98000000, 0x1C000000, 0x8E000000, 0x15000000, 0xE8800000, 0xA1400000, 0xEBA00000, 0x36900000, 0xE7680000, 0x1DE40000, 0x78D20000, 0x3B4B0000, 0x45B68000, 0xD6DBC000, 0x3F5D6000, 0x52FCF000, 0xE56EF800, 0x3085B400, 0xE3219200, 0x87D29D00, 0x44CAAA80, 0xDF769040, 0x95BB64A0, 0xA1AD6710, 0x4EE6F208, 0xB1516D0C, 0xD888D28A, 0xF857E447 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x58000000, 0x8C000000, 0x9E000000, 0x3D000000, 0x27800000, 0x0E400000, 0xC8600000, 0xE8700000, 0xC5980000, 0xFFCC0000, 0x75B20000, 0x41BB0000, 0xB4DC8000, 0x26D8C000, 0x182E6000, 0xD780B000, 0xB643B800, 0xD4611400, 0x9E706E00, 0x2C9B2100, 0xCA4DE580, 0xD8F347C0, 0x9358DB60, 0x756CC0B0, 0x25628E08, 0xC7F3510C, 0x8FD83D82, 0xCDAEE3CB } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xE8000000, 0xE4000000, 0xAA000000, 0x15000000, 0x66800000, 0x09400000, 0xFFA00000, 0x2AB00000, 0x99280000, 0x807C0000, 0x7F720000, 0xD2C90000, 0x37EF8000, 0x7FAA4000, 0xC93EA000, 0x60D21000, 0xE87BE800, 0x46C47400, 0x1BD44A00, 0x1C4E2D00, 0xA718BA80, 0xB91558C0, 0x302C75A0, 0x2D4B1570, 0x562D6A08, 0xD64A7D04, 0x7FAFF28E, 0x548A3CC1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xF8000000, 0x7C000000, 0x82000000, 0x83000000, 0x81800000, 0x85C00000, 0x78E00000, 0xF6700000, 0x51680000, 0x20A40000, 0x98320000, 0x4B490000, 0xA1B68000, 0x93E94000, 0xC4E6E000, 0x15117000, 0xEDD84800, 0x82AF6C00, 0x1C26B600, 0x7D70FF00, 0xC4E99F80, 0x036617C0, 0x4DD3FEA0, 0xC5B87710, 0x0B9ED608, 0x4DECCF04, 0xD485378A, 0x00210BCD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xD8000000, 0xF4000000, 0x4E000000, 0xF3000000, 0x67800000, 0x0A400000, 0xEEA00000, 0xCCF00000, 0x29980000, 0x486C0000, 0x4B320000, 0x08790000, 0x7ABF8000, 0xC5984000, 0x526E6000, 0x86325000, 0xD4FA7800, 0x3B7F2C00, 0x9B7A0E00, 0xCD3F7100, 0xF7DA2680, 0xD8CCD5C0, 0xDCC1A360, 0xFA639530, 0x5A93EE08, 0x29096104, 0x4C643E8E, 0x4BD4A9C9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x58000000, 0xFC000000, 0xD2000000, 0x13000000, 0x54800000, 0x17C00000, 0x60A00000, 0xC6700000, 0x3A680000, 0x1C140000, 0x1B320000, 0x440B0000, 0x39458000, 0xDA6B4000, 0x8C166000, 0x23307000, 0xE8090800, 0xB344AC00, 0x3569E200, 0x0A957700, 0x27F1BE80, 0xDC2B43C0, 0x62F41AA0, 0x6FA010D0, 0xD0F20208, 0x06AA470C, 0x8434D686, 0x40809FC5 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x68000000, 0x84000000, 0xD6000000, 0xC5000000, 0x4C800000, 0xC6C00000, 0xB8A00000, 0x06900000, 0x9B280000, 0x0F7C0000, 0xF6D20000, 0xD24B0000, 0x7ECD8000, 0xBC29C000, 0x98FEA000, 0xAD919000, 0xAEAB9800, 0x2F3F3400, 0x87B2E200, 0xDFFAE300, 0xFE366680, 0x099FB040, 0x9022C3A0, 0x26537D70, 0xEE89C208, 0x316EB30C, 0x15395E86, 0x2496144F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x58000000, 0x94000000, 0x2E000000, 0x95000000, 0x62800000, 0x00C00000, 0x81600000, 0xF1100000, 0x11480000, 0x108C0000, 0x41520000, 0x27EB0000, 0xCD7F8000, 0xC848C000, 0x080E6000, 0x1A93D000, 0xE1097800, 0x062CB400, 0xCCA31A00, 0x46F2DB00, 0x2E998180, 0xA5A43640, 0x9A4D7220, 0xE3309DB0, 0x557AFA08, 0x2075CB0C, 0x9464998E, 0xCFAC524B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x88000000, 0x74000000, 0xB2000000, 0xBD000000, 0x60800000, 0x0EC00000, 0xB8A00000, 0xDBD00000, 0x50280000, 0x78EC0000, 0xA8920000, 0x76CB0000, 0xBD5C8000, 0xDFCAC000, 0xBFDD2000, 0xF40B5000, 0xABFD0800, 0x6F1A5400, 0x38779200, 0xA3A65300, 0x138C0680, 0x7B638540, 0x6BF11FA0, 0xE13A2B30, 0x9A643208, 0x4AACC30C, 0x28F0AE82, 0xB2B84143 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xB8000000, 0x0C000000, 0x32000000, 0xA3000000, 0xEA800000, 0x4C400000, 0xDFE00000, 0xD4100000, 0xBFE80000, 0x7EDC0000, 0x89D20000, 0x3AC90000, 0x036C8000, 0xBAC84000, 0x436FE000, 0x9ACAB000, 0xD36F8800, 0x22CAEC00, 0xDF6CDA00, 0x10C99900, 0x7C6E8380, 0xFA485240, 0x302E32A0, 0x25A986F0, 0xE43DBA08, 0x9A426904, 0x9AE26B82, 0x13904E49 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x38000000, 0xA4000000, 0x26000000, 0x65000000, 0x59800000, 0x79C00000, 0x85E00000, 0xAC900000, 0xFB580000, 0x4FBC0000, 0xCDD20000, 0xB8FB0000, 0xDA0E8000, 0x367BC000, 0xE14FE000, 0x82DA1000, 0x867E5800, 0xD031F400, 0xC0693600, 0x3F571F00, 0xB8C6D380, 0x531EAC40, 0x26E28E60, 0x80129770, 0x331A5608, 0x5F9DCF0C, 0x5EA1EB8A, 0x08328847 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x08000000, 0x54000000, 0xCA000000, 0x67000000, 0xAE800000, 0x15400000, 0xE6200000, 0x40900000, 0x8BC80000, 0x37AC0000, 0x98520000, 0xB4290000, 0xC75F8000, 0x49A84000, 0x669D2000, 0x35C8D000, 0xAAAC6800, 0x29D03C00, 0xC3E8AA00, 0xA23CDD00, 0x161B1480, 0xAE45B040, 0x556F3620, 0x58B39430, 0xB6580A08, 0x9DE54D04, 0xD03DDC8E, 0x1D191C49 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xB8000000, 0xF4000000, 0x4E000000, 0x1B000000, 0xEF800000, 0x03400000, 0x05A00000, 0x55B00000, 0xF6C80000, 0xA6340000, 0xBE720000, 0x5DA90000, 0x34658000, 0x72294000, 0x1727E000, 0xC7885000, 0x2A977800, 0x7D410C00, 0x36A22E00, 0x96325500, 0x9F88EA80, 0x4E9530C0, 0xEB426A20, 0x09A10850, 0x8FB24E08, 0x73CA4504, 0xEAB5F286, 0xA6B12CCD } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x88000000, 0xF4000000, 0x8E000000, 0x37000000, 0xB1800000, 0x18C00000, 0xD3E00000, 0xBED00000, 0x1A380000, 0x0EFC0000, 0xFE920000, 0x3F990000, 0x0E8E8000, 0x07584000, 0x0D6F2000, 0x918B5000, 0x73557800, 0x99767C00, 0x4EC45600, 0x996DFB00, 0x6F8B8380, 0xFC55E540, 0xC4F7E7E0, 0xA4073A70, 0x078FF608, 0xD9DBEB04, 0x782D5B8A, 0xB0A98949 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0x6C000000, 0xAE000000, 0xDD000000, 0xA3800000, 0x3C400000, 0x39A00000, 0xC6900000, 0xB9680000, 0x81AC0000, 0xDA520000, 0xAA090000, 0xD55D8000, 0x724A4000, 0x26FDE000, 0xE3DA3000, 0x0B17F800, 0xDAB41400, 0x68247E00, 0x634C2900, 0xB9E0E280, 0x49330C40, 0xBEF9F0A0, 0x1D47C630, 0xEEBE1E08, 0x28795904, 0xF6857A86, 0x595E6841 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x28000000, 0xA4000000, 0xDE000000, 0xF5000000, 0xDF800000, 0x41C00000, 0xAA600000, 0x6E700000, 0xC5D80000, 0x346C0000, 0x93320000, 0xF0FB0000, 0x783F8000, 0x12384000, 0xECDFA000, 0x640B1000, 0x2BA63800, 0x19F6F400, 0xDDFEAE00, 0x46585F00, 0x07AD2D80, 0xC652DFC0, 0xD20AB460, 0x5AA7CE30, 0x68748E08, 0xD13C0F0C, 0xBFB9358E, 0x521C7BC9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x78000000, 0x2C000000, 0x1E000000, 0xA9000000, 0xD6800000, 0x25400000, 0xF5A00000, 0x9AD00000, 0xF1A80000, 0x270C0000, 0x56120000, 0x7ACB0000, 0x41BD8000, 0xDE894000, 0xF69EE000, 0x331B3000, 0x95943800, 0x8944C400, 0xEDEDAA00, 0x1A618D00, 0x3C300280, 0x03DA6940, 0x78F7E7A0, 0x6AF738B0, 0xADF4CA08, 0x1A74FD0C, 0x6DB55A86, 0xF757DD4D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x78000000, 0xBC000000, 0x32000000, 0x21000000, 0xEA800000, 0xAF400000, 0x60A00000, 0xABB00000, 0x2FE80000, 0xE4A40000, 0xB9720000, 0xE5890000, 0xD9768000, 0xC949C000, 0xD814E000, 0x731A7000, 0xA7EE0800, 0x1C65E400, 0x1E119A00, 0x78D81500, 0x9B0EB680, 0x4CF5ECC0, 0x578A96A0, 0xB8740210, 0x83C9FA08, 0x8756A504, 0x6BB8DE8A, 0xB05EB8CF } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x98000000, 0xE4000000, 0x4A000000, 0x4B000000, 0xD3800000, 0x02C00000, 0x55A00000, 0x9B700000, 0x37980000, 0x89740000, 0x27320000, 0x2E7B0000, 0x03E48000, 0xC63B4000, 0xB8056000, 0x2BA91000, 0xBC8F6800, 0x5A15CC00, 0x13E09E00, 0x2190C300, 0x428A2A80, 0x5CBF2BC0, 0x01EE0960, 0x4FC78550, 0xD48B7E08, 0x29BD930C, 0x6B6EA282, 0x6187B7C5 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x98000000, 0xA4000000, 0x86000000, 0x63000000, 0xA6800000, 0xF7C00000, 0x77200000, 0xC9500000, 0x1D580000, 0x41940000, 0x6E720000, 0x8C0B0000, 0xD8CC8000, 0xF9E74000, 0x197B6000, 0x56451000, 0x50E9D800, 0xF4BDAC00, 0x20ECEA00, 0xEC371700, 0x92E1A880, 0x73706340, 0x5D888860, 0xE78F39D0, 0x76053208, 0xBB8ABB0C, 0x348D4282, 0x38877445 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x58000000, 0x9C000000, 0x32000000, 0x01000000, 0x4F800000, 0xA9C00000, 0x3A200000, 0x64B00000, 0xB5380000, 0x27A40000, 0x56920000, 0x258B0000, 0x449C8000, 0x2E35C000, 0x57986000, 0x1A55F000, 0x84C98800, 0x8FFDA400, 0xE9E4AE00, 0xC172DF00, 0xF51AC480, 0x561598C0, 0xAA2925E0, 0x5CEEC510, 0xC8AD2608, 0xBA4F7B0C, 0x7B5E6A82, 0xAB1747CF } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x28000000, 0x94000000, 0x4A000000, 0x07000000, 0x32800000, 0xAFC00000, 0x1D600000, 0x01700000, 0x45080000, 0xC7FC0000, 0x70120000, 0xE2790000, 0x63F68000, 0xC46CC000, 0xFE2BA000, 0xD8ADD000, 0x6BCB6800, 0xF91F7C00, 0x2522BA00, 0xF2520700, 0x9E5B6180, 0xAE2443C0, 0x6074E920, 0x602C9970, 0x2309D208, 0xC6FD7B04, 0x1391DB8A, 0x163A44CB } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x58000000, 0x5C000000, 0x8E000000, 0xD7000000, 0x16800000, 0x43400000, 0xC0600000, 0xE2900000, 0xB4680000, 0x6BA40000, 0x8CF20000, 0x11F90000, 0x414F8000, 0x9016C000, 0xD76A6000, 0xB727F000, 0x2AB37800, 0xAE1BFC00, 0x791FCA00, 0xEDDC8500, 0x537C0580, 0x7A4D7C40, 0x1095FEA0, 0xFF29DE10, 0xDFC4B208, 0x04637904, 0x9091CF8E, 0x3D68F943 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xD8000000, 0x84000000, 0xD2000000, 0x6D000000, 0x66800000, 0xA3400000, 0x66A00000, 0x1B300000, 0x21F80000, 0x26FC0000, 0x1F920000, 0xEFCB0000, 0xB5868000, 0x602DC000, 0xA7FA6000, 0x71FF9000, 0xE8100800, 0x8C0A1400, 0x17666A00, 0x923E1500, 0x8AF10680, 0xDE1BD2C0, 0xCA6D98E0, 0xE5D89870, 0x2C8E6208, 0x65C8010C, 0x9C856C8A, 0x74AEC7CF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0x9C000000, 0x6A000000, 0xD5000000, 0x14800000, 0x60400000, 0xB2200000, 0x01900000, 0xAD880000, 0xC3AC0000, 0x61B20000, 0xF5190000, 0x28A58000, 0xDB5F4000, 0x000A6000, 0xF56EF000, 0x92D36800, 0xAC2A7400, 0x9FFEC200, 0x30D91900, 0x68445480, 0xDFAEF040, 0x4BB08D20, 0x401AF330, 0x6C25AA08, 0xE31F6D04, 0x2E289686, 0x9EFEE945 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xE8000000, 0xC4000000, 0x1A000000, 0xFD000000, 0xFC800000, 0x65C00000, 0x7B200000, 0xA0900000, 0xD2380000, 0x4A640000, 0x3DB20000, 0x89AB0000, 0x0FDE8000, 0x3D95C000, 0x597AA000, 0xFD869000, 0xB8832800, 0xBFC09400, 0x2621C200, 0xAC112F00, 0x5FF9D080, 0xF5459440, 0x872345E0, 0xA691A610, 0xB93AEA08, 0x65E5BB0C, 0xABF2128A, 0x52CBBB4F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xE8000000, 0x44000000, 0x8A000000, 0x2F000000, 0x0C800000, 0xCCC00000, 0x8F200000, 0x9AF00000, 0x24F80000, 0x343C0000, 0xAAD20000, 0x2A890000, 0x50048000, 0xEFCEC000, 0x57A8A000, 0x39F49000, 0xC1B46800, 0x7E54DC00, 0x5D850200, 0xDA8F4B00, 0xCFC84880, 0x706515C0, 0x1A5D4AE0, 0x9A423B70, 0xD4E36A08, 0xA5529704, 0x64C9CA82, 0x96E49EC3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0xC8000000, 0xF4000000, 0x56000000, 0x37000000, 0x8B800000, 0x90C00000, 0x2D200000, 0x16300000, 0xBEA80000, 0x311C0000, 0x58120000, 0x451B0000, 0xC0748000, 0xCBADC000, 0x05FA2000, 0xD5E45000, 0xF1741800, 0x8F2D3C00, 0x02BB5E00, 0x3A048B00, 0x63675080, 0x6F349AC0, 0xC04EBFA0, 0xD9EA27F0, 0xCEFD4608, 0xD202B70C, 0x69008E82, 0x6881D1CF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x18000000, 0xEC000000, 0xFA000000, 0x65000000, 0xE1800000, 0x7BC00000, 0xD5E00000, 0xD7300000, 0x71480000, 0xF36C0000, 0x03D20000, 0x39FB0000, 0x32E68000, 0x07DCC000, 0xF0596000, 0xBCF63000, 0xA4C5A800, 0x990E3400, 0x1423D600, 0x07D2F700, 0x57F90B80, 0x51E45EC0, 0xD15D9420, 0xFB19B930, 0xE5547E08, 0x42D7C30C, 0x6E145D8A, 0xDB7669CB } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xC8000000, 0xF4000000, 0x62000000, 0xDB000000, 0x0B800000, 0xC6C00000, 0x3C200000, 0xE1900000, 0x73580000, 0xF0EC0000, 0xC4B20000, 0x324B0000, 0xA6F48000, 0x8ABCC000, 0x814A2000, 0x29745000, 0xC67DC800, 0x226B8C00, 0x69675E00, 0x5CE50300, 0x8726F480, 0x5185B440, 0x2A57E060, 0xF66EAC30, 0x50F09608, 0x88298F0C, 0xCE072A82, 0xDE97774B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x48000000, 0xEC000000, 0x62000000, 0xE9000000, 0xAC800000, 0x23C00000, 0x16A00000, 0xE0300000, 0x5F080000, 0x130C0000, 0xB5920000, 0xD6BB0000, 0x41478000, 0x2AFF4000, 0x71382000, 0xE7073000, 0x531D4800, 0xF46AC400, 0x069CA200, 0x132A7700, 0x6FFD1680, 0x9FB986C0, 0x9DC73920, 0xF13E15B0, 0x939BEA08, 0xC137B30C, 0x6B14348E, 0xC0E7B1C5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x48000000, 0x7C000000, 0x4E000000, 0x89000000, 0x82800000, 0xE5C00000, 0xAAE00000, 0xC4900000, 0x91980000, 0x5BCC0000, 0x41720000, 0xD28B0000, 0x9B178000, 0x389D4000, 0x05082000, 0x42557000, 0x86BFF800, 0x0DF94400, 0x889E5A00, 0x5D099F00, 0x9654D780, 0x64BE6C40, 0x82F95360, 0xFF1EEFB0, 0x744BA208, 0x5077DB0C, 0x884F0D8E, 0x3231B34D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xD8000000, 0xAC000000, 0xBE000000, 0x41000000, 0x96800000, 0xE4C00000, 0x03E00000, 0x1C300000, 0xF1F80000, 0x71B40000, 0x9CD20000, 0x2C490000, 0xA70D8000, 0xBEC6C000, 0x6C886000, 0x1EEE3000, 0x49F5B800, 0x68F1A400, 0x3A1B0A00, 0x49869B00, 0x972A5380, 0xD6FFFEC0, 0xFE5DC6E0, 0x1FCE6650, 0xFB24B208, 0xCDBA3F04, 0x2F96D986, 0xE982A5C3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xB8000000, 0x94000000, 0x6A000000, 0x1F000000, 0x65800000, 0x71400000, 0x08E00000, 0x63100000, 0xBBD80000, 0xFFC40000, 0x86720000, 0x358B0000, 0x7AFC8000, 0x13A74000, 0x34A3E000, 0x4571D000, 0x86086800, 0x72BFDC00, 0xCFC72600, 0x8E733D00, 0x698A7780, 0x6CFDA640, 0x4AA71C60, 0xB023A990, 0x24B3CE08, 0x852BA10C, 0x0D8EB182, 0x6EAF4B45 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x78000000, 0xBC000000, 0xB6000000, 0xE3000000, 0x94800000, 0x0B400000, 0xB0E00000, 0xE3F00000, 0xF4180000, 0xDAFC0000, 0x83920000, 0x56A90000, 0x6B068000, 0xDD1E4000, 0xC6E2E000, 0xE0F17000, 0xD0981800, 0xB9BE2C00, 0xF7734200, 0xBF590500, 0xCA1D1780, 0x706011C0, 0xDAB14F60, 0x0DF9F570, 0xE88DDA08, 0x73496904, 0x1F74B58A, 0x06C464C1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xE8000000, 0x6C000000, 0xBA000000, 0x79000000, 0x54800000, 0x11400000, 0xAA200000, 0xB5B00000, 0x3A580000, 0x6DA40000, 0x51120000, 0xB7A90000, 0x615C8000, 0xE4464000, 0x24C0A000, 0x1BE03000, 0x00D22800, 0x72CA0400, 0xF1CF4200, 0xEC2D1D00, 0xA7FEA480, 0xA4B5E0C0, 0x52BA3E60, 0xF8F53B10, 0xC219EA08, 0x3B055904, 0xB9E34682, 0x8DD1CDC1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0xB8000000, 0xD4000000, 0x9A000000, 0x29000000, 0x0C800000, 0xDA400000, 0xA6A00000, 0xF3100000, 0x65380000, 0x1BAC0000, 0xD3320000, 0x4D6B0000, 0xE8B48000, 0x67CFC000, 0x82C3E000, 0x26E0D000, 0x5CB32800, 0xEAAB8400, 0x1CD58200, 0xBA3C5100, 0xF7495680, 0xE9E4DA40, 0x98558FE0, 0xEC7FBD30, 0x4FEA2A08, 0x61F4150C, 0xB4ED3482, 0x6F135B47 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xF8000000, 0x6C000000, 0xAE000000, 0x51000000, 0x53800000, 0x55C00000, 0xF7A00000, 0x9C300000, 0xF2280000, 0xF60C0000, 0xEE120000, 0x46D90000, 0x2E048000, 0xF0EFC000, 0x06C0E000, 0x3B203000, 0x9B73F800, 0x8BCB6400, 0x5C5F1E00, 0xB5A85F00, 0x21CD2280, 0xC6B0FAC0, 0xA86B11A0, 0x226E31B0, 0xC8806608, 0x2D40FB04, 0x42E0DC82, 0xE2D195C7 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x08000000, 0x44000000, 0xC2000000, 0x25000000, 0x28800000, 0xA1400000, 0x91E00000, 0xDDB00000, 0xF2C80000, 0xA7AC0000, 0xCAD20000, 0x3D3B0000, 0xA3068000, 0x880D4000, 0xD7012000, 0xB5809000, 0xB5C2C800, 0x6EA3F400, 0xE7519200, 0xA4F89D00, 0x3BA5DB80, 0x505D40C0, 0x3278EC20, 0x81E7DC30, 0x323DDA08, 0x1D0A290C, 0xC00F698A, 0xF3024DCD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x48000000, 0x44000000, 0x3E000000, 0x37000000, 0x4B800000, 0x73C00000, 0x82200000, 0x8FF00000, 0x7D780000, 0x3A640000, 0x01520000, 0x72C90000, 0x0AFF8000, 0x54E74000, 0x84122000, 0x39AB9000, 0x546E3800, 0x2E0EBC00, 0xF01E1E00, 0x30B4A700, 0xE05BEC80, 0xAA152DC0, 0x99E9E4E0, 0xE98FA610, 0xB9DDA608, 0x5B945B04, 0x4328528E, 0xA72D5AC5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xF8000000, 0x24000000, 0xA2000000, 0xD5000000, 0x2F800000, 0x35C00000, 0xFDE00000, 0x85100000, 0x86580000, 0x2F340000, 0xF6720000, 0xB3090000, 0x084D8000, 0xB834C000, 0xFCF0E000, 0x31481000, 0x546DC800, 0x9AC47400, 0x0EB8CE00, 0x15A64F00, 0x6DEB6B80, 0x0DDDDE40, 0x052E8060, 0xDE644450, 0x830A8608, 0xB04FFB04, 0xFC36C586, 0xEEF3414B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xC8000000, 0x64000000, 0xE6000000, 0xE5000000, 0x32800000, 0x6E400000, 0x61E00000, 0x6C100000, 0xF7080000, 0x251C0000, 0xB6720000, 0x25D90000, 0xCEB48000, 0xB11EC000, 0xF8702000, 0xB4D81000, 0xE237D800, 0x965E7400, 0x29117A00, 0xB58A3100, 0xA35DCB80, 0x83930E40, 0x67C91F20, 0xB8BE22F0, 0x40802208, 0xC5438504, 0xC2601182, 0x2ED3EF43 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x18000000, 0x4C000000, 0x92000000, 0x23000000, 0xBD800000, 0x7B400000, 0xA6A00000, 0x66F00000, 0x00680000, 0x03140000, 0x4CD20000, 0xC3590000, 0xC31E8000, 0x64D44000, 0x57B36000, 0x29CAB000, 0x7A668800, 0x9CF8AC00, 0x8F6EA600, 0x4C7E1500, 0xB0451E80, 0x6FCA01C0, 0xC767EAA0, 0x307B93D0, 0xFAACAE08, 0x341FF904, 0x4754588A, 0x3DF3E4C9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x18000000, 0xDC000000, 0xC6000000, 0x2B000000, 0x8C800000, 0x02400000, 0x09200000, 0x9AD00000, 0xFFB80000, 0xACBC0000, 0x66720000, 0x62A90000, 0x95E78000, 0xB2FC4000, 0x09536000, 0xA379F000, 0x6EDED800, 0xD8008C00, 0x7C002200, 0xB603E100, 0xA301D080, 0x48809540, 0x1842B5E0, 0xE4218770, 0x3D537A08, 0x717A2D04, 0xA7DF128E, 0xF583C449 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0xC8000000, 0x4C000000, 0x36000000, 0xC3000000, 0xEA800000, 0x2BC00000, 0x2C600000, 0x74500000, 0xE2B80000, 0xF0440000, 0xF3F20000, 0x7A8B0000, 0x86AF8000, 0x310D4000, 0xB13E2000, 0x43D7B000, 0xFB291800, 0xC59FEC00, 0x29677A00, 0x22002700, 0x5101F580, 0x63805F40, 0x2C433BE0, 0xAA216990, 0xE3704208, 0x64487B0C, 0x634F978E, 0x541F944D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x78000000, 0x4C000000, 0xE6000000, 0x1F000000, 0xCE800000, 0xD0C00000, 0x57200000, 0x36F00000, 0xCB980000, 0xD2640000, 0x29120000, 0x16490000, 0xD10D8000, 0xD3ECC000, 0xBDBEE000, 0x6D97B000, 0x6B0BD800, 0x466FDC00, 0x51FEAA00, 0x8F75CB00, 0xF558E880, 0x8E4775C0, 0xAB601360, 0x3C110010, 0xB1CB9208, 0x784DA704, 0x1E8D9A86, 0xDEAD62CB } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x18000000, 0xF4000000, 0xD2000000, 0xC9000000, 0x4B800000, 0xB8C00000, 0x06200000, 0xF7B00000, 0x50680000, 0x339C0000, 0x85520000, 0xD7FB0000, 0x07458000, 0x7825C000, 0xAC756000, 0x040F5000, 0x09880800, 0x4E8E0400, 0x46CADE00, 0x5E6EDB00, 0xB0584480, 0x45358CC0, 0xCFED00A0, 0x1D992FF0, 0x5697B608, 0x9F9F8F0C, 0x03529286, 0x5CF953CF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xB8000000, 0x14000000, 0x16000000, 0xD7000000, 0x09800000, 0x93C00000, 0x3FA00000, 0xB4700000, 0x32F80000, 0x449C0000, 0x4E120000, 0x0E2B0000, 0x1B968000, 0x63B7C000, 0x9707E000, 0xEDDFD000, 0x85F21800, 0x7539FC00, 0xCD3DD600, 0x5D636700, 0x8D524A80, 0xD8CB23C0, 0x040466E0, 0xFA5C39F0, 0xCD302E08, 0x31194B0C, 0x938F848A, 0x9ABAB8C7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xC8000000, 0x04000000, 0xDA000000, 0x05000000, 0xB5800000, 0x88400000, 0xDA200000, 0x1F700000, 0x19D80000, 0x49140000, 0x27120000, 0xD18B0000, 0x9E3D8000, 0x159EC000, 0xA8AE2000, 0xC6549000, 0x11B32800, 0xB5397400, 0xF684A600, 0x3F58B900, 0x6FD42480, 0x7FF247C0, 0x1C182C60, 0xB7740FD0, 0x0C41AE08, 0xC0215D0C, 0x7A71AA86, 0x9C588AC3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x08000000, 0xB4000000, 0xF2000000, 0x8D000000, 0xF8800000, 0xBA400000, 0xE4200000, 0x7F900000, 0x50080000, 0x7F640000, 0x5BF20000, 0xB2B90000, 0x3A7D8000, 0xB3DDC000, 0x828F2000, 0xA2E45000, 0x7D328800, 0x86D95400, 0x60CF5200, 0x2AC61100, 0xDCA39C80, 0xE5D1B040, 0x242BF720, 0xF8F6B210, 0xB7FAFA08, 0x8BDF1504, 0x1E8C4686, 0x74E7F54F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xE8000000, 0x1C000000, 0x8E000000, 0xF1000000, 0x03800000, 0x09C00000, 0xAC600000, 0x9AF00000, 0xE9D80000, 0x706C0000, 0x5D520000, 0xA84B0000, 0x7DC48000, 0x18A4C000, 0x25D6A000, 0x2FCDF000, 0xC8C17800, 0x87E12400, 0xAF319E00, 0x7BBB0F00, 0xF39C9D80, 0xAB09E9C0, 0x5FE57260, 0x7DF61D30, 0x299E4608, 0xB80BDB0C, 0xEB667B82, 0x2AB4C2CB } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x18000000, 0x6C000000, 0x4E000000, 0x61000000, 0xA9800000, 0x36400000, 0xB0200000, 0x62100000, 0x94C80000, 0x187C0000, 0x16720000, 0x81F90000, 0xB2278000, 0x9704C000, 0x3E976000, 0x531D3000, 0x83C37800, 0x7061A400, 0x8F323600, 0xB95AF100, 0xAFF7AC80, 0x35AC2240, 0xECDB9020, 0xDFB7DA70, 0xC08E2E08, 0xAD4A6504, 0x263CE28E, 0x8252774B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x58000000, 0xD4000000, 0xAE000000, 0xD5000000, 0x94800000, 0xE6C00000, 0x31200000, 0x2CD00000, 0x67080000, 0xFBEC0000, 0xEE320000, 0x0E790000, 0x06F68000, 0xEBF5C000, 0xBB766000, 0xFBB6D000, 0x6394F800, 0xF9C47400, 0xD70E2200, 0xF2415300, 0x97E35880, 0xBDF07D40, 0xBBD84920, 0xC4E53E30, 0xC1DEBA08, 0x4E4AF704, 0xDD8F028A, 0x79809A4F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xD8000000, 0xA4000000, 0xF2000000, 0x31000000, 0x70800000, 0x5EC00000, 0xA3200000, 0x13F00000, 0x4CE80000, 0x55140000, 0x77120000, 0x90B90000, 0x92CC8000, 0x66CCC000, 0x9CCC6000, 0x41CD1000, 0x0F4E8800, 0xEE8EE400, 0x5A2D7200, 0xA49E0300, 0x54153080, 0x9F9231C0, 0x4A7836A0, 0x73EFDDD0, 0x9C3D9A08, 0x04A4F704, 0xB81A4A82, 0xEA7E16CB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xC8000000, 0x0C000000, 0xF2000000, 0x17000000, 0x17800000, 0xD2C00000, 0xD1E00000, 0x59300000, 0xC7C80000, 0x419C0000, 0xB7120000, 0xA3990000, 0x18268000, 0xBD674000, 0x0E442000, 0xBE95B000, 0xB46F0800, 0x043BBC00, 0x1BB58E00, 0xFDBE5300, 0x94418380, 0x25A23EC0, 0xCC906E20, 0x3358A0F0, 0xE6C4A608, 0x67D55F04, 0x2D4F858A, 0xC7E991C5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x88000000, 0x0C000000, 0x22000000, 0x19000000, 0x50800000, 0x79C00000, 0x0F200000, 0x16900000, 0x2AF80000, 0xA7E40000, 0x77720000, 0xC8C90000, 0x83CE8000, 0x000D4000, 0xD22D2000, 0x1A3DB000, 0xA2064800, 0xCB408400, 0x8FE39200, 0x3932BF00, 0x1DA98080, 0x063FE440, 0xE806D2E0, 0xAE41EA10, 0xA562FA08, 0xDDF28B04, 0x6C08DA8A, 0x526D9F4D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x18000000, 0x94000000, 0x0E000000, 0xF5000000, 0x35800000, 0x1AC00000, 0x5D200000, 0x96F00000, 0x42980000, 0xB26C0000, 0x0E120000, 0x1FC90000, 0xC8478000, 0xB286C000, 0x9FA76000, 0xF156D000, 0x17CC7800, 0xB3A3F400, 0xDCB0A600, 0xF8F92300, 0xDF7C6880, 0x055951C0, 0x16CD0B60, 0xF8216C30, 0xCB71BE08, 0x34590704, 0x454D368E, 0x7BE046C3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x18000000, 0x5C000000, 0x86000000, 0x5B000000, 0x8C800000, 0x60C00000, 0x3A200000, 0x38900000, 0x1B980000, 0x98BC0000, 0xB3720000, 0x80A90000, 0xD8F68000, 0x1436C000, 0x50176000, 0xFF84F000, 0xC69F5800, 0x21E04C00, 0xFE306200, 0xFBC8CB00, 0xD5064C80, 0x8D5EB440, 0x2F42DB60, 0xCA61CF70, 0x44725A08, 0x72297704, 0x2F35F68A, 0x0C95F343 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xC8000000, 0xDC000000, 0xF6000000, 0x31000000, 0x0B800000, 0xF5C00000, 0xEDE00000, 0xA1D00000, 0x40C80000, 0x7A3C0000, 0xEA720000, 0xDD3B0000, 0x74C78000, 0x9A55C000, 0x093E2000, 0x2AF1F000, 0x3C789800, 0xB267A400, 0xCA25BE00, 0xEB055F00, 0x90B55B80, 0x826CF540, 0xAC785E20, 0x4A66B670, 0x3E248608, 0x3106CB0C, 0x9FB65D8E, 0x64EFFE4F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xC8000000, 0x44000000, 0x7E000000, 0xE5000000, 0x85800000, 0x2BC00000, 0xDBE00000, 0x79B00000, 0x0EF80000, 0xAD440000, 0x9A120000, 0xD6690000, 0x926E8000, 0x7ADCC000, 0x07A42000, 0x80209000, 0x8A50B800, 0x2348F400, 0xA5BEE600, 0x5E556700, 0xF3FB1380, 0xF4C61CC0, 0x53D356E0, 0xAA8B8390, 0x795CFE08, 0x0565C304, 0x44436D8A, 0xF3221FCB } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x58000000, 0x94000000, 0xA6000000, 0x5F000000, 0xCF800000, 0xFAC00000, 0x92E00000, 0x93900000, 0x42280000, 0x99440000, 0x5A320000, 0x3A9B0000, 0xAF9F8000, 0xED0EC000, 0xD3A46000, 0x9DA0D000, 0x3EB2D800, 0x59DB5C00, 0x20BCCE00, 0x87FC4300, 0x06DEFF80, 0x1F2C1440, 0x07D6E1A0, 0xDE9BDB90, 0x719DF608, 0xF60D0F0C, 0xD226898E, 0xF460DB43 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x28000000, 0x9C000000, 0x66000000, 0x81000000, 0x7C800000, 0x28400000, 0xF7A00000, 0xAC300000, 0xFBC80000, 0xD5240000, 0xE5520000, 0x871B0000, 0x34FC8000, 0xC54C4000, 0x3A45A000, 0x3883F000, 0x8A405800, 0x14A06400, 0x13B16200, 0xFC0BE900, 0x0D463280, 0x0D02DEC0, 0xF283B820, 0x15415910, 0x7D201A08, 0x2D703D0C, 0xECE8A882, 0x3755A3C9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x78000000, 0xBC000000, 0x12000000, 0xC5000000, 0x63800000, 0x89400000, 0x88600000, 0xB2500000, 0x48D80000, 0x46DC0000, 0x4EF20000, 0xE4A90000, 0xA6B78000, 0xDE664000, 0xB67EE000, 0x78827000, 0x15C28800, 0x83A13400, 0x6EF2DE00, 0x54A97D00, 0x2EB78D80, 0x0A661B40, 0x607E9C60, 0x138011F0, 0xA1413608, 0xAC607904, 0x0C533B8E, 0xE7D92241 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x78000000, 0x54000000, 0x2E000000, 0x6F000000, 0xE7800000, 0xB3C00000, 0xD0600000, 0x17900000, 0x9D780000, 0xA78C0000, 0x74B20000, 0x52CB0000, 0xFCC58000, 0x34B54000, 0x819CE000, 0xA109D000, 0x8CA57800, 0x93249C00, 0xB4E56E00, 0x2A864700, 0x8214D580, 0x80ECE440, 0xC0A1E8E0, 0x4A7146B0, 0x602B7608, 0xE6154B0C, 0xC6EDA386, 0xE3A2AF4D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xB8000000, 0xBC000000, 0x4E000000, 0x2F000000, 0x99800000, 0xED400000, 0xCE600000, 0x9DD00000, 0xB6580000, 0x16440000, 0x44720000, 0x27290000, 0xEDED8000, 0x105FC000, 0x24D5E000, 0xC5487000, 0xB63C7800, 0xED041C00, 0x2910B600, 0xB57A1D00, 0x55F40D80, 0xA7F8B540, 0x8336A660, 0x4DDAFB90, 0x1206AE08, 0x5890B104, 0x4C38A386, 0xA1950447 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xB8000000, 0xBC000000, 0xDE000000, 0x27000000, 0x7D800000, 0xFA400000, 0x16600000, 0xF9100000, 0x10B80000, 0xF12C0000, 0x6BB20000, 0x2A0B0000, 0x45A58000, 0xABD44000, 0x04FFE000, 0x4CAA7000, 0x3517B800, 0xE25FBC00, 0xFC1AA600, 0x1C9E0100, 0x8AB88D80, 0x142E5640, 0x1F3151E0, 0xA2C94A30, 0xD0057E08, 0xDCE48D0C, 0x0237F386, 0x0EADDB49 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x28000000, 0xB4000000, 0x66000000, 0x7B000000, 0x66800000, 0xA2C00000, 0xC5E00000, 0x69B00000, 0x32F80000, 0xBB1C0000, 0x9F120000, 0x80E90000, 0x9E758000, 0x39254000, 0xDCEFA000, 0xDBC85000, 0x10265800, 0xE76D8C00, 0x048BAA00, 0xC185E300, 0xC1FD7380, 0x2E20A8C0, 0x47D0C6E0, 0xAC0B62F0, 0xEC45D208, 0x649C7F04, 0x4E52A186, 0xFE49D7CD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x08000000, 0x74000000, 0x76000000, 0x1B000000, 0xC2800000, 0x7C400000, 0xB6600000, 0x66100000, 0x10480000, 0xDB540000, 0x27B20000, 0xBBF90000, 0xBAAF8000, 0x6C1C4000, 0x9C672000, 0xFD095000, 0xF6B51800, 0x72638C00, 0x2811BA00, 0x074A5900, 0x83D4FD80, 0x4AF10640, 0xD61A0620, 0x0F7D17D0, 0x6FF60208, 0x2981C504, 0x66C2FF8E, 0x5620C349 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x18000000, 0x5C000000, 0x46000000, 0xF7000000, 0xB9800000, 0xB6400000, 0x74600000, 0x2A900000, 0x37880000, 0x82840000, 0x978A0000, 0x92850000, 0xDF8B8000, 0xE685C000, 0xDD8BE000, 0x0B84B000, 0xD50AF800, 0xF3476C00, 0xAEA81E00, 0x1BF5B500, 0xC7D1CF80, 0x84691F40, 0xE55711A0, 0x03E01550, 0x3FD1CF88, 0xA8691F44, 0xDB5711A6, 0x98E01553 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x98000000, 0x3C000000, 0x22000000, 0xBF000000, 0xF7800000, 0xA0C00000, 0x27E00000, 0x02500000, 0xB1D80000, 0x6E240000, 0x19DA0000, 0x7A270000, 0xEFDB8000, 0x53274000, 0x2159E000, 0xA567B000, 0xCCF96800, 0x68954C00, 0x0FD2B600, 0x321BCF00, 0xEC442980, 0x8C4AC640, 0xBF9C6EE0, 0x3D6EBED0, 0x41C42988, 0x7F8AC64C, 0xB5FC6EE6, 0x0CFEBED1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x28000000, 0x7C000000, 0xF6000000, 0xF3000000, 0xA7800000, 0x8F400000, 0x0E200000, 0x0D100000, 0x96C80000, 0x799C0000, 0xCACA0000, 0xFF9F0000, 0xB1C88000, 0x941DC000, 0xE0882000, 0x153C3000, 0xBC1BF800, 0xFFB7FC00, 0x6C256600, 0xB72FC100, 0x0B525E80, 0x726B7540, 0xC34FC5A0, 0x14E1B330, 0xAD725E88, 0xC37B754C, 0x0387C5AA, 0x2E7DB33B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xE8000000, 0x4C000000, 0x32000000, 0xBF000000, 0x2C800000, 0x80C00000, 0x06E00000, 0xBC500000, 0x8D580000, 0xC9C40000, 0x475A0000, 0x62C70000, 0x1DD98000, 0x5306C000, 0x52BA2000, 0xB017F000, 0x4742E800, 0xFCA10C00, 0x1B705A00, 0xE6680F00, 0x038FC180, 0xE5653E40, 0xE42B54E0, 0xB0ADA950, 0xF857C188, 0x9F613E4C, 0x5B1154EE, 0x21FAA957 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x78000000, 0x0C000000, 0x46000000, 0x25000000, 0xA9800000, 0x01C00000, 0x57200000, 0x16700000, 0x8E480000, 0x165C0000, 0x274A0000, 0xB9DD0000, 0x638B8000, 0x777DC000, 0x0C3A6000, 0xA215F000, 0x4A177800, 0x2E176400, 0x4C14DE00, 0x6B16E300, 0xD5954280, 0x12D75AC0, 0x8EB74BA0, 0x42A61BB0, 0x25FF4288, 0xFD7A5AC4, 0x0374CBA6, 0x1387DBB3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x48000000, 0x3C000000, 0x42000000, 0x4D000000, 0x50800000, 0x03400000, 0x1FE00000, 0x4A300000, 0xCDD80000, 0xB70C0000, 0x2ADA0000, 0x468F0000, 0x531A8000, 0x3B2F4000, 0x5C4BA000, 0xCE87B000, 0x2BFEA800, 0x57208400, 0xC512EA00, 0xBCC90900, 0x55C55580, 0x601FC1C0, 0x7312F2E0, 0x4FC845F0, 0x2A475588, 0x6EDCC1CC, 0x773272E2, 0x255805F1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xC8000000, 0xE4000000, 0x7A000000, 0xAB000000, 0x73800000, 0x0AC00000, 0x98600000, 0x38700000, 0xAFB80000, 0x4AB40000, 0x6ABA0000, 0xE0370000, 0xBCF98000, 0x0B16C000, 0x752AA000, 0x933D5000, 0xD8974800, 0x2FE9FC00, 0x535F8600, 0xBCE55700, 0xD651A780, 0x2CEA56C0, 0x74DD2960, 0xE4264410, 0x7133A788, 0xD51956CC, 0x9EA6A96E, 0x3F738417 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xE8000000, 0xBC000000, 0xEA000000, 0x17000000, 0x6A800000, 0xE2C00000, 0xB1E00000, 0x17100000, 0x8D880000, 0x96CC0000, 0x8B0A0000, 0xC60D0000, 0xD9E88000, 0x1D9EC000, 0xA3A32000, 0xFB303000, 0x5DFA8800, 0xF4956C00, 0xDEAFA200, 0x1A5A2700, 0x11A74580, 0x3254CB40, 0x914E3BA0, 0xEC495C70, 0xFBAFC588, 0xD3DA0B44, 0x9FE51BAA, 0x84756C7F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x78000000, 0xDC000000, 0xD2000000, 0xF9000000, 0xC8800000, 0x09400000, 0xEBA00000, 0xEC300000, 0x6B880000, 0x8D840000, 0xC90A0000, 0x41C50000, 0xE8288000, 0x55B4C000, 0x04816000, 0x3343B000, 0x66A02800, 0x22B15400, 0xEDC98A00, 0x59A4B100, 0xCFF9C480, 0xF92D71C0, 0xA3FDA2A0, 0xF9E763D0, 0xA4D94488, 0x185DB1C4, 0x5DD6C2AA, 0xCB51D3D7 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x18000000, 0x6C000000, 0x62000000, 0x59000000, 0xA7800000, 0x8C400000, 0x9A600000, 0xCB300000, 0x55580000, 0xC69C0000, 0x38DA0000, 0x27DD0000, 0xAB388000, 0x6BADC000, 0x8280E000, 0x21C07000, 0x9B236800, 0xC8D01400, 0x312B7600, 0x9B26E500, 0x7CB77F80, 0x057F79C0, 0xBCA822E0, 0xEA6547B0, 0xC757FF88, 0x3D0EB9C4, 0x9B12C2EA, 0x9B0837B3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xE8000000, 0xC4000000, 0x4A000000, 0xAD000000, 0x0C800000, 0xB9C00000, 0xA5200000, 0x33500000, 0xB8580000, 0x8FF40000, 0x06DA0000, 0x27350000, 0x197A8000, 0x96A6C000, 0xC3812000, 0xBC41D000, 0x8A620800, 0x9AB26400, 0x0EAABA00, 0x333F4300, 0x73558E80, 0x3CCB9E40, 0x358DC7E0, 0x3BFD5590, 0xDCF70E88, 0x45595E44, 0xDB76E7E2, 0xB319859F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x08000000, 0xA4000000, 0x7A000000, 0xD1000000, 0x89800000, 0xE7400000, 0x41200000, 0xBD500000, 0x31080000, 0x90F40000, 0x3E8A0000, 0x00B50000, 0x11298000, 0xEC25C000, 0xACC1A000, 0x9B635000, 0x4BF24800, 0xF0191400, 0xB05FEE00, 0xD9EC4900, 0xD355CA80, 0xAC1AAC40, 0xC65DA6A0, 0x06EE4B90, 0xC9D44A88, 0xBFDB6C44, 0x37BE06AE, 0xB6DC1B93 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x88000000, 0x04000000, 0x16000000, 0xAB000000, 0xDC800000, 0x1DC00000, 0xC6A00000, 0x12B00000, 0x04E80000, 0xB2BC0000, 0xE36A0000, 0x9BFF0000, 0x4C088000, 0x01EC4000, 0x7D52A000, 0x79385000, 0x8C44F800, 0xB08FFC00, 0x88400A00, 0x22E34B00, 0x9251F080, 0xD3BBF1C0, 0x4A864B20, 0xF2ACBF30, 0x0B337088, 0xF2A8B1CC, 0x8F5C6B2A, 0x43B8AF3D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x68000000, 0x84000000, 0x36000000, 0x4D000000, 0xB5800000, 0xEAC00000, 0x89E00000, 0x85700000, 0x36F80000, 0x54D40000, 0xB67A0000, 0xA7950000, 0xC7588000, 0x40074000, 0xE4512000, 0xF9695000, 0x53DFF800, 0xA9176400, 0x3518AE00, 0xA6A70F00, 0xFA02E980, 0x2F026AC0, 0x06811A60, 0x06406590, 0x88A06988, 0x2F502AC4, 0xB9E8BA6A, 0x409E7599 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x88000000, 0x9C000000, 0x62000000, 0xC9000000, 0x18800000, 0xC8C00000, 0xFA600000, 0x4A900000, 0xE7B80000, 0xD85C0000, 0xCA3A0000, 0xBA1F0000, 0x59998000, 0x9E6F4000, 0xD673A000, 0x0EE93000, 0xF4042800, 0x98B71400, 0x2D3ECA00, 0x1728F700, 0xC2E6C380, 0x04E6CD40, 0x8BE50560, 0xDC663030, 0xA3254388, 0x36068D4C, 0x61B7256E, 0x4DBC4031 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x88000000, 0xC4000000, 0x4E000000, 0x13000000, 0x9B800000, 0xC8400000, 0xB4200000, 0xCBF00000, 0xF9280000, 0xDD940000, 0xBDAA0000, 0x44550000, 0x3CC88000, 0xE3044000, 0xD5D2A000, 0x7FDB5000, 0x843D9800, 0xA7FC1C00, 0x439E7600, 0xD04DFD00, 0x38954680, 0xC92AA2C0, 0xE594AA20, 0x01AAB090, 0x1657C688, 0x2DCBE2C4, 0xE1868A2A, 0xDB11A095 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x48000000, 0x6C000000, 0x76000000, 0x59000000, 0x28800000, 0x76400000, 0xAB200000, 0xC3100000, 0xF7C80000, 0xAA640000, 0x384A0000, 0x81A50000, 0xDBAB8000, 0x56D74000, 0x24D2A000, 0xD22AF000, 0x9C157800, 0x5BB09400, 0x21195A00, 0x8B4C8D00, 0x1BDF9680, 0x69D59140, 0x5D52E1A0, 0x80EB64D0, 0xA7761688, 0x2283D144, 0x5141C1A6, 0xD6A3D4D9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x88000000, 0x8C000000, 0x46000000, 0xEF000000, 0xBD800000, 0x6BC00000, 0x3EA00000, 0xDE900000, 0x40580000, 0x973C0000, 0xCCDA0000, 0x0A7F0000, 0xDE3B8000, 0xF08E4000, 0x28D1A000, 0xE5387000, 0xCF0EB800, 0x0612CC00, 0x9F1ACE00, 0xA0DDA300, 0x22A85480, 0xC5D44940, 0x236EBDE0, 0x9CA1D1B0, 0x6B91D488, 0xBCD9094C, 0x727E9DE6, 0xEA38E1B5 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xC8000000, 0x74000000, 0xE2000000, 0xB3000000, 0x86800000, 0xDEC00000, 0x25A00000, 0x7E100000, 0xEAC80000, 0x928C0000, 0xF94A0000, 0x33CF0000, 0x13A88000, 0xEA3CC000, 0x7313A000, 0xD9491000, 0x03CE2800, 0x7BAADC00, 0x6E3DB200, 0x5910E700, 0x1E49C480, 0x674DEF40, 0x166937A0, 0xCD1F6170, 0xF9C34488, 0xD1222F4C, 0x8BD017AA, 0x05E9B17F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x88000000, 0x8C000000, 0x62000000, 0x95000000, 0x43800000, 0xA5400000, 0xD3600000, 0xC6100000, 0x75A80000, 0x8CAC0000, 0x5D2A0000, 0x656F0000, 0xD98A8000, 0xC8DDC000, 0x6310A000, 0x7E2BF000, 0x85EF2800, 0x5C48A400, 0xBE7DA600, 0x63A07100, 0x83320B80, 0x78597940, 0x9ED76520, 0x8C8E17F0, 0xCB5A8B88, 0x4657B94C, 0x0D4F4522, 0x53FB27FB } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x28000000, 0x54000000, 0x6A000000, 0xF1000000, 0xED800000, 0x43C00000, 0x55600000, 0x92F00000, 0x44280000, 0x62F40000, 0x2EAA0000, 0x33B70000, 0x86898000, 0x0F64C000, 0xE9712000, 0x08E99000, 0xA1168800, 0x131B5400, 0xA4BDBE00, 0x342E1B00, 0xC8758B80, 0x9FEAA0C0, 0x6B95E320, 0x92598710, 0x349E0B88, 0x84FD60CC, 0xB18F432E, 0x5767D71F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0xC8000000, 0x84000000, 0x8E000000, 0x99000000, 0x6E800000, 0x7EC00000, 0xFC200000, 0x96100000, 0xEBC80000, 0x84A40000, 0x2E4A0000, 0xBFE50000, 0xA9298000, 0x4E964000, 0x6392A000, 0xC8885000, 0x4FC69800, 0xD5393400, 0x625DA200, 0xD8B40F00, 0x72803280, 0xFCC06740, 0x8F2335A0, 0x3F93E9D0, 0xAA8BB288, 0xECC72744, 0xB4BA15AE, 0xA71CF9DD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x08000000, 0xC4000000, 0xAE000000, 0x01000000, 0x59800000, 0x52C00000, 0xC7A00000, 0xE8100000, 0x19480000, 0xAD940000, 0x2B8A0000, 0x7A350000, 0x2B998000, 0xF77C4000, 0x200DA000, 0x19F55000, 0xADBA1800, 0x61ACD400, 0xC4E73E00, 0xFB703F00, 0x03F97080, 0x134D8740, 0x5097C1A0, 0x00090F10, 0xABF4D088, 0x8EB8D744, 0xB32DD9AE, 0x30A5DB15 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x28000000, 0xF4000000, 0xBA000000, 0x27000000, 0xEF800000, 0xF4400000, 0x89600000, 0x50B00000, 0xDC480000, 0x2BB40000, 0x180A0000, 0x3AD70000, 0xE4BA8000, 0xD09E4000, 0x8E0E2000, 0x4E179000, 0x321BC800, 0x1F0D8C00, 0x20963600, 0x60D87D00, 0x40AF8380, 0xED84F7C0, 0x8A807EA0, 0x20C1EF10, 0xFCA1A388, 0xE09367CC, 0xE51BB6A2, 0x488C6315 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x98000000, 0xA4000000, 0x72000000, 0x4D000000, 0x02800000, 0x1D400000, 0x0FA00000, 0x07300000, 0x7C080000, 0x15040000, 0xB54A0000, 0xE0A70000, 0xE37A8000, 0x982C4000, 0x4C3CE000, 0xC944D000, 0xC66A2800, 0x09D76400, 0x41526200, 0x96D9F100, 0x0E1D8C80, 0x14B745C0, 0xB60258A0, 0x0F0013D0, 0x27816C88, 0xF3C395CC, 0x5CE070A2, 0x939377DD } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x78000000, 0x24000000, 0x72000000, 0x07000000, 0x6D800000, 0x0A400000, 0x5FE00000, 0x01700000, 0xB4580000, 0xDD7C0000, 0x481A0000, 0x279D0000, 0x7BEA8000, 0x40074000, 0xF9376000, 0x758DD000, 0x7403A800, 0x6A034C00, 0x93035E00, 0xF7830500, 0x51407180, 0x646168C0, 0x7E33CCE0, 0x813AF330, 0xBBCF1188, 0xA9E0B8C4, 0xA47264E2, 0x86D8BF39 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x88000000, 0xF4000000, 0x02000000, 0x3B000000, 0x71800000, 0x57400000, 0x07E00000, 0x0BD00000, 0x78F80000, 0x7BBC0000, 0xC4BA0000, 0xA5DF0000, 0x1C298000, 0xC0C54000, 0x2B47A000, 0xFB049000, 0x9B64A800, 0x6EF7FC00, 0xD36F2E00, 0x71C08100, 0x9F22E180, 0x7671A640, 0xAC4B6E60, 0x9D544EB0, 0x12DF4188, 0x43AA364C, 0x3286466E, 0x0026F2B9 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x48000000, 0x74000000, 0x42000000, 0xCB000000, 0xCE800000, 0xAF400000, 0x8D200000, 0x83700000, 0x3B080000, 0x82E40000, 0xC74A0000, 0x3D470000, 0x7D788000, 0x526E4000, 0x316DA000, 0xBBED9000, 0xEEAFA800, 0xC48C3C00, 0xF77DD200, 0x9E37A100, 0xD6723680, 0x388AA4C0, 0xD224F6A0, 0x8CA81550, 0x2CD59688, 0x1A6034CC, 0xA253DEAA, 0x667A6955 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x48000000, 0x44000000, 0x8A000000, 0x73000000, 0x3D800000, 0xFA400000, 0x00200000, 0xB4D00000, 0x7BA80000, 0x86440000, 0x76EA0000, 0x11E50000, 0x3B7B8000, 0x0FED4000, 0xFFAEA000, 0xCC8E5000, 0x25DD8800, 0xB4361C00, 0x7A513E00, 0xFC6AD500, 0x1C272E80, 0xD218AE40, 0x969FCC20, 0x8296A150, 0x75438E88, 0xEBA3FE44, 0xDB91C426, 0xEB09FD51 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xF8000000, 0xA4000000, 0xA6000000, 0x5B000000, 0x38800000, 0x30C00000, 0x8C200000, 0xA6900000, 0xD4F80000, 0x12940000, 0x633A0000, 0xE4350000, 0x686B8000, 0xCF6D4000, 0x2C2C6000, 0x604DD000, 0x563FF800, 0x42753C00, 0x838B5A00, 0x475C1F00, 0x2786FA80, 0x17839D40, 0x76438560, 0x33E25510, 0x5C309A88, 0x45AB4D44, 0x70CFFD66, 0x1AFE2911 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x18000000, 0xEC000000, 0x1A000000, 0x7B000000, 0x2F800000, 0x19C00000, 0xD3200000, 0xAF900000, 0x9DC80000, 0x3F5C0000, 0x250A0000, 0xD8FD0000, 0x4CDA8000, 0x47D64000, 0xFB36E000, 0xA687F000, 0xE05F8800, 0xA48A9C00, 0x6C3E7600, 0x017B9B00, 0xBD060A80, 0x6F9E0D40, 0xE6ABF1A0, 0x5F2EFE30, 0x5EF2EA88, 0xBEB8FD44, 0x5724F9A2, 0x588F223D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xA8000000, 0xA4000000, 0x16000000, 0xA7000000, 0xBB800000, 0x93400000, 0x19E00000, 0x65F00000, 0x31E80000, 0x7E6C0000, 0xB3AA0000, 0xCB0D0000, 0x769A8000, 0x2446C000, 0xCAE42000, 0xC0F65000, 0xE3ED7800, 0x4FE84C00, 0x1D6E5600, 0xCE29A100, 0xA74C2180, 0xD8FBAEC0, 0x60F4DA20, 0x53EE2970, 0xC7EA0188, 0x496CFEC4, 0x70292222, 0xA44DA57F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x08000000, 0x84000000, 0x72000000, 0x59000000, 0x4E800000, 0xE6400000, 0xA9200000, 0xAD900000, 0x0E680000, 0xE39C0000, 0x4B2A0000, 0x193F0000, 0x9C788000, 0x51364000, 0x3DD4A000, 0xDBA65000, 0x123E6800, 0x1BF9B400, 0x51F41200, 0xA6B50D00, 0xA5142680, 0x6CC43340, 0xCA8FDB20, 0x4601D730, 0x13028688, 0x6B81634C, 0x06C3332A, 0xE8612335 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0xC8000000, 0x14000000, 0x66000000, 0xF7000000, 0x00800000, 0x90400000, 0x39E00000, 0xE9D00000, 0x09780000, 0xFAEC0000, 0x7C3A0000, 0xA28D0000, 0x8A288000, 0xCED54000, 0x8AB7A000, 0xEEA71000, 0xA3FF3800, 0x8CE24C00, 0xE0517A00, 0x12B82D00, 0x31CE4D80, 0x654AD240, 0x9847D460, 0x66ACCBF0, 0x1FDBED88, 0x7E5CC244, 0xCAD26C6A, 0x8FFAC7F1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x68000000, 0x1C000000, 0x22000000, 0x57000000, 0x19800000, 0xF6C00000, 0x68600000, 0x05D00000, 0xA2980000, 0x3E140000, 0x31DA0000, 0x92B50000, 0x83698000, 0x607C4000, 0xA3242000, 0x4CD23000, 0x3E1BA800, 0x5E57EC00, 0x92FA0E00, 0x5FC65700, 0x2540BF80, 0x95A25840, 0xB63031E0, 0x568A6210, 0x856D1F88, 0xE0DC2844, 0x4B97B9EE, 0x7D1BBE15 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x18000000, 0x6C000000, 0x0E000000, 0x01000000, 0x43800000, 0x2AC00000, 0x1CE00000, 0xD1500000, 0x8B580000, 0x2DB40000, 0x7E1A0000, 0x4D950000, 0x3EA98000, 0x2A1CC000, 0xAB85E000, 0x4AD37000, 0x6D9AD800, 0xAF57F400, 0xC64A9600, 0xF14C7F00, 0x5BDD7580, 0x47E51240, 0x75C3B4E0, 0x9660A690, 0x5C111588, 0xB77AA244, 0x9B048CEE, 0x04902297 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x48000000, 0xCC000000, 0x8E000000, 0x99000000, 0x39800000, 0x4EC00000, 0x21200000, 0x89F00000, 0x80F80000, 0xC55C0000, 0xA1BA0000, 0x57BD0000, 0x82E88000, 0x1F744000, 0xC2EDA000, 0xC7217000, 0xCCF09800, 0xDF7A9400, 0x8E9EBE00, 0x7F1B4F00, 0xC58C6A80, 0x94B3C0C0, 0x84184560, 0xFB0F4FB0, 0x92F14A88, 0x4E7AF0C4, 0xDB1F7D6A, 0xEFD9ABB5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xB8000000, 0xEC000000, 0x46000000, 0x79000000, 0xD4800000, 0xE6400000, 0x9CE00000, 0x84B00000, 0xB5980000, 0xF9040000, 0x765A0000, 0x23250000, 0xB24B8000, 0xF9EEC000, 0x83E56000, 0x5BEB7000, 0x6A3F7800, 0x090E1400, 0x01546A00, 0xF771AD00, 0xB7B8C980, 0x2115D7C0, 0x529283E0, 0x878875D0, 0x82CC2988, 0x8F7567C4, 0x99631BE6, 0x5273D1DF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x58000000, 0x54000000, 0x5A000000, 0x39000000, 0x86800000, 0x62C00000, 0x45600000, 0x30F00000, 0xD0A80000, 0x2D240000, 0x45EA0000, 0x30070000, 0xE4B98000, 0xD23EC000, 0x9444E000, 0xE3199000, 0x37AC8800, 0x5C1DF400, 0x1296D200, 0x5163DF00, 0x4AF27780, 0x79ABE4C0, 0x83A55920, 0x2B28BE50, 0x7B651788, 0xB74BB4CC, 0xBD14B12E, 0x5D221A57 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xF8000000, 0x4C000000, 0x92000000, 0x23000000, 0xE8800000, 0x57400000, 0xB2A00000, 0x35F00000, 0x93180000, 0x5FA40000, 0xA3DA0000, 0xD0C70000, 0x78C88000, 0xE80EC000, 0xF0C76000, 0xC8C9F000, 0xB00C2800, 0xCCC4FC00, 0xA2CACA00, 0xDF0E8100, 0xB6475080, 0xD6886EC0, 0x852CF8E0, 0xD4F56E50, 0xF732B088, 0xEF785ECC, 0xE43730EA, 0x7852A257 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xC8000000, 0x6C000000, 0xEE000000, 0x9F000000, 0x61800000, 0xED400000, 0x02600000, 0x04900000, 0x8CF80000, 0xF57C0000, 0x2B3A0000, 0xF1DF0000, 0xBD8B8000, 0xFB554000, 0x1B5CA000, 0x4B4AF000, 0x31761800, 0x392E0C00, 0x9AE25E00, 0xDB51D900, 0x1C584780, 0xD9CF0340, 0x64B15060, 0xE388FCB0, 0x9C556788, 0x2EDFB34C, 0x7C086866, 0xE61540B9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x48000000, 0xEC000000, 0x5E000000, 0x39000000, 0x2D800000, 0xBB400000, 0xC5600000, 0x51100000, 0x4C680000, 0x50BC0000, 0x17AA0000, 0x291F0000, 0xEB9B8000, 0x6F86C000, 0xF39EA000, 0xBC5B7000, 0xF826D800, 0x1EAD1400, 0x4B402E00, 0x4D621900, 0xDD112B80, 0x626AD540, 0x21BCE620, 0xD62A95B0, 0xCC5E0B88, 0x17F8654C, 0x13171E26, 0x04B631B7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xF8000000, 0xE4000000, 0x26000000, 0xCB000000, 0x1E800000, 0xE7C00000, 0xB8A00000, 0xB2F00000, 0x28C80000, 0xB6640000, 0x1C8A0000, 0xAC870000, 0x479B8000, 0x45DFC000, 0xE9646000, 0x7C0A5000, 0x3445F800, 0x0FBBFC00, 0xC7ECC200, 0xA58F4300, 0x725C5080, 0x6D2580C0, 0x5EEAC7A0, 0xEB56CF50, 0xF0E1B088, 0x5A1310CC, 0x66DADFA6, 0x6EBFA353 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xE8000000, 0x34000000, 0x06000000, 0x6F000000, 0xAF800000, 0x13C00000, 0xE8E00000, 0x8A500000, 0x66480000, 0x6E240000, 0xEF0A0000, 0xA7870000, 0xB8F98000, 0xC03DC000, 0x86662000, 0x622B1000, 0xA2373800, 0x7F622C00, 0x3590C600, 0xB4A90300, 0x09771580, 0xA7C26240, 0x2EE2E8A0, 0x0552F8D0, 0x79CAB588, 0x95E7B24C, 0x33E870AE, 0x2BD504DB } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x38000000, 0x5C000000, 0x5E000000, 0xED000000, 0x3C800000, 0xDB400000, 0x37200000, 0x07700000, 0x55180000, 0x3E540000, 0x223A0000, 0x99270000, 0x87238000, 0x0F714000, 0xC1196000, 0x94573000, 0xF53B9800, 0x4AA5C400, 0xD3E20A00, 0x32919900, 0x16894E80, 0x2A5C40C0, 0xAE2610E0, 0x04A32090, 0x03B2D688, 0x30F984CC, 0x25C41AE6, 0xFA32B999 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x88000000, 0x5C000000, 0x7E000000, 0xB1000000, 0x73800000, 0x5AC00000, 0xB5600000, 0x02100000, 0x43C80000, 0x714C0000, 0x66AA0000, 0xEB5F0000, 0x21638000, 0x8011C000, 0x5CCBA000, 0x8BCFB000, 0x9BE9D800, 0x26FCB400, 0x5913B600, 0x034A6F00, 0x470CBB80, 0x7388D340, 0xA16F02A0, 0xAD19F970, 0xCAE56388, 0xC874674C, 0x1DFCB4A6, 0xA993967B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xF8000000, 0xA4000000, 0xBA000000, 0xE5000000, 0x13800000, 0xFC400000, 0x84A00000, 0x1B100000, 0x4AC80000, 0xF0A40000, 0x566A0000, 0x1FB50000, 0x4EA08000, 0xE613C000, 0xED496000, 0xFEE45000, 0x6BCB0800, 0x09240400, 0xA72A2600, 0x6497A500, 0x4FF13C80, 0xD37ACD40, 0x4A7CB1A0, 0xE8866AD0, 0xEFBA3488, 0x721EC944, 0x8BF697AA, 0x6601CFDB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xF8000000, 0x94000000, 0x32000000, 0x87000000, 0x43800000, 0xE0400000, 0x04200000, 0xE8100000, 0xEF780000, 0x7E3C0000, 0xA75A0000, 0x802D0000, 0xA5208000, 0x5E92C000, 0x6BB96000, 0x29DD9000, 0x53292800, 0x17654C00, 0xEE754600, 0xEF8D5D00, 0x71737E80, 0x4BCA3140, 0x2C95C560, 0x6F7C34B0, 0x1DFA5688, 0x80FF7D44, 0xBBB8836A, 0x61DD69BF } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x88000000, 0xC4000000, 0x56000000, 0x59000000, 0xCD800000, 0xB6C00000, 0xB2E00000, 0xF3500000, 0x33180000, 0x6E5C0000, 0x3DFA0000, 0xC70D0000, 0x65E08000, 0x1BD0C000, 0xF258A000, 0xD17ED000, 0x36C97800, 0xE1077400, 0xA706EE00, 0xE6057F00, 0xB7865D80, 0x6B464640, 0x9AA53FE0, 0x6F766030, 0x282F2588, 0xD6D13244, 0xD1DBD1EA, 0xD2BF1F37 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xE8000000, 0x6C000000, 0x0A000000, 0x4D000000, 0x8D800000, 0xE4400000, 0x62A00000, 0x33100000, 0x67680000, 0x076C0000, 0xEFCA0000, 0xC97D0000, 0x1D228000, 0x7E524000, 0x1E4B2000, 0xAF3EF000, 0xAE818800, 0xF2C18400, 0x54629E00, 0x2171E500, 0xD1181C80, 0xFEF6ED40, 0x14FE3F20, 0x5162E5F0, 0x50F19488, 0xF75B6944, 0x6D56A122, 0x486E00FD } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x98000000, 0x54000000, 0x86000000, 0x4D000000, 0xD3800000, 0x89C00000, 0x00A00000, 0x42100000, 0xAAE80000, 0x7ACC0000, 0x044A0000, 0x89DD0000, 0x47238000, 0x6DD14000, 0x974BE000, 0x635D1000, 0xEB627800, 0x21B16400, 0xCA78D600, 0xD0675300, 0xF0E72C80, 0x83A57F40, 0xB7463120, 0xED371770, 0x9CED5488, 0x18181B44, 0xD454E726, 0x765D4471 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x08000000, 0x54000000, 0xC6000000, 0xED000000, 0x6B800000, 0xBDC00000, 0xBC200000, 0x7BF00000, 0x2F680000, 0x8B6C0000, 0xD94A0000, 0x679D0000, 0x52A08000, 0x09B14000, 0x508AA000, 0xEDBD1000, 0x7C513800, 0x015BE400, 0xFC243600, 0xF7D70300, 0x20BC7E80, 0x47D3C8C0, 0x149A9520, 0x04069670, 0x42254688, 0xB6D42CC4, 0x613CA32A, 0x9D109571 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x98000000, 0xF4000000, 0x92000000, 0xD7000000, 0x52800000, 0x1FC00000, 0x19A00000, 0x10300000, 0xF2580000, 0xF08C0000, 0x6CFA0000, 0x9A3F0000, 0x4D608000, 0x6512C000, 0xECA8E000, 0x7CF61000, 0x8E062800, 0xA47D8C00, 0xA3808200, 0x68436300, 0x53E00C80, 0xACD04FC0, 0x880857E0, 0x6D4546F0, 0x3B1C2488, 0x7192C3CC, 0x066855EA, 0xD8D4E5F7 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x78000000, 0x5C000000, 0x22000000, 0x6F000000, 0xEB800000, 0xBBC00000, 0xF0600000, 0x30700000, 0xD7A80000, 0xCC9C0000, 0xC0CA0000, 0x436D0000, 0x9AA08000, 0x86934000, 0xE89B6000, 0x53173000, 0x53876800, 0xEA1FCC00, 0xBF8AA600, 0x434E9300, 0x71734F80, 0xE929FEC0, 0x9FDE0720, 0xAAEBF7B0, 0x73BE2788, 0x189B32C4, 0x5B14212A, 0x478624B9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xC8000000, 0x14000000, 0x7E000000, 0x8D000000, 0xE6800000, 0xABC00000, 0xC6A00000, 0x61700000, 0xF1380000, 0xB1540000, 0xB69A0000, 0x34A50000, 0xFB618000, 0x8ED14000, 0x30C8A000, 0xAAAC1000, 0x85ECD800, 0xAF8D6400, 0xEDDEE200, 0x65D45B00, 0x725B6080, 0x13869AC0, 0x34539660, 0xB10ABC90, 0x7F0DB888, 0x9F1EFEC4, 0xDBF4F46E, 0x25EBA791 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x58000000, 0xFC000000, 0x16000000, 0x1B000000, 0x7E800000, 0x6DC00000, 0x25200000, 0x52300000, 0x19E80000, 0x3AD40000, 0xF9CA0000, 0xD9650000, 0x61628000, 0x6A51C000, 0xC439E000, 0x0CAF3000, 0xA6073800, 0xA4309C00, 0x52E82200, 0x0C559B00, 0x000ACE80, 0x4E476FC0, 0xC251DB20, 0x00385790, 0xF6AFF688, 0xC306F3C4, 0x65B17922, 0xABA90C93 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x48000000, 0xBC000000, 0xFE000000, 0xB3000000, 0x56800000, 0xCA400000, 0x1E200000, 0x02300000, 0xE5D80000, 0x4EE40000, 0x8AFA0000, 0x97570000, 0x60E28000, 0x4B534000, 0x7449A000, 0x99CEB000, 0x43A4D800, 0x40593C00, 0x32252200, 0x6E9B2500, 0xD3474280, 0x730A71C0, 0xA26DA7E0, 0xFD57A750, 0x61E19A88, 0x28D04DCC, 0xBF8805E2, 0x112CC251 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x98000000, 0xFC000000, 0xBA000000, 0x01000000, 0x66800000, 0xF4400000, 0x25E00000, 0xD5100000, 0xCC080000, 0xAABC0000, 0x276A0000, 0x2FEF0000, 0xA8828000, 0x5B41C000, 0xBC62E000, 0xB0D13000, 0x58288800, 0x358FF400, 0x33517200, 0x4CE8D500, 0x7F2D8D80, 0x14204540, 0x5F32C7A0, 0x343A8EB0, 0xD3078588, 0x4FAE714C, 0xB36155A2, 0x59536BBB } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0xF8000000, 0xFC000000, 0x52000000, 0x4F000000, 0xEE800000, 0x16C00000, 0xE1200000, 0xD9F00000, 0xD7280000, 0xD0740000, 0x148A0000, 0x05470000, 0x19818000, 0x24414000, 0xD5E06000, 0x1FD1B000, 0xE45AA800, 0xBF9ECC00, 0x38DCF200, 0x69BC6700, 0x33AEBE80, 0x1A57FCC0, 0xDDFBF820, 0xC1AEF610, 0xE5559688, 0xBB7870CC, 0x436F6A2E, 0x52772119 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x78000000, 0xEC000000, 0x12000000, 0x65000000, 0xE5800000, 0x3DC00000, 0x44A00000, 0xB2700000, 0xB4280000, 0x79A40000, 0x210A0000, 0x58150000, 0xCE838000, 0xF740C000, 0x05E06000, 0x34927000, 0x8E39A800, 0x20DE2400, 0x1435DE00, 0x70B26300, 0xA40A0480, 0x8D967EC0, 0xEB41E220, 0x2FE07F50, 0xDD902C88, 0x09B89AC4, 0x001C5C26, 0x59146C57 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x68000000, 0xEC000000, 0x8E000000, 0x7B000000, 0x2E800000, 0x81400000, 0xB5A00000, 0x95500000, 0x8A680000, 0x4EF40000, 0xAB4A0000, 0x6BE50000, 0x43018000, 0xDA81C000, 0x6B422000, 0x9CA37000, 0x26D39800, 0xB2AA5C00, 0xDA968200, 0x71F9E900, 0xEFFF6C80, 0x938DD040, 0x00F73F20, 0x704A4E90, 0x95657488, 0x9A424C44, 0xEB219D2E, 0x9C11D793 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x98000000, 0x54000000, 0x9A000000, 0x35000000, 0x28800000, 0xDBC00000, 0xCEA00000, 0x66500000, 0x72980000, 0x28FC0000, 0x92BA0000, 0x266D0000, 0xF5008000, 0xC881C000, 0x4BC0E000, 0x66A19000, 0xAA500800, 0xBC998400, 0x87FECA00, 0x8F39BB00, 0xD52E9880, 0xE0627640, 0x607330E0, 0x5F09DAB0, 0x3CC61088, 0x10163244, 0x084F1AEA, 0x5490F1B3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x88000000, 0xE4000000, 0x82000000, 0x35000000, 0xCB800000, 0xBF400000, 0x34200000, 0x1F100000, 0x9C880000, 0x21FC0000, 0x962A0000, 0x2A2D0000, 0x51C28000, 0x58E2C000, 0x2872A000, 0xA9B85000, 0x79642800, 0xB3DD4400, 0x5E3A2600, 0x9827A900, 0x7CFEBE80, 0x29A86140, 0x4F6E92A0, 0xCCE023B0, 0x62721688, 0x58BAE544, 0xC0E494A2, 0xB19D1ABF } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xF8000000, 0x34000000, 0x0A000000, 0xCB000000, 0x83800000, 0x04400000, 0x0EE00000, 0x64700000, 0xD3A80000, 0xAEEC0000, 0x75CA0000, 0xFD5F0000, 0x34C38000, 0x7D22C000, 0x04D26000, 0x02391000, 0x62B7C800, 0x38CDFC00, 0x229B2600, 0x1325BD00, 0xE4947580, 0xE79EA0C0, 0x00E0C520, 0xFD709270, 0xBF2A3D88, 0xAB2E9CCC, 0x786A0326, 0x2A4EFF77 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x98000000, 0x34000000, 0x1A000000, 0x93000000, 0x2E800000, 0xB7C00000, 0x56200000, 0x30D00000, 0x14780000, 0x6B140000, 0xE7DA0000, 0x36870000, 0x68438000, 0x78604000, 0x1DB3E000, 0xB24B9000, 0xB51E0800, 0xB8A49C00, 0xCC91D200, 0xC61A1300, 0xADA72280, 0xD7113C40, 0x1A58B960, 0x0FC45710, 0x39A0AA88, 0x5692E04C, 0x95190B66, 0xE325941D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x64000000, 0x7E000000, 0x9F000000, 0xF6800000, 0xF6C00000, 0x08E00000, 0x4E100000, 0xB7180000, 0xB7140000, 0x027A0000, 0xDF450000, 0x98428000, 0xD2214000, 0x7CF0A000, 0x0809D000, 0x618DD800, 0xD12DEC00, 0x5D1D2200, 0x9EF62700, 0x45E83980, 0x581F0340, 0xC9758FE0, 0xFAA8EC10, 0x40BD6188, 0x7146AF44, 0x6F428DE2, 0x70A25B11 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x68000000, 0x5C000000, 0x7A000000, 0x3D000000, 0x02800000, 0xECC00000, 0xE7A00000, 0xD0300000, 0x0E980000, 0x7E440000, 0x2CBA0000, 0x3D350000, 0x0BC28000, 0x6822C000, 0x76712000, 0xA9FAB000, 0x5BD44800, 0x93138400, 0x3568E200, 0x88FFC700, 0x9C8E5480, 0x7C7653C0, 0x232154E0, 0xEBF111D0, 0x6EBA9C88, 0x843617C4, 0x674016E2, 0x6FE3A6DF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x98000000, 0xF4000000, 0x82000000, 0xBD000000, 0x2F800000, 0x4D400000, 0x23600000, 0x6BD00000, 0xB1980000, 0xF19C0000, 0xDA7A0000, 0x918D0000, 0x58438000, 0xD0E34000, 0x3893E000, 0x51F99000, 0xE6CC6800, 0xC2232400, 0x1EB3B600, 0x154A4100, 0xDA867380, 0x2524FA40, 0x53D69BE0, 0xBE7EE130, 0xC06B9B88, 0xCAB59E44, 0x2CAF4DE6, 0xB4737039 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x48000000, 0x84000000, 0x46000000, 0x4B000000, 0xED800000, 0xCFC00000, 0xB4A00000, 0x5CD00000, 0x9DB80000, 0x967C0000, 0x9D9A0000, 0xEDED0000, 0xB9C18000, 0xA7A04000, 0x9D52A000, 0xC07B5000, 0x67DC3800, 0xE3C93C00, 0x1417AE00, 0x1FDF9300, 0x3FCB2480, 0x7E15EC40, 0xC6DE7460, 0x974952B0, 0x93549C88, 0x163D9044, 0xFBF8FA6E, 0x0B1CD1B5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x58000000, 0x5C000000, 0x76000000, 0x57000000, 0xD8800000, 0x37400000, 0x55A00000, 0xC2900000, 0x7FF80000, 0xD7EC0000, 0x77DA0000, 0x57BD0000, 0x5B438000, 0x5BA2C000, 0x5990E000, 0x797AB000, 0xB3ACB800, 0xD0FA2C00, 0x836FBA00, 0xFE9A0100, 0xA11CF480, 0x33513740, 0x6E1B1960, 0x225D6DF0, 0x74F1CC88, 0x2188DB44, 0xFC25C366, 0x47DE1CFF } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xC8000000, 0x74000000, 0x86000000, 0x11000000, 0xAE800000, 0x58400000, 0xA5200000, 0x23300000, 0x01C80000, 0x08540000, 0x6CAA0000, 0xF6450000, 0x12518000, 0xFDDAC000, 0x29ACA000, 0xACB41000, 0xBD7A3800, 0xAF5F1400, 0x419EE200, 0x50FEC500, 0xFCEE5E80, 0x051565C0, 0x8908AFA0, 0xF835E390, 0xA638C688, 0x23FE61C4, 0xBD6C75AE, 0xBED4329F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x28000000, 0xAC000000, 0xDA000000, 0xD9000000, 0x07800000, 0x2E400000, 0xECE00000, 0x3F700000, 0x39380000, 0xA5FC0000, 0x339A0000, 0x2A6F0000, 0xA7D38000, 0xF3ABC000, 0xC4352000, 0xB11C7000, 0x78EAC800, 0x2D575400, 0x9D2C3600, 0xECB2BD00, 0xB29B3D80, 0x09ECDCC0, 0xAF913B60, 0x04480030, 0xA1C4D588, 0xD7E7F8CC, 0x1CB7C566, 0x13DDE933 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x08000000, 0xBC000000, 0xA2000000, 0xB9000000, 0x1D800000, 0xACC00000, 0x17E00000, 0xE7D00000, 0x2FF80000, 0xD08C0000, 0xB8DA0000, 0xCABD0000, 0x95F18000, 0x9A494000, 0xE067A000, 0x5E4CB000, 0x5639A800, 0xD0EE9400, 0x06CB3E00, 0x55253700, 0x036F7980, 0x190A1440, 0xAA462C60, 0xEFFD7F70, 0x80D17188, 0x89783044, 0x28CCBA6E, 0x067ADC71 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0xB8000000, 0xE4000000, 0xA6000000, 0xD9000000, 0xE4800000, 0xC0C00000, 0xEAA00000, 0xAE500000, 0xFE780000, 0x4AF40000, 0x401A0000, 0xE0050000, 0x25308000, 0x5A094000, 0xCC1C6000, 0x6F35D000, 0xFC3B7800, 0xF9977400, 0x4069CA00, 0x60EFC700, 0xC31DC880, 0x1AB7F240, 0x347ACF60, 0x39F73490, 0x279AD088, 0x4F455644, 0x2CD07D6A, 0x07BB8791 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xB8000000, 0x8C000000, 0x9E000000, 0x31000000, 0x71800000, 0x33400000, 0xBE600000, 0xF2100000, 0x97580000, 0xA4240000, 0xAE7A0000, 0xBA550000, 0x04338000, 0xB9A8C000, 0xF4AF6000, 0xACA5F000, 0x98BB9800, 0x45767400, 0x9741FE00, 0x24622900, 0x09126F80, 0xB5DA8D40, 0xF1E4F8E0, 0xEFD86AD0, 0x2AE69788, 0xDD590944, 0xB7269EE6, 0xA8F837D7 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x88000000, 0xAC000000, 0xF2000000, 0x5F000000, 0x66800000, 0x08C00000, 0x17A00000, 0x80D00000, 0x34E80000, 0xCF640000, 0x2C8A0000, 0x7A950000, 0xFE728000, 0xA3B94000, 0x80CEA000, 0xF10CF000, 0x792EE800, 0x2EBC4C00, 0xFAB59200, 0x45E0BF00, 0xA5B09480, 0x7099B840, 0xFFDEE920, 0x08C480D0, 0x445ADC88, 0xD27C0444, 0x5B171322, 0xF43133D1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xF8000000, 0xC4000000, 0xA6000000, 0xF9000000, 0xD8800000, 0x7C400000, 0xF3A00000, 0x73500000, 0xA2F80000, 0x5D4C0000, 0x201A0000, 0x3B3D0000, 0x60F28000, 0x41AAC000, 0xD7B76000, 0xB156D000, 0x81267800, 0xC0CF7400, 0xA6D9BA00, 0xCBDFB500, 0x31811C80, 0xCCC09440, 0x63E04960, 0xEAF27670, 0xB2AA0488, 0xBC343044, 0x86950B62, 0xB544777F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xA8000000, 0xD4000000, 0x92000000, 0xD3000000, 0x84800000, 0xE8400000, 0x73600000, 0x11700000, 0x71280000, 0x93F40000, 0x5D0A0000, 0x9F670000, 0x5A128000, 0xDC5B4000, 0x84DE2000, 0x9FFD1000, 0x3DEDE800, 0x7DB59C00, 0x8F699A00, 0xE9958D00, 0xFFF8EF80, 0xA88F1CC0, 0xFDC67D20, 0x21C30C10, 0xD2A12788, 0x03D090CC, 0x52F88F22, 0xD10C5D11 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x08000000, 0xE4000000, 0x1A000000, 0x2D000000, 0xE9800000, 0xB0400000, 0x2E600000, 0x54100000, 0x33780000, 0x354C0000, 0x2C5A0000, 0x78BF0000, 0x5C718000, 0xEC6AC000, 0xA4B7A000, 0xEBD45000, 0xF8454800, 0xD47DA400, 0x97D08E00, 0x405B1500, 0x46BEEF80, 0x8B738940, 0x58E81860, 0xF576EF70, 0x91F60788, 0x98357D4C, 0x9E145E6E, 0x78669E77 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xD8000000, 0x74000000, 0xEA000000, 0xA3000000, 0x47800000, 0xA7400000, 0x3D200000, 0xF4900000, 0xF6980000, 0x8D1C0000, 0xA5FA0000, 0x602F0000, 0x67328000, 0x31C9C000, 0x5E67E000, 0x82151000, 0xC8FDC800, 0x5F0ADC00, 0x2507F600, 0x23273100, 0x04349A80, 0x2FEDD740, 0x54D09AE0, 0xEE3BFC30, 0x41CCB288, 0xDFC11B4C, 0x5BE224E2, 0x73F0D13B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xD8000000, 0x3C000000, 0x9A000000, 0xD9000000, 0x35800000, 0xD1C00000, 0xBDA00000, 0x60700000, 0x0B280000, 0xA1F40000, 0x844A0000, 0x40A70000, 0xC3518000, 0x9218C000, 0x453CE000, 0x42AD3000, 0x1A940800, 0x0B191400, 0x50BDFE00, 0x836D0300, 0x8F377080, 0x8F69BEC0, 0xFD946620, 0x619BFC10, 0xE7FD9888, 0x2B8E9ACC, 0x52A6102E, 0x2E502B1F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xF8000000, 0x44000000, 0xD6000000, 0xF5000000, 0xAC800000, 0xEAC00000, 0xB5A00000, 0xE3D00000, 0xD6880000, 0xFCB40000, 0x5AEA0000, 0x1B450000, 0xB5F28000, 0xAC184000, 0x9EDF6000, 0xC56E5000, 0x8A17B800, 0xD0B94400, 0x038D2A00, 0xFA245F00, 0xCA80D480, 0xD7C00C40, 0xD521D0A0, 0x3310E390, 0xFC2A0C88, 0xD4E61844, 0xE923C2A2, 0xE110B895 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x48000000, 0xF4000000, 0x56000000, 0x61000000, 0xE2800000, 0xE5400000, 0x76200000, 0x85F00000, 0xAB080000, 0x57AC0000, 0x536A0000, 0xB5FF0000, 0xF5508000, 0xB5BA4000, 0xEF87A000, 0x2DB49000, 0x75DD7800, 0x21A1D400, 0x44321200, 0xB168F100, 0xE2FDE280, 0x86D02AC0, 0xAA7B78A0, 0xC0E69F70, 0x7C653A88, 0x6C266ECC, 0x5E8692AA, 0x4736FA75 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x18000000, 0x84000000, 0x8E000000, 0x61000000, 0x44800000, 0x89400000, 0xC8A00000, 0xEFF00000, 0x98980000, 0x29D40000, 0x69FA0000, 0xF1C50000, 0x23308000, 0xCDFBC000, 0x8FC6E000, 0xFA32D000, 0xBD7B5800, 0x90851400, 0xD793EA00, 0x980AC100, 0xE05EA080, 0x726762C0, 0x9743A4E0, 0x41A39A90, 0x97739888, 0xABDB66C4, 0x1675F6EA, 0x278A9F9B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xE8000000, 0x5C000000, 0xAA000000, 0x2F000000, 0x70800000, 0x9E400000, 0xC9A00000, 0x51100000, 0x2C380000, 0xF7140000, 0x475A0000, 0xC3E70000, 0x48D28000, 0x7F59C000, 0x27E72000, 0xC6D1B000, 0xFE5A0800, 0x66654C00, 0xF113AA00, 0x5C3A6500, 0x3F171480, 0xAB595540, 0x81E78A60, 0x3BD0AA10, 0xA5D8BC88, 0x96A4694C, 0x7FF10862, 0x310A331B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x48000000, 0x4C000000, 0x72000000, 0x6B000000, 0x27800000, 0x70400000, 0xF3E00000, 0x2F100000, 0xC5680000, 0xA2240000, 0xF54A0000, 0x68950000, 0xA1D38000, 0x2A49C000, 0x7914A000, 0xE493F000, 0xD729E800, 0x22C51C00, 0xC9DB9600, 0xABBC4D00, 0xA515E180, 0xCE937540, 0xE828D620, 0x4346DAD0, 0xA49B2988, 0x2ADC5944, 0xC4C60826, 0xC4D87BD3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xA8000000, 0x0C000000, 0x4E000000, 0xBB000000, 0x95800000, 0x81400000, 0xA4200000, 0x2E500000, 0xE2D80000, 0x41940000, 0x643A0000, 0x15A50000, 0xFB128000, 0xBCF84000, 0x1EC62000, 0xBA637000, 0x1DF29800, 0x98CA5C00, 0x79EE2E00, 0xB73C4900, 0xBA27F680, 0x6B500440, 0x545B37E0, 0x81548910, 0xFB59CE88, 0xCED56844, 0x5B1BA1E2, 0xFE74EC15 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x08000000, 0x9C000000, 0x4E000000, 0x29000000, 0xBE800000, 0x1EC00000, 0x9D200000, 0xC7100000, 0x0F680000, 0x3A2C0000, 0x200A0000, 0xF9DD0000, 0x92D08000, 0x73CA4000, 0x907EA000, 0x18033000, 0x74001800, 0xA2005400, 0xBF008200, 0x0380FF00, 0x7242FE80, 0xE4E25F40, 0xCDB2ED20, 0x68390EF0, 0xB6A4C688, 0x40177B44, 0x11AED72A, 0x5E4B95FD } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x18000000, 0x94000000, 0x1E000000, 0xA1000000, 0x40800000, 0x2A400000, 0x45600000, 0xE1500000, 0x85F80000, 0xF75C0000, 0x285A0000, 0xFA2F0000, 0x9A118000, 0x581AC000, 0x484FE000, 0x86C19000, 0x55231800, 0xE3335400, 0x6128BA00, 0x1E664D00, 0x85244780, 0x28C65440, 0x8FD70660, 0xB54E1A30, 0x04413F88, 0xDC62504C, 0xA5D1446E, 0xD9B99337 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x78000000, 0x5C000000, 0xA2000000, 0xA3000000, 0x80800000, 0xC5C00000, 0x3F200000, 0x76F00000, 0x54780000, 0xBA3C0000, 0xB51A0000, 0xCAAF0000, 0xDF718000, 0x4638C000, 0x565E6000, 0xEC08B000, 0x72846800, 0x5F867C00, 0x66064A00, 0x3C46FB00, 0x1426CE80, 0x4334E4C0, 0x821EF160, 0x7D6A6930, 0xBA174688, 0x89EDE8CC, 0xB893336E, 0x6E6A9E3F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xD8000000, 0xFC000000, 0x22000000, 0x93000000, 0x37800000, 0xD4C00000, 0xBFA00000, 0x55500000, 0xA7780000, 0x33CC0000, 0x449A0000, 0x907F0000, 0xFAD18000, 0xAFBAC000, 0x3E6CE000, 0x2AC83000, 0x2484E800, 0xC3DC3C00, 0xE5809600, 0x5FC2FF00, 0x94239080, 0xD3902E40, 0x53DABF60, 0xAD1E3C70, 0x15201888, 0x8F11E24C, 0xDC9BA16E, 0x4C7E0F77 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x78000000, 0x14000000, 0x7A000000, 0x8F000000, 0xC0800000, 0x41400000, 0x7F600000, 0x6A900000, 0x36480000, 0xE2540000, 0x5BEA0000, 0xB0670000, 0x40118000, 0x400B4000, 0xA9B66000, 0x1A3A1000, 0x0E4F0800, 0x1C57EC00, 0x16EBAA00, 0x0BE65900, 0xABD36F80, 0x892BE740, 0x68C528A0, 0x7DA2D910, 0x2A318788, 0x0FFA5B4C, 0x8A6E6AAE, 0x66A63C11 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xC8000000, 0x44000000, 0x62000000, 0xE5000000, 0xD7800000, 0x8DC00000, 0xC9A00000, 0xD6700000, 0x42D80000, 0x2E940000, 0x163A0000, 0xEE070000, 0xE1708000, 0x885A4000, 0x08D5A000, 0xEC5A5000, 0xFAD5A800, 0x615A0400, 0x39549600, 0x469A0300, 0x51F72880, 0x256B46C0, 0x7BEEE9E0, 0x15DE9590, 0x3665A088, 0x70A252CC, 0x2FF0F7EA, 0xAC198295 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x88000000, 0xE4000000, 0x8E000000, 0xF1000000, 0x0F800000, 0xFBC00000, 0xD3E00000, 0xB9500000, 0x04A80000, 0xDCB40000, 0x7C0A0000, 0xC3470000, 0xCE508000, 0xDE29C000, 0x06F4A000, 0x152B5000, 0x2E771800, 0x6C68D400, 0x5BD7C600, 0xEE1A8B00, 0xA14D2180, 0x04159240, 0xD3F8C920, 0xF91C3190, 0x373C1988, 0x988CD64C, 0x3CF6372A, 0x322BFE9B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x38000000, 0xC4000000, 0x4E000000, 0x65000000, 0x02800000, 0x7D400000, 0xBA600000, 0xBF500000, 0x07080000, 0xBF7C0000, 0x71AA0000, 0xF48D0000, 0xAA538000, 0x1D8BC000, 0xD63D6000, 0x0DCBD000, 0xD2DCD800, 0x25D90400, 0xF4B6F200, 0x7A770100, 0x39D43380, 0xB8A45040, 0x821C31A0, 0xEB7992B0, 0x3B440B88, 0x8F8C4444, 0x05D2FBA6, 0xFE4A87BB } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x88000000, 0x8C000000, 0x4A000000, 0x61000000, 0xCF800000, 0x03C00000, 0xA8A00000, 0x3E500000, 0x5C280000, 0x467C0000, 0x227A0000, 0x7A570000, 0xB4048000, 0xA02CC000, 0xCA51A000, 0xD22A7000, 0x417C4800, 0xB6FA5400, 0x5F150600, 0x5CE61300, 0x7F1DF080, 0x618BEC40, 0x39AE9320, 0x7A910530, 0x0008F688, 0x8D6DFF4C, 0x6EB363AA, 0xE71AE977 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xC8000000, 0x8C000000, 0xC6000000, 0xB7000000, 0x50800000, 0x0EC00000, 0xAA600000, 0x20300000, 0x75B80000, 0x38E40000, 0x598A0000, 0x4B5F0000, 0xF66E8000, 0x12544000, 0x7BF2A000, 0xC258F000, 0x8F95F800, 0x7B108C00, 0x25A84A00, 0xA3CF4F00, 0xBF856F80, 0x503905C0, 0x7BA7B660, 0xACAA29D0, 0xB04D2588, 0x13C64ACC, 0x919AD9E2, 0x94772C15 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x38000000, 0x3C000000, 0xFE000000, 0x89000000, 0x8C800000, 0x10C00000, 0x11600000, 0x90B00000, 0x6DE80000, 0xD0EC0000, 0x395A0000, 0xDF050000, 0x8EB58000, 0x2BDCC000, 0xC9F06000, 0x66C9B000, 0x14FF5800, 0x57E3F400, 0x5370DA00, 0xAB0AEF00, 0x631C6B80, 0x5490F7C0, 0xD07A7320, 0x3C157FF0, 0xCD8CB188, 0xCFEA18C4, 0x17EE18AE, 0xE4D9883F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xB8000000, 0xC4000000, 0x26000000, 0x4F000000, 0xD4800000, 0xC9400000, 0x81600000, 0x1AD00000, 0xF0D80000, 0xDDCC0000, 0xB60A0000, 0x7F150000, 0x1AC48000, 0x669CC000, 0xE6136000, 0xBF7B5000, 0xE9BF3800, 0x35210C00, 0x2E333A00, 0x64CB1100, 0xA3B73380, 0xE835C040, 0xFDF5A1E0, 0x69D724F0, 0xE0640988, 0xDB6ED144, 0xA9FA926A, 0xF9FEE4BF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xA8000000, 0x64000000, 0xF6000000, 0x0B000000, 0xD4800000, 0x76C00000, 0x78200000, 0xBB300000, 0xE7680000, 0x55240000, 0x405A0000, 0xD84F0000, 0xB47C8000, 0x4D95C000, 0xFF712000, 0xBA88D000, 0x2EB73800, 0xC8C1DC00, 0x4720BA00, 0xA1B13F00, 0x66A98680, 0xC386E9C0, 0x14AB6420, 0x6E875BD0, 0xF3293C88, 0x30C7D6CC, 0xC7CAE2AA, 0x6AD5B213 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xA8000000, 0x04000000, 0x96000000, 0xE7000000, 0xE1800000, 0x94C00000, 0x59E00000, 0x94100000, 0xB8980000, 0x132C0000, 0x3A8A0000, 0x0CB50000, 0x28258000, 0xB2FF4000, 0xD5722000, 0x0ACAD000, 0x49173800, 0x2B976C00, 0x98D46E00, 0xFAF70700, 0xC287E580, 0x44CE7940, 0x559820E0, 0x9FAF0070, 0x62CB8B88, 0xED157E44, 0x4D95C56E, 0xC7D47931 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xA8000000, 0xE4000000, 0x5A000000, 0xFF000000, 0x09800000, 0x13C00000, 0x3C200000, 0xD2300000, 0x6BD80000, 0x833C0000, 0x4EEA0000, 0xD5650000, 0x0C168000, 0x2CAD4000, 0xF0C12000, 0x43A05000, 0x30F10800, 0xC3788C00, 0xF84C7E00, 0xBD534B00, 0x0E8B4280, 0x31B45DC0, 0xD95D76E0, 0x75385BB0, 0x99AD3C88, 0xEE4216C4, 0x9DE0B462, 0xD5114679 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0xF8000000, 0xC4000000, 0xBE000000, 0x45000000, 0xF1800000, 0x6AC00000, 0x04A00000, 0xFCF00000, 0xDC880000, 0x8E5C0000, 0xCD7A0000, 0xDF550000, 0xB3E58000, 0x3D8C4000, 0xDCC36000, 0x0DA2D000, 0xBF71D800, 0xA14AA400, 0xBC7DCE00, 0x95CB5700, 0x673D3880, 0x1BA90AC0, 0x4F6F4DA0, 0xC3D21330, 0xD9BAF688, 0x3EF75DC4, 0x8E97F52E, 0xA3C759FD } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x18000000, 0xF4000000, 0xAE000000, 0x4F000000, 0xF9800000, 0x16C00000, 0x60600000, 0x7C300000, 0x3F080000, 0x34D40000, 0xB83A0000, 0xFC5F0000, 0x052F8000, 0x7587C000, 0x7F80E000, 0x75C39000, 0xA3E19800, 0x3BF04C00, 0xF1EAEE00, 0x53A40F00, 0x5F93E380, 0x9BD871C0, 0x07AF40A0, 0x94C43910, 0x96230D88, 0x38137ECC, 0x1A1B2326, 0x0A4F88DB } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x28000000, 0xE4000000, 0x02000000, 0x79000000, 0x4D800000, 0x38400000, 0x3EA00000, 0x1DD00000, 0xCCD80000, 0x9A1C0000, 0x5C0A0000, 0xA1470000, 0x1B568000, 0x306CC000, 0x28812000, 0x0BC1D000, 0x91E1E800, 0x81F31400, 0xF7CA0E00, 0x80A69D00, 0x92A62080, 0x53A54440, 0x82279EE0, 0x046644B0, 0x8DC62E88, 0x4294D94C, 0x808F3E62, 0x28F3C0F7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xD8000000, 0xC4000000, 0xA6000000, 0xD5000000, 0x1E800000, 0x46C00000, 0xC7E00000, 0xC8500000, 0x4EE80000, 0x85A40000, 0xFDBA0000, 0x6CCF0000, 0x7A5D8000, 0x1757C000, 0xACA1E000, 0xA2F15000, 0x4918B800, 0xEA3DE400, 0x25449200, 0xF06AC700, 0x53662980, 0xB25A5440, 0x089DE520, 0x8EB6C350, 0x25F0BB88, 0x3C9B934C, 0x437C4CAE, 0xACE4571B } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x48000000, 0xC4000000, 0x06000000, 0x33000000, 0x46800000, 0x08400000, 0x25A00000, 0x87700000, 0x12580000, 0xEB6C0000, 0x842A0000, 0x7AB50000, 0xEA868000, 0x89FD4000, 0xB0A2A000, 0x22F0D000, 0x349BF800, 0x928CBC00, 0x68F93200, 0x189EE500, 0x5333D880, 0xDDF8AAC0, 0x2D1C44E0, 0x3DF257F0, 0x6018EA88, 0xC7CF4FC4, 0x6CDB1C62, 0x9F2EBD39 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x38000000, 0xDC000000, 0xC6000000, 0x51000000, 0x5F800000, 0x8A400000, 0x77200000, 0xEA900000, 0xD2580000, 0x11140000, 0x03CA0000, 0x53CD0000, 0xDA1E8000, 0xBCE5C000, 0x2B236000, 0x6C903000, 0xA359B800, 0xFE941400, 0xB18BF600, 0xF8EE0500, 0xF68C7E80, 0x3FBC7940, 0x65B6A2E0, 0xE51A2B90, 0x87B58888, 0xCE1B7C44, 0xDF365C62, 0xC2DA92DB } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x58000000, 0xEC000000, 0x72000000, 0xEB000000, 0x94800000, 0x31400000, 0x6AA00000, 0x58300000, 0x76B80000, 0x759C0000, 0x938A0000, 0xAAA50000, 0x3ED78000, 0xEB4FC000, 0x2E23E000, 0x4173F000, 0xC819E800, 0x83ADBC00, 0x24334A00, 0x4CB81100, 0x7A9C1C80, 0xF10A9BC0, 0xB6E68760, 0xB5F5E930, 0x8FBD5688, 0x7CFB8AC4, 0xA3BF1BE6, 0x2EF9B2F3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x38000000, 0x1C000000, 0x0A000000, 0xC9000000, 0xC4800000, 0x17C00000, 0x0B600000, 0xCC900000, 0xC4680000, 0xA6940000, 0x167A0000, 0xD43F0000, 0xCB0C8000, 0x0715C000, 0x373B6000, 0xBD9D3000, 0xF27C8800, 0xE92E7400, 0x86242A00, 0xDC206300, 0x36319380, 0x58998B40, 0x8FEC0920, 0x95C44690, 0xAD713988, 0x0038284C, 0xCE1CFAAA, 0x563FFDD3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x88000000, 0xE4000000, 0xAE000000, 0x03000000, 0xCE800000, 0xE4C00000, 0x52600000, 0x17100000, 0x70480000, 0xE1740000, 0x7BDA0000, 0x24FD0000, 0x174C8000, 0xD376C000, 0xFADBA000, 0x037DD000, 0xE00DD800, 0x20577C00, 0x71E9B200, 0x7C84F700, 0x3743A780, 0x13218940, 0x5B31A9A0, 0x87F9E710, 0xBB4E9588, 0x7977BE44, 0x87DBAE2A, 0x36FCBE57 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xF8000000, 0x7C000000, 0x5A000000, 0x73000000, 0xD0800000, 0x6AC00000, 0x5D200000, 0xFF700000, 0x1DC80000, 0x117C0000, 0xF13A0000, 0x7EF70000, 0xA3A58000, 0xE39D4000, 0x92E96000, 0xC90D3000, 0x02734800, 0x40489C00, 0x0E3FBA00, 0xD75ABF00, 0x91E67280, 0x807CA8C0, 0x0EBBC2A0, 0x6EB5CBB0, 0x0F464888, 0x154C57CC, 0x3C91502E, 0xB1991371 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xE8000000, 0xAC000000, 0x5A000000, 0xDD000000, 0x14800000, 0xA0400000, 0x38600000, 0x0AD00000, 0x5DB80000, 0xBD1C0000, 0xD6EA0000, 0xE8670000, 0x91D58000, 0xA53DC000, 0x24592000, 0x5F0EF000, 0x41738800, 0x26C9A400, 0xB6D7AA00, 0x7CBCED00, 0xA8980F80, 0xB32FBC40, 0x6DC36C60, 0x5AA3ABB0, 0xC5F02588, 0x7E89914C, 0x1AB7C3EE, 0x586F27F3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xC8000000, 0xE4000000, 0xEA000000, 0xC9000000, 0x43800000, 0xC4C00000, 0xBEA00000, 0xF2700000, 0x65780000, 0x8B2C0000, 0x858A0000, 0xB5150000, 0xD2C78000, 0x0B4DC000, 0x5859A000, 0x9D9DD000, 0x8E51C800, 0xB4485400, 0x1E379600, 0x3B74CF00, 0x2C175880, 0xA947E0C0, 0x838E9A60, 0x58F848F0, 0x84ED4E88, 0x85ABEFC4, 0x5227E2E6, 0x28DFB83B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x18000000, 0x8C000000, 0x8A000000, 0x9D000000, 0xA5800000, 0x99C00000, 0x47A00000, 0x87900000, 0x6FB80000, 0x04840000, 0xDCAA0000, 0x9D7D0000, 0x7B4D8000, 0x9465C000, 0x8FD8E000, 0x4FB67000, 0xCE010800, 0x7303E400, 0xC6816E00, 0x1742CB00, 0x74E3B480, 0xED72AB40, 0x19CA7960, 0xAFCF01D0, 0xD2255A88, 0x34B8A044, 0x1604ADEE, 0x2DEA1A9B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x78000000, 0xCC000000, 0x86000000, 0x7F000000, 0x84800000, 0x7BC00000, 0x0CE00000, 0xC4900000, 0x53E80000, 0xF8BC0000, 0x80FA0000, 0xA2170000, 0xB8678000, 0x0A1E4000, 0xC4C96000, 0x20CEF000, 0x0F833800, 0x15436C00, 0x3E235A00, 0x9BF27B00, 0xDC382580, 0x96762340, 0x49369920, 0x4E15D030, 0x4E66FF88, 0xBD1D184C, 0x24485CA6, 0x690F437D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xF8000000, 0x6C000000, 0x82000000, 0x39000000, 0x4C800000, 0x74400000, 0x91600000, 0x1D300000, 0x80380000, 0x49A40000, 0x5C8A0000, 0x6F5F0000, 0x130C8000, 0x1607C000, 0xA3986000, 0x7CB6F000, 0xE263A800, 0x3CB37400, 0xF6FBEA00, 0xA7844D00, 0x5D587B80, 0xA696C3C0, 0xBDB22E60, 0xB67BE2D0, 0x41C51188, 0xBD3A4ECC, 0x6326B5EA, 0xA7C8111B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xB8000000, 0x7C000000, 0x12000000, 0x33000000, 0x77800000, 0x68400000, 0xC7A00000, 0x0E500000, 0x59880000, 0xED7C0000, 0x295A0000, 0x4C370000, 0x1A458000, 0x11DDC000, 0x54886000, 0xF3FDB000, 0x219BE800, 0xCA541C00, 0x22F70600, 0xB9251500, 0xE3EE2480, 0xF2B33A40, 0x17F8EFA0, 0x8AE5AF30, 0x160EA288, 0x2C40EF4C, 0x69A12B2E, 0xCF51E573 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x58000000, 0xB4000000, 0xF6000000, 0xD9000000, 0x0F800000, 0xBF400000, 0x7E200000, 0x7D100000, 0x71E80000, 0x92FC0000, 0x287A0000, 0xE4D70000, 0xB9648000, 0xB95DC000, 0x112AE000, 0x5B9F9000, 0x574AF800, 0xC22F1400, 0x9970D600, 0x975B5100, 0x42469A80, 0x11CC4340, 0xE4814420, 0xA7C08E30, 0x33E0CC88, 0x2DF1D24C, 0xF89BBEAA, 0xADA59D73 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x28000000, 0x5C000000, 0xEA000000, 0x53000000, 0x76800000, 0xFE400000, 0x1F600000, 0x4A300000, 0x52380000, 0x507C0000, 0x7E4A0000, 0x59270000, 0x0A078000, 0x28574000, 0xB8DC2000, 0x31DBB000, 0xE70FC800, 0x0D915C00, 0x712AE200, 0xFB154D00, 0x643E7380, 0x02284FC0, 0xBD95AA60, 0x427C5FB0, 0xF948B188, 0x69A6B2CC, 0xF54411E6, 0x66B54C79 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xB8000000, 0xDC000000, 0xC2000000, 0x8D000000, 0xFA800000, 0x4C400000, 0x3A600000, 0xFDD00000, 0x4A080000, 0xF9940000, 0x879A0000, 0x7BFD0000, 0x96DE8000, 0xE0EEC000, 0x22F56000, 0x9AC93000, 0x7CB5A800, 0xA5A8E400, 0x3FE5B200, 0xCDE31D00, 0x0B118F80, 0x1C2A7040, 0x4E279EA0, 0x8841CB90, 0x14615D88, 0x2AD05D44, 0x918BB922, 0x35575FD7 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0xF8000000, 0xCC000000, 0xFA000000, 0xBF000000, 0x6D800000, 0x7BC00000, 0x04A00000, 0xD0900000, 0x19680000, 0x03C40000, 0x163A0000, 0x700D0000, 0xFC6D8000, 0xFFDE4000, 0x12E76000, 0x316AF000, 0x77C7C800, 0xC03AEC00, 0x650ECE00, 0xD6EDAB00, 0x259DC080, 0x97856F40, 0x5A582220, 0xD3BCCED0, 0xA1546E88, 0x74523444, 0x604A2AAE, 0xB0974D95 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x58000000, 0x9C000000, 0xBA000000, 0x6D000000, 0x8E800000, 0x24C00000, 0xA2200000, 0x2E100000, 0x7E980000, 0x70DC0000, 0x004A0000, 0x02670000, 0x6D868000, 0xA9354000, 0x3A7CE000, 0x3D9BB000, 0x0D5C4800, 0xD1086400, 0x95048200, 0xE2F65F00, 0xD7DCDE80, 0x4BC9AD40, 0x5C25DFE0, 0x856412B0, 0x3604BC88, 0xAF74424C, 0x4E9D4962, 0x18A9DBF1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x68000000, 0x44000000, 0x72000000, 0xAB000000, 0xE7800000, 0x28C00000, 0x4C200000, 0x69100000, 0xECF80000, 0x903C0000, 0x9F2A0000, 0x7BE70000, 0x51868000, 0xB8F6C000, 0xDA7C2000, 0x294B5000, 0x2C942800, 0x7E0F5C00, 0xED402600, 0x97E0F700, 0xCEB39A80, 0x6B2B9D40, 0x81E7A260, 0x6E873130, 0xB5779C88, 0x75BC3A4C, 0xB4EA10E2, 0xB444F07F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xB8000000, 0x14000000, 0x66000000, 0x05000000, 0x66800000, 0x67C00000, 0x34600000, 0x3DD00000, 0x84780000, 0xAAFC0000, 0x186A0000, 0xCFE70000, 0x71C68000, 0x30354000, 0xFEBF6000, 0x75499000, 0x8594B800, 0x320C6400, 0x8A63F200, 0xDCD12300, 0x0CF85780, 0x743FDE40, 0x808A6160, 0xE2F44030, 0xC45CC588, 0xA35B6D4C, 0x578C8EE2, 0x7E20FA71 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x18000000, 0x34000000, 0x82000000, 0x91000000, 0xC1800000, 0x0EC00000, 0x31600000, 0x42B00000, 0x81780000, 0x58440000, 0x3F0A0000, 0x215D0000, 0xB07F8000, 0xE3ECC000, 0x7106E000, 0xDBA99000, 0xBE0D2800, 0xE2F6B400, 0x3A717E00, 0x83184700, 0xDA751F80, 0x9933DBC0, 0x6ABA0960, 0x4AA4CB50, 0x127A8188, 0x48C60CC4, 0x90483EE6, 0xEEFCA49F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x48000000, 0xEC000000, 0xF2000000, 0x7F000000, 0x2F800000, 0x11C00000, 0xC0A00000, 0x58F00000, 0x36C80000, 0x7DA40000, 0x89FA0000, 0xFACF0000, 0x662E8000, 0x38BE4000, 0xA5A4A000, 0xCDF97000, 0x14CE2800, 0x732EAC00, 0xCC3FA600, 0x85E56300, 0x9198F880, 0xDC1E4EC0, 0x23558CA0, 0x563076D0, 0xE9EBFE88, 0x8C965DCC, 0x0B915C22, 0x899B941D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x38000000, 0x14000000, 0x8A000000, 0xA7000000, 0x5A800000, 0xF7C00000, 0x94A00000, 0xFB100000, 0xB9780000, 0x68340000, 0xDEAA0000, 0x316D0000, 0xCF4F8000, 0xDB9CC000, 0x72466000, 0xA3611000, 0x4FB18800, 0xD2686C00, 0x194C3200, 0x9A9DDB00, 0x71C4DC80, 0xD3236D40, 0xE953DE60, 0x04980B10, 0xB2448E88, 0x8362A644, 0xDFB10AE6, 0x1A6BCA5F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xB8000000, 0xA4000000, 0x6A000000, 0x15000000, 0x17800000, 0x41400000, 0x99E00000, 0x7DB00000, 0x04280000, 0x231C0000, 0xC7DA0000, 0x7C570000, 0x6FB48000, 0x1704C000, 0x6CAD6000, 0x62F0D000, 0x4ACB0800, 0x902F6400, 0x93324600, 0xE4EB8900, 0x80BFD580, 0x3B0A91C0, 0xFE0E9820, 0x23A05630, 0x3CD2F388, 0x225AC8CC, 0x3C14C5AA, 0x93D663F7 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x88000000, 0xBC000000, 0x9A000000, 0x13000000, 0xA5800000, 0x98400000, 0xECA00000, 0xF7D00000, 0x61980000, 0x8E140000, 0xCF0A0000, 0x69AD0000, 0x610E8000, 0x78DE4000, 0x0C45A000, 0xFED03000, 0x97188800, 0x93D55C00, 0xEBEB6E00, 0xFADD9500, 0x4B477080, 0x0D534C40, 0x5E592FE0, 0xFDF59290, 0x07FBBE88, 0x66A7E944, 0x68A25762, 0x69D0C2D5 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x48000000, 0x9C000000, 0xCE000000, 0xE7000000, 0x7C800000, 0x12C00000, 0x2EA00000, 0x06B00000, 0x38F80000, 0xA8C40000, 0xED8A0000, 0x491F0000, 0x8BBE8000, 0xEB0DC000, 0xB8F4A000, 0xDAB33000, 0x16F95800, 0x5FC48C00, 0xE90B5A00, 0x8FDCBF00, 0xF71D1C80, 0xC4BCC7C0, 0x1B8EDC60, 0x1C348A50, 0xC710E688, 0x3EC848CC, 0x5CFE18E2, 0xF4EE0193 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x08000000, 0xCC000000, 0x46000000, 0x6F000000, 0x44800000, 0xDBC00000, 0x98A00000, 0x0E100000, 0x85E80000, 0x23BC0000, 0x813A0000, 0x11770000, 0xD9D78000, 0x0FC4C000, 0x5E2CA000, 0x8F927000, 0xE3AA7800, 0x535EEC00, 0x3CC8DA00, 0x5BEFDB00, 0x0C336480, 0x4B382140, 0x98761420, 0xE2545930, 0xE8851E88, 0xD94E8A4C, 0x932288A6, 0x41515477 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xB8000000, 0x44000000, 0x96000000, 0xF5000000, 0xCC800000, 0x28C00000, 0x31600000, 0xE9300000, 0xDE380000, 0x6AF40000, 0x634A0000, 0x256D0000, 0x5DED8000, 0x8B2D4000, 0x534E6000, 0x34FFD000, 0x19067800, 0x3F12E400, 0xC72A5A00, 0xD0DF1F00, 0xF315CB80, 0x04B949C0, 0xF7363060, 0x7EAB1790, 0x749C7188, 0x0AB4C6C4, 0x4CEBE3EE, 0x783F6A59 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xE8000000, 0xBC000000, 0x96000000, 0x99000000, 0xF8800000, 0x9B400000, 0xD3600000, 0xC7300000, 0x42680000, 0xA4940000, 0xAE9A0000, 0xE2DD0000, 0xD05F8000, 0xD41C4000, 0xEEFD2000, 0x260F3000, 0x52443800, 0xC782F400, 0x82C32A00, 0x84A1C100, 0x75128380, 0xB13BFFC0, 0xFC4D0720, 0xBDA57010, 0x39F30988, 0x70C94EC4, 0xF8869CA6, 0xDF234BDD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x48000000, 0x1C000000, 0x6E000000, 0x9F000000, 0x7F800000, 0x68400000, 0xA6E00000, 0x28300000, 0x78180000, 0x3A540000, 0xEBEA0000, 0x0AED0000, 0x4C6D8000, 0x98AEC000, 0xA78DA000, 0xAE1D3000, 0x6F55D800, 0x716A6C00, 0x102E5600, 0x7C4F7500, 0xD6BF3180, 0x5A86EBC0, 0x64C1D0E0, 0xD7232910, 0x85914788, 0x974A6EC4, 0xD53E996E, 0x6CC69ED7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xA8000000, 0xA4000000, 0x0E000000, 0x15000000, 0x02800000, 0xA9C00000, 0xCEE00000, 0x05F00000, 0xB2180000, 0x5A640000, 0x80AA0000, 0x4D5F0000, 0xCEDF8000, 0x739D4000, 0x7DBE2000, 0xA62E5000, 0xAF065800, 0x3418A400, 0x5B66C200, 0x54293B00, 0xED9C2D80, 0x00BD66C0, 0x60ACE2E0, 0x18C6A4D0, 0x47FB4F88, 0xF8174DCC, 0x41F0B766, 0x6C193611 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x98000000, 0x1C000000, 0xAA000000, 0x07000000, 0x61800000, 0x59400000, 0x89200000, 0xB4D00000, 0x5B080000, 0x968C0000, 0xA11A0000, 0xD0E50000, 0x9CE68000, 0xEEE44000, 0xD5E5E000, 0xCE64B000, 0x08240800, 0xFC86CC00, 0xBB15FE00, 0x6E3D0100, 0x2DE3C680, 0x8EB05440, 0x41F8CFA0, 0xC8D5AAF0, 0xADDD5888, 0x7251A544, 0xF3C8E122, 0xFEEE82BD } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xC8000000, 0x84000000, 0x52000000, 0x9B000000, 0x13800000, 0xA3C00000, 0xF9200000, 0xC2D00000, 0x71B80000, 0x7CA40000, 0xC52A0000, 0x16FD0000, 0x2EFC8000, 0x12FD4000, 0x3CFEA000, 0x29FDD000, 0xBF7DA800, 0x423C9C00, 0xC25FF600, 0xD2EF5B00, 0x28E67E80, 0xBDC81E40, 0x4E0F3760, 0x52170850, 0xA223A888, 0x3153D544, 0xE27841EA, 0xDD875A19 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x18000000, 0xFC000000, 0xF2000000, 0xF7000000, 0x4B800000, 0xA8400000, 0x4C200000, 0x11D00000, 0x47D80000, 0x77BC0000, 0x43CA0000, 0x9D050000, 0xCF068000, 0xA8044000, 0xDB87E000, 0x5FC73000, 0xF9E76800, 0xE3348C00, 0x1D6DB600, 0x3591E500, 0x71F95A80, 0x556F8C40, 0x919164E0, 0x5FF9A230, 0x806D8C88, 0x35111944, 0x403AB662, 0x960C927D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x88000000, 0x34000000, 0x62000000, 0xFD000000, 0x7A800000, 0x05400000, 0x22200000, 0x3E100000, 0x1C780000, 0x0D7C0000, 0x18AA0000, 0x30E70000, 0xBAA58000, 0x0707C000, 0xAAD4A000, 0xFFCC9000, 0xCD83E800, 0x26C34400, 0xE7E3D200, 0xE8725900, 0xA4C9EE80, 0x8157AB40, 0xCE0D7A60, 0x99E34E30, 0xD3711C88, 0x9949A24C, 0x0F965CEE, 0x4DECF17B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xB8000000, 0x04000000, 0xF2000000, 0x5F000000, 0x70800000, 0x02400000, 0x9AA00000, 0x49F00000, 0xC9E80000, 0x08BC0000, 0x9FDA0000, 0x96350000, 0xC6F48000, 0xF9164000, 0xFEC76000, 0xDE9CD000, 0x6269E800, 0xC87D4C00, 0xF8393A00, 0x65E40D00, 0xFCAF6C80, 0xA6E008C0, 0xD2535220, 0x419808B0, 0x4A97B688, 0x6A0795C4, 0xF37C36AA, 0xCABADC75 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x18000000, 0x1C000000, 0xF2000000, 0x97000000, 0x74800000, 0x8C400000, 0x23200000, 0xDFF00000, 0x1C080000, 0x1B9C0000, 0x3E3A0000, 0x5B770000, 0xD9B58000, 0xC5D64000, 0x9386E000, 0x713DB000, 0xB20A6800, 0x5E9D8C00, 0xEDB8CA00, 0x6BB7F500, 0x72D55A80, 0xD70738C0, 0x357C6BA0, 0x952B9230, 0x6F6CF088, 0x94B03DCC, 0x93AA392E, 0xB42DD6FD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x48000000, 0xBC000000, 0xD6000000, 0x29000000, 0x0C800000, 0x8E400000, 0xD4200000, 0x8FB00000, 0xC2B80000, 0xBEC40000, 0x0CCA0000, 0x959D0000, 0xA25D8000, 0xF2BEC000, 0xD66DA000, 0xC7C7B000, 0x984B3800, 0x7FDC3400, 0x247CFA00, 0x760CD500, 0x5B57CE80, 0x04C079C0, 0xEB63CD60, 0x3310AA50, 0x91491488, 0xA35CDCC4, 0x723D1BEE, 0x262C9797 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xD8000000, 0xAC000000, 0x76000000, 0x25000000, 0x0F800000, 0x0CC00000, 0x3EE00000, 0x09500000, 0x7E580000, 0xB91C0000, 0xBB4A0000, 0x51E70000, 0x2FA58000, 0x7E04C000, 0xD375E000, 0xCF9DF000, 0xD609F800, 0x0AC40400, 0x11947600, 0xF8CC6F00, 0x8952D980, 0xBE5A9440, 0x591D63E0, 0xCB48B3B0, 0x89E4CF88, 0x83A4CB4C, 0x0804226E, 0xF67413F7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x28000000, 0x04000000, 0xEE000000, 0xB5000000, 0x17800000, 0xA0400000, 0x55A00000, 0xFB100000, 0x13E80000, 0xFDEC0000, 0x9D5A0000, 0x05170000, 0x8B5F8000, 0xF9A3C000, 0xD1122000, 0x28EB5000, 0xEF6DD800, 0x02986400, 0xF4F4F600, 0xCBEC6D00, 0xA4581C80, 0x28971340, 0xE81EC820, 0x22819570, 0x77C13288, 0x95E31A4C, 0x1EB222A6, 0xC0FAEB3B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x58000000, 0x04000000, 0xCA000000, 0x07000000, 0x77800000, 0xBAC00000, 0x26600000, 0x6B900000, 0xBAD80000, 0x443C0000, 0xC72A0000, 0x6D770000, 0x2DCF8000, 0x0C60C000, 0xDC93E000, 0xF5585000, 0x8AFF8800, 0x734B6C00, 0x05E5E600, 0x2A965F00, 0xF59D9B80, 0x4A5B7B40, 0x497FC9E0, 0x3B882F30, 0x5087F588, 0xA486484C, 0xF687B466, 0x95850B77 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x08000000, 0xFC000000, 0x26000000, 0x97000000, 0xEA800000, 0x53400000, 0xC6600000, 0x99500000, 0x1C080000, 0x499C0000, 0xBB3A0000, 0xF8C70000, 0x94AC8000, 0xCB60C000, 0xA2D1A000, 0xE2C8B000, 0x4E3D7800, 0x434B8C00, 0x61FFC200, 0xE96B0900, 0x584C2F80, 0x11702240, 0xA0BB14A0, 0xB60662B0, 0x3B0E9588, 0xBF10A74C, 0x15E8F92A, 0xF40D49F7 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x58000000, 0xF4000000, 0x2A000000, 0xFD000000, 0x2D800000, 0xF8400000, 0xA8600000, 0x7C900000, 0xAF380000, 0xCB9C0000, 0x57CA0000, 0x06370000, 0xC46E8000, 0x1AE04000, 0x1852E000, 0x7C9A1000, 0x382C8800, 0x50834400, 0x15C0CE00, 0x70203D00, 0x84F0A380, 0x8BABC540, 0x90A42C60, 0xB656D5B0, 0xACFCE588, 0xEFD8BC4C, 0x26CC41E2, 0xAAD12DF5 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x08000000, 0x9C000000, 0x82000000, 0x47000000, 0x5E800000, 0x61400000, 0xB3A00000, 0x41F00000, 0xC9380000, 0x3E540000, 0x696A0000, 0x399F0000, 0xFC848000, 0xDDE04000, 0x50D1A000, 0x9B89B000, 0x5BCF6800, 0xDC4D4C00, 0xE68C0200, 0x8DED1100, 0x107C6880, 0x425718C0, 0xDB68FF60, 0x869FA810, 0x66070288, 0xAAA345CC, 0xBA7295EA, 0x41FAA1D5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x98000000, 0x3C000000, 0xBA000000, 0x03000000, 0xA9800000, 0x29400000, 0xD1600000, 0xF7100000, 0x43080000, 0xBD440000, 0x977A0000, 0xDE5D0000, 0xBEB78000, 0x6823C000, 0xAE72E000, 0x4019B000, 0xD04C4800, 0x373C9C00, 0x65A7BE00, 0x5928C100, 0x8435AF80, 0x60E0FF40, 0xA251BCA0, 0x486B94D0, 0x79565988, 0xE5F0A244, 0x7659AD26, 0x42AEAA93 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x68000000, 0xB4000000, 0x0A000000, 0xAF000000, 0x69800000, 0xF8400000, 0x58200000, 0xAC900000, 0x5E780000, 0xD5040000, 0x2CCA0000, 0x1EED0000, 0xBF378000, 0x03E04000, 0x83F12000, 0x73481000, 0x67AEC800, 0x2397CC00, 0xF5B05E00, 0x7669F500, 0xB1BCBA80, 0x822C1540, 0x4DD78860, 0xDC90FED0, 0xC67A2C88, 0xB9062C44, 0x2AC96CE6, 0x67EC1E9D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x98000000, 0x9C000000, 0xF2000000, 0x1D000000, 0x8F800000, 0x15C00000, 0x23200000, 0xDA300000, 0xDE180000, 0xCB3C0000, 0xFA0A0000, 0x60950000, 0x8AEF8000, 0xFA834000, 0xCE42E000, 0xA0E3B000, 0x9A11E800, 0xFCA86400, 0x0E678600, 0x7A55EB00, 0x6B4DC680, 0x42F381C0, 0xAABB63E0, 0xF8CF68B0, 0xE531A888, 0xF49B0EC4, 0xBD7EA366, 0xB6EA4271 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xE8000000, 0xC4000000, 0xCE000000, 0xBB000000, 0x13800000, 0xE6C00000, 0x06600000, 0x5FD00000, 0x65880000, 0x44BC0000, 0xC33A0000, 0xE3650000, 0x5FCD8000, 0x61034000, 0x2E812000, 0x7A40D000, 0xC520D800, 0x28725C00, 0x25B86600, 0xED264F00, 0x4CECBB80, 0xCE71AA40, 0xFAB894A0, 0xC0A7B430, 0xE92E0588, 0xF790B944, 0x49A9C92E, 0xD64F1171 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x28000000, 0xAC000000, 0x32000000, 0x6B000000, 0xE2800000, 0xEEC00000, 0x0E600000, 0x03900000, 0x8F680000, 0xE3B40000, 0x5D9A0000, 0x8BCD0000, 0xF2848000, 0x54024000, 0xF6032000, 0x55017000, 0xEB812800, 0x4F43BC00, 0xAE21F200, 0xD132DF00, 0xE99A1F80, 0x8DCC3F40, 0xDF87BF20, 0x3B80B910, 0x2740C588, 0xA2205C44, 0xB330D2AA, 0xAA981955 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xA8000000, 0xB4000000, 0xCE000000, 0x63000000, 0x5B800000, 0xF6C00000, 0x96E00000, 0x6A100000, 0xFB080000, 0xD61C0000, 0x2AFA0000, 0x3F850000, 0xCAAF8000, 0xF3424000, 0x8B222000, 0x23721000, 0x51D8D800, 0xC4F5FC00, 0xB7768600, 0xB5B66F00, 0x8D543980, 0xD444DD40, 0xDCCF0CA0, 0x48131BB0, 0x3A086788, 0x0C9E4E44, 0x66B83326, 0xB526E9F5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x58000000, 0x5C000000, 0x12000000, 0x11000000, 0x82800000, 0xBB400000, 0xF4A00000, 0x3A700000, 0xC4580000, 0x86C40000, 0xB98A0000, 0x536D0000, 0x4ED48000, 0x19C2C000, 0x7FE2E000, 0x36D23000, 0xD228E800, 0x089C5400, 0x724D3200, 0x7A65E100, 0xB7F81C80, 0x21364EC0, 0xE7120EE0, 0x79C9F050, 0x584FC688, 0xA766FBC4, 0xAF79A06A, 0xFF759F97 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x48000000, 0xCC000000, 0x8A000000, 0xE1000000, 0x84800000, 0x50C00000, 0x91200000, 0xBB100000, 0xE4480000, 0x23240000, 0x957A0000, 0x81FD0000, 0x22568000, 0x20414000, 0x3FE0A000, 0x7531F000, 0xA4D94800, 0xFC2D9400, 0x543D0A00, 0x81F7EF00, 0x58905280, 0x3B0A7D40, 0x374776A0, 0xB30A7450, 0x9B461088, 0x89090644, 0xA246AE22, 0x898BA619 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0xB8000000, 0x4C000000, 0x72000000, 0xCD000000, 0xFB800000, 0x7A400000, 0xBB600000, 0xCCD00000, 0x19880000, 0xBA6C0000, 0x3D3A0000, 0x7BB70000, 0x4A1E8000, 0x1A434000, 0xCB616000, 0xC4D3F000, 0x7D896800, 0x3C6CE400, 0xCE391600, 0x3F341500, 0x06DCB780, 0x20E27440, 0xC69202A0, 0xAAE8C770, 0x12BEC988, 0xA2B1854C, 0x32DB2322, 0x33A6E639 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x08000000, 0x1C000000, 0x62000000, 0x01000000, 0x9C800000, 0x1EC00000, 0x50600000, 0x7EB00000, 0x2DE80000, 0x38040000, 0x7FBA0000, 0xE59F0000, 0x52378000, 0x90904000, 0x8FFAA000, 0x023CB000, 0xCC66E800, 0xE7095400, 0xDF750A00, 0xD9B33700, 0x06695780, 0xA54623C0, 0x9E9B3520, 0x400EF750, 0xCF4D3588, 0xD76C00CC, 0xCA7DC8A6, 0x6FC75395 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xD8000000, 0xBC000000, 0xBE000000, 0x6F000000, 0x0D800000, 0x35400000, 0x3A200000, 0xE6D00000, 0x72680000, 0x75AC0000, 0xAB1A0000, 0xC0570000, 0xACFD8000, 0x2533C000, 0xB15BE000, 0xD7F7B000, 0x2F6D5800, 0x05792C00, 0x4624BE00, 0x0C84D100, 0x4B95C280, 0x601C6840, 0x9B81BC20, 0x1E40C170, 0x65A1A488, 0x6A92554C, 0x4ECB20AE, 0xA9BFC83B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x18000000, 0x94000000, 0xE6000000, 0xBD000000, 0x0F800000, 0x99400000, 0xAE200000, 0x4CD00000, 0x94F80000, 0xC2240000, 0x358A0000, 0x514D0000, 0xE6758000, 0xD0B14000, 0x0C8AE000, 0xE0CF9000, 0xB637B800, 0x0713C400, 0x7C1B7600, 0x4196C900, 0x47805280, 0xB5405840, 0xAC20C660, 0x9FD3AF50, 0xAA791C88, 0x26E41544, 0x59E902EE, 0x013EAE19 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xC8000000, 0x44000000, 0xC6000000, 0x2F000000, 0x50800000, 0xE8C00000, 0x77E00000, 0x50D00000, 0xDDB80000, 0x82140000, 0xB80A0000, 0xD6BD0000, 0x33C78000, 0x7E33C000, 0x7AEBA000, 0xC3EC5000, 0x533EF800, 0xAE858C00, 0x7C91CA00, 0x3C984700, 0x66264180, 0xD7E35240, 0x40D12260, 0x45B9A090, 0x3E16F388, 0xF2095944, 0x7BBF09E6, 0x8A47E5D3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xB8000000, 0x24000000, 0x16000000, 0x33000000, 0x66800000, 0x68C00000, 0x3BE00000, 0x5D900000, 0x4DE80000, 0xD9840000, 0xAE1A0000, 0x4FBD0000, 0xD5568000, 0x1C52C000, 0xB98B6000, 0x6355D000, 0x1F517800, 0x470BBC00, 0x5F95D200, 0x8AB2F700, 0x0D9A5980, 0x62FD5F40, 0x08F7E320, 0xFEE3D3D0, 0x18127388, 0xABABD444, 0x66A588A2, 0x426B6B97 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x88000000, 0x74000000, 0x66000000, 0x4F000000, 0x4F800000, 0x6CC00000, 0x3BA00000, 0x19D00000, 0x77380000, 0x57540000, 0x7DCA0000, 0x3EFF0000, 0xC4C68000, 0x9D134000, 0x4899A000, 0x10871000, 0x29F3F800, 0xBC29CC00, 0x88CDF600, 0xFECD5700, 0xF9CFCC80, 0xE24CBA40, 0x788ED960, 0x842D0890, 0xA67D4288, 0xDB84614C, 0xF873C3E2, 0xD3E8B5D9 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x38000000, 0x5C000000, 0xC6000000, 0x2B000000, 0x54800000, 0xA6400000, 0x32600000, 0x48B00000, 0x87880000, 0x14DC0000, 0x9EDA0000, 0xCF270000, 0x02AD8000, 0x03704000, 0x5E286000, 0xF5CFB000, 0x7040B800, 0x01623C00, 0xF030BA00, 0x8FC86D00, 0x69BDD780, 0x18E999C0, 0x03EC56A0, 0x5B909430, 0x27DA5588, 0x82A488CC, 0x996CDB2E, 0x22D290F5 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xC8000000, 0x6C000000, 0xFA000000, 0xF9000000, 0xD2800000, 0x42C00000, 0x9D600000, 0xFF900000, 0x01D80000, 0x92840000, 0xF4AA0000, 0x0E8F0000, 0x0D568000, 0x72D04000, 0x7AF8A000, 0xC1B47000, 0x24038800, 0x56027400, 0x23019200, 0x7B804700, 0x5841FB80, 0xB3A00F40, 0x98F091E0, 0x074825D0, 0x41DF6188, 0x24ED7C4C, 0x6746D862, 0xFC485D95 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xD8000000, 0x94000000, 0xB6000000, 0x11000000, 0x3D800000, 0x95400000, 0xDAA00000, 0xD7900000, 0xCB380000, 0xAC8C0000, 0xF68A0000, 0x42E70000, 0x9DDF8000, 0x47514000, 0xC0D9E000, 0xAFBF9000, 0x7F23F800, 0x76D27400, 0xD799FE00, 0xA21C8900, 0x4C32B880, 0x5928AD40, 0x16F54B60, 0xFEA482F0, 0x3EFD3E88, 0x0B80104C, 0x44406DE6, 0x872276B1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xB8000000, 0xA4000000, 0x26000000, 0xF5000000, 0x36800000, 0x8E400000, 0x44600000, 0x77D00000, 0xF8380000, 0x2A240000, 0xFE0A0000, 0x000F0000, 0x5CB58000, 0x23D0C000, 0xA63A6000, 0x9B24D000, 0x9E89B800, 0xC34CA400, 0x8A575200, 0xFC41B500, 0xEF607F80, 0xF053EC40, 0x16FB7060, 0xAD07C250, 0x5F391588, 0x27A53D4C, 0x3FC9BDEE, 0xB6AE8B17 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x48000000, 0x04000000, 0xF6000000, 0x69000000, 0xA4800000, 0x6CC00000, 0xFBA00000, 0xAB900000, 0x0AD80000, 0xAC940000, 0x762A0000, 0xD67F0000, 0xEBF58000, 0x3E18C000, 0xAB35A000, 0x87B85000, 0x37A43800, 0x34E11400, 0xED739A00, 0xB8A96F00, 0x39BD0880, 0xF7D57740, 0xFECAC2E0, 0x410E3890, 0x285F0A88, 0x4C255C4C, 0xB5A0686E, 0x4E9334D7 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xE8000000, 0xD4000000, 0x66000000, 0x43000000, 0x34800000, 0x16400000, 0xEBE00000, 0xDD700000, 0x1E180000, 0x7F7C0000, 0x0ECA0000, 0x0FF50000, 0x7EDE8000, 0xEA584000, 0x199E2000, 0x503A9000, 0x852C7800, 0x57037C00, 0x32805A00, 0xA543ED00, 0xE7626180, 0xF731C6C0, 0x47F9D2E0, 0x870C6DB0, 0x67506388, 0x524BC7C4, 0x8DB79162, 0xD33D3A7D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x28000000, 0x6C000000, 0x52000000, 0x43000000, 0x21800000, 0xDCC00000, 0x79A00000, 0x6F900000, 0x1C280000, 0xE9E40000, 0x0EDA0000, 0x47FD0000, 0x3A848000, 0xB5EBC000, 0xBCC72000, 0x0509F000, 0xC0342800, 0x42109C00, 0x42E9BE00, 0x6B451700, 0x34CB1C80, 0x9116A340, 0xD7C2D920, 0xE423F150, 0x5951AA88, 0x528AD844, 0xB1F453AA, 0xB330D913 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x88000000, 0x2C000000, 0xEA000000, 0x73000000, 0x51800000, 0xEAC00000, 0x09E00000, 0x28100000, 0x88680000, 0x236C0000, 0x5F5A0000, 0xF8F70000, 0x6B4F8000, 0x4B2A4000, 0x144CA000, 0x80A87000, 0xB58DC800, 0xACC8DC00, 0x395E1E00, 0x98406F00, 0xFAA05D80, 0x87324540, 0x939B9120, 0x7814C470, 0x89DF2B88, 0x8402864C, 0xB6001AA6, 0xA102323D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x48000000, 0x14000000, 0x52000000, 0x7B000000, 0x4A800000, 0x02400000, 0xBFA00000, 0xF6300000, 0xBB580000, 0xC6740000, 0x028A0000, 0x5FBD0000, 0xDB178000, 0x4E5BC000, 0xF1F5A000, 0x034B1000, 0xE3DDA800, 0x92471C00, 0xAAD3F200, 0x97490D00, 0xF1DF2880, 0x894453C0, 0xD05386E0, 0xDD0A8D90, 0x5A7CD288, 0x2D7552C4, 0x1008F466, 0x51FDCF53 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xF8000000, 0x04000000, 0xCA000000, 0xE5000000, 0x5F800000, 0xF1400000, 0x07A00000, 0xA6F00000, 0x82880000, 0xF68C0000, 0xB49A0000, 0xB6550000, 0xCAEE8000, 0x0308C000, 0x40CE6000, 0x25B95000, 0x78660800, 0x6D86E400, 0x20568600, 0x51EF1900, 0xAB8AA480, 0xFF0EA8C0, 0xBED8F5A0, 0xC9763970, 0xDBDC4A88, 0xE6E205C4, 0xC950DF22, 0x08786CBF } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x08000000, 0x64000000, 0x62000000, 0xB9000000, 0x10800000, 0xAE400000, 0x82600000, 0xA4F00000, 0xF4580000, 0x318C0000, 0x458A0000, 0xB3C50000, 0x2AEC8000, 0x41F8C000, 0x41DFA000, 0x0D02D000, 0xCA836800, 0xDB41D400, 0x64E39A00, 0xD9B1F500, 0xBBB93F80, 0x49BDE0C0, 0x24F385E0, 0xB4591E70, 0x918C6D88, 0xB58A11C4, 0xBBC6C86A, 0x4EEC1FBF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x98000000, 0x24000000, 0xDE000000, 0x31000000, 0x17800000, 0xD3C00000, 0xE9200000, 0x2CD00000, 0xA5380000, 0xD1A40000, 0x4A0A0000, 0xDAEF0000, 0x9B848000, 0x325A4000, 0x4897E000, 0x7C435000, 0x0EE15800, 0x23F0B400, 0x4CE8F600, 0x251E9300, 0x5D6DAE80, 0xB045DA40, 0x8F793B60, 0xF246CF50, 0x5479E088, 0x32C7AD4C, 0x5539BBEA, 0x59A7721D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x28000000, 0xF4000000, 0x7E000000, 0x6F000000, 0x55800000, 0xB7C00000, 0xFA600000, 0x04900000, 0xB2280000, 0x0A1C0000, 0x621A0000, 0x18470000, 0x3AFD8000, 0x8CCBC000, 0x43CC2000, 0x28109000, 0xEB689800, 0x3C3D4C00, 0xDC2BBE00, 0xDD1D3B00, 0xBB995380, 0xBD87A340, 0x0D9F6220, 0x38DA95B0, 0x02A45588, 0x552C444C, 0x95C297AE, 0xDF6181FB } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x08000000, 0xC4000000, 0xF2000000, 0x4F000000, 0xD7800000, 0xA7C00000, 0x9B200000, 0x48900000, 0x40480000, 0x041C0000, 0x713A0000, 0x23670000, 0xABBE8000, 0x2FEBC000, 0x7ACFA000, 0x98935000, 0x184A2800, 0x581E8C00, 0xFF3B4600, 0x52674B00, 0x053D9E80, 0xE2A8EB40, 0xDEAF6EA0, 0x3B6350B0, 0x2C715088, 0xCFF97C4C, 0x82C71E22, 0x446EBCFB } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x08000000, 0x5C000000, 0x96000000, 0x0F000000, 0x3A800000, 0xA0400000, 0x27200000, 0x5F500000, 0x3FC80000, 0x16040000, 0x02FA0000, 0x423F0000, 0x99A78000, 0x90E94000, 0xD556A000, 0xCB32B000, 0x4B393800, 0xA9DCEC00, 0x2E958200, 0xFDD1C500, 0x0B8BBA80, 0x9B248E40, 0xD4A8BEA0, 0x407703D0, 0x4963A088, 0x8370174C, 0xE01A3E26, 0x088CE491 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x78000000, 0xE4000000, 0x1A000000, 0x43000000, 0x45800000, 0x20C00000, 0xA7600000, 0x97300000, 0xF8480000, 0xB9940000, 0x0DDA0000, 0xF90F0000, 0x3F748000, 0x602BC000, 0x45246000, 0xE451D000, 0xCD784800, 0x46DDFC00, 0x5BCE2E00, 0xEF150700, 0xC09A9780, 0xF2ACE1C0, 0x392753A0, 0xCA528110, 0xFC7A9188, 0x6C5ECACC, 0xB88D222A, 0xD5B65BDB } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x98000000, 0x9C000000, 0xC2000000, 0x53000000, 0x94800000, 0x94C00000, 0xC9600000, 0x00500000, 0x94880000, 0x35AC0000, 0x3DFA0000, 0x0CD70000, 0xFDEE8000, 0x84594000, 0xABE5E000, 0x7034B000, 0xE6FC2800, 0xFDF0DC00, 0x8DB8EA00, 0x1976B700, 0x10DE6B80, 0x5E821840, 0x03C090A0, 0x23E32470, 0x1591C988, 0x0269834C, 0xA9BFD922, 0x36D3E731 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x38000000, 0xC4000000, 0xFA000000, 0x65000000, 0xBF800000, 0xB3400000, 0x07E00000, 0x8F700000, 0x79080000, 0xD2540000, 0xD55A0000, 0xAC8F0000, 0xE8968000, 0x52FB4000, 0xD89F6000, 0xD92FD000, 0x55844800, 0xFAC3E400, 0xA7A3C600, 0xE4129100, 0x09BAC580, 0xC37E16C0, 0xD85C5AA0, 0x1B8CE910, 0x0E14AB88, 0x403BF3CC, 0x633E7122, 0xB33C5AD9 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x78000000, 0x74000000, 0xB2000000, 0x4D000000, 0x86800000, 0xAC400000, 0x1CA00000, 0x4B700000, 0xE4780000, 0x875C0000, 0x2D6A0000, 0x0AB50000, 0x049F8000, 0xC10BC000, 0xE0256000, 0xBFB69000, 0xB61CE800, 0xBF4B8400, 0x81854200, 0x0A47ED00, 0x8A24AC80, 0x96B5FEC0, 0xAA9D3E60, 0x62090430, 0xA5A7E688, 0x6674C7C4, 0x0B7D58E6, 0x3D5A03F3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0xF4000000, 0x32000000, 0xFF000000, 0x65800000, 0x3A400000, 0x21E00000, 0x3DB00000, 0x47280000, 0x887C0000, 0x48BA0000, 0x77450000, 0x8ABE8000, 0x819B4000, 0xE0D5A000, 0xC9851000, 0xA59FA800, 0xCB0B8C00, 0x316F4E00, 0x46413D00, 0xA7E05D80, 0xD0B231C0, 0xCDA9D620, 0xDFBCD2B0, 0xA71B9B88, 0x5916D0C4, 0x0F24CDA2, 0x2B4D4271 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0xA8000000, 0x6C000000, 0x7E000000, 0x4F000000, 0xA8800000, 0x21400000, 0xB5A00000, 0xE3100000, 0xC0680000, 0xF80C0000, 0xA11A0000, 0xE0950000, 0xB74C8000, 0x63BAC000, 0xBF052000, 0x9C64F000, 0xDB159800, 0x088FAC00, 0x045AAA00, 0xE734A100, 0x155F1880, 0xEC518340, 0xA2C90620, 0xD79E2CF0, 0x22318A88, 0x3438BE44, 0x7EC60CAA, 0xB48552B7 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x38000000, 0xDC000000, 0x3E000000, 0x51000000, 0x65800000, 0xB1400000, 0xD9E00000, 0x68D00000, 0x84B80000, 0xB24C0000, 0x7F4A0000, 0xD7870000, 0x850E8000, 0xEBA8C000, 0xC4D76000, 0x91F43000, 0xDD84D800, 0xBE0F5400, 0x252A5E00, 0xD315D900, 0xCBD76580, 0x35755840, 0x61441C60, 0x42AF17F0, 0x4E180388, 0x8C7F254C, 0xF7A09FE2, 0x7DB3F2B7 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xE8000000, 0xCC000000, 0x4A000000, 0x11000000, 0xF3800000, 0x51400000, 0xAE200000, 0x59900000, 0x6C580000, 0x2C8C0000, 0x3F2A0000, 0xFD250000, 0x0ACF8000, 0x498BC000, 0x9F772000, 0x96747000, 0x61F54800, 0xE6B65400, 0xCB979600, 0x5485C900, 0x1C1FE280, 0x94F01540, 0xBEEBF0E0, 0xD4C41EF0, 0x61BD9C88, 0xCC203844, 0xA493EC66, 0x85DAE6B3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x18000000, 0xA4000000, 0xC6000000, 0xB1000000, 0x78800000, 0xD9400000, 0x5C600000, 0xAA900000, 0x8F480000, 0xE7440000, 0xEA7A0000, 0x88BD0000, 0x69058000, 0x4F994000, 0xEBEEE000, 0x4F6D5000, 0x242E3800, 0xF74CB400, 0xA05EAA00, 0x50D41900, 0x27B26780, 0x85B90540, 0x409EC5A0, 0x6576C8D0, 0x54019588, 0x0E01B844, 0xED00D02E, 0x8A833099 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x48000000, 0xAC000000, 0xC2000000, 0x41000000, 0x31800000, 0x49C00000, 0xD3A00000, 0x82300000, 0x65480000, 0x3FA40000, 0x8A9A0000, 0x3DBD0000, 0x1B678000, 0xEABB4000, 0xD74DA000, 0x8C0D7000, 0x56ED6800, 0x473C1400, 0xCE27BE00, 0xE358CB00, 0x9E1DDC80, 0xC154B1C0, 0x6BF120A0, 0x86E862D0, 0x85952A88, 0x1BD25EC4, 0x24198A26, 0xBEFC7C11 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x28000000, 0x9C000000, 0x86000000, 0x77000000, 0x75800000, 0x87C00000, 0x63600000, 0xAD500000, 0x63D80000, 0x62040000, 0xE0AA0000, 0x51AD0000, 0xB6868000, 0x2DE94000, 0xEC8D2000, 0xC176B000, 0x4303F800, 0x2F828C00, 0x56C37E00, 0xF1E33B00, 0x77135780, 0x1B791440, 0x2A35D9E0, 0x5920BAD0, 0x25F27188, 0xB3EA5344, 0xFF8DA862, 0xA6F7E999 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xA8000000, 0xA4000000, 0xB2000000, 0x01000000, 0x2A800000, 0x14400000, 0x07200000, 0xB8700000, 0x2FD80000, 0x9DD40000, 0x854A0000, 0x8E9D0000, 0xF8D48000, 0xFDCA4000, 0x6BDD2000, 0x2D775000, 0x5DFA2800, 0x5527B400, 0xBBD13200, 0xDCE87D00, 0x78AE0280, 0xD52D02C0, 0x10EF9EE0, 0x7C0F3410, 0xB79EB888, 0x3E56DBC4, 0x0F89266A, 0x27FDEFD5 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x18000000, 0x8C000000, 0xFE000000, 0x45000000, 0x13800000, 0x42400000, 0xCD600000, 0xB9D00000, 0x08580000, 0xC1340000, 0x11360000, 0x39370000, 0x8D378000, 0x8F364000, 0x2C362000, 0xF6B41000, 0x5977E800, 0x9356FC00, 0xF466B200, 0x07AFBB00, 0x03A08E80, 0x6A7069C0, 0x4A2948A0, 0x3F1ECC70, 0x2C2948A8, 0xB61ECC74, 0xE1A948AA, 0xC15ECC73 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xA8000000, 0xE4000000, 0xC6000000, 0xCD000000, 0x3B800000, 0x77400000, 0xDD600000, 0x7C500000, 0x56480000, 0xC4740000, 0xCC760000, 0xF8750000, 0xB6758000, 0x8F75C000, 0xDAF76000, 0x84B4F000, 0xA457E800, 0x6244DC00, 0xD2EC3200, 0x1D89EF00, 0x5AD49A80, 0x1A846BC0, 0x36CEB2E0, 0x85B96330, 0x254EB2E8, 0xD6F9633C, 0x1E2EB2EA, 0x77A9633D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x08000000, 0xEC000000, 0xBA000000, 0x7D000000, 0x8B800000, 0xE9C00000, 0xEAA00000, 0x80D00000, 0x97680000, 0x7A6C0000, 0xE66E0000, 0xA46F0000, 0x8D6E8000, 0x88EDC000, 0x422DE000, 0x080E5000, 0x2D9CB800, 0x4F154C00, 0x3D4B6200, 0xCFFEC500, 0xECE66F80, 0xEA30ECC0, 0xCDDA7160, 0x3AF5F8D0, 0x757A7168, 0xBB25F8D4, 0xBB92716E, 0x6989F8D9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x38000000, 0xB4000000, 0x8A000000, 0x63000000, 0x88800000, 0x08C00000, 0xC5600000, 0x85900000, 0xE0380000, 0x6D5C0000, 0x115E0000, 0xC75F0000, 0x425C8000, 0x07DEC000, 0x569E2000, 0xC4BCF000, 0x8E0ED800, 0x45075400, 0x00117600, 0x117B5500, 0x8F7D4080, 0xF3EED6C0, 0x80561620, 0x3948C350, 0xFFB61628, 0x2318C354, 0x386E1626, 0x3014C35D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xE8000000, 0x54000000, 0xFE000000, 0x5B000000, 0x04800000, 0x5FC00000, 0x62600000, 0x6F700000, 0x12C80000, 0x4EDC0000, 0xC4DE0000, 0xB1DF0000, 0x965C8000, 0x011D4000, 0x7EBEE000, 0x82AFB000, 0x5E944800, 0x02C12400, 0xB1E33600, 0x96334900, 0xAE694080, 0x0A4D3D40, 0xED24D660, 0x2AE9BD10, 0x158CD668, 0x6F45BD14, 0x359AD666, 0xEF46BD13 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x38000000, 0x74000000, 0x46000000, 0xDB000000, 0x15800000, 0x91400000, 0xFF600000, 0x8A300000, 0xC0C80000, 0xBE340000, 0x9C360000, 0x99370000, 0x13B48000, 0x3977C000, 0xC0572000, 0x9286F000, 0xD43FE800, 0x9B208400, 0xB7D2D200, 0x1C399700, 0x5DDDEA80, 0xA1D28240, 0xBF3A6160, 0xDC5FC9B0, 0xA6926168, 0xA35BC9B4, 0x37EC6166, 0xB118C9B9 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0xE8000000, 0x74000000, 0x4E000000, 0x3F000000, 0xCD800000, 0xA1400000, 0x33E00000, 0x94F00000, 0x3E280000, 0xB24C0000, 0xDD4E0000, 0x38CD0000, 0x4D8F8000, 0xE06CC000, 0xA39F6000, 0x2436B000, 0x793B8800, 0xA8957400, 0xC92B4200, 0x1BCE4700, 0x7A0E4880, 0x902D7B40, 0xB2FE33E0, 0x3404F2D0, 0xA1B033E8, 0xF3C9F2DC, 0x81BFB3E2, 0x62E532D1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x78000000, 0x24000000, 0xAE000000, 0x5F000000, 0xA0800000, 0xB1400000, 0x43E00000, 0xEF700000, 0x4CA80000, 0x411C0000, 0x961E0000, 0xBA9F0000, 0x19DC8000, 0x1F3EC000, 0xD9CF2000, 0xFFA7B000, 0x42990800, 0x96567400, 0x6C73F600, 0x2629B300, 0xE15C7C80, 0xBA7DE140, 0x3C2EE3E0, 0x83D7AF90, 0x5CB0E3E8, 0xB308AF94, 0xE80C63E6, 0x3D066F9D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xF8000000, 0x64000000, 0x0A000000, 0x55000000, 0x77800000, 0x79C00000, 0xC9A00000, 0xF6100000, 0x91A80000, 0x373C0000, 0x163E0000, 0x73BD0000, 0x4B7D8000, 0x575CC000, 0x118F2000, 0x5006B000, 0xB7EA9800, 0xDB5DCC00, 0x678D1200, 0x1B077500, 0x37699380, 0x1C1EEBC0, 0xCE6FDD60, 0x02753990, 0xBBF1DD68, 0x42D8399C, 0xCEA45D6A, 0x6F78F999 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xD8000000, 0xA4000000, 0x06000000, 0xC9000000, 0x13800000, 0x16C00000, 0xF9A00000, 0x0ED00000, 0xB0380000, 0xE5BC0000, 0x10BE0000, 0xC13D0000, 0x08FF8000, 0x43DD4000, 0x344E2000, 0xC914B000, 0x14D8A800, 0x600D8C00, 0xF1F4C200, 0xE3691900, 0x8644BF80, 0xC52024C0, 0x12909420, 0x84DACAD0, 0xC80E9428, 0x2DF7CADC, 0xF1691422, 0x91468AD7 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0xD8000000, 0xC4000000, 0xAE000000, 0x47000000, 0xEC800000, 0x3DC00000, 0x7DE00000, 0x02F00000, 0x0ED80000, 0x54940000, 0xBF960000, 0xA1170000, 0x51D48000, 0x19B44000, 0x55072000, 0x337C3000, 0x8B3A8800, 0x02659400, 0x174D2600, 0x9E835100, 0xB0C3E680, 0xA8614D40, 0x7CB28620, 0xBE7ABC70, 0x7C448628, 0x275DBC74, 0x52280626, 0x654DFC77 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x48000000, 0xE4000000, 0xA2000000, 0x95000000, 0x8F800000, 0x53400000, 0xEEE00000, 0xD5900000, 0x21C80000, 0x8C8C0000, 0x938E0000, 0x5D0D0000, 0x8BCE8000, 0xB76D4000, 0xE99C6000, 0x3F87F000, 0x51A17800, 0x5D712C00, 0xD3581200, 0x0FC6DF00, 0x6FC0A480, 0x3523D2C0, 0xDAB045E0, 0xD278BFD0, 0x2F7645E8, 0x74B9BFDC, 0x9BD6C5E6, 0x2E49FFD3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x18000000, 0xFC000000, 0x56000000, 0x97000000, 0x30800000, 0x6BC00000, 0x78200000, 0x3FB00000, 0xA1080000, 0x259C0000, 0x851E0000, 0xB6DF0000, 0x92FD8000, 0xEB4DC000, 0xC545A000, 0x2C5A5000, 0x94850800, 0xCD785400, 0x50B51600, 0x71317900, 0xE9C93980, 0x7F3D9740, 0xFC6D1B60, 0x86745910, 0xB8909B68, 0xBA399914, 0xED553B62, 0xEDA3C915 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xD8000000, 0x54000000, 0xFE000000, 0xA1000000, 0xFD800000, 0x4DC00000, 0x10200000, 0xDA100000, 0x23680000, 0x32A40000, 0x97260000, 0xCEE70000, 0x80C58000, 0xABD4C000, 0xAD3FA000, 0x865AF000, 0xFF5F0800, 0x4AAA8C00, 0x1484FA00, 0xC0350D00, 0xEA0CED80, 0x78A275C0, 0x24507060, 0xF78AF6F0, 0xD915F068, 0x519E36F4, 0xC40A5062, 0x5DD4C6F1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xA8000000, 0x84000000, 0xEA000000, 0x53000000, 0xF8800000, 0xA6C00000, 0xAEE00000, 0x3A300000, 0x34F80000, 0x7FAC0000, 0x932E0000, 0x47ED0000, 0x760E8000, 0x2ABD4000, 0xA987E000, 0x5749F000, 0x4A145800, 0x62201400, 0x07D17600, 0x1648AD00, 0x1D94F680, 0xEA616E40, 0x6AF3A5A0, 0xEF1A2F10, 0x701D25A8, 0xE8976F1C, 0x1FE2C5A6, 0xC5B29F13 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x18000000, 0x9C000000, 0x6A000000, 0x1B000000, 0x60800000, 0xF8400000, 0x53E00000, 0x74F00000, 0xECD80000, 0xB3040000, 0x07860000, 0x51C70000, 0xCF278000, 0x7A54C000, 0x0D4CA000, 0xE96AD000, 0x5BBD7800, 0xDAB21400, 0x5E381600, 0x84753700, 0x3F9DD880, 0x3B605B40, 0x68B2D020, 0xB939E830, 0x7EF55028, 0x14DD2834, 0x8C01F02A, 0x1203F839 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x38000000, 0x9C000000, 0xA2000000, 0x6B000000, 0x61800000, 0x60C00000, 0x6A200000, 0x18B00000, 0x29280000, 0x655C0000, 0x26DE0000, 0x6D1F0000, 0xC6BD8000, 0x0ECF4000, 0x75C7A000, 0x9429D000, 0x39DD5800, 0x5A9FF400, 0xDB7DF200, 0xD86C3100, 0x0137B980, 0x83614B40, 0xE65317E0, 0x4DB8A690, 0x89C697E8, 0x662BE694, 0x7ADF37E2, 0x2F1D369F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x18000000, 0x3C000000, 0x5A000000, 0x7F000000, 0x8B800000, 0x1BC00000, 0x29600000, 0x16500000, 0x90E80000, 0x49640000, 0x6CE60000, 0x86250000, 0x45C48000, 0xEAD44000, 0xFE1C2000, 0x5B08D000, 0x5277B800, 0x562F4400, 0x1233EA00, 0xC638C500, 0x67CFC080, 0x262089C0, 0x5F729260, 0xCC19C3F0, 0xEABE1268, 0xE13983FC, 0x704C326E, 0x37E053FF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xA8000000, 0xC4000000, 0x5E000000, 0x61000000, 0x1E800000, 0x19400000, 0x16A00000, 0x74B00000, 0x25880000, 0xDC4C0000, 0x3BCE0000, 0xE00F0000, 0x2DEE8000, 0x8CFCC000, 0x90466000, 0x95417000, 0x5CA20800, 0x83B28C00, 0x0E0B7600, 0x2D8D5300, 0x912DA980, 0xC29E6B40, 0x04960560, 0x7D1AB050, 0x1A368568, 0x7DA97054, 0x39BE656E, 0x3CE4C05D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xC8000000, 0x4C000000, 0x66000000, 0x33000000, 0x32800000, 0x70C00000, 0x44200000, 0x06500000, 0xEA480000, 0x8ED40000, 0xE3560000, 0x37170000, 0x58F58000, 0xD4074000, 0xE6DC6000, 0xB9615000, 0x8632C800, 0xFBFB0400, 0x6C6D4E00, 0x75584D00, 0xDEFD7D80, 0x5131D4C0, 0xB378A5E0, 0x91AC32B0, 0x04FB25E8, 0x78EC72B4, 0x969AC5E2, 0x185E62BF } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x68000000, 0xD4000000, 0xEE000000, 0x51000000, 0xBC800000, 0x3D400000, 0x5FA00000, 0x0FB00000, 0x75680000, 0xFAB40000, 0x13360000, 0x44F70000, 0xDB178000, 0x55874000, 0x111EE000, 0x16E1B000, 0xCE100800, 0x63D84C00, 0xD75E3E00, 0x52C00B00, 0x8D63D580, 0xC2D13B40, 0x97BB16E0, 0x5D0CD830, 0x263A96E8, 0xB6CC9834, 0x83DBF6EA, 0x875E6837 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x28000000, 0xF4000000, 0x82000000, 0x25000000, 0xA5800000, 0xE7400000, 0xB3E00000, 0xC9300000, 0x58D80000, 0xB2140000, 0x1E960000, 0x62570000, 0x75F78000, 0x15A74000, 0x3F8FE000, 0x52603000, 0xC4703800, 0x1A39AC00, 0x6CA7BA00, 0xAC0EE700, 0x32218880, 0xC713FC40, 0xB9C95720, 0x94DF2B70, 0xE6C8D728, 0x985F6B74, 0xEA08B72A, 0x87FC1B77 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xB8000000, 0x7C000000, 0xBE000000, 0x9B000000, 0x29800000, 0xA0400000, 0x8D200000, 0x08700000, 0x0EE80000, 0x195C0000, 0xD9DE0000, 0x9D1D0000, 0x66FF8000, 0x386DC000, 0x8E972000, 0xD2F2D000, 0x232A2800, 0xC63F4400, 0x518F6200, 0xED04A300, 0x3A8AF780, 0xF08F6640, 0xFD8645E0, 0xA6483C90, 0x476FC5E8, 0x3514FC9C, 0x4FB165E2, 0xF08AEC95 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x48000000, 0xF4000000, 0xBA000000, 0x0B000000, 0xA5800000, 0x92400000, 0x63E00000, 0x58900000, 0x2FE80000, 0x073C0000, 0x4FBE0000, 0xED7F0000, 0x205E8000, 0x43ECC000, 0x92B5E000, 0xEC523000, 0xAFCAD800, 0xE40FF400, 0x8826E200, 0x84BBEB00, 0x9B74C480, 0x34F336C0, 0xE63AC160, 0x7AB7E190, 0xA8524168, 0xADC82194, 0xC30F216E, 0x2BA5D19D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xA8000000, 0xCC000000, 0x7A000000, 0x1D000000, 0xE9800000, 0xE9C00000, 0x01600000, 0xD1D00000, 0x21F80000, 0xC0C40000, 0x8D060000, 0x9A670000, 0xBCB48000, 0xB1CD4000, 0x154BE000, 0xC6EED000, 0xEB383800, 0x5324CC00, 0x03962A00, 0xB3BC6D00, 0xB283B880, 0x8F4347C0, 0x3022CC20, 0xDAF34530, 0xAD892C28, 0x140D9534, 0x2E291426, 0xEA3D5933 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x08000000, 0x9C000000, 0xCE000000, 0x99000000, 0xAF800000, 0xDF400000, 0xE3E00000, 0x34300000, 0x43280000, 0x41AC0000, 0x8CEE0000, 0x980D0000, 0x4ABC8000, 0xC1564000, 0x285A6000, 0x21661000, 0x99702800, 0xE7CACC00, 0x9B1C3200, 0x9B062F00, 0xBF023080, 0xDA800840, 0xD6C3E8E0, 0x89A0AC50, 0xBE5188E8, 0xAD5ABC5C, 0x80E7A0EE, 0xBF317057 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xF8000000, 0x34000000, 0x7A000000, 0xEB000000, 0xB8800000, 0x59C00000, 0x68600000, 0x81300000, 0x54480000, 0xEEE40000, 0x89260000, 0x78470000, 0xD6F78000, 0x45FDC000, 0xC7BA2000, 0xBA4CF000, 0x67321800, 0x694A3400, 0x43671600, 0x91655100, 0xD6648080, 0x90E4DC40, 0x30255960, 0xC7C5A4F0, 0xE9B77968, 0x1D5D54F4, 0x496B616A, 0xF47460FD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x78000000, 0x04000000, 0xD6000000, 0x1B000000, 0x64800000, 0x70C00000, 0xBE200000, 0x13900000, 0x63D80000, 0x3C1C0000, 0x96DE0000, 0xC9FF0000, 0xEFEC8000, 0x4174C000, 0x62092000, 0x52273000, 0x97F36800, 0xE1AB8400, 0xA0F4D600, 0xA1493500, 0xA2457D80, 0xEB831BC0, 0xFA4170A0, 0x31E006D0, 0x0F3050A8, 0x638B36D4, 0x816538A6, 0x1F93B2D5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x08000000, 0x6C000000, 0x7E000000, 0x89000000, 0xB1800000, 0x7A400000, 0xFEE00000, 0x3F700000, 0x4EB80000, 0xD7940000, 0xD4D60000, 0x03B70000, 0x82858000, 0xF0DEC000, 0xE73AE000, 0x29D55000, 0x4837A800, 0x13C60C00, 0x90BD0A00, 0xFE8B8300, 0x404FE880, 0xD3705D40, 0x70BB3BA0, 0xFE9447F0, 0xB557DBA8, 0x71F617F4, 0x1065F3A2, 0xB1AEDBF9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xE8000000, 0x84000000, 0x2E000000, 0xC5000000, 0x18800000, 0x8AC00000, 0x87E00000, 0xD7700000, 0xE4180000, 0xF2640000, 0xE5A60000, 0x26C70000, 0x49748000, 0x3D8EC000, 0x87196000, 0x7BE57000, 0x51E6C800, 0xFAE75C00, 0xC766FE00, 0xC5253500, 0x20069A80, 0xF4976F40, 0xE9FF5320, 0x3A83ECB0, 0x35C03328, 0x7C619CB4, 0x94327B26, 0x37B800BD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x38000000, 0x94000000, 0x6E000000, 0x3F000000, 0xDD800000, 0x8F400000, 0xD6600000, 0x27700000, 0x6A680000, 0x602C0000, 0x646E0000, 0x718D0000, 0x7EBF8000, 0x3B354000, 0xA529A000, 0xD64DF000, 0x531D4800, 0x93E43400, 0xB2930200, 0xA5591F00, 0x85A7F680, 0x4A700340, 0x3AEB2EE0, 0x6FEC4450, 0x95CC8EE8, 0xBB5CB45C, 0x1C0646E2, 0xFCA1C057 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xF8000000, 0x8C000000, 0x66000000, 0xA7000000, 0x70800000, 0x9A400000, 0xFAE00000, 0x9FB00000, 0xD5180000, 0xC6940000, 0xC7D60000, 0x13B50000, 0x5D448000, 0x543C4000, 0xC85BA000, 0xDCF79000, 0x6A270800, 0x784F1400, 0x16639600, 0x0BF0DF00, 0xACF9E480, 0x0BA5B240, 0x3D8F2220, 0x12438670, 0x2EE28228, 0x25B1167C, 0xDC190A2E, 0x6516427F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x78000000, 0x14000000, 0x92000000, 0x55000000, 0x36800000, 0x0AC00000, 0x85600000, 0xF6500000, 0x23280000, 0xA0740000, 0x73B60000, 0xF6570000, 0x45C78000, 0x3C0CC000, 0xA8692000, 0xA4577000, 0x70C63800, 0xFA8EEC00, 0x0AA9F600, 0x4D357D00, 0x0095D880, 0x1EA599C0, 0xC95DC960, 0x02C066B0, 0x7962E968, 0x285016B4, 0x202B516A, 0x29F63AB9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x88000000, 0x0C000000, 0xFE000000, 0x91000000, 0x8B800000, 0x04C00000, 0x7DE00000, 0xCD700000, 0x94780000, 0xC36C0000, 0x00AE0000, 0x7BCF0000, 0x1FFC8000, 0x57A64000, 0xD5D86000, 0xEBBE5000, 0x5E06A800, 0x510A6C00, 0x1B170200, 0xDDC0F100, 0x5A639680, 0x67B32B40, 0x409BA6A0, 0x019C1110, 0x6215C6A8, 0xAA414114, 0xC8A1EEA6, 0x37526D1F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x98000000, 0x04000000, 0xEA000000, 0x6F000000, 0x60800000, 0x6CC00000, 0x05E00000, 0x70900000, 0x10880000, 0x858C0000, 0x844E0000, 0x322D0000, 0x70FE8000, 0x24564000, 0x47282000, 0x413E3000, 0x0A349800, 0x01F9A400, 0xFF956600, 0x064B7500, 0x676F9280, 0xD85FA8C0, 0x0867DEE0, 0xE990C6D0, 0x3109FEE8, 0xECCFF6DC, 0xD2EDE6E6, 0xD31D12DF } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x08000000, 0x4C000000, 0xCA000000, 0x13000000, 0xEA800000, 0x2EC00000, 0x19E00000, 0x4DB00000, 0xFEC80000, 0x33240000, 0xFCE60000, 0x48850000, 0x2F748000, 0xA39FC000, 0xFF6BE000, 0x2BB4D000, 0xB97EF800, 0x30583400, 0x67BF5E00, 0x51B98500, 0xDE0C7280, 0xF1709C40, 0x702BE360, 0x721419F0, 0x25EE0368, 0x93C1C9FC, 0x16627B6E, 0xE8F33DF1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x58000000, 0xCC000000, 0x8A000000, 0xBD000000, 0xE2800000, 0xC1C00000, 0x1E200000, 0xD0300000, 0x7F180000, 0xE69C0000, 0xC45E0000, 0x23FD0000, 0x978D8000, 0x60F4C000, 0xFF39A000, 0x0DAC9000, 0x4EC7B800, 0x0B22CC00, 0x36B28600, 0x80DAA100, 0x53BC0980, 0x99ED1140, 0x0EA65120, 0xC6730550, 0x1679F128, 0x8F4E955C, 0x1255C92A, 0x6DC99959 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xB8000000, 0xDC000000, 0xE2000000, 0x85000000, 0xF8800000, 0xB6C00000, 0x30E00000, 0xAD900000, 0x6E480000, 0x0EEC0000, 0x5CAE0000, 0x588F0000, 0x70FF8000, 0xE3A7C000, 0x51C12000, 0x0D605000, 0xC3D2D800, 0xF8684C00, 0x2B9FEE00, 0x4375D500, 0xDA2B6680, 0xA7BCD8C0, 0x1F0435E0, 0xCF708C50, 0xAEDA95E8, 0xDC271C54, 0xCA816DEA, 0xEBC30055 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x28000000, 0xC4000000, 0x76000000, 0x23000000, 0x82800000, 0xED400000, 0x28A00000, 0xE0B00000, 0xE8480000, 0xAD6C0000, 0xAEAE0000, 0x194D0000, 0xA45D8000, 0xBD274000, 0xBFC3E000, 0xBDE2F000, 0xB4102800, 0x22F82400, 0xFC24EE00, 0x1041FB00, 0x8D234980, 0xD9729340, 0xBEABFE60, 0xCFFD21D0, 0x8F159E68, 0x02C891DC, 0x642E566A, 0x600E45D7 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x68000000, 0x94000000, 0xCE000000, 0xDB000000, 0xA4800000, 0xD8400000, 0xDF600000, 0x9C100000, 0xE2880000, 0x9A540000, 0xFA960000, 0x57B50000, 0x59C78000, 0x34DDC000, 0x02C06000, 0xE4203000, 0xBBF00800, 0x6CD9E400, 0xDABD3600, 0x1751F700, 0xFD69DA80, 0x480512C0, 0x707F34E0, 0xC7732FB0, 0x1898D4E8, 0x97DEDFBC, 0x9A40BCE2, 0xC6630BB5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x58000000, 0x84000000, 0x26000000, 0xFF000000, 0x5F800000, 0xE9C00000, 0x8B600000, 0x76D00000, 0x31480000, 0x965C0000, 0x8E1E0000, 0xEFBD0000, 0x9F8E8000, 0x20D4C000, 0x7021A000, 0x0AF1B000, 0xE1BA2800, 0x5AE65400, 0x9A7B6A00, 0xE084AD00, 0xE02A1080, 0x0D8F93C0, 0x11D50AE0, 0x7CA39D90, 0xD6B22AE8, 0x861AED9C, 0xA5D7A2E6, 0xB2A00995 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0xE8000000, 0x5C000000, 0x9A000000, 0x2B000000, 0x8D800000, 0x23C00000, 0x97600000, 0x04900000, 0x58980000, 0x9FEC0000, 0xA7AE0000, 0x7A0F0000, 0x5B7D8000, 0x1F344000, 0x35E3E000, 0x64D09000, 0xD13BF800, 0xA89DD400, 0xCAE42200, 0x425A0D00, 0x620DA080, 0xAF7D1AC0, 0x7934F4A0, 0xF4E28D10, 0x2A5294A8, 0x237A5D14, 0x863C8CA2, 0x72141913 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x18000000, 0x6C000000, 0x46000000, 0xAD000000, 0xE2800000, 0x6A400000, 0x99200000, 0xBCF00000, 0x43780000, 0x83C40000, 0x59060000, 0x5D670000, 0x89348000, 0x0F7C4000, 0x80202000, 0xD4739000, 0x123B8800, 0x7D66BC00, 0x1937F600, 0xC77F3F00, 0xC4236B80, 0xE6724040, 0x953899A0, 0x74E72CB0, 0x3CF439A8, 0xD69CFCB4, 0x8BB191A6, 0x80DAD0B7 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xD8000000, 0x54000000, 0x46000000, 0x19000000, 0x23800000, 0x24400000, 0xC1200000, 0x20B00000, 0x8D780000, 0x779C0000, 0xB95E0000, 0xE7BF0000, 0x566F8000, 0x2C86C000, 0x37D1A000, 0x03EAF000, 0x48D6E800, 0x98780C00, 0x061EC200, 0xE21EB300, 0x4C1C2780, 0xA91F1D40, 0x109E3CA0, 0xE7DC44D0, 0x0E7E1CA8, 0x760F74D4, 0x2496D4AA, 0xB55B48D1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x68000000, 0xC4000000, 0x7A000000, 0x9D000000, 0x38800000, 0xC1C00000, 0x5F600000, 0x6F900000, 0x07080000, 0xB92C0000, 0x356E0000, 0x174F0000, 0x3C7D8000, 0xA6854000, 0x27B0E000, 0xA939F000, 0x17551800, 0xFB9BEC00, 0x49A4CE00, 0x8C03E900, 0xCE00C480, 0x2F0272C0, 0x5180EAE0, 0xEB417450, 0xC7A38AE8, 0x7272C454, 0x345BF2E2, 0xD9C59857 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xF8000000, 0xE4000000, 0xC2000000, 0xE5000000, 0x91800000, 0xC2400000, 0x1AA00000, 0xFE300000, 0x1CC80000, 0x802C0000, 0x52EE0000, 0x998F0000, 0x3A5E8000, 0x4386C000, 0x1B112000, 0x2BB8B000, 0x5CC6B800, 0x5432AC00, 0xA5CBAA00, 0x57AFC300, 0xA7AFF980, 0x0FADA940, 0x73AFBE60, 0x45AF20D0, 0x9AAE1E68, 0x0A2E50D4, 0x9BEF066E, 0xA60E8CD5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0xC8000000, 0x34000000, 0xFA000000, 0x7B000000, 0x83800000, 0x33C00000, 0x0EE00000, 0xC2700000, 0x78080000, 0x0D2C0000, 0x4A6E0000, 0x02CF0000, 0x309D8000, 0x6A85C000, 0x1092E000, 0x24783000, 0x9C26D800, 0x9BC3B400, 0xCAE2FA00, 0x40729500, 0xEF08BE80, 0x88AF3F40, 0xCCAEC360, 0x0EAEC1D0, 0x39AFA368, 0xAC2C31D4, 0xE2EE1B62, 0xDA8E75D5 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xC8000000, 0xE4000000, 0xA2000000, 0x81000000, 0x0F800000, 0x21400000, 0xE9A00000, 0xB8500000, 0xADD80000, 0xE9D40000, 0x50160000, 0xAC770000, 0xEE448000, 0xC2AD4000, 0xF9126000, 0x747BF000, 0x79847800, 0x69CFFC00, 0x2FA30200, 0xDB512700, 0xC359D180, 0xB71518C0, 0x50F5FBA0, 0x1986CAF0, 0x59CD1BA8, 0x07A37AF4, 0x4F5183A6, 0xA95936F3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x18000000, 0xCC000000, 0x42000000, 0x7F000000, 0x8C800000, 0x6A400000, 0x9CA00000, 0x19500000, 0xF8280000, 0x897C0000, 0xE5DE0000, 0x248D0000, 0x70A48000, 0xCBD94000, 0x49072000, 0x2D091000, 0x75EC9800, 0x5D942400, 0x81413600, 0x3E218F00, 0x5E136580, 0xFF0924C0, 0xA2EEF260, 0x6515D890, 0x15026A68, 0x8781FC9C, 0x78C35C6E, 0xA3E0739B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x18000000, 0xFC000000, 0xBA000000, 0xAD000000, 0x7F800000, 0x98400000, 0x06200000, 0x06F00000, 0xF3480000, 0xF7E40000, 0x49C60000, 0x03370000, 0xA27E8000, 0x8C98C000, 0xE4DEA000, 0x94AA5000, 0x58763800, 0x98DC4C00, 0x6EAB1200, 0x95772300, 0x775F0380, 0xEEE85440, 0x6F540B60, 0xCBAD37F0, 0xB0A23368, 0xE7317BF4, 0x1A29216E, 0xB5B658FD } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x88000000, 0xEC000000, 0xE2000000, 0x37000000, 0x4D800000, 0xC5400000, 0xA6E00000, 0x0B100000, 0x5FF80000, 0x1CEC0000, 0xD80E0000, 0xA41F0000, 0x96678000, 0x7FCB4000, 0x89276000, 0xCA2BD000, 0xE1B7D800, 0xB5904400, 0xA9381200, 0x024FD700, 0xD37D1480, 0x12363CC0, 0x6DD03120, 0xB9584590, 0x539FE928, 0x50240194, 0x02A9FB2A, 0xC674D697 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x78000000, 0x5C000000, 0x46000000, 0x23000000, 0x41800000, 0x9BC00000, 0x05E00000, 0x1B500000, 0x29C80000, 0x9A8C0000, 0x796E0000, 0x913D0000, 0x91768000, 0x44394000, 0x5AB6A000, 0xE9DAD000, 0x75E54800, 0x52108400, 0xAE692200, 0x53FC9D00, 0x80174280, 0x3E2AEBC0, 0x00DFCEE0, 0xC824E9D0, 0x44F286E8, 0x6CB86DDC, 0x4DF5A4E6, 0x2179F0D3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xE8000000, 0xE4000000, 0x4E000000, 0x1F000000, 0x37800000, 0x43C00000, 0x07600000, 0x5C100000, 0x1DA80000, 0x3CEC0000, 0x348E0000, 0x971D0000, 0x9D768000, 0x50FBC000, 0x2B666000, 0x3C50F000, 0x8F0B4800, 0xC49EF400, 0x50B54A00, 0xA89A3500, 0x10F6A080, 0x8A3944C0, 0x50858860, 0xE20086D0, 0xC500C068, 0x3E8372DC, 0x37430A66, 0x312287D9 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x88000000, 0x4C000000, 0x52000000, 0xE5000000, 0x81800000, 0xACC00000, 0xB5E00000, 0xBCF00000, 0xE8F80000, 0x97BC0000, 0x5F5E0000, 0x362F0000, 0x34168000, 0xD5484000, 0xC4646000, 0xCCF25000, 0x40F99800, 0x0BBC4C00, 0x355D2A00, 0x172F4900, 0xAB964680, 0xCE899940, 0x1506C0A0, 0x5D418F50, 0xB12158A8, 0x9512C354, 0x3E0AF2AE, 0x5E45CA5F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xE8000000, 0x34000000, 0x12000000, 0xA5000000, 0xF9800000, 0x58C00000, 0xB0E00000, 0x57300000, 0xED580000, 0xF34C0000, 0x20AE0000, 0xE91D0000, 0xF8078000, 0x76E94000, 0x2754E000, 0x47C13000, 0xB862F800, 0xF4732C00, 0xF87B2A00, 0x311FF900, 0xE4040280, 0xF0E85240, 0x20565D20, 0xF3424110, 0x2D22A528, 0x0E506D1C, 0xBAA80F22, 0x72F7D417 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x28000000, 0x14000000, 0x32000000, 0xF7000000, 0x5C800000, 0x3C400000, 0xA5A00000, 0xC3D00000, 0xE9780000, 0x29640000, 0xD5C60000, 0xCB950000, 0x8F2D8000, 0x102BC000, 0xD95D6000, 0x42803000, 0x05417800, 0x08236400, 0xF6107600, 0xF31A3700, 0x3BD49980, 0x548ED2C0, 0x9AF81120, 0x05A46BB0, 0xF2276928, 0xC4E60FBC, 0x00049F2A, 0x61F6F8B5 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x88000000, 0x74000000, 0x72000000, 0x3D000000, 0x19800000, 0x32C00000, 0x7C200000, 0x72D00000, 0x76480000, 0xECEC0000, 0x094E0000, 0x895D0000, 0xE3348000, 0xCD0A4000, 0x3A0E6000, 0x2BBEB000, 0xB3C5F800, 0xCA924C00, 0x0A28CA00, 0xDE5CF100, 0x2BB69980, 0xB84BAEC0, 0x77EF45E0, 0x8FCE4B50, 0xA71E3DE8, 0x4856475C, 0xF73897EE, 0x0DB40657 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xA8000000, 0xE4000000, 0x9E000000, 0xA5000000, 0x8A800000, 0x21400000, 0x0BA00000, 0x41F00000, 0xE0080000, 0xF5140000, 0xC4360000, 0xAC870000, 0x332C8000, 0xC1C94000, 0x0CF5E000, 0xA5E57000, 0x48BD8800, 0x01D15C00, 0xD43A1600, 0x7AFEA300, 0x81F2E580, 0x4009CE40, 0x6516D060, 0x1C347B30, 0xE087D868, 0x492C6734, 0xFAC82E66, 0x2377B433 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x28000000, 0x44000000, 0x32000000, 0xB1000000, 0x2F800000, 0x50C00000, 0x2DE00000, 0x54F00000, 0x99980000, 0x64240000, 0x6A460000, 0xC8770000, 0x470D8000, 0xB5594000, 0x67C7E000, 0x71B5F000, 0x896EB800, 0xF76A3C00, 0x78BCE200, 0x9BE31100, 0x37F3FE80, 0x971BE140, 0x03651D20, 0x7B6600B0, 0xC7662528, 0x09657CB4, 0xD6652722, 0x16E79DB7 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0x64000000, 0xE6000000, 0x2D000000, 0xBA800000, 0x37400000, 0xB9600000, 0x24F00000, 0xCD080000, 0x46BC0000, 0xA95E0000, 0x00EF0000, 0xEB878000, 0xB04BC000, 0x48DCA000, 0xB82E3000, 0x9B242800, 0xEC985C00, 0x6D459600, 0xC9EABB00, 0x688DD680, 0x97F5A940, 0xB1006360, 0x68817E90, 0x8443CB68, 0x5AE2E294, 0x1732FD6A, 0x0A2A6995 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x28000000, 0x5C000000, 0x8A000000, 0x4D000000, 0x9C800000, 0x76400000, 0x81A00000, 0xFCD00000, 0x7C080000, 0x55140000, 0xE2360000, 0xD5A50000, 0x3C8F8000, 0x8F0B4000, 0x3295E000, 0x5FF59000, 0xEBC63800, 0xDF3D4C00, 0x2E335E00, 0xA1F95700, 0xB98F0980, 0x1F8B66C0, 0x76D410E0, 0xD755CFB0, 0x7595A8E8, 0x4E77C3BC, 0xA10516E2, 0x18DE04BF } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x08000000, 0x3C000000, 0x92000000, 0x53000000, 0xDB800000, 0x73C00000, 0x19600000, 0x16900000, 0xD5980000, 0x10940000, 0x58760000, 0xBA250000, 0x735D8000, 0x9F98C000, 0xB796E000, 0x0DF71000, 0x58E6D800, 0xEABE5400, 0x1D485A00, 0x9AAF4500, 0x41909880, 0x181A46C0, 0xE655F2A0, 0x3F94F1F0, 0xF1F6AAA8, 0xEAE665FC, 0xE9BE10AA, 0xCECB30F9 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xA8000000, 0x14000000, 0xB2000000, 0xE9000000, 0xCA800000, 0x3F400000, 0x60A00000, 0xF3D00000, 0xBE280000, 0x58B40000, 0x33960000, 0x61870000, 0x524E8000, 0xC0884000, 0xDC64E000, 0x703FB000, 0x9BF1F800, 0x13BB1C00, 0x88BD5600, 0x0DB0DB00, 0xD99A0180, 0xF42E82C0, 0x7B39E460, 0x66FEF9B0, 0xCB909C68, 0xAB0AA5B4, 0xCDA7AA6E, 0x55DD8EBF } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x78000000, 0xD4000000, 0x8E000000, 0x1D000000, 0x32800000, 0x95C00000, 0x86200000, 0x2C100000, 0x8CD80000, 0xC7AC0000, 0xCA0E0000, 0x675F0000, 0x29668000, 0xBC78C000, 0xA87F2000, 0xF9F77000, 0xD861C800, 0x4B707C00, 0xF22A1600, 0x61C77100, 0x07A84180, 0x15845DC0, 0x5BCB00A0, 0x88F47B10, 0x90E248A8, 0xBDB3C714, 0xB389FEAE, 0x4697061D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x18000000, 0x24000000, 0x36000000, 0x61000000, 0x67800000, 0xD6C00000, 0x34200000, 0x2DF00000, 0x44180000, 0x4F3C0000, 0xD19E0000, 0x072F0000, 0xB2D68000, 0xC4BAC000, 0xB48CA000, 0x19E73000, 0xCC836800, 0xE2412C00, 0xA2619200, 0xC193B900, 0xD08B6180, 0xD636EA40, 0x94697020, 0xF6E551D0, 0xDE029828, 0x0D01BDD4, 0x0D812A2E, 0xB5C3F4D5 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x68000000, 0xFC000000, 0x82000000, 0x7D000000, 0x61800000, 0x98C00000, 0x51200000, 0x8AD00000, 0x62380000, 0x023C0000, 0x0B9E0000, 0x3E0F0000, 0xEED78000, 0x0D9B4000, 0x7CACE000, 0x89C41000, 0xB3039800, 0xB6802C00, 0x5841CA00, 0x1A617900, 0x56310580, 0x244972C0, 0xF0177820, 0x47B89DD0, 0xDCFD6028, 0x21BCF1D4, 0x8E5FCA2A, 0x1EAED8D7 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x88000000, 0xE4000000, 0xC6000000, 0x77000000, 0x79800000, 0x65C00000, 0x99A00000, 0x32D00000, 0xA3E80000, 0x1D940000, 0x24B60000, 0xA9250000, 0xA12C8000, 0x110B4000, 0x0AA76000, 0xD9EDF000, 0xC4286800, 0x6535F400, 0x00E4F200, 0x8A8E5500, 0xEADAFB80, 0xCBCF14C0, 0xFA391160, 0xADFD1E30, 0x69E3F968, 0x2CB2AA3C, 0xD99AEB6E, 0x722F4F33 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xD8000000, 0x6C000000, 0x62000000, 0x0D000000, 0x9C800000, 0x47C00000, 0x3B200000, 0xA4500000, 0x6DA80000, 0xB1AC0000, 0xA50E0000, 0x5D1F0000, 0x19D78000, 0x6A4AC000, 0xA15FA000, 0x20B51000, 0x50791800, 0xF346EC00, 0x4641BE00, 0x5861F100, 0xC4B1E580, 0x18D868C0, 0xC1540860, 0xEB88FBD0, 0x617C9068, 0x4B67D7D4, 0x51930E6A, 0xC38AF6D1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xB8000000, 0x0C000000, 0x96000000, 0x3B000000, 0x7A800000, 0xAC400000, 0x97E00000, 0x94700000, 0x67E80000, 0x18E40000, 0xCC860000, 0xFF370000, 0x5CFC8000, 0x6E494000, 0x3275A000, 0xBC9E9000, 0x87FA4800, 0xDCBEE400, 0xBFAB2E00, 0xB507CF00, 0x65F6B880, 0x115FFD40, 0x26DBF4E0, 0x036F8470, 0x63D33CE8, 0x527B2074, 0x407F32E6, 0x01083F73 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xA8000000, 0xCC000000, 0x56000000, 0x6B000000, 0x2D800000, 0x98C00000, 0xAFA00000, 0x2A500000, 0x41380000, 0x95740000, 0xC2160000, 0xF7E50000, 0x448D8000, 0xA4C0C000, 0xC1A06000, 0x05505000, 0xA6B98800, 0x98B56400, 0xE7357200, 0x3EF72100, 0x59D44780, 0x99C402C0, 0xF01F1020, 0x895816F0, 0x9F06F828, 0x48BD22FC, 0x008A022A, 0x19FF67F9 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x48000000, 0x6C000000, 0xA2000000, 0x65000000, 0xE0800000, 0x32400000, 0xBC600000, 0x8A900000, 0xD3780000, 0x7DEC0000, 0x23CE0000, 0x2D3D0000, 0xB0D68000, 0x60404000, 0xB1636000, 0x5611D000, 0xBB38D800, 0x808F8C00, 0x87DF2E00, 0x0B055700, 0xF4DAAE80, 0x1BDDD0C0, 0xC1053F20, 0xADD93190, 0xA15E8728, 0xB2476D9C, 0x3F397126, 0xDE8DB697 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x68000000, 0xA4000000, 0x2A000000, 0xC3000000, 0xD2800000, 0x4EC00000, 0x2B600000, 0xA3D00000, 0x49B80000, 0x907C0000, 0x91DE0000, 0x136F0000, 0xCA068000, 0x3940C000, 0xBA236000, 0x9DF0F000, 0x0E49D800, 0xA5349400, 0x2A687E00, 0xF9C4D500, 0xF1A25080, 0x7AB313C0, 0x156A1F20, 0x7D4595D0, 0x6A60A728, 0x3651F1D4, 0x0FF9012E, 0xCEDDB0DD } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0xF8000000, 0xB4000000, 0x9A000000, 0xE5000000, 0xE3800000, 0x8FC00000, 0x87E00000, 0x47B00000, 0x47080000, 0xD7340000, 0x23160000, 0xD5470000, 0xCEFD8000, 0x4A404000, 0x7B21A000, 0x48D27000, 0x63FA9800, 0x669CCC00, 0xEC32A200, 0x64C94D00, 0xAED6BA80, 0x93A57040, 0xD8CCC260, 0x5B8A11B0, 0x1E77FA68, 0x68B4ADB4, 0xEAD7C062, 0xB1A52CB3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x48000000, 0x14000000, 0xAE000000, 0x13000000, 0x67800000, 0x88400000, 0xB3600000, 0x1EF00000, 0x28980000, 0x4D4C0000, 0x206E0000, 0x92FF0000, 0x11178000, 0x4583C000, 0x0940E000, 0x4DE1B000, 0x14338800, 0x3B3B8400, 0xB51F3A00, 0x90274B00, 0x2E3A3E80, 0xA59C8940, 0xA9E6F520, 0x4A194110, 0x9D8D9D28, 0xBECF7514, 0x462F2F2A, 0x129CBA15 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x78000000, 0x24000000, 0x7E000000, 0x43000000, 0x6D800000, 0xB7C00000, 0xEEE00000, 0x93900000, 0xCB380000, 0xBB240000, 0x48060000, 0x50770000, 0x525E8000, 0xCE024000, 0x7B01A000, 0x29803000, 0xF9C04800, 0xD5E18400, 0xDA11D200, 0x02FB9D00, 0x16C5DE80, 0xB6149CC0, 0x2C8F0620, 0x079AB5B0, 0x1596EE28, 0xE04F01B4, 0xC0F9742E, 0x7FC618B7 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0xF8000000, 0x6C000000, 0xCE000000, 0x99000000, 0x28800000, 0xEAC00000, 0x39A00000, 0xAC100000, 0x15C80000, 0x08640000, 0x02060000, 0x5F350000, 0xBC2D8000, 0xF023C000, 0xC2522000, 0x28A89000, 0x94D72800, 0x6B5D0C00, 0xC4594E00, 0x41EDD500, 0x98014B80, 0x1C03FFC0, 0x86037AE0, 0x9D02E870, 0x728072E8, 0xD1C2747C, 0x462394EA, 0xF7516D75 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xA8000000, 0xD4000000, 0x62000000, 0xD3000000, 0xCF800000, 0xCC400000, 0x28200000, 0xEBF00000, 0x5B480000, 0x94040000, 0x2B660000, 0xC3350000, 0x85CC8000, 0x5DA2C000, 0xD8B26000, 0xC2EA3000, 0x46B63800, 0x8E8D3400, 0xB803AA00, 0xBC004B00, 0xD6002380, 0x2103E040, 0xB480A360, 0xD7C2EA70, 0x8662FB68, 0x10D0EE7C, 0x7F3BE96E, 0x030F5175 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0xB8000000, 0xDC000000, 0x1E000000, 0x33000000, 0xD9800000, 0xFD400000, 0x09200000, 0xF7F00000, 0x8EF80000, 0xCCAC0000, 0xF7CE0000, 0x5E9F0000, 0x81D48000, 0x47204000, 0x0CF0A000, 0xD37AD000, 0xC3ED2800, 0x6BEF2400, 0x9FEFA200, 0x35ECA700, 0x4CEC3B80, 0xDC6DC840, 0x09AFE5A0, 0x094F5A10, 0xE05C6DA8, 0xB4B5AE14, 0xF57267A6, 0xBE3A6D17 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0x6C000000, 0x56000000, 0xE1000000, 0x85800000, 0x05400000, 0x9DA00000, 0x25B00000, 0xD8080000, 0x45140000, 0xE0F60000, 0x83670000, 0xE69E8000, 0x6DA34000, 0x4DB1E000, 0xD4095000, 0x63158800, 0x29F5CC00, 0x6AE67A00, 0xB5DE5F00, 0x1100B180, 0xED810340, 0x0940C560, 0xBBA11C30, 0xECB2AD68, 0x318A8034, 0x1657DF6E, 0x9C565333 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0xC8000000, 0x7C000000, 0xCA000000, 0x6D000000, 0x76800000, 0x16C00000, 0xC6600000, 0x7C300000, 0x57580000, 0x6D3C0000, 0x049E0000, 0xEE4F0000, 0x5CE48000, 0x1763C000, 0x60B2E000, 0x1C9A1000, 0xC5DEB800, 0xDA6E4C00, 0xC975B600, 0xEAEB9D00, 0x5F26EC80, 0x83828840, 0x94437F20, 0x86A078D0, 0xCD512728, 0xF8EB24D4, 0x2626A926, 0x730135D9 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xB8000000, 0xCC000000, 0xB6000000, 0x59000000, 0x8F800000, 0x09C00000, 0xBD200000, 0x1CF00000, 0xBFB80000, 0xA3940000, 0x10760000, 0x53270000, 0x6C2E8000, 0xFBE1C000, 0x87512000, 0x2D0B1000, 0x0CCC4800, 0xD0306C00, 0xC31BB200, 0x43A42500, 0xFB6CC980, 0x04817E40, 0x3D43EEA0, 0xA862EFF0, 0xA09086A8, 0xB52A93F4, 0x41BFFCAE, 0x4B481AF9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x48000000, 0xAC000000, 0xFA000000, 0x9D000000, 0xB8800000, 0x7BC00000, 0xE7200000, 0x31100000, 0xC6A80000, 0x66740000, 0xE5960000, 0x42250000, 0x18DC8000, 0xB7E0C000, 0xD9B3E000, 0x81FA5000, 0x38BC3800, 0x9C100C00, 0x862ACE00, 0x89B71100, 0x0CB4A580, 0xF03475C0, 0xADF79D60, 0x75D6F3B0, 0x85464568, 0xD6ADAFBC, 0x4B3A336E, 0x5D1F72BD } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x28000000, 0x64000000, 0xD6000000, 0x8B000000, 0xB7800000, 0x3BC00000, 0xD0E00000, 0x4D700000, 0xDB980000, 0x52AC0000, 0xA60E0000, 0xA45D0000, 0x14558000, 0x8B12C000, 0x3BA86000, 0x3496F000, 0x24732800, 0xD91B4400, 0x11EEBA00, 0xFCAE0500, 0xA10EFE80, 0x81DC5740, 0xA2946F20, 0x4F701E90, 0x9E9AA728, 0xD22F6A9C, 0x604F552A, 0x5E7CDB91 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x58000000, 0x34000000, 0x46000000, 0xB1000000, 0x16800000, 0xEAC00000, 0x1F600000, 0x03B00000, 0x0A680000, 0xCCC40000, 0xE7E60000, 0x1DF50000, 0x094F8000, 0xB350C000, 0x599BA000, 0xE10C7000, 0x10F1E800, 0x0C496C00, 0x1A55D600, 0x229D6D00, 0xBD092880, 0xB376D240, 0x678D29E0, 0xC2328DF0, 0x5728E1E8, 0xD7E751FC, 0xF5F77FE2, 0x154F20F1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xE8000000, 0xE4000000, 0xDA000000, 0xE3000000, 0xD9800000, 0xB8C00000, 0x34E00000, 0x79500000, 0x68880000, 0xC6EC0000, 0x794E0000, 0xE73D0000, 0x2F878000, 0x02724000, 0x0EBBE000, 0xC8F77000, 0x90489800, 0x920FD400, 0xD01C9200, 0x17B5A100, 0xE56AFA80, 0x453F63C0, 0xD087FFE0, 0xDDF0F350, 0xF37B07E8, 0x1096175C, 0x555AEDE2, 0x9626125B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xB8000000, 0xCC000000, 0x26000000, 0xCF000000, 0x22800000, 0x18C00000, 0x77600000, 0x20700000, 0xE4480000, 0x25BC0000, 0x469E0000, 0x824D0000, 0xB1948000, 0x45D2C000, 0x0A5A2000, 0xD4061000, 0xE1290800, 0x10CD7400, 0x21579E00, 0xB6B00D00, 0xE82A6880, 0xAD4D4540, 0xC3149660, 0x8511B790, 0x213B3E68, 0x6A74139C, 0x0661886E, 0x31F27A95 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x88000000, 0x04000000, 0x86000000, 0xC9000000, 0x1E800000, 0x64C00000, 0x84600000, 0xB6300000, 0x4B980000, 0xC7940000, 0xEBB60000, 0x3A270000, 0x306D8000, 0x2612C000, 0xE00AE000, 0xDEDFF000, 0x20496800, 0xCD7E0C00, 0xBF99D600, 0x59969500, 0x0EB67C80, 0x76A57040, 0x93ADCC20, 0x71F30D70, 0xAA7BC428, 0xBCE43174, 0xCB0F9A22, 0xBFA05879 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x88000000, 0x4C000000, 0x32000000, 0x1B000000, 0x67800000, 0x4AC00000, 0x11E00000, 0x7A300000, 0xB1280000, 0x23F40000, 0x89560000, 0x9D450000, 0x113D8000, 0xBB934000, 0x6ABB6000, 0x194D5000, 0x881B1800, 0x615CB400, 0x86628A00, 0x58F1D100, 0x7CCA3E80, 0x53C6EA40, 0xE77EA8E0, 0xA733B830, 0xFBAB50E8, 0x4BB51C3C, 0x2CF7A2EA, 0x48D42937 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xC8000000, 0xE4000000, 0x5A000000, 0xFF000000, 0xF4800000, 0xFCC00000, 0xD4600000, 0xA4D00000, 0xA4F80000, 0xBECC0000, 0x1DEE0000, 0x251F0000, 0xAD958000, 0xF7114000, 0x9C186000, 0x5ADEF000, 0x2B771800, 0xB6012400, 0xA1015600, 0xC180F500, 0x0F436C80, 0xF02153C0, 0x32725A20, 0x714B3E10, 0xB566A228, 0x0F9AAA14, 0xAE9D0C22, 0xE5D4CB17 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x38000000, 0xBC000000, 0xE2000000, 0x21000000, 0xFF800000, 0xE2C00000, 0xE2E00000, 0x6CD00000, 0x41580000, 0xD8840000, 0xFA260000, 0x2B550000, 0xB7FC8000, 0x97934000, 0xFE79A000, 0x0A345000, 0x1BEC5800, 0x75281C00, 0x45AC8200, 0x6B8B3900, 0xB6DF5A80, 0xB623DDC0, 0x99310EA0, 0x050A33B0, 0x339E76A8, 0x9A003FBC, 0x3D038CAE, 0x8D800AB3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x28000000, 0x6C000000, 0xBE000000, 0x03000000, 0xB0800000, 0x3F400000, 0x76600000, 0x18900000, 0x38B80000, 0xE35C0000, 0x0FFE0000, 0x41CD0000, 0x46448000, 0x9F11C000, 0xBD7B6000, 0x637DD000, 0x788CA800, 0x1726E400, 0xB5010600, 0x2F830B00, 0x29C38A80, 0x5E23D4C0, 0x24724C20, 0xCE699050, 0xA0070428, 0x78F2645C, 0x8F2B4A2E, 0xB5669B59 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xE8000000, 0x4C000000, 0x7E000000, 0x75000000, 0x92800000, 0xD7400000, 0xFEE00000, 0x00900000, 0xBB780000, 0x6BF40000, 0x03660000, 0xB41F0000, 0x01E98000, 0xC78D4000, 0x0911E000, 0x93B95000, 0xD4D5E800, 0xA855DC00, 0x1216C600, 0x7A747300, 0x2FA45480, 0x893D90C0, 0x49DA8E20, 0xCA063570, 0x494C4828, 0x27324674, 0x38081CA2, 0x1E9FD6BF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x78000000, 0xFC000000, 0xD6000000, 0xAD000000, 0xFE800000, 0xCC400000, 0x0C600000, 0xB0900000, 0x04180000, 0x7BB40000, 0xE3260000, 0x933D0000, 0x5A8A8000, 0x0EAC4000, 0x6010A000, 0x5959D000, 0xBF56C800, 0x02F4DC00, 0x1DC6F600, 0xA1EF0F00, 0x33F1E280, 0x950AD6C0, 0x1A6C49A0, 0x953385F0, 0xD72ABFA8, 0x699C8AFC, 0x203B5D26, 0x1D465C3F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xE8000000, 0xC4000000, 0x42000000, 0x99000000, 0x3B800000, 0xC2400000, 0xA4600000, 0xDFD00000, 0xB1580000, 0x3F2C0000, 0x0AFE0000, 0x06A50000, 0x70098000, 0xD9B7C000, 0x6CF16000, 0x876BF000, 0x90E53800, 0xBE6A3C00, 0x7B672200, 0xB4281300, 0x0B073E80, 0xC1F9A3C0, 0xE75F95A0, 0x87566790, 0xB6E0B7A8, 0x1E12749C, 0xDB79892A, 0xD29ED75D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x68000000, 0x2C000000, 0x22000000, 0x93000000, 0xA3800000, 0x4C400000, 0x2DE00000, 0xCA500000, 0xA9780000, 0xD6F40000, 0x9AA60000, 0x3EDD0000, 0xC2AB8000, 0x90CE4000, 0x0A32E000, 0xFE69D000, 0x32EF1800, 0xF1C3B400, 0x28A2EA00, 0xC333C300, 0x1AE84080, 0xEB2D43C0, 0x95610520, 0x99906E70, 0xD2DBEF28, 0x1647AD7C, 0x3C0DAFA2, 0x9013EEB3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x08000000, 0x9C000000, 0x46000000, 0x1D000000, 0x0C800000, 0xBBC00000, 0xAAA00000, 0x8C300000, 0xFFA80000, 0x6E5C0000, 0x376E0000, 0xB8470000, 0x5BD98000, 0x0314C000, 0xAFE3E000, 0x6A501000, 0xF6B9C800, 0xF3845C00, 0x697B7E00, 0xBB25D900, 0x5A49EF80, 0x570C4140, 0x4C57F6E0, 0xBA80A810, 0x3EC288E8, 0x92227114, 0x3DF2E762, 0x060AF059 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xC8000000, 0xD4000000, 0x16000000, 0x6F000000, 0x90800000, 0xBCC00000, 0x96200000, 0x2B300000, 0x72F80000, 0x3A340000, 0xA6060000, 0xC87D0000, 0x148A8000, 0xF1AE4000, 0xE7606000, 0x0051B000, 0x08ABA800, 0xB79C7400, 0x9C1A8600, 0xC9255D00, 0xDCCF3180, 0xAA327B40, 0x517ADDA0, 0x34756CF0, 0x45E65BA8, 0x42ED31FC, 0xB503EA26, 0x85810AB7 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x58000000, 0x94000000, 0x42000000, 0xD3000000, 0xC5800000, 0xACC00000, 0xE3200000, 0x35D00000, 0xCAA80000, 0xBCB40000, 0x6E660000, 0xD34F0000, 0x683B8000, 0x04FF4000, 0x54A12000, 0x5210F000, 0x580AB800, 0xD7A6D400, 0xCCEE3200, 0x0BABB900, 0x2236A180, 0x5B26E4C0, 0xA2AFC760, 0xE3CB0C30, 0x3B07F568, 0xDAFFB534, 0xD9A2D4EA, 0x5A9211FF } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xA8000000, 0x0C000000, 0xDE000000, 0xAB000000, 0x98800000, 0x8C400000, 0xBBA00000, 0x7DB00000, 0xF5080000, 0xAACC0000, 0x407E0000, 0x9BF50000, 0x7A788000, 0x77244000, 0x1E23E000, 0xBE735000, 0x4C686800, 0xF79F2400, 0x9DE71600, 0x92C3CF00, 0x98E34580, 0x5C90C540, 0x69FACE60, 0x73E428D0, 0x51C3D868, 0x6C62E7DC, 0xBED01DEE, 0xD15A6297 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x48000000, 0xEC000000, 0xDA000000, 0x71000000, 0x0F800000, 0xE4C00000, 0x0CE00000, 0x74500000, 0x56D80000, 0xA5EC0000, 0x1ABE0000, 0x62E50000, 0x844A8000, 0x0AD6C000, 0x8282E000, 0xB943D000, 0x95227800, 0x3D335C00, 0xFF4BB200, 0x1C55D900, 0xF5C2F680, 0x5360B5C0, 0x389307A0, 0x263BCE90, 0x43BEB5A8, 0xD167179C, 0x1288C326, 0x0B346255 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x38000000, 0x64000000, 0x7A000000, 0x61000000, 0x33800000, 0xB4C00000, 0x8F200000, 0xC2100000, 0x0B980000, 0x054C0000, 0x705E0000, 0x7F470000, 0x8A4B8000, 0xA575C000, 0x57422000, 0x63E03000, 0x19301800, 0x9B89BC00, 0x33D44200, 0x58900900, 0xA0D8C980, 0x28AEE3C0, 0x6A6F94A0, 0xC24E0010, 0x7CDDD6A8, 0xC3050914, 0xF3289F2A, 0x57052AD5 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x88000000, 0x24000000, 0xE2000000, 0x33000000, 0x74800000, 0x34400000, 0x8BA00000, 0x0D300000, 0xD9C80000, 0x24AC0000, 0x851E0000, 0x84970000, 0x0D988000, 0x84B5C000, 0x1668E000, 0x5B9CF000, 0x07D4B800, 0x20BB9400, 0xD6C63600, 0x9C839F00, 0x8040C580, 0x01A33740, 0xCA30F760, 0xC74A7450, 0x07EE4168, 0x983C2B54, 0x8EE664E6, 0x2B73EC19 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xC8000000, 0xAC000000, 0x2A000000, 0xD9000000, 0xA3800000, 0xB7C00000, 0x18A00000, 0x42700000, 0x18F80000, 0x0C840000, 0xB1760000, 0x8C4F0000, 0x15698000, 0x9BEDC000, 0x2F99E000, 0xD256D000, 0x5DFDB800, 0x33303C00, 0xB619E200, 0x34954500, 0xEADFFB80, 0x7C824040, 0xA7421EA0, 0x75E08B30, 0xDE927CA8, 0x3DE80E34, 0xE2AC6722, 0xCD789E7D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x48000000, 0x34000000, 0x92000000, 0x21000000, 0xCF800000, 0xE6C00000, 0x6BE00000, 0x7CF00000, 0xA8380000, 0x7EDC0000, 0x7BAE0000, 0x6E570000, 0x91E88000, 0xB5F5C000, 0xA3BBE000, 0x321FB000, 0x7D4E3800, 0xE3265C00, 0x10105200, 0xE8493100, 0x3EA6A280, 0x97D3F340, 0xAC2B7AA0, 0x7494AF50, 0x1C0BA8A8, 0x9A045E54, 0x3500EA26, 0x2D831D19 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x38000000, 0x84000000, 0x66000000, 0xB9000000, 0x90800000, 0xF1C00000, 0x9FA00000, 0x3F300000, 0x17F80000, 0xF2440000, 0xC7F60000, 0x9ACD0000, 0xC8A98000, 0x802EC000, 0x4FFB2000, 0xC644B000, 0xE9F5E800, 0xCFCD2C00, 0x82285E00, 0x2AEFB100, 0x9FD94380, 0x21371140, 0x00ED77A0, 0x6CD98130, 0xF2B4A9A8, 0x6AACF03C, 0x7538CA2A, 0x0E665179 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xA8000000, 0x2C000000, 0xD2000000, 0xEB000000, 0xAB800000, 0xFF400000, 0xFB200000, 0x8CB00000, 0x78C80000, 0x6C2C0000, 0x501E0000, 0xA4150000, 0xF8588000, 0x59D5C000, 0xB4BA6000, 0xE6865000, 0xEEA2D800, 0xEAF01400, 0x73696A00, 0xCC5D0F00, 0xA8B55780, 0x41A83F40, 0x653F5B60, 0xA9A6F050, 0x2410B168, 0x4F3B3F5C, 0x71C706EE, 0x59809011 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xE8000000, 0x2C000000, 0x42000000, 0x11000000, 0x4A800000, 0x26C00000, 0xD9600000, 0xBDF00000, 0xDB380000, 0x25840000, 0x9BF60000, 0xB88D0000, 0x44AB8000, 0x54CFC000, 0x7B096000, 0x905E5000, 0x8DC29800, 0x86E0BC00, 0x1FB14600, 0xE79B0500, 0xF2947C80, 0xBD7FFD40, 0xFB93DCA0, 0x8F485230, 0x5BFF1AA8, 0x5F51973C, 0xE7298622, 0x3C8FFA75 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x88000000, 0x34000000, 0xB2000000, 0xB1000000, 0x94800000, 0x42C00000, 0x44200000, 0xF1500000, 0x0A480000, 0xCF4C0000, 0xAF9E0000, 0x01950000, 0x993A8000, 0x67554000, 0x571A6000, 0x7B043000, 0x3FD1B800, 0x7D8A1C00, 0xC5EFFE00, 0xE90E8D00, 0xE17FA180, 0x60E74AC0, 0xA02126E0, 0x9B507E50, 0x974A58E8, 0x25CEB35C, 0x525D1966, 0xE634899B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xD8000000, 0x84000000, 0x02000000, 0xE7000000, 0x5A800000, 0x8B400000, 0x37E00000, 0x17B00000, 0xF5280000, 0x143C0000, 0x8A0E0000, 0x14E50000, 0x8F7B8000, 0x55A64000, 0x93982000, 0x1695B000, 0xA4F1F800, 0xD6C94400, 0x898F1E00, 0x34270B00, 0x0459F080, 0xEF36A040, 0xC92177E0, 0x3D91CB90, 0x503BE9E8, 0x8845809C, 0x9F29B962, 0xCF3CD0D3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x18000000, 0xFC000000, 0x76000000, 0x21000000, 0x83800000, 0xDB400000, 0xE9600000, 0x56700000, 0x14080000, 0x6F8C0000, 0x417E0000, 0x02B70000, 0xA1998000, 0xA134C000, 0xEADBA000, 0xF055D000, 0x90AAC800, 0x8A5CEC00, 0x2227B200, 0x3EA25700, 0xDAD0FE80, 0xF5DB2540, 0xF6D65A60, 0xE26ACED0, 0x3F7E6868, 0x27B759D4, 0xD81AB6E2, 0xE5766C99 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x68000000, 0xCC000000, 0x12000000, 0x71000000, 0x6F800000, 0x97400000, 0x94A00000, 0xFDF00000, 0xD8680000, 0x956C0000, 0x7FDE0000, 0xF3150000, 0x7B8A8000, 0x8C3DC000, 0x82456000, 0x4A12D000, 0x273A5800, 0xAFF47C00, 0x065AD200, 0x3467B700, 0x45234980, 0x99B03440, 0xDA489EE0, 0x0C5F50D0, 0xDE572CE8, 0xB22A37DC, 0x5C4E3D66, 0xD46E7F99 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x28000000, 0x8C000000, 0xA6000000, 0x6B000000, 0x93800000, 0x39C00000, 0x21200000, 0x00500000, 0x7FB80000, 0x641C0000, 0xE18E0000, 0x81170000, 0xDA5B8000, 0x05EEC000, 0xB0256000, 0x7852D000, 0x9BB98800, 0x6E1EC400, 0xFC8C9A00, 0x51969500, 0xFC190580, 0xBB0D96C0, 0xFA57F920, 0x943816D0, 0xB9DE0328, 0xCAAC53D4, 0x9C468EAA, 0x75630119 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x38000000, 0x64000000, 0xBE000000, 0x89000000, 0x30800000, 0xF6C00000, 0xDB200000, 0xADD00000, 0x2AC80000, 0x6BDC0000, 0x36CE0000, 0x6A270000, 0x82A98000, 0xF16FC000, 0x23342000, 0xA8423000, 0x7CE00800, 0x92738C00, 0xE7D8BE00, 0x4F344D00, 0x1A411D80, 0xB7E3DCC0, 0xE1F116E0, 0x2E98EA10, 0xBF5588E8, 0x14F29714, 0x941A9D62, 0xE695C7D5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x98000000, 0xF4000000, 0x9A000000, 0xE5000000, 0x60800000, 0x29400000, 0x65600000, 0x0F900000, 0x02780000, 0xA77C0000, 0x93AE0000, 0x9DB70000, 0x4BD98000, 0xC44CC000, 0x7265A000, 0x8241F000, 0xEAE05800, 0x9B53EC00, 0x0AD95E00, 0xE6CF0300, 0xEA270A80, 0xCDA3F2C0, 0xB1303420, 0x68CA4D50, 0x1174CA28, 0xF778BE54, 0xBFFD98A2, 0x3EEFA099 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xD8000000, 0x24000000, 0xEE000000, 0xC1000000, 0xE5800000, 0x0AC00000, 0xF8A00000, 0xB8F00000, 0x70580000, 0x63140000, 0xBB260000, 0x4CDD0000, 0xFBBA8000, 0x53854000, 0x9C2F2000, 0x97E33000, 0x8A90C800, 0xD00A6C00, 0xDBBD8A00, 0x70694900, 0xB0EC7780, 0xE2401640, 0x25E29220, 0xD191F3F0, 0x52883828, 0x79FF8AFC, 0x758A87A6, 0xF17CF0BB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x28000000, 0xAC000000, 0x46000000, 0x21000000, 0x0C800000, 0x91400000, 0x70200000, 0x15F00000, 0x83480000, 0x3E0C0000, 0x20BE0000, 0x7CD70000, 0xC6A98000, 0x269D4000, 0x2026E000, 0x4563D000, 0x7FD08800, 0x79BB6C00, 0x8CC7CE00, 0xED72E300, 0x30091F80, 0x952CCE40, 0xC6CFEC60, 0xC75F75D0, 0xFF46C268, 0x95B246D4, 0x97E955E2, 0xB6BEE49F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xA8000000, 0x74000000, 0x6A000000, 0x2D000000, 0xB3800000, 0x31400000, 0x27200000, 0xEF100000, 0xD1E80000, 0x3FB40000, 0x2FE60000, 0xC62F0000, 0xB4088000, 0x66C44000, 0x663DE000, 0xDF62B000, 0xA9B05800, 0xAEB98C00, 0x7CFFB200, 0x5503CF00, 0x9F83EF80, 0x674179C0, 0xA420DD60, 0xB390AE30, 0x0A2A8F68, 0xF055D134, 0xFB9738E6, 0x6C7624FF } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x18000000, 0xB4000000, 0xC6000000, 0x85000000, 0xB2800000, 0x4EC00000, 0x90E00000, 0x0F100000, 0x4CF80000, 0xAFD40000, 0x24060000, 0xBF1F0000, 0xD65B8000, 0x83E64000, 0x218D2000, 0x33E27000, 0xA8902800, 0x78B89C00, 0x2DF46600, 0xD1F55500, 0x0BF77A80, 0xC4F5C8C0, 0x7177D220, 0xD63461F0, 0x8B969428, 0x2E2744F4, 0x36EFC6AA, 0xF8B1103B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x48000000, 0x84000000, 0xDE000000, 0x55000000, 0xDD800000, 0x96400000, 0x37E00000, 0x15100000, 0xCA380000, 0x6DD40000, 0x7B860000, 0xFBDF0000, 0x45588000, 0x3B044000, 0x741E6000, 0xDAFAF000, 0xFCF6C800, 0x3EB77C00, 0x6F55BA00, 0x0347CB00, 0xFEFED880, 0xC66B9EC0, 0x868EF120, 0xFD80ECF0, 0x86432B28, 0x2FE2D7F4, 0x6913BBA6, 0xD83A753F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x68000000, 0x84000000, 0x32000000, 0x1F000000, 0x04800000, 0xB6400000, 0xDC600000, 0xFED00000, 0xECB80000, 0x7B140000, 0xE4860000, 0xE4DD0000, 0xFD5A8000, 0x4A06C000, 0xF19E6000, 0x1BB8F000, 0x3B97F800, 0x80C56400, 0xB7BE4600, 0x6F0B8700, 0x94FDA280, 0x64E887C0, 0x1EEDA620, 0x377196F0, 0xB0CB8028, 0xC55FE1FC, 0x849B5AA6, 0x9EA4C235 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x68000000, 0x94000000, 0x3A000000, 0x67000000, 0x1A800000, 0x39400000, 0x49E00000, 0x43100000, 0x29580000, 0xE1140000, 0x40460000, 0xF47D0000, 0x423B8000, 0xA746C000, 0x2EFE6000, 0xDB79B000, 0x3EA69800, 0x05ECE400, 0x6622FE00, 0xE5B36300, 0x22AAD080, 0x88DF5AC0, 0x9EC888A0, 0xCC0F1A70, 0xE53216A8, 0x6CE8C97C, 0x13BDDE22, 0xA099B7B1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x88000000, 0x84000000, 0x1E000000, 0xB7000000, 0xEC800000, 0x4A400000, 0xFA600000, 0x05D00000, 0x9AD80000, 0x1BEC0000, 0xCF7E0000, 0x89470000, 0x5C398000, 0x3C7FC000, 0x9BC6E000, 0x117B7000, 0xB29FC800, 0xD8547400, 0xEBC07600, 0x05A3F700, 0xD671DA80, 0xDFAA13C0, 0x26C4CBA0, 0x9CF8E090, 0x875C5DA8, 0x8AF76794, 0x6133CF22, 0x084AC055 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x28000000, 0x74000000, 0xE2000000, 0xA1000000, 0x85800000, 0x70C00000, 0x95200000, 0x09500000, 0x08880000, 0xB8840000, 0x8C160000, 0x1A3F0000, 0xB4298000, 0xEF14C000, 0xAEBF6000, 0xC9693000, 0xAEF57800, 0xF8CF1C00, 0x1DB3FA00, 0x797BA100, 0x1D9E1980, 0x9B3B5EC0, 0xAEFEB1E0, 0xDB0BE870, 0x6B442BE8, 0x4DB67974, 0x1E2ECA62, 0x0542FBB9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x88000000, 0x9C000000, 0x5E000000, 0xE9000000, 0x52800000, 0x5D400000, 0x77600000, 0xB4B00000, 0xEB180000, 0x710C0000, 0x7FFE0000, 0xB0070000, 0x567B8000, 0xAEBFC000, 0x5166E000, 0xB7C91000, 0xD924A800, 0x1C286C00, 0x71D6F600, 0xDED14B00, 0x3F29AA80, 0x48560640, 0x46107D20, 0x3E8ADD90, 0x0C466B28, 0xAF998694, 0x394EE9AA, 0xB41F2CDD } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x38000000, 0x54000000, 0xE6000000, 0xCD000000, 0x4C800000, 0x70400000, 0x2A600000, 0x81900000, 0x21A80000, 0x59D40000, 0x67060000, 0x734F0000, 0x2ECB8000, 0xA8C54000, 0xACEEA000, 0x77FA7000, 0xC3DFA800, 0xB9E3BC00, 0xE650BE00, 0xE20AF700, 0xAAE65280, 0x431D22C0, 0x39C27F60, 0x1AA10CB0, 0x79B26168, 0xA95A8BB4, 0x146E1BEA, 0x91BA5577 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x48000000, 0x9C000000, 0xEA000000, 0xBB000000, 0x12800000, 0xBC400000, 0x1C600000, 0xDBF00000, 0xE6F80000, 0x59DC0000, 0x036E0000, 0x82770000, 0xF1988000, 0x48ADC000, 0x6DD7E000, 0x61CB1000, 0x30067800, 0x19A1F400, 0x81526E00, 0x31288700, 0x0AB45280, 0x08BB8B40, 0x5ABD53A0, 0xC41D0050, 0x8DCEDDA8, 0x23A59754, 0xF3F27726, 0xEAF92819 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x28000000, 0x4C000000, 0x52000000, 0xA1000000, 0x46800000, 0x30C00000, 0xD6E00000, 0xCF900000, 0x00280000, 0xC9340000, 0xB0E60000, 0x36EF0000, 0x56AB8000, 0x91F7C000, 0x0A046000, 0x3B7CD000, 0xDF835800, 0x52413C00, 0xD820B600, 0x7A708D00, 0x003A5A80, 0xF35E5AC0, 0xCDF0B360, 0x3E7A4730, 0xE97FE568, 0x3E81DA34, 0x34C287EA, 0x78E26CFD } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xA8000000, 0x34000000, 0xA6000000, 0x37000000, 0x95800000, 0x12C00000, 0xEE200000, 0xEB500000, 0x92680000, 0xC0240000, 0xA4360000, 0x6EBD0000, 0xF5EA8000, 0x33E64000, 0xA095E000, 0x86ADB000, 0x95626800, 0xF5B0D400, 0x4E1BF200, 0x9F9E7100, 0x7F3B4D80, 0xF54DCAC0, 0x0993CE60, 0xF449E570, 0x4F775C68, 0x885C647C, 0x059B99E6, 0x565CCAB7 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x18000000, 0x5C000000, 0xDE000000, 0xF3000000, 0x5D800000, 0x4A400000, 0x84A00000, 0x9D300000, 0x1E880000, 0x954C0000, 0xB3BE0000, 0x05D70000, 0xF6088000, 0x6D8E4000, 0x1EDD2000, 0x9506D000, 0xB492E800, 0x6D3B8400, 0x7C06E200, 0xD8104300, 0xB7F92580, 0x2C670B40, 0xCE431E60, 0xA6A2A8D0, 0x60305C68, 0x980A7BD4, 0xC68EB1E6, 0xFF5C2497 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xE8000000, 0x2C000000, 0xCE000000, 0xB1000000, 0x70800000, 0xDAC00000, 0xCE200000, 0x57900000, 0xC7780000, 0x81D40000, 0xF8060000, 0xE99D0000, 0x5EFA8000, 0x2F944000, 0xEEE6E000, 0x3F2ED000, 0xE792A800, 0xEF790C00, 0x4DD4DE00, 0x0605BD00, 0xB09CB980, 0x027AC1C0, 0x3B550520, 0x91C6C9F0, 0x183DBB28, 0xFA29E4FC, 0xA08D4AA6, 0xE240F93F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x18000000, 0xA4000000, 0x8E000000, 0x03000000, 0xBA800000, 0xBD400000, 0x57A00000, 0xB0900000, 0x2F880000, 0xCE840000, 0x75D60000, 0x42BD0000, 0xE20B8000, 0x0F454000, 0xB0342000, 0x1D0F3000, 0xF1534800, 0x2A69E400, 0x3136FE00, 0x568C2300, 0x7F908980, 0xC7084DC0, 0xCAC5BCE0, 0x3DF7F570, 0x4AECE2E8, 0xB7E1A67C, 0x16B30362, 0xB4DB3FBF } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x58000000, 0x14000000, 0xCE000000, 0xE3000000, 0x68800000, 0xB4C00000, 0xC0E00000, 0xF3700000, 0xC6480000, 0x7B740000, 0xFA460000, 0x7B2F0000, 0x93498000, 0x94F74000, 0x10052000, 0xC80EF000, 0x5E5B8800, 0xE20FA400, 0xCB583600, 0xED8C0D00, 0xB11AFA80, 0x36AF3940, 0x300B2160, 0x9A545430, 0xC657B768, 0x3455E934, 0xF555E5E2, 0x94D48477 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x48000000, 0xCC000000, 0x9A000000, 0x43000000, 0xB3800000, 0xEA400000, 0x45A00000, 0x3E100000, 0x78F80000, 0x37E40000, 0x1A360000, 0x262F0000, 0xA5F98000, 0xD167C000, 0x3AF5E000, 0x694D5000, 0xCF89F800, 0xF46F9400, 0x94584A00, 0x41773B00, 0x0F0C8980, 0xB02953C0, 0x997F0720, 0x17225F30, 0x50D32D28, 0xCA9BF434, 0xEB15BCA2, 0xF7FF63F5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x08000000, 0x3C000000, 0xF2000000, 0xEF000000, 0x0E800000, 0x1C400000, 0x8C600000, 0xF2500000, 0xD8E80000, 0xDCC40000, 0x62560000, 0xFF9D0000, 0x60EA8000, 0xD8C4C000, 0x5455E000, 0xC69D9000, 0x47699800, 0xEB044400, 0xD7F5AE00, 0x456E6700, 0xF373E280, 0x8D59CDC0, 0xCFBD3560, 0x2EDABEF0, 0x0A7FFB68, 0x747989FC, 0xBE0E61E6, 0xFBA0903D } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0xD8000000, 0xF4000000, 0xA6000000, 0x71000000, 0x5C800000, 0x96400000, 0x76600000, 0xF5D00000, 0x0BE80000, 0xD8B40000, 0x5DA60000, 0x1D6F0000, 0x41E98000, 0x1BB7C000, 0x6627A000, 0x6EAFF000, 0xD14BA800, 0x5C474C00, 0x397D8E00, 0x65A11F00, 0x95735A80, 0x241A1BC0, 0xBBEF2F60, 0xDCA8C530, 0x7A548168, 0xB235EA34, 0x22E5D3E2, 0x638C4DF5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x28000000, 0x94000000, 0xC2000000, 0x1F000000, 0x28800000, 0x5BC00000, 0x5D600000, 0x71300000, 0xA6080000, 0xDD1C0000, 0x406E0000, 0x88470000, 0x82C98000, 0x78FF4000, 0xD29CE000, 0xFF2D3000, 0x50E47800, 0xD7986400, 0x72443600, 0x51CB0100, 0x8E7C8080, 0xF05CDA40, 0x7FCC6F60, 0xD997B190, 0x9DB33968, 0xC7C9C094, 0xB37EA1E2, 0x57DF0ED7 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xD8000000, 0xF4000000, 0xAE000000, 0x1F000000, 0x5C800000, 0x82400000, 0x68A00000, 0x3BF00000, 0x9C480000, 0x3DD40000, 0x77E60000, 0xD5CD0000, 0xB50B8000, 0xC7F7C000, 0xE155A000, 0x35A7F000, 0x1D6D8800, 0x1EF8D400, 0x83BF1600, 0x28817700, 0xEC419180, 0xD7A3B040, 0xF7711A60, 0xC608B6B0, 0xA1762C68, 0xE214F1BC, 0x568415E2, 0xD45FA5F5 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x58000000, 0xF4000000, 0x4A000000, 0x13000000, 0x35800000, 0xBB400000, 0xA8200000, 0xEF500000, 0xD1680000, 0x436C0000, 0x7DFE0000, 0x64750000, 0x4A2B8000, 0x1B4D4000, 0x6AAD2000, 0x711F7000, 0x1B441800, 0x81B1F400, 0x71599200, 0x93768700, 0x9DA9C380, 0xBF0F24C0, 0x790CBA60, 0x240F6A50, 0xB08D8868, 0xE94EDD5C, 0xDDAEF3E2, 0xC69E3D9F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x68000000, 0xB4000000, 0xCA000000, 0x71000000, 0x79800000, 0xF0C00000, 0xE8A00000, 0xCD300000, 0x2C580000, 0xBD8C0000, 0xE2FE0000, 0xEE450000, 0xB7198000, 0xE8EC4000, 0x10ECE000, 0xDCEDB000, 0x1AEDD800, 0x8DEE7C00, 0x936CEA00, 0x152ED100, 0xCFCF9F80, 0x121C8940, 0x92961D20, 0xD6108A90, 0x80A99728, 0xD0F6AB9C, 0xFA80B0AA, 0x1440AED3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x58000000, 0xFC000000, 0x22000000, 0x75000000, 0x87800000, 0xCCC00000, 0x54A00000, 0x29D00000, 0x3E380000, 0xC37C0000, 0x8EEE0000, 0x96370000, 0xE9788000, 0x291EC000, 0x3E9CA000, 0xEA5DD000, 0xA2FE9800, 0xB92E6C00, 0xAA16E200, 0x12EAA900, 0x72C4A780, 0xC550CAC0, 0x82799F20, 0x599E3350, 0xF0DD5D28, 0xBDBC8A54, 0xB74D42A6, 0x24663C95 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x68000000, 0x84000000, 0x52000000, 0x49000000, 0x5D800000, 0x86400000, 0x7C200000, 0xC4B00000, 0x1FA80000, 0xFAFC0000, 0xFA8E0000, 0x19C70000, 0xE96B8000, 0xBF1EC000, 0x155C6000, 0xDF7FF000, 0xF0CD7800, 0x43E6BC00, 0x8ED87A00, 0x58373B00, 0xE261A780, 0xC4916740, 0x4518B6E0, 0xAA56D490, 0x2EF12CE8, 0xF58BDF94, 0x054C136A, 0x21A634D9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xC8000000, 0x54000000, 0xD6000000, 0x51000000, 0x3A800000, 0xE5400000, 0x0E200000, 0x15D00000, 0x8BD80000, 0x8EF40000, 0x27E60000, 0xE2DD0000, 0x45198000, 0xBF17C000, 0xE955E000, 0xAAF73000, 0xC9E4A800, 0x1FDE8C00, 0x25981600, 0x41578B00, 0x0EF4AF80, 0xE7E6D6C0, 0xC2DF46A0, 0x5519B0F0, 0x771530A8, 0xBD57CBFC, 0x7CF7572A, 0x98E6613D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xA8000000, 0x54000000, 0x3A000000, 0xFB000000, 0x3E800000, 0xAA400000, 0x11A00000, 0xB4D00000, 0xB6980000, 0xE05C0000, 0xCD4E0000, 0x83B70000, 0xE75B8000, 0xDC3F4000, 0x6BFEE000, 0x729E3000, 0x83AC9800, 0x49471400, 0x92D01E00, 0xF3990F00, 0x27DF4D80, 0xEE8C08C0, 0xC0D741A0, 0x7D680F50, 0x30543FA8, 0xE62B7054, 0x6C748A2A, 0x223A1C9F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x28000000, 0xA4000000, 0xAA000000, 0xA3000000, 0xC1800000, 0x07400000, 0xC7200000, 0x0DD00000, 0x56880000, 0xA8E40000, 0xF6160000, 0x9F4D0000, 0x3E208000, 0x9752C000, 0x7C496000, 0x76867000, 0x1DE69800, 0x0297B400, 0xAC8FA200, 0xAAC15700, 0x1E626780, 0x8BF0C6C0, 0x8DDAA9E0, 0xBAADDAF0, 0x999393E8, 0xC82B39FC, 0x5E76566E, 0x51BEA83D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x08000000, 0x44000000, 0x8A000000, 0x7F000000, 0x88800000, 0x70400000, 0xE7E00000, 0xB9B00000, 0xDBB80000, 0xA55C0000, 0x270E0000, 0xF3050000, 0x94E38000, 0x9F334000, 0x4EF86000, 0x0D3FF000, 0x2A7D1800, 0x711FC400, 0x9AEE7600, 0x2DB75F00, 0x3BD91C80, 0x8C2EC840, 0x3F174FA0, 0x3A0A3950, 0xE2E421A8, 0x5452A25C, 0xDD0B4B22, 0x56673517 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x08000000, 0xF4000000, 0x12000000, 0xD3000000, 0x3D800000, 0x8CC00000, 0x0DE00000, 0x75B00000, 0xB5480000, 0x223C0000, 0x206E0000, 0x57970000, 0x37618000, 0xE6F24000, 0x4F6B6000, 0xE3EE3000, 0x7655B800, 0xEA03D400, 0x6F007200, 0x7B82C900, 0x3DC31280, 0xEB602240, 0x30F0AC60, 0x26688F10, 0x896D6668, 0xDD159214, 0x4C2006E2, 0x38D07953 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x58000000, 0xCC000000, 0x02000000, 0x51000000, 0xCA800000, 0xC8C00000, 0xFC200000, 0x0A100000, 0xA9A80000, 0x0B6C0000, 0xAB5E0000, 0xB7E70000, 0x5CA28000, 0x47D24000, 0x310A2000, 0x2ABC9000, 0x3D545800, 0x78D97C00, 0x68B6E600, 0x5C680D00, 0xAFCD5980, 0xB08D2BC0, 0x0CEF8660, 0x031C0F50, 0x26053868, 0x1E117E54, 0x27A887EE, 0x386F589F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x78000000, 0xDC000000, 0x82000000, 0x33000000, 0xE5800000, 0x79400000, 0xC0600000, 0xC3F00000, 0x5B880000, 0x7AEC0000, 0x8E7E0000, 0x7D870000, 0x0CA08000, 0xA2D0C000, 0xF4182000, 0x8894D000, 0x381A9800, 0x3294B400, 0x3718D200, 0xC515FF00, 0x05591280, 0x3CF5DB40, 0x3DEB0860, 0x941F7650, 0x61774268, 0x38A93D54, 0xA67E02E6, 0x7985D91D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x18000000, 0xB4000000, 0x1E000000, 0x07000000, 0xA5800000, 0x68400000, 0xE2A00000, 0xFA900000, 0x29E80000, 0xAB540000, 0x28660000, 0xAC9F0000, 0x0B608000, 0x66704000, 0xCAD92000, 0xDFAC7000, 0x7798C800, 0xC58FB400, 0xA1CB7200, 0xC004EB00, 0xD96D5D80, 0x02FAD1C0, 0x54FE5F60, 0x36906CB0, 0x73EBE568, 0x4A5433B4, 0x8EE54AE6, 0x675E497F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x48000000, 0x74000000, 0xB2000000, 0x79000000, 0x8A800000, 0x7F400000, 0xF8A00000, 0x50D00000, 0x95980000, 0xFB840000, 0x18F60000, 0x6E3F0000, 0xD5E38000, 0xE170C000, 0x77C8E000, 0x7D5DB000, 0x95D03800, 0x991BFC00, 0x6FC58600, 0x43D57300, 0x832E1580, 0xB3990CC0, 0x0086FFA0, 0xD377FF30, 0xF7FD41A8, 0xDC027034, 0xF603522A, 0xF301CFF1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0xB4000000, 0xC2000000, 0xC5000000, 0xA9800000, 0xEBC00000, 0xAC200000, 0xB8300000, 0xB6480000, 0x001C0000, 0xB30E0000, 0x61F70000, 0xEDE28000, 0xB512C000, 0x8DF9E000, 0xBC96B000, 0xFCB1F800, 0xF00BCC00, 0xFDFF3A00, 0xCE1E5D00, 0x380E9980, 0x0377AF40, 0x04A14160, 0x6073CD90, 0x68A98368, 0x5B8D5C94, 0xD9B4A0EE, 0xA3016EDD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x78000000, 0xF4000000, 0x96000000, 0xE9000000, 0xC8800000, 0xB0400000, 0x67200000, 0x9D900000, 0x76580000, 0xE0CC0000, 0xF17E0000, 0x7D370000, 0xE2608000, 0x8830C000, 0xA0882000, 0xAE347000, 0x91E26800, 0x87F32C00, 0x4A695E00, 0x36440700, 0x264B9F80, 0x5C57FBC0, 0x21D1EBA0, 0x3378C810, 0xE25CDDA8, 0x36A4E314, 0x9D389C26, 0x307CDFDD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xC8000000, 0xE4000000, 0x06000000, 0x2B000000, 0xB4800000, 0x72C00000, 0xC1E00000, 0x74300000, 0xD4180000, 0x23D40000, 0x52860000, 0x086F0000, 0x3A408000, 0xC9214000, 0xA4D36000, 0xE5AB7000, 0x308CA800, 0xBFF12400, 0x047B6600, 0xBEA43500, 0x773DDE80, 0x0FAB3C40, 0x598C9720, 0x367057F0, 0xD13BD928, 0x950406F4, 0x522E01A6, 0x43607FBB } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x58000000, 0x8C000000, 0xB6000000, 0x41000000, 0x15800000, 0x7F400000, 0xE4A00000, 0x47D00000, 0x96080000, 0x40340000, 0x8EC60000, 0xBC5D0000, 0xB0C08000, 0x1CE04000, 0xCFF22000, 0x87199000, 0xA3DD8800, 0xA083EC00, 0x40C08A00, 0xE4E12F00, 0x93F0F980, 0xD91A10C0, 0x36DEE5E0, 0x8F029FB0, 0xC88367E8, 0x54C01CBC, 0xBEE1346E, 0xD4F2B377 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x78000000, 0x0C000000, 0xA2000000, 0x6D000000, 0x73800000, 0x78400000, 0x34200000, 0x9C900000, 0x09D80000, 0x68940000, 0x6FA60000, 0x38AD0000, 0x3CC38000, 0x9EE3C000, 0xA1712000, 0x242B9000, 0xC27F5800, 0xE6390C00, 0xA065F200, 0xF2CD1B00, 0x8F73BF80, 0x2B2B23C0, 0x7CFE75A0, 0x7DF8DF70, 0x94075FA8, 0x567F087C, 0xB8383222, 0x2766A0B5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x18000000, 0x1C000000, 0xD6000000, 0xDD000000, 0x94800000, 0x87C00000, 0x12A00000, 0x24300000, 0x1CF80000, 0x013C0000, 0xAD2E0000, 0xF3270000, 0x4EC28000, 0x1422C000, 0xD4F3A000, 0x01DA5000, 0xF34F4800, 0xAC365C00, 0x95497E00, 0x1487B900, 0x4A71C780, 0xAD19E540, 0x586D39A0, 0x13478FD0, 0x18D18FA8, 0xE928AAD4, 0xD494962E, 0x0A7BA69D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x88000000, 0x0C000000, 0xA2000000, 0x89000000, 0x4E800000, 0x92C00000, 0x5CA00000, 0x4FD00000, 0x52380000, 0x3DC40000, 0x8E360000, 0xCA1D0000, 0xAEC18000, 0xB6A14000, 0xEAD06000, 0x0EB8D000, 0xAE049800, 0x90169C00, 0xB50C9600, 0x2958D500, 0x8A374380, 0xA41C66C0, 0xA5C0D520, 0xC12398B0, 0xBE915B28, 0xCCD891BC, 0x1F74EEAA, 0x04FDF277 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x68000000, 0xAC000000, 0xEA000000, 0x13000000, 0xF7800000, 0x2E400000, 0x8A200000, 0x25D00000, 0xA4080000, 0xAD6C0000, 0xD31E0000, 0x95870000, 0x7A408000, 0x0423C000, 0xC0D36000, 0x928A5000, 0xA3ACB800, 0xC6FF5400, 0xED373A00, 0x953BAB00, 0xF1568F80, 0xBECB66C0, 0xD68F7FE0, 0x1EAD8AD0, 0x247C7DE8, 0x2DF6B5D4, 0x85D8A866, 0xEF672811 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xB8000000, 0xDC000000, 0xB6000000, 0xD5000000, 0x0A800000, 0xC2C00000, 0x6B200000, 0x7FF00000, 0xF4280000, 0x9D140000, 0xF9460000, 0x2B5F0000, 0xCAC08000, 0x3F20C000, 0xDDF32000, 0x632BD000, 0x90974800, 0x8E04FC00, 0xEB3EA600, 0xC350F500, 0x179A4D80, 0x62DC7840, 0xE78253E0, 0x54421330, 0xFFE33DE8, 0x51D2DA34, 0x395AF666, 0x77FE877D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xD8000000, 0x1C000000, 0x4E000000, 0xB5000000, 0x1F800000, 0x81C00000, 0x86200000, 0xC4B00000, 0x80780000, 0x05AC0000, 0x31BE0000, 0xC5370000, 0xC2038000, 0x6301C000, 0x9683A000, 0xC0435000, 0x6AE22800, 0x41139C00, 0x8B0B9200, 0xB6F4AD00, 0xEF226180, 0xF5320D40, 0x84BB8BA0, 0x540D4590, 0xB0CFB1A8, 0x916CB494, 0xF81E622A, 0x784484D5 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x78000000, 0xF4000000, 0x0E000000, 0x8B000000, 0xF7800000, 0xC9400000, 0xC1200000, 0xECD00000, 0x4B580000, 0x3E540000, 0x63260000, 0xC06D0000, 0xD8028000, 0x4402C000, 0x06002000, 0x97007000, 0x75820800, 0xB841C400, 0xB3A1CA00, 0x5912D700, 0xB4BBFF80, 0xDAE792C0, 0x058F9AA0, 0x59B36770, 0xCE28D8A8, 0xD91FB47C, 0x7D484D26, 0xCB6C41B5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xC8000000, 0x2C000000, 0x2E000000, 0xF1000000, 0x53800000, 0x97C00000, 0x3BE00000, 0x09900000, 0xF3580000, 0xD9A40000, 0x7D560000, 0xA9DF0000, 0xAC028000, 0x6E00C000, 0x9102E000, 0x4383D000, 0x5FC32800, 0x17E3CC00, 0x27923200, 0x0258D500, 0x8A27FE80, 0xEA9496C0, 0x923C04A0, 0xA5920DB0, 0x9D599EA8, 0x48A6D4B4, 0x3ED4322E, 0xF61D8775 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xE8000000, 0x8C000000, 0x5A000000, 0x47000000, 0xE4800000, 0x4A400000, 0x6E600000, 0xBCD00000, 0xA7880000, 0xF10C0000, 0x343E0000, 0x8FA50000, 0x24038000, 0xB6024000, 0x4D02E000, 0xBB825000, 0xCAC0F800, 0xF2224400, 0xCFB3E600, 0xB8DBA700, 0xF8470280, 0xE11063C0, 0x692AD4E0, 0xB0FD2950, 0xC4844AE8, 0x3E338A5C, 0x4D19CE62, 0xDAE45E93 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0xE8000000, 0x6C000000, 0xBA000000, 0xF1000000, 0xD5800000, 0x16400000, 0x94200000, 0x02500000, 0x78B80000, 0xDC3C0000, 0x74CE0000, 0x8CE50000, 0xB7818000, 0x83424000, 0xC7A2E000, 0xC713D000, 0x4C18F800, 0xCBAC9C00, 0xC5147A00, 0xE229CB00, 0x7A66DF80, 0x294140C0, 0x4EA2DB20, 0xC6900B50, 0x1459D928, 0x908E1C5C, 0x35C61CAA, 0x1252079B } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x28000000, 0xB4000000, 0x66000000, 0x0F000000, 0x75800000, 0xDE400000, 0xCE200000, 0x91B00000, 0x54C80000, 0xAAFC0000, 0xFB2E0000, 0x18750000, 0xE3F18000, 0xD0EAC000, 0xBE4D6000, 0x7F653000, 0xEC4AE800, 0xA03CF400, 0x55CFB200, 0xF2267300, 0xA5EA6780, 0xD6CF8F40, 0x9DA6E960, 0xD6AA6410, 0x7C6ED368, 0x34D5D31C, 0x3581EEEA, 0x3E40DB59 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x58000000, 0x3C000000, 0x8E000000, 0x55000000, 0x43800000, 0x28C00000, 0x11600000, 0x47B00000, 0x20980000, 0x31EC0000, 0xD3FE0000, 0xBBB70000, 0x30728000, 0x657A4000, 0xFE1E2000, 0x50455000, 0x61C8A800, 0xD4071C00, 0x54EB2200, 0x36965900, 0x1EE3F880, 0x9970F040, 0x88FA5520, 0x53DF3110, 0xEAA7FF28, 0x6ABB2414, 0x57FF8DAE, 0xF9B6915F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x18000000, 0xAC000000, 0x8E000000, 0x83000000, 0xEC800000, 0xE9400000, 0x47200000, 0x9BB00000, 0xF2380000, 0x1D240000, 0x74F60000, 0xDC5D0000, 0x3FF38000, 0xBA9AC000, 0xF355A000, 0xE0AF9000, 0xA9E9E800, 0x008F0400, 0x84D84600, 0xCAF63B00, 0xF75F5B80, 0x17721F40, 0xB9D96EA0, 0x0D771CB0, 0x369D60A8, 0x5311B3BC, 0xDC4B9522, 0x297E93F1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xA8000000, 0x94000000, 0xD2000000, 0xE3000000, 0xA4800000, 0x7F400000, 0xA4E00000, 0x13300000, 0x30A80000, 0xE4840000, 0xD0160000, 0xB16F0000, 0x37708000, 0x4CC8C000, 0x2EF76000, 0xE55CB000, 0xA958B800, 0x980C1400, 0x10819600, 0x9D410300, 0x9FE28C80, 0x1BB07A40, 0xA1E879E0, 0xE5645270, 0x56A637E8, 0xB905F574, 0xACD59566, 0x544C983D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x78000000, 0x04000000, 0x32000000, 0x5D000000, 0xA7800000, 0xEE400000, 0x60200000, 0xFC700000, 0x0B880000, 0xA79C0000, 0x678E0000, 0xED570000, 0x7AB28000, 0x8F6BC000, 0xBA0F2000, 0xB214B000, 0x93123800, 0x26592C00, 0x6125E200, 0xF938F300, 0xE4F45780, 0x43829040, 0x4C41A360, 0x2522CB90, 0x8FF15968, 0xAFCBA494, 0x9EBCD4EE, 0x0E7FEBD9 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x88000000, 0x54000000, 0x76000000, 0x59000000, 0xDA800000, 0xA9C00000, 0x36A00000, 0x60700000, 0xEF780000, 0x4E340000, 0x0F260000, 0x9B8D0000, 0x46328000, 0xC099C000, 0x2A24E000, 0x130C3000, 0xF8F3A800, 0xF9B96C00, 0x93151600, 0x1815C900, 0x15976780, 0x53D5F440, 0xEC359AA0, 0xE024EAF0, 0xF80FC4A8, 0x65707FFC, 0xD7F81D26, 0x28F42EB9 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xD8000000, 0xC4000000, 0xFA000000, 0x0D000000, 0xC6800000, 0xDB400000, 0x87E00000, 0x88F00000, 0x93380000, 0x8DA40000, 0x8FF60000, 0x58DF0000, 0x2B308000, 0x78994000, 0xA9372000, 0x79FDB000, 0xC2E09800, 0xE2724C00, 0x4E788600, 0xC944E300, 0xEE841880, 0x1F24A940, 0xC6B52CA0, 0x2E3E37B0, 0xAB4212A8, 0x1FE128B4, 0xACF01426, 0x99382EFB } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x78000000, 0xBC000000, 0xE6000000, 0x7D000000, 0x5D800000, 0x07C00000, 0x7D600000, 0xA0F00000, 0xA8A80000, 0x3CAC0000, 0x1BFE0000, 0x73470000, 0xA0708000, 0x02EBC000, 0x8E0F2000, 0x526C5000, 0x591F8800, 0x13741C00, 0xE33ADA00, 0xC1F6BD00, 0xA67B4C80, 0x21D7A140, 0xEAA928E0, 0x0BAD79D0, 0x457D5AE8, 0xB80488D4, 0x1953C466, 0x19BA4891 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x78000000, 0x04000000, 0xFE000000, 0xCF000000, 0xBF800000, 0xB0C00000, 0x16E00000, 0x41D00000, 0x61980000, 0xDBDC0000, 0xD32E0000, 0x4A070000, 0x29508000, 0x9AD84000, 0x1BFCA000, 0xFF1D3000, 0x53CD0800, 0xE8D45400, 0xC5487A00, 0xBCC6A100, 0x54B2D680, 0xCA8A57C0, 0xCDA66EA0, 0xF1A10450, 0x8BF1BCA8, 0xE4A9C154, 0x06969826, 0x9BE9239F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xF8000000, 0xD4000000, 0x1E000000, 0x13000000, 0xEE800000, 0x3D400000, 0x61200000, 0x64D00000, 0xB5A80000, 0x744C0000, 0x47FE0000, 0x1D250000, 0x03508000, 0x336AC000, 0x71AE2000, 0x67CEF000, 0xAF3DC800, 0xE3C7E400, 0xE1E34E00, 0x76322300, 0xFD1BBB80, 0x2C146AC0, 0xCEC84560, 0x513D4AD0, 0x20C6E368, 0x97637DDC, 0x8F735EEE, 0x7A38101D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xB8000000, 0xEC000000, 0x82000000, 0x17000000, 0xF6800000, 0x27400000, 0xADA00000, 0xB1100000, 0x8DB80000, 0x3D0C0000, 0x2DFE0000, 0x20750000, 0xD5918000, 0x75F94000, 0x122CA000, 0x65AD9000, 0x2D6E5800, 0x540C6400, 0x867ECE00, 0x92B6BB00, 0x77F3E180, 0x630AF7C0, 0x8EA70020, 0x37C81890, 0x2DC53628, 0x8EBA579C, 0x458FC1AA, 0x0FBF3F57 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x98000000, 0x1C000000, 0x66000000, 0x87000000, 0xA3800000, 0x6E400000, 0xE6200000, 0xC1300000, 0x6BD80000, 0xE0B40000, 0x88E60000, 0x40AF0000, 0x37308000, 0x34DAC000, 0xBF35A000, 0x90A45000, 0xB98C8800, 0x49837400, 0x5743CA00, 0x3EA08B00, 0x7AF2FF80, 0xFCBAAD40, 0x7826C720, 0x2A4E2370, 0xAAE22528, 0x3DD28C74, 0xF90918A6, 0xCE3E1E35 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x18000000, 0x94000000, 0x3A000000, 0xF9000000, 0xDA800000, 0x4FC00000, 0xD3A00000, 0x3B100000, 0xEEB80000, 0x5C8C0000, 0x90FE0000, 0x99770000, 0xBB108000, 0xAEBB4000, 0xBC8E2000, 0xE0FDF000, 0x8175D800, 0x2F11DC00, 0x94BB2600, 0x458F9100, 0x3A7CEB80, 0xCEB745C0, 0xFCB1C420, 0xAFA90290, 0xAB371A28, 0x66F1BF94, 0x5E4B8FA6, 0x65C4F753 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x38000000, 0xF4000000, 0xA2000000, 0x7F000000, 0xBF800000, 0x18C00000, 0x02E00000, 0xEF900000, 0x7C280000, 0x778C0000, 0xF73E0000, 0x5AE50000, 0x97928000, 0xA82B4000, 0xC58CA000, 0x403EF000, 0x2964B800, 0xD9522400, 0x77CACA00, 0xEA9FC100, 0x9B546680, 0x44CB6EC0, 0xC31E6160, 0xBE945AD0, 0x76AAB368, 0xB3CE4FDC, 0x2C9C27E6, 0x4E568413 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x38000000, 0x54000000, 0xEE000000, 0xB9000000, 0x79800000, 0x9AC00000, 0xAA600000, 0x7F100000, 0x97180000, 0x4F840000, 0xCB360000, 0x0BDD0000, 0x6C118000, 0x119A4000, 0x29C5A000, 0x70167000, 0x7F6F0800, 0x54F98C00, 0x0256FA00, 0xCA4EC900, 0xC9485480, 0x0B3CB6C0, 0x2F4245A0, 0x3AA00430, 0x9A7017A8, 0x0C88313C, 0xEDDE312A, 0x591082FB } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x18000000, 0x6C000000, 0x7E000000, 0x91000000, 0x87800000, 0xB7C00000, 0x56E00000, 0xF8D00000, 0x5F480000, 0x54E40000, 0x4A960000, 0xCC2D0000, 0x49B18000, 0xE05BC000, 0x754CA000, 0x82A39000, 0xD3F32800, 0x527A8C00, 0x8BFDE200, 0xF878E500, 0xD8FF2A80, 0xA8FB1FC0, 0x05BEC1E0, 0xA85B33F0, 0xE14D2BE8, 0xA0A10AFC, 0x34F06B6A, 0x30FBEC3D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x18000000, 0x74000000, 0x9E000000, 0xD3000000, 0x8B800000, 0xCCC00000, 0x3EA00000, 0xE5100000, 0x2D780000, 0xA35C0000, 0xC7AE0000, 0x59A50000, 0xEA308000, 0xF1AAC000, 0xEC05A000, 0x50A3F000, 0xFE10C800, 0xAAF96400, 0x959F5A00, 0xAC0C3100, 0x90353780, 0x1E0AA5C0, 0x73965720, 0x7B9822D0, 0x0DACE528, 0xA4A447DC, 0xDAB3E0AE, 0xCAE8471D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xF8000000, 0xF4000000, 0xE2000000, 0x05000000, 0xCD800000, 0x16C00000, 0x3D200000, 0xCB900000, 0xB9980000, 0x68EC0000, 0x011E0000, 0x02F70000, 0xB4328000, 0xB0484000, 0x8916A000, 0x5282F000, 0x6A42B800, 0x6461CC00, 0xD5706A00, 0x7AA89900, 0xF8244980, 0x0F4A09C0, 0xA59428A0, 0xC3C0DD90, 0x78A2DAA8, 0xB1533894, 0xA2BAE12E, 0xBC7E9457 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0xB8000000, 0x2C000000, 0xCE000000, 0x59000000, 0xBC800000, 0x6E400000, 0x05600000, 0x3C700000, 0x69B80000, 0x88340000, 0x77E60000, 0xEB0F0000, 0x04918000, 0x5B0BC000, 0x4CAC2000, 0x1BC01000, 0x2FA06800, 0xDB506C00, 0x8EA8EE00, 0x3CFCCF00, 0x06E9EE80, 0xB49F6540, 0xC418A6A0, 0x3464C5F0, 0x14CD80A8, 0x8133B6F4, 0x3358C822, 0x6D8460B5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xE8000000, 0x9C000000, 0xC2000000, 0xBD000000, 0x62800000, 0x9B400000, 0xDB600000, 0x14D00000, 0xD3F80000, 0x97BC0000, 0xC5CE0000, 0x14C70000, 0x0C318000, 0xBCE8C000, 0x19666000, 0x2F409000, 0x6563D800, 0x1BD10C00, 0x347B3600, 0x1A7EB300, 0xDBECFA80, 0xA4755BC0, 0x149B0520, 0x016C0850, 0x0B340B28, 0x31FBE754, 0xBABE7FA2, 0xEF4D9399 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xD8000000, 0x44000000, 0xC2000000, 0xC5000000, 0xAF800000, 0xC7C00000, 0x29E00000, 0x2FD00000, 0xA6880000, 0xC4140000, 0xD8660000, 0x921F0000, 0xB5318000, 0x69D8C000, 0xF3DEA000, 0x0BD33000, 0x54887800, 0xA9178C00, 0x3BE7E200, 0x0BDED500, 0xDFD19680, 0xEE88CFC0, 0xF81736E0, 0x8E64BB30, 0x4D1F8CE8, 0x9BB21234, 0xC3992062, 0xD8FFB4F9 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xE8000000, 0x44000000, 0x12000000, 0xD3000000, 0x3F800000, 0x9E400000, 0x94600000, 0xF7D00000, 0x81880000, 0xC5EC0000, 0x9D9E0000, 0x26E70000, 0xD4B18000, 0xABD94000, 0x4127E000, 0x07927000, 0x28EBF800, 0x70BC9400, 0x60D73A00, 0xBBA96B00, 0x0E5E4680, 0x0FC5FFC0, 0xC082A4E0, 0xB7C300D0, 0x6B2006E8, 0x3F31CFD4, 0x3F9B6262, 0x0A44BF1F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0xD8000000, 0x74000000, 0x82000000, 0x73000000, 0x8F800000, 0x51400000, 0x39A00000, 0x00500000, 0x1C180000, 0x1FAC0000, 0xD39E0000, 0x1CB70000, 0x15B08000, 0xDF6BC000, 0x4425A000, 0xB849F000, 0x19B5B800, 0x2B339400, 0x92A9BA00, 0xF3465700, 0x08F90D80, 0x485DCAC0, 0xAAD50BA0, 0x31827990, 0xAC4229A8, 0x83228A94, 0xA7920626, 0x2478B351 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xD8000000, 0x44000000, 0x3E000000, 0x0D000000, 0x73800000, 0x9CC00000, 0x91600000, 0x28900000, 0x34E80000, 0x9BDC0000, 0x1E6E0000, 0x41370000, 0x10B38000, 0x48D8C000, 0xA346A000, 0x1C093000, 0xF48F8800, 0x29675C00, 0xEF3B4200, 0x98956900, 0x2F432880, 0x6DA34CC0, 0xC9F0F060, 0x947B7890, 0x33371A68, 0xFFB3BD94, 0x6C5BD8EA, 0x2F043451 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x38000000, 0xC4000000, 0xE2000000, 0x7B000000, 0xD5800000, 0x96C00000, 0x2B600000, 0xAE100000, 0xDEC80000, 0x48940000, 0x5FA60000, 0x005D0000, 0x56318000, 0xE5784000, 0x3F2FA000, 0x89EA3000, 0xACA77800, 0xC9DFF400, 0x36F3F200, 0x9F1B8100, 0xC3BDF080, 0x3262E6C0, 0xC09072E0, 0xBD8BAF30, 0x0534D8E8, 0xE2D4AA3C, 0xB485826A, 0x226D49F3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0x84000000, 0xE2000000, 0x69000000, 0xCD800000, 0xEAC00000, 0x19A00000, 0xF7D00000, 0x88480000, 0x48A40000, 0xD2960000, 0x26EF0000, 0x51328000, 0x30F94000, 0x209C6000, 0x9AA9F000, 0x7A14B800, 0x27AFBC00, 0x4953DA00, 0x0A099900, 0x7046AB80, 0x2D247AC0, 0xEC550CE0, 0xC54CF2F0, 0x33E28EE8, 0x1B3167F4, 0x8DFBA76E, 0x171C8833 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x28000000, 0x54000000, 0x46000000, 0x9F000000, 0x89800000, 0xE8400000, 0x95200000, 0xC8500000, 0x95980000, 0x36EC0000, 0x175E0000, 0x0F770000, 0x7BB38000, 0xA529C000, 0x1C446000, 0x5C5BB000, 0x5F8DE800, 0x2C2CB400, 0xDDBE0200, 0x7944DB00, 0x38D94380, 0xD74EACC0, 0x7FCE6FA0, 0x9D0C2290, 0x4BEC65A8, 0x1FDD3D94, 0xBDB72C2A, 0xA5528E55 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x08000000, 0x54000000, 0x3A000000, 0xBF000000, 0x89800000, 0x3A400000, 0x9AE00000, 0x20300000, 0x87E80000, 0xEA340000, 0xCDDE0000, 0x37EB0000, 0xD2358000, 0xE1DFC000, 0x01EA6000, 0x0B34F000, 0xB95E7800, 0x37287400, 0x9D142A00, 0xB04CB700, 0x3052F680, 0x4A1AC140, 0x307C2860, 0xA7BA41F0, 0x882EDEE8, 0xF9A080B4, 0xA252F68A, 0xB11AC141 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xD8000000, 0xAC000000, 0xDE000000, 0x53000000, 0x4C800000, 0x90400000, 0xC0200000, 0x09500000, 0x07380000, 0x0D1C0000, 0x42260000, 0xCB3B0000, 0x831F8000, 0xD9264000, 0x43BAA000, 0xB95E5000, 0x38078800, 0x8B689400, 0x31A62E00, 0x29F8FB00, 0x907FD580, 0x34D60BC0, 0xA99342A0, 0x015BBD10, 0xF36C9728, 0x1ACDB6D4, 0xA85FD582, 0x61860BCF } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0xA8000000, 0x4C000000, 0x72000000, 0x45000000, 0x2B800000, 0x28C00000, 0x21E00000, 0xDCF00000, 0x21080000, 0x85140000, 0x001E0000, 0xDB090000, 0x9C158000, 0x519FC000, 0x2AC8E000, 0x4C761000, 0xACAF3800, 0x73A03C00, 0x7853AA00, 0x87D93500, 0xD98D1880, 0xE4B3DE40, 0x54A802E0, 0x4E44E8F0, 0xA7451A68, 0x4EC736BC, 0xFB051882, 0xC567DE41 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x88000000, 0xC4000000, 0x82000000, 0x2D000000, 0xE4800000, 0x3C400000, 0x30E00000, 0x7F100000, 0x4E580000, 0x796C0000, 0xC9360000, 0x43590000, 0xEDEE8000, 0xCD74C000, 0xEFB86000, 0x5CFFB000, 0xE82DD800, 0xDD56DC00, 0x600A9600, 0x4357BB00, 0x43086E80, 0xACD769C0, 0xE4CB1E20, 0xE1F50250, 0xB7FB70A8, 0x5E1E6B9C, 0xE23E6E8E, 0x3B8E69C1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x58000000, 0x4C000000, 0x9E000000, 0x85000000, 0xAA800000, 0xBE400000, 0x03600000, 0xF4100000, 0x81480000, 0xE06C0000, 0x58260000, 0x94CB0000, 0x1BAF8000, 0xC8854000, 0x447BA000, 0xE857D000, 0x98120800, 0x2F49CC00, 0x9D6E6E00, 0xCEA4DB00, 0xEC88F880, 0xD1CDD3C0, 0x0816BE60, 0xFE72C410, 0xA1D846E8, 0x8A6417D4, 0x39A97882, 0x92BF93C3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x98000000, 0x04000000, 0x16000000, 0x8B000000, 0x7C800000, 0x3D400000, 0xAE200000, 0x86700000, 0x59480000, 0x1A040000, 0xC44E0000, 0x88C90000, 0x58C68000, 0xD7ACC000, 0x5FD82000, 0x2CDCF000, 0xE1108800, 0x8F185400, 0x623C2E00, 0xA1800F00, 0x6AC15980, 0x5FE2EF40, 0x5D1163E0, 0xED1B0CB0, 0xD73E3A68, 0x1A00E3FC, 0xA101D98E, 0x55832F41 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x58000000, 0x1C000000, 0xFE000000, 0x2F000000, 0xC0800000, 0xFBC00000, 0x59200000, 0x8BB00000, 0xAB880000, 0x88CC0000, 0x82460000, 0xFD0B0000, 0x380C8000, 0x69E44000, 0xF479A000, 0x61259000, 0xB3DBC800, 0xAE54E400, 0x29F12E00, 0x12E9A500, 0xBB1D2F80, 0x3D9D4440, 0x455DF5E0, 0x1AFC4A90, 0xA98EDA68, 0x3DA60ED4, 0xF619AF8E, 0xB875044B } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x98000000, 0x54000000, 0x2A000000, 0xA7000000, 0xCA800000, 0xA3C00000, 0xCEA00000, 0x37900000, 0xE6380000, 0x41440000, 0x1A7E0000, 0x1EB90000, 0xD1858000, 0x945FC000, 0xFDE82000, 0xAB9EB000, 0x154A3800, 0xE50C1400, 0x64F20600, 0xF2081D00, 0x8D6F6180, 0x9C4242C0, 0xE4E32BA0, 0x52726470, 0x07CA4A28, 0x72CD26BC, 0xF052E182, 0x2A9982C1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x98000000, 0xFC000000, 0xC6000000, 0x27000000, 0x2C800000, 0x67C00000, 0x76E00000, 0xB2F00000, 0xCD480000, 0x3B540000, 0x6B1E0000, 0xDDCB0000, 0x7A978000, 0xAAFC4000, 0xEBB9A000, 0xB41E1000, 0xDD48A800, 0xD3542400, 0xAF1D3E00, 0xD7CA0500, 0x03962080, 0x5D7C8E40, 0x66FA6BE0, 0x823D10F0, 0x35DA4B68, 0xCB2E9EB4, 0x2FE1A082, 0x3570CE47 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xF8000000, 0x74000000, 0xEE000000, 0x23000000, 0x9B800000, 0xD1C00000, 0xDAA00000, 0x3AD00000, 0xE9F80000, 0x25440000, 0x6F3E0000, 0x8FBB0000, 0x24258000, 0x9A4DC000, 0x4013A000, 0xB4DBB000, 0x8C55A800, 0x35659400, 0x3EAFD200, 0xBFA0C100, 0x4E51D980, 0x19B943C0, 0x332715A0, 0xCFCC9770, 0x62D34C28, 0x0DF814B4, 0x1347F98A, 0xE83F33C9 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x88000000, 0x0C000000, 0xC2000000, 0x8F000000, 0xE8800000, 0x56400000, 0xB6200000, 0x89900000, 0xA6880000, 0x059C0000, 0xA3960000, 0x0C490000, 0xB3FC8000, 0x85254000, 0x32D3E000, 0x672A9000, 0x6ACC7800, 0x517DD400, 0x70668E00, 0x7E734300, 0x8FFAF580, 0x16E400C0, 0x45329760, 0x8E5B15D0, 0x99B4E2E8, 0x87DA551C, 0x7A759586, 0x583BD0CF } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x08000000, 0x3C000000, 0x06000000, 0x73000000, 0xA7800000, 0x8DC00000, 0xDAA00000, 0x71300000, 0x6D180000, 0xF90C0000, 0x0B960000, 0x8B590000, 0x806C8000, 0xBF074000, 0x8EF3E000, 0xDEB85000, 0x0ABDA800, 0x87CD3400, 0xB6B68200, 0x97AAC100, 0x87D6C980, 0x3F3A9C40, 0xD47DC9A0, 0xAAEE45D0, 0xF2478028, 0x1413999C, 0x35E9A986, 0x2CB58C47 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x18000000, 0x54000000, 0x0E000000, 0x8D000000, 0x4A800000, 0x8EC00000, 0xEAA00000, 0x1D900000, 0x42F80000, 0x95840000, 0x51FE0000, 0x50BB0000, 0x08E48000, 0x524CC000, 0xC4102000, 0x33B9B000, 0x5F67A800, 0xEE0F2C00, 0x24712E00, 0xD28AF900, 0xD90D5D80, 0x7DF1E2C0, 0xE3CA5CA0, 0x73EE2470, 0x12038128, 0x8F0306B4, 0xFD81FD8E, 0x974092C9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xB8000000, 0xF4000000, 0x5E000000, 0xB3000000, 0x94800000, 0x71400000, 0x16A00000, 0xD4D00000, 0x5D280000, 0xD1840000, 0x742E0000, 0x6EE90000, 0x89668000, 0xE8DD4000, 0xCB512000, 0x8CEBB000, 0x8865E800, 0xB55D9400, 0xCB90AE00, 0x808BBF00, 0x05D56B80, 0xB645B7C0, 0xA2CD80E0, 0x49198530, 0xF45E6B68, 0x361172FC, 0x504ACB8E, 0x01B747C7 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x08000000, 0xAC000000, 0x0A000000, 0xC9000000, 0xB9800000, 0xFAC00000, 0x2DE00000, 0xA9500000, 0xEFD80000, 0xE9F40000, 0x6BAE0000, 0xC6990000, 0xC7D78000, 0xAE9DC000, 0x0ED26000, 0x42191000, 0xEA955800, 0x36BE6C00, 0x20E25200, 0x86D01500, 0x2E1B9080, 0xC094B0C0, 0x2FBC8720, 0x9160DC30, 0xD01097A8, 0x09F9ACFC, 0xA0C6708A, 0x79E460C1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xE8000000, 0x44000000, 0x26000000, 0xF1000000, 0xF7800000, 0x4F400000, 0x8DE00000, 0x8B300000, 0xC9C80000, 0x4ABC0000, 0xA6F60000, 0x3C090000, 0xC59E8000, 0xF4644000, 0x67916000, 0x4A183000, 0x51C7C800, 0x2FC13C00, 0x6421AA00, 0x2E12EB00, 0x985B9680, 0x29A7A140, 0xCCB0F8E0, 0xCE8A9F50, 0x135DEE68, 0x13C57E1C, 0xA8C2768E, 0x1AA2D143 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xE8000000, 0x24000000, 0x72000000, 0x5F000000, 0x82800000, 0x84C00000, 0xD6A00000, 0xD3D00000, 0xF9B80000, 0x3B440000, 0xC77E0000, 0x96790000, 0x45668000, 0x636E4000, 0x1DE36000, 0xEC31B000, 0x72891800, 0x174ED400, 0x9AF24600, 0x3B2A4100, 0x261C7D80, 0x9788A3C0, 0x3ECC10A0, 0x16B15270, 0x8A48ED28, 0x1FEEB1BC, 0x30211D8E, 0x851013CB } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xF8000000, 0xAC000000, 0x92000000, 0x77000000, 0xF9800000, 0x93400000, 0xBF200000, 0xD0900000, 0x80080000, 0xF4640000, 0xD6EE0000, 0x9A4B0000, 0x37C58000, 0x6BBFC000, 0x67A1A000, 0x6B50D000, 0x6CE93800, 0xBC153400, 0x70956A00, 0xD5565300, 0x8CB4A580, 0xB24544C0, 0xD2FDC960, 0x2382F030, 0x8042ECE8, 0xF0A374F4, 0xA2D3058A, 0x77AA94C1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xE8000000, 0xAC000000, 0xFE000000, 0x5B000000, 0x79800000, 0xF4C00000, 0xA5A00000, 0xB1300000, 0x57180000, 0x93940000, 0xC20E0000, 0x5EDB0000, 0x60B68000, 0x347FC000, 0x29A2E000, 0x7F339000, 0x94188800, 0x3E177400, 0x8CCF9A00, 0xF2787D00, 0x0D055180, 0xB5271840, 0x92D74DA0, 0x5D6FC7B0, 0x894A9C28, 0x2B1C1FF4, 0xBE31B186, 0xD49B884D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x48000000, 0x0C000000, 0xE6000000, 0xC7000000, 0x6D800000, 0xE1400000, 0x5D600000, 0x43500000, 0x63E80000, 0x262C0000, 0x31460000, 0xE8AB0000, 0x1A4E8000, 0x3894C000, 0x57836000, 0xC8439000, 0x1BE16800, 0x7990E400, 0x50CBBA00, 0x599D9B00, 0x16BC7480, 0x370DD2C0, 0x23F631E0, 0x63D22790, 0xDE2AC568, 0x988C3554, 0xFFB71486, 0xDA3242C1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x18000000, 0xAC000000, 0x0E000000, 0x75000000, 0x94800000, 0x4E400000, 0x82600000, 0x62B00000, 0x9F580000, 0xCFA40000, 0x337E0000, 0x8D190000, 0x2BC58000, 0x20CCC000, 0x2CC12000, 0x65235000, 0xD2504800, 0x62A9CC00, 0xFC1D5600, 0x072BE300, 0x4CDDDC80, 0xA4088540, 0xFF8FDCA0, 0xE0229370, 0x2ED18028, 0x28EBD63C, 0xD47CFC82, 0xAA9BD54D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xE8000000, 0x84000000, 0x1E000000, 0x79000000, 0x41800000, 0x90C00000, 0x27A00000, 0x74F00000, 0x23080000, 0xB6140000, 0xFF9E0000, 0x6BCB0000, 0xBDB68000, 0xF16F4000, 0x9FC26000, 0xDB233000, 0x5BB32800, 0x5D68FC00, 0x4CC55200, 0xBCA72D00, 0xC7744180, 0xF9CD2F40, 0x07B05AE0, 0x6F6B69F0, 0x4FC49B68, 0x2A2606B4, 0x87362186, 0x8B2E1F4F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xC8000000, 0x64000000, 0x56000000, 0x59000000, 0xB1800000, 0xFCC00000, 0xAD200000, 0xB5500000, 0xC7980000, 0x19D40000, 0x9CCE0000, 0x8B5B0000, 0xACF78000, 0x259EC000, 0xEEC26000, 0x72213000, 0x35D00800, 0x7ED95C00, 0xD6351200, 0xB9BFFD00, 0x1E127B80, 0xD77843C0, 0xBC243E20, 0xB0C55EB0, 0x3F37C5A8, 0x103CDD74, 0xEED01B82, 0xD85973CD } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x28000000, 0xBC000000, 0x7A000000, 0xA5000000, 0x2A800000, 0xBD400000, 0xAEA00000, 0x49900000, 0x33C80000, 0x4C8C0000, 0x9A060000, 0x1C2B0000, 0x91BD8000, 0x655CC000, 0xD9EDE000, 0xD275D000, 0xF1D2D800, 0x67E81C00, 0xB05EAE00, 0x2B6DA700, 0x4B366380, 0x21713AC0, 0x657B0A60, 0xCA15EC90, 0x2F2089E8, 0x4D510654, 0x4DA95B8A, 0x9D7CF6CD } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x58000000, 0xC4000000, 0x1E000000, 0x8B000000, 0x82800000, 0x99400000, 0x74600000, 0x51300000, 0x56C80000, 0x2C4C0000, 0xFFC60000, 0x3DEB0000, 0x661C8000, 0x94BDC000, 0x9D2C2000, 0xDF74F000, 0x44E3A800, 0x7171F400, 0x59299600, 0xFFBC2700, 0xCFAD9080, 0x7E34DB40, 0x6480A4E0, 0x6640B890, 0x40E11468, 0x4F7093D4, 0x222A188E, 0xB53DDF4D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x18000000, 0xDC000000, 0xA6000000, 0xE3000000, 0x3E800000, 0x91400000, 0xC8E00000, 0x49300000, 0xD0C80000, 0xE1FC0000, 0xF4760000, 0xDF6B0000, 0x8B2D8000, 0xB70FC000, 0x551E2000, 0x0B449000, 0xD4A32800, 0xD851B400, 0x6C39A600, 0x7D967700, 0x51D96280, 0xC1259940, 0x9AD34CE0, 0x4B7A9450, 0x6E740E68, 0xAA6B9D14, 0x3EAC6A8A, 0x8CCCBD41 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x28000000, 0xDC000000, 0x06000000, 0xF7000000, 0xF6800000, 0x26C00000, 0x86200000, 0xE9F00000, 0xB2B80000, 0x3ECC0000, 0x9CB60000, 0x4B590000, 0x4C9D8000, 0xB1BFC000, 0x40CEE000, 0x5FB45000, 0xC7DBA800, 0x4B5DA400, 0x1E1C1600, 0xA57EC900, 0x4BED1780, 0x61C61140, 0x7A218820, 0xFFF1A450, 0xCDBA7FA8, 0xC44FE51C, 0x94765F82, 0xE67AE541 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x58000000, 0x5C000000, 0x1A000000, 0x4B000000, 0xC7800000, 0xD3C00000, 0x3E600000, 0x66B00000, 0xDA080000, 0x39CC0000, 0x56060000, 0xB0AB0000, 0xA49E8000, 0xCE7DC000, 0xA08E2000, 0x6D249000, 0x5739D800, 0x2206E400, 0xFEABE200, 0x119D6900, 0x14FF6280, 0xBDCD0940, 0x500607E0, 0x01ABBB90, 0x381F4568, 0x823E22D4, 0x112E9A86, 0x2FF47D45 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x58000000, 0xA4000000, 0x5E000000, 0x83000000, 0x9C800000, 0x9CC00000, 0x3C200000, 0x9A500000, 0x66880000, 0x0F4C0000, 0xCA060000, 0x7FE90000, 0xDE7F8000, 0x2CBCC000, 0x9B9E2000, 0x414E7000, 0xD1042800, 0x6769D400, 0x8CBE4E00, 0xCB9E4900, 0x394D4780, 0xE505EFC0, 0x6169D660, 0xABBE8290, 0x091CB1E8, 0x268C1D5C, 0x45A6CF8A, 0x67FB8BC5 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0xE8000000, 0x0C000000, 0x82000000, 0x65000000, 0x05800000, 0x07400000, 0xE1E00000, 0x09900000, 0x2E780000, 0xFBB40000, 0xB58E0000, 0x0F590000, 0x11858000, 0x0607C000, 0xEC45E000, 0x74241000, 0xC0F6F800, 0x8E6CFC00, 0xF7CAD200, 0x8C7F5300, 0xF9F05680, 0x56ABFBC0, 0x972E18A0, 0x792A37B0, 0x996DAE28, 0x6F48DC7C, 0xCABECE82, 0x4150D7C1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x68000000, 0x7C000000, 0xA6000000, 0xC3000000, 0xAF800000, 0x58C00000, 0x3A600000, 0xF1F00000, 0x60680000, 0x45640000, 0xA8CE0000, 0x034B0000, 0x19378000, 0x52B6C000, 0xC874E000, 0xB315D000, 0x0C64A800, 0xEA4FF400, 0x7B0A2200, 0x8A14D500, 0x16E68E80, 0x160D1440, 0x5A29DF60, 0xD74604B0, 0x021DB1E8, 0xCB71C0F4, 0x4C294682, 0xAC45F04D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x98000000, 0x54000000, 0xDE000000, 0xB3000000, 0x47800000, 0x5A400000, 0xCA600000, 0x60B00000, 0x6A880000, 0x6BE40000, 0x7E2E0000, 0xB7290000, 0x36758000, 0xEAF44000, 0xFB37A000, 0x4114B000, 0xB6C56800, 0xD07C9400, 0x98D3A200, 0xC3397F00, 0x13EE8480, 0xDF0BF140, 0x58A5DBE0, 0x96CF3F30, 0x855AFF68, 0x995D7E7C, 0x4881CC82, 0x6FC3954F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xF8000000, 0x04000000, 0xBA000000, 0xC7000000, 0xF5800000, 0x21C00000, 0xCB600000, 0x9FF00000, 0x2B680000, 0xE3840000, 0xB02E0000, 0xC04B0000, 0xA4D78000, 0xC4D6C000, 0xB4D6A000, 0x7CD67000, 0x10D53800, 0x56D5D400, 0x2FD4FA00, 0xA7558900, 0xB4166E80, 0xAB374040, 0xDE644760, 0xA19E9B30, 0xF68289E8, 0x8E40AB74, 0x1DA27682, 0xC912244D } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xC8000000, 0xD4000000, 0x06000000, 0x69000000, 0x13800000, 0x6F400000, 0x20600000, 0x41500000, 0x23480000, 0x8F040000, 0x300E0000, 0xF7E90000, 0xF5768000, 0x8475C000, 0x2BF46000, 0x66B4F000, 0x71D58800, 0x56045C00, 0xDB8F5A00, 0x74AB5B00, 0x5F143080, 0xB625C6C0, 0xA03EF760, 0xFA728FB0, 0x7478A7E8, 0xBC1EB97C, 0x03C3588E, 0x3DA0AAC5 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x98000000, 0xFC000000, 0x8E000000, 0x09000000, 0x24800000, 0x6CC00000, 0xAC200000, 0xFAF00000, 0x38E80000, 0x64D40000, 0xB3FE0000, 0x548B0000, 0x7AC78000, 0x0FC6C000, 0xE5472000, 0x20841000, 0x38260800, 0x3617BC00, 0x5EDEE600, 0x4EF94900, 0xCCED4F80, 0xD8308540, 0x7DCAE560, 0x8AA7ED70, 0xEFD68AE8, 0xF87C7834, 0x41CBE782, 0xE4A5E94D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x98000000, 0x34000000, 0x4A000000, 0xF7000000, 0xC3800000, 0x05C00000, 0xBA600000, 0x4E900000, 0xC7D80000, 0x03B40000, 0x422E0000, 0xDE390000, 0x58E48000, 0x4796C000, 0x771C2000, 0x0F103000, 0x591A3800, 0xE4545400, 0x647F2200, 0x0F018100, 0xE7805A80, 0x37C2E9C0, 0xA963C020, 0x5F105130, 0x011B3AA8, 0x305448FC, 0xFE7EE286, 0x60007DC1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x98000000, 0xDC000000, 0xDA000000, 0x17000000, 0x71800000, 0xBAC00000, 0x5B200000, 0x8AD00000, 0x16B80000, 0x22840000, 0x4F7E0000, 0x541B0000, 0x76948000, 0x54E74000, 0x994DA000, 0x0DD39000, 0xEF385800, 0x8C441400, 0xBA5E4A00, 0x57CA5500, 0x00AF4380, 0x7022F5C0, 0x5152A0A0, 0x437A0170, 0xE424C328, 0x3D6C24B4, 0xD2839B8E, 0x7541A1C7 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xC8000000, 0x54000000, 0x96000000, 0x25000000, 0x6D800000, 0x58C00000, 0x7DA00000, 0x76700000, 0xDBF80000, 0x51A40000, 0x8B1E0000, 0x39DB0000, 0x44178000, 0x91C64000, 0x0D4EE000, 0xDC93F000, 0xCBEA4800, 0xA10DAC00, 0xA6739200, 0x43F9FD00, 0xDDA58980, 0x311F9540, 0x16DAD720, 0xCE95DAF0, 0x17863EA8, 0x60AFFFB4, 0xE2004182, 0x4300794F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x58000000, 0xAC000000, 0x12000000, 0x43000000, 0x2B800000, 0xC7400000, 0x86A00000, 0x0F500000, 0x8D480000, 0xB9140000, 0xE49E0000, 0x36690000, 0xC4058000, 0xC1F7C000, 0x41EF2000, 0xCEB05000, 0xC4B83800, 0x9B0DE400, 0x00C33200, 0x33E32B00, 0xBAF07380, 0x21988DC0, 0x071DD760, 0x6529C8F0, 0x8CA704E8, 0x17A6D53C, 0x5025CB82, 0x2566A9C1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x78000000, 0x74000000, 0xFE000000, 0xED000000, 0x8A800000, 0x5D400000, 0xE8600000, 0xC0B00000, 0x12580000, 0x118C0000, 0x29160000, 0x8F390000, 0x7FBD8000, 0x700C4000, 0xA7D42000, 0xEE9BB000, 0xD72F6800, 0xB805EC00, 0x4DF06E00, 0xD2391700, 0x4D3D0880, 0xF94DE540, 0x81B690A0, 0xBB2959D0, 0x3BF43828, 0x0ACA4C9C, 0x61846082, 0x1731094F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x68000000, 0x1C000000, 0xCE000000, 0x35000000, 0x06800000, 0xF1400000, 0xBB200000, 0x30700000, 0x6B780000, 0x17740000, 0x16CE0000, 0xF15B0000, 0x43868000, 0xFFF64000, 0x828D6000, 0x34F95000, 0x06B60800, 0x95AC0C00, 0x4289DE00, 0xB4CFB700, 0x2258F580, 0x8C06BB40, 0x36363720, 0x95EF4BB0, 0xA52B22A8, 0x62FDE0F4, 0x6780FD86, 0x75C1B74B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x88000000, 0x34000000, 0xC2000000, 0xA9000000, 0x21800000, 0xEE400000, 0x17A00000, 0xAB300000, 0x2D980000, 0xA4BC0000, 0x3BE60000, 0xB5390000, 0x9D0E8000, 0x5CBC4000, 0x47E4E000, 0x233A7000, 0x060E9800, 0x5C3FCC00, 0xBC261200, 0x18DA4700, 0x139FDB80, 0xFB15B840, 0xDB43B1A0, 0x90223D10, 0x36700A28, 0xFEB8B55C, 0xBE4F438E, 0xB09F7443 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x88000000, 0x9C000000, 0x1E000000, 0x7F000000, 0xA3800000, 0xF7400000, 0xB7E00000, 0xCA300000, 0x57880000, 0xEF3C0000, 0xB7760000, 0xE16B0000, 0x098F8000, 0x8C3CC000, 0x4AF56000, 0xC929D000, 0x0DEDC800, 0x394F6400, 0x369C6200, 0xF224FB00, 0x92133680, 0x949B1D40, 0x7F2449E0, 0x28930650, 0x1B5B9F68, 0x86060B14, 0xD700FE82, 0x6F837945 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x28000000, 0x94000000, 0x6E000000, 0x9B000000, 0x17800000, 0x73C00000, 0xE7600000, 0xD8B00000, 0x56680000, 0x923C0000, 0xFD160000, 0xA30B0000, 0x4B8D8000, 0x99FD4000, 0x16746000, 0x89B97000, 0x8CE5A800, 0xC1423400, 0x80220200, 0xC7925900, 0x10781680, 0x2687D540, 0xF9719660, 0x9009A5D0, 0x880E60E8, 0xA43D4094, 0x9A15BE8A, 0x6E89E14B } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x08000000, 0x34000000, 0xBA000000, 0xEF000000, 0x91800000, 0x1CC00000, 0x2DA00000, 0x03D00000, 0x0C580000, 0xF7B40000, 0xCFAE0000, 0xA1F90000, 0x34668000, 0xA3F44000, 0xA64EE000, 0xF3C87000, 0x360F7800, 0x28293400, 0xBF3DCA00, 0x01C3AD00, 0xC7218180, 0xA4920BC0, 0x2A3AA720, 0x7447A430, 0x52E546A8, 0x22B49FFC, 0x712EF98E, 0x4CBB3FC3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x98000000, 0x6C000000, 0x7A000000, 0x5F000000, 0x34800000, 0x5C400000, 0xC2A00000, 0x3C100000, 0xD8280000, 0x38940000, 0x7A1E0000, 0xF29B0000, 0x9AAF8000, 0x87A0C000, 0xA7932000, 0x98E95000, 0x42741800, 0x0AACF400, 0x5FA31E00, 0x6B93CB00, 0xF2E9C780, 0x857508C0, 0x522F31E0, 0x79E3D070, 0xF632EE68, 0xFA7A2CB4, 0x011EC182, 0xA81A37C5 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x38000000, 0x8C000000, 0xE6000000, 0x35000000, 0x37800000, 0x56400000, 0x8F200000, 0x69700000, 0x6A480000, 0xBD2C0000, 0x80460000, 0x88190000, 0xDC168000, 0xC021C000, 0x75F1A000, 0xD28B5000, 0x25CFE800, 0x3D55AC00, 0xBF833A00, 0xD2409F00, 0x2D207180, 0x9E71E740, 0x3ACB85E0, 0x83ECC910, 0xBDA41C68, 0x3A88825C, 0x31CCA38E, 0xA754D445 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x38000000, 0x7C000000, 0x7E000000, 0x13000000, 0xBA800000, 0x13C00000, 0xAB200000, 0xBDD00000, 0x58980000, 0x455C0000, 0x78E60000, 0x9B6B0000, 0x35958000, 0x9263C000, 0x5D30A000, 0x42699000, 0xB6154800, 0x32235400, 0x1E525600, 0xA8DBDD00, 0x3E3FEF80, 0xEE5451C0, 0x6D412A20, 0xFAE2A390, 0x5BF38DA8, 0x1CC9A654, 0x8C86F18A, 0xF95BD8C1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x58000000, 0x44000000, 0x3A000000, 0x21000000, 0xA5800000, 0x6FC00000, 0xF7A00000, 0xD0500000, 0xCC380000, 0x66740000, 0xEFEE0000, 0x44C90000, 0xCC9C8000, 0x52E3C000, 0x1EB02000, 0x6C8BF000, 0xF1FFB800, 0x0A930C00, 0xDC180200, 0xCCE44100, 0x83F6A580, 0xA02E69C0, 0xC36A5EA0, 0xD4CF5FB0, 0x82DB4328, 0x06C63A7C, 0x98671F86, 0x31B424C5 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x58000000, 0xA4000000, 0x3A000000, 0x2B000000, 0xB6800000, 0x45C00000, 0xEFE00000, 0x3B100000, 0x05980000, 0x1F0C0000, 0x7B760000, 0xB6690000, 0xC1068000, 0xA922C000, 0x6E732000, 0x8D4A7000, 0x48773800, 0x04EB2400, 0x8EC7E600, 0x65C0A500, 0x1FE04480, 0x531169C0, 0xA99A3D20, 0xD90E5DD0, 0xCE7541A8, 0x11E8101C, 0x19469A8E, 0xB583E8C9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x38000000, 0x1C000000, 0x32000000, 0x21000000, 0x33800000, 0x5BC00000, 0x9E600000, 0x2FB00000, 0xB1D80000, 0x870C0000, 0xF6B60000, 0x65090000, 0x34E78000, 0x40A1C000, 0x6C50A000, 0xF6A81000, 0x6A37F800, 0x0E4AAC00, 0xFBC73A00, 0x5533E900, 0x3D9BD280, 0x4CAE6940, 0x846626A0, 0xD1E38AD0, 0x76720C28, 0xC6BB4F9C, 0x6F3D108A, 0x0AAE2C41 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x58000000, 0x3C000000, 0x06000000, 0xD5000000, 0xFF800000, 0x34C00000, 0x85A00000, 0xFCF00000, 0x68380000, 0xC6E40000, 0xD27E0000, 0xA9E90000, 0xBE6F8000, 0xA543C000, 0xB0632000, 0x94D11000, 0x4709A800, 0x63FE2C00, 0xCC2A5A00, 0x8E4C3500, 0xB6731180, 0x13785B40, 0x5F876020, 0x9F2F1DF0, 0x5F23D9A8, 0xFFB06ABC, 0x9D59638A, 0xD5B48249 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x28000000, 0x2C000000, 0x36000000, 0xC9000000, 0xB4800000, 0x86400000, 0x54E00000, 0xE7D00000, 0x09280000, 0x2ED40000, 0x7E1E0000, 0x399B0000, 0x47EC8000, 0x41C3C000, 0xA921E000, 0x10F19000, 0x9CD82800, 0x208F5C00, 0x39D34600, 0xCC291300, 0xDC55EE80, 0x095E5EC0, 0xDDFA02E0, 0x3C7DFC70, 0xE309C468, 0x1DA7FEB4, 0x5504008E, 0x5934D1C5 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xC8000000, 0x3C000000, 0x26000000, 0xB9000000, 0xB8800000, 0x90400000, 0xCB200000, 0x28F00000, 0x49D80000, 0x3C540000, 0xD1AE0000, 0x5C8B0000, 0x783C8000, 0x4983C000, 0x54C26000, 0x1D625000, 0x4AD02800, 0x11A95C00, 0xD9CCF600, 0x00DA3B00, 0x1CD68980, 0xD5EEED40, 0x9DA885A0, 0x07CD5AB0, 0x3DD82428, 0x6655EBF4, 0x2EAED78E, 0x4D0A4A45 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x08000000, 0xBC000000, 0x7A000000, 0x2D000000, 0xCD800000, 0x95400000, 0x77600000, 0x3EF00000, 0x75F80000, 0x5AC40000, 0x375E0000, 0xB7EB0000, 0x938F8000, 0x2F81C000, 0xEC406000, 0x8CE05000, 0xA4B25800, 0x56197C00, 0xFAF57200, 0xF7868B00, 0x443C3C80, 0xB71B9040, 0x5575B920, 0x5BC48170, 0x68DDDDA8, 0x43A96D34, 0x0B6C9682, 0x1D31A741 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xD8000000, 0xCC000000, 0xCA000000, 0xA7000000, 0xD6800000, 0x53400000, 0xD4E00000, 0xDD500000, 0x5C180000, 0x39BC0000, 0xA0460000, 0x672B0000, 0xD5B78000, 0x20004000, 0x7002A000, 0x7802D000, 0xFC00D800, 0x1202D400, 0x6B02F600, 0x1C813F00, 0xF4408280, 0x02637CC0, 0x8E134820, 0x88FAC510, 0xE4ED12A8, 0xFC5C6DD4, 0x5E952C82, 0x75F0D7C7 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x08000000, 0xD4000000, 0x22000000, 0x3F000000, 0x46800000, 0x35C00000, 0x98E00000, 0xC3900000, 0x13D80000, 0xF8BC0000, 0xC2860000, 0xEE290000, 0x2D358000, 0x4901C000, 0x9B826000, 0xEC41F000, 0xBBA29800, 0x66B05400, 0x9CAAB600, 0x0AF54500, 0x16E04880, 0x929377C0, 0x34591620, 0x12FC8E10, 0x3C25C6A8, 0x2D1AADDC, 0x34DDE682, 0xF3D7A6C9 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xB8000000, 0x7C000000, 0x32000000, 0x0B000000, 0x61800000, 0x3C400000, 0x7C600000, 0xF6500000, 0x11E80000, 0xD87C0000, 0x3C760000, 0x4A190000, 0x25E68000, 0xD0D3C000, 0x7629A000, 0x275E9000, 0x31C77800, 0x6CE30400, 0xB492DA00, 0xA6487F00, 0x3B0F8C80, 0x472EBEC0, 0x5F1F57E0, 0xC3A6B3D0, 0xC3B12368, 0xDFF8C91C, 0x9BF50E8E, 0x3B5895CD } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x88000000, 0x34000000, 0x8E000000, 0xCB000000, 0xE8800000, 0x77C00000, 0xE8200000, 0x5D500000, 0xFC180000, 0x6F240000, 0x279E0000, 0x2C290000, 0xB48E8000, 0x32524000, 0xA298E000, 0x0FE77000, 0xED3D2800, 0xCBBA3400, 0xB736DE00, 0x11660500, 0x2DFFB380, 0x111B07C0, 0xA8A6F220, 0xAEDC9870, 0xB4CAE9A8, 0xDB7FEBBC, 0x95DA258E, 0x740606CB } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x58000000, 0xE4000000, 0x12000000, 0x3B000000, 0x70800000, 0xACC00000, 0x35200000, 0x97700000, 0xBC780000, 0x679C0000, 0x50460000, 0x116B0000, 0x59F78000, 0xD3304000, 0x2198A000, 0x47CC7000, 0x284D1800, 0x060EC400, 0x34EF3E00, 0x8E3E7900, 0xB5F6AB80, 0xAD30FB40, 0x249BE720, 0x924FAF10, 0x610FD4A8, 0x226DD054, 0x63FDAD82, 0x77577647 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xE8000000, 0xE4000000, 0xCE000000, 0x7B000000, 0xC8800000, 0xC9C00000, 0x3AE00000, 0xAC700000, 0x9FC80000, 0xF9040000, 0x06AE0000, 0x03190000, 0xC91C8000, 0xD331C000, 0xCFE8E000, 0x5B17B000, 0x2ED6E800, 0xE6347400, 0x0347DE00, 0xFD0DFD00, 0xBC4B4080, 0xD0458840, 0xF18D21E0, 0x4B8AD4B0, 0x69A40968, 0x997EE8FC, 0x37801686, 0x1F43714D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x18000000, 0x04000000, 0x86000000, 0x7B000000, 0x4E800000, 0xA3C00000, 0x40E00000, 0x14300000, 0x39E80000, 0xEB040000, 0x2F8E0000, 0xE1F90000, 0xB6BF8000, 0x0592C000, 0x9CFB2000, 0x433CF000, 0xC8D04800, 0x6FD89400, 0x0FEC4600, 0xE10BED00, 0x3B350080, 0xB066F940, 0x61FD6060, 0xCFB24430, 0x43A9A8E8, 0xECA7E97C, 0x299C2E8A, 0x2340704D } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x58000000, 0x2C000000, 0xD2000000, 0x87000000, 0x7B800000, 0xAC400000, 0x8EA00000, 0x92B00000, 0xDE480000, 0x920C0000, 0xD2660000, 0x771B0000, 0x6ED68000, 0xE450C000, 0xCC592000, 0x63F65000, 0x46A0B800, 0x46B13400, 0x9048C200, 0xCF0D5700, 0x5AE5F780, 0x5EDA2E40, 0x19364AE0, 0x04C1D790, 0x57638568, 0x0D510DD4, 0x1ADAAD86, 0xAF371D41 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x78000000, 0x94000000, 0xAE000000, 0x03000000, 0x68800000, 0x8FC00000, 0xBE200000, 0xF1700000, 0x79A80000, 0x034C0000, 0x13460000, 0xB43B0000, 0xCE348000, 0xD7914000, 0xB07A2000, 0x67563000, 0x0F002800, 0xA2825400, 0x3AC27E00, 0xF1A3E500, 0xC0312B80, 0xDF4ACF40, 0x8A9EA460, 0x175D1F10, 0x187D27E8, 0xA08FC454, 0xB7675D8E, 0x384A4E4F } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xE8000000, 0xDC000000, 0xE6000000, 0x1F000000, 0x09800000, 0x30C00000, 0x7B200000, 0xCCB00000, 0x0B580000, 0x99240000, 0x49DE0000, 0x02090000, 0x26EF8000, 0xD8924000, 0xC6686000, 0x6EBC5000, 0x95DA2800, 0xAC674400, 0x1C3DAA00, 0xAE9ABD00, 0x3A857380, 0x5F2FC840, 0x9D3224A0, 0xCF988970, 0xF804FF28, 0x4C6F453C, 0xF7D2918A, 0x5A8A614F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x68000000, 0x7C000000, 0x72000000, 0xFB000000, 0x64800000, 0x44C00000, 0xDAE00000, 0x18500000, 0x2DB80000, 0xCD9C0000, 0x3F460000, 0x0DCB0000, 0xF7948000, 0xDAB1C000, 0xF1EAE000, 0xE625D000, 0x97D87800, 0xB70E8400, 0x5D1C0E00, 0xA5840900, 0x562AB480, 0x9C45A8C0, 0xCD486CA0, 0x25541710, 0x0D502028, 0x1039FBD4, 0x1EDC228E, 0x29E6F5CD } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x98000000, 0xCC000000, 0xFE000000, 0xFF000000, 0xC6800000, 0x3CC00000, 0x03A00000, 0xBBF00000, 0xF5280000, 0x493C0000, 0x04360000, 0xF5B90000, 0x9E458000, 0xF6D34000, 0xB61AA000, 0x45B7D000, 0x53F90800, 0x97256400, 0x15835600, 0x9440D100, 0x0863E180, 0xDAD10B40, 0xD8185060, 0x72B632D0, 0x317939E8, 0x01E41D9C, 0xDB231F82, 0xE8336E43 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x48000000, 0x94000000, 0x4E000000, 0xD9000000, 0xFE800000, 0x22400000, 0x8C600000, 0xD2100000, 0xC5980000, 0x532C0000, 0xCF560000, 0x21AB0000, 0x44C68000, 0x09F24000, 0xC34BE000, 0x4C94F000, 0x7C0AA800, 0x68767C00, 0x995B4E00, 0xBD0C8B00, 0x71257C80, 0xC62013C0, 0x9A724F20, 0x01891F50, 0x63B51BA8, 0xF0FA3094, 0xCFBF7A86, 0x808E14CB } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xC8000000, 0x0C000000, 0xBA000000, 0xCB000000, 0xAC800000, 0x91400000, 0x20A00000, 0xAFB00000, 0x96E80000, 0x6D040000, 0x5E0E0000, 0x02190000, 0xF84C8000, 0x8C38C000, 0x79BD6000, 0xB8F29000, 0x9F489800, 0x81356400, 0x1326EE00, 0x67FC3F00, 0x42D35B80, 0x30BBA640, 0x00FC6C60, 0x24518F30, 0x12FACFE8, 0x18DDDD7C, 0x64A0D586, 0xD9B10949 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x78000000, 0xA4000000, 0x66000000, 0xE3000000, 0xDF800000, 0xDF400000, 0x97200000, 0xF1900000, 0xA3680000, 0x42D40000, 0xEFDE0000, 0x98BB0000, 0x721E8000, 0x1859C000, 0xEA6CA000, 0x55C2F000, 0xACE24800, 0x32707400, 0x149A2200, 0xB80C7B00, 0xE2723D80, 0xCC9A7CC0, 0xEC0E3AE0, 0xEC70E470, 0xF39AEF68, 0xF18C1CB4, 0xB632BF86, 0x583BF7C5 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xF8000000, 0x4C000000, 0x2E000000, 0xC3000000, 0xB3800000, 0xD5400000, 0x4A600000, 0x15100000, 0x4E380000, 0xFFCC0000, 0x38D60000, 0x776B0000, 0xF9158000, 0x81CBC000, 0xF227A000, 0x9E005000, 0x0B01C800, 0x7780D400, 0x1F41B200, 0x1362C300, 0x07904080, 0xC5FB0BC0, 0x106D35A0, 0x01672050, 0xB3631D28, 0x1790AF94, 0x1DF8528A, 0x0C6E98C1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x28000000, 0x34000000, 0xB2000000, 0x9D000000, 0xAF800000, 0xC2400000, 0x12E00000, 0xDED00000, 0x83D80000, 0x73FC0000, 0xDA860000, 0x5C490000, 0x0E448000, 0x9968C000, 0x1936E000, 0xB301F000, 0x74805800, 0xA2C39C00, 0xB2215A00, 0x89F3DF00, 0xB9A9E680, 0x8E1746C0, 0x69720920, 0xD96A3510, 0x393557A8, 0x03031FDC, 0x0C805C86, 0xBEC069C9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x38000000, 0x04000000, 0x12000000, 0x59000000, 0x57800000, 0xE3400000, 0xBE600000, 0x8F700000, 0xF8680000, 0x694C0000, 0x56060000, 0x5B5B0000, 0x73C58000, 0x7DFBC000, 0xAF94A000, 0xAB827000, 0x95401800, 0x85614C00, 0xE9F16A00, 0x70AA7B00, 0x226C0080, 0x2C17D240, 0x22C03560, 0x56206310, 0x1F908DE8, 0x93D88D54, 0xF407CA8A, 0x0A58D941 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xD8000000, 0x44000000, 0x16000000, 0xEB000000, 0x09800000, 0x1A400000, 0x39200000, 0x1D100000, 0x77580000, 0xB11C0000, 0xF7260000, 0xFF090000, 0xD0E58000, 0xD26B4000, 0xFBD7A000, 0x57A2F000, 0x14D18800, 0x653A1400, 0x0DAD5A00, 0xEFAD7700, 0xAAAF3180, 0x5C2F6EC0, 0x71EE2C20, 0x258CFB90, 0x5A3F35A8, 0xD737715C, 0xCAD3CB82, 0x8239E9C3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x18000000, 0xA4000000, 0xAA000000, 0xDD000000, 0xE1800000, 0x99400000, 0x43E00000, 0x8D900000, 0xD5780000, 0x1AF40000, 0x4B2E0000, 0x30A90000, 0x9BEF8000, 0x6609C000, 0xB39C2000, 0x25E07000, 0x56907800, 0xDFF93C00, 0x61352200, 0x1F0D2B00, 0xFF1B8E80, 0x522597C0, 0x23B5B2A0, 0x18CF97B0, 0x853A6428, 0x3A974C7C, 0xCEFC8C8A, 0x81B1CCC1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x18000000, 0x74000000, 0x12000000, 0xC5000000, 0xE3800000, 0xA6400000, 0x2AE00000, 0x71300000, 0xA8980000, 0x06240000, 0xAF1E0000, 0xAD6B0000, 0x939E8000, 0x71A84000, 0x62BCA000, 0x5F383000, 0xBD755800, 0x7476BC00, 0xC1F78A00, 0x48B5BF00, 0x40D5B680, 0x7E278940, 0xEB1E1BA0, 0x47692770, 0x529C5528, 0x982B2234, 0x75FE1C86, 0x84594643 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xE8000000, 0xDC000000, 0x8E000000, 0x5F000000, 0xED800000, 0x99C00000, 0xFDA00000, 0x07B00000, 0x0CE80000, 0xFBFC0000, 0xD0760000, 0x921B0000, 0x3FF48000, 0x72D8C000, 0xCCD5E000, 0x5F2B5000, 0x135F0800, 0x6F476400, 0xDFB1FA00, 0xA8E8C900, 0x21FD5D80, 0x0D748640, 0x4698E660, 0xC8B654D0, 0x753953E8, 0xF005E694, 0x4453C78E, 0x7A38DF49 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x78000000, 0xF4000000, 0x12000000, 0x33000000, 0x34800000, 0x43C00000, 0x3FE00000, 0xAF100000, 0x15A80000, 0xB8FC0000, 0xE6760000, 0xE0FB0000, 0x70F78000, 0x383AC000, 0x5796A000, 0xA2EAB000, 0x24DCD800, 0x4685E400, 0xB2428E00, 0x51A3F500, 0x80B22C80, 0x701979C0, 0x356519E0, 0x1B5300D0, 0x550B4D68, 0xD7CE2D14, 0x6D2F8282, 0x4FBDFCCD } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0xE8000000, 0x24000000, 0xD2000000, 0x3B000000, 0xBC800000, 0x9EC00000, 0x59A00000, 0xFC100000, 0xD9980000, 0xA4B40000, 0x3B4E0000, 0xD9CB0000, 0xD74E8000, 0x5FCAC000, 0xE64DE000, 0xC44AB000, 0xDA0D9800, 0xCE298400, 0x2A3CCE00, 0xF2E1E100, 0x2CF12180, 0x566B0CC0, 0xB25DD120, 0xD9D08830, 0x7CBA88A8, 0x2667B0F4, 0x6B768F86, 0x696E9DC9 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x38000000, 0x34000000, 0x76000000, 0x11000000, 0xA7800000, 0x58C00000, 0x09A00000, 0xE5100000, 0xDAD80000, 0x94C40000, 0x5C7E0000, 0xBC8B0000, 0xF57D8000, 0x6F09C000, 0xFBBEA000, 0xA7AAB000, 0x812F4800, 0x11B3FC00, 0x6A484A00, 0xB9DE4500, 0xAB989180, 0x80A514C0, 0x914F8820, 0x228218F0, 0x1940F1A8, 0x58614034, 0xAF33FB8A, 0x290821C9 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xB8000000, 0xAC000000, 0x66000000, 0xD1000000, 0x4B800000, 0x5B400000, 0x7FA00000, 0xB2B00000, 0x7B080000, 0x2D4C0000, 0x41A60000, 0x89790000, 0x2AA78000, 0x3DFAC000, 0xCF65A000, 0x309AD000, 0xFA346800, 0xD602BC00, 0xB9039A00, 0x7F83BB00, 0x81412780, 0x70A16240, 0x8433BFE0, 0x0DC81190, 0xD8AD5068, 0xC7341FDC, 0x1B809D8A, 0x0342C94D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xF8000000, 0xA4000000, 0xDE000000, 0x6B000000, 0x55800000, 0x6C400000, 0x9A200000, 0x1F900000, 0x5CD80000, 0x6C3C0000, 0x63060000, 0x3ECB0000, 0x70A48000, 0x771B4000, 0x635E2000, 0x0A36F000, 0x9D422800, 0x0AA1B400, 0xD5532A00, 0x6B38BF00, 0xA3CF0580, 0x756CA8C0, 0x9A3D6820, 0x2404D110, 0x894AE5A8, 0x3DE47DD4, 0xF5B8AF8E, 0x8A0F57C7 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x88000000, 0x64000000, 0xFE000000, 0xC3000000, 0x80800000, 0x89C00000, 0xE9600000, 0x86100000, 0x73780000, 0xE39C0000, 0xDEC60000, 0x50E90000, 0x96A48000, 0x777AC000, 0x0D9E6000, 0x75C63000, 0x64682800, 0x69665400, 0x391A5E00, 0xF50DBD00, 0x4C7CBE80, 0xEE1797C0, 0xB871A6A0, 0xF3EAB810, 0x0627D028, 0x96BB8BDC, 0x50FC6086, 0x85D5EAC1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x68000000, 0xB4000000, 0x4E000000, 0xC3000000, 0x1B800000, 0xF7C00000, 0xF7A00000, 0x41300000, 0xB7980000, 0x09140000, 0xE36E0000, 0xEC2B0000, 0x43CF8000, 0x689BC000, 0x0897E000, 0xE9AFF000, 0x7B0BA800, 0x32BC1400, 0x25627200, 0x3A116900, 0x24EAFD80, 0xC5EE1C40, 0x9B6991A0, 0xF42D96B0, 0x6BC8A428, 0x589FAEF4, 0x34910F82, 0x47ABB549 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xC8000000, 0x7C000000, 0xB6000000, 0x99000000, 0xCF800000, 0x70400000, 0xA2A00000, 0x23300000, 0xF2580000, 0xA6BC0000, 0xD3860000, 0x13E90000, 0x31268000, 0x90D94000, 0x137EE000, 0x4E655000, 0x74F8E800, 0x978D1C00, 0x6ADDEA00, 0x51D4C700, 0xC6637F80, 0xCD525040, 0x330A58A0, 0x8BB69310, 0x0D31AF28, 0xAF59CF5C, 0x0B3E158E, 0x40C6D747 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xF8000000, 0xFC000000, 0x02000000, 0x9D000000, 0x72800000, 0xED400000, 0x79600000, 0x08900000, 0xCDE80000, 0x830C0000, 0x6E460000, 0x32FB0000, 0x3D248000, 0xE36AC000, 0x1C4FA000, 0x42279000, 0x1CE9B800, 0x1B8D1C00, 0x7A068E00, 0x971BD700, 0xBFF4B480, 0x446135C0, 0x0A117CE0, 0xE8AAF010, 0xAE6F5068, 0x60D789D4, 0x9C10BA8E, 0x53AB22C1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xC8000000, 0x1C000000, 0xB2000000, 0x85000000, 0x24800000, 0x7C400000, 0xAA200000, 0x26500000, 0x0E380000, 0x0FB40000, 0xCA6E0000, 0x73690000, 0x1A0C8000, 0xE41A4000, 0x09E7E000, 0xD456D000, 0x44DC7800, 0x04617C00, 0x3971B600, 0x24E8CB00, 0x91CDDD80, 0x15F93BC0, 0x0656FCA0, 0xF1DF60B0, 0x08E23928, 0xA932B77C, 0xF4CA6B86, 0x2E9CF0C3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x68000000, 0x14000000, 0xEE000000, 0x5D000000, 0x57800000, 0x7FC00000, 0xF0600000, 0x2FB00000, 0xECA80000, 0x75E40000, 0x806E0000, 0x28190000, 0x5FCE8000, 0x3FCBC000, 0xF8D6E000, 0x30867000, 0x2C5EA800, 0x3573EC00, 0x974ABA00, 0xAF977900, 0x57A4FA80, 0x04CD6940, 0xE148EF60, 0x5E94F6B0, 0xF224DDE8, 0xCC0EC3FC, 0x9DA8408E, 0x1067104D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xD8000000, 0xEC000000, 0x62000000, 0xCD000000, 0xF8800000, 0x79400000, 0x0EA00000, 0x9DB00000, 0x8C780000, 0xECC40000, 0xE0DE0000, 0x03CB0000, 0x35BC8000, 0x78984000, 0x0855A000, 0x2DD75000, 0xC416F800, 0xE7F75C00, 0x0AE62600, 0x6C2DAF00, 0xD5137B80, 0x3ACBB640, 0x633D8E20, 0x3ED9F670, 0x1B772DA8, 0x05A50C34, 0xB18D5D8E, 0x3722194B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x78000000, 0xBC000000, 0xDE000000, 0x1F000000, 0xB5800000, 0x02C00000, 0x3B600000, 0xB7300000, 0xD4E80000, 0x13AC0000, 0xB2660000, 0x19D90000, 0xEA448000, 0x4D4BC000, 0x2FFCA000, 0xD9BE9000, 0x8A9EC800, 0x518C6400, 0x9BF49A00, 0xA8E08500, 0xD6F14A80, 0x64094F40, 0x295FD060, 0x906F3290, 0x038672E8, 0x69AA49DC, 0xEF0DD086, 0x16B5CA45 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x08000000, 0x8C000000, 0xBE000000, 0xE1000000, 0x08800000, 0xF7C00000, 0x65200000, 0xA2900000, 0xC9B80000, 0xD7AC0000, 0xF3760000, 0x612B0000, 0x75178000, 0x0759C000, 0xE61C6000, 0x555E9000, 0x99BE8800, 0x4F0CDC00, 0x74A55600, 0x1971E500, 0x6A891F80, 0x054414C0, 0x31425FA0, 0x6BE3A2D0, 0xEB302828, 0xFEEB3A14, 0x2C344982, 0xE3C9F1C1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x78000000, 0x04000000, 0x02000000, 0xAB000000, 0xD8800000, 0xDDC00000, 0xE2A00000, 0xD6700000, 0x4D380000, 0x79EC0000, 0xBAA60000, 0x9A730000, 0x833B8000, 0x5CEFC000, 0xE726A000, 0x4A32F000, 0xC9DB9800, 0xC47D6400, 0x308F6E00, 0x4F76E500, 0xAEB96580, 0xE4ACB740, 0x71C78320, 0x84A37650, 0xCF7188A8, 0xB6B92414, 0x50AF6E02, 0xFBC6E501 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x08000000, 0x3C000000, 0x56000000, 0xB3000000, 0x07800000, 0xED400000, 0xEB200000, 0x40300000, 0xDA680000, 0x8BEC0000, 0xCDB60000, 0xFA310000, 0x676A8000, 0x9B6E4000, 0xB575E000, 0x2D51D000, 0x12FB2800, 0x0EF5D400, 0x56133200, 0x2AD87B00, 0xB9443180, 0x6938F840, 0x76179B60, 0x62C19D10, 0xFA6098E8, 0x9D111E5C, 0xD95B320E, 0x5E047B03 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x08000000, 0x0C000000, 0x62000000, 0xB7000000, 0xBA800000, 0x2BC00000, 0xD8A00000, 0x39100000, 0x1D080000, 0x10A40000, 0xB0BE0000, 0x13110000, 0x86088000, 0xF824C000, 0xF47D6000, 0x75311000, 0xFAD93800, 0xE88F9400, 0xD0495600, 0x49C55500, 0x0A0FF580, 0x3F8A92C0, 0x1F640660, 0x361C83B0, 0x2702A5E8, 0x9283447C, 0x17C15606, 0x62A15501 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x78000000, 0xCC000000, 0xD6000000, 0x73000000, 0xA1800000, 0x59400000, 0x14E00000, 0x81500000, 0xEBA80000, 0x96040000, 0x18FE0000, 0xB7510000, 0x88A98000, 0x9F874000, 0x85BE2000, 0xC1B3D000, 0x60F9E800, 0x70ADD400, 0x98796A00, 0x356E3300, 0x1B59DE80, 0x861E02C0, 0xFB0381E0, 0xD583E5B0, 0xE3433568, 0xC1E3D47C, 0x2BD16A02, 0xDF6A330B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x28000000, 0x54000000, 0x3E000000, 0x6B000000, 0x0A800000, 0x4AC00000, 0xF2200000, 0x02B00000, 0x72C80000, 0x7F6C0000, 0xD5160000, 0xB5B30000, 0x62488000, 0x78ACC000, 0x6AB7E000, 0xB542F000, 0xA9612800, 0xA8D19400, 0xE4986600, 0xBF34F100, 0xDB014B80, 0x32839640, 0x56C1C7E0, 0xC8207790, 0x7FB0EA68, 0x474B10D4, 0x012E660E, 0x06F7F101 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x48000000, 0xDC000000, 0x46000000, 0x71000000, 0x0E800000, 0x18C00000, 0x14200000, 0x64700000, 0xFE680000, 0x4D5C0000, 0x10460000, 0xF4F10000, 0x73A98000, 0x25FC4000, 0x37F5E000, 0x6F3B5000, 0xE1C7E800, 0x8FB29C00, 0x97C91E00, 0x8C6C8900, 0xFF4E9B80, 0x7CBD3D40, 0x10976660, 0x332ACDD0, 0xF03EE3E8, 0x7B56799C, 0x9A889E02, 0x910CC907 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xC8000000, 0x1C000000, 0xE2000000, 0xB3000000, 0x6A800000, 0x04C00000, 0xD6A00000, 0x40300000, 0x3F280000, 0xAFFC0000, 0x11E60000, 0xA0B10000, 0x44E88000, 0x29DC4000, 0xC216E000, 0x15BA5000, 0xE2E77800, 0xEA330400, 0x50288600, 0xC77D6900, 0x56257180, 0xD4913E40, 0x1C1A6A60, 0x22543250, 0x9ED99DE8, 0x51F5651C, 0xE9680606, 0x699D2903 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0xF8000000, 0x84000000, 0xAA000000, 0x6F000000, 0x21800000, 0x17C00000, 0xFBA00000, 0x8A900000, 0x1B380000, 0x53440000, 0x6FEE0000, 0x55130000, 0xD1FB8000, 0xD266C000, 0x913DA000, 0xB14AF000, 0xFC0F3800, 0xFEE3D400, 0x39739A00, 0xE0CBA900, 0xE3CF4980, 0xC94330C0, 0x75E06CA0, 0x42F1D0F0, 0xD00ABF28, 0x55EE4934, 0x82101A02, 0xD4796905 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x38000000, 0xFC000000, 0x86000000, 0x91000000, 0xF7800000, 0x68C00000, 0xF3200000, 0xD6D00000, 0xC3780000, 0x025C0000, 0x6CF60000, 0x65530000, 0x91B98000, 0xC67D4000, 0xACA72000, 0x01681000, 0xF4046800, 0x097B1C00, 0x4D5DBA00, 0xA677ED00, 0x34114780, 0x5F59ABC0, 0x6E0F7CA0, 0xC6CC4190, 0x55ED8128, 0xD33D0754, 0x58443A0A, 0x9E1AAD03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x88000000, 0x94000000, 0xC2000000, 0xBB000000, 0x6B800000, 0x63C00000, 0xC8600000, 0x89300000, 0xB9180000, 0x0C040000, 0x3FAE0000, 0x6D710000, 0x0CB98000, 0x00574000, 0x6D05E000, 0xE32D7000, 0x6B32D800, 0xB219A400, 0x4F862200, 0xB86F9100, 0xEF10D680, 0xAA8B3140, 0x10CFCAA0, 0xB9C1F970, 0x7F60BE28, 0xECB2193C, 0xCFDA4202, 0xCAE5A10B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xC8000000, 0x04000000, 0xEE000000, 0xC1000000, 0xC0800000, 0xD7400000, 0xFAA00000, 0xAD100000, 0x15180000, 0x0BFC0000, 0xD7760000, 0x40D30000, 0x9FF88000, 0x39CFC000, 0x06BF6000, 0x7AD43000, 0xD0412800, 0x2F227C00, 0xFCD0E600, 0x6DF92F00, 0xBACC3F80, 0x7D3FF2C0, 0x8A165E20, 0xF821A090, 0x815207A8, 0xA838BD54, 0xE42F060E, 0x090EDF0D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x98000000, 0x1C000000, 0x0A000000, 0xE3000000, 0x56800000, 0x5FC00000, 0x24200000, 0x1CD00000, 0x12180000, 0x39A40000, 0x3BEE0000, 0x04910000, 0xD07B8000, 0x4A174000, 0xD9C7A000, 0xCF5F1000, 0x7639D800, 0xC577E400, 0xF9F5F600, 0x5534F500, 0x6F965780, 0x588577C0, 0xE0BEE520, 0x30CB57F0, 0xA6BEC4A8, 0x71C9953C, 0xB73FD60A, 0x9E89A503 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x08000000, 0x94000000, 0xBA000000, 0xEF000000, 0xE8800000, 0xDEC00000, 0xB8E00000, 0x39900000, 0x8AB80000, 0xEE840000, 0x372E0000, 0x3ED10000, 0xB91B8000, 0xB2B64000, 0x08A4E000, 0x765F7000, 0xADF93800, 0x6D241400, 0x631C7E00, 0x95596900, 0x4B968080, 0x495541C0, 0x3FB7DAA0, 0xC32505F0, 0xF61EA428, 0xB2DB6D3C, 0xCDD51E0A, 0x27755907 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xD8000000, 0xF4000000, 0xC6000000, 0x45000000, 0x8B800000, 0xA3C00000, 0xE7A00000, 0x63900000, 0xC5780000, 0x8CAC0000, 0xA3C60000, 0xA2D30000, 0x78998000, 0x085FC000, 0xFC0E2000, 0x78D7B000, 0x22EB4800, 0xC7D4CC00, 0x66699A00, 0x68965100, 0x22883980, 0xADE58CC0, 0x798359A0, 0x40C10250, 0xD9237A28, 0x43D11F94, 0xAD183A0A, 0x3A9D2109 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x28000000, 0x1C000000, 0x26000000, 0x07000000, 0xC1800000, 0x4BC00000, 0x28200000, 0x3A300000, 0xB5880000, 0xFA740000, 0x264E0000, 0x5F730000, 0x6BE98000, 0x15A64000, 0x1ED46000, 0xDF3FD000, 0x739B6800, 0x9FCFC400, 0xF0B3FA00, 0xC1C93900, 0x8A954780, 0x7FDC7C40, 0x920A1CE0, 0xD6B6FAF0, 0x5FED2168, 0xB681FFB4, 0xC2401A0A, 0xEFE3A90F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xA8000000, 0xDC000000, 0x56000000, 0x6B000000, 0x6C800000, 0xABC00000, 0x02600000, 0xC9900000, 0x6AD80000, 0x9C1C0000, 0x41D60000, 0x35D30000, 0xB7F98000, 0xA82F4000, 0x9AFF6000, 0x9F86D000, 0xDB69A800, 0xD176B400, 0x9BA3FE00, 0x12F00D00, 0x56CAAE80, 0x88876BC0, 0x51EB6B20, 0x99B71A10, 0xD943BBA8, 0x8EA33CD4, 0x89731E0A, 0xE78A9D0B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x38000000, 0xDC000000, 0x9E000000, 0x29000000, 0x9E800000, 0x59400000, 0x6B600000, 0x4B500000, 0x05F80000, 0x92CC0000, 0xEBE60000, 0xFB130000, 0x501A8000, 0x30DEC000, 0xED7FA000, 0xC68C9000, 0xFC058800, 0xEE031C00, 0xE101FE00, 0xCA824F00, 0x73406080, 0x3861CCC0, 0xBED2ECA0, 0x753B9FD0, 0x176FF228, 0x0C15DC14, 0x87985E06, 0xE71DDF01 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x18000000, 0xAC000000, 0x0E000000, 0x85000000, 0x39800000, 0xF8C00000, 0x96A00000, 0x41F00000, 0x81C80000, 0xA3C40000, 0x7F7E0000, 0x0C330000, 0x76E88000, 0xD6F74000, 0xD614A000, 0x7305D000, 0x1DDC0800, 0x8FC26C00, 0xCC20D200, 0xD1B29500, 0xC4299180, 0x1F57A140, 0x39657AE0, 0xA08EA130, 0xC0FAB968, 0xE8AFD574, 0xEB4A720E, 0x6B84450F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xF8000000, 0xE4000000, 0x6A000000, 0x09000000, 0xE5800000, 0x37C00000, 0xF6200000, 0xDB900000, 0xDBC80000, 0x84E40000, 0xF43E0000, 0xB7530000, 0x856A8000, 0xB7354000, 0xAF172000, 0xE7877000, 0xC8CEB800, 0xCA6BCC00, 0x6DB41200, 0x1A547900, 0x10E71F80, 0xC63DCAC0, 0x0A53CB60, 0x42E819B0, 0x95F446E8, 0x32B7EA74, 0x68D53206, 0x09A4090F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x88000000, 0x2C000000, 0xE6000000, 0xFF000000, 0x8C800000, 0x18400000, 0xD2A00000, 0x7F700000, 0x58E80000, 0xB5D40000, 0xF7CE0000, 0xB9330000, 0xF1488000, 0x9C244000, 0x5665E000, 0x09C59000, 0x2735A800, 0xAE1F2400, 0xCCA8AE00, 0xD1758300, 0xEFBC6380, 0xB95A8340, 0x1EDCD860, 0x8C4B73F0, 0x05A695E8, 0xCBA733B4, 0x48A54E0E, 0xBA241303 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xB8000000, 0xA4000000, 0x8A000000, 0xC7000000, 0x1A800000, 0x1A400000, 0x52200000, 0x5AD00000, 0x8A680000, 0x11340000, 0x8E0E0000, 0x46910000, 0x49488000, 0x5867C000, 0x59A4A000, 0x7A457000, 0x6B763800, 0x0C2FF400, 0x44435600, 0x7720B300, 0x7B50B980, 0xB4A927C0, 0xAC566CE0, 0xFF7FCA70, 0x1CEB0368, 0x5D749EBC, 0xD52FF606, 0x5BC1C30D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x58000000, 0x84000000, 0xB6000000, 0x83000000, 0x5F800000, 0x12400000, 0x66E00000, 0x07500000, 0x20E80000, 0x01FC0000, 0xE4C60000, 0x47110000, 0xC30B8000, 0xF22DC000, 0x05EE2000, 0x584E7000, 0xF77D4800, 0xF8041400, 0x2932D200, 0x64788700, 0x22B5BA80, 0x650962C0, 0xC92D44E0, 0xAE6DF750, 0xF40FAC68, 0xCE9CD29C, 0x92D4F20A, 0x2E9AF709 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x38000000, 0x0C000000, 0x2A000000, 0x41000000, 0x5D800000, 0x19C00000, 0xAE200000, 0x70500000, 0xD0880000, 0x16040000, 0xEF1E0000, 0xA7B10000, 0x7EF88000, 0x6EDD4000, 0x95902000, 0x4CABD000, 0x7B571800, 0xC0156C00, 0xDD759200, 0x4447A100, 0xCBFE3780, 0x8942DDC0, 0x00616560, 0x66B24530, 0xE37AE0E8, 0x971CE9FC, 0x8BB2AA06, 0x04F91D07 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xF8000000, 0x64000000, 0x32000000, 0xA1000000, 0x95800000, 0x44C00000, 0x34200000, 0x8DB00000, 0xD6680000, 0x139C0000, 0xA4860000, 0xE9510000, 0x75F88000, 0x9547C000, 0xB2F1A000, 0x71897000, 0x5C8ED800, 0x671C0C00, 0x55C63200, 0x69B05500, 0x2469CB80, 0x529C4240, 0x21070960, 0x5591BCD0, 0x25D950E8, 0x2AF4DB9C, 0xC5994A06, 0xF795290D } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x28000000, 0x2C000000, 0x7A000000, 0x9B000000, 0x39800000, 0xFA400000, 0x5D600000, 0x37900000, 0x65180000, 0x59340000, 0x4DFE0000, 0x1EB10000, 0xFAE98000, 0x773DC000, 0xAF11E000, 0x5DDB1000, 0xB797D800, 0x254EC400, 0x155B2A00, 0xA7563F00, 0xE7ECB480, 0x07E927C0, 0x37BC3C20, 0x83D181B0, 0x6D7A42A8, 0xC225897C, 0xDE251202, 0x3C27EB01 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x38000000, 0x04000000, 0xC2000000, 0xB1000000, 0xFD800000, 0x44400000, 0xDEA00000, 0xD7F00000, 0xA0180000, 0xF3DC0000, 0x9C760000, 0x67110000, 0x74488000, 0x17B64000, 0xB4F32000, 0x649BF000, 0x961C9800, 0xB0960C00, 0x2540D200, 0x4B227700, 0x3FB32380, 0xF0BBC140, 0x6B2ED9A0, 0xB6ED4610, 0x5E0E0828, 0x3E5F005C, 0xC0376A06, 0x2DB38B0B } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x08000000, 0x1C000000, 0x76000000, 0x31000000, 0x49800000, 0x55C00000, 0x0C200000, 0xDBD00000, 0xAF580000, 0x88040000, 0xCD4E0000, 0x74330000, 0x09AA8000, 0x550EC000, 0xEFD36000, 0x35595000, 0x77062800, 0xF1CE5C00, 0x0A72C200, 0x0B4A8100, 0x8C7E7F80, 0xB618FBC0, 0x0265A420, 0xB07DE270, 0x301A79A8, 0x8B66C8B4, 0xBDFF8A06, 0x07D98D01 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xA8000000, 0x74000000, 0x1A000000, 0x15000000, 0xFB800000, 0x80C00000, 0x98200000, 0xF4100000, 0xAC480000, 0xF7A40000, 0x253E0000, 0xBBF30000, 0x62FB8000, 0xB2BDC000, 0xCD33E000, 0x59DA7000, 0xBE2F3800, 0xC9397C00, 0x361C1A00, 0x8360BD00, 0xDCF24B80, 0x1879C4C0, 0xA3FC1F60, 0xB8D3A4B0, 0x1269AEE8, 0x08B4AD74, 0x05F6C202, 0xFE14B109 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x48000000, 0x9C000000, 0x82000000, 0x6F000000, 0xC0800000, 0xBD400000, 0x48E00000, 0x8B100000, 0x3FB80000, 0x2C040000, 0x4FEE0000, 0xB7B10000, 0x75CB8000, 0x6C6EC000, 0xC0716000, 0x53685000, 0x7D1CF800, 0xEE9BF400, 0x54B49E00, 0xAAA50700, 0x0E9E9E80, 0xF15A13C0, 0x7E1660A0, 0x71D553F0, 0xD3750028, 0xB406173C, 0x7BEF060A, 0x19B3A305 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xB8000000, 0x44000000, 0x7E000000, 0xA9000000, 0xFB800000, 0xED400000, 0x6A200000, 0x1CD00000, 0xD4780000, 0x0A740000, 0x069E0000, 0x89310000, 0x144A8000, 0xD5BE4000, 0xE6632000, 0xB170F000, 0x7FE96800, 0x932C9C00, 0xFAB9AA00, 0x09164B00, 0x6E6C6580, 0x1899BFC0, 0x89C4ACA0, 0x70159D30, 0x7DEC4328, 0x99DB99FC, 0x91E7620E, 0x47C56703 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x08000000, 0xA4000000, 0x7E000000, 0x9F000000, 0x7D800000, 0x72400000, 0x41200000, 0x67500000, 0x13780000, 0x335C0000, 0x3A360000, 0x5EB30000, 0xCEC98000, 0x12144000, 0x3F62E000, 0x8C73B000, 0xBD2BE800, 0x56A74400, 0x70A9AA00, 0x6CE7AF00, 0xB58BB580, 0x45B725C0, 0x31F286A0, 0xAF6A1990, 0x07847928, 0x2FFA2354, 0xD39F220A, 0x5CD41B07 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x48000000, 0x04000000, 0x52000000, 0x25000000, 0xDC800000, 0xE6400000, 0xB0E00000, 0xB8B00000, 0xB6880000, 0x16AC0000, 0xB7D60000, 0xBD930000, 0xAD1A8000, 0x24B74000, 0xBEE3E000, 0x13B03000, 0x810AD800, 0x276D1C00, 0x06F4C600, 0xFC03FB00, 0x5E029280, 0x9303F540, 0x9B82AAE0, 0x57C02990, 0x8E211E68, 0xBC1317D4, 0x9BD97E06, 0xC4169707 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xB8000000, 0x74000000, 0xB2000000, 0xB9000000, 0xCE800000, 0x59400000, 0x8D600000, 0x94100000, 0x77D80000, 0x61640000, 0xDEEE0000, 0x15B30000, 0x086B8000, 0xF40C4000, 0xFE622000, 0x77923000, 0x42199800, 0x0446EC00, 0xC51D3E00, 0x69388F00, 0x98B61880, 0xA814C1C0, 0xD5279520, 0xDF0F8FF0, 0x79E093A8, 0xF852F134, 0x523B0602, 0x1737130F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xD8000000, 0x8C000000, 0x22000000, 0x49000000, 0x9D800000, 0xE3C00000, 0xDC200000, 0x31D00000, 0xA7280000, 0x324C0000, 0xEC760000, 0x91B30000, 0x501B8000, 0x9D154000, 0xD702A000, 0xCE805000, 0xEB403800, 0xA8626C00, 0x13303200, 0x795BC900, 0x2C747780, 0x71B093C0, 0x00192DE0, 0xB5175A90, 0x8301C868, 0x60835054, 0x80412A02, 0x7CE0B50B } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xA8000000, 0x24000000, 0xEE000000, 0xE9000000, 0x7C800000, 0xE1400000, 0x17A00000, 0xE2900000, 0x54180000, 0xFD240000, 0x09EE0000, 0x0CF10000, 0x8E688000, 0xE50D4000, 0x26C26000, 0xC1613000, 0xABF0A800, 0x8BEADC00, 0x80CCF600, 0xEC20E700, 0x56536380, 0x3E7BF0C0, 0x5955E820, 0x00C581F0, 0x635E1DA8, 0xC0BAA63C, 0xF436BE06, 0xD1364B07 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xE8000000, 0xF4000000, 0xD2000000, 0x91000000, 0x5D800000, 0x13C00000, 0x4C200000, 0x14100000, 0x86080000, 0x3D740000, 0x03AE0000, 0x0E710000, 0xA1FA8000, 0x9D4EC000, 0x23C2E000, 0xB4237000, 0x68111800, 0x700A4C00, 0x96749200, 0x3B2CE900, 0x92333780, 0x6F19A4C0, 0x98FDFE60, 0xA21842F0, 0x437EBBE8, 0x42DB7F3C, 0xFBDDEA0E, 0x048B1501 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x98000000, 0xFC000000, 0x1A000000, 0xB9000000, 0x39800000, 0x36C00000, 0x7FA00000, 0x4B500000, 0x85880000, 0xB4040000, 0xC99E0000, 0x4B710000, 0x6B1B8000, 0x76AF4000, 0x358BA000, 0xCC069000, 0xE59D1800, 0x39704C00, 0xB61BE200, 0xA92C8D00, 0xA04AED80, 0x3324A7C0, 0xA18EC560, 0xF5985130, 0x36EFEAE8, 0xAE69ABFC, 0xDAB57A0A, 0x25A78103 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xB8000000, 0x7C000000, 0xBA000000, 0x99000000, 0x2B800000, 0xECC00000, 0x81E00000, 0x1D500000, 0x7E780000, 0x8A940000, 0x04FE0000, 0xAC330000, 0x01688000, 0x684D4000, 0x57182000, 0xD9861000, 0xD4249800, 0xA2D74C00, 0x995EAA00, 0x72C0AD00, 0xAEE1FC80, 0xCDD246C0, 0x6C381AA0, 0xCE37FCB0, 0x918FEC28, 0xDF7A4774, 0x9D14B20E, 0x323DA107 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x48000000, 0x04000000, 0xAA000000, 0x03000000, 0x07800000, 0xF8C00000, 0x38E00000, 0xAD100000, 0xD3E80000, 0xFD2C0000, 0x1E960000, 0xB7730000, 0x4CB98000, 0x7064C000, 0xD20B6000, 0x5CBC3000, 0x163C3800, 0x307DE400, 0x8CDEB200, 0xBA6C2D00, 0xE2B74880, 0xF480ABC0, 0xC743BDE0, 0xBC200C10, 0x63F0A768, 0x9BF87AD4, 0x84450A0A, 0xB5FA0905 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0x1C000000, 0x6E000000, 0xD7000000, 0x5C800000, 0x5BC00000, 0x5FA00000, 0x1B900000, 0x8C880000, 0x17C40000, 0x519E0000, 0x1DB30000, 0x39588000, 0x2CAD4000, 0x412B6000, 0xC554D000, 0x5E964800, 0x21352400, 0x6AA50E00, 0xBE2E2D00, 0xDDEA4980, 0xFE77DCC0, 0x5AC40660, 0xE81FF630, 0xC3F0A1E8, 0x86BB97F4, 0x07DDC60E, 0xCE514907 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x08000000, 0x7C000000, 0x1A000000, 0x5F000000, 0xD0800000, 0xB7C00000, 0x79E00000, 0xD4F00000, 0x98380000, 0xFC140000, 0x699E0000, 0xB2930000, 0x43898000, 0xA60DC000, 0x7A9B6000, 0xBCC4D000, 0x23B71800, 0x82CF5400, 0xF1F99E00, 0x84F4AD00, 0x2CECB080, 0x2CE85840, 0x903E4920, 0x3CC06BB0, 0xDF6187A8, 0x0E318EF4, 0x4259060A, 0x5DA53901 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x28000000, 0xAC000000, 0xDE000000, 0x6B000000, 0xD1800000, 0x80C00000, 0x86600000, 0xE0D00000, 0x25180000, 0x40BC0000, 0x2F360000, 0xA5B30000, 0xF8488000, 0x5B654000, 0xB2EA6000, 0x93D71000, 0x54224800, 0xBBF31400, 0x4D6BCA00, 0x70173500, 0xFFC1C280, 0x1DE386C0, 0x0112A920, 0x73FAF990, 0xC02C41A8, 0xC40F1A54, 0x67FF820E, 0xAE972107 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xF8000000, 0xCC000000, 0xA6000000, 0xA3000000, 0xF4800000, 0xDDC00000, 0x6BE00000, 0x25700000, 0x00480000, 0xD8940000, 0x3BEE0000, 0x47930000, 0xF4B88000, 0xE29EC000, 0x89DAA000, 0xDB2DD000, 0x97F22800, 0xEE8A5400, 0xDFF73E00, 0xDF5ED500, 0x7238A080, 0x665C0640, 0x8BB91EE0, 0x681F3870, 0x8B1AA068, 0xCA4DFB34, 0xF843160E, 0x1BA38109 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x98000000, 0x6C000000, 0xB6000000, 0x73000000, 0x33800000, 0xF2400000, 0x4A200000, 0xE5300000, 0x3A580000, 0xF1240000, 0x808E0000, 0x4E110000, 0x2DEA8000, 0x5BBD4000, 0x6348A000, 0xFD4CD000, 0x2870E800, 0x65F8D400, 0x5D56E200, 0x07747700, 0xEA475980, 0x741E4040, 0xF7392BA0, 0x46B508F0, 0x9224B028, 0xBB0FAFBC, 0x18500A0E, 0x15C9A30F } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x38000000, 0x64000000, 0x5E000000, 0x8D000000, 0x1C800000, 0x8A400000, 0xDF200000, 0x6AD00000, 0xE8E80000, 0x22840000, 0xB77E0000, 0xF6F10000, 0x8BBA8000, 0x88AEC000, 0x7699A000, 0x257E7000, 0xD9F36800, 0x903B0C00, 0x256F2600, 0xEE7A8B00, 0x3C4FCD80, 0xDDAAF3C0, 0x7E2742E0, 0xA46C54B0, 0x30FA8968, 0x610D9C7C, 0x1D0A4E0E, 0x37348701 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x58000000, 0x34000000, 0x8E000000, 0xDB000000, 0x02800000, 0x70C00000, 0xFF600000, 0x64500000, 0xC9380000, 0xBEAC0000, 0x2C860000, 0xD9310000, 0xDC6B8000, 0x5817C000, 0xDF682000, 0xAE96B000, 0x01A86800, 0x5AF51400, 0x3F788600, 0xD70D5900, 0xF0B7E680, 0x44DB90C0, 0xE23E67A0, 0x56DE6150, 0x69CCA728, 0x34D4D89C, 0xD208EE0A, 0xD3C44D01 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x28000000, 0xE4000000, 0x7A000000, 0xDF000000, 0xC8800000, 0x67400000, 0x28200000, 0x55500000, 0x13580000, 0xC2F40000, 0x2A3E0000, 0x39710000, 0x2C0B8000, 0x06AFC000, 0x1449E000, 0x260C3000, 0x0658F800, 0xCD76D400, 0xB9FE7E00, 0x10136F00, 0x387BF580, 0xC926D9C0, 0xCF263220, 0x962797B0, 0xC7A7D9A8, 0xD164D17C, 0x3F86860A, 0xAC35BB01 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xC8000000, 0xE4000000, 0xB2000000, 0xD3000000, 0x61800000, 0x71C00000, 0x91A00000, 0xF8B00000, 0xC5480000, 0x59DC0000, 0xB9660000, 0xE1110000, 0x39FB8000, 0x5E95C000, 0xABB86000, 0x15F7B000, 0xFF2BD800, 0x97CFC400, 0xBF1F6A00, 0x6B479100, 0x5363E980, 0xB893B840, 0xF43959E0, 0x71350950, 0x86083A68, 0x183E501C, 0x81B4B20A, 0x1D485509 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xF8000000, 0x5C000000, 0x8E000000, 0x91000000, 0x2C800000, 0x47400000, 0xC7200000, 0x49300000, 0xB1A80000, 0xF18C0000, 0x6E360000, 0xB7230000, 0x41318000, 0xA5AAC000, 0x4B8DA000, 0xD5349000, 0xD8A04800, 0x35F1FC00, 0x98483600, 0xAE5C0F00, 0xADCE9180, 0x16967040, 0x52D01E60, 0x01783690, 0xC7F6F1E8, 0x9043B5D4, 0x0EA0480A, 0x28F1FC0D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x48000000, 0xA4000000, 0x82000000, 0xFB000000, 0x20800000, 0x22400000, 0xC5200000, 0xBD300000, 0xAD980000, 0x2CC40000, 0xFD4E0000, 0x13210000, 0x4C308000, 0x321A4000, 0xDC04E000, 0xA92DB000, 0xEFB19800, 0xFCD96400, 0x8D652E00, 0x903EEB00, 0xC8992D80, 0x5945F840, 0xC28DE6A0, 0xDDC08B70, 0x85E07D28, 0x4152FC3C, 0x85099806, 0x562D640B } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xD8000000, 0x14000000, 0xFA000000, 0x15000000, 0x55800000, 0xA1C00000, 0x7AE00000, 0xB6900000, 0xCEF80000, 0x58FC0000, 0xBE760000, 0x2CE30000, 0x7D938000, 0xDC79C000, 0xA5BC2000, 0x06D53000, 0xBA50B800, 0xC5983C00, 0x1DACC200, 0x036DF100, 0xA10F5C80, 0x57DD09C0, 0x68049DA0, 0x318AFA10, 0xB617BB28, 0x57323ED4, 0xA3C8B802, 0x0E343C09 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x78000000, 0x24000000, 0xEA000000, 0xC5000000, 0x3D800000, 0xEE400000, 0x94E00000, 0xE4900000, 0xB3E80000, 0xF9540000, 0xF8CE0000, 0x8FE30000, 0xEE118000, 0x712BC000, 0xFC76A000, 0xFFFF7000, 0xBFF83800, 0x817D3C00, 0xAF3A2200, 0x455CEF00, 0xAF8A1A80, 0x2604B9C0, 0x4D8681E0, 0x18C618F0, 0x16A68168, 0x68F77234, 0x2A3E380A, 0x465A3C09 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xE8000000, 0x34000000, 0x0A000000, 0xAF000000, 0xC5800000, 0x1FC00000, 0x54E00000, 0x0FF00000, 0xBD380000, 0x775C0000, 0x8E760000, 0x46630000, 0x39B08000, 0x40184000, 0xCD4E6000, 0xB43D7000, 0xCD47F800, 0x44381400, 0x63DCEA00, 0x91368900, 0x17C09C80, 0x50E2B440, 0x8DF0CF20, 0x5638CB90, 0x50DD41A8, 0x0AB7E2D4, 0xDD01780E, 0x86835403 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x78000000, 0xCC000000, 0x9A000000, 0x93000000, 0x9F800000, 0x24C00000, 0xDDE00000, 0xF8F00000, 0x63380000, 0x596C0000, 0xB4460000, 0x05610000, 0x25B08000, 0x0B184000, 0x4CFE2000, 0x76CCD000, 0x99145800, 0xE80AA400, 0x96377200, 0x14194D00, 0x697DF480, 0xD10DAC40, 0x5377BB20, 0x8039D350, 0x7EEF65A8, 0xBC86961C, 0xB282D806, 0x3643E403 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x38000000, 0x2C000000, 0xEE000000, 0x29000000, 0x15800000, 0x26400000, 0x79E00000, 0x2A700000, 0x60480000, 0xA1DC0000, 0x63060000, 0x41610000, 0x73B28000, 0xBCE94000, 0x04CC2000, 0xC9FE5000, 0x21D60800, 0x163B9C00, 0xB796B200, 0x97DB6F00, 0xD1E6EE80, 0x29912640, 0x613944E0, 0x73152C50, 0xE8191068, 0x5045F91C, 0x6B02880E, 0x1283DC0F } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x18000000, 0x1C000000, 0x82000000, 0x43000000, 0x1F800000, 0x63C00000, 0xC3200000, 0xAE500000, 0x41180000, 0xC0040000, 0x736E0000, 0x21A30000, 0x83138000, 0x0579C000, 0x1D372000, 0xA6C61000, 0x92CD7800, 0x42B28400, 0xF669B200, 0xD04C5100, 0xBFF3D380, 0xAA0AADC0, 0x117E4920, 0xE8583E70, 0x5A6750A8, 0xCF5F46B4, 0x7888F802, 0x543C4409 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x98000000, 0xD4000000, 0xCE000000, 0x43000000, 0x11800000, 0xD8400000, 0x14200000, 0x05D00000, 0x4F280000, 0x3C2C0000, 0x4DF60000, 0xA0A30000, 0x83128000, 0x68CB4000, 0x489EA000, 0xD9AF3000, 0xCBB76800, 0xBF82B400, 0xEB430A00, 0x7DA20700, 0x3992C180, 0x0D0A4FC0, 0xAEFC4FE0, 0xDD5DBE10, 0x07CCEC68, 0xCB4442D4, 0x15FBE806, 0x9086F407 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xF8000000, 0x24000000, 0x3A000000, 0xBD000000, 0x63800000, 0xCC400000, 0xC4600000, 0x18B00000, 0x0AC80000, 0x3B040000, 0xAA1E0000, 0x3DE30000, 0x99F18000, 0x752A4000, 0x7BF52000, 0xA6B57000, 0x87577800, 0x60A59C00, 0x028E3A00, 0xEFF81F00, 0x3A8C1080, 0xABF8AB40, 0x908EE5E0, 0x5EFAA530, 0x2F0DB768, 0x8CB88D74, 0x6C6EF80A, 0x4A8BDC0F } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xF8000000, 0x0C000000, 0x12000000, 0x43000000, 0x8A800000, 0xB7C00000, 0x16A00000, 0xAD900000, 0x5E080000, 0x71040000, 0xBD3E0000, 0x3A210000, 0x27518000, 0x83284000, 0xEAD52000, 0x3CD5D000, 0x59D57800, 0x2E56C400, 0xF2166600, 0x62F65500, 0xE8841580, 0xA87C34C0, 0x7F401A60, 0xCA634230, 0xD5B111E8, 0x125AE7FC, 0x9CACF802, 0xB62A8407 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x88000000, 0x1C000000, 0x22000000, 0x03000000, 0xBB800000, 0xE9400000, 0x1DA00000, 0xF4F00000, 0xA9080000, 0x346C0000, 0x71360000, 0x56230000, 0xB5B08000, 0xF8A94000, 0x5A9EE000, 0x4F3C5000, 0xE7CFF800, 0x0CC60400, 0x0BA8A200, 0x491F2B00, 0xEA7EC380, 0x606EBD40, 0x6F3523E0, 0x27222F90, 0xB532BA68, 0x3E6ABDD4, 0x907F780E, 0x876F4407 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x48000000, 0x6C000000, 0x26000000, 0x4D000000, 0x6E800000, 0x00C00000, 0xF5A00000, 0x13500000, 0x5DC80000, 0xF9A40000, 0x7D9E0000, 0x1B210000, 0xD3928000, 0xC868C000, 0xBAF46000, 0x68569000, 0x8E842800, 0x880D2C00, 0x9E494E00, 0x07E75900, 0xA0FD8580, 0xC1D3D3C0, 0xF30A8660, 0x4D07F7B0, 0x764C65E8, 0x432B517C, 0xDD16A80E, 0x8065EC09 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x18000000, 0x84000000, 0x46000000, 0x85000000, 0x12800000, 0xB1400000, 0x4E600000, 0x6A900000, 0x4EE80000, 0x434C0000, 0xBBD60000, 0x2DA30000, 0x75B38000, 0xDA1AC000, 0x6F342000, 0x2A707000, 0x173A0800, 0x20C58C00, 0x15881E00, 0x635FEF00, 0x607D6C80, 0x768ECBC0, 0x39F765E0, 0x2FD3AC90, 0xAE8B9F68, 0x80DDC454, 0x2DBDA802, 0x80AF3C05 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0xC8000000, 0x54000000, 0xD2000000, 0x37000000, 0xBB800000, 0xAA400000, 0x6E200000, 0x51300000, 0xB7B80000, 0x072C0000, 0x9C060000, 0xF3E30000, 0x4B528000, 0x21AB4000, 0x1327E000, 0x44507000, 0xA62B1800, 0xEF641400, 0x3770F200, 0xE79A6700, 0xCF1DC180, 0x113D7440, 0xC80F6620, 0xCBB5FC50, 0x2E9BCDA8, 0x4D9DBB14, 0x51FE7806, 0x62EF2407 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x68000000, 0x1C000000, 0xE2000000, 0x67000000, 0x9C800000, 0x80C00000, 0x82200000, 0xE6300000, 0x90580000, 0x4F940000, 0xF35E0000, 0x84610000, 0x37D08000, 0x76CBC000, 0x2C3DE000, 0x3D33D000, 0xDED8F800, 0x30559400, 0x89FDAE00, 0x7490D100, 0xBCA8FB80, 0xC6EDD840, 0x347BA5A0, 0x68A7DD30, 0xFE868828, 0x36B4807C, 0xABED9806, 0x13F9840D } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x98000000, 0xAC000000, 0xA6000000, 0x25000000, 0x13800000, 0x21400000, 0xDBE00000, 0x49300000, 0x2F880000, 0xD6540000, 0x3E8E0000, 0xBA230000, 0x4D108000, 0xAB984000, 0xA84FA000, 0xE282D000, 0x08C12800, 0x81A38C00, 0x78511A00, 0x6A7AAB00, 0x8A7D5A80, 0xCF8AD340, 0xE6540EE0, 0xC68C2970, 0x6621E668, 0x73139D34, 0x2298080E, 0x1DCE1C03 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x38000000, 0x8C000000, 0x1E000000, 0x9B000000, 0x92800000, 0xFA400000, 0x13A00000, 0xF2B00000, 0x0CA80000, 0x1C140000, 0x092E0000, 0xB8630000, 0x95D28000, 0xD1F8C000, 0x36AFA000, 0x5FA0D000, 0x4CB34800, 0xA7A99400, 0x66976600, 0x476F4300, 0x39C29780, 0xE2617C40, 0xD4D15460, 0x4279A8F0, 0xBF6D6DE8, 0x15C2C3B4, 0xCC606806, 0xA7D28409 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0x4C000000, 0xFA000000, 0x31000000, 0xA6800000, 0x60C00000, 0x2A600000, 0x71700000, 0x8CB80000, 0x72FC0000, 0x6DD60000, 0x2D230000, 0xD5508000, 0xAB694000, 0x07556000, 0xF7E29000, 0xAE33D800, 0x4C9AAC00, 0x832E9E00, 0xE37CB900, 0x48971A80, 0xDC000440, 0x82037320, 0x45018310, 0x4881AFA8, 0x8FC2D254, 0x0BE0380E, 0x7C327C07 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x98000000, 0x4C000000, 0xD2000000, 0xE1000000, 0x4B800000, 0x06C00000, 0x9C600000, 0x37500000, 0x96780000, 0x7ADC0000, 0xF5160000, 0x6FA30000, 0x5EB08000, 0x24EAC000, 0x92452000, 0x21D95000, 0x086F7800, 0xD3FF4C00, 0x84E6EA00, 0x78E9D500, 0xF8449A80, 0x3CDB44C0, 0xD9EC10A0, 0xE03D0490, 0xCD079828, 0x7A791954, 0x58DC580E, 0x3C151C09 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x38000000, 0xEC000000, 0x22000000, 0x91000000, 0x26800000, 0x1D400000, 0xA9600000, 0x59500000, 0x47E80000, 0xFCC40000, 0x249E0000, 0x21230000, 0x60B18000, 0x7CF9C000, 0xD7CDA000, 0x13C95000, 0x3CF63800, 0x72244C00, 0x1E0C9E00, 0x4EEB8F00, 0x2645A080, 0x03DC68C0, 0xA5432EE0, 0x05602EB0, 0x5B53A868, 0x86E94574, 0xE245980A, 0xD5DE1C01 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x28000000, 0x7C000000, 0xEE000000, 0xA7000000, 0xE5800000, 0xB5C00000, 0xE0E00000, 0x9E900000, 0x15B80000, 0xD5140000, 0xA05E0000, 0x30210000, 0x3AF28000, 0x606AC000, 0x4E0FE000, 0x31FB5000, 0x62354800, 0x0F2EA400, 0x7D8B4A00, 0x101F6100, 0x75006480, 0x0C82A1C0, 0x474060A0, 0x48A19CB0, 0x9FB28628, 0xF9C9387C, 0x173CA80E, 0x2270F401 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xD8000000, 0xCC000000, 0xD6000000, 0x55000000, 0x85800000, 0x0E400000, 0x9FE00000, 0x33700000, 0xC3380000, 0x384C0000, 0xD3660000, 0x2AA10000, 0x40128000, 0x15894000, 0xC3D7A000, 0xCC3A5000, 0x9ECF6800, 0x5DA58C00, 0xD6828200, 0xF6C3CF00, 0x60203680, 0x88D24A40, 0x34AAC520, 0xD48593D0, 0x75D399A8, 0x0529DA9C, 0x90C6C80E, 0x8132DC0F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xE8000000, 0x44000000, 0x86000000, 0xC5000000, 0x6B800000, 0x74400000, 0x0DA00000, 0xD8500000, 0xA4A80000, 0xEEDC0000, 0x97060000, 0x8FE30000, 0xB8F28000, 0xB3784000, 0x48346000, 0x5978B000, 0xEF360800, 0x61F88C00, 0x2DF47A00, 0xDF9A5F00, 0x4E463780, 0xEDC36FC0, 0x72E137E0, 0x2F72BFD0, 0xFD39F268, 0x5A944314, 0x05AA6806, 0x535C3C0B } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0x3C000000, 0xF6000000, 0x35000000, 0x92800000, 0xC7400000, 0x8A200000, 0x6F100000, 0xCB680000, 0x03640000, 0xCCBE0000, 0x43630000, 0x9C308000, 0xA8F8C000, 0x0E4C2000, 0x457B9000, 0xD88E2800, 0xCF988C00, 0x387EDE00, 0x7E83B700, 0x29418580, 0xE320ACC0, 0x5B93F5E0, 0x612BD230, 0x27C40668, 0x92EF85F4, 0x372A080E, 0x62C71C01 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x18000000, 0x14000000, 0xDA000000, 0x35000000, 0x65800000, 0xAD400000, 0x6CE00000, 0x08700000, 0x0B880000, 0xAE340000, 0x0FAE0000, 0x5DA10000, 0x12928000, 0x48FAC000, 0xE73F2000, 0x505A3000, 0x382C3800, 0x69E03C00, 0x65F10200, 0xCACAC300, 0xDCD41680, 0xF0DC9A40, 0x12A98BE0, 0xAE66E8F0, 0xB3F42768, 0xBB8F4DBC, 0xEC73180E, 0xB98A0C01 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x88000000, 0xAC000000, 0xA2000000, 0xEB000000, 0x3B800000, 0xCC400000, 0xDE200000, 0x10500000, 0xFB880000, 0x426C0000, 0x91160000, 0xC2610000, 0x76718000, 0x6FD94000, 0x47E5E000, 0x127A9000, 0x2FF73800, 0xE1D1A400, 0xE0CB8200, 0xDDCF7F00, 0x72073980, 0x5A4A91C0, 0x0D0F3360, 0xA9E7C190, 0xCB7B30E8, 0x2777CB5C, 0xC212D802, 0x74AB3403 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x38000000, 0x34000000, 0xAE000000, 0x63000000, 0xF0800000, 0xE8C00000, 0xBC600000, 0x28B00000, 0xA4980000, 0x81640000, 0x10AE0000, 0xF4A30000, 0xC4D08000, 0xA4284000, 0x59FD2000, 0x33CA3000, 0x1D0F6800, 0x0DF0B400, 0x1BBA8E00, 0x59F50100, 0x16264280, 0x1E8F0B40, 0x1DB1ECA0, 0x2318ADF0, 0x2724C828, 0x6F0D53B4, 0x9CF2480E, 0x3A3A8403 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xD8000000, 0xAC000000, 0x9A000000, 0xE1000000, 0xAA800000, 0x28C00000, 0x74A00000, 0x1AD00000, 0x9A780000, 0x79940000, 0xD55E0000, 0x90C10000, 0xE8A38000, 0xA8D3C000, 0xDF782000, 0x3D15D000, 0x2A9ED800, 0x35E0EC00, 0x9132AE00, 0xC449C900, 0xE05D5180, 0x1C4269C0, 0x4361DAA0, 0xEBF2E3B0, 0x05E8DD28, 0xB60C7F7C, 0x0DF8200A, 0xA9D5D001 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x08000000, 0xC4000000, 0xAA000000, 0xD3000000, 0xE0800000, 0x77C00000, 0xAE600000, 0x31300000, 0xB0A80000, 0xE8AC0000, 0x28960000, 0x63C30000, 0xAC628000, 0xD633C000, 0xE2286000, 0x806F3000, 0x0877B800, 0x5C32E400, 0x812A4E00, 0x98ED9D00, 0xA3B50680, 0x94524D40, 0x0D193E60, 0xB1C74410, 0x0F59AEE8, 0x85E54054, 0x86486006, 0x325F3005 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xC8000000, 0x34000000, 0x62000000, 0x55000000, 0x3E800000, 0x15400000, 0xA0200000, 0xD2500000, 0x86880000, 0xB83C0000, 0x9D860000, 0x0B430000, 0xE3238000, 0x7BD0C000, 0x68496000, 0xFBDFF000, 0xCEB75800, 0x9DBBDC00, 0x5AC62E00, 0xE6626F00, 0x53F2B580, 0x2E18B9C0, 0x8F564B60, 0xEB8906D0, 0x0ABCE8E8, 0x26C7FC14, 0xF0616002, 0xC4F3F00D } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x18000000, 0x7C000000, 0xEA000000, 0x27000000, 0x15800000, 0x25C00000, 0x52E00000, 0x29D00000, 0x31180000, 0x515C0000, 0x28B60000, 0x3EC10000, 0x4D638000, 0xDB13C000, 0xBE7B2000, 0x394D9000, 0xDD4C5800, 0x8B4E3400, 0x664D4A00, 0x84CE0100, 0xAC8F7C80, 0xA7AEBCC0, 0x369C9B20, 0x0955E510, 0x7C91D5A8, 0x20BAFCDC, 0x642D200A, 0x3E5C9001 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x88000000, 0x1C000000, 0x9E000000, 0xA3000000, 0x12800000, 0xD2400000, 0xE0E00000, 0x6FB00000, 0x8CA80000, 0x3B240000, 0x809E0000, 0xA9410000, 0xB6608000, 0xA7F04000, 0x3549E000, 0xEF165000, 0xEDF40800, 0x8F45F400, 0xDA6C4600, 0xCD8A4300, 0x69B5AA80, 0xF0A62D40, 0x295D6460, 0x4862FA30, 0x34F160E8, 0x4FC9307C, 0xD157E006, 0x1B175003 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x08000000, 0x5C000000, 0x86000000, 0xBF000000, 0xE0800000, 0xE8C00000, 0xBE200000, 0xA9100000, 0x1BB80000, 0x6DF40000, 0x6BBE0000, 0xD7C30000, 0x1EA08000, 0x21D3C000, 0x359A6000, 0xCCE55000, 0x2C056800, 0x3C37E400, 0xCA1FFE00, 0x1690E100, 0xC3FBBB80, 0x5316CCC0, 0xB08DC2A0, 0xEB6B6D30, 0x8BEE8F28, 0x411BF4F4, 0xDE24600E, 0x5B26500D } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x28000000, 0x34000000, 0x6E000000, 0xA1000000, 0xD1800000, 0x90400000, 0xD4E00000, 0xA1D00000, 0x52D80000, 0x2CE40000, 0xA24E0000, 0x34C30000, 0x8B218000, 0x5C70C000, 0xFA68E000, 0x3DAC7000, 0xF3936800, 0x053A3C00, 0xAFB54200, 0x5A574700, 0x6A06B280, 0x889E84C0, 0x6099B420, 0x4B061CF0, 0x191FCCA8, 0xD0DA9334, 0x8FE7600A, 0x90CFB005 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x28000000, 0x4C000000, 0x4A000000, 0xA9000000, 0x22800000, 0xFAC00000, 0xDB600000, 0xC1D00000, 0x2DE80000, 0x861C0000, 0xDE860000, 0x8F410000, 0x74228000, 0x25F14000, 0x70186000, 0xA2059000, 0x52821800, 0x72C08C00, 0xC763AE00, 0x93D3A100, 0xE0E82680, 0xA29D5AC0, 0xC74498E0, 0xDFA10BD0, 0x6DB36868, 0x29BBEC1C, 0xECB4E00E, 0x90B9D00F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0x84000000, 0xD2000000, 0x4F000000, 0x8D800000, 0x16C00000, 0x25600000, 0x34300000, 0x63C80000, 0x57640000, 0x363E0000, 0x35430000, 0x7AA18000, 0x79D0C000, 0x17B92000, 0x008F7000, 0xADCB5800, 0x2E677400, 0x16BD8A00, 0xA9012D00, 0x18802E80, 0x28429540, 0xF82337E0, 0xC2929EB0, 0x341AEB68, 0x49DE22F4, 0x7E30A00A, 0xC8CBB005 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xC8000000, 0x54000000, 0xA2000000, 0xD5000000, 0xE8800000, 0x76C00000, 0x29600000, 0x1C900000, 0x01E80000, 0x949C0000, 0xB5460000, 0x2A410000, 0xEDA28000, 0x48F2C000, 0x71F86000, 0x89B67000, 0x89B9D800, 0xC916DC00, 0x65CB7600, 0xF02E3900, 0xE61DDE80, 0xFA87C7C0, 0x65A15DE0, 0xBCF191D0, 0x63F84D68, 0x44B5C31C, 0xFD3AE00E, 0x49D4B001 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x08000000, 0x2C000000, 0x9A000000, 0x5F000000, 0xE3800000, 0xED400000, 0xF9E00000, 0x72900000, 0x27D80000, 0x57FC0000, 0x1F160000, 0x32C30000, 0x16A08000, 0x20734000, 0xB8CAE000, 0x7C649000, 0xBB88D800, 0x94861400, 0xAB997200, 0xE49FFB00, 0xC647F280, 0x0D3B5DC0, 0xCCEF9D20, 0x528D4C90, 0xEB5D25A8, 0x28646E54, 0x258A600E, 0xAD87D00F } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x78000000, 0x64000000, 0x66000000, 0x89000000, 0x89800000, 0x70C00000, 0x93600000, 0xE0B00000, 0xA1C80000, 0x6F040000, 0xD45E0000, 0x21830000, 0x0CC18000, 0xA160C000, 0x67B1A000, 0xBD487000, 0x94440800, 0xD8FDBC00, 0x52D30200, 0xB4FA6500, 0x8C0F4E80, 0xAF3A6F40, 0x09EC75E0, 0x77C9B330, 0xCE041168, 0x61DCB574, 0x4341800A, 0x08A0C005 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x18000000, 0xEC000000, 0x9E000000, 0x8F000000, 0xC4800000, 0x91C00000, 0x2BA00000, 0xBDF00000, 0xDD380000, 0xDE940000, 0xACBE0000, 0xF6810000, 0x20C28000, 0x30214000, 0xC0B0A000, 0x935BD000, 0x3AC5C800, 0xDD764400, 0xBEAC2E00, 0x07A9D500, 0xD07CA980, 0x80A17940, 0xE3719320, 0xC9F826B0, 0xFCB6FCA8, 0x4D0C5EFC, 0x365A800E, 0xA345400F } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xA8000000, 0x2C000000, 0xF6000000, 0x69000000, 0x1A800000, 0x4A400000, 0x64600000, 0xFB900000, 0xA9680000, 0xE2FC0000, 0xB0A60000, 0x6C830000, 0x63428000, 0x9EE1C000, 0x21D0E000, 0x650A1000, 0x356F6800, 0xEFCC7C00, 0xE77ECE00, 0xC965C300, 0xB8227880, 0x26F01FC0, 0x007A9BE0, 0xBDD6A650, 0x683B2568, 0x62B4D694, 0x4A2A8006, 0x3C1DC00D } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xA8000000, 0x3C000000, 0xCE000000, 0x6D000000, 0x9B800000, 0x50400000, 0x98200000, 0xAD900000, 0xAA880000, 0x1C7C0000, 0x56860000, 0x30810000, 0x0AC08000, 0x65E14000, 0x2CF06000, 0x5EBA5000, 0xD427C800, 0x40D08C00, 0x7128DA00, 0x95ACAF00, 0x262FE180, 0x8A6F76C0, 0x3C4E6C60, 0x4CDDA3D0, 0xD5D67FE8, 0xA5E9E61C, 0xA54E8006, 0x555C4007 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x98000000, 0x7C000000, 0x9E000000, 0x59000000, 0x93800000, 0x67400000, 0x66200000, 0x1F300000, 0x73980000, 0xE12C0000, 0x39660000, 0xE0810000, 0x07C18000, 0xA1E04000, 0x1ED0A000, 0xDD4B9000, 0xA4678800, 0xE1011C00, 0x9F802A00, 0xC1415300, 0xF322C580, 0x8AB38440, 0x31D842A0, 0x8A8C32D0, 0x18140528, 0x66B8299C, 0x9E9F8002, 0x8D3D4007 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x58000000, 0x0C000000, 0xA2000000, 0x0D000000, 0x9D800000, 0xD2400000, 0xC0E00000, 0x19B00000, 0xD7180000, 0x632C0000, 0x54A60000, 0x08830000, 0x23C18000, 0xC0A1C000, 0xDC502000, 0x07295000, 0xC876B800, 0x5868BC00, 0xD5174200, 0xB39BBF00, 0x92EC0A80, 0x91048540, 0x1D514AA0, 0x58A8B8D0, 0x67351A28, 0x0D0BAE94, 0x4AE7800A, 0x0A62C001 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xB8000000, 0xAC000000, 0x2E000000, 0x83000000, 0x08800000, 0x81400000, 0x7C600000, 0xA7F00000, 0xE8980000, 0xEBB40000, 0x227E0000, 0x6B010000, 0x6C828000, 0xDB434000, 0xCD602000, 0xBA705000, 0x4E5A0800, 0x3016B400, 0xFBAC2E00, 0x508B2700, 0x491D7480, 0x86722E40, 0xC85A1DA0, 0x7715DCB0, 0x792DEF28, 0x68C871FC, 0x3CFE000E, 0x05410007 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0xE4000000, 0x92000000, 0x09000000, 0x3D800000, 0xE2400000, 0xDC600000, 0x6FD00000, 0x73A80000, 0x6F6C0000, 0xC9B60000, 0xB1030000, 0xA9818000, 0x1840C000, 0x79612000, 0x7C52F000, 0xEEE9D800, 0x158E6C00, 0x70A6D200, 0xC1087F00, 0x971D7880, 0x11EC0EC0, 0xBB7651E0, 0x00A10310, 0xE1728368, 0xBDDA2ED4, 0x0C36000A, 0xE7430005 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x48000000, 0xD4000000, 0xC6000000, 0xE5000000, 0x15800000, 0x33C00000, 0x4E200000, 0x62F00000, 0xD2380000, 0xEE440000, 0x6BEE0000, 0xB1030000, 0x93808000, 0xB6C0C000, 0x0BA06000, 0x19327000, 0x48184800, 0x4AB48C00, 0x5CD5C200, 0x4AC79900, 0xCBAF7780, 0x49E37340, 0xFAD22320, 0x7DCA41F0, 0xADFE3EA8, 0x386B97B4, 0xA5CE000E, 0x93F30001 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x88000000, 0x9C000000, 0xB6000000, 0x01000000, 0x94800000, 0xB1C00000, 0x1C200000, 0x20100000, 0xE6F80000, 0x048C0000, 0x2C060000, 0xE6030000, 0x59028000, 0x10824000, 0x63C3E000, 0xBF205000, 0x9F90A800, 0x74BADC00, 0x3CEE5600, 0x35769500, 0x8D09B780, 0x874670C0, 0xFEE35BA0, 0x4BB169D0, 0x28AB7228, 0x1C164014, 0xB8F80006, 0xA98C0003 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x38000000, 0xDC000000, 0xDE000000, 0x81000000, 0xD3800000, 0x82400000, 0xE1E00000, 0xBC700000, 0x2D480000, 0xC0840000, 0x069E0000, 0xFA030000, 0x23028000, 0xDC814000, 0x58C22000, 0x54239000, 0xDDD00800, 0x2FD97C00, 0x033D4A00, 0xBA934700, 0x5FB88E80, 0x820EF640, 0x94BA84E0, 0x4A8E5730, 0x1679E868, 0x2DAF4A74, 0x7F280006, 0x0EB4000F } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x68000000, 0x24000000, 0xFA000000, 0xBB000000, 0x05800000, 0x79400000, 0x50E00000, 0x11300000, 0x6D380000, 0xBB540000, 0x2E7E0000, 0x94010000, 0x52008000, 0x7F034000, 0xCF816000, 0xAA413000, 0x71637800, 0x92710400, 0x86DAFA00, 0xAFE5F300, 0x3A06A680, 0x7FB40740, 0x6D4F7020, 0x863919B0, 0x26D7B4A8, 0xFB3E99FC, 0x2AE00006, 0x6A30000F } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x58000000, 0x64000000, 0x62000000, 0x21000000, 0xB4800000, 0x1A400000, 0x21E00000, 0xF0100000, 0x97280000, 0x26140000, 0xEBCA0000, 0xC0010000, 0x20008000, 0xD000C000, 0xE8016000, 0x3C00B000, 0x0600C800, 0x4300C400, 0x95804200, 0xAEC16900, 0x3BA03480, 0xD1F043C0, 0x6739E020, 0xB13D2E50, 0xCDDE4C28, 0x2BCAD794, 0xE0000002, 0xF0000001 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0xD8000000, 0x3C000000, 0xEE000000, 0x23000000, 0x4F800000, 0x44400000, 0xBA200000, 0xC5500000, 0xA9C80000, 0x34240000, 0xD1D60000, 0x58010000, 0xFC018000, 0x4E014000, 0x33002000, 0x9781B000, 0x78407800, 0x5421DC00, 0xE6504600, 0xE6489F00, 0x70648880, 0x6BF77440, 0x9D508AA0, 0x55C8D390, 0x7A252848, 0xE2D783AC, 0xCF800002, 0x84400003 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0xB8000000, 0x7C000000, 0xC2000000, 0x91000000, 0x14800000, 0x97400000, 0xB5E00000, 0x03B00000, 0xA8680000, 0x565C0000, 0x70DE0000, 0x58010000, 0xCC018000, 0x0A014000, 0x8501A000, 0x12817000, 0xB840F800, 0xF2618400, 0x11712200, 0x9E482900, 0x774D2E80, 0x6EE76BC0, 0xA5850760, 0x42EAD0D0, 0x7482ECB8, 0x61DFC1BC, 0x8C800002, 0xFB400003 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x38000000, 0xA4000000, 0x7A000000, 0xC1000000, 0xB0800000, 0xDBC00000, 0xE1A00000, 0x24500000, 0xAA380000, 0xAEA40000, 0x39460000, 0x54010000, 0x92008000, 0xBD01C000, 0xFE812000, 0x58C07000, 0x34214800, 0x3510F400, 0x51598200, 0xDBD56100, 0x6CEFB780, 0xB13CC340, 0x21B2C8A0, 0x7A7F9470, 0x9625FD48, 0x4E87428C, 0x23A00002, 0x01500001 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xE8000000, 0x4C000000, 0x6E000000, 0xCF000000, 0xB4800000, 0xBDC00000, 0x07E00000, 0x8CF00000, 0x42380000, 0xE53C0000, 0xAA2E0000, 0xC4010000, 0xD2008000, 0xA901C000, 0x87816000, 0x8F41D000, 0x39209800, 0x5190DC00, 0xBC099E00, 0x14656900, 0x7E237B80, 0x2BF70FC0, 0x7FCC99E0, 0x9317C470, 0x0FBC6A78, 0x70EF645C, 0xDB600002, 0x3D300001 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x88000000, 0x1C000000, 0x92000000, 0xB3000000, 0x33800000, 0x05C00000, 0x72A00000, 0x4B500000, 0x99E80000, 0x1A6C0000, 0x2A560000, 0xAA010000, 0x17018000, 0xC5804000, 0x60C1A000, 0xF4211000, 0x40103800, 0xFC092400, 0xA6DD6600, 0xBC0E6700, 0x15B50B80, 0x87236540, 0x8D03D6A0, 0x741213D0, 0xBC9BE4D8, 0x72070CAC, 0x10680002, 0xA0AC0003 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x78000000, 0x0C000000, 0x12000000, 0x6D000000, 0x71800000, 0xD7400000, 0x6C600000, 0xDC900000, 0x2FF80000, 0x07A40000, 0xB2B20000, 0x86010000, 0x23018000, 0xE6814000, 0x8FC06000, 0xACA0F000, 0x14B01800, 0x91882400, 0x3F0CDA00, 0x504EE300, 0x54A6AE80, 0x88BA58C0, 0xB74C7920, 0xD0AEFFF0, 0xF6F6DF48, 0x20636D64, 0x6A180002, 0xF0740003 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x78000000, 0x3C000000, 0xBE000000, 0xC1000000, 0xC0800000, 0xF9400000, 0xBEA00000, 0x74900000, 0x2C880000, 0x3FBC0000, 0x73660000, 0x41010000, 0x00818000, 0x9940C000, 0x2EA12000, 0x0C90F000, 0x10887800, 0x81BD7C00, 0xB2678200, 0x81808100, 0xF9C07280, 0x27E1BD40, 0x5A31C920, 0x2018A910, 0x2F340778, 0xF2DB9ACC, 0xF3660002, 0x81010003 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x28000000, 0x74000000, 0x62000000, 0xAB000000, 0x55800000, 0x9BC00000, 0x91E00000, 0xE9F00000, 0x38880000, 0xBBA40000, 0x37060000, 0x0B010000, 0x25808000, 0x83C0C000, 0x9DE0A000, 0xD7F05000, 0x8588E800, 0x2724C400, 0x52475600, 0x54A1AB00, 0xC651B780, 0xC359E3C0, 0xF73D73E0, 0x63DA2110, 0x022A9F48, 0x3EA32A0C, 0xFF060002, 0x6F010001 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xB8000000, 0x2C000000, 0xAE000000, 0xB7000000, 0x95800000, 0x8AC00000, 0xE8200000, 0x1E900000, 0x6D880000, 0x8F240000, 0xE0B60000, 0x4F010000, 0x99818000, 0x94C1C000, 0xB720A000, 0x1F117000, 0x65485800, 0x7E055C00, 0xDCA76E00, 0x3DC82B00, 0x74449580, 0x82C61040, 0x8B399D20, 0x643C2B10, 0x9E1A8648, 0x66933D6C, 0x15360002, 0x55C10003 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x98000000, 0x54000000, 0xAA000000, 0x7F000000, 0xA8800000, 0x6DC00000, 0x93E00000, 0x76300000, 0x3AA80000, 0x44540000, 0x51A60000, 0x0B010000, 0x52818000, 0x2AC14000, 0xFF612000, 0x29F13000, 0x8248A800, 0x30E55400, 0x79CEFE00, 0x74345100, 0x18D75B80, 0x888967C0, 0x9F844C60, 0x683E0550, 0x327C00A8, 0x1A33474C, 0xDA460002, 0xE9310003 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0xD8000000, 0x44000000, 0x3A000000, 0x53000000, 0xE7800000, 0x60400000, 0x91E00000, 0xD7D00000, 0x8D580000, 0x4A5C0000, 0x48D20000, 0x29010000, 0x94818000, 0xB7C1C000, 0xF9A1A000, 0xDA31B000, 0x24888800, 0xAE047400, 0xB60EA600, 0xE612CF00, 0x4C204080, 0x657163C0, 0x14E9CFA0, 0xE4950AB0, 0xFC37ACB8, 0xEB5F6DA4, 0xA58A0002, 0x735D0003 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xA8000000, 0xEC000000, 0x82000000, 0x53000000, 0x58800000, 0xBEC00000, 0x27A00000, 0xB6100000, 0xEB380000, 0x5D3C0000, 0x861E0000, 0x01010000, 0xF3808000, 0xB240C000, 0x2F60E000, 0x04B15000, 0x38A9D800, 0x81450400, 0x49C2A600, 0xF0EFB100, 0x36C8FD80, 0x66740F40, 0x1B2B4C20, 0x1ACB6670, 0x15BBB278, 0x7F32903C, 0xA7260002, 0xD33D0001 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x68000000, 0x6C000000, 0x62000000, 0x23000000, 0x7E800000, 0x19400000, 0xD4600000, 0x16300000, 0x44280000, 0xA9AC0000, 0xBD3A0000, 0xB9010000, 0xE9808000, 0xE1C1C000, 0x1021E000, 0x95D0D000, 0x7AD8D800, 0x3C24C400, 0xEC864600, 0xFCC3FD00, 0xB275B280, 0x8C9EE8C0, 0x4A470C60, 0x2C623850, 0xF7E51B58, 0xE3A7C674, 0x0D920002, 0x06ED0001 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x88000000, 0x44000000, 0xA2000000, 0x5B000000, 0xAE800000, 0xA3C00000, 0xABA00000, 0x8B100000, 0x1D880000, 0x0E0C0000, 0xF8720000, 0xDD010000, 0xA7808000, 0x6E414000, 0x7AE02000, 0xED711000, 0x80388800, 0xCF154400, 0xBDB6B600, 0x8D9E5D00, 0x0182C780, 0x29F99740, 0x2BB4F620, 0x12264B10, 0x3CD6A418, 0x20AEACE4, 0xE65A0002, 0x4C1D0001 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x28000000, 0x04000000, 0xA2000000, 0x35000000, 0x6B800000, 0x92C00000, 0x14E00000, 0xFCD00000, 0xB1380000, 0x57740000, 0x69B20000, 0xDB010000, 0x88818000, 0xA641C000, 0x6CA16000, 0x9B705000, 0xFAC80800, 0xC7FD4400, 0xD4EE6A00, 0x2B9FD700, 0x0357A580, 0x39AB69C0, 0x32C5D9A0, 0x019A1270, 0x272D56E8, 0x2BD72F64, 0x0FEA0002, 0x26650003 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x08000000, 0x24000000, 0x76000000, 0xEB000000, 0x9D800000, 0x30C00000, 0x71A00000, 0x8BD00000, 0x0FC80000, 0xA2BC0000, 0xDBE20000, 0x1D810000, 0xF0C18000, 0xD1A14000, 0x7BD1E000, 0x07C81000, 0x86BC4800, 0xADE2EC00, 0xF680D600, 0x6D40BB00, 0xE1612180, 0x0A710340, 0x8C1907A0, 0x89745790, 0x0F5FA978, 0x2D6361C4, 0x70C18002, 0x11A14003 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x48000000, 0x7C000000, 0x52000000, 0x2B000000, 0x89800000, 0xE6400000, 0x03200000, 0x29F00000, 0xB3480000, 0xAFA40000, 0x20C20000, 0x61810000, 0xEA408000, 0x39204000, 0x4EF06000, 0x20C89000, 0x1EE4F800, 0xF862A400, 0x85315600, 0xD3A99300, 0x59358C80, 0xDE5A6640, 0xC71DC3E0, 0x672F1E90, 0x0F66BB48, 0x0143F784, 0xABC08002, 0xE3604001 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xE8000000, 0x34000000, 0xBE000000, 0xD5000000, 0x9E800000, 0xF8C00000, 0xBA200000, 0xEC300000, 0x5F180000, 0x85E40000, 0xE12E0000, 0x4A810000, 0x56C18000, 0xE720C000, 0x96B1A000, 0xF1D9D000, 0xDEC46800, 0x2D9F7C00, 0x3858AA00, 0xF784BD00, 0x12FF3180, 0x3909D440, 0xCECD8860, 0x87D21630, 0x744AD7C8, 0x7E6F385C, 0x84E18002, 0xFF10C003 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x48000000, 0xC4000000, 0xFA000000, 0xF1000000, 0x2B800000, 0x26400000, 0xD1200000, 0xF0900000, 0xE2A80000, 0x1ACC0000, 0x5AD60000, 0xB9810000, 0xE3408000, 0xF8A1C000, 0xFBD0A000, 0x6E089000, 0x031D8800, 0x49DFF400, 0xAF1CE200, 0x87DED700, 0x5C1C8C80, 0x815F8240, 0x27DDB120, 0xB93E6D50, 0x26ED9198, 0x57C6FFAC, 0x02688002, 0x102DC001 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xD8000000, 0x6C000000, 0x26000000, 0xDF000000, 0x1F800000, 0x73C00000, 0x88E00000, 0x57300000, 0xCF980000, 0xB5140000, 0x10C20000, 0x91810000, 0xC8C08000, 0x6560C000, 0x21F12000, 0x79F9B000, 0x3D64D800, 0x1DFA4C00, 0x5784BE00, 0xD7CABF00, 0xAA9D2780, 0x0B9EB1C0, 0x7FFEDE60, 0x9A8FE730, 0xED37D628, 0xF6732784, 0x66D88002, 0x50B4C001 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xA8000000, 0x44000000, 0x5A000000, 0x17000000, 0xB2800000, 0x02C00000, 0xA3600000, 0x6FF00000, 0x4D880000, 0x212C0000, 0xBE2A0000, 0x2C810000, 0x0FC08000, 0x66E0C000, 0x2FB1E000, 0x44295000, 0xA9BC8800, 0xC652B400, 0x57252E00, 0x2247E500, 0xF68BC580, 0xAF9126C0, 0x42F9CFE0, 0xAD653310, 0x8CE64658, 0x049B8A54, 0x61288002, 0x683CC001 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xF8000000, 0xD4000000, 0xEA000000, 0x33000000, 0xD8800000, 0x30400000, 0x9AE00000, 0xD0100000, 0x4B180000, 0xC7240000, 0xFBB60000, 0x36810000, 0x21418000, 0xFD614000, 0xF6D1E000, 0xC0B9F000, 0xB255A800, 0x627FD400, 0x231D6600, 0x8FA23100, 0x9B1E2080, 0xF7CC55C0, 0xF01A9020, 0x3FCA9E30, 0x84F2CA48, 0x7666096C, 0x62B98002, 0xCD554003 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x38000000, 0x6C000000, 0x12000000, 0x73000000, 0xD0800000, 0x90C00000, 0x0A600000, 0x0AD00000, 0x93680000, 0xF4C40000, 0xD68E0000, 0x83810000, 0x90408000, 0x02A14000, 0xFCB12000, 0xB3B87000, 0x78ACD800, 0xE0CA2400, 0xB6CFE600, 0xC9202100, 0x08F0E180, 0x671874C0, 0xB11D45A0, 0x8EF38ED0, 0xEF221588, 0x10CAEF1C, 0xFECE8002, 0xAD204001 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x48000000, 0x24000000, 0x3E000000, 0x23000000, 0x7C800000, 0x8DC00000, 0x29600000, 0x38900000, 0x9F680000, 0xE7840000, 0x6F5E0000, 0xFB810000, 0x0F418000, 0x27A14000, 0x1D70E000, 0x62389000, 0x758C4800, 0x8E4A7C00, 0x28B74600, 0x6FC47900, 0xCA7FDB80, 0xE830F2C0, 0x48998120, 0xAF7CA6D0, 0x01331B08, 0xAB9B74BC, 0xC97F8002, 0x24B04003 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x08000000, 0xF4000000, 0x3A000000, 0x81000000, 0x3B800000, 0x69400000, 0xC7A00000, 0xBAB00000, 0x5F080000, 0x77340000, 0xB7360000, 0xEE810000, 0x78C18000, 0xF7E1C000, 0x8A906000, 0x4AF81000, 0xA09DE800, 0xFA327400, 0xD57E0200, 0x7414F700, 0x2C469280, 0xB1E92F40, 0x2A248560, 0x828E8610, 0xFEBC1268, 0x44C3886C, 0x60578002, 0xA7D0C003 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x68000000, 0x04000000, 0xC6000000, 0x69000000, 0x35800000, 0x7F400000, 0x7BA00000, 0x8D300000, 0x1F880000, 0x6AAC0000, 0x458E0000, 0x20810000, 0xA0C08000, 0x4FE1C000, 0xFC112000, 0xD978D000, 0x40440800, 0x60F38C00, 0xE517D200, 0x4DD5EB00, 0xA0CBBE80, 0xC7F31740, 0x6D976A60, 0x4914A710, 0x592B3158, 0xAAE2E51C, 0xED6E8002, 0xB410C001 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x58000000, 0x74000000, 0xAA000000, 0x1D000000, 0x84800000, 0x1A400000, 0xFE600000, 0xD1500000, 0x6EB80000, 0xD93C0000, 0x4FCA0000, 0x83810000, 0xBBC18000, 0x44A14000, 0x3771E000, 0x7088B000, 0x3C54E800, 0x550F5400, 0x72973A00, 0x381B8900, 0xF679F480, 0x3E1CDCC0, 0xF37BB2A0, 0x4FA86570, 0x34E53E78, 0x93265994, 0x10B38002, 0x331C4003 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xC8000000, 0x4C000000, 0x6A000000, 0x8B000000, 0xE9800000, 0x79400000, 0x3D600000, 0xBFB00000, 0xE5C80000, 0xD8940000, 0xC9B60000, 0xB8810000, 0x03C18000, 0x09A04000, 0xCD902000, 0x4E199000, 0xAC6C9800, 0x0E2AD400, 0x66821600, 0x19A75300, 0x91D83280, 0xC7CD9AC0, 0x24BA8F60, 0xBB1BE390, 0x8F8AED28, 0x0712096C, 0x0DBF8002, 0x6EB54003 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x18000000, 0xAC000000, 0x52000000, 0xB9000000, 0x16800000, 0x73C00000, 0x2BE00000, 0xB0700000, 0x4EB80000, 0x68C40000, 0x59060000, 0xB5810000, 0xB8408000, 0x38A14000, 0x87506000, 0x9CA83000, 0xB44D5800, 0xDADAA400, 0xC3927200, 0xE4AFAD00, 0xFB4C2780, 0xE35BF7C0, 0x59D370E0, 0xDD0E1570, 0xF69DDD88, 0x46339C0C, 0xD37E8002, 0xF3244001 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x58000000, 0x3C000000, 0xAE000000, 0xDD000000, 0xD5800000, 0xA8400000, 0xCBE00000, 0x25700000, 0x65D80000, 0xA70C0000, 0xF4660000, 0x72810000, 0x7AC18000, 0x4121C000, 0x0C51A000, 0xDD88B000, 0xB0847800, 0x0BE35C00, 0xDFE2BA00, 0x05E32B00, 0xF2E21080, 0xB86377C0, 0xEEA21AE0, 0xB982E3B0, 0x84D23A18, 0x7ADB26CC, 0x831F8002, 0x389CC003 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x48000000, 0x24000000, 0x1E000000, 0x31000000, 0x89800000, 0x53C00000, 0xC9A00000, 0xE0300000, 0xA5E80000, 0xE8040000, 0xCED60000, 0x5BC10000, 0x8DA18000, 0xEE314000, 0x6CE96000, 0x0D849000, 0xA7164800, 0xBD613C00, 0xD511E200, 0x91985300, 0x1E8DC780, 0xEAC30340, 0xB90E8860, 0x7D2DF7D0, 0x1DF37208, 0x6867AEAC, 0xC5696002, 0x2E449003 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0xE8000000, 0x34000000, 0x9E000000, 0xE1000000, 0xBE800000, 0xC3400000, 0xB0600000, 0xAC900000, 0xDFA80000, 0xEA1C0000, 0x9A0A0000, 0xCF410000, 0xD2618000, 0x9791C000, 0x66292000, 0xAADDD000, 0xFDAA6800, 0x6FF03C00, 0x4EB84200, 0x7374BD00, 0xBAB6A680, 0x097BB0C0, 0x09B9B120, 0xD0F4C350, 0x1D76F638, 0x7D5BB914, 0x96C92002, 0x740DD003 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xE8000000, 0x64000000, 0xEA000000, 0xB7000000, 0x32800000, 0xA2C00000, 0x51A00000, 0xC5500000, 0x0DE80000, 0xE0D40000, 0xB5FA0000, 0x28C10000, 0x16A08000, 0xFFD1C000, 0x7B296000, 0xB375D000, 0xA3AAC800, 0xFDA8D400, 0xE3B5EE00, 0x290BA500, 0x34792580, 0xF99DF340, 0x79FE82A0, 0x3E93AFD0, 0x98D4FFA8, 0x29FA86F4, 0x1EC16002, 0x77A1D001 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x28000000, 0x84000000, 0x92000000, 0x9B000000, 0xEC800000, 0x60C00000, 0x49E00000, 0x7FD00000, 0xBA680000, 0xFEAC0000, 0xF6160000, 0x8EC10000, 0xBCE08000, 0x26504000, 0xA3286000, 0x9E0C5000, 0xC1670800, 0x87D82400, 0xD955B600, 0x2EF39900, 0xC9CBA180, 0x28CF43C0, 0x181437A0, 0x8252F0D0, 0xF8BBBB58, 0x30D68D2C, 0xA6206002, 0x10B05001 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x58000000, 0x84000000, 0x3A000000, 0x15000000, 0xF5800000, 0xEA400000, 0x5B200000, 0xFEB00000, 0x1E780000, 0x26740000, 0x945E0000, 0x0F410000, 0x36A18000, 0xB0F04000, 0x0F58E000, 0x95C4B000, 0xFBA70800, 0xF9757400, 0xECDFAA00, 0xB480AB00, 0xCDC0B480, 0x58604640, 0x9E101560, 0x7D88F8F0, 0x07AD6EE8, 0x695AB7BC, 0x2106E002, 0x4F85B003 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xE8000000, 0x9C000000, 0xD2000000, 0x6F000000, 0x56800000, 0xEBC00000, 0x08A00000, 0x12700000, 0xFF780000, 0xCBB40000, 0xCC260000, 0xD4C10000, 0x66218000, 0x9DB1C000, 0xA1D9E000, 0x10C5D000, 0x44DF3800, 0x1F34A400, 0x70E75E00, 0xEEE06D00, 0xC991B780, 0xA3680140, 0x0F9CFCE0, 0x23DB8AF0, 0x814B7168, 0x12A2114C, 0x37FFE002, 0x0704D003 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x38000000, 0x14000000, 0xC2000000, 0x93000000, 0x34800000, 0xDDC00000, 0x37600000, 0xA2300000, 0xB8080000, 0xA8040000, 0x0CA60000, 0x46C10000, 0xCFE08000, 0xF9F14000, 0x1669E000, 0x81B47000, 0x8BEE2800, 0x55648400, 0xF197A600, 0x4C482900, 0x2324DB80, 0x49B75EC0, 0xCDD98C60, 0x4DFC0410, 0xE8CB1E08, 0xBCD3144C, 0xCC4FE002, 0x39B57001 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x58000000, 0xB4000000, 0xAE000000, 0xCF000000, 0xB0800000, 0xE3400000, 0xE6E00000, 0x14300000, 0x47580000, 0xC9540000, 0x803E0000, 0x32410000, 0x61618000, 0x63F0C000, 0x44F9E000, 0x1884B000, 0x79D76800, 0x3E0C5C00, 0xB16A1E00, 0x967EA100, 0x5520A680, 0x21903DC0, 0x8D886060, 0xDE3C82B0, 0xF833D4A8, 0x002B557C, 0xCD9FE002, 0x1C91B003 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x98000000, 0x84000000, 0x56000000, 0x4F000000, 0x39800000, 0xA3400000, 0x2CE00000, 0xB3900000, 0x90080000, 0xC25C0000, 0x31860000, 0x92410000, 0x06608000, 0x5B514000, 0x36A86000, 0xB3AD3000, 0x0CDF0800, 0x19B5AC00, 0x25CA1E00, 0xE28E3300, 0x539CA680, 0x31A6A9C0, 0x71704F20, 0x98985C10, 0x05D462B8, 0xAB9BD40C, 0x78A66002, 0x4FF03001 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x88000000, 0xF4000000, 0x62000000, 0xE3000000, 0x91800000, 0x11400000, 0xDB200000, 0xF3B00000, 0x0F180000, 0x31CC0000, 0xE2E20000, 0xA8C10000, 0x8E618000, 0xB291C000, 0xF3A92000, 0xB1551000, 0xB76FE800, 0x8183C400, 0xB6D14600, 0x68096300, 0x4924C280, 0x87978640, 0x639E1F60, 0x64BBB230, 0xFE2C2198, 0xE93240C4, 0x0448A002, 0xB684D003 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xC8000000, 0x8C000000, 0x7A000000, 0xD3000000, 0xC4800000, 0x31C00000, 0x56600000, 0x6F300000, 0xC4B80000, 0xD0EC0000, 0x7B920000, 0x4D410000, 0x43A18000, 0x5F514000, 0xFA886000, 0x47D59000, 0xA83F1800, 0xF873F400, 0x20312600, 0x42394900, 0xD62D4380, 0x2F735CC0, 0x72B15660, 0x4AF9E570, 0x6FCDB3D8, 0xF102B824, 0x27A9E002, 0x0A44D003 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x38000000, 0x5C000000, 0x4A000000, 0x5B000000, 0x7A800000, 0xE4C00000, 0x48600000, 0x36300000, 0xC1880000, 0x109C0000, 0x87A60000, 0xD2410000, 0xFEA18000, 0xC951C000, 0xAF38A000, 0x0AD47000, 0xB3DAB800, 0x96179400, 0x84883600, 0x8F1CB500, 0x8CE6A980, 0x196140C0, 0x37B12460, 0xEFC86F10, 0xD43CA338, 0x9DF73C4C, 0x33F92002, 0x3EB5B003 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xB8000000, 0xCC000000, 0x52000000, 0x3F000000, 0xBB800000, 0x00C00000, 0x13E00000, 0x76100000, 0x8A180000, 0x1A5C0000, 0x8C720000, 0x8F410000, 0xAD218000, 0x98F1C000, 0xB088E000, 0x5F057000, 0x1B0F9800, 0x0BC3A400, 0x5AE8FE00, 0x1ED53700, 0xAD772180, 0x894EB7C0, 0x9A628420, 0xB5596830, 0xEF7C4EB8, 0xA88241E4, 0xD5C96002, 0x0124B003 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x68000000, 0x2C000000, 0x6A000000, 0x2B000000, 0x9E800000, 0x51400000, 0xDAA00000, 0x97700000, 0x80D80000, 0x864C0000, 0xA24A0000, 0x45C10000, 0xB0E08000, 0xEB504000, 0x72E8E000, 0xF234D000, 0xDE765800, 0xB8D3D400, 0x97ADD600, 0xEC9BFD00, 0xC0E90280, 0xFD350540, 0x56F7E6E0, 0xB0926DB0, 0xBC8CDE98, 0xF22AB794, 0x8AD06002, 0x83289001 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x48000000, 0x24000000, 0x7A000000, 0x71000000, 0xDA800000, 0x35400000, 0xAFE00000, 0x28500000, 0x87C80000, 0x0C9C0000, 0xED960000, 0x85C10000, 0x93A08000, 0xD131C000, 0xB4D8E000, 0x67B49000, 0x46DA4800, 0x7A5FF400, 0xF15D6200, 0xF236F500, 0x7AF04A80, 0x6479AFC0, 0x390548A0, 0x67C35390, 0xF64B9F38, 0xEAB7442C, 0x12B06002, 0xAF195001 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x88000000, 0x9C000000, 0x22000000, 0x71000000, 0xC3800000, 0x60400000, 0x48A00000, 0x7E700000, 0xE8C80000, 0x9EA40000, 0xAC220000, 0x99C10000, 0x5DE18000, 0x1350C000, 0x01F96000, 0xBA4D1000, 0x20373800, 0x654B4400, 0xBE946200, 0x9F4AC700, 0xAB946080, 0x0ACB6140, 0xB4D514E0, 0x5AEA4D90, 0x84654B48, 0x7B43E544, 0x3D50E002, 0xCAF9D003 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xE8000000, 0x7C000000, 0xCA000000, 0xD7000000, 0xBD800000, 0x5E400000, 0x8B200000, 0xB2700000, 0xDF580000, 0xE0A40000, 0xC7560000, 0x95C10000, 0xE8608000, 0x63D0C000, 0x36E8A000, 0x7E9DD000, 0xA8A2F800, 0x22BE9400, 0x28DC2E00, 0x4F833B00, 0xD2CFDC80, 0x0C85E640, 0x30A60CE0, 0xE0D9B2B0, 0x65E40B48, 0xE3F6B3AC, 0x6AF02002, 0x5F991001 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x68000000, 0x0C000000, 0xF2000000, 0x7D000000, 0x71800000, 0xF2400000, 0x01600000, 0x45B00000, 0xB0C80000, 0x8FE40000, 0x2FCA0000, 0xADC10000, 0xD4218000, 0xE4514000, 0xD4B8A000, 0xD90CD000, 0x997E1800, 0x7732E400, 0x3AAC7A00, 0xA46E2300, 0xF06B0480, 0xFAD0F2C0, 0x1A788360, 0xC3AD7D90, 0x1BEE71C8, 0x152B8E94, 0xC3312002, 0x4A099003 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xE8000000, 0x44000000, 0x42000000, 0x7B000000, 0x9E800000, 0x4B400000, 0x5DA00000, 0x55500000, 0xAF980000, 0x09740000, 0x0C9A0000, 0xBBC10000, 0xABE18000, 0x4F71C000, 0xA409E000, 0xC68DD000, 0x025E8800, 0x52338400, 0x989C7600, 0xD0677D00, 0x1E17B680, 0x239E0B40, 0xCED2B2A0, 0xBF6DF330, 0xEE2E10E8, 0x24BBAA34, 0xE3506002, 0x5E981003 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x38000000, 0xD4000000, 0xFA000000, 0xF9000000, 0x6D800000, 0xA3C00000, 0x0D200000, 0xB0900000, 0x33880000, 0xC7BC0000, 0x9A820000, 0x87410000, 0x1B618000, 0x1A704000, 0xBC39E000, 0x51A47000, 0x2D37A800, 0x7ABEF400, 0x9F037200, 0xF8801B00, 0x20416780, 0x8DE1CA40, 0xD9315920, 0x75584B10, 0x8ED42178, 0x1A8FE804, 0x67DA6002, 0x05953003 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xC8000000, 0xD4000000, 0x26000000, 0x35000000, 0x4E800000, 0x5D400000, 0xE7E00000, 0x1EF00000, 0x9E480000, 0x93E40000, 0x12120000, 0x7EC10000, 0xA8208000, 0xB651C000, 0x64582000, 0xA0DD9000, 0xD87FA800, 0x63974C00, 0x08E3EA00, 0xAE88DD00, 0x2AC5DA80, 0x14C3BFC0, 0x6ED925E0, 0x539DC890, 0x3E9F69C8, 0x05E7BF24, 0x36EAA002, 0x400D5001 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x18000000, 0xE4000000, 0x72000000, 0xA1000000, 0xD7800000, 0x67C00000, 0xE8600000, 0x40900000, 0xC6680000, 0x18A40000, 0xF6B60000, 0xC5410000, 0x82218000, 0xE2314000, 0xE719A000, 0xD69C3000, 0x209BC800, 0x0883E400, 0x8E9FC200, 0xA5446F00, 0x78E7AF80, 0x60C800C0, 0xFBD55920, 0xF18FD0D0, 0xE8ECFF48, 0xA622546C, 0x31EE2002, 0xE47C7003 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0xB8000000, 0xFC000000, 0x3A000000, 0xDD000000, 0x06800000, 0xF1400000, 0xF9A00000, 0x8D900000, 0x31780000, 0xA3EC0000, 0x4A9E0000, 0x5EC10000, 0x60608000, 0xC671C000, 0x08C8A000, 0xB7C57000, 0xF76BF800, 0x0E437400, 0x1D363A00, 0x18F44D00, 0x0A020280, 0x0616E340, 0x1224B320, 0xCDDBDEF0, 0xB7EB11D8, 0x5803063C, 0xDF162002, 0x32A5B001 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xF8000000, 0x64000000, 0x2E000000, 0x3D000000, 0x8E800000, 0x01400000, 0xFAA00000, 0x36F00000, 0x18D80000, 0xCFCC0000, 0x99CA0000, 0x7CC10000, 0xD8608000, 0xDB90C000, 0x61C9A000, 0xCD45F000, 0x212EC800, 0x929F5C00, 0xCEE7FA00, 0x92DA5D00, 0x2948E280, 0x4D05E540, 0xAF0E35E0, 0x9E2FF5B0, 0x031F0198, 0xAE278094, 0x40BB2002, 0x81D83001 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xA8000000, 0xB4000000, 0xF2000000, 0x59000000, 0x83800000, 0x87C00000, 0xA6A00000, 0xA9700000, 0x06D80000, 0xA91C0000, 0xCC360000, 0x87410000, 0x0FE08000, 0x1991C000, 0xC7C82000, 0x8B955000, 0xF9436800, 0xB012E400, 0x1DFB3200, 0xD85F4700, 0x78256F80, 0x30BB7D40, 0x82BF8AE0, 0x0C3471B0, 0x6FB37C38, 0x870A416C, 0x0146A002, 0x7B999001 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xD8000000, 0x34000000, 0x26000000, 0x75000000, 0x50800000, 0x72400000, 0xC0A00000, 0x12700000, 0x9AC80000, 0xBD740000, 0x714E0000, 0xA8A10000, 0xBE708000, 0xE8C8C000, 0xDE746000, 0x8CCFB000, 0xBE616800, 0x2A90CC00, 0x4F182A00, 0x064CC100, 0xD9335480, 0xB2FAE940, 0xE10FE8E0, 0xC3009F90, 0xED81FBE8, 0x9EC1161C, 0x48E16802, 0x6DD0CC01 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x38000000, 0xFC000000, 0x1A000000, 0xF7000000, 0xDB800000, 0xAA400000, 0x7A200000, 0x9E900000, 0xD8580000, 0xA14C0000, 0x396A0000, 0xC6210000, 0xE4918000, 0xBF594000, 0x72CC6000, 0x572A7000, 0x5A00F800, 0x9701B400, 0x4B80AE00, 0xA241D700, 0xBE212480, 0x78910C40, 0x35590920, 0x8DCC5EB0, 0x48AAF598, 0x16402654, 0x0020F802, 0xF991B403 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x18000000, 0xCC000000, 0xA2000000, 0xFB000000, 0xAE800000, 0xF5C00000, 0x48A00000, 0x9D300000, 0x47480000, 0x2C840000, 0xF9560000, 0xF4A10000, 0xD7318000, 0x58494000, 0x64052000, 0x81963000, 0x87809800, 0x4840C400, 0xF7E0B600, 0xC6507D00, 0x1FD9DB80, 0xCD7D0940, 0x90DA7E60, 0xC9927890, 0x54178408, 0x1CC1D92C, 0x55209802, 0xB270C403 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x58000000, 0xFC000000, 0x5E000000, 0x89000000, 0x97800000, 0x9CC00000, 0x0B600000, 0x8DD00000, 0xDDC80000, 0x21840000, 0xF2A60000, 0x2F610000, 0xEFD18000, 0xAAC94000, 0x0F046000, 0xA1E6B000, 0x44C0F800, 0x37613C00, 0x73D05200, 0x64C94F00, 0xEE058980, 0x9267EEC0, 0x7A00A7A0, 0xEB012990, 0xE0802C08, 0xB240BCCC, 0x5820F802, 0xE6713C03 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x68000000, 0x44000000, 0x6A000000, 0x1B000000, 0x42800000, 0x03400000, 0x0EA00000, 0x72D00000, 0x80380000, 0x5B4C0000, 0xE3C20000, 0x82A10000, 0x8CD08000, 0x0938C000, 0xDECDE000, 0xE402D000, 0xBA418800, 0xC3205400, 0xA110F600, 0x4AD96500, 0x23BCD680, 0x276A9540, 0x64F531A0, 0x1C4FB670, 0xA703F398, 0xF4C1A104, 0x7E618802, 0x46B05401 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xA8000000, 0x84000000, 0x4A000000, 0xFD000000, 0xE8800000, 0x34400000, 0x26A00000, 0x03100000, 0x64480000, 0xF4F40000, 0x71D20000, 0x88A10000, 0x84108000, 0xA9C94000, 0xD435A000, 0x05335000, 0x9E100800, 0xBCC81400, 0x18B4BA00, 0xAB727100, 0xEDB03880, 0xD359C540, 0x02BDD220, 0x84269290, 0x77F268E8, 0x0BF00324, 0x54F80802, 0x5F2C1401 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x68000000, 0x54000000, 0x42000000, 0xCB000000, 0xF9800000, 0x23400000, 0x90600000, 0xF3500000, 0x33F80000, 0x210C0000, 0xD6860000, 0x16610000, 0xA2508000, 0xDD79C000, 0x1DCDE000, 0x84A6D000, 0x13D1A800, 0xFA380400, 0xB7AC5600, 0x70F61300, 0xA7A99680, 0x257508C0, 0x81CAA2A0, 0x840711F0, 0x7CA0E118, 0x9970038C, 0x1A49A802, 0xF7640401 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xA8000000, 0x24000000, 0x4E000000, 0x9D000000, 0x80800000, 0x44400000, 0x9D200000, 0x72700000, 0x10180000, 0x7C840000, 0x9D4A0000, 0x6F210000, 0xED718000, 0xC7994000, 0xDB456000, 0xF1AB5000, 0x60B14800, 0x18791C00, 0xD9547A00, 0xD8626100, 0x2B1CD880, 0x9E0EF240, 0xB28A38E0, 0x57C0FA30, 0xA4E06808, 0x3B91DA14, 0xA3094802, 0x0FCD1C03 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x98000000, 0x74000000, 0x1E000000, 0xBD000000, 0x33800000, 0x36C00000, 0xAE600000, 0x20500000, 0xE8080000, 0x66E40000, 0x7BF20000, 0xD3610000, 0x33D08000, 0x6EC8C000, 0x8085A000, 0xB7A33000, 0x5169E800, 0xF634BC00, 0x9BBBBA00, 0x56A4C700, 0x1CD3DD80, 0xB19074C0, 0xBEE95CA0, 0xA2F55A10, 0x1ADBE2C8, 0x42749664, 0xCA9BE802, 0xB555BC01 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xA8000000, 0x7C000000, 0x62000000, 0x97000000, 0x13800000, 0x86400000, 0xDEE00000, 0xD7900000, 0xD8180000, 0x037C0000, 0x5A860000, 0x81E10000, 0xE8108000, 0x84594000, 0x2E9D6000, 0x28975000, 0x56B9F800, 0xD30C4400, 0x0B8E6E00, 0x3C444700, 0x4CCADC80, 0x590F05C0, 0x70858B20, 0x4AEA0E30, 0x36BFF9F8, 0x822CCD8C, 0x97BFF802, 0x58AD4401 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x38000000, 0xFC000000, 0x8A000000, 0x1F000000, 0x0D800000, 0xE3C00000, 0xEDE00000, 0xB0500000, 0xF9480000, 0xCA540000, 0xFC020000, 0x8EE10000, 0xF7D18000, 0x6588C000, 0x9A356000, 0x97927000, 0x6648F800, 0x07D49400, 0x7FC2FE00, 0xD3007B00, 0x7F803780, 0x60C0E3C0, 0xDA6114A0, 0x7491BC90, 0xE52877A8, 0x13C52B84, 0xF7AAF802, 0xF9659403 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xC8000000, 0xB4000000, 0x2E000000, 0xE9000000, 0xFF800000, 0x94C00000, 0xACE00000, 0x6B900000, 0xD4280000, 0xBC5C0000, 0xA5760000, 0x59E10000, 0xDE108000, 0xAFE9C000, 0x223D2000, 0x43A79000, 0xE8E86800, 0x74BCDC00, 0xC8E61200, 0x40C9DF00, 0x7BCC3980, 0xC35FF1C0, 0x06BCAB20, 0x8BE76A50, 0xC0492FB8, 0x158D9F6C, 0x56FE6802, 0x260DDC01 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x08000000, 0x6C000000, 0xF6000000, 0x31000000, 0xDB800000, 0xAAC00000, 0x3EA00000, 0x28100000, 0x3CD80000, 0x5F7C0000, 0xC69E0000, 0x01A10000, 0xD6908000, 0xEF99C000, 0xB81DA000, 0xA8AE1000, 0xCF29D800, 0x3DD56C00, 0x208BA200, 0x240B1700, 0xA04AC580, 0x45AAE540, 0xE6DA5C20, 0x4233EBB0, 0xE2C621F8, 0x149C1CBC, 0x70EFD802, 0x04C86C01 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x08000000, 0x5C000000, 0x72000000, 0xF1000000, 0x79800000, 0x94400000, 0xFEE00000, 0x65100000, 0x45080000, 0x50CC0000, 0x4B960000, 0x09E10000, 0x33918000, 0x13C8C000, 0xB6ECA000, 0x1BA61000, 0x9C59B800, 0x47256400, 0x344B2200, 0xF27F5300, 0x353DB880, 0x208E05C0, 0xA8A54E20, 0xE70A5810, 0xC21F3A98, 0x32EDC3AC, 0xFDA7B802, 0x23586403 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x28000000, 0x4C000000, 0xA6000000, 0x37000000, 0xF0800000, 0x1F400000, 0x16200000, 0x3FD00000, 0x23980000, 0xB22C0000, 0xB4760000, 0x33210000, 0x0A508000, 0x19584000, 0xE6CCE000, 0xCB465000, 0xAD899800, 0xFBD5CC00, 0x3D2A2E00, 0x295E0100, 0xF765EE80, 0xBE427440, 0x04BA93A0, 0xA7671930, 0x3B598D58, 0x2BCCA26C, 0xD2C79802, 0x6148CC01 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xE8000000, 0x9C000000, 0x42000000, 0xD9000000, 0xE6800000, 0xE2C00000, 0x5BA00000, 0xED300000, 0x96580000, 0xCA2C0000, 0xD8860000, 0xE5210000, 0x6BF08000, 0x9BF8C000, 0x701CA000, 0xDB5FD000, 0x6E4C3800, 0xAE960400, 0xF3887200, 0xDDA5ED00, 0x1322D580, 0xC1022F40, 0x6F730E60, 0x5DCAE6B0, 0xAC373D58, 0xB839F68C, 0xC93CB802, 0xD2AEC401 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x38000000, 0x2C000000, 0x4E000000, 0xA5000000, 0xF7800000, 0x24C00000, 0x7CE00000, 0x72300000, 0x19880000, 0x096C0000, 0x489A0000, 0x27610000, 0xD8F18000, 0x2069C000, 0xBCDC6000, 0x4DD27000, 0x7EED5800, 0xAC5B1C00, 0xBB818A00, 0x9AC00F00, 0x01E1F980, 0x99B0C1C0, 0x4B480860, 0xFC8D2110, 0x832B61D8, 0xBF2892B4, 0x5AFCD802, 0x3E02DC03 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0xC8000000, 0xD4000000, 0x46000000, 0x0F000000, 0xD7800000, 0xB7400000, 0x97A00000, 0xB5B00000, 0xFCB80000, 0x3D8C0000, 0xD5C60000, 0x34210000, 0x94F18000, 0xBC19C000, 0xB3BDE000, 0xC43F9000, 0x030CA800, 0x6A070C00, 0x1B40DE00, 0xEDA1CF00, 0x38B13E80, 0x5A396740, 0x4E4C7760, 0xB0A64F70, 0xE8705818, 0x92D95B0C, 0xA85D2802, 0x87AECC03 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x68000000, 0x24000000, 0x42000000, 0x1B000000, 0xF2800000, 0x2DC00000, 0x38E00000, 0xD0D00000, 0x4FD80000, 0x4DE40000, 0x44B20000, 0xC6610000, 0xBB118000, 0x1E39C000, 0xCCB5A000, 0x982AD000, 0xF8A54800, 0x4E930400, 0xAED0F600, 0xAAD9C500, 0x9A654B80, 0x5EF399C0, 0x34C0F5A0, 0xF16161B0, 0x3F903AC8, 0xE2F944E4, 0xE9D4C802, 0xBDBAC403 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xC8000000, 0xBC000000, 0x96000000, 0x15000000, 0x66800000, 0x03C00000, 0xCCE00000, 0xBFB00000, 0x28780000, 0xB6B40000, 0x840E0000, 0xDC610000, 0x39708000, 0x9A184000, 0x8EC5E000, 0x82979000, 0xEA647800, 0x7087AC00, 0x808D6A00, 0x9A1BAD00, 0xB47ED780, 0x06F881C0, 0x49750360, 0xFEEEA2F0, 0x86D1FC68, 0xBF894D9C, 0x936CF802, 0x502BEC01 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x18000000, 0x7C000000, 0xBA000000, 0x39000000, 0x15800000, 0x2E400000, 0x1F600000, 0x76B00000, 0xF6680000, 0xA9340000, 0x1C320000, 0x80E10000, 0x19F08000, 0x50884000, 0xA3C5E000, 0xA83A3000, 0x8CE5F800, 0x5EEBF400, 0x4ABD3200, 0xEB774B00, 0xBF1B2C80, 0xF634A6C0, 0x3AB36960, 0xBA21C6D0, 0xB1515D68, 0xB5189EE4, 0x797D7802, 0x2E57B401 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xE8000000, 0x24000000, 0x8A000000, 0xDF000000, 0x6E800000, 0x86400000, 0x2DA00000, 0xD5300000, 0xB4580000, 0xEEBC0000, 0x297A0000, 0x91210000, 0x70708000, 0xC178C000, 0x34CC2000, 0x4703D000, 0x336D4800, 0x7D339400, 0x71B47E00, 0xC9CE7D00, 0x336F1C80, 0xFCDFB340, 0xCCC62E60, 0xE4DBFEB0, 0x1410A478, 0x4C291874, 0x1BC5C802, 0x7FB75401 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x08000000, 0x14000000, 0xFA000000, 0xF3000000, 0x6A800000, 0xFAC00000, 0xC4600000, 0xD1B00000, 0x7C680000, 0x89340000, 0xCB120000, 0xC8E10000, 0x76708000, 0x3B89C000, 0x6BC4A000, 0xEB5A1000, 0xBAC52800, 0x2EDB7400, 0x24852600, 0x497AF500, 0xA0D52580, 0x60E380C0, 0x91288760, 0xC41516D0, 0x5583E368, 0x75180DA4, 0x9E3DA802, 0xF716B401 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x38000000, 0x4C000000, 0x6A000000, 0xF3000000, 0x96800000, 0x12C00000, 0x93E00000, 0xAA300000, 0xD0F80000, 0x00340000, 0x818A0000, 0x0B610000, 0x35F08000, 0xF0984000, 0x5F45A000, 0xC1D27000, 0x90C59800, 0xD6925400, 0x7764A600, 0x15820D00, 0xEA4D1580, 0x497E9FC0, 0x220AB060, 0xA620FFF0, 0x19514968, 0xE909B894, 0xBAAD1802, 0xFDCE1401 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x88000000, 0xCC000000, 0xB6000000, 0xEF000000, 0xDA800000, 0x2FC00000, 0x85200000, 0x9BF00000, 0xB3D80000, 0x35340000, 0x40D60000, 0x30A10000, 0xAEB18000, 0x39384000, 0xFBE5A000, 0xE0FF1000, 0x7A4C9800, 0x6D52EC00, 0xA64E9E00, 0xBF749500, 0x58B68F80, 0x3DB07240, 0xEDB96BE0, 0x8F2471B0, 0x9D5E8B68, 0xD37C7C2C, 0x142B1802, 0xA4CBAC03 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x58000000, 0xEC000000, 0x2A000000, 0xA9000000, 0x95800000, 0x1EC00000, 0xE6A00000, 0x89700000, 0x43680000, 0xE1F40000, 0x50AE0000, 0xAA210000, 0x4A308000, 0xAF094000, 0x1824A000, 0x41B6B000, 0xD83CD800, 0x5A2AD400, 0x04E71200, 0x02640B00, 0x70574D80, 0x2B2CF540, 0x3B93D6E0, 0x248AFCD0, 0x819644E8, 0x9B0DEADC, 0x30A25802, 0x5A029401 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x98000000, 0xBC000000, 0x66000000, 0xB3000000, 0x14800000, 0x04C00000, 0xA8600000, 0x91500000, 0xFBF80000, 0x5DA40000, 0x7A4A0000, 0xF3E10000, 0xC7118000, 0x7459C000, 0x9814E000, 0x30233000, 0x27DC7800, 0xA4AF4C00, 0xA18BA600, 0xE1004900, 0x55817980, 0x014108C0, 0xA1203EA0, 0x6470D9F0, 0xDD892648, 0xE92D5714, 0x52E7F802, 0x02478C03 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xC8000000, 0x6C000000, 0x0E000000, 0x85000000, 0x6F800000, 0x85400000, 0x59E00000, 0x16100000, 0xDDA80000, 0x81740000, 0x510E0000, 0x97610000, 0xDED08000, 0xAA084000, 0xB4052000, 0xB8779000, 0x7B1DD800, 0x4F5A9C00, 0x22DE4A00, 0xCEE87F00, 0x99945A80, 0xFA9F0BC0, 0x1C898020, 0x48C57950, 0x65D759E8, 0xA96C9E9C, 0x42A35802, 0xA163DC01 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xF8000000, 0x14000000, 0x86000000, 0x27000000, 0xDC800000, 0x7BC00000, 0x7A200000, 0xE7300000, 0x2CD80000, 0xB1E40000, 0x71CE0000, 0x27A10000, 0x57718000, 0xA9B94000, 0xB335E000, 0xBE07F000, 0x6EAD2800, 0xE1028C00, 0x12F20E00, 0x148AD900, 0xFB9EC780, 0x75A8FC40, 0x135C1260, 0x2C7B6FB0, 0xB366EEC8, 0x407C0E1C, 0x1CCAA802, 0x0AFECC03 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x78000000, 0x9C000000, 0x32000000, 0x21000000, 0x2D800000, 0x82C00000, 0x1F200000, 0xFC300000, 0x18080000, 0x50F40000, 0x4BB60000, 0x51A10000, 0x4A708000, 0x5468C000, 0xF325E000, 0xE9AEF000, 0x54EC3800, 0xF9FAE400, 0x20AB8200, 0x72F23B00, 0x3CDEB580, 0xF605A640, 0x009ECC60, 0x27659A10, 0x2CCE36E8, 0xAEBDBCEC, 0xFF22B802, 0xCDC72401 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x18000000, 0xE4000000, 0xA6000000, 0xBB000000, 0xD3800000, 0x29400000, 0x14200000, 0xD7D00000, 0x46080000, 0x0F540000, 0x41DA0000, 0x32A10000, 0x4A108000, 0xBAE8C000, 0xD0E46000, 0x50A23000, 0x14ECC800, 0x62F7CC00, 0x6DB6B600, 0x82964700, 0xE6C72280, 0xB98EC040, 0xBAFBF3A0, 0xC8F12210, 0x1A592DA8, 0xE41DB334, 0xCCAE4802, 0x07AA0C01 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x08000000, 0x44000000, 0x72000000, 0xBD000000, 0x8D800000, 0x02C00000, 0x66E00000, 0xDB100000, 0xDB880000, 0xB99C0000, 0x78A20000, 0xF0610000, 0x23508000, 0x2329C000, 0x4D2DE000, 0xDB1A1000, 0x5B058800, 0x1FB66400, 0x10DFBA00, 0x6F537B00, 0x51F85580, 0xE2C4E5C0, 0x93D76220, 0xAD8EB510, 0xD77B9438, 0xA655A2C4, 0x479F0802, 0x1772A401 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x08000000, 0xA4000000, 0x0E000000, 0xFF000000, 0xC0800000, 0x54C00000, 0x4BE00000, 0x57D00000, 0x2E080000, 0xD6040000, 0x4A260000, 0x16610000, 0xB6908000, 0xD0A8C000, 0x19756000, 0x405E1000, 0x0C9C4800, 0xE98A9C00, 0x1CB23E00, 0x9FEF6100, 0xB305F980, 0x33A6FFC0, 0xB92003A0, 0xD7311A10, 0x6F59A908, 0x4FCDF7CC, 0xB542C802, 0x0A575C01 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x28000000, 0x24000000, 0xB6000000, 0x63000000, 0x69800000, 0x3A400000, 0x06600000, 0xA6700000, 0x24680000, 0x910C0000, 0x907E0000, 0x4C210000, 0xC8108000, 0x4619C000, 0xF365E000, 0x4A725000, 0x91DF4800, 0x0870EC00, 0xEB698600, 0x7A8CF300, 0xA73FC480, 0x4CC114C0, 0xAFA0E8E0, 0x8B5022D0, 0xC8F8D718, 0x0BD5D77C, 0x54BAA802, 0x6102BC01 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xA8000000, 0x94000000, 0x1A000000, 0x5B000000, 0x13800000, 0x06C00000, 0x7FA00000, 0xAFD00000, 0xB9880000, 0x67D40000, 0x1A960000, 0x51610000, 0x04708000, 0x6C58C000, 0xF55CE000, 0xC6C35000, 0xD9362800, 0x30B1B400, 0x9CF8F600, 0x330C0700, 0x528BBD80, 0x7AC38740, 0x1737C3A0, 0x11B0B110, 0xA478FEA8, 0x8E4D6FAC, 0xBFEAC802, 0xB0B2E401 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xE8000000, 0x74000000, 0x0A000000, 0x45000000, 0xC7800000, 0xA6400000, 0xAFE00000, 0xF5100000, 0x52E80000, 0xB7A40000, 0x93DA0000, 0x51A10000, 0x16F18000, 0x11F84000, 0xCE4C2000, 0x44FFD000, 0x92BBE800, 0x83709400, 0xBEB94A00, 0x102DEF00, 0x3CAEBC80, 0x0F3367C0, 0x91059620, 0xBBABFBD0, 0x4F990A48, 0x761D9434, 0xF977C802, 0x90CF4403 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x68000000, 0xA4000000, 0x4E000000, 0x01000000, 0xDA800000, 0x89400000, 0x14200000, 0x90B00000, 0xAFF80000, 0x823C0000, 0xB10A0000, 0x89610000, 0x82918000, 0x8A49C000, 0x2145E000, 0x7776D000, 0x1CCA4800, 0x5D001C00, 0x68804200, 0xEA419500, 0xD5A02280, 0xE471B040, 0x4D18F560, 0x1B6DC1F0, 0x1222B378, 0xFAB4C594, 0x07AFA802, 0x8BC6CC03 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0x44000000, 0xE6000000, 0x3D000000, 0x22800000, 0xEEC00000, 0x3B600000, 0xEB300000, 0xFB180000, 0x0E7C0000, 0x8BCA0000, 0xEBA10000, 0xF9508000, 0x8CA8C000, 0x72A42000, 0x42567000, 0x1C9B8800, 0x16084C00, 0x43743A00, 0x973EA500, 0xD0DE8D80, 0xEC2F0EC0, 0x88D7D260, 0xAE5B2030, 0xFF6933F8, 0x5B441714, 0x0FA7A802, 0xB0E23C01 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xA8000000, 0xEC000000, 0xA2000000, 0x91000000, 0xE7800000, 0x24400000, 0xF2A00000, 0xAD900000, 0xE8E80000, 0xDE540000, 0x58220000, 0x8CE10000, 0x4A318000, 0xCCF84000, 0xF1FDA000, 0xAA575000, 0x5692D800, 0x5AD9C400, 0x96ACE200, 0xC7DE2F00, 0xC5B7B880, 0xC223ED40, 0xB9E10720, 0x13B1D7D0, 0xA3B9E1A8, 0x31DC1FC4, 0x8A077802, 0x5B9A9403 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x78000000, 0x2C000000, 0x36000000, 0xA5000000, 0xE6800000, 0x62C00000, 0xCDA00000, 0xE1B00000, 0xE9380000, 0xC16C0000, 0xD1460000, 0x15610000, 0x0F108000, 0x13084000, 0x7015E000, 0xF14AF000, 0x61375800, 0xC279EC00, 0xF38D8A00, 0x58166D00, 0xC608D580, 0xAE95B340, 0x9F8BB760, 0x6A961470, 0xFEC875D8, 0xD034320C, 0xCDBAB802, 0x7FEF1C01 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xE8000000, 0x4C000000, 0x36000000, 0x7B000000, 0x0A800000, 0x25400000, 0xCD600000, 0xFA100000, 0xE1380000, 0x69C40000, 0x244E0000, 0x8A210000, 0x0E708000, 0x18A9C000, 0x363D2000, 0x0A2BD000, 0x81DF9800, 0x4BD9EC00, 0xF715B600, 0xBFD6F500, 0xC5D5BA80, 0x6E7652C0, 0xE165C020, 0xD37EF870, 0x81E92088, 0xF55D2F1C, 0xCF3AB802, 0x80663C01 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x68000000, 0x24000000, 0xCE000000, 0x8B000000, 0x5C800000, 0x92C00000, 0x49E00000, 0x45900000, 0x45780000, 0xB64C0000, 0xFF3E0000, 0xD0210000, 0x10F08000, 0xB2284000, 0x0AD56000, 0x64E2D000, 0x4E674800, 0xB89C1C00, 0xD6E7D600, 0x345C9900, 0xEC061580, 0xD14D4BC0, 0xB9BEBF20, 0x4FE190F0, 0x1A916B98, 0x9FF96EFC, 0x3B8C2802, 0x4C5FCC01 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xF8000000, 0x34000000, 0x26000000, 0x5D000000, 0x72800000, 0x1F400000, 0xB7E00000, 0x94100000, 0x5F780000, 0xA0940000, 0xDF260000, 0x51A10000, 0x4F718000, 0x9D284000, 0x0C8C2000, 0x51E3F000, 0x209F6800, 0x1314CC00, 0xB8E77A00, 0x86018500, 0x8D006E80, 0xAA80B7C0, 0x3B412C20, 0x69E1B8F0, 0xFD117628, 0x0BF929CC, 0xE2D54802, 0x1A463C03 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x38000000, 0xD4000000, 0xC6000000, 0xAF000000, 0x50800000, 0xD4C00000, 0x4D200000, 0xFBB00000, 0x49A80000, 0xAEFC0000, 0x0F160000, 0x12E10000, 0x68118000, 0x95D9C000, 0x80F4A000, 0x0B9A7000, 0xF4FEA800, 0xC2FD0C00, 0xDD171E00, 0x9BE0C100, 0xC790F980, 0x29988240, 0xCD157360, 0x7B0A3150, 0xE9E60AF8, 0x75281AAC, 0xA83C0802, 0xCB367C03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x18000000, 0x7C000000, 0xDE000000, 0xB3000000, 0x76800000, 0xD3400000, 0x43600000, 0x42100000, 0x08180000, 0x35640000, 0xD01A0000, 0xA7210000, 0x05F18000, 0xFC494000, 0x6F9D6000, 0xB8AE3000, 0xFE03F800, 0x8D453C00, 0x756BA600, 0xEF29CD00, 0xE58D7680, 0xC4B70EC0, 0xC167A020, 0x545E7A30, 0xB5CAD9C8, 0x2219F7B4, 0x4C649802, 0x0F9A0C03 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xA8000000, 0xC4000000, 0xFA000000, 0x77000000, 0xE7800000, 0x64C00000, 0x5C200000, 0x71300000, 0x7B280000, 0xCB5C0000, 0xE3320000, 0x75E10000, 0x5D908000, 0x19594000, 0x10946000, 0x697F5000, 0xA2CA8800, 0x15047400, 0xFC272E00, 0x1C5FEF00, 0x697A7980, 0xA26CA040, 0xB41B3E60, 0x20BC9C50, 0x03A28FB8, 0x5439ACE4, 0x0A44E802, 0xB2C62401 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x28000000, 0x74000000, 0x8A000000, 0xFB000000, 0x9C800000, 0x59400000, 0x52E00000, 0x44900000, 0x67580000, 0xC8B40000, 0xDE9E0000, 0xC2A10000, 0x4DF18000, 0x68094000, 0x2D4DA000, 0x3BDA5000, 0x0437E800, 0x5A1D9400, 0x42233600, 0xBF72D900, 0x3D8BC280, 0x1A4FDDC0, 0x24991520, 0x2E151CB0, 0xF16F0668, 0x85A93ABC, 0xA63C4802, 0xD992C403 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xE8000000, 0x44000000, 0xB2000000, 0x0F000000, 0xCD800000, 0x66400000, 0xFBA00000, 0x2F500000, 0x7FA80000, 0xC3A40000, 0x56F60000, 0xFCE10000, 0xF8718000, 0xDA38C000, 0xAD6CA000, 0xFB63D000, 0x538F8800, 0x7AADE400, 0xB8835E00, 0x1E7EFB00, 0x0AD53C80, 0x484FEF40, 0x9F4CD2A0, 0xA0737550, 0xE8869A48, 0xE3D8366C, 0x5B9D2802, 0x2C9B3403 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x38000000, 0xCC000000, 0x06000000, 0xC1000000, 0xF6800000, 0x21400000, 0x2FA00000, 0x7EB00000, 0x07180000, 0x67AC0000, 0x65060000, 0xC8610000, 0x28508000, 0x4A084000, 0xD005E000, 0x30B27000, 0xF64A9800, 0x63778C00, 0xB2184200, 0x1B2CCD00, 0xA3479280, 0x20415740, 0xB9219960, 0x8FF05830, 0xE0B94C58, 0xED1C978C, 0xA81FF802, 0x68CDBC01 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x38000000, 0x5C000000, 0xC6000000, 0xCB000000, 0xA1800000, 0xFBC00000, 0xB7200000, 0xB4700000, 0x45380000, 0x1BEC0000, 0xAC6A0000, 0xBD610000, 0x70908000, 0x02684000, 0x80A5E000, 0xC7BE7000, 0x3C67B800, 0xFDDA0C00, 0x48785600, 0x508C6300, 0x4FFA2780, 0x92894640, 0x05F4ACE0, 0xDDF66870, 0x33338ED8, 0x899D8A54, 0xB252D802, 0xEF0C3C01 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xE8000000, 0xEC000000, 0x9A000000, 0x97000000, 0xFE800000, 0x4E400000, 0x33E00000, 0xF8900000, 0xA9B80000, 0x7D4C0000, 0x42F60000, 0x4B210000, 0xB9308000, 0xB0C94000, 0xC7652000, 0x1A83D000, 0x41DAD800, 0xE786B400, 0x6309EE00, 0xAA451D00, 0xA6B32C80, 0x44924FC0, 0x72234D20, 0x972A5170, 0xA86EFD98, 0x535CFA6C, 0xA90F7802, 0xAF8C2401 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x98000000, 0x34000000, 0x72000000, 0xD9000000, 0x2B800000, 0x1DC00000, 0x03200000, 0x47D00000, 0xB1180000, 0x3AD40000, 0x365E0000, 0x71610000, 0x73318000, 0x38E84000, 0x659DE000, 0xE1533000, 0x614B6800, 0x1C1E6400, 0x51817200, 0x78C07700, 0x26A0AB80, 0xAD10BE40, 0x9EB933A0, 0xD4445C30, 0x192774A8, 0xE004B23C, 0x86C70802, 0x9B751403 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x98000000, 0x7C000000, 0xEE000000, 0x03000000, 0xE4800000, 0x1D400000, 0x71200000, 0x16900000, 0x2E580000, 0xC1D40000, 0xD2FA0000, 0xECE10000, 0x28F18000, 0x44E9C000, 0xCE9DA000, 0x5CB73000, 0xEFAFF800, 0x9F5B5C00, 0xBB314600, 0xA9882900, 0xD8AD6A80, 0x32BE8A40, 0xFEC33920, 0x8985FEB0, 0xC643D0A8, 0x8AC53074, 0x1C63D802, 0x4CD5AC03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x78000000, 0x8C000000, 0x7A000000, 0x4D000000, 0x3B800000, 0x0CC00000, 0xDB200000, 0xACD00000, 0x22180000, 0xA5340000, 0xB8560000, 0xEA610000, 0x54318000, 0xBF694000, 0xAEBD6000, 0x519AF000, 0x4D721800, 0xB30E7400, 0x2BB55A00, 0xC317D700, 0xE781C980, 0xDEC0BE40, 0x722105A0, 0xA9505230, 0xEDD9A368, 0xFE949C2C, 0x14C6F802, 0x6919C403 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x08000000, 0x8C000000, 0x22000000, 0x5D000000, 0x62800000, 0x7FC00000, 0x9CA00000, 0xBD700000, 0x55980000, 0xEC5C0000, 0x76560000, 0x3CE10000, 0x8C918000, 0x6388C000, 0x6414E000, 0x58E21000, 0x22721800, 0x6AFAC400, 0x876EFA00, 0x49CC6500, 0x115F4F80, 0xB4351140, 0x255356E0, 0xB4CA9D30, 0x56969BB8, 0x4FC0782C, 0x34A17802, 0x21711403 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x58000000, 0xDC000000, 0x6E000000, 0x6B000000, 0x50800000, 0x12C00000, 0x10200000, 0x89300000, 0x3F380000, 0x4C340000, 0xC98A0000, 0xA9610000, 0x43518000, 0x08E8C000, 0x941C2000, 0x00B6B000, 0x9F66B800, 0x134E5C00, 0x50729600, 0xAF74C100, 0xF2EBF580, 0x5F30C840, 0x58396660, 0x4AB5BC70, 0x7C4BAB68, 0xDFC0AD94, 0x6FA11802, 0x19712C03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xB8000000, 0x4C000000, 0xE2000000, 0xA7000000, 0x53800000, 0x43C00000, 0xA2E00000, 0x07D00000, 0x9E080000, 0x14AC0000, 0x285A0000, 0x85A10000, 0x1D718000, 0x5CF94000, 0x4994E000, 0x142F7000, 0x7DDF9800, 0xF1674400, 0xF9D28E00, 0x38CD8700, 0x64CBD780, 0x53080DC0, 0x742D43A0, 0x461B1E10, 0xE9817C58, 0xB8C00A34, 0x7B60F802, 0x67107403 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xA8000000, 0x7C000000, 0x16000000, 0x77000000, 0x6B800000, 0x78C00000, 0xBFE00000, 0x19700000, 0xCAA80000, 0xF0A40000, 0xECB20000, 0x57A10000, 0xEBD08000, 0x8FF94000, 0x791C6000, 0x140F5000, 0x3F7FF800, 0xA0D7AC00, 0xB6F22E00, 0xB0007700, 0xE8000180, 0xDC01F7C0, 0x2601D6E0, 0xDF00FF50, 0x17810C48, 0x6EC13DE4, 0xC8E11802, 0x72F0BC01 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xA8000000, 0x14000000, 0x9A000000, 0x5F000000, 0xDD800000, 0x3DC00000, 0x72200000, 0x25D00000, 0x0B680000, 0x74A40000, 0x99F60000, 0x69610000, 0xD5B18000, 0x22594000, 0xEBBD2000, 0x932B5000, 0x6BFB2800, 0x0E13B400, 0x1CF77E00, 0x8BE15B00, 0x05F0CB80, 0x55B9FC40, 0x004D27A0, 0x3392E4D0, 0xD137F048, 0x61C1F96C, 0x0C218802, 0x78D0A403 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x88000000, 0xEC000000, 0x12000000, 0x23000000, 0xC3800000, 0xBFC00000, 0xBAA00000, 0x1DB00000, 0x93A80000, 0x75A40000, 0xF6B60000, 0xC1E10000, 0xC5518000, 0xEA784000, 0x599CE000, 0x154B1000, 0x2A3AD800, 0x11B2A400, 0x76E68600, 0x2D19A700, 0xE58D4F80, 0x1CD31D40, 0xFDF73760, 0x91010D50, 0x50811648, 0xD441D7EC, 0x9961B802, 0x3D10F403 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xF8000000, 0x54000000, 0x7A000000, 0x1F000000, 0xD2800000, 0x2CC00000, 0x22200000, 0x30300000, 0xB3880000, 0xA53C0000, 0xFFFA0000, 0x3F610000, 0xEA518000, 0x5458C000, 0x6F24E000, 0xEE3FF000, 0x3B4FA800, 0x06A67400, 0x3E4A7E00, 0x14A90500, 0xE88C0980, 0x2A333C40, 0xB0BC2C60, 0x85BB7510, 0xA3814D78, 0x3B41A974, 0xD360C802, 0x64504403 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xD8000000, 0x34000000, 0xFA000000, 0x37000000, 0xD3800000, 0xFF400000, 0x3E200000, 0xDC100000, 0xD7B80000, 0xEC1C0000, 0x40BA0000, 0x17E10000, 0x85F18000, 0x5F494000, 0xF7D5E000, 0x6BAFB000, 0x652F6800, 0x36EF7400, 0x980FAE00, 0x637F8700, 0x77F66E80, 0xBAC38440, 0x201DB420, 0xBEBACD70, 0xA2E19D38, 0xA570FAF4, 0x51890802, 0x35B48403 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x68000000, 0x7C000000, 0xD2000000, 0x5D000000, 0xD2800000, 0xB1400000, 0x50600000, 0x43700000, 0x2FE80000, 0x8EF40000, 0x545E0000, 0x28A10000, 0xC3D08000, 0x70394000, 0x1CCD2000, 0xED92D000, 0x03B3F800, 0xDF222400, 0x707A7A00, 0xA0464500, 0x01FC5280, 0x6D9A68C0, 0xF5F66AE0, 0xC1B5C9D0, 0x033E4EE8, 0xA850E93C, 0xA5F85802, 0x56ECB401 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x98000000, 0x74000000, 0x6A000000, 0xC7000000, 0x9F800000, 0x3DC00000, 0x51E00000, 0xBDF00000, 0xC8580000, 0xBFAC0000, 0x6F4A0000, 0x3DF10000, 0x08598000, 0x9FAC4000, 0xDF4B6000, 0xA5F03000, 0x7C596800, 0xF5AC9400, 0x184AEE00, 0x3A710F00, 0x41991380, 0xA44C37C0, 0xA5BB95E0, 0xF2289FB0, 0xFE346CD8, 0xCB06E954, 0x984AEE02, 0xFA710F03 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x48000000, 0xE4000000, 0x0A000000, 0x5B000000, 0xEA800000, 0x25400000, 0x20600000, 0x14900000, 0xA9C80000, 0x6C740000, 0x75EA0000, 0xD8910000, 0x17C98000, 0xE5744000, 0xD86B6000, 0xB1519000, 0xA7E84800, 0x6A045400, 0xF1F3D600, 0x9B4C4500, 0xAFC60280, 0x5A4714C0, 0xEF877F20, 0xD9A6D690, 0x53D6FA68, 0x89CF8F14, 0xD313D602, 0x3E9C4503 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x28000000, 0xCC000000, 0x76000000, 0x19000000, 0xE3800000, 0x5BC00000, 0xCAE00000, 0x1B900000, 0x62980000, 0xB6BC0000, 0xA23E0000, 0xBD910000, 0x93998000, 0xB93C4000, 0xDFFEA000, 0x46715000, 0xA7881800, 0xF664AC00, 0xBAA29200, 0x1C5E9700, 0x2341AF80, 0x19A0B9C0, 0xBA30E520, 0x1CA9F230, 0x401412F8, 0xA52BA5BC, 0x2E3A9202, 0x73E29703 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x58000000, 0xC4000000, 0xE2000000, 0x5F000000, 0x2D800000, 0x61400000, 0x4BA00000, 0x7B500000, 0x40180000, 0x242C0000, 0xADAA0000, 0xD1510000, 0x33198000, 0x97ADC000, 0xC5EAE000, 0x5271B000, 0x9F880800, 0x32D40400, 0xEF765E00, 0xA2B3EB00, 0x30FDCA80, 0x83F31340, 0x5B5C68A0, 0x68A30B30, 0x334572D8, 0xD08EE014, 0xB8EE5E02, 0xBCDFEB03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x98000000, 0x2C000000, 0xC6000000, 0x87000000, 0xD8800000, 0xC3400000, 0xB8200000, 0x37500000, 0x22880000, 0x37D40000, 0x1D360000, 0x5D510000, 0xA3898000, 0xC8554000, 0x36F66000, 0xBE303000, 0x00F9D800, 0x1B8CCC00, 0xA4AB6E00, 0x4C538100, 0x83DF5E80, 0x5D753C40, 0xF827C0A0, 0x9078E410, 0x3CCD6128, 0xFE8AEE2C, 0xBE036E02, 0x8CD78103 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x18000000, 0x64000000, 0x12000000, 0xE3000000, 0xD8800000, 0xB4C00000, 0x27A00000, 0x08B00000, 0xCF180000, 0x7E0C0000, 0xDE2E0000, 0x56B10000, 0x82198000, 0x138C4000, 0xF36F6000, 0xE6513000, 0xA5494800, 0x55446400, 0x8E6AA600, 0x595A8100, 0x28032180, 0x066EAB40, 0x9FD07760, 0xA208BF30, 0xD2A44D98, 0x7BBA4F1C, 0x2C52A602, 0xB8268103 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x48000000, 0x24000000, 0x0A000000, 0x3F000000, 0x78800000, 0x35C00000, 0xF8E00000, 0xB8500000, 0x7B380000, 0x0C1C0000, 0xF62E0000, 0x47510000, 0x63B88000, 0x89DC4000, 0xD6CF2000, 0x93019000, 0x3680C800, 0xB0C05400, 0x67615E00, 0x99106100, 0x98182380, 0x79ADE5C0, 0x72C70EA0, 0x7D350770, 0x54AAF3B8, 0x78135D9C, 0x314F5E02, 0x0E416101 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x88000000, 0xC4000000, 0x46000000, 0xA7000000, 0x41800000, 0x1AC00000, 0xA1E00000, 0x9A100000, 0x8F080000, 0xAE2C0000, 0xE9120000, 0xED110000, 0x16888000, 0xE8ECC000, 0x32F2E000, 0xDA001000, 0xFD010800, 0xFC804C00, 0x8641AE00, 0x57A19300, 0x45B1BD80, 0x0EB9CFC0, 0xE6947A20, 0xA8879D10, 0x041669D8, 0x085F11E4, 0x4153AE02, 0xE9B09301 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x28000000, 0x64000000, 0xEE000000, 0x81000000, 0xC3800000, 0xB9C00000, 0x85A00000, 0xB8D00000, 0x0AE80000, 0x6BAC0000, 0x6A860000, 0x55D10000, 0x13688000, 0x356D4000, 0xD9A62000, 0x51415000, 0xC0E04800, 0x4E309C00, 0x39D92200, 0x23F5D700, 0xD3B3BB80, 0xCB43D740, 0x75BBF3A0, 0x34DF52D0, 0xC1E544D8, 0x747A6E4C, 0xBD7F2202, 0x5334D701 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x48000000, 0x7C000000, 0x7E000000, 0xFD000000, 0x6B800000, 0x0CC00000, 0xA8600000, 0x93900000, 0x61A80000, 0xCBE40000, 0xDE5A0000, 0x70910000, 0x67298000, 0xB4A44000, 0x3EFAE000, 0x01619000, 0x6A117800, 0xF668BC00, 0xB1051A00, 0x608A4700, 0x4A99E180, 0x7FBC2CC0, 0x02869D20, 0x2B07F450, 0x44C79E48, 0x2A26D474, 0xE6F71A02, 0x17FF4703 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x18000000, 0x7C000000, 0x2A000000, 0xA3000000, 0x7F800000, 0x0BC00000, 0x20600000, 0x21700000, 0xAAA80000, 0x34540000, 0xEF720000, 0xA0710000, 0x52288000, 0xF615C000, 0xDDD32000, 0x65E13000, 0xD1B07800, 0x69499400, 0xA4E46600, 0xDEBACF00, 0xB6D5EF80, 0x363294C0, 0xE151C4E0, 0x3E780A50, 0x92ED8F28, 0x4A7E4624, 0x34BE6602, 0xA25FCF01 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x88000000, 0x84000000, 0xAE000000, 0x2F000000, 0x79800000, 0xB1400000, 0x74200000, 0xF6700000, 0x61180000, 0x35740000, 0x6B320000, 0x6FF10000, 0xC0598000, 0xA954C000, 0xC943A000, 0x28E81000, 0x5E2C8800, 0x15E79C00, 0x38F2FE00, 0xE5116300, 0xB0492A80, 0xC99CD440, 0xD31F02E0, 0xB1172930, 0xFF2BDC68, 0x5A057C24, 0xF0AB7E02, 0x0845A303 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xC8000000, 0xF4000000, 0x7A000000, 0xAD000000, 0xC6800000, 0xB7C00000, 0xFAA00000, 0xD1B00000, 0xFDC80000, 0xB5240000, 0xD8620000, 0x27310000, 0x42098000, 0x1B854000, 0xC3D36000, 0xBFF89000, 0xC5AC6800, 0x0E27B400, 0xB3433A00, 0xEAC09D00, 0x94204780, 0x82712140, 0x05680960, 0xF5940E90, 0x6D2B19C8, 0xF2D4EB84, 0x0B4ABA02, 0x9C45DD03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x88000000, 0xAC000000, 0x7E000000, 0xE7000000, 0x89800000, 0x4DC00000, 0x9FA00000, 0xA6D00000, 0xE4580000, 0x20CC0000, 0x4C360000, 0x47510000, 0x95998000, 0x196D4000, 0xD9E7E000, 0x70881000, 0xCD94D800, 0xDA7BBC00, 0x1B272E00, 0x5AA88300, 0x80850380, 0x92836340, 0x4EBB73A0, 0x8A0613B0, 0x6838BE18, 0xCEBDB52C, 0xAF3EAE02, 0x9205C303 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xC8000000, 0xAC000000, 0x8E000000, 0xBF000000, 0x04800000, 0x1E400000, 0xEA200000, 0xEA300000, 0xEA180000, 0xDB9C0000, 0xBDCA0000, 0xA2B10000, 0x2A598000, 0xD6BD4000, 0x077A6000, 0xBCE89000, 0x86E4D800, 0xB4C65C00, 0xEA121E00, 0xBDCD1900, 0xF3C3A480, 0xFB04E840, 0xA716DA60, 0x61DB5530, 0x84992FB8, 0x98DD9DD4, 0xC26B9E02, 0xDD405903 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x88000000, 0x8C000000, 0xE2000000, 0x71000000, 0xC0800000, 0xEB400000, 0x04E00000, 0xA9100000, 0x26480000, 0x50BC0000, 0x0ABA0000, 0x27910000, 0x4E098000, 0xCDDD4000, 0xD46BA000, 0x84781000, 0x4E449800, 0x6ABE8400, 0x1F4E4200, 0x54161100, 0xECE30E80, 0xF5E5ADC0, 0xE14FC020, 0x2F162590, 0xA1639BF8, 0x6424F2B4, 0x7BEFC202, 0x2C675103 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x38000000, 0x8C000000, 0x26000000, 0x69000000, 0xF3800000, 0x11C00000, 0x11600000, 0x27300000, 0x82D80000, 0x31BC0000, 0x05920000, 0x55B10000, 0x14998000, 0x3B1D4000, 0x2CC2A000, 0x52D97000, 0xC9BC9800, 0x29930C00, 0x23B17200, 0x45981700, 0x449C7B80, 0x1B02CEC0, 0x2AB9EC60, 0x1D0C7AB0, 0xBA8B4CF8, 0x036D5BE4, 0x673AF202, 0x93F45703 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xE8000000, 0x74000000, 0xCE000000, 0x05000000, 0x4E800000, 0xD9400000, 0xD1600000, 0x1A700000, 0xD1080000, 0xA7240000, 0x296E0000, 0x95F10000, 0x50C88000, 0x46054000, 0x2EFFA000, 0xD0C8D000, 0x06046800, 0x8EFEDC00, 0x00C8AA00, 0xEE05CD00, 0xFAFE1A80, 0xCEC89EC0, 0xEB056EE0, 0xB47E9710, 0x1789C0C8, 0x3A64AA1C, 0xAE0E2A02, 0xC6818D01 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0xE8000000, 0x7C000000, 0x7A000000, 0x6F000000, 0xEC800000, 0xF0C00000, 0x55A00000, 0x5CB00000, 0x4A780000, 0x7EB40000, 0x425E0000, 0xD5310000, 0x21388000, 0x13554000, 0x458E2000, 0x1758D000, 0xCCC47800, 0x6C87B400, 0x8AB5FE00, 0xB45E8900, 0x98315980, 0x26B8FF40, 0xE114F760, 0x89EF95F0, 0xE7C938E8, 0xA94C89FC, 0x11AB7E02, 0x4F8EC901 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x98000000, 0x34000000, 0xBE000000, 0x71000000, 0x6C800000, 0x0EC00000, 0xA9200000, 0x66F00000, 0x71080000, 0x331C0000, 0x12220000, 0xDD710000, 0x16488000, 0xE67D4000, 0x92326000, 0x97283000, 0x086CE800, 0xA16A3C00, 0x798D8200, 0x53BB6900, 0x18F43580, 0x786ECE40, 0x216B5FE0, 0x398DB310, 0xF3BBF7B8, 0x28F5DC04, 0xE06F0202, 0x156B2901 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xC8000000, 0x8C000000, 0x76000000, 0x83000000, 0x9A800000, 0x6F400000, 0x33E00000, 0x05D00000, 0x2D680000, 0x89540000, 0xEBF20000, 0xF2510000, 0xAFA98000, 0xDD754000, 0xBB82E000, 0x4E889000, 0xF4849800, 0x229BAC00, 0xF104E600, 0x795B2500, 0xBAA58680, 0x97EBEBC0, 0x4C5CDDA0, 0xE3B717D0, 0x2BEAF028, 0x925DCE24, 0x3CB76602, 0x7F6B6503 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x28000000, 0xAC000000, 0x8E000000, 0xF1000000, 0x3D800000, 0x2F400000, 0x67E00000, 0xD8D00000, 0xFCE80000, 0x60AC0000, 0xFFA20000, 0x06510000, 0xE9288000, 0xC08D4000, 0x60522000, 0x3DC95000, 0xAADDD800, 0xE77A5C00, 0xBC44C200, 0xCF0EAB00, 0x71F34680, 0x537873C0, 0x8FA5C3A0, 0xFDDFBAD0, 0xEE1AF3D8, 0x49545A84, 0x17C64202, 0xACAEEB01 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xC8000000, 0x7C000000, 0xF6000000, 0xAB000000, 0x9F800000, 0x5EC00000, 0x6F200000, 0x93D00000, 0x98880000, 0xBF040000, 0x81C20000, 0x15510000, 0xC0C98000, 0x4865C000, 0x0572A000, 0x59689000, 0xFBF57800, 0x8E9A2C00, 0x20DCF600, 0x170F2F00, 0x62768580, 0x4CAB1240, 0xD4A4A1A0, 0x8B521610, 0xE839DF88, 0x593CC3C4, 0x57FF7602, 0x7F2FEF03 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xD8000000, 0xAC000000, 0xF2000000, 0x3F000000, 0x91800000, 0x93C00000, 0x65600000, 0x7CB00000, 0x95480000, 0x208C0000, 0xF5320000, 0xAB710000, 0xB6298000, 0x1D3C4000, 0x8CFB6000, 0x6EBCB000, 0x883AD800, 0xCE5CA400, 0x894A9E00, 0x2B75D300, 0xD7F69F80, 0xBB4FDEC0, 0x95AA3F60, 0x70049D90, 0x59DEE098, 0x9A7277A4, 0x8351FE02, 0x55B96303 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xD8000000, 0xD4000000, 0xAA000000, 0xBB000000, 0xE6800000, 0xCDC00000, 0x57E00000, 0x18F00000, 0xD8680000, 0xB3F40000, 0xE0320000, 0x87310000, 0x10888000, 0x9F854000, 0x2A9B6000, 0xF7A4B000, 0x4A8B2800, 0xDBBD1400, 0xE7D69600, 0xE11A3D00, 0x81E4D380, 0x532B8BC0, 0x1EEDCFE0, 0x38EF79D0, 0x3AD7D268, 0x229ABEA4, 0xABA5F602, 0xFC8A8D01 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0x2C000000, 0x42000000, 0x79000000, 0x2E800000, 0xB3400000, 0x9F600000, 0xF2500000, 0x84B80000, 0x5B540000, 0xD23A0000, 0xEF110000, 0x00D88000, 0xCE84C000, 0xF342A000, 0xDC65D000, 0xD1D2D800, 0x6C7D4400, 0x7BF6D200, 0x064F4D00, 0x339A1E80, 0x32E02AC0, 0x1291AEA0, 0x88196070, 0xEE250A28, 0x0432CBB4, 0x736C7202, 0x632E9D01 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x38000000, 0x14000000, 0x5E000000, 0xC7000000, 0xB7800000, 0x8C400000, 0x17200000, 0xB2700000, 0xBB680000, 0x2A2C0000, 0x3B3A0000, 0xD4310000, 0x65498000, 0xF0DC4000, 0x3F932000, 0x037D7000, 0x2823A800, 0xC475FC00, 0x80DF2E00, 0x42165F00, 0xC68A9080, 0xDA382240, 0xA53422E0, 0xC97FB5D0, 0x84A6BAD8, 0xED035334, 0xAB040E02, 0x0D372F03 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xB8000000, 0x2C000000, 0x8E000000, 0xC9000000, 0x1E800000, 0xB6400000, 0x7E600000, 0xDC900000, 0x14B80000, 0x16140000, 0xC8960000, 0xF0D10000, 0x41D88000, 0x33054000, 0x2DEF2000, 0x88647000, 0xB1FED800, 0xFB9D5C00, 0x7B0A3200, 0x6FDB0D00, 0x04039480, 0x740650C0, 0x94699320, 0xDFCC9870, 0xFF939AA8, 0xC73F44EC, 0xA2BD1202, 0xDB7B7D01 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0xD8000000, 0x54000000, 0x16000000, 0x7F000000, 0x8C800000, 0x79C00000, 0x98200000, 0xC3900000, 0xAD280000, 0x30E40000, 0x8AEE0000, 0xB0510000, 0xF0098000, 0x72F5C000, 0xB387A000, 0x1ED4B000, 0x96172800, 0x24FCEC00, 0x7672DE00, 0x4DD26900, 0x63037B80, 0x9BCBEC40, 0x369F3120, 0x75C93F50, 0x80D49448, 0xA516689C, 0x0A7D7E02, 0xB6B2D903 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x08000000, 0x74000000, 0xAA000000, 0xC1000000, 0x6A800000, 0xB9C00000, 0xB8200000, 0x26300000, 0x0C380000, 0x92F40000, 0xA5220000, 0x3EF10000, 0xAE988000, 0x35054000, 0xFD3B2000, 0x5C351000, 0x18826800, 0x98811400, 0xE4C02200, 0x3CA18500, 0x6CF0BB80, 0x63983440, 0xB9852660, 0xC3FB9970, 0x9994D468, 0xF2F26F04, 0x94D90202, 0xFA659501 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xF8000000, 0xFC000000, 0x4A000000, 0x93000000, 0x13800000, 0x57C00000, 0x09E00000, 0xBFD00000, 0x4C480000, 0x8B140000, 0x44920000, 0x0B110000, 0x0E298000, 0xCF04C000, 0x833A6000, 0xA8D4F000, 0xA3727800, 0xC1C15400, 0x40E0C600, 0x97511700, 0x3C093780, 0x9B3577C0, 0xD7A3A1A0, 0x32092B90, 0x1E351FA8, 0x4D227DE4, 0x2D48A602, 0x5794E703 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xC8000000, 0xC4000000, 0x6E000000, 0x2F000000, 0xDC800000, 0x55C00000, 0x9E600000, 0x46300000, 0xB8E80000, 0xE0EC0000, 0x52A60000, 0xA4F10000, 0x26088000, 0x011DC000, 0x492EE000, 0x93AC9000, 0xC0070800, 0x13201C00, 0x43903E00, 0xDFB9E900, 0x7AB5C380, 0x536270C0, 0x22DA5A60, 0xD76F94D0, 0xC88D7458, 0x0797808C, 0x4298DE02, 0x66247901 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x68000000, 0xDC000000, 0x6E000000, 0x7B000000, 0x33800000, 0xC1400000, 0x0FA00000, 0x86100000, 0x94380000, 0xD08C0000, 0x143A0000, 0xD0510000, 0x1E188000, 0xA8DDC000, 0x76222000, 0xE68DD000, 0x6B3B3800, 0xC9D01C00, 0x6E585600, 0x35FD7700, 0xCBF21A80, 0x9AD51340, 0xBBC6C220, 0x32A35370, 0xB24D7598, 0xF2DBC034, 0x65E07602, 0x7231A701 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x48000000, 0x84000000, 0x32000000, 0xB7000000, 0xEA800000, 0x35400000, 0x24600000, 0x04B00000, 0xD2280000, 0x6AFC0000, 0xD0F20000, 0xCAF10000, 0x6AC98000, 0x3E0DC000, 0x4B3A6000, 0x337D9000, 0xFD328800, 0x8CD0A400, 0x90988E00, 0x95D48500, 0x538F0280, 0xBFC3BCC0, 0x8218EF60, 0xAC945550, 0x21EE7178, 0x0E73CC24, 0x45B0EE02, 0x9DA81503 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x78000000, 0xAC000000, 0x0E000000, 0x4F000000, 0x55800000, 0x05400000, 0xDCE00000, 0x9E900000, 0x85E80000, 0xBB9C0000, 0xBBCE0000, 0x32D10000, 0x27898000, 0xCFCCC000, 0x7A86E000, 0xA7BDF000, 0x34FED800, 0x4149DC00, 0x556DFE00, 0x73769B00, 0xFE84B280, 0x57EAD5C0, 0x78CB3B20, 0xC47BDCD0, 0x59A353B8, 0x78279D5C, 0xB24D1E02, 0x7BC66B03 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x48000000, 0xF4000000, 0xFA000000, 0x17000000, 0x71800000, 0xDBC00000, 0x1AE00000, 0x66300000, 0x58980000, 0x0DCC0000, 0x7C860000, 0x5C710000, 0xF1B98000, 0xB51DC000, 0x202FA000, 0xA2259000, 0xFF726800, 0xA32B3400, 0xF1870E00, 0x2AF13300, 0xF3F9BF80, 0x503D31C0, 0xEEFE3A60, 0x7F8DDE30, 0x21A61E18, 0x1EA135CC, 0xBA112E02, 0x3AC96303 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xC8000000, 0xB4000000, 0x7E000000, 0x2B000000, 0x5B800000, 0xCF400000, 0x12A00000, 0x3DD00000, 0x1ED80000, 0x3BAC0000, 0x5F2A0000, 0x59110000, 0x9B388000, 0xC8DD4000, 0x6623A000, 0xE1649000, 0x3B3FE800, 0x2426BC00, 0x52EA7600, 0xC671E700, 0x79889680, 0x94B5A940, 0xD1E775A0, 0xC18B8EB0, 0xF6C1ABD8, 0x0CE14614, 0x99F15602, 0x30C83701 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x98000000, 0x6C000000, 0x46000000, 0x53000000, 0x43800000, 0x72C00000, 0x62200000, 0x08300000, 0x52F80000, 0x34040000, 0x17820000, 0x7D710000, 0xD0188000, 0x3714C000, 0xF3CAE000, 0x8DCC3000, 0x8AFE5800, 0x50374C00, 0x76CBC600, 0x354CF700, 0x2FBE9D80, 0x1AD65840, 0x91DA3E60, 0x130406F0, 0x3E02DF88, 0x7AB05644, 0xD2B9A602, 0x96640701 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x58000000, 0xA4000000, 0x12000000, 0xDB000000, 0xED800000, 0xF6400000, 0xA6200000, 0xECB00000, 0x3DB80000, 0x491C0000, 0x43660000, 0x25710000, 0x16D88000, 0x5E0DC000, 0x6C2EA000, 0x0BF5B000, 0x4613C800, 0xCCA2E400, 0x201A9600, 0x1B872B00, 0x01204480, 0xF7303840, 0xE2F8F760, 0x89BCDC70, 0xEC1714B8, 0xECA9CB8C, 0x0754B602, 0x17635B01 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x08000000, 0x44000000, 0xB6000000, 0x9B000000, 0x01800000, 0xBEC00000, 0xEAE00000, 0x0E900000, 0x06B80000, 0x2E2C0000, 0xCB120000, 0x13D10000, 0x07988000, 0xFCDDC000, 0xBE7A6000, 0x4A651000, 0xD8560800, 0x2577AC00, 0x4D86D600, 0xB1EE5300, 0xF4DBD580, 0x075489C0, 0xCF5E9320, 0xD0135A70, 0x525003D8, 0x5959C2E4, 0x263C3602, 0xB8EA8301 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xC8000000, 0x2C000000, 0x2E000000, 0xE3000000, 0xE2800000, 0xC1C00000, 0xF1E00000, 0xEF900000, 0x8F380000, 0x04340000, 0x05820000, 0xC6D10000, 0x3E188000, 0xA5C44000, 0xDD6B6000, 0x7B7C9000, 0xE21ED800, 0x3ADF1C00, 0x40BF2600, 0x4D6F9500, 0x6DF77B80, 0x7FF28FC0, 0xE4797120, 0x5814EF70, 0x15F2F9E8, 0xF5781FC4, 0x9F94C602, 0x49B34501 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x38000000, 0x64000000, 0xD2000000, 0x15000000, 0xE0800000, 0x8AC00000, 0x9F600000, 0xD9300000, 0xABF80000, 0xF4040000, 0x065A0000, 0x1E710000, 0xFAD98000, 0x8A94C000, 0x4EF36000, 0x403D7000, 0x4DBF4800, 0x2BDA6400, 0x6031CA00, 0x6578F100, 0x0DC47D80, 0x36BB8AC0, 0xE4002060, 0x12007AF0, 0x7501B388, 0x5081B974, 0xB2C12A02, 0xFB604103 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0xF8000000, 0x94000000, 0x32000000, 0xFF000000, 0x74800000, 0xA5C00000, 0x90600000, 0x61B00000, 0x95380000, 0x74640000, 0xE9FA0000, 0x07F10000, 0xA8198000, 0x9E75C000, 0x0413A000, 0xC69CF000, 0x1AFEA800, 0x773AA400, 0xE910DE00, 0xE7695900, 0x0DAC0380, 0xB30714C0, 0xCABEE560, 0x9F1A0F70, 0xCC817948, 0x11C00434, 0x9260FE02, 0xB6B16903 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xB8000000, 0xCC000000, 0x66000000, 0x89000000, 0x1F800000, 0xCA400000, 0x2BA00000, 0xAE500000, 0xD9480000, 0xA5B40000, 0x941E0000, 0x14910000, 0xEE288000, 0x9584C000, 0x12E62000, 0x559C7000, 0x649B1800, 0x0FF70C00, 0x50F4B200, 0xB13F0F00, 0xD301EC80, 0x18814B40, 0x48C066A0, 0x4460F990, 0x18B071E8, 0x0639CA7C, 0x616C1202, 0x8002BF01 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xA8000000, 0xB4000000, 0x1E000000, 0xA1000000, 0xC4800000, 0x39400000, 0x36A00000, 0xB9700000, 0x7D980000, 0x3CD40000, 0xA6720000, 0x6BB10000, 0x1FF98000, 0x4AC4C000, 0x0B7BA000, 0x182C5000, 0x2F36E800, 0x400BFC00, 0xB6B46200, 0xC4639900, 0x68B97A80, 0xB5652140, 0xA28AC8E0, 0x92F48630, 0x2C43A528, 0x2F8942A4, 0x87DC4202, 0x70EE0903 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0x2C000000, 0x1E000000, 0xD3000000, 0x8F800000, 0x20C00000, 0xE6E00000, 0xA0900000, 0xF6480000, 0xF4D40000, 0xF27A0000, 0x0AD10000, 0x70E88000, 0x4BE4C000, 0xED82E000, 0xF7BD5000, 0xFF5ED800, 0xC6B3FC00, 0xC244C600, 0xAB330F00, 0x57853980, 0x0553C1C0, 0x32552F20, 0xFC3AF790, 0xEE71A228, 0x3AD8A834, 0x7C9CA602, 0xA5AF9F01 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xD8000000, 0x4C000000, 0xAA000000, 0xFB000000, 0x6E800000, 0x9FC00000, 0x53200000, 0xE9100000, 0xB4580000, 0x7B040000, 0xDACA0000, 0xE5510000, 0x77398000, 0x7374C000, 0x99E3E000, 0x7DFCB000, 0x6F9F1800, 0xAE229400, 0x7ADC9600, 0x008E2D00, 0xBB7B8780, 0x4C592240, 0x67044C20, 0x38CB59B0, 0x7A503B88, 0x27B890D4, 0xF1B4F602, 0xF5435D03 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x78000000, 0xBC000000, 0xBA000000, 0xD7000000, 0xAB800000, 0x15400000, 0xAF200000, 0x55F00000, 0x5C280000, 0xD5740000, 0xC6DA0000, 0xC2310000, 0x5CC98000, 0x1C65C000, 0xF9E3E000, 0x777DF000, 0x40DEF800, 0xD103B400, 0xAA6CCE00, 0x11E7E700, 0x3D4E7280, 0xB4FBBA40, 0xB341CDE0, 0x12204350, 0x41718A68, 0xD6E842F4, 0x1114AE02, 0xED0AD703 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x38000000, 0xCC000000, 0x6A000000, 0xD9000000, 0xEB800000, 0x61400000, 0x44E00000, 0x47500000, 0x37380000, 0x22F40000, 0x8B0A0000, 0x4FB10000, 0x5A688000, 0xECCC4000, 0xD27F2000, 0x9DFB7000, 0x9D381800, 0x9BF41400, 0xD08AD200, 0x86F18700, 0xEA89AA80, 0x0D9D85C0, 0x5646C8A0, 0x8D8F7B70, 0x9CF34868, 0xF1E44954, 0x8952CA02, 0x1A559301 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x18000000, 0x74000000, 0x82000000, 0x1D000000, 0x6F800000, 0x93C00000, 0xD6E00000, 0x41900000, 0xEED80000, 0x3C340000, 0xE9560000, 0xC3710000, 0x1D488000, 0xA7EDC000, 0x46E32000, 0x57E73000, 0xE3D96800, 0x0BB44400, 0xEE96DA00, 0x0790CF00, 0x59D97F80, 0x52B581C0, 0x6B169D20, 0x755008B0, 0x0EB9E8E8, 0x6BE59CEC, 0xA3AFB202, 0xE9B48B01 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x68000000, 0xA4000000, 0xAA000000, 0x1D000000, 0xE1800000, 0x60C00000, 0xDEE00000, 0xE9500000, 0xFB080000, 0x499C0000, 0xF7360000, 0x7DB10000, 0xDF588000, 0xAB144000, 0xA26B6000, 0x3267D000, 0x58B8C800, 0xD9C59400, 0xDCA31A00, 0x389B7300, 0x401ED980, 0x929C61C0, 0xF5B71CA0, 0x03F0FF10, 0x89F9E9B8, 0xDFE41E2C, 0xB713D202, 0xFCC2E701 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x58000000, 0xE4000000, 0x96000000, 0x99000000, 0x03800000, 0x5D400000, 0xFB600000, 0x10F00000, 0x0EA80000, 0x330C0000, 0x94320000, 0x85910000, 0x13598000, 0xD0244000, 0x377F6000, 0x2743B000, 0xA6794800, 0xA334EC00, 0x00E61200, 0x7246D700, 0x7A174280, 0x77EFD2C0, 0xD59B9FE0, 0xCC1C3850, 0x49AB0398, 0x1B941024, 0x73B75A02, 0x9B3E3B03 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x98000000, 0xAC000000, 0x0E000000, 0xF3000000, 0xC0800000, 0x49400000, 0x73600000, 0x34B00000, 0x98F80000, 0x07540000, 0x41CA0000, 0x25D10000, 0xB1488000, 0x3C2D4000, 0x675E6000, 0x6A3A3000, 0x7148D800, 0xDC2DDC00, 0xF75EC600, 0xC23BD100, 0x45497A80, 0x7E2C62C0, 0x0A5EB360, 0xF1BB06F0, 0xCC88F528, 0x440C73D4, 0x4D8E1E02, 0x5DF20D01 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0xE8000000, 0xBC000000, 0x22000000, 0x7D000000, 0xEB800000, 0xE7C00000, 0x2BA00000, 0xF1300000, 0x5F980000, 0xB36C0000, 0x738E0000, 0x34910000, 0xD9A98000, 0xE6744000, 0x1EA3E000, 0x1E7ED000, 0x6029F800, 0x54B58400, 0x42835A00, 0xDA8EE700, 0x8111E780, 0x4168AB40, 0xAB54FC60, 0x0BD3A230, 0x3186D658, 0x2BD4C3DC, 0xF492A202, 0x71676303 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x88000000, 0x44000000, 0xDE000000, 0x6D000000, 0x04800000, 0x35400000, 0xA4200000, 0xF3F00000, 0x89D80000, 0x43A40000, 0xDCEA0000, 0x5AD10000, 0x2EA98000, 0xE73C4000, 0x476F6000, 0x67CA1000, 0x0AA00800, 0x3DB07C00, 0x2079FA00, 0xEF947900, 0x2153F280, 0x0E257C40, 0x632B01E0, 0xBEB080B0, 0x01F804C8, 0xBA55CB14, 0xDE33F202, 0xBCF50503 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x08000000, 0xDC000000, 0x5E000000, 0x45000000, 0x47800000, 0xC5400000, 0x8FA00000, 0xEF900000, 0x9DE80000, 0x6C940000, 0x52920000, 0x6D310000, 0x49F98000, 0xFA3CC000, 0x0CA7E000, 0x43B31000, 0xFE613800, 0x4BF1FC00, 0x4919AA00, 0x3D0D7F00, 0xD25E2280, 0x7D0F1B40, 0x11076920, 0x8F237ED0, 0xD5087CA8, 0xD7A480E4, 0x426A9202, 0xEE8D8303 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x58000000, 0x3C000000, 0x9E000000, 0x53000000, 0x3D800000, 0xEA400000, 0x8B600000, 0xAD700000, 0x5F080000, 0xB9740000, 0xA55E0000, 0x09110000, 0x31F98000, 0x8F3D4000, 0x82CAE000, 0x8F7FB000, 0x4E80F800, 0x67C1FC00, 0x99210600, 0x6A102B00, 0x34791C80, 0x897C52C0, 0xBFAAC0E0, 0x150F6310, 0x8E085D68, 0xF9F548FC, 0xD99FFE02, 0x19B0D703 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x48000000, 0xBC000000, 0x5A000000, 0xDD000000, 0x45800000, 0xE6C00000, 0xCFA00000, 0x56300000, 0x4DA80000, 0x71040000, 0x2F260000, 0xA8910000, 0x8C198000, 0x5B6DC000, 0x5E03A000, 0xA2479000, 0x5F01F800, 0x4C80F400, 0x7541DA00, 0x3661BB00, 0xF5102580, 0x5ED85340, 0x92CDA260, 0x5F33AA50, 0x3F6EA488, 0x31448C8C, 0x10C62202, 0x99404F03 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x58000000, 0xDC000000, 0x9A000000, 0x03000000, 0x2B800000, 0xAD400000, 0xF8E00000, 0x47900000, 0x56F80000, 0xFD3C0000, 0xBFF20000, 0xC8710000, 0x04E88000, 0x1384C000, 0x60AE6000, 0x31D3B000, 0xA2403800, 0x61617400, 0x0DD0A600, 0xF3988700, 0xD6EC5280, 0xE56B7DC0, 0x6E1CBD20, 0xBB427CF0, 0xB23937F8, 0x679D34A4, 0xB9029E02, 0xC358F301 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x18000000, 0x8C000000, 0xB6000000, 0x09000000, 0xC3800000, 0xE7C00000, 0x0CA00000, 0x72F00000, 0x75580000, 0xA1A40000, 0x84160000, 0xF1510000, 0x95288000, 0xDCBD4000, 0xC8D36000, 0x1A173000, 0x2C509800, 0xCCA8AC00, 0x347C3200, 0x16F2D700, 0xC0A7E780, 0x0469ED40, 0x1A5C5BE0, 0x74435FB0, 0xD49F5BC8, 0x7C9C76EC, 0xDF62AA02, 0xC3AF7B01 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x28000000, 0xC4000000, 0x9E000000, 0x5B000000, 0x66800000, 0x6EC00000, 0xAB200000, 0x0C500000, 0x4F480000, 0xAF4C0000, 0x8ACA0000, 0x26710000, 0x20998000, 0x13454000, 0xB6E66000, 0x4D0B5000, 0x2AD10800, 0x4189FC00, 0x946D9600, 0x9E9AFD00, 0x85380580, 0xD5D46240, 0x5C8ED2A0, 0xAD178590, 0x65D39E18, 0xFC74D654, 0x501E9E02, 0x9A7E0103 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x48000000, 0x1C000000, 0x32000000, 0x19000000, 0xB2800000, 0x3DC00000, 0x3BA00000, 0x1A500000, 0xEFF80000, 0x5D8C0000, 0xEAFE0000, 0x33710000, 0x18688000, 0x51D4C000, 0x0923E000, 0x50779000, 0x4195B800, 0x3AC22400, 0xFDC61200, 0xF5DD9500, 0x5C069380, 0xBC7C0B40, 0x3F5792A0, 0x1105E0F0, 0x171A9998, 0xDC5ADF3C, 0x0C3B2A02, 0x32CB7101 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xE8000000, 0x14000000, 0xB2000000, 0x75000000, 0xF0800000, 0x7AC00000, 0x2E600000, 0x18500000, 0xDDE80000, 0x23340000, 0xB8820000, 0x36B10000, 0xB7788000, 0x54BD4000, 0xE9E66000, 0xDADAD000, 0xF47DA800, 0xE686A400, 0x200ACA00, 0x1655D100, 0xF352CD80, 0xEE1930C0, 0x616C8EA0, 0x0A4E08D0, 0x2F4F7EE8, 0xE7CE0644, 0xF10FE202, 0xA16E3501 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xE8000000, 0xEC000000, 0x22000000, 0xB5000000, 0xFF800000, 0x48C00000, 0xF8E00000, 0xDAB00000, 0xFF880000, 0x56DC0000, 0xEABA0000, 0x11D10000, 0xDFF88000, 0xACB54000, 0xA557A000, 0x8622D000, 0x39145800, 0x9EC78400, 0x1A7A8A00, 0xAD300F00, 0x6B495980, 0x143C8DC0, 0x510AEB60, 0x37D86210, 0xBAE4DF38, 0xD66EDB34, 0x6C765202, 0xE9F2CB01 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xB8000000, 0x7C000000, 0xEA000000, 0xD9000000, 0x78800000, 0x1CC00000, 0x5DA00000, 0x3B100000, 0x3B480000, 0xBF740000, 0x42320000, 0xB4310000, 0x65998000, 0x711CC000, 0xD2976000, 0x54EA7000, 0xC3CC7800, 0x5EFE9400, 0x094F1200, 0xC5966100, 0x136BF180, 0x4C8CB740, 0x721F4020, 0x59BE1D90, 0x21AE0A68, 0x6367A8A4, 0x7452EA02, 0x25003503 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xC8000000, 0xBC000000, 0x3E000000, 0x01000000, 0x52800000, 0x4DC00000, 0x4F600000, 0xE2D00000, 0x31C80000, 0x81C40000, 0xEAA20000, 0x89310000, 0x63D88000, 0x73EDC000, 0x3577E000, 0x87BA9000, 0x783CF800, 0xBA3F3C00, 0xADBF2200, 0x58FF5500, 0xC95E3380, 0x316E3AC0, 0x88378BA0, 0xEA1B8C90, 0x5E0C0908, 0xF267E604, 0x55135A02, 0x1D29A901 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x18000000, 0x44000000, 0xCA000000, 0xED000000, 0xBD800000, 0x7DC00000, 0x06200000, 0x3A100000, 0x34B80000, 0x3C640000, 0xD0C60000, 0x83B10000, 0xA2698000, 0x0D7D4000, 0x04732000, 0x6D6F3000, 0x69EC0800, 0x178B5400, 0xDA6ABA00, 0xD55AEB00, 0xF9738380, 0x08EFF040, 0xF02CEA20, 0x4BAB9070, 0x157BB448, 0x1862004C, 0x72D73202, 0x3308FF03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x78000000, 0xA4000000, 0x02000000, 0xEF000000, 0x1A800000, 0x35C00000, 0xD8A00000, 0x33B00000, 0x12180000, 0x3FE40000, 0x33660000, 0x9F910000, 0x15698000, 0x2EDD4000, 0x7172A000, 0x780FF000, 0x384DC800, 0x339AC400, 0xC6933E00, 0xC6DEE500, 0x31441380, 0x05D69D40, 0x0409AD60, 0xF3CD5730, 0x65DADD48, 0x54728E0C, 0x618F7602, 0x390D6103 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x78000000, 0x54000000, 0x46000000, 0x15000000, 0xC9800000, 0x40400000, 0xB8600000, 0x96300000, 0x93080000, 0xB4840000, 0x01960000, 0x52D10000, 0xBCF98000, 0x87AC4000, 0x3F43E000, 0x687FF000, 0x88A42800, 0x01C74C00, 0xBEE88A00, 0xC8F50300, 0x0DFE9880, 0x1AE5B4C0, 0xCAA6FA60, 0x04597710, 0xAA3C9688, 0x155B696C, 0x73232202, 0x884F0F03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x48000000, 0xD4000000, 0xE2000000, 0x09000000, 0xDF800000, 0x7FC00000, 0x43E00000, 0xC4500000, 0xE6E80000, 0xAFC40000, 0x035E0000, 0x61310000, 0x0AF98000, 0x010D4000, 0x792B6000, 0x01D79000, 0x29652800, 0x3AAF0400, 0x50A93200, 0x08E5CF00, 0xBA6E8780, 0x87C88BC0, 0xD5F54EA0, 0xF72688D0, 0x047DBB08, 0x55F37CFC, 0x126B9A02, 0x9B768B03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x48000000, 0x2C000000, 0x6E000000, 0x5D000000, 0xA2800000, 0x66C00000, 0x26200000, 0xA0D00000, 0xD6B80000, 0xC0CC0000, 0x32460000, 0xE1710000, 0xB6298000, 0x24954000, 0x9F7B2000, 0x3EDF9000, 0xC76CD800, 0x13D61C00, 0x11A9DA00, 0x44D57500, 0x3D9B4580, 0x1B2EE840, 0x068537A0, 0xEDE2CA70, 0xCDC3B518, 0x4C136F4C, 0xBE2A8202, 0xF9272903 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xF8000000, 0x6C000000, 0x2A000000, 0x71000000, 0x31800000, 0xD5400000, 0x2DA00000, 0x24D00000, 0x74980000, 0xA9EC0000, 0x63BE0000, 0xA5F10000, 0x5E898000, 0x3494C000, 0x82A2E000, 0xBB46F000, 0x67AC5800, 0xAE9F1400, 0x75E1C200, 0x5AF0F300, 0x00084280, 0xF7543740, 0x98C30FA0, 0xB3F7B030, 0xB8844E58, 0xF4DA94BC, 0x82DA1A02, 0x81DA2703 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x78000000, 0x6C000000, 0x3E000000, 0x11000000, 0x89800000, 0x17400000, 0x91200000, 0xA3B00000, 0x29880000, 0x722C0000, 0x04960000, 0xAE110000, 0xAEF98000, 0xB6C44000, 0x86AAE000, 0x857FF000, 0x17AC5800, 0xEDD7BC00, 0x0E318200, 0xF4C88300, 0xF00C4680, 0x09A76640, 0x1C58E960, 0x81343A10, 0xB883E5D8, 0xAB22C7EC, 0x4D525A02, 0x783A7F03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x88000000, 0xBC000000, 0x62000000, 0xED000000, 0x0D800000, 0x30400000, 0x9AA00000, 0x24F00000, 0xA0F80000, 0x56440000, 0xF6BE0000, 0xECD10000, 0xBCC98000, 0xDDDD4000, 0x54EB2000, 0xDDC61000, 0x51D5F800, 0xDE560400, 0xBF3CBA00, 0x36BBAB00, 0x0BCE4880, 0x52692940, 0x472C87E0, 0x4B1398F0, 0x73032308, 0xAEAB8ABC, 0x4666C202, 0x32A5EF03 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x68000000, 0x04000000, 0x36000000, 0x57000000, 0x15800000, 0xF4400000, 0x26200000, 0xCDD00000, 0x4D580000, 0xE3AC0000, 0x8F220000, 0x8F710000, 0xAE498000, 0xA5154000, 0x713E6000, 0xAFFBD000, 0x049C8800, 0xFD4AAC00, 0xB2B48E00, 0x8EAF1B00, 0x5B837080, 0x0B60C840, 0x957149A0, 0xAB4937B0, 0x4194D8D8, 0x9FFECC84, 0x041B8602, 0x292DF703 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x78000000, 0x34000000, 0xCA000000, 0x01000000, 0x91800000, 0xC9C00000, 0xD5E00000, 0x8E500000, 0xAE280000, 0xACAC0000, 0x669A0000, 0x15310000, 0x83388000, 0x56254000, 0x8DC6E000, 0xFDF3F000, 0xFA3DE800, 0x64D25400, 0x620CA200, 0x686BB300, 0xE6E94B80, 0xA8CC37C0, 0x810B3AA0, 0x1EF9F550, 0xD9C40DD8, 0xAA97DF74, 0xFE5BCA02, 0x1951A701 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x48000000, 0x0C000000, 0x82000000, 0x51000000, 0xCF800000, 0xB7400000, 0xBEE00000, 0xABB00000, 0xBDA80000, 0x027C0000, 0x376E0000, 0x95D10000, 0x35D98000, 0x44F4C000, 0xCA822000, 0xA4079000, 0xC90C9800, 0x67664400, 0x7CFD4200, 0x9FAEAF00, 0xB4702680, 0x3C89C1C0, 0x98ECA160, 0x28567E50, 0xDC946178, 0x8DF3479C, 0xB60E5A02, 0x11212B03 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xD8000000, 0x04000000, 0x8E000000, 0x31000000, 0x73800000, 0xD4C00000, 0xFEE00000, 0x26500000, 0x3B580000, 0x27A40000, 0x715E0000, 0xC0310000, 0x8D498000, 0x385CC000, 0x8B0BE000, 0xE546B000, 0x41B48800, 0xE6A65C00, 0x76644200, 0x0A3F3700, 0x97A1D180, 0x9D7089C0, 0x006842A0, 0xC66D1BB0, 0x4F43ADC8, 0x3A9BDCFC, 0xB87F4A02, 0x1000AB03 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x18000000, 0xA4000000, 0x6E000000, 0x17000000, 0x7B800000, 0xFCC00000, 0x48A00000, 0x93B00000, 0x55C80000, 0x14E40000, 0xA3860000, 0x57D10000, 0xF6D88000, 0xE69C4000, 0x24AB6000, 0x4BB33000, 0xB30EC800, 0xC2551C00, 0x10CF8E00, 0x9D74E700, 0x3DBF6180, 0xF51C7540, 0x046B7D60, 0x5913DE90, 0xF1BEA148, 0x471DF4CC, 0x496A2602, 0xF392CB01 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x88000000, 0xF4000000, 0x86000000, 0xFF000000, 0x47800000, 0x59400000, 0x76200000, 0xD4F00000, 0xB5C80000, 0x40EC0000, 0xBA560000, 0x63910000, 0xFB188000, 0x0BD4C000, 0xFA736000, 0xDBAA1000, 0xB11E6800, 0x82BC4C00, 0x49AEDE00, 0x23D53F00, 0x9E73AA80, 0x05AAD840, 0x821E53E0, 0x3F3D4690, 0x9DEF8A58, 0x6B75196C, 0xAB43D602, 0xD8836301 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xB8000000, 0x04000000, 0x96000000, 0xF7000000, 0x84800000, 0x67400000, 0xED600000, 0xA0500000, 0xCF280000, 0xF49C0000, 0x7DEA0000, 0xE6710000, 0xC8198000, 0x6EE54000, 0x2BDE6000, 0xC7C67000, 0xCF228800, 0x0BFCEC00, 0x7CBB4E00, 0xFAD85900, 0xEF445680, 0x212ECEC0, 0x849EEAA0, 0xF6A7A550, 0x6D7208B8, 0x2DD46A94, 0x47A7A602, 0xF6F2C503 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x58000000, 0xC4000000, 0x16000000, 0xBD000000, 0x6F800000, 0x2C400000, 0xB6200000, 0x78B00000, 0x05180000, 0xF8840000, 0x87220000, 0x2CD10000, 0xF2888000, 0xDCAC4000, 0x7BFF2000, 0xD2D7B000, 0xC98A0800, 0xA7CDEC00, 0x68EE9A00, 0x983E0F00, 0x98B7C080, 0x7F1BB840, 0x8E64CF60, 0xDB72D330, 0x9E995488, 0x4AC45184, 0x3003B202, 0x79E05301 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x88000000, 0x04000000, 0xDE000000, 0xBD000000, 0xAB800000, 0xF0400000, 0x35600000, 0x9CB00000, 0x4AC80000, 0x87340000, 0x31A20000, 0xAF910000, 0xAA198000, 0x9CCDC000, 0xED1FA000, 0xD5E61000, 0x3FDA8800, 0x2E6CFC00, 0x268E9A00, 0xB1FF2700, 0x7617D880, 0xBCF38EC0, 0x55291760, 0x0245F490, 0xB14BBBE8, 0x9DF4BA04, 0xFD03B202, 0x2901CB03 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0xB8000000, 0xF4000000, 0x76000000, 0x33000000, 0x9C800000, 0xF0C00000, 0x62E00000, 0xE6100000, 0xB0280000, 0x3DF40000, 0x485E0000, 0x0E310000, 0xA5D98000, 0x824DC000, 0xF2C3A000, 0x393A7000, 0x15876800, 0x587DAC00, 0x111B8600, 0xE0772900, 0x37C45980, 0x1386F1C0, 0x237DCE20, 0xF19B8350, 0xFAB69D68, 0x5C24A9FC, 0xD8174E02, 0xBA14F503 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xA8000000, 0xD4000000, 0xFE000000, 0x8D000000, 0xF9800000, 0xD6C00000, 0x2A200000, 0xB1300000, 0x63D80000, 0x43FC0000, 0xFCE20000, 0xAFD10000, 0xEFC98000, 0x5395C000, 0xDA86E000, 0x43AE5000, 0xA82B2800, 0xECC4BC00, 0xAC0FBA00, 0xC5DA8300, 0x463D3580, 0xF2431040, 0x09A00C60, 0x7CF1E2B0, 0x0978FB78, 0x538D4704, 0x46DA7202, 0x5ABC6F03 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x08000000, 0x14000000, 0x6A000000, 0x3F000000, 0xF8800000, 0x85C00000, 0x04600000, 0x13100000, 0x89580000, 0x98740000, 0x67120000, 0xDDB10000, 0x9EA88000, 0x2BFDC000, 0x545EA000, 0x78C71000, 0x14D3A800, 0xD8D09400, 0xC0399E00, 0xB0E48100, 0xBD0B9380, 0x9965E4C0, 0x3D4A2420, 0x7B4489B0, 0x657B9468, 0x43ACEC64, 0xE5A69602, 0xF6420501 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x68000000, 0x7C000000, 0x76000000, 0xE5000000, 0x69800000, 0xBA400000, 0xB5A00000, 0xE5D00000, 0x5DE80000, 0x785C0000, 0xBAC60000, 0x07310000, 0x28188000, 0x14254000, 0x0BD3A000, 0x2BFBD000, 0x9D477800, 0x0C702C00, 0x5E39AA00, 0x08B4E300, 0x071AFC80, 0x19B6AF40, 0x038995A0, 0xC66C8ED0, 0x1D5E7D38, 0x8455C94C, 0x53EB7202, 0x7E4E1F01 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x38000000, 0xFC000000, 0x22000000, 0xC5000000, 0xF6800000, 0xD7400000, 0x3E600000, 0xBC700000, 0xC6680000, 0x1C5C0000, 0x3A1A0000, 0xB8510000, 0x16F98000, 0x9F054000, 0x514EA000, 0xD5E77000, 0xAD1B7800, 0x23D18400, 0x5339EA00, 0xF8247D00, 0x0C5E8680, 0x607EB0C0, 0x74EFCEE0, 0x29B66FD0, 0xA5E29138, 0xFBD55B74, 0x61F63202, 0x34038903 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x68000000, 0x94000000, 0x3A000000, 0xBD000000, 0x7E800000, 0xFE400000, 0x28200000, 0xC4900000, 0x0CB80000, 0x75EC0000, 0x85960000, 0xBBF10000, 0xE4888000, 0xDE844000, 0x7A63A000, 0x195BD000, 0x6A76A800, 0x0A81B400, 0x74401A00, 0x0D21CD00, 0x9611A480, 0x34F9DC40, 0x4ECDAF20, 0xB887EA70, 0x8A899058, 0x3984DAEC, 0x49E31202, 0x219AA901 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xB8000000, 0xD4000000, 0x8A000000, 0x4D000000, 0x57800000, 0x04400000, 0xE4E00000, 0x34900000, 0x78580000, 0x143C0000, 0xFAD60000, 0xE5310000, 0x89A98000, 0xA7B4C000, 0xBED26000, 0xC78A7000, 0x4A372800, 0x9BA15400, 0xDCF1BA00, 0xD4097F00, 0xF844B080, 0x125A05C0, 0x7D0F4F20, 0x094D51B0, 0x219F55F8, 0xED153BEC, 0xB3A2F202, 0x34C35B03 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x68000000, 0x9C000000, 0xD6000000, 0xED000000, 0xC2800000, 0xB6400000, 0x4F600000, 0xE8500000, 0x5F080000, 0x31840000, 0x75160000, 0xAA710000, 0x17B98000, 0x121DC000, 0x32BBA000, 0x21D3D000, 0xE387B800, 0x1758EC00, 0x9E8C3A00, 0x1C933500, 0xFB662480, 0x9FC85AC0, 0xA2A4DEA0, 0xD9272D10, 0x8AA92088, 0xF9F4F56C, 0xE5AE2202, 0x71ED0903 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xC8000000, 0x1C000000, 0x8A000000, 0x23000000, 0xF7800000, 0x0C400000, 0x52600000, 0xADF00000, 0xBD180000, 0xD8CC0000, 0xBAEE0000, 0x52D10000, 0xAA088000, 0xC9E4C000, 0x7A1A2000, 0xECE29000, 0xC89FB800, 0xAF885400, 0x02A42600, 0xF1FA9F00, 0x20529080, 0xAD6798C0, 0x947571E0, 0x05F3A730, 0x5CB67018, 0x89FC2E9C, 0xA057BE02, 0x64CD5B01 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x28000000, 0x64000000, 0x62000000, 0x07000000, 0x60800000, 0x7B400000, 0x0BA00000, 0x29100000, 0x2F580000, 0xDA5C0000, 0x6E960000, 0x38F10000, 0x98698000, 0x08D5C000, 0xBFF2A000, 0x9FCB5000, 0xA0E64800, 0x76D98400, 0xC89CEE00, 0xCFF7F100, 0x1C81CE80, 0xC541CB40, 0xC2A19020, 0x1890F5B0, 0x7999DD38, 0xA93C35EC, 0x35E60602, 0x49582503 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x58000000, 0x3C000000, 0xE2000000, 0x2D000000, 0x0A800000, 0x94C00000, 0x5B600000, 0xD4500000, 0x80A80000, 0x97BC0000, 0x81E20000, 0xE0F10000, 0x4E198000, 0x9E044000, 0xD4D62000, 0xAEDFB000, 0x60D2F800, 0xF3090400, 0x3A8DBA00, 0xD81AC500, 0xED64C180, 0x94863AC0, 0x98770EA0, 0x4C6E2A50, 0xD36A39F8, 0xB73C1184, 0x9C236202, 0x4F117103 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x98000000, 0x4C000000, 0x76000000, 0x07000000, 0x34800000, 0x90C00000, 0x4AE00000, 0xB2B00000, 0x03080000, 0xE5F40000, 0x78020000, 0xEC110000, 0xC3998000, 0x3AACC000, 0x1E4F2000, 0xD7EE3000, 0xBBFE1800, 0xB866AC00, 0xE2CB6E00, 0x6C843900, 0x236AE980, 0xD49531C0, 0x1AF28F60, 0xFF38E510, 0xA73C5968, 0x14963F44, 0x8AE3D602, 0x22A06503 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xD8000000, 0xC4000000, 0xE2000000, 0x05000000, 0xB7800000, 0x8CC00000, 0xAEA00000, 0xAF500000, 0x5E680000, 0x309C0000, 0xA17E0000, 0x1EB10000, 0x01588000, 0xC2044000, 0x9B5AA000, 0xA3FAB000, 0x03AA0800, 0x83420400, 0x269F6A00, 0x5E81BF00, 0xD5414180, 0xF9604140, 0xC57008A0, 0xF57825D0, 0x3A1451B8, 0x4953A73C, 0x69974202, 0xC76D4B01 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xD8000000, 0xCC000000, 0xC6000000, 0xA7000000, 0x36800000, 0x5B400000, 0xF4E00000, 0x5F300000, 0xD9780000, 0xE1140000, 0x8E1E0000, 0xBA110000, 0x97E98000, 0x68BCC000, 0x31C3E000, 0xE422B000, 0x8A931800, 0xAE2BCC00, 0xC89EEE00, 0xF9507D00, 0xCF083E80, 0x018D6DC0, 0x97BBB460, 0xFFB635F0, 0x99CCC3A8, 0x47DBAC7C, 0x36C79602, 0x13D5C103 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xA8000000, 0xCC000000, 0xFA000000, 0x43000000, 0x3D800000, 0x0B400000, 0xCF200000, 0x03300000, 0x96C80000, 0xDC040000, 0xF2920000, 0x4ED10000, 0x0F998000, 0xD3DC4000, 0x6FEEA000, 0x2B4E5000, 0x5A3F1800, 0x5D573400, 0xE4A2E600, 0xEC994B00, 0x7E5DBE80, 0xECAE4240, 0x786E1C60, 0x0B0E6C90, 0x449FFF88, 0xFF2704E4, 0x564ADE02, 0xC22C6F03 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0xA8000000, 0xEC000000, 0x2A000000, 0xF9000000, 0x26800000, 0xC6400000, 0xD2E00000, 0xA0100000, 0x46080000, 0x43840000, 0x3A6A0000, 0x74310000, 0x11B88000, 0xA0FD4000, 0xE336E000, 0xDD765000, 0x7B965800, 0x15869400, 0x1C8FD200, 0x028B3D00, 0xCD212480, 0xA13059C0, 0xFD39CE20, 0x4FBD0F10, 0xCF566888, 0xFF276E94, 0x297FEA02, 0x2512B901 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x78000000, 0x8C000000, 0x8E000000, 0x1D000000, 0x85800000, 0x98C00000, 0xE2A00000, 0x71F00000, 0xDBF80000, 0x338C0000, 0x4D7E0000, 0x14110000, 0xDF688000, 0x45A44000, 0x50BAE000, 0x34FBF000, 0xA11A9800, 0x9D8ADC00, 0x47A31A00, 0xA466DB00, 0xE18DF980, 0x967F1140, 0x58918DE0, 0xB02812F0, 0xD4C4D398, 0xD76BBB3C, 0x0DB3E202, 0x2E0FB701 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xA8000000, 0xEC000000, 0xDA000000, 0xD5000000, 0xB9800000, 0xC4400000, 0x52600000, 0x69700000, 0x96D80000, 0x5E040000, 0x99460000, 0x08D10000, 0x52898000, 0xE14DC000, 0x162B6000, 0xD1EA5000, 0xE2CB5800, 0x285AF400, 0x4FB38A00, 0xA70E0300, 0x303D2080, 0x54F2B8C0, 0x41EFE4E0, 0x808D28B0, 0xD20A9188, 0x83FB0BCC, 0x66E23202, 0xB5C76703 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xD8000000, 0x44000000, 0x02000000, 0x37000000, 0xB7800000, 0xEAC00000, 0x29A00000, 0x07F00000, 0x9F880000, 0x25940000, 0xDBD60000, 0xE0110000, 0x1E988000, 0xF18CC000, 0x0C1B6000, 0xB6EAB000, 0xC5E30800, 0x43374400, 0x9A804E00, 0x0E41FF00, 0xA6E14D80, 0x9B900F40, 0x9A595DE0, 0x112CB210, 0x7D6A9BA8, 0x9922306C, 0xE796A602, 0xE9F1CB01 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x28000000, 0x8C000000, 0x76000000, 0x85000000, 0xFE800000, 0x8F400000, 0x4E200000, 0xF1100000, 0xF7F80000, 0x527C0000, 0x1D1E0000, 0x6DF10000, 0xD4088000, 0x0775C000, 0x2EEBA000, 0xC75B5000, 0x82F29800, 0xFF56AC00, 0x1424EA00, 0x45B34D00, 0xAD773680, 0x5B351840, 0x6B4A0C20, 0x5F8B8CF0, 0xC06BD178, 0xC01A47FC, 0x70D35202, 0x80467101 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x58000000, 0xBC000000, 0xFE000000, 0x9D000000, 0x09800000, 0x64C00000, 0x12E00000, 0x47700000, 0xE7780000, 0x8C640000, 0xFE120000, 0x83D10000, 0xBEA88000, 0x8DCC4000, 0x495EE000, 0x12CFB000, 0x37C6F800, 0xC95A3C00, 0x51EC1A00, 0xFBCE8300, 0x3446A180, 0x7A9B71C0, 0xBD8C40E0, 0x56FE43F0, 0x739E1448, 0xAD2E9164, 0x01368202, 0x86E24F01 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x28000000, 0x34000000, 0xD2000000, 0x7B000000, 0x1F800000, 0x22C00000, 0xC4200000, 0x7BF00000, 0x11980000, 0x701C0000, 0xD8720000, 0x9F910000, 0xFA098000, 0xB8144000, 0x2B662000, 0x93775000, 0x57BEE800, 0xCD8B6400, 0x341C1600, 0xD2738F00, 0xC8911D80, 0x3B89B440, 0x2FD5DDE0, 0x6DC70630, 0x7CC698B8, 0xC4465C24, 0x3F075E02, 0x60E6FB03 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x48000000, 0x8C000000, 0xD2000000, 0xE3000000, 0x48800000, 0x05400000, 0xAB200000, 0x03900000, 0x0C480000, 0x2DA40000, 0x909E0000, 0x1C490000, 0x45A48000, 0xAC9EC000, 0x5648A000, 0x62A41000, 0xBA1FD800, 0x62090400, 0x6205D600, 0xF44F4900, 0xC0210E80, 0xE7108040, 0x6B094E20, 0xFD841610, 0x1F8E5B08, 0x4B41AF1C, 0xF2210E82, 0x94108041 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x88000000, 0xF4000000, 0xC6000000, 0xBB000000, 0x82800000, 0x46400000, 0x36A00000, 0x8AB00000, 0xBB780000, 0x1D040000, 0x8CA20000, 0xC3790000, 0xA1058000, 0x9EA24000, 0xCE79E000, 0x10849000, 0xAE63A800, 0x78986C00, 0x1795E600, 0x1D2AAD00, 0x98A4E080, 0xB0938B40, 0xD840B860, 0x41A11670, 0x92307148, 0x04380124, 0x5C24E082, 0x8DD38B43 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x08000000, 0xEC000000, 0x86000000, 0x2D000000, 0xE1800000, 0x6DC00000, 0xFAA00000, 0xE1700000, 0x00180000, 0x6FFC0000, 0x6F260000, 0x78190000, 0x7BFD8000, 0x3D26C000, 0x6719A000, 0xD57D9000, 0xF6671800, 0xBAF8AC00, 0x6FEDCA00, 0x61EEDB00, 0xA30C7780, 0x74FE3F40, 0xF84419E0, 0xA02AF7B0, 0x4AE6A0B8, 0xCEB927AC, 0x2C8C7782, 0x483E3F43 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xE8000000, 0x4C000000, 0x32000000, 0xFB000000, 0x89800000, 0xB7400000, 0xDAA00000, 0xFB500000, 0x1B380000, 0x326C0000, 0x6B0A0000, 0xB7390000, 0xF06D8000, 0x180AC000, 0x42B96000, 0x9D2C5000, 0x75AA5800, 0x02690400, 0xCA55A600, 0x14E74B00, 0x25726A80, 0xBCF51340, 0x2DB73DA0, 0x4D4A9CF0, 0x7B191798, 0x2BFC3BB4, 0x97D26A82, 0xCBA51343 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xD8000000, 0xD4000000, 0x72000000, 0xF3000000, 0xF5800000, 0x82400000, 0xF0200000, 0x40D00000, 0x9CA80000, 0x591C0000, 0x773A0000, 0xB0A90000, 0x8F1D8000, 0x9E3AC000, 0x6A28A000, 0x86DC3000, 0xB95B6800, 0xAE584400, 0xDE65D600, 0xFB0E8300, 0xB2CF4080, 0x35AF3640, 0x41DE82A0, 0x116739D0, 0x5F32E478, 0xE5A47CD4, 0x8F6F4082, 0x333F3643 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0x68000000, 0xE4000000, 0x02000000, 0x0F000000, 0x3D800000, 0x85400000, 0x62200000, 0x14F00000, 0x2C780000, 0xDEF40000, 0x1B360000, 0xB0790000, 0x20F58000, 0xBA364000, 0xD4F86000, 0xFD355000, 0x8BD78800, 0x18E86400, 0x2DDD4E00, 0x320BF300, 0x60E36E80, 0x163E8A40, 0x73B55AE0, 0x7D17F670, 0x368997A8, 0xDB8D9C8C, 0xD5436E82, 0xAC8E8A43 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x78000000, 0xDC000000, 0x0A000000, 0x8B000000, 0xC0800000, 0x0BC00000, 0xF7A00000, 0x50B00000, 0xE7280000, 0xC9F40000, 0xE60A0000, 0xAD290000, 0x62F58000, 0x168BC000, 0x0EE8A000, 0x31557000, 0x903A7800, 0x68C0B400, 0xB3206600, 0xBD71F900, 0x3989A380, 0x76C40940, 0x1C629860, 0x19BCCDD0, 0x686EEAA8, 0xC77A2C74, 0xBEA1A382, 0xAF300943 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xB8000000, 0x5C000000, 0x76000000, 0x5D000000, 0x3A800000, 0x0E400000, 0x07E00000, 0xBE700000, 0x97880000, 0xB5D40000, 0xC5BE0000, 0x79890000, 0x04D48000, 0xC13FC000, 0xDEC92000, 0xABB5F000, 0x060F7800, 0x5F21CC00, 0xC9D14A00, 0x67190D00, 0x24ACD080, 0x26A3C5C0, 0x4382B1E0, 0x19525F90, 0x45CB9E68, 0x23A6E29C, 0x51A4D082, 0x9137C5C1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x98000000, 0x94000000, 0x32000000, 0xCB000000, 0xEE800000, 0x6FC00000, 0xA8200000, 0xD9D00000, 0x41980000, 0xD08C0000, 0x5ACA0000, 0x67990000, 0x698C8000, 0x9F4BC000, 0x36D8A000, 0x366DB000, 0x7ABAE800, 0x9C90C400, 0x6C782600, 0x1E7D3500, 0xCE031B80, 0xCA4CF640, 0x316BC6A0, 0x2608F8B0, 0x1A744758, 0x27762B34, 0xA7BB1B82, 0x8310F641 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x58000000, 0x5C000000, 0xA2000000, 0x11000000, 0x14800000, 0xB7C00000, 0x8FA00000, 0xCB500000, 0xEF880000, 0x818C0000, 0xAE2A0000, 0x41890000, 0x1A8C8000, 0x4FABC000, 0x2CC96000, 0xC9EC3000, 0x52DB7800, 0x09502400, 0x8E881200, 0x2D0D5100, 0x75EA4B80, 0x34288D40, 0x9CDD87A0, 0x16A23490, 0x0B855E58, 0xFCE6D3F4, 0x6FC24B82, 0x73F48D41 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x78000000, 0x24000000, 0x72000000, 0xA7000000, 0xE7800000, 0x7B400000, 0x5D600000, 0x79B00000, 0xCA380000, 0x115C0000, 0xF7060000, 0xC4390000, 0x905C8000, 0x1D874000, 0xEBF96000, 0x5BFC7000, 0xC1170800, 0x90918400, 0x25693E00, 0x5794C700, 0xB0027280, 0x115204C0, 0x769AF460, 0xEB1F46F0, 0x69B57678, 0x60D3826C, 0x38DA7282, 0x66FE04C1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x38000000, 0x3C000000, 0xD6000000, 0xCD000000, 0xA2800000, 0x29C00000, 0xDAA00000, 0x39F00000, 0x70280000, 0x5FBC0000, 0x3B820000, 0xCD290000, 0x853C8000, 0x8E434000, 0x3188E000, 0x49CCF000, 0x60EB3800, 0x91F54C00, 0x65EF6A00, 0x36B37D00, 0x4D219F80, 0x6EB19F40, 0x0549EEE0, 0xB9EC8FD0, 0xD4DA9838, 0x217D95E4, 0x20A39F82, 0x2E989F41 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xA8000000, 0x64000000, 0xA6000000, 0x93000000, 0xCD800000, 0x63C00000, 0xB1E00000, 0x8E700000, 0x72680000, 0x769C0000, 0x882A0000, 0xC9690000, 0x9F1C8000, 0x6DEA4000, 0x3B88A000, 0x74EDD000, 0x18428800, 0x5AF5EC00, 0xE1B6F600, 0x6EC21300, 0xD0B5AB80, 0xB597D5C0, 0x1252AFE0, 0x492C1F50, 0xB6A3F0F8, 0xFB04F3B4, 0x151FAB82, 0x5F3ED5C1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x28000000, 0x44000000, 0x8A000000, 0xCD000000, 0x79800000, 0xA1C00000, 0x3B200000, 0x6B500000, 0x3DC80000, 0xA7940000, 0x16C20000, 0x88C90000, 0xD2148000, 0xC9024000, 0x4CE82000, 0x61C4D000, 0xE28AC800, 0x369D3400, 0x93F74A00, 0xE49B3B00, 0xE434F780, 0xBBD37C40, 0x60E0CDA0, 0x4571DC10, 0xF3183B68, 0x4D9CB424, 0xA176F782, 0x8FDA7C41 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x28000000, 0x94000000, 0xCE000000, 0x0F000000, 0xF2800000, 0xA0400000, 0xDC200000, 0xEAB00000, 0xDAA80000, 0xABA40000, 0x5BFA0000, 0xF1A90000, 0xAF248000, 0x28BAC000, 0xD509A000, 0x0CD4D000, 0x47B3E800, 0x08DC3C00, 0xFEE6CE00, 0xD9AF0D00, 0x6C5BFC80, 0x8AD8B640, 0xB96DF860, 0x38CF59D0, 0xED4A2908, 0x6101E394, 0x8D81FC82, 0x4AC1B641 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x48000000, 0xCC000000, 0xAE000000, 0xC3000000, 0x30800000, 0xC9C00000, 0xE1200000, 0x3C100000, 0xC6280000, 0x434C0000, 0xE3620000, 0xD6A90000, 0x1A8C8000, 0xEA434000, 0xF6B8A000, 0x3AA41000, 0xA60ED800, 0x8B5BFC00, 0xE6CC9600, 0x6D223900, 0x94C92F80, 0x377DF440, 0x28DA5120, 0x178C7BD0, 0x29C38ED8, 0x37F981E4, 0x4645AF82, 0x513EB441 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x48000000, 0x8C000000, 0xA6000000, 0x3D000000, 0xC1800000, 0xCC400000, 0x76E00000, 0xF9900000, 0xF4B80000, 0x847C0000, 0xBB0A0000, 0x65390000, 0xC03D8000, 0x61EA4000, 0xEAA8A000, 0x41851000, 0xA8175800, 0x3BE3EC00, 0x6F5C6A00, 0x503B5B00, 0x62F03480, 0x776827C0, 0x5325B820, 0x5B6785F0, 0x08CB4338, 0xE698E434, 0x84CDB482, 0xEB8267C3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x98000000, 0xBC000000, 0x96000000, 0x25000000, 0x2D800000, 0x54400000, 0x77200000, 0x49100000, 0x05180000, 0x234C0000, 0xC1120000, 0x90990000, 0xDB0C8000, 0xE833C000, 0x68886000, 0x4195B000, 0x903EB800, 0x403B4C00, 0xC4DCFA00, 0x40CA6300, 0xE1342480, 0x566E7440, 0xFE824120, 0x4D4016B0, 0x8CA1BED8, 0xD850D904, 0xEFB8A482, 0xA61DB441 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x68000000, 0x3C000000, 0xA6000000, 0xAB000000, 0x4F800000, 0x15C00000, 0x4D600000, 0xB9D00000, 0x52E80000, 0xD6740000, 0x61A60000, 0x05690000, 0xF7B48000, 0x26C64000, 0x69B86000, 0x15DC5000, 0x30F23800, 0x5DBF2C00, 0x00840600, 0x763E2700, 0xA7454780, 0x2A5EFCC0, 0xEC1404A0, 0xE1F65A50, 0x1140BC28, 0xC721E1EC, 0x1971C782, 0x4258BCC1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x28000000, 0xFC000000, 0xEE000000, 0x19000000, 0xAB800000, 0x43400000, 0x45200000, 0x88700000, 0x1DF80000, 0x3BC40000, 0xAD5A0000, 0x8E790000, 0x5C858000, 0x727B4000, 0x3D096000, 0x35FDD000, 0x447EB800, 0xD3B2BC00, 0x2C94E200, 0x63D26F00, 0x4CC57A80, 0xDFDB0840, 0xC6B9AFE0, 0x6AE57970, 0x972A03C8, 0x5481B754, 0xFDC0FA82, 0xCBE04843 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x28000000, 0x94000000, 0xB2000000, 0x6D000000, 0xF8800000, 0xFD400000, 0x21200000, 0x29D00000, 0x3A180000, 0x295C0000, 0x1AEA0000, 0xF0990000, 0xF91C8000, 0x634B4000, 0xD408E000, 0xCA24D000, 0xF7C66800, 0x46FB8400, 0x7EE10A00, 0xECB11900, 0x28683E80, 0x72D52840, 0x6C0EDAA0, 0x31BEC2B0, 0xD7562EF8, 0xFFC38D74, 0x6B6CBE82, 0x78C26841 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xA8000000, 0x54000000, 0x1E000000, 0xF5000000, 0x35800000, 0xA2400000, 0x2DE00000, 0x64100000, 0xE3780000, 0xF69C0000, 0x269E0000, 0xB8F90000, 0x59DD8000, 0xA2FEC000, 0xA4A82000, 0xD444D000, 0xA4F26800, 0xE88E1C00, 0xE0803A00, 0xA7C18300, 0xD7A09880, 0x25F1C1C0, 0x65695B20, 0xAAE41670, 0x0E8260F8, 0xFCA6041C, 0x5B051882, 0x109301C3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x28000000, 0xA4000000, 0xFA000000, 0x71000000, 0x4F800000, 0x28400000, 0x94E00000, 0xDA300000, 0x6E580000, 0x00DC0000, 0xA2F20000, 0xE7D90000, 0x8F9D8000, 0xC692C000, 0x0928E000, 0xEFE5D000, 0xB15F8800, 0x28131400, 0x16E83200, 0x4F449700, 0x798E8480, 0x9B7B7BC0, 0x18ECB360, 0x01AB7030, 0xBE841E78, 0xDA2EBC84, 0x592B0482, 0xEE45BBC3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xA8000000, 0xE4000000, 0x2A000000, 0xC3000000, 0x31800000, 0x30400000, 0xEF600000, 0xB6B00000, 0xC6680000, 0xEBB40000, 0xC2C20000, 0x8CE90000, 0x66758000, 0x73E34000, 0xAC382000, 0x4C2CD000, 0xBBFE8800, 0x706E7400, 0x98D65600, 0x103A6B00, 0x7864D480, 0x811AE8C0, 0x08B4F660, 0xA3438050, 0xB4A903A8, 0xFD1431E4, 0x47535482, 0x4D50A8C3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xF8000000, 0x2C000000, 0x92000000, 0x8D000000, 0xB4800000, 0x9B400000, 0x7FA00000, 0x81300000, 0x9FD80000, 0xC5E40000, 0xD1BA0000, 0x4A590000, 0x18248000, 0x285A4000, 0x48486000, 0x498D7000, 0xB3C61800, 0xC2274400, 0x74376A00, 0x0B9EF100, 0xC702B280, 0xA0ECB540, 0x0C966360, 0x4F2EA530, 0x8D1A0288, 0x68E99E14, 0xD13C3282, 0xB3DFF541 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xE8000000, 0x2C000000, 0x56000000, 0x3D000000, 0x68800000, 0xE6C00000, 0xDB200000, 0x79100000, 0x1A580000, 0x03340000, 0x415E0000, 0xD3D90000, 0x73748000, 0x4DBE4000, 0x7F696000, 0x23FD5000, 0xCB721800, 0xF4D3CC00, 0x4D022A00, 0x797B4900, 0x77DEC180, 0x7419BC40, 0x6ED50B20, 0x1B6EFD30, 0x44918E28, 0xF8197F9C, 0x48D44182, 0xEE6EFC41 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x78000000, 0x84000000, 0xEE000000, 0xD1000000, 0x6B800000, 0xF3400000, 0xDDE00000, 0x32F00000, 0xD1280000, 0x7C540000, 0x716A0000, 0x17A90000, 0xCE948000, 0x40CA4000, 0x1239A000, 0xCD8C7000, 0x47174800, 0x1E167C00, 0x9996D200, 0x58D61F00, 0x6E375A80, 0x704789C0, 0x6CAE2AE0, 0xBBDB00D0, 0x07E1A568, 0x45F1B634, 0xE7A9DA82, 0xA694C9C1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x88000000, 0xE4000000, 0x36000000, 0x93000000, 0xF4800000, 0x0EC00000, 0xB3E00000, 0x8E700000, 0x0DE80000, 0xB83C0000, 0x9A360000, 0xF6690000, 0x087C8000, 0xCE164000, 0x2E79A000, 0x5CA59000, 0x45638800, 0xFDA3CC00, 0x9D43B600, 0xC7B3E100, 0x949B1180, 0x174631C0, 0xE7014DE0, 0x2A80D250, 0x09C165B8, 0xA960F38C, 0x7FB19182, 0x988971C1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x58000000, 0xDC000000, 0x02000000, 0x53000000, 0x98800000, 0x04400000, 0xEEA00000, 0x19500000, 0x48A80000, 0x52B40000, 0xDF1E0000, 0x91290000, 0x55758000, 0x797E4000, 0x9499E000, 0x3F2D3000, 0x6FB3F800, 0x9C5BE400, 0x02CE9600, 0x1FC04900, 0x9A612C80, 0x57B16B40, 0x1158EBA0, 0x0A4D95D0, 0xD2826228, 0x82431F9C, 0xA2A2AC82, 0xD2522B43 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x58000000, 0x6C000000, 0xCE000000, 0x9D000000, 0xE3800000, 0xFB400000, 0xFE200000, 0xC4900000, 0x3BF80000, 0xF5AC0000, 0xC4DA0000, 0x67790000, 0x7E6D8000, 0xDF3AC000, 0x3509E000, 0xDC653000, 0x47DE1800, 0x35167C00, 0x2C930A00, 0x8C3D5F00, 0xCCA3CA80, 0x21955640, 0x00974620, 0x86D3B570, 0x4F9C0918, 0x46729194, 0x33CC4A82, 0x68EA9643 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x78000000, 0xCC000000, 0x4A000000, 0x83000000, 0xFB800000, 0xFBC00000, 0xE0600000, 0x97500000, 0x29B80000, 0x73D40000, 0xA9DA0000, 0x12790000, 0x73B48000, 0x2E8B4000, 0xF3C06000, 0xB4607000, 0x0150D800, 0x28B9F400, 0xBF55F600, 0x2F9A6F00, 0xC0D86380, 0x7C0446C0, 0x902399A0, 0xB20DC4F0, 0x195F5768, 0x041BA514, 0x13180382, 0x386436C1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xB8000000, 0xFC000000, 0x8A000000, 0x53000000, 0xD1800000, 0x46C00000, 0x48E00000, 0x07B00000, 0xF1680000, 0x230C0000, 0x41A60000, 0x8FA90000, 0xD7EC8000, 0xAC16C000, 0x3DC12000, 0x9D61F000, 0x57713800, 0x70893400, 0x1E3DD600, 0xDB8E5B00, 0x28849980, 0x8A1AB7C0, 0x04E66C60, 0x7E88CF50, 0x1B3DE7D8, 0xA30F942C, 0x44C5B982, 0x11BB47C1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xD8000000, 0xB4000000, 0xDA000000, 0x11000000, 0x95800000, 0x10400000, 0x2BE00000, 0x3B300000, 0x24680000, 0xA78C0000, 0x100A0000, 0x7C290000, 0x006C8000, 0xB53B4000, 0x1B41A000, 0x4F613000, 0x4EF02800, 0x97C91400, 0xDB5D9200, 0x61524300, 0x34CC9480, 0x336AF5C0, 0x5CD91D60, 0x5CA44850, 0xEAE7E8D8, 0xFFD29E74, 0x400D3482, 0x6D4BC5C1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xB8000000, 0xF4000000, 0xE6000000, 0xFD000000, 0x00800000, 0xE8C00000, 0xB9200000, 0xC7300000, 0x0DC80000, 0xE63C0000, 0xD48E0000, 0xB1090000, 0xA91C8000, 0x06BEC000, 0xC0416000, 0x0DE1F000, 0x84112800, 0xADF9AC00, 0xBC748A00, 0x35F3E900, 0x2FE71D80, 0x73450840, 0x343BCF60, 0xBBDA6A10, 0x8CCA2E38, 0xC0B3FF7C, 0x0E867D82, 0x3D94F841 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xC8000000, 0x2C000000, 0xA6000000, 0x8D000000, 0xB3800000, 0x55C00000, 0x70A00000, 0x65D00000, 0x16D80000, 0xC8A40000, 0x702A0000, 0x67190000, 0xD2048000, 0xAEFB4000, 0xB7416000, 0x18E11000, 0x71B11800, 0xEE292C00, 0x876C8A00, 0xE7773F00, 0xC486E780, 0x9DCE7B40, 0x50D36CA0, 0x882C2630, 0xBB974008, 0x0F37C3F4, 0x90E78782, 0xC53F6B41 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x38000000, 0xB4000000, 0xC2000000, 0x03000000, 0x95800000, 0x36400000, 0x52E00000, 0x5F700000, 0xC7580000, 0x46BC0000, 0xCC460000, 0x4D190000, 0xEA5C8000, 0x2E36C000, 0xC2C02000, 0x4220F000, 0x6651A800, 0xE088A400, 0xC2747600, 0x67D24300, 0x543AE880, 0x8D7F23C0, 0xB414D5E0, 0x70628230, 0x8E42B8B8, 0x16129E6C, 0x4B9AC882, 0xC16FD3C1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x58000000, 0xD4000000, 0x12000000, 0xCB000000, 0xA8800000, 0xB2400000, 0xBDA00000, 0x2CF00000, 0x8F580000, 0xB2CC0000, 0xD2320000, 0xDF190000, 0x4C6C8000, 0x3A43C000, 0xB4002000, 0xC2003000, 0x73006800, 0xEC810400, 0xF8412600, 0xA2A0F900, 0x96714080, 0xF618ED40, 0xA7ED08E0, 0x4C827A30, 0xEDE11ED8, 0xD2517D84, 0x67296082, 0xD9D4DD41 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x58000000, 0xA4000000, 0xFA000000, 0xD5000000, 0x76800000, 0x5E400000, 0x2D200000, 0xC9F00000, 0x83F80000, 0x32FC0000, 0x62DE0000, 0xBFB90000, 0xCEDC8000, 0x57AFC000, 0x7F002000, 0x5B803000, 0xFCC08800, 0x4160D400, 0xCDD11A00, 0x6289A500, 0xC0454880, 0xDE83F040, 0x3C567EE0, 0x81FC3B70, 0x4F5F7FB8, 0x0078B65C, 0x2A3D6882, 0x39BFC041 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x38000000, 0x84000000, 0xC6000000, 0x13000000, 0x3A800000, 0x44400000, 0x7B200000, 0x06B00000, 0x77B80000, 0x9E5C0000, 0x97BE0000, 0x79F90000, 0xAC7D8000, 0x6A8FC000, 0xED81E000, 0x98C1F000, 0xBC60C800, 0x0F116C00, 0x89485600, 0xD0C57D00, 0xDA530480, 0xB07FD040, 0x3518F860, 0x6E2C27F0, 0x8366EAF8, 0xA834B21C, 0xA7CAE482, 0x57122043 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xC8000000, 0xA4000000, 0x1A000000, 0x7D000000, 0xE0800000, 0x2A400000, 0x8FA00000, 0xFB500000, 0xB0F80000, 0x30140000, 0x95B60000, 0x87B90000, 0x4F348000, 0xDCA74000, 0x24E0E000, 0xF2711000, 0x3AE80800, 0x14CDD400, 0x9F336A00, 0x24978900, 0x21A9E080, 0x75EC2540, 0x412297A0, 0xD24E4570, 0xF22C2768, 0x2C4261CC, 0x78FF0082, 0x14243541 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xC8000000, 0xE4000000, 0x5E000000, 0x67000000, 0x86800000, 0x0CC00000, 0xE1A00000, 0x9C700000, 0xD0F80000, 0x7E040000, 0x5E1A0000, 0x53390000, 0xAD258000, 0xF8AB4000, 0x71602000, 0x5FD01000, 0xF9888800, 0x657D9C00, 0x5B5F5E00, 0xE5C3C500, 0x578C2580, 0x9367CD40, 0xDC6755E0, 0x4EE78870, 0xE426A748, 0xDE8610D4, 0xB6760582, 0xB74EDD43 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x18000000, 0x8C000000, 0xAE000000, 0xE1000000, 0x5E800000, 0x39400000, 0x74600000, 0xCDD00000, 0x2A180000, 0x164C0000, 0x198A0000, 0x3E590000, 0xF2AD8000, 0xDC1B4000, 0x56A1E000, 0x8471B000, 0xB9E85800, 0xFC65BC00, 0xFACFF200, 0x2A26A500, 0x0CC3AE80, 0x254CEAC0, 0xD00B06A0, 0x9498B6B0, 0x3F0C8C58, 0xA5EA9CB4, 0x17884E82, 0xE2B45AC3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x28000000, 0x7C000000, 0x7A000000, 0x13000000, 0x7B800000, 0x02400000, 0xD0600000, 0x15700000, 0x11780000, 0x2A3C0000, 0x1D660000, 0xB4390000, 0xD7DC8000, 0x5B564000, 0x79A16000, 0xBF50D000, 0x9068B800, 0x30349400, 0x1B227600, 0xEDE30F00, 0x6E437080, 0x821246C0, 0x49FB7DE0, 0x4B8FD670, 0xA8CCFCB8, 0x2C5EEC2C, 0x29641082, 0x924B96C1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xF8000000, 0x4C000000, 0x72000000, 0xBB000000, 0x36800000, 0x1E400000, 0xA0E00000, 0x8DD00000, 0x14980000, 0xFDAC0000, 0x09F20000, 0xB3D90000, 0xE8CD8000, 0x40E34000, 0x9BE0E000, 0x7B507000, 0xAAD9D800, 0xAD4D0400, 0x7C228600, 0xEB41F500, 0x67615880, 0xF21177C0, 0x1EB896A0, 0x8DDDE5B0, 0x4ADA2298, 0xBB7CEC44, 0x13EBB882, 0xBC3407C3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x28000000, 0xBC000000, 0x76000000, 0xF3000000, 0x7F800000, 0x18400000, 0xF4E00000, 0x6BB00000, 0x2A180000, 0x2F2C0000, 0xD2DA0000, 0x0F590000, 0xB34C8000, 0x1CAA4000, 0xC0E16000, 0xD1B0D000, 0xA7193800, 0x2FAC8C00, 0xEB1BB600, 0xACF88700, 0x259C5C80, 0xB6424FC0, 0x4EB54860, 0x5FB6B4B0, 0xA4638F98, 0xD7247ED4, 0xBC3F3C82, 0x50C79FC1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xE8000000, 0x8C000000, 0x96000000, 0x43000000, 0xF8800000, 0xB6C00000, 0x18200000, 0xCEB00000, 0x6FD80000, 0xBB940000, 0x38520000, 0x88190000, 0x32358000, 0xE5A2C000, 0x8EA0E000, 0x6F705000, 0x1D79D800, 0x6AE4CC00, 0x8A2B5600, 0x7C7DE900, 0xA5DFC180, 0xF57F7640, 0xC50F0C60, 0xAEF62230, 0x55D3FF68, 0x2558B1C4, 0xF4552182, 0x9DF22643 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x68000000, 0x8C000000, 0x9E000000, 0xD5000000, 0x19800000, 0xF5C00000, 0xF0E00000, 0x70100000, 0x9D680000, 0x555C0000, 0x078A0000, 0xD7A90000, 0x533C8000, 0xFCDB4000, 0x8D602000, 0xD7D05000, 0x86885800, 0x79CC1C00, 0x1EA37A00, 0x0BD42B00, 0x4A465780, 0x130A0BC0, 0x0FE87320, 0x8C1DC150, 0x2B2A3378, 0x5A992334, 0xAAA47782, 0x56FF5BC1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0x28000000, 0xA4000000, 0x0E000000, 0x53000000, 0x07800000, 0x66C00000, 0xDDE00000, 0xDBB00000, 0xD3180000, 0x32C40000, 0x80520000, 0x5A590000, 0x8DE48000, 0xD803C000, 0x99F06000, 0xE7B8D000, 0xA6548800, 0xC31B7C00, 0xBF35F600, 0x41EBC700, 0x0B0C1180, 0x477EFDC0, 0x52F72860, 0x027AC3B0, 0x51C5D248, 0xEFD379C4, 0x7898F182, 0xEE05EDC1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x98000000, 0xF4000000, 0x06000000, 0x13000000, 0xC5800000, 0xCCC00000, 0xA6600000, 0x0B300000, 0xA3480000, 0x53540000, 0x1C220000, 0x46090000, 0x0BF58000, 0x04734000, 0x28F12000, 0x6AA8B000, 0xD5A4A800, 0xD98A2C00, 0x9C2C1600, 0xEFBFE300, 0x76BFD580, 0x223FCAC0, 0x167F6D60, 0xD65ED710, 0x184F3668, 0x3B973024, 0xB65B7582, 0x4B143AC3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x38000000, 0x14000000, 0xAE000000, 0x0F000000, 0xC1800000, 0x98400000, 0xB7200000, 0x11500000, 0x1ED80000, 0x82E40000, 0x070E0000, 0x09190000, 0x72848000, 0x38FEC000, 0x1AD02000, 0xCF98F000, 0xB744E800, 0x659E7C00, 0xA1A16E00, 0x8C912B00, 0xC7B8AC80, 0xAF945040, 0x5F07D1A0, 0x16642530, 0x2FCFB788, 0xB0F9F2BC, 0x09340C82, 0x8E166041 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x78000000, 0x2C000000, 0xF6000000, 0x6B000000, 0xB1800000, 0x53400000, 0x23A00000, 0x70900000, 0xDA680000, 0x18340000, 0xC97E0000, 0x7EA90000, 0x3BD48000, 0x27CE4000, 0x41116000, 0xC9287000, 0x1B941800, 0x89EF8C00, 0xDCC12600, 0x0FE1BB00, 0x18B10A80, 0x54B8F140, 0x437D7220, 0x6F1B4A50, 0xEB5E9B28, 0x657825DC, 0xCE1CEA82, 0x896AC141 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0xD8000000, 0x34000000, 0x92000000, 0x6F000000, 0xF0800000, 0x38C00000, 0x88600000, 0x16D00000, 0xB2880000, 0x4F7C0000, 0xD4A20000, 0x10C90000, 0xD4DC8000, 0xC093C000, 0xDF50A000, 0x2FC93000, 0xBC5DA800, 0x2C528400, 0x15306E00, 0x8E190900, 0xCA549580, 0xC9EE6EC0, 0x26F37CA0, 0x7880FC90, 0x94C1EA38, 0xCE613AE4, 0x3BD0B582, 0xF5089EC1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x08000000, 0xDC000000, 0xBE000000, 0xD5000000, 0xBC800000, 0x65400000, 0x11600000, 0x74B00000, 0x43F80000, 0x41E40000, 0xE11A0000, 0xB0390000, 0x22C58000, 0xC34AC000, 0x73B0E000, 0x3C799000, 0x01257800, 0x6FBA9C00, 0xB1A8BA00, 0xDA6D4100, 0xBBA77680, 0xE85768C0, 0x81CF0060, 0x451BB570, 0x1A387D08, 0xF5C43154, 0xE4CA1682, 0x777038C3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xA8000000, 0xAC000000, 0xDA000000, 0x9B000000, 0x5A800000, 0xE1400000, 0xF3E00000, 0x1FB00000, 0x89280000, 0xA8FC0000, 0x188A0000, 0xBCE90000, 0x2F5D8000, 0xFB5B4000, 0x64B06000, 0x03A8D000, 0xF1BC1800, 0x5F6AD400, 0x7D596600, 0x4B746D00, 0x48273680, 0x5CFAB1C0, 0xF7615A60, 0xD3F148D0, 0xC1492238, 0x278D0874, 0x7182D682, 0xB50521C3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x88000000, 0x2C000000, 0x56000000, 0xD7000000, 0xFA800000, 0x04C00000, 0x20600000, 0xD9700000, 0xC7680000, 0x6C3C0000, 0xF41E0000, 0x2E290000, 0xD21C8000, 0xD9CE4000, 0x6850E000, 0x04399000, 0xFC841800, 0x5F5B4C00, 0x2193BE00, 0x273E2D00, 0x18796580, 0x6D24CEC0, 0xA9CAF7E0, 0x14CA2F50, 0x774AFCB8, 0x2A0AC0DC, 0xF62B0582, 0x2EFA1EC1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x98000000, 0xF4000000, 0x96000000, 0x29000000, 0xC3800000, 0x17C00000, 0x6C200000, 0x5A100000, 0xF9C80000, 0xDA6C0000, 0xC0AE0000, 0x4C890000, 0x3E0D8000, 0xBB5F4000, 0x3870E000, 0xA338B000, 0x5114A800, 0x405ACC00, 0x19E26200, 0x94B6EF00, 0x930CC380, 0xB6DFAA40, 0x52B1A320, 0x6A996410, 0xADC5D898, 0xE232437C, 0x185FA382, 0xE8F15A43 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xA8000000, 0x3C000000, 0xE6000000, 0xD5000000, 0x00800000, 0xA1400000, 0x61200000, 0x5ED00000, 0x4F780000, 0xAF5C0000, 0x1C620000, 0x87B90000, 0x49BD8000, 0x77D24000, 0xC7B16000, 0xFE08D000, 0xD6B43800, 0x4BE7AC00, 0xB617FA00, 0xC0BEF900, 0x0F1A4E80, 0x1EE5C840, 0x38DE4CA0, 0x54EBD470, 0x5D4D98F8, 0xE7FA0B64, 0x7C54AE82, 0x8E565843 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x48000000, 0xE4000000, 0x4E000000, 0xD3000000, 0xCB800000, 0x10400000, 0xE0600000, 0xAF500000, 0x57780000, 0x87CC0000, 0x0F860000, 0xD3B90000, 0xE66D8000, 0x25F74000, 0x07716000, 0x44491000, 0x3DE48800, 0x9632FC00, 0x45723600, 0xD692DF00, 0x65837C80, 0x489BC6C0, 0xB507F9A0, 0x11787670, 0xD0CDAB58, 0x1A0603AC, 0x68F99C82, 0x618C96C3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x88000000, 0xDC000000, 0x5E000000, 0x71000000, 0x0E800000, 0x22C00000, 0xA2A00000, 0xCE700000, 0x23480000, 0xD9EC0000, 0xE8FA0000, 0x30090000, 0x8E0C8000, 0xC46AC000, 0x5B50A000, 0x3D799000, 0x94C57800, 0x74C71C00, 0x6F4AF200, 0xE4602500, 0xF6D0B980, 0xF638C740, 0xD72531E0, 0xBA56AB10, 0xFB12F298, 0xA0959314, 0x563E9982, 0x07CE9741 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x28000000, 0x8C000000, 0xC2000000, 0x97000000, 0xEE800000, 0x66400000, 0xAEA00000, 0xD4700000, 0x8A280000, 0xF8E40000, 0x30260000, 0x0FE90000, 0x1D848000, 0x1436C000, 0xB850A000, 0x0A18D000, 0xD36DD800, 0x86322400, 0xB5A67E00, 0x9D294500, 0x56650880, 0x36671340, 0x714885E0, 0xE1F410D0, 0x121EF088, 0x82B5C2AC, 0xAD3F2882, 0x32040341 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0xA8000000, 0xCC000000, 0xC6000000, 0x85000000, 0x4A800000, 0xBEC00000, 0x4DE00000, 0x0AD00000, 0x86B80000, 0xAD240000, 0x088E0000, 0x0DF90000, 0x8F858000, 0xEAFE4000, 0x0A302000, 0x7AE8D000, 0x4B5DD800, 0x994AAC00, 0xE7275A00, 0x35058D00, 0x8C3F3180, 0x93D1F1C0, 0x423970A0, 0xEAE4F8F0, 0xF1EEF588, 0x58E8D2BC, 0x045C9182, 0xB0CA61C3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x68000000, 0x0C000000, 0xC6000000, 0x03000000, 0x61800000, 0xE2C00000, 0xA6E00000, 0x54B00000, 0xF9480000, 0x5A340000, 0xFCFE0000, 0x5B090000, 0x76958000, 0xA8EFC000, 0x2050E000, 0xCCF95000, 0xEBFDD800, 0x108A6C00, 0xE957D600, 0x508C5B00, 0xF1A20980, 0xDA926BC0, 0x861BDA60, 0xC14FBF10, 0xD6C0CDA8, 0xD4E1AA9C, 0xE5B16982, 0xC9C9FBC3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0xAC000000, 0x56000000, 0xD9000000, 0xED800000, 0xE5400000, 0xABA00000, 0x68D00000, 0x98380000, 0x964C0000, 0x82220000, 0x6BF90000, 0xBE2C8000, 0x9A92C000, 0xAF702000, 0x86E99000, 0x27759800, 0xE1EF8C00, 0x289BA200, 0x84750300, 0xC36F2680, 0x995A0540, 0xB714BAA0, 0x6D5EF2F0, 0x6E136FD8, 0x87B17BE4, 0x38098682, 0xFC045541 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xF8000000, 0x7C000000, 0x6E000000, 0x0B000000, 0x24800000, 0xAD400000, 0x03200000, 0x1A100000, 0x25580000, 0x61440000, 0xFC2E0000, 0x76790000, 0x53558000, 0x4D76C000, 0x8D3DE000, 0x4E7A7000, 0x068F3800, 0x32A8BC00, 0x82ECA600, 0x1B429100, 0xEDFB9680, 0xD94F9840, 0x8BC81920, 0xA15C7A30, 0x7A4B4BC8, 0xF24637FC, 0x9D74AE82, 0x2CE72443 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xA8000000, 0xE4000000, 0xFE000000, 0x95000000, 0x27800000, 0x5EC00000, 0xC9200000, 0x9EF00000, 0xCA480000, 0xFA840000, 0xD46E0000, 0x37690000, 0x52758000, 0x5F274000, 0x2C6C2000, 0x01DAD000, 0x9CEF8800, 0xD5285C00, 0xEF14BA00, 0xADB7E700, 0x5D343180, 0xE9C7A040, 0xAA3D06E0, 0xEAA35F10, 0x14821248, 0x4AF20FBC, 0xD6FBB982, 0x671FFC43 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x68000000, 0x24000000, 0xA2000000, 0x99000000, 0x94800000, 0xC5400000, 0xDAA00000, 0xB0300000, 0x7BC80000, 0xAF7C0000, 0xC2BE0000, 0xCD690000, 0xC94C8000, 0x4A774000, 0x5B952000, 0x90325000, 0x25FE0800, 0xCEC8E400, 0x4DFC2200, 0xE4FE0100, 0x46493E80, 0xC6BC9F40, 0x315E0560, 0x31F82B10, 0x51B4A0B8, 0xB7434E9C, 0xC5973682, 0x19047B41 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xB8000000, 0xF4000000, 0x5A000000, 0x2B000000, 0x15800000, 0x21400000, 0xB9200000, 0x60700000, 0x5D780000, 0xD6AC0000, 0x505E0000, 0xCE590000, 0x45DD8000, 0x7CA74000, 0xEBB56000, 0xCBA2F000, 0x690FA800, 0xA3505400, 0xE609E600, 0x8654E300, 0x63B3E680, 0xC526BC40, 0x34F537E0, 0x2B82DA70, 0x4BFE8218, 0xDCE999DC, 0x2DC44E82, 0x6BDAE843 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xC8000000, 0xAC000000, 0x3E000000, 0xB1000000, 0xA8800000, 0x30400000, 0x87600000, 0x00100000, 0x1EF80000, 0x97F40000, 0x41760000, 0xAF990000, 0xAAE48000, 0x390EC000, 0xE12C2000, 0xA0731000, 0x34C69800, 0x5D50DC00, 0x1718B200, 0x12A5E900, 0x726EAC80, 0x4F3DA4C0, 0xC78AF520, 0xA7B28370, 0x1266B228, 0x8EE1634C, 0x10D03482, 0x65D978C1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x68000000, 0x84000000, 0x82000000, 0x53000000, 0xD2800000, 0x25400000, 0x33200000, 0x98B00000, 0xE7F80000, 0x8A3C0000, 0xE73E0000, 0x2AD90000, 0x5F8D8000, 0x4F474000, 0xB2246000, 0xC5535000, 0xEECF4800, 0xD400E400, 0x3A00B600, 0xAF008D00, 0x0C80FE80, 0x18411840, 0xB4A09860, 0xBE702770, 0x70187138, 0xD66D109C, 0x8E17B682, 0xEC8DFC43 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x58000000, 0x04000000, 0x2E000000, 0xE1000000, 0x26800000, 0x92400000, 0xBC200000, 0x9DD00000, 0x17180000, 0xAA8C0000, 0xC90A0000, 0xD2390000, 0xF5DC8000, 0x72534000, 0xCD946000, 0xDB863000, 0x0F324800, 0xE1E4BC00, 0x3A8EB200, 0xB3476500, 0x4B532880, 0xAF14C240, 0xC7C782A0, 0xE21304B0, 0x02B5FA58, 0xBBD6E434, 0x8BEB6082, 0xFE897E41 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x38000000, 0xDC000000, 0x06000000, 0xDF000000, 0xCF800000, 0x82400000, 0xE9200000, 0x92D00000, 0xB0F80000, 0x747C0000, 0x81720000, 0xEED90000, 0x0D2D8000, 0x89CBC000, 0x7A84A000, 0x360FF000, 0x462B7800, 0x6EB52C00, 0x9A478E00, 0x3FDF4700, 0x13525880, 0x4988E440, 0xD694EEA0, 0xEC17C770, 0xC0E673B8, 0xD94FF8C4, 0x9D8B2082, 0x54A4C843 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x08000000, 0xB4000000, 0xF2000000, 0x31000000, 0xE7800000, 0x18C00000, 0x84A00000, 0x9FF00000, 0x9EF80000, 0xD1340000, 0x56360000, 0xFF590000, 0xCB448000, 0x090FC000, 0x294CA000, 0xE0429000, 0x690FA800, 0xB94DC400, 0x08433200, 0x0D0FC700, 0x434DE580, 0x8D435340, 0x188F1CE0, 0x6A8CBA70, 0xEE633E28, 0x9FBF810C, 0x70D44D82, 0xA0A79741 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xF8000000, 0xCC000000, 0x46000000, 0xEB000000, 0xC0800000, 0xFFC00000, 0xDD600000, 0x7DD00000, 0xA9E80000, 0x4C340000, 0xACCE0000, 0x63890000, 0x8F658000, 0x3DE7C000, 0xC45C6000, 0xB2BA7000, 0x26675800, 0xC31D6C00, 0xBC1A6600, 0x70D7B900, 0x04256380, 0x554644C0, 0x29EDCEA0, 0xFD02E650, 0x04FBDDA8, 0xCD4728BC, 0x95EC3B82, 0xA30228C3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xA8000000, 0x0C000000, 0x16000000, 0x77000000, 0x28800000, 0xB8400000, 0x88A00000, 0x94900000, 0x7EB80000, 0x11840000, 0x7B2E0000, 0xD5190000, 0xBF958000, 0x00D6C000, 0x1DBC6000, 0x13EAD000, 0xA917D800, 0x76DDCC00, 0x551AFE00, 0x0ADEE900, 0xFE51EC80, 0x5F59F740, 0x9A34EC20, 0xBDC77FF0, 0x34C5C548, 0xB20F4AFC, 0x7A483482, 0xD74D3B43 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x48000000, 0x0C000000, 0xA6000000, 0xD9000000, 0xC1800000, 0x3E400000, 0x82E00000, 0x74500000, 0x80380000, 0xF01C0000, 0xBFC20000, 0x55D90000, 0xA0CC8000, 0x5E3B4000, 0x5464A000, 0xCA3E1000, 0xB2CA5800, 0xB8ED6C00, 0x894AE200, 0xF1AC7B00, 0xBF2A8080, 0x0C3C7FC0, 0x12B31FA0, 0xC71152F0, 0xC159ECF8, 0xB90CF4A4, 0x9B9AD882, 0xB35413C1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x28000000, 0x94000000, 0x56000000, 0xB7000000, 0xBF800000, 0x73C00000, 0x75200000, 0x48D00000, 0x2E480000, 0x0EFC0000, 0x852E0000, 0xC2690000, 0x52AD8000, 0xD526C000, 0x13752000, 0x5EF3D000, 0x7F96E800, 0x868C0C00, 0x35767E00, 0x817DB700, 0x6EEFBB80, 0x7B493C40, 0xE07DCAA0, 0xA66FE910, 0xD708EEB8, 0xF69D7F7C, 0xB39F5382, 0x25903043 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x38000000, 0xAC000000, 0xFE000000, 0xF3000000, 0x28800000, 0xFF400000, 0x14A00000, 0x2F100000, 0x93380000, 0xCA940000, 0xAC420000, 0xA6990000, 0x80048000, 0x7BBAC000, 0xFF6DA000, 0xD0B6F000, 0xD9AA9800, 0xF7D4DC00, 0xADE3D600, 0xCE086900, 0x52FC5280, 0x3DCE2740, 0x121F0B20, 0x384732F0, 0xCF221368, 0x1268B524, 0x208CCA82, 0xC907FB41 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x18000000, 0xF4000000, 0x82000000, 0x35000000, 0xD4800000, 0x16400000, 0x00A00000, 0x5BB00000, 0x2B980000, 0x95AC0000, 0x46020000, 0x08390000, 0x1D9C8000, 0x725B4000, 0xE3F5A000, 0x78CEB000, 0x49EBA800, 0x786C2400, 0x05639A00, 0xB3E8A100, 0x1E553880, 0x5BFEF340, 0xA2325260, 0x0A60A5B0, 0xE150C118, 0xA6895AE4, 0x02849082, 0x01B7D741 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x58000000, 0x8C000000, 0xF6000000, 0x15000000, 0x29800000, 0xAC400000, 0x53600000, 0x4B300000, 0xBA380000, 0xF5440000, 0xD20A0000, 0xBE590000, 0xE8F58000, 0xB6F3C000, 0xD4BCA000, 0x096F3000, 0x9F83D800, 0xB4E4CC00, 0xD09ADA00, 0x12F02B00, 0x2B182480, 0x9414E4C0, 0x2C839160, 0x10645AF0, 0x395BAD48, 0xCBD115F4, 0x7E49FC82, 0xC09D28C3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x48000000, 0xC4000000, 0x52000000, 0x65000000, 0x91800000, 0x54C00000, 0x85600000, 0x29100000, 0x8B280000, 0x11C40000, 0xA5160000, 0x05490000, 0x22548000, 0x207F4000, 0x3FACA000, 0x55721000, 0x342FC800, 0xD9248400, 0x46C79A00, 0x58014B00, 0x6C01BD80, 0xE60198C0, 0xAF01FD20, 0x788141D0, 0x53414848, 0xE6A0368C, 0x58F07582, 0x67781CC1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x88000000, 0xF4000000, 0x16000000, 0xD5000000, 0x0D800000, 0xC9400000, 0xD3600000, 0x42100000, 0xBBD80000, 0xBA940000, 0x93860000, 0x45390000, 0xA1C58000, 0x233EC000, 0xF1BD6000, 0xE39A9000, 0xEB922800, 0x0D7ECC00, 0x945CFA00, 0xAC4AD300, 0x95EB0E80, 0xA4DA14C0, 0x01F20B20, 0x78EEAB30, 0x69C47EE8, 0x773E58AC, 0xB7BCA682, 0x8E9A18C3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x18000000, 0xCC000000, 0x0A000000, 0x3F000000, 0x3C800000, 0x00C00000, 0x1EA00000, 0xA4700000, 0x74C80000, 0xFBE40000, 0xD1660000, 0xEEE90000, 0x23558000, 0x890E4000, 0x327DE000, 0xA87BB000, 0x6FC2D800, 0xE86E7400, 0x542C8E00, 0x2802C100, 0x964F8580, 0xB29D8B40, 0xD96B4DE0, 0x2B5ABA10, 0xEEF38988, 0xDB4784AC, 0x7E58DD82, 0xDF3DBF43 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xB8000000, 0xCC000000, 0x9E000000, 0x13000000, 0x50800000, 0x1AC00000, 0x4C200000, 0xDA100000, 0x69E80000, 0x3F0C0000, 0x12F60000, 0x29490000, 0x19DD8000, 0xC83E4000, 0x12D52000, 0xD302F000, 0x0EDAD800, 0x472F9C00, 0x04BD9600, 0xB04ED900, 0x3DCD1980, 0x42D7F640, 0xF5598120, 0xBF35C450, 0x81B26D58, 0xC5E39B4C, 0x78EA4182, 0xC4D62A43 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x88000000, 0x2C000000, 0xCA000000, 0x65000000, 0xBA800000, 0x0FC00000, 0xCD200000, 0x11D00000, 0x29A80000, 0x02940000, 0x6D920000, 0x7A090000, 0x3A858000, 0x061A4000, 0xA6CD2000, 0x43FE9000, 0x90671800, 0xE72B3400, 0x62951A00, 0x9D92CD00, 0xC209FB80, 0x8E85B840, 0x681BCAA0, 0x25CC6AD0, 0x567F2468, 0x40264004, 0x9F4B6382, 0xB1A4CC43 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x08000000, 0xCC000000, 0xA6000000, 0x89000000, 0x16800000, 0xFEC00000, 0x66A00000, 0x36300000, 0xBD380000, 0xA32C0000, 0x4D020000, 0xF9190000, 0x19DC8000, 0x5D9A4000, 0xC985A000, 0x26A69000, 0xCC4ED800, 0x838A6C00, 0x184CC200, 0x4413D500, 0x63514180, 0xD1287740, 0xD9E4C560, 0xFA37E1F0, 0xC146E818, 0x449E2CE4, 0xE8E31982, 0xC2C85B41 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x88000000, 0x5C000000, 0x32000000, 0xB5000000, 0xD6800000, 0x7BC00000, 0x27A00000, 0xC9300000, 0xBA580000, 0xD9E40000, 0x4DE20000, 0xD9790000, 0x4E158000, 0xAE9A4000, 0xBE6DA000, 0x240E9000, 0x8E37F800, 0xE3424400, 0x44C8BA00, 0xC28C7500, 0x025F6380, 0xA77F2D40, 0xBB8F7360, 0x8176F530, 0xA2233F88, 0x70D84924, 0x70251B82, 0xAF432943 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x18000000, 0x3C000000, 0xF6000000, 0xBF000000, 0xB8800000, 0x2C400000, 0xD4200000, 0x84100000, 0x79880000, 0x51440000, 0xAA9E0000, 0x5F290000, 0x70158000, 0xE0B7C000, 0x2EBD6000, 0x4363B000, 0x82EAB800, 0xFFAF0C00, 0x6B300E00, 0x9F192900, 0x858C2480, 0x3C7AFE40, 0x3766DD20, 0xDBD4C190, 0x6056A9C8, 0xB2CCAA9C, 0x5ADB1C82, 0x36363243 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xA8000000, 0x9C000000, 0x66000000, 0x8B000000, 0x87800000, 0x97400000, 0x7DE00000, 0xDB900000, 0x69280000, 0x3B140000, 0x351E0000, 0x99490000, 0xD2C58000, 0x21564000, 0x170C6000, 0xDB52D000, 0x58FA7800, 0x382F2C00, 0x40108600, 0x58689700, 0xEDF59280, 0xD90EE5C0, 0xCF211C20, 0x08309ED0, 0xA9D818E8, 0x6C6D8A9C, 0xB5026A82, 0xDBF389C3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x68000000, 0x4C000000, 0x5E000000, 0xA5000000, 0x7C800000, 0x65400000, 0x1FE00000, 0x50F00000, 0x8D080000, 0xE0EC0000, 0x2BA60000, 0x9B690000, 0x81DC8000, 0x700FC000, 0x3A95A000, 0xBA825000, 0xB6025800, 0x4B439C00, 0xC0A3DA00, 0xBA528100, 0xE85A4680, 0xC337DDC0, 0x0A504CE0, 0x32198E90, 0xE515D918, 0x3243DB2C, 0x2A229E82, 0x861281C1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0x44000000, 0xC6000000, 0x01000000, 0xC4800000, 0x07C00000, 0x4DA00000, 0x31D00000, 0xBF080000, 0xFA0C0000, 0xFA560000, 0xAF290000, 0x449C8000, 0x9D3EC000, 0xB655E000, 0x9992D000, 0x36534800, 0x7FF2EC00, 0xE8231200, 0x262AA100, 0x30A67380, 0x8931E140, 0xADB81EA0, 0xD9F40790, 0x3F435058, 0x74DA478C, 0x5ABFBB82, 0xF214CD41 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x58000000, 0x54000000, 0x82000000, 0x51000000, 0x49800000, 0x6EC00000, 0x60E00000, 0xE5700000, 0xDBA80000, 0xB7940000, 0x1A160000, 0x07C90000, 0xBFA58000, 0x329F4000, 0x7A4CA000, 0x7EAB3000, 0x750AE800, 0x285A2400, 0xD563D200, 0xCCAE5B00, 0x91C50980, 0xE3AF1BC0, 0x1745A5E0, 0xBBEEF4D0, 0x07E4C3E8, 0x923E9E4C, 0x7B9C6182, 0xDED37FC3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xB8000000, 0x84000000, 0xC6000000, 0xB1000000, 0x50800000, 0x90400000, 0xD8200000, 0x26900000, 0x6C480000, 0xB82C0000, 0x89520000, 0x9BE90000, 0xE37D8000, 0xF7FBC000, 0x16352000, 0xE356F000, 0xAD27C800, 0xC79F2C00, 0x314B5200, 0x18ECC900, 0x1133BC80, 0x3D584A40, 0x3DA4B820, 0x5D9EAE10, 0x124AA718, 0x676DC004, 0xF4F3F482, 0x5BB9A643 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x78000000, 0x3C000000, 0x6A000000, 0xC1000000, 0x30800000, 0x3FC00000, 0x98E00000, 0x22100000, 0xA1080000, 0x0DA40000, 0xBF9A0000, 0x6E690000, 0xB3F48000, 0xD4334000, 0xCC7DE000, 0x91567000, 0xA0863800, 0x1B6FB400, 0x61DBB200, 0x11C83900, 0xA2C57B80, 0x91CB9BC0, 0xADC19920, 0x25E06390, 0xD8912588, 0x2FC89394, 0xDDC5C382, 0x9E4A6FC1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x38000000, 0xE4000000, 0x5E000000, 0x79000000, 0xBF800000, 0xD0C00000, 0xD5A00000, 0x93B00000, 0x93D80000, 0xBE0C0000, 0x36B20000, 0xEEB90000, 0x7C1D8000, 0xD8DB4000, 0x926D2000, 0x9723F000, 0x6A118800, 0xF2691C00, 0x66D5C200, 0xDC3E9700, 0x4C4A6D80, 0xEB441140, 0xAA962460, 0x893E1430, 0x01CB7858, 0x70849384, 0x2BB6C582, 0x8ECEFD43 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x98000000, 0x84000000, 0x7E000000, 0x63000000, 0xC1800000, 0x17C00000, 0x61E00000, 0x3F100000, 0xC7280000, 0x3ED40000, 0x3C0A0000, 0xC9090000, 0x94258000, 0x4232C000, 0x67F46000, 0xB17AB000, 0x47F0C800, 0xE4B81C00, 0x2CBD3600, 0x057FEB00, 0x2432E380, 0x40F58DC0, 0x6EFA4120, 0x8331C7D0, 0xDCD8ED68, 0x806CD1B4, 0xDDB64B82, 0x46F721C3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0xC8000000, 0x84000000, 0x92000000, 0x87000000, 0xA7800000, 0xC4400000, 0x74E00000, 0x78700000, 0xB6B80000, 0xA4140000, 0x3C4E0000, 0xCA190000, 0xFE848000, 0xC7864000, 0x0834E000, 0xCD1F1000, 0x05704800, 0xA2384400, 0xBDD4DE00, 0x7FEFA700, 0x3B083C80, 0xF70C6FC0, 0x944ADBE0, 0xAB5F0BF0, 0x5E90FEE8, 0x29C8C8FC, 0x652C9482, 0x641B3BC1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xD8000000, 0xB4000000, 0x8E000000, 0xD7000000, 0xF4800000, 0x27400000, 0x94A00000, 0xA1100000, 0xD7A80000, 0x9FAC0000, 0x17A20000, 0x68490000, 0x401C8000, 0x701B4000, 0x5FCD6000, 0xF9D33000, 0x51112800, 0xEFA9FC00, 0xBBAD5E00, 0x71A2E100, 0xD349E280, 0x8E9D6F40, 0x0E5AF720, 0xE8ED2FD0, 0x8B02CF18, 0x35580BE4, 0x45B5AA82, 0xDAB7A341 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xA8000000, 0x0C000000, 0xC2000000, 0xE1000000, 0x32800000, 0x27C00000, 0x24A00000, 0xAE500000, 0xF8980000, 0xE7B40000, 0x09720000, 0x4FF90000, 0x3B448000, 0x38BBC000, 0x3D55E000, 0x4BC3D000, 0xA2D0D800, 0x1459E400, 0xFC955200, 0x00629D00, 0xFD019B80, 0x68811340, 0x82C17DA0, 0xA8209CB0, 0x0290B328, 0x03B919C4, 0x9EA4A382, 0x138B2741 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xB8000000, 0xA4000000, 0xA6000000, 0x3F000000, 0xB4800000, 0x30C00000, 0xD5600000, 0x82100000, 0xA7980000, 0x62DC0000, 0x01660000, 0xA4390000, 0xEAAD8000, 0xE06E4000, 0xB9BDA000, 0x4076F000, 0xC5200800, 0xC9B06C00, 0xA3E94E00, 0x19D48100, 0x71E25D80, 0x9B639CC0, 0xD0A3A120, 0x674390B0, 0x02926678, 0xD8EA776C, 0x0AE7F582, 0xE07900C3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xA8000000, 0xCC000000, 0x76000000, 0x43000000, 0x57800000, 0x5AC00000, 0x67200000, 0xB9B00000, 0x67C80000, 0x8A140000, 0x5C3A0000, 0x40290000, 0x51848000, 0x4EC2C000, 0xD4B52000, 0xA84BD000, 0x75405800, 0x79E04C00, 0x14911600, 0x53791700, 0x9D5D0980, 0x616FD040, 0x14F23060, 0xDBBD7C10, 0xCC7F3568, 0x4A4A9E94, 0x74407182, 0x1F604C41 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x98000000, 0x0C000000, 0x1E000000, 0x15000000, 0xD6800000, 0xA8C00000, 0xC6A00000, 0xA3700000, 0x50780000, 0x18040000, 0x37C60000, 0x24190000, 0x22D58000, 0xF54FC000, 0x09252000, 0x38F6B000, 0xF100D800, 0x8C819C00, 0xD7C0DA00, 0x07219500, 0x4E305D80, 0xF199BF40, 0x1D94D7E0, 0xBFAFDB70, 0xDF351048, 0x56DFF8EC, 0x684DA582, 0x835A9343 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xA8000000, 0x74000000, 0x22000000, 0x73000000, 0xAC800000, 0x63400000, 0x41600000, 0x6A300000, 0xDC180000, 0xAE940000, 0x179E0000, 0x05390000, 0xAD458000, 0x78F6C000, 0xC9D5A000, 0x2CFED000, 0xF0092800, 0x73DD6400, 0x38237600, 0x16AA1100, 0xDD375280, 0x7CF4CCC0, 0x412E2960, 0x7261A8B0, 0x66B01EE8, 0x8F5901DC, 0x17F5DA82, 0xA1AE78C3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x98000000, 0xFC000000, 0xC6000000, 0xAF000000, 0x2D800000, 0x6C400000, 0x13200000, 0xEA500000, 0x10280000, 0xD58C0000, 0x39FE0000, 0x6C490000, 0x6F7C8000, 0xC4C74000, 0xDD4DE000, 0xF41FB000, 0xECF9B800, 0x6665EC00, 0xA6132E00, 0x98464300, 0x8F8DE480, 0xC0FF4040, 0xA6C8A3A0, 0x3ABCF6D0, 0x19A65E58, 0xB13CEBDC, 0x4AE7BC82, 0xC79C1C41 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xC8000000, 0x5C000000, 0x6A000000, 0x95000000, 0x20800000, 0x89C00000, 0x99E00000, 0x16D00000, 0xCF680000, 0xEC840000, 0x7F7E0000, 0xA0490000, 0x16358000, 0xEF87C000, 0xA3856000, 0xC2FE1000, 0xB5087800, 0x5C153400, 0x3DB77A00, 0x06BD9900, 0x02D3D780, 0x2A1261C0, 0xB57258A0, 0xCD637750, 0x8A6B33C8, 0x277FA4DC, 0x2448CF82, 0x383445C3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x28000000, 0xB4000000, 0x16000000, 0x97000000, 0xA1800000, 0x07C00000, 0xDAA00000, 0x19900000, 0xD3080000, 0xA41C0000, 0x751E0000, 0x1F690000, 0x59AD8000, 0x9DC7C000, 0x5B1CA000, 0x409FD000, 0x3EA9A800, 0xEC0C0C00, 0xB9D6BE00, 0x2DD48B00, 0xBF23F380, 0x64A73340, 0x862C7C20, 0x99069790, 0x063DB678, 0x31CE8A9C, 0x0A80FB82, 0xF441EF43 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x28000000, 0x54000000, 0x3A000000, 0x75000000, 0xA0800000, 0x55400000, 0xE2600000, 0xE2300000, 0x87880000, 0xBF7C0000, 0x436A0000, 0xC7A90000, 0x06AD8000, 0x4513C000, 0x4B7D6000, 0x696BD000, 0x4AA86800, 0xEA2D9400, 0x56537A00, 0xB21C8900, 0x64DB0E80, 0x4DE146C0, 0x42F11160, 0x4028DF90, 0xF26D3338, 0xB8B3CC34, 0x736C0682, 0x323202C3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x38000000, 0x0C000000, 0x0A000000, 0xDD000000, 0xCB800000, 0xA7C00000, 0xDC600000, 0xE5500000, 0x49880000, 0x7FBC0000, 0xB7820000, 0xA1290000, 0x4E0D8000, 0x7C1BC000, 0xF83D6000, 0x3A43F000, 0x7048D800, 0x68DDF400, 0xA6520A00, 0x5DE0EF00, 0xBF90AB80, 0x8E69DAC0, 0x352C29A0, 0x166A1690, 0x3DC5C8B8, 0x67067E24, 0xB40F1382, 0x6DF2DEC3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x58000000, 0xDC000000, 0x6A000000, 0xB9000000, 0x7B800000, 0x08C00000, 0xE3E00000, 0x20100000, 0x2B180000, 0xB8CC0000, 0x9CCA0000, 0xD7B90000, 0x61FC8000, 0x0122C000, 0x5DFDE000, 0x5B223000, 0xDCFC7800, 0x8CA2B400, 0xE63C0200, 0x0A432F00, 0xD7ADB580, 0x909B6DC0, 0xF7011320, 0x2480EDB0, 0xE840E558, 0xDDA14234, 0x5EB0AD82, 0xEF2929C1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xE8000000, 0xCC000000, 0x92000000, 0xBF000000, 0x5C800000, 0xF0400000, 0x6E200000, 0x7E300000, 0xB0980000, 0x0FEC0000, 0x79C60000, 0xB6790000, 0x21BD8000, 0x7C4EC000, 0x08BDA000, 0x31CE5000, 0x517C5800, 0x382E0400, 0x5BAD6E00, 0x89E60100, 0x8548D480, 0x22A51A40, 0x37627160, 0x231BC7B0, 0x05A60E98, 0x0169496C, 0xA794AC82, 0xD57B8E43 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x38000000, 0xDC000000, 0x76000000, 0x05000000, 0xD0800000, 0xCF400000, 0x38A00000, 0x92300000, 0x12580000, 0xCF8C0000, 0x063A0000, 0xF3390000, 0x875D8000, 0x6A73C000, 0x099CA000, 0x2F13F000, 0xCB4D7800, 0x005ACC00, 0x0C68BA00, 0x53D43900, 0xF0B6C280, 0x83836340, 0x86249960, 0xD90E4830, 0x489FC358, 0x0977EC94, 0x69629A82, 0x10359F43 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x58000000, 0xA4000000, 0x96000000, 0x55000000, 0x20800000, 0x25400000, 0xC5E00000, 0x21100000, 0x54980000, 0xB35C0000, 0x378A0000, 0xE6B90000, 0x91ED8000, 0x2263C000, 0x4DAD6000, 0x5D033000, 0x96FD8800, 0xBBFACC00, 0x9A70DA00, 0xE9C8E900, 0xB8A41680, 0x8F8609C0, 0x5FCA9F20, 0x87D981B0, 0xD3BDC078, 0x8E1B6DB4, 0x03617E82, 0x295035C3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x68000000, 0xE4000000, 0x4A000000, 0xF3000000, 0x2D800000, 0x99400000, 0x53200000, 0x0AB00000, 0x32F80000, 0xD6A40000, 0x12920000, 0x2E190000, 0x8FF58000, 0x22BBC000, 0x14D42000, 0x7C0B5000, 0x742D0800, 0x45AE3400, 0x8D3FF600, 0xAFF63300, 0xC56A3680, 0xC03CE840, 0x04A76A60, 0xAA424970, 0x09717C08, 0x2F1928C4, 0xFD749E82, 0x487B4C43 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0xAC000000, 0xC2000000, 0x35000000, 0xEE800000, 0xC6400000, 0x7CE00000, 0xE3F00000, 0x4FD80000, 0x732C0000, 0x96BE0000, 0xD6F90000, 0x10FC8000, 0xD636C000, 0x761DE000, 0xC4C6D000, 0xD9449800, 0xF6ABE400, 0xC09BFA00, 0x4763E500, 0xE71F1880, 0x48686BC0, 0x45156EE0, 0xA0E25130, 0x15DEAE98, 0x23C8001C, 0x2A84E082, 0x158A9FC1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0x08000000, 0x24000000, 0xC6000000, 0xFD000000, 0x9E800000, 0xCC400000, 0xC2E00000, 0x82100000, 0x4F080000, 0xE44C0000, 0x7CFA0000, 0xC6290000, 0x907C8000, 0xB243C000, 0xAB1D2000, 0x25929000, 0x83348800, 0xDCEF2C00, 0x91F72A00, 0x7AB2D500, 0x02044480, 0xA8D757C0, 0xF6834520, 0xF0BD0490, 0x2FE3E458, 0x5C6CBB54, 0x644B6C82, 0xF7D02BC1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x28000000, 0xA4000000, 0x72000000, 0x79000000, 0xC1800000, 0x6E400000, 0x58A00000, 0x5E700000, 0xDC280000, 0x83640000, 0x67E20000, 0x16490000, 0x88758000, 0xE25AC000, 0x3A552000, 0xDAEBD000, 0x491C8800, 0xAD1F4400, 0x0A076200, 0x156A6B00, 0x705C2880, 0xD33E6B40, 0x44B66BE0, 0x1D222ED0, 0x87298888, 0xB3E491A4, 0x1C220082, 0x6AA93F43 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xE8000000, 0xE4000000, 0x7E000000, 0xB7000000, 0xA3800000, 0x76400000, 0xF2E00000, 0x0D500000, 0x7C280000, 0xFE840000, 0x15660000, 0x58090000, 0x02F48000, 0x93BE4000, 0x2894A000, 0xB12F5000, 0xE91C8800, 0x9C9BDC00, 0x54C3FE00, 0x589EAF00, 0x8B640080, 0xE3B623C0, 0xAE6091A0, 0xAC9042D0, 0x4E89FBC8, 0x823526EC, 0x519EA882, 0xFFE5EFC1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0xC8000000, 0x3C000000, 0x96000000, 0xB9000000, 0xA7800000, 0xDC400000, 0x82200000, 0xD0B00000, 0x8BB80000, 0x6A9C0000, 0xA5020000, 0xBF590000, 0x29CD8000, 0x6F6BC000, 0x826C2000, 0x0E9A1000, 0xF674B800, 0x1FF78C00, 0xB06E2200, 0xCB429700, 0xC6784480, 0x3DFD6E40, 0xE812B260, 0x5C1015F0, 0x28C9DA78, 0x6344B5E4, 0x9B0F5C82, 0x30523243 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xB8000000, 0x0C000000, 0x72000000, 0x75000000, 0xFF800000, 0xE7C00000, 0x60600000, 0xC9D00000, 0x1DA80000, 0xF1FC0000, 0x5D760000, 0x4A890000, 0x210D8000, 0x3F2EC000, 0x87ACA000, 0x071EF000, 0x6B15D800, 0xDDAAC400, 0xDC0E5A00, 0x295CC700, 0x62471B80, 0x2CB052C0, 0xE3F9D8A0, 0x0F94B6D0, 0xDAEB8038, 0x6D2E98CC, 0x82ADE382, 0xF09FA6C3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xD8000000, 0x4C000000, 0x6E000000, 0xCF000000, 0xA5800000, 0xB0400000, 0xF3200000, 0x31D00000, 0xDEA80000, 0xA3F40000, 0x81920000, 0xD1490000, 0x1FC48000, 0x120AC000, 0x43A5E000, 0xFD7B3000, 0x989D5800, 0xF906BC00, 0xBE2BEE00, 0x3FF4B300, 0x67924C80, 0x9A49C040, 0x304424A0, 0x974AABD0, 0xF8044EA8, 0x786A7204, 0x6FD47482, 0x8DC38C41 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0xE8000000, 0x1C000000, 0xB6000000, 0x5D000000, 0xE5800000, 0x17400000, 0xBBA00000, 0x78700000, 0xC8780000, 0xFDFC0000, 0x4CBE0000, 0xDE190000, 0xDBED8000, 0x6ED64000, 0x7F8D2000, 0x67C65000, 0xB7657800, 0x2B92CC00, 0xB52E2A00, 0x28315300, 0x45595280, 0xFE4D9540, 0x77A7A7E0, 0xF475EC70, 0x387B93B8, 0xB9FAD11C, 0x2CBA8A82, 0x401A4943 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xF8000000, 0x2C000000, 0xC2000000, 0xB3000000, 0xFC800000, 0xC9C00000, 0x6DA00000, 0xFA300000, 0x88C80000, 0x8A4C0000, 0x211E0000, 0x45290000, 0x3D9C8000, 0x5E074000, 0x107DA000, 0x19D77000, 0xC7641800, 0x9883A400, 0x0D2ED600, 0x70E08100, 0xCA502780, 0x51580540, 0xD9B4D960, 0x941A4C10, 0xF73AEAD8, 0x3FCB47DC, 0x02231F82, 0xFD9E9141 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0x64000000, 0x22000000, 0x83000000, 0x0B800000, 0x17C00000, 0x26E00000, 0x59500000, 0x3F680000, 0xCC8C0000, 0xB9760000, 0xB6390000, 0xEBE48000, 0x71FAC000, 0x7D4FA000, 0x86DD3000, 0xF59E8800, 0x39752400, 0x5E739600, 0x2193AF00, 0xE4438380, 0x8D6AFFC0, 0x9FC68BA0, 0x4C815250, 0x4E406558, 0xDA21C68C, 0x18301582, 0x6FF950C1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0x68000000, 0x6C000000, 0x42000000, 0x7F000000, 0xF0800000, 0x1D400000, 0x8CE00000, 0x65300000, 0xCAE80000, 0x84EC0000, 0x33AE0000, 0x43D90000, 0x4C048000, 0xA842C000, 0x30F66000, 0x7A9D5000, 0x04A69800, 0xBF842400, 0xFF83CE00, 0x0A562900, 0x95CC8680, 0x8F3FF3C0, 0xDCE1AD60, 0xFD31FA50, 0xAEE81C98, 0x1AED69FC, 0x66AF4882, 0xA059DAC1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x98000000, 0x6C000000, 0xB2000000, 0x65000000, 0x0D800000, 0x3AC00000, 0xC5600000, 0x6A500000, 0x8A280000, 0xFA940000, 0x7EDE0000, 0x32790000, 0x25BD8000, 0xE1CA4000, 0x5266A000, 0x94A5B000, 0x15271800, 0xE3058400, 0x6E17DA00, 0x0D7CB300, 0x51ABE980, 0x8DB654C0, 0x984DFDA0, 0x00D2EED0, 0xFE8AF868, 0x69C6CCDC, 0x8D943382, 0x065EE7C3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x08000000, 0x3C000000, 0x06000000, 0x75000000, 0x9E800000, 0x76C00000, 0xD3600000, 0x97700000, 0xAC780000, 0x1A9C0000, 0x17320000, 0xE6090000, 0x24658000, 0x556E4000, 0x9B5AE000, 0xC59C9000, 0xE2B3B800, 0x9F48AC00, 0xDD449A00, 0x20BF1500, 0xA2B27980, 0x7F49D0C0, 0x0D4541E0, 0xD8BF2470, 0x96B36478, 0x45497344, 0x7E44E382, 0x333FC5C3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x3C000000, 0x26000000, 0x25000000, 0x76800000, 0x74C00000, 0xA5200000, 0x1C500000, 0x43C80000, 0xD0040000, 0xF6160000, 0x82990000, 0xF14C8000, 0x28D2C000, 0xC2AF2000, 0x54055000, 0xA4163800, 0xCD99AC00, 0xFCCC3A00, 0x5B928500, 0x7FCFFD80, 0x9AB41C40, 0x0D2EA7A0, 0x40452F10, 0x48F639C8, 0x46691BCC, 0xA595C782, 0x527F9941 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xE8000000, 0xDC000000, 0x3E000000, 0xC7000000, 0x2A800000, 0x47400000, 0x78E00000, 0x16F00000, 0x7B280000, 0x025C0000, 0xA0D60000, 0x26D90000, 0x55F48000, 0x86CAC000, 0x2E6EE000, 0xEF9C5000, 0xDF77F800, 0x28C85C00, 0xC82D3E00, 0x17BEFD00, 0x50E5AA80, 0x579253C0, 0x6B5B8EE0, 0xD17631D0, 0x27C965F8, 0xAEADD08C, 0x76FE9482, 0xDB05AEC1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x38000000, 0x34000000, 0x3E000000, 0x23000000, 0x3A800000, 0x87C00000, 0x93600000, 0xD7100000, 0x5EF80000, 0xAF640000, 0xEC2A0000, 0x16E90000, 0xD91D8000, 0xFD8FC000, 0x8622E000, 0x8AA4F000, 0x5E4A2800, 0x0A795C00, 0xE3A45600, 0x59CBAD00, 0x8439FB80, 0x0584ECC0, 0x967A3520, 0x94B15B70, 0x3E08C188, 0x924C8DB4, 0x7C57AD82, 0x097641C3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x18000000, 0xAC000000, 0x02000000, 0x3F000000, 0xB0800000, 0x62C00000, 0xDDE00000, 0xDA500000, 0xA1B80000, 0xCE240000, 0xC5FE0000, 0xA6E90000, 0x501C8000, 0xA19AC000, 0x8036E000, 0xEB45B000, 0x196F1800, 0xFCB02400, 0x3D692E00, 0xFC5CC900, 0xABBA7980, 0x4C06F1C0, 0xF4EC73A0, 0x58D2A3F0, 0x7D5ABC08, 0xC8D6B59C, 0x6A955782, 0x349738C1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x88000000, 0x64000000, 0x72000000, 0xCD000000, 0xCD800000, 0x14C00000, 0xEAA00000, 0x82D00000, 0xAEF80000, 0xBD4C0000, 0x445E0000, 0x3B290000, 0x27358000, 0x4A52C000, 0x5016E000, 0x27ED9000, 0x8E8F8800, 0x91D0C400, 0x1878EA00, 0x4B0C8300, 0xC2BFE580, 0x6618BB40, 0xE37C4CA0, 0x8E96CB70, 0x85ADFC58, 0x926F535C, 0x95E10F82, 0xEBB13843 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x78000000, 0x24000000, 0xE6000000, 0x63000000, 0x2A800000, 0xDDC00000, 0x7B600000, 0xFAF00000, 0xDD280000, 0x3A6C0000, 0xA8020000, 0xCAD90000, 0x02C48000, 0xFF2E4000, 0xD57A6000, 0x9E0D7000, 0x6A728800, 0xA731EC00, 0xE649D600, 0xE09CAD00, 0xC52B5F80, 0x88B40CC0, 0x8EC7AEE0, 0xD3F6D8D0, 0xB4BF1F98, 0x4BA33624, 0x62C88982, 0x425DA1C1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xC8000000, 0x9C000000, 0xFE000000, 0x25000000, 0xA4800000, 0x44400000, 0xBF600000, 0xC8B00000, 0xDE580000, 0xF2340000, 0xCF9E0000, 0x42690000, 0x402D8000, 0x8ECA4000, 0xC3466000, 0xAD1D1000, 0xFA52F800, 0x1D53DC00, 0x12D23A00, 0x3F132100, 0x4CB3EC80, 0x4922F8C0, 0x59AB9A60, 0xE7F68930, 0x6544AC28, 0x0167879C, 0x404C5682, 0xADFB99C3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x78000000, 0x0C000000, 0x06000000, 0x65000000, 0xD7800000, 0xA1400000, 0x3DA00000, 0x2D300000, 0xFC980000, 0x163C0000, 0x743E0000, 0x2E290000, 0x7FE48000, 0xF5A34000, 0xC426A000, 0x67D57000, 0xE6BBD800, 0xDF5BEC00, 0xF84A1A00, 0xF8A38700, 0x87A63680, 0xBC952D40, 0x101BB760, 0x34EA10B0, 0x78131BB8, 0x117F885C, 0x5188AC82, 0x35D5EA41 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xF8000000, 0x8C000000, 0x4A000000, 0x83000000, 0x81800000, 0xD4400000, 0x28A00000, 0xD4B00000, 0x71580000, 0x337C0000, 0xF14A0000, 0x48690000, 0x4C658000, 0xF196C000, 0x3013A000, 0x13157000, 0xA92E5800, 0x2FFFF400, 0x4D76D600, 0x6C03AB00, 0x86FCC480, 0x430BD340, 0x99C82460, 0x32551530, 0xA10E2538, 0x398E33B4, 0xD74F9282, 0x462EB843 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x48000000, 0x0C000000, 0x3E000000, 0xC9000000, 0xBD800000, 0xE2C00000, 0x7DA00000, 0xD0500000, 0xE9080000, 0x27940000, 0xED2A0000, 0x18D90000, 0x9A5D8000, 0x921FC000, 0xB6232000, 0x084C1000, 0xE3F65800, 0xC5869C00, 0xFB1FA200, 0x3BA2B300, 0x528CC180, 0xCA57E540, 0x6FD721A0, 0xE9173890, 0x56B757E8, 0x29E76CB4, 0xF06EE382, 0xBABA9643 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x38000000, 0x1C000000, 0xBE000000, 0x67000000, 0x3C800000, 0x27400000, 0x6FE00000, 0xA7B00000, 0xB6780000, 0xC1CC0000, 0x6FEE0000, 0xC1490000, 0xA6F58000, 0x32C24000, 0x3F962000, 0x0B84F000, 0xC39BF800, 0x07CB1C00, 0x50031E00, 0x7CB6F100, 0xC014EA80, 0x16F3FDC0, 0x3E2FD060, 0x94E9CF70, 0x272528D8, 0x49CBDC7C, 0x7F027482, 0xD4374CC3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x68000000, 0x14000000, 0x6E000000, 0xE9000000, 0x01800000, 0xD5C00000, 0x6B600000, 0x45B00000, 0x79580000, 0x7DA40000, 0x1A320000, 0xE1690000, 0xBB3D8000, 0x33F7C000, 0x1A6B6000, 0xE54C5000, 0xD8CE6800, 0x9BFE7C00, 0x1FE7E200, 0x3D63BB00, 0xEC407F80, 0x32A128C0, 0xDCD00260, 0x9FE91E30, 0xEA7C7008, 0x4ED74CC4, 0x2A7A1D82, 0x484553C3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x18000000, 0xDC000000, 0xC6000000, 0x4F000000, 0x83800000, 0xCFC00000, 0xC5600000, 0x0CD00000, 0xB1480000, 0x1F3C0000, 0x743E0000, 0x38190000, 0xCEB48000, 0x1DE34000, 0x07362000, 0x4685B000, 0xDABA7800, 0x56A2EC00, 0xAA160E00, 0x6AF44F00, 0xA3434B80, 0xFC87C8C0, 0x261CA8A0, 0xBA4E3E10, 0x24E1E138, 0xE610FE1C, 0x56A9C582, 0x44ACC7C1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x88000000, 0x64000000, 0xAA000000, 0x13000000, 0x5E800000, 0x23400000, 0x6DA00000, 0x29B00000, 0x8B680000, 0xBA2C0000, 0xB59E0000, 0xF6590000, 0x91058000, 0x94924000, 0x7D37A000, 0xA3959000, 0xE10B0800, 0x23D2B400, 0xA2971600, 0x5525A500, 0xAAE2BA80, 0x8BBF5940, 0x53293060, 0x5D0CA150, 0xED6EB398, 0xBF909C1C, 0x1A182C82, 0x5424BC43 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x08000000, 0x8C000000, 0x1E000000, 0xDB000000, 0xEA800000, 0xB5400000, 0xE0200000, 0xE6300000, 0x72680000, 0xF42C0000, 0xEBEA0000, 0x9CD90000, 0xEE048000, 0xEA674000, 0x0CC3A000, 0x98D59000, 0x4BDED800, 0xD8D6DC00, 0x00EA8600, 0xCE581D00, 0x2F452E80, 0xC047BA40, 0xABF30760, 0x493CEF50, 0x25321098, 0x57DD64F4, 0xC5E32882, 0xE164E741 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0xD8000000, 0x0C000000, 0x52000000, 0x99000000, 0xD7800000, 0x79C00000, 0x5EE00000, 0x54100000, 0xD2780000, 0x9B440000, 0xCD4A0000, 0xA7E90000, 0xDFFC8000, 0x706FC000, 0xDFF3A000, 0x45CC3000, 0x57675800, 0xDF1EC400, 0x495BA200, 0xED904700, 0xA8B9AF80, 0xBF25FBC0, 0x391B3D20, 0x41B0F470, 0x0CC876C8, 0xC70C7674, 0x8F068D82, 0x114E7CC1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x58000000, 0x34000000, 0x52000000, 0x79000000, 0x84800000, 0x74400000, 0xB4E00000, 0x00500000, 0x6A780000, 0x1DCC0000, 0x4E6A0000, 0xA7A90000, 0x9F748000, 0x87064000, 0xBF726000, 0x73F53000, 0xDF46A800, 0x4D928400, 0xE8A4A200, 0x10BF1100, 0x949E0480, 0x346F6FC0, 0x7AA6E3A0, 0xE5435970, 0xB09DFCD8, 0x229376B4, 0x7F242682, 0x3D7F3EC1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x78000000, 0xFC000000, 0x0A000000, 0x07000000, 0xCB800000, 0x14C00000, 0x2DA00000, 0xE6700000, 0xF1480000, 0x6CF40000, 0x848E0000, 0x23B90000, 0x7EFD8000, 0x7B1B4000, 0xFBE62000, 0xF9FC7000, 0x709B3800, 0x4F277400, 0x445D5E00, 0xEEEA5F00, 0x426EA580, 0x22A91140, 0x6D659DE0, 0xAA57D010, 0x48946128, 0x3BDF8FBC, 0xB7C07B82, 0x40210E43 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x28000000, 0xA4000000, 0x96000000, 0x9B000000, 0xD0800000, 0x8D400000, 0x95E00000, 0x45700000, 0x58380000, 0xA73C0000, 0xB0420000, 0xCEC90000, 0x8EC48000, 0xADDFC000, 0xFB1BE000, 0x9AC5D000, 0xB3DE0800, 0x541B0C00, 0x84440600, 0x299FF900, 0x237B5E80, 0x417401C0, 0xAFC645E0, 0x9CF64FF0, 0xB1AE5538, 0x16A30EA4, 0xBF39D882, 0x2DBD38C1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x38000000, 0xAC000000, 0x4E000000, 0xB9000000, 0x34800000, 0x51C00000, 0xF7200000, 0x47100000, 0x65E80000, 0xA55C0000, 0x5B1A0000, 0xEB790000, 0xBFF58000, 0xE3A7C000, 0x93D3A000, 0x9234F000, 0xA2871800, 0x21C2FC00, 0xDD5D2200, 0xD71B0100, 0x15790780, 0x6EF55040, 0x43277D20, 0x20126550, 0x92151978, 0x6817D554, 0x216BA582, 0xDEE09143 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x98000000, 0x4C000000, 0xCE000000, 0x89000000, 0x54800000, 0x44400000, 0xA9A00000, 0xD5500000, 0xEEF80000, 0xA48C0000, 0xFDD20000, 0xE2290000, 0x10B58000, 0xB7BFC000, 0xD48BE000, 0x4AF5B000, 0x5F1ED800, 0x115BBC00, 0x8A4C4200, 0xC1334100, 0x6659AC80, 0xD15D8D40, 0x456A79A0, 0x40051870, 0x31B6ACD8, 0x29AEE144, 0xCA526E82, 0xA1E80C43 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x68000000, 0x0C000000, 0xA2000000, 0x17000000, 0x50800000, 0x49C00000, 0x5BE00000, 0x7EF00000, 0x20180000, 0xF2640000, 0x9D8A0000, 0x3B690000, 0x9C3C8000, 0x4D4EC000, 0x1A32A000, 0xCA5D5000, 0x71FE5800, 0xBA8B2400, 0x93E8DE00, 0xD1FC2900, 0x68AEAF80, 0xB9C3ADC0, 0xA1C53AE0, 0x38DB6EB0, 0x2220CA88, 0xDD100E34, 0x5AE8F182, 0xAC7C44C1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x78000000, 0x04000000, 0xB6000000, 0x23000000, 0xBB800000, 0x33C00000, 0xB1200000, 0x45B00000, 0x45E80000, 0xB7940000, 0x427A0000, 0xFED90000, 0xC13C8000, 0x788F4000, 0xA5F32000, 0xD19D7000, 0x07FFC800, 0xCBBB0C00, 0x56F91600, 0x660C4F00, 0x4C266380, 0xC2079840, 0x7E36C260, 0x551E3F50, 0xA72BA0E8, 0xE2A04CD4, 0x4A71F582, 0xE6C99741 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xC8000000, 0xCC000000, 0x62000000, 0xDB000000, 0x61800000, 0x68400000, 0xBE600000, 0xF7100000, 0xB3580000, 0x752C0000, 0xD37E0000, 0x34C90000, 0x28B58000, 0x5BF3C000, 0xE1876000, 0x2DD51000, 0x3D63D800, 0x129E6400, 0x1A98C600, 0xB30C8B00, 0x820E2C80, 0x4480FEC0, 0x88C11320, 0x88A1E930, 0xDEB05418, 0xE369D11C, 0xF9856A82, 0x89DAB5C3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xB0000000, 0xB8000000, 0x74000000, 0x26000000, 0x51000000, 0xD2800000, 0x9E400000, 0x40200000, 0x22300000, 0xEBC80000, 0x00740000, 0x5D0A0000, 0xD8790000, 0xF07C8000, 0xD09EC000, 0xA3A26000, 0xF39CF000, 0xFB4EA800, 0x90BAEC00, 0xBD713200, 0x31687D00, 0x10043880, 0x14E27E40, 0x353DDB60, 0xB13F6A10, 0x62529228, 0x81B59934, 0x4BEB8A82, 0xFF29C341 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x68000000, 0xF4000000, 0x42000000, 0xF3000000, 0x6E800000, 0x39C00000, 0x0DE00000, 0x36F00000, 0x59680000, 0x1C0C0000, 0xD7160000, 0x02590000, 0x3A848000, 0x46EA4000, 0x66A7E000, 0x37115000, 0xA1992800, 0x38642400, 0xF89BD600, 0xAF0EE500, 0x277C9F80, 0xA13FB9C0, 0xE674F6E0, 0x7882AC50, 0x062A2858, 0x32C7D40C, 0x5CA0A982, 0xBBD00CC1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0x98000000, 0x54000000, 0x02000000, 0x8D000000, 0x4F800000, 0x97400000, 0x79200000, 0xBC500000, 0xCDB80000, 0x263C0000, 0x9B9E0000, 0x74A90000, 0x97A58000, 0x5273C000, 0x4BCF6000, 0xFF11B000, 0x7698E800, 0xF76DA400, 0x29A64A00, 0x5DD40700, 0x211A0280, 0x988B2C40, 0x9CD21DA0, 0xC4DE5AF0, 0x318818B8, 0x05F5A9DC, 0x74CB2882, 0x35729B43 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xF8000000, 0x24000000, 0xB6000000, 0x53000000, 0x0E800000, 0xDA400000, 0x74200000, 0x02B00000, 0x46680000, 0xC3EC0000, 0xBB1E0000, 0x70990000, 0x96A58000, 0xEAC3C000, 0xE8AF6000, 0x35717000, 0xDE880800, 0xAB3CCC00, 0x0DE73600, 0x5CACA500, 0x82BF1080, 0x8EE9E240, 0x92AD5E60, 0x35BF1550, 0xD669F318, 0x2BEC871C, 0xB71F4682, 0x2A983743 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xF8000000, 0x3C000000, 0xAE000000, 0x69000000, 0x9F800000, 0xF3400000, 0xBA200000, 0xD5900000, 0x69880000, 0xF6140000, 0x126A0000, 0xE9590000, 0x68BC8000, 0xAC6F4000, 0x6EFB6000, 0xFF507000, 0xFDE9B800, 0xCC247C00, 0x96334200, 0x6C65B700, 0x60924280, 0x4634BA40, 0xECFAA620, 0xB051BA90, 0x6F69E6E8, 0x02E517B4, 0xE0526082, 0xC9557D41 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x38000000, 0x5C000000, 0x06000000, 0x51000000, 0xBF800000, 0x68C00000, 0x59200000, 0x3E500000, 0xD6C80000, 0x09440000, 0x023A0000, 0xAE590000, 0x03AC8000, 0x88AEC000, 0xE96AE000, 0x2D11F000, 0x6D28F800, 0x91352C00, 0x90233200, 0xC494B700, 0x3232E580, 0xAB3DDC40, 0x2A46C1A0, 0xF7FFB310, 0x0822A948, 0x4895F694, 0x9C333782, 0x6E3C9B41 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xE8000000, 0x34000000, 0x3A000000, 0x65000000, 0xDC800000, 0xAD400000, 0xFEE00000, 0xB8700000, 0xB9080000, 0xBD840000, 0x5E2A0000, 0x22390000, 0x656D8000, 0x825EC000, 0xA4DB2000, 0x41715000, 0xCB892800, 0x3FC49400, 0xE14B3A00, 0x37890100, 0x81C4C680, 0x264B83C0, 0x420923E0, 0x1605C190, 0x1EEB7448, 0x87196574, 0x03BCDC82, 0x9547D2C3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x48000000, 0x74000000, 0xC2000000, 0x75000000, 0xD2800000, 0x6C400000, 0x7F200000, 0x07D00000, 0x70B80000, 0x931C0000, 0x35760000, 0xBD290000, 0xD3848000, 0x5A3AC000, 0x0026E000, 0x11D11000, 0x17B8A800, 0xEC9CA400, 0x47B79A00, 0x5048DD00, 0x68753480, 0x48D35040, 0x2843A0A0, 0x765A8CF0, 0x8B56A8F8, 0x8A79BF0C, 0x2A7C4E82, 0xDC869D41 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x58000000, 0x34000000, 0x96000000, 0x9B000000, 0xCE800000, 0x12C00000, 0x0DA00000, 0x63F00000, 0xC0880000, 0xFBCC0000, 0x629A0000, 0x5BB90000, 0x97E58000, 0xAD274000, 0xB8EA2000, 0x25703000, 0xDE48A800, 0x646D4C00, 0xC46AA600, 0xA2B04500, 0x1268E180, 0xDDDD4140, 0xD8834CE0, 0xCDAD8990, 0x574A2158, 0x2B817594, 0x7B406782, 0x8BE13443 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x58000000, 0x34000000, 0x62000000, 0xE1000000, 0xC8800000, 0x95C00000, 0xE2E00000, 0x66B00000, 0xF5680000, 0xCFE40000, 0xC4D60000, 0x18190000, 0xA76D8000, 0x1A02C000, 0xABE76000, 0x20303000, 0x17A92800, 0x06846400, 0x2E271200, 0x0AD04900, 0x4D180780, 0xCDEC03C0, 0x0EC2FE60, 0xB186E050, 0x8B419988, 0x3421050C, 0xCDD07582, 0xFE987AC3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x78000000, 0x2C000000, 0x36000000, 0x5F000000, 0xC1800000, 0xE8C00000, 0x44A00000, 0x88300000, 0x6A280000, 0xF82C0000, 0x81660000, 0x8DD90000, 0x4B258000, 0xE7BBC000, 0x7937A000, 0x15607000, 0xEA101800, 0x07590C00, 0x5864EE00, 0x92DB2B00, 0x0326E580, 0x8A38DB40, 0xCE746D60, 0xDB83E6D0, 0x2843F898, 0xEF62B3EC, 0x7A93AB82, 0xD49A8043 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x48000000, 0x9C000000, 0xF2000000, 0x05000000, 0xE2800000, 0x06C00000, 0xDA600000, 0x29100000, 0x51080000, 0x14240000, 0x62420000, 0x63D90000, 0xD9CC8000, 0x9FB7C000, 0xD1F36000, 0xDAA11000, 0x08707800, 0xF5984400, 0x406CFA00, 0x6E466D00, 0x9F2BD180, 0x0DEDDAC0, 0xCB06DD20, 0x570BCA90, 0xEB5CE108, 0xA8FFCA64, 0xB4764B82, 0x0513A7C1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xC8000000, 0x64000000, 0xDA000000, 0x31000000, 0x5C800000, 0xF6400000, 0x4EE00000, 0x32300000, 0x78C80000, 0x8BEC0000, 0x8BDA0000, 0xF9B90000, 0xD3458000, 0x2147C000, 0x5ACBA000, 0xF8611000, 0xAD708800, 0x26A8D400, 0xA19D5200, 0x9EF3E100, 0x49E59080, 0x5096CBC0, 0xDAB27F60, 0x22058410, 0x9C27B698, 0x993B4614, 0xCD896282, 0x5C8D3AC3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x18000000, 0xEC000000, 0x5E000000, 0x31000000, 0x45800000, 0x44C00000, 0xB7E00000, 0xBB300000, 0xAEC80000, 0xDAEC0000, 0x926A0000, 0xC4390000, 0x6C448000, 0x5476C000, 0xB5FAA000, 0xE1E1B000, 0x5E319800, 0xE949DC00, 0x392DF200, 0xA50B6300, 0xCC48ED80, 0x5EAD31C0, 0xF6CB5F60, 0x3329FF10, 0xA2DCE398, 0x76222574, 0xFE95BF82, 0x508EE2C1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xE8000000, 0x2C000000, 0xC2000000, 0xE1000000, 0x7A800000, 0x48C00000, 0xEA200000, 0x93D00000, 0x17F80000, 0x356C0000, 0x74BE0000, 0x8FE90000, 0x43348000, 0x58434000, 0x7A4EE000, 0x86405000, 0xE4E19800, 0xD6F12400, 0x2DA9F200, 0x19D57D00, 0xB5B34D80, 0x08669240, 0x43D590A0, 0xD0B38B70, 0x3CE68F18, 0xD815AA9C, 0x49125F82, 0xB176BF41 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x78000000, 0x44000000, 0x26000000, 0xD1000000, 0xB3800000, 0xDEC00000, 0xABE00000, 0x7D300000, 0xE2780000, 0x52CC0000, 0xE1520000, 0xB2890000, 0xFFD58000, 0x42EEC000, 0x5F03A000, 0x2B807000, 0x0AC1C800, 0x95E02C00, 0xB831F200, 0x0FF91F00, 0x190D7980, 0xDF32B9C0, 0xC0793F60, 0x05CC9E70, 0xB3D28FD8, 0xF7C9CF04, 0xB6F52B82, 0xF63ED6C3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x48000000, 0xDC000000, 0xD2000000, 0x23000000, 0x26800000, 0x0BC00000, 0x7FE00000, 0x00D00000, 0x5AA80000, 0x0D3C0000, 0x50320000, 0x04B90000, 0x4BF58000, 0xCD9FC000, 0x9583E000, 0xA7001000, 0xD081F800, 0x8EC08400, 0x04603600, 0x94916500, 0xF7080B80, 0x8D4D1DC0, 0x5D6A0AA0, 0x0A9DEFD0, 0x47437238, 0xB1609E04, 0x8711DD82, 0x2F4968C3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x38000000, 0x14000000, 0x82000000, 0xE9000000, 0x46800000, 0x45400000, 0xA6A00000, 0x93500000, 0x0DD80000, 0x71640000, 0xABB60000, 0x25490000, 0x4B5D8000, 0x8D23C000, 0x8977E000, 0x6C28F000, 0x4DEC6800, 0xAE0A2400, 0xF11A4200, 0xACE25500, 0xD396E680, 0xB7583B40, 0xCA24A9A0, 0xDA176430, 0xC7999908, 0x0244328C, 0x2626C482, 0x7FF15E43 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x68000000, 0xFC000000, 0x52000000, 0x57000000, 0x60800000, 0xB8400000, 0x87A00000, 0x90D00000, 0xF5E80000, 0x9E940000, 0x5F060000, 0x25F90000, 0xA09D8000, 0x68E34000, 0xC2C66000, 0x4D985000, 0x7F2D3800, 0xEA3A8400, 0x2ACA1E00, 0x47336900, 0x6BAFEC80, 0x994DA540, 0x408A3EA0, 0x57925250, 0x3BFF2EE8, 0x64E472EC, 0x31BE1282, 0x6445DC43 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x38000000, 0xE4000000, 0x96000000, 0xEB000000, 0xE6800000, 0xD6400000, 0x13600000, 0xA7700000, 0xB9280000, 0x28140000, 0x55020000, 0xB2990000, 0xC61D8000, 0x84064000, 0xDC432000, 0x0978F000, 0x882C0800, 0x76CF4C00, 0xB2668600, 0x62B2F500, 0x1E918880, 0x42193CC0, 0x3B5D45E0, 0x51E68BD0, 0xBD724E68, 0x9B307024, 0xE349AE82, 0x0CE579C3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x68000000, 0xA4000000, 0x7E000000, 0x87000000, 0xD8800000, 0x60C00000, 0xF2E00000, 0x8C900000, 0xAAE80000, 0xB67C0000, 0xDFEA0000, 0x60390000, 0x49B48000, 0x2F67C000, 0x096AE000, 0xAFF95000, 0x27D40800, 0x4D36DC00, 0xBE633E00, 0xE995A900, 0x4C163580, 0xEE9337C0, 0x7C2D1620, 0x6CE2FD50, 0x4854DCB8, 0x3D770134, 0x98436B82, 0x71E40EC1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x28000000, 0x0C000000, 0xCE000000, 0xA1000000, 0xB7800000, 0xA2400000, 0x62A00000, 0x49B00000, 0x82180000, 0x590C0000, 0x83260000, 0x78690000, 0x16F58000, 0x38BAC000, 0xCBA6A000, 0x44A8D000, 0xDD955800, 0x87EAFC00, 0xE7AFB200, 0xA38DA700, 0x48E78080, 0x51887B40, 0x5664CE60, 0xB753A7B0, 0xDF1217D8, 0xAEB35E6C, 0xA7831282, 0x655BCC43 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xF8000000, 0x34000000, 0x5A000000, 0x8D000000, 0x38800000, 0xC0400000, 0x81600000, 0x1C900000, 0xD1A80000, 0xEA340000, 0xD55E0000, 0x47F90000, 0x6BBD8000, 0x9C1BC000, 0xF4DFE000, 0xB5397000, 0xCF9C2800, 0x856B9400, 0x6FA70A00, 0xECC56900, 0x03E71C80, 0xB3A48CC0, 0xD077C220, 0x938D0AD0, 0x6082EA28, 0xBEF20F5C, 0xD80A7682, 0x553755C3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x08000000, 0xAC000000, 0xEE000000, 0x91000000, 0x37800000, 0x94400000, 0x8E600000, 0x1A100000, 0x13E80000, 0x45540000, 0x870A0000, 0x58390000, 0x0B9C8000, 0x24AEC000, 0x2F0B2000, 0xC4399000, 0x9D9D1800, 0x01AF3C00, 0x528A1200, 0x8378A700, 0x5B7DEC80, 0x297F02C0, 0x6CC24920, 0xC61DA850, 0x5BEE7AE8, 0x3DEB38F4, 0xB6E85E82, 0x78D4F5C1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x48000000, 0x84000000, 0x26000000, 0x63000000, 0x64800000, 0xAB400000, 0xE0200000, 0xA3D00000, 0xD6480000, 0x89040000, 0x2BEE0000, 0xB0590000, 0x252D8000, 0xB89B4000, 0x1EEE2000, 0x0FD81000, 0x16EDC800, 0x89FA2C00, 0xD41E7600, 0xDFC1D100, 0xC360D280, 0x67F12A40, 0xC398F8A0, 0x744DAB10, 0x426AC0C8, 0x16F75A3C, 0x16550482, 0x5AE7AB43 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xB8000000, 0xAC000000, 0x36000000, 0xBD000000, 0xA2800000, 0x67C00000, 0x1AE00000, 0x4E500000, 0x70780000, 0x12FC0000, 0x4EDA0000, 0x56690000, 0x65258000, 0x33574000, 0xE27BA000, 0xB699F000, 0x42AD9800, 0x37A38C00, 0x2C15AA00, 0x7F3EED00, 0xCC5FBB80, 0x3A4F03C0, 0x359613A0, 0x441B5270, 0x9608A3B8, 0x40B506D4, 0x3FCE3182, 0xBBD65EC3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x58000000, 0x8C000000, 0xE2000000, 0xAD000000, 0xFB800000, 0x04C00000, 0xB6600000, 0x1F700000, 0xA7980000, 0x3DFC0000, 0x6CF20000, 0x72A90000, 0x7F448000, 0xAEDEC000, 0x35D2A000, 0xA7793000, 0x4DCD5800, 0x41CAA400, 0xBA454A00, 0x115EDF00, 0x67131580, 0x0219D2C0, 0xBE3C63E0, 0x3812C9B0, 0x2C98CAB8, 0x7D7DF9C4, 0xE0B27F82, 0xFC89FDC1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0xF8000000, 0xC4000000, 0x1A000000, 0xAD000000, 0x63800000, 0x9BC00000, 0x99E00000, 0x9BF00000, 0xCDA80000, 0x7C540000, 0xC5D20000, 0x5F190000, 0x5E5C8000, 0x7F574000, 0x17F26000, 0xF5087000, 0x24044800, 0x58AA1400, 0x2574CA00, 0x7F423F00, 0x6A00CB80, 0xB501BDC0, 0xB7801AE0, 0xC9C083D0, 0x08E138E8, 0x26715D84, 0xE168E182, 0x2B35B2C1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0xB8000000, 0x0C000000, 0x9E000000, 0x95000000, 0xFC800000, 0xEA400000, 0xE5E00000, 0xE7500000, 0x34480000, 0x86340000, 0x3EBE0000, 0xD4D90000, 0x3B5D8000, 0xCF7A4000, 0xB71E2000, 0x1F69F000, 0x12C5D800, 0x9E465C00, 0x30F47A00, 0x611F1100, 0x4E69B080, 0x74457DC0, 0x5B062DA0, 0x96947D10, 0x978EDF28, 0x82000A1C, 0x73006A82, 0x4580DCC3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xA8000000, 0x6C000000, 0xD6000000, 0x0B000000, 0xFC800000, 0x65C00000, 0x16200000, 0xE0900000, 0x93C80000, 0xC7940000, 0x5B4A0000, 0x4B190000, 0x0E3D8000, 0xA42EC000, 0xC26BA000, 0x4D09D000, 0x15359800, 0x7A1BCC00, 0x24F0E600, 0x5C39F100, 0xF72D7F80, 0x01A73640, 0x609E7E20, 0xF0324D10, 0xA0D484E8, 0x8FAAADF4, 0xF729B982, 0x43A4D743 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xE8000000, 0xC4000000, 0x9E000000, 0x35000000, 0x1E800000, 0xDFC00000, 0xFE600000, 0x23300000, 0xAF680000, 0x5EC40000, 0x307E0000, 0x1A190000, 0x198D8000, 0x65AA4000, 0xAE1E6000, 0x69295000, 0xCEE44800, 0xA76E1C00, 0x2C61DA00, 0x1C31E500, 0x62E94B80, 0x3685CAC0, 0xBD5FC160, 0x77885450, 0xDE3442C8, 0x4377F05C, 0x50ED7182, 0x1F1A3FC3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0xD4000000, 0x06000000, 0xD7000000, 0x31800000, 0xD8400000, 0xDAA00000, 0xDCD00000, 0x86880000, 0x136C0000, 0xDE5E0000, 0x68F90000, 0xAD348000, 0x25BAC000, 0xD6CBE000, 0x24139000, 0x3B36E800, 0xB365AC00, 0x04F31E00, 0xA446FB00, 0xBBBD6480, 0x0ED7EF40, 0xB494F0A0, 0xEEEB0C90, 0x4F039618, 0xA45EA7DC, 0x3DF89282, 0x55B4B841 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xF8000000, 0xEC000000, 0xE6000000, 0x35000000, 0xC9800000, 0xE3400000, 0x69E00000, 0x06700000, 0x9B380000, 0xA5FC0000, 0xEAF20000, 0x28A90000, 0x96B48000, 0x05364000, 0x8C26A000, 0x70AE7000, 0x244A1800, 0xE015AC00, 0x14A6FA00, 0x386F5B00, 0x49EA0280, 0xA9049DC0, 0x882E81E0, 0x9C8BD5F0, 0xA5B5AFB8, 0x49B67B44, 0xAEE6E082, 0x3E0E6AC1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0xD8000000, 0x04000000, 0xEE000000, 0x53000000, 0xE4800000, 0x14400000, 0x31600000, 0x32B00000, 0xC2680000, 0xE0040000, 0x043A0000, 0x8DB90000, 0x82DC8000, 0x2F57C000, 0xB807A000, 0x749E3000, 0x0B924800, 0xBF1D3C00, 0x95F6F600, 0x27161100, 0xC3676C80, 0x4B2EE0C0, 0xF67A3E60, 0x73D84F50, 0x5EECBD48, 0x147EEA54, 0x06E3D282, 0xB6D5CDC1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x28000000, 0xD4000000, 0xA6000000, 0x75000000, 0x86800000, 0x51C00000, 0x6D600000, 0x06500000, 0x68780000, 0x0B2C0000, 0xCDC60000, 0x0D490000, 0x84048000, 0x2E134000, 0xBF63A000, 0x876BD000, 0x24CF6800, 0xB66D2C00, 0x6E67DA00, 0x3FF81500, 0x426C3780, 0xD867C4C0, 0xC2F8AFA0, 0x40EC0870, 0x07A76018, 0x0E980F6C, 0x663C8582, 0x4B1EFDC1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0xF8000000, 0x9C000000, 0xF2000000, 0x93000000, 0x98800000, 0x5FC00000, 0x97600000, 0x76900000, 0xEEF80000, 0xB69C0000, 0x93B60000, 0x15090000, 0x29F48000, 0xE5524000, 0x22E26000, 0x39AA7000, 0x677EF800, 0xA29D4400, 0x65B77600, 0x7809D900, 0x98747380, 0xD51364C0, 0x1CC24620, 0xE69AE170, 0x63F61378, 0x4B282E0C, 0x66C5FD82, 0xA9DBF9C1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xB8000000, 0xD4000000, 0x22000000, 0x55000000, 0xC5800000, 0x7DC00000, 0x07A00000, 0x6D100000, 0x93480000, 0x48840000, 0x6BB60000, 0x2FF90000, 0x91DD8000, 0x08FAC000, 0x288AE000, 0xE1F3F000, 0x7F6FE800, 0xFD75E400, 0xF70F7A00, 0x2AC57300, 0x30D60780, 0x32C9F940, 0x0F447720, 0x7D170810, 0xED680CC8, 0x4655C68C, 0x745E9582, 0x24ED6E43 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xD8000000, 0x04000000, 0xD2000000, 0x1D000000, 0x8F800000, 0x09400000, 0x77E00000, 0x3CF00000, 0x8A580000, 0x49840000, 0x4F7E0000, 0xAF490000, 0x042C8000, 0xF423C000, 0x4673E000, 0x1F3A3000, 0x04164800, 0x2AB50400, 0x46062A00, 0x299C8700, 0xAD9A6E80, 0x710609C0, 0x6F1D90E0, 0xB15B7730, 0xBEA76348, 0xA58C715C, 0xC5B20C82, 0x4A1B8AC1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x38000000, 0xFC000000, 0x72000000, 0xC7000000, 0x0D800000, 0x1AC00000, 0x88E00000, 0xF5300000, 0xD9C80000, 0x0B240000, 0x5AC60000, 0xC2190000, 0x96DD8000, 0xACAAC000, 0x61BBA000, 0x6EA2F000, 0x6EFFB800, 0x97140400, 0xCB8E1E00, 0x117CF300, 0xC7BA7980, 0xBFA233C0, 0x1A7F4360, 0x5D54C710, 0x572EBF08, 0xF5ED94AC, 0xCC63DF82, 0xDA1EC4C3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x28000000, 0xC4000000, 0xAA000000, 0x2D000000, 0xE0800000, 0x0B400000, 0x06200000, 0xD5B00000, 0x22A80000, 0x071C0000, 0x7C5A0000, 0xFC390000, 0xC0858000, 0xDAAF4000, 0x555F2000, 0x1756D000, 0x2DBA4800, 0x02E8B400, 0xC2BCEA00, 0x752B7900, 0x2671BA80, 0x13C95A40, 0x328DAC60, 0xD842BCD0, 0x960CDFF8, 0xB9028014, 0x1D2D1882, 0x9C339743 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x68000000, 0x3C000000, 0x4E000000, 0x1B000000, 0xE9800000, 0x15400000, 0xC0200000, 0xBEF00000, 0x3DC80000, 0x89F40000, 0xC51E0000, 0xBC190000, 0xC94C8000, 0x15624000, 0x8853A000, 0xF37B5000, 0x081FB800, 0x0A99FC00, 0x0F8C8600, 0xF9039B00, 0x2203BE80, 0xAB820240, 0xCEC3BCE0, 0x36E24810, 0xDC12EC28, 0x93DB461C, 0x4F2E8082, 0x78B16541 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x08000000, 0xBC000000, 0x2E000000, 0x79000000, 0x49800000, 0x88C00000, 0xE9200000, 0x5D300000, 0x18580000, 0x36EC0000, 0x62F60000, 0x53490000, 0x4F048000, 0x8B024000, 0x53B2E000, 0xA52B9000, 0x9FE6B800, 0x37A07C00, 0x8571C200, 0xE0385B00, 0xF23DC580, 0x7ABE1440, 0xB2CCFF60, 0x54479C30, 0xBCD18F18, 0xEC494F4C, 0x5384BF82, 0xBC433341 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x98000000, 0x14000000, 0x9A000000, 0x65000000, 0x00800000, 0xB4400000, 0x8FA00000, 0xB9700000, 0x99E80000, 0xB9C40000, 0x821E0000, 0xA4390000, 0xB6DD8000, 0x8BF2C000, 0xA0832000, 0x106BB000, 0x472E6800, 0x9E715400, 0x48689A00, 0xE705F900, 0x54FF6480, 0x1E68F940, 0xAC0525E0, 0xDB7F6450, 0x47A8EF48, 0x1B64B01C, 0xD7EF9682, 0x17915443 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x08000000, 0x8C000000, 0xBE000000, 0xEF000000, 0x3F800000, 0xD5C00000, 0x80E00000, 0x1C700000, 0xEE780000, 0x5E5C0000, 0xABBE0000, 0x27E90000, 0x0ED48000, 0x80DA4000, 0x27ABE000, 0xFC539000, 0x82CED800, 0x3B105C00, 0xB3C9EE00, 0x5AC5D700, 0x4C933F80, 0x88AFABC0, 0x40207DE0, 0x1E106A70, 0x194917F8, 0x4D854ADC, 0x07320982, 0x197F20C1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0xB8000000, 0xAC000000, 0x96000000, 0x69000000, 0xA7800000, 0x37C00000, 0xE4200000, 0xC9100000, 0x0CE80000, 0x74C40000, 0xEA6A0000, 0x6AD90000, 0xF5BD8000, 0x3507C000, 0x6D162000, 0x4A7FF000, 0xEF7A1800, 0xA0314C00, 0xB078C200, 0x44ED8700, 0x1E0E4B80, 0x9EE31E40, 0x22ECFB20, 0x9F0E8750, 0xCD633348, 0xBF2C7E34, 0x3C2E9182, 0x66F2D543 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xE8000000, 0x24000000, 0x56000000, 0x91000000, 0x6F800000, 0x82C00000, 0x3FE00000, 0x14300000, 0xBA180000, 0xAE140000, 0xB00A0000, 0x3E490000, 0x62FC8000, 0xCBE74000, 0x2C66E000, 0x9AA65000, 0x4B468800, 0xF2778C00, 0xBDEFD200, 0x723A6700, 0x55511180, 0x036849C0, 0x092C4160, 0xC5CF58B0, 0xC86BEF68, 0x6CB8AB34, 0xE104CB82, 0xF8C2E2C1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0xF4000000, 0xBA000000, 0x85000000, 0xE6800000, 0x3A400000, 0x2FE00000, 0x2B500000, 0xE5980000, 0x31740000, 0xD6CA0000, 0x35A90000, 0xE4FC8000, 0x7946C000, 0xA2072000, 0xF9675000, 0xF976A800, 0x7F8E1400, 0xB2EABA00, 0xBCD99500, 0x13145880, 0x6E5BF9C0, 0xDE11FDA0, 0x91F9B4B0, 0x3AE4D2A8, 0x78F24374, 0x576CCA82, 0x6B7EB8C1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x68000000, 0xB4000000, 0xE2000000, 0xCF000000, 0x1A800000, 0xFBC00000, 0x65E00000, 0x47900000, 0x5BC80000, 0x04840000, 0xAD660000, 0x79390000, 0x301D8000, 0x3B4BC000, 0x518B2000, 0x67EA5000, 0x643A2800, 0xD052A400, 0x9DE62E00, 0xC9F8ED00, 0x357DEB80, 0x841AC9C0, 0x4B227820, 0x463E1710, 0xC0F57248, 0xC43EE6AC, 0xDFF46D82, 0x56BF40C3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x98000000, 0x44000000, 0xE2000000, 0x59000000, 0x09800000, 0xFFC00000, 0xCB200000, 0xCCD00000, 0x15C80000, 0x510C0000, 0x78920000, 0xFDB90000, 0xACD58000, 0x57F74000, 0x26B7A000, 0xD4D7B000, 0xF6674800, 0xC71EA400, 0x4C6AE200, 0x770CCB00, 0x0393E380, 0x0D39B840, 0x0A9464A0, 0xFB164910, 0x654686D8, 0xEFCFD444, 0xEBA3C982, 0xE7009743 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0xA8000000, 0x3C000000, 0x1E000000, 0xC5000000, 0xCC800000, 0x61C00000, 0xF9200000, 0x9AB00000, 0x63A80000, 0x453C0000, 0xE7220000, 0x89B90000, 0x51648000, 0x3956C000, 0x9836A000, 0x6EE6D000, 0xFB1F3800, 0x4C1ADC00, 0x641C3A00, 0x19935100, 0xD011B780, 0x8B584C40, 0x5DF4F260, 0x5BCFF3D0, 0xB0E3C4B8, 0xC99821E4, 0x79543582, 0x2E3E0141 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xF8000000, 0x1C000000, 0xDE000000, 0xE7000000, 0x5D800000, 0x87C00000, 0x05A00000, 0xF1700000, 0x77180000, 0x47740000, 0x22AA0000, 0xA9490000, 0x035C8000, 0x7CA74000, 0x4E47A000, 0x0DD67000, 0x795EF800, 0xEAA3DC00, 0x0BF45E00, 0xBBEA1300, 0x14A99B80, 0x194D9140, 0xBDEFA3E0, 0x491AB0B0, 0x43713328, 0xA6182E74, 0xB9F5BD82, 0x6AEA1E41 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x98000000, 0x1C000000, 0xF6000000, 0x17000000, 0x27800000, 0x80400000, 0x17A00000, 0xE4F00000, 0x28580000, 0xCF240000, 0x45EA0000, 0x83890000, 0xE04D8000, 0xBF76C000, 0x6B17E000, 0x4207B000, 0x800E7800, 0xDF034C00, 0xB455BE00, 0x21F2E700, 0x250CC480, 0xA2578540, 0x41268CE0, 0x393E8530, 0x69BA4C88, 0x3CA094F4, 0xE5708282, 0x3719EE43 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x18000000, 0xD4000000, 0xDA000000, 0x85000000, 0x4E800000, 0x37C00000, 0x51600000, 0xBF300000, 0xBD380000, 0xE1DC0000, 0xD22E0000, 0x30E90000, 0x66948000, 0x8E6B4000, 0xAE4AA000, 0x5BDBB000, 0x76B36800, 0x0266D400, 0x8B2C5A00, 0xFF776500, 0x4285A380, 0xBF42A4C0, 0x82BE8560, 0xC300BEF0, 0x9D80DDF8, 0x5240C87C, 0xA7201182, 0x0A1155C1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xB8000000, 0xFC000000, 0x76000000, 0xE5000000, 0x08800000, 0x31C00000, 0x50600000, 0x27D00000, 0xEE780000, 0xD53C0000, 0x39CE0000, 0xE8490000, 0x03D48000, 0xDE2BC000, 0x978B2000, 0xE43AF000, 0x4793B800, 0xFFD68C00, 0x46A4DA00, 0x5263F900, 0xAE5EE780, 0xE110AEC0, 0x6998B0A0, 0x10AC9070, 0x0F970E38, 0x4184AC7C, 0xFD130582, 0xE1171BC1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x08000000, 0xCC000000, 0xEE000000, 0x43000000, 0xA7800000, 0x87C00000, 0x72200000, 0xDED00000, 0x95D80000, 0xD1740000, 0x3A4E0000, 0x89A90000, 0xE03C8000, 0xC2024000, 0x38E36000, 0x9D939000, 0x325A5800, 0x93567C00, 0x297D3600, 0xB1626700, 0x39527B80, 0xF7FBD640, 0xF247E0A0, 0x0A840930, 0x9CC6EC28, 0x3BC543FC, 0x4BA79582, 0x08748D41 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0xF8000000, 0x14000000, 0xB6000000, 0x61000000, 0x0B800000, 0x37C00000, 0x68A00000, 0x54900000, 0x3C480000, 0xBC2C0000, 0x4E6E0000, 0xF7B90000, 0x5C548000, 0x0A9B4000, 0xF1B36000, 0xB5AE7000, 0x4D18E800, 0x87C4CC00, 0x78521200, 0x3FDEAF00, 0xD1A15B80, 0x3B109740, 0xE5883020, 0x918D5210, 0x5F7E0998, 0x8930CF3C, 0x3558C182, 0x46A48441 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x98000000, 0x0C000000, 0x9E000000, 0xAB000000, 0x96800000, 0xABC00000, 0xC1200000, 0x16300000, 0x93280000, 0xCA940000, 0x833A0000, 0xF7F90000, 0x42AD8000, 0xF2B74000, 0xF67FE000, 0xF27BB000, 0x6319D800, 0xEEBD1C00, 0x092FC600, 0x9003E500, 0xE8F5C380, 0x34EB3040, 0xF541CB60, 0x4EE05AD0, 0x7D1005E8, 0xCC183BD4, 0x623C3D82, 0xD3EE7943 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x58000000, 0xC4000000, 0xDE000000, 0x7B000000, 0x7D800000, 0x8E400000, 0xC8A00000, 0x19100000, 0xA9F80000, 0xD33C0000, 0x451E0000, 0x4E090000, 0xBF758000, 0xB0CB4000, 0x26D26000, 0x58DE3000, 0xEBE84800, 0x77441C00, 0xE0626600, 0xB7B7A300, 0x6E6D1880, 0x19479340, 0xE6A4A320, 0xCE521270, 0x481EA8B8, 0xB489E1DC, 0x46B55682, 0xBB2A1C43 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x18000000, 0xD4000000, 0x0E000000, 0x37000000, 0xB8800000, 0x9E400000, 0x16A00000, 0xFC500000, 0x5D880000, 0xF71C0000, 0x43AA0000, 0x7D390000, 0x8E658000, 0x026E4000, 0x1C876000, 0xC1AAB000, 0x70396800, 0x1FE5BC00, 0x3BAE7E00, 0xE0E78900, 0x6F1A3880, 0xFE413740, 0xC6A15BA0, 0xF4508890, 0xA18876F8, 0x351DEA34, 0xAEAA4E82, 0xFCB9B243 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xF8000000, 0x74000000, 0x96000000, 0xA7000000, 0x8B800000, 0x95400000, 0x43600000, 0x6FF00000, 0xFA680000, 0x448C0000, 0x4BEA0000, 0x9FB90000, 0xC8748000, 0xFFFE4000, 0x0036A000, 0x196A7000, 0xCA792800, 0x87D44C00, 0x5F2F5E00, 0x764EAF00, 0x34BE9E80, 0xD857CCC0, 0x171BCAE0, 0xC8511750, 0xB6B84A58, 0x20F43074, 0x7F3E4882, 0x2D175FC1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x88000000, 0x3C000000, 0xC6000000, 0xB7000000, 0x69800000, 0x0C400000, 0x1C200000, 0xC4700000, 0x8DC80000, 0xCD540000, 0xB69E0000, 0xFFD90000, 0xBFCC8000, 0x03F34000, 0xC19BE000, 0x55FE9000, 0x7C08B800, 0x1734AC00, 0x37CFDE00, 0x24E05B00, 0xD4907C80, 0xE359E240, 0xFF0D59E0, 0xE713AE10, 0xF50A1168, 0x66A6C91C, 0x7B04FA82, 0x44278541 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x18000000, 0xEC000000, 0x32000000, 0x95000000, 0xE9800000, 0x11400000, 0xF2600000, 0x3EF00000, 0x56680000, 0x49540000, 0xE8EE0000, 0x41B90000, 0xBAAC8000, 0x6AA2C000, 0x8E2BA000, 0x6B4FB000, 0x2FE89800, 0x60148400, 0xC68F7A00, 0x05499B00, 0x8DC52E80, 0x1477B2C0, 0xD08540E0, 0xA416C750, 0x53749FE8, 0xBFFE2E7C, 0xCD616C82, 0xEE711DC1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0x88000000, 0x84000000, 0xEE000000, 0xBD000000, 0xDF800000, 0x3EC00000, 0x6DE00000, 0x0B100000, 0xA8980000, 0xD2BC0000, 0x4AE60000, 0x26A90000, 0x6DD58000, 0xAE524000, 0x4BAB6000, 0x54479000, 0xC199C800, 0xBB3C7C00, 0xD5264A00, 0x46C8C700, 0x07043980, 0x63AB35C0, 0x20466F20, 0x879879B0, 0xB23C7438, 0x6CA7D9AC, 0x4108DB82, 0x5B641EC3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x78000000, 0x7C000000, 0xE6000000, 0x03000000, 0x0A800000, 0xCC400000, 0x3B600000, 0x73900000, 0xBCC80000, 0xC3F40000, 0x921A0000, 0xE2790000, 0x72CD8000, 0x8736C000, 0xC19FE000, 0x327A7000, 0x5768B800, 0xFC446C00, 0x70A2D600, 0xB495FD00, 0xDF8BDC80, 0x31B084C0, 0x55B85820, 0xDE6CC210, 0x880664A8, 0x1A661154, 0x5E765282, 0x4B7F65C3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xF8000000, 0x84000000, 0x0E000000, 0x73000000, 0xB4800000, 0x92C00000, 0xEFE00000, 0x3EF00000, 0x6E880000, 0x75140000, 0x973A0000, 0xF7590000, 0x0F8C8000, 0x51D74000, 0x83BEA000, 0xECDA7000, 0xDFA9C800, 0xE6047C00, 0xB643F600, 0x89453100, 0xCAE34180, 0x01146DC0, 0xF13ACEE0, 0x5859C790, 0xE10D5168, 0x461705D4, 0x2FDFDF82, 0xFA6B50C1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0xB8000000, 0x8C000000, 0x1E000000, 0x6F000000, 0x3D800000, 0x9E400000, 0x64A00000, 0x7BF00000, 0x41E80000, 0xE2340000, 0x26F20000, 0x67F90000, 0x450D8000, 0x7A9FC000, 0x1376A000, 0xE543F000, 0x61B05800, 0x1F49DC00, 0x3CC5CE00, 0x779BB300, 0xEF0C6880, 0x479EB340, 0xBFF6AEE0, 0xF9823A50, 0x1ED07AA8, 0x1259B7C4, 0x7C7D5E82, 0xC0B62C43 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xC8000000, 0x34000000, 0x16000000, 0xCD000000, 0x30800000, 0xDF400000, 0x73E00000, 0x50B00000, 0x7D380000, 0xD4640000, 0xE7FA0000, 0x38290000, 0x0C8D8000, 0xDC56C000, 0x4DEE6000, 0x74CB1000, 0x23D02800, 0xFAC80C00, 0x8EBDAA00, 0xC52EF900, 0xA7EB6A80, 0xE441B9C0, 0xFE603660, 0x17711FF0, 0x55986088, 0x2935CFD4, 0x33728882, 0xB7F55CC3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x48000000, 0x34000000, 0xF2000000, 0x59000000, 0x6B800000, 0xCDC00000, 0xADA00000, 0x62D00000, 0xFCF80000, 0x498C0000, 0x7D7A0000, 0xB1490000, 0xC2858000, 0x899F4000, 0x44A6E000, 0xA68A1000, 0xB221A800, 0x3D10C400, 0x58588200, 0xF8DDCF00, 0x30428780, 0x93656540, 0x762EC4A0, 0xF6AE4770, 0x69EFE4D8, 0x320FAF94, 0x88BF4D82, 0xC7377E43 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xB8000000, 0x9C000000, 0xA6000000, 0x17000000, 0x17800000, 0xEB400000, 0xB1600000, 0x95500000, 0xB2180000, 0x757C0000, 0x2D8A0000, 0xA8690000, 0x39D58000, 0x227E4000, 0x90276000, 0x35BBF000, 0xD921F800, 0x71B0EC00, 0xC1097E00, 0xE0840700, 0x9E66D280, 0xE65A38C0, 0x8DB0E7A0, 0xB70973B0, 0x5F8451B8, 0x9DE6D5F4, 0x8F1B3482, 0x11D023C3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0xB8000000, 0xAC000000, 0x9E000000, 0xED000000, 0x2E800000, 0x32C00000, 0x56E00000, 0x0E100000, 0xB0680000, 0x381C0000, 0x830E0000, 0x24D90000, 0xBA458000, 0x4F8A4000, 0x97B22000, 0x6CE7F000, 0x76859800, 0x846BDC00, 0xBF22CA00, 0x6A4FD500, 0x9279B180, 0xD675F3C0, 0x7612B720, 0x19568A50, 0x145D7178, 0x0F2FAC7C, 0x48294382, 0xA63C4AC3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x78000000, 0x4C000000, 0xB2000000, 0x81000000, 0xBB800000, 0x1F400000, 0x1C200000, 0x52B00000, 0x46D80000, 0xB55C0000, 0x8C220000, 0x94890000, 0x8E558000, 0x13374000, 0x709F6000, 0xEAFA7000, 0xD1D55800, 0xDA77C400, 0xFBBFD200, 0x34CBFF00, 0x34CCF280, 0xA8CA6640, 0xAECD6460, 0x8DCB4E30, 0xA34D5778, 0x958AA5E4, 0x7BEC9882, 0x50FB6D43 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xF8000000, 0x94000000, 0xBA000000, 0x85000000, 0xBC800000, 0xEFC00000, 0x58600000, 0x26D00000, 0xE0580000, 0xF2140000, 0xEC9E0000, 0x19A90000, 0x993D8000, 0x7562C000, 0x952B2000, 0xFD877000, 0x9D1D6800, 0x95921400, 0x44831A00, 0xB8BB0100, 0x4E7E3380, 0x43B986C0, 0x5685DAA0, 0xDDE65430, 0xEFCD7E68, 0xAFCBDDDC, 0x2396E182, 0x10A523C3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x28000000, 0x34000000, 0x1E000000, 0x01000000, 0x12800000, 0x83400000, 0xCD200000, 0xB0D00000, 0xBFD80000, 0x3F940000, 0x95E60000, 0x17E90000, 0xB8FD8000, 0x455BC000, 0x7212A000, 0x3AFED000, 0xB49D2800, 0x33ABDC00, 0x409B3200, 0xD2733D00, 0x5E0E4280, 0x65152C40, 0x32A6CAA0, 0x0CC90630, 0xED2CE2E8, 0xDE0310AC, 0xFBC77882, 0x6EB8DD43 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x88000000, 0x0C000000, 0x86000000, 0x61000000, 0xBB800000, 0xD3400000, 0x32600000, 0x3CD00000, 0x7A780000, 0x238C0000, 0xF7160000, 0x8A090000, 0xAD058000, 0x77D2C000, 0xDD7A2000, 0x528F9000, 0x0F145800, 0x558B6C00, 0xAFC73200, 0x2A71DF00, 0x8188E280, 0xC64452C0, 0x31B2F0A0, 0x73AAEF70, 0x4BF76658, 0x7C19DBCC, 0x2D5C2882, 0x1E6FB1C3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xC8000000, 0x1C000000, 0xB6000000, 0x43000000, 0x87800000, 0x74400000, 0x3C200000, 0xD9500000, 0xA3680000, 0x03C40000, 0x41B60000, 0x93D90000, 0xAA9C8000, 0x07EAC000, 0x8DD36000, 0xC57E1000, 0xCB0D7800, 0x57634C00, 0xF926B600, 0x79D14700, 0x72A86C80, 0xC2A50A40, 0xE646A7A0, 0x91208F50, 0xD9D04C48, 0x62A88B0C, 0x5AA44282, 0x0247D141 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x08000000, 0xA4000000, 0xDA000000, 0x73000000, 0x25800000, 0xC4C00000, 0x26A00000, 0xB4700000, 0x05980000, 0x8DC40000, 0x6C8E0000, 0xE8090000, 0xA74C8000, 0xB8824000, 0x45EA6000, 0x3FF79000, 0x895C8800, 0xE3CA1400, 0x97C6D600, 0xCA25F300, 0x7A9FA580, 0x5F407740, 0x2B6181E0, 0x545037B0, 0xE8A90848, 0xC63D373C, 0x0D9B1B82, 0x9C6E4041 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x58000000, 0x7C000000, 0xE2000000, 0x5B000000, 0x97800000, 0xE2C00000, 0xF1A00000, 0x87700000, 0xF3B80000, 0xB8B40000, 0xA1660000, 0x43290000, 0xCC9D8000, 0x707AC000, 0xCE92E000, 0x0A2E3000, 0xFEE4B800, 0x82EF6400, 0x20442600, 0xC41F0700, 0x5C3D8980, 0x878A0940, 0xCA6A23E0, 0x0AFA23F0, 0xE6D34CA8, 0x2BCF84EC, 0xB4747782, 0x71C79A43 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0xD8000000, 0x44000000, 0x2A000000, 0x29000000, 0x31800000, 0x22400000, 0xAEA00000, 0x3A100000, 0xB5D80000, 0xBB240000, 0x30720000, 0x0FA90000, 0x4B8D8000, 0x1D7E4000, 0x0A16E000, 0xB9FB3000, 0x95F44800, 0xDBCA7400, 0xCAFD4200, 0x61573B00, 0x36DA6880, 0x85A4B340, 0xACB26120, 0xFDC93630, 0xA3FD8888, 0xB0D62704, 0xC49A0282, 0x03058C43 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0xA8000000, 0x74000000, 0x5E000000, 0xEF000000, 0x8F800000, 0x4C400000, 0x70600000, 0xA9700000, 0x35D80000, 0x33CC0000, 0x018E0000, 0xDC090000, 0x96C48000, 0x13CBC000, 0x1A02A000, 0xFBE6D000, 0x48BCA800, 0x19565C00, 0x4545EE00, 0x358B8700, 0x3B635C80, 0xE2174AC0, 0x16A43FE0, 0x62BA3A30, 0xC3DB8CD8, 0x9A2B6FBC, 0x24323A82, 0x8FDE81C1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xF8000000, 0x54000000, 0xCA000000, 0x95000000, 0x35800000, 0xBE400000, 0x95A00000, 0x6A700000, 0x96180000, 0x836C0000, 0x53320000, 0x7B090000, 0x8F648000, 0x80D64000, 0x061F6000, 0x619A7000, 0xD81D6800, 0xA2AB3400, 0x9725FA00, 0x7E77D300, 0x16EEF080, 0x2142DD40, 0xE91031E0, 0x2E0919B0, 0xDAE57E18, 0x2E963744, 0x5BBF8282, 0xA7EB0A41 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xB8000000, 0xB4000000, 0xDA000000, 0xDD000000, 0x2A800000, 0x9AC00000, 0x15200000, 0x3F500000, 0x67480000, 0x93AC0000, 0xCC9A0000, 0x2A790000, 0xBBD48000, 0x0E4F4000, 0x3CB6E000, 0x3CA2F000, 0xDB4DA800, 0xF16B9400, 0x92216A00, 0x88D12D00, 0x7709D980, 0xEC4CAC40, 0x5EEB55A0, 0xC6607C10, 0x95315998, 0x8C780254, 0xF0D57B82, 0x37CEA541 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x38000000, 0xE4000000, 0x26000000, 0x99000000, 0x73800000, 0x9CC00000, 0x46A00000, 0x63B00000, 0xC5280000, 0x4EB40000, 0xC7420000, 0xDEB50000, 0x9F438000, 0x4AB44000, 0x51422000, 0x0FB43000, 0xE0C3E800, 0x2C747C00, 0x4CE2DA00, 0xA0849B00, 0x53ABE380, 0xCB201640, 0x327124E0, 0x9E089C10, 0x24C43988, 0xCD4A5294, 0x347124E2, 0x17089C13 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0x08000000, 0xB4000000, 0x56000000, 0x4F000000, 0x87800000, 0x0EC00000, 0x1B600000, 0x8CF00000, 0x37C80000, 0x7BBC0000, 0xBBFA0000, 0x0FBD0000, 0x4DFA8000, 0xD0BCC000, 0xB27A6000, 0x627CD000, 0x4B1B0800, 0xF78C7C00, 0xB4539600, 0x05717300, 0x1A098B80, 0x9D5C45C0, 0xECCA1260, 0x0194EA50, 0x9EF68518, 0xD7AE4DA4, 0x97AA1262, 0xBD64EA51 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xF8000000, 0xE4000000, 0x72000000, 0xE7000000, 0x10800000, 0x38C00000, 0x42600000, 0x2A700000, 0x23A80000, 0x01540000, 0x9A820000, 0x85550000, 0x78838000, 0x7A54C000, 0xDC032000, 0xC8953000, 0x9D62E800, 0x8065D400, 0x610B2600, 0xD3D1F500, 0xE9395780, 0x374C71C0, 0xBA9E8360, 0xF432F690, 0xE29CA1C8, 0xDEA77394, 0x80FE8362, 0xFA42F693 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x58000000, 0xEC000000, 0x76000000, 0xA9000000, 0xE5800000, 0xAD400000, 0x71600000, 0x4A700000, 0x76380000, 0xC8240000, 0x30EE0000, 0x74250000, 0xCEEE8000, 0xF925C000, 0x196F6000, 0x3F657000, 0xBE8EB800, 0xE2D59C00, 0x5817EA00, 0x59205700, 0x8890B080, 0xA809B5C0, 0x82FCA460, 0xABFB99B0, 0xD993D428, 0xE79EC86C, 0x3D9CA462, 0x148B99B1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x98000000, 0x54000000, 0xD2000000, 0x41000000, 0x85800000, 0x23400000, 0xC1600000, 0x30D00000, 0xE3F80000, 0xD3F40000, 0x8ADE0000, 0xC1F50000, 0x6BDE8000, 0x7474C000, 0x009F2000, 0x7915F000, 0xB64F8800, 0x09EC5400, 0xA13B0A00, 0x25F35F00, 0x82EE4C80, 0xBF9C5DC0, 0x25B2ED20, 0x8F0EBA30, 0x058CBAC8, 0x726B278C, 0xA64AED22, 0xCCFABA31 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0xF8000000, 0xFC000000, 0xC2000000, 0x9B000000, 0xEE800000, 0xA5400000, 0x29200000, 0x31D00000, 0x4F580000, 0x3F740000, 0x52520000, 0x15750000, 0x6D538000, 0xF5F5C000, 0x39132000, 0xAD543000, 0x7D02D800, 0x376DB400, 0x2F07EE00, 0x50766900, 0xC63FA480, 0x48F3BB40, 0x0A650720, 0x79EA85F0, 0x52B109C8, 0x8F291954, 0x89BD0722, 0xE8DE85F3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x58000000, 0x44000000, 0xEE000000, 0x59000000, 0x23800000, 0x19C00000, 0x82600000, 0x19D00000, 0xBC980000, 0xC8740000, 0x5A4E0000, 0xEE750000, 0xAF4F8000, 0x5FF5C000, 0x358F6000, 0x11157000, 0x0B1FE800, 0xFBACAC00, 0x181B5A00, 0xA54AEB00, 0x82926980, 0xA6C66FC0, 0xB8F89A20, 0x34A4F6F0, 0x7F573AC8, 0xA0C08A6C, 0x11E09A22, 0x3810F6F3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x28000000, 0x4C000000, 0x6A000000, 0xB9000000, 0x33800000, 0x9D400000, 0xFBE00000, 0x4E900000, 0xA1580000, 0xA5540000, 0x69120000, 0xE3550000, 0xCA138000, 0xF1D54000, 0x90D2A000, 0x99751000, 0xBAA23800, 0x963DC400, 0xA96F4A00, 0x0F5BA300, 0x0B197080, 0x3234D4C0, 0x7A432DA0, 0x3E2C7670, 0x5CF6D708, 0x5DAF0C54, 0xA8FB2DA2, 0xC9E87673 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xB8000000, 0x8C000000, 0x32000000, 0x81000000, 0x59800000, 0xEFC00000, 0x54A00000, 0x8C900000, 0xC5580000, 0xBDDC0000, 0x1B060000, 0x93DD0000, 0x70068000, 0xB75D4000, 0x1C462000, 0xB93C3000, 0x23F73800, 0xAC345400, 0xD7523A00, 0x303EE700, 0x21B0E580, 0xB609CE40, 0xB4243CA0, 0xF64A24F0, 0xC783D718, 0x53075AFC, 0xB7DC3CA2, 0x560624F1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x48000000, 0xBC000000, 0xBA000000, 0x2D000000, 0x11800000, 0x0B400000, 0x21200000, 0x81100000, 0xC2880000, 0x00640000, 0xD3FE0000, 0xB6650000, 0x5CFE8000, 0x5EE54000, 0x503EA000, 0xAB85D000, 0x708FD800, 0x48DCA400, 0xB5038200, 0x2AF68700, 0x98409480, 0x23A14540, 0xC8D056A0, 0x8A682050, 0xD994A668, 0x80864FAC, 0x597856A2, 0xDA1C2051 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xA8000000, 0xD4000000, 0xFE000000, 0xA3000000, 0x9B800000, 0xA6C00000, 0x4AA00000, 0x61900000, 0x8D180000, 0x005C0000, 0x4A9E0000, 0x935D0000, 0xB91F8000, 0xC19D4000, 0xBDBEE000, 0xAB0C1000, 0x7F274800, 0xF391EC00, 0xDC180E00, 0x9ADDDB00, 0x4EDEC380, 0x11BC0E40, 0xD86EE0A0, 0xA4F40470, 0x1E0A2818, 0xDC663D4C, 0xECF0E0A2, 0x54A90473 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x38000000, 0xBC000000, 0xD2000000, 0xD3000000, 0x78800000, 0x17C00000, 0x30A00000, 0x38300000, 0xBB880000, 0x7F040000, 0x9B620000, 0x14050000, 0x1FE28000, 0xB1C5C000, 0xCC42E000, 0xC975B000, 0xDC0B9800, 0x54D01400, 0xAC583E00, 0x83DDE500, 0xDB7E9180, 0x99DA4440, 0x3B0901E0, 0xF4C40350, 0x29C3A7E8, 0xF735C194, 0x58EB01E2, 0xB7010351 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xE8000000, 0xB4000000, 0x12000000, 0x1B000000, 0xF1800000, 0xC7C00000, 0x21A00000, 0x71300000, 0x8C680000, 0x6F140000, 0xAD0A0000, 0xC8150000, 0x4A8A8000, 0x8ED5C000, 0xC5AB6000, 0x33A41000, 0x00A20800, 0xEFA03400, 0x8C303E00, 0x14E8D700, 0xB2553180, 0x52EA5440, 0xEB4533E0, 0x84721C90, 0x079845C8, 0x7A5C8284, 0xFE6F33E2, 0x0E971C91 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xE8000000, 0x14000000, 0x72000000, 0xCD000000, 0x5D800000, 0x99C00000, 0xD1A00000, 0xF9300000, 0x8F080000, 0x897C0000, 0x7F6E0000, 0xE67D0000, 0x77EE8000, 0xBE3DC000, 0x698EE000, 0xC1AC1000, 0x9B36C800, 0x7198F400, 0xE8455200, 0x9D9B4F00, 0x962FE180, 0x839DAC40, 0x4EBF33E0, 0x3DA54250, 0x0CCB7918, 0x61B6C08C, 0xA4D933E2, 0xCBA44251 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x30000000, 0x78000000, 0x14000000, 0xB6000000, 0x65000000, 0x9F800000, 0x6F400000, 0x9DA00000, 0x7F700000, 0x7F380000, 0x80E40000, 0x5AB60000, 0x7BE50000, 0x1C368000, 0xC1244000, 0x61D6E000, 0x0374B000, 0x565EC800, 0x42C9DC00, 0xFB1C0200, 0x0EB3E300, 0xEE835C80, 0x941A1840, 0xEF8E0260, 0x34013630, 0xC600BBA8, 0xBD01B75C, 0xBB800262, 0xA1403631 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x98000000, 0x44000000, 0x02000000, 0xB9000000, 0x4C800000, 0x90C00000, 0x7D200000, 0x7EF00000, 0x47B80000, 0xFF3C0000, 0xC1860000, 0x683D0000, 0xCA078000, 0x1B7CC000, 0xF866E000, 0xA1EDF000, 0x264E6800, 0x3179F400, 0xA91D1A00, 0x82F66D00, 0x9FC4BB80, 0x06DAD740, 0x262AE660, 0x5E930830, 0xB62F2018, 0xA2E9C73C, 0xF3B4E662, 0xEEA20833 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x68000000, 0xB4000000, 0xBA000000, 0xB9000000, 0x9F800000, 0xA6C00000, 0x87A00000, 0x05D00000, 0x12080000, 0xB47C0000, 0x58B60000, 0x6BFD0000, 0x5E778000, 0x7C5DC000, 0xC3A66000, 0xB2551000, 0x79DB0800, 0xE9E26400, 0x34A77A00, 0x8ED4DB00, 0x699BF780, 0xCF03B440, 0xCC16EC20, 0x10AC9850, 0xC93FE0D8, 0x1740533C, 0x72616C22, 0x5CF15853 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x18000000, 0xF4000000, 0x5A000000, 0xBF000000, 0x19800000, 0xF5400000, 0x8FE00000, 0xA9B00000, 0x4E380000, 0x40CC0000, 0x23D60000, 0xA94D0000, 0xBE968000, 0xFAACC000, 0x71272000, 0xBD94F000, 0x396AC800, 0x97824400, 0x4C06B600, 0xE384F700, 0x2B839C80, 0xBA06C8C0, 0x12843FE0, 0x07039CB0, 0xF1C77A78, 0x85A42D1C, 0x8E12BFE2, 0x26AF5CB1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xD8000000, 0x44000000, 0x8E000000, 0x8D000000, 0x1C800000, 0xF5400000, 0x81200000, 0x14D00000, 0x90F80000, 0xF8340000, 0x081E0000, 0xECB50000, 0x115E8000, 0x1F95C000, 0x728EE000, 0x48EC7000, 0xAA7A6800, 0xA6136C00, 0xAB7E7200, 0xAEC5D500, 0x3DB65880, 0x3DB83740, 0x7D150120, 0xF2CEFEB0, 0xC14DDD48, 0x2DEB3C8C, 0xA6CB8122, 0x911B3EB1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0xA8000000, 0xDC000000, 0x42000000, 0x7B000000, 0xB2800000, 0xDF400000, 0x67A00000, 0xFCD00000, 0x9D180000, 0xB73C0000, 0x685A0000, 0xF9BD0000, 0xA51B8000, 0xDD1DC000, 0x6F4A6000, 0xA9449000, 0x5AD7D800, 0xB64E1400, 0x28B22E00, 0xAE08F100, 0xD9C45080, 0x3E975E40, 0x036EB920, 0xFB227C70, 0xFCB0A358, 0x4E2892C4, 0x89D53922, 0x36EFBC73 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xF8000000, 0xBC000000, 0x36000000, 0xDF000000, 0x9B800000, 0x33400000, 0x16600000, 0xD5300000, 0x7D980000, 0xABD40000, 0xDBA60000, 0xB4550000, 0x02E68000, 0xFB354000, 0xFB57A000, 0x6A6CB000, 0xFFA2D800, 0x9B9ADC00, 0xA7DE6600, 0xE7F16B00, 0x09B94080, 0xB005E7C0, 0x7DCFDAE0, 0x603804F0, 0x9644B148, 0x392FC5BC, 0x52C95AE2, 0xAD7D44F1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x18000000, 0x9C000000, 0x1E000000, 0x07000000, 0xFA800000, 0xA0400000, 0x5BE00000, 0x12700000, 0x3EA80000, 0xC5840000, 0x9A860000, 0x9B050000, 0x68C78000, 0x61E44000, 0x0B37A000, 0x038C7000, 0xAE129800, 0x341A4C00, 0xBE8F9600, 0x06903900, 0x32589680, 0x696C2EC0, 0x15E24260, 0x6A730B90, 0x15AB6568, 0x2E07F89C, 0x4445C262, 0xE5A74B93 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0x78000000, 0x04000000, 0x96000000, 0xF3000000, 0xA4800000, 0x42C00000, 0xA5600000, 0x8ED00000, 0xA8680000, 0xB9A40000, 0x7AF20000, 0xF1250000, 0x12338000, 0x5545C000, 0x4D63A000, 0x906D3000, 0xB3E7A800, 0x15EE1C00, 0x321B4E00, 0x3C40D500, 0x4EA00B80, 0xE6313FC0, 0xC9F8A620, 0x4BEC8710, 0x6FA62968, 0x8B4E6CF4, 0xCC2B2622, 0xE1B94713 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0x44000000, 0xCA000000, 0x63000000, 0x68800000, 0xEAC00000, 0x8F600000, 0xC9500000, 0xA1380000, 0x35AC0000, 0x016E0000, 0x372D0000, 0x98AE8000, 0xE8CDC000, 0xA73EE000, 0x20951000, 0xB6C26800, 0x41428400, 0x5503AE00, 0xD5A2D500, 0x2612BB80, 0x0D3BABC0, 0xB38FF920, 0x893C61B0, 0xD1B70678, 0xC410256C, 0x02197922, 0x605DA1B1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xD8000000, 0xAC000000, 0x3A000000, 0xB3000000, 0x59800000, 0xA4C00000, 0x64E00000, 0x13900000, 0x82280000, 0x0F0C0000, 0x586A0000, 0x308D0000, 0xDDAA8000, 0xFAED4000, 0x6D7AA000, 0x45E4F000, 0x6987F800, 0xF8768400, 0xFE8F9E00, 0xF88AB700, 0x3D1C9780, 0x82835EC0, 0x996180A0, 0x99514290, 0xF3C8CAB8, 0x041DA444, 0xE00300A2, 0x30200291 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x48000000, 0xCC000000, 0xFA000000, 0xF5000000, 0xBE800000, 0x8AC00000, 0xACE00000, 0xF2F00000, 0x3FE80000, 0xC8740000, 0x5DFA0000, 0x18F50000, 0x7C3A8000, 0x7995C000, 0x2D8B2000, 0xAFDD5000, 0xB9AEB800, 0x161EA400, 0x43565200, 0x06F35900, 0xAE718780, 0x8428A0C0, 0x8C157260, 0xFACB0710, 0x887D7688, 0xBEFFE6E4, 0xC7A7F262, 0x561AC711 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xE8000000, 0x9C000000, 0x6E000000, 0x7F000000, 0x75800000, 0x9A400000, 0xC2200000, 0xC3D00000, 0xF1B80000, 0xE6140000, 0x82BA0000, 0x6C950000, 0x2D7A8000, 0x14F54000, 0xBC8BA000, 0xCE9C9000, 0x37269800, 0xC4324C00, 0xA6096600, 0xF05D2700, 0x05C79280, 0x9A024340, 0xB4012520, 0x9201A830, 0xA1003D08, 0x72818744, 0x9BC1A522, 0xAA61E831 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x78000000, 0x24000000, 0x5E000000, 0xD9000000, 0x2C800000, 0xF6C00000, 0x87600000, 0x41500000, 0x94480000, 0xC9CC0000, 0x6B2E0000, 0xB44D0000, 0x9D6E8000, 0xF7EDC000, 0xD05E2000, 0xD5753000, 0xF49A6800, 0xADB78C00, 0xEE88DA00, 0x0CAC5500, 0xE97E7780, 0xDB84BBC0, 0x2FE2E520, 0xE5E34B50, 0x0AE2D2B8, 0xC362AB0C, 0x33226522, 0xBD838B51 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0xB8000000, 0x0C000000, 0x46000000, 0x4F000000, 0x16800000, 0x6CC00000, 0xC1A00000, 0xA5500000, 0x58780000, 0xA1DC0000, 0x4E720000, 0xCC5D0000, 0xBE338000, 0x083DC000, 0xF3436000, 0x3754B000, 0xAB877800, 0xFA0A3C00, 0x9B80E600, 0x67409100, 0xAEE07F80, 0xDFB0B240, 0xBDC86520, 0xAD158AB0, 0xB6E6C298, 0x46FA1C54, 0x1AA9E522, 0x60E54AB3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xF8000000, 0xF4000000, 0x32000000, 0xDF000000, 0xFF800000, 0x4FC00000, 0x3CE00000, 0x68D00000, 0x17180000, 0x6EE40000, 0x8FE20000, 0x1C650000, 0x50A28000, 0x88C4C000, 0x4F536000, 0x01ED3000, 0x757E8800, 0x3A735400, 0x18DC3600, 0x3A372B00, 0xFBCFE980, 0x86FA72C0, 0x3B81A820, 0x25C084F0, 0x07E099E8, 0xAD50F134, 0x8BD92822, 0x6B8544F1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x98000000, 0x54000000, 0xF6000000, 0xED000000, 0x95800000, 0x5BC00000, 0xA7A00000, 0x5A900000, 0x5C280000, 0x86D40000, 0x56560000, 0x78550000, 0x1D168000, 0x6DB4C000, 0xD1E62000, 0x1BADF000, 0x8B0A8800, 0x42461C00, 0xA73C5200, 0x4222B700, 0x5513A580, 0xC4AB9840, 0x24D600A0, 0x71157810, 0x43F7E908, 0x41C452BC, 0x3DBE80A2, 0x4B20B811 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0xF8000000, 0xD4000000, 0xFA000000, 0x21000000, 0x80800000, 0xB3C00000, 0xA2200000, 0x37F00000, 0x9F380000, 0x9FF40000, 0x602A0000, 0x90750000, 0x486B8000, 0xC014C000, 0x9EFB6000, 0x813D3000, 0xDFE6C800, 0x2C2AC400, 0x0E758A00, 0x8B6B4500, 0xC594AD80, 0xAFBB2140, 0x65DDD260, 0x30B64730, 0x1622B188, 0x2C183164, 0xF0845262, 0x08D38733 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xF8000000, 0xEC000000, 0x92000000, 0xD3000000, 0x30800000, 0x34400000, 0xA1200000, 0xFC100000, 0xBFF80000, 0xDF0C0000, 0x3E7A0000, 0xDB4D0000, 0xD75B8000, 0x435D4000, 0xBEA32000, 0xC950B000, 0x1D58F800, 0x57DC9400, 0xBCE2DE00, 0x4D71B500, 0xD4C99680, 0xB9E44740, 0x6B0E96A0, 0x6BFAACB0, 0x3A8D76B8, 0x57BAA544, 0x1FADB6A2, 0x0DAA1CB3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0xF8000000, 0x14000000, 0x96000000, 0x69000000, 0xC2800000, 0xF6400000, 0x01200000, 0xFC100000, 0x25080000, 0x7A340000, 0x95160000, 0x9A750000, 0xBD368000, 0x04E44000, 0x1E7E6000, 0x87F1B000, 0x63784800, 0xAE8D9C00, 0xCD7A1A00, 0xFDFE5900, 0xBF309680, 0xC6196B40, 0x24BD66A0, 0x53E2DD50, 0x140238C8, 0x5873E67C, 0x9FCB06A2, 0xEE276D51 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x58000000, 0x9C000000, 0x92000000, 0xFD000000, 0x89800000, 0xCB400000, 0x03200000, 0xD7100000, 0x4DE80000, 0x5BC40000, 0x1D360000, 0xE2850000, 0x73168000, 0x34154000, 0xC1BF6000, 0x3AF1F000, 0xF8985800, 0x731DD400, 0x6F8B2200, 0x1BDF8700, 0x53C0D480, 0xCBE0F140, 0x5E7062A0, 0x7258DE90, 0xAF7D0728, 0x1DBABBFC, 0x2A2702A2, 0x3F6D2E91 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xF8000000, 0x4C000000, 0xEE000000, 0x05000000, 0x36800000, 0x63400000, 0xA6200000, 0xD1300000, 0xB9A80000, 0xC2840000, 0x13CA0000, 0x43C50000, 0x7EEB8000, 0x5174C000, 0x7A83A000, 0xE2913000, 0xBC593800, 0x22CDEC00, 0x8A1EB200, 0xF7374100, 0x65F2D480, 0x5F99BD40, 0x9EAD0EE0, 0x2D8E4210, 0x5DEEA9E8, 0xD47E2C84, 0x9BA6AEE2, 0x0CAB7213 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x28000000, 0xEC000000, 0x7A000000, 0xAF000000, 0xD9800000, 0xF6400000, 0x08200000, 0xEC500000, 0xA9880000, 0xEB840000, 0x7FD20000, 0x7BC50000, 0xFAF28000, 0x15154000, 0xD2BAA000, 0x11F11000, 0xA9997800, 0xD52CE400, 0x9986A600, 0x9FDE1700, 0xF492EA80, 0xA9649740, 0x63638A20, 0xFDFDC050, 0x2CCECB28, 0x31BB80F4, 0xE2712A22, 0xF8D8D051 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xF8000000, 0x34000000, 0x6A000000, 0x57000000, 0x22800000, 0x4C400000, 0xB5E00000, 0x11100000, 0x44A80000, 0x42D40000, 0xBECE0000, 0x51950000, 0x25AF8000, 0xF2C44000, 0x99E76000, 0x2C81B000, 0x39410800, 0xAC606400, 0x51D02600, 0x78096100, 0xA7A45E80, 0xEFB7FAC0, 0xF94914A0, 0x5FC42790, 0x04677F08, 0x5E417F0C, 0x16E074A2, 0xF9909793 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x68000000, 0x34000000, 0xB6000000, 0xAB000000, 0x23800000, 0x91C00000, 0x01E00000, 0xE0F00000, 0xD4880000, 0x9CE40000, 0xCBE20000, 0xE2250000, 0xF7838000, 0x6C15C000, 0x476A6000, 0x42C11000, 0x4E600800, 0xFB317C00, 0x0C68DE00, 0x2A95FB00, 0x322A1D80, 0x7B6028C0, 0xE7B03460, 0x98292DD0, 0x89B43BA8, 0xACBAED14, 0x5CD85462, 0xB33D3DD3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x28000000, 0x34000000, 0xB6000000, 0xE1000000, 0x1F800000, 0x11400000, 0xE0600000, 0x15500000, 0x0E680000, 0x4E5C0000, 0x49FE0000, 0xE81D0000, 0xC71F8000, 0xBB8DC000, 0x5C572000, 0x9EE19000, 0xDB914800, 0x9F49FC00, 0xEB6D0A00, 0x7AC70300, 0x9C288880, 0x76BD13C0, 0xFB6F0A20, 0x6CD44310, 0xF3334498, 0xDC2AE7EC, 0x48AE2A22, 0xA074D313 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0xA8000000, 0xDC000000, 0xDA000000, 0x27000000, 0xE5800000, 0xE7400000, 0x1CA00000, 0xB2700000, 0xB5780000, 0x21140000, 0xF7F60000, 0xEB550000, 0x41D78000, 0x67E4C000, 0x854F2000, 0x67219000, 0x4C309800, 0x25592400, 0xE0A55600, 0x09EF2F00, 0x9D513880, 0x7549C640, 0x764D2460, 0xEC5238B0, 0xDD3AB848, 0x1CC7845C, 0xEB8C0462, 0xA632A8B3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x08000000, 0x14000000, 0x22000000, 0xB1000000, 0xC8800000, 0xB5C00000, 0xC2600000, 0xC1900000, 0x26D80000, 0x5CB40000, 0x71E60000, 0xD2750000, 0xCE068000, 0x14A5C000, 0x027EE000, 0xBD61D000, 0xA610C800, 0x8C989400, 0x48952A00, 0xA257C500, 0xBC1D2180, 0x915AD1C0, 0x655E4AA0, 0x6751B870, 0xDD3801C8, 0x8065A2BC, 0x109EAAA2, 0x85316871 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x98000000, 0x4C000000, 0x4A000000, 0x57000000, 0x34800000, 0x12400000, 0x18A00000, 0xFE300000, 0xC2E80000, 0xA4E40000, 0x47EE0000, 0xC3A50000, 0x48CE8000, 0xCD54C000, 0x35C6E000, 0x38A1F000, 0x6E307800, 0x8AE86400, 0x40E45600, 0xD9EFCD00, 0x92A51280, 0x614E4C40, 0xBC95B6E0, 0x0BA73D90, 0xCC716128, 0x4A49434C, 0x12D556E2, 0x6107CD91 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x08000000, 0xDC000000, 0xEE000000, 0x73000000, 0xDC800000, 0x00C00000, 0x7D600000, 0x65F00000, 0x06280000, 0xCA040000, 0xC6520000, 0x9BC50000, 0x42B28000, 0xE575C000, 0x27BB6000, 0xA221D000, 0x8CD0D800, 0xA2790C00, 0xCABCBE00, 0x148E7500, 0x913A5F80, 0x3BE11FC0, 0xF4306C60, 0xA2C86F90, 0x24B4AE68, 0x5B5AD234, 0x08910C62, 0xDBD8BF91 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0xF8000000, 0x04000000, 0xEE000000, 0x31000000, 0xE9800000, 0xA1C00000, 0x55A00000, 0xAD300000, 0x73480000, 0xACA40000, 0xD1460000, 0x44E50000, 0xB5278000, 0x1474C000, 0x275EE000, 0xD9993000, 0x81BCE800, 0x7ABBEC00, 0x093E0A00, 0xC6097F00, 0x63456980, 0xB3160440, 0x49BDEBE0, 0x46BBE6D0, 0x033E54A8, 0xA909B15C, 0x43C48BE2, 0xFF5616D3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xB0000000, 0x98000000, 0x4C000000, 0x2A000000, 0x49000000, 0xE5800000, 0xE9C00000, 0x4CE00000, 0x17300000, 0x22580000, 0xE11C0000, 0x510E0000, 0x9D5D0000, 0x0C2E8000, 0x1A8D4000, 0x3B47E000, 0x44C87000, 0x08D57800, 0x025B2400, 0x79C66A00, 0x0F892F00, 0xDF751980, 0xCACA26C0, 0xF70E3FE0, 0x9E5D3E70, 0x30AE33D8, 0x3ECC996C, 0x4A675FE2, 0x79180E71 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x78000000, 0x0C000000, 0xD6000000, 0xB3000000, 0x81800000, 0xA9400000, 0x89A00000, 0x13B00000, 0xEFC80000, 0xE4BC0000, 0x57D20000, 0x3C7D0000, 0x1F338000, 0x726C4000, 0xE94A2000, 0x6418B000, 0x64A43800, 0xF1761C00, 0xD40BDE00, 0x87B8DF00, 0x1A14EC80, 0x883F5C40, 0xBA7643E0, 0x998BA7D0, 0x58F8C898, 0xF0B5C974, 0x620FE3E2, 0xF0FF57D3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x78000000, 0x54000000, 0xBA000000, 0x19000000, 0xAE800000, 0x05C00000, 0x87E00000, 0x01B00000, 0xB1D80000, 0xCB140000, 0xE4EA0000, 0x08550000, 0x0ACA8000, 0x8004C000, 0x89A3A000, 0x35483000, 0x591D0800, 0xE1D64400, 0xC4D2BA00, 0x75F15900, 0xB279D180, 0x6105C6C0, 0x3323EAE0, 0x6A886970, 0x57FCC2C8, 0x36E723A4, 0x24CACAE2, 0x83049971 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x38000000, 0xAC000000, 0x02000000, 0xC3000000, 0x22800000, 0xBC400000, 0xA4600000, 0xA4500000, 0x65D80000, 0x576C0000, 0x97DE0000, 0x25AD0000, 0x2DFF8000, 0xD69DC000, 0xA6F72000, 0xCC69B000, 0x6C247800, 0x1B4AB400, 0xE02F7E00, 0x2984B100, 0x1FBAE680, 0x668669C0, 0x5381E620, 0xF5C1AE70, 0xCEA1A2F8, 0x4271FECC, 0x9CE94622, 0xDB65DE73 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xF8000000, 0x24000000, 0x96000000, 0xD9000000, 0x6C800000, 0x31400000, 0xF0A00000, 0x7F100000, 0x70080000, 0xEDCC0000, 0x9E360000, 0x060D0000, 0x16D78000, 0xBD3C4000, 0x5C8F2000, 0xBE59B000, 0xAD656800, 0xACEB9C00, 0xB8325A00, 0x05168500, 0x11DC5880, 0x71BE7440, 0x2D003EA0, 0xC2814050, 0x6C409338, 0x5A204B3C, 0x6F509EA2, 0xC828B053 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x88000000, 0x7C000000, 0x06000000, 0xD1000000, 0x9D800000, 0x0C400000, 0x76A00000, 0x8DB00000, 0x90180000, 0x445C0000, 0x805E0000, 0xDF9D0000, 0x45BE8000, 0x040C4000, 0xF7D7E000, 0x8FA95000, 0x2F451800, 0x16825C00, 0x5B033A00, 0x8F43A700, 0x1DE38280, 0xD2527A40, 0x614A11E0, 0x1396BE70, 0xD509CF58, 0x3CF42BCC, 0x139B71E2, 0x70DFAE71 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x88000000, 0x8C000000, 0x1A000000, 0x73000000, 0x3B800000, 0x8A400000, 0xBEE00000, 0xB2900000, 0x70780000, 0x061C0000, 0xC41A0000, 0x69DD0000, 0xB5BA8000, 0x472CC000, 0xAD93A000, 0x3A69D000, 0x7FA4B800, 0x82A6E400, 0x2FB7DE00, 0x738ED300, 0x5A72AA80, 0xF0785EC0, 0x461DE7A0, 0x241B0230, 0xF9DC6198, 0x3DBA4F04, 0xCB2CC7A2, 0xB7921231 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xF0000000, 0x68000000, 0xEC000000, 0x22000000, 0xB1000000, 0x96800000, 0xB3C00000, 0x71A00000, 0x67F00000, 0x9D480000, 0x11A40000, 0x04220000, 0x65E50000, 0x60C38000, 0xC875C000, 0xF7DA6000, 0x69691000, 0x2215B800, 0xAD8A5400, 0x21D05A00, 0x87F83900, 0xAA8D1D80, 0x3DD66A40, 0x607F1A60, 0x424BACD0, 0xBA718F28, 0x2D081394, 0x1B44FA62, 0xAAB27CD3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x50000000, 0x78000000, 0x34000000, 0xC6000000, 0x9D000000, 0xBD800000, 0xF3C00000, 0x7F600000, 0x8CB00000, 0x76F80000, 0xA5F40000, 0x02BE0000, 0x06B50000, 0xBB9E8000, 0xFAA4C000, 0xE4B62000, 0xB2183000, 0xE7844800, 0x06A6BC00, 0xF430F200, 0xFCB88700, 0x27557580, 0x706EA9C0, 0xCB7C34E0, 0xF4538030, 0xC40EF908, 0xBF4C0C4C, 0x48EA94E2, 0x035A7031 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x28000000, 0xE4000000, 0x0A000000, 0x1F000000, 0xB4800000, 0xF5400000, 0x6E600000, 0xE8B00000, 0x46980000, 0x507C0000, 0x5C0E0000, 0x06BD0000, 0xE7AF8000, 0xE72DC000, 0x24E62000, 0x6BF99000, 0x6A4DE800, 0xAED68400, 0x61215600, 0xC1D0AD00, 0x66A8DC80, 0xF5A401C0, 0xBB1255E0, 0xF783F0F0, 0xF34A0F18, 0x605E97EC, 0x58D5F5E2, 0x7CAAA0F3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x08000000, 0xAC000000, 0xFA000000, 0x13000000, 0x26800000, 0x7F400000, 0xE3200000, 0xED300000, 0x3A380000, 0x83440000, 0xD4EA0000, 0xE5850000, 0xD40A8000, 0xA7D54000, 0x16A32000, 0x84D95000, 0x34147800, 0x21C3A400, 0xF849DE00, 0x125D2900, 0x369FC080, 0x2156DF40, 0xA9CA92E0, 0x2DB56730, 0xD1B2B668, 0xB650CDE4, 0xDCA932E2, 0x460C7731 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x98000000, 0xA4000000, 0x2A000000, 0x97000000, 0x2C800000, 0x2F400000, 0x60200000, 0x79100000, 0x8C880000, 0xD49C0000, 0xC0E60000, 0xBC5D0000, 0xCD068000, 0xE72C4000, 0x0B3E6000, 0xF9E97000, 0x52AD2800, 0xF5FE2400, 0xAD098600, 0x385DBD00, 0xD7077880, 0x482D2D40, 0xF3BE32A0, 0x64A88850, 0x018D3198, 0x8A6F069C, 0x99C0D2A2, 0xA060B851 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xA8000000, 0x24000000, 0x02000000, 0xC3000000, 0x0F800000, 0xE2C00000, 0xD6E00000, 0x60D00000, 0x19480000, 0xD4F40000, 0x81AA0000, 0x78B50000, 0x390A8000, 0x03C54000, 0xE4B3A000, 0xD0481000, 0xEC75E800, 0xE6EB1400, 0x3B95EE00, 0x2ABBCB00, 0x7F9D4B80, 0xF26E16C0, 0xC4069220, 0xD5436850, 0xF1B039C8, 0x4F58B204, 0x015DB222, 0xEA8F3851 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xA8000000, 0xF4000000, 0xCE000000, 0xDB000000, 0x9B800000, 0xD4400000, 0x41600000, 0x01500000, 0x8DA80000, 0x637C0000, 0x1EBE0000, 0xA9BD0000, 0x131E8000, 0xDA4D4000, 0x00C6E000, 0xC9A81000, 0x457D0800, 0x11BE8C00, 0xCC3D3E00, 0xB45F7B00, 0xF4ACB680, 0x1BD6C9C0, 0xDE600C20, 0xBCD1A690, 0x56E9E0D8, 0x479D9AEC, 0xB8AE6C22, 0x0AF5F691 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x38000000, 0x84000000, 0x9A000000, 0x13000000, 0xF4800000, 0xE9400000, 0xD8200000, 0x71500000, 0xD2A80000, 0xA7340000, 0x000E0000, 0x6BF50000, 0x82EE8000, 0x9D44C000, 0x1777A000, 0x1728B000, 0x6DF4A800, 0xBFEE8400, 0xA8C50E00, 0x35B62D00, 0xF4C83C80, 0x20C4CD40, 0xB9B6A620, 0xA2C8D410, 0x85C5BA48, 0x7836FB0C, 0xB2098622, 0xC925A411 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xB8000000, 0xD4000000, 0x56000000, 0x3F000000, 0xE2800000, 0x34400000, 0xA4200000, 0xB1F00000, 0x52880000, 0xD75C0000, 0x750E0000, 0xB37D0000, 0xA4FE8000, 0x91F54000, 0x9BA22000, 0x88FA3000, 0xAADE8800, 0x45041C00, 0xE6ABB600, 0x0867F900, 0xFE31EE80, 0xB7683940, 0x584C9160, 0xD4172A50, 0xF278C6D8, 0xEC552ECC, 0x52921962, 0x81133651 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x78000000, 0xB4000000, 0xA6000000, 0xF1000000, 0xFE800000, 0xA4C00000, 0x1AA00000, 0x0DD00000, 0xA2A80000, 0x5E0C0000, 0x94020000, 0x24AD0000, 0x29D38000, 0x1E04C000, 0xB3DF6000, 0x54063000, 0xD2730800, 0x2554FC00, 0x99B62A00, 0x72AA6100, 0x64A15380, 0x18D15C40, 0x1229B420, 0xB7CC3310, 0x1A226938, 0x6EBDC894, 0x385ABC22, 0xE698CF13 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xC8000000, 0xAC000000, 0x4A000000, 0x09000000, 0x5F800000, 0x7E400000, 0x5FA00000, 0x12700000, 0x1DC80000, 0x10540000, 0x57860000, 0x5FF50000, 0xCDF68000, 0x4E3C4000, 0x07A3A000, 0xD8BBD000, 0xABD7F800, 0x210DC400, 0xB34BAA00, 0x6B5EDB00, 0x08788680, 0x8F7D9C40, 0x6C836660, 0x7E0B0DD0, 0xDA7F1DC8, 0x6FC9645C, 0x0D549E62, 0x1606C9D1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x28000000, 0xC4000000, 0x5A000000, 0xB1000000, 0xBD800000, 0xADC00000, 0x2C600000, 0x6AF00000, 0xF2180000, 0x07C40000, 0x3B5A0000, 0x19A50000, 0x04AB8000, 0x5C3CC000, 0x87AEE000, 0x1A869000, 0xC73A6800, 0x2B55A400, 0xFAB3CA00, 0x75F83F00, 0x7FF50180, 0xCBA38FC0, 0x89D1B060, 0x47C8C1F0, 0x860DD0E8, 0x5A563EC4, 0x6173D862, 0xB69965F3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0xB8000000, 0xBC000000, 0xCA000000, 0x91000000, 0x96800000, 0x33C00000, 0x18600000, 0x8B100000, 0xFCE80000, 0xEFC40000, 0x6E220000, 0xD5A50000, 0x30328000, 0x69CC4000, 0x67372000, 0xA00F3000, 0x20C35800, 0x8D742400, 0xA4BA3A00, 0x65182900, 0xF1FC6D80, 0xEC6FC1C0, 0x25D21FA0, 0x369CA210, 0x56FE1928, 0x877A2BD4, 0x257947A2, 0xB6EC8611 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x48000000, 0x24000000, 0x6E000000, 0xDF000000, 0xAB800000, 0xE6400000, 0xE4200000, 0xCD100000, 0x52180000, 0x0D5C0000, 0xD8060000, 0xB67D0000, 0x7E978000, 0xE224C000, 0x47EA2000, 0xBF325000, 0x878F6800, 0xA2F90C00, 0x62AC1600, 0xF8EF7B00, 0x45480A80, 0x79651B40, 0x6D4ABCA0, 0xF6E3F970, 0x1F76B518, 0xC9554FFC, 0xB2C3D4A2, 0x2267F573 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x10000000, 0xA8000000, 0x04000000, 0x86000000, 0x95000000, 0xD8800000, 0x1BC00000, 0x48200000, 0xE5B00000, 0x0F780000, 0x8D4C0000, 0xB87A0000, 0x806D0000, 0x8D4A8000, 0x60D4C000, 0x7626A000, 0x041F9000, 0xA3B3A800, 0x0CD81C00, 0x7EBC4200, 0xDC620D00, 0xAB716580, 0x3FD9F540, 0x833C12E0, 0x472339B0, 0x44902D78, 0xB848F0C4, 0x7EF5BAE2, 0x0E9625B1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0x48000000, 0x9C000000, 0x4A000000, 0x49000000, 0x3A800000, 0x8BC00000, 0x8D600000, 0x9CF00000, 0xED780000, 0x83240000, 0xC1560000, 0x5F450000, 0x73278000, 0xCFFD4000, 0xAE622000, 0xA9DBD000, 0x311E1800, 0x1578C400, 0x6725CA00, 0xAF579100, 0x58448D80, 0x9EA7D3C0, 0xE1BC5060, 0x91429330, 0x400A1F28, 0x7CB6381C, 0xE1744862, 0xD9BF5733 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x58000000, 0x3C000000, 0xAA000000, 0xE5000000, 0x03800000, 0x05400000, 0xCE200000, 0x2E300000, 0x0BB80000, 0xDA9C0000, 0xD35A0000, 0x2DBD0000, 0xE4EB8000, 0xFE45C000, 0xBFD76000, 0xF46F7000, 0x8EF21800, 0x4DA9A400, 0x48141200, 0xC8FFC300, 0xA0BAE880, 0x506C8740, 0x4283F0E0, 0xCAB03230, 0x4C79FED8, 0xE47C2804, 0x090BE8E2, 0x78949633 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x78000000, 0xA4000000, 0x62000000, 0x75000000, 0x56800000, 0xCE400000, 0xA7E00000, 0x17900000, 0x37E80000, 0xC39C0000, 0xEF960000, 0x857D0000, 0x04868000, 0x25D44000, 0xD87A2000, 0xD892B000, 0x288E6800, 0x87D8F400, 0x9F04C200, 0x31F37900, 0xE55F6E80, 0xFDD11EC0, 0xB20915A0, 0x010C4310, 0xDEFE2398, 0xF0A176BC, 0xE8F17DA2, 0xD539B711 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x48000000, 0x2C000000, 0xC2000000, 0x63000000, 0xAD800000, 0xB6400000, 0x01200000, 0x6A700000, 0x24C80000, 0x51140000, 0x46CA0000, 0xD7350000, 0x2F3A8000, 0x04BCC000, 0x418F6000, 0x7BC65000, 0x29123800, 0xACB95400, 0x46DC3E00, 0xE25E6F00, 0xB3BF8280, 0x5F2F9540, 0xCCF6E260, 0x6D7BF2D0, 0x139DB748, 0x0EFE99C4, 0x8F8EDA62, 0x8AC7A6D1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x78000000, 0x64000000, 0xC6000000, 0x3F000000, 0x2C800000, 0xA8C00000, 0x46200000, 0x0D700000, 0xFD780000, 0x3DCC0000, 0xC0760000, 0xC8ED0000, 0xCB868000, 0xD8544000, 0xB1EBE000, 0x1012B000, 0x1D1E2800, 0xEF49BC00, 0x24D41600, 0x312B0500, 0x5A337780, 0x7A6EE140, 0xF730B160, 0xA8987DB0, 0x8C1DC7F8, 0x6FBEA6DC, 0x7EF89962, 0x318CC1B1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x38000000, 0xD4000000, 0xC6000000, 0xC1000000, 0x74800000, 0xB6C00000, 0x5BA00000, 0x75B00000, 0xF3380000, 0xE1340000, 0x6D660000, 0x7D950000, 0xCD568000, 0x7CED4000, 0xE902A000, 0xD39B3000, 0x001E0800, 0x0BC03C00, 0x4520CA00, 0x30717500, 0xCB191780, 0xAFC40A40, 0xD3BE20E0, 0xC270B630, 0xBC19AF88, 0x12444F7C, 0xEDFE28E2, 0x05118A31 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xF8000000, 0x5C000000, 0x5A000000, 0x99000000, 0xA8800000, 0x49400000, 0x37600000, 0x8FD00000, 0xA0780000, 0x747C0000, 0x66860000, 0x481D0000, 0x1CD78000, 0xDFA44000, 0x5D8B6000, 0x9413B000, 0xDDFED800, 0xE1E08400, 0x9991AA00, 0x5C99B500, 0xF36C0880, 0xE85EC3C0, 0x9191B320, 0x38987930, 0x556C46D8, 0x5B5EC0BC, 0x58116B22, 0x8559FD33 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xB8000000, 0xD4000000, 0x2E000000, 0xA5000000, 0x1A800000, 0xDAC00000, 0xC0E00000, 0x40B00000, 0x84B80000, 0x4FB40000, 0xDE3A0000, 0x40550000, 0x470B8000, 0xEDAD4000, 0xC21FE000, 0x5A063000, 0xED234800, 0x78F1EC00, 0xAA994200, 0xF1E53900, 0x37324780, 0xFDD830C0, 0xF6440AE0, 0x3823EBB0, 0x3A71B488, 0xB4584444, 0x970542E2, 0xBE8307B3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x68000000, 0xA4000000, 0x9A000000, 0x5D000000, 0x66800000, 0xB9C00000, 0x89A00000, 0x58500000, 0x4A180000, 0x703C0000, 0x60620000, 0x1F1D0000, 0xC1F28000, 0xFCA54000, 0x199F6000, 0xBEDF9000, 0xD2BF2800, 0x854E2400, 0x6C07D200, 0x3BA30900, 0x97BC7180, 0x79225240, 0xF47D7520, 0x8D823C70, 0x3AACB858, 0x165B5F34, 0x6730DD22, 0xB4695871 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0x88000000, 0xFC000000, 0x32000000, 0x65000000, 0x49800000, 0x25400000, 0x96E00000, 0xDC500000, 0x53280000, 0x950C0000, 0x57120000, 0x766D0000, 0xBC028000, 0x46A5C000, 0xC4DF6000, 0x13DED000, 0x7F5F9800, 0x739E3400, 0x303F9200, 0xF28F4700, 0x81F6C880, 0x75D392C0, 0xD2CD1420, 0xBA32FE90, 0x551C2D38, 0x395ADA34, 0x67700C22, 0xE3590A91 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x88000000, 0x14000000, 0x06000000, 0x23000000, 0xC2800000, 0xE3400000, 0x7F200000, 0xAF300000, 0xA3D80000, 0xCB840000, 0x45260000, 0xC2250000, 0x5F578000, 0x95DD4000, 0x7D62A000, 0x1E625000, 0x3CE38800, 0x6FA3DC00, 0x08838E00, 0x3BB37900, 0x8A6B5880, 0x64EFAF40, 0xC0480AE0, 0x23ADAEF0, 0xE09A98E8, 0xA556223C, 0xD4DC02E2, 0xA2E332F3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x98000000, 0x6C000000, 0x8A000000, 0x5B000000, 0x23800000, 0x88C00000, 0xB1A00000, 0x33F00000, 0xD9C80000, 0x56340000, 0xDC920000, 0xD8150000, 0x35A28000, 0x677CC000, 0x09E76000, 0x29E7F000, 0x79E6B800, 0xF1E66400, 0xF5E7CE00, 0x8BE7C300, 0x36E7EF80, 0xC4667840, 0x34269C60, 0x2EC77DD0, 0x24567708, 0x7FCFD574, 0xC3C2A462, 0x90ADD9D1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x88000000, 0xB4000000, 0x6E000000, 0x3F000000, 0x83800000, 0xCCC00000, 0x97600000, 0xAB300000, 0x14780000, 0xCF540000, 0xAE120000, 0x25B50000, 0x6EE28000, 0x492DC000, 0xA446E000, 0x0926D000, 0x83168800, 0xC3EE8C00, 0xC7FA3600, 0xD449EB00, 0x46ADBF80, 0x7A862DC0, 0x1B4775E0, 0xCAA75B30, 0x2FD6DC48, 0x648F4694, 0xE4CB7DE2, 0x74301731 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xB8000000, 0x34000000, 0xA2000000, 0xFB000000, 0x29800000, 0x89C00000, 0x3D600000, 0x40500000, 0x6F480000, 0x05940000, 0xB6C20000, 0xAA750000, 0xB6D38000, 0x019D4000, 0x26772000, 0x14463000, 0x70DE4800, 0x48C2F400, 0xBF75FE00, 0xD2530700, 0xA8DC1D80, 0xF85755C0, 0xFD377920, 0x49660D50, 0xA42EC908, 0x0ABB7754, 0x2DF8B122, 0x3A4CB953 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xD0000000, 0xC8000000, 0x6C000000, 0xBA000000, 0x8F000000, 0xCB800000, 0x64C00000, 0xAE600000, 0x6C500000, 0x63980000, 0x1DF40000, 0xF5BA0000, 0xFB150000, 0xBCAB8000, 0xE52D4000, 0xDCEE2000, 0x659ED000, 0xAEF7F800, 0xA3AA2400, 0x06ACA600, 0x242F1300, 0x69FE7F80, 0xE9A7D7C0, 0xDDB3F320, 0x4A99DEF0, 0x3B7427C8, 0x51FA9804, 0xFC358B22, 0xE75BBAF3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x18000000, 0x54000000, 0xAA000000, 0x71000000, 0xF1800000, 0x73400000, 0xA7E00000, 0x23100000, 0x41080000, 0xA9A40000, 0xBD7A0000, 0x92C50000, 0xBAAA8000, 0x686CC000, 0x6D7F2000, 0x5CCEF000, 0x66368800, 0xAF0B2400, 0x951DAA00, 0xD0266700, 0x3D83FC80, 0x92F940C0, 0x153CCEA0, 0x3C1750D0, 0x1A3B36E8, 0xDF2448A4, 0x08BAC6A2, 0x08E5B4D1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0x2C000000, 0x6A000000, 0x87000000, 0x0C800000, 0x28C00000, 0xD8200000, 0x26900000, 0x2FE80000, 0xAA040000, 0x7D520000, 0x23A50000, 0xF0828000, 0xA42D4000, 0xDAF6A000, 0xBD27F000, 0xFDAFF800, 0xFB5BA400, 0xDA90B600, 0x7DE89D00, 0x3105D780, 0x53D3B540, 0xF8642EA0, 0x6222F490, 0x477DCBA8, 0xA6BEF3B4, 0x15F356A2, 0x5FF51091 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x18000000, 0xC4000000, 0xFA000000, 0x8B000000, 0x26800000, 0xDEC00000, 0x65E00000, 0xD6700000, 0x98580000, 0xC3840000, 0x23E60000, 0xA5E50000, 0x24D68000, 0x4F1C4000, 0x4682A000, 0x0AF27000, 0xE9AA2800, 0xA4AF0400, 0x95887E00, 0x738C6900, 0x342A7380, 0xB4EFEAC0, 0x42A8CB60, 0xF61D1C70, 0xD7025968, 0x7CB24A3C, 0x2B8A6362, 0x66BF5871 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xD8000000, 0xFC000000, 0xDE000000, 0x6D000000, 0xD2800000, 0x6A400000, 0x2B200000, 0x64D00000, 0xAA380000, 0x15340000, 0xFD3A0000, 0xFB950000, 0x2E2A8000, 0x514D4000, 0xB12EA000, 0x297EF000, 0x2C065800, 0xD493CC00, 0xCD38C200, 0x20B54900, 0xE2FA2680, 0xEF752740, 0x4E1BB320, 0x43457930, 0x4A125448, 0xF179A3C4, 0x62956B22, 0x66AAF531 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x88000000, 0x14000000, 0x4A000000, 0xAB000000, 0x81800000, 0x46400000, 0x7D600000, 0xB5500000, 0x65480000, 0xF3140000, 0xA74E0000, 0x00350000, 0x1B7F8000, 0x0A2C4000, 0x9E23E000, 0x43F75000, 0x2118C800, 0xC4DD4400, 0xAF9A5E00, 0xF25BE700, 0xBA7A6280, 0xFFCA85C0, 0x8F938420, 0x19AED550, 0x8C259B08, 0x68D6FE4C, 0x9128AC22, 0x28C4C153 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x78000000, 0xDC000000, 0x96000000, 0xC7000000, 0xF6800000, 0x35C00000, 0xCB200000, 0x92900000, 0xF6080000, 0x24540000, 0x55F60000, 0xD6B50000, 0xB2468000, 0xC12C4000, 0x149BE000, 0x704EB000, 0x27795800, 0x146C1C00, 0x6D7A1600, 0x7F7E5100, 0xC6212D80, 0x75112F40, 0x5249CCA0, 0x9C358950, 0x4187A308, 0xA50D2E3C, 0x648B74A2, 0x81872551 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xA8000000, 0x84000000, 0x2E000000, 0x05000000, 0xF7800000, 0xEB400000, 0x94200000, 0x1DB00000, 0xB5380000, 0xECE40000, 0x536A0000, 0x1F850000, 0x40FB8000, 0xC40CC000, 0xD7A7A000, 0x65439000, 0x4B29A800, 0x6F2D4C00, 0x7E96E200, 0xADBBC300, 0x112D0480, 0xF397D340, 0x2E3B5BE0, 0x6C6C5730, 0x4EB7C328, 0x6E0A8664, 0x191553E2, 0xC4F28B33 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xF8000000, 0x94000000, 0x4A000000, 0x1D000000, 0x6C800000, 0x61400000, 0x25200000, 0xC1900000, 0xE4B80000, 0x28A40000, 0x77960000, 0x5EC50000, 0x5A268000, 0xFD6C4000, 0x7A7BA000, 0x13FFB000, 0x67F98800, 0x9C84A400, 0x34877200, 0xE43D9D00, 0x4A22A080, 0x98AB6F40, 0xD3674FA0, 0xF44C5030, 0xC5EA01E8, 0x3047AA9C, 0xC6DD67A2, 0x72D34431 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x38000000, 0xB4000000, 0xDE000000, 0xA7000000, 0x94800000, 0x44C00000, 0xD0A00000, 0x9B900000, 0x2F380000, 0xF6240000, 0x0A120000, 0x88450000, 0xF8238000, 0xEF6CC000, 0xA17F2000, 0xBF3AB000, 0xDC194800, 0xA5F58C00, 0xB54B4600, 0x83514500, 0x6D995F80, 0x40B59C40, 0x98ABECA0, 0x3120E830, 0x46D193E8, 0xB6D91E94, 0x9A5584A2, 0x865BD433 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x18000000, 0xB4000000, 0x26000000, 0x0B000000, 0x5E800000, 0x31C00000, 0x99600000, 0xA5700000, 0x3B480000, 0x8DD40000, 0x864A0000, 0xEF750000, 0xC35B8000, 0x52CD4000, 0x79876000, 0x03737000, 0x8F690800, 0x0505BC00, 0x5893DE00, 0x71D92100, 0x6E2CAD80, 0x6BB6EBC0, 0x049A9360, 0x68AD5F50, 0x0E7627C8, 0xEBFBC744, 0xAEDCFB62, 0xC7BF9353 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x78000000, 0x9C000000, 0x26000000, 0xB3000000, 0x49800000, 0x55400000, 0x23600000, 0xBD500000, 0xED780000, 0x8BA40000, 0x92920000, 0xB6850000, 0x99228000, 0xB5ED4000, 0xBF9F2000, 0x200BB000, 0xBFB11800, 0x81687C00, 0x0FBDBE00, 0x99678F00, 0xD7EF0480, 0x02C221C0, 0x5D7D3A20, 0xD8470930, 0x4A5E4468, 0x3AABFB94, 0x06410222, 0xDAE1C531 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x18000000, 0x2C000000, 0x52000000, 0xFF000000, 0xB6800000, 0xD0C00000, 0x73200000, 0x18500000, 0x1CB80000, 0xEDDC0000, 0x719A0000, 0x793D0000, 0x386B8000, 0x2315C000, 0x9F2EA000, 0xDA83F000, 0x9371F800, 0x78E9D400, 0xDB644600, 0xDF46D900, 0xF4273780, 0x4297F740, 0x8CDE8B20, 0x8BAB2C30, 0x9CB47798, 0x6CBF9584, 0xF59BD322, 0x2F3C0833 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x28000000, 0x94000000, 0x3A000000, 0xCB000000, 0x9C800000, 0x43C00000, 0x96E00000, 0x1E700000, 0x73F80000, 0x3B8C0000, 0xD10A0000, 0xDDAD0000, 0x091A8000, 0x15E5C000, 0x828EE000, 0xA4939000, 0x7D90C800, 0x38086400, 0xB0341E00, 0x15277D00, 0x8AF76980, 0xD65EC8C0, 0x64BA1960, 0x8CB44530, 0x46E78578, 0x641637A4, 0x442E3162, 0x9142B131 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x90000000, 0x98000000, 0xD4000000, 0x62000000, 0x8B000000, 0xAF800000, 0x86400000, 0xD2200000, 0x63B00000, 0xA8B80000, 0xD83C0000, 0xE01A0000, 0xC55D0000, 0xC50B8000, 0xCF94C000, 0x3DEEA000, 0x6823F000, 0xEEA00800, 0x5E71B400, 0x7ED85E00, 0x72AD8B00, 0x1C928280, 0xE7989740, 0x4D0D99E0, 0x02637C30, 0x3A810498, 0x3CC08984, 0x2EE131E2, 0xAD503833 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x10000000, 0x78000000, 0x8C000000, 0x2A000000, 0x25000000, 0x7B800000, 0xDEC00000, 0xE7E00000, 0x4DB00000, 0x62080000, 0xA2340000, 0xED560000, 0xE0150000, 0x7F878000, 0x45ED4000, 0xC81BA000, 0x7D9FB000, 0x5FC1B800, 0xA2616400, 0x20713200, 0x99687300, 0x9BC41F80, 0x6BFE74C0, 0x39B038E0, 0x040836D0, 0x8D34D588, 0xA3D74CFC, 0x3D5420E2, 0xCAA7E2D3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x50000000, 0x48000000, 0xBC000000, 0xB6000000, 0x19000000, 0xEF800000, 0x54400000, 0x61A00000, 0xDD900000, 0x20A80000, 0x944C0000, 0xB28A0000, 0xCAAD0000, 0x2A3B8000, 0x3754C000, 0x07BF2000, 0xF1625000, 0xFDC15800, 0x14E1BC00, 0x17B02A00, 0xBB788300, 0x8E457280, 0x07D70840, 0x4C4F4DA0, 0xB7BBEF10, 0xA814A438, 0x329FAF84, 0xD43335A2, 0xE0090313 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x98000000, 0x7C000000, 0xA2000000, 0x05000000, 0x3A800000, 0xE6C00000, 0x46A00000, 0x98B00000, 0xE6B80000, 0x1C0C0000, 0x5B4A0000, 0x2EED0000, 0x679A8000, 0x98444000, 0xCA9F6000, 0xE23B7000, 0xA1749800, 0xF767B400, 0x91D75200, 0x606E6100, 0x7BE2CF80, 0x70E86440, 0xC464A2E0, 0x04EE5730, 0x7A22DDF8, 0xA9C93D24, 0x7095DAE2, 0xDA36D331 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x50000000, 0x88000000, 0x3C000000, 0x2A000000, 0xF5000000, 0xF4800000, 0xDE400000, 0xFFE00000, 0xAB100000, 0xE8A80000, 0xE7040000, 0x68B20000, 0x1E250000, 0xE0038000, 0x5B7DC000, 0x423F2000, 0xA322D000, 0xCECC5800, 0x9FE60400, 0x7D5EF200, 0x00728D00, 0x66857E80, 0x8273DAC0, 0x5F8524A0, 0xE4F26590, 0x90C431A8, 0x7193A574, 0x0695DCA2, 0x4D5B7193 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xF0000000, 0x98000000, 0xB4000000, 0x86000000, 0x75000000, 0x95800000, 0x97C00000, 0x77200000, 0x2E700000, 0xD6780000, 0xBD6C0000, 0x345A0000, 0x940D0000, 0x10CA8000, 0x7C254000, 0xC32F6000, 0xCC2A7000, 0x1F750800, 0x3426FC00, 0x1DBF2200, 0x4B037700, 0xA6105D80, 0x31688140, 0xDF840560, 0x291F3BB0, 0xAFB376B8, 0x9EC90B84, 0xF7B4ED62, 0x2186F7B1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x08000000, 0xAC000000, 0x26000000, 0x81000000, 0xAC800000, 0xD7400000, 0x1A200000, 0x95300000, 0xE1280000, 0x6F6C0000, 0x40560000, 0x908D0000, 0x0D068000, 0xA035C000, 0xD232A000, 0xDB87D000, 0x8874F800, 0x21921C00, 0xAF77BA00, 0x0B3CA500, 0x406FA480, 0xC6F99940, 0x59957AE0, 0x41C22510, 0x154F3738, 0x8248063C, 0x8D7DA2E2, 0xDECE2911 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x10000000, 0x08000000, 0x34000000, 0x96000000, 0x63000000, 0xA6800000, 0x27400000, 0x02E00000, 0x4C100000, 0x3A080000, 0xF1DC0000, 0x7D3E0000, 0x58FD0000, 0x158F8000, 0xDF844000, 0x608BA000, 0xE24E5000, 0xE924C800, 0x30FBFC00, 0x9F16CE00, 0x8A10D100, 0x31083080, 0xD35D6CC0, 0xD47F0CA0, 0x051C82D0, 0x5D1EBC18, 0x37CD6F2C, 0x5637E4A2, 0x52A16ED3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x38000000, 0xF4000000, 0xEE000000, 0x59000000, 0xF5800000, 0x64400000, 0x1C600000, 0x6CB00000, 0x76F80000, 0xFA0C0000, 0x16760000, 0x7EAD0000, 0xBF678000, 0xB0C5C000, 0xE942E000, 0xC9F7B000, 0x55EC0800, 0x9B86EC00, 0x13B5FA00, 0x869AA700, 0x42AA2280, 0xD39207C0, 0x2CBF4FE0, 0xD9994430, 0x4C3D82F8, 0x8C4EBB5C, 0x6F0027E2, 0x2880D833 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x68000000, 0xDC000000, 0x06000000, 0x9F000000, 0xCA800000, 0x94400000, 0x79E00000, 0x16900000, 0x50180000, 0x5EB40000, 0xDB6E0000, 0xD2950000, 0xF0DF8000, 0x00BCC000, 0x34826000, 0xF52E1000, 0x0274D800, 0x3BCE9C00, 0x2265A600, 0xE9972900, 0x0231BE80, 0x5AE8B2C0, 0xCEFD27A0, 0x1462A0F0, 0x563FF1C8, 0xFCACCBAC, 0xE0DA1FA2, 0x4A7BECF3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x98000000, 0x14000000, 0x0A000000, 0x09000000, 0x3B800000, 0x0A400000, 0x04200000, 0x45700000, 0x8AD80000, 0x48DC0000, 0xE1520000, 0xE83D0000, 0x37C28000, 0x8EF5C000, 0xC4172000, 0x5C12F000, 0x249C0800, 0x62736400, 0x6DCC5A00, 0x41DA7300, 0x61C8DE80, 0x73556340, 0x4E276860, 0x976BF0F0, 0xF070DCD8, 0xA758B1D4, 0xAD9CC062, 0x19F2A4F1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xC8000000, 0xEC000000, 0xFA000000, 0xFF000000, 0x18800000, 0xECC00000, 0xD1200000, 0xB8300000, 0xC7080000, 0x236C0000, 0x44DA0000, 0xCD0D0000, 0x378A8000, 0x4ED4C000, 0x3B7E6000, 0x6F1B5000, 0x60ACB800, 0x957B2400, 0x2DFC0600, 0x8FA23500, 0xF488AF80, 0x492DDF40, 0x703AF3E0, 0xC99DDB50, 0x8BF23A38, 0x63D19A64, 0x2318ABE2, 0xB7D46F51 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xC8000000, 0x64000000, 0xDE000000, 0xC1000000, 0x6C800000, 0x30400000, 0x66A00000, 0xADB00000, 0x02280000, 0x2E340000, 0xD3460000, 0x9B550000, 0x5D968000, 0xF2AC4000, 0x08DB6000, 0x75E7D000, 0xD6E4A800, 0x0FBFEC00, 0xE498EA00, 0x779D9500, 0x54B3FA80, 0x94738040, 0x509315E0, 0xB0839A10, 0x549B2288, 0x49463D1C, 0x34545DE2, 0x9816E611 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xA8000000, 0x4C000000, 0x66000000, 0x9D000000, 0x65800000, 0x79C00000, 0xDA200000, 0x75300000, 0x1C780000, 0xDBDC0000, 0x3B0A0000, 0xCEBD0000, 0x995B8000, 0xA7944000, 0x652F6000, 0x39AB1000, 0x17CCF800, 0x2EC35C00, 0xEF590200, 0xF96C3700, 0xE1B34180, 0x6DC0CB40, 0x98213FE0, 0x6231A5B0, 0xF2F94958, 0xF29D6324, 0xB16B27E2, 0x7E6CA9B3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x18000000, 0x3C000000, 0x6E000000, 0x49000000, 0x9C800000, 0x3D400000, 0x84A00000, 0x78900000, 0x5ED80000, 0x097C0000, 0x5A560000, 0xA31D0000, 0xBAA68000, 0x4A344000, 0xA773A000, 0x18767000, 0xA5CCD800, 0x475F2C00, 0x2D198A00, 0xD79C7500, 0xD3E7E080, 0xB494B440, 0x4CE275A0, 0xD92E27F0, 0x1671DC58, 0x1F6818DC, 0x9AF58DA2, 0x6E123BF1 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x70000000, 0x18000000, 0xE4000000, 0xD2000000, 0x79000000, 0xE6800000, 0x0AC00000, 0x64600000, 0x70900000, 0x7ED80000, 0x21B40000, 0x89160000, 0x86950000, 0x4AA68000, 0xB1FC4000, 0x617A6000, 0x57B67000, 0x6A64A800, 0x70EE5400, 0x54919A00, 0x4CD83900, 0x88B45F80, 0x079789C0, 0x705492A0, 0x18C64270, 0x6A6C9EC8, 0x8023A0DC, 0x9A42DAA2, 0x8DD32671 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x98000000, 0x2C000000, 0x02000000, 0x79000000, 0xF9800000, 0xD2400000, 0x4B200000, 0xDBB00000, 0x5CC80000, 0xD6040000, 0x45AA0000, 0x11B50000, 0xA3638000, 0x02B0C000, 0xF5496000, 0x0C44F000, 0xCA8AB800, 0x7C043400, 0xA8AB2A00, 0x56353700, 0xE2223680, 0x7D109540, 0x2B392BE0, 0xB2ECDBD0, 0x0C9E5168, 0x9517F5C4, 0xAAB201E2, 0xF669ECD3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x68000000, 0x8C000000, 0xE2000000, 0xE7000000, 0xC3800000, 0xAC400000, 0x57200000, 0xB3700000, 0xE6D80000, 0x0B2C0000, 0xD2FA0000, 0x1C5D0000, 0xFA238000, 0x4271C000, 0x5459E000, 0xD5EC1000, 0x3B1B7800, 0x76CC1400, 0x1E6B5600, 0x21158300, 0x07C77680, 0x7D2E3940, 0xAA7BC660, 0x099C37F0, 0x624286B8, 0x3BA15B44, 0xC0B09062, 0xC7B9B4F3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x98000000, 0x14000000, 0x22000000, 0x2B000000, 0x57800000, 0x48C00000, 0x7B600000, 0x77D00000, 0xEE980000, 0xF49C0000, 0x53820000, 0x5F4D0000, 0x531A8000, 0x96D14000, 0x8E192000, 0x65DD7000, 0xAD238800, 0x957C7400, 0xEA12FE00, 0xCAF5AB00, 0x4677E780, 0xDCBA29C0, 0x84607620, 0x62509FF0, 0x7D589898, 0x907D0134, 0xE0928822, 0xFCB534F1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x98000000, 0x94000000, 0xF2000000, 0xF3000000, 0x3E800000, 0x9BC00000, 0x99E00000, 0x01D00000, 0x48A80000, 0x506C0000, 0xA7760000, 0x93BD0000, 0x24DE8000, 0x7950C000, 0x82696000, 0x8C0CF000, 0xFFE6C800, 0x2735D400, 0x79824E00, 0xA8DF5900, 0x5F50B180, 0x63693EC0, 0xB18C3C20, 0xC2A69690, 0xB1145D78, 0x13B3EEBC, 0x12A67222, 0x7915CF91 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xC8000000, 0x6C000000, 0x72000000, 0xBB000000, 0x26800000, 0x64400000, 0xBA200000, 0xBA100000, 0xA9380000, 0x34D40000, 0x13EE0000, 0x2CC50000, 0xF9D78000, 0x3A904000, 0x60786000, 0xAD74D000, 0xD23F3800, 0x0E1C7400, 0xE3F22E00, 0x9636E900, 0x6A60DE80, 0x46306940, 0x2E29C4A0, 0x266CB230, 0x08FB2388, 0x62CA04AC, 0x5EE3EAA2, 0x938E5B33 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x08000000, 0x04000000, 0xAA000000, 0x1B000000, 0x39800000, 0x8BC00000, 0x01200000, 0x93D00000, 0x16380000, 0x59940000, 0x16060000, 0xC8450000, 0x2F3E8000, 0x2A514000, 0xDDF86000, 0x78B45000, 0xF5D6E800, 0xD67C4400, 0x72AABE00, 0x96566700, 0x0EBC4180, 0x6E0AA140, 0x54479820, 0x0AA40A30, 0x99CF7A88, 0x75B88F7C, 0x81552622, 0x0AA66D31 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0x48000000, 0x74000000, 0x7A000000, 0x71000000, 0x54800000, 0x57400000, 0x49E00000, 0x42500000, 0xBCC80000, 0x76F40000, 0xB9160000, 0x4AA50000, 0x86DF8000, 0x4DD14000, 0xB6086000, 0x20D4D000, 0x1BE70800, 0xBEDD6400, 0x5F338A00, 0x473B1D00, 0x5CEF2C80, 0x0A886AC0, 0x3394E220, 0x40062E50, 0x098C1348, 0x857BAEBC, 0x638F6822, 0x82993353 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x68000000, 0xB4000000, 0x62000000, 0xE3000000, 0xAC800000, 0x8CC00000, 0x0AE00000, 0xE0D00000, 0x7BC80000, 0x70940000, 0x41F20000, 0x1E450000, 0x373A8000, 0x3F504000, 0x7388A000, 0xE2B59000, 0xD9C34800, 0x0E5D1400, 0x24E62E00, 0xE0F7DD00, 0xC5DF7F80, 0x879B5CC0, 0x26A15020, 0x38F11650, 0x14F83E88, 0xBE0C7174, 0x55EF7E22, 0xD382CB51 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x18000000, 0x54000000, 0xF2000000, 0xB7000000, 0xE7800000, 0x14C00000, 0xAAA00000, 0x21B00000, 0x2E680000, 0x9D3C0000, 0xC2460000, 0x8B8D0000, 0x4BAE8000, 0x22714000, 0x73482000, 0x904C7000, 0x428E0800, 0xDD00D400, 0x44814600, 0x21406B00, 0x5961E780, 0x7490AA40, 0x4F18C2E0, 0xEBF4ED90, 0xC9CA1718, 0x8023175C, 0x49DF84E2, 0x01398691 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x18000000, 0xF4000000, 0xCA000000, 0xED000000, 0x14800000, 0x24C00000, 0xEE600000, 0xBE900000, 0xECF80000, 0x816C0000, 0x2FA60000, 0x8AFD0000, 0x43DF8000, 0x15504000, 0x27192000, 0xD9BD7000, 0x92FF4800, 0x84E0A400, 0xDD51B200, 0x0B18FD00, 0x47BD3380, 0xE5FFC5C0, 0x6561DCA0, 0x19101130, 0x0BB8E5F8, 0xFA4D0FBC, 0xA3166EA2, 0x2C35EC33 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xF0000000, 0xF8000000, 0xE4000000, 0x26000000, 0x9B000000, 0xDE800000, 0xC9400000, 0xE0200000, 0x0CF00000, 0x3DB80000, 0x34740000, 0x6F920000, 0xCB850000, 0x80AB8000, 0xDCB14000, 0x5E186000, 0x6445B000, 0xADCA2800, 0xC660BC00, 0xFC517E00, 0xAF09B100, 0xFD6D4480, 0x3F578D40, 0xFE0F4360, 0xD96B7730, 0x62D18708, 0x86493954, 0xCD4C3D62, 0x3BA7C633 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x48000000, 0x9C000000, 0x36000000, 0x49000000, 0x52800000, 0x56400000, 0x43E00000, 0xFFF00000, 0x04280000, 0xA3940000, 0x5A6A0000, 0x49650000, 0x9AC28000, 0xC5B0C000, 0x49C92000, 0xF1655000, 0x3EC29800, 0x17B1FC00, 0x32C92A00, 0x08E50900, 0xD9039E80, 0x2F91B2C0, 0xC318EB60, 0xB41D2390, 0x94EF8AC8, 0x6E578984, 0x885BC162, 0x9A6D2A91 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0x88000000, 0xE4000000, 0xC6000000, 0x51000000, 0xB3800000, 0x5BC00000, 0x84200000, 0x49500000, 0x84080000, 0xEC5C0000, 0x146E0000, 0x600D0000, 0x2DE68000, 0x8290C000, 0x38296000, 0x290CD000, 0x42662800, 0x93519C00, 0x3F09EA00, 0xCCDD2B00, 0x9B2FF580, 0xD56C7F40, 0xECD76D20, 0x56294C50, 0xCC0C8818, 0xAFE697CC, 0x05908722, 0xA2A96751 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xF8000000, 0x5C000000, 0xE2000000, 0x6F000000, 0xF7800000, 0xECC00000, 0xCB200000, 0x4AB00000, 0x40280000, 0x17940000, 0x0A860000, 0x76250000, 0x532F8000, 0x68704000, 0x9E09E000, 0x09A4B000, 0x7BEED800, 0x8D513400, 0x91B9E600, 0x750D6B00, 0xC93B6780, 0x2D368940, 0xFE8D74E0, 0x37FA1210, 0xD1164448, 0x2FBC6A5C, 0x811292E2, 0x3EA27913 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0x48000000, 0xBC000000, 0x32000000, 0x3F000000, 0xE3800000, 0x1AC00000, 0x60600000, 0xEE700000, 0x77980000, 0xFE7C0000, 0x5ABE0000, 0x2D0D0000, 0x09A68000, 0x2E304000, 0xBFB82000, 0x742DD000, 0x7D77D800, 0x27B9F400, 0xC02D8600, 0x5376E300, 0x7AB9EB80, 0x54AD17C0, 0x1637D160, 0x3219EBF0, 0xE5BC4E18, 0x6C5FA54C, 0xA13C5762, 0x211E08F1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x88000000, 0xF4000000, 0x66000000, 0xD7000000, 0x1F800000, 0x1EC00000, 0x9CA00000, 0xF5700000, 0x16880000, 0x96BC0000, 0x19A60000, 0xAACD0000, 0x6BAE8000, 0xC730C000, 0x2569A000, 0x22ACD000, 0x8F7EC800, 0x9E48DC00, 0x851CC600, 0x6F573300, 0xA085B380, 0x58B29640, 0x1766FF60, 0xFE6D7850, 0x8ADF3998, 0x27B8295C, 0xECD43962, 0xD08B4B51 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0x58000000, 0x44000000, 0xA6000000, 0xFF000000, 0xEC800000, 0x1AC00000, 0x55200000, 0x2FB00000, 0xF5780000, 0x7DAC0000, 0xF61E0000, 0xCF1D0000, 0xF6E68000, 0x1BF04000, 0x53996000, 0xECBDF000, 0x6E976800, 0xF628FC00, 0xBCC5F600, 0xB2BBD500, 0x07772B80, 0x33B84340, 0x2A8D22E0, 0xD0AEACB0, 0x81E50A38, 0x610B67CC, 0x400ED4E2, 0xBF1479B1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x38000000, 0x7C000000, 0x4A000000, 0x05000000, 0x7E800000, 0x26C00000, 0xFC200000, 0x26100000, 0x2C680000, 0xE93C0000, 0xC5320000, 0x81AD0000, 0x179B8000, 0xB8B14000, 0xF6B96000, 0x54743000, 0x409E1800, 0x4037E400, 0xB02A7200, 0x7D88A900, 0xBE8D6780, 0xF80BD540, 0x959969A0, 0x81E43C90, 0x50B7B858, 0x35EA51B4, 0xD8289BA2, 0xF1DDD593 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0xF8000000, 0x64000000, 0x2A000000, 0xF1000000, 0xD7800000, 0x30400000, 0x55200000, 0x8D900000, 0x9F180000, 0xB35C0000, 0xA7860000, 0x514D0000, 0xCCDF8000, 0x2D31C000, 0x3FC82000, 0xA8E53000, 0x3E0B6800, 0xAC72A400, 0xFB9FAA00, 0xB091BB00, 0x3E996280, 0x5C1D9540, 0x2E27E3A0, 0x321DF870, 0x85268398, 0x5C9DA83C, 0x2EE7C9A2, 0x8FFD8373 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x78000000, 0x24000000, 0x62000000, 0xFF000000, 0x4E800000, 0xF8C00000, 0x4EE00000, 0x7CB00000, 0x70A80000, 0x8DF40000, 0xBD6A0000, 0x17C50000, 0xA9038000, 0x32D04000, 0xA5D92000, 0x9C3DB000, 0x136EE800, 0xC7A73400, 0x6C233600, 0xB0019900, 0x48006F80, 0xAC0110C0, 0x6E0110E0, 0xC1000090, 0xF7809088, 0x2B403C84, 0x07A1A6E2, 0x8411D993 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x98000000, 0x7C000000, 0xAA000000, 0x99000000, 0xF6800000, 0xEDC00000, 0x38600000, 0x63300000, 0xCE880000, 0x39840000, 0x672A0000, 0xF6350000, 0x85638000, 0x1D51C000, 0xB6B96000, 0x1C8DF000, 0xE3EE1800, 0xEFBF6400, 0x3B874A00, 0x84CAF900, 0x10444980, 0x594B0DC0, 0x2E05F5E0, 0xB06A11D0, 0x7194DB68, 0x4B334044, 0x74693FE2, 0x497528D3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x88000000, 0xA4000000, 0xD6000000, 0xE7000000, 0x99800000, 0x5A400000, 0x47E00000, 0xCA700000, 0x6B980000, 0xFC7C0000, 0xA1220000, 0x758D0000, 0x55FA8000, 0x4E904000, 0xAE68A000, 0x8AA45000, 0x933F6800, 0xCC9FBC00, 0xA80F0600, 0xFB665F00, 0xCD439A80, 0x34BC4CC0, 0xB7029860, 0x235DCCF0, 0x5572F618, 0xFCC4DC74, 0xF70F1E62, 0x1EE7D3F1 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0xF8000000, 0xC4000000, 0xBA000000, 0x4F000000, 0x5A800000, 0x1D400000, 0x9B200000, 0xE3D00000, 0x99280000, 0xC4DC0000, 0x677E0000, 0xD68D0000, 0x33968000, 0x5330C000, 0xDA99A000, 0x64043000, 0x1EDAA800, 0xD8C78400, 0xE4589600, 0x41E48100, 0x98EA4480, 0x27DE5340, 0x4F9C0520, 0x755FB810, 0xBEDC4418, 0x887F87AC, 0xFC0C1322, 0x46D6F911 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0x38000000, 0x7C000000, 0xFE000000, 0xC9000000, 0x05800000, 0x31C00000, 0xE7600000, 0x01700000, 0xB1180000, 0x7F7C0000, 0xA3AE0000, 0xBE8D0000, 0xB0F78000, 0xFA51C000, 0xE2C8A000, 0xCA74B000, 0xCBBBD800, 0x27C68C00, 0x9AE9EA00, 0x7F24B700, 0x39F21180, 0xD7F395C0, 0xE6F26960, 0xFF73E8F0, 0xA0B3F218, 0xB6D2AC6C, 0xCE220362, 0xB0FB9FF3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x18000000, 0x94000000, 0x3A000000, 0xBD000000, 0x20800000, 0x73400000, 0x60200000, 0x14100000, 0xCD880000, 0xFD7C0000, 0x83C20000, 0x2AED0000, 0x428B8000, 0xAD71C000, 0xACB96000, 0xE864F000, 0x1E77C800, 0xAB734400, 0xF634D200, 0x615F7500, 0x105EBC80, 0x3EDED140, 0xDA9F96A0, 0x4F3EA750, 0x84EE4CD8, 0xF4061F94, 0xFA4AC4A2, 0x3D911253 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x08000000, 0x34000000, 0xB6000000, 0xA7000000, 0x10800000, 0x1BC00000, 0xB4A00000, 0x41700000, 0x4D780000, 0xC53C0000, 0xB2DA0000, 0x61CD0000, 0xBDE28000, 0x90104000, 0xCBA9E000, 0x7FB55000, 0x3E5F0800, 0x8E0A7C00, 0xB644A600, 0xA4E68D00, 0xD5965980, 0xD0EFB840, 0x81D20D60, 0x350957B0, 0xFBC59A98, 0x62A6C844, 0x5F762B62, 0x877E9AB1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x18000000, 0x04000000, 0x5E000000, 0xB9000000, 0xA4800000, 0xE1C00000, 0xCE600000, 0xBBD00000, 0x1C580000, 0x139C0000, 0x40DE0000, 0x57CD0000, 0xCAC68000, 0x4071C000, 0x0FE8A000, 0x7914F000, 0xBD9A2800, 0x404F8C00, 0xED34FA00, 0x606BB500, 0x4AE75180, 0xDB8145C0, 0xB840CC20, 0xB521F070, 0x3D708E98, 0xD568BA0C, 0x51D4B622, 0xDF7A8571 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x98000000, 0x7C000000, 0x0A000000, 0xE9000000, 0x84800000, 0xC0400000, 0xA2E00000, 0x9C700000, 0x45A80000, 0xDB0C0000, 0x9E420000, 0x773D0000, 0xF10B8000, 0x74404000, 0x8CE02000, 0xA3707000, 0xF2295800, 0xEECD2400, 0x04632A00, 0x83EC1D00, 0x6333D280, 0xF2140CC0, 0x4C469860, 0x33E2BE90, 0x762D56F8, 0x591253D4, 0xD6C59262, 0x467ED393 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xD8000000, 0x2C000000, 0x86000000, 0xC3000000, 0x02800000, 0xA5400000, 0x0FA00000, 0xEB100000, 0xE1580000, 0xFAAC0000, 0x38C60000, 0x0CFD0000, 0x0A3F8000, 0xA340C000, 0x0CA1E000, 0x09907000, 0x74183800, 0x2D0CBC00, 0xFFD7DE00, 0x6BA40900, 0x33934C80, 0x9906DA40, 0xA51C7CA0, 0x0C0E2DF0, 0x3C48DB78, 0xC0F4EF3C, 0x0CEA42A2, 0x277A54F3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xD8000000, 0x34000000, 0xE6000000, 0x19000000, 0xEC800000, 0x68400000, 0xDAE00000, 0x8AF00000, 0x41980000, 0x5C640000, 0x6F820000, 0x5AD50000, 0x9AFA8000, 0x69414000, 0x6260E000, 0x14B1F000, 0x6A780800, 0xD6147C00, 0x945A5A00, 0x23511500, 0x8A086280, 0xF6CC2CC0, 0x165FA560, 0x426386F0, 0x99A44528, 0x45A35034, 0xA4851F62, 0xA27363F1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x68000000, 0xD4000000, 0xC6000000, 0x73000000, 0x70800000, 0xB8400000, 0xCAA00000, 0x21B00000, 0x81180000, 0x075C0000, 0xF8F20000, 0xA2AD0000, 0x614B8000, 0xD140C000, 0xEB206000, 0xD4711000, 0xD4784800, 0x8A8D5C00, 0x8DBB4E00, 0x79786D00, 0xF50C1680, 0xB77AB440, 0x4E99D3E0, 0x759DC770, 0x0B1225D8, 0x7C3D9FD4, 0x1222FDE2, 0x8164BA73 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xC8000000, 0x4C000000, 0x4E000000, 0xCF000000, 0x4C800000, 0x8E400000, 0xDB600000, 0x9AD00000, 0x5FC80000, 0x735C0000, 0xE9BE0000, 0xE9CD0000, 0x42168000, 0xBCC04000, 0xE2202000, 0x7930D000, 0xD1583800, 0xF2F50C00, 0x81B30600, 0x1C7B0500, 0x0E270280, 0x9419EFC0, 0x27154920, 0xB4237950, 0x4B537B18, 0xED6B78EC, 0x3B4E6F22, 0xB234AC51 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x68000000, 0xEC000000, 0x42000000, 0x03000000, 0xD9800000, 0x44400000, 0x57A00000, 0xEEB00000, 0xE3D80000, 0xB86C0000, 0xCBFE0000, 0x009D0000, 0xC4878000, 0x1BC04000, 0xDEE0E000, 0x31919000, 0x4BA8B800, 0x15D45400, 0x20C3DE00, 0xD0AA3700, 0xAB9E0E80, 0xD2CCDC40, 0xA5CEF5E0, 0x598498F0, 0xA88B45B8, 0x046F9C4C, 0xB235CBE2, 0x9FD33FF3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xE8000000, 0x4C000000, 0x8E000000, 0x3B000000, 0x2E800000, 0xFEC00000, 0x6EE00000, 0x05300000, 0x92180000, 0x75D40000, 0xD18A0000, 0x68250000, 0x1A728000, 0xD841C000, 0x0C21A000, 0x6DD11000, 0x7029B800, 0xAF4CCC00, 0x2D9EEE00, 0x77CE4100, 0xB2A60B80, 0x104BC0C0, 0x5A4597E0, 0x4C8349F0, 0x053949C8, 0x86857324, 0x4762D9E2, 0x9D8818F1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x30000000, 0xA8000000, 0xD4000000, 0x8E000000, 0x49000000, 0x15800000, 0x50400000, 0xC5A00000, 0x57700000, 0x7E580000, 0xCB0C0000, 0x83720000, 0x163D0000, 0x3F8B8000, 0xF6C14000, 0xB761E000, 0x16111000, 0x4D49C800, 0x51C44C00, 0x39F73A00, 0xECEA3700, 0x06D0B280, 0x47286040, 0xEC542E60, 0xC5FE47F0, 0xB90EC0F8, 0xB617CE54, 0x593AF462, 0x637960F3 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x18000000, 0x34000000, 0x4A000000, 0x0B000000, 0x2E800000, 0xDA400000, 0x95200000, 0xD9900000, 0x0E180000, 0xF7F40000, 0x8BAE0000, 0xE2250000, 0xBD978000, 0x77C0C000, 0x7DE06000, 0x10F1F000, 0xC7A98800, 0x57FCA400, 0xB9827E00, 0xB59FC900, 0x49ED2280, 0x445B3740, 0x4D8B27A0, 0xFDB26670, 0xED5744C8, 0x5AA1576C, 0xF65139A2, 0x67F85F73 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0xB0000000, 0xF8000000, 0x4C000000, 0xCA000000, 0x39000000, 0x40800000, 0xBC400000, 0x6AA00000, 0x1CF00000, 0xD3280000, 0xAD2C0000, 0x43B60000, 0xDC9D0000, 0x7EBF8000, 0x8F014000, 0x8B80E000, 0xA9C1B000, 0xEC61F800, 0x0B106400, 0xA9F8EA00, 0x14B51500, 0x6E130A80, 0x6E775440, 0x8EFDC160, 0xEAAEB310, 0x257943B8, 0xA2F4313C, 0x1DB3CB62, 0x82071613 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xC8000000, 0xA4000000, 0x32000000, 0xC5000000, 0x75800000, 0x98400000, 0x71200000, 0x3E100000, 0x65080000, 0x1E3C0000, 0xC0AA0000, 0x096D0000, 0x6B038000, 0xB8004000, 0xAC006000, 0x3600D000, 0x0700A800, 0x7881F400, 0x49C0C200, 0xDB608F00, 0x8A30BA80, 0x2E980940, 0xE3754CA0, 0xAFB62850, 0xF7D74058, 0x0767CB44, 0xCD3FEEA2, 0xD4AB7753 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xA8000000, 0x1C000000, 0x6A000000, 0x6B000000, 0xEC800000, 0x13400000, 0x8DE00000, 0x41500000, 0x9A280000, 0x57BC0000, 0x7C760000, 0x0AAD0000, 0x993F8000, 0x32014000, 0x4F012000, 0x12811000, 0x5E409800, 0xC8618400, 0xC990EE00, 0x82090D00, 0xE34CF080, 0xC66EC2C0, 0x9529A420, 0xA53DAF90, 0x52366DD8, 0x3ACC6CBC, 0xE4AE6A22, 0xC608B293 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xB0000000, 0x18000000, 0x24000000, 0xD2000000, 0xB7000000, 0x4B800000, 0x83C00000, 0x35200000, 0x3CF00000, 0x7F480000, 0x0E440000, 0x15D20000, 0x8C750000, 0xA73B8000, 0xF480C000, 0x6440E000, 0x08E1F000, 0xE0D12800, 0x51399400, 0xF84D2600, 0x83F73300, 0xEF376980, 0x95967D40, 0xA8A63E60, 0xFDCEB4D0, 0xB8FA7568, 0xA7A08D34, 0x75B1F862, 0x072977D3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xD0000000, 0x98000000, 0xF4000000, 0xA2000000, 0x09000000, 0xCE800000, 0xD4C00000, 0xD7600000, 0x45900000, 0x2D680000, 0x86EC0000, 0x1A320000, 0x193D0000, 0x94FA8000, 0x3D20C000, 0xAE312000, 0xE398F000, 0xF0144800, 0x76B67400, 0x1462FA00, 0x26B55900, 0x74C6FB80, 0x8F5B53C0, 0x1BD032A0, 0x84C86C10, 0x911D4AF8, 0x3A4BA8B4, 0x557968A2, 0xECC50511 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xF0000000, 0x98000000, 0xD4000000, 0xA6000000, 0x1F000000, 0xDC800000, 0x55C00000, 0x47E00000, 0x3A700000, 0x8DF80000, 0x145C0000, 0x622E0000, 0xF76D0000, 0xB5F78000, 0xC2A0C000, 0x7A506000, 0x5968F000, 0x08544800, 0x3ECA7C00, 0xE13E9600, 0xE4247500, 0xF432D580, 0x1DE216C0, 0x85CA8F60, 0xC3BE4C30, 0x9AE41858, 0x39523DAC, 0xF553F962, 0x47520933 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xE8000000, 0x4C000000, 0xEE000000, 0x4B000000, 0x01800000, 0x93C00000, 0x69A00000, 0x28900000, 0x35A80000, 0xD5FC0000, 0xD2320000, 0x772D0000, 0xA9FA8000, 0x89E14000, 0xDFF02000, 0x52199000, 0xE4843800, 0x6B060C00, 0x7C530E00, 0x6C1C5F00, 0x95C37180, 0xD1353040, 0x077E86A0, 0x0BE6B010, 0x07239ED8, 0xE7449534, 0x8AA728A2, 0x68C23F11 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x28000000, 0xD4000000, 0xFE000000, 0xBF000000, 0x07800000, 0xC1400000, 0xB3200000, 0xB5300000, 0x00A80000, 0x4DC40000, 0x8B5E0000, 0xA2350000, 0x03968000, 0x60E0C000, 0xC1D1A000, 0x9F799000, 0x1DBC8800, 0x2963AC00, 0xB617D600, 0x2CA07300, 0xB871BC80, 0xC1898940, 0xD5F598E0, 0x31769F10, 0xBC30A5E8, 0xBC2915EC, 0xBD056EE2, 0x023FBC11 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0xA8000000, 0x24000000, 0xC6000000, 0x73000000, 0xC6800000, 0x18C00000, 0x5AA00000, 0xEFB00000, 0x1E680000, 0x130C0000, 0xA54E0000, 0xBEFD0000, 0xF3468000, 0x29E04000, 0x4451A000, 0x9F381000, 0xA1B56800, 0xC6BADC00, 0x7027AE00, 0xA7718100, 0x0CC91780, 0xE8BD5840, 0x45279EE0, 0x52F09190, 0x7288BD78, 0x3ADD5C4C, 0x583710E2, 0x87294091 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0x38000000, 0x9C000000, 0x3A000000, 0x5D000000, 0x97800000, 0xE4400000, 0x7AA00000, 0xDDD00000, 0xA3480000, 0xAA6C0000, 0x03120000, 0xDE7D0000, 0x33BB8000, 0xECE04000, 0x3E71E000, 0xDF193000, 0x82655800, 0xBD5E0400, 0xD57E8200, 0xB76FDB00, 0x18C6B280, 0xDCDA7A40, 0xA8D1A320, 0x60C85BD0, 0x702CF378, 0xB2B2A6B4, 0xCB2D4122, 0x2232F0D3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x48000000, 0x64000000, 0xD2000000, 0x65000000, 0x00800000, 0xD8C00000, 0x30A00000, 0x8C100000, 0x18280000, 0xDCAC0000, 0x4E3E0000, 0x7EFD0000, 0xA9778000, 0xAB61C000, 0x5330E000, 0xD5785000, 0x6265A800, 0x6DE33400, 0x47DB0200, 0xF05F2500, 0x054D3B80, 0x70CE4040, 0x63A499A0, 0xB3C2E910, 0x580A9D78, 0xF356EA2C, 0x16B0FBA2, 0x1D385C13 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x10000000, 0x08000000, 0x94000000, 0xEA000000, 0xD5000000, 0xC3800000, 0xC2C00000, 0xE7600000, 0x5CD00000, 0x27E80000, 0x579C0000, 0x06660000, 0x0F0D0000, 0x2FAE8000, 0x05E04000, 0x4790A000, 0x6F495000, 0xA3AD0800, 0xC99FC400, 0x33198200, 0xDE04D300, 0xFF236F80, 0xD68F69C0, 0x3A10AC20, 0x72896910, 0xE24CA298, 0x8C0FD91C, 0xAD510E22, 0x4C29AA11 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x18000000, 0x14000000, 0x56000000, 0x2F000000, 0xF1800000, 0x5BC00000, 0x5DA00000, 0x69D00000, 0x9B080000, 0xEE640000, 0x1D7E0000, 0x8AF50000, 0xBD978000, 0xA920C000, 0x6691A000, 0xF9E9F000, 0x0D540800, 0x79469C00, 0x5AA97600, 0x1DB4CF00, 0x0B772980, 0xFC107840, 0x3DA9D420, 0xC0346550, 0xE2B78368, 0xD0B062EC, 0x86F88222, 0xB37C9A53 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xD8000000, 0x2C000000, 0x2A000000, 0x53000000, 0xDA800000, 0x5EC00000, 0x82200000, 0x18900000, 0xAF580000, 0x25D40000, 0xF7F60000, 0x4E050000, 0x20CF8000, 0x8AA1C000, 0x8951A000, 0x75F97000, 0xD4847800, 0xDE0FE400, 0x7881FE00, 0x59C06100, 0x2EA0DB80, 0xF7509140, 0x50F93CA0, 0xBF0402F0, 0xFD4E2E88, 0x78E1175C, 0xE4B0E2A2, 0x92C9D3F3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x98000000, 0x04000000, 0x9E000000, 0x3F000000, 0x1A800000, 0x32400000, 0x90E00000, 0x9C500000, 0xC5B80000, 0xB0D40000, 0x4A820000, 0x85450000, 0xB81B8000, 0x29E04000, 0x7DD16000, 0xD3787000, 0x5D74E800, 0xC4B20C00, 0xEAED7600, 0xC3968900, 0x70E65A80, 0x6D2F74C0, 0x6CB3AC20, 0x16ED82B0, 0x89967508, 0x39E6F874, 0xD4AE3A22, 0xDE723BB3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x48000000, 0x94000000, 0x7A000000, 0xD9000000, 0xD5800000, 0xE4400000, 0xA3E00000, 0xDAF00000, 0xAB080000, 0xA55C0000, 0x9A160000, 0x256D0000, 0x2E3F8000, 0x12E04000, 0x8B702000, 0xDD49D000, 0x9BBC8800, 0xA7666400, 0x27259A00, 0x8702DF00, 0x6F463A80, 0x7375CCC0, 0x689A2D60, 0x1BA2D9D0, 0x76D7BB58, 0xE54DA83C, 0x8E6E1762, 0xF77896D3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x58000000, 0x74000000, 0xF2000000, 0xAF000000, 0x46800000, 0x80C00000, 0x73A00000, 0x34500000, 0xBBD80000, 0xA2CC0000, 0xFB3A0000, 0xF5DD0000, 0x9E028000, 0x8CA1C000, 0x0AD1A000, 0xBF187000, 0xEB6DC800, 0x4C6B5400, 0x8E84B600, 0xE10FE900, 0xEDBB9F80, 0x0D1CCA40, 0x69A39920, 0x82F198F0, 0x3209D938, 0xDD5547C4, 0xCD960F22, 0x2396C1F1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0xD8000000, 0xE4000000, 0xC2000000, 0xAF000000, 0xB6800000, 0x5BC00000, 0xD9200000, 0xF0500000, 0x27480000, 0xBF4C0000, 0x11320000, 0xC75D0000, 0xF11B8000, 0xAA204000, 0x90D0A000, 0xF988F000, 0xD3ECE800, 0xF2223400, 0xEBF59600, 0xBCA76900, 0x2E4BA980, 0xFBE97F40, 0xD45C2720, 0xA19A54D0, 0x3CE08A38, 0xC070CAF4, 0x3C989122, 0x92448DD3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xB8000000, 0x04000000, 0x6A000000, 0x7B000000, 0x3F800000, 0x53400000, 0xA6E00000, 0x2C300000, 0xB3980000, 0x66340000, 0x4CA20000, 0xCBC50000, 0x801B8000, 0xAAE1C000, 0xCA30A000, 0xEE99B000, 0x64B52800, 0x8D63A400, 0x14E5FE00, 0x770B2B00, 0x84699080, 0xF98D92C0, 0xAE074EE0, 0xBCAE02F0, 0x7383B008, 0x6CD54074, 0x769390E2, 0x0D5C59F3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x90000000, 0x88000000, 0x94000000, 0xCA000000, 0x29000000, 0x2D800000, 0x0F400000, 0x36200000, 0x3D300000, 0x87C80000, 0xC0FC0000, 0x549A0000, 0x4BED0000, 0x2E638000, 0x2CD94000, 0x2A04A000, 0xBBAF5000, 0xDB8B0800, 0x73140400, 0xF456BA00, 0xCF3FAF00, 0x9B32FC80, 0x5180CF40, 0x214038E0, 0xED20D5D0, 0xB5B0EA98, 0x73084F24, 0x8E9D8AE2, 0x910B7ED3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xD0000000, 0x18000000, 0x54000000, 0x1E000000, 0x31000000, 0x80800000, 0x18C00000, 0xE0200000, 0xBAB00000, 0xA3880000, 0xB5A40000, 0xDB4A0000, 0xCF350000, 0xB2738000, 0x7119C000, 0x409C2000, 0x3766F000, 0x46DA0800, 0x5B8C8C00, 0xDE1F8A00, 0x54175D00, 0xEDF34380, 0xB0581940, 0xC4FD30E0, 0xF7378950, 0xDCC34528, 0x0C91E504, 0xA438B2E2, 0xBCAC5853 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xB0000000, 0xA8000000, 0x34000000, 0xB2000000, 0x0B000000, 0x43800000, 0x26400000, 0x61E00000, 0xB4D00000, 0xD4F80000, 0xBB9C0000, 0x79EA0000, 0xBEAD0000, 0x41C28000, 0xADC8C000, 0xB5B5E000, 0x7B8E9000, 0x365A0800, 0x4045B400, 0x62873E00, 0x18CE4300, 0x693BEA80, 0x60553CC0, 0x3D5E0920, 0x09A2E830, 0x08595798, 0x952C8DA4, 0xF3833F22, 0x2E291F31 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0xD0000000, 0x28000000, 0xF4000000, 0x92000000, 0x05000000, 0x86800000, 0xAEC00000, 0x73A00000, 0xB6D00000, 0xB8F80000, 0x5B440000, 0xC2560000, 0x3A350000, 0xB67F8000, 0xC888C000, 0xEBEC2000, 0xB32B9000, 0x66874800, 0x47CDF400, 0x8BBBA200, 0x741F4900, 0x8A782780, 0x47841240, 0x84F69C20, 0xF26448B0, 0x7C46E428, 0x866CA9DC, 0x086A7622, 0xB266F5B3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xC8000000, 0xB4000000, 0x56000000, 0x5D000000, 0x07800000, 0xE7C00000, 0x9CA00000, 0x13F00000, 0x24A80000, 0xE37C0000, 0x9DFA0000, 0xF02D0000, 0x78A38000, 0x04F84000, 0x70A52000, 0xA36ED000, 0x3C4AC800, 0x5CE5BC00, 0xC20F1200, 0x341A4300, 0x4B3CC580, 0x929B0E40, 0x897CCC60, 0x42FBD610, 0x0CADEC18, 0x5DE25624, 0x04191662, 0xFA342913 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xD8000000, 0xB4000000, 0x12000000, 0x67000000, 0xDF800000, 0x9CC00000, 0x9AE00000, 0xF1D00000, 0x43C80000, 0x00C40000, 0x8BFA0000, 0x51F50000, 0x12E28000, 0x3B79C000, 0x981CE000, 0xAF177000, 0xCF9A0800, 0xB6641400, 0xBF8BE600, 0xFBCC3B00, 0xCBDEA780, 0x70DF92C0, 0x915E7620, 0xAC9FA850, 0xACFEDB28, 0xA16FA2E4, 0x8F079822, 0x6A338751 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x58000000, 0x24000000, 0x02000000, 0x01000000, 0x00800000, 0x83C00000, 0x67200000, 0xCDF00000, 0x13780000, 0x20BC0000, 0x52520000, 0xBC6D0000, 0x67DB8000, 0x1228C000, 0xC0756000, 0x43F77000, 0x9493A800, 0x69CC3400, 0x90EA0A00, 0x32F02500, 0xF4F8D580, 0x40FDF740, 0xC7323060, 0xCDFD5EB0, 0x79B21198, 0x893D40D4, 0x6D139262, 0x9E8D4FB3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0xA8000000, 0x2C000000, 0x76000000, 0xA5000000, 0x10800000, 0xB9C00000, 0xB6A00000, 0x5FF00000, 0xC7C80000, 0x14540000, 0x8B3E0000, 0x4F050000, 0x4C078000, 0x8F19C000, 0xC72CE000, 0xD0C39000, 0xCEBE3800, 0xEE453C00, 0xBF665200, 0x08486D00, 0x7E158980, 0x49DE8440, 0x3B151860, 0x295F94D0, 0x4AD46448, 0x03FFC76C, 0xCB257262, 0x4D36C5D3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x30000000, 0x98000000, 0xAC000000, 0x5E000000, 0xF5000000, 0xEA800000, 0x89C00000, 0xB4E00000, 0x7AB00000, 0x05480000, 0x17240000, 0xF96A0000, 0x4C750000, 0x1C128000, 0xAFD8C000, 0xDABCE000, 0xA676F000, 0xD6923800, 0xB6180C00, 0x265DF200, 0xD8C6C900, 0xB9DAA980, 0xA63D54C0, 0x9EB742E0, 0x02F29550, 0x72683428, 0x4E7416C4, 0x8F1288E2, 0xCC595051 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x58000000, 0x54000000, 0x66000000, 0x07000000, 0x7D800000, 0x31C00000, 0x90200000, 0x2FF00000, 0xC8880000, 0x35640000, 0xEBB60000, 0x3DB50000, 0x194E8000, 0x8D99C000, 0x2DBCA000, 0x196A7000, 0x894F8800, 0x9599FC00, 0x19BCE600, 0x6F6AD700, 0xD64FFD80, 0xBC184340, 0x4E7C1860, 0xF84A9350, 0x843F5028, 0x455146FC, 0xEB397662, 0x3C0CB851 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xF8000000, 0x14000000, 0x52000000, 0x67000000, 0xDF800000, 0x41C00000, 0x1A600000, 0x7ED00000, 0xFAA80000, 0x49840000, 0x52A60000, 0x12350000, 0x2D5F8000, 0xBAD8C000, 0xB71DA000, 0xE51A3000, 0x121F0800, 0xCBF9D400, 0xCAECA600, 0xF542FB00, 0x7C429D80, 0x5AC2D3C0, 0x1583B220, 0x4CA2CB90, 0x3D538FA8, 0x7B0AD49C, 0xD8561C22, 0xE5ECE493 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x88000000, 0x64000000, 0x6E000000, 0x4B000000, 0xC4800000, 0x1AC00000, 0xFC200000, 0x95500000, 0x34A80000, 0xDB140000, 0x47920000, 0x37650000, 0x19EA8000, 0xBE99C000, 0xDF8C2000, 0x251FD000, 0x11FB6800, 0x8C504C00, 0x79281E00, 0x24553500, 0x10F31380, 0x4354A940, 0xFE738B20, 0x4C941B10, 0x55D3A388, 0xEB858AF4, 0x8D9AFD22, 0x7CE06211 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x68000000, 0x04000000, 0x96000000, 0xED000000, 0x66800000, 0x73400000, 0x56200000, 0x9E300000, 0x58B80000, 0xD9940000, 0xB66E0000, 0xA2850000, 0x2F668000, 0xE8694000, 0x1CFDA000, 0xAC129000, 0xCDD62800, 0x4C907C00, 0x56C91200, 0x808C8100, 0x8E0ACC80, 0x7E33B940, 0x85E77EE0, 0xD9292B30, 0x79DC7848, 0x2DA2462C, 0x7EAE44E2, 0x5964D631 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0xB8000000, 0x9C000000, 0x42000000, 0xBD000000, 0x4E800000, 0x8EC00000, 0x1DE00000, 0x41D00000, 0x30B80000, 0x1A540000, 0xB4260000, 0xB1650000, 0x22CF8000, 0xCDC8C000, 0xD49DA000, 0x013AB000, 0x951E1800, 0xE6717400, 0x03480200, 0x9A5DF900, 0xFCDB3780, 0xC4CFEEC0, 0x6EC8A220, 0x851DE4B0, 0x6C7AB008, 0xF0BED9BC, 0xA880B822, 0x2DC069B3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0xD8000000, 0xF4000000, 0x8E000000, 0x79000000, 0x18800000, 0x27400000, 0xA7A00000, 0x6AB00000, 0x4B880000, 0xB6A40000, 0xCF160000, 0xC8B50000, 0x19AF8000, 0xE759C000, 0x467DE000, 0xABAB7000, 0xFD7E8800, 0x6B802C00, 0xB0C05A00, 0x45618D00, 0x94D16C80, 0xF4D92640, 0x52BC6FE0, 0x88CA3650, 0x3CAE7B28, 0xFDD9F6BC, 0x323CBDE2, 0x0B8A9753 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x70000000, 0x98000000, 0xFC000000, 0x5E000000, 0x35000000, 0x2F800000, 0xC5C00000, 0xB7600000, 0x4F900000, 0x3FE80000, 0x0BCC0000, 0x42D60000, 0xEC3D0000, 0xA22F8000, 0xDD58C000, 0x51156000, 0x9202F000, 0xFB5E1800, 0x95E10C00, 0x09D1D200, 0x1B49C300, 0xD23C3180, 0x272FF9C0, 0x8AD950A0, 0x18D44710, 0xE3637DB8, 0x7DCECEFC, 0xDB889AA2, 0xF2DD8813 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xD8000000, 0x84000000, 0x2A000000, 0xFD000000, 0x9E800000, 0x26400000, 0xBCA00000, 0x6E500000, 0x77080000, 0x09640000, 0x2E260000, 0xA5150000, 0xA13E8000, 0xDFD9C000, 0x9C2D6000, 0xD1E37000, 0xE863E800, 0x35A26400, 0xD5C3B200, 0xFB73C900, 0x7B8AA680, 0x71365C40, 0x2D3CDC20, 0xEECB2150, 0x3416C568, 0xBEACB5DC, 0xE9A20622, 0x3BC34C51 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0x58000000, 0x44000000, 0xC2000000, 0x5B000000, 0x52800000, 0x31C00000, 0xDAE00000, 0x85700000, 0x29180000, 0x30140000, 0xEA560000, 0xE5050000, 0xF3FF8000, 0x44E84000, 0x07CC6000, 0x6823F000, 0x54E26800, 0x2D83B400, 0x2CB3FE00, 0xCA0B0100, 0x554E4580, 0x841108C0, 0x5C29F560, 0xECAC4DF0, 0x9A1325C8, 0xFCDB4A1C, 0x0507E362, 0xBE0CB8F3 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x18000000, 0x84000000, 0xBA000000, 0x31000000, 0x13800000, 0xB9C00000, 0x2AA00000, 0x9F500000, 0xED980000, 0x34A40000, 0xF1520000, 0x9AD50000, 0x465B8000, 0x27494000, 0xDFFD2000, 0x1FD67000, 0xA396A800, 0x97F7C400, 0x5687AA00, 0xC90F3300, 0x87D34180, 0x52952A40, 0x403B6120, 0x6B384070, 0x3DF47EE8, 0x7BCB0314, 0xFAF1E322, 0x0A49F773 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xD0000000, 0x18000000, 0x14000000, 0xAE000000, 0x3F000000, 0x92800000, 0xC4400000, 0xC6E00000, 0x2A300000, 0x7A580000, 0x22840000, 0x8E320000, 0xC8D50000, 0xF41A8000, 0x09E9C000, 0x301D2000, 0xE916F000, 0xFCB68800, 0x1EE6EC00, 0x48CF1600, 0x83F29900, 0x1EF52680, 0x5F8B50C0, 0x7FE0F8E0, 0x1BB16370, 0xEE98CE68, 0x7525EF54, 0x7963E6E2, 0xE57CD671 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0xB0000000, 0x18000000, 0x3C000000, 0x8A000000, 0xE7000000, 0x78800000, 0x1FC00000, 0x35A00000, 0x89900000, 0xFF680000, 0xC4140000, 0xC9220000, 0x26A50000, 0xC51B8000, 0x43F9C000, 0x38FCE000, 0x3076F000, 0x8AE61800, 0x030FA400, 0x59DBF600, 0x18D8C500, 0x13ADE180, 0xCD3F7240, 0x842210A0, 0xA9258790, 0x6A5B8808, 0xFD98D814, 0x2ACC7EA2, 0x178F2693 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xB0000000, 0x78000000, 0x9C000000, 0x06000000, 0x1D000000, 0x3E800000, 0xAB400000, 0x50600000, 0x56900000, 0x19E80000, 0x72CC0000, 0xE0F20000, 0x0BBD0000, 0xDC4A8000, 0x96B84000, 0xBE05E000, 0x7DCFB000, 0xC8B75800, 0xE8937C00, 0x312DC200, 0x1BA2D100, 0xD574BC80, 0x1E76F5C0, 0x5C327FA0, 0x7C1D7D10, 0x9EFB33B8, 0xF820FBB4, 0xE97065A2, 0xB4B99011 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0xF0000000, 0xD8000000, 0x3C000000, 0x76000000, 0xED000000, 0x95800000, 0xC1400000, 0x89200000, 0xF2300000, 0xCB380000, 0x6F640000, 0xDE9E0000, 0x80F50000, 0x4D568000, 0x75C8C000, 0x703D6000, 0xACEA7000, 0xA2629800, 0x187EDC00, 0x0225E200, 0x49BF6700, 0x9BC4C880, 0xA9EE9140, 0x98ED82E0, 0x6302AA30, 0xFCEE57A8, 0x816D40CC, 0xEC4278E2, 0x54CED131 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x48000000, 0x44000000, 0x3E000000, 0xE3000000, 0x22800000, 0x6EC00000, 0xCC200000, 0x20D00000, 0x33D80000, 0xE5640000, 0x76D20000, 0xA6150000, 0x429B8000, 0x14C84000, 0xBD1C2000, 0xB027D000, 0xC97E2800, 0x16DA6C00, 0x7A288E00, 0x8BED5900, 0xAE2F6B80, 0x96436540, 0x8D2C7820, 0x360E0DF0, 0x60939468, 0xC9F46494, 0x87EB5E22, 0xDF8078F3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x68000000, 0xCC000000, 0x8A000000, 0xAD000000, 0x37800000, 0x6C400000, 0x22E00000, 0x86100000, 0x41580000, 0x98340000, 0xC2620000, 0x34450000, 0xC7EB8000, 0x1A084000, 0xEE0D2000, 0x71079000, 0x781E3800, 0x44CB4400, 0x87B90200, 0x38251B00, 0x543AB280, 0x0EF0C2C0, 0xFA4808A0, 0x26EC5170, 0xAA16BD48, 0x36C73BF4, 0x14BEB2A2, 0x213B4E73 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0x38000000, 0x8C000000, 0x6E000000, 0x33000000, 0xB2800000, 0x18C00000, 0xDFA00000, 0x14D00000, 0x40C80000, 0x9E9C0000, 0x717E0000, 0x566D0000, 0x42278000, 0xA6D94000, 0x08F56000, 0xC8B23000, 0xD89AF800, 0x78362C00, 0x16B1BE00, 0x36389900, 0x16C48780, 0xA74B5240, 0x967EAC20, 0x96EC1CD0, 0x6FE70B98, 0x3CF8F1EC, 0x6C646A22, 0x9E1AE9D3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x68000000, 0xA4000000, 0xCA000000, 0x57000000, 0xD4800000, 0xAF400000, 0x8EE00000, 0xAAD00000, 0xCA480000, 0x876C0000, 0x88160000, 0x7EDD0000, 0xC64F8000, 0x25D9C000, 0x44C56000, 0x092A1000, 0x2FC2A800, 0xB71FC400, 0xF851A600, 0x9C099D00, 0x200D0080, 0x7E07CCC0, 0x29B50720, 0x6E537B50, 0x89B70878, 0x8AECBD3C, 0xDED78922, 0xD4FDE253 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x50000000, 0xC8000000, 0x74000000, 0x7E000000, 0x1F000000, 0xC0800000, 0x86400000, 0x46600000, 0x25F00000, 0xD2180000, 0x908C0000, 0x33060000, 0x3E9D0000, 0x1F2E8000, 0xC9A84000, 0xA8F42000, 0xE47AD000, 0x9A834800, 0xD8BEEC00, 0xC8401600, 0x21601D00, 0xA9714280, 0xC658D5C0, 0x0BECC360, 0xC37702F0, 0xCB4529F8, 0x9003F1BC, 0xDFFF1D62, 0xA1A0B3F1 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0x48000000, 0xFC000000, 0xDE000000, 0x83000000, 0x77800000, 0xB4C00000, 0x58200000, 0xAF500000, 0xCD980000, 0xC64C0000, 0x88E20000, 0x55FD0000, 0x3A0B8000, 0xAD784000, 0x373D2000, 0x7D2BD000, 0x5BA85800, 0xD564AC00, 0x20C7BE00, 0xEADAF300, 0x48207F80, 0x87516740, 0xC1986B20, 0x004C1D70, 0xBFE35538, 0x007CA774, 0xD3CAAD22, 0x01D99273 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x70000000, 0xF8000000, 0xDC000000, 0xCA000000, 0xE1000000, 0xEE800000, 0x43C00000, 0x4C600000, 0xC6B00000, 0xF5980000, 0x99AC0000, 0x10EA0000, 0x78BD0000, 0xFBA38000, 0x1C394000, 0x007D6000, 0xD043B000, 0x03C85800, 0x6445E400, 0xCC3E3A00, 0x398BA900, 0xF68C3580, 0xBEFB3DC0, 0x6A753EE0, 0x496621F0, 0x6FC66B38, 0xCF970164, 0xF97E3CE2, 0x7A2BDCF3 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x28000000, 0x3C000000, 0xA2000000, 0x7F000000, 0xC3800000, 0x53400000, 0x34600000, 0x44300000, 0xBB680000, 0xC06C0000, 0xF6420000, 0x0F7D0000, 0xC77A8000, 0x3B49C000, 0x27BCE000, 0xA45A9000, 0xAD191800, 0x21E59400, 0xD5DE4600, 0xEAF7A300, 0xA17B8880, 0x8248D7C0, 0x4D3D4AE0, 0xE59B1010, 0xFCB9C7B8, 0x8275D0D4, 0x2C26F4E2, 0xCDE3B711 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xF0000000, 0xB8000000, 0x1C000000, 0x46000000, 0x6D000000, 0x5A800000, 0x49C00000, 0x67200000, 0x1A300000, 0x1E480000, 0xF6240000, 0x492A0000, 0x16F50000, 0x08738000, 0x73A84000, 0x28B46000, 0x1C123000, 0x1778D800, 0x03EC7C00, 0x4A4FA200, 0xEC3ED900, 0x8117B980, 0x2A638340, 0x92500BE0, 0xFC9878D0, 0x107C8528, 0xB5F61944, 0x1C7311E2, 0xF1A8EDD3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x50000000, 0xC8000000, 0x5C000000, 0x8A000000, 0xB1000000, 0xA2800000, 0x59C00000, 0xC5200000, 0x26B00000, 0xC2C80000, 0xB7A40000, 0x3F4E0000, 0x29F50000, 0x30178000, 0x25284000, 0x27B52000, 0xD076D000, 0x58791800, 0xCF6D0400, 0x01EA9A00, 0x703BF100, 0x5E22C180, 0xB71FB740, 0xBDAC8AE0, 0x7F4A9DD0, 0x01CBAF28, 0x120B548C, 0xC62A28E2, 0x121AB8D3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0xF8000000, 0x34000000, 0x9E000000, 0x3D000000, 0x78800000, 0xFCC00000, 0xF5200000, 0x3B500000, 0xC2180000, 0x07C40000, 0x37760000, 0x03750000, 0x1A1F8000, 0xC7784000, 0xCB74E000, 0x161EB000, 0xCD780800, 0xD8754C00, 0xAB9F5200, 0x7D39AD00, 0x4F95F380, 0x58EE3340, 0xFCF0D320, 0x76886470, 0x9D7DA028, 0xF3A24F5C, 0xADFB6922, 0x47DE3573 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x30000000, 0xC8000000, 0x4C000000, 0x86000000, 0xEB000000, 0xA8800000, 0xFDC00000, 0xB9A00000, 0x16300000, 0x72280000, 0xC6FC0000, 0x714E0000, 0x1EAD0000, 0xA1F78000, 0x6FC84000, 0xC92DE000, 0x06B6D000, 0x62A9F800, 0xDF3D1C00, 0x92EE0E00, 0x9D9D3D00, 0x145E3D80, 0x3674FA40, 0x91033BE0, 0xF40B9110, 0xF2068898, 0x4040A14C, 0x43E12DE2, 0x90D16013 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0xF8000000, 0x5C000000, 0x46000000, 0xE7000000, 0x49800000, 0x03C00000, 0x20E00000, 0x7CB00000, 0x0D780000, 0x5CD40000, 0x93E60000, 0x61450000, 0xFFCF8000, 0x04D84000, 0xE0C56000, 0x380EB000, 0xEE395800, 0xB574FC00, 0x3FF63600, 0xE2ADFF00, 0xA4B3B980, 0xAC622AC0, 0x26EA12E0, 0xD2E7A530, 0xDFC54BC8, 0x9D8E66BC, 0xF3F81CE2, 0x5E941633 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x08000000, 0x8C000000, 0x4A000000, 0x07000000, 0x2A800000, 0x6EC00000, 0x59600000, 0x2E700000, 0x44680000, 0xC3E40000, 0x88260000, 0x34350000, 0xAA5F8000, 0xE249C000, 0x12B56000, 0x4E9ED000, 0xDC28F800, 0x66450400, 0x6C37D600, 0xCAAD2100, 0x8A134380, 0x1B6A3FC0, 0x89967560, 0x8EBC6410, 0x648B3628, 0x4326E11C, 0xF4B43B62, 0xD39E9113 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0xA4000000, 0x02000000, 0xD1000000, 0x3C800000, 0xE8400000, 0x52A00000, 0xF9F00000, 0x1DD80000, 0x500C0000, 0xF3160000, 0x321D0000, 0x111E8000, 0x9279C000, 0x4B7CA000, 0x118EB000, 0xCF306800, 0x2638F400, 0x9FDC2A00, 0x4B7E5D00, 0x17690280, 0x3EF51440, 0x702AE760, 0x01321CF0, 0x0FDEDAF8, 0x3598051C, 0x22AC0562, 0x7AE705F1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0xAC000000, 0xFE000000, 0x7D000000, 0x35800000, 0x49400000, 0x22200000, 0x81700000, 0x5DD80000, 0xB5BC0000, 0x3CB20000, 0x9AAD0000, 0x4BBA8000, 0x7CF9C000, 0x3C4C2000, 0x7DAA7000, 0x1470F800, 0x8C59CC00, 0x96FD6200, 0x61933700, 0xF55DD880, 0xBBA3F740, 0x69A5AC60, 0x97EE25F0, 0x2C0F7298, 0x7F9E2854, 0x06561662, 0x3863AEF1 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0x68000000, 0x74000000, 0x4E000000, 0xD9000000, 0x37800000, 0xC2C00000, 0xA0E00000, 0x68B00000, 0x83480000, 0x4C140000, 0x9F660000, 0x2B850000, 0xCDFE8000, 0x67A94000, 0xB2A52000, 0x292E9000, 0xD2104800, 0x1B58CC00, 0x384D1A00, 0x75AB5300, 0x416FE780, 0x11B046C0, 0x24C908E0, 0xC6D41550, 0x9B875648, 0x653485DC, 0xE3B77AE2, 0x523C1A51 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0xF0000000, 0xC8000000, 0xD4000000, 0x32000000, 0x87000000, 0xC2800000, 0xE7400000, 0xF6600000, 0x29700000, 0xEBC80000, 0x29C40000, 0x3C5A0000, 0xBA950000, 0xC4028000, 0x47A9C000, 0x83B56000, 0x7F135000, 0x1F114800, 0xE2B97400, 0x520C6600, 0x2D9E0100, 0x9ACE5080, 0x989641C0, 0x36AAB860, 0x819D9550, 0xD967B468, 0x712279A4, 0x22B8F662, 0x720CB051 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xD0000000, 0x18000000, 0xEC000000, 0xC2000000, 0x5B000000, 0xB2800000, 0x0B400000, 0x76600000, 0xBD700000, 0xFCF80000, 0x61F40000, 0x6D2E0000, 0x40A50000, 0x6F468000, 0x73184000, 0x9D452000, 0x70F77000, 0xE0417800, 0xECE13400, 0x32302E00, 0x6C994100, 0xB1849080, 0x565651C0, 0x0191E860, 0x96C92330, 0x416D9C08, 0xCEAA952C, 0x55F39E62, 0x30572631 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0xF0000000, 0xC8000000, 0x7C000000, 0x02000000, 0xAB000000, 0xBB800000, 0xEAC00000, 0x3F600000, 0xE0700000, 0x22080000, 0xD4940000, 0x15FA0000, 0x50450000, 0xFC628000, 0x01E84000, 0xEFA56000, 0x9552D000, 0x12401800, 0xA2211400, 0x5FD0EE00, 0xDA189300, 0x676D1380, 0xDEA7F1C0, 0x17CB1160, 0x186CECD0, 0x0B26DEC8, 0xCC0A1A64, 0x738C8762, 0x0C16BBD1 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xC8000000, 0x54000000, 0x52000000, 0x83000000, 0x49800000, 0xB8400000, 0x01200000, 0x64300000, 0x3A180000, 0xB4D40000, 0xDDDA0000, 0x4C850000, 0x4A528000, 0x0CB9C000, 0x05A46000, 0x3A635000, 0x04A14800, 0x4271B400, 0x66396E00, 0xA464D700, 0x5B03E680, 0x8DB13940, 0xD2599CE0, 0x6DF5B070, 0x55EBD2C8, 0xB89C2F04, 0x7B87DAE2, 0x49E28371 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x90000000, 0xA8000000, 0x24000000, 0x76000000, 0x1B000000, 0x54800000, 0xDAC00000, 0x58E00000, 0x56D00000, 0x5A980000, 0x7C040000, 0x209A0000, 0xA9F50000, 0x39B38000, 0xF2F9C000, 0x4614A000, 0x59E39000, 0x47A06800, 0x31703C00, 0x5BE8BE00, 0x7FED6500, 0x4376D380, 0x108350C0, 0x60317420, 0xAB4972F0, 0x781D1CA8, 0xF75F3184, 0x640F0222, 0x01D6BBF3 } , 
  { 0x80000000, 0x40000000, 0xA0000000, 0x90000000, 0x68000000, 0x74000000, 0x8E000000, 0x27000000, 0x19800000, 0x54400000, 0x85600000, 0xA6500000, 0x25980000, 0x5D3C0000, 0x96620000, 0xB3CD0000, 0x848A8000, 0x48584000, 0x5C1DA000, 0x7D539000, 0xD404C800, 0x1A2F4C00, 0xD006E600, 0xEE338F00, 0x3954F680, 0x843731C0, 0xFC7B4820, 0x51B197F0, 0xBC0921D8, 0x44841574, 0xA0EE4622, 0xD0A684F1 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x10000000, 0x88000000, 0x54000000, 0x56000000, 0x4F000000, 0x5A800000, 0xB9400000, 0xEDA00000, 0xD7500000, 0xE0180000, 0x20F40000, 0x0C6A0000, 0x31C50000, 0x1BC38000, 0x6DD8C000, 0xD715A000, 0x161AD000, 0x6ACD8800, 0xA90E3C00, 0x38D6F600, 0x1DC2B900, 0x8AD9BC80, 0x2995A640, 0x615A8020, 0x146C1D70, 0x26DFCE48, 0x788EF064, 0xC517DE22, 0xB2228873 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xB8000000, 0x94000000, 0xD2000000, 0x33000000, 0x71800000, 0xC1C00000, 0x9E200000, 0xBAB00000, 0x44A80000, 0xD93C0000, 0xE1B60000, 0xC5ED0000, 0xDC4E8000, 0x72E9C000, 0x47DDA000, 0x77A7B000, 0xA3B50800, 0x323A5400, 0x28F28E00, 0x7C9FE700, 0xB111D580, 0x85D99740, 0x7CB5C2E0, 0x25BAAB10, 0xF832D818, 0x883FA3BC, 0x97E164E2, 0xD8916811 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0xD0000000, 0xB8000000, 0xBC000000, 0xDE000000, 0x29000000, 0x2E800000, 0x41400000, 0x09600000, 0x86B00000, 0x86680000, 0xB3F40000, 0x7DCA0000, 0xBFE50000, 0x13328000, 0xB0A94000, 0xFD552000, 0x975B3000, 0x045DD800, 0xEF1E4C00, 0x437E6A00, 0x3D4FC100, 0x27666080, 0xB97357C0, 0xF04923E0, 0xA5242410, 0x1B926388, 0x1F3833C4, 0x0E6D31E2, 0xBF37D911 } , 
  { 0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xD8000000, 0x6C000000, 0xF6000000, 0x7D000000, 0xFA800000, 0xC1C00000, 0x33A00000, 0x42900000, 0xEDB80000, 0xEB640000, 0xCB3A0000, 0x5D150000, 0xA8728000, 0xB3F9C000, 0xAF84E000, 0xDDCB7000, 0x549DB800, 0xA2BEDC00, 0x25DFE200, 0x6A6FF900, 0x26878980, 0xC4FA6A40, 0x0FB47AA0, 0x5E620E30, 0xBE8182E8, 0xA3C15084, 0x84A040A2, 0xDB119B31 } , 
  { 0x80000000, 0xC0000000, 0xE0000000, 0x30000000, 0xD8000000, 0x2C000000, 0x76000000, 0x57000000, 0x67800000, 0xB9C00000, 0xDCA00000, 0xB9900000, 0x1C880000, 0x7E940000, 0x5A7E0000, 0x41E50000, 0x38078000, 0x9BC8C000, 0x1775E000, 0x9F0E7000, 0x129D3800, 0xDAAADC00, 0xAEFA3600, 0xF4D2C300, 0xF2D72D80, 0xB4A00E40, 0x8D917CA0, 0xA6896650, 0x6F942508, 0xB2FE546C, 0xB3A412A2, 0x2B67C953 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x10000000, 0xB8000000, 0x1C000000, 0xE2000000, 0x11000000, 0x8E800000, 0xF8400000, 0x56E00000, 0x95F00000, 0x9CD80000, 0x4AAC0000, 0xE1EA0000, 0x5D7D0000, 0xF7638000, 0xB699C000, 0x054DA000, 0x2E9BB000, 0x6FE51800, 0xBC2F3400, 0xA303DA00, 0x41287900, 0xA275E280, 0x8D4768C0, 0x43974F60, 0x6F9E7E70, 0x3A3B1FB8, 0x71F48CE4, 0x0187AD62, 0x90374373 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0x58000000, 0xCC000000, 0x62000000, 0x8B000000, 0x6A800000, 0x6CC00000, 0xB8600000, 0x8A100000, 0xD1380000, 0xCAD40000, 0x4CF60000, 0x4CE50000, 0xD07F8000, 0xE3F94000, 0x53B52000, 0x9366F000, 0x659C3800, 0x7F0BF400, 0xB0FFCE00, 0x20383100, 0x0754BF80, 0x58B6DDC0, 0x1B4419A0, 0x1C8F6CB0, 0x7A104888, 0x1939101C, 0x7ED54FA2, 0xB2F719B3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x70000000, 0x08000000, 0xFC000000, 0x3E000000, 0x97000000, 0x56800000, 0xBFC00000, 0xB5A00000, 0x5D900000, 0xD7F80000, 0x95F40000, 0xC79E0000, 0xB6850000, 0xFE978000, 0x05384000, 0x4BD56000, 0xF64F5000, 0xEC9C1800, 0x0913EC00, 0xD62E9600, 0x41ACB100, 0xA4FA8180, 0x6E629E40, 0x8527C8A0, 0xD711C2B0, 0xE63899C8, 0x1F55BD4C, 0x408FA6A2, 0xE8BD8FB3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x70000000, 0xA8000000, 0xD4000000, 0x4E000000, 0x9F000000, 0xC2800000, 0x39C00000, 0x26A00000, 0x16700000, 0xF0A80000, 0xE78C0000, 0x286E0000, 0x7E1D0000, 0xE4D68000, 0x0268C000, 0x0DAC6000, 0x78DE9000, 0x1A944800, 0x84EB4C00, 0x280E5600, 0xCC4C7900, 0xDBCF5D80, 0x43EC4040, 0x7C3FF360, 0x0A04AA10, 0x29D332F8, 0xD53BF00C, 0x9B570D62, 0x6429CF11 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0xBC000000, 0xA6000000, 0x1D000000, 0x7B800000, 0x16400000, 0x2E200000, 0xAA700000, 0x60F80000, 0xE1540000, 0x87B20000, 0xE5C50000, 0x26DA8000, 0x22794000, 0xF694A000, 0x34D2F000, 0x4F145800, 0x65937C00, 0x81B40200, 0xAF231B00, 0xFAADE680, 0x60677340, 0x3FB7C460, 0xB37E7FB0, 0x64F25D48, 0x04654014, 0xF8EBBE62, 0x7BA0A8B1 } , 
  { 0x80000000, 0xC0000000, 0x20000000, 0x50000000, 0xC8000000, 0x64000000, 0xDE000000, 0xF5000000, 0x77800000, 0xBCC00000, 0x0E200000, 0x6E500000, 0x6FF80000, 0x0E540000, 0x03260000, 0x24650000, 0x31EF8000, 0x78794000, 0x02952000, 0xB507D000, 0xB6356800, 0x2C17AC00, 0x392C6200, 0x5D327300, 0xAF224380, 0x42BA1B40, 0x88DF4920, 0x343181B0, 0xE7C96308, 0x7B9DF23C, 0x47BAE322, 0xA75FCEB3 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x30000000, 0x28000000, 0xEC000000, 0xAA000000, 0x97000000, 0xE7800000, 0x93C00000, 0x5CE00000, 0xEB700000, 0x03C80000, 0x2DBC0000, 0x562E0000, 0xBB6D0000, 0x4D378000, 0xACC9C000, 0x9E3DE000, 0xFBEE9000, 0x2E8CB800, 0xB8C68400, 0x0A413600, 0xA6217B00, 0xF9109980, 0x55F8CEC0, 0xFFD5F560, 0x69424850, 0x105A1698, 0x8CFE224C, 0x5A741B62, 0xD593E753 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0x90000000, 0x58000000, 0x9C000000, 0x9A000000, 0xA1000000, 0x89800000, 0x3A400000, 0xF8E00000, 0xA7B00000, 0xCC880000, 0x25DC0000, 0xFAE20000, 0x2E4D0000, 0x81FB8000, 0xBA884000, 0xB6DCA000, 0x2663F000, 0x538D1800, 0xBC5A0400, 0xCB583A00, 0x55248700, 0x2516C680, 0x6023FAC0, 0xC16C3FE0, 0xD2EAD2D0, 0xDA5043D8, 0x14B94A54, 0x80143DE2, 0x5B5EE1D3 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xB0000000, 0x28000000, 0xE4000000, 0x1A000000, 0xE5000000, 0xA4800000, 0xBD400000, 0xE8E00000, 0xF7700000, 0x84980000, 0x71840000, 0x79DE0000, 0xD4D50000, 0xB8178000, 0xB4984000, 0x9984E000, 0x3DDF1000, 0x7ED5A800, 0x7517E400, 0xF4184200, 0x3EC59D00, 0x303FA080, 0x2D2530C0, 0x4CCF7060, 0x6D7C9AF0, 0xB06A90E8, 0x60735A0C, 0xE4B7FA62, 0x8188B3F3 } , 
  { 0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x5C000000, 0x26000000, 0x43000000, 0xE2800000, 0x94400000, 0xFB600000, 0x71500000, 0x92B80000, 0x8B1C0000, 0x4B2E0000, 0xE9A50000, 0xB8328000, 0xC68B4000, 0x3397A000, 0x4FB9D000, 0x2E9C5800, 0x6FEE3C00, 0xAF850E00, 0xBD83A100, 0x4CA21A80, 0x819359C0, 0xD2FB5920, 0x761F6630, 0xC2CC96D8, 0x78D6694C, 0x105943A2, 0xB88C3FF1 } , 
  { 0x80000000, 0xC0000000, 0x60000000, 0x70000000, 0x08000000, 0x74000000, 0xCE000000, 0xFF000000, 0xF6800000, 0xA1C00000, 0xD5A00000, 0xFE100000, 0x83380000, 0x0ED40000, 0xE13A0000, 0xB5ED0000, 0x33EF8000, 0xFED7C000, 0xCF026000, 0xB8B85000, 0xDC954800, 0x32DBAC00, 0x461CE600, 0xC4270900, 0x8D4A0980, 0x46644440, 0x6093FCA0, 0xC0C1CBB0, 0x0421E548, 0xC5515564, 0x3559F522, 0x68658FF3 } , 
  { 0x80000000, 0x40000000, 0xE0000000, 0x90000000, 0x18000000, 0xDC000000, 0x6A000000, 0x21000000, 0x02800000, 0x37C00000, 0x34E00000, 0xD1300000, 0xEEF80000, 0x70AC0000, 0xC48A0000, 0xB2550000, 0x16268000, 0x73DEC000, 0x80F2A000, 0x01387000, 0x384DD800, 0x0FBA0400, 0xF5ADEA00, 0xA00BD900, 0x36958180, 0x4D475AC0, 0xE5AF7AE0, 0x902AC6B0, 0xFCC5E178, 0xD5CE0544, 0x15DAFB62, 0xB15D9C71 } , 
  { 0x80000000, 0xC0000000, 0xA0000000, 0xD0000000, 0x18000000, 0xAC000000, 0x9E000000, 0xFF000000, 0xEB800000, 0x8F400000, 0x7DE00000, 0x84700000, 0xD2580000, 0x9CFC0000, 0xB5160000, 0xD