/*
 * Decompiled with CFR 0.152.
 */
package dag;

import blbutil.FileIt;
import dag.Dag;
import dag.DagLevel;
import dag.ImmutableDag;
import dag.MergeableDagLevel;
import dag.Score;
import haplotype.HapPairs;
import haplotype.HapsMarkerIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import vcf.HapsMarker;

public final class MergeableDag {
    private static final Score MAX_SCORE = new Score(-1, -1, Float.POSITIVE_INFINITY, false);
    private static final float MAX_THRESHOLD_RATIO = 1.4f;
    private static final int MIN_DEPTH = 10;
    private final float scale;
    private final Dag dag;
    private float nUnmergedAtLeaf = 0.0f;

    public static Dag dag(HapPairs hapPairs, float[] fArray, float f, int n) {
        MergeableDag mergeableDag = new MergeableDag(hapPairs, fArray, f, n);
        return mergeableDag.dag();
    }

    private MergeableDag(HapPairs hapPairs, float[] fArray, float f, int n) {
        MergeableDag.checkParameters(hapPairs, fArray, f, n);
        this.scale = f;
        ArrayList<DagLevel> arrayList = new ArrayList<DagLevel>(hapPairs.nMarkers());
        float f2 = MergeableDag.maxUnmergedAtLeaf(hapPairs, fArray);
        int n2 = n;
        try (HapsMarkerIterator hapsMarkerIterator = new HapsMarkerIterator(hapPairs);){
            Object object;
            MergeableDagLevel mergeableDagLevel = MergeableDag.readFirstLevel(hapsMarkerIterator, fArray);
            MergeableDagLevel mergeableDagLevel2 = MergeableDag.readLevels(hapsMarkerIterator, n, mergeableDagLevel);
            while (mergeableDagLevel.next() != null) {
                int n3;
                float f3;
                int n4;
                this.nUnmergedAtLeaf = 0.0f;
                mergeableDagLevel = mergeableDagLevel.next();
                this.mergeParentNodes(mergeableDagLevel);
                object = mergeableDagLevel.setPreviousToNull();
                arrayList.add(((MergeableDagLevel)object).toDagLevel());
                if (!hapsMarkerIterator.hasNext() || (n4 = MergeableDag.nextReadDepth(f3 = this.nUnmergedAtLeaf / f2, n3 = mergeableDagLevel2.index() - mergeableDagLevel.index(), n2)) <= n3) continue;
                mergeableDagLevel2 = MergeableDag.readLevels(hapsMarkerIterator, n4 - n3, mergeableDagLevel2);
                n2 = n4;
            }
            arrayList.add(mergeableDagLevel.toDagLevel());
            object = arrayList.toArray(new DagLevel[0]);
            this.dag = new ImmutableDag(hapPairs.markers(), (DagLevel[])object);
        }
    }

    private static void checkParameters(HapPairs hapPairs, float[] fArray, float f, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (hapPairs.nMarkers() == 0) {
            throw new IllegalArgumentException("hapPairs.nMarkers()==0");
        }
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                float f2 = fArray[i];
                if (!((double)f2 <= 0.0) && Float.isFinite(f2)) continue;
                throw new IllegalArgumentException(String.valueOf(f2));
            }
        }
        if (f <= 0.0f || !Float.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
    }

    private static MergeableDagLevel readFirstLevel(FileIt<HapsMarker> fileIt, float[] fArray) {
        HapsMarker hapsMarker = (HapsMarker)fileIt.next();
        if (fArray == null) {
            return new MergeableDagLevel(hapsMarker);
        }
        return new MergeableDagLevel(hapsMarker, fArray);
    }

    private static float maxUnmergedAtLeaf(HapPairs hapPairs, float[] fArray) {
        float f = 0.01f;
        float f2 = fArray == null ? (float)hapPairs.nHaps() : MergeableDag.sum(fArray);
        return f * f2;
    }

    private static int nextReadDepth(float f, int n, int n2) {
        if (f <= 1.0f) {
            return 10;
        }
        if ((double)n < 0.85 * (double)n2) {
            return 1 + (int)Math.round(0.95 * (double)n2);
        }
        if (f > 2.0f && (double)n > 0.95 * (double)n2) {
            return (int)Math.ceil((1.0f + f / 20.0f) * (float)n2);
        }
        return n2;
    }

    private static MergeableDagLevel readLevels(FileIt<HapsMarker> fileIt, int n, MergeableDagLevel mergeableDagLevel) {
        for (int i = 0; fileIt.hasNext() && i < n; ++i) {
            HapsMarker hapsMarker = (HapsMarker)fileIt.next();
            MergeableDagLevel mergeableDagLevel2 = new MergeableDagLevel(mergeableDagLevel, hapsMarker);
            mergeableDagLevel.setNextLevel(mergeableDagLevel2);
            mergeableDagLevel = mergeableDagLevel2;
        }
        return mergeableDagLevel;
    }

    private static float sum(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        return f;
    }

    private void mergeParentNodes(MergeableDagLevel mergeableDagLevel) {
        LinkedList<Score> linkedList = new LinkedList<Score>();
        Score score = this.getPairwiseScores(mergeableDagLevel, linkedList);
        while (score.isMergeable()) {
            int n = score.nodeA();
            int n2 = score.nodeB();
            if (!mergeableDagLevel.hasSibling(n)) {
                n = score.nodeB();
                n2 = score.nodeA();
                assert (mergeableDagLevel.hasSibling(n));
            } else if (mergeableDagLevel.hasSibling(n2) && mergeableDagLevel.nodeCount(score.nodeA()) < mergeableDagLevel.nodeCount(score.nodeB())) {
                n2 = score.nodeB();
                n = score.nodeA();
            }
            mergeableDagLevel.mergeParentNodes(n, n2);
            score = MAX_SCORE;
            ListIterator<Score> listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                Score score2 = (Score)listIterator.next();
                if (score2.nodeA() == n2 || score2.nodeB() == n2) {
                    listIterator.remove();
                    continue;
                }
                if (score2.nodeA() == n || score2.nodeB() == n) {
                    if ((score2 = this.score(mergeableDagLevel, score2.nodeA(), score2.nodeB())) != null) {
                        if (score2.score() < score.score() && score2.isMergeable()) {
                            score = score2;
                        }
                        listIterator.set(score2);
                        continue;
                    }
                    listIterator.remove();
                    continue;
                }
                if (!(score2.score() < score.score()) || !score2.isMergeable()) continue;
                score = score2;
            }
        }
    }

    private Score getPairwiseScores(MergeableDagLevel mergeableDagLevel, List<Score> list) {
        Score score = MAX_SCORE;
        SortedNodes sortedNodes = this.sortedParents(mergeableDagLevel);
        int[] nArray = sortedNodes.sorted;
        int n = sortedNodes.nWithSibs;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            for (int j = i + 1; j < nArray.length; ++j) {
                int n3 = nArray[j];
                Score score2 = this.score(mergeableDagLevel, n2, n3);
                if (score2 == null) continue;
                if (score2.score() < score.score() && score2.isMergeable()) {
                    score = score2;
                }
                list.add(score2);
            }
        }
        return score;
    }

    private SortedNodes sortedParents(MergeableDagLevel mergeableDagLevel) {
        int[] nArray = mergeableDagLevel.parentNodeArray();
        int n = 0;
        int n2 = nArray.length - 1;
        while (n < n2) {
            if (mergeableDagLevel.hasSibling(nArray[n])) {
                ++n;
                continue;
            }
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2--] = n3;
        }
        if (mergeableDagLevel.hasSibling(nArray[n])) {
            ++n;
        }
        return new SortedNodes(nArray, n);
    }

    private Score score(MergeableDagLevel mergeableDagLevel, int n, int n2) {
        float f = 0.0f;
        float f2 = mergeableDagLevel.nodeCount(n);
        float f3 = mergeableDagLevel.nodeCount(n2);
        float f4 = (float)((double)this.scale * Math.sqrt(1.0 / (double)f2 + 1.0 / (double)f3));
        f = this.similar(mergeableDagLevel, n, n2, f2, f3, mergeableDagLevel.index(), f2, f3, f, f4);
        if (f > 1.4f * f4) {
            return null;
        }
        boolean bl = f < f4;
        return new Score(n, n2, f, bl);
    }

    private float similar(MergeableDagLevel mergeableDagLevel, int n, int n2, float f, float f2, int n3, float f3, float f4, float f5, float f6) {
        float f7 = f / f3;
        float f8 = f2 / f4;
        float f9 = Math.abs(f7 - f8);
        if (f9 >= f6) {
            return f9;
        }
        if (f7 <= f5 && f8 <= f5) {
            return f5;
        }
        if (f9 > f5) {
            f5 = f9;
        }
        if (n == -1 ^ n2 == -1) {
            return f5;
        }
        if (mergeableDagLevel == null) {
            this.nUnmergedAtLeaf += f + f2;
            return f5;
        }
        int n4 = mergeableDagLevel.nAlleles();
        for (int i = 0; i < n4; ++i) {
            int n5 = mergeableDagLevel.outEdge(n, i);
            int n6 = mergeableDagLevel.outEdge(n2, i);
            int n7 = n5 != -1 ? mergeableDagLevel.childNode(n5) : -1;
            int n8 = n6 != -1 ? mergeableDagLevel.childNode(n6) : -1;
            f = n5 != -1 ? mergeableDagLevel.edgeCount(n5) : 0.0f;
            f2 = n6 != -1 ? mergeableDagLevel.edgeCount(n6) : 0.0f;
            float f10 = this.similar(mergeableDagLevel.next(), n7, n8, f, f2, n3, f3, f4, f5, f6);
            if (!(f10 > f5)) continue;
            if (f10 >= f6) {
                return f10;
            }
            f5 = f10;
        }
        return f5;
    }

    public Dag dag() {
        return this.dag;
    }

    public String toString() {
        return this.dag.toString();
    }

    private static class SortedNodes {
        public int[] sorted;
        public int nWithSibs;

        public SortedNodes(int[] nArray, int n) {
            this.sorted = nArray;
            this.nWithSibs = n;
        }
    }
}

