/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import java.util.BitSet;
import vcf.Marker;
import vcf.VcfEmission;
import vcf.VcfHeader;
import vcf.VcfRecGTParser;

public final class BitSetRefGT
implements VcfEmission {
    private final int bitsPerAllele;
    private final Marker marker;
    private final Samples samples;
    private final BitSet allele1;
    private final BitSet allele2;

    public BitSetRefGT(VcfHeader vcfHeader, String string) {
        this(new VcfRecGTParser(vcfHeader, string));
    }

    public BitSetRefGT(VcfRecGTParser vcfRecGTParser) {
        this.marker = vcfRecGTParser.marker();
        this.samples = vcfRecGTParser.samples();
        this.bitsPerAllele = BitSetRefGT.bitsPerAllele(this.marker);
        this.allele1 = new BitSet(vcfRecGTParser.nSamples() * this.bitsPerAllele);
        this.allele2 = new BitSet(vcfRecGTParser.nSamples() * this.bitsPerAllele);
        BitSetRefGT.storeAlleles(vcfRecGTParser, this.bitsPerAllele, this.allele1, this.allele2);
    }

    private static int bitsPerAllele(Marker marker) {
        int n = marker.nAlleles() - 1;
        int n2 = 32 - Integer.numberOfLeadingZeros(n);
        return n2;
    }

    private static void storeAlleles(VcfRecGTParser vcfRecGTParser, int n, BitSet bitSet, BitSet bitSet2) {
        int n2 = vcfRecGTParser.nSamples();
        for (int i = 0; i < n2; ++i) {
            int n3 = vcfRecGTParser.allele1();
            int n4 = vcfRecGTParser.allele2();
            if (!vcfRecGTParser.isPhased() || n3 == -1 || n4 == -2) {
                String string = "Unphased or missing reference genotype at marker: " + vcfRecGTParser.marker();
                throw new IllegalArgumentException(string);
            }
            BitSetRefGT.storeAllele(bitSet, i, n, n3);
            BitSetRefGT.storeAllele(bitSet2, i, n, n4);
            if (i + 1 >= n2) continue;
            vcfRecGTParser.nextSample();
        }
    }

    private static void storeAllele(BitSet bitSet, int n, int n2, int n3) {
        int n4 = n * n2;
        int n5 = 1;
        for (int i = 0; i < n2; ++i) {
            if ((n3 & n5) == n5) {
                bitSet.set(n4);
            }
            ++n4;
            n5 <<= 1;
        }
    }

    @Override
    public boolean isPhased(int n) {
        if (n < 0 || n >= this.nSamples()) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return true;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.nSamples();
    }

    @Override
    public int nHapPairs() {
        return this.samples.nSamples();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isRefData() {
        return true;
    }

    @Override
    public float gl(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= this.marker.nAlleles()) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        if (n3 < 0 || n3 >= this.marker.nAlleles()) {
            throw new IndexOutOfBoundsException(String.valueOf(n3));
        }
        boolean bl = n2 == this.allele1(n) && n3 == this.allele2(n);
        return bl ? 1.0f : 0.0f;
    }

    @Override
    public int allele1(int n) {
        return this.allele(this.allele1, this.bitsPerAllele, n);
    }

    @Override
    public int allele2(int n) {
        return this.allele(this.allele2, this.bitsPerAllele, n);
    }

    @Override
    public int allele(int n) {
        int n2 = n / 2;
        return (n & 1) == 0 ? this.allele1(n2) : this.allele2(n2);
    }

    private int allele(BitSet bitSet, int n, int n2) {
        if (n2 >= this.samples.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        int n3 = n * n2;
        int n4 = n3 + n;
        int n5 = 0;
        int n6 = 1;
        for (int i = n3; i < n4; ++i) {
            if (bitSet.get(i)) {
                n5 += n6;
            }
            n6 <<= 1;
        }
        return n5;
    }

    @Override
    public int nAlleles() {
        return this.marker().nAlleles();
    }

    @Override
    public boolean storesNonMajorIndices() {
        return false;
    }

    @Override
    public int majorAllele() {
        String string = "this.storesNonMajorIndices()==false";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public int alleleCount(int n) {
        String string = "this.storesNonMajorIndices()==false";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public int hapIndex(int n, int n2) {
        String string = "this.storesNonMajorIndices()==false";
        throw new UnsupportedOperationException(string);
    }

    public String toString() {
        return this.toVcfRec();
    }
}

