## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  warning = FALSE
)

## ----setup--------------------------------------------------------------------
library(visor)
library(sf)

## ----dummy-data---------------------------------------------------------------
# Define occluder geoemtries
occluders <- st_sfc(
  create_occluder(1, 1, 1, 0.5),
  create_occluder(4, 1, 1.5, 0.7),
  create_occluder(7, 1, 0.8, 0.8),
  create_occluder(2, 5, 2, 1),
  create_occluder(5, 5, 1, 1.5),
  create_occluder(1, 7, 1.2, 0.6),
  create_occluder(7, 7, 1.8, 0.9)
)

# Define the viewpoint source geometry
line <- st_sfc(
  st_linestring(matrix(c(0, 3, 9, 3), ncol = 2, byrow = TRUE))
)

## -----------------------------------------------------------------------------
vpoints <- get_viewpoints(line, density = 1)

## -----------------------------------------------------------------------------
isovist <- get_isovist(vpoints, occluders, ray_num = 160, ray_length = 5,
                       remove_holes = FALSE)

## -----------------------------------------------------------------------------
plot(isovist, col = "blue")
plot(occluders, col = "grey", add = TRUE)
plot(line, col = "lightblue", add = TRUE)
plot(vpoints, col = "red", add = TRUE)

