/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.continuous.MultivariateElasticModel;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.OUDiffusionModelDelegate;
import dr.evomodel.treedatalikelihood.continuous.cdi.ContinuousDiffusionIntegrator;
import dr.math.matrixAlgebra.missingData.MissingOps;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class IntegratedOUDiffusionModelDelegate
extends OUDiffusionModelDelegate {
    public IntegratedOUDiffusionModelDelegate(Tree tree, MultivariateDiffusionModel multivariateDiffusionModel, List<BranchRateModel> list, MultivariateElasticModel multivariateElasticModel) {
        super(tree, multivariateDiffusionModel, list, multivariateElasticModel);
    }

    @Override
    public boolean hasDrift() {
        return true;
    }

    @Override
    public boolean hasActualization() {
        return true;
    }

    @Override
    public boolean hasDiagonalActualization() {
        return false;
    }

    @Override
    public boolean isIntegratedProcess() {
        return true;
    }

    @Override
    public boolean isSymmetric() {
        return false;
    }

    @Override
    public void updateDiffusionMatrices(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int[] nArray, double[] dArray, int n, boolean bl) {
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            if (bl) {
                this.flipMatrixBufferOffset(nArray[i]);
            }
            nArray2[i] = this.getMatrixBufferOffsetIndex(nArray[i]);
        }
        continuousDiffusionIntegrator.updateIntegratedOrnsteinUhlenbeckDiffusionMatrices(this.getEigenBufferOffsetIndex(0), nArray2, dArray, this.getDriftRates(nArray, n), this.getEigenValuesStrengthOfSelection(), this.getEigenVectorsStrengthOfSelection(), n);
    }

    @Override
    public DenseMatrix64F getGradientVarianceWrtVariance(NodeRef nodeRef, ContinuousDiffusionIntegrator continuousDiffusionIntegrator, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, DenseMatrix64F denseMatrix64F) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public double[] getAccumulativeDrift(NodeRef nodeRef, double[] dArray, ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int n) {
        double[] dArray2 = super.getAccumulativeDrift(nodeRef, dArray, continuousDiffusionIntegrator, n);
        assert (n % 2 == 0) : "dimTrait should be twice dimProcess.";
        int n2 = n / 2;
        double[] dArray3 = new double[n2];
        System.arraycopy(dArray2, n2, dArray3, 0, n2);
        return dArray3;
    }

    @Override
    public double[][] getJointVariance(double d, double[][] dArray, double[][] dArray2, double[][] dArray3) {
        double[] dArray4 = this.getEigenValuesStrengthOfSelection();
        DenseMatrix64F denseMatrix64F = MissingOps.wrap(this.getEigenVectorsStrengthOfSelection(), 0, this.dim, this.dim);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.dim, this.dim);
        CommonOps.invert(denseMatrix64F, denseMatrix64F2);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(dArray3);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dim, this.dim);
        CommonOps.mult(denseMatrix64F2, denseMatrix64F3, denseMatrix64F4);
        CommonOps.multTransB(denseMatrix64F4, denseMatrix64F2, denseMatrix64F3);
        int n = this.tree.getExternalNodeCount();
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(this.dim, this.dim);
        double[][] dArray5 = new double[this.dim * n][this.dim * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2;
                int n3;
                double d2 = dArray2[i][i];
                double d3 = dArray2[j][j];
                double d4 = dArray2[i][j];
                for (n3 = 0; n3 < this.dim; ++n3) {
                    for (n2 = 0; n2 < this.dim; ++n2) {
                        double d5 = dArray4[n3];
                        double d6 = dArray4[n2];
                        double d7 = d4 / d5 / d6;
                        d7 += (1.0 - Math.exp(d5 * d4)) * Math.exp(-d5 * d2) / d5 / d5 / d6;
                        d7 += (1.0 - Math.exp(d6 * d4)) * Math.exp(-d6 * d3) / d5 / d6 / d6;
                        d7 -= (1.0 - Math.exp((d5 + d6) * d4)) * Math.exp(-d5 * d2) * Math.exp(-d6 * d3) / d5 / d6 / (d5 + d6);
                        d7 += (1.0 - Math.exp(-d5 * d2)) * (1.0 - Math.exp(-d6 * d3)) / d5 / d6 / d;
                        denseMatrix64F5.set(n3, n2, (d7 += 1.0 / d) * denseMatrix64F3.get(n3, n2));
                    }
                }
                CommonOps.mult(denseMatrix64F, denseMatrix64F5, denseMatrix64F4);
                CommonOps.multTransB(denseMatrix64F4, denseMatrix64F, denseMatrix64F5);
                for (n3 = 0; n3 < this.dim; ++n3) {
                    for (n2 = 0; n2 < this.dim; ++n2) {
                        dArray5[i * this.dim + n3][j * this.dim + n2] = denseMatrix64F5.get(n3, n2);
                    }
                }
            }
        }
        return dArray5;
    }
}

