/*
 * Decompiled with CFR 0.152.
 */
package dr.math.functionEval;

import java.io.PrintStream;

public final class DrMath {
    private static double defaultNumericalPrecision = 0.0;
    private static double smallNumber = 0.0;
    private static int radix = 0;
    private static double machinePrecision = 0.0;
    private static double negativeMachinePrecision = 0.0;
    private static double smallestNumber = 0.0;
    private static double largestNumber = 0.0;
    private static double largestExponentialArgument = 0.0;
    private static final double[] scales = new double[]{1.25, 2.0, 2.5, 4.0, 5.0, 7.5, 8.0, 10.0};
    private static final double[] semiIntegerScales = new double[]{2.0, 2.5, 4.0, 5.0, 7.5, 8.0, 10.0};
    private static final double[] integerScales = new double[]{2.0, 4.0, 5.0, 8.0, 10.0};

    private static void computeLargestNumber() {
        double d = DrMath.getRadix();
        double d2 = 1.0 - d * DrMath.getNegativeMachinePrecision();
        while (!Double.isInfinite(d2)) {
            largestNumber = d2;
            d2 *= d;
        }
    }

    private static void computeMachinePrecision() {
        double d = DrMath.getRadix();
        double d2 = 1.0 / d;
        machinePrecision = 1.0;
        double d3 = 1.0 + machinePrecision;
        while (d3 - 1.0 != 0.0) {
            d3 = 1.0 + (machinePrecision *= d2);
        }
    }

    private static void computeNegativeMachinePrecision() {
        double d = DrMath.getRadix();
        double d2 = 1.0 / d;
        negativeMachinePrecision = 1.0;
        double d3 = 1.0 - negativeMachinePrecision;
        while (d3 - 1.0 != 0.0) {
            d3 = 1.0 - (negativeMachinePrecision *= d2);
        }
    }

    private static void computeRadix() {
        double d;
        double d2;
        double d3 = 1.0;
        while ((d2 = (d = (d3 += d3) + 1.0) - d3) - 1.0 != 0.0) {
        }
        double d4 = 1.0;
        while (radix == 0) {
            d4 += d4;
            d = d3 + d4;
            radix = (int)(d - d3);
        }
    }

    private static void computeSmallestNumber() {
        double d = DrMath.getRadix();
        double d2 = 1.0 / d;
        for (double d3 = 1.0 - d * DrMath.getNegativeMachinePrecision(); d3 != 0.0; d3 *= d2) {
            smallestNumber = d3;
        }
    }

    public static double defaultNumericalPrecision() {
        if (defaultNumericalPrecision == 0.0) {
            defaultNumericalPrecision = Math.sqrt(DrMath.getMachinePrecision());
        }
        return defaultNumericalPrecision;
    }

    public static boolean equal(double d, double d2) {
        return DrMath.equal(d, d2, DrMath.defaultNumericalPrecision());
    }

    public static boolean equal(double d, double d2, double d3) {
        double d4 = Math.max(Math.abs(d), Math.abs(d2));
        return d4 < d3 || Math.abs(d - d2) < d3 * d4;
    }

    public static double getLargestExponentialArgument() {
        if (largestExponentialArgument == 0.0) {
            largestExponentialArgument = Math.log(DrMath.getLargestNumber());
        }
        return largestExponentialArgument;
    }

    public static double getLargestNumber() {
        if (largestNumber == 0.0) {
            DrMath.computeLargestNumber();
        }
        return largestNumber;
    }

    public static double getMachinePrecision() {
        if (machinePrecision == 0.0) {
            DrMath.computeMachinePrecision();
        }
        return machinePrecision;
    }

    public static double getNegativeMachinePrecision() {
        if (negativeMachinePrecision == 0.0) {
            DrMath.computeNegativeMachinePrecision();
        }
        return negativeMachinePrecision;
    }

    public static int getRadix() {
        if (radix == 0) {
            DrMath.computeRadix();
        }
        return radix;
    }

    public static double getSmallestNumber() {
        if (smallestNumber == 0.0) {
            DrMath.computeSmallestNumber();
        }
        return smallestNumber;
    }

    public static void printParameters(PrintStream printStream) {
        printStream.println("Floating-point machine parameters");
        printStream.println("---------------------------------");
        printStream.println(" ");
        printStream.println("radix = " + DrMath.getRadix());
        printStream.println("Machine precision = " + DrMath.getMachinePrecision());
        printStream.println("Negative machine precision = " + DrMath.getNegativeMachinePrecision());
        printStream.println("Smallest number = " + DrMath.getSmallestNumber());
        printStream.println("Largest number = " + DrMath.getLargestNumber());
    }

    public static void reset() {
        defaultNumericalPrecision = 0.0;
        smallNumber = 0.0;
        radix = 0;
        machinePrecision = 0.0;
        negativeMachinePrecision = 0.0;
        smallestNumber = 0.0;
        largestNumber = 0.0;
    }

    public static double roundTo(double d, double d2) {
        return (double)Math.round(d / d2) * d2;
    }

    public static double roundToScale(double d, boolean bl) {
        int n = (int)Math.floor(Math.log(d) / Math.log(10.0));
        double[] dArray = bl ? ((n = Math.max(1, n)) == 1 ? integerScales : (n == 2 ? semiIntegerScales : scales)) : scales;
        double d2 = Math.pow(10.0, n);
        double d3 = d / d2;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d3 <= dArray[i])) continue;
            return dArray[i] * d2;
        }
        return d2;
    }

    public static double smallNumber() {
        if (smallNumber == 0.0) {
            smallNumber = Math.sqrt(DrMath.getSmallestNumber());
        }
        return smallNumber;
    }
}

