/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;

public class DoubleILU
implements DoublePreconditioner {
    private SparseRCDoubleMatrix2D LU;
    private final DoubleMatrix1D y;
    private int[] diagind;
    private final int n;

    public DoubleILU(int n) {
        this.n = n;
        this.y = new DenseDoubleMatrix1D(n);
    }

    public DoubleMatrix1D apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        this.lowerUnitSolve(doubleMatrix1D, this.y);
        return this.upperSolve(this.y, doubleMatrix1D2);
    }

    public DoubleMatrix1D transApply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        this.upperTransSolve(doubleMatrix1D, this.y);
        return this.loverUnitTransSolve(this.y, doubleMatrix1D2);
    }

    public void setMatrix(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.LU = new SparseRCDoubleMatrix2D(this.n, this.n);
        this.LU.assign(doubleMatrix2D);
        if (!this.LU.hasColumnIndexesSorted()) {
            this.LU.sortColumnIndexes();
        }
        this.factor();
    }

    private void factor() {
        int[] nArray = this.LU.getColumnIndexes();
        int[] nArray2 = this.LU.getRowPointers();
        double[] dArray = this.LU.getValues();
        this.diagind = this.findDiagonalIndexes(this.n, nArray, nArray2);
        for (int i = 1; i < this.n; ++i) {
            for (int j = nArray2[i]; j < this.diagind[i]; ++j) {
                int n = nArray[j];
                double d = dArray[this.diagind[n]];
                if (d == 0.0) {
                    throw new RuntimeException("Zero pivot encountered on row " + (j + 1) + " during ILU process");
                }
                int n2 = j;
                double d2 = dArray[n2] / d;
                dArray[n2] = d2;
                double d3 = d2;
                int n3 = nArray2[i] + 1;
                for (int k = this.diagind[n] + 1; k < nArray2[n + 1]; ++k) {
                    while (n3 < nArray2[i + 1] && nArray[n3] < nArray[k]) {
                        ++n3;
                    }
                    if (nArray[n3] != nArray[k]) continue;
                    int n4 = n3;
                    dArray[n4] = dArray[n4] - d3 * dArray[k];
                }
            }
        }
    }

    private int[] findDiagonalIndexes(int n, int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = Sorting.binarySearchFromTo(nArray, i, nArray2[i], nArray2[i + 1] - 1);
            if (nArray3[i] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (i + 1));
        }
        return nArray3;
    }

    private DoubleMatrix1D lowerUnitSolve(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D).elements();
        double[] dArray2 = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        int[] nArray = this.LU.getColumnIndexes();
        int[] nArray2 = this.LU.getRowPointers();
        double[] dArray3 = this.LU.getValues();
        int n = this.LU.rows();
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = nArray2[i]; j < this.diagind[i]; ++j) {
                d += dArray3[j] * dArray2[nArray[j]];
            }
            dArray2[i] = dArray[i] - d;
        }
        return doubleMatrix1D2;
    }

    private DoubleMatrix1D loverUnitTransSolve(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D);
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        int[] nArray = this.LU.getColumnIndexes();
        int[] nArray2 = this.LU.getRowPointers();
        double[] dArray2 = this.LU.getValues();
        int n = this.LU.rows();
        for (int i = n - 1; i >= 0; --i) {
            for (int j = nArray2[i]; j < this.diagind[i]; ++j) {
                int n2 = nArray[j];
                dArray[n2] = dArray[n2] - dArray2[j] * dArray[i];
            }
        }
        return doubleMatrix1D2;
    }

    private DoubleMatrix1D upperSolve(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D).elements();
        double[] dArray2 = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        int[] nArray = this.LU.getColumnIndexes();
        int[] nArray2 = this.LU.getRowPointers();
        double[] dArray3 = this.LU.getValues();
        int n = this.LU.rows();
        for (int i = n - 1; i >= 0; --i) {
            double d = 0.0;
            for (int j = this.diagind[i] + 1; j < nArray2[i + 1]; ++j) {
                d += dArray3[j] * dArray2[nArray[j]];
            }
            dArray2[i] = (dArray[i] - d) / dArray3[this.diagind[i]];
        }
        return doubleMatrix1D2;
    }

    private DoubleMatrix1D upperTransSolve(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D);
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        int[] nArray = this.LU.getColumnIndexes();
        int[] nArray2 = this.LU.getRowPointers();
        double[] dArray2 = this.LU.getValues();
        int n = this.LU.rows();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] / dArray2[this.diagind[i]];
            for (int j = this.diagind[i] + 1; j < nArray2[i + 1]; ++j) {
                int n3 = nArray[j];
                dArray[n3] = dArray[n3] - dArray2[j] * dArray[i];
            }
        }
        return doubleMatrix1D2;
    }
}

