## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(TCRconvertR)

tcr_file <- get_example_path("tenx.csv") # Using built-in example file
tcrs <- read.csv(tcr_file)[c("barcode", "v_gene", "j_gene", "cdr3")]
tcrs

## -----------------------------------------------------------------------------
new_tcrs <- convert_gene(tcrs, frm = "tenx", to = "adaptive")
new_tcrs

## -----------------------------------------------------------------------------
custom_file <- get_example_path("customcols.csv")

custom <- read.csv(custom_file)
custom

## -----------------------------------------------------------------------------
custom_new <- convert_gene(
  custom,
  frm = "tenx",
  to = "imgt",
  verbose = FALSE,
  frm_cols = c("myVgene", "myDgene", "myJgene", "myCgene"),
)
custom_new

## -----------------------------------------------------------------------------
new_tcrs <- convert_gene(
  tcrs,
  frm = "tenx",
  to = "imgt",
  species = "rhesus", # or 'mouse'
  verbose = FALSE
)
new_tcrs

