## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(bitstreamio)

## ----example------------------------------------------------------------------
library(bitstreamio)

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Write bits to a raw vector
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
bs <- bs_open(raw(), "w")
bs_write_bit(bs, c(TRUE , FALSE, FALSE, FALSE))
bs_write_byte(bs, c(0x01, 0x7f))  # write unaligned byte values
bs_write_bit(bs, c(FALSE, FALSE, FALSE, TRUE))

raw_vec <- bs_close(bs)
raw_vec


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Read bits back from raw vector
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
bs <- bs_open(raw_vec, mode = 'r')
bs_read_bit(bs, 4)
bs_read_byte(bs, 2) # unaligned byte read
bs_read_bit(bs, 4)
bs_close(bs)

## -----------------------------------------------------------------------------
filename <- tempfile()

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Write bits to a file
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
con <- file(filename, "wb")
bs  <- bs_open(con, mode = 'w')

bs_write_bit(bs, c(TRUE , FALSE, FALSE, FALSE))
bs_write_byte(bs, c(1, 127))
bs_write_bit(bs, c(FALSE, FALSE, FALSE, TRUE))

bs_close(bs)
close(con)

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Read the bits back in
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
con <- file(filename, "rb")
bs  <- bs_open(con, mode = 'r')

bs_read_bit(bs, 4)
bs_read_uint(bs, nbits = 8, n = 2)
bs_read_bit(bs, 4)

bs_close(bs)
close(con)

## -----------------------------------------------------------------------------
library(bitstreamio)

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Write bits to a raw vector
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
bs <- bs_open(raw(), "w")
bs_write_uint(bs,  0:7 , nbits = 3) # write 8 * 3-bit integers
bs_write_uint(bs, 10:15, nbits = 4) # write 6 * 4-bit integers
raw_vec <- bs_close(bs)
raw_vec


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Read bits back from raw vector
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
bs <- bs_open(raw_vec, mode = 'r')
bs_read_uint(bs, nbits = 3, n = 8)
bs_read_uint(bs, nbits = 4, n = 6)
bs_close(bs)

## -----------------------------------------------------------------------------
# Converstion of unsigned integers to Exponential-Golomb coded bit sequences
uint_to_exp_golomb_bits(0)
uint_to_exp_golomb_bits(1)
uint_to_exp_golomb_bits(2)
uint_to_exp_golomb_bits(3)


# Converstion of signed integers to Exponential-Golomb coded bit sequences
sint_to_exp_golomb_bits(0)
sint_to_exp_golomb_bits(-1)
sint_to_exp_golomb_bits(-2)
sint_to_exp_golomb_bits(3)

## -----------------------------------------------------------------------------
library(bitstreamio)

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Write bits to a raw vector
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
bs <- bs_open(raw(), "w")
bs_write_uint_exp_golomb(bs,  0:9) 
raw_vec <- bs_close(bs)

# 10 integers encoded into 6 bytes
raw_vec


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Read bits back from raw vector
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
bs <- bs_open(raw_vec, mode = 'r')
bs_read_uint_exp_golomb(bs, 10)
bs_close(bs)

