## ----echo=FALSE---------------------------------------------------------------
knitr::opts_chunk$set(
  comment = "#>",
  collapse = TRUE,
  warning = FALSE,
  message = FALSE
)

## ----eval=FALSE---------------------------------------------------------------
# install.packages("hoardr")

## ----eval=FALSE---------------------------------------------------------------
# devtools::install_github(c("ropensci/hoardr"))

## -----------------------------------------------------------------------------
library("hoardr")

## -----------------------------------------------------------------------------
(x <- hoardr::hoard())

## -----------------------------------------------------------------------------
x$cache_path_set("foobar", type = 'tempdir')

## -----------------------------------------------------------------------------
x$mkdir()

## -----------------------------------------------------------------------------
cat("hello world", file = file.path(x$cache_path_get(), "foo.txt"))

## -----------------------------------------------------------------------------
x$list()

## -----------------------------------------------------------------------------
x$details()

## -----------------------------------------------------------------------------
x$delete("foo.txt")
x$list()

