## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(mergedblocks)

## -----------------------------------------------------------------------------
mergedblocks(n = 50)

## -----------------------------------------------------------------------------
mergedblocks(n = 50, labels = c("treatment", "placebo"))

## -----------------------------------------------------------------------------
mergedblocks(n = 50, ratio = c(1, 2), labels = c("A", "B"))

## -----------------------------------------------------------------------------
mergedblocks(n = 50, ratio = c(3, 2), labels = c("A", "B"))

## -----------------------------------------------------------------------------
mergedblocks(n = 50, ratio = c(1, 1, 1))

## -----------------------------------------------------------------------------
mergedblocks(n = 50, ratio = c(1, 1, 1), labels = c("A", "B", "C"))

## -----------------------------------------------------------------------------
mergedblocks(n = 50, ratio = c(1, 1, 1, 1, 1), labels = c("A", "B", "C", "D", "E"))

## -----------------------------------------------------------------------------
mergedblocks(n = 50, ratio = c(1, 1, 2), labels = c("A", "B", "C"))

## -----------------------------------------------------------------------------
mergedblocks(n = 50, ratio = c(2, 1, 1), labels = c("A", "B", "C"))

## -----------------------------------------------------------------------------
four.arms <- mergedblocks(n = 100, ratio = c(2, 2, 3, 3), labels = c("A", "B", "C", "D"))

four.arms

table(four.arms)

## ---- eval = FALSE------------------------------------------------------------
#  example.list <- mergedblocks(n = 50, ratio = c(1, 2), labels = c("A", "B"))
#  
#  write.csv2(example.list, file = "./YourFilePath/ExampleList.csv")

## -----------------------------------------------------------------------------
mergedblocksmulti(K = 3, n = 25)

## -----------------------------------------------------------------------------
mergedblocksmulti(K = 3, n = 25, ratio = c(1, 2), labels = c("treatment", "placebo"))

## -----------------------------------------------------------------------------
mergedblocksmulti(K = 4, n = 30, ratio = c(1, 1, 1), labels = c("A", "B", "C"))

## -----------------------------------------------------------------------------
mergedblocksmulti(K = 3, n = c(20, 30, 25), ratio = c(1, 1), labels = c("A", "B"))

## -----------------------------------------------------------------------------
mergedblocksmulti(K = 5, n = c(35, 30, 40, 20, 15), ratio = c(1, 1, 1), labels = c("A", "B", "C"))

## ---- eval = FALSE------------------------------------------------------------
#  example.list <- mergedblocksmulti(K = 5, n = c(35, 30, 40, 20, 15), ratio = c(1, 1, 1), labels = c("A", "B", "C"))
#  
#  write.csv2(example.list, file = "./YourFilePath/ExampleList.csv")

