api <- hal_query()

hal <- hal_filter(api, "file" %IN% "submitType_s")
expect_identical(hal$fq, "submitType_s:file")

hal <- hal_filter(api, c("THESE", "HDR"), "docType_s")
expect_identical(hal$fq, "docType_s:(THESE OR HDR)")

hal <- hal_filter(api, "[2000 TO 2013]", "submittedDateY_i")
expect_identical(hal$fq, "submittedDateY_i:[2000 TO 2013]")

hal <- hal_filter(api, "[Aa TO Ab]", "city_s")
expect_identical(hal$fq, "city_s:[Aa TO Ab]")

hal <- hal_filter(api, "" %TO% "", "doiId_s")
expect_identical(hal$fq, "doiId_s:[\"\" TO *]")

## Multiple filters
filters <- hal_filter(api, "[NOW-1MONTHS/DAY TO NOW/HOUR]", "submittedDate_tdate")
filters <- hal_filter(filters, "-notice", "submitType_s")
expect_identical(
  filters$fq,
  c("submittedDate_tdate:[NOW-1MONTHS/DAY TO NOW/HOUR]", "submitType_s:-notice")
)
