/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule.parsers;

import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.AttributeValueType;
import eu.kliegr.ac1.rule.Antecedent;
import eu.kliegr.ac1.rule.AttributeNotFoundException;
import eu.kliegr.ac1.rule.Consequent;
import eu.kliegr.ac1.rule.Data;
import eu.kliegr.ac1.rule.Rule;
import eu.kliegr.ac1.rule.RuleInt;
import eu.kliegr.ac1.rule.RuleMultiItem;
import eu.kliegr.ac1.rule.RuleQuality;
import eu.kliegr.ac1.rule.extend.AttributeValueAnnotation;
import eu.kliegr.ac1.rule.extend.ExtendRule;
import eu.kliegr.ac1.rule.extend.RuleMultiItemAnnotation;
import eu.kliegr.ac1.rule.extend.TestRuleAnnotation;
import eu.kliegr.ac1.rule.extend.ValueOrigin;
import eu.kliegr.ac1.rule.parsers.AnnotatedRuleMultiItem;
import eu.kliegr.ac1.rule.parsers.ArulesParser;
import eu.kliegr.ac1.rule.parsers.ConsequentCache;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GUHASimplifiedParser {
    private static final Logger LOGGER = Logger.getLogger(GUHASimplifiedParser.class.getName());
    Data data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeRules(List<ExtendRule> rules, String path) throws ParserConfigurationException, TransformerException {
        File f = new File(path);
        File dir = new File(new File(f.getAbsolutePath()).getParent());
        dir.mkdir();
        FileOutputStream fop = null;
        StringBuilder content = new StringBuilder();
        content.append("\"\",\"rules\",\"support\",\"confidence\"\n");
        rules.stream().forEach(rule -> content.append(rule.getArulesRepresentation()).append("\n"));
        try {
            File file = new File(path);
            fop = new FileOutputStream(file);
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] contentInBytes = content.toString().getBytes();
            fop.write(contentInBytes);
            fop.flush();
            fop.close();
            LOGGER.info("Serialization done");
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveRules(List<? extends RuleInt> rules, String path) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException, FileNotFoundException, IOException {
        File parentF;
        File f = new File(path);
        String parent = f.getParent();
        if (parent != null && !(parentF = new File(parent)).exists()) {
            File dir = new File(parent);
            dir.mkdir();
        }
        BufferedWriter writer = null;
        OutputStream os = path.endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(f)) : new FileOutputStream(f);
        OutputStreamWriter o = new OutputStreamWriter(os, "utf-8");
        writer = new BufferedWriter(o);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        writer.write("<AssociationRules xmlns=\"http://keg.vse.cz/lm/AssociationRules/v1.0\">\n");
        writer.write("<AssociationModel xmlns=\"http://keg.vse.cz/ns/GUHA0.1rev1\">\n");
        ((Writer)writer).flush();
        StreamResult result = new StreamResult(o);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        for (RuleInt ruleInt : rules) {
            Node node = ruleInt.getXMLRepresentation();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
        }
        writer.write("</AssociationModel>");
        writer.write("</AssociationRules>");
        ((Writer)writer).flush();
        ((Writer)writer).close();
        LOGGER.log(Level.INFO, "File saved to {0}", path);
    }

    public static Node string2Node(String xml) throws IOException, SAXException, ParserConfigurationException {
        if (xml == null) {
            return null;
        }
        return GUHASimplifiedParser.inputStream2Document(new ByteArrayInputStream(xml.getBytes())).getChildNodes().item(0);
    }

    public static Document inputStream2Document(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory newInstance = DocumentBuilderFactory.newInstance();
        newInstance.setNamespaceAware(true);
        Document parse = newInstance.newDocumentBuilder().parse(inputStream);
        return parse;
    }

    public GUHASimplifiedParser(Data rmi) throws Exception {
        this.data = rmi;
    }

    public ArrayList<Rule> parseFileForRules(String path) throws FileNotFoundException, XMLStreamException, IOException, SAXException, XPathExpressionException, ParserConfigurationException, Exception {
        BufferedReader reader;
        LOGGER.log(Level.INFO, "Reading rules from {0}\n", path);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        File fXmlFile = new File(path);
        String ls = System.getProperty("line.separator");
        if (path.endsWith(".gz")) {
            FileInputStream fileStream = new FileInputStream(fXmlFile);
            GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
            InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, "utf-8");
            reader = new BufferedReader(decoder);
        } else {
            reader = new BufferedReader(new FileReader(fXmlFile));
        }
        String line = null;
        StringBuilder currentRuleTextSB = new StringBuilder();
        int lineCounter = 0;
        long start2 = 0L;
        while ((line = reader.readLine()) != null) {
            ++lineCounter;
            if (line.trim().startsWith("<AssociationRule")) {
                currentRuleTextSB.delete(0, currentRuleTextSB.length());
                LOGGER.log(Level.FINEST, "Starting to read next rule from input line:{0}", lineCounter);
                currentRuleTextSB.append(line);
                start2 = System.nanoTime();
                continue;
            }
            if (line.trim().startsWith("</AssociationRule>")) {
                currentRuleTextSB.append("\n");
                currentRuleTextSB.append(line);
                Node ruleNode = GUHASimplifiedParser.string2Node(currentRuleTextSB.toString());
                long time2 = System.nanoTime() - start2;
                LOGGER.finest(String.format("Took %.3f seconds to read and parse ending on line:" + lineCounter, (double)time2 / 1.0E9));
                Rule rule = this.parseAssociationRule(ruleNode);
                rules.add(rule);
                continue;
            }
            currentRuleTextSB.append("\n");
            currentRuleTextSB.append(line);
        }
        reader.close();
        return rules;
    }

    private Rule parseAssociationRule(Node rule) throws Exception {
        int ruleid = Integer.parseInt(rule.getAttributes().getNamedItem("id").getNodeValue());
        TestRuleAnnotation ruleAnnot = new TestRuleAnnotation();
        Antecedent ant = null;
        Consequent con = null;
        RuleQuality qm = null;
        NodeList ruleParts = rule.getChildNodes();
        for (int i = 0; i < ruleParts.getLength(); ++i) {
            Node ruleNode = ruleParts.item(i);
            String nodeName = ruleNode.getNodeName();
            if (nodeName.equals("Antecedent")) {
                ArrayList<AnnotatedRuleMultiItem> antItems = this.parseAntecedent(ruleNode);
                ant = new Antecedent(antItems.stream().map(annRMI -> annRMI.rmi).collect(Collectors.toCollection(ArrayList::new)));
                antItems.stream().forEach(annRMI -> ruleAnnot.addAnnotation(annRMI.rmi, annRMI.annotation));
                continue;
            }
            if (nodeName.equals("Consequent")) {
                AnnotatedRuleMultiItem conItem = this.parseConsequent(ruleNode);
                con = ConsequentCache.getConsequent(conItem.rmi);
                continue;
            }
            if (!nodeName.equals("FourFtTable")) continue;
            qm = this.parseFourFtTable(ruleNode);
        }
        if (ant == null) {
            throw new Exception("Antecedent parsing failed");
        }
        if (con == null) {
            throw new Exception("Antecedent parsing failed");
        }
        if (qm == null) {
            throw new Exception("Rule quality parsing failed");
        }
        return new Rule(ant, con, qm, ruleAnnot, ruleid, null, this.data);
    }

    private ArrayList<AnnotatedRuleMultiItem> parseAntecedent(Node node) throws Exception {
        ArrayList<AnnotatedRuleMultiItem> items = new ArrayList<AnnotatedRuleMultiItem>();
        NodeList ant = node.getChildNodes();
        int cedentCounter = 0;
        for (int i = 0; i < ant.getLength(); ++i) {
            Node antNode = ant.item(i);
            String nodeName = antNode.getNodeName();
            if (!nodeName.equals("Cedent")) continue;
            ++cedentCounter;
            if (!antNode.getAttributes().getNamedItem("connective").getTextContent().equals("Conjunction")) {
                throw new UnsupportedOperationException("Disjunctions not supported.");
            }
            NodeList attributeNodes = antNode.getChildNodes();
            for (int j = 0; j < attributeNodes.getLength(); ++j) {
                AnnotatedRuleMultiItem at;
                if (attributeNodes.item(j).getNodeName().equals("Attribute")) {
                    at = this.parseAttribute(attributeNodes.item(j), false);
                    items.add(at);
                    continue;
                }
                if (!attributeNodes.item(j).getNodeName().equals("Cedent")) continue;
                if (attributeNodes.item(j).getAttributes().getNamedItem("connective").getTextContent().equals("Negation")) {
                    at = this.parseNegatedAttribute(attributeNodes.item(j));
                    items.add(at);
                    continue;
                }
                throw new UnsupportedOperationException("Unexpected or unsupported Cedent.");
            }
        }
        if (cedentCounter == 0) {
            throw new UnsupportedOperationException("No cedents not supported.");
        }
        if (cedentCounter > 1) {
            throw new UnsupportedOperationException("Multiple cedents not supported.");
        }
        return items;
    }

    private AnnotatedRuleMultiItem parseConsequent(Node node) throws Exception {
        ArrayList<AnnotatedRuleMultiItem> items = new ArrayList<AnnotatedRuleMultiItem>();
        NodeList ant = node.getChildNodes();
        int cedentCounter = 0;
        for (int i = 0; i < ant.getLength(); ++i) {
            Node conNode = ant.item(i);
            String nodeName = conNode.getNodeName();
            if (!nodeName.equals("Cedent")) continue;
            ++cedentCounter;
            if (!conNode.getAttributes().getNamedItem("connective").getTextContent().equals("Conjunction")) {
                throw new UnsupportedOperationException("Disjunctions not supported.");
            }
            NodeList attributeNodes = conNode.getChildNodes();
            for (int j = 0; j < attributeNodes.getLength(); ++j) {
                AnnotatedRuleMultiItem at;
                if (attributeNodes.item(j).getNodeName().equals("Attribute")) {
                    at = this.parseAttribute(attributeNodes.item(j), false);
                    items.add(at);
                    continue;
                }
                if (!attributeNodes.item(j).getNodeName().equals("Cedent")) continue;
                if (attributeNodes.item(j).getAttributes().getNamedItem("connective").getTextContent().equals("Negation")) {
                    at = this.parseNegatedAttribute(attributeNodes.item(j));
                    items.add(at);
                    continue;
                }
                throw new UnsupportedOperationException("Unexpected or unsupported Cedent.");
            }
        }
        if (cedentCounter == 0) {
            throw new UnsupportedOperationException("No cedents not supported.");
        }
        if (cedentCounter > 1) {
            throw new UnsupportedOperationException("Multiple cedents not supported.");
        }
        if (items.size() != 1) {
            throw new UnsupportedOperationException("Consequent must have exactly one attribute and has " + items.size());
        }
        return (AnnotatedRuleMultiItem)items.get(0);
    }

    private AnnotatedRuleMultiItem parseAttribute(Node attribute, boolean negation) throws Exception {
        String nodeName;
        Node node;
        int i;
        NodeList attributeNodes = attribute.getChildNodes();
        String attributeName = null;
        ArrayList<AttributeValue> allValues = new ArrayList<AttributeValue>();
        for (i = 0; i < attributeNodes.getLength(); ++i) {
            node = attributeNodes.item(i);
            nodeName = node.getNodeName();
            if (!nodeName.equals("Column")) continue;
            attributeName = node.getTextContent();
            break;
        }
        if (attributeName == null) {
            throw new UnsupportedOperationException("Name for attribute not found");
        }
        for (i = 0; i < attributeNodes.getLength(); ++i) {
            node = attributeNodes.item(i);
            nodeName = node.getNodeName();
            if (!nodeName.equals("Category")) continue;
            ArrayList<AttributeValue> values = this.parseCategory(node, attributeName, negation);
            allValues.addAll(values);
        }
        RuleMultiItem rmi = this.data.makeRuleItem(allValues, attributeName);
        RuleMultiItemAnnotation annotation = null;
        for (int i2 = 0; i2 < attributeNodes.getLength(); ++i2) {
            Node node2 = attributeNodes.item(i2);
            String nodeName2 = node2.getNodeName();
            if (!nodeName2.equals("Annotations")) continue;
            annotation = this.parseAnnotations(node2, attributeName);
            break;
        }
        AnnotatedRuleMultiItem rmiannot = new AnnotatedRuleMultiItem(rmi, annotation);
        return rmiannot;
    }

    private ArrayList<AttributeValue> parseCategory(Node category, String attributeName, boolean negated) throws AttributeNotFoundException {
        NodeList categoryNodes = category.getChildNodes();
        ArrayList<AttributeValue> allValues = new ArrayList<AttributeValue>();
        for (int i = 0; i < categoryNodes.getLength(); ++i) {
            Node node = categoryNodes.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.equals("Data")) continue;
            allValues.addAll(this.parseData(node, attributeName, negated));
        }
        return allValues;
    }

    private ArrayList<AttributeValue> parseDataOfNegatedAttribute(Node data, String attributeName) throws AttributeNotFoundException {
        NodeList dataNodes = data.getChildNodes();
        ArrayList<AttributeValue> allValues = null;
        for (int i = 0; i < dataNodes.getLength(); ++i) {
            Collection<AttributeValue> valuesMatchingCategory;
            Node node = dataNodes.item(i);
            if (node.getNodeName().equals("Interval")) {
                valuesMatchingCategory = this.parseInterval(node, attributeName, true);
                if (allValues == null) {
                    allValues = new ArrayList<AttributeValue>(valuesMatchingCategory);
                    continue;
                }
                allValues.retainAll(valuesMatchingCategory);
                continue;
            }
            if (!node.getNodeName().equals("Value")) continue;
            valuesMatchingCategory = this.parseValue(node, attributeName, true);
            if (allValues == null) {
                allValues = new ArrayList<AttributeValue>(valuesMatchingCategory);
                continue;
            }
            allValues.retainAll(valuesMatchingCategory);
        }
        return allValues;
    }

    private ArrayList<AttributeValue> parseData(Node data, String attributeName, boolean negated) throws AttributeNotFoundException {
        if (negated) {
            return this.parseDataOfNegatedAttribute(data, attributeName);
        }
        NodeList dataNodes = data.getChildNodes();
        ArrayList<AttributeValue> allValues = new ArrayList<AttributeValue>();
        for (int i = 0; i < dataNodes.getLength(); ++i) {
            Node node = dataNodes.item(i);
            if (node.getNodeName().equals("Interval")) {
                allValues.addAll(this.parseInterval(node, attributeName, negated));
                continue;
            }
            if (!node.getNodeName().equals("Value")) continue;
            allValues.addAll(this.parseValue(node, attributeName, negated));
        }
        return allValues;
    }

    private String[] concat(String[] A, String[] B) {
        int aLen = A.length;
        int bLen = B.length;
        String[] C = new String[aLen + bLen];
        System.arraycopy(A, 0, C, 0, aLen);
        System.arraycopy(B, 0, C, aLen, bLen);
        return C;
    }

    private Collection<AttributeValue> parseInterval(Node node, String attributeName, boolean negated) {
        boolean toInclusive;
        boolean fromInclusive;
        String leftMargingStr = ArulesParser.normInfinity(node.getAttributes().getNamedItem("leftMargin").getTextContent());
        String rightMarginStr = ArulesParser.normInfinity(node.getAttributes().getNamedItem("rightMargin").getTextContent());
        float leftMargin = Float.parseFloat(leftMargingStr);
        float rightMargin = Float.parseFloat(rightMarginStr);
        String closure = node.getAttributes().getNamedItem("closure").getTextContent();
        if (closure.equals("closedOpen")) {
            fromInclusive = true;
            toInclusive = false;
        } else if (closure.equals("closedClosed")) {
            fromInclusive = true;
            toInclusive = true;
        } else if (closure.equals("openOpen")) {
            fromInclusive = false;
            toInclusive = false;
        } else {
            fromInclusive = false;
            toInclusive = true;
        }
        Collection<AttributeValue> values = this.data.getValuesInRange(attributeName, leftMargin, fromInclusive, rightMargin, toInclusive, negated);
        return values;
    }

    private RuleQuality parseFourFtTable(Node tableNode) {
        RuleQuality rq;
        Integer a = Integer.parseInt(tableNode.getAttributes().getNamedItem("a").getTextContent());
        Integer b = Integer.parseInt(tableNode.getAttributes().getNamedItem("b").getTextContent());
        try {
            Integer c = Integer.parseInt(tableNode.getAttributes().getNamedItem("c").getTextContent());
            Integer d = Integer.parseInt(tableNode.getAttributes().getNamedItem("d").getTextContent());
            rq = new RuleQuality(a, b, c, d);
        }
        catch (NumberFormatException e) {
            rq = new RuleQuality(a, b);
        }
        return rq;
    }

    private Collection<AttributeValue> parseValue(Node node, String attributeName, boolean negated) throws AttributeNotFoundException {
        return this.data.getValuesByEnumeration(attributeName, new String[]{node.getTextContent()}, negated, AttributeValueType.breakpoint);
    }

    private AnnotatedRuleMultiItem parseNegatedAttribute(Node cedent) throws Exception {
        NodeList cedentNodes = cedent.getChildNodes();
        AnnotatedRuleMultiItem multiItem = null;
        for (int i = 0; i < cedentNodes.getLength(); ++i) {
            if (!cedentNodes.item(i).getNodeName().equals("Attribute")) continue;
            if (multiItem != null) {
                throw new UnsupportedOperationException("Too many cedents");
            }
            multiItem = this.parseAttribute(cedentNodes.item(i), true);
        }
        return multiItem;
    }

    private RuleMultiItemAnnotation parseAnnotations(Node annotations, String attributeName) throws AttributeNotFoundException {
        RuleMultiItemAnnotation annotationList = new RuleMultiItemAnnotation();
        NodeList annotationsNodes = annotations.getChildNodes();
        for (int i = 0; i < annotationsNodes.getLength(); ++i) {
            Node node = annotationsNodes.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.equals("Annotation")) continue;
            AttributeValueAnnotation annot = this.parseAnnotation(node, attributeName);
            annotationList.add(annot);
        }
        return annotationList;
    }

    private AttributeValueAnnotation parseAnnotation(Node annotation, String attributeName) throws AttributeNotFoundException {
        NodeList annotationNodes = annotation.getChildNodes();
        AttributeValueAnnotation annot = null;
        String value = null;
        ValueOrigin origin = null;
        for (int i = 0; i < annotationNodes.getLength(); ++i) {
            Node node = annotationNodes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("Value")) {
                value = node.getTextContent();
                continue;
            }
            if (nodeName.equals("Origin")) {
                origin = ValueOrigin.valueOf(node.getTextContent());
                continue;
            }
            if (!nodeName.equals("Distribution")) continue;
            AttributeValue atVal = this.data.getValue(attributeName, value, AttributeValueType.breakpoint);
            annot = new AttributeValueAnnotation(atVal, origin);
            annot = this.parseDistribution(node, annot);
        }
        return annot;
    }

    private AttributeValueAnnotation parseDistribution(Node distribution, AttributeValueAnnotation annot) throws AttributeNotFoundException {
        NodeList distributionNodes = distribution.getChildNodes();
        for (int i = 0; i < distributionNodes.getLength(); ++i) {
            Node node = distributionNodes.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.equals("Consequent")) continue;
            annot = this.parseDistributionConsequent(node, annot);
        }
        return annot;
    }

    private AttributeValueAnnotation parseDistributionConsequent(Node distrCons, AttributeValueAnnotation annot) throws AttributeNotFoundException {
        NodeList distrConsNodes = distrCons.getChildNodes();
        ArrayList<AttributeValue> values = new ArrayList<AttributeValue>();
        RuleQuality quality = null;
        for (int i = 0; i < distrConsNodes.getLength(); ++i) {
            Node node = distrConsNodes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("Value")) {
                String value = node.getTextContent();
                values.add(this.data.getValue(this.data.getTargetAttribute().getName(), value, AttributeValueType.breakpoint));
            }
            if (!nodeName.equals("FourFtTable")) continue;
            quality = this.parseFourFtTable(node);
        }
        RuleMultiItem rmi = null;
        try {
            rmi = this.data.makeRuleItem(values, this.data.getTargetAttribute().getName());
        }
        catch (Exception node) {
            // empty catch block
        }
        Consequent cons = ConsequentCache.getConsequent(rmi);
        annot.add(cons, quality);
        return annot;
    }
}

