## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include = FALSE---------------------------------------------------
library(re2)

## -----------------------------------------------------------------------------
re2_detect(c("barbazbla", "foobar", "foxy brown"), "(foo)|(bar)baz")

## -----------------------------------------------------------------------------
re2_count(c("yellowgreen", "steelblue", "maroon"), "e")

## -----------------------------------------------------------------------------
re2_subset(c("yellowgreen", "steelblue", "goldenrod"), "ee")

## -----------------------------------------------------------------------------
re2_match("ruby:1234 68 red:92 blue:", "(\\w+):(\\d+)")

## -----------------------------------------------------------------------------
# Groups can be named:

re2_match(c("barbazbla", "foobar"), "(foo)|(?P<TestGroup>bar)baz")

## -----------------------------------------------------------------------------
# Use pre-compiled regular expression:

re <- re2_regexp("(foo)|(bar)baz", case_sensitive = FALSE)
re2_match(c("BaRbazbla", "Foobar"), re)

## -----------------------------------------------------------------------------
re2_match_all("ruby:1234 68 red:92 blue:", "(\\w+):(\\d+)")

## -----------------------------------------------------------------------------
re2_replace("yabba dabba doo", "b+", "d")

## -----------------------------------------------------------------------------
# Use groups in rewrite:

re2_replace("bunny@wunnies.pl", "(.*)@([^.]*)", "\\2!\\1")

## -----------------------------------------------------------------------------
re2_replace_all("yabba dabba doo", "b+", "d")
# Multiple replacements
re2_replace_all(c("one", "two"), c("one" = "1", "1" = "2", "two" = "2"))

## -----------------------------------------------------------------------------
re2_extract_replace("bunny@wunnies.pl", "(.*)@([^.]*)", "\\2!\\1")

## -----------------------------------------------------------------------------
re2_split("How vexingly quick daft zebras jump!", " quick | zebras")

## -----------------------------------------------------------------------------
re2_locate(c("yellowgreen", "steelblue"), "l(b)?l")

## -----------------------------------------------------------------------------
re2_locate_all(c("yellowgreen", "steelblue"), "l")

