## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(devtools)

## ----toload-------------------------------------------------------------------
lbs <- c("janitor", "gmodels", "epiR", "DescTools", "coin", "irr", "Exact", "stats")
lbs <- c('stats','devtools')

## ----unload-------------------------------------------------------------------
trashbin <- lapply(lbs, 
                   function(x) if (x %in% .packages()) {detach(paste0('package:',x), character.only=TRUE)})

## ----reload-------------------------------------------------------------------
suppressMessages(repfun::ru_load_library(lbs))

## ----confirm------------------------------------------------------------------
loaded <- lapply(lbs,function(x) x %in% loadedNamespaces())
names(loaded) <- lbs
knitr::kable(stack(loaded)[,c(2,1)], caption = "Is Package Loaded (T/F)?")

